/* src/bazaar.p/bz-bulk-install-dialog-result.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-bulk-install-dialog-result.h"



struct _BzBulkInstallDialogResult
{
  GObject parent_instance;

  GListModel *entries;
  gboolean confirmed;
};

G_DEFINE_FINAL_TYPE (BzBulkInstallDialogResult, bz_bulk_install_dialog_result, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_ENTRIES,
  PROP_CONFIRMED,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_bulk_install_dialog_result_dispose (GObject *object)
{
  BzBulkInstallDialogResult *self = BZ_BULK_INSTALL_DIALOG_RESULT (object);

  g_clear_pointer (&self->entries, g_object_unref);

  G_OBJECT_CLASS (bz_bulk_install_dialog_result_parent_class)->dispose (object);
}

static void
bz_bulk_install_dialog_result_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzBulkInstallDialogResult *self = BZ_BULK_INSTALL_DIALOG_RESULT (object);

  switch (prop_id)
    {
    case PROP_ENTRIES:
      g_value_set_object (value, bz_bulk_install_dialog_result_get_entries (self));
      break;
    case PROP_CONFIRMED:
      g_value_set_boolean (value, bz_bulk_install_dialog_result_get_confirmed (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_bulk_install_dialog_result_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzBulkInstallDialogResult *self = BZ_BULK_INSTALL_DIALOG_RESULT (object);

  switch (prop_id)
    {
    case PROP_ENTRIES:
      bz_bulk_install_dialog_result_set_entries (self, g_value_get_object (value));
      break;
    case PROP_CONFIRMED:
      bz_bulk_install_dialog_result_set_confirmed (self, g_value_get_boolean (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_bulk_install_dialog_result_class_init (BzBulkInstallDialogResultClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_bulk_install_dialog_result_set_property;
  object_class->get_property = bz_bulk_install_dialog_result_get_property;
  object_class->dispose      = bz_bulk_install_dialog_result_dispose;

  props[PROP_ENTRIES] =
      g_param_spec_object (
          "entries",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CONFIRMED] =
      g_param_spec_boolean (
          "confirmed",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_bulk_install_dialog_result_init (BzBulkInstallDialogResult *self)
{
}

BzBulkInstallDialogResult *
bz_bulk_install_dialog_result_new (void){
  return g_object_new (BZ_TYPE_BULK_INSTALL_DIALOG_RESULT, NULL);
}

GListModel *
bz_bulk_install_dialog_result_get_entries (BzBulkInstallDialogResult *self){
  g_return_val_if_fail (BZ_IS_BULK_INSTALL_DIALOG_RESULT (self), NULL);
  return self->entries;
}

gboolean
bz_bulk_install_dialog_result_get_confirmed (BzBulkInstallDialogResult *self){
  g_return_val_if_fail (BZ_IS_BULK_INSTALL_DIALOG_RESULT (self), FALSE);
  return self->confirmed;
}

void
bz_bulk_install_dialog_result_set_entries (BzBulkInstallDialogResult *self,
    GListModel *entries){
  g_return_if_fail (BZ_IS_BULK_INSTALL_DIALOG_RESULT (self));

  if (entries == self->entries)
    return;

  g_clear_pointer (&self->entries, g_object_unref);
  if (entries != NULL)
    self->entries = g_object_ref (entries);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ENTRIES]);
}

void
bz_bulk_install_dialog_result_set_confirmed (BzBulkInstallDialogResult *self,
    gboolean confirmed){
  g_return_if_fail (BZ_IS_BULK_INSTALL_DIALOG_RESULT (self));

  if (!!confirmed == !!self->confirmed)
    return;

  self->confirmed = confirmed;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CONFIRMED]);
}

/* End of src/bazaar.p/bz-bulk-install-dialog-result.c */
