package zerogod

// generated from https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml
var KNOWN_SERVICES = map[string]string{
	"_tcpmux":                               "TCP Port Service Multiplexer",
	"_compressnet":                          "Management Utility",
	"_rje":                                  "Remote Job Entry",
	"_echo":                                 "Echo",
	"_discard":                              "Discard",
	"_systat":                               "Active Users",
	"_daytime":                              "Daytime",
	"_qotd":                                 "Quote of the Day",
	"_msp":                                  "Message Send Protocol (historic)",
	"_chargen":                              "Character Generator",
	"_ftp-data":                             "File Transfer [Default Data]",
	"_ftp":                                  "File Transfer Protocol [Control]",
	"_ssh":                                  "The Secure Shell (SSH) Protocol",
	"_telnet":                               "Telnet",
	"_smtp":                                 "Simple Mail Transfer",
	"_nsw-fe":                               "NSW User System FE",
	"_msg-icp":                              "MSG ICP",
	"_msg-auth":                             "MSG Authentication",
	"_dsp":                                  "Display Support Protocol",
	"_time":                                 "Time",
	"_rap":                                  "Route Access Protocol",
	"_rlp":                                  "Resource Location Protocol",
	"_graphics":                             "Graphics",
	"_name":                                 "Host Name Server",
	"_nameserver":                           "Host Name Server",
	"_nicname":                              "Who Is",
	"_mpm-flags":                            "MPM FLAGS Protocol",
	"_mpm":                                  "Message Processing Module [recv]",
	"_mpm-snd":                              "MPM [default send]",
	"_auditd":                               "Digital Audit Daemon",
	"_tacacs":                               "Login Host Protocol (TACACS)",
	"_re-mail-ck":                           "Remote Mail Checking Protocol",
	"_xns-time":                             "XNS Time Protocol",
	"_domain":                               "Domain Name Server",
	"_xns-ch":                               "XNS Clearinghouse",
	"_isi-gl":                               "ISI Graphics Language",
	"_xns-auth":                             "XNS Authentication",
	"_xns-mail":                             "XNS Mail",
	"_acas":                                 "ACA Services",
	"_whoispp":                              "whois++ IANA assigned this well-formed service name as a replacement for 'whois++'.",
	"_whois++":                              "whois++",
	"_covia":                                "Communications Integrator (CI)",
	"_tacacs-ds":                            "TACACS-Database Service",
	"_sql-net":                              "Oracle SQL*NET IANA assigned this well-formed service name as a replacement for 'sql*net'.",
	"_sql*net":                              "Oracle SQL*NET",
	"_bootps":                               "Bootstrap Protocol Server",
	"_bootpc":                               "Bootstrap Protocol Client",
	"_tftp":                                 "Trivial File Transfer",
	"_gopher":                               "Gopher",
	"_netrjs-1":                             "Remote Job Service",
	"_netrjs-2":                             "Remote Job Service",
	"_netrjs-3":                             "Remote Job Service",
	"_netrjs-4":                             "Remote Job Service",
	"_deos":                                 "Distributed External Object Store",
	"_vettcp":                               "vettcp",
	"_finger":                               "Finger",
	"_http":                                 "World Wide Web HTTP",
	"_www":                                  "World Wide Web HTTP",
	"_www-http":                             "World Wide Web HTTP",
	"_xfer":                                 "XFER Utility",
	"_mit-ml-dev":                           "MIT ML Device",
	"_ctf":                                  "Common Trace Facility",
	"_mfcobol":                              "Micro Focus Cobol",
	"_kerberos":                             "Kerberos",
	"_su-mit-tg":                            "SU/MIT Telnet Gateway",
	"_dnsix":                                "DNSIX Securit Attribute Token Map",
	"_mit-dov":                              "MIT Dover Spooler",
	"_npp":                                  "Network Printing Protocol",
	"_dcp":                                  "Device Control Protocol",
	"_objcall":                              "Tivoli Object Dispatcher",
	"_supdup":                               "SUPDUP",
	"_dixie":                                "DIXIE Protocol Specification",
	"_swift-rvf":                            "Swift Remote Virtural File Protocol",
	"_tacnews":                              "TAC News",
	"_metagram":                             "Metagram Relay",
	"_hostname":                             "NIC Host Name Server",
	"_iso-tsap":                             "ISO-TSAP Class 0",
	"_gppitnp":                              "Genesis Point-to-Point Trans Net",
	"_acr-nema":                             "ACR-NEMA Digital Imag. & Comm. 300",
	"_cso":                                  "CCSO name server protocol",
	"_csnet-ns":                             "Mailbox Name Nameserver",
	"_3com-tsmux":                           "3COM-TSMUX",
	"_rtelnet":                              "Remote Telnet Service",
	"_snagas":                               "SNA Gateway Access Server",
	"_pop2":                                 "Post Office Protocol - Version 2",
	"_pop3":                                 "Post Office Protocol - Version 3",
	"_sunrpc":                               "SUN Remote Procedure Call",
	"_mcidas":                               "McIDAS Data Transmission Protocol",
	"_ident":                                "",
	"_auth":                                 "Authentication Service",
	"_sftp":                                 "Simple File Transfer Protocol",
	"_ansanotify":                           "ANSA REX Notify",
	"_uucp-path":                            "UUCP Path Service",
	"_sqlserv":                              "SQL Services",
	"_nntp":                                 "Network News Transfer Protocol",
	"_cfdptkt":                              "CFDPTKT",
	"_erpc":                                 "Encore Expedited Remote Pro.Call",
	"_smakynet":                             "SMAKYNET",
	"_ntp":                                  "Network Time Protocol",
	"_ansatrader":                           "ANSA REX Trader",
	"_locus-map":                            "Locus PC-Interface Net Map Ser",
	"_nxedit":                               "NXEdit",
	"_locus-con":                            "Locus PC-Interface Conn Server",
	"_gss-xlicen":                           "GSS X License Verification",
	"_pwdgen":                               "Password Generator Protocol",
	"_cisco-fna":                            "cisco FNATIVE",
	"_cisco-tna":                            "cisco TNATIVE",
	"_cisco-sys":                            "cisco SYSMAINT",
	"_statsrv":                              "Statistics Service",
	"_ingres-net":                           "INGRES-NET Service",
	"_epmap":                                "DCE endpoint resolution",
	"_profile":                              "PROFILE Naming System",
	"_netbios-ns":                           "NETBIOS Name Service",
	"_netbios-dgm":                          "NETBIOS Datagram Service",
	"_netbios-ssn":                          "NETBIOS Session Service",
	"_emfis-data":                           "EMFIS Data Service",
	"_emfis-cntl":                           "EMFIS Control Service",
	"_bl-idm":                               "Britton-Lee IDM",
	"_imap":                                 "Internet Message Access Protocol",
	"_uma":                                  "Universal Management Architecture",
	"_uaac":                                 "UAAC Protocol",
	"_iso-tp0":                              "ISO-IP0",
	"_iso-ip":                               "ISO-IP",
	"_jargon":                               "Jargon",
	"_aed-512":                              "AED 512 Emulation Service",
	"_hems":                                 "HEMS",
	"_bftp":                                 "Background File Transfer Program",
	"_sgmp":                                 "SGMP",
	"_netsc-prod":                           "NETSC",
	"_netsc-dev":                            "NETSC",
	"_sqlsrv":                               "SQL Service",
	"_knet-cmp":                             "KNET/VM Command/Message Protocol",
	"_pcmail-srv":                           "PCMail Server",
	"_nss-routing":                          "NSS-Routing",
	"_sgmp-traps":                           "SGMP-TRAPS",
	"_snmp":                                 "SNMP",
	"_snmptrap":                             "SNMPTRAP",
	"_cmip-man":                             "CMIP/TCP Manager",
	"_cmip-agent":                           "CMIP/TCP Agent",
	"_xns-courier":                          "Xerox",
	"_s-net":                                "Sirius Systems",
	"_namp":                                 "NAMP",
	"_rsvd":                                 "RSVD",
	"_send":                                 "SEND",
	"_print-srv":                            "Network PostScript",
	"_multiplex":                            "Network Innovations Multiplex",
	"_cl-1":                                 "Network Innovations CL/1 IANA assigned this well-formed service name as a replacement for 'cl/1'.",
	"_cl/1":                                 "Network Innovations CL/1",
	"_xyplex-mux":                           "Xyplex",
	"_mailq":                                "MAILQ",
	"_vmnet":                                "VMNET",
	"_genrad-mux":                           "GENRAD-MUX",
	"_xdmcp":                                "X Display Manager Control Protocol",
	"_nextstep":                             "NextStep Window Server",
	"_bgp":                                  "Border Gateway Protocol",
	"_ris":                                  "Intergraph",
	"_unify":                                "Unify",
	"_audit":                                "Unisys Audit SITP",
	"_ocbinder":                             "OCBinder",
	"_ocserver":                             "OCServer",
	"_remote-kis":                           "Remote-KIS",
	"_kis":                                  "KIS Protocol",
	"_aci":                                  "Application Communication Interface",
	"_mumps":                                "Plus Five's MUMPS",
	"_qft":                                  "Queued File Transport",
	"_gacp":                                 "Gateway Access Control Protocol",
	"_prospero":                             "Prospero Directory Service",
	"_osu-nms":                              "OSU Network Monitoring System",
	"_srmp":                                 "Spider Remote Monitoring Protocol",
	"_irc":                                  "Internet Relay Chat Protocol",
	"_dn6-nlm-aud":                          "DNSIX Network Level Module Audit",
	"_dn6-smm-red":                          "DNSIX Session Mgt Module Audit Redir",
	"_dls":                                  "Directory Location Service",
	"_dls-mon":                              "Directory Location Service Monitor",
	"_smux":                                 "SMUX",
	"_src":                                  "IBM System Resource Controller",
	"_at-rtmp":                              "AppleTalk Routing Maintenance",
	"_at-nbp":                               "AppleTalk Name Binding",
	"_at-3":                                 "AppleTalk Unused",
	"_at-echo":                              "AppleTalk Echo",
	"_at-5":                                 "AppleTalk Unused",
	"_at-zis":                               "AppleTalk Zone Information",
	"_at-7":                                 "AppleTalk Unused",
	"_at-8":                                 "AppleTalk Unused",
	"_qmtp":                                 "The Quick Mail Transfer Protocol",
	"_z39-50":                               "ANSI Z39.50 IANA assigned this well-formed service name as a replacement for 'z39.50'.",
	"_z39.50":                               "ANSI Z39.50",
	"_914c-g":                               "Texas Instruments 914C/G Terminal IANA assigned this well-formed service name as a replacement for '914c/g'.",
	"_914c/g":                               "Texas Instruments 914C/G Terminal",
	"_anet":                                 "ATEXSSTR",
	"_ipx":                                  "IPX",
	"_vmpwscs":                              "VM PWSCS",
	"_softpc":                               "Insignia Solutions",
	"_cailic":                               "Computer Associates Int'l License Server",
	"_dbase":                                "dBASE Unix",
	"_mpp":                                  "Netix Message Posting Protocol",
	"_uarps":                                "Unisys ARPs",
	"_imap3":                                "Interactive Mail Access Protocol v3",
	"_fln-spx":                              "Berkeley rlogind with SPX auth",
	"_rsh-spx":                              "Berkeley rshd with SPX auth",
	"_cdc":                                  "Certificate Distribution Center",
	"_masqdialer":                           "masqdialer",
	"_direct":                               "Direct",
	"_sur-meas":                             "Survey Measurement",
	"_inbusiness":                           "inbusiness",
	"_link":                                 "LINK",
	"_dsp3270":                              "Display Systems Protocol",
	"_subntbcst-tftp":                       "SUBNTBCST_TFTP IANA assigned this well-formed service name as a replacement for 'subntbcst_tftp'.",
	"_subntbcst_tftp":                       "SUBNTBCST_TFTP",
	"_bhfhs":                                "bhfhs",
	"_set":                                  "Secure Electronic Transaction",
	"_esro-gen":                             "Efficient Short Remote Operations",
	"_openport":                             "Openport",
	"_nsiiops":                              "IIOP Name Service over TLS/SSL",
	"_arcisdms":                             "Arcisdms",
	"_hdap":                                 "HDAP",
	"_bgmp":                                 "BGMP",
	"_x-bone-ctl":                           "X-Bone CTL",
	"_sst":                                  "SCSI on ST",
	"_td-service":                           "Tobit David Service Layer",
	"_td-replica":                           "Tobit David Replica",
	"_manet":                                "MANET Protocols",
	"_gist":                                 "Q-mode encapsulation for GIST messages",
	"_pt-tls":                               "IETF Network Endpoint Assessment (NEA) Posture Transport Protocol over TLS (PT-TLS)",
	"_http-mgmt":                            "http-mgmt",
	"_personal-link":                        "Personal Link",
	"_cableport-ax":                         "Cable Port A/X",
	"_rescap":                               "rescap",
	"_corerjd":                              "corerjd",
	"_fxp":                                  "FXP Communication",
	"_k-block":                              "K-BLOCK",
	"_novastorbakcup":                       "Novastor Backup",
	"_entrusttime":                          "EntrustTime",
	"_bhmds":                                "bhmds",
	"_asip-webadmin":                        "AppleShare IP WebAdmin",
	"_vslmp":                                "VSLMP",
	"_magenta-logic":                        "Magenta Logic",
	"_opalis-robot":                         "Opalis Robot",
	"_dpsi":                                 "DPSI",
	"_decauth":                              "decAuth",
	"_zannet":                               "Zannet",
	"_pkix-timestamp":                       "PKIX TimeStamp",
	"_ptp-event":                            "PTP Event",
	"_ptp-general":                          "PTP General",
	"_pip":                                  "PIP",
	"_rtsps":                                "RTSPS",
	"_rpki-rtr":                             "Resource PKI to Router Protocol",
	"_rpki-rtr-tls":                         "Resource PKI to Router Protocol over TLS",
	"_texar":                                "Texar Security Port",
	"_pdap":                                 "Prospero Data Access Protocol",
	"_pawserv":                              "Perf Analysis Workbench",
	"_zserv":                                "Zebra server",
	"_fatserv":                              "Fatmen Server",
	"_csi-sgwp":                             "Cabletron Management Protocol",
	"_mftp":                                 "mftp",
	"_matip-type-a":                         "MATIP Type A",
	"_matip-type-b":                         "MATIP Type B",
	"_bhoetty":                              "bhoetty",
	"_dtag-ste-sb":                          "DTAG",
	"_bhoedap4":                             "bhoedap4",
	"_ndsauth":                              "NDSAUTH",
	"_bh611":                                "bh611",
	"_datex-asn":                            "DATEX-ASN",
	"_cloanto-net-1":                        "Cloanto Net 1",
	"_bhevent":                              "bhevent",
	"_shrinkwrap":                           "Shrinkwrap",
	"_scoi2odialog":                         "scoi2odialog",
	"_semantix":                             "Semantix",
	"_srssend":                              "SRS Send",
	"_rsvp-tunnel":                          "RSVP Tunnel IANA assigned this well-formed service name as a replacement for 'rsvp_tunnel'.",
	"_rsvp_tunnel":                          "RSVP Tunnel",
	"_aurora-cmgr":                          "Aurora CMGR",
	"_dtk":                                  "DTK",
	"_odmr":                                 "ODMR",
	"_mortgageware":                         "MortgageWare",
	"_qbikgdp":                              "QbikGDP",
	"_rpc2portmap":                          "rpc2portmap",
	"_codaauth2":                            "codaauth2",
	"_clearcase":                            "Clearcase",
	"_ulistproc":                            "ListProcessor",
	"_legent-1":                             "Legent Corporation",
	"_legent-2":                             "Legent Corporation",
	"_hassle":                               "Hassle",
	"_nip":                                  "Amiga Envoy Network Inquiry Protocol",
	"_tnetos":                               "NEC Corporation",
	"_dsetos":                               "NEC Corporation",
	"_is99c":                                "TIA/EIA/IS-99 modem client",
	"_is99s":                                "TIA/EIA/IS-99 modem server",
	"_hp-collector":                         "hp performance data collector",
	"_hp-managed-node":                      "hp performance data managed node",
	"_hp-alarm-mgr":                         "hp performance data alarm manager",
	"_arns":                                 "A Remote Network Server System",
	"_ibm-app":                              "IBM Application",
	"_asa":                                  "ASA Message Router Object Def.",
	"_aurp":                                 "Appletalk Update-Based Routing Pro.",
	"_unidata-ldm":                          "Unidata LDM",
	"_ldap":                                 "Lightweight Directory Access Protocol",
	"_uis":                                  "UIS",
	"_synotics-relay":                       "SynOptics SNMP Relay Port",
	"_synotics-broker":                      "SynOptics Port Broker Port",
	"_meta5":                                "Meta5",
	"_embl-ndt":                             "EMBL Nucleic Data Transfer",
	"_netcp":                                "NetScout Control Protocol",
	"_netware-ip":                           "Novell Netware over IP",
	"_mptn":                                 "Multi Protocol Trans. Net.",
	"_kryptolan":                            "Kryptolan",
	"_iso-tsap-c2":                          "ISO Transport Class 2 Non-Control over TCP",
	"_osb-sd":                               "Oracle Secure Backup",
	"_ups":                                  "Uninterruptible Power Supply",
	"_genie":                                "Genie Protocol",
	"_decap":                                "decap",
	"_nced":                                 "nced",
	"_ncld":                                 "ncld",
	"_imsp":                                 "Interactive Mail Support Protocol",
	"_timbuktu":                             "Timbuktu",
	"_prm-sm":                               "Prospero Resource Manager Sys. Man.",
	"_prm-nm":                               "Prospero Resource Manager Node Man.",
	"_decladebug":                           "DECLadebug Remote Debug Protocol",
	"_rmt":                                  "Remote MT Protocol",
	"_synoptics-trap":                       "Trap Convention Port",
	"_smsp":                                 "Storage Management Services Protocol",
	"_infoseek":                             "InfoSeek",
	"_bnet":                                 "BNet",
	"_silverplatter":                        "Silverplatter",
	"_onmux":                                "Onmux",
	"_hyper-g":                              "Hyper-G",
	"_ariel1":                               "Ariel 1",
	"_smpte":                                "SMPTE",
	"_ariel2":                               "Ariel 2",
	"_ariel3":                               "Ariel 3",
	"_opc-job-start":                        "IBM Operations Planning and Control Start",
	"_opc-job-track":                        "IBM Operations Planning and Control Track",
	"_icad-el":                              "ICAD",
	"_smartsdp":                             "smartsdp",
	"_svrloc":                               "Server Location",
	"_ocs-cmu":                              "OCS_CMU IANA assigned this well-formed service name as a replacement for 'ocs_cmu'.",
	"_ocs_cmu":                              "OCS_CMU",
	"_ocs-amu":                              "OCS_AMU IANA assigned this well-formed service name as a replacement for 'ocs_amu'.",
	"_ocs_amu":                              "OCS_AMU",
	"_utmpsd":                               "UTMPSD",
	"_utmpcd":                               "UTMPCD",
	"_iasd":                                 "IASD",
	"_nnsp":                                 "NNTP for transit servers (NNSP)",
	"_mobileip-agent":                       "MobileIP-Agent",
	"_mobilip-mn":                           "MobilIP-MN",
	"_dna-cml":                              "DNA-CML",
	"_comscm":                               "comscm",
	"_dsfgw":                                "dsfgw",
	"_dasp":                                 "dasp",
	"_sgcp":                                 "sgcp",
	"_decvms-sysmgt":                        "decvms-sysmgt",
	"_cvc-hostd":                            "cvc_hostd IANA assigned this well-formed service name as a replacement for 'cvc_hostd'.",
	"_cvc_hostd":                            "cvc_hostd",
	"_https":                                "http protocol over TLS/SSL",
	"_snpp":                                 "Simple Network Paging Protocol",
	"_microsoft-ds":                         "Microsoft-DS",
	"_ddm-rdb":                              "DDM-Remote Relational Database Access",
	"_ddm-dfm":                              "DDM-Distributed File Management",
	"_ddm-ssl":                              "DDM-Remote DB Access Using Secure Sockets",
	"_as-servermap":                         "AS Server Mapper",
	"_tserver":                              "Computer Supported Telecomunication Applications",
	"_sfs-smp-net":                          "Cray Network Semaphore server",
	"_sfs-config":                           "Cray SFS config server",
	"_creativeserver":                       "CreativeServer",
	"_contentserver":                        "ContentServer",
	"_creativepartnr":                       "CreativePartnr",
	"_macon-tcp":                            "macon-tcp",
	"_macon-udp":                            "macon-udp",
	"_scohelp":                              "scohelp",
	"_appleqtc":                             "apple quick time",
	"_ampr-rcmd":                            "ampr-rcmd",
	"_skronk":                               "skronk",
	"_datasurfsrv":                          "DataRampSrv",
	"_datasurfsrvsec":                       "DataRampSrvSec",
	"_alpes":                                "alpes",
	"_kpasswd":                              "kpasswd",
	"_urd":                                  "URL Rendezvous Directory for SSM",
	"_submissions":                          "Message Submission over TLS protocol",
	"_igmpv3lite":                           "IGMP over UDP for SSM",
	"_digital-vrc":                          "digital-vrc",
	"_mylex-mapd":                           "mylex-mapd",
	"_photuris":                             "proturis",
	"_rcp":                                  "Radio Control Protocol",
	"_scx-proxy":                            "scx-proxy",
	"_mondex":                               "Mondex",
	"_ljk-login":                            "ljk-login",
	"_hybrid-pop":                           "hybrid-pop",
	"_tn-tl-w1":                             "tn-tl-w1",
	"_tn-tl-w2":                             "tn-tl-w2",
	"_tcpnethaspsrv":                        "tcpnethaspsrv",
	"_tn-tl-fd1":                            "tn-tl-fd1",
	"_ss7ns":                                "ss7ns",
	"_spsc":                                 "spsc",
	"_iafserver":                            "iafserver",
	"_iafdbase":                             "iafdbase",
	"_ph":                                   "Ph service",
	"_bgs-nsi":                              "bgs-nsi",
	"_ulpnet":                               "ulpnet",
	"_integra-sme":                          "Integra Software Management Environment",
	"_powerburst":                           "Air Soft Power Burst",
	"_avian":                                "avian",
	"_saft":                                 "saft Simple Asynchronous File Transfer",
	"_gss-http":                             "gss-http",
	"_nest-protocol":                        "nest-protocol",
	"_micom-pfs":                            "micom-pfs",
	"_go-login":                             "go-login",
	"_ticf-1":                               "Transport Independent Convergence for FNA",
	"_ticf-2":                               "Transport Independent Convergence for FNA",
	"_pov-ray":                              "POV-Ray",
	"_intecourier":                          "intecourier",
	"_pim-rp-disc":                          "PIM-RP-DISC",
	"_retrospect":                           "Retrospect backup and restore service",
	"_siam":                                 "siam",
	"_iso-ill":                              "ISO ILL Protocol",
	"_isakmp":                               "isakmp",
	"_stmf":                                 "STMF",
	"_mbap":                                 "Modbus Application Protocol",
	"_intrinsa":                             "Intrinsa",
	"_citadel":                              "citadel",
	"_mailbox-lm":                           "mailbox-lm",
	"_ohimsrv":                              "ohimsrv",
	"_crs":                                  "crs",
	"_xvttp":                                "xvttp",
	"_snare":                                "snare",
	"_fcp":                                  "FirstClass Protocol",
	"_passgo":                               "PassGo",
	"_exec":                                 "remote process execution; authentication performed using passwords and UNIX login names",
	"_comsat":                               "",
	"_biff":                                 "used by mail system to notify users of new mail received; currently receives messages only from processes on the same machine",
	"_login":                                "remote login a la telnet; automatic authentication performed based on priviledged port numbers and distributed data bases which identify 'authentication domains'",
	"_who":                                  "maintains data bases showing who's logged in to machines on a local net and the load average of the machine",
	"_shell":                                "cmd like exec, but automatic authentication is performed as for login server",
	"_syslog":                               "",
	"_printer":                              "spooler",
	"_videotex":                             "videotex",
	"_talk":                                 "like tenex link, but across machine - unfortunately, doesn't use link protocol (this is actually just a rendezvous port from which a tcp connection is established)",
	"_ntalk":                                "",
	"_utime":                                "unixtime",
	"_efs":                                  "extended file name server",
	"_router":                               "local routing process (on site); uses variant of Xerox NS routing information protocol - RIP",
	"_ripng":                                "ripng",
	"_ulp":                                  "ULP",
	"_ibm-db2":                              "IBM-DB2",
	"_ncp":                                  "NCP",
	"_timed":                                "timeserver",
	"_tempo":                                "newdate",
	"_stx":                                  "Stock IXChange",
	"_custix":                               "Customer IXChange",
	"_irc-serv":                             "IRC-SERV",
	"_courier":                              "rpc",
	"_conference":                           "chat",
	"_netnews":                              "readnews",
	"_netwall":                              "for emergency broadcasts",
	"_windream":                             "windream Admin",
	"_iiop":                                 "iiop",
	"_opalis-rdv":                           "opalis-rdv",
	"_nmsp":                                 "Networked Media Streaming Protocol",
	"_gdomap":                               "gdomap",
	"_apertus-ldp":                          "Apertus Technologies Load Determination",
	"_uucp":                                 "uucpd",
	"_uucp-rlogin":                          "uucp-rlogin",
	"_commerce":                             "commerce",
	"_klogin":                               "",
	"_kshell":                               "krcmd",
	"_appleqtcsrvr":                         "appleqtcsrvr",
	"_dhcpv6-client":                        "DHCPv6 Client",
	"_dhcpv6-server":                        "DHCPv6 Server",
	"_afpovertcp":                           "AFP over TCP",
	"_idfp":                                 "IDFP",
	"_new-rwho":                             "new-who",
	"_cybercash":                            "cybercash",
	"_devshr-nts":                           "DeviceShare",
	"_pirp":                                 "pirp",
	"_rtsp":                                 "Real Time Streaming Protocol (RTSP)",
	"_dsf":                                  "",
	"_remotefs":                             "rfs server",
	"_openvms-sysipc":                       "openvms-sysipc",
	"_sdnskmp":                              "SDNSKMP",
	"_teedtap":                              "TEEDTAP",
	"_rmonitor":                             "rmonitord",
	"_monitor":                              "",
	"_chshell":                              "chcmd",
	"_nntps":                                "nntp protocol over TLS/SSL (was snntp)",
	"_9pfs":                                 "plan 9 file service",
	"_whoami":                               "whoami",
	"_streettalk":                           "streettalk",
	"_banyan-rpc":                           "banyan-rpc",
	"_ms-shuttle":                           "microsoft shuttle",
	"_ms-rome":                              "microsoft rome",
	"_meter":                                "demon",
	"_sonar":                                "sonar",
	"_banyan-vip":                           "banyan-vip",
	"_ftp-agent":                            "FTP Software Agent System",
	"_vemmi":                                "VEMMI",
	"_ipcd":                                 "ipcd",
	"_vnas":                                 "vnas",
	"_ipdd":                                 "ipdd",
	"_decbsrv":                              "decbsrv",
	"_sntp-heartbeat":                       "SNTP HEARTBEAT",
	"_bdp":                                  "Bundle Discovery Protocol",
	"_scc-security":                         "SCC Security",
	"_philips-vc":                           "Philips Video-Conferencing",
	"_keyserver":                            "Key Server",
	"_password-chg":                         "Password Change",
	"_submission":                           "Message Submission",
	"_cal":                                  "CAL",
	"_eyelink":                              "EyeLink",
	"_tns-cml":                              "TNS CML",
	"_http-alt":                             "FileMaker, Inc. - HTTP Alternate (see Port 80)",
	"_eudora-set":                           "Eudora Set",
	"_http-rpc-epmap":                       "HTTP RPC Ep Map",
	"_tpip":                                 "TPIP",
	"_cab-protocol":                         "CAB Protocol",
	"_smsd":                                 "SMSD",
	"_ptcnameservice":                       "PTC Name Service",
	"_sco-websrvrmg3":                       "SCO Web Server Manager 3",
	"_acp":                                  "Aeolon Core Protocol",
	"_ipcserver":                            "Sun IPC server",
	"_syslog-conn":                          "Reliable Syslog Service",
	"_xmlrpc-beep":                          "XML-RPC over BEEP",
	"_idxp":                                 "IDXP",
	"_tunnel":                               "TUNNEL",
	"_soap-beep":                            "SOAP over BEEP",
	"_urm":                                  "Cray Unified Resource Manager",
	"_nqs":                                  "nqs",
	"_sift-uft":                             "Sender-Initiated/Unsolicited File Transfer",
	"_npmp-trap":                            "npmp-trap",
	"_npmp-local":                           "npmp-local",
	"_npmp-gui":                             "npmp-gui",
	"_hmmp-ind":                             "HMMP Indication",
	"_hmmp-op":                              "HMMP Operation",
	"_sshell":                               "SSLshell",
	"_sco-inetmgr":                          "Internet Configuration Manager",
	"_sco-sysmgr":                           "SCO System Administration Server",
	"_sco-dtmgr":                            "SCO Desktop Administration Server",
	"_dei-icda":                             "DEI-ICDA",
	"_compaq-evm":                           "Compaq EVM",
	"_sco-websrvrmgr":                       "SCO WebServer Manager",
	"_escp-ip":                              "ESCP",
	"_collaborator":                         "Collaborator",
	"_oob-ws-http":                          "DMTF out-of-band web services management protocol",
	"_asf-rmcp":                             "ASF Remote Management and Control Protocol",
	"_cryptoadmin":                          "Crypto Admin",
	"_dec-dlm":                              "DEC DLM IANA assigned this well-formed service name as a replacement for 'dec_dlm'.",
	"_dec_dlm":                              "DEC DLM",
	"_asia":                                 "ASIA",
	"_passgo-tivoli":                        "PassGo Tivoli",
	"_qmqp":                                 "QMQP",
	"_3com-amp3":                            "3Com AMP3",
	"_rda":                                  "RDA",
	"_ipp":                                  "IPP (Internet Printing Protocol)",
	"_ipps":                                 "Internet Printing Protocol over HTTPS",
	"_bmpp":                                 "bmpp",
	"_servstat":                             "Service Status update (Sterling Software)",
	"_ginad":                                "ginad",
	"_rlzdbase":                             "RLZ DBase",
	"_ldaps":                                "ldap protocol over TLS/SSL (was sldap)",
	"_lanserver":                            "lanserver",
	"_mcns-sec":                             "mcns-sec",
	"_msdp":                                 "MSDP",
	"_entrust-sps":                          "entrust-sps",
	"_repcmd":                               "repcmd",
	"_esro-emsdp":                           "ESRO-EMSDP V1.3",
	"_sanity":                               "SANity",
	"_dwr":                                  "dwr",
	"_pssc":                                 "PSSC",
	"_ldp":                                  "LDP",
	"_dhcp-failover":                        "DHCP Failover",
	"_rrp":                                  "Registry Registrar Protocol (RRP)",
	"_cadview-3d":                           "Cadview-3d - streaming 3d models over the internet",
	"_obex":                                 "OBEX",
	"_ieee-mms":                             "IEEE MMS",
	"_hello-port":                           "HELLO_PORT",
	"_repscmd":                              "RepCmd",
	"_aodv":                                 "AODV",
	"_tinc":                                 "TINC",
	"_spmp":                                 "SPMP",
	"_rmc":                                  "RMC",
	"_tenfold":                              "TenFold",
	"_mac-srvr-admin":                       "MacOS Server Admin",
	"_hap":                                  "HAP",
	"_pftp":                                 "PFTP",
	"_purenoise":                            "PureNoise",
	"_oob-ws-https":                         "DMTF out-of-band secure web services management protocol",
	"_asf-secure-rmcp":                      "ASF Secure Remote Management and Control Protocol",
	"_sun-dr":                               "Sun DR",
	"_mdqs":                                 "",
	"_doom":                                 "doom Id Software",
	"_disclose":                             "campaign contribution disclosures - SDR Technologies",
	"_mecomm":                               "MeComm",
	"_meregister":                           "MeRegister",
	"_vacdsm-sws":                           "VACDSM-SWS",
	"_vacdsm-app":                           "VACDSM-APP",
	"_vpps-qua":                             "VPPS-QUA",
	"_cimplex":                              "CIMPLEX",
	"_acap":                                 "ACAP",
	"_dctp":                                 "DCTP",
	"_vpps-via":                             "VPPS Via",
	"_vpp":                                  "Virtual Presence Protocol",
	"_ggf-ncp":                              "GNU Generation Foundation NCP",
	"_mrm":                                  "MRM",
	"_entrust-aaas":                         "entrust-aaas",
	"_entrust-aams":                         "entrust-aams",
	"_xfr":                                  "XFR",
	"_corba-iiop":                           "CORBA IIOP",
	"_corba-iiop-ssl":                       "CORBA IIOP SSL",
	"_mdc-portmapper":                       "MDC Port Mapper",
	"_hcp-wismar":                           "Hardware Control Protocol Wismar",
	"_asipregistry":                         "asipregistry",
	"_realm-rusd":                           "ApplianceWare managment protocol",
	"_nmap":                                 "NMAP",
	"_vatp":                                 "Velneo Application Transfer Protocol",
	"_msexch-routing":                       "MS Exchange Routing",
	"_hyperwave-isp":                        "Hyperwave-ISP",
	"_connendp":                             "almanid Connection Endpoint",
	"_ha-cluster":                           "ha-cluster",
	"_ieee-mms-ssl":                         "IEEE-MMS-SSL",
	"_rushd":                                "RUSHD",
	"_uuidgen":                              "UUIDGEN",
	"_olsr":                                 "OLSR",
	"_accessnetwork":                        "Access Network",
	"_epp":                                  "Extensible Provisioning Protocol",
	"_lmp":                                  "Link Management Protocol (LMP)",
	"_iris-beep":                            "IRIS over BEEP",
	"_elcsd":                                "errlog copy/server daemon",
	"_agentx":                               "AgentX",
	"_silc":                                 "SILC",
	"_borland-dsj":                          "Borland DSJ",
	"_entrust-kmsh":                         "Entrust Key Management Service Handler",
	"_entrust-ash":                          "Entrust Administration Service Handler",
	"_cisco-tdp":                            "Cisco TDP",
	"_tbrpf":                                "TBRPF",
	"_iris-xpc":                             "IRIS over XPC",
	"_iris-xpcs":                            "IRIS over XPCS",
	"_iris-lwz":                             "IRIS-LWZ",
	"_pana":                                 "PANA Messages",
	"_netviewdm1":                           "IBM NetView DM/6000 Server/Client",
	"_netviewdm2":                           "IBM NetView DM/6000 send/tcp",
	"_netviewdm3":                           "IBM NetView DM/6000 receive/tcp",
	"_netgw":                                "netGW",
	"_netrcs":                               "Network based Rev. Cont. Sys.",
	"_flexlm":                               "Flexible License Manager",
	"_fujitsu-dev":                          "Fujitsu Device Control",
	"_ris-cm":                               "Russell Info Sci Calendar Manager",
	"_kerberos-adm":                         "kerberos administration",
	"_rfile":                                "",
	"_loadav":                               "",
	"_kerberos-iv":                          "kerberos version iv",
	"_pump":                                 "",
	"_qrh":                                  "",
	"_rrh":                                  "",
	"_tell":                                 "send",
	"_nlogin":                               "",
	"_con":                                  "",
	"_ns":                                   "",
	"_rxe":                                  "",
	"_quotad":                               "",
	"_cycleserv":                            "",
	"_omserv":                               "",
	"_webster":                              "",
	"_phonebook":                            "phone",
	"_vid":                                  "",
	"_cadlock":                              "",
	"_rtip":                                 "",
	"_cycleserv2":                           "",
	"_submit":                               "",
	"_notify":                               "",
	"_rpasswd":                              "",
	"_acmaint-dbd":                          "IANA assigned this well-formed service name as a replacement for 'acmaint_dbd'.",
	"_acmaint_dbd":                          "",
	"_entomb":                               "",
	"_acmaint-transd":                       "IANA assigned this well-formed service name as a replacement for 'acmaint_transd'.",
	"_acmaint_transd":                       "",
	"_wpages":                               "",
	"_multiling-http":                       "Multiling HTTP",
	"_wpgs":                                 "",
	"_mdbs-daemon":                          "IANA assigned this well-formed service name as a replacement for 'mdbs_daemon'.",
	"_mdbs_daemon":                          "",
	"_device":                               "",
	"_mbap-s":                               "Modbus Application Protocol Secure",
	"_fcp-udp":                              "FCP",
	"_itm-mcell-s":                          "itm-mcell-s",
	"_pkix-3-ca-ra":                         "PKIX-3 CA/RA",
	"_netconf-ssh":                          "NETCONF over SSH",
	"_netconf-beep":                         "NETCONF over BEEP",
	"_netconfsoaphttp":                      "NETCONF for SOAP over HTTPS",
	"_netconfsoapbeep":                      "NETCONF for SOAP over BEEP",
	"_dhcp-failover2":                       "dhcp-failover 2",
	"_gdoi":                                 "GDOI",
	"_domain-s":                             "DNS query-response protocol run over TLS",
	"_dlep":                                 "Dynamic Link Exchange Protocol (DLEP)",
	"_iscsi":                                "iSCSI",
	"_owamp-control":                        "OWAMP-Control",
	"_owamp-test":                           "OWAMP-Test",
	"_twamp-control":                        "TWAMP-Control",
	"_twamp-test":                           "TWAMP-Test Receiver Port",
	"_rsync":                                "rsync",
	"_iclcnet-locate":                       "ICL coNETion locate server",
	"_iclcnet-svinfo":                       "ICL coNETion server info IANA assigned this well-formed service name as a replacement for 'iclcnet_svinfo'.",
	"_iclcnet_svinfo":                       "ICL coNETion server info",
	"_accessbuilder":                        "AccessBuilder",
	"_cddbp":                                "CD Database Protocol",
	"_omginitialrefs":                       "OMG Initial Refs",
	"_smpnameres":                           "SMPNAMERES",
	"_ideafarm-door":                        "self documenting Telnet Door",
	"_ideafarm-panic":                       "self documenting Telnet Panic Door",
	"_kink":                                 "Kerberized Internet Negotiation of Keys (KINK)",
	"_xact-backup":                          "xact-backup",
	"_apex-mesh":                            "APEX relay-relay service",
	"_apex-edge":                            "APEX endpoint-relay service",
	"_rift-lies":                            "Routing in Fat Trees Link Information Element",
	"_rift-ties":                            "Routing in Fat Trees Topology Information Element",
	"_rndc":                                 "BIND9 remote name daemon controller",
	"_ftps-data":                            "ftp protocol, data, over TLS/SSL",
	"_ftps":                                 "ftp protocol, control, over TLS/SSL",
	"_nas":                                  "Netnews Administration System",
	"_telnets":                              "telnet protocol over TLS/SSL",
	"_imaps":                                "IMAP over TLS protocol",
	"_pop3s":                                "POP3 over TLS protocol",
	"_vsinet":                               "vsinet",
	"_maitrd":                               "",
	"_busboy":                               "",
	"_puparp":                               "",
	"_garcon":                               "",
	"_applix":                               "Applix ac",
	"_puprouter":                            "",
	"_cadlock2":                             "",
	"_webpush":                              "HTTP Web Push",
	"_surf":                                 "surf",
	"_exp1":                                 "RFC3692-style Experiment 1",
	"_exp2":                                 "RFC3692-style Experiment 2",
	"_blackjack":                            "network blackjack",
	"_cap":                                  "Calendar Access Protocol",
	"_6a44":                                 "IPv6 Behind NAT44 CPEs",
	"_solid-mux":                            "Solid Mux Server",
	"_netinfo-local":                        "local netinfo port",
	"_activesync":                           "ActiveSync Notifications",
	"_mxxrlogin":                            "MX-XR RPC",
	"_nsstp":                                "Nebula Secure Segment Transfer Protocol",
	"_ams":                                  "AMS",
	"_mtqp":                                 "Message Tracking Query Protocol",
	"_sbl":                                  "Streamlined Blackhole",
	"_netarx":                               "Netarx Netcare",
	"_danf-ak2":                             "AK2 Product",
	"_afrog":                                "Subnet Roaming",
	"_boinc-client":                         "BOINC Client Control",
	"_dcutility":                            "Dev Consortium Utility",
	"_fpitp":                                "Fingerprint Image Transfer Protocol",
	"_wfremotertm":                          "WebFilter Remote Monitor",
	"_neod1":                                "Sun's NEO Object Request Broker",
	"_neod2":                                "Sun's NEO Object Request Broker",
	"_td-postman":                           "Tobit David Postman VPMN",
	"_cma":                                  "CORBA Management Agent",
	"_optima-vnet":                          "Optima VNET",
	"_ddt":                                  "Dynamic DNS Tools",
	"_remote-as":                            "Remote Assistant (RA)",
	"_brvread":                              "BRVREAD",
	"_ansyslmd":                             "ANSYS - License Manager",
	"_vfo":                                  "VFO",
	"_startron":                             "STARTRON",
	"_nim":                                  "nim",
	"_nimreg":                               "nimreg",
	"_polestar":                             "POLESTAR",
	"_kiosk":                                "KIOSK",
	"_veracity":                             "Veracity",
	"_kyoceranetdev":                        "KyoceraNetDev",
	"_jstel":                                "JSTEL",
	"_syscomlan":                            "SYSCOMLAN",
	"_fpo-fns":                              "FPO-FNS",
	"_instl-boots":                          "Installation Bootstrap Proto. Serv. IANA assigned this well-formed service name as a replacement for 'instl_boots'.",
	"_instl_boots":                          "Installation Bootstrap Proto. Serv.",
	"_instl-bootc":                          "Installation Bootstrap Proto. Cli. IANA assigned this well-formed service name as a replacement for 'instl_bootc'.",
	"_instl_bootc":                          "Installation Bootstrap Proto. Cli.",
	"_cognex-insight":                       "COGNEX-INSIGHT",
	"_gmrupdateserv":                        "GMRUpdateSERV",
	"_bsquare-voip":                         "BSQUARE-VOIP",
	"_cardax":                               "CARDAX",
	"_bridgecontrol":                        "Bridge Control",
	"_warmspotmgmt":                         "Warmspot Management Protocol",
	"_rdrmshc":                              "RDRMSHC",
	"_dab-sti-c":                            "DAB STI-C",
	"_imgames":                              "IMGames",
	"_avocent-proxy":                        "Avocent Proxy Protocol",
	"_asprovatalk":                          "ASPROVATalk",
	"_socks":                                "Socks",
	"_pvuniwien":                            "PVUNIWIEN",
	"_amt-esd-prot":                         "AMT-ESD-PROT",
	"_ansoft-lm-1":                          "Anasoft License Manager",
	"_ansoft-lm-2":                          "Anasoft License Manager",
	"_webobjects":                           "Web Objects",
	"_cplscrambler-lg":                      "CPL Scrambler Logging",
	"_cplscrambler-in":                      "CPL Scrambler Internal",
	"_cplscrambler-al":                      "CPL Scrambler Alarm Log",
	"_ff-annunc":                            "FF Annunciation",
	"_ff-fms":                               "FF Fieldbus Message Specification",
	"_ff-sm":                                "FF System Management",
	"_obrpd":                                "Open Business Reporting Protocol",
	"_proofd":                               "PROOFD",
	"_rootd":                                "ROOTD",
	"_nicelink":                             "NICELink",
	"_cnrprotocol":                          "Common Name Resolution Protocol",
	"_sunclustermgr":                        "Sun Cluster Manager",
	"_rmiactivation":                        "RMI Activation",
	"_rmiregistry":                          "RMI Registry",
	"_mctp":                                 "MCTP",
	"_pt2-discover":                         "PT2-DISCOVER",
	"_adobeserver-1":                        "ADOBE SERVER 1",
	"_adobeserver-2":                        "ADOBE SERVER 2",
	"_xrl":                                  "XRL",
	"_ftranhc":                              "FTRANHC",
	"_isoipsigport-1":                       "ISOIPSIGPORT-1",
	"_isoipsigport-2":                       "ISOIPSIGPORT-2",
	"_ratio-adp":                            "ratio-adp",
	"_webadmstart":                          "Start web admin server",
	"_nfsd-keepalive":                       "Client status info",
	"_lmsocialserver":                       "LM Social Server",
	"_icp":                                  "Intelligent Communication Protocol",
	"_ltp-deepspace":                        "Licklider Transmission Protocol",
	"_mini-sql":                             "Mini SQL",
	"_ardus-trns":                           "ARDUS Transfer",
	"_ardus-cntl":                           "ARDUS Control",
	"_ardus-mtrns":                          "ARDUS Multicast Transfer",
	"_sacred":                               "SACRED",
	"_bnetgame":                             "Battle.net Chat/Game Protocol",
	"_bnetfile":                             "Battle.net File Transfer Protocol",
	"_rmpp":                                 "Datalode RMPP",
	"_availant-mgr":                         "availant-mgr",
	"_murray":                               "Murray",
	"_hpvmmcontrol":                         "HP VMM Control",
	"_hpvmmagent":                           "HP VMM Agent",
	"_hpvmmdata":                            "HP VMM Agent",
	"_kwdb-commn":                           "KWDB Remote Communication",
	"_saphostctrl":                          "SAPHostControl over SOAP/HTTP",
	"_saphostctrls":                         "SAPHostControl over SOAP/HTTPS",
	"_casp":                                 "CAC App Service Protocol",
	"_caspssl":                              "CAC App Service Protocol Encripted",
	"_kvm-via-ip":                           "KVM-via-IP Management Service",
	"_dfn":                                  "Data Flow Network",
	"_aplx":                                 "MicroAPL APLX",
	"_omnivision":                           "OmniVision Communication Service",
	"_hhb-gateway":                          "HHB Gateway Control",
	"_trim":                                 "TRIM Workgroup Service",
	"_encrypted-admin":                      "encrypted admin requests IANA assigned this well-formed service name as a replacement for 'encrypted_admin'.",
	"_encrypted_admin":                      "encrypted admin requests",
	"_evm":                                  "Enterprise Virtual Manager",
	"_autonoc":                              "AutoNOC Network Operations Protocol",
	"_mxomss":                               "User Message Service",
	"_edtools":                              "User Discovery Service",
	"_imyx":                                 "Infomatryx Exchange",
	"_fuscript":                             "Fusion Script",
	"_x9-icue":                              "X9 iCue Show Control",
	"_audit-transfer":                       "audit transfer",
	"_capioverlan":                          "CAPIoverLAN",
	"_elfiq-repl":                           "Elfiq Replication Service",
	"_bvtsonar":                             "BlueView Sonar Service",
	"_blaze":                                "Blaze File Server",
	"_unizensus":                            "Unizensus Login Server",
	"_winpoplanmess":                        "Winpopup LAN Messenger",
	"_c1222-acse":                           "ANSI C12.22 Port",
	"_resacommunity":                        "Community Service",
	"_nfa":                                  "Network File Access",
	"_iascontrol-oms":                       "iasControl OMS",
	"_iascontrol":                           "Oracle iASControl",
	"_dbcontrol-oms":                        "dbControl OMS",
	"_oracle-oms":                           "Oracle OMS",
	"_olsv":                                 "DB Lite Mult-User Server",
	"_health-polling":                       "Health Polling",
	"_health-trap":                          "Health Trap",
	"_sddp":                                 "SmartDialer Data Protocol",
	"_qsm-proxy":                            "QSM Proxy Service",
	"_qsm-gui":                              "QSM GUI Service",
	"_qsm-remote":                           "QSM RemoteExec",
	"_cisco-ipsla":                          "Cisco IP SLAs Control Protocol",
	"_vchat":                                "VChat Conference Service",
	"_tripwire":                             "TRIPWIRE",
	"_atc-lm":                               "AT+C License Manager",
	"_atc-appserver":                        "AT+C FmiApplicationServer",
	"_dnap":                                 "DNA Protocol",
	"_d-cinema-rrp":                         "D-Cinema Request-Response",
	"_fnet-remote-ui":                       "FlashNet Remote Admin",
	"_dossier":                              "Dossier Server",
	"_indigo-server":                        "Indigo Home Server",
	"_dkmessenger":                          "DKMessenger Protocol",
	"_sgi-storman":                          "SGI Storage Manager",
	"_b2n":                                  "Backup To Neighbor",
	"_mc-client":                            "Millicent Client Proxy",
	"_3comnetman":                           "3Com Net Management",
	"_accelenet":                            "AcceleNet Control",
	"_accelenet-data":                       "AcceleNet Data",
	"_llsurfup-http":                        "LL Surfup HTTP",
	"_llsurfup-https":                       "LL Surfup HTTPS",
	"_catchpole":                            "Catchpole port",
	"_mysql-cluster":                        "MySQL Cluster Manager",
	"_alias":                                "Alias Service",
	"_hp-webadmin":                          "HP Web Admin",
	"_unet":                                 "Unet Connection",
	"_commlinx-avl":                         "CommLinx GPS / AVL System",
	"_gpfs":                                 "General Parallel File System",
	"_caids-sensor":                         "caids sensors channel",
	"_fiveacross":                           "Five Across Server",
	"_openvpn":                              "OpenVPN",
	"_rsf-1":                                "RSF-1 clustering",
	"_netmagic":                             "Network Magic",
	"_carrius-rshell":                       "Carrius Remote Access",
	"_cajo-discovery":                       "cajo reference discovery",
	"_dmidi":                                "DMIDI",
	"_scol":                                 "SCOL",
	"_nucleus-sand":                         "Nucleus Sand Database Server",
	"_caiccipc":                             "caiccipc",
	"_ssslic-mgr":                           "License Validation",
	"_ssslog-mgr":                           "Log Request Listener",
	"_accord-mgc":                           "Accord-MGC",
	"_anthony-data":                         "Anthony Data",
	"_metasage":                             "MetaSage",
	"_seagull-ais":                          "SEAGULL AIS",
	"_ipcd3":                                "IPCD3",
	"_eoss":                                 "EOSS",
	"_groove-dpp":                           "Groove DPP",
	"_lupa":                                 "lupa",
	"_mpc-lifenet":                          "Medtronic/Physio-Control LIFENET",
	"_kazaa":                                "KAZAA",
	"_scanstat-1":                           "scanSTAT 1.0",
	"_etebac5":                              "ETEBAC 5",
	"_hpss-ndapi":                           "HPSS NonDCE Gateway",
	"_aeroflight-ads":                       "AeroFlight-ADs",
	"_aeroflight-ret":                       "AeroFlight-Ret",
	"_qt-serveradmin":                       "QT SERVER ADMIN",
	"_sweetware-apps":                       "SweetWARE Apps",
	"_nerv":                                 "SNI R&D network",
	"_tgp":                                  "TrulyGlobal Protocol",
	"_vpnz":                                 "VPNz",
	"_slinkysearch":                         "SLINKYSEARCH",
	"_stgxfws":                              "STGXFWS",
	"_dns2go":                               "DNS2Go",
	"_florence":                             "FLORENCE",
	"_zented":                               "ZENworks Tiered Electronic Distribution",
	"_periscope":                            "Periscope",
	"_menandmice-lpm":                       "menandmice-lpm",
	"_first-defense":                        "Remote systems monitoring",
	"_univ-appserver":                       "Universal App Server",
	"_search-agent":                         "Infoseek Search Agent",
	"_mosaicsyssvc1":                        "mosaicsyssvc1",
	"_bvcontrol":                            "bvcontrol",
	"_tsdos390":                             "tsdos390",
	"_hacl-qs":                              "hacl-qs",
	"_nmsd":                                 "NMSD",
	"_instantia":                            "Instantia",
	"_nessus":                               "nessus",
	"_nmasoverip":                           "NMAS over IP",
	"_serialgateway":                        "SerialGateway",
	"_isbconference1":                       "isbconference1",
	"_isbconference2":                       "isbconference2",
	"_payrouter":                            "payrouter",
	"_visionpyramid":                        "VisionPyramid",
	"_hermes":                               "hermes",
	"_mesavistaco":                          "Mesa Vista Co",
	"_swldy-sias":                           "swldy-sias",
	"_servergraph":                          "servergraph",
	"_bspne-pcc":                            "bspne-pcc",
	"_q55-pcc":                              "q55-pcc",
	"_de-noc":                               "de-noc",
	"_de-cache-query":                       "de-cache-query",
	"_de-server":                            "de-server",
	"_shockwave2":                           "Shockwave 2",
	"_opennl":                               "Open Network Library",
	"_opennl-voice":                         "Open Network Library Voice",
	"_ibm-ssd":                              "ibm-ssd",
	"_mpshrsv":                              "mpshrsv",
	"_qnts-orb":                             "QNTS-ORB",
	"_dka":                                  "dka",
	"_prat":                                 "PRAT",
	"_dssiapi":                              "DSSIAPI",
	"_dellpwrappks":                         "DELLPWRAPPKS",
	"_epc":                                  "eTrust Policy Compliance",
	"_propel-msgsys":                        "PROPEL-MSGSYS",
	"_watilapp":                             "WATiLaPP",
	"_opsmgr":                               "Microsoft Operations Manager",
	"_excw":                                 "eXcW",
	"_cspmlockmgr":                          "CSPMLockMgr",
	"_emc-gateway":                          "EMC-Gateway",
	"_t1distproc":                           "t1distproc",
	"_ivcollector":                          "ivcollector",
	"_miva-mqs":                             "mqs",
	"_dellwebadmin-1":                       "Dell Web Admin 1",
	"_dellwebadmin-2":                       "Dell Web Admin 2",
	"_pictrography":                         "Pictrography",
	"_healthd":                              "healthd",
	"_emperion":                             "Emperion",
	"_productinfo":                          "Product Information",
	"_iee-qfx":                              "IEE-QFX",
	"_neoiface":                             "neoiface",
	"_netuitive":                            "netuitive",
	"_routematch":                           "RouteMatch Com",
	"_navbuddy":                             "NavBuddy",
	"_jwalkserver":                          "JWalkServer",
	"_winjaserver":                          "WinJaServer",
	"_seagulllms":                           "SEAGULLLMS",
	"_dsdn":                                 "dsdn",
	"_pkt-krb-ipsec":                        "PKT-KRB-IPSec",
	"_cmmdriver":                            "CMMdriver",
	"_ehtp":                                 "End-by-Hop Transmission Protocol",
	"_dproxy":                               "dproxy",
	"_sdproxy":                              "sdproxy",
	"_lpcp":                                 "lpcp",
	"_hp-sci":                               "hp-sci",
	"_h323hostcallsc":                       "H.323 Secure Call Control Signalling",
	"_sftsrv":                               "sftsrv",
	"_boomerang":                            "Boomerang",
	"_pe-mike":                              "pe-mike",
	"_re-conn-proto":                        "RE-Conn-Proto",
	"_pacmand":                              "Pacmand",
	"_odsi":                                 "Optical Domain Service Interconnect (ODSI)",
	"_jtag-server":                          "JTAG server",
	"_husky":                                "Husky",
	"_rxmon":                                "RxMon",
	"_sti-envision":                         "STI Envision",
	"_bmc-patroldb":                         "BMC_PATROLDB IANA assigned this well-formed service name as a replacement for 'bmc_patroldb'.",
	"_bmc_patroldb":                         "BMC_PATROLDB",
	"_pdps":                                 "Photoscript Distributed Printing System",
	"_els":                                  "E.L.S., Event Listener Service",
	"_exbit-escp":                           "Exbit-ESCP",
	"_vrts-ipcserver":                       "vrts-ipcserver",
	"_krb5gatekeeper":                       "krb5gatekeeper",
	"_amx-icsp":                             "AMX-ICSP",
	"_amx-axbnet":                           "AMX-AXBNET",
	"_novation":                             "Novation",
	"_brcd":                                 "brcd",
	"_delta-mcp":                            "delta-mcp",
	"_dx-instrument":                        "DX-Instrument",
	"_wimsic":                               "WIMSIC",
	"_ultrex":                               "Ultrex",
	"_ewall":                                "EWALL",
	"_netdb-export":                         "netdb-export",
	"_streetperfect":                        "StreetPerfect",
	"_intersan":                             "intersan",
	"_pcia-rxp-b":                           "PCIA RXP-B",
	"_passwrd-policy":                       "Password Policy",
	"_writesrv":                             "writesrv",
	"_digital-notary":                       "Digital Notary Protocol",
	"_ischat":                               "Instant Service Chat",
	"_menandmice-dns":                       "menandmice DNS",
	"_wmc-log-svc":                          "WMC-log-svr",
	"_kjtsiteserver":                        "kjtsiteserver",
	"_naap":                                 "NAAP",
	"_qubes":                                "QuBES",
	"_esbroker":                             "ESBroker",
	"_re101":                                "re101",
	"_icap":                                 "ICAP",
	"_vpjp":                                 "VPJP",
	"_alta-ana-lm":                          "Alta Analytics License Manager",
	"_bbn-mmc":                              "multi media conferencing",
	"_bbn-mmx":                              "multi media conferencing",
	"_sbook":                                "Registration Network Protocol",
	"_editbench":                            "Registration Network Protocol",
	"_equationbuilder":                      "Digital Tool Works (MIT)",
	"_lotusnote":                            "Lotus Note",
	"_relief":                               "Relief Consulting",
	"_xsip-network":                         "Five Across XSIP Network",
	"_intuitive-edge":                       "Intuitive Edge",
	"_cuillamartin":                         "CuillaMartin Company",
	"_pegboard":                             "Electronic PegBoard",
	"_connlcli":                             "CONNLCLI",
	"_ftsrv":                                "FTSRV",
	"_mimer":                                "MIMER",
	"_linx":                                 "LinX",
	"_timeflies":                            "TimeFlies",
	"_ndm-requester":                        "Network DataMover Requester",
	"_ndm-server":                           "Network DataMover Server",
	"_adapt-sna":                            "Network Software Associates",
	"_netware-csp":                          "Novell NetWare Comm Service Platform",
	"_dcs":                                  "DCS",
	"_screencast":                           "ScreenCast",
	"_gv-us":                                "GlobalView to Unix Shell",
	"_us-gv":                                "Unix Shell to GlobalView",
	"_fc-cli":                               "Fujitsu Config Protocol",
	"_fc-ser":                               "Fujitsu Config Protocol",
	"_chromagrafx":                          "Chromagrafx",
	"_molly":                                "EPI Software Systems",
	"_bytex":                                "Bytex",
	"_ibm-pps":                              "IBM Person to Person Software",
	"_cichlid":                              "Cichlid License Manager",
	"_elan":                                 "Elan License Manager",
	"_dbreporter":                           "Integrity Solutions",
	"_telesis-licman":                       "Telesis Network License Manager",
	"_apple-licman":                         "Apple Network License Manager",
	"_udt-os":                               "udt_os IANA assigned this well-formed service name as a replacement for 'udt_os'.",
	"_udt_os":                               "udt_os",
	"_gwha":                                 "GW Hannaway Network License Manager",
	"_os-licman":                            "Objective Solutions License Manager",
	"_atex-elmd":                            "Atex Publishing License Manager IANA assigned this well-formed service name as a replacement for 'atex_elmd'.",
	"_atex_elmd":                            "Atex Publishing License Manager",
	"_checksum":                             "CheckSum License Manager",
	"_cadsi-lm":                             "Computer Aided Design Software Inc LM",
	"_objective-dbc":                        "Objective Solutions DataBase Cache",
	"_iclpv-dm":                             "Document Manager",
	"_iclpv-sc":                             "Storage Controller",
	"_iclpv-sas":                            "Storage Access Server",
	"_iclpv-pm":                             "Print Manager",
	"_iclpv-nls":                            "Network Log Server",
	"_iclpv-nlc":                            "Network Log Client",
	"_iclpv-wsm":                            "PC Workstation Manager software",
	"_dvl-activemail":                       "DVL Active Mail",
	"_audio-activmail":                      "Audio Active Mail",
	"_video-activmail":                      "Video Active Mail",
	"_cadkey-licman":                        "Cadkey License Manager",
	"_cadkey-tablet":                        "Cadkey Tablet Daemon",
	"_goldleaf-licman":                      "Goldleaf License Manager",
	"_prm-sm-np":                            "Prospero Resource Manager",
	"_prm-nm-np":                            "Prospero Resource Manager",
	"_igi-lm":                               "Infinite Graphics License Manager",
	"_ibm-res":                              "IBM Remote Execution Starter",
	"_netlabs-lm":                           "NetLabs License Manager",
	"_tibet-server":                         "TIBET Data Server",
	"_sophia-lm":                            "Sophia License Manager",
	"_here-lm":                              "Here License Manager",
	"_hiq":                                  "HiQ License Manager",
	"_af":                                   "AudioFile",
	"_innosys":                              "InnoSys",
	"_innosys-acl":                          "Innosys-ACL",
	"_ibm-mqseries":                         "IBM MQSeries",
	"_dbstar":                               "DBStar",
	"_novell-lu6-2":                         "Novell LU6.2 IANA assigned this well-formed service name as a replacement for 'novell-lu6.2'.",
	"_novell-lu6.2":                         "Novell LU6.2",
	"_timbuktu-srv1":                        "Timbuktu Service 1 Port",
	"_timbuktu-srv2":                        "Timbuktu Service 2 Port",
	"_timbuktu-srv3":                        "Timbuktu Service 3 Port",
	"_timbuktu-srv4":                        "Timbuktu Service 4 Port",
	"_gandalf-lm":                           "Gandalf License Manager",
	"_autodesk-lm":                          "Autodesk License Manager",
	"_essbase":                              "Essbase Arbor Software",
	"_hybrid":                               "Hybrid Encryption Protocol",
	"_zion-lm":                              "Zion Software License Manager",
	"_sais":                                 "Satellite-data Acquisition System 1",
	"_mloadd":                               "mloadd monitoring tool",
	"_informatik-lm":                        "Informatik License Manager",
	"_nms":                                  "Hypercom NMS",
	"_tpdu":                                 "Hypercom TPDU",
	"_rgtp":                                 "Reverse Gossip Transport",
	"_blueberry-lm":                         "Blueberry Software License Manager",
	"_ms-sql-s":                             "Microsoft-SQL-Server",
	"_ms-sql-m":                             "Microsoft-SQL-Monitor",
	"_ibm-cics":                             "IBM CICS",
	"_saism":                                "Satellite-data Acquisition System 2",
	"_tabula":                               "Tabula",
	"_eicon-server":                         "Eicon Security Agent/Server",
	"_eicon-x25":                            "Eicon X25/SNA Gateway",
	"_eicon-slp":                            "Eicon Service Location Protocol",
	"_cadis-1":                              "Cadis License Management",
	"_cadis-2":                              "Cadis License Management",
	"_ies-lm":                               "Integrated Engineering Software",
	"_marcam-lm":                            "Marcam  License Management",
	"_proxima-lm":                           "Proxima License Manager",
	"_ora-lm":                               "Optical Research Associates License Manager",
	"_apri-lm":                              "Applied Parallel Research LM",
	"_oc-lm":                                "OpenConnect License Manager",
	"_peport":                               "PEport",
	"_dwf":                                  "Tandem Distributed Workbench Facility",
	"_infoman":                              "IBM Information Management",
	"_gtegsc-lm":                            "GTE Government Systems License Man",
	"_genie-lm":                             "Genie License Manager",
	"_interhdl-elmd":                        "interHDL License Manager IANA assigned this well-formed service name as a replacement for 'interhdl_elmd'.",
	"_interhdl_elmd":                        "interHDL License Manager",
	"_esl-lm":                               "ESL License Manager",
	"_dca":                                  "DCA",
	"_valisys-lm":                           "Valisys License Manager",
	"_nrcabq-lm":                            "Nichols Research Corp.",
	"_proshare1":                            "Proshare Notebook Application",
	"_proshare2":                            "Proshare Notebook Application",
	"_ibm-wrless-lan":                       "IBM Wireless LAN IANA assigned this well-formed service name as a replacement for 'ibm_wrless_lan'.",
	"_ibm_wrless_lan":                       "IBM Wireless LAN",
	"_world-lm":                             "World License Manager",
	"_nucleus":                              "Nucleus",
	"_msl-lmd":                              "MSL License Manager IANA assigned this well-formed service name as a replacement for 'msl_lmd'.",
	"_msl_lmd":                              "MSL License Manager",
	"_pipes":                                "Pipes Platform",
	"_oceansoft-lm":                         "Ocean Software License Manager",
	"_csdmbase":                             "CSDMBASE",
	"_csdm":                                 "CSDM",
	"_aal-lm":                               "Active Analysis Limited License Manager",
	"_uaiact":                               "Universal Analytics",
	"_openmath":                             "OpenMath",
	"_telefinder":                           "Telefinder",
	"_taligent-lm":                          "Taligent License Manager",
	"_clvm-cfg":                             "clvm-cfg",
	"_ms-sna-server":                        "ms-sna-server",
	"_ms-sna-base":                          "ms-sna-base",
	"_dberegister":                          "dberegister",
	"_pacerforum":                           "PacerForum",
	"_airs":                                 "AIRS",
	"_miteksys-lm":                          "Miteksys License Manager",
	"_afs":                                  "AFS License Manager",
	"_confluent":                            "Confluent License Manager",
	"_lansource":                            "LANSource",
	"_nms-topo-serv":                        "nms_topo_serv IANA assigned this well-formed service name as a replacement for 'nms_topo_serv'.",
	"_nms_topo_serv":                        "nms_topo_serv",
	"_localinfosrvr":                        "LocalInfoSrvr",
	"_docstor":                              "DocStor",
	"_dmdocbroker":                          "dmdocbroker",
	"_insitu-conf":                          "insitu-conf",
	"_stone-design-1":                       "stone-design-1",
	"_netmap-lm":                            "netmap_lm IANA assigned this well-formed service name as a replacement for 'netmap_lm'.",
	"_netmap_lm":                            "netmap_lm",
	"_ica":                                  "ica",
	"_cvc":                                  "cvc",
	"_liberty-lm":                           "liberty-lm",
	"_rfx-lm":                               "rfx-lm",
	"_sybase-sqlany":                        "Sybase SQL Any",
	"_fhc":                                  "Federico Heinz Consultora",
	"_vlsi-lm":                              "VLSI License Manager",
	"_saiscm":                               "Satellite-data Acquisition System 3",
	"_shivadiscovery":                       "Shiva",
	"_imtc-mcs":                             "Databeam",
	"_evb-elm":                              "EVB Software Engineering License Manager",
	"_funkproxy":                            "Funk Software, Inc.",
	"_utcd":                                 "Universal Time daemon (utcd)",
	"_symplex":                              "symplex",
	"_diagmond":                             "diagmond",
	"_robcad-lm":                            "Robcad, Ltd. License Manager",
	"_mvx-lm":                               "Midland Valley Exploration Ltd. Lic. Man.",
	"_3l-l1":                                "3l-l1",
	"_wins":                                 "Microsoft's Windows Internet Name Service",
	"_fujitsu-dtc":                          "Fujitsu Systems Business of America, Inc",
	"_fujitsu-dtcns":                        "Fujitsu Systems Business of America, Inc",
	"_ifor-protocol":                        "ifor-protocol",
	"_vpad":                                 "Virtual Places Audio data",
	"_vpac":                                 "Virtual Places Audio control",
	"_vpvd":                                 "Virtual Places Video data",
	"_vpvc":                                 "Virtual Places Video control",
	"_atm-zip-office":                       "atm zip office",
	"_ncube-lm":                             "nCube License Manager",
	"_ricardo-lm":                           "Ricardo North America License Manager",
	"_cichild-lm":                           "cichild",
	"_ingreslock":                           "ingres",
	"_orasrv":                               "oracle",
	"_prospero-np":                          "Prospero Directory Service non-priv",
	"_pdap-np":                              "Prospero Data Access Prot non-priv",
	"_tlisrv":                               "oracle",
	"_norp":                                 "Not Only a Routeing Protocol",
	"_coauthor":                             "oracle",
	"_rap-service":                          "rap-service",
	"_rap-listen":                           "rap-listen",
	"_miroconnect":                          "miroconnect",
	"_virtual-places":                       "Virtual Places Software",
	"_micromuse-lm":                         "micromuse-lm",
	"_ampr-info":                            "ampr-info",
	"_ampr-inter":                           "ampr-inter",
	"_sdsc-lm":                              "isi-lm",
	"_3ds-lm":                               "3ds-lm",
	"_intellistor-lm":                       "Intellistor License Manager",
	"_rds":                                  "rds",
	"_rds2":                                 "rds2",
	"_gridgen-elmd":                         "gridgen-elmd",
	"_simba-cs":                             "simba-cs",
	"_aspeclmd":                             "aspeclmd",
	"_vistium-share":                        "vistium-share",
	"_abbaccuray":                           "abbaccuray",
	"_laplink":                              "laplink",
	"_axon-lm":                              "Axon License Manager",
	"_shivahose":                            "Shiva Hose",
	"_shivasound":                           "Shiva Sound",
	"_3m-image-lm":                          "Image Storage license manager 3M Company",
	"_hecmtl-db":                            "HECMTL-DB",
	"_pciarray":                             "pciarray",
	"_sna-cs":                               "sna-cs",
	"_caci-lm":                              "CACI Products Company License Manager",
	"_livelan":                              "livelan",
	"_veritas-pbx":                          "VERITAS Private Branch Exchange IANA assigned this well-formed service name as a replacement for 'veritas_pbx'.",
	"_veritas_pbx":                          "VERITAS Private Branch Exchange",
	"_arbortext-lm":                         "ArborText License Manager",
	"_xingmpeg":                             "xingmpeg",
	"_web2host":                             "web2host",
	"_asci-val":                             "ASCI-RemoteSHADOW",
	"_facilityview":                         "facilityview",
	"_pconnectmgr":                          "pconnectmgr",
	"_cadabra-lm":                           "Cadabra License Manager",
	"_pay-per-view":                         "Pay-Per-View",
	"_winddlb":                              "WinDD",
	"_corelvideo":                           "CORELVIDEO",
	"_jlicelmd":                             "jlicelmd",
	"_tsspmap":                              "tsspmap",
	"_ets":                                  "ets",
	"_orbixd":                               "orbixd",
	"_rdb-dbs-disp":                         "Oracle Remote Data Base",
	"_chip-lm":                              "Chipcom License Manager",
	"_itscomm-ns":                           "itscomm-ns",
	"_mvel-lm":                              "mvel-lm",
	"_oraclenames":                          "oraclenames",
	"_moldflow-lm":                          "Moldflow License Manager",
	"_hypercube-lm":                         "hypercube-lm",
	"_jacobus-lm":                           "Jacobus License Manager",
	"_ioc-sea-lm":                           "ioc-sea-lm",
	"_tn-tl-r1":                             "tn-tl-r1",
	"_tn-tl-r2":                             "tn-tl-r2",
	"_mil-2045-47001":                       "MIL-2045-47001",
	"_msims":                                "MSIMS",
	"_simbaexpress":                         "simbaexpress",
	"_tn-tl-fd2":                            "tn-tl-fd2",
	"_intv":                                 "intv",
	"_ibm-abtact":                           "ibm-abtact",
	"_pra-elmd":                             "pra_elmd IANA assigned this well-formed service name as a replacement for 'pra_elmd'.",
	"_pra_elmd":                             "pra_elmd",
	"_triquest-lm":                          "triquest-lm",
	"_vqp":                                  "VQP",
	"_gemini-lm":                            "gemini-lm",
	"_ncpm-pm":                              "ncpm-pm",
	"_commonspace":                          "commonspace",
	"_mainsoft-lm":                          "mainsoft-lm",
	"_sixtrak":                              "sixtrak",
	"_radio":                                "radio",
	"_radio-sm":                             "radio-sm",
	"_radio-bc":                             "radio-bc",
	"_orbplus-iiop":                         "orbplus-iiop",
	"_picknfs":                              "picknfs",
	"_simbaservices":                        "simbaservices",
	"_issd":                                 "issd",
	"_aas":                                  "aas",
	"_inspect":                              "inspect",
	"_picodbc":                              "pickodbc",
	"_icabrowser":                           "icabrowser",
	"_slp":                                  "Salutation Manager (Salutation Protocol)",
	"_slm-api":                              "Salutation Manager (SLM-API)",
	"_stt":                                  "stt",
	"_smart-lm":                             "Smart Corp. License Manager",
	"_isysg-lm":                             "isysg-lm",
	"_taurus-wh":                            "taurus-wh",
	"_ill":                                  "Inter Library Loan",
	"_netbill-trans":                        "NetBill Transaction Server",
	"_netbill-keyrep":                       "NetBill Key Repository",
	"_netbill-cred":                         "NetBill Credential Server",
	"_netbill-auth":                         "NetBill Authorization Server",
	"_netbill-prod":                         "NetBill Product Server",
	"_nimrod-agent":                         "Nimrod Inter-Agent Communication",
	"_skytelnet":                            "skytelnet",
	"_xs-openstorage":                       "xs-openstorage",
	"_faxportwinport":                       "faxportwinport",
	"_softdataphone":                        "softdataphone",
	"_ontime":                               "ontime",
	"_jaleosnd":                             "jaleosnd",
	"_udp-sr-port":                          "udp-sr-port",
	"_svs-omagent":                          "svs-omagent",
	"_shockwave":                            "Shockwave",
	"_t128-gateway":                         "T.128 Gateway",
	"_lontalk-norm":                         "LonTalk normal",
	"_lontalk-urgnt":                        "LonTalk urgent",
	"_oraclenet8cman":                       "Oracle Net8 Cman",
	"_visitview":                            "Visit view",
	"_pammratc":                             "PAMMRATC",
	"_pammrpc":                              "PAMMRPC",
	"_loaprobe":                             "Log On America Probe",
	"_edb-server1":                          "EDB Server 1",
	"_isdc":                                 "ISP shared public data control",
	"_islc":                                 "ISP shared local data control",
	"_ismc":                                 "ISP shared management control",
	"_cert-initiator":                       "cert-initiator",
	"_cert-responder":                       "cert-responder",
	"_invision":                             "InVision",
	"_isis-am":                              "isis-am",
	"_isis-ambc":                            "isis-ambc",
	"_saiseh":                               "Satellite-data Acquisition System 4",
	"_sightline":                            "SightLine",
	"_sa-msg-port":                          "sa-msg-port",
	"_rsap":                                 "rsap",
	"_concurrent-lm":                        "concurrent-lm",
	"_kermit":                               "kermit",
	"_nkd":                                  "nkdn",
	"_shiva-confsrvr":                       "shiva_confsrvr IANA assigned this well-formed service name as a replacement for 'shiva_confsrvr'.",
	"_shiva_confsrvr":                       "shiva_confsrvr",
	"_xnmp":                                 "xnmp",
	"_alphatech-lm":                         "alphatech-lm",
	"_stargatealerts":                       "stargatealerts",
	"_dec-mbadmin":                          "dec-mbadmin",
	"_dec-mbadmin-h":                        "dec-mbadmin-h",
	"_fujitsu-mmpdc":                        "fujitsu-mmpdc",
	"_sixnetudr":                            "sixnetudr",
	"_sg-lm":                                "Silicon Grail License Manager",
	"_skip-mc-gikreq":                       "skip-mc-gikreq",
	"_netview-aix-1":                        "netview-aix-1",
	"_netview-aix-2":                        "netview-aix-2",
	"_netview-aix-3":                        "netview-aix-3",
	"_netview-aix-4":                        "netview-aix-4",
	"_netview-aix-5":                        "netview-aix-5",
	"_netview-aix-6":                        "netview-aix-6",
	"_netview-aix-7":                        "netview-aix-7",
	"_netview-aix-8":                        "netview-aix-8",
	"_netview-aix-9":                        "netview-aix-9",
	"_netview-aix-10":                       "netview-aix-10",
	"_netview-aix-11":                       "netview-aix-11",
	"_netview-aix-12":                       "netview-aix-12",
	"_proshare-mc-1":                        "Intel Proshare Multicast",
	"_proshare-mc-2":                        "Intel Proshare Multicast",
	"_pdp":                                  "Pacific Data Products",
	"_netcomm1":                             "netcomm1",
	"_netcomm2":                             "netcomm2",
	"_groupwise":                            "groupwise",
	"_prolink":                              "prolink",
	"_darcorp-lm":                           "darcorp-lm",
	"_microcom-sbp":                         "microcom-sbp",
	"_sd-elmd":                              "sd-elmd",
	"_lanyon-lantern":                       "lanyon-lantern",
	"_ncpm-hip":                             "ncpm-hip",
	"_snaresecure":                          "SnareSecure",
	"_n2nremote":                            "n2nremote",
	"_cvmon":                                "cvmon",
	"_nsjtp-ctrl":                           "nsjtp-ctrl",
	"_nsjtp-data":                           "nsjtp-data",
	"_firefox":                              "firefox",
	"_ng-umds":                              "ng-umds",
	"_empire-empuma":                        "empire-empuma",
	"_sstsys-lm":                            "sstsys-lm",
	"_rrirtr":                               "rrirtr",
	"_rrimwm":                               "rrimwm",
	"_rrilwm":                               "rrilwm",
	"_rrifmm":                               "rrifmm",
	"_rrisat":                               "rrisat",
	"_rsvp-encap-1":                         "RSVP-ENCAPSULATION-1",
	"_rsvp-encap-2":                         "RSVP-ENCAPSULATION-2",
	"_mps-raft":                             "mps-raft",
	"_l2f":                                  "l2f",
	"_l2tp":                                 "l2tp",
	"_deskshare":                            "deskshare",
	"_hb-engine":                            "hb-engine",
	"_bcs-broker":                           "bcs-broker",
	"_slingshot":                            "slingshot",
	"_jetform":                              "jetform",
	"_vdmplay":                              "vdmplay",
	"_gat-lmd":                              "gat-lmd",
	"_centra":                               "centra",
	"_impera":                               "impera",
	"_pptconference":                        "pptconference",
	"_registrar":                            "resource monitoring service",
	"_conferencetalk":                       "ConferenceTalk",
	"_sesi-lm":                              "sesi-lm",
	"_houdini-lm":                           "houdini-lm",
	"_xmsg":                                 "xmsg",
	"_fj-hdnet":                             "fj-hdnet",
	"_h323gatedisc":                         "H.323 Multicast Gatekeeper Discover",
	"_h323gatestat":                         "H.323 Unicast Gatekeeper Signaling",
	"_h323hostcall":                         "H.323 Call Control Signalling",
	"_caicci":                               "caicci",
	"_hks-lm":                               "HKS License Manager",
	"_pptp":                                 "pptp",
	"_csbphonemaster":                       "csbphonemaster",
	"_iden-ralp":                            "iden-ralp",
	"_iberiagames":                          "IBERIAGAMES",
	"_winddx":                               "winddx",
	"_telindus":                             "TELINDUS",
	"_citynl":                               "CityNL License Management",
	"_roketz":                               "roketz",
	"_msiccp":                               "MSICCP",
	"_proxim":                               "proxim",
	"_siipat":                               "SIMS - SIIPAT Protocol for Alarm Transmission",
	"_cambertx-lm":                          "Camber Corporation License Management",
	"_privatechat":                          "PrivateChat",
	"_street-stream":                        "street-stream",
	"_ultimad":                              "ultimad",
	"_gamegen1":                             "GameGen1",
	"_webaccess":                            "webaccess",
	"_encore":                               "encore",
	"_cisco-net-mgmt":                       "cisco-net-mgmt",
	"_3com-nsd":                             "3Com-nsd",
	"_cinegrfx-lm":                          "Cinema Graphics License Manager",
	"_ncpm-ft":                              "ncpm-ft",
	"_remote-winsock":                       "remote-winsock",
	"_ftrapid-1":                            "ftrapid-1",
	"_ftrapid-2":                            "ftrapid-2",
	"_oracle-em1":                           "oracle-em1",
	"_aspen-services":                       "aspen-services",
	"_sslp":                                 "Simple Socket Library's PortMaster",
	"_swiftnet":                             "SwiftNet",
	"_lofr-lm":                              "Leap of Faith Research License Manager",
	"_predatar-comms":                       "Predatar Comms Service",
	"_oracle-em2":                           "oracle-em2",
	"_ms-streaming":                         "ms-streaming",
	"_capfast-lmd":                          "capfast-lmd",
	"_cnhrp":                                "cnhrp",
	"_tftp-mcast":                           "tftp-mcast",
	"_spss-lm":                              "SPSS License Manager",
	"_www-ldap-gw":                          "www-ldap-gw",
	"_cft-0":                                "cft-0",
	"_cft-1":                                "cft-1",
	"_cft-2":                                "cft-2",
	"_cft-3":                                "cft-3",
	"_cft-4":                                "cft-4",
	"_cft-5":                                "cft-5",
	"_cft-6":                                "cft-6",
	"_cft-7":                                "cft-7",
	"_bmc-net-adm":                          "bmc-net-adm",
	"_bmc-net-svc":                          "bmc-net-svc",
	"_vaultbase":                            "vaultbase",
	"_essweb-gw":                            "EssWeb Gateway",
	"_kmscontrol":                           "KMSControl",
	"_global-dtserv":                        "global-dtserv",
	"_vdab":                                 "data interchange between visual processing containers",
	"_femis":                                "Federal Emergency Management Information System",
	"_powerguardian":                        "powerguardian",
	"_prodigy-intrnet":                      "prodigy-internet",
	"_pharmasoft":                           "pharmasoft",
	"_dpkeyserv":                            "dpkeyserv",
	"_answersoft-lm":                        "answersoft-lm",
	"_hp-hcip":                              "hp-hcip",
	"_finle-lm":                             "Finle License Manager",
	"_windlm":                               "Wind River Systems License Manager",
	"_funk-logger":                          "funk-logger",
	"_funk-license":                         "funk-license",
	"_psmond":                               "psmond",
	"_hello":                                "hello",
	"_ea1":                                  "EA1",
	"_ibm-dt-2":                             "ibm-dt-2",
	"_rsc-robot":                            "rsc-robot",
	"_cera-bcm":                             "cera-bcm",
	"_dpi-proxy":                            "dpi-proxy",
	"_vocaltec-admin":                       "Vocaltec Server Administration",
	"_etp":                                  "Event Transfer Protocol",
	"_netrisk":                              "NETRISK",
	"_ansys-lm":                             "ANSYS-License manager",
	"_msmq":                                 "Microsoft Message Que",
	"_concomp1":                             "ConComp1",
	"_hp-hcip-gwy":                          "HP-HCIP-GWY",
	"_enl":                                  "ENL",
	"_enl-name":                             "ENL-Name",
	"_musiconline":                          "Musiconline",
	"_fhsp":                                 "Fujitsu Hot Standby Protocol",
	"_oracle-vp2":                           "Oracle-VP2",
	"_oracle-vp1":                           "Oracle-VP1",
	"_jerand-lm":                            "Jerand License Manager",
	"_scientia-sdb":                         "Scientia-SDB",
	"_radius":                               "RADIUS",
	"_radius-acct":                          "RADIUS Accounting",
	"_tdp-suite":                            "TDP Suite",
	"_mmpft":                                "Manufacturing messaging protocol for factory transmission",
	"_harp":                                 "HARP",
	"_rkb-oscs":                             "RKB-OSCS",
	"_etftp":                                "Enhanced Trivial File Transfer Protocol",
	"_plato-lm":                             "Plato License Manager",
	"_mcagent":                              "mcagent",
	"_donnyworld":                           "donnyworld",
	"_es-elmd":                              "es-elmd",
	"_unisys-lm":                            "Unisys Natural Language License Manager",
	"_metrics-pas":                          "metrics-pas",
	"_direcpc-video":                        "DirecPC Video",
	"_ardt":                                 "ARDT",
	"_asi":                                  "ASI",
	"_itm-mcell-u":                          "itm-mcell-u",
	"_optika-emedia":                        "Optika eMedia",
	"_net8-cman":                            "Oracle Net8 CMan Admin",
	"_myrtle":                               "Myrtle",
	"_tht-treasure":                         "ThoughtTreasure",
	"_udpradio":                             "udpradio",
	"_ardusuni":                             "ARDUS Unicast",
	"_ardusmul":                             "ARDUS Multicast",
	"_ste-smsc":                             "ste-smsc",
	"_csoft1":                               "csoft1",
	"_talnet":                               "TALNET",
	"_netopia-vo1":                          "netopia-vo1",
	"_netopia-vo2":                          "netopia-vo2",
	"_netopia-vo3":                          "netopia-vo3",
	"_netopia-vo4":                          "netopia-vo4",
	"_netopia-vo5":                          "netopia-vo5",
	"_direcpc-dll":                          "DirecPC-DLL",
	"_altalink":                             "altalink",
	"_tunstall-pnc":                         "Tunstall PNC",
	"_slp-notify":                           "SLP Notification",
	"_fjdocdist":                            "fjdocdist",
	"_alpha-sms":                            "ALPHA-SMS",
	"_gsi":                                  "GSI",
	"_ctcd":                                 "ctcd",
	"_virtual-time":                         "Virtual Time",
	"_vids-avtp":                            "VIDS-AVTP",
	"_buddy-draw":                           "Buddy Draw",
	"_fiorano-rtrsvc":                       "Fiorano RtrSvc",
	"_fiorano-msgsvc":                       "Fiorano MsgSvc",
	"_datacaptor":                           "DataCaptor",
	"_privateark":                           "PrivateArk",
	"_gammafetchsvr":                        "Gamma Fetcher Server",
	"_sunscalar-svc":                        "SunSCALAR Services",
	"_lecroy-vicp":                          "LeCroy VICP",
	"_mysql-cm-agent":                       "MySQL Cluster Manager Agent",
	"_msnp":                                 "MSNP",
	"_paradym-31port":                       "Paradym 31 Port",
	"_entp":                                 "ENTP",
	"_swrmi":                                "swrmi",
	"_udrive":                               "UDRIVE",
	"_viziblebrowser":                       "VizibleBrowser",
	"_transact":                             "TransAct",
	"_sunscalar-dns":                        "SunSCALAR DNS Service",
	"_canocentral0":                         "Cano Central 0",
	"_canocentral1":                         "Cano Central 1",
	"_fjmpjps":                              "Fjmpjps",
	"_fjswapsnp":                            "Fjswapsnp",
	"_westell-stats":                        "westell stats",
	"_ewcappsrv":                            "ewcappsrv",
	"_hp-webqosdb":                          "hp-webqosdb",
	"_drmsmc":                               "drmsmc",
	"_nettgain-nms":                         "NettGain NMS",
	"_vsat-control":                         "Gilat VSAT Control",
	"_ibm-mqseries2":                        "IBM WebSphere MQ Everyplace",
	"_ecsqdmn":                              "CA eTrust Common Services",
	"_mqtt":                                 "Message Queuing Telemetry Transport Protocol",
	"_idmaps":                               "Internet Distance Map Svc",
	"_vrtstrapserver":                       "Veritas Trap Server",
	"_leoip":                                "Leonardo over IP",
	"_filex-lport":                          "FileX Listening Port",
	"_ncconfig":                             "NC Config Port",
	"_unify-adapter":                        "Unify Web Adapter Service",
	"_wilkenlistener":                       "wilkenListener",
	"_childkey-notif":                       "ChildKey Notification",
	"_childkey-ctrl":                        "ChildKey Control",
	"_elad":                                 "ELAD Protocol",
	"_o2server-port":                        "O2Server Port",
	"_b-novative-ls":                        "b-novative license server",
	"_metaagent":                            "MetaAgent",
	"_cymtec-port":                          "Cymtec secure management",
	"_mc2studios":                           "MC2Studios",
	"_ssdp":                                 "SSDP",
	"_fjicl-tep-a":                          "Fujitsu ICL Terminal Emulator Program A",
	"_fjicl-tep-b":                          "Fujitsu ICL Terminal Emulator Program B",
	"_linkname":                             "Local Link Name Resolution",
	"_fjicl-tep-c":                          "Fujitsu ICL Terminal Emulator Program C",
	"_sugp":                                 "Secure UP.Link Gateway Protocol",
	"_tpmd":                                 "TPortMapperReq",
	"_intrastar":                            "IntraSTAR",
	"_dawn":                                 "Dawn",
	"_global-wlink":                         "Global World Link",
	"_ultrabac":                             "UltraBac Software communications port",
	"_mtp":                                  "Starlight Networks Multimedia Transport Protocol",
	"_rhp-iibp":                             "rhp-iibp",
	"_armadp":                               "armadp",
	"_elm-momentum":                         "Elm-Momentum",
	"_facelink":                             "FACELINK",
	"_persona":                              "Persoft Persona",
	"_noagent":                              "nOAgent",
	"_can-nds":                              "IBM Tivole Directory Service - NDS",
	"_can-dch":                              "IBM Tivoli Directory Service - DCH",
	"_can-ferret":                           "IBM Tivoli Directory Service - FERRET",
	"_noadmin":                              "NoAdmin",
	"_tapestry":                             "Tapestry",
	"_spice":                                "SPICE",
	"_xiip":                                 "XIIP",
	"_discovery-port":                       "Surrogate Discovery Port",
	"_egs":                                  "Evolution Game Server",
	"_videte-cipc":                          "Videte CIPC Port",
	"_emsd-port":                            "Expnd Maui Srvr Dscovr",
	"_bandwiz-system":                       "Bandwiz System - Server",
	"_driveappserver":                       "Drive AppServer",
	"_amdsched":                             "AMD SCHED",
	"_ctt-broker":                           "CTT Broker",
	"_xmapi":                                "IBM LM MT Agent",
	"_xaapi":                                "IBM LM Appl Agent",
	"_macromedia-fcs":                       "Macromedia Flash Communications Server MX",
	"_jetcmeserver":                         "JetCmeServer Server Port",
	"_jwserver":                             "JetVWay Server Port",
	"_jwclient":                             "JetVWay Client Port",
	"_jvserver":                             "JetVision Server Port",
	"_jvclient":                             "JetVision Client Port",
	"_dic-aida":                             "DIC-Aida",
	"_res":                                  "Real Enterprise Service",
	"_beeyond-media":                        "Beeyond Media",
	"_close-combat":                         "close-combat",
	"_dialogic-elmd":                        "dialogic-elmd",
	"_tekpls":                               "tekpls",
	"_sentinelsrm":                          "SentinelSRM",
	"_eye2eye":                              "eye2eye",
	"_ismaeasdaqlive":                       "ISMA Easdaq Live",
	"_ismaeasdaqtest":                       "ISMA Easdaq Test",
	"_bcs-lmserver":                         "bcs-lmserver",
	"_mpnjsc":                               "mpnjsc",
	"_rapidbase":                            "Rapid Base",
	"_abr-api":                              "ABR-API (diskbridge)",
	"_abr-secure":                           "ABR-Secure Data (diskbridge)",
	"_vrtl-vmf-ds":                          "Vertel VMF DS",
	"_unix-status":                          "unix-status",
	"_dxadmind":                             "CA Administration Daemon",
	"_simp-all":                             "SIMP Channel",
	"_nasmanager":                           "Merit DAC NASmanager",
	"_bts-appserver":                        "BTS APPSERVER",
	"_biap-mp":                              "BIAP-MP",
	"_webmachine":                           "WebMachine",
	"_solid-e-engine":                       "SOLID E ENGINE",
	"_tivoli-npm":                           "Tivoli NPM",
	"_slush":                                "Slush",
	"_sns-quote":                            "SNS Quote",
	"_lipsinc":                              "LIPSinc",
	"_lipsinc1":                             "LIPSinc 1",
	"_netop-rc":                             "NetOp Remote Control",
	"_netop-school":                         "NetOp School",
	"_intersys-cache":                       "Cache",
	"_dlsrap":                               "Data Link Switching Remote Access Protocol",
	"_drp":                                  "DRP",
	"_tcoflashagent":                        "TCO Flash Agent",
	"_tcoregagent":                          "TCO Reg Agent",
	"_tcoaddressbook":                       "TCO Address Book",
	"_unisql":                               "UniSQL",
	"_unisql-java":                          "UniSQL Java",
	"_pearldoc-xact":                        "PearlDoc XACT",
	"_p2pq":                                 "p2pQ",
	"_estamp":                               "Evidentiary Timestamp",
	"_lhtp":                                 "Loophole Test Protocol",
	"_bb":                                   "BB",
	"_hsrp":                                 "Hot Standby Router Protocol",
	"_licensedaemon":                        "cisco license management",
	"_tr-rsrb-p1":                           "cisco RSRB Priority 1 port",
	"_tr-rsrb-p2":                           "cisco RSRB Priority 2 port",
	"_tr-rsrb-p3":                           "cisco RSRB Priority 3 port",
	"_mshnet":                               "MHSnet system",
	"_stun-p1":                              "cisco STUN Priority 1 port",
	"_stun-p2":                              "cisco STUN Priority 2 port",
	"_stun-p3":                              "cisco STUN Priority 3 port",
	"_ipsendmsg":                            "IPsendmsg",
	"_snmp-tcp-port":                        "cisco SNMP TCP port",
	"_stun-port":                            "cisco serial tunnel port",
	"_perf-port":                            "cisco perf port",
	"_tr-rsrb-port":                         "cisco Remote SRB port",
	"_gdp-port":                             "cisco Gateway Discovery Protocol",
	"_x25-svc-port":                         "cisco X.25 service (XOT)",
	"_tcp-id-port":                          "cisco identification port",
	"_cisco-sccp":                           "Cisco SCCP",
	"_dc":                                   "",
	"_wizard":                               "curry",
	"_globe":                                "",
	"_brutus":                               "Brutus Server",
	"_mailbox":                              "",
	"_emce":                                 "CCWS mm conf",
	"_berknet":                              "",
	"_oracle":                               "",
	"_invokator":                            "",
	"_raid-cd":                              "raid",
	"_dectalk":                              "",
	"_raid-am":                              "",
	"_conf":                                 "",
	"_terminaldb":                           "",
	"_news":                                 "",
	"_whosockami":                           "",
	"_search":                               "",
	"_pipe-server":                          "IANA assigned this well-formed service name as a replacement for 'pipe_server'.",
	"_pipe_server":                          "",
	"_raid-cc":                              "raid",
	"_servserv":                             "",
	"_ttyinfo":                              "",
	"_raid-ac":                              "",
	"_troff":                                "",
	"_raid-sf":                              "",
	"_cypress":                              "",
	"_raid-cs":                              "",
	"_bootserver":                           "",
	"_cypress-stat":                         "",
	"_bootclient":                           "",
	"_rellpack":                             "",
	"_about":                                "",
	"_xinupageserver":                       "",
	"_servexec":                             "",
	"_xinuexpansion1":                       "",
	"_down":                                 "",
	"_xinuexpansion2":                       "",
	"_xinuexpansion3":                       "",
	"_xinuexpansion4":                       "",
	"_ellpack":                              "",
	"_xribs":                                "",
	"_scrabble":                             "",
	"_shadowserver":                         "",
	"_submitserver":                         "",
	"_hsrpv6":                               "Hot Standby Router Protocol IPv6",
	"_device2":                              "",
	"_mobrien-chat":                         "mobrien-chat",
	"_blackboard":                           "",
	"_glogger":                              "",
	"_scoremgr":                             "",
	"_imsldoc":                              "",
	"_e-dpnet":                              "Ethernet WS DP network",
	"_applus":                               "APplus Application Server",
	"_objectmanager":                        "",
	"_prizma":                               "Prizma Monitoring Service",
	"_lam":                                  "",
	"_interbase":                            "",
	"_isis":                                 "isis",
	"_isis-bcast":                           "isis-bcast",
	"_rimsl":                                "",
	"_cdfunc":                               "",
	"_sdfunc":                               "",
	"_dls-monitor":                          "",
	"_shilp":                                "",
	"_nfs":                                  "Network File System - Sun Microsystems",
	"_av-emb-config":                        "Avaya EMB Config Port",
	"_epnsdp":                               "EPNSDP",
	"_clearvisn":                            "clearVisn Services Port",
	"_lot105-ds-upd":                        "Lot105 DSuper Updates",
	"_weblogin":                             "Weblogin Port",
	"_iop":                                  "Iliad-Odyssey Protocol",
	"_omnisky":                              "OmniSky Port",
	"_rich-cp":                              "Rich Content Protocol",
	"_newwavesearch":                        "NewWaveSearchables RMI",
	"_bmc-messaging":                        "BMC Messaging Service",
	"_teleniumdaemon":                       "Telenium Daemon IF",
	"_netmount":                             "NetMount",
	"_icg-swp":                              "ICG SWP Port",
	"_icg-bridge":                           "ICG Bridge Port",
	"_icg-iprelay":                          "ICG IP Relay Port",
	"_dlsrpn":                               "Data Link Switch Read Port Number",
	"_aura":                                 "AVM USB Remote Architecture",
	"_dlswpn":                               "Data Link Switch Write Port Number",
	"_avauthsrvprtcl":                       "Avocent AuthSrv Protocol",
	"_event-port":                           "HTTP Event Port",
	"_ah-esp-encap":                         "AH and ESP Encapsulated in UDP packet",
	"_acp-port":                             "Axon Control Protocol",
	"_msync":                                "GlobeCast mSync",
	"_gxs-data-port":                        "DataReel Database Socket",
	"_vrtl-vmf-sa":                          "Vertel VMF SA",
	"_newlixengine":                         "Newlix ServerWare Engine",
	"_newlixconfig":                         "Newlix JSPConfig",
	"_tsrmagt":                              "Old Tivoli Storage Manager",
	"_tpcsrvr":                              "IBM Total Productivity Center Server",
	"_idware-router":                        "IDWARE Router Port",
	"_autodesk-nlm":                         "Autodesk NLM (FLEXlm)",
	"_kme-trap-port":                        "KME PRINTER TRAP PORT",
	"_infowave":                             "Infowave Mobility Server",
	"_radsec":                               "Secure Radius Service",
	"_sunclustergeo":                        "SunCluster Geographic",
	"_ada-cip":                              "ADA Control",
	"_gnunet":                               "GNUnet",
	"_eli":                                  "ELI - Event Logging Integration",
	"_ip-blf":                               "IP Busy Lamp Field",
	"_sep":                                  "Security Encapsulation Protocol - SEP",
	"_lrp":                                  "Load Report Protocol",
	"_prp":                                  "PRP",
	"_descent3":                             "Descent 3",
	"_nbx-cc":                               "NBX CC",
	"_nbx-au":                               "NBX AU",
	"_nbx-ser":                              "NBX SER",
	"_nbx-dir":                              "NBX DIR",
	"_jetformpreview":                       "Jet Form Preview",
	"_dialog-port":                          "Dialog Port",
	"_h2250-annex-g":                        "H.225.0 Annex G Signalling",
	"_amiganetfs":                           "Amiga Network Filesystem",
	"_rtcm-sc104":                           "rtcm-sc104",
	"_zephyr-srv":                           "Zephyr server",
	"_zephyr-clt":                           "Zephyr serv-hm connection",
	"_zephyr-hm":                            "Zephyr hostmanager",
	"_minipay":                              "MiniPay",
	"_mzap":                                 "MZAP",
	"_bintec-admin":                         "BinTec Admin",
	"_comcam":                               "Comcam",
	"_ergolight":                            "Ergolight",
	"_umsp":                                 "UMSP",
	"_dsatp":                                "OPNET Dynamic Sampling Agent Transaction Protocol",
	"_idonix-metanet":                       "Idonix MetaNet",
	"_hsl-storm":                            "HSL StoRM",
	"_ariascribe":                           "Classical Music Meta-Data Access and Enhancement",
	"_kdm":                                  "Key Distribution Manager",
	"_ccowcmr":                              "CCOWCMR",
	"_mentaclient":                          "MENTACLIENT",
	"_mentaserver":                          "MENTASERVER",
	"_gsigatekeeper":                        "GSIGATEKEEPER",
	"_qencp":                                "Quick Eagle Networks CP",
	"_scientia-ssdb":                        "SCIENTIA-SSDB",
	"_caupc-remote":                         "CauPC Remote Control",
	"_gtp-control":                          "GTP-Control Plane (3GPP)",
	"_elatelink":                            "ELATELINK",
	"_lockstep":                             "LOCKSTEP",
	"_pktcable-cops":                        "PktCable-COPS",
	"_index-pc-wb":                          "INDEX-PC-WB",
	"_net-steward":                          "Net Steward Control",
	"_cs-live":                              "cs-live.com",
	"_xds":                                  "XDS",
	"_avantageb2b":                          "Avantageb2b",
	"_solera-epmap":                         "SoleraTec End Point Map",
	"_zymed-zpp":                            "ZYMED-ZPP",
	"_avenue":                               "AVENUE",
	"_gris":                                 "Grid Resource Information Server",
	"_appworxsrv":                           "APPWORXSRV",
	"_connect":                              "CONNECT",
	"_unbind-cluster":                       "UNBIND-CLUSTER",
	"_ias-auth":                             "IAS-AUTH",
	"_ias-reg":                              "IAS-REG",
	"_ias-admind":                           "IAS-ADMIND",
	"_tdmoip":                               "TDM OVER IP",
	"_lv-jc":                                "Live Vault Job Control",
	"_lv-ffx":                               "Live Vault Fast Object Transfer",
	"_lv-pici":                              "Live Vault Remote Diagnostic Console Support",
	"_lv-not":                               "Live Vault Admin Event Notification",
	"_lv-auth":                              "Live Vault Authentication",
	"_veritas-ucl":                          "VERITAS UNIVERSAL COMMUNICATION LAYER",
	"_acptsys":                              "ACPTSYS",
	"_dynamic3d":                            "DYNAMIC3D",
	"_docent":                               "DOCENT",
	"_gtp-user":                             "GTP-User Plane (3GPP)",
	"_ctlptc":                               "Control Protocol",
	"_stdptc":                               "Standard Protocol",
	"_brdptc":                               "Bridge Protocol",
	"_trp":                                  "Talari Reliable Protocol",
	"_xnds":                                 "Xerox Network Document Scan Protocol",
	"_touchnetplus":                         "TouchNetPlus Service",
	"_gdbremote":                            "GDB Remote Debug Port",
	"_apc-2160":                             "APC 2160",
	"_apc-2161":                             "APC 2161",
	"_navisphere":                           "Navisphere",
	"_navisphere-sec":                       "Navisphere Secure",
	"_ddns-v3":                              "Dynamic DNS Version 3",
	"_x-bone-api":                           "X-Bone API",
	"_iwserver":                             "iwserver",
	"_raw-serial":                           "Raw Async Serial Link",
	"_easy-soft-mux":                        "easy-soft Multiplexer",
	"_brain":                                "Backbone for Academic Information Notification (BRAIN)",
	"_eyetv":                                "EyeTV Server Port",
	"_msfw-storage":                         "MS Firewall Storage",
	"_msfw-s-storage":                       "MS Firewall SecureStorage",
	"_msfw-replica":                         "MS Firewall Replication",
	"_msfw-array":                           "MS Firewall Intra Array",
	"_airsync":                              "Microsoft Desktop AirSync Protocol",
	"_rapi":                                 "Microsoft ActiveSync Remote API",
	"_qwave":                                "qWAVE Bandwidth Estimate",
	"_bitspeer":                             "Peer Services for BITS",
	"_vmrdp":                                "Microsoft RDP for virtual machines",
	"_mc-gt-srv":                            "Millicent Vendor Gateway Server",
	"_eforward":                             "eforward",
	"_cgn-stat":                             "CGN status",
	"_cgn-config":                           "Code Green configuration",
	"_nvd":                                  "NVD User",
	"_onbase-dds":                           "OnBase Distributed Disk Services",
	"_gtaua":                                "Guy-Tek Automated Update Applications",
	"_ssmc":                                 "Sepehr System Management Control",
	"_ssmd":                                 "Sepehr System Management Data",
	"_radware-rpm":                          "Radware Resource Pool Manager",
	"_radware-rpm-s":                        "Secure Radware Resource Pool Manager",
	"_tivoconnect":                          "TiVoConnect Beacon",
	"_tvbus":                                "TvBus Messaging",
	"_asdis":                                "ASDIS software management",
	"_drwcs":                                "Dr.Web Enterprise Management Service",
	"_mnp-exchange":                         "MNP data exchange",
	"_onehome-remote":                       "OneHome Remote Access",
	"_onehome-help":                         "OneHome Service Port",
	"_ats":                                  "Advanced Training System Program",
	"_imtc-map":                             "Int. Multimedia Teleconferencing Cosortium",
	"_b2-runtime":                           "b2 Runtime Protocol",
	"_b2-license":                           "b2 License Server",
	"_jps":                                  "Java Presentation Server",
	"_hpocbus":                              "HP OpenCall bus",
	"_hpssd":                                "HP Status and Services",
	"_hpiod":                                "HP I/O Backend",
	"_rimf-ps":                              "HP RIM for Files Portal Service",
	"_noaaport":                             "NOAAPORT Broadcast Network",
	"_emwin":                                "EMWIN",
	"_leecoposserver":                       "LeeCO POS Server Service",
	"_kali":                                 "Kali",
	"_rpi":                                  "RDQ Protocol Interface",
	"_ipcore":                               "IPCore.co.za GPRS",
	"_vtu-comms":                            "VTU data service",
	"_gotodevice":                           "GoToDevice Device Management",
	"_bounzza":                              "Bounzza IRC Proxy",
	"_netiq-ncap":                           "NetIQ NCAP Protocol",
	"_netiq":                                "NetIQ End2End",
	"_ethernet-ip-s":                        "EtherNet/IP over TLS",
	"_ethernet-ip-1":                        "EtherNet/IP I/O IANA assigned this well-formed service name as a replacement for 'EtherNet/IP-1'.",
	"_ethernet/ip-1":                        "EtherNet/IP I/O",
	"_rockwell-csp2":                        "Rockwell CSP2",
	"_efi-mg":                               "Easy Flexible Internet/Multiplayer Games",
	"_rcip-itu":                             "Resource Connection Initiation Protocol",
	"_di-drm":                               "Digital Instinct DRM",
	"_di-msg":                               "DI Messaging Service",
	"_ehome-ms":                             "eHome Message Server",
	"_datalens":                             "DataLens Service",
	"_queueadm":                             "MetaSoft Job Queue Administration Service",
	"_wimaxasncp":                           "WiMAX ASN Control Plane Protocol",
	"_ivs-video":                            "IVS Video default",
	"_infocrypt":                            "INFOCRYPT",
	"_directplay":                           "DirectPlay",
	"_sercomm-wlink":                        "Sercomm-WLink",
	"_nani":                                 "Nani",
	"_optech-port1-lm":                      "Optech Port1 License Manager",
	"_aviva-sna":                            "AVIVA SNA SERVER",
	"_imagequery":                           "Image Query",
	"_recipe":                               "RECIPe",
	"_ivsd":                                 "IVS Daemon",
	"_foliocorp":                            "Folio Remote Server",
	"_magicom":                              "Magicom Protocol",
	"_nmsserver":                            "NMS Server",
	"_hao":                                  "HaO",
	"_pc-mta-addrmap":                       "PacketCable MTA Addr Map",
	"_antidotemgrsvr":                       "Antidote Deployment Manager Service",
	"_ums":                                  "User Management Service",
	"_rfmp":                                 "RISO File Manager Protocol",
	"_remote-collab":                        "remote-collab",
	"_dif-port":                             "Distributed Framework Port",
	"_njenet-ssl":                           "NJENET using SSL",
	"_dtv-chan-req":                         "DTV Channel Request",
	"_seispoc":                              "Seismic P.O.C. Port",
	"_vrtp":                                 "VRTP - ViRtue Transfer Protocol",
	"_pcc-mfp":                              "PCC MFP",
	"_simple-tx-rx":                         "simple text/file transfer",
	"_rcts":                                 "Rotorcraft Communications Test System",
	"_bid-serv":                             "BIF identifiers resolution service",
	"_apc-2260":                             "APC 2260",
	"_comotionmaster":                       "CoMotion Master Server",
	"_comotionback":                         "CoMotion Backup Server",
	"_ecwcfg":                               "ECweb Configuration Service",
	"_apx500api-1":                          "Audio Precision Apx500 API Port 1",
	"_apx500api-2":                          "Audio Precision Apx500 API Port 2",
	"_mfserver":                             "M-Files Server",
	"_ontobroker":                           "OntoBroker",
	"_amt":                                  "AMT",
	"_mikey":                                "MIKEY",
	"_starschool":                           "starSchool",
	"_mmcals":                               "Secure Meeting Maker Scheduling",
	"_mmcal":                                "Meeting Maker Scheduling",
	"_mysql-im":                             "MySQL Instance Manager",
	"_pcttunnell":                           "PCTTunneller",
	"_ibridge-data":                         "iBridge Conferencing",
	"_ibridge-mgmt":                         "iBridge Management",
	"_bluectrlproxy":                        "Bt device control proxy",
	"_s3db":                                 "Simple Stacked Sequences Database",
	"_xmquery":                              "xmquery",
	"_lnvpoller":                            "LNVPOLLER",
	"_lnvconsole":                           "LNVCONSOLE",
	"_lnvalarm":                             "LNVALARM",
	"_lnvstatus":                            "LNVSTATUS",
	"_lnvmaps":                              "LNVMAPS",
	"_lnvmailmon":                           "LNVMAILMON",
	"_nas-metering":                         "NAS-Metering",
	"_dna":                                  "DNA",
	"_netml":                                "NETML",
	"_dict-lookup":                          "Lookup dict server",
	"_sonus-logging":                        "Sonus Logging Services",
	"_eapsp":                                "EPSON Advanced Printer Share Protocol",
	"_mib-streaming":                        "Sonus Element Management Services",
	"_npdbgmngr":                            "Network Platform Debug Manager",
	"_konshus-lm":                           "Konshus License Manager (FLEX)",
	"_advant-lm":                            "Advant License Manager",
	"_theta-lm":                             "Theta License Manager (Rainbow)",
	"_d2k-datamover1":                       "D2K DataMover 1",
	"_d2k-datamover2":                       "D2K DataMover 2",
	"_pc-telecommute":                       "PC Telecommute",
	"_cvmmon":                               "CVMMON",
	"_cpq-wbem":                             "Compaq HTTP",
	"_binderysupport":                       "Bindery Support",
	"_proxy-gateway":                        "Proxy Gateway",
	"_attachmate-uts":                       "Attachmate UTS",
	"_mt-scaleserver":                       "MT ScaleServer",
	"_tappi-boxnet":                         "TAPPI BoxNet",
	"_pehelp":                               "pehelp",
	"_sdhelp":                               "sdhelp",
	"_sdserver":                             "SD Server",
	"_sdclient":                             "SD Client",
	"_messageservice":                       "Message Service",
	"_wanscaler":                            "WANScaler Communication Service",
	"_iapp":                                 "IAPP (Inter Access Point Protocol)",
	"_cr-websystems":                        "CR WebSystems",
	"_precise-sft":                          "Precise Sft.",
	"_sent-lm":                              "SENT License Manager",
	"_attachmate-g32":                       "Attachmate G32",
	"_cadencecontrol":                       "Cadence Control",
	"_infolibria":                           "InfoLibria",
	"_siebel-ns":                            "Siebel NS",
	"_rdlap":                                "RDLAP",
	"_ofsd":                                 "ofsd",
	"_3d-nfsd":                              "3d-nfsd",
	"_cosmocall":                            "Cosmocall",
	"_ansysli":                              "ANSYS Licensing Interconnect",
	"_idcp":                                 "IDCP",
	"_xingcsm":                              "xingcsm",
	"_netrix-sftm":                          "Netrix SFTM",
	"_tscchat":                              "TSCCHAT",
	"_agentview":                            "AGENTVIEW",
	"_rcc-host":                             "RCC Host",
	"_snapp":                                "SNAPP",
	"_ace-client":                           "ACE Client Auth",
	"_ace-proxy":                            "ACE Proxy",
	"_appleugcontrol":                       "Apple UG Control",
	"_ideesrv":                              "ideesrv",
	"_norton-lambert":                       "Norton Lambert",
	"_3com-webview":                         "3Com WebView",
	"_wrs-registry":                         "WRS Registry IANA assigned this well-formed service name as a replacement for 'wrs_registry'.",
	"_wrs_registry":                         "WRS Registry",
	"_xiostatus":                            "XIO Status",
	"_manage-exec":                          "Seagate Manage Exec",
	"_nati-logos":                           "nati logos",
	"_fcmsys":                               "fcmsys",
	"_dbm":                                  "dbm",
	"_redstorm-join":                        "Game Connection Port IANA assigned this well-formed service name as a replacement for 'redstorm_join'.",
	"_redstorm_join":                        "Game Connection Port",
	"_redstorm-find":                        "Game Announcement and Location IANA assigned this well-formed service name as a replacement for 'redstorm_find'.",
	"_redstorm_find":                        "Game Announcement and Location",
	"_redstorm-info":                        "Information to query for game status IANA assigned this well-formed service name as a replacement for 'redstorm_info'.",
	"_redstorm_info":                        "Information to query for game status",
	"_redstorm-diag":                        "Diagnostics Port IANA assigned this well-formed service name as a replacement for 'redstorm_diag'.",
	"_redstorm_diag":                        "Diagnostics Port",
	"_psbserver":                            "Pharos Booking Server",
	"_psrserver":                            "psrserver",
	"_pslserver":                            "pslserver",
	"_pspserver":                            "pspserver",
	"_psprserver":                           "psprserver",
	"_psdbserver":                           "psdbserver",
	"_gxtelmd":                              "GXT License Managemant",
	"_unihub-server":                        "UniHub Server",
	"_futrix":                               "Futrix",
	"_flukeserver":                          "FlukeServer",
	"_nexstorindltd":                        "NexstorIndLtd",
	"_tl1":                                  "TL1",
	"_digiman":                              "digiman",
	"_mediacntrlnfsd":                       "Media Central NFSD",
	"_oi-2000":                              "OI-2000",
	"_dbref":                                "dbref",
	"_qip-login":                            "qip-login",
	"_service-ctrl":                         "Service Control",
	"_opentable":                            "OpenTable",
	"_bif-p2p":                              "Blockchain Identifier InFrastructure P2P",
	"_l3-hbmon":                             "L3-HBMon",
	"_lanmessenger":                         "LanMessenger",
	"_remographlm":                          "Remograph License Manager",
	"_hydra":                                "Hydra RPC",
	"_docker":                               "Docker REST API (plain text)",
	"_docker-s":                             "Docker REST API (ssl)",
	"_swarm":                                "RPC interface for Docker Swarm",
	"_dali":                                 "DALI lighting control",
	"_etcd-client":                          "etcd client communication",
	"_etcd-server":                          "etcd server to server communication",
	"_compaq-https":                         "Compaq HTTPS",
	"_ms-olap3":                             "Microsoft OLAP",
	"_ms-olap4":                             "Microsoft OLAP",
	"_sd-request":                           "SD-REQUEST",
	"_sd-capacity":                          "SD-CAPACITY",
	"_sd-data":                              "SD-DATA",
	"_virtualtape":                          "Virtual Tape",
	"_vsamredirector":                       "VSAM Redirector",
	"_mynahautostart":                       "MYNAH AutoStart",
	"_ovsessionmgr":                         "OpenView Session Mgr",
	"_rsmtp":                                "RSMTP",
	"_3com-net-mgmt":                        "3COM Net Management",
	"_tacticalauth":                         "Tactical Auth",
	"_ms-olap1":                             "MS OLAP 1",
	"_ms-olap2":                             "MS OLAP 2",
	"_lan900-remote":                        "LAN900 Remote IANA assigned this well-formed service name as a replacement for 'lan900_remote'.",
	"_lan900_remote":                        "LAN900 Remote",
	"_wusage":                               "Wusage",
	"_ncl":                                  "NCL",
	"_orbiter":                              "Orbiter",
	"_fmpro-fdal":                           "FileMaker, Inc. - Data Access Layer",
	"_opequus-server":                       "OpEquus Server",
	"_cvspserver":                           "cvspserver",
	"_taskmaster2000":                       "TaskMaster 2000 Server",
	"_iec-104":                              "IEC 60870-5-104 process control over IP",
	"_trc-netpoll":                          "TRC Netpoll",
	"_jediserver":                           "JediServer",
	"_orion":                                "Orion",
	"_railgun-webaccl":                      "CloudFlare Railgun Web Acceleration Protocol",
	"_sns-protocol":                         "SNS Protocol",
	"_vrts-registry":                        "VRTS Registry",
	"_netwave-ap-mgmt":                      "Netwave AP Management",
	"_cdn":                                  "CDN",
	"_orion-rmi-reg":                        "orion-rmi-reg",
	"_beeyond":                              "Beeyond",
	"_codima-rtp":                           "Codima Remote Transaction Protocol",
	"_rmtserver":                            "RMT Server",
	"_composit-server":                      "Composit Server",
	"_cas":                                  "cas",
	"_attachmate-s2s":                       "Attachmate S2S",
	"_dslremote-mgmt":                       "DSL Remote Management",
	"_g-talk":                               "G-Talk",
	"_crmsbits":                             "CRMSBITS",
	"_rnrp":                                 "RNRP",
	"_kofax-svr":                            "KOFAX-SVR",
	"_fjitsuappmgr":                         "Fujitsu App Manager",
	"_vcmp":                                 "VeloCloud MultiPath Protocol",
	"_mgcp-gateway":                         "Media Gateway Control Protocol Gateway",
	"_ott":                                  "One Way Trip Time",
	"_ft-role":                              "FT-ROLE",
	"_venus":                                "venus",
	"_venus-se":                             "venus-se",
	"_codasrv":                              "codasrv",
	"_codasrv-se":                           "codasrv-se",
	"_pxc-epmap":                            "pxc-epmap",
	"_optilogic":                            "OptiLogic",
	"_topx":                                 "TOP/X",
	"_unicontrol":                           "UniControl",
	"_sybasedbsynch":                        "SybaseDBSynch",
	"_spearway":                             "Spearway Lockers",
	"_pvsw-inet":                            "Pervasive I*net Data Server",
	"_netangel":                             "Netangel",
	"_powerclientcsf":                       "PowerClient Central Storage Facility",
	"_btpp2sectrans":                        "BT PP2 Sectrans",
	"_dtn1":                                 "DTN1",
	"_bues-service":                         "bues_service IANA assigned this well-formed service name as a replacement for 'bues_service'.",
	"_bues_service":                         "bues_service",
	"_ovwdb":                                "OpenView NNM daemon",
	"_hpppssvr":                             "hpppsvr",
	"_ratl":                                 "RATL",
	"_netadmin":                             "netadmin",
	"_netchat":                              "netchat",
	"_snifferclient":                        "SnifferClient",
	"_madge-ltd":                            "madge ltd",
	"_indx-dds":                             "IndX-DDS",
	"_wago-io-system":                       "WAGO-IO-SYSTEM",
	"_altav-remmgt":                         "altav-remmgt",
	"_rapido-ip":                            "Rapido_IP",
	"_griffin":                              "griffin",
	"_xrpl":                                 "Community",
	"_ms-theater":                           "ms-theater",
	"_qadmifoper":                           "qadmifoper",
	"_qadmifevent":                          "qadmifevent",
	"_lsi-raid-mgmt":                        "LSI RAID Management",
	"_direcpc-si":                           "DirecPC SI",
	"_lbm":                                  "Load Balance Management",
	"_lbf":                                  "Load Balance Forwarding",
	"_high-criteria":                        "High Criteria",
	"_qip-msgd":                             "qip_msgd",
	"_mti-tcs-comm":                         "MTI-TCS-COMM",
	"_taskman-port":                         "taskman port",
	"_seaodbc":                              "SeaODBC",
	"_c3":                                   "C3",
	"_aker-cdp":                             "Aker-cdp",
	"_vitalanalysis":                        "Vital Analysis",
	"_ace-server":                           "ACE Server",
	"_ace-svr-prop":                         "ACE Server Propagation",
	"_ssm-cvs":                              "SecurSight Certificate Valifation Service",
	"_ssm-cssps":                            "SecurSight Authentication Server (SSL)",
	"_ssm-els":                              "SecurSight Event Logging Server (SSL)",
	"_powerexchange":                        "Informatica PowerExchange Listener",
	"_giop":                                 "Oracle GIOP",
	"_giop-ssl":                             "Oracle GIOP SSL",
	"_ttc":                                  "Oracle TTC",
	"_ttc-ssl":                              "Oracle TTC SSL",
	"_netobjects1":                          "Net Objects1",
	"_netobjects2":                          "Net Objects2",
	"_pns":                                  "Policy Notice Service",
	"_moy-corp":                             "Moy Corporation",
	"_tsilb":                                "TSILB",
	"_qip-qdhcp":                            "qip_qdhcp",
	"_conclave-cpp":                         "Conclave CPP",
	"_groove":                               "GROOVE",
	"_talarian-mqs":                         "Talarian MQS",
	"_bmc-ar":                               "BMC AR",
	"_fast-rem-serv":                        "Fast Remote Services",
	"_dirgis":                               "DIRGIS",
	"_quaddb":                               "Quad DB",
	"_odn-castraq":                          "ODN-CasTraq",
	"_rtsserv":                              "Resource Tracking system server",
	"_rtsclient":                            "Resource Tracking system client",
	"_kentrox-prot":                         "Kentrox Protocol",
	"_nms-dpnss":                            "NMS-DPNSS",
	"_wlbs":                                 "WLBS",
	"_ppcontrol":                            "PowerPlay Control",
	"_jbroker":                              "jbroker",
	"_spock":                                "spock",
	"_jdatastore":                           "JDataStore",
	"_fjmpss":                               "fjmpss",
	"_fjappmgrbulk":                         "fjappmgrbulk",
	"_metastorm":                            "Metastorm",
	"_citrixima":                            "Citrix IMA",
	"_citrixadmin":                          "Citrix ADMIN",
	"_facsys-ntp":                           "Facsys NTP",
	"_facsys-router":                        "Facsys Router",
	"_maincontrol":                          "Main Control",
	"_call-sig-trans":                       "H.323 Annex E Call Control Signalling Transport",
	"_willy":                                "Willy",
	"_globmsgsvc":                           "globmsgsvc",
	"_pvsw":                                 "Pervasive Listener",
	"_adaptecmgr":                           "Adaptec Manager",
	"_windb":                                "WinDb",
	"_qke-llc-v3":                           "Qke LLC V.3",
	"_optiwave-lm":                          "Optiwave License Management",
	"_ms-v-worlds":                          "MS V-Worlds",
	"_ema-sent-lm":                          "EMA License Manager",
	"_iqserver":                             "IQ Server",
	"_ncr-ccl":                              "NCR CCL IANA assigned this well-formed service name as a replacement for 'ncr_ccl'.",
	"_ncr_ccl":                              "NCR CCL",
	"_utsftp":                               "UTS FTP",
	"_vrcommerce":                           "VR Commerce",
	"_ito-e-gui":                            "ITO-E GUI",
	"_ovtopmd":                              "OVTOPMD",
	"_snifferserver":                        "SnifferServer",
	"_combox-web-acc":                       "Combox Web Access",
	"_madcap":                               "MADCAP",
	"_btpp2audctr1":                         "btpp2audctr1",
	"_upgrade":                              "Upgrade Protocol",
	"_vnwk-prapi":                           "vnwk-prapi",
	"_vsiadmin":                             "VSI Admin",
	"_lonworks":                             "LonWorks",
	"_lonworks2":                            "LonWorks2",
	"_udrawgraph":                           "uDraw(Graph)",
	"_reftek":                               "REFTEK",
	"_novell-zen":                           "Management Daemon Refresh",
	"_sis-emt":                              "sis-emt",
	"_vytalvaultbrtp":                       "vytalvaultbrtp",
	"_vytalvaultvsmp":                       "vytalvaultvsmp",
	"_vytalvaultpipe":                       "vytalvaultpipe",
	"_ipass":                                "IPASS",
	"_ads":                                  "ADS",
	"_isg-uda-server":                       "ISG UDA Server",
	"_call-logging":                         "Call Logging",
	"_efidiningport":                        "efidiningport",
	"_vcnet-link-v10":                       "VCnet-Link v10",
	"_compaq-wcp":                           "Compaq WCP",
	"_nicetec-nmsvc":                        "nicetec-nmsvc",
	"_nicetec-mgmt":                         "nicetec-mgmt",
	"_pclemultimedia":                       "PCLE Multi Media",
	"_lstp":                                 "LSTP",
	"_labrat":                               "labrat",
	"_mosaixcc":                             "MosaixCC",
	"_delibo":                               "Delibo",
	"_cti-redwood":                          "CTI Redwood",
	"_hp-3000-telnet":                       "HP 3000 NS/VT block mode telnet",
	"_coord-svr":                            "Coordinator Server",
	"_pcs-pcw":                              "pcs-pcw",
	"_clp":                                  "Cisco Line Protocol",
	"_spamtrap":                             "SPAM TRAP",
	"_sonuscallsig":                         "Sonus Call Signal",
	"_hs-port":                              "HS Port",
	"_cecsvc":                               "CECSVC",
	"_ibp":                                  "IBP",
	"_trustestablish":                       "Trust Establish",
	"_blockade-bpsp":                        "Blockade BPSP",
	"_hl7":                                  "HL7",
	"_tclprodebugger":                       "TCL Pro Debugger",
	"_scipticslsrvr":                        "Scriptics Lsrvr",
	"_rvs-isdn-dcp":                         "RVS ISDN DCP",
	"_mpfoncl":                              "mpfoncl",
	"_tributary":                            "Tributary",
	"_argis-te":                             "ARGIS TE",
	"_argis-ds":                             "ARGIS DS",
	"_mon":                                  "MON",
	"_cyaserv":                              "cyaserv",
	"_netx-server":                          "NETX Server",
	"_netx-agent":                           "NETX Agent",
	"_masc":                                 "MASC",
	"_privilege":                            "Privilege",
	"_quartus-tcl":                          "quartus tcl",
	"_idotdist":                             "idotdist",
	"_maytagshuffle":                        "Maytag Shuffle",
	"_netrek":                               "netrek",
	"_mns-mail":                             "MNS Mail Notice Service",
	"_dts":                                  "Data Base Server",
	"_worldfusion1":                         "World Fusion 1",
	"_worldfusion2":                         "World Fusion 2",
	"_homesteadglory":                       "Homestead Glory",
	"_citriximaclient":                      "Citrix MA Client",
	"_snapd":                                "Snap Discovery",
	"_hpstgmgr":                             "HPSTGMGR",
	"_discp-client":                         "discp client",
	"_discp-server":                         "discp server",
	"_servicemeter":                         "Service Meter",
	"_nsc-ccs":                              "NSC CCS",
	"_nsc-posa":                             "NSC POSA",
	"_netmon":                               "Dell Netmon",
	"_connection":                           "Dell Connection",
	"_wag-service":                          "Wag Service",
	"_system-monitor":                       "System Monitor",
	"_versa-tek":                            "VersaTek",
	"_lionhead":                             "LIONHEAD",
	"_qpasa-agent":                          "Qpasa Agent",
	"_smntubootstrap":                       "SMNTUBootstrap",
	"_neveroffline":                         "Never Offline",
	"_firepower":                            "firepower",
	"_appswitch-emp":                        "appswitch-emp",
	"_cmadmin":                              "Clinical Context Managers",
	"_priority-e-com":                       "Priority E-Com",
	"_bruce":                                "bruce",
	"_lpsrecommender":                       "LPSRecommender",
	"_miles-apart":                          "Miles Apart Jukebox Server",
	"_metricadbc":                           "MetricaDBC",
	"_lmdp":                                 "LMDP",
	"_aria":                                 "Aria",
	"_blwnkl-port":                          "Blwnkl Port",
	"_gbjd816":                              "gbjd816",
	"_moshebeeri":                           "Moshe Beeri",
	"_dict":                                 "DICT",
	"_sitaraserver":                         "Sitara Server",
	"_sitaramgmt":                           "Sitara Management",
	"_sitaradir":                            "Sitara Dir",
	"_irdg-post":                            "IRdg Post",
	"_interintelli":                         "InterIntelli",
	"_pk-electronics":                       "PK Electronics",
	"_backburner":                           "Back Burner",
	"_solve":                                "Solve",
	"_imdocsvc":                             "Import Document Service",
	"_sybaseanywhere":                       "Sybase Anywhere",
	"_aminet":                               "AMInet",
	"_ami-control":                          "Alcorn McBride Inc protocol used for device control",
	"_hdl-srv":                              "HDL Server",
	"_tragic":                               "Tragic",
	"_gte-samp":                             "GTE-SAMP",
	"_travsoft-ipx-t":                       "Travsoft IPX Tunnel",
	"_novell-ipx-cmd":                       "Novell IPX CMD",
	"_and-lm":                               "AND License Manager",
	"_syncserver":                           "SyncServer",
	"_upsnotifyprot":                        "Upsnotifyprot",
	"_vpsipport":                            "VPSIPPORT",
	"_eristwoguns":                          "eristwoguns",
	"_ebinsite":                             "EBInSite",
	"_interpathpanel":                       "InterPathPanel",
	"_sonus":                                "Sonus",
	"_corel-vncadmin":                       "Corel VNC Admin IANA assigned this well-formed service name as a replacement for 'corel_vncadmin'.",
	"_corel_vncadmin":                       "Corel VNC Admin",
	"_unglue":                               "UNIX Nt Glue",
	"_kana":                                 "Kana",
	"_sns-dispatcher":                       "SNS Dispatcher",
	"_sns-admin":                            "SNS Admin",
	"_sns-query":                            "SNS Query",
	"_gcmonitor":                            "GC Monitor",
	"_olhost":                               "OLHOST",
	"_bintec-capi":                          "BinTec-CAPI",
	"_bintec-tapi":                          "BinTec-TAPI",
	"_patrol-mq-gm":                         "Patrol for MQ GM",
	"_patrol-mq-nm":                         "Patrol for MQ NM",
	"_extensis":                             "extensis",
	"_alarm-clock-s":                        "Alarm Clock Server",
	"_alarm-clock-c":                        "Alarm Clock Client",
	"_toad":                                 "TOAD",
	"_tve-announce":                         "TVE Announce",
	"_newlixreg":                            "newlixreg",
	"_nhserver":                             "nhserver",
	"_firstcall42":                          "First Call 42",
	"_ewnn":                                 "ewnn",
	"_ttc-etap":                             "TTC ETAP",
	"_simslink":                             "SIMSLink",
	"_gadgetgate1way":                       "Gadget Gate 1 Way",
	"_gadgetgate2way":                       "Gadget Gate 2 Way",
	"_syncserverssl":                        "Sync Server SSL",
	"_pxc-sapxom":                           "pxc-sapxom",
	"_mpnjsomb":                             "mpnjsomb",
	"_ncdloadbalance":                       "NCDLoadBalance",
	"_mpnjsosv":                             "mpnjsosv",
	"_mpnjsocl":                             "mpnjsocl",
	"_mpnjsomg":                             "mpnjsomg",
	"_pq-lic-mgmt":                          "pq-lic-mgmt",
	"_md-cg-http":                           "md-cf-http",
	"_fastlynx":                             "FastLynx",
	"_hp-nnm-data":                          "HP NNM Embedded Database",
	"_itinternet":                           "ITInternet ISM Server",
	"_admins-lms":                           "Admins LMS",
	"_pwrsevent":                            "pwrsevent",
	"_vspread":                              "VSPREAD",
	"_unifyadmin":                           "Unify Admin",
	"_oce-snmp-trap":                        "Oce SNMP Trap Port",
	"_mck-ivpip":                            "MCK-IVPIP",
	"_csoft-plusclnt":                       "Csoft Plus Client",
	"_tqdata":                               "tqdata",
	"_sms-rcinfo":                           "SMS RCINFO",
	"_sms-xfer":                             "SMS XFER",
	"_sms-chat":                             "SMS CHAT",
	"_sms-remctrl":                          "SMS REMCTRL",
	"_sds-admin":                            "SDS Admin",
	"_ncdmirroring":                         "NCD Mirroring",
	"_emcsymapiport":                        "EMCSYMAPIPORT",
	"_banyan-net":                           "Banyan-Net",
	"_supermon":                             "Supermon",
	"_sso-service":                          "SSO Service",
	"_sso-control":                          "SSO Control",
	"_aocp":                                 "Axapta Object Communication Protocol",
	"_raventbs":                             "Raven Trinity Broker Service",
	"_raventdm":                             "Raven Trinity Data Mover",
	"_hpstgmgr2":                            "HPSTGMGR2",
	"_inova-ip-disco":                       "Inova IP Disco",
	"_pn-requester":                         "PN REQUESTER",
	"_pn-requester2":                        "PN REQUESTER 2",
	"_scan-change":                          "Scan & Change",
	"_wkars":                                "wkars",
	"_smart-diagnose":                       "Smart Diagnose",
	"_proactivesrvr":                        "Proactive Server",
	"_watchdog-nt":                          "WatchDog NT Protocol",
	"_qotps":                                "qotps",
	"_msolap-ptp2":                          "MSOLAP PTP2",
	"_tams":                                 "TAMS",
	"_mgcp-callagent":                       "Media Gateway Control Protocol Call Agent",
	"_sqdr":                                 "SQDR",
	"_tcim-control":                         "TCIM Control",
	"_nec-raidplus":                         "NEC RaidPlus",
	"_fyre-messanger":                       "Fyre Messanger",
	"_g5m":                                  "G5M",
	"_signet-ctf":                           "Signet CTF",
	"_ccs-software":                         "CCS Software",
	"_netiq-mc":                             "NetIQ Monitor Console",
	"_radwiz-nms-srv":                       "RADWIZ NMS SRV",
	"_srp-feedback":                         "SRP Feedback",
	"_ndl-tcp-ois-gw":                       "NDL TCP-OSI Gateway",
	"_tn-timing":                            "TN Timing",
	"_alarm":                                "Alarm",
	"_tsb":                                  "TSB",
	"_tsb2":                                 "TSB2",
	"_murx":                                 "murx",
	"_honyaku":                              "honyaku",
	"_urbisnet":                             "URBISNET",
	"_cpudpencap":                           "CPUDPENCAP",
	"_fjippol-swrly":                        "",
	"_fjippol-polsvr":                       "",
	"_fjippol-cnsl":                         "",
	"_fjippol-port1":                        "",
	"_fjippol-port2":                        "",
	"_rsisysaccess":                         "RSISYS ACCESS",
	"_de-spot":                              "de-spot",
	"_apollo-cc":                            "APOLLO CC",
	"_expresspay":                           "Express Pay",
	"_simplement-tie":                       "simplement-tie",
	"_cnrp":                                 "CNRP",
	"_apollo-status":                        "APOLLO Status",
	"_apollo-gms":                           "APOLLO GMS",
	"_sabams":                               "Saba MS",
	"_dicom-iscl":                           "DICOM ISCL",
	"_dicom-tls":                            "DICOM TLS",
	"_desktop-dna":                          "Desktop DNA",
	"_data-insurance":                       "Data Insurance",
	"_qip-audup":                            "qip-audup",
	"_compaq-scp":                           "Compaq SCP",
	"_uadtc":                                "UADTC",
	"_uacs":                                 "UACS",
	"_exce":                                 "eXcE",
	"_veronica":                             "Veronica",
	"_vergencecm":                           "Vergence CM",
	"_auris":                                "auris",
	"_rbakcup1":                             "RBackup Remote Backup",
	"_rbakcup2":                             "RBackup Remote Backup",
	"_smpp":                                 "SMPP",
	"_ridgeway1":                            "Ridgeway Systems & Software",
	"_ridgeway2":                            "Ridgeway Systems & Software",
	"_gwen-sonya":                           "Gwen-Sonya",
	"_lbc-sync":                             "LBC Sync",
	"_lbc-control":                          "LBC Control",
	"_whosells":                             "whosells",
	"_everydayrc":                           "everydayrc",
	"_aises":                                "AISES",
	"_www-dev":                              "world wide web - development",
	"_aic-np":                               "aic-np",
	"_aic-oncrpc":                           "aic-oncrpc - Destiny MCD database",
	"_piccolo":                              "piccolo - Cornerstone Software",
	"_fryeserv":                             "NetWare Loadable Module - Seagate Software",
	"_media-agent":                          "Media Agent",
	"_plgproxy":                             "PLG Proxy",
	"_mtport-regist":                        "MT Port Registrator",
	"_f5-globalsite":                        "f5-globalsite",
	"_initlsmsad":                           "initlsmsad",
	"_livestats":                            "LiveStats",
	"_ac-tech":                              "ac-tech",
	"_esp-encap":                            "esp-encap",
	"_tmesis-upshot":                        "TMESIS-UPShot",
	"_icon-discover":                        "ICON Discover",
	"_acc-raid":                             "ACC RAID",
	"_igcp":                                 "IGCP",
	"_veritas-tcp1":                         "Veritas TCP1",
	"_veritas-udp1":                         "Veritas UDP1",
	"_btprjctrl":                            "btprjctrl",
	"_dvr-esm":                              "March Networks Digital Video Recorders and Enterprise Service Manager products",
	"_wta-wsp-s":                            "WTA WSP-S",
	"_cspuni":                               "cspuni",
	"_cspmulti":                             "cspmulti",
	"_j-lan-p":                              "J-LAN-P",
	"_corbaloc":                             "CORBA LOC",
	"_netsteward":                           "Active Net Steward",
	"_gsiftp":                               "GSI FTP",
	"_atmtcp":                               "atmtcp",
	"_llm-pass":                             "llm-pass",
	"_llm-csv":                              "llm-csv",
	"_lbc-measure":                          "LBC Measurement",
	"_lbc-watchdog":                         "LBC Watchdog",
	"_nmsigport":                            "NMSig Port",
	"_rmlnk":                                "rmlnk",
	"_fc-faultnotify":                       "FC Fault Notification",
	"_univision":                            "UniVision",
	"_vrts-at-port":                         "VERITAS Authentication Service",
	"_ka0wuc":                               "ka0wuc",
	"_cqg-netlan":                           "CQG Net/LAN",
	"_cqg-netlan-1":                         "CQG Net/LAN 1",
	"_slc-systemlog":                        "slc systemlog",
	"_slc-ctrlrloops":                       "slc ctrlrloops",
	"_itm-lm":                               "ITM License Manager",
	"_silkp1":                               "silkp1",
	"_silkp2":                               "silkp2",
	"_silkp3":                               "silkp3",
	"_silkp4":                               "silkp4",
	"_glishd":                               "glishd",
	"_evtp":                                 "EVTP",
	"_evtp-data":                            "EVTP-DATA",
	"_catalyst":                             "catalyst",
	"_repliweb":                             "Repliweb",
	"_starbot":                              "Starbot",
	"_l3-exprt":                             "l3-exprt",
	"_l3-ranger":                            "l3-ranger",
	"_l3-hawk":                              "l3-hawk",
	"_pdnet":                                "PDnet",
	"_bpcp-poll":                            "BPCP POLL",
	"_bpcp-trap":                            "BPCP TRAP",
	"_aimpp-hello":                          "AIMPP Hello",
	"_aimpp-port-req":                       "AIMPP Port Req",
	"_amt-blc-port":                         "AMT-BLC-PORT",
	"_metaconsole":                          "MetaConsole",
	"_webemshttp":                           "webemshttp",
	"_bears-01":                             "bears-01",
	"_ispipes":                              "ISPipes",
	"_infomover":                            "InfoMover",
	"_msrp":                                 "MSRP over TCP",
	"_cesdinv":                              "cesdinv",
	"_simctlp":                              "SimCtIP",
	"_ecnp":                                 "ECNP",
	"_activememory":                         "Active Memory",
	"_dialpad-voice1":                       "Dialpad Voice 1",
	"_dialpad-voice2":                       "Dialpad Voice 2",
	"_ttg-protocol":                         "TTG Protocol",
	"_sonardata":                            "Sonar Data",
	"_astronova-main":                       "main 5001 cmd",
	"_pit-vpn":                              "pit-vpn",
	"_iwlistener":                           "iwlistener",
	"_esps-portal":                          "esps-portal",
	"_npep-messaging":                       "Norman Proprietaqry Events Protocol",
	"_icslap":                               "ICSLAP",
	"_daishi":                               "daishi",
	"_msi-selectplay":                       "MSI Select Play",
	"_radix":                                "RADIX",
	"_psrt":                                 "PubSub Realtime Telemetry Protocol",
	"_dxmessagebase1":                       "DX Message Base Transport Protocol",
	"_dxmessagebase2":                       "DX Message Base Transport Protocol",
	"_sps-tunnel":                           "SPS Tunnel",
	"_bluelance":                            "BLUELANCE",
	"_aap":                                  "AAP",
	"_ucentric-ds":                          "ucentric-ds",
	"_synapse":                              "Synapse Transport",
	"_ndsp":                                 "NDSP",
	"_ndtp":                                 "NDTP",
	"_ndnp":                                 "NDNP",
	"_flashmsg":                             "Flash Msg",
	"_topflow":                              "TopFlow",
	"_responselogic":                        "RESPONSELOGIC",
	"_aironetddp":                           "aironet",
	"_spcsdlobby":                           "SPCSDLOBBY",
	"_rsom":                                 "RSOM",
	"_cspclmulti":                           "CSPCLMULTI",
	"_cinegrfx-elmd":                        "CINEGRFX-ELMD License Manager",
	"_snifferdata":                          "SNIFFERDATA",
	"_vseconnector":                         "VSECONNECTOR",
	"_abacus-remote":                        "ABACUS-REMOTE",
	"_natuslink":                            "NATUS LINK",
	"_ecovisiong6-1":                        "ECOVISIONG6-1",
	"_citrix-rtmp":                          "Citrix RTMP",
	"_appliance-cfg":                        "APPLIANCE-CFG",
	"_powergemplus":                         "POWERGEMPLUS",
	"_quicksuite":                           "QUICKSUITE",
	"_allstorcns":                           "ALLSTORCNS",
	"_netaspi":                              "NET ASPI",
	"_suitcase":                             "SUITCASE",
	"_m2ua":                                 "M2UA",
	"_m3ua":                                 "M3UA",
	"_caller9":                              "CALLER9",
	"_webmethods-b2b":                       "WEBMETHODS B2B",
	"_mao":                                  "mao",
	"_funk-dialout":                         "Funk Dialout",
	"_tdaccess":                             "TDAccess",
	"_blockade":                             "Blockade",
	"_epicon":                               "Epicon",
	"_boosterware":                          "Booster Ware",
	"_gamelobby":                            "Game Lobby",
	"_tksocket":                             "TK Socket",
	"_elvin-server":                         "Elvin Server IANA assigned this well-formed service name as a replacement for 'elvin_server'.",
	"_elvin_server":                         "Elvin Server",
	"_elvin-client":                         "Elvin Client IANA assigned this well-formed service name as a replacement for 'elvin_client'.",
	"_elvin_client":                         "Elvin Client",
	"_kastenchasepad":                       "Kasten Chase Pad",
	"_roboer":                               "roboER",
	"_roboeda":                              "roboEDA",
	"_cesdcdman":                            "CESD Contents Delivery Management",
	"_cesdcdtrn":                            "CESD Contents Delivery Data Transfer",
	"_wta-wsp-wtp-s":                        "WTA-WSP-WTP-S",
	"_precise-vip":                          "PRECISE-VIP",
	"_mobile-file-dl":                       "MOBILE-FILE-DL",
	"_unimobilectrl":                        "UNIMOBILECTRL",
	"_redstone-cpss":                        "REDSTONE-CPSS",
	"_amx-webadmin":                         "AMX-WEBADMIN",
	"_amx-weblinx":                          "AMX-WEBLINX",
	"_circle-x":                             "Circle-X",
	"_incp":                                 "INCP",
	"_4-tieropmgw":                          "4-TIER OPM GW",
	"_4-tieropmcli":                         "4-TIER OPM CLI",
	"_qtp":                                  "QTP",
	"_otpatch":                              "OTPatch",
	"_pnaconsult-lm":                        "PNACONSULT-LM",
	"_sm-pas-1":                             "SM-PAS-1",
	"_sm-pas-2":                             "SM-PAS-2",
	"_sm-pas-3":                             "SM-PAS-3",
	"_sm-pas-4":                             "SM-PAS-4",
	"_sm-pas-5":                             "SM-PAS-5",
	"_ttnrepository":                        "TTNRepository",
	"_megaco-h248":                          "Megaco H-248",
	"_h248-binary":                          "H248 Binary",
	"_fjsvmpor":                             "FJSVmpor",
	"_gpsd":                                 "GPS Daemon request/response protocol",
	"_wap-push":                             "WAP PUSH",
	"_wap-pushsecure":                       "WAP PUSH SECURE",
	"_esip":                                 "ESIP",
	"_ottp":                                 "OTTP",
	"_mpfwsas":                              "MPFWSAS",
	"_ovalarmsrv":                           "OVALARMSRV",
	"_ovalarmsrv-cmd":                       "OVALARMSRV-CMD",
	"_csnotify":                             "CSNOTIFY",
	"_ovrimosdbman":                         "OVRIMOSDBMAN",
	"_jmact5":                               "JAMCT5",
	"_jmact6":                               "JAMCT6",
	"_rmopagt":                              "RMOPAGT",
	"_dfoxserver":                           "DFOXSERVER",
	"_boldsoft-lm":                          "BOLDSOFT-LM",
	"_iph-policy-cli":                       "IPH-POLICY-CLI",
	"_iph-policy-adm":                       "IPH-POLICY-ADM",
	"_bullant-srap":                         "BULLANT SRAP",
	"_bullant-rap":                          "BULLANT RAP",
	"_idp-infotrieve":                       "IDP-INFOTRIEVE",
	"_ssc-agent":                            "SSC-AGENT",
	"_enpp":                                 "ENPP",
	"_essp":                                 "ESSP",
	"_index-net":                            "INDEX-NET",
	"_netclip":                              "NetClip clipboard daemon",
	"_pmsm-webrctl":                         "PMSM Webrctl",
	"_svnetworks":                           "SV Networks",
	"_signal":                               "Signal",
	"_fjmpcm":                               "Fujitsu Configuration Management Service",
	"_cns-srv-port":                         "CNS Server Port",
	"_ttc-etap-ns":                          "TTCs Enterprise Test Access Protocol - NS",
	"_ttc-etap-ds":                          "TTCs Enterprise Test Access Protocol - DS",
	"_h263-video":                           "H.263 Video Streaming",
	"_wimd":                                 "Instant Messaging Service",
	"_mylxamport":                           "MYLXAMPORT",
	"_iwb-whiteboard":                       "IWB-WHITEBOARD",
	"_netplan":                              "NETPLAN",
	"_hpidsadmin":                           "HPIDSADMIN",
	"_hpidsagent":                           "HPIDSAGENT",
	"_stonefalls":                           "STONEFALLS",
	"_identify":                             "identify",
	"_hippad":                               "HIPPA Reporting Protocol",
	"_zarkov":                               "ZARKOV Intelligent Agent Communication",
	"_boscap":                               "BOSCAP",
	"_wkstn-mon":                            "WKSTN-MON",
	"_avenyo":                               "Avenyo Server",
	"_veritas-vis1":                         "VERITAS VIS1",
	"_veritas-vis2":                         "VERITAS VIS2",
	"_idrs":                                 "IDRS",
	"_vsixml":                               "vsixml",
	"_rebol":                                "REBOL",
	"_realsecure":                           "Real Secure",
	"_remoteware-un":                        "RemoteWare Unassigned",
	"_hbci":                                 "HBCI",
	"_remoteware-cl":                        "RemoteWare Client",
	"_origo-native":                         "OrigoDB Server Native Interface",
	"_exlm-agent":                           "EXLM Agent",
	"_remoteware-srv":                       "RemoteWare Server",
	"_cgms":                                 "CGMS",
	"_csoftragent":                          "Csoft Agent",
	"_geniuslm":                             "Genius License Manager",
	"_ii-admin":                             "Instant Internet Admin",
	"_lotusmtap":                            "Lotus Mail Tracking Agent Protocol",
	"_midnight-tech":                        "Midnight Technologies",
	"_pxc-ntfy":                             "PXC-NTFY",
	"_gw":                                   "Telerate Workstation",
	"_ping-pong":                            "Telerate Workstation",
	"_trusted-web":                          "Trusted Web",
	"_twsdss":                               "Trusted Web Client",
	"_gilatskysurfer":                       "Gilat Sky Surfer",
	"_broker-service":                       "Broker Service IANA assigned this well-formed service name as a replacement for 'broker_service'.",
	"_broker_service":                       "Broker Service",
	"_nati-dstp":                            "NATI DSTP",
	"_notify-srvr":                          "Notify Server IANA assigned this well-formed service name as a replacement for 'notify_srvr'.",
	"_notify_srvr":                          "Notify Server",
	"_event-listener":                       "Event Listener IANA assigned this well-formed service name as a replacement for 'event_listener'.",
	"_event_listener":                       "Event Listener",
	"_srvc-registry":                        "Service Registry IANA assigned this well-formed service name as a replacement for 'srvc_registry'.",
	"_srvc_registry":                        "Service Registry",
	"_resource-mgr":                         "Resource Manager IANA assigned this well-formed service name as a replacement for 'resource_mgr'.",
	"_resource_mgr":                         "Resource Manager",
	"_cifs":                                 "CIFS",
	"_agriserver":                           "AGRI Server",
	"_csregagent":                           "CSREGAGENT",
	"_magicnotes":                           "magicnotes",
	"_nds-sso":                              "NDS_SSO IANA assigned this well-formed service name as a replacement for 'nds_sso'.",
	"_nds_sso":                              "NDS_SSO",
	"_arepa-raft":                           "Arepa Raft",
	"_agri-gateway":                         "AGRI Gateway",
	"_liebdevmgmt-c":                        "LiebDevMgmt_C IANA assigned this well-formed service name as a replacement for 'LiebDevMgmt_C'.",
	"_liebdevmgmt_c":                        "LiebDevMgmt_C",
	"_liebdevmgmt-dm":                       "LiebDevMgmt_DM IANA assigned this well-formed service name as a replacement for 'LiebDevMgmt_DM'.",
	"_liebdevmgmt_dm":                       "LiebDevMgmt_DM",
	"_liebdevmgmt-a":                        "LiebDevMgmt_A IANA assigned this well-formed service name as a replacement for 'LiebDevMgmt_A'.",
	"_liebdevmgmt_a":                        "LiebDevMgmt_A",
	"_arepa-cas":                            "Arepa Cas",
	"_eppc":                                 "Remote AppleEvents/PPC Toolbox",
	"_redwood-chat":                         "Redwood Chat",
	"_pdb":                                  "PDB",
	"_osmosis-aeea":                         "Osmosis / Helix (R) AEEA Port",
	"_fjsv-gssagt":                          "FJSV gssagt",
	"_hagel-dump":                           "Hagel DUMP",
	"_hp-san-mgmt":                          "HP SAN Mgmt",
	"_santak-ups":                           "Santak UPS",
	"_cogitate":                             "Cogitate, Inc.",
	"_tomato-springs":                       "Tomato Springs",
	"_di-traceware":                         "di-traceware",
	"_journee":                              "journee",
	"_brp":                                  "Broadcast Routing Protocol",
	"_responsenet":                          "ResponseNet",
	"_di-ase":                               "di-ase",
	"_hlserver":                             "Fast Security HL Server",
	"_pctrader":                             "Sierra Net PC Trader",
	"_nsws":                                 "NSWS",
	"_gds-db":                               "gds_db IANA assigned this well-formed service name as a replacement for 'gds_db'.",
	"_gds_db":                               "gds_db",
	"_galaxy-server":                        "Galaxy Server",
	"_apc-3052":                             "APC 3052",
	"_dsom-server":                          "dsom-server",
	"_amt-cnf-prot":                         "AMT CNF PROT",
	"_policyserver":                         "Policy Server",
	"_cdl-server":                           "CDL Server",
	"_goahead-fldup":                        "GoAhead FldUp",
	"_videobeans":                           "videobeans",
	"_qsoft":                                "qsoft",
	"_interserver":                          "interserver",
	"_cautcpd":                              "cautcpd",
	"_ncacn-ip-tcp":                         "ncacn-ip-tcp",
	"_ncadg-ip-udp":                         "ncadg-ip-udp",
	"_rprt":                                 "Remote Port Redirector",
	"_slinterbase":                          "slinterbase",
	"_netattachsdmp":                        "NETATTACHSDMP",
	"_fjhpjp":                               "FJHPJP",
	"_ls3bcast":                             "ls3 Broadcast",
	"_ls3":                                  "ls3",
	"_mgxswitch":                            "MGXSWITCH",
	"_xplat-replicate":                      "Crossplatform replication protocol",
	"_csd-monitor":                          "ContinuStor Monitor Port",
	"_vcrp":                                 "Very simple chatroom prot",
	"_xbox":                                 "Xbox game port",
	"_orbix-locator":                        "Orbix 2000 Locator",
	"_orbix-config":                         "Orbix 2000 Config",
	"_orbix-loc-ssl":                        "Orbix 2000 Locator SSL",
	"_orbix-cfg-ssl":                        "Orbix 2000 Locator SSL",
	"_lv-frontpanel":                        "LV Front Panel",
	"_stm-pproc":                            "stm_pproc IANA assigned this well-formed service name as a replacement for 'stm_pproc'.",
	"_stm_pproc":                            "stm_pproc",
	"_tl1-lv":                               "TL1-LV",
	"_tl1-raw":                              "TL1-RAW",
	"_tl1-telnet":                           "TL1-TELNET",
	"_itm-mccs":                             "ITM-MCCS",
	"_pcihreq":                              "PCIHReq",
	"_jdl-dbkitchen":                        "JDL-DBKitchen",
	"_asoki-sma":                            "Asoki SMA",
	"_xdtp":                                 "eXtensible Data Transfer Protocol",
	"_ptk-alink":                            "ParaTek Agent Linking",
	"_stss":                                 "Senforce Session Services",
	"_1ci-smcs":                             "1Ci Server Management",
	"_rapidmq-center":                       "Jiiva RapidMQ Center",
	"_rapidmq-reg":                          "Jiiva RapidMQ Registry",
	"_panasas":                              "Panasas rendezvous port",
	"_ndl-aps":                              "Active Print Server Port",
	"_itu-bicc-stc":                         "ITU-T Q.1902.1/Q.2150.3",
	"_umm-port":                             "Universal Message Manager",
	"_chmd":                                 "CHIPSY Machine Daemon",
	"_opcon-xps":                            "OpCon/xps",
	"_hp-pxpib":                             "HP PolicyXpert PIB Server",
	"_slslavemon":                           "SoftlinK Slave Mon Port",
	"_autocuesmi":                           "Autocue SMI Protocol",
	"_autocuelog":                           "Autocue Logger Protocol",
	"_autocuetime":                          "Autocue Time Service",
	"_cardbox":                              "Cardbox",
	"_cardbox-http":                         "Cardbox HTTP",
	"_business":                             "Business protocol",
	"_geolocate":                            "Geolocate protocol",
	"_personnel":                            "Personnel protocol",
	"_sim-control":                          "simulator control port",
	"_wsynch":                               "Web Synchronous Services",
	"_ksysguard":                            "KDE System Guard",
	"_cs-auth-svr":                          "CS-Authenticate Svr Port",
	"_ccmad":                                "CCM AutoDiscover",
	"_mctet-master":                         "MCTET Master",
	"_mctet-gateway":                        "MCTET Gateway",
	"_mctet-jserv":                          "MCTET Jserv",
	"_pkagent":                              "PKAgent",
	"_d2000kernel":                          "D2000 Kernel Port",
	"_d2000webserver":                       "D2000 Webserver Port",
	"_pcmk-remote":                          "The pacemaker remote (pcmk-remote) service extends high availability functionality outside of the Linux cluster into remote nodes.",
	"_vtr-emulator":                         "MTI VTR Emulator port",
	"_edix":                                 "EDI Translation Protocol",
	"_beacon-port":                          "Beacon Port",
	"_a13-an":                               "A13-AN Interface",
	"_ctx-bridge":                           "CTX Bridge Port",
	"_ndl-aas":                              "Active API Server Port",
	"_netport-id":                           "NetPort Discovery Port",
	"_icpv2":                                "ICPv2",
	"_netbookmark":                          "Net Book Mark",
	"_ms-rule-engine":                       "Microsoft Business Rule Engine Update Service",
	"_prism-deploy":                         "Prism Deploy User Port",
	"_ecp":                                  "Extensible Code Protocol",
	"_peerbook-port":                        "PeerBook Port",
	"_grubd":                                "Grub Server Port",
	"_rtnt-1":                               "rtnt-1 data packets",
	"_rtnt-2":                               "rtnt-2 data packets",
	"_incognitorv":                          "Incognito Rendez-Vous",
	"_ariliamulti":                          "Arilia Multiplexor",
	"_vmodem":                               "VMODEM",
	"_rdc-wh-eos":                           "RDC WH EOS",
	"_seaview":                              "Sea View",
	"_tarantella":                           "Tarantella",
	"_csi-lfap":                             "CSI-LFAP",
	"_bears-02":                             "bears-02",
	"_rfio":                                 "RFIO",
	"_nm-game-admin":                        "NetMike Game Administrator",
	"_nm-game-server":                       "NetMike Game Server",
	"_nm-asses-admin":                       "NetMike Assessor Administrator",
	"_nm-assessor":                          "NetMike Assessor",
	"_feitianrockey":                        "FeiTian Port",
	"_s8-client-port":                       "S8Cargo Client Port",
	"_ccmrmi":                               "ON RMI Registry",
	"_jpegmpeg":                             "JpegMpeg Port",
	"_indura":                               "Indura Collector",
	"_lsa-comm":                             "LSA Communicator",
	"_stvp":                                 "SmashTV Protocol",
	"_navegaweb-port":                       "NavegaWeb Tarification",
	"_tip-app-server":                       "TIP Application Server",
	"_doc1lm":                               "DOC1 License Manager",
	"_sflm":                                 "SFLM",
	"_res-sap":                              "RES-SAP",
	"_imprs":                                "IMPRS",
	"_newgenpay":                            "Newgenpay Engine Service",
	"_sossecollector":                       "Quest Spotlight Out-Of-Process Collector",
	"_nowcontact":                           "Now Contact Public Server",
	"_poweronnud":                           "Now Up-to-Date Public Server",
	"_serverview-as":                        "SERVERVIEW-AS",
	"_serverview-asn":                       "SERVERVIEW-ASN",
	"_serverview-gf":                        "SERVERVIEW-GF",
	"_serverview-rm":                        "SERVERVIEW-RM",
	"_serverview-icc":                       "SERVERVIEW-ICC",
	"_armi-server":                          "ARMI Server",
	"_t1-e1-over-ip":                        "T1_E1_Over_IP",
	"_ars-master":                           "ARS Master",
	"_phonex-port":                          "Phonex Protocol",
	"_radclientport":                        "Radiance UltraEdge Port",
	"_h2gf-w-2m":                            "H2GF W.2m Handover prot.",
	"_mc-brk-srv":                           "Millicent Broker Server",
	"_bmcpatrolagent":                       "BMC Patrol Agent",
	"_bmcpatrolrnvu":                        "BMC Patrol Rendezvous",
	"_cops-tls":                             "COPS/TLS",
	"_apogeex-port":                         "ApogeeX Port",
	"_smpppd":                               "SuSE Meta PPPD",
	"_iiw-port":                             "IIW Monitor User Port",
	"_odi-port":                             "Open Design Listen Port",
	"_brcm-comm-port":                       "Broadcom Port",
	"_pcle-infex":                           "Pinnacle Sys InfEx Port",
	"_csvr-proxy":                           "ConServR Proxy",
	"_csvr-sslproxy":                        "ConServR SSL Proxy",
	"_firemonrcc":                           "FireMon Revision Control",
	"_spandataport":                         "SpanDataPort",
	"_magbind":                              "Rockstorm MAG protocol",
	"_ncu-1":                                "Network Control Unit",
	"_ncu-2":                                "Network Control Unit",
	"_embrace-dp-s":                         "Embrace Device Protocol Server",
	"_embrace-dp-c":                         "Embrace Device Protocol Client",
	"_dmod-workspace":                       "DMOD WorkSpace",
	"_tick-port":                            "Press-sense Tick Port",
	"_cpq-tasksmart":                        "CPQ-TaskSmart",
	"_intraintra":                           "IntraIntra",
	"_netwatcher-mon":                       "Network Watcher Monitor",
	"_netwatcher-db":                        "Network Watcher DB Access",
	"_isns":                                 "iSNS Server Port",
	"_ironmail":                             "IronMail POP Proxy",
	"_vx-auth-port":                         "Veritas Authentication Port",
	"_pfu-prcallback":                       "PFU PR Callback",
	"_netwkpathengine":                      "HP OpenView Network Path Engine Server",
	"_flamenco-proxy":                       "Flamenco Networks Proxy",
	"_avsecuremgmt":                         "Avocent Secure Management",
	"_surveyinst":                           "Survey Instrument",
	"_neon24x7":                             "NEON 24X7 Mission Control",
	"_jmq-daemon-1":                         "JMQ Daemon Port 1",
	"_jmq-daemon-2":                         "JMQ Daemon Port 2",
	"_ferrari-foam":                         "Ferrari electronic FOAM",
	"_unite":                                "Unified IP & Telecom Environment",
	"_smartpackets":                         "EMC SmartPackets",
	"_wms-messenger":                        "WMS Messenger",
	"_xnm-ssl":                              "XML NM over SSL",
	"_xnm-clear-text":                       "XML NM over TCP",
	"_glbp":                                 "Gateway Load Balancing Pr",
	"_digivote":                             "DIGIVOTE (R) Vote-Server",
	"_aes-discovery":                        "AES Discovery Port",
	"_fcip-port":                            "FCIP",
	"_isi-irp":                              "ISI Industry Software IRP",
	"_dwnmshttp":                            "DiamondWave NMS Server",
	"_dwmsgserver":                          "DiamondWave MSG Server",
	"_global-cd-port":                       "Global CD Port",
	"_sftdst-port":                          "Software Distributor Port",
	"_vidigo":                               "VidiGo communication (previous was: Delta Solutions Direct)",
	"_mdtp":                                 "MDT port",
	"_whisker":                              "WhiskerControl main port",
	"_alchemy":                              "Alchemy Server",
	"_mdap-port":                            "MDAP port",
	"_apparenet-ts":                         "appareNet Test Server",
	"_apparenet-tps":                        "appareNet Test Packet Sequencer",
	"_apparenet-as":                         "appareNet Analysis Server",
	"_apparenet-ui":                         "appareNet User Interface",
	"_triomotion":                           "Trio Motion Control Port",
	"_sysorb":                               "SysOrb Monitoring Server",
	"_sdp-id-port":                          "Session Description ID",
	"_timelot":                              "Timelot Port",
	"_onesaf":                               "OneSAF",
	"_vieo-fe":                              "VIEO Fabric Executive",
	"_dvt-system":                           "DVT SYSTEM PORT",
	"_dvt-data":                             "DVT DATA LINK",
	"_procos-lm":                            "PROCOS LM",
	"_ssp":                                  "State Sync Protocol",
	"_hicp":                                 "HMS hicp port",
	"_sysscanner":                           "Sys Scanner",
	"_dhe":                                  "DHE port",
	"_pda-data":                             "PDA Data",
	"_pda-sys":                              "PDA System",
	"_semaphore":                            "Semaphore Connection Port",
	"_cpqrpm-agent":                         "Compaq RPM Agent Port",
	"_cpqrpm-server":                        "Compaq RPM Server Port",
	"_ivecon-port":                          "Ivecon Server Port",
	"_epncdp2":                              "Epson Network Common Devi",
	"_iscsi-target":                         "iSCSI port",
	"_winshadow":                            "winShadow",
	"_necp":                                 "NECP",
	"_ecolor-imager":                        "E-Color Enterprise Imager",
	"_ccmail":                               "cc:mail/lotus",
	"_altav-tunnel":                         "Altav Tunnel",
	"_ns-cfg-server":                        "NS CFG Server",
	"_ibm-dial-out":                         "IBM Dial Out",
	"_msft-gc":                              "Microsoft Global Catalog",
	"_msft-gc-ssl":                          "Microsoft Global Catalog with LDAP/SSL",
	"_verismart":                            "Verismart",
	"_csoft-prev":                           "CSoft Prev Port",
	"_user-manager":                         "Fujitsu User Manager",
	"_sxmp":                                 "Simple Extensible Multiplexed Protocol",
	"_ordinox-server":                       "Ordinox Server",
	"_samd":                                 "SAMD",
	"_maxim-asics":                          "Maxim ASICs",
	"_awg-proxy":                            "AWG Proxy",
	"_lkcmserver":                           "LKCM Server",
	"_admind":                               "admind",
	"_vs-server":                            "VS Server",
	"_sysopt":                               "SYSOPT",
	"_datusorb":                             "Datusorb",
	"_apple remote desktop (net assistant)": "Net Assistant",
	"_4talk":                                "4Talk",
	"_plato":                                "Plato",
	"_e-net":                                "E-Net",
	"_directvdata":                          "DIRECTVDATA",
	"_cops":                                 "COPS",
	"_enpc":                                 "ENPC",
	"_caps-lm":                              "CAPS LOGISTICS TOOLKIT - LM",
	"_sah-lm":                               "S A Holditch & Associates - LM",
	"_cart-o-rama":                          "Cart O Rama",
	"_fg-fps":                               "fg-fps",
	"_fg-gip":                               "fg-gip",
	"_dyniplookup":                          "Dynamic IP Lookup",
	"_rib-slm":                              "Rib License Manager",
	"_cytel-lm":                             "Cytel License Manager",
	"_deskview":                             "DeskView",
	"_pdrncs":                               "pdrncs",
	"_ceph":                                 "Ceph monitor",
	"_tarantool":                            "Tarantool in-memory computing platform",
	"_mcs-fastmail":                         "MCS Fastmail",
	"_opsession-clnt":                       "OP Session Client",
	"_opsession-srvr":                       "OP Session Server",
	"_odette-ftp":                           "ODETTE-FTP",
	"_mysql":                                "MySQL",
	"_opsession-prxy":                       "OP Session Proxy",
	"_tns-server":                           "TNS Server",
	"_tns-adv":                              "TNS ADV",
	"_dyna-access":                          "Dyna Access",
	"_mcns-tel-ret":                         "MCNS Tel Ret",
	"_appman-server":                        "Application Management Server",
	"_uorb":                                 "Unify Object Broker",
	"_uohost":                               "Unify Object Host",
	"_cdid":                                 "CDID",
	"_aicc-cmi":                             "AICC/CMI",
	"_vsaiport":                             "VSAI PORT",
	"_ssrip":                                "Swith to Swith Routing Information Protocol",
	"_sdt-lmd":                              "SDT License Manager",
	"_officelink2000":                       "Office Link 2000",
	"_vnsstr":                               "VNSSTR",
	"_active-net":                           "Active Networks",
	"_sftu":                                 "SFTU",
	"_bbars":                                "BBARS",
	"_egptlm":                               "Eaglepoint License Manager",
	"_hp-device-disc":                       "HP Device Disc",
	"_mcs-calypsoicf":                       "MCS Calypso ICF",
	"_mcs-messaging":                        "MCS Messaging",
	"_mcs-mailsvr":                          "MCS Mail Server",
	"_dec-notes":                            "DEC Notes",
	"_directv-web":                          "Direct TV Webcasting",
	"_directv-soft":                         "Direct TV Software Updates",
	"_directv-tick":                         "Direct TV Tickers",
	"_directv-catlg":                        "Direct TV Data Catalog",
	"_anet-b":                               "OMF data b",
	"_anet-l":                               "OMF data l",
	"_anet-m":                               "OMF data m",
	"_anet-h":                               "OMF data h",
	"_webtie":                               "WebTIE",
	"_ms-cluster-net":                       "MS Cluster Net",
	"_bnt-manager":                          "BNT Manager",
	"_influence":                            "Influence",
	"_trnsprntproxy":                        "Trnsprnt Proxy",
	"_phoenix-rpc":                          "Phoenix RPC",
	"_pangolin-laser":                       "Pangolin Laser",
	"_chevinservices":                       "Chevin Services",
	"_findviatv":                            "FINDVIATV",
	"_btrieve":                              "Btrieve port",
	"_ssql":                                 "Scalable SQL",
	"_fatpipe":                              "FATPIPE",
	"_suitjd":                               "SUITJD",
	"_ordinox-dbase":                        "Ordinox Dbase",
	"_upnotifyps":                           "UPNOTIFYPS",
	"_adtech-test":                          "Adtech Test IP",
	"_mpsysrmsvr":                           "Mp Sys Rmsvr",
	"_wg-netforce":                          "WG NetForce",
	"_kv-server":                            "KV Server",
	"_kv-agent":                             "KV Agent",
	"_dj-ilm":                               "DJ ILM",
	"_nati-vi-server":                       "NATI Vi Server",
	"_satvid-datalnk":                       "Satellite Video Data Link",
	"_tip2":                                 "TIP 2",
	"_lavenir-lm":                           "Lavenir License Manager",
	"_cluster-disc":                         "Cluster Disc",
	"_vsnm-agent":                           "VSNM Agent",
	"_cdbroker":                             "CD Broker",
	"_cogsys-lm":                            "Cogsys Network License Manager",
	"_wsicopy":                              "WSICOPY",
	"_socorfs":                              "SOCORFS",
	"_sns-channels":                         "SNS Channels",
	"_geneous":                              "Geneous",
	"_fujitsu-neat":                         "Fujitsu Network Enhanced Antitheft function",
	"_esp-lm":                               "Enterprise Software Products License Manager",
	"_hp-clic":                              "Cluster Management Services",
	"_qnxnetman":                            "qnxnetman",
	"_gprs-data":                            "GPRS Data",
	"_gprs-sig":                             "GPRS SIG",
	"_backroomnet":                          "Back Room Net",
	"_cbserver":                             "CB Server",
	"_ms-wbt-server":                        "MS WBT Server",
	"_dsc":                                  "Distributed Service Coordinator",
	"_savant":                               "SAVANT",
	"_efi-lm":                               "EFI License Management",
	"_d2k-tapestry1":                        "D2K Tapestry Client to Server",
	"_d2k-tapestry2":                        "D2K Tapestry Server to Server",
	"_dyna-lm":                              "Dyna License Manager (Elam)",
	"_printer-agent":                        "Printer Agent IANA assigned this well-formed service name as a replacement for 'printer_agent'.",
	"_printer_agent":                        "Printer Agent",
	"_cloanto-lm":                           "Cloanto License Manager",
	"_mercantile":                           "Mercantile",
	"_csms":                                 "CSMS",
	"_csms2":                                "CSMS2",
	"_filecast":                             "filecast",
	"_fxaengine-net":                        "FXa Engine Network Port",
	"_nokia-ann-ch1":                        "Nokia Announcement ch 1",
	"_nokia-ann-ch2":                        "Nokia Announcement ch 2",
	"_ldap-admin":                           "LDAP admin server port",
	"_besapi":                               "BES Api Port",
	"_networklens":                          "NetworkLens Event Port",
	"_networklenss":                         "NetworkLens SSL Event",
	"_biolink-auth":                         "BioLink Authenteon server",
	"_xmlblaster":                           "xmlBlaster",
	"_svnet":                                "SpecView Networking",
	"_wip-port":                             "BroadCloud WIP Port",
	"_bcinameservice":                       "BCI Name Service",
	"_commandport":                          "AirMobile IS Command Port",
	"_csvr":                                 "ConServR file translation",
	"_rnmap":                                "Remote nmap",
	"_softaudit":                            "Isogon SoftAudit",
	"_ifcp-port":                            "iFCP User Port",
	"_bmap":                                 "Bull Apprise portmapper",
	"_rusb-sys-port":                        "Remote USB System Port",
	"_xtrm":                                 "xTrade Reliable Messaging",
	"_xtrms":                                "xTrade over TLS/SSL",
	"_agps-port":                            "AGPS Access Port",
	"_arkivio":                              "Arkivio Storage Protocol",
	"_websphere-snmp":                       "WebSphere SNMP",
	"_twcss":                                "2Wire CSS",
	"_gcsp":                                 "GCSP user port",
	"_ssdispatch":                           "Scott Studios Dispatch",
	"_ndl-als":                              "Active License Server Port",
	"_osdcp":                                "Secure Device Protocol",
	"_opnet-smp":                            "OPNET Service Management Platform",
	"_opencm":                               "OpenCM Server",
	"_pacom":                                "Pacom Security User Port",
	"_gc-config":                            "GuardControl Exchange Protocol",
	"_autocueds":                            "Autocue Directory Service",
	"_spiral-admin":                         "Spiralcraft Admin",
	"_hri-port":                             "HRI Interface Port",
	"_ans-console":                          "Net Steward Mgmt Console",
	"_connect-client":                       "OC Connect Client",
	"_connect-server":                       "OC Connect Server",
	"_ov-nnm-websrv":                        "OpenView Network Node Manager WEB Server",
	"_denali-server":                        "Denali Server",
	"_monp":                                 "Media Object Network Protocol",
	"_3comfaxrpc":                           "3Com FAX RPC port",
	"_directnet":                            "DirectNet IM System",
	"_dnc-port":                             "Discovery and Net Config",
	"_hotu-chat":                            "HotU Chat",
	"_castorproxy":                          "CAStorProxy",
	"_asam":                                 "ASAM Services",
	"_sabp-signal":                          "SABP-Signalling Protocol",
	"_pscupd":                               "PSC Update",
	"_mira":                                 "Apple Remote Access Protocol",
	"_prsvp":                                "RSVP Port",
	"_vat":                                  "VAT default data",
	"_vat-control":                          "VAT default control",
	"_d3winosfi":                            "D3WinOSFI",
	"_integral":                             "TIP Integral",
	"_edm-manager":                          "EDM Manger",
	"_edm-stager":                           "EDM Stager",
	"_edm-std-notify":                       "EDM STD Notify",
	"_edm-adm-notify":                       "EDM ADM Notify",
	"_edm-mgr-sync":                         "EDM MGR Sync",
	"_edm-mgr-cntrl":                        "EDM MGR Cntrl",
	"_workflow":                             "WORKFLOW",
	"_rcst":                                 "RCST",
	"_ttcmremotectrl":                       "TTCM Remote Controll",
	"_pluribus":                             "Pluribus",
	"_jt400":                                "jt400",
	"_jt400-ssl":                            "jt400-ssl",
	"_jaugsremotec-1":                       "JAUGS N-G Remotec 1",
	"_jaugsremotec-2":                       "JAUGS N-G Remotec 2",
	"_ttntspauto":                           "TSP Automation",
	"_genisar-port":                         "Genisar Comm Port",
	"_nppmp":                                "NVIDIA Mgmt Protocol",
	"_ecomm":                                "eComm link port",
	"_stun":                                 "Session Traversal Utilities for NAT (STUN) port",
	"_turn":                                 "TURN over TCP",
	"_stun-behavior":                        "STUN Behavior Discovery over TCP",
	"_twrpc":                                "2Wire RPC",
	"_plethora":                             "Secure Virtual Workspace",
	"_cleanerliverc":                        "CleanerLive remote ctrl",
	"_vulture":                              "Vulture Monitoring System",
	"_slim-devices":                         "Slim Devices Protocol",
	"_gbs-stp":                              "GBS SnapTalk Protocol",
	"_celatalk":                             "CelaTalk",
	"_ifsf-hb-port":                         "IFSF Heartbeat Port",
	"_ltctcp":                               "LISA TCP Transfer Channel",
	"_ltcudp":                               "LISA UDP Transfer Channel",
	"_fs-rh-srv":                            "FS Remote Host Server",
	"_dtp-dia":                              "DTP/DIA",
	"_colubris":                             "Colubris Management Port",
	"_swr-port":                             "SWR Port",
	"_tvdumtray-port":                       "TVDUM Tray Port",
	"_nut":                                  "Network UPS Tools",
	"_ibm3494":                              "IBM 3494",
	"_seclayer-tcp":                         "securitylayer over tcp",
	"_seclayer-tls":                         "securitylayer over tls",
	"_ipether232port":                       "ipEther232Port",
	"_dashpas-port":                         "DASHPAS user port",
	"_sccip-media":                          "SccIP Media",
	"_rtmp-port":                            "RTMP Port",
	"_isoft-p2p":                            "iSoft-P2P",
	"_avinstalldisc":                        "Avocent Install Discovery",
	"_lsp-ping":                             "MPLS LSP-echo Port",
	"_ironstorm":                            "IronStorm game server",
	"_ccmcomm":                              "CCM communications port",
	"_apc-3506":                             "APC 3506",
	"_nesh-broker":                          "Nesh Broker Port",
	"_interactionweb":                       "Interaction Web",
	"_vt-ssl":                               "Virtual Token SSL Port",
	"_xss-port":                             "XSS Port",
	"_webmail-2":                            "WebMail/2",
	"_aztec":                                "Aztec Distribution Port",
	"_arcpd":                                "Adaptec Remote Protocol",
	"_must-p2p":                             "MUST Peer to Peer",
	"_must-backplane":                       "MUST Backplane",
	"_smartcard-port":                       "Smartcard Port",
	"_802-11-iapp":                          "IEEE 802.11 WLANs WG IAPP",
	"_artifact-msg":                         "Artifact Message Server",
	"_nvmsgd":                               "Netvion Messenger Port",
	"_galileo":                              "Netvion Galileo Port",
	"_galileolog":                           "Netvion Galileo Log Port",
	"_mc3ss":                                "Telequip Labs MC3SS",
	"_nssocketport":                         "DO over NSSocketPort",
	"_odeumservlink":                        "Odeum Serverlink",
	"_ecmport":                              "ECM Server port",
	"_eisport":                              "EIS Server port",
	"_starquiz-port":                        "starQuiz Port",
	"_beserver-msg-q":                       "VERITAS Backup Exec Server",
	"_jboss-iiop":                           "JBoss IIOP",
	"_jboss-iiop-ssl":                       "JBoss IIOP/SSL",
	"_gf":                                   "Grid Friendly",
	"_joltid":                               "Joltid",
	"_raven-rmp":                            "Raven Remote Management Control",
	"_raven-rdp":                            "Raven Remote Management Data",
	"_urld-port":                            "URL Daemon Port",
	"_ms-la":                                "MS-LA",
	"_snac":                                 "SNAC",
	"_ni-visa-remote":                       "Remote NI-VISA port",
	"_ibm-diradm":                           "IBM Directory Server",
	"_ibm-diradm-ssl":                       "IBM Directory Server SSL",
	"_pnrp-port":                            "PNRP User Port",
	"_voispeed-port":                        "VoiSpeed Port",
	"_hacl-monitor":                         "HA cluster monitor",
	"_qftest-lookup":                        "qftest Lookup Port",
	"_teredo":                               "Teredo Port",
	"_camac":                                "CAMAC equipment",
	"_symantec-sim":                         "Symantec SIM",
	"_interworld":                           "Interworld",
	"_tellumat-nms":                         "Tellumat MDR NMS",
	"_ssmpp":                                "Secure SMPP",
	"_apcupsd":                              "Apcupsd Information Port",
	"_taserver":                             "TeamAgenda Server Port",
	"_rbr-discovery":                        "Red Box Recorder ADP",
	"_questnotify":                          "Quest Notification Server",
	"_razor":                                "Vipul's Razor",
	"_sky-transport":                        "Sky Transport Protocol",
	"_personalos-001":                       "PersonalOS Comm Port",
	"_mcp-port":                             "MCP user port",
	"_cctv-port":                            "CCTV control port",
	"_iniserve-port":                        "INIServe port",
	"_bmc-onekey":                           "BMC-OneKey",
	"_sdbproxy":                             "SDBProxy",
	"_watcomdebug":                          "Watcom Debug",
	"_esimport":                             "Electromed SIM port",
	"_m2pa":                                 "M2PA",
	"_quest-data-hub":                       "Quest Data Hub",
	"_dof-eps":                              "DOF Protocol Stack",
	"_dof-tunnel-sec":                       "DOF Secure Tunnel",
	"_mbg-ctrl":                             "Meinberg Control Service",
	"_mccwebsvr-port":                       "MCC Web Server Port",
	"_megardsvr-port":                       "MegaRAID Server Port",
	"_megaregsvrport":                       "Registration Server Port",
	"_tag-ups-1":                            "Advantage Group UPS Suite",
	"_dmaf-server":                          "DMAF Server",
	"_dmaf-caster":                          "DMAF Caster",
	"_ccm-port":                             "Coalsere CCM Port",
	"_cmc-port":                             "Coalsere CMC Port",
	"_config-port":                          "Configuration Port",
	"_data-port":                            "Data Port",
	"_ttat3lb":                              "Tarantella Load Balancing",
	"_nati-svrloc":                          "NATI-ServiceLocator",
	"_kfxaclicensing":                       "Ascent Capture Licensing",
	"_press":                                "PEG PRESS Server",
	"_canex-watch":                          "CANEX Watch System",
	"_u-dbap":                               "U-DBase Access Protocol",
	"_emprise-lls":                          "Emprise License Server",
	"_emprise-lsc":                          "License Server Console",
	"_p2pgroup":                             "Peer to Peer Grouping",
	"_sentinel":                             "Sentinel Server",
	"_isomair":                              "isomair",
	"_wv-csp-sms":                           "WV CSP SMS Binding",
	"_gtrack-server":                        "LOCANIS G-TRACK Server",
	"_gtrack-ne":                            "LOCANIS G-TRACK NE Port",
	"_bpmd":                                 "BP Model Debugger",
	"_mediaspace":                           "MediaSpace",
	"_shareapp":                             "ShareApp",
	"_iw-mmogame":                           "Illusion Wireless MMOG",
	"_a14":                                  "A14 (AN-to-SC/MM)",
	"_a15":                                  "A15 (AN-to-AN)",
	"_quasar-server":                        "Quasar Accounting Server",
	"_trap-daemon":                          "text relay-answer",
	"_visinet-gui":                          "Visinet Gui",
	"_infiniswitchcl":                       "InfiniSwitch Mgr Client",
	"_int-rcv-cntrl":                        "Integrated Rcvr Control",
	"_bmc-jmx-port":                         "BMC JMX Port",
	"_comcam-io":                            "ComCam IO Port",
	"_splitlock":                            "Splitlock Server",
	"_precise-i3":                           "Precise I3",
	"_trendchip-dcp":                        "Trendchip control protocol",
	"_cpdi-pidas-cm":                        "CPDI PIDAS Connection Mon",
	"_echonet":                              "ECHONET",
	"_six-degrees":                          "Six Degrees Port",
	"_dataprotector":                        "Micro Focus Data Protector",
	"_alaris-disc":                          "Alaris Device Discovery",
	"_sigma-port":                           "Satchwell Sigma",
	"_start-network":                        "Start Messaging Network",
	"_cd3o-protocol":                        "cd3o Control Protocol",
	"_sharp-server":                         "ATI SHARP Logic Engine",
	"_aairnet-1":                            "AAIR-Network 1",
	"_aairnet-2":                            "AAIR-Network 2",
	"_ep-pcp":                               "EPSON Projector Control Port",
	"_ep-nsp":                               "EPSON Network Screen Port",
	"_ff-lr-port":                           "FF LAN Redundancy Port",
	"_haipe-discover":                       "HAIPIS Dynamic Discovery",
	"_dist-upgrade":                         "Distributed Upgrade Port",
	"_volley":                               "Volley",
	"_bvcdaemon-port":                       "bvControl Daemon",
	"_jamserverport":                        "Jam Server Port",
	"_ept-machine":                          "EPT Machine Interface",
	"_escvpnet":                             "ESC/VP.net",
	"_cs-remote-db":                         "C&S Remote Database Port",
	"_cs-services":                          "C&S Web Services Port",
	"_distcc":                               "distributed compiler",
	"_wacp":                                 "Wyrnix AIS port",
	"_hlibmgr":                              "hNTSP Library Manager",
	"_sdo":                                  "Simple Distributed Objects",
	"_servistaitsm":                         "SerVistaITSM",
	"_scservp":                              "Customer Service Port",
	"_ehp-backup":                           "EHP Backup Protocol",
	"_xap-ha":                               "Extensible Automation",
	"_netplay-port1":                        "Netplay Port 1",
	"_netplay-port2":                        "Netplay Port 2",
	"_juxml-port":                           "Juxml Replication port",
	"_audiojuggler":                         "AudioJuggler",
	"_ssowatch":                             "ssowatch",
	"_cyc":                                  "Cyc",
	"_xss-srv-port":                         "XSS Server Port",
	"_splitlock-gw":                         "Splitlock Gateway",
	"_fjcp":                                 "Fujitsu Cooperation Port",
	"_nmmp":                                 "Nishioka Miyuki Msg Protocol",
	"_prismiq-plugin":                       "PRISMIQ VOD plug-in",
	"_xrpc-registry":                        "XRPC Registry",
	"_vxcrnbuport":                          "VxCR NBU Default Port",
	"_tsp":                                  "Tunnel Setup Protocol",
	"_vaprtm":                               "VAP RealTime Messenger",
	"_abatemgr":                             "ActiveBatch Exec Agent",
	"_abatjss":                              "ActiveBatch Job Scheduler",
	"_immedianet-bcn":                       "ImmediaNet Beacon",
	"_ps-ams":                               "PlayStation AMS (Secure)",
	"_apple-sasl":                           "Apple SASL",
	"_can-nds-ssl":                          "IBM Tivoli Directory Service using SSL",
	"_can-ferret-ssl":                       "IBM Tivoli Directory Service using SSL",
	"_pserver":                              "pserver",
	"_dtp":                                  "DIRECWAY Tunnel Protocol",
	"_ups-engine":                           "UPS Engine Port",
	"_ent-engine":                           "Enterprise Engine Port",
	"_eserver-pap":                          "IBM eServer PAP",
	"_infoexch":                             "IBM Information Exchange",
	"_dell-rm-port":                         "Dell Remote Management",
	"_casanswmgmt":                          "CA SAN Switch Management",
	"_smile":                                "SMILE TCP/UDP Interface",
	"_efcp":                                 "e Field Control (EIBnet)",
	"_lispworks-orb":                        "LispWorks ORB",
	"_mediavault-gui":                       "Openview Media Vault GUI",
	"_wininstall-ipc":                       "WinINSTALL IPC Port",
	"_calltrax":                             "CallTrax Data Port",
	"_va-pacbase":                           "VisualAge Pacbase server",
	"_roverlog":                             "RoverLog IPC",
	"_ipr-dglt":                             "DataGuardianLT",
	"_escale (newton dock)":                 "Newton Dock",
	"_npds-tracker":                         "NPDS Tracker",
	"_bts-x73":                              "BTS X73 Port",
	"_cas-mapi":                             "EMC SmartPackets-MAPI",
	"_bmc-ea":                               "BMC EDV/EA",
	"_faxstfx-port":                         "FAXstfX",
	"_dsx-agent":                            "DS Expert Agent",
	"_tnmpv2":                               "Trivial Network Management",
	"_simple-push":                          "simple-push",
	"_simple-push-s":                        "simple-push Secure",
	"_daap":                                 "Digital Audio Access Protocol (iTunes)",
	"_svn":                                  "Subversion",
	"_magaya-network":                       "Magaya Network Port",
	"_intelsync":                            "Brimstone IntelSync",
	"_easl":                                 "Emergency Automatic Structure Lockdown System",
	"_bmc-data-coll":                        "BMC Data Collection",
	"_telnetcpcd":                           "Telnet Com Port Control",
	"_nw-license":                           "NavisWorks License System",
	"_sagectlpanel":                         "SAGECTLPANEL",
	"_kpn-icw":                              "Internet Call Waiting",
	"_lrs-paging":                           "LRS NetPage",
	"_netcelera":                            "NetCelera",
	"_ws-discovery":                         "Web Service Discovery",
	"_adobeserver-3":                        "Adobe Server 3",
	"_adobeserver-4":                        "Adobe Server 4",
	"_adobeserver-5":                        "Adobe Server 5",
	"_rt-event":                             "Real-Time Event Port",
	"_rt-event-s":                           "Real-Time Event Secure Port",
	"_sun-as-iiops":                         "Sun App Svr - Naming",
	"_ca-idms":                              "CA-IDMS Server",
	"_portgate-auth":                        "PortGate Authentication",
	"_edb-server2":                          "EBD Server 2",
	"_sentinel-ent":                         "Sentinel Enterprise",
	"_tftps":                                "TFTP over TLS",
	"_delos-dms":                            "DELOS Direct Messaging",
	"_anoto-rendezv":                        "Anoto Rendezvous Port",
	"_wv-csp-sms-cir":                       "WV CSP SMS CIR Channel",
	"_wv-csp-udp-cir":                       "WV CSP UDP/IP CIR Channel",
	"_opus-services":                        "OPUS Server Port",
	"_itelserverport":                       "iTel Server Port",
	"_ufastro-instr":                        "UF Astro. Instr. Services",
	"_xsync":                                "Xsync",
	"_xserveraid":                           "Xserve RAID",
	"_sychrond":                             "Sychron Service Daemon",
	"_blizwow":                              "World of Warcraft",
	"_na-er-tip":                            "Netia NA-ER Port",
	"_array-manager":                        "Xyratex Array Manager",
	"_e-mdu":                                "Ericsson Mobile Data Unit",
	"_e-woa":                                "Ericsson Web on Air",
	"_fksp-audit":                           "Fireking Audit Port",
	"_client-ctrl":                          "Client Control",
	"_smap":                                 "Service Manager",
	"_m-wnn":                                "Mobile Wnn",
	"_multip-msg":                           "Multipuesto Msg Port",
	"_synel-data":                           "Synel Data Collection Port",
	"_pwdis":                                "Password Distribution",
	"_rs-rmi":                               "RealSpace RMI",
	"_xpanel":                               "XPanel Daemon",
	"_versatalk":                            "versaTalk Server Port",
	"_launchbird-lm":                        "Launchbird LicenseManager",
	"_heartbeat":                            "Heartbeat Protocol",
	"_wysdma":                               "WysDM Agent",
	"_cst-port":                             "CST - Configuration & Service Tracker",
	"_ipcs-command":                         "IP Control Systems Ltd.",
	"_sasg":                                 "SASG",
	"_gw-call-port":                         "GWRTC Call Port",
	"_linktest":                             "LXPRO.COM LinkTest",
	"_linktest-s":                           "LXPRO.COM LinkTest SSL",
	"_webdata":                              "webData",
	"_cimtrak":                              "CimTrak",
	"_cbos-ip-port":                         "CBOS/IP ncapsalation port",
	"_gprs-cube":                            "CommLinx GPRS Cube",
	"_vipremoteagent":                       "Vigil-IP RemoteAgent",
	"_nattyserver":                          "NattyServer Port",
	"_timestenbroker":                       "TimesTen Broker Port",
	"_sas-remote-hlp":                       "SAS Remote Help Server",
	"_canon-capt":                           "Canon CAPT Port",
	"_grf-port":                             "GRF Server Port",
	"_apw-registry":                         "apw RMI registry",
	"_exapt-lmgr":                           "Exapt License Manager",
	"_adtempusclient":                       "adTempus Client",
	"_gsakmp":                               "gsakmp port",
	"_gbs-smp":                              "GBS SnapMail Protocol",
	"_xo-wave":                              "XO Wave Control Port",
	"_mni-prot-rout":                        "MNI Protected Routing",
	"_rtraceroute":                          "Remote Traceroute",
	"_sitewatch-s":                          "SSL e-watch sitewatch server",
	"_listmgr-port":                         "ListMGR Port",
	"_rblcheckd":                            "rblcheckd server daemon",
	"_haipe-otnk":                           "HAIPE Network Keying",
	"_cindycollab":                          "Cinderella Collaboration",
	"_paging-port":                          "RTP Paging Port",
	"_ctp":                                  "Chantry Tunnel Protocol",
	"_ctdhercules":                          "ctdhercules",
	"_zicom":                                "ZICOM",
	"_ispmmgr":                              "ISPM Manager Port",
	"_dvcprov-port":                         "Device Provisioning Port",
	"_jibe-eb":                              "Jibe EdgeBurst",
	"_c-h-it-port":                          "Cutler-Hammer IT Port",
	"_cognima":                              "Cognima Replication",
	"_nnp":                                  "Nuzzler Network Protocol",
	"_abcvoice-port":                        "ABCvoice server port",
	"_iso-tp0s":                             "Secure ISO TP0 port",
	"_bim-pem":                              "Impact Mgr./PEM Gateway",
	"_bfd-control":                          "BFD Control Protocol",
	"_bfd-echo":                             "BFD Echo Protocol",
	"_upstriggervsw":                        "VSW Upstrigger port",
	"_fintrx":                               "Fintrx",
	"_isrp-port":                            "SPACEWAY Routing port",
	"_remotedeploy":                         "RemoteDeploy Administration Port [July 2003]",
	"_quickbooksrds":                        "QuickBooks RDS",
	"_tvnetworkvideo":                       "TV NetworkVideo Data port",
	"_sitewatch":                            "e-Watch Corporation SiteWatch",
	"_dcsoftware":                           "DataCore Software",
	"_jaus":                                 "JAUS Robots",
	"_myblast":                              "myBLAST Mekentosj port",
	"_spw-dialer":                           "Spaceway Dialer",
	"_idps":                                 "idps",
	"_minilock":                             "Minilock",
	"_radius-dynauth":                       "RADIUS Dynamic Authorization",
	"_pwgpsi":                               "Print Services Interface",
	"_ibm-mgr":                              "ibm manager service",
	"_vhd":                                  "VHD",
	"_soniqsync":                            "SoniqSync",
	"_iqnet-port":                           "Harman IQNet Port",
	"_tcpdataserver":                        "ThorGuard Server Port",
	"_wsmlb":                                "Remote System Manager",
	"_spugna":                               "SpuGNA Communication Port",
	"_sun-as-iiops-ca":                      "Sun App Svr-IIOPClntAuth",
	"_apocd":                                "Java Desktop System Configuration Agent",
	"_wlanauth":                             "WLAN AS server",
	"_amp":                                  "AMP",
	"_neto-wol-server":                      "netO WOL Server",
	"_rap-ip":                               "Rhapsody Interface Protocol",
	"_neto-dcs":                             "netO DCS",
	"_lansurveyorxml":                       "LANsurveyor XML",
	"_sunlps-http":                          "Sun Local Patch Server",
	"_tapeware":                             "Yosemite Tech Tapeware",
	"_crinis-hb":                            "Crinis Heartbeat",
	"_epl-slp":                              "EPL Sequ Layer Protocol",
	"_scp":                                  "Siemens AuD SCP",
	"_pmcp":                                 "ATSC PMCP Standard",
	"_acp-discovery":                        "Compute Pool Discovery",
	"_acp-conduit":                          "Compute Pool Conduit",
	"_acp-policy":                           "Compute Pool Policy",
	"_ffserver":                             "Antera FlowFusion Process Simulation",
	"_warmux":                               "WarMUX game server",
	"_netmpi":                               "Netadmin Systems MPI service",
	"_neteh":                                "Netadmin Systems Event Handler",
	"_neteh-ext":                            "Netadmin Systems Event Handler External",
	"_cernsysmgmtagt":                       "Cerner System Management Agent",
	"_dvapps":                               "Docsvault Application Service",
	"_xxnetserver":                          "xxNETserver",
	"_aipn-auth":                            "AIPN LS Authentication",
	"_spectardata":                          "Spectar Data Stream Service",
	"_spectardb":                            "Spectar Database Rights Service",
	"_markem-dcp":                           "MARKEM NEXTGEN DCP",
	"_mkm-discovery":                        "MARKEM Auto-Discovery",
	"_sos":                                  "Scito Object Server",
	"_amx-rms":                              "AMX Resource Management Suite",
	"_flirtmitmir":                          "www.FlirtMitMir.de",
	"_shiprush-db-svr":                      "ShipRush Database Server",
	"_nhci":                                 "NHCI status port",
	"_quest-agent":                          "Quest Common Agent",
	"_rnm":                                  "RNM",
	"_v-one-spp":                            "V-ONE Single Port Proxy",
	"_an-pcp":                               "Astare Network PCP",
	"_msfw-control":                         "MS Firewall Control",
	"_item":                                 "IT Environmental Monitor",
	"_spw-dnspreload":                       "SPACEWAY DNS Preload",
	"_qtms-bootstrap":                       "QTMS Bootstrap Protocol",
	"_spectraport":                          "SpectraTalk Port",
	"_sse-app-config":                       "SSE App Configuration",
	"_sscan":                                "SONY scanning protocol",
	"_stryker-com":                          "Stryker Comm Port",
	"_opentrac":                             "OpenTRAC",
	"_informer":                             "INFORMER",
	"_trap-port":                            "Trap Port",
	"_trap-port-mom":                        "Trap Port MOM",
	"_nav-port":                             "Navini Port",
	"_sasp":                                 "Server/Application State Protocol (SASP)",
	"_winshadow-hd":                         "winShadow Host Discovery",
	"_giga-pocket":                          "GIGA-POCKET",
	"_asap-tcp":                             "asap tcp port",
	"_asap-udp":                             "asap udp port",
	"_asap-sctp":                            "asap sctp",
	"_asap-tcp-tls":                         "asap/tls tcp port",
	"_asap-sctp-tls":                        "asap-sctp/tls",
	"_xpl":                                  "xpl automation protocol",
	"_dzdaemon":                             "Sun SDViz DZDAEMON Port",
	"_dzoglserver":                          "Sun SDViz DZOGLSERVER Port",
	"_diameter":                             "DIAMETER",
	"_ovsam-mgmt":                           "hp OVSAM MgmtServer Disco",
	"_ovsam-d-agent":                        "hp OVSAM HostAgent Disco",
	"_avocent-adsap":                        "Avocent DS Authorization",
	"_oem-agent":                            "OEM Agent",
	"_fagordnc":                             "fagordnc",
	"_sixxsconfig":                          "SixXS Configuration",
	"_pnbscada":                             "PNBSCADA",
	"_dl-agent":                             "DirectoryLockdown Agent IANA assigned this well-formed service name as a replacement for 'dl_agent'.",
	"_dl_agent":                             "DirectoryLockdown Agent",
	"_xmpcr-interface":                      "XMPCR Interface Port",
	"_fotogcad":                             "FotoG CAD interface",
	"_appss-lm":                             "appss license manager",
	"_igrs":                                 "IGRS",
	"_idac":                                 "Data Acquisition and Control",
	"_msdts1":                               "DTS Service Port",
	"_vrpn":                                 "VR Peripheral Network",
	"_softrack-meter":                       "SofTrack Metering",
	"_topflow-ssl":                          "TopFlow SSL",
	"_nei-management":                       "NEI management port",
	"_ciphire-data":                         "Ciphire Data Transport",
	"_ciphire-serv":                         "Ciphire Services",
	"_dandv-tester":                         "D and V Tester Control Port",
	"_ndsconnect":                           "Niche Data Server Connect",
	"_rtc-pm-port":                          "Oracle RTC-PM port",
	"_pcc-image-port":                       "PCC-image-port",
	"_cgi-starapi":                          "CGI StarAPI Server",
	"_syam-agent":                           "SyAM Agent Port",
	"_syam-smc":                             "SyAm SMC Service Port",
	"_sdo-tls":                              "Simple Distributed Objects over TLS",
	"_sdo-ssh":                              "Simple Distributed Objects over SSH",
	"_senip":                                "IAS, Inc. SmartEye NET Internet Protocol",
	"_itv-control":                          "ITV Port",
	"_nimsh":                                "NIM Service Handler",
	"_nimaux":                               "NIMsh Auxiliary Port",
	"_charsetmgr":                           "CharsetMGR",
	"_omnilink-port":                        "Arnet Omnilink Port",
	"_mupdate":                              "Mailbox Update (MUPDATE) protocol",
	"_topovista-data":                       "TopoVista elevation data",
	"_imoguia-port":                         "Imoguia Port",
	"_hppronetman":                          "HP Procurve NetManagement",
	"_surfcontrolcpa":                       "SurfControl CPA",
	"_prnrequest":                           "Printer Request Port",
	"_prnstatus":                            "Printer Status Port",
	"_gbmt-stars":                           "Global Maintech Stars",
	"_listcrt-port":                         "ListCREATOR Port",
	"_listcrt-port-2":                       "ListCREATOR Port 2",
	"_agcat":                                "Auto-Graphics Cataloging",
	"_wysdmc":                               "WysDM Controller",
	"_aftmux":                               "AFT multiplex port",
	"_pktcablemmcops":                       "PacketCableMultimediaCOPS",
	"_hyperip":                              "HyperIP",
	"_exasoftport1":                         "Exasoft IP Port",
	"_herodotus-net":                        "Herodotus Net",
	"_sor-update":                           "Soronti Update Port",
	"_symb-sb-port":                         "Symbian Service Broker",
	"_mpl-gprs-port":                        "MPL_GPRS_PORT",
	"_zmp":                                  "Zoran Media Port",
	"_winport":                              "WINPort",
	"_natdataservice":                       "ScsTsr",
	"_netboot-pxe":                          "PXE NetBoot Manager",
	"_smauth-port":                          "AMS Port",
	"_syam-webserver":                       "Syam Web Server Port",
	"_msr-plugin-port":                      "MSR Plugin Port",
	"_dyn-site":                             "Dynamic Site System",
	"_plbserve-port":                        "PL/B App Server User Port",
	"_sunfm-port":                           "PL/B File Manager Port",
	"_sdp-portmapper":                       "SDP Port Mapper Protocol",
	"_mailprox":                             "Mailprox",
	"_dvbservdsc":                           "DVB Service Discovery",
	"_dbcontrol-agent":                      "Oracle dbControl Agent po IANA assigned this well-formed service name as a replacement for 'dbcontrol_agent'.",
	"_dbcontrol_agent":                      "Oracle dbControl Agent po",
	"_aamp":                                 "Anti-virus Application Management Port",
	"_xecp-node":                            "XeCP Node Service",
	"_homeportal-web":                       "Home Portal Web Server",
	"_srdp":                                 "satellite distribution",
	"_tig":                                  "TetraNode Ip Gateway",
	"_sops":                                 "S-Ops Management",
	"_emcads":                               "EMCADS Server Port",
	"_backupedge":                           "BackupEDGE Server",
	"_ccp":                                  "Connect and Control Protocol for Consumer, Commercial, and Industrial Electronic Devices",
	"_apdap":                                "Anton Paar Device Administration Protocol",
	"_drip":                                 "Dynamic Routing Information Protocol",
	"_namemunge":                            "Name Munging",
	"_pwgippfax":                            "PWG IPP Facsimile",
	"_i3-sessionmgr":                        "I3 Session Manager",
	"_xmlink-connect":                       "Eydeas XMLink Connect",
	"_adrep":                                "AD Replication RPC",
	"_p2pcommunity":                         "p2pCommunity",
	"_gvcp":                                 "GigE Vision Control",
	"_mqe-broker":                           "MQEnterprise Broker",
	"_mqe-agent":                            "MQEnterprise Agent",
	"_treehopper":                           "Tree Hopper Networking",
	"_bess":                                 "Bess Peer Assessment",
	"_proaxess":                             "ProAxess Server",
	"_sbi-agent":                            "SBI Agent Protocol",
	"_thrp":                                 "Teran Hybrid Routing Protocol",
	"_sasggprs":                             "SASG GPRS",
	"_ati-ip-to-ncpe":                       "Avanti IP to NCPE API",
	"_bflckmgr":                             "BuildForge Lock Manager",
	"_ppsms":                                "PPS Message Service",
	"_ianywhere-dbns":                       "iAnywhere DBNS",
	"_landmarks":                            "Landmark Messages",
	"_lanrevagent":                          "LANrev Agent",
	"_lanrevserver":                         "LANrev Server",
	"_iconp":                                "ict-control Protocol",
	"_progistics":                           "ConnectShip Progistics",
	"_xk22":                                 "Remote Applicant Tracking Service",
	"_airshot":                              "Air Shot",
	"_opswagent":                            "Server Automation Agent",
	"_opswmanager":                          "Opsware Manager",
	"_secure-cfg-svr":                       "Secured Configuration Server",
	"_smwan":                                "Smith Micro Wide Area Network Service",
	"_starfish":                             "Starfish System Admin",
	"_eis":                                  "ESRI Image Server",
	"_eisp":                                 "ESRI Image Service",
	"_mapper-nodemgr":                       "MAPPER network node manager",
	"_mapper-mapethd":                       "MAPPER TCP/IP server",
	"_mapper-ws-ethd":                       "MAPPER workstation server IANA assigned this well-formed service name as a replacement for 'mapper-ws_ethd'.",
	"_mapper-ws_ethd":                       "MAPPER workstation server",
	"_centerline":                           "Centerline",
	"_dcs-config":                           "DCS Configuration Port",
	"_bv-queryengine":                       "BindView-Query Engine",
	"_bv-is":                                "BindView-IS",
	"_bv-smcsrv":                            "BindView-SMCServer",
	"_bv-ds":                                "BindView-DirectoryServer",
	"_bv-agent":                             "BindView-Agent",
	"_iss-mgmt-ssl":                         "ISS Management Svcs SSL",
	"_abcsoftware":                          "abcsoftware-01",
	"_agentsease-db":                        "aes_db",
	"_dnx":                                  "Distributed Nagios Executor Service",
	"_nvcnet":                               "Norman distributes scanning service",
	"_terabase":                             "Terabase",
	"_newoak":                               "NewOak",
	"_pxc-spvr-ft":                          "pxc-spvr-ft",
	"_pxc-splr-ft":                          "pxc-splr-ft",
	"_pxc-roid":                             "pxc-roid",
	"_pxc-pin":                              "pxc-pin",
	"_pxc-spvr":                             "pxc-spvr",
	"_pxc-splr":                             "pxc-splr",
	"_netcheque":                            "NetCheque accounting",
	"_chimera-hwm":                          "Chimera HWM",
	"_samsung-unidex":                       "Samsung Unidex",
	"_altserviceboot":                       "Alternate Service Boot",
	"_pda-gate":                             "PDA Gate",
	"_acl-manager":                          "ACL Manager",
	"_taiclock":                             "TAICLOCK",
	"_talarian-mcast1":                      "Talarian Mcast",
	"_talarian-mcast2":                      "Talarian Mcast",
	"_talarian-mcast3":                      "Talarian Mcast",
	"_talarian-mcast4":                      "Talarian Mcast",
	"_talarian-mcast5":                      "Talarian Mcast",
	"_trap":                                 "TRAP Port",
	"_nexus-portal":                         "Nexus Portal",
	"_dnox":                                 "DNOX",
	"_esnm-zoning":                          "ESNM Zoning Port",
	"_tnp1-port":                            "TNP1 User Port",
	"_partimage":                            "Partition Image Port",
	"_as-debug":                             "Graphical Debug Server",
	"_bxp":                                  "bitxpress",
	"_dtserver-port":                        "DTServer Port",
	"_ip-qsig":                              "IP Q signaling protocol",
	"_jdmn-port":                            "Accell/JSP Daemon Port",
	"_suucp":                                "UUCP over SSL",
	"_vrts-auth-port":                       "VERITAS Authorization Service",
	"_sanavigator":                          "SANavigator Peer Port",
	"_ubxd":                                 "Ubiquinox Daemon",
	"_wap-push-http":                        "WAP Push OTA-HTTP port",
	"_wap-push-https":                       "WAP Push OTA-HTTP secure",
	"_ravehd":                               "RaveHD network control",
	"_fazzt-ptp":                            "Fazzt Point-To-Point",
	"_fazzt-admin":                          "Fazzt Administration",
	"_yo-main":                              "Yo.net main service",
	"_houston":                              "Rocketeer-Houston",
	"_ldxp":                                 "LDXP",
	"_nirp":                                 "Neighbour Identity Resolution",
	"_ltp":                                  "Location Tracking Protocol",
	"_acp-proto":                            "Accounting Protocol",
	"_ctp-state":                            "Context Transfer Protocol",
	"_wafs":                                 "Wide Area File Services",
	"_cisco-wafs":                           "Wide Area File Services",
	"_cppdp":                                "Cisco Peer to Peer Distribution Protocol",
	"_interact":                             "VoiceConnect Interact",
	"_ccu-comm-1":                           "CosmoCall Universe Communications Port 1",
	"_ccu-comm-2":                           "CosmoCall Universe Communications Port 2",
	"_ccu-comm-3":                           "CosmoCall Universe Communications Port 3",
	"_lms":                                  "Location Message Service",
	"_wfm":                                  "Servigistics WFM server",
	"_kingfisher":                           "Kingfisher protocol",
	"_dlms-cosem":                           "DLMS/COSEM",
	"_dsmeter-iatc":                         "DSMETER Inter-Agent Transfer Channel IANA assigned this well-formed service name as a replacement for 'dsmeter_iatc'.",
	"_dsmeter_iatc":                         "DSMETER Inter-Agent Transfer Channel",
	"_ice-location":                         "Ice Location Service (TCP)",
	"_ice-slocation":                        "Ice Location Service (SSL)",
	"_ice-router":                           "Ice Firewall Traversal Service (TCP)",
	"_ice-srouter":                          "Ice Firewall Traversal Service (SSL)",
	"_avanti-cdp":                           "Avanti Common Data IANA assigned this well-formed service name as a replacement for 'avanti_cdp'.",
	"_avanti_cdp":                           "Avanti Common Data",
	"_pmas":                                 "Performance Measurement and Analysis",
	"_idp":                                  "Information Distribution Protocol",
	"_ipfltbcst":                            "IP Fleet Broadcast",
	"_minger":                               "Minger Email Address Validation Service",
	"_tripe":                                "Trivial IP Encryption (TrIPE)",
	"_aibkup":                               "Automatically Incremental Backup",
	"_zieto-sock":                           "Zieto Socket Communications",
	"_irapp":                                "Interactive Remote Application Pairing Protocol",
	"_cequint-cityid":                       "Cequint City ID UI trigger",
	"_perimlan":                             "ISC Alarm Message Service",
	"_seraph":                               "Seraph DCS",
	"_ascomalarm":                           "Ascom IP Alarming",
	"_cssp":                                 "Coordinated Security Service Protocol",
	"_santools":                             "SANtools Diagnostic Server",
	"_lorica-in":                            "Lorica inside facing",
	"_lorica-in-sec":                        "Lorica inside facing (SSL)",
	"_lorica-out":                           "Lorica outside facing",
	"_lorica-out-sec":                       "Lorica outside facing (SSL)",
	"_fortisphere-vm":                       "Fortisphere VM Service",
	"_ezmessagesrv":                         "EZNews Newsroom Message Service",
	"_ftsync":                               "Firewall/NAT state table synchronization",
	"_applusservice":                        "APplus Service",
	"_npsp":                                 "Noah Printing Service Protocol",
	"_opencore":                             "OpenCORE Remote Control Service",
	"_omasgport":                            "OMA BCAST Service Guide",
	"_ewinstaller":                          "EminentWare Installer",
	"_ewdgs":                                "EminentWare DGS",
	"_pvxpluscs":                            "Pvx Plus CS Host",
	"_sysrqd":                               "sysrq daemon",
	"_xtgui":                                "xtgui information service",
	"_bre":                                  "BRE (Bridge Relay Element)",
	"_patrolview":                           "Patrol View",
	"_drmsfsd":                              "drmsfsd",
	"_dpcp":                                 "DPCP",
	"_igo-incognito":                        "IGo Incognito Data Port",
	"_brlp-0":                               "Braille protocol",
	"_brlp-1":                               "Braille protocol",
	"_brlp-2":                               "Braille protocol",
	"_brlp-3":                               "Braille protocol",
	"_shofar":                               "Shofar",
	"_synchronite":                          "Synchronite",
	"_j-ac":                                 "JDL Accounting LAN Service",
	"_accel":                                "ACCEL",
	"_izm":                                  "Instantiated Zero-control Messaging",
	"_g2tag":                                "G2 RFID Tag Telemetry Data",
	"_xgrid":                                "Xgrid",
	"_apple-vpns-rp":                        "Apple VPN Server Reporting Protocol",
	"_aipn-reg":                             "AIPN LS Registration",
	"_jomamqmonitor":                        "JomaMQMonitor",
	"_cds":                                  "CDS Transfer Agent",
	"_smartcard-tls":                        "smartcard-TLS",
	"_hillrserv":                            "Hillr Connection Manager",
	"_netscript":                            "Netadmin Systems NETscript service",
	"_assuria-slm":                          "Assuria Log Manager",
	"_minirem":                              "MiniRem Remote Telemetry and Control",
	"_e-builder":                            "e-Builder Application Communication",
	"_fprams":                               "Fiber Patrol Alarm Service",
	"_z-wave":                               "Z-Wave Protocol",
	"_tigv2":                                "Rohill TetraNode Ip Gateway v2",
	"_opsview-envoy":                        "Opsview Envoy",
	"_ddrepl":                               "Data Domain Replication Service",
	"_unikeypro":                            "NetUniKeyServer",
	"_nufw":                                 "NuFW decision delegation protocol",
	"_nuauth":                               "NuFW authentication protocol",
	"_fronet":                               "FRONET message protocol",
	"_stars":                                "Global Maintech Stars",
	"_nuts-dem":                             "NUTS Daemon IANA assigned this well-formed service name as a replacement for 'nuts_dem'.",
	"_nuts_dem":                             "NUTS Daemon",
	"_nuts-bootp":                           "NUTS Bootp Server IANA assigned this well-formed service name as a replacement for 'nuts_bootp'.",
	"_nuts_bootp":                           "NUTS Bootp Server",
	"_nifty-hmi":                            "NIFTY-Serve HMI protocol",
	"_cl-db-attach":                         "Classic Line Database Server Attach",
	"_cl-db-request":                        "Classic Line Database Server Request",
	"_cl-db-remote":                         "Classic Line Database Server Remote",
	"_nettest":                              "nettest",
	"_thrtx":                                "Imperfect Networks Server",
	"_cedros-fds":                           "Cedros Fraud Detection System IANA assigned this well-formed service name as a replacement for 'cedros_fds'.",
	"_cedros_fds":                           "Cedros Fraud Detection System",
	"_oirtgsvc":                             "Workflow Server",
	"_oidocsvc":                             "Document Server",
	"_oidsr":                                "Document Replication",
	"_vvr-control":                          "VVR Control",
	"_tgcconnect":                           "TGCConnect Beacon",
	"_vrxpservman":                          "Multum Service Manager",
	"_hhb-handheld":                         "HHB Handheld Client",
	"_agslb":                                "A10 GSLB Service",
	"_poweralert-nsa":                       "PowerAlert Network Shutdown Agent",
	"_menandmice-noh":                       "Men & Mice Remote Control IANA assigned this well-formed service name as a replacement for 'menandmice_noh'.",
	"_menandmice_noh":                       "Men & Mice Remote Control",
	"_idig-mux":                             "iDigTech Multiplex IANA assigned this well-formed service name as a replacement for 'idig_mux'.",
	"_idig_mux":                             "iDigTech Multiplex",
	"_mbl-battd":                            "MBL Remote Battery Monitoring",
	"_atlinks":                              "atlinks device discovery",
	"_bzr":                                  "Bazaar version control system",
	"_stat-results":                         "STAT Results",
	"_stat-scanner":                         "STAT Scanner Control",
	"_stat-cc":                              "STAT Command Center",
	"_nss":                                  "Network Security Service",
	"_jini-discovery":                       "Jini Discovery",
	"_omscontact":                           "OMS Contact",
	"_omstopology":                          "OMS Topology",
	"_silverpeakpeer":                       "Silver Peak Peer Protocol",
	"_silverpeakcomm":                       "Silver Peak Communication Protocol",
	"_altcp":                                "ArcLink over Ethernet",
	"_joost":                                "Joost Peer to Peer Protocol",
	"_ddgn":                                 "DeskDirect Global Network",
	"_pslicser":                             "PrintSoft License Server",
	"_iadt":                                 "Automation Drive Interface Transport",
	"_iadt-disc":                            "Internet ADT Discovery Protocol",
	"_d-cinema-csp":                         "SMPTE Content Synchonization Protocol",
	"_ml-svnet":                             "Maxlogic Supervisor Communication",
	"_pcoip":                                "PC over IP",
	"_mma-discovery":                        "MMA Device Discovery",
	"_smcluster":                            "StorMagic Cluster Services",
	"_sm-disc":                              "StorMagic Discovery",
	"_bccp":                                 "Brocade Cluster Communication Protocol",
	"_tl-ipcproxy":                          "Translattice Cluster IPC Proxy",
	"_wello":                                "Wello P2P pubsub service",
	"_storman":                              "StorMan",
	"_maxumsp":                              "Maxum Services",
	"_httpx":                                "HTTPX",
	"_macbak":                               "MacBak",
	"_pcptcpservice":                        "Production Company Pro TCP Service",
	"_cyborgnet":                            "CyborgNet communications protocol",
	"_universe-suite":                       "UNIVERSE SUITE MESSAGE SERVICE IANA assigned this well-formed service name as a replacement for 'universe_suite'.",
	"_universe_suite":                       "UNIVERSE SUITE MESSAGE SERVICE",
	"_wcpp":                                 "Woven Control Plane Protocol",
	"_boxbackupstore":                       "Box Backup Store Service",
	"_csc-proxy":                            "Cascade Proxy IANA assigned this well-formed service name as a replacement for 'csc_proxy'.",
	"_csc_proxy":                            "Cascade Proxy",
	"_vatata":                               "Vatata Peer to Peer Protocol",
	"_pcep":                                 "Path Computation Element Communication Protocol",
	"_sieve":                                "ManageSieve Protocol",
	"_dsmipv6":                              "Dual Stack MIPv6 NAT Traversal",
	"_azeti":                                "Azeti Agent Service",
	"_azeti-bd":                             "azeti blinddate",
	"_pvxplusio":                            "PxPlus remote file srvr",
	"_spdm":                                 "Security Protocol and Data Model",
	"_aws-wsp":                              "AWS protocol for cloud remoting solution",
	"_hctl":                                 "Harman HControl Protocol",
	"_eims-admin":                           "EIMS ADMIN",
	"_vrml-multi-use":                       "VRML Multi User Systems",
	"_corelccam":                            "Corel CCam",
	"_d-data":                               "Diagnostic Data",
	"_d-data-control":                       "Diagnostic Data Control",
	"_srcp":                                 "Simple Railroad Command Protocol",
	"_owserver":                             "One-Wire Filesystem Server",
	"_batman":                               "better approach to mobile ad-hoc networking",
	"_pinghgl":                              "Hellgate London",
	"_trueconf":                             "TrueConf Videoconference Service",
	"_compx-lockview":                       "CompX-LockView",
	"_dserver":                              "Exsequi Appliance Discovery",
	"_mirrtex":                              "Mir-RT exchange service",
	"_p6ssmc":                               "P6R Secure Server Management Console",
	"_pscl-mgt":                             "Parascale Membership Manager",
	"_perrla":                               "PERRLA User Services",
	"_choiceview-agt":                       "ChoiceView Agent",
	"_choiceview-clt":                       "ChoiceView Client",
	"_opentelemetry":                        "OpenTelemetry Protocol",
	"_fox-skytale":                          "Fox SkyTale encrypted communication",
	"_fdt-rcatp":                            "FDT Remote Categorization Protocol",
	"_rwhois":                               "Remote Who Is",
	"_trim-event":                           "TRIM Event Service",
	"_trim-ice":                             "TRIM ICE Service",
	"_geognosisadmin":                       "Cadcorp GeognoSIS Administrator",
	"_geognosisman":                         "Cadcorp GeognoSIS Administrator",
	"_geognosis":                            "Cadcorp GeognoSIS",
	"_jaxer-web":                            "Jaxer Web Protocol",
	"_jaxer-manager":                        "Jaxer Manager Command Protocol",
	"_publiqare-sync":                       "PubliQare Distributed Environment Synchronisation Engine",
	"_dey-sapi":                             "DEY Storage Administration REST API",
	"_ktickets-rest":                        "ktickets REST API for event management and ticketing systems (embedded POS devices)",
	"_getty-focus":                          "Getty Images FOCUS service",
	"_ahsp":                                 "ArrowHead Service Protocol (AHSP)",
	"_netconf-ch-ssh":                       "NETCONF Call Home (SSH)",
	"_netconf-ch-tls":                       "NETCONF Call Home (TLS)",
	"_restconf-ch-tls":                      "RESTCONF Call Home (TLS)",
	"_gaia":                                 "Gaia Connector Protocol",
	"_lisp-data":                            "LISP Data Packets",
	"_lisp-control":                         "LISP Control Packets",
	"_unicall":                              "UNICALL",
	"_vinainstall":                          "VinaInstall",
	"_m4-network-as":                        "Macro 4 Network AS",
	"_elanlm":                               "ELAN LM",
	"_lansurveyor":                          "LAN Surveyor",
	"_itose":                                "ITOSE",
	"_fsportmap":                            "File System Port Map",
	"_net-device":                           "Net Device",
	"_plcy-net-svcs":                        "PLCY Net Services",
	"_pjlink":                               "Projector Link",
	"_f5-iquery":                            "F5 iQuery",
	"_qsnet-trans":                          "QSNet Transmitter",
	"_qsnet-workst":                         "QSNet Workstation",
	"_qsnet-assist":                         "QSNet Assistant",
	"_qsnet-cond":                           "QSNet Conductor",
	"_qsnet-nucl":                           "QSNet Nucleus",
	"_omabcastltkm":                         "OMA BCAST Long-Term Key Messages",
	"_matrix-vnet":                          "Matrix VNet Communication Protocol IANA assigned this well-formed service name as a replacement for 'matrix_vnet'.",
	"_matrix_vnet":                          "Matrix VNet Communication Protocol",
	"_nacnl":                                "NavCom Discovery and Control Port",
	"_afore-vdp-disc":                       "AFORE vNode Discovery protocol",
	"_shadowstream":                         "ShadowStream System",
	"_wxbrief":                              "WeatherBrief Direct",
	"_epmd":                                 "Erlang Port Mapper Daemon",
	"_elpro-tunnel":                         "ELPRO V2 Protocol Tunnel IANA assigned this well-formed service name as a replacement for 'elpro_tunnel'.",
	"_elpro_tunnel":                         "ELPRO V2 Protocol Tunnel",
	"_l2c-control":                          "LAN2CAN Control",
	"_l2c-disc":                             "LAN2CAN Discovery",
	"_l2c-data":                             "LAN2CAN Data",
	"_remctl":                               "Remote Authenticated Command Service",
	"_psi-ptt":                              "PSI Push-to-Talk Protocol",
	"_tolteces":                             "Toltec EasyShare",
	"_bip":                                  "BioAPI Interworking",
	"_cp-spxsvr":                            "Cambridge Pixel SPx Server",
	"_cp-spxdpy":                            "Cambridge Pixel SPx Display",
	"_ctdb":                                 "CTDB",
	"_xandros-cms":                          "Xandros Community Management Service",
	"_wiegand":                              "Physical Access Control",
	"_apwi-imserver":                        "American Printware IMServer Protocol",
	"_apwi-rxserver":                        "American Printware RXServer Protocol",
	"_apwi-rxspooler":                       "American Printware RXSpooler Protocol",
	"_apwi-disc":                            "American Printware Discovery",
	"_omnivisionesx":                        "OmniVision communication for Virtual environments",
	"_fly":                                  "Fly Object Space",
	"_ds-srv":                               "ASIGRA Services",
	"_ds-srvr":                              "ASIGRA Televaulting DS-System Service",
	"_ds-clnt":                              "ASIGRA Televaulting DS-Client Service",
	"_ds-user":                              "ASIGRA Televaulting DS-Client Monitoring/Management",
	"_ds-admin":                             "ASIGRA Televaulting DS-System Monitoring/Management",
	"_ds-mail":                              "ASIGRA Televaulting Message Level Restore service",
	"_ds-slp":                               "ASIGRA Televaulting DS-Sleeper Service",
	"_nacagent":                             "Network Access Control Agent",
	"_slscc":                                "SLS Technology Control Centre",
	"_netcabinet-com":                       "Net-Cabinet comunication",
	"_itwo-server":                          "RIB iTWO Application Server",
	"_found":                                "Found Messaging Protocol",
	"_smallchat":                            "SmallChat",
	"_avi-nms":                              "AVI Systems NMS",
	"_avi-nms-disc":                         "AVI Systems NMS",
	"_updog":                                "Updog Monitoring and Status Framework",
	"_brcd-vr-req":                          "Brocade Virtual Router Request",
	"_pjj-player":                           "PJJ Media Player",
	"_pjj-player-disc":                      "PJJ Media Player discovery",
	"_workflowdir":                          "Workflow Director Communication",
	"_axysbridge":                           "AXYS communication protocol",
	"_cbp":                                  "Colnod Binary Protocol",
	"_nvme":                                 "NVM Express over Fabrics storage access",
	"_scaleft":                              "Multi-Platform Remote Management for Cloud Infrastructure",
	"_tsepisp":                              "TSEP Installation Service Protocol",
	"_thingkit":                             "thingkit secure mesh",
	"_netrockey6":                           "NetROCKEY6 SMART Plus Service",
	"_beacon-port-2":                        "SMARTS Beacon Port",
	"_drizzle":                              "Drizzle database server",
	"_omviserver":                           "OMV-Investigation Server-Client",
	"_omviagent":                            "OMV Investigation Agent-Server",
	"_rsqlserver":                           "REAL SQL Server",
	"_wspipe":                               "adWISE Pipe",
	"_l-acoustics":                          "L-ACOUSTICS management",
	"_vop":                                  "Versile Object Protocol",
	"_netblox":                              "Netblox Protocol",
	"_saris":                                "Saris",
	"_pharos":                               "Pharos",
	"_krb524":                               "KRB524",
	"_nv-video":                             "NV Video default",
	"_upnotifyp":                            "UPNOTIFYP",
	"_n1-fwp":                               "N1-FWP",
	"_n1-rmgmt":                             "N1-RMGMT",
	"_asc-slmd":                             "ASC Licence Manager",
	"_privatewire":                          "PrivateWire",
	"_camp":                                 "Common ASCII Messaging Protocol",
	"_ctisystemmsg":                         "CTI System Msg",
	"_ctiprogramload":                       "CTI Program Load",
	"_nssalertmgr":                          "NSS Alert Manager",
	"_nssagentmgr":                          "NSS Agent Manager",
	"_prchat-user":                          "PR Chat User",
	"_prchat-server":                        "PR Chat Server",
	"_prregister":                           "PR Register",
	"_mcp":                                  "Matrix Configuration Protocol",
	"_ntske":                                "Network Time Security Key Establishment",
	"_hpssmgmt":                             "hpssmgmt service",
	"_assyst-dr":                            "Assyst Data Repository Service",
	"_icms":                                 "Integrated Client Message Service",
	"_prex-tcp":                             "Protocol for Remote Execution over TCP",
	"_awacs-ice":                            "Apple Wide Area Connectivity Service ICE Bootstrap",
	"_ipsec-nat-t":                          "IPsec NAT-Traversal",
	"_a25-fap-fgw":                          "A25 (FAP-FGW)",
	"_armagetronad":                         "Armagetron Advanced Game Server",
	"_ehs":                                  "Event Heap Server",
	"_ehs-ssl":                              "Event Heap Server SSL",
	"_wssauthsvc":                           "WSS Security Service",
	"_swx-gate":                             "Software Data Exchange Gateway",
	"_worldscores":                          "WorldScores",
	"_sf-lm":                                "SF License Manager (Sentinel)",
	"_lanner-lm":                            "Lanner License Manager",
	"_synchromesh":                          "Synchromesh",
	"_aegate":                               "Aegate PMR Service",
	"_gds-adppiw-db":                        "Perman I Interbase Server",
	"_ieee-mih":                             "MIH Services",
	"_menandmice-mon":                       "Men and Mice Monitoring",
	"_icshostsvc":                           "ICS host services",
	"_msfrs":                                "MS FRS Replication",
	"_rsip":                                 "RSIP Port",
	"_dtn-bundle":                           "DTN Bundle TCP CL Protocol",
	"_mtcevrunqss":                          "Marathon everRun Quorum Service Server",
	"_mtcevrunqman":                         "Marathon everRun Quorum Service Manager",
	"_hylafax":                              "HylaFAX",
	"_amahi-anywhere":                       "Amahi Anywhere",
	"_kwtc":                                 "Kids Watch Time Control Service",
	"_tram":                                 "TRAM",
	"_bmc-reporting":                        "BMC Reporting",
	"_iax":                                  "Inter-Asterisk eXchange",
	"_deploymentmap":                        "Service to distribute and update within a site deployment information for Oracle Communications Suite",
	"_cardifftec-back":                      "A port for communication between a server and client for a custom backup system",
	"_rid":                                  "RID over HTTP/TLS",
	"_l3t-at-an":                            "HRPD L3T (AT-AN)",
	"_hrpd-ith-at-an":                       "HRPD-ITH (AT-AN)",
	"_ipt-anri-anri":                        "IPT (ANRI-ANRI)",
	"_ias-session":                          "IAS-Session (ANRI-ANRI)",
	"_ias-paging":                           "IAS-Paging (ANRI-ANRI)",
	"_ias-neighbor":                         "IAS-Neighbor (ANRI-ANRI)",
	"_a21-an-1xbs":                          "A21 (AN-1xBS)",
	"_a16-an-an":                            "A16 (AN-AN)",
	"_a17-an-an":                            "A17 (AN-AN)",
	"_piranha1":                             "Piranha1",
	"_piranha2":                             "Piranha2",
	"_mtsserver":                            "EAX MTS Server",
	"_menandmice-upg":                       "Men & Mice Upgrade Agent",
	"_irp":                                  "Identity Registration Protocol",
	"_sixchat":                              "Direct End to End Secure Chat Protocol",
	"_sixid":                                "Secure ID to IP registration and lookup",
	"_ventoso":                              "Bidirectional single port remote radio VOIP and Control stream",
	"_dots-signal":                          "Distributed Denial-of-Service Open Threat Signaling (DOTS) Signal Channel Protocol. The service name is used to construct the SRV service names '_dots-signal._udp' and '_dots-signal._tcp' for discovering DOTS servers used to establish DOTS signal channel.",
	"_playsta2-app":                         "PlayStation2 App Port",
	"_playsta2-lob":                         "PlayStation2 Lobby Port",
	"_smaclmgr":                             "smaclmgr",
	"_kar2ouche":                            "Kar2ouche Peer location service",
	"_oms":                                  "OrbitNet Message Service",
	"_noteit":                               "Note It! Message Service",
	"_ems":                                  "Rimage Messaging Server",
	"_contclientms":                         "Container Client Message Service",
	"_eportcomm":                            "E-Port Message Service",
	"_mmacomm":                              "MMA Comm Services",
	"_mmaeds":                               "MMA EDS Service",
	"_eportcommdata":                        "E-Port Data Service",
	"_light":                                "Light packets transfer protocol",
	"_acter":                                "Bull RSF action server",
	"_rfa":                                  "remote file access server",
	"_cxws":                                 "CXWS Operations",
	"_appiq-mgmt":                           "AppIQ Agent Management",
	"_dhct-status":                          "BIAP Device Status",
	"_dhct-alerts":                          "BIAP Generic Alert",
	"_bcs":                                  "Business Continuity Servi",
	"_traversal":                            "boundary traversal",
	"_mgesupervision":                       "MGE UPS Supervision",
	"_mgemanagement":                        "MGE UPS Management",
	"_parliant":                             "Parliant Telephony System",
	"_finisar":                              "finisar",
	"_spike":                                "Spike Clipboard Service",
	"_rfid-rp1":                             "RFID Reader Protocol 1.0",
	"_autopac":                              "Autopac Protocol",
	"_msp-os":                               "Manina Service Protocol",
	"_nst":                                  "Network Scanner Tool FTP",
	"_mobile-p2p":                           "Mobile P2P Service",
	"_altovacentral":                        "Altova DatabaseCentral",
	"_prelude":                              "Prelude IDS message proto",
	"_mtn":                                  "monotone Netsync Protocol",
	"_conspiracy":                           "Conspiracy messaging",
	"_netxms-agent":                         "NetXMS Agent",
	"_netxms-mgmt":                          "NetXMS Management",
	"_netxms-sync":                          "NetXMS Server Synchronization",
	"_npqes-test":                           "Network Performance Quality Evaluation System Test Service",
	"_assuria-ins":                          "Assuria Insider",
	"_trinity-dist":                         "Trinity Trust Network Node Communication",
	"_truckstar":                            "TruckStar Service",
	"_a26-fap-fgw":                          "A26 (FAP-FGW)",
	"_fcis":                                 "F-Link Client Information Service",
	"_fcis-disc":                            "F-Link Client Information Service Discovery",
	"_capmux":                               "CA Port Multiplexer",
	"_gsmtap":                               "GSM Interface Tap",
	"_gearman":                              "Gearman Job Queue System",
	"_remcap":                               "Remote Capture Protocol",
	"_ohmtrigger":                           "OHM server trigger",
	"_resorcs":                              "RES Orchestration Catalog Services",
	"_ipdr-sp":                              "IPDR/SP",
	"_solera-lpn":                           "SoleraTec Locator",
	"_ipfix":                                "IP Flow Info Export",
	"_ipfixs":                               "ipfix protocol over TLS",
	"_lumimgrd":                             "Luminizer Manager",
	"_sicct":                                "SICCT",
	"_sicct-sdp":                            "SICCT Service Discovery Protocol",
	"_openhpid":                             "openhpi HPI service",
	"_ifsp":                                 "Internet File Synchronization Protocol",
	"_fmp":                                  "Funambol Mobile Push",
	"_intelliadm-disc":                      "IntelliAdmin Discovery",
	"_buschtrommel":                         "peer-to-peer file exchange protocol",
	"_profilemac":                           "Profile for Mac",
	"_ssad":                                 "Simple Service Auto Discovery",
	"_spocp":                                "Simple Policy Control Protocol",
	"_snap":                                 "Simple Network Audio Protocol",
	"_simon":                                "Simple Invocation of Methods Over Network (SIMON)",
	"_simon-disc":                           "Simple Invocation of Methods Over Network (SIMON) Discovery",
	"_gre-in-udp":                           "GRE-in-UDP Encapsulation",
	"_gre-udp-dtls":                         "GRE-in-UDP Encapsulation with DTLS",
	"_rdcenter":                             "Reticle Decision Center",
	"_converge":                             "Converge RPC",
	"_bfd-multi-ctl":                        "BFD Multihop Control",
	"_cncp":                                 "Cisco Nexus Control Protocol",
	"_smart-install":                        "Smart Install Service",
	"_sia-ctrl-plane":                       "Service Insertion Architecture (SIA) Control-Plane",
	"_xmcp":                                 "eXtensible Messaging Client Protocol",
	"_vxlan":                                "Virtual eXtensible Local Area Network (VXLAN)",
	"_vxlan-gpe":                            "Generic Protocol Extension for Virtual eXtensible Local Area Network (VXLAN)",
	"_roce":                                 "IP Routable RocE",
	"_unified-bus":                          "IP Routable Unified Bus",
	"_iims":                                 "Icona Instant Messenging System",
	"_iwec":                                 "Icona Web Embedded Chat",
	"_ilss":                                 "Icona License System Server",
	"_notateit":                             "Notateit Messaging",
	"_notateit-disc":                        "Notateit Messaging Discovery",
	"_aja-ntv4-disc":                        "AJA ntv4 Video System Discovery",
	"_htcp":                                 "HTCP",
	"_varadero-0":                           "Varadero-0",
	"_varadero-1":                           "Varadero-1",
	"_varadero-2":                           "Varadero-2",
	"_opcua-tcp":                            "OPC UA Connection Protocol",
	"_opcua-udp":                            "OPC UA Multicast Datagram Protocol",
	"_quosa":                                "QUOSA Virtual Library Service",
	"_gw-asv":                               "nCode ICE-flow Library AppServer",
	"_opcua-tls":                            "OPC UA TCP Protocol over TLS/SSL",
	"_gw-log":                               "nCode ICE-flow Library LogServer",
	"_wcr-remlib":                           "WordCruncher Remote Library Service",
	"_contamac-icm":                         "Contamac ICM Service IANA assigned this well-formed service name as a replacement for 'contamac_icm'.",
	"_contamac_icm":                         "Contamac ICM Service",
	"_wfc":                                  "Web Fresh Communication",
	"_appserv-http":                         "App Server - Admin HTTP",
	"_appserv-https":                        "App Server - Admin HTTPS",
	"_sun-as-nodeagt":                       "Sun App Server - NA",
	"_derby-repli":                          "Apache Derby Replication",
	"_unify-debug":                          "Unify Debugger",
	"_phrelay":                              "Photon Relay",
	"_phrelaydbg":                           "Photon Relay Debug",
	"_cc-tracking":                          "Citcom Tracking Service",
	"_wired":                                "Wired",
	"_tritium-can":                          "Tritium CAN Bus Bridge Service",
	"_lmcs":                                 "Lighting Management Control System",
	"_inst-discovery":                       "Agilent Instrument Discovery",
	"_wsdl-event":                           "WSDL Event Receiver",
	"_hislip":                               "IVI High-Speed LAN Instrument Protocol",
	"_socp-t":                               "SOCP Time Synchronization Protocol",
	"_socp-c":                               "SOCP Control Protocol",
	"_wmlserver":                            "Meier-Phelps License Server",
	"_hivestor":                             "HiveStor Distributed File System",
	"_abbs":                                 "ABBS",
	"_xcap-portal":                          "xcap code analysis portal public user access",
	"_xcap-control":                         "xcap code analysis portal cluster control and administration",
	"_lyskom":                               "LysKOM Protocol A",
	"_radmin-port":                          "RAdmin Port",
	"_hfcs":                                 "HFSQL Client/Server Database Engine",
	"_flr-agent":                            "FileLocator Remote Search Agent IANA assigned this well-formed service name as a replacement for 'flr_agent'.",
	"_flr_agent":                            "FileLocator Remote Search Agent",
	"_magiccontrol":                         "magicCONROL RF and Data Interface",
	"_lutap":                                "Technicolor LUT Access Protocol",
	"_lutcp":                                "LUTher Control Protocol",
	"_bones":                                "Bones Remote Control",
	"_frcs":                                 "Fibics Remote Control Service",
	"_an-signaling":                         "Signal protocol port for autonomic networking",
	"_atsc-mh-ssc":                          "ATSC-M/H Service Signaling Channel",
	"_eq-office-4940":                       "Equitrac Office",
	"_eq-office-4941":                       "Equitrac Office",
	"_eq-office-4942":                       "Equitrac Office",
	"_munin":                                "Munin Graphing Framework",
	"_sybasesrvmon":                         "Sybase Server Monitor",
	"_pwgwims":                              "PWG WIMS",
	"_sagxtsds":                             "SAG Directory Server",
	"_dbsyncarbiter":                        "Synchronization Arbiter",
	"_ccss-qmm":                             "CCSS QMessageMonitor",
	"_ccss-qsm":                             "CCSS QSystemMonitor",
	"_burp":                                 "BackUp and Restore Program",
	"_ctxs-vpp":                             "Citrix Virtual Path",
	"_webyast":                              "WebYast",
	"_gerhcs":                               "GER HC Standard",
	"_mrip":                                 "Model Railway Interface Program",
	"_smar-se-port1":                        "SMAR Ethernet Port 1",
	"_smar-se-port2":                        "SMAR Ethernet Port 2",
	"_parallel":                             "Parallel for GAUSS (tm)",
	"_busycal":                              "BusySync Calendar Synch. Protocol",
	"_vrt":                                  "VITA Radio Transport",
	"_hfcs-manager":                         "HFSQL Client/Server Database Engine Manager",
	"_commplex-main":                        "",
	"_commplex-link":                        "",
	"_rfe":                                  "radio free ethernet",
	"_fmpro-internal":                       "FileMaker, Inc. - Proprietary transport",
	"_avt-profile-1":                        "RTP media data",
	"_avt-profile-2":                        "RTP control protocol",
	"_wsm-server":                           "wsm server",
	"_wsm-server-ssl":                       "wsm server ssl",
	"_synapsis-edge":                        "Synapsis EDGE",
	"_winfs":                                "Microsoft Windows Filesystem",
	"_telelpathstart":                       "TelepathStart",
	"_telelpathattack":                      "TelepathAttack",
	"_nsp":                                  "NetOnTap Service",
	"_fmpro-v6":                             "FileMaker, Inc. - Proprietary transport",
	"_onpsocket":                            "Overlay Network Protocol",
	"_fmwp":                                 "FileMaker, Inc. - Web publishing",
	"_zenginkyo-1":                          "zenginkyo-1",
	"_zenginkyo-2":                          "zenginkyo-2",
	"_mice":                                 "mice server",
	"_htuilsrv":                             "Htuil Server for PLD2",
	"_scpi-telnet":                          "SCPI-TELNET",
	"_scpi-raw":                             "SCPI-RAW",
	"_strexec-d":                            "Storix I/O daemon (data)",
	"_strexec-s":                            "Storix I/O daemon (stat)",
	"_qvr":                                  "Quiqum Virtual Relais",
	"_infobright":                           "Infobright Database Server",
	"_dmp":                                  "Direct Message Protocol",
	"_signacert-agent":                      "SignaCert Enterprise Trust Server Agent",
	"_jtnetd-server":                        "Janstor Secure Data",
	"_jtnetd-status":                        "Janstor Status",
	"_asnaacceler8db":                       "asnaacceler8db",
	"_swxadmin":                             "ShopWorX Administration",
	"_lxi-evntsvc":                          "LXI Event Service",
	"_osp":                                  "Open Settlement Protocol",
	"_vpm-udp":                              "Vishay PM UDP Service",
	"_iscape":                               "iSCAPE Data Broadcasting",
	"_texai":                                "Texai Message Service",
	"_ivocalize":                            "iVocalize Web Conference",
	"_mmcc":                                 "multimedia conference control tool",
	"_ita-agent":                            "ITA Agent",
	"_ita-manager":                          "ITA Manager",
	"_rlm":                                  "RLM License Server",
	"_rlm-disc":                             "RLM Discovery Server",
	"_rlm-admin":                            "RLM administrative interface",
	"_unot":                                 "UNOT",
	"_intecom-ps1":                          "Intecom Pointspan 1",
	"_intecom-ps2":                          "Intecom Pointspan 2",
	"_locus-disc":                           "Locus Discovery",
	"_sds":                                  "SIP Directory Services",
	"_sip":                                  "SIP",
	"_sips":                                 "SIP-TLS",
	"_na-localise":                          "Localisation access",
	"_csrpc":                                "centrify secure RPC",
	"_ca-1":                                 "Channel Access 1",
	"_ca-2":                                 "Channel Access 2",
	"_stanag-5066":                          "STANAG-5066-SUBNET-INTF",
	"_authentx":                             "Authentx Service",
	"_bitforestsrv":                         "Bitforest Data Service",
	"_i-net-2000-npr":                       "I/Net 2000-NPR",
	"_vtsas":                                "VersaTrans Server Agent Service",
	"_powerschool":                          "PowerSchool",
	"_ayiya":                                "Anything In Anything",
	"_tag-pm":                               "Advantage Group Port Mgr",
	"_alesquery":                            "ALES Query",
	"_pvaccess":                             "Experimental Physics and Industrial Control System",
	"_pixelpusher":                          "PixelPusher pixel data",
	"_cp-spxrpts":                           "Cambridge Pixel SPx Reports",
	"_onscreen":                             "OnScreen Data Collection Service",
	"_sdl-ets":                              "SDL - Ent Trans Server",
	"_qcp":                                  "Qpur Communication Protocol",
	"_qfp":                                  "Qpur File Protocol",
	"_llrp":                                 "EPCglobal Low-Level Reader Protocol",
	"_encrypted-llrp":                       "EPCglobal Encrypted LLRP",
	"_aprigo-cs":                            "Aprigo Collection Service",
	"_biotic":                               "BIOTIC - Binary Internet of Things Interoperable Communication",
	"_car":                                  "Candidate AR",
	"_cxtp":                                 "Context Transfer Protocol",
	"_magpie":                               "Magpie Binary",
	"_sentinel-lm":                          "Sentinel LM",
	"_hart-ip":                              "HART-IP",
	"_sentlm-srv2srv":                       "SentLM Srv2Srv",
	"_socalia":                              "Socalia service mux",
	"_talarian-tcp":                         "Talarian_TCP",
	"_talarian-udp":                         "Talarian_UDP",
	"_oms-nonsecure":                        "Oracle OMS non-secure",
	"_actifio-c2c":                          "Actifio C2C",
	"_tinymessage":                          "TinyMessage",
	"_hughes-ap":                            "Hughes Association Protocol",
	"_actifioudsagent":                      "Actifio UDS Agent",
	"_actifioreplic":                        "Disk to Disk replication between Actifio Clusters",
	"_taep-as-svc":                          "TAEP AS service",
	"_pm-cmdsvr":                            "PeerMe Msg Cmd Service",
	"_ev-services":                          "Enterprise Vault Services",
	"_autobuild":                            "Symantec Autobuild Service",
	"_emb-proj-cmd":                         "EPSON Projecter Image Transfer",
	"_gradecam":                             "GradeCam Image Processing",
	"_barracuda-bbs":                        "Barracuda Backup Protocol",
	"_nbt-pc":                               "Policy Commander",
	"_ppactivation":                         "PP ActivationServer",
	"_erp-scale":                            "ERP-Scale",
	"_minotaur-sa":                          "Minotaur SA",
	"_ctsd":                                 "MyCTS server port",
	"_rmonitor-secure":                      "RMONITOR SECURE IANA assigned this well-formed service name as a replacement for 'rmonitor_secure'.",
	"_rmonitor_secure":                      "RMONITOR SECURE",
	"_social-alarm":                         "Social Alarm Service",
	"_atmp":                                 "Ascend Tunnel Management Protocol",
	"_esri-sde":                             "ESRI SDE Instance IANA assigned this well-formed service name as a replacement for 'esri_sde'.",
	"_esri_sde":                             "ESRI SDE Instance",
	"_sde-discovery":                        "ESRI SDE Instance Discovery",
	"_bzflag":                               "BZFlag game server",
	"_asctrl-agent":                         "Oracle asControl Agent",
	"_rugameonline":                         "Russian Online Game",
	"_mediat":                               "Mediat Remote Object Exchange",
	"_snmpssh":                              "SNMP over SSH Transport Model",
	"_snmpssh-trap":                         "SNMP Notification over SSH Transport Model",
	"_sbackup":                              "Shadow Backup",
	"_vpa":                                  "Virtual Protocol Adapter",
	"_vpa-disc":                             "Virtual Protocol Adapter Discovery",
	"_ife-icorp":                            "ife_1corp IANA assigned this well-formed service name as a replacement for 'ife_icorp'.",
	"_ife_icorp":                            "ife_1corp",
	"_winpcs":                               "WinPCS Service Connection",
	"_scte104":                              "SCTE104 Connection",
	"_scte30":                               "SCTE30 Connection",
	"_pcoip-mgmt":                           "PC over IP Endpoint Management",
	"_aol":                                  "America-Online",
	"_aol-1":                                "AmericaOnline1",
	"_aol-2":                                "AmericaOnline2",
	"_aol-3":                                "AmericaOnline3",
	"_cpscomm":                              "CipherPoint Config Service",
	"_ampl-lic":                             "The protocol is used by a license server and client programs to control use of program licenses that float to networked machines",
	"_ampl-tableproxy":                      "The protocol is used by two programs that exchange 'table' data used in the AMPL modeling language",
	"_tunstall-lwp":                         "Tunstall Lone worker device interface",
	"_targus-getdata":                       "TARGUS GetData",
	"_targus-getdata1":                      "TARGUS GetData 1",
	"_targus-getdata2":                      "TARGUS GetData 2",
	"_targus-getdata3":                      "TARGUS GetData 3",
	"_nomad":                                "Nomad Device Video Transfer",
	"_noteza":                               "NOTEZA Data Safety Service",
	"_3exmp":                                "3eTI Extensible Management Protocol for OAMP",
	"_xmpp-client":                          "XMPP Client Connection",
	"_hpvirtgrp":                            "HP Virtual Machine Group Management",
	"_hpvirtctrl":                           "HP Virtual Machine Console Operations",
	"_hp-server":                            "HP Server",
	"_hp-status":                            "HP Status",
	"_perfd":                                "HP System Performance Metric Service",
	"_hpvroom":                              "HP Virtual Room Service",
	"_jaxflow":                              "Netflow/IPFIX/sFlow Collector and Forwarder Management",
	"_jaxflow-data":                         "JaxMP RealFlow application and protocol data",
	"_crusecontrol":                         "Remote Control of Scan Software for Cruse Scanners",
	"_csedaemon":                            "Cruse Scanning System Service",
	"_enfs":                                 "Etinnae Network File Service",
	"_eenet":                                "EEnet communications",
	"_galaxy-network":                       "Galaxy Network Service",
	"_padl2sim":                             "",
	"_mnet-discovery":                       "m-net discovery",
	"_attune":                               "ATTUne API",
	"_xycstatus":                            "xyClient Status API and rendevous point",
	"_downtools":                            "DownTools Control Protocol",
	"_downtools-disc":                       "DownTools Discovery Protocol",
	"_capwap-control":                       "CAPWAP Control Protocol",
	"_capwap-data":                          "CAPWAP Data Protocol",
	"_caacws":                               "CA Access Control Web Service",
	"_caaclang2":                            "CA AC Lang Service",
	"_soagateway":                           "soaGateway",
	"_caevms":                               "CA eTrust VM Service",
	"_movaz-ssc":                            "Movaz SSC",
	"_kpdp":                                 "Kohler Power Device Protocol",
	"_logcabin":                             "LogCabin storage service",
	"_3com-njack-1":                         "3Com Network Jack Port 1",
	"_3com-njack-2":                         "3Com Network Jack Port 2",
	"_xmpp-server":                          "XMPP Server Connection",
	"_cartographerxmp":                      "Cartographer XMP",
	"_cuelink":                              "StageSoft CueLink messaging",
	"_cuelink-disc":                         "StageSoft CueLink discovery",
	"_pk":                                   "PK",
	"_xmpp-bosh":                            "Bidirectional-streams Over Synchronous HTTP (BOSH)",
	"_undo-lm":                              "Undo License Manager",
	"_transmit-port":                        "Marimba Transmitter Port",
	"_presence":                             "XMPP Link-Local Messaging",
	"_nlg-data":                             "NLG Data Service",
	"_hacl-hb":                              "HA cluster heartbeat",
	"_hacl-gs":                              "HA cluster general services",
	"_hacl-cfg":                             "HA cluster configuration",
	"_hacl-probe":                           "HA cluster probing",
	"_hacl-local":                           "HA Cluster Commands",
	"_hacl-test":                            "HA Cluster Test",
	"_sun-mc-grp":                           "Sun MC Group",
	"_sco-aip":                              "SCO AIP",
	"_cfengine":                             "CFengine",
	"_jprinter":                             "J Printer",
	"_outlaws":                              "Outlaws",
	"_permabit-cs":                          "Permabit Client-Server",
	"_rrdp":                                 "Real-time & Reliable Data",
	"_opalis-rbt-ipc":                       "opalis-rbt-ipc",
	"_hacl-poll":                            "HA Cluster UDP Polling",
	"_hpbladems":                            "HPBladeSystem Monitor Service",
	"_hpdevms":                              "HP Device Monitor Service",
	"_pkix-cmc":                             "PKIX Certificate Management using CMS (CMC)",
	"_bsfserver-zn":                         "Webservices-based Zn interface of BSF",
	"_bsfsvr-zn-ssl":                        "Webservices-based Zn interface of BSF over SSL",
	"_kfserver":                             "Sculptor Database Server",
	"_xkotodrcp":                            "xkoto DRCP",
	"_stuns":                                "Session Traversal Utilities for NAT (STUN) port",
	"_turns":                                "TURN over TLS",
	"_stun-behaviors":                       "STUN Behavior Discovery over TLS",
	"_pcp-multicast":                        "Port Control Protocol Multicast",
	"_pcp":                                  "Port Control Protocol",
	"_dns-llq":                              "DNS Long-Lived Queries",
	"_mdns":                                 "Multicast DNS",
	"_mdnsresponder":                        "Multicast DNS Responder IPC",
	"_llmnr":                                "LLMNR",
	"_ms-smlbiz":                            "Microsoft Small Business",
	"_wsdapi":                               "Web Services for Devices",
	"_wsdapi-s":                             "WS for Devices Secured",
	"_ms-alerter":                           "Microsoft Alerter",
	"_ms-sideshow":                          "Protocol for Windows SideShow",
	"_ms-s-sideshow":                        "Secure Protocol for Windows SideShow",
	"_serverwsd2":                           "Microsoft Windows Server WSD2 Service",
	"_net-projection":                       "Windows Network Projection",
	"_kdnet":                                "Microsoft Kernel Debugger",
	"_stresstester":                         "StressTester(tm) Injector",
	"_elektron-admin":                       "Elektron Administration",
	"_securitychase":                        "SecurityChase",
	"_excerpt":                              "Excerpt Search",
	"_excerpts":                             "Excerpt Search Secure",
	"_hpoms-ci-lstn":                        "HPOMS-CI-LSTN",
	"_hpoms-dps-lstn":                       "HPOMS-DPS-LSTN",
	"_netsupport":                           "NetSupport",
	"_systemics-sox":                        "Systemics Sox",
	"_foresyte-clear":                       "Foresyte-Clear",
	"_foresyte-sec":                         "Foresyte-Sec",
	"_salient-dtasrv":                       "Salient Data Server",
	"_salient-usrmgr":                       "Salient User Manager",
	"_actnet":                               "ActNet",
	"_continuus":                            "Continuus",
	"_wwiotalk":                             "WWIOTALK",
	"_statusd":                              "StatusD",
	"_ns-server":                            "NS Server",
	"_sns-gateway":                          "SNS Gateway",
	"_sns-agent":                            "SNS Agent",
	"_mcntp":                                "MCNTP",
	"_dj-ice":                               "DJ-ICE",
	"_cylink-c":                             "Cylink-C",
	"_netsupport2":                          "Net Support 2",
	"_salient-mux":                          "Salient MUX",
	"_virtualuser":                          "VIRTUALUSER",
	"_beyond-remote":                        "Beyond Remote",
	"_br-channel":                           "Beyond Remote Command Channel",
	"_devbasic":                             "DEVBASIC",
	"_sco-peer-tta":                         "SCO-PEER-TTA",
	"_telaconsole":                          "TELACONSOLE",
	"_base":                                 "Billing and Accounting System Exchange",
	"_radec-corp":                           "RADEC CORP",
	"_park-agent":                           "PARK AGENT",
	"_postgresql":                           "PostgreSQL Database",
	"_pyrrho":                               "Pyrrho DBMS",
	"_sgi-arrayd":                           "SGI Array Services Daemon",
	"_sceanics":                             "SCEANICS situation and action notification",
	"_pmip6-cntl":                           "pmip6-cntl",
	"_pmip6-data":                           "pmip6-data",
	"_spss":                                 "Pearson HTTPS",
	"_smbdirect":                            "Server Message Block over Remote Direct Memory Access",
	"_tiepie":                               "TiePie engineering data acquisition",
	"_tiepie-disc":                          "TiePie engineering data acquisition (discovery)",
	"_surebox":                              "SureBox",
	"_apc-5454":                             "APC 5454",
	"_apc-5455":                             "APC 5455",
	"_apc-5456":                             "APC 5456",
	"_silkmeter":                            "SILKMETER",
	"_ttl-publisher":                        "TTL Publisher",
	"_ttlpriceproxy":                        "TTL Price Proxy",
	"_quailnet":                             "Quail Networks Object Broker",
	"_netops-broker":                        "NETOPS-BROKER",
	"_apsolab-col":                          "The Apsolab company's data collection protocol (native api)",
	"_apsolab-cols":                         "The Apsolab company's secure data collection protocol (native api)",
	"_apsolab-tag":                          "The Apsolab company's dynamic tag protocol",
	"_apsolab-tags":                         "The Apsolab company's secure dynamic tag protocol",
	"_apsolab-rpc":                          "The Apsolab company's status query protocol",
	"_apsolab-data":                         "The Apsolab company's data retrieval protocol",
	"_fcp-addr-srvr1":                       "fcp-addr-srvr1",
	"_fcp-addr-srvr2":                       "fcp-addr-srvr2",
	"_fcp-srvr-inst1":                       "fcp-srvr-inst1",
	"_fcp-srvr-inst2":                       "fcp-srvr-inst2",
	"_fcp-cics-gw1":                         "fcp-cics-gw1",
	"_checkoutdb":                           "Checkout Database",
	"_amc":                                  "Amcom Mobile Connect",
	"_psl-management":                       "PowerSysLab Electrical Management",
	"_matter":                               "Matter Operational Discovery and Communi",
	"_qftest-licserve":                      "QF-Test License Server",
	"_cbus":                                 "Model Railway control using the CBUS message protocol",
	"_sgi-eventmond":                        "SGI Eventmond Port",
	"_sgi-esphttp":                          "SGI ESP HTTP",
	"_personal-agent":                       "Personal Agent",
	"_freeciv":                              "Freeciv gameplay",
	"_farenet":                              "Sandlab FARENET",
	"_dp-bura":                              "Data Protector BURA",
	"_westec-connect":                       "Westec Connect",
	"_dof-dps-mc-sec":                       "DOF Protocol Stack Multicast/Secure Transport",
	"_sdt":                                  "Session Data Transport Multicast",
	"_rdmnet-ctrl":                          "PLASA E1.33, Remote Device Management (RDM) controller status notifications",
	"_rdmnet-device":                        "PLASA E1.33, Remote Device Management (RDM) messages",
	"_sdmmp":                                "SAS Domain Management Messaging Protocol",
	"_lsi-bobcat":                           "SAS IO Forwarding",
	"_ora-oap":                              "Oracle Access Protocol",
	"_fdtracks":                             "FleetDisplay Tracking Service",
	"_tmosms0":                              "T-Mobile SMS Protocol Message 0",
	"_tmosms1":                              "T-Mobile SMS Protocol Message 1",
	"_fac-restore":                          "T-Mobile SMS Protocol Message 3",
	"_tmo-icon-sync":                        "T-Mobile SMS Protocol Message 2",
	"_bis-web":                              "BeInSync-Web",
	"_bis-sync":                             "BeInSync-sync",
	"_att-mt-sms":                           "Planning to send mobile terminated SMS to the specific port so that the SMS is not visible to the client",
	"_ininmessaging":                        "inin secure messaging",
	"_mctfeed":                              "MCT Market Data Feed",
	"_esinstall":                            "Enterprise Security Remote Install",
	"_esmmanager":                           "Enterprise Security Manager",
	"_esmagent":                             "Enterprise Security Agent",
	"_a1-msc":                               "A1-MSC",
	"_a1-bs":                                "A1-BS",
	"_a3-sdunode":                           "A3-SDUNode",
	"_a4-sdunode":                           "A4-SDUNode",
	"_efr":                                  "Fiscal Registering Protocol",
	"_ninaf":                                "Node Initiated Network Association Forma",
	"_htrust":                               "HTrust API",
	"_symantec-sfdb":                        "Symantec Storage Foundation for Database",
	"_precise-comm":                         "PreciseCommunication",
	"_pcanywheredata":                       "pcANYWHEREdata",
	"_pcanywherestat":                       "pcANYWHEREstat",
	"_beorl":                                "BE Operations Request Listener",
	"_xprtld":                               "SF Message Service",
	"_sfmsso":                               "SFM Authentication Subsystem",
	"_sfm-db-server":                        "SFMdb - SFM DB server",
	"_cssc":                                 "Symantec CSSC",
	"_flcrs":                                "Symantec Fingerprint Lookup and Container Reference Service",
	"_ics":                                  "Symantec Integrity Checking Service",
	"_vfmobile":                             "Ventureforth Mobile",
	"_nrpe":                                 "Nagios Remote Plugin Executor",
	"_filemq":                               "ZeroMQ file publish-subscribe protocol",
	"_zre-disc":                             "Local area discovery and messaging over ZeroMQ",
	"_amqps":                                "amqp protocol over TLS/SSL",
	"_amqp":                                 "AMQP",
	"_jms":                                  "JACL Message Server",
	"_hyperscsi-port":                       "HyperSCSI Port",
	"_v5ua":                                 "V5UA application port",
	"_raadmin":                              "RA Administration",
	"_questdb2-lnchr":                       "Quest Central DB2 Launchr",
	"_rrac":                                 "Remote Replication Agent Connection",
	"_dccm":                                 "Direct Cable Connect Manager",
	"_auriga-router":                        "Auriga Router Service",
	"_ncxcp":                                "Net-coneX Control Protocol",
	"_brightcore":                           "BrightCore control & data transfer exchange",
	"_coap":                                 "Constrained Application Protocol (CoAP)",
	"_coaps":                                "Constrained Application Protocol (CoAP)",
	"_gog-multiplayer":                      "GOG multiplayer game protocol",
	"_ggz":                                  "GGZ Gaming Zone",
	"_qmvideo":                              "QM video network management protocol",
	"_rbsystem":                             "Robert Bosch Data Transfer",
	"_kmip":                                 "Key Management Interoperability Protocol",
	"_supportassist":                        "Dell SupportAssist data center management",
	"_storageos":                            "StorageOS REST API",
	"_proshareaudio":                        "proshare conf audio",
	"_prosharevideo":                        "proshare conf video",
	"_prosharedata":                         "proshare conf data",
	"_prosharerequest":                      "proshare conf request",
	"_prosharenotify":                       "proshare conf notify",
	"_dpm":                                  "DPM Communication Server",
	"_dpm-agent":                            "DPM Agent Coordinator",
	"_ms-licensing":                         "MS-Licensing",
	"_dtpt":                                 "Desktop Passthru Service",
	"_msdfsr":                               "Microsoft DFS Replication Service",
	"_omhs":                                 "Operations Manager - Health Service",
	"_omsdk":                                "Operations Manager - SDK Service",
	"_ms-ilm":                               "Microsoft Identity Lifecycle Manager",
	"_ms-ilm-sts":                           "Microsoft Lifecycle Manager Secure Token Service",
	"_asgenf":                               "ASG Event Notification Framework",
	"_io-dist-data":                         "Dist. I/O Comm. Service Data and Control",
	"_io-dist-group":                        "Dist. I/O Comm. Service Group Membership",
	"_openmail":                             "Openmail User Agent Layer",
	"_unieng":                               "Steltor's calendar access",
	"_ida-discover1":                        "IDA Discover Port 1",
	"_ida-discover2":                        "IDA Discover Port 2",
	"_watchdoc-pod":                         "Watchdoc NetPOD Protocol",
	"_watchdoc":                             "Watchdoc Server",
	"_fcopy-server":                         "fcopy-server",
	"_fcopys-server":                        "fcopys-server",
	"_tunatic":                              "Wildbits Tunatic",
	"_tunalyzer":                            "Wildbits Tunalyzer",
	"_rscd":                                 "Bladelogic Agent Service",
	"_openmailg":                            "OpenMail Desk Gateway server",
	"_x500ms":                               "OpenMail X.500 Directory Server",
	"_openmailns":                           "OpenMail NewMail Server",
	"_s-openmail":                           "OpenMail Suer Agent Layer (Secure)",
	"_openmailpxy":                          "OpenMail CMTS Server",
	"_spramsca":                             "x509solutions Internal CA",
	"_spramsd":                              "x509solutions Secure Data",
	"_netagent":                             "NetAgent",
	"_starfield-io":                         "Control commands and responses",
	"_vts-rpc":                              "Visual Tag System RPC",
	"_3par-evts":                            "3PAR Event Reporting Service",
	"_3par-mgmt":                            "3PAR Management Service",
	"_3par-mgmt-ssl":                        "3PAR Management Service with SSL",
	"_ibar":                                 "Cisco Interbox Application Redundancy",
	"_3par-rcopy":                           "3PAR Inform Remote Copy",
	"_cisco-redu":                           "redundancy notification",
	"_waascluster":                          "Cisco WAAS Cluster Protocol",
	"_xtreamx":                              "XtreamX Supervised Peer message",
	"_spdp":                                 "Simple Peered Discovery Protocol",
	"_enlabel-dpl":                          "Proprietary Website deployment service",
	"_icmpd":                                "ICMPD",
	"_spt-automation":                       "Support Automation",
	"_autopassdaemon":                       "AutoPass licensing",
	"_shiprush-d-ch":                        "Z-firm ShipRush interface for web access and bidirectional data",
	"_reversion":                            "Reversion Backup/Restore",
	"_wherehoo":                             "WHEREHOO",
	"_ppsuitemsg":                           "PlanetPress Suite Messeng",
	"_diameters":                            "Diameter over TLS/TCP",
	"_jute":                                 "Javascript Unit Test Environment",
	"_rfb":                                  "Remote Framebuffer",
	"_ff-ice":                               "Flight & Flow Info for Collaborative Env",
	"_ag-swim":                              "Air-Ground SWIM",
	"_asmgcs":                               "Adv Surface Mvmnt and Guidance Cont Sys",
	"_rpas-c2":                              "Remotely Piloted Vehicle C&C",
	"_dsd":                                  "Distress and Safety Data App",
	"_ipsma":                                "IPS Management Application",
	"_agma":                                 "Air-ground media advisory",
	"_ats-atn":                              "Air Traffic Services applications using ATN",
	"_cm":                                   "Context Management",
	"_ats-acars":                            "Air Traffic Services applications using ACARS",
	"_cpdlc":                                "Controller Pilot Data Link Communication",
	"_ais-met":                              "Aeronautical Information Service/Meteorological applications using ACARS",
	"_fis":                                  "Flight Information Services",
	"_aoc-acars":                            "Airline operational communications applications using ACARS",
	"_ads-c":                                "Automatic Dependent Surveillance",
	"_indy":                                 "Indy Application Server",
	"_mppolicy-v5":                          "mppolicy-v5",
	"_mppolicy-mgr":                         "mppolicy-mgr",
	"_couchdb":                              "CouchDB",
	"_wsman":                                "WBEM WS-Management HTTP",
	"_wsmans":                               "WBEM WS-Management HTTP over TLS/SSL",
	"_wbem-rmi":                             "WBEM RMI",
	"_wbem-http":                            "WBEM CIM-XML (HTTP)",
	"_wbem-https":                           "WBEM CIM-XML (HTTPS)",
	"_wbem-exp-https":                       "WBEM Export HTTPS",
	"_nuxsl":                                "NUXSL",
	"_consul-insight":                       "Consul InSight Security",
	"_cim-rs":                               "DMTF WBEM CIM REST",
	"_rms-agent":                            "RMS Agent Listening Service",
	"_cvsup":                                "CVSup",
	"_x11":                                  "X Window System",
	"_ndl-ahp-svc":                          "NDL-AHP-SVC",
	"_winpharaoh":                           "WinPharaoh",
	"_ewctsp":                               "EWCTSP",
	"_gsmp-ancp":                            "GSMP/ANCP",
	"_trip":                                 "TRIP",
	"_messageasap":                          "Messageasap",
	"_ssdtp":                                "SSDTP",
	"_diagnose-proc":                        "DIAGNOSE-PROC",
	"_directplay8":                          "DirectPlay8",
	"_max":                                  "Microsoft Max",
	"_dpm-acm":                              "Microsoft DPM Access Control Manager",
	"_msft-dpm-cert":                        "Microsoft DPM WCF Certificates",
	"_iconstructsrv":                        "iConstruct Server",
	"_gue":                                  "Generic UDP Encapsulation",
	"_geneve":                               "Generic Network Virtualization Encapsulation (Geneve)",
	"_p25cai":                               "APCO Project 25 Common Air Interface - UDP encapsulation",
	"_miami-bcast":                          "telecomsoftware miami broadcast",
	"_reload-config":                        "Peer to Peer Infrastructure Configuration",
	"_konspire2b":                           "konspire2b p2p network",
	"_pdtp":                                 "PDTP P2P",
	"_ldss":                                 "Local Download Sharing Service",
	"_doglms":                               "SuperDog License Manager",
	"_doglms-notify":                        "SuperDog License Manager Notifier",
	"_raxa-mgmt":                            "RAXA Management",
	"_synchronet-db":                        "SynchroNet-db",
	"_synchronet-rtc":                       "SynchroNet-rtc",
	"_synchronet-upd":                       "SynchroNet-upd",
	"_rets":                                 "RETS",
	"_dbdb":                                 "DBDB",
	"_primaserver":                          "Prima Server",
	"_mpsserver":                            "MPS Server",
	"_etc-control":                          "ETC Control",
	"_sercomm-scadmin":                      "Sercomm-SCAdmin",
	"_globecast-id":                         "GLOBECAST-ID",
	"_softcm":                               "HP SoftBench CM",
	"_spc":                                  "HP SoftBench Sub-Process Control",
	"_dtspcd":                               "Desk-Top Sub-Process Control Daemon",
	"_dayliteserver":                        "Daylite Server",
	"_wrspice":                              "WRspice IPC Service",
	"_xic":                                  "Xic IPC Service",
	"_xtlserv":                              "XicTools License Manager Service",
	"_daylitetouch":                         "Daylite Touch Sync",
	"_tipc":                                 "Transparent Inter Process Communication",
	"_spdy":                                 "SPDY for a faster web",
	"_bex-webadmin":                         "Backup Express Web Server",
	"_backup-express":                       "Backup Express",
	"_pnbs":                                 "Phlexible Network Backup Service",
	"_damewaremobgtwy":                      "The DameWare Mobile Gateway Service",
	"_nbt-wol":                              "New Boundary Tech WOL",
	"_pulsonixnls":                          "Pulsonix Network License Service",
	"_meta-corp":                            "Meta Corporation License Manager",
	"_aspentec-lm":                          "Aspen Technology License Manager",
	"_watershed-lm":                         "Watershed License Manager",
	"_statsci1-lm":                          "StatSci License Manager - 1",
	"_statsci2-lm":                          "StatSci License Manager - 2",
	"_lonewolf-lm":                          "Lone Wolf Systems License Manager",
	"_montage-lm":                           "Montage License Manager",
	"_tal-pod":                              "tal-pod",
	"_efb-aci":                              "EFB Application Control Interface",
	"_ecmp":                                 "Emerson Extensible Control and Management Protocol",
	"_ecmp-data":                            "Emerson Extensible Control and Management Protocol Data",
	"_patrol-ism":                           "PATROL Internet Srv Mgr",
	"_patrol-coll":                          "PATROL Collector",
	"_pscribe":                              "Precision Scribe Cnx Port",
	"_lm-x":                                 "LM-X License Manager by X-Formation",
	"_thermo-calc":                          "Management of service nodes in a processing grid for thermodynamic calculations",
	"_qmtps":                                "QMTP over TLS",
	"_radmind":                              "Radmind Access Protocol",
	"_jeol-nsdtp-1":                         "JEOL Network Services Data Transport Protocol 1",
	"_jeol-nsddp-1":                         "JEOL Network Services Dynamic Discovery Protocol 1",
	"_jeol-nsdtp-2":                         "JEOL Network Services Data Transport Protocol 2",
	"_jeol-nsddp-2":                         "JEOL Network Services Dynamic Discovery Protocol 2",
	"_jeol-nsdtp-3":                         "JEOL Network Services Data Transport Protocol 3",
	"_jeol-nsddp-3":                         "JEOL Network Services Dynamic Discovery Protocol 3",
	"_jeol-nsdtp-4":                         "JEOL Network Services Data Transport Protocol 4",
	"_jeol-nsddp-4":                         "JEOL Network Services Dynamic Discovery Protocol 4",
	"_tl1-raw-ssl":                          "TL1 Raw Over SSL/TLS",
	"_tl1-ssh":                              "TL1 over SSH",
	"_crip":                                 "CRIP",
	"_gld":                                  "GridLAB-D User Interface",
	"_grid":                                 "Grid Authentication",
	"_grid-alt":                             "Grid Authentication Alt",
	"_bmc-grx":                              "BMC GRX",
	"_bmc-ctd-ldap":                         "BMC CONTROL-D LDAP SERVER IANA assigned this well-formed service name as a replacement for 'bmc_ctd_ldap'.",
	"_bmc_ctd_ldap":                         "BMC CONTROL-D LDAP SERVER",
	"_ufmp":                                 "Unified Fabric Management Protocol",
	"_scup":                                 "Sensor Control Unit Protocol",
	"_scup-disc":                            "Sensor Control Unit Protocol Discovery Protocol",
	"_abb-escp":                             "Ethernet Sensor Communications Protocol",
	"_nav-data-cmd":                         "Navtech Radar Sensor Data Command",
	"_nav-data":                             "Navtech Radar Sensor Data",
	"_iona-data":                            "IONA Measurement and control data",
	"_repsvc":                               "Double-Take Replication Service",
	"_emp-server1":                          "Empress Software Connectivity Server 1",
	"_emp-server2":                          "Empress Software Connectivity Server 2",
	"_hrd-ncs":                              "HR Device Network Configuration Service",
	"_hrd-ns-disc":                          "HR Device Network service",
	"_dt-mgmtsvc":                           "Double-Take Management Service",
	"_dt-vra":                               "Double-Take Virtual Recovery Assistant",
	"_sflow":                                "sFlow traffic monitoring",
	"_streletz":                             "Argus-Spectr security and fire-prevention systems service",
	"_gnutella-svc":                         "gnutella-svc",
	"_gnutella-rtr":                         "gnutella-rtr",
	"_adap":                                 "App Discovery and Access Protocol",
	"_pmcs":                                 "PMCS applications",
	"_metaedit-mu":                          "MetaEdit+ Multi-User",
	"_ndn":                                  "Named Data Networking",
	"_metaedit-se":                          "MetaEdit+ Server Administration",
	"_redis":                                "An advanced key-value cache and store",
	"_metatude-mds":                         "Metatude Dialogue Server",
	"_clariion-evr01":                       "clariion-evr01",
	"_metaedit-ws":                          "MetaEdit+ WebService API",
	"_boe-cms":                              "Business Objects CMS contact port",
	"_boe-was":                              "boe-was",
	"_boe-eventsrv":                         "boe-eventsrv",
	"_boe-cachesvr":                         "boe-cachesvr",
	"_boe-filesvr":                          "Business Objects Enterprise internal server",
	"_boe-pagesvr":                          "Business Objects Enterprise internal server",
	"_boe-processsvr":                       "Business Objects Enterprise internal server",
	"_boe-resssvr1":                         "Business Objects Enterprise internal server",
	"_boe-resssvr2":                         "Business Objects Enterprise internal server",
	"_boe-resssvr3":                         "Business Objects Enterprise internal server",
	"_boe-resssvr4":                         "Business Objects Enterprise internal server",
	"_faxcomservice":                        "Faxcom Message Service",
	"_syserverremote":                       "SYserver remote commands",
	"_svdrp":                                "Simple VDR Protocol",
	"_svdrp-disc":                           "Simple VDR Protocol Discovery",
	"_nim-vdrshell":                         "NIM_VDRShell",
	"_nim-wan":                              "NIM_WAN",
	"_pgbouncer":                            "PgBouncer",
	"_heliosd":                              "heliosd daemon",
	"_tarp":                                 "Transitory Application Request Protocol",
	"_sun-sr-https":                         "Service Registry Default HTTPS Domain",
	"_sge-qmaster":                          "Grid Engine Qmaster Service IANA assigned this well-formed service name as a replacement for 'sge_qmaster'.",
	"_sge_qmaster":                          "Grid Engine Qmaster Service",
	"_sge-execd":                            "Grid Engine Execution Service IANA assigned this well-formed service name as a replacement for 'sge_execd'.",
	"_sge_execd":                            "Grid Engine Execution Service",
	"_mysql-proxy":                          "MySQL Proxy",
	"_skip-cert-recv":                       "SKIP Certificate Receive",
	"_skip-cert-send":                       "SKIP Certificate Send",
	"_ieee11073-20701":                      "Port assignment for medical device communication in accordance to IEEE 11073-20701",
	"_lvision-lm":                           "LVision License Manager",
	"_sun-sr-http":                          "Service Registry Default HTTP Domain",
	"_servicetags":                          "Service Tags",
	"_ldoms-mgmt":                           "Logical Domains Management Interface",
	"_sunvts-rmi":                           "SunVTS RMI",
	"_sun-sr-jms":                           "Service Registry Default JMS Domain",
	"_sun-sr-iiop":                          "Service Registry Default IIOP Domain",
	"_sun-sr-iiops":                         "Service Registry Default IIOPS Domain",
	"_sun-sr-iiop-aut":                      "Service Registry Default IIOPAuth Domain",
	"_sun-sr-jmx":                           "Service Registry Default JMX Domain",
	"_sun-sr-admin":                         "Service Registry Default Admin Domain",
	"_boks":                                 "BoKS Master",
	"_boks-servc":                           "BoKS Servc IANA assigned this well-formed service name as a replacement for 'boks_servc'.",
	"_boks_servc":                           "BoKS Servc",
	"_boks-servm":                           "BoKS Servm IANA assigned this well-formed service name as a replacement for 'boks_servm'.",
	"_boks_servm":                           "BoKS Servm",
	"_boks-clntd":                           "BoKS Clntd IANA assigned this well-formed service name as a replacement for 'boks_clntd'.",
	"_boks_clntd":                           "BoKS Clntd",
	"_badm-priv":                            "BoKS Admin Private Port IANA assigned this well-formed service name as a replacement for 'badm_priv'.",
	"_badm_priv":                            "BoKS Admin Private Port",
	"_badm-pub":                             "BoKS Admin Public Port IANA assigned this well-formed service name as a replacement for 'badm_pub'.",
	"_badm_pub":                             "BoKS Admin Public Port",
	"_bdir-priv":                            "BoKS Dir Server, Private Port IANA assigned this well-formed service name as a replacement for 'bdir_priv'.",
	"_bdir_priv":                            "BoKS Dir Server, Private Port",
	"_bdir-pub":                             "BoKS Dir Server, Public Port IANA assigned this well-formed service name as a replacement for 'bdir_pub'.",
	"_bdir_pub":                             "BoKS Dir Server, Public Port",
	"_mgcs-mfp-port":                        "MGCS-MFP Port",
	"_mcer-port":                            "MCER Port",
	"_dccp-udp":                             "Datagram Congestion Control Protocol Encapsulation for NAT Traversal",
	"_netconf-tls":                          "NETCONF over TLS",
	"_syslog-tls":                           "Syslog over TLS",
	"_elipse-rec":                           "Elipse RPC Protocol",
	"_lds-distrib":                          "lds_distrib",
	"_lds-dump":                             "LDS Dump Service",
	"_apc-6547":                             "APC 6547",
	"_apc-6548":                             "APC 6548",
	"_apc-6549":                             "APC 6549",
	"_fg-sysupdate":                         "fg-sysupdate",
	"_sum":                                  "Software Update Manager",
	"_checkmk-agent":                        "Checkmk Monitoring Agent",
	"_xdsxdm":                               "",
	"_sane-port":                            "SANE Control Port",
	"_canit-store":                          "CanIt Storage Manager IANA assigned this well-formed service name as a replacement for 'canit_store'.",
	"_canit_store":                          "CanIt Storage Manager",
	"_rp-reputation":                        "Roaring Penguin IP Address Reputation Collection",
	"_affiliate":                            "Affiliate",
	"_parsec-master":                        "Parsec Masterserver",
	"_parsec-peer":                          "Parsec Peer-to-Peer",
	"_parsec-game":                          "Parsec Gameserver",
	"_joajewelsuite":                        "JOA Jewel Suite",
	"_mshvlm":                               "Microsoft Hyper-V Live Migration",
	"_mstmg-sstp":                           "Microsoft Threat Management Gateway SSTP",
	"_wsscomfrmwk":                          "Windows WSS Communication Framework",
	"_odette-ftps":                          "ODETTE-FTP over TLS/SSL",
	"_kftp-data":                            "Kerberos V5 FTP Data",
	"_kftp":                                 "Kerberos V5 FTP Control",
	"_mcftp":                                "Multicast FTP",
	"_ktelnet":                              "Kerberos V5 Telnet",
	"_datascaler-db":                        "DataScaler database",
	"_datascaler-ctl":                       "DataScaler control",
	"_wago-service":                         "WAGO Service and Update",
	"_nexgen":                               "Allied Electronics NeXGen",
	"_afesc-mc":                             "AFE Stock Channel M/C",
	"_nexgen-aux":                           "Secondary, (non ANDI) multi-protocol multi-function interface to    the Allied ANDI-based family of forecourt controllers",
	"_mxodbc-connect":                       "eGenix mxODBC Connect",
	"_cisco-vpath-tun":                      "Cisco vPath Services Overlay",
	"_mpls-pm":                              "MPLS Performance Measurement out-of-band response",
	"_mpls-udp":                             "Encapsulate MPLS packets in UDP tunnels.",
	"_mpls-udp-dtls":                        "Encapsulate MPLS packets in UDP tunnels with DTLS.",
	"_ovsdb":                                "Open vSwitch Database protocol",
	"_openflow":                             "OpenFlow",
	"_pcs-sf-ui-man":                        "PC SOFT - Software factory UI/manager",
	"_emgmsg":                               "Emergency Message Control Service",
	"_palcom-disc":                          "PalCom Discovery",
	"_ircu":                                 "IRCU",
	"_vocaltec-gold":                        "Vocaltec Global Online Directory",
	"_p4p-portal":                           "P4P Portal Service",
	"_vision-server":                        "vision_server IANA assigned this well-formed service name as a replacement for 'vision_server'.",
	"_vision_server":                        "vision_server",
	"_vision-elmd":                          "vision_elmd IANA assigned this well-formed service name as a replacement for 'vision_elmd'.",
	"_vision_elmd":                          "vision_elmd",
	"_vfbp":                                 "Viscount Freedom Bridge Protocol",
	"_vfbp-disc":                            "Viscount Freedom Bridge Discovery",
	"_osaut":                                "Osorno Automation",
	"_clever-ctrace":                        "CleverView for cTrace Message Service",
	"_clever-tcpip":                         "CleverView for TCP/IP Message Service",
	"_tsa":                                  "Tofino Security Appliance",
	"_cleverdetect":                         "CLEVERDetect Message Service",
	"_babel":                                "Babel Routing Protocol",
	"_ircs-u":                               "Internet Relay Chat via TLS/SSL",
	"_babel-dtls":                           "Babel Routing Protocol over DTLS",
	"_kti-icad-srvr":                        "KTI/ICAD Nameserver",
	"_e-design-net":                         "e-Design network",
	"_e-design-web":                         "e-Design web",
	"_frc-hp":                               "ForCES HP (High Priority) channel",
	"_frc-mp":                               "ForCES MP (Medium Priority) channel",
	"_frc-lp":                               "ForCES LP (Low priority) channel",
	"_ibprotocol":                           "Internet Backplane Protocol",
	"_fibotrader-com":                       "Fibotrader Communications",
	"_princity-agent":                       "Princity Agent",
	"_bmc-perf-agent":                       "BMC PERFORM AGENT",
	"_bmc-perf-mgrd":                        "BMC PERFORM MGRD",
	"_adi-gxp-srvprt":                       "ADInstruments GxP Server",
	"_plysrv-http":                          "PolyServe http",
	"_plysrv-https":                         "PolyServe https",
	"_ntz-tracker":                          "netTsunami Tracker",
	"_ntz-p2p-storage":                      "netTsunami p2p storage system",
	"_bfd-lag":                              "Bidirectional Forwarding Detection (BFD) on Link Aggregation Group (LAG) Interfaces",
	"_dgpf-exchg":                           "DGPF Individual Exchange",
	"_smc-jmx":                              "Sun Java Web Console JMX",
	"_smc-admin":                            "Sun Web Console Admin",
	"_smc-http":                             "SMC-HTTP",
	"_radg":                                 "GSS-API for the Oracle Remote Administration Daemon",
	"_hnmp":                                 "HNMP",
	"_hnm":                                  "Halcyon Network Manager",
	"_acnet":                                "ACNET Control System Protocol",
	"_pentbox-sim":                          "PenTBox Secure IM Protocol",
	"_ambit-lm":                             "ambit-lm",
	"_netmo-default":                        "Netmo Default",
	"_netmo-http":                           "Netmo HTTP",
	"_iccrushmore":                          "ICCRUSHMORE",
	"_acctopus-cc":                          "Acctopus Command Channel",
	"_acctopus-st":                          "Acctopus Status",
	"_muse":                                 "MUSE",
	"_rtimeviewer":                          "R*TIME Viewer Data Interface",
	"_jetstream":                            "Novell Jetstream messaging protocol",
	"_split-ping":                           "Ping with RX/TX latency/loss split",
	"_ethoscan":                             "EthoScan Service",
	"_xsmsvc":                               "XenSource Management Service",
	"_bioserver":                            "Biometrics Server",
	"_otlp":                                 "OTLP",
	"_jmact3":                               "JMACT3",
	"_jmevt2":                               "jmevt2",
	"_swismgr1":                             "swismgr1",
	"_swismgr2":                             "swismgr2",
	"_swistrap":                             "swistrap",
	"_swispol":                              "swispol",
	"_acmsoda":                              "acmsoda",
	"_conductor":                            "Conductor test coordination protocol",
	"_conductor-mpx":                        "conductor for multiplex",
	"_qolyester":                            "QoS-extended OLSR protocol",
	"_mobilitysrv":                          "Mobility XE Protocol",
	"_iatp-highpri":                         "IATP-highPri",
	"_iatp-normalpri":                       "IATP-normalPri",
	"_afs3-fileserver":                      "file server itself",
	"_afs3-callback":                        "callbacks to cache managers",
	"_afs3-prserver":                        "users & groups database",
	"_afs3-vlserver":                        "volume location database",
	"_afs3-kaserver":                        "AFS/Kerberos authentication service",
	"_afs3-volser":                          "volume managment server",
	"_afs3-errors":                          "error interpretation service",
	"_afs3-bos":                             "basic overseer process",
	"_afs3-update":                          "server-to-server updater",
	"_afs3-rmtsys":                          "remote cache manager service",
	"_ups-onlinet":                          "onlinet uninterruptable power supplies",
	"_talon-disc":                           "Talon Discovery Port",
	"_talon-engine":                         "Talon Engine",
	"_microtalon-dis":                       "Microtalon Discovery",
	"_microtalon-com":                       "Microtalon Communications",
	"_talon-webserver":                      "Talon Webserver",
	"_spg":                                  "SPG Controls Carrier",
	"_grasp":                                "GeneRic Autonomic Signaling Protocol",
	"_fisa-svc":                             "FISA Service",
	"_doceri-ctl":                           "doceri drawing service control",
	"_doceri-view":                          "doceri drawing service screen view",
	"_dpserve":                              "DP Serve",
	"_dpserveadmin":                         "DP Serve Admin",
	"_ctdp":                                 "CT Discovery Protocol",
	"_ct2nmcs":                              "Comtech T2 NMCS",
	"_vmsvc":                                "Vormetric service",
	"_vmsvc-2":                              "Vormetric Service II",
	"_loreji-panel":                         "Loreji Webhosting Panel",
	"_op-probe":                             "ObjectPlanet probe",
	"_iposplanet":                           "IPOSPLANET retailing multi devices protocol",
	"_quest-disc":                           "Quest application level network service discovery",
	"_arcp":                                 "ARCP",
	"_iwg1":                                 "IWGADTS Aircraft Housekeeping Message",
	"_iba-cfg":                              "iba Device Configuration Protocol",
	"_iba-cfg-disc":                         "iba Device Configuration Protocol",
	"_martalk":                              "MarTalk protocol",
	"_empowerid":                            "EmpowerID Communication",
	"_zixi-transport":                       "Zixi live video transport protocol",
	"_jdp-disc":                             "Java Discovery Protocol",
	"_lazy-ptop":                            "lazy-ptop",
	"_font-service":                         "X Font Service",
	"_elcn":                                 "Embedded Light Control Network",
	"_aes-x170":                             "AES-X170",
	"_rothaga":                              "Encrypted chat and file transfer service",
	"_virprot-lm":                           "Virtual Prototypes License Manager",
	"_snif":                                 "End-to-end TLS Relay Control Connection",
	"_scenidm":                              "intelligent data manager",
	"_scenccs":                              "Catalog Content Search",
	"_cabsm-comm":                           "CA BSM Comm",
	"_caistoragemgr":                        "CA Storage Manager",
	"_cacsambroker":                         "CA Connection Broker",
	"_fsr":                                  "File System Repository Agent",
	"_doc-server":                           "Document WCF Server",
	"_aruba-server":                         "Aruba eDiscovery Server",
	"_casrmagent":                           "CA SRM Agent",
	"_cnckadserver":                         "cncKadServer DB & Inventory Services",
	"_ccag-pib":                             "Consequor Consulting Process Integration Bridge",
	"_nsrp":                                 "Adaptive Name/Service Resolution",
	"_drm-production":                       "Discovery and Retention Mgt Production",
	"_metalbend":                            "Port used for MetalBend programmable interface",
	"_zsecure":                              "zSecure Server",
	"_clutild":                              "Clutild",
	"_janus-disc":                           "Janus Guidewire Enterprise Discovery Service Bus",
	"_fodms":                                "FODMS FLIP",
	"_dlip":                                 "DLIP",
	"_pon-ictp":                             "Inter-Channel Termination Protocol (ICTP) for multi-wavelength PON    (Passive Optical Network) systems",
	"_ps-server":                            "Communication ports for PaperStream Server services",
	"_ps-capture-pro":                       "PaperStream Capture Professional",
	"_ramp":                                 "Registry A & M Protocol",
	"_citrixupp":                            "Citrix Universal Printing Port",
	"_citrixuppg":                           "Citrix UPP Gateway",
	"_asa-gateways":                         "Traffic forwarding for Okta cloud infra",
	"_aspcoordination":                      "ASP Coordination Protocol",
	"_display":                              "Wi-Fi Alliance Wi-Fi Display Protocol",
	"_pads":                                 "PADS (Public Area Display System) Server",
	"_frc-hicp":                             "FrontRow Calypso Human Interface Control Protocol",
	"_frc-hicp-disc":                        "FrontRow Calypso Human Interface Control Protocol",
	"_cnap":                                 "Calypso Network Access Protocol",
	"_watchme-7272":                         "WatchMe Monitoring 7272",
	"_oma-rlp":                              "OMA Roaming Location",
	"_oma-rlp-s":                            "OMA Roaming Location SEC",
	"_oma-ulp":                              "OMA UserPlane Location",
	"_oma-ilp":                              "OMA Internal Location Protocol",
	"_oma-ilp-s":                            "OMA Internal Location Secure Protocol",
	"_oma-dcdocbs":                          "OMA Dynamic Content Delivery over CBS",
	"_ctxlic":                               "Citrix Licensing",
	"_itactionserver1":                      "ITACTIONSERVER 1",
	"_itactionserver2":                      "ITACTIONSERVER 2",
	"_mzca-action":                          "eventACTION/ussACTION (MZCA) server",
	"_mzca-alert":                           "eventACTION/ussACTION (MZCA) alert",
	"_genstat":                              "General Statistics Rendezvous Protocol",
	"_swx":                                  "The Swiss Exchange",
	"_lcm-server":                           "LifeKeeper Communications",
	"_mindfilesys":                          "mind-file system server",
	"_mrssrendezvous":                       "mrss-rendezvous server",
	"_nfoldman":                             "nFoldMan Remote Publish",
	"_fse":                                  "File system export of backup images",
	"_winqedit":                             "winqedit",
	"_hexarc":                               "Hexarc Command Language",
	"_rtps-discovery":                       "RTPS Discovery",
	"_rtps-dd-ut":                           "RTPS Data-Distribution User-Traffic",
	"_rtps-dd-mt":                           "RTPS Data-Distribution Meta-Traffic",
	"_ionixnetmon":                          "Ionix Network Monitor",
	"_daqstream":                            "Streaming of measurement data",
	"_ipluminary":                           "Multichannel real-time lighting control",
	"_mtportmon":                            "Matisse Port Monitor",
	"_pmdmgr":                               "OpenView DM Postmaster Manager",
	"_oveadmgr":                             "OpenView DM Event Agent Manager",
	"_ovladmgr":                             "OpenView DM Log Agent Manager",
	"_opi-sock":                             "OpenView DM rqt communication",
	"_xmpv7":                                "OpenView DM xmpv7 api pipe",
	"_pmd":                                  "OpenView DM ovc/xmpv3 api pipe",
	"_faximum":                              "Faximum",
	"_oracleas-https":                       "Oracle Application Server HTTPS",
	"_sttunnel":                             "Stateless Transport Tunneling Protocol",
	"_rise":                                 "Rise: The Vieneo Province",
	"_neo4j":                                "Neo4j Graph Database",
	"_openit":                               "IT Asset Management",
	"_telops-lmd":                           "telops-lmd",
	"_silhouette":                           "Silhouette User",
	"_ovbus":                                "HP OpenView Bus Daemon",
	"_adcp":                                 "Automation Device Configuration Protocol",
	"_acplt":                                "ACPLT - process automation service",
	"_ovhpas":                               "HP OpenView Application Server",
	"_pafec-lm":                             "pafec-lm",
	"_saratoga":                             "Saratoga Transfer Protocol",
	"_atul":                                 "atul server",
	"_nta-ds":                               "FlowAnalyzer DisplayServer",
	"_nta-us":                               "FlowAnalyzer UtilityServer",
	"_cfs":                                  "Cisco Fabric service",
	"_cwmp":                                 "Broadband Forum CWMP",
	"_tidp":                                 "Threat Information Distribution Protocol",
	"_nls-tl":                               "Network Layer Signaling Transport Layer",
	"_cloudsignaling":                       "Cloud Signaling Service",
	"_controlone-con":                       "ControlONE Console signaling",
	"_sncp":                                 "Sniffer Command Protocol",
	"_cfw":                                  "Control Framework",
	"_vsi-omega":                            "VSI Omega",
	"_dell-eql-asm":                         "Dell EqualLogic Host Group Management",
	"_aries-kfinder":                        "Aries Kfinder",
	"_coherence":                            "Oracle Coherence Cluster Service",
	"_coherence-disc":                       "Oracle Coherence Cluster discovery service",
	"_wtmi-panel":                           "Main access port for WTMI Panel",
	"_sun-lm":                               "Sun License Manager",
	"_mipi-debug":                           "MIPI Alliance Debug",
	"_indi":                                 "Instrument Neutral Distributed Interface",
	"_simco":                                "SImple Middlebox COnfiguration (SIMCO) Server",
	"_soap-http":                            "SOAP Service Port",
	"_zen-pawn":                             "Primary Agent Work Notification",
	"_xdas":                                 "OpenXDAS Wire Protocol",
	"_hawk":                                 "HA Web Konsole",
	"_tesla-sys-msg":                        "TESLA System Messaging",
	"_pmdfmgt":                              "PMDF Management",
	"_cuseeme":                              "bonjour-cuseeme",
	"_rome":                                 "Proprietary immutable distributed data storage",
	"_imqstomp":                             "iMQ STOMP Server",
	"_imqstomps":                            "iMQ STOMP Server over SSL",
	"_imqtunnels":                           "iMQ SSL tunnel",
	"_imqtunnel":                            "iMQ Tunnel",
	"_imqbrokerd":                           "iMQ Broker Rendezvous",
	"_sun-user-https":                       "Sun App Server - HTTPS",
	"_ms-do":                                "Microsoft Delivery Optimization Peer-to-Peer",
	"_dmt":                                  "Cleondris DMT",
	"_bolt":                                 "Bolt database connection",
	"_collaber":                             "Collaber Network Service",
	"_sovd":                                 "Service-Oriented Vehicle Diagnostics",
	"_klio":                                 "KLIO communications",
	"_em7-secom":                            "EM7 Secure Communications",
	"_nfapi":                                "SCF nFAPI defining MAC/PHY split",
	"_sync-em7":                             "EM7 Dynamic Updates",
	"_scinet":                               "scientia.net",
	"_medimageportal":                       "MedImage Portal",
	"_nsdeepfreezectl":                      "Novell Snap-in Deep Freeze Control",
	"_nitrogen":                             "Nitrogen Service",
	"_freezexservice":                       "FreezeX Console Service",
	"_trident-data":                         "Trident Systems Data",
	"_osvr":                                 "Open-Source Virtual Reality",
	"_smip":                                 "Smith Protocol over IP",
	"_aiagent":                              "HP Enterprise Discovery Agent",
	"_scriptview":                           "ScriptView Network",
	"_msss":                                 "Mugginsoft Script Server Service",
	"_sstp-1":                               "Sakura Script Transfer Protocol",
	"_raqmon-pdu":                           "RAQMON PDU",
	"_prgp":                                 "Put/Run/Get Protocol",
	"_inetfs":                               "A File System using TLS over a wide area network",
	"_cbt":                                  "cbt",
	"_interwise":                            "Interwise",
	"_vstat":                                "VSTAT",
	"_accu-lmgr":                            "accu-lmgr",
	"_s-bfd":                                "Seamless Bidirectional Forwarding Detection (S-BFD)",
	"_minivend":                             "MINIVEND",
	"_popup-reminders":                      "Popup Reminders Receive",
	"_office-tools":                         "Office Tools Pro Receive",
	"_q3ade":                                "Q3ADE Cluster Service",
	"_pnet-conn":                            "Propel Connector port",
	"_pnet-enc":                             "Propel Encoder port",
	"_altbsdp":                              "Alternate BSDP Service",
	"_asr":                                  "Apple Software Restore",
	"_ssp-client":                           "Secure Server Protocol - client",
	"_vns-tp":                               "Virtualized Network Services Tunnel Protocol",
	"_rbt-wanopt":                           "Riverbed WAN Optimization Protocol",
	"_apc-7845":                             "APC 7845",
	"_apc-7846":                             "APC 7846",
	"_csoauth":                              "A product key authentication protocol made by CSO",
	"_mobileanalyzer":                       "MobileAnalyzer& MobileMonitor",
	"_rbt-smc":                              "Riverbed Steelhead Mobile Service",
	"_mdm":                                  "Mobile Device Management",
	"_mipv6tls":                             "TLS-based Mobile IPv6 Security",
	"_owms":                                 "Opswise Message Service",
	"_pss":                                  "Pearson",
	"_ubroker":                              "Universal Broker",
	"_mevent":                               "Multicast Event",
	"_tnos-sp":                              "TNOS Service Protocol",
	"_tnos-dp":                              "TNOS shell Protocol",
	"_tnos-dps":                             "TNOS Secure DiaguardProtocol",
	"_qo-secure":                            "QuickObjects secure port",
	"_t2-drm":                               "Tier 2 Data Resource Manager",
	"_t2-brm":                               "Tier 2 Business Rules Manager",
	"_generalsync":                          "Encrypted, extendable, general-purpose synchronization protocol",
	"_supercell":                            "Supercell",
	"_micromuse-ncps":                       "Micromuse-ncps",
	"_quest-vista":                          "Quest Vista",
	"_sossd-collect":                        "Spotlight on SQL Server Desktop Collect",
	"_sossd-agent":                          "Spotlight on SQL Server Desktop Agent",
	"_sossd-disc":                           "Spotlight on SQL Server Desktop Agent Discovery",
	"_pushns":                               "PUSH Notification Service",
	"_usicontentpush":                       "USI Content Push Service",
	"_irdmi2":                               "iRDMI2",
	"_irdmi":                                "iRDMI",
	"_vcom-tunnel":                          "VCOM Tunnel",
	"_teradataordbms":                       "Teradata ORDBMS",
	"_mcreport":                             "Mulberry Connect Reporting Service",
	"_p2pevolvenet":                         "Opensource Evolv Enterprise Platform P2P Network Node Connection Protocol",
	"_mxi":                                  "MXI Generation II for z/OS",
	"_wpl-analytics":                        "World Programming analytics",
	"_wpl-disc":                             "World Programming analytics discovery",
	"_warppipe":                             "I/O oriented cluster computing software",
	"_nvme-disc":                            "NVMe over Fabrics Discovery Service",
	"_cfg-cloud":                            "Configuration Cloud Service",
	"_ads-s":                                "Beckhoff Automation Device Specification",
	"_cisco-cloudsec":                       "Cisco Cloudsec Dataplane Port Number",
	"_qbdb":                                 "QB DB Dynamic Port",
	"_intu-ec-svcdisc":                      "Intuit Entitlement Service and Discovery",
	"_intu-ec-client":                       "Intuit Entitlement Client",
	"_oa-system":                            "oa-system",
	"_arca-api":                             "ARCATrust vault API",
	"_ca-audit-da":                          "CA Audit Distribution Agent",
	"_ca-audit-ds":                          "CA Audit Distribution Server",
	"_papachi-p2p-srv":                      "peer tracker and data relay service",
	"_pro-ed":                               "ProEd",
	"_mindprint":                            "MindPrint",
	"_vantronix-mgmt":                       ".vantronix Management",
	"_ampify":                               "Ampify Messaging Protocol",
	"_enguity-xccetp":                       "Xcorpeon ASIC Carrier Ethernet Transport",
	"_fs-agent":                             "FireScope Agent",
	"_fs-server":                            "FireScope Server",
	"_fs-mgmt":                              "FireScope Management Interface",
	"_rocrail":                              "Rocrail Client Service",
	"_senomix01":                            "Senomix Timesheets Server",
	"_senomix02":                            "Senomix Timesheets Client [1 year assignment]",
	"_senomix03":                            "Senomix Timesheets Server [1 year assignment]",
	"_senomix04":                            "Senomix Timesheets Server [1 year assignment]",
	"_senomix05":                            "Senomix Timesheets Server [1 year assignment]",
	"_senomix06":                            "Senomix Timesheets Client [1 year assignment]",
	"_senomix07":                            "Senomix Timesheets Client [1 year assignment]",
	"_senomix08":                            "Senomix Timesheets Client [1 year assignment]",
	"_aero":                                 "Asymmetric Extended Route Optimization (AERO)",
	"_nikatron-dev":                         "Nikatron Device Protocol",
	"_toad-bi-appsrvr":                      "Toad BI Application Server",
	"_infi-async":                           "Infinidat async replication",
	"_ucs-isc":                              "Oracle Unified Communication Suite's Indexed Search Converter",
	"_gadugadu":                             "Gadu-Gadu",
	"_sunproxyadmin":                        "Sun Proxy Admin Service",
	"_us-cli":                               "Utilistor (Client)",
	"_us-srv":                               "Utilistor (Server)",
	"_websnp":                               "Snarl Network Protocol over HTTP",
	"_d-s-n":                                "Distributed SCADA Networking Rendezvous Port",
	"_simplifymedia":                        "Simplify Media SPP Protocol",
	"_radan-http":                           "Radan HTTP",
	"_opsmessaging":                         "Vehicle to station messaging",
	"_jamlink":                              "Jam Link Framework",
	"_sac":                                  "SAC Port Id",
	"_xprint-server":                        "Xprint Server",
	"_ldoms-migr":                           "Logical Domains Migration",
	"_kz-migr":                              "Oracle Kernel zones migration server",
	"_skynetflow":                           "Skynetflow network services",
	"_mtl8000-matrix":                       "MTL8000 Matrix",
	"_cp-cluster":                           "Check Point Clustering",
	"_purityrpc":                            "Purity replication clustering and remote management",
	"_privoxy":                              "Privoxy HTTP proxy",
	"_apollo-data":                          "Apollo Data Port",
	"_apollo-admin":                         "Apollo Admin Port",
	"_paycash-online":                       "PayCash Online Protocol",
	"_paycash-wbp":                          "PayCash Wallet-Browser",
	"_indigo-vrmi":                          "INDIGO-VRMI",
	"_indigo-vbcp":                          "INDIGO-VBCP",
	"_dbabble":                              "dbabble",
	"_puppet":                               "The Puppet master service",
	"_isdd":                                 "i-SDD file transfer",
	"_eor-game":                             "Edge of Reality game data",
	"_quantastor":                           "QuantaStor Management Interface",
	"_patrol":                               "Patrol",
	"_patrol-snmp":                          "Patrol SNMP",
	"_lpar2rrd":                             "LPAR2RRD client server communication",
	"_intermapper":                          "Intermapper network management system",
	"_vmware-fdm":                           "VMware Fault Domain Manager",
	"_proremote":                            "ProRemote",
	"_itach":                                "Remote iTach Connection",
	"_gcp-rphy":                             "Generic control plane for RPHY",
	"_limnerpressure":                       "Limner Pressure",
	"_spytechphone":                         "SpyTech Phone Service",
	"_blp1":                                 "Bloomberg data API",
	"_blp2":                                 "Bloomberg feed",
	"_vvr-data":                             "VVR DATA",
	"_trivnet1":                             "TRIVNET",
	"_trivnet2":                             "TRIVNET",
	"_aesop":                                "Audio+Ethernet Standard Open Protocol",
	"_lm-perfworks":                         "LM Perfworks",
	"_lm-instmgr":                           "LM Instmgr",
	"_lm-dta":                               "LM Dta",
	"_lm-sserver":                           "LM SServer",
	"_lm-webwatcher":                        "LM Webwatcher",
	"_aruba-papi":                           "Aruba Networks AP management",
	"_rexecj":                               "RexecJ Server",
	"_hncp-udp-port":                        "HNCP",
	"_hncp-dtls-port":                       "HNCP over DTLS",
	"_synapse-nhttps":                       "Synapse Non Blocking HTTPS",
	"_espeasy-p2p":                          "ESPeasy peer-2-peer communication",
	"_robot-remote":                         "Robot Framework Remote Library Interface",
	"_ms-mcc":                               "Microsoft Connected Cache",
	"_synapse-nhttp":                        "Synapse Non Blocking HTTP",
	"_libelle":                              "Libelle EnterpriseBus",
	"_libelle-disc":                         "Libelle EnterpriseBus discovery",
	"_blp3":                                 "Bloomberg professional",
	"_hiperscan-id":                         "Hiperscan Identification Service",
	"_blp4":                                 "Bloomberg intelligent client",
	"_tmi":                                  "Transport Management Interface",
	"_amberon":                              "Amberon PPC/PPS",
	"_hub-open-net":                         "Hub Open Network",
	"_tnp-discover":                         "Thin(ium) Network Protocol",
	"_tnp":                                  "Thin(ium) Network Protocol",
	"_garmin-marine":                        "Garmin Marine",
	"_server-find":                          "Server Find",
	"_cruise-enum":                          "Cruise ENUM",
	"_cruise-swroute":                       "Cruise SWROUTE",
	"_cruise-config":                        "Cruise CONFIG",
	"_cruise-diags":                         "Cruise DIAGS",
	"_cruise-update":                        "Cruise UPDATE",
	"_m2mservices":                          "M2m Services",
	"_marathontp":                           "Marathon Transport Protocol",
	"_cvd":                                  "cvd",
	"_sabarsd":                              "sabarsd",
	"_abarsd":                               "abarsd",
	"_svcloud":                              "SuperVault Cloud",
	"_svbackup":                             "SuperVault Backup",
	"_dlpx-sp":                              "Delphix Session Protocol",
	"_espeech":                              "eSpeech Session Protocol",
	"_espeech-rtp":                          "eSpeech RTP Protocol",
	"_aritts":                               "Aristech text-to-speech server",
	"_pgbackrest":                           "PostgreSQL Backup",
	"_aws-as2":                              "Non Persistent Desktop and Application Streaming",
	"_cybro-a-bus":                          "CyBro A-bus Protocol",
	"_pcsync-https":                         "PCsync HTTPS",
	"_pcsync-http":                          "PCsync HTTP",
	"_copy":                                 "Port for copy peer sync feature",
	"_copy-disc":                            "Port for copy discovery",
	"_matrix-fed":                           "Matrix Federation Protocol",
	"_npmp":                                 "npmp",
	"_nexentamv":                            "Nexenta Management GUI",
	"_cisco-avp":                            "Cisco Address Validation Protocol",
	"_pim-port":                             "PIM over Reliable Transport",
	"_otv":                                  "Overlay Transport Virtualization (OTV)",
	"_vp2p":                                 "Virtual Point to Point",
	"_noteshare":                            "AquaMinds NoteShare",
	"_fmtp":                                 "Flight Message Transfer Protocol",
	"_cmtp-mgt":                             "CYTEL Message Transfer Management",
	"_cmtp-av":                              "CYTEL Message Transfer Audio and Video",
	"_ftnmtp":                               "FTN Message Transfer Protocol",
	"_lsp-self-ping":                        "MPLS LSP Self-Ping",
	"_rtsp-alt":                             "RTSP Alternate (see port 554)",
	"_d-fence":                              "SYMAX D-FENCE",
	"_dof-tunnel":                           "DOF Tunneling Protocol",
	"_asterix":                              "Surveillance Data",
	"_canon-cpp-disc":                       "Canon Compact Printer Protocol Discovery",
	"_canon-mfnp":                           "Canon MFNP Service",
	"_canon-bjnp1":                          "Canon BJNP Port 1",
	"_canon-bjnp2":                          "Canon BJNP Port 2",
	"_canon-bjnp3":                          "Canon BJNP Port 3",
	"_canon-bjnp4":                          "Canon BJNP Port 4",
	"_imink":                                "Imink Service Control",
	"_monetra":                              "Monetra",
	"_monetra-admin":                        "Monetra Administrative Access",
	"_spartan":                              "Spartan management",
	"_msi-cps-rm":                           "Motorola Solutions Customer Programming Software for Radio Management",
	"_msi-cps-rm-disc":                      "Motorola Solutions Customer Programming Software for Radio Management Discovery",
	"_sun-as-jmxrmi":                        "Sun App Server - JMX/RMI",
	"_openremote-ctrl":                      "OpenRemote Controller HTTP/REST",
	"_vnyx":                                 "VNYX Primary Port",
	"_semi-grpc":                            "gRPC for SEMI Standards implementations",
	"_nvc":                                  "Nuance Voice Control",
	"_dtp-net":                              "DASGIP Net Services",
	"_ibus":                                 "iBus",
	"_dey-keyneg":                           "DEY Storage Key Negotiation",
	"_mc-appserver":                         "MC-APPSERVER",
	"_openqueue":                            "OPENQUEUE",
	"_ultraseek-http":                       "Ultraseek HTTP",
	"_amcs":                                 "Agilent Connectivity Service",
	"_core-of-source":                       "Online mobile multiplayer game",
	"_sandpolis":                            "Sandpolis Server",
	"_oktaauthenticat":                      "Okta MultiPlatform Access Mgmt for Cloud Svcs",
	"_dpap":                                 "Digital Photo Access Protocol (iPhoto)",
	"_uec":                                  "Stonebranch Universal Enterprise Controller",
	"_msgclnt":                              "Message Client",
	"_msgsrvr":                              "Message Server",
	"_acd-pm":                               "Accedian Performance Measurement",
	"_sunwebadmin":                          "Sun Web Server Admin Service",
	"_truecm":                               "truecm",
	"_pfcp":                                 "Destination Port number for PFCP",
	"_hes-clip":                             "HES-CLIP Interoperability protocol",
	"_ssports-bcast":                        "STATSports Broadcast Service",
	"_3gpp-monp":                            "MCPTT Off-Network Protocol (MONP)",
	"_dxspider":                             "dxspider linking protocol",
	"_cddbp-alt":                            "CDDBP",
	"_galaxy4d":                             "Galaxy4D Online Game Engine",
	"_secure-mqtt":                          "Secure MQTT",
	"_ddi-tcp-1":                            "NewsEDGE server TCP (TCP 1)",
	"_ddi-udp-1":                            "NewsEDGE server UDP (UDP 1)",
	"_ddi-tcp-2":                            "Desktop Data TCP 1",
	"_ddi-udp-2":                            "NewsEDGE server broadcast",
	"_ddi-tcp-3":                            "Desktop Data TCP 2",
	"_ddi-udp-3":                            "NewsEDGE client broadcast",
	"_ddi-tcp-4":                            "Desktop Data TCP 3: NESS application",
	"_ddi-udp-4":                            "Desktop Data UDP 3: NESS application",
	"_ddi-tcp-5":                            "Desktop Data TCP 4: FARM product",
	"_ddi-udp-5":                            "Desktop Data UDP 4: FARM product",
	"_ddi-tcp-6":                            "Desktop Data TCP 5: NewsEDGE/Web application",
	"_ddi-udp-6":                            "Desktop Data UDP 5: NewsEDGE/Web application",
	"_ddi-tcp-7":                            "Desktop Data TCP 6: COAL application",
	"_ddi-udp-7":                            "Desktop Data UDP 6: COAL application",
	"_ospf-lite":                            "ospf-lite",
	"_jmb-cds1":                             "JMB-CDS 1",
	"_jmb-cds2":                             "JMB-CDS 2",
	"_dpp":                                  "WFA Device Provisioning Protocol",
	"_manyone-http":                         "manyone-http",
	"_manyone-xml":                          "manyone-xml",
	"_wcbackup":                             "Windows Client Backup",
	"_dragonfly":                            "Dragonfly System Service",
	"_twds":                                 "Transaction Warehouse Data Service",
	"_ub-dns-control":                       "unbound dns nameserver control",
	"_cumulus-admin":                        "Cumulus Admin Port",
	"_nod-provider":                         "Network of Devices Provider",
	"_nod-client":                           "Network of Devices Client",
	"_sunwebadmins":                         "Sun Web Server SSL Admin Service",
	"_http-wmap":                            "webmail HTTP service",
	"_https-wmap":                           "webmail HTTPS service",
	"_oracle-ms-ens":                        "Oracle Messaging Server Event Notification Service",
	"_canto-roboflow":                       "Canto RoboFlow Control",
	"_bctp":                                 "Brodos Crypto Trade Protocol",
	"_cslistener":                           "CSlistener",
	"_etlservicemgr":                        "ETL Service Manager",
	"_dynamid":                              "DynamID authentication",
	"_golem":                                "Golem Inter-System RPC",
	"_ogs-client":                           "Open Grid Services Client",
	"_ogs-server":                           "Open Grid Services Server",
	"_pichat":                               "Pichat Server",
	"_sdr":                                  "Secure Data Replicator Protocol",
	"_d-star":                               "D-Star Routing digital voice+data for amateur radio",
	"_tambora":                              "TAMBORA",
	"_panagolin-ident":                      "Pangolin Identification",
	"_paragent":                             "PrivateArk Remote Agent",
	"_swa-1":                                "Secure Web Access - 1",
	"_swa-2":                                "Secure Web Access - 2",
	"_swa-3":                                "Secure Web Access - 3",
	"_swa-4":                                "Secure Web Access - 4",
	"_versiera":                             "Versiera Agent Listener",
	"_fio-cmgmt":                            "Fusion-io Central Manager Service",
	"_cardweb-io":                           "CardWeb request-response I/O exchange",
	"_cardweb-rt":                           "CardWeb realtime device data",
	"_glrpc":                                "Groove GLRPC",
	"_cisco-aqos":                           "Required for Adaptive Quality of Service",
	"_lcs-ap":                               "LCS Application Protocol",
	"_emc-pp-mgmtsvc":                       "EMC PowerPath Mgmt Service",
	"_aurora":                               "IBM AURORA Performance Visualizer",
	"_ibm-rsyscon":                          "IBM Remote System Console",
	"_net2display":                          "Vesa Net2Display",
	"_classic":                              "Classic Data Server",
	"_sqlexec":                              "IBM Informix SQL Interface",
	"_sqlexec-ssl":                          "IBM Informix SQL Interface - Encrypted",
	"_websm":                                "WebSM",
	"_xmltec-xmlmail":                       "xmltec-xmlmail",
	"_xmlipcregsvc":                         "Xml-Ipc Server Reg",
	"_copycat":                              "Copycat database replication service",
	"_hp-pdl-datastr":                       "PDL Data Streaming Port",
	"_pdl-datastream":                       "Printer PDL Data Stream",
	"_bacula-dir":                           "Bacula Director",
	"_bacula-fd":                            "Bacula File Daemon",
	"_bacula-sd":                            "Bacula Storage Daemon",
	"_peerwire":                             "PeerWire",
	"_xadmin":                               "Xadmin Control Service",
	"_astergate":                            "Astergate Control Service",
	"_astergate-disc":                       "Astergate Discovery Service",
	"_astergatefax":                         "AstergateFax Control Service",
	"_hexxorecore":                          "Multiple Purpose, Distributed Message Bus",
	"_mxit":                                 "MXit Instant Messaging",
	"_grcmp":                                "Global Relay compliant mobile instant messaging protocol",
	"_grcp":                                 "Global Relay compliant instant messaging protocol",
	"_dddp":                                 "Dynamic Device Discovery",
	"_apani1":                               "apani1",
	"_apani2":                               "apani2",
	"_apani3":                               "apani3",
	"_apani4":                               "apani4",
	"_apani5":                               "apani5",
	"_sun-as-jpda":                          "Sun AppSvr JPDA",
	"_wap-wsp":                              "WAP connectionless session service",
	"_wap-wsp-wtp":                          "WAP session service",
	"_wap-wsp-s":                            "WAP secure connectionless session service",
	"_wap-wsp-wtp-s":                        "WAP secure session service",
	"_wap-vcard":                            "WAP vCard",
	"_wap-vcal":                             "WAP vCal",
	"_wap-vcard-s":                          "WAP vCard Secure",
	"_wap-vcal-s":                           "WAP vCal Secure",
	"_rjcdb-vcards":                         "rjcdb vCard",
	"_almobile-system":                      "ALMobile System Service",
	"_oma-mlp":                              "OMA Mobile Location Protocol",
	"_oma-mlp-s":                            "OMA Mobile Location Protocol Secure",
	"_serverviewdbms":                       "Server View dbms access",
	"_serverstart":                          "ServerStart RemoteControl",
	"_ipdcesgbs":                            "IPDC ESG BootstrapService",
	"_insis":                                "Integrated Setup and Install Service",
	"_acme":                                 "Aionex Communication Management Engine",
	"_fsc-port":                             "FSC Communication Port",
	"_teamcoherence":                        "QSC Team Coherence",
	"_traingpsdata":                         "GPS Data transmitted from train to ground network",
	"_pegasus":                              "Pegasus GPS Platform",
	"_pegasus-ctl":                          "Pegaus GPS System Control Interface",
	"_pgps":                                 "Predicted GPS",
	"_swtp-port1":                           "SofaWare transport port 1",
	"_swtp-port2":                           "SofaWare transport port 2",
	"_callwaveiam":                          "CallWaveIAM",
	"_visd":                                 "VERITAS Information Serve",
	"_n2h2server":                           "N2H2 Filter Service Port",
	"_n2receive":                            "n2 monitoring receiver",
	"_cumulus":                              "Cumulus",
	"_armtechdaemon":                        "ArmTech Daemon",
	"_storview":                             "StorView Client",
	"_armcenterhttp":                        "ARMCenter http Service",
	"_armcenterhttps":                       "ARMCenter https Service",
	"_vrace":                                "Virtual Racing Service",
	"_sphinxql":                             "Sphinx search server (MySQL listener)",
	"_sapms":                                "SAP Message Server",
	"_sphinxapi":                            "Sphinx search server",
	"_secure-ts":                            "PKIX TimeStamp over TLS",
	"_guibase":                              "guibase",
	"_gnmi-gnoi":                            "gRPC Network Mgmt/Operations Interface",
	"_gribi":                                "gRPC Routing Information Base Interface",
	"_mpidcmgr":                             "MpIdcMgr",
	"_mphlpdmc":                             "Mphlpdmc",
	"_rancher":                              "Rancher Agent",
	"_ctechlicensing":                       "C Tech Licensing",
	"_fjdmimgr":                             "fjdmimgr",
	"_boxp":                                 "Brivs! Open Extensible Protocol",
	"_d2dconfig":                            "D2D Configuration Service",
	"_d2ddatatrans":                         "D2D Data Transfer Service",
	"_adws":                                 "Active Directory Web Services",
	"_otp":                                  "OpenVAS Transfer Protocol",
	"_fjinvmgr":                             "fjinvmgr",
	"_mpidcagt":                             "MpIdcAgt",
	"_sec-t4net-srv":                        "Samsung Twain for Network Server",
	"_sec-t4net-clt":                        "Samsung Twain for Network Client",
	"_sec-pc2fax-srv":                       "Samsung PC2FAX for Network Server",
	"_git":                                  "git pack transfer service",
	"_tungsten-https":                       "WSO2 Tungsten HTTPS",
	"_wso2esb-console":                      "WSO2 ESB Administration Console HTTPS",
	"_mindarray-ca":                         "MindArray Systems Console Agent",
	"_sntlkeyssrvr":                         "Sentinel Keys Server",
	"_ismserver":                            "ismserver",
	"_sma-spw":                              "SMA Speedwire",
	"_mngsuite":                             "Management Suite Remote Control",
	"_laes-bf":                              "Surveillance buffering function",
	"_trispen-sra":                          "Trispen Secure Remote Access",
	"_p4runtime":                            "P4Runtime gRPC Service",
	"_ldgateway":                            "LANDesk Gateway",
	"_cba8":                                 "LANDesk Management Agent (cba8)",
	"_msgsys":                               "Message System",
	"_pds":                                  "Ping Discovery Service",
	"_mercury-disc":                         "Mercury Discovery",
	"_pd-admin":                             "PD Administration",
	"_vscp":                                 "Very Simple Ctrl Protocol",
	"_robix":                                "Robix",
	"_micromuse-ncpw":                       "MICROMUSE-NCPW",
	"_streamcomm-ds":                        "StreamComm User Directory",
	"_iadt-tls":                             "iADT Protocol over TLS",
	"_erunbook-agent":                       "eRunbook Agent IANA assigned this well-formed service name as a replacement for 'erunbook_agent'.",
	"_erunbook_agent":                       "eRunbook Agent",
	"_erunbook-server":                      "eRunbook Server IANA assigned this well-formed service name as a replacement for 'erunbook_server'.",
	"_erunbook_server":                      "eRunbook Server",
	"_condor":                               "Condor Collector Service",
	"_odbcpathway":                          "ODBC Pathway Service",
	"_uniport":                              "UniPort SSO Controller",
	"_peoctlr":                              "Peovica Controller",
	"_peocoll":                              "Peovica Collector",
	"_mc-comm":                              "Mobile-C Communications",
	"_pqsflows":                             "ProQueSys Flows Service",
	"_zoomcp":                               "Zoom Control Panel Game Server Management",
	"_xmms2":                                "Cross-platform Music Multiplexing System",
	"_tec5-sdctp":                           "tec5 Spectral Device Control Protocol",
	"_client-wakeup":                        "T-Mobile Client Wakeup Message",
	"_ccnx":                                 "Content Centric Networking",
	"_board-roar":                           "Board M.I.T. Service",
	"_l5nas-parchan":                        "L5NAS Parallel Channel",
	"_board-voip":                           "Board M.I.T. Synchronous Collaboration",
	"_rasadv":                               "rasadv",
	"_tungsten-http":                        "WSO2 Tungsten HTTP",
	"_davsrc":                               "WebDav Source Port",
	"_sstp-2":                               "Sakura Script Transfer Protocol-2",
	"_davsrcs":                              "WebDAV Source TLS/SSL",
	"_sapv1":                                "Session Announcement v1",
	"_sd":                                   "Session Director",
	"_x510":                                 "The X.510 wrapper protocol",
	"_kca-service":                          "The KX509 Kerberized Certificate Issuance Protocol in Use in 2012",
	"_cyborg-systems":                       "CYBORG Systems",
	"_gt-proxy":                             "Port for Cable network related data proxy or repeater",
	"_monkeycom":                            "MonkeyCom",
	"_sctp-tunneling":                       "SCTP TUNNELING",
	"_iua":                                  "IUA",
	"_enrp":                                 "enrp server channel",
	"_enrp-sctp":                            "enrp server channel",
	"_enrp-sctp-tls":                        "enrp/tls server channel",
	"_multicast-ping":                       "Multicast Ping Protocol",
	"_domaintime":                           "domaintime",
	"_sype-transport":                       "SYPECom Transport Protocol",
	"_xybrid-cloud":                         "XYBRID Cloud",
	"_apc-9950":                             "APC 9950",
	"_apc-9951":                             "APC 9951",
	"_apc-9952":                             "APC 9952",
	"_acis":                                 "9953",
	"_hinp":                                 "HaloteC Instrument Network Protocol",
	"_alljoyn-stm":                          "Contact Port for AllJoyn standard messaging",
	"_alljoyn-mcm":                          "Contact Port for AllJoyn multiplexed constrained messaging",
	"_alljoyn":                              "Alljoyn Name Service",
	"_odnsp":                                "OKI Data Network Setting Protocol",
	"_xybrid-rt":                            "XYBRID RT Server",
	"_visweather":                           "Valley Information Systems Weather station data",
	"_pumpkindb":                            "Event sourcing database engine with a built-in programming language",
	"_dsm-scm-target":                       "DSM/SCM Target Interface",
	"_nsesrvr":                              "Software Essentials Secure HTTP server",
	"_osm-appsrvr":                          "OSM Applet Server",
	"_osm-oev":                              "OSM Event Server",
	"_palace-1":                             "OnLive-1",
	"_palace-2":                             "OnLive-2",
	"_palace-3":                             "OnLive-3",
	"_palace-4":                             "Palace-4",
	"_palace-5":                             "Palace-5",
	"_palace-6":                             "Palace-6",
	"_distinct32":                           "Distinct32",
	"_distinct":                             "distinct",
	"_ndmp":                                 "Network Data Management Protocol",
	"_scp-config":                           "SCP Configuration",
	"_documentum":                           "EMC-Documentum Content Server Product",
	"_documentum-s":                         "EMC-Documentum Content Server Product IANA assigned this well-formed service name as a replacement for 'documentum_s'.",
	"_documentum_s":                         "EMC-Documentum Content Server Product",
	"_emcrmirccd":                           "EMC Replication Manager Client",
	"_emcrmird":                             "EMC Replication Manager Server",
	"_netapp-sync":                          "Sync replication protocol among different NetApp platforms",
	"_mvs-capacity":                         "MVS Capacity",
	"_octopus":                              "Octopus Multiplexer",
	"_swdtp-sv":                             "Systemwalker Desktop Patrol",
	"_rxapi":                                "ooRexx rxapi services",
	"_abb-hw":                               "Hardware configuration and maintenance",
	"_cefd-vmp":                             "Comtech EF-Data's Vipersat Management Protocol",
	"_zabbix-agent":                         "Zabbix Agent",
	"_zabbix-trapper":                       "Zabbix Trapper",
	"_qptlmd":                               "Quantapoint FLEXlm Licensing Service",
	"_amanda":                               "Amanda",
	"_famdc":                                "FAM Archive Server",
	"_itap-ddtp":                            "VERITAS ITAP DDTP",
	"_ezmeeting-2":                          "eZmeeting",
	"_ezproxy-2":                            "eZproxy",
	"_ezrelay":                              "eZrelay",
	"_swdtp":                                "Systemwalker Desktop Patrol",
	"_bctp-server":                          "VERITAS BCTP, server",
	"_nmea-0183":                            "NMEA-0183 Navigational Data",
	"_nmea-onenet":                          "NMEA OneNet multicast messaging",
	"_netiq-endpoint":                       "NetIQ Endpoint",
	"_netiq-qcheck":                         "NetIQ Qcheck",
	"_netiq-endpt":                          "NetIQ Endpoint",
	"_netiq-voipa":                          "NetIQ VoIP Assessor",
	"_iqrm":                                 "NetIQ IQCResource Managament Svc",
	"_cimple":                               "HotLink CIMple REST API",
	"_bmc-perf-sd":                          "BMC-PERFORM-SERVICE DAEMON",
	"_bmc-gms":                              "BMC General Manager Server",
	"_qb-db-server":                         "QB Database Server",
	"_snmptls":                              "SNMP-TLS",
	"_snmpdtls":                             "SNMP-DTLS",
	"_snmptls-trap":                         "SNMP-Trap-TLS",
	"_snmpdtls-trap":                        "SNMP-Trap-DTLS",
	"_trisoap":                              "Trigence AE Soap Service",
	"_rsms":                                 "Remote Server Management Service",
	"_rscs":                                 "Remote Server Control and Test Service",
	"_apollo-relay":                         "Apollo Relay Port",
	"_eapol-relay":                          "Relay of EAPOL frames",
	"_axis-wimp-port":                       "Axis WIMP Port",
	"_tile-ml":                              "Tile remote machine learning",
	"_blocks":                               "Blocks",
	"_bngsync":                              "BalanceNG session table synchronization protocol",
	"_cirrossp":                             "CirrosSP Workstation Communication",
	"_hip-nat-t":                            "HIP NAT-Traversal",
	"_mos-lower":                            "MOS Media Object Metadata Port",
	"_mos-upper":                            "MOS Running Order Port",
	"_mos-aux":                              "MOS Low Priority Port",
	"_mos-soap":                             "MOS SOAP Default Port",
	"_mos-soap-opt":                         "MOS SOAP Optional Port",
	"_serverdocs":                           "Apple Document Sharing Service",
	"_printopia":                            "Printopia Serve",
	"_gap":                                  "Gestor de Acaparamiento para Pocket PCs",
	"_lpdg":                                 "LUCIA Pareja Data Group",
	"_nbd":                                  "Network Block Device",
	"_nmc-disc":                             "Nuance Mobile Care Discovery",
	"_helix":                                "Helix Client/Server",
	"_bveapi":                               "BVEssentials HTTP API",
	"_octopustentacle":                      "Listen port used by the Octopus Deploy Tentacle deployment agent",
	"_rmiaux":                               "Auxiliary RMI Port",
	"_irisa":                                "IRISA",
	"_metasys":                              "Metasys",
	"_weave":                                "Nest device-to-device and device-to-service application protocol",
	"_origo-sync":                           "OrigoDB Server Sync Interface",
	"_netapp-icmgmt":                        "NetApp Intercluster Management",
	"_netapp-icdata":                        "NetApp Intercluster Data",
	"_sgi-lk":                               "SGI LK Licensing service",
	"_myq-termlink":                         "Hardware Terminals Discovery and Low-Level Communication Protocol",
	"_sgi-dmfmgr":                           "Data migration facility Manager (DMF) is a browser based interface to DMF",
	"_sgi-soap":                             "Data migration facility (DMF) SOAP is a web server protocol to support remote access to DMF",
	"_vce":                                  "Viral Computing Environment (VCE)",
	"_dicom":                                "DICOM",
	"_suncacao-snmp":                        "sun cacao snmp access point",
	"_suncacao-jmxmp":                       "sun cacao JMX-remoting access point",
	"_suncacao-rmi":                         "sun cacao rmi registry access point",
	"_suncacao-csa":                         "sun cacao command-streaming access point",
	"_suncacao-websvc":                      "sun cacao web service access point",
	"_snss":                                 "Surgical Notes Security Service Discovery (SNSS)",
	"_oemcacao-jmxmp":                       "OEM cacao JMX-remoting access point",
	"_t5-straton":                           "Straton Runtime Programing",
	"_oemcacao-rmi":                         "OEM cacao rmi registry access point",
	"_oemcacao-websvc":                      "OEM cacao web service access point",
	"_smsqp":                                "smsqp",
	"_dcsl-backup":                          "DCSL Network Backup Services",
	"_wifree":                               "WiFree Service",
	"_memcache":                             "Memory cache service",
	"_xcompute":                             "numerical systems messaging",
	"_imip":                                 "IMIP",
	"_imip-channels":                        "IMIP Channels Port",
	"_arena-server":                         "Arena Server Listen",
	"_atm-uhas":                             "ATM UHAS",
	"_hkp":                                  "OpenPGP HTTP Keyserver",
	"_lsdp":                                 "Lenbrook Service Discovery Protocol",
	"_asgcypresstcps":                       "ASG Cypress Secure Only",
	"_tempest-port":                         "Tempest Protocol Port",
	"_emc-xsw-dconfig":                      "EMC XtremSW distributed config",
	"_h323callsigalt":                       "H.323 Call Control Signalling Alternate",
	"_emc-xsw-dcache":                       "EMC XtremSW distributed cache",
	"_intrepid-ssl":                         "Intrepid SSL",
	"_lanschool":                            "LanSchool",
	"_lanschool-mpt":                        "Lanschool Multipoint",
	"_xoraya":                               "X2E Xoraya Multichannel protocol",
	"_x2e-disc":                             "X2E service discovery protocol",
	"_sysinfo-sp":                           "SysInfo Service Protocol",
	"_tibsd":                                "TiBS Service",
	"_wmereceiving":                         "WorldMailExpress",
	"_wmedistribution":                      "WorldMailExpress",
	"_wmereporting":                         "WorldMailExpress",
	"_entextxid":                            "IBM Enterprise Extender SNA XID Exchange",
	"_entextnetwk":                          "IBM Enterprise Extender SNA COS Network Priority",
	"_entexthigh":                           "IBM Enterprise Extender SNA COS High Priority",
	"_entextmed":                            "IBM Enterprise Extender SNA COS Medium Priority",
	"_entextlow":                            "IBM Enterprise Extender SNA COS Low Priority",
	"_dbisamserver1":                        "DBISAM Database Server - Regular",
	"_dbisamserver2":                        "DBISAM Database Server - Admin",
	"_accuracer":                            "Accuracer Database System Server",
	"_accuracer-dbms":                       "Accuracer Database System Admin",
	"_ghvpn":                                "Green Hills VPN",
	"_edbsrvr":                              "ElevateDB Server",
	"_vipera":                               "Vipera Messaging Service",
	"_vipera-ssl":                           "Vipera Messaging Service over SSL Communication",
	"_rets-ssl":                             "RETS over SSL",
	"_nupaper-ss":                           "NuPaper Session Service",
	"_cawas":                                "CA Web Access Service",
	"_hivep":                                "HiveP",
	"_linogridengine":                       "LinoGrid Engine",
	"_rads":                                 "Remote Administration Daemon (RAD) is a system service that offers secure, remote, programmatic access to Solaris system configuration and run-time state",
	"_warehouse-sss":                        "Warehouse Monitoring Syst SSS",
	"_warehouse":                            "Warehouse Monitoring Syst",
	"_italk":                                "Italk Chat System",
	"_carb-repl-ctrl":                       "Carbonite Server Replication Control",
	"_tsaf":                                 "tsaf port",
	"_netperf":                              "control port for the netperf benchmark",
	"_i-zipqd":                              "I-ZIPQD",
	"_bcslogc":                              "Black Crow Software application logging",
	"_rs-pias":                              "R&S Proxy Installation Assistant Service",
	"_emc-vcas-tcp":                         "EMC Virtual CAS Service",
	"_emc-vcas-udp":                         "EMV Virtual CAS Service Discovery",
	"_powwow-client":                        "PowWow Client",
	"_powwow-server":                        "PowWow Server",
	"_doip-data":                            "DoIP Data",
	"_doip-disc":                            "DoIP Discovery",
	"_bprd":                                 "BPRD Protocol (VERITAS NetBackup)",
	"_bpdbm":                                "BPDBM Protocol (VERITAS NetBackup)",
	"_bpjava-msvc":                          "BP Java MSVC Protocol",
	"_vnetd":                                "Veritas Network Utility",
	"_bpcd":                                 "VERITAS NetBackup",
	"_vopied":                               "VOPIED Protocol",
	"_nbdb":                                 "NetBackup Database",
	"_nomdb":                                "Veritas-nomdb",
	"_dsmcc-config":                         "DSMCC Config",
	"_dsmcc-session":                        "DSMCC Session Messages",
	"_dsmcc-passthru":                       "DSMCC Pass-Thru Messages",
	"_dsmcc-download":                       "DSMCC Download Protocol",
	"_dsmcc-ccp":                            "DSMCC Channel Change Protocol",
	"_bmdss":                                "Blackmagic Design Streaming Server",
	"_a-trust-rpc":                          "Certificate Management and Issuing",
	"_ucontrol":                             "Ultimate Control communication protocol",
	"_dta-systems":                          "D-TA SYSTEMS",
	"_medevolve":                            "MedEvolve Port Requester",
	"_scotty-ft":                            "SCOTTY High-Speed Filetransfer",
	"_sua":                                  "SUA",
	"_scotty-disc":                          "Discovery of a SCOTTY hardware codec board",
	"_sage-best-com1":                       "sage Best! Config Server 1",
	"_sage-best-com2":                       "sage Best! Config Server 2",
	"_vcs-app":                              "VCS Application",
	"_icpp":                                 "IceWall Cert Protocol",
	"_icpps":                                "IceWall Cert Protocol over TLS",
	"_gcm-app":                              "GCM Application",
	"_vrts-tdd":                             "Veritas Traffic Director",
	"_vcscmd":                               "Veritas Cluster Server Command Server",
	"_vad":                                  "Veritas Application Director",
	"_cps":                                  "Fencing Server",
	"_ca-web-update":                        "CA eTrust Web Update Service",
	"_xpra":                                 "xpra network protocol",
	"_hde-lcesrvr-1":                        "hde-lcesrvr-1",
	"_hde-lcesrvr-2":                        "hde-lcesrvr-2",
	"_hydap":                                "Hypack Data Aquisition",
	"_onep-tls":                             "Open Network Environment TLS",
	"_v2g-secc":                             "v2g Supply Equipment Communication Controller Discovery Protocol",
	"_xpilot":                               "XPilot Contact Port",
	"_3link":                                "3Link Negotiation",
	"_cisco-snat":                           "Cisco Stateful NAT",
	"_bex-xr":                               "Backup Express Restore Server",
	"_ptp":                                  "Picture Transfer Protocol",
	"_2ping":                                "2ping Bi-Directional Ping Service",
	"_programmar":                           "ProGrammar Enterprise",
	"_fmsas":                                "Administration Server Access",
	"_fmsascon":                             "Administration Server Connector",
	"_gsms":                                 "GoodSync Mediation Service",
	"_alfin":                                "Automation and Control by REGULACE.ORG",
	"_jwpc":                                 "Filemaker Java Web Publishing Core",
	"_jwpc-bin":                             "Filemaker Java Web Publishing Core Binary",
	"_sun-sea-port":                         "Solaris SEA Port",
	"_solaris-audit":                        "Solaris Audit - secure remote audit log",
	"_etb4j":                                "etb4j",
	"_pduncs":                               "Policy Distribute, Update Notification",
	"_pdefmns":                              "Policy definition and update management",
	"_netserialext1":                        "Network Serial Extension Ports One",
	"_netserialext2":                        "Network Serial Extension Ports Two",
	"_netserialext3":                        "Network Serial Extension Ports Three",
	"_netserialext4":                        "Network Serial Extension Ports Four",
	"_connected":                            "Connected Corp",
	"_rdgs":                                 "Reliable Datagram Sockets",
	"_xoms":                                 "X509 Objects Management Service",
	"_axon-tunnel":                          "Reliable multipath data transport for high latencies",
	"_vtp":                                  "Vidder Tunnel Protocol",
	"_cadsisvr":                             "This server provides callable services to mainframe External Security Managers from any TCP/IP platform",
	"_newbay-snc-mc":                        "Newbay Mobile Client Update Service",
	"_sgcip":                                "Simple Generic Client Interface Protocol",
	"_intel-rci-mp":                         "INTEL-RCI-MP",
	"_amt-soap-http":                        "Intel(R) AMT SOAP/HTTP",
	"_amt-soap-https":                       "Intel(R) AMT SOAP/HTTPS",
	"_amt-redir-tcp":                        "Intel(R) AMT Redirection/TCP",
	"_amt-redir-tls":                        "Intel(R) AMT Redirection/TLS",
	"_isode-dua":                            "",
	"_ncpu":                                 "Plan 9 cpu port",
	"_vestasdlp":                            "Vestas Data Layer Protocol",
	"_soundsvirtual":                        "Sounds Virtual",
	"_chipper":                              "Chipper",
	"_avtp":                                 "IEEE 1722 Transport Protocol for Time Sensitive Applications",
	"_avdecc":                               "IEEE 1722.1 AVB Discovery, Enumeration, Connection management, and Control",
	"_cpsp":                                 "Control Plane Synchronization Protocol (SPSP)",
	"_isa100-gci":                           "ISA100 GCI is a service utilizing a common interface between an ISA100 Wireless gateway and a client application",
	"_trdp-pd":                              "Train Realtime Data Protocol (TRDP) Process Data",
	"_trdp-md":                              "Train Realtime Data Protocol (TRDP) Message Data",
	"_integrius-stp":                        "Integrius Secure Tunnel Protocol",
	"_ssh-mgmt":                             "SSH Tectia Manager",
	"_db-lsp":                               "Dropbox LanSync Protocol",
	"_db-lsp-disc":                          "Dropbox LanSync Discovery",
	"_ailith":                               "Ailith management of routers",
	"_ea":                                   "Eclipse Aviation",
	"_zep":                                  "Encap. ZigBee Packets",
	"_zigbee-ip":                            "ZigBee IP Transport Service",
	"_zigbee-ips":                           "ZigBee IP Transport Secure Service",
	"_sw-orion":                             "SolarWinds Orion",
	"_biimenu":                              "Beckman Instruments, Inc.",
	"_radpdf":                               "RAD PDF Service",
	"_racf":                                 "z/OS Resource Access Control Facility",
	"_opsec-cvp":                            "OPSEC CVP",
	"_opsec-ufp":                            "OPSEC UFP",
	"_opsec-sam":                            "OPSEC SAM",
	"_opsec-lea":                            "OPSEC LEA",
	"_opsec-omi":                            "OPSEC OMI",
	"_ohsc":                                 "Occupational Health SC",
	"_opsec-ela":                            "OPSEC ELA",
	"_checkpoint-rtm":                       "Check Point RTM",
	"_iclid":                                "Checkpoint router monitoring",
	"_clusterxl":                            "Checkpoint router state backup",
	"_gv-pf":                                "GV NetConfig Service",
	"_ac-cluster":                           "AC Cluster",
	"_heythings":                            "HeyThings Device communicate service",
	"_rds-ib":                               "Reliable Datagram Service",
	"_rds-ip":                               "Reliable Datagram Service over IP",
	"_vdmmesh":                              "Manufacturing Execution Systems Mesh Communication",
	"_vdmmesh-disc":                         "Manufacturing Execution Systems Mesh Communication",
	"_ique":                                 "IQue Protocol",
	"_infotos":                              "Infotos",
	"_apc-necmp":                            "APCNECMP",
	"_igrid":                                "iGrid Server",
	"_scintilla":                            "Scintilla protocol for device services",
	"_j-link":                               "J-Link TCP/IP Protocol",
	"_opsec-uaa":                            "OPSEC UAA",
	"_ua-secureagent":                       "UserAuthority SecureAgent",
	"_cora":                                 "Client Connection Management and Data Exchange Service",
	"_cora-disc":                            "Discovery for Client Connection Management and Data Exchange Service",
	"_keysrvr":                              "Key Server for SASSAFRAS",
	"_keyshadow":                            "Key Shadow for SASSAFRAS",
	"_mtrgtrans":                            "mtrgtrans",
	"_hp-sco":                               "hp-sco",
	"_hp-sca":                               "hp-sca",
	"_hp-sessmon":                           "HP-SESSMON",
	"_fxuptp":                               "FXUPTP",
	"_sxuptp":                               "SXUPTP",
	"_jcp":                                  "JCP Client",
	"_mle":                                  "Mesh Link Establishment",
	"_faircom-db":                           "FairCom Database",
	"_iec-104-sec":                          "IEC 60870-5-104 process control - secure",
	"_dnp-sec":                              "Distributed Network Protocol - Secure",
	"_dnp":                                  "DNP",
	"_microsan":                             "MicroSAN",
	"_commtact-http":                        "Commtact HTTP",
	"_commtact-https":                       "Commtact HTTPS",
	"_openwebnet":                           "OpenWebNet protocol for electric network",
	"_ss-idi-disc":                          "Samsung Interdevice Interaction discovery",
	"_ss-idi":                               "Samsung Interdevice Interaction",
	"_opendeploy":                           "OpenDeploy Listener",
	"_nburn-id":                             "NetBurner ID Port IANA assigned this well-formed service name as a replacement for 'nburn_id'.",
	"_nburn_id":                             "NetBurner ID Port",
	"_tmophl7mts":                           "TMOP HL7 Message Transfer Service",
	"_mountd":                               "NFS mount protocol",
	"_nfsrdma":                              "Network File System (NFS) over RDMA",
	"_avesterra":                            "AvesTerra Hypergraph Transfer Protocol (HGTP)",
	"_tolfab":                               "TOLfab Data Change",
	"_ipdtp-port":                           "IPD Tunneling Port",
	"_ipulse-ics":                           "iPulse-ICS",
	"_emwavemsg":                            "emWave Message Service",
	"_track":                                "Track",
	"_crtech-nlm":                           "CRTech NLM",
	"_athand-mmp":                           "At Hand MMP",
	"_irtrans":                              "IRTrans Control",
	"_notezilla-lan":                        "Notezilla.Lan Server",
	"_trinket-agent":                        "Distributed artificial intelligence",
	"_cohesity-agent":                       "Cohesity backup agents",
	"_aigairserver":                         "Services for Air Server",
	"_rdm-tfs":                              "Raima RDM TFS",
	"_dfserver":                             "MineScape Design File Server",
	"_vofr-gateway":                         "VoFR Gateway",
	"_tvpm":                                 "TVNC Pro Multiplexing",
	"_sal":                                  "Safe AutoLogon",
	"_webphone":                             "webphone",
	"_netspeak-is":                          "NetSpeak Corp. Directory Services",
	"_netspeak-cs":                          "NetSpeak Corp. Connection Services",
	"_netspeak-acd":                         "NetSpeak Corp. Automatic Call Distribution",
	"_netspeak-cps":                         "NetSpeak Corp. Credit Processing System",
	"_snapenetio":                           "SNAPenetIO",
	"_optocontrol":                          "OptoControl",
	"_optohost002":                          "Opto Host Port 2",
	"_optohost003":                          "Opto Host Port 3",
	"_optohost004":                          "Opto Host Port 4",
	"_dcap":                                 "dCache Access Protocol",
	"_gsidcap":                              "GSI dCache Access Protocol",
	"_easyengine":                           "EasyEngine is CLI tool to manage WordPress Sites on Nginx server",
	"_wnn6":                                 "wnn6",
	"_cis":                                  "CompactIS Tunnel",
	"_showcockpit-net":                      "ShowCockpit Networking",
	"_shrewd-control":                       "Initium Labs Security and Automation Control",
	"_shrewd-stream":                        "Initium Labs Security and Automation Streaming",
	"_cis-secure":                           "CompactIS Secure Tunnel",
	"_wibukey":                              "WibuKey Standard WkLan",
	"_codemeter":                            "CodeMeter Standard",
	"_codemeter-cmwan":                      "TPC/IP requests of copy protection software to a server",
	"_caldsoft-backup":                      "CaldSoft Backup server file transfer",
	"_vocaltec-wconf":                       "Vocaltec Web Conference",
	"_vocaltec-phone":                       "Vocaltec Internet Phone",
	"_talikaserver":                         "Talika Main Server",
	"_aws-brf":                              "Telerate Information Platform LAN",
	"_brf-gw":                               "Telerate Information Platform WAN",
	"_inovaport1":                           "Inova LightLink Server Type 1",
	"_inovaport2":                           "Inova LightLink Server Type 2",
	"_inovaport3":                           "Inova LightLink Server Type 3",
	"_inovaport4":                           "Inova LightLink Server Type 4",
	"_inovaport5":                           "Inova LightLink Server Type 5",
	"_inovaport6":                           "Inova LightLink Server Type 6",
	"_gntp":                                 "Generic Notification Transport Protocol",
	"_s102":                                 "S102 application",
	"_5afe-dir":                             "5AFE SDN Directory",
	"_5afe-disc":                            "5AFE SDN Directory discovery",
	"_elxmgmt":                              "Emulex HBAnyware Remote Management",
	"_novar-dbase":                          "Novar Data",
	"_novar-alarm":                          "Novar Alarm",
	"_novar-global":                         "Novar Global",
	"_aequus":                               "Aequus Service",
	"_aequus-alt":                           "Aequus Service Mgmt",
	"_areaguard-neo":                        "AreaGuard Neo - WebServer",
	"_med-ltp":                              "med-ltp",
	"_med-fsp-rx":                           "med-fsp-rx",
	"_med-fsp-tx":                           "med-fsp-tx",
	"_med-supp":                             "med-supp",
	"_med-ovw":                              "med-ovw",
	"_med-ci":                               "med-ci",
	"_med-net-svc":                          "med-net-svc",
	"_filesphere":                           "fileSphere",
	"_vista-4gl":                            "Vista 4GL",
	"_ild":                                  "Isolv Local Directory",
	"_hid":                                  "Transport of Human Interface Device data streams",
	"_vrmg-ip":                              "Verimag mobile class protocol over TCP",
	"_intel-rci":                            "Intel RCI IANA assigned this well-formed service name as a replacement for 'intel_rci'.",
	"_intel_rci":                            "Intel RCI",
	"_tonidods":                             "Tonido Domain Server",
	"_binkp":                                "BINKP",
	"_bilobit":                              "bilobit Service",
	"_bilobit-update":                       "bilobit Service Update",
	"_sdtvwcam":                             "Service used by SmarDTV to communicate between a CAM and a second screen application",
	"_canditv":                              "Canditv Message Service",
	"_flashfiler":                           "FlashFiler",
	"_proactivate":                          "Turbopower Proactivate",
	"_tcc-http":                             "TCC User HTTP Service",
	"_cslg":                                 "Citrix StorageLink Gateway",
	"_assoc-disc":                           "Device Association Discovery",
	"_find":                                 "Find Identification of Network Devices",
	"_icl-twobase1":                         "icl-twobase1",
	"_icl-twobase2":                         "icl-twobase2",
	"_icl-twobase3":                         "icl-twobase3",
	"_icl-twobase4":                         "icl-twobase4",
	"_icl-twobase5":                         "icl-twobase5",
	"_icl-twobase6":                         "icl-twobase6",
	"_icl-twobase7":                         "icl-twobase7",
	"_icl-twobase8":                         "icl-twobase8",
	"_icl-twobase9":                         "icl-twobase9",
	"_icl-twobase10":                        "icl-twobase10",
	"_db2c-tls":                             "IBM Db2 Client Interface - Encrypted",
	"_rna":                                  "RNSAP User Adaptation for Iurh",
	"_sauterdongle":                         "Sauter Dongle",
	"_idtp":                                 "Identifier Tracing Protocol",
	"_vocaltec-hos":                         "Vocaltec Address Server",
	"_tasp-net":                             "TASP Network Comm",
	"_niobserver":                           "NIObserver",
	"_nilinkanalyst":                        "NILinkAnalyst",
	"_niprobe":                              "NIProbe",
	"_bf-game":                              "Bitfighter game server",
	"_bf-master":                            "Bitfighter master server",
	"_quake":                                "quake",
	"_scscp":                                "Symbolic Computation Software Composability Protocol",
	"_wnn6-ds":                              "wnn6-ds",
	"_cockroach":                            "CockroachDB",
	"_ezproxy":                              "eZproxy",
	"_ezmeeting":                            "eZmeeting",
	"_k3software-svr":                       "K3 Software-Server",
	"_k3software-cli":                       "K3 Software-Client",
	"_exoline-tcp":                          "EXOline-TCP",
	"_exoline-udp":                          "EXOline-UDP",
	"_exoconfig":                            "EXOconfig",
	"_exonet":                               "EXOnet",
	"_flex-lm":                              "FLEX LM (1-10)",
	"_flex-lmadmin":                         "A protocol for managing license services",
	"_chlenix":                              "Cloud hosting environment network",
	"_mongodb":                              "Mongo database system",
	"_imagepump":                            "ImagePump",
	"_jesmsjc":                              "Job controller service",
	"_kopek-httphead":                       "Kopek HTTP Head Port",
	"_ars-vista":                            "ARS VISTA Application",
	"_astrolink":                            "Astrolink Protocol",
	"_tw-auth-key":                          "TW Authentication/Key Distribution and",
	"_nxlmd":                                "NX License Manager",
	"_pqsp":                                 "PQ Service",
	"_gruber-cashreg":                       "Gruber cash registry protocol",
	"_thor-engine":                          "thor/server - ML engine",
	"_a27-ran-ran":                          "A27 cdma2000 RAN Management",
	"_voxelstorm":                           "VoxelStorm game server",
	"_siemensgsm":                           "Siemens GSM",
	"_bosswave":                             "Building operating system services wide area verified exchange",
	"_saltd-licensing":                      "Siemens Licensing Server",
	"_sgsap":                                "SGsAP in 3GPP",
	"_otmp":                                 "ObTools Message Protocol",
	"_sbcap":                                "SBcAP in 3GPP",
	"_iuhsctpassoc":                         "HNBAP and RUA Common Association",
	"_bingbang":                             "data exchange protocol for IEC61850 in wind power plants",
	"_ndmps":                                "Secure Network Data Management Protocol",
	"_pago-services1":                       "Pago Services 1",
	"_pago-services2":                       "Pago Services 2",
	"_amicon-fpsu-ra":                       "Amicon FPSU-IP Remote Administration",
	"_amicon-fpsu-s":                        "Amicon FPSU-IP VPN",
	"_rwp":                                  "Remote Window Protocol",
	"_kingdomsonline":                       "Kingdoms Online (CraigAvenue)",
	"_gs-realtime":                          "GroundStar RealTime System",
	"_samsung-disc":                         "Samsung Convergence Discovery Protocol",
	"_ovobs":                                "OpenView Service Desk Client",
	"_ka-sddp":                              "Kollective Agent Secure Distributed Delivery Protocol",
	"_ka-kdp":                               "Kollective Agent Kollective Delivery Protocol",
	"_autotrac-acp":                         "Autotrac ACP 245",
	"_yawn":                                 "YaWN - Yet Another Windows Notifier",
	"_eldim":                                "eldim is a secure file upload proxy",
	"_pace-licensed":                        "PACE license server",
	"_xqosd":                                "XQoS network monitor",
	"_tetrinet":                             "TetriNET Protocol",
	"_lm-mon":                               "lm mon",
	"_dsx-monitor":                          "DS Expert Monitor IANA assigned this well-formed service name as a replacement for 'dsx_monitor'.",
	"_dsx_monitor":                          "DS Expert Monitor",
	"_gamesmith-port":                       "GameSmith Port",
	"_iceedcp-tx":                           "Embedded Device Configuration Protocol TX IANA assigned this well-formed service name as a replacement for 'iceedcp_tx'.",
	"_iceedcp_tx":                           "Embedded Device Configuration Protocol TX",
	"_iceedcp-rx":                           "Embedded Device Configuration Protocol RX IANA assigned this well-formed service name as a replacement for 'iceedcp_rx'.",
	"_iceedcp_rx":                           "Embedded Device Configuration Protocol RX",
	"_iracinghelper":                        "iRacing helper service",
	"_t1distproc60":                         "T1 Distributed Processor",
	"_plex":                                 "Plex multimedia",
	"_apm-link":                             "Access Point Manager Link",
	"_sec-ntb-clnt":                         "SecureNotebook-CLNT",
	"_dmexpress":                            "DMExpress",
	"_filenet-powsrm":                       "FileNet BPM WS-ReliableMessaging Client",
	"_filenet-tms":                          "Filenet TMS",
	"_filenet-rpc":                          "Filenet RPC",
	"_filenet-nch":                          "Filenet NCH",
	"_filenet-rmi":                          "FileNET RMI",
	"_filenet-pa":                           "FileNET Process Analyzer",
	"_filenet-cm":                           "FileNET Component Manager",
	"_filenet-re":                           "FileNET Rules Engine",
	"_filenet-pch":                          "Performance Clearinghouse",
	"_filenet-peior":                        "FileNET BPM IOR",
	"_filenet-obrok":                        "FileNet BPM CORBA",
	"_mlsn":                                 "Multiple Listing Service Network",
	"_retp":                                 "Real Estate Transport Protocol",
	"_idmgratm":                             "Attachmate ID Manager",
	"_wg-endpt-comms":                       "WatchGuard Endpoint Communications",
	"_mysqlx":                               "MySQL Database Extended Interface",
	"_aurora-balaena":                       "Aurora (Balaena Ltd)",
	"_diamondport":                          "DiamondCentral Interface",
	"_dgi-serv":                             "Digital Gaslight Service",
	"_speedtrace":                           "SpeedTrace TraceAgent",
	"_speedtrace-disc":                      "SpeedTrace TraceAgent Discovery",
	"_traceroute":                           "traceroute use",
	"_mtrace":                               "IP Multicast Traceroute",
	"_snip-slave":                           "SNIP Slave",
	"_digilent-adept":                       "Adept IP protocol",
	"_turbonote-2":                          "TurboNote Relay Server Default Port",
	"_p-net-local":                          "P-Net on IP local",
	"_p-net-remote":                         "P-Net on IP remote",
	"_dhanalakshmi":                         "dhanalakshmi.org EDI Service",
	"_edi_service":                          "dhanalakshmi.org EDI Service",
	"_profinet-rt":                          "PROFInet RT Unicast",
	"_profinet-rtm":                         "PROFInet RT Multicast",
	"_profinet-cm":                          "PROFInet Context Manager",
	"_ethercat":                             "EtherCAT Port",
	"_heathview":                            "HeathView",
	"_rt-viewer":                            "ReadyTech Viewer",
	"_rt-sound":                             "ReadyTech Sound Server",
	"_rt-devicemapper":                      "ReadyTech DeviceMapper Server",
	"_rt-classmanager":                      "ReadyTech ClassManager",
	"_rt-labtracker":                        "ReadyTech LabTracker",
	"_rt-helper":                            "ReadyTech Helper Service",
	"_axio-disc":                            "Axiomatic discovery protocol",
	"_kitim":                                "KIT Messenger",
	"_altova-lm":                            "Altova License Management",
	"_altova-lm-disc":                       "Altova License Management Discovery",
	"_guttersnex":                           "Gutters Note Exchange",
	"_openstack-id":                         "OpenStack ID Service",
	"_allpeers":                             "AllPeers Network",
	"_wlcp":                                 "Wireless LAN Control plane Protocol (WLCP)",
	"_s1-control":                           "S1-Control Plane (3GPP)",
	"_x2-control":                           "X2-Control Plane (3GPP)",
	"_slmap":                                "SLm Interface Application Protocol",
	"_nq-ap":                                "Nq and Nq' Application Protocol",
	"_m2ap":                                 "M2 Application Part",
	"_m3ap":                                 "M3 Application Part",
	"_xw-control":                           "Xw-Control Plane (3GPP)",
	"_febooti-aw":                           "Febooti Automation Workshop",
	"_observium-agent":                      "Observium statistics collection agent",
	"_mapx":                                 "MapX communication",
	"_kastenxpipe":                          "KastenX Pipe",
	"_3gpp-w1ap":                            "W1 signalling transport",
	"_neckar":                               "science + computing's Venus Administration Port",
	"_gdrive-sync":                          "Google Drive Sync",
	"_eftp":                                 "Epipole File Transfer Protocol",
	"_unisys-eportal":                       "Unisys ClearPath ePortal",
	"_ivs-database":                         "InfoVista Server Database",
	"_ivs-insertion":                        "InfoVista Server Insertion",
	"_cresco-control":                       "Cresco Controller",
	"_crescoctrl-disc":                      "Cresco Controller Discovery",
	"_galaxy7-data":                         "Galaxy7 Data Tunnel",
	"_fairview":                             "Fairview Message Service",
	"_agpolicy":                             "AppGate Policy Server",
	"_ng-control":                           "NG Control Plane (3GPP)",
	"_xn-control":                           "Xn Control Plane (3GPP)",
	"_e1-interface":                         "E1 signalling transport (3GPP)",
	"_f1-control":                           "F1 Control Plane (3GPP)",
	"_psqlmws":                              "Premier SQL Middleware Server",
	"_sruth":                                "Sruth is a service for the distribution of routinely-      generated but arbitrary files based on a publish/subscribe      distribution model and implemented using a peer-to-peer transport      mechanism",
	"_secrmmsafecopya":                      "Security approval process for use of the secRMM SafeCopy program",
	"_vroa":                                 "Children's hearing test/Telemedicine",
	"_turbonote-1":                          "TurboNote Default Port",
	"_safetynetp":                           "SafetyNET p",
	"_k-patentssensor":                      "K-PatentsSensorInformation",
	"_sptx":                                 "Simplify Printing TX",
	"_cscp":                                 "CSCP",
	"_csccredir":                            "CSCCREDIR",
	"_csccfirewall":                         "CSCCFIREWALL",
	"_ortec-disc":                           "ORTEC Service Discovery",
	"_fs-qos":                               "Foursticks QoS Protocol",
	"_tentacle":                             "Tentacle Server",
	"_z-wave-s":                             "Z-Wave Protocol over SSL/TLS",
	"_crestron-cip":                         "Crestron Control Port",
	"_crestron-ctp":                         "Crestron Terminal Port",
	"_crestron-cips":                        "Crestron Secure Control Port",
	"_crestron-ctps":                        "Crestron Secure Terminal Port",
	"_candp":                                "Computer Associates network discovery protocol",
	"_candrp":                               "CA discovery response",
	"_caerpc":                               "CA eTrust RPC",
	"_curiosity":                            "API endpoint for search application",
	"_recvr-rc":                             "Receiver Remote Control",
	"_recvr-rc-disc":                        "Receiver Remote Control Discovery",
	"_reachout":                             "REACHOUT",
	"_ndm-agent-port":                       "NDM-AGENT-PORT",
	"_ip-provision":                         "IP-PROVISION",
	"_noit-transport":                       "Reconnoiter Agent Data Transport",
	"_shaperai":                             "Shaper Automation Server Management",
	"_shaperai-disc":                        "Shaper Automation Server Management Discovery",
	"_hmip-routing":                         "HmIP LAN Routing",
	"_eq3-update":                           "EQ3 firmware update",
	"_eq3-config":                           "EQ3 discovery and configuration",
	"_ew-mgmt":                              "Cisco EnergyWise Management",
	"_ew-disc-cmd":                          "Cisco EnergyWise Discovery and Command Flooding",
	"_ciscocsdb":                            "Cisco NetMgmt DB Ports",
	"_z-wave-tunnel":                        "Z-Wave Secure Tunnel",
	"_pmcd":                                 "PCP server (pmcd)",
	"_pmcdproxy":                            "PCP server (pmcd) proxy",
	"_pmwebapi":                             "HTTP binding for Performance Co-Pilot client API",
	"_cognex-dataman":                       "Cognex DataMan Management Protocol",
	"_acronis-backup":                       "Acronis Backup Gateway service port",
	"_domiq":                                "DOMIQ Building Automation",
	"_rbr-debug":                            "REALbasic Remote Debug",
	"_asihpi":                               "AudioScience HPI",
	"_ethernet-ip-2":                        "EtherNet/IP messaging IANA assigned this well-formed service name as a replacement for 'EtherNet/IP-2'.",
	"_ethernet/ip-2":                        "EtherNet/IP messaging",
	"_m3da":                                 "M3DA is used for efficient machine-to-machine communications",
	"_m3da-disc":                            "M3DA Discovery is used for efficient machine-to-machine communications",
	"_asmp":                                 "Nuance AutoStore Status Monitoring Protocol (data transfer)",
	"_asmp-mon":                             "Nuance AutoStore Status Monitoring Protocol (device monitoring)",
	"_asmps":                                "Nuance AutoStore Status Monitoring Protocol (secure data transfer)",
	"_rs-status":                            "Redspeed Status Monitor",
	"_synctest":                             "Remote application control protocol",
	"_invision-ag":                          "InVision AG",
	"_cloudcheck":                           "ASSIA CloudCheck WiFi Management System",
	"_cloudcheck-ping":                      "ASSIA CloudCheck WiFi Management keepalive",
	"_eba":                                  "EBA PRISE",
	"_dai-shell":                            "Server for the DAI family of client-server products",
	"_qdb2service":                          "Qpuncture Data Access Service",
	"_ssr-servermgr":                        "SSRServerMgr",
	"_inedo":                                "Listen port used for Inedo agent communication",
	"_spremotetablet":                       "Connection between a desktop computer or server and a signature tablet to capture handwritten signatures",
	"_mediabox":                             "MediaBox Server",
	"_mbus":                                 "Message Bus",
	"_winrm":                                "Windows Remote Management Service",
	"_jvl-mactalk":                          "Configuration of motors connected to Industrial Ethernet",
	"_dbbrowse":                             "Databeam Corporation",
	"_directplaysrvr":                       "Direct Play Server",
	"_ap":                                   "ALC Protocol",
	"_bacnet":                               "Building Automation and Control Networks",
	"_presonus-ucnet":                       "PreSonus Universal Control Network Protocol",
	"_nimcontroller":                        "Nimbus Controller",
	"_nimspooler":                           "Nimbus Spooler",
	"_nimhub":                               "Nimbus Hub",
	"_nimgtw":                               "Nimbus Gateway",
	"_nimbusdb":                             "NimbusDB Connector",
	"_nimbusdbctrl":                         "NimbusDB Control",
	"_juka":                                 "Juliar Programming Language Protocol",
	"_3gpp-cbsp":                            "3GPP Cell Broadcast Service Protocol",
	"_weandsf":                              "WeFi Access Network Discovery and Selection Function",
	"_isnetserv":                            "Image Systems Network Services",
	"_blp5":                                 "Bloomberg locator",
	"_com-bardac-dw":                        "com-bardac-dw",
	"_iqobject":                             "iqobject",
	"_robotraconteur":                       "Robot Raconteur transport",
	"_matahari":                             "Matahari Broker",
	"_nusrp":                                "Nuance Unity Service Request Protocol",
	"_nusdp-disc":                           "Nuance Unity Service Discovery Protocol",
	"_inspider":                             "InSpider System",
	"_argus":                                "ARGUS Protocol",
	"_arp":                                  "Address Resolution Protocol",
	"_bbn-rcc-mon":                          "BBN RCC Monitoring",
	"_bootp":                                "Bootstrap Protocol",
	"_br-sat-mon":                           "Backroom SATNET Monitoring",
	"_cftp":                                 "CFTP",
	"_chaos":                                "CHAOS Protocol",
	"_clock":                                "DCNET Time Server Protocol",
	"_cmot":                                 "Common Mgmnt Info Ser and Prot over TCP/IP",
	"_cookie-jar":                           "Authentication Scheme",
	"_dcn-meas":                             "DCN Measurement Subsystems Protocol",
	"_dgp":                                  "Dissimilar Gateway Protocol",
	"_dmf-mail":                             "Digest Message Format for Mail",
	"_egp":                                  "Exterior Gateway Protocol",
	"_ehf-mail":                             "Encoding Header Field for Mail",
	"_emcon":                                "Emission Control Protocol",
	"_fconfig":                              "Fujitsu Config Protocol",
	"_ggp":                                  "Gateway Gateway Protocol",
	"_hmp":                                  "Host Monitoring Protocol",
	"_host2-ns":                             "Host2 Name Server",
	"_icmp":                                 "Internet Control Message Protocol",
	"_igmp":                                 "Internet Group Management Protocol",
	"_igp":                                  "Interior Gateway Protocol",
	"_imap2":                                "Interim Mail Access Protocol version 2",
	"_ip":                                   "Internet Protocol",
	"_ipcu":                                 "Internet Packet Core Utility",
	"_ippc":                                 "Internet Pluribus Packet Core",
	"_ip-arc":                               "Internet Protocol on ARCNET",
	"_ip-arpa":                              "Internet Protocol on ARPANET",
	"_ip-cmprs":                             "Compressing TCP/IP Headers",
	"_ip-dc":                                "Internet Protocol on DC Networks",
	"_ip-dvmrp":                             "Distance Vector Multicast Routing Protocol",
	"_ip-e":                                 "Internet Protocol on Ethernet Networks",
	"_ip-ee":                                "Internet Protocol on Exp. Ethernet Nets",
	"_ip-fddi":                              "Transmission of IP over FDDI",
	"_ip-hc":                                "Internet Protocol on Hyperchannnel",
	"_ip-ieee":                              "Internet Protocol on IEEE 802",
	"_ip-ipx":                               "Transmission of 802.2 over IPX Networks",
	"_ip-mtu":                               "IP MTU Discovery Options",
	"_ip-netbios":                           "Internet Protocol over NetBIOS Networks",
	"_ip-slip":                              "Transmission of IP over Serial Lines",
	"_ip-wb":                                "Internet Protocol on Wideband Network",
	"_ip-x25":                               "Internet Protocol on X.25 Networks",
	"_irtp":                                 "Internet Reliable Transaction Protocol",
	"_iso-tp4":                              "ISO Transport Protocol Class 4",
	"_larp":                                 "Locus Address Resoultion Protocol",
	"_leaf-1":                               "Leaf-1 Protocol",
	"_leaf-2":                               "Leaf-2 Protocol",
	"_loc-srv":                              "Location Service",
	"_mail":                                 "Format of Electronic Mail Messages",
	"_merit-inp":                            "MERIT Internodal Protocol",
	"_mib":                                  "Management Information Base",
	"_mihcs":                                "MIH Command Services",
	"_mihes":                                "MIH Event Services",
	"_mihis":                                "MIH Information Services",
	"_mfe-nsp":                              "MFE Network Services Protocol",
	"_mit-subnet":                           "MIT Subnet Support",
	"_mux":                                  "Multiplexing Protocol",
	"_netblt":                               "Bulk Data Transfer Protocol",
	"_neted":                                "Network Standard Text Editor",
	"_netrjs":                               "Remote Job Service",
	"_nfile":                                "A File Access Protocol",
	"_nvp-ii":                               "Network Voice Protocol",
	"_ospf":                                 "Open Shortest Path First Interior GW Protocol",
	"_pcmail":                               "Pcmail Transport Protocol",
	"_ppp":                                  "Point-to-Point Protocol",
	"_prm":                                  "Packet Radio Measurement",
	"_pup":                                  "PUP Protocol",
	"_quote":                                "Quote of the Day Protocol",
	"_rarp":                                 "A Reverse Address Resolution Protocol",
	"_ratp":                                 "Reliable Asynchronous Transfer Protocol",
	"_rdp":                                  "Reliable Data Protocol",
	"_rip":                                  "Routing Information Protocol",
	"_rvd":                                  "Remote Virtual Disk Protocol",
	"_sat-expak":                            "Satnet and Backroom EXPAK",
	"_sat-mon":                              "SATNET Monitoring",
	"_smi":                                  "Structure of Management Information",
	"_stp":                                  "Stream Protocol",
	"_sun-rpc":                              "SUN Remote Procedure Call",
	"_tcp":                                  "Transmission Control Protocol",
	"_tcp-aco":                              "TCP Alternate Checksum Option",
	"_thinwire":                             "Thinwire Protocol",
	"_tp-tcp":                               "ISO Transport Service on top of the TCP",
	"_trunk-1":                              "Trunk-1 Protocol",
	"_trunk-2":                              "Trunk-2 Protocol",
	"_ucl":                                  "University College London Protocol",
	"_udp":                                  "User Datagram Protocol",
	"_users":                                "Active Users Protocol",
	"_via-ftp":                              "VIA Systems-File Transfer Protocol",
	"_visa":                                 "VISA Protocol",
	"_vmtp":                                 "Versatile Message Transaction Protocol",
	"_wb-expak":                             "Wideband EXPAK",
	"_wb-mon":                               "Wideband Monitoring",
	"_xnet":                                 "Cross Net Debugger",
	"_xns-idp":                              "Xerox NS IDP",
	"_1password":                            "1Password Password Manager data sharing and synchronization protocol",
	"_7ksonar":                              "Teledyne Marine 7k Sonar Protocol",
	"_a-d-sync":                             "Altos Design Synchronization protocol",
	"_abi-instrument":                       "Applied Biosystems Universal Instrument Framework",
	"_accessdata-f2d":                       "FTK2 Database Discovery Service",
	"_accessdata-f2w":                       "FTK2 Backend Processing Agent Service",
	"_accessone":                            "Strix Systems 5S/AccessOne protocol",
	"_accountedge":                          "MYOB AccountEdge",
	"_acrobatsrv":                           "Adobe Acrobat",
	"_acs-ctl-ds":                           "Access Control Device",
	"_acs-ctl-gw":                           "Access Control Gateway",
	"_acsp-server":                          "AXIS Camera Station Pro Server",
	"_actionitems":                          "ActionItems",
	"_activeraid":                           "Active Storage Proprietary Device Management Protocol",
	"_activeraid-ssl":                       "Encrypted transport of Active Storage Proprietary Device Management Protocol",
	"_adamhall":                             "Adam Hall network control and monitoring",
	"_addressbook":                          "Address-O-Matic",
	"_addressbooksrv":                       "Address Book Server used for contacts and calendar synchronisation",
	"_adnodes":                              "difusi Cloud based plug & play network      synchronization protocol, content pool database discovery, and      cloudOS SAaS discovery protocol.",
	"_adobe-shadow":                         "Adobe Shadow Server",
	"_adobe-vc":                             "Adobe Version Cue",
	"_adisk":                                "Automatic Disk Discovery",
	"_adpro-setup":                          "ADPRO Security Device Setup",
	"_aecoretech":                           "Apple Application Engineering Services",
	"_aeroflex":                             "Aeroflex instrumentation and software",
	"_aerohive-proxy":                       "Aerohive Proxy Configuration Service",
	"_affinity-docs0":                       "Affinity Designer document sharing",
	"_affinity-docs1":                       "Affinity Photo document sharing",
	"_affinity-docs2":                       "Affinity Publisher document sharing",
	"_affinity-cntent":                      "Affinity content sharing",
	"_airdrop":                              "Airdrop",
	"_airmate":                              "Airmate interworking protocol",
	"_airplay":                              "Protocol for streaming of audio/video content",
	"_airport":                              "AirPort Base Station",
	"_airpreview":                           "Coda AirPreview",
	"_airprojector":                         "AirProjector",
	"_airsharing":                           "Air Sharing",
	"_airsharingpro":                        "Air Sharing Pro",
	"_alazartech-atn":                       "Alazar Technologies ATN Communication Protocol",
	"_aloe-gwp":                             "Aloe Gateway Protocol",
	"_aloe-pp":                              "Aloe Pairing Protocol",
	"_alpacadiscovery":                      "ASCOM Alpaca Device Discovery",
	"_amazon-expiscor":                      "Device discovery for Amazon",
	"_amba-cam":                             "Ambarella Cameras",
	"_amiphd-p2p":                           "P2PTapWar Sample Application from 'iPhone SDK Development' Book",
	"_ams-htm":                              "Proprietary protocol for Accu-Med HTM",
	"_animolmd":                             "Animo License Manager",
	"_animobserver":                         "Animo Batch Server",
	"_anquetsync":                           "Anquet map synchronization between desktop and handheld devices",
	"_antrmai":                              "ANT Galio web services",
	"_anyremote":                            "remote control of Linux PCs from Android and J2ME",
	"_appelezvous":                          "Appelezvous",
	"_apple-ausend":                         "Apple Audio Units",
	"_apple-mobdev":                         "Apple Mobile Device Protocol",
	"_apple-midi":                           "Apple MIDI",
	"_applerdbg":                            "Apple Remote Debug Services (OpenGL Profiler)",
	"_appletv":                              "Apple TV",
	"_appletv-itunes":                       "Apple TV discovery of iTunes",
	"_appletv-pair":                         "Apple TV Pairing",
	"_aquamon":                              "AquaMon",
	"_arcnet":                               "Arcturus Networks Inc. Hardware Services",
	"_arn":                                  "Active Registry Network for distribution of values and streams",
	"_aroundsound":                          "AroundSound's information sharing protocol",
	"_asam-cmp":                             "ASAM Capture Module Protocol",
	"_aseba":                                "protocol for an event-based architecture for distributed control of mobile robots",
	"_astnotify":                            "Asterisk Caller-ID Notification Service",
	"_astralite":                            "Astralite",
	"_async":                                "address-o-sync",
	"_atnet":                                "AT protocol over IP",
	"_atlassianapp":                         "Atlassian Application (JIRA, Confluence, Fisheye, Crucible, Crowd, Bamboo) discovery service",
	"_attero-ad":                            "Attero Tech Audio Device",
	"_audirvana-ap":                         "Audirvana Remote Access Protocol",
	"_autosendimages":                       "automatic sending Image data protocol",
	"_autotargets-ap":                       "Access Point for AutoTargets system",
	"_av":                                   "Allen Vanguard Hardware Service",
	"_av-chat-ring-01":                      "TCP SpyChat Stream Message Exchange",
	"_avatars":                              "Libravatar federated avatar hosting service.",
	"_avatars-sec":                          "Libravatar federated avatar hosting service.",
	"_axis-nvr":                             "Axis Network Video Recorders",
	"_axis-video":                           "Axis Video Cameras",
	"_autotunnel":                           "IPSEC VPN tunnel over UDP",
	"_b3d-convince":                         "3M Unitek Digital Orthodontic System",
	"_babyphone":                            "BabyPhone",
	"_bandhelper-rc":                        "Remote Control for BandHelper app",
	"_bandhelper-ss":                        "Screen sharing for BandHelper app",
	"_barroomcomedy":                        "Peer to peer file sharing for a media player application",
	"_bcloud-server":                        "Buddycloud Server Delegation",
	"_bdsk":                                 "BibDesk Sharing",
	"_beacon":                               "Beacon Remote Service",
	"_beamer":                               "Beamer Data Sharing Protocol",
	"_beatpack":                             "BeatPack Synchronization Server for BeatMaker",
	"_beatsdirect":                          "Beats Direct allows for the discovery and control of devices",
	"_beep":                                 "Xgrid Technology Preview",
	"_behnke-cc":                            "Behnke doorphones / emergency phones",
	"_behnke-station":                       "Behnke audio / video intercom systems",
	"_behnke-video":                         "Behnke doorphones / video intercoms",
	"_bender":                               "Bender Communication Protocol",
	"_beyondidentity":                       "Beyond Identity Platform Authenticator S",
	"_bfagent":                              "BuildForge Agent",
	"_bhipc":                                "Becker & Hickl Inter Process Communication",
	"_bidib":                                "Model Railway Control via netBiDiB",
	"_bigbangchess":                         "Big Bang Chess",
	"_bigbangmancala":                       "Big Bang Mancala",
	"_biosonics":                            "BioSonics Echosounders",
	"_bitflit":                              "Data transfer service",
	"_bittorrent":                           "BitTorrent Zeroconf Peer Discovery Protocol",
	"_blackbook":                            "Little Black Book Information Exchange Protocol",
	"_bluevertise":                          "BlueVertise Network Protocol (BNP)",
	"_boardplus":                            "board plus application transfer protocol",
	"_booked-sync":                          "Booked communication protocol - Sharing And Sync Service",
	"_bookworm":                             "Bookworm Client Discovery",
	"_bootstrap":                            "Bootstrap service discovery",
	"_boundaryscan":                         "Proprietary",
	"_bousg":                                "Bag Of Unusual Strategy Games",
	"_boutfitness":                          "Bout Fitness Synchronization Service",
	"_boxraysrvr":                           "Boxray Devices Host Server",
	"_bq-cromo":                             "bq Cromo protocol",
	"_breas":                                "Breas",
	"_bri":                                  "RFID Reader Basic Reader Interface",
	"_bridgeprotocol":                       "JSON RPC Bridge Protocol",
	"_brski-proxy":                          "The Bootstrapping Remote Secure Key Infrastructure Proxy",
	"_brski-reg-cmp":                        "Bootstrapping Remote Secure Key Infrastructure registrar with CMP      capabilities according to the Lightweight CMP Profile (LCMPP,      [RFC9483])",
	"_brski-registrar":                      "The Bootstrapping Remote Secure Key Infrastructure Registrar",
	"_bsqdea":                               "Backup Simplicity",
	"_btp":                                  "Beats Transfer Protocol allows for the discovery and control of devices",
	"_buddycloud-api":                       "buddycloud API",
	"_buzzer":                               "Service for opening electric doors",
	"_caldav":                               "Calendaring Extensions to WebDAV (CalDAV) - non-TLS",
	"_caldavs":                              "Calendaring Extensions to WebDAV (CalDAV) - over TLS",
	"_caltalk":                              "CalTalk",
	"_canon-chmp":                           "Canon HTTP Management Protocol",
	"_carddav":                              "vCard Extensions to WebDAV (CardDAV) - non-TLS",
	"_carddavs":                             "vCard Extensions to WebDAV (CardDAV) - over TLS",
	"_cardsend":                             "Card Send Protocol",
	"_carousel":                             "Carousel Player Protocol",
	"_cctv":                                 "IP and Closed-Circuit Television for Securitiy applications",
	"_cerebra":                              "Control the Cerebra Aquarium Controller",
	"_certificates":                         "Server for S/MIME and PGP certificates",
	"_cheat":                                "The Cheat",
	"_chess":                                "Project Gridlock",
	"_chfts":                                "Fluid Theme Server",
	"_chili":                                "The CHILI Radiology System",
	"_ciao":                                 "Ciao Arduino Protocol",
	"_cip4discovery":                        "Discovery of JDF (CIP4 Job Definition Format) enabled devices",
	"_clipboard":                            "Clipboard Sharing",
	"_clique":                               "Clique Link-Local Multicast Chat Room",
	"_clscts":                               "Oracle CLS Cluster Topology Service",
	"_collabio":                             "Collabio",
	"_collection":                           "Published Collection Object",
	"_commfort":                             "A client-server chat for LAN or Internet with video chat support",
	"_com-ocs-es-mcc":                       "ElectraStar media centre control protocol",
	"_conecube":                             "DNS SRV service for smarthome server",
	"_contactserver":                        "Now Contact",
	"_controllerplus":                       "game controller forwarding protocol",
	"_convert":                              "0-RTT TCP Convert Protocol",
	"_coolanetaudio":                        "Coolatoola Network Audio",
	"_core-rd":                              "Resource Directory accessed using CoAP over TCP",
	"_core-rd-tls":                          "Resource Directory accessed using CoAP over TLS",
	"_core-rd-dtls":                         "Resource Directory accessed using CoAP over DTLS",
	"_corroboree":                           "Corroboree Server",
	"_cosir":                                "Computer Op System Information Report",
	"_coviot":                               "Service for coviot branded devices",
	"_cpnotebook2":                          "NoteBook 2",
	"_csi-mmws":                             "Canfield Scientific Inc - Mirror Mobile Web Services",
	"_cw-codetap":                           "CodeWarrior HTI Xscale PowerTAP",
	"_cw-dpitap":                            "CodeWarrior HTI DPI PowerTAP",
	"_cw-oncetap":                           "CodeWarrior HTI OnCE PowerTAP",
	"_cw-powertap":                          "CodeWarrior HTI COP PowerTAP",
	"_cytv":                                 "CyTV - Network streaming for Elgato EyeTV",
	"_dacp":                                 "Digital Audio Control Protocol (iTunes)",
	"_dancepartner":                         "Dance partner application for iPhone",
	"_darkhorsetimer":                       "Timer LAN service",
	"_dataturbine":                          "Open Source DataTurbine Streaming Data Middleware",
	"_dbaudio":                              "d&b audiotechnik remote network",
	"_dccp-ping":                            "ping/traceroute using DCCP",
	"_dell-soo-ds":                          "Spotlight on Oracle Diagnostic Server",
	"_dell-soss-ds-w":                       "Spotlight on SQL Server Diagnostic Server HTTP",
	"_dell-ssms-ds":                         "Spotlight SSMS Plugin Diagnostic Server",
	"_demoncamremote":                       "Peer-to-peer real-time video streaming",
	"_device-info":                          "Device Info",
	"_devonsync":                            "DEVONthink synchronization protocol",
	"_dhanda-g":                             "DHANDAg is going for a site",
	"_dictation":                            "Use of a dictation service by a hand-held device",
	"_difi":                                 "EyeHome",
	"_disconnect":                           "DisConnect Peer to Peer Game Protocol",
	"_displaysrc":                           "Wi-Fi Alliance Display Source service",
	"_dist-opencl":                          "Distributed OpenCL discovery protocol",
	"_ditrios":                              "Ditrios SOA Framework Protocol",
	"_divelogsync":                          "Dive Log Data Sharing and Synchronization Protocol",
	"_dltimesync":                           "Local Area Dynamic Time Synchronisation Protocol",
	"_dns-llq-tls":                          "DNS Long-Lived Queries over TLS",
	"_dns-push-tls":                         "DNS Push Notification Service Type",
	"_dns-query-tls":                        "DNS queries to the authoritative server over TLS",
	"_dns-sd":                               "DNS Service Discovery",
	"_dns-update":                           "DNS Dynamic Update Service",
	"_dns-update-tls":                       "DNS Dynamic Update Service over TLS",
	"_dnssd-srp":                            "DNS-Based Service Discovery",
	"_dnssd-srp-tls":                        "DNS-Based Service Discovery (TLS)",
	"_dop":                                  "Roar (Death of Productivity)",
	"_dots-call-home":                       "DOTS Signal Channel Call Home Protocol.      The service name is used to construct the SRV service names '_dots-call-home._udp'      and '_dots-call-home._tcp' for discovering Call Home DOTS clients used to establish      DOTS signal channel call home.",
	"_dots-data":                            "DOTS Data Channel Protocol.      The service name is used to construct the SRV service name '_dots-data._tcp' for      discovering DOTS servers used to establish DOTS data channel.",
	"_dropcopy":                             "DropCopy",
	"_dsgsync":                              "Datacolor SpyderGallery Desktop Sync Protocol",
	"_dsl-sync":                             "Data Synchronization Protocol for Discovery Software products",
	"_dtrmtdesktop":                         "Desktop Transporter Remote Desktop Protocol",
	"_duckrace":                             "A communication protocol that allows a school teacher to set work activities to students over a LAN.",
	"_dxtgsync":                             "Documents To Go Desktop Sync Protocol",
	"_ea-dttx-poker":                        "Protocol for EA Downtown Texas Hold 'em",
	"_earphoria":                            "Earphoria",
	"_easyspndlg-sync":                      "Sync service for the Easy Spend Log app",
	"_eb-amuzi":                             "Amuzi peer-to-peer session synchronization protocol",
	"_eb-sync":                              "Easy Books App data sync helper for Mac OS X and iOS",
	"_ebms":                                 "ebXML Messaging",
	"_ecms":                                 "Northrup Grumman/Mission Systems/ESL Data Flow Protocol",
	"_ebreg":                                "ebXML Registry",
	"_ecbyesfsgksc":                         "Net Monitor Anti-Piracy Service",
	"_edcp":                                 "LaCie Ethernet Disk Configuration Protocol",
	"_edge1":                                "Edge1 Base Station",
	"_edsservice":                           "Provides resolution of EDS services available on a given network",
	"_eeg":                                  "EEG System Discovery across local and wide area networks",
	"_efkon-elite":                          "EFKON Lightweight Interface to Traffic Events",
	"_egistix":                              "Egistix Auto-Discovery",
	"_eheap":                                "Interactive Room Software Infrastructure (Event Sharing)",
	"_embrace":                              "DataEnvoy",
	"_enphase-envoy":                        "Enphase Energy Envoy",
	"_ep":                                   "Endpoint Protocol (EP) for use in Home Automation systems",
	"_esp":                                  "Extensis Server Protocol",
	"_est":                                  "Enrollment Over Secure Transport",
	"_est-coaps":                            "EST over secure CoAP (EST-coaps)",
	"_eucalyptus":                           "Eucalyptus Discovery",
	"_eventserver":                          "Now Up-to-Date",
	"_evp":                                  "EvP - Generic EVENT protocol",
	"_evs-notif":                            "EVS Notification Center Protocol",
	"_ewalletsync":                          "Synchronization Protocol for Ilium Software's eWallet",
	"_ewelink":                              "eWeLink devices supporting LAN Control",
	"_example":                              "Example Service Type",
	"_exb":                                  "Exbiblio Cascading Service Protocol",
	"_extensissn":                           "Extensis Serial Number",
	"_eyetvsn":                              "EyeTV Sharing",
	"_facespan":                             "FaceSpan",
	"_faxstfx":                              "FAXstf",
	"_feed-sharing":                         "NetNewsWire 2.0",
	"_feldwesen":                            "proprietary",
	"_firetask":                             "Firetask task sharing and synchronization protocol",
	"_fish":                                 "Fish",
	"_fisk":                                 "Fiscalization service of Click.al",
	"_fix":                                  "Financial Information Exchange (FIX) Protocol",
	"_fjork":                                "Fjork",
	"_fl-purr":                              "FilmLight Cluster Power Control Service",
	"_flightdmp":                            "Flight Data Monitoring Protocol",
	"_flir-ircam":                           "FLIR Infrared Camera",
	"_fmserver-admin":                       "FileMaker Server Administration Communication Service",
	"_fontagentnode":                        "FontAgent Pro",
	"_foxtrot-serv":                         "FoxTrot Search Server Discovery Service",
	"_foxtrot-start":                        "FoxTrot Professional Search Discovery Service",
	"_frameforge-lic":                       "FrameForge License",
	"_freehand":                             "FreeHand MusicPad Pro Interface Protocol",
	"_frog":                                 "Frog Navigation Systems",
	"_ftpcroco":                             "Crocodile FTP Server",
	"_fv-cert":                              "Fairview Certificate",
	"_fv-key":                               "Fairview Key",
	"_fv-time":                              "Fairview Time/Date",
	"_g2metric-lynx":                        "Used for the Lynx System",
	"_garagepad":                            "Entrackment Client Service",
	"_giffer":                               "gif collection browsing",
	"_gforce-ssmp":                          "G-Force Control via SoundSpectrum's SSMP TCP Protocol",
	"_glasspad":                             "GlassPad Data Exchange Protocol",
	"_glasspadserver":                       "GlassPadServer Data Exchange Protocol",
	"_glrdrvmon":                            "OpenGL Driver Monitor",
	"_googexpeditions":                      "Service related to Google Expeditions which is a technology for enabling multi-participant virtual fieldtrip experiences over a local wireless network. See http://g.co/expeditions for more details",
	"_googlecast":                           "Service related to Google Cast which is a technology for enabling multi-screen experiences. See developers.google.com/cast for more details",
	"_goorstop":                             "For iOS Application named GoOrStop",
	"_gopro-wake":                           "GoPro proprietary protocol to wake devices",
	"_gopro-web":                            "GoPro proprietary protocol for devices",
	"_gotit":                                "Network name Got It!",
	"_gpnp":                                 "Grid Plug and Play",
	"_grillezvous":                          "Roxio ToastAnywhere(tm) Recorder Sharing",
	"_groovesquid":                          "Groovesquid Democratic Music Control Protocol",
	"_growl":                                "Growl",
	"_gsremotecontrol":                      "GS Labs set-top box remote control",
	"_gucam-http":                           "Image Data Transfer API for Wi-Fi Camera Devices over HTTP",
	"_guid":                                 "Special service type for resolving by GUID (Globally Unique Identifier)",
	"_h323":                                 "H.323 Real-time audio, video and data communication call setup protocol",
	"_hbbtv-ait":                            "HbbTV Application Information Table",
	"_help":                                 "HELP command",
	"_hg":                                   "Mercurial web-based repository access",
	"_hinz":                                 "HINZMobil Synchronization protocol",
	"_hmcp":                                 "Home Media Control Protocol",
	"_hola":                                 "An application to communicate with other",
	"_home-assistant":                       "Home Assistant",
	"_home-sharing":                         "iTunes Home Sharing",
	"_homeauto":                             "iDo Technology Home Automation Protocol",
	"_homeconnect":                          "Home Connect Protocol",
	"_homekit":                              "Protocol for home hub communication",
	"_honeywell-vid":                        "Honeywell Video Systems",
	"_hotwayd":                              "Hotwayd",
	"_howdy":                                "Howdy messaging and notification protocol",
	"_hpdeviceinfo":                         "The service provides information about connected HP devices",
	"_hpr-bldlnx":                           "HP Remote Build System for Linux-based Systems",
	"_hpr-bldwin":                           "HP Remote Build System for Microsoft Windows Systems",
	"_hpr-db":                               "Identifies systems that house databases for the Remote Build System and Remote Test System",
	"_hpr-rep":                              "HP Remote Repository for Build and Test Results",
	"_hpr-toollnx":                          "HP Remote System that houses compilers and tools for Linux-based Systems",
	"_hpr-toolwin":                          "HP Remote System that houses compilers and tools for Microsoft Windows Systems",
	"_hpr-tstlnx":                           "HP Remote Test System for Linux-based Systems",
	"_hpr-tstwin":                           "HP Remote Test System for Microsoft Windows Systems",
	"_hs-off":                               "Hobbyist Software Off Discovery",
	"_htsp":                                 "Home Tv Streaming Protocol",
	"_htvncconf":                            "HomeTouch Vnc Configuration",
	"_hue":                                  "Philips hue protocol",
	"_huesync":                              "Philips Hue Sync control protocol",
	"_hyperstream":                          "Atempo HyperStream deduplication server",
	"_iad1":                                 "BBN IAD",
	"_iad2":                                 "BBN IAD",
	"_iad3":                                 "BBN IAD",
	"_iaudit":                               "Braemar Inventory audit",
	"_ibiz":                                 "iBiz Server",
	"_ica-networking":                       "Image Capture Networking",
	"_ican":                                 "Northrup Grumman/TASC/ICAN Protocol",
	"_ichalkboard":                          "iChalk",
	"_ichat":                                "iChat 1.0",
	"_ici":                                  "ICI",
	"_iconquer":                             "iConquer",
	"_icontrolbox":                          "A Remote Control Application service used to control Computers on a Local Area Network",
	"_idata":                                "Generic Data Acquisition and Control Protocol",
	"_idcws":                                "Intermec Device Configuration Web Services",
	"_ideaquest":                            "IDEAQUEST Safety Monitoring System",
	"_idsync":                               "SplashID Synchronization Service",
	"_iffl":                                 "iFFL Bonjour service for communication between client and server applications.",
	"_ifolder":                              "Published iFolder",
	"_ihouse":                               "Idle Hands iHouse Protocol",
	"_ii-drills":                            "Instant Interactive Drills",
	"_ii-konane":                            "Instant Interactive Konane",
	"_ilynx":                                "iLynX",
	"_im":                                   "Instant Messaging",
	"_imagescal":                            "ImagesCal App Data Sharing",
	"_imidi":                                "iMidi",
	"_imgsync":                              "Protocol synchronizing Image data",
	"_ims-ni":                               "Noise Inspector",
	"_indigo-dvr":                           "Indigo Security Digital Video Recorders",
	"_infboard":                             "InfBoard interactive whiteboard protocol",
	"_informacast":                          "Listing Singlewire InformaCast servers",
	"_innergroup":                           "Service for a Communications App",
	"_inova-ontrack":                        "Inova Solutions OnTrack Display Protocol",
	"_iot":                                  "Internet-of-things (IoT) JSON telegram service",
	"_iota":                                 "iotaMed medical records server",
	"_ipbroadcaster":                        "IP Broadcaster",
	"_iperfd":                               "Network socket performance test",
	"_ipspeaker":                            "IP Speaker Control Protocol",
	"_iqp":                                  "Control protocol for Phase One devices",
	"_irc-iot":                              "The universal protocol for building IoT",
	"_ir-hvac-000":                          "HVAC SMIL Server",
	"_irelay":                               "iRelay application discovery service",
	"_irmc":                                 "Intego Remote Management Console",
	"_irobotmcs":                            "iRobot Monitor and Control Service",
	"_iroid-sd":                             "Iroid Data Service Discovery",
	"_irradiatd-iclip":                      "iClip clipboard transfer",
	"_irt-sharing":                          "Image Resizer Toolbox preview sharing service",
	"_isparx":                               "iSparx",
	"_ispq-vc":                              "iSpQ VideoChat",
	"_ishare":                               "iShare",
	"_isticky":                              "iSticky",
	"_istorm":                               "iStorm",
	"_isynchronize":                         "iSynchronize data synchronization protocol",
	"_itap-publish":                         "iTap Publishing Service",
	"_itis-device":                          "IT-IS International Ltd. Device",
	"_itsrc":                                "iTunes Socket Remote Control",
	"_ivef":                                 "Inter VTS Exchange Format",
	"_iwork":                                "iWork Server",
	"_izira":                                "Integrated Business Data Exchange",
	"_jcan":                                 "Northrup Grumman/TASC/JCAN Protocol",
	"_jeditx":                               "Jedit X",
	"_jini":                                 "Jini Service Discovery",
	"_jmap":                                 "JSON Meta Application Protocol",
	"_jnx-kcsync":                           "jollys keychain cloud sync protocol",
	"_jtag":                                 "Proprietary",
	"_jukebox":                              "Jukebox Request Service",
	"_jukejoint":                            "Music sharing protocol",
	"_keynoteaccess":                        "KeynoteAccess is used for sending remote requests/responses when controlling a slideshow with Keynote Remote",
	"_keynotepairing":                       "KeynotePairing is used to pair Keynote Remote with Keynote",
	"_kiwin":                                "Topology Discovery",
	"_knx":                                  "KNX Discovery Protocol",
	"_ktp":                                  "Kabira Transaction Platform",
	"_kyma":                                 "Symbolic Sound Kyma Service Discovery",
	"_la-maint":                             "IMP Logical Address Maintenance",
	"_labyrinth":                            "Labyrinth local multiplayer protocol",
	"_lan2p":                                "Lan2P Peer-to-Peer Network Protocol",
	"_lapse":                                "Gawker",
	"_larvaio-control":                      "Larva IP Controller",
	"_leaf":                                 "Lua Embedded Application Framework",
	"_lexicon":                              "Lexicon Vocabulary Sharing",
	"_liaison":                              "Liaison",
	"_library":                              "Delicious Library 2 Collection Data Sharing Protocol",
	"_libratone":                            "Protocol for setup and control of Libratone products",
	"_licor":                                "LI-COR Biosciences instrument discovery",
	"_llrp-secure":                          "RFID reader Low Level Reader Protocol over SSL/TLS",
	"_lobby":                                "Gobby",
	"_logicnode":                            "Logic Pro Distributed Audio",
	"_logsheetserver":                       "logSheet Server Synchronization Server",
	"_lonbridge":                            "Echelon LonBridge Server",
	"_lontalk":                              "LonTalk over IP (ANSI 852)",
	"_lsys-appserver":                       "Linksys One Application Server API",
	"_lsys-camera":                          "Linksys One Camera API",
	"_lsys-ezcfg":                           "LinkSys EZ Configuration",
	"_lsys-oamp":                            "LinkSys Operations, Administration, Management, and Provisioning",
	"_lumiere":                              "A protocol to remotely control DMX512 devices over the network",
	"_lumis-lca":                            "Lumis Cache Appliance Protocol",
	"_lux-dtp":                              "Lux Solis Data Transport Protocol",
	"_lxi":                                  "LXI",
	"_lyrics":                               "iPod Lyrics Service",
	"_m30s1pt":                              "Moritz30-Project Standard protocol 1 Plain Text",
	"_macfoh":                               "MacFOH",
	"_macfoh-admin":                         "MacFOH admin services",
	"_macfoh-audio":                         "MacFOH audio stream",
	"_macfoh-events":                        "MacFOH show control events",
	"_macfoh-data":                          "MacFOH realtime data",
	"_macfoh-db":                            "MacFOH database",
	"_macfoh-remote":                        "MacFOH Remote",
	"_macminder":                            "Mac Minder",
	"_maestro":                              "Maestro Music Sharing Service",
	"_magicdice":                            "Magic Dice Game Protocol",
	"_mandos":                               "Mandos Password Server",
	"_mas":                                  "Pravala Mobility and Aggregation Service",
	"_matrix":                               "MATRIX Remote AV Switching",
	"_matterc":                              "Matter Commissionable Node Discovery",
	"_matterd":                              "Matter Commissioner Discovery",
	"_mavlink":                              "MAVLink Micro Air Vehicle Communication Protocol",
	"_mazepseudo-game":                      "Peer to peer communication between instances of the Maze Pseudo game.",
	"_mbconsumer":                           "MediaBroker++ Consumer",
	"_mbproducer":                           "MediaBroker++ Producer",
	"_mbserver":                             "MediaBroker++ Server",
	"_mconnect":                             "ClairMail Connect",
	"_mcrcp":                                "MediaCentral",
	"_mediaboard1":                          "MediaBoardONE Asset and Information Manager data sharing and synchronization protocol",
	"_mediatap":                             "Mediatap streaming protocol",
	"_mercurydock":                          "Mercury Dock Assistant",
	"_mesamis":                              "Mes Amis",
	"_meshcop":                              "Thread Mesh Commissioning",
	"_meshcop-e":                            "Thread Mesh Commissioning Ephemeral-key",
	"_mi-raysat":                            "Mental Ray for Maya",
	"_microdeep":                            "A protocol for controlling a microscope",
	"_midi2":                                "MIDI 2.0 Device Discovery",
	"_mieleacs":                             "Protocol for connected accessories",
	"_mieleathome":                          "Miele@home Protocol",
	"_mieleprof":                            "Miele protocol for prof. appliances",
	"_mielesemiprof":                        "Miele protocol for semi prof. appliances",
	"_mist":                                 "A Medical Interoperability Service Type, used to identify medical devices providing network interfaces.",
	"_mles":                                 "Mles is a client-server data distribution protocol targeted to serve as a lightweight and reliable distributed publish/subscribe database service.",
	"_mmm":                                  "Provides a client with access to the Mathematical Mesh, a user-focused PKI.",
	"_mn-passage":                           "A Remote Control Application service used to control Computers on a Local Area Network",
	"_modolansrv":                           "modo LAN Services",
	"_mogeneti-auth":                        "Authentication service for Mogeneti Software Applications",
	"_moncon":                               "Sonnox MCON monitor controller protocol",
	"_moneysync":                            "SplashMoney Synchronization Service",
	"_moneyworks":                           "MoneyWorks Gold and MoneyWorks Datacentre network service",
	"_moodring":                             "Bonjour Mood Ring tutorial program",
	"_mother":                               "Mother script server protocol",
	"_movieslate":                           "MovieSlate digital clapperboard",
	"_mp3sushi":                             "MP3 Sushi",
	"_mslingshot":                           "Martian SlingShot",
	"_msrps":                                "MSRP protocol over TLS",
	"_mumble":                               "Mumble VoIP communication protocol",
	"_musicmachine":                         "Protocol for a distributed music playing service",
	"_mysync":                               "MySync Protocol",
	"_mttp":                                 "MenuTunes Sharing",
	"_mxim-art2":                            "Maxim Integrated Products Automated Roadtest Mk II",
	"_mxim-ice":                             "Maxim Integrated Products In-circuit Emulator",
	"_mxs":                                  "MatrixStore",
	"_naio":                                 "NetAcquire server input/output protocol",
	"_nasmon":                               "Proprietary communication protocol for NAS Monitor",
	"_nasunifiler":                          "This DNS-SD service is used by mobile clients to locate the Nasuni Filer (a storage product) for a given company.",
	"_ncbroadcast":                          "Network Clipboard Broadcasts",
	"_ncdirect":                             "Network Clipboard Direct Transfers",
	"_ncount-issuer":                        "The issuer service in the n-Count electronic value transfer system",
	"_ncsyncserver":                         "Network Clipboard Sync Server",
	"_ndi":                                  "IP based video discovery and usage",
	"_nedap-aepu":                           "Nedap AEOS processing unit",
	"_neoriders":                            "NeoRiders Client Discovery Protocol",
	"_netready":                             "UpdateLogic NetReady Device Identification",
	"_netrestore":                           "NetRestore",
	"_netvu-video":                          "AD Group NetVu Connected Video",
	"_nextcap":                              "Proprietary communication protocol for NextCap capture solution",
	"_nfs-domainroot":                       "NFS service for the domain root, the root of an organization's published file namespace.",
	"_ngr-keydist":                          "NGR Key Distribution",
	"_ni":                                   "National Instruments Network Device",
	"_ni-ftp":                               "NI FTP",
	"_ni-mail":                              "NI MAIL",
	"_ni-rt":                                "National Instruments Real-Time Target",
	"_ni-sysapi":                            "National Instruments System API Service",
	"_nodel":                                "Lightweight event based control protocol utilising JavaScript Object Notation",
	"_nq":                                   "Network Quality test server endpoint",
	"_ntlx-arch":                            "American Dynamics Intellex Archive Management Service",
	"_ntlx-ent":                             "American Dynamics Intellex Enterprise Management Service",
	"_ntlx-video":                           "American Dynamics Intellex Video Service",
	"_ntx":                                  "Tenasys",
	"_nusdp":                                "Nuance Unity Service Discovery Protocol",
	"_oak":                                  "Oak Device Services",
	"_obf":                                  "Observations Framework",
	"_objective":                            "Means for clients to locate servers in an Objective (http://www.objective.com) instance.",
	"_oca":                                  "Insecure OCP.1 protocol, which is the insecure TCP/IP implementation of the Object Control Architecture",
	"_ocasec":                               "Secure OCP.1 protocol, which is the secure TCP/IP implementation of the Object Control Architecture",
	"_ocaws":                                "Insecure OCP.1 hosted on a WebSocket",
	"_oce":                                  "Oce Common Exchange Protocol",
	"_od-master":                            "OpenDirectory Master",
	"_odabsharing":                          "OD4Contact",
	"_odisk":                                "Optical Disk Sharing",
	"_officetime-sync":                      "OfficeTime Synchronization Protocol",
	"_ofocus-conf":                          "OmniFocus setting configuration",
	"_ofocus-sync":                          "OmniFocus document synchronization",
	"_ola":                                  "Web Interface for the Open Lighting Architecture Software",
	"_olpc-activity1":                       "One Laptop per Child activity",
	"_oma-bcast-sg":                         "OMA BCAST Service Guide Discovery Service",
	"_omadm-bootstrap":                      "Open Mobile Alliance (OMA) Device Management (DM) Bootstrap Server Discovery Service",
	"_omni-bookmark":                        "OmniWeb",
	"_omni-live":                            "Service for remote control of Omnisphere virtual instrument",
	"_omnistate":                            "Resource state update notifications",
	"_onenet-info":                          "OneNet Application Information Service",
	"_onenet-pairing":                       "OneNet Pairing",
	"_onenet-pgn":                           "OneNet PGN Transport Service",
	"_openbase":                             "OpenBase SQL",
	"_opencu":                               "Conferencing Protocol",
	"_openpath":                             "Discovery of OpenPath appliances",
	"_oprofile":                             "oprofile server protocol",
	"_oscit":                                "Open Sound Control Interface Transfer",
	"_ovready":                              "ObjectVideo OV Ready Protocol",
	"_owhttpd":                              "OWFS (1-wire file system) web server",
	"_parentcontrol":                        "Remote Parental Controls",
	"_passwordwallet":                       "PasswordWallet Data Synchronization Protocol",
	"_pcast":                                "Mac OS X Podcast Producer Server",
	"_p2pchat":                              "Peer-to-Peer Chat (Sample Java Bonjour application)",
	"_p2pstorage-sec":                       "DataBOND p2p storage",
	"_pairandshare":                         "Pair & Share data protocol",
	"_panoply":                              "Panoply multimedia composite transfer protocol",
	"_parabay-p2p":                          "Parabay P2P protocol",
	"_parity":                               "PA-R-I-Ty (Public Address - Radio - Intercom - Telefony)",
	"_payload-app":                          "Local and remote file transfers",
	"_pgpkey-hkp":                           "Horowitz Key Protocol (HKP)",
	"_pgpkey-http":                          "PGP Keyserver using HTTP/1.1",
	"_pgpkey-https":                         "PGP Keyserver using HTTPS",
	"_pgpkey-ldap":                          "PGP Keyserver using LDAP",
	"_pgpkey-mailto":                        "PGP Key submission using SMTP",
	"_photoparata":                          "Photo Parata Event Photography Software",
	"_photoshow":                            "Show Photos over TCP",
	"_photosmithsync":                       "Photosmith's iPad to Lightroom sync protocol",
	"_pictua":                               "Pictua Intercommunication Protocol",
	"_piesync":                              "pieSync Computer to Computer Synchronization",
	"_pipedal":                              "Pi Pedal Web Interface",
	"_piu":                                  "Pedestal Interface Unit by RPM-PSI",
	"_pkixrep":                              "Public Key Infrastructure Repository Locator Service",
	"_poch":                                 "Parallel OperatiOn and Control Heuristic (Pooch)",
	"_pochi":                                "A presenter to audience transfer service",
	"_podcastproxy":                         "Protocol for communication between Podcast",
	"_pokeeye":                              "Communication channel for 'Poke Eye' Elgato EyeTV remote controller",
	"_powereasy-erp":                        "PowerEasy ERP",
	"_powereasy-pos":                        "PowerEasy Point of Sale",
	"_pplayer-ctrl":                         "Piano Player Remote Control",
	"_pres":                                 "Presence",
	"_print-caps":                           "Retrieve a description of a device's print capabilities",
	"_prolog":                               "Prolog",
	"_protonet":                             "Protonet node and service discovery protocol",
	"_psap":                                 "Progal Service Advertising Protocol",
	"_psia":                                 "Physical Security Interoperability Alliance Protocol",
	"_pstmailsync":                          "File synchronization protocol for Pst Mail Sync",
	"_pstmailsync-ssl":                      "Secured file synchronization protocol for Pst Mail Sync",
	"_ptnetprosrv2":                         "PTNetPro Service",
	"_ptp-init":                             "Picture Transfer Protocol(PTP) Initiator",
	"_ptp-req":                              "PTP Initiation Request Protocol",
	"_pulsar":                               "Network service for Pulsar messaging and data sharing mobile app",
	"_puzzle":                               "Protocol used for puzzle games",
	"_qbox":                                 "QBox Appliance Locator",
	"_qttp":                                 "QuickTime Transfer Protocol",
	"_quad":                                 "Distributed Game Data",
	"_quinn":                                "Quinn Game Server",
	"_qwizcollab":                           "Broadcast of Qwizdom Presentation sessions for joining by a client, such as Qwizdom Notes+.",
	"_rakket":                               "Rakket Client Protocol",
	"_radiotag":                             "RadioTAG: Event tagging for radio services",
	"_radiovis":                             "RadioVIS: Visualisation for radio services",
	"_radioepg":                             "RadioEPG: Electronic Programme Guide for radio services",
	"_radioport":                            "RadioPort Message Service",
	"_radiusdtls":                           "Authentication, Accounting, and Dynamic Authorization via the RADIUS protocol. This service name is used to construct the SRV service label '_radiusdtls' for discovery of RADIUS/DTLS servers.",
	"_radiustls":                            "Authentication, Accounting, and Dynamic Authorization via the RADIUS protocol. This service name is used to construct the SRV service label '_radiustls' for discovery of RADIUS/TLS servers.",
	"_railduino":                            "Model Railroad Messaging",
	"_raop":                                 "Remote Audio Output Protocol (AirTunes)",
	"_rapta":                                "Industrial IOT self-discovery network",
	"_rbr":                                  "RBR Instrument Communication",
	"_rce":                                  "PowerCard",
	"_realplayfavs":                         "RealPlayer Shared Favorites",
	"_recipe-box":                           "The Recipe Box Exchange",
	"_recipe-sharing":                       "Recipe Sharing Protocol",
	"_recolive-cc":                          "Remote Camera Control",
	"_recordit-itp":                         "Recordit Image Transport Protocol",
	"_remote":                               "Remote Device Control Protocol",
	"_remotebuddy":                          "Remote Buddy remote control software command and data exchange",
	"_remoteburn":                           "LaCie Remote Burn",
	"_renderpipe":                           "ARTvps RenderDrive/PURE Renderer Protocol",
	"_rendezvouspong":                       "RendezvousPong",
	"_renkara-sync":                         "Renkara synchronization protocol",
	"_resol-vbus":                           "RESOL VBus",
	"_rfbc":                                 "Remote Frame Buffer Client (Used by VNC viewers in listen-mode)",
	"_rfid":                                 "RFID Reader Mach1(tm) Protocol",
	"_rgb":                                  "RGB Spectrum Device Discovery",
	"_riousbprint":                          "Remote I/O USB Printer Protocol",
	"_roambot":                              "Roambot communication",
	"_robustirc":                            "Like ircu (RFC1459), but failure tolerant due to strong consistency among n>=3 servers",
	"_roku-rcp":                             "Roku Control Protocol",
	"_roomcast-capi":                        "RoomCast Control Protocol",
	"_roomcast-mapi":                        "RoomCast Management Protocol",
	"_rql":                                  "RemoteQuickLaunch",
	"_rr-disc":                              "Robot Raconteur discovery",
	"_rradict":                              "Ruckus Radio Access Device, Installation, Commissioning and Troubleshooting service.",
	"_rsmp-server":                          "Remote System Management Protocol (Server Instance)",
	"_rubygems":                             "RubyGems GemServer",
	"_rxxmiele":                             "Miele protocol robot cleaners",
	"_rym-rrc":                              "Raymarine remote control protocol",
	"_safarimenu":                           "Safari Menu",
	"_sallingbridge":                        "Salling Clicker Sharing",
	"_sallingclicker":                       "Salling Clicker Service",
	"_salutafugijms":                        "Salutafugi Peer-To-Peer Java Message Service Implementation",
	"_sandvox":                              "Sandvox",
	"_savagesoft":                           "Proprietary Client Server Protocol",
	"_sc-golf":                              "StrawberryCat Golf Protocol",
	"_scanner":                              "Bonjour Scanning",
	"_schdca":                               "schindler internal messaging service",
	"_schick":                               "Schick",
	"_schims":                               "schindler internal messaging service",
	"_schlog":                               "logging service",
	"_schmpp":                               "Schindler maintenance portal protocol",
	"_schoms":                               "schindler object messaging system",
	"_schsap":                               "Schindler service authentication portal",
	"_schsrmp":                              "Schindler internal messaging service",
	"_schvpp":                               "schindler internal messaging service",
	"_scone":                                "Scone",
	"_scoop-sftp":                           "The service name is used by the SFTP protocol to upload log files from vehicles to road side units in a securely way in a cooperative intelligent transportation system.",
	"_sdsharing":                            "Speed Download",
	"_see":                                  "SubEthaEdit 2",
	"_seecard":                              "seeCard",
	"_senteo-http":                          "Senteo Assessment Software Protocol",
	"_sentillion-vlc":                       "Sentillion Vault System",
	"_sentillion-vlt":                       "Sentillion Vault Systems Cluster",
	"_sepvsync":                             "SEPV Application Data Synchronization Protocol",
	"_serendipd":                            "serendiPd Shared Patches for Pure Data",
	"_servereye":                            "ServerEye AgentContainer Communication Protocol",
	"_servermgr":                            "Mac OS X Server Admin",
	"_services":                             "DNS Service Discovery",
	"_sessionfs":                            "Session File Sharing",
	"_setlistmaker-rc":                      "Remote Control for Set List Maker app",
	"_setlistmaker-ss":                      "Screen sharing for Set List Maker app",
	"_sftp-ssh":                             "Secure File Transfer Protocol over SSH",
	"_sge-exec":                             "Sun Grid Engine (Execution Host)",
	"_shifter":                              "Window Shifter server protocol",
	"_ship":                                 "SHIP (Smart Home IP)",
	"_shipsgm":                              "Swift Office Ships",
	"_shipsinvit":                           "Swift Office Ships",
	"_shoppersync":                          "SplashShopper Synchronization Service",
	"_shots-sync":                           "The protocol is used to sync database among iOS devices and Mac OS X computers.",
	"_shoutcast":                            "Nicecast",
	"_siminsufflator":                       "Simulated insufflator synchronisation protocol",
	"_simmon":                               "Medical simulation patient monitor syncronisation protocol",
	"_simusoftpong":                         "simusoftpong iPhone game protocol",
	"_sipuri":                               "Session Initiation Protocol Uniform Resource Identifier",
	"_sironaxray":                           "Sirona Xray Protocol",
	"_skillscapture":                        "The protocol is used to transfer database records between an iOS device to a Mac OS X computer",
	"_skype":                                "Skype",
	"_sleep-proxy":                          "Sleep Proxy Server",
	"_sleeptracker":                         "Sleeptracker(R) The loT Smartbed Platform",
	"_slimcli":                              "SliMP3 Server Command-Line Interface",
	"_slimhttp":                             "SliMP3 Server Web Interface",
	"_slpda":                                "Remote Service Discovery in the Service Location",
	"_smag":                                 "terminal access to laundry appliances",
	"_smaho":                                "Smart Home Device Setup",
	"_smartenergy":                          "Smart Energy Profile",
	"_smartsocket":                          "home control",
	"_smb":                                  "Server Message Block over TCP/IP",
	"_smimeca":                              "Domain signing certificate for S/MIME keys",
	"_sms":                                  "Short Text Message Sending and Delivery Status Service",
	"_smsync":                               "Syncellence file synchronization protocol",
	"_snif-cln":                             "End-to-end TLS Relay Client Connection",
	"_snif-fifo":                            "End-to-end TLS Relay Cluster",
	"_snif-srv":                             "End-to-end TLS Relay Service Connection",
	"_soap":                                 "Simple Object Access Protocol",
	"_socketcloud":                          "Socketcloud distributed application framework",
	"_soda":                                 "Secure On Device API",
	"_souschef":                             "SousChef Recipe Sharing Protocol",
	"_sox":                                  "Simple Object eXchange",
	"_sparechange":                          "SpareChange data sharing protocol",
	"_sparql":                               "SPARQL Protocol and RDF Query Language",
	"_spearcat":                             "sPearCat Host Discovery",
	"_spidap":                               "Sierra Photonics Inc. data protocol",
	"_spincrisis":                           "Spin Crisis",
	"_spiderelectron":                       "Binary message passing protocol",
	"_spl-itunes":                           "launchTunes",
	"_spr-itunes":                           "netTunes",
	"_splashsync":                           "SplashData Synchronization Service",
	"_split-dns64":                          "DNS64 in split configuration",
	"_spres":                                "SongPresenter",
	"_spx-hmp":                              "SpinetiX HMP",
	"_sqp":                                  "Square Connect Control Protocol",
	"_ss-sign":                              "Samsung Smart Interaction for Group Network",
	"_ss-sign-disc":                         "Samsung Smart Interaction for Group Network Discovery",
	"_ssd-audio":                            "Studio Six Digital Wireless Audio",
	"_ssscreenshare":                        "Screen Sharing",
	"_startrecapp":                          "Remote Controlled Multimedia Recorder Network",
	"_stingray-rpc":                         "Stingray Remote Procedure Call",
	"_stingray-remote":                      "Stingray remote control",
	"_strateges":                            "Strateges",
	"_stanza":                               "Lexcycle Stanza service for discovering shared books",
	"_stickynotes":                          "Sticky Notes",
	"_stotp":                                "One Time Pad Synchronisation",
	"_strobe-sync":                          "Strobe Synchronization",
	"_sugarlock-rcp":                        "Remote control protocol for Sugarlock consumer electronics devices",
	"_supple":                               "Supple Service protocol",
	"_surveillus":                           "Surveillus Networks Discovery Protocol",
	"_swcards":                              "Signwave Card Sharing Protocol",
	"_switcher":                             "Wireless home control remote control protocol",
	"_swordfish":                            "Swordfish Protocol for Input/Output",
	"_swyp":                                 "Framework for transferring any file from any app, to      any app on any device: simply with a swÿp.",
	"_sxqdea":                               "Synchronize! Pro X",
	"_sybase-tds":                           "Sybase Server",
	"_synclavier":                           "Remote control of Synclavier Digital Audio Workstation over local area network.",
	"_syncopation":                          "Syncopation Synchronization Protocol by Sonzea",
	"_syncqdea":                             "Synchronize! X Plus 2.0",
	"_synergy":                              "Synergy Peer Discovery",
	"_synksharing":                          "SynkSharing synchronization protocol",
	"_sztp":                                 "This service name is used to construct the      SRV service label '_sztp' for discovering      SZTP bootstrap servers.",
	"_taccounting":                          "Data Transmission and Synchronization",
	"_tango":                                "Tango Remote Control Protocol",
	"_tapinoma-ecs":                         "Tapinoma Easycontact receiver",
	"_taskcoachsync":                        "Task Coach Two-way Synchronization Protocol for iPhone",
	"_tbricks":                              "tbricks internal protocol",
	"_tcode":                                "Time Code",
	"_tcu":                                  "Tracking Control Unit by RPM-PSI",
	"_te-faxserver":                         "TE-SYSTEMS GmbH Fax Server Daemon",
	"_teamlist":                             "ARTIS Team Task",
	"_ted":                                  "Teddington Controls",
	"_teleport":                             "teleport",
	"_tenir-rc":                             "Proprietary",
	"_tera-fsmgr":                           "Terascala Filesystem Manager Protocol",
	"_tera-mp":                              "Terascala Maintenance Protocol",
	"_test-ok":                              "Test Controller Card",
	"_tf-redeye":                            "ThinkFlood RedEye IR bridge",
	"_thing":                                "Internet of things service discovery",
	"_thumbwrestling":                       "tinkerbuilt Thumb Wrestling game",
	"_ticonnectmgr":                         "TI Connect Manager Discovery Service",
	"_tic-tac-toe":                          "Tic Tac Toe game",
	"_timezone":                             "Time Zone Data Distribution Service - non-TLS",
	"_timezones":                            "Time Zone Data Distribution Service - over TLS",
	"_tinavigator":                          "TI Navigator Hub 1.0 Discovery Service",
	"_tivo-device":                          "TiVo Device Protocol",
	"_tivo-hme":                             "TiVo Home Media Engine Protocol",
	"_tivo-mindrpc":                         "TiVo RPC Protocol",
	"_tivo-music":                           "TiVo Music Protocol",
	"_tivo-photos":                          "TiVo Photos Protocol",
	"_tivo-remote":                          "TiVo Remote Protocol",
	"_tivo-videos":                          "TiVo Videos Protocol",
	"_tmsensor":                             "Teledyne Marine Sensor",
	"_todogwa":                              "2Do Sync Helper Tool for Mac OS X and PCs",
	"_tomboy":                               "Tomboy",
	"_toothpicserver":                       "ToothPics Dental Office Support Server",
	"_touch-able":                           "iPhone and iPod touch Remote Controllable",
	"_touch-remote":                         "iPhone and iPod touch Remote Pairing",
	"_tptx-console":                         "Coordination service for client users of the TotalPraisTrax iPad application",
	"_transmitr":                            "Service discovery and media transfer for peer to peer mobile media transfer app",
	"_trel":                                 "Thread Radio Encapsulation Link",
	"_tri-vis-client":                       "triCerat Simplify Visibility Client",
	"_tri-vis-server":                       "triCerat Simplify Visibility Server",
	"_tryst":                                "Tryst",
	"_tsbiis":                               "The Social Broadband Interference Information Sharing",
	"_tt4inarow":                            "Trivial Technology's 4 in a Row",
	"_ttcheckers":                           "Trivial Technology's Checkers",
	"_ttp4daemon":                           "TechTool Pro 4 Anti-Piracy Service",
	"_tunage":                               "Tunage Media Control Service",
	"_tuneranger":                           "TuneRanger",
	"_tvm":                                  "Vogel's TV mount control",
	"_twiline-disc":                         "Discovery for Twiline systems",
	"_twinlevel":                            "detect sanitary product",
	"_twosnakes":                            "Service to enable multiplayer game called two snakes.",
	"_tyba":                                 "Tyba control",
	"_tzrpc":                                "TZ-Software remote procedure call based synchronization protocol",
	"_ubertragen":                           "Ubertragen",
	"_ucdynamics-tuc":                       "Tactical Unified Communicator",
	"_uddi":                                 "Universal Description, Discovery and Integration",
	"_uddi-inq":                             "Universal Description, Discovery and Integration Inquiry",
	"_uddi-pub":                             "Universal Description, Discovery and Integration Publishing",
	"_uddi-sub":                             "Universal Description, Discovery and Integration Subscription",
	"_uddi-sec":                             "Universal Description, Discovery and Integration Security",
	"_upnp":                                 "Universal Plug and Play",
	"_urlbookmark":                          "URL Advertising",
	"_usp-agt-coap":                         "USP discovery",
	"_usp-agt-http":                         "USP discovery",
	"_usp-agt-mqtt":                         "USP discovery",
	"_usp-agt-stomp":                        "USP discovery",
	"_usp-agt-ws":                           "USP discovery",
	"_usp-ctr-coap":                         "USP discovery",
	"_usp-ctr-http":                         "USP discovery",
	"_usp-ctr-mqtt":                         "USP discovery",
	"_usp-ctr-stomp":                        "USP discovery",
	"_usp-ctr-ws":                           "USP discovery",
	"_uswi":                                 "Universal Switching Corporation products",
	"_utest":                                "uTest",
	"_uwsgi":                                "Unbit Web Server Gateway Interface",
	"_vapix-http":                           "Indicator for VAPIX support over HTTP",
	"_vapix-https":                          "Indicator for VAPIX support over HTTPS",
	"_ve-decoder":                           "American Dynamics VideoEdge Decoder Control Service",
	"_ve-encoder":                           "American Dynamics VideoEdge Encoder Control Service",
	"_ve-recorder":                          "American Dynamics VideoEdge Recorder Control Service",
	"_vedabase":                             "Application specific synchronization protocol",
	"_vhusb":                                "USB over IP Sharing System",
	"_virtualdj":                            "VirtualDJ Remote Control protocol",
	"_visel":                                "visel Q-System services",
	"_voalte2":                              "Server location via DNS-SD",
	"_voalte3":                              "Server location via DNS-SD",
	"_volterio":                             "Internal Communication Service",
	"_vos":                                  "Virtual Object System (using VOP/TCP)",
	"_voxidahmp":                            "RTP Mixer/Summation Resource",
	"_vrmg-p2p":                             "Verimag mobile class protocol over P2P",
	"_vue4rendercow":                        "VueProRenderCow",
	"_vxi-11":                               "VXI-11 TCP/IP Instrument Protocol",
	"_wakeywakey":                           "Proprietary",
	"_walkietalkie":                         "Walkie Talkie",
	"_wd-2go":                               "NAS Service Protocol",
	"_wdp":                                  "Windows Device Portal",
	"_web-xi":                               "HTTP-based protocol for DAQ devices",
	"_webex":                                "Cisco WebEx serials products will release Bonjour based service",
	"_we-jell":                              "Proprietary collaborative messaging protocol",
	"_webdav":                               "World Wide Web Distributed Authoring and Versioning (WebDAV)",
	"_webdavs":                              "WebDAV over SSL/TLS",
	"_webissync":                            "WebIS Sync Protocol",
	"_wedraw":                               "weDraw document sharing protocol",
	"_whamb":                                "Whamb",
	"_whistler":                             "Honeywell Video Systems",
	"_wicop":                                "WiFi Control Platform",
	"_wifile":                               "System for transferring files between mobile device and computer in a local network",
	"_witap":                                "WiTap Sample Game Protocol",
	"_witapvoice":                           "witapvoice",
	"_wkgrpsvr":                             "Workgroup Server Discovery",
	"_workstation":                          "Workgroup Manager",
	"_wormhole":                             "Roku Cascade Wormhole Protocol",
	"_workgroup":                            "Novell collaboration workgroup",
	"_wot":                                  "W3C WoT Thing Description or Directory",
	"_wpl-ers-http":                         "World Programming repository server",
	"_wpl-ers-zmq":                          "World Programming repository server",
	"_writietalkie":                         "Writie Talkie Data Sharing",
	"_ws":                                   "Web Services",
	"_wtc-heleos":                           "Wyatt Technology Corporation HELEOS",
	"_wtc-qels":                             "Wyatt Technology Corporation QELS",
	"_wtc-rex":                              "Wyatt Technology Corporation Optilab rEX",
	"_wtc-viscostar":                        "Wyatt Technology Corporation ViscoStar",
	"_wtc-wpr":                              "Wyatt Technology Corporation DynaPro Plate Reader",
	"_wwdcpic":                              "PictureSharing sample code",
	"_x-on":                                 "x-on services synchronisation protocol",
	"_x-plane9":                             "x-plane9",
	"_xcodedistcc":                          "Xcode Distributed Compiler",
	"_xential":                              "xential document creation services",
	"_xgate-rmi":                            "xGate Remote Management Interface",
	"_xmiserver":                            "XMI Systems home terminal local connection",
	"_xmp":                                  "Xperientia Mobile Protocol",
	"_xsanclient":                           "Xsan Client",
	"_xsanserver":                           "Xsan Server",
	"_xsansystem":                           "Xsan System",
	"_xtimelicence":                         "xTime License",
	"_xtshapro":                             "xTime Project",
	"_xul-http":                             "XUL (XML User Interface Language) transported over HTTP",
	"_yakumo":                               "Yakumo iPhone OS Device Control Protocol",
	"_zeromq":                               "High performance brokerless messaging",
	"_zigbee-bridge":                        "ZigBee Bridge device",
	"_zigbee-gateway":                       "ZigBee IP Gateway",
}
