/* ButtonPopover.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ButtonPopover.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "icontasklistapplet.h"
#include <gio/gio.h>
#include "budgie-private.h"
#include "budgie-windowing.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <libxfce4windowing/libxfce4windowing.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#define SETTINGS_DBUS_NAME "org.budgie_desktop.Settings"
#define SETTINGS_DBUS_PATH "/org/budgie_desktop/Settings"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy SettingsRemoteProxy;
typedef GDBusProxyClass SettingsRemoteProxyClass;
typedef struct _settings_remote_CloseReadyData settings_remote_CloseReadyData;
enum  {
	ICON_TASKLIST_BUTTON_POPOVER_0_PROPERTY,
	ICON_TASKLIST_BUTTON_POPOVER_APP_PROPERTY,
	ICON_TASKLIST_BUTTON_POPOVER_GROUP_PROPERTY,
	ICON_TASKLIST_BUTTON_POPOVER_PINNED_PROPERTY,
	ICON_TASKLIST_BUTTON_POPOVER_NUM_PROPERTIES
};
static GParamSpec* icon_tasklist_button_popover_properties[ICON_TASKLIST_BUTTON_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_WINDOW_ITEM (window_item_get_type ())
#define WINDOW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW_ITEM, WindowItem))
#define WINDOW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW_ITEM, WindowItemClass))
#define IS_WINDOW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW_ITEM))
#define IS_WINDOW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW_ITEM))
#define WINDOW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW_ITEM, WindowItemClass))

typedef struct _WindowItem WindowItem;
typedef struct _WindowItemClass WindowItemClass;

#define TYPE_WINDOW_CONTROLS (window_controls_get_type ())
#define WINDOW_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW_CONTROLS, WindowControls))
#define WINDOW_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW_CONTROLS, WindowControlsClass))
#define IS_WINDOW_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW_CONTROLS))
#define IS_WINDOW_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW_CONTROLS))
#define WINDOW_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW_CONTROLS, WindowControlsClass))

typedef struct _WindowControls WindowControls;
typedef struct _WindowControlsClass WindowControlsClass;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
typedef struct _WindowControlsPrivate WindowControlsPrivate;
enum  {
	WINDOW_CONTROLS_0_PROPERTY,
	WINDOW_CONTROLS_WINDOW_PROPERTY,
	WINDOW_CONTROLS_NUM_PROPERTIES
};
static GParamSpec* window_controls_properties[WINDOW_CONTROLS_NUM_PROPERTIES];
typedef struct _Block4Data Block4Data;
enum  {
	WINDOW_CONTROLS_RETURN_CLICKED_SIGNAL,
	WINDOW_CONTROLS_NUM_SIGNALS
};
static guint window_controls_signals[WINDOW_CONTROLS_NUM_SIGNALS] = {0};
typedef struct _WindowItemPrivate WindowItemPrivate;
enum  {
	WINDOW_ITEM_0_PROPERTY,
	WINDOW_ITEM_WINDOW_PROPERTY,
	WINDOW_ITEM_NUM_PROPERTIES
};
static GParamSpec* window_item_properties[WINDOW_ITEM_NUM_PROPERTIES];
enum  {
	WINDOW_ITEM_PAGE_SWITCH_CLICKED_SIGNAL,
	WINDOW_ITEM_NUM_SIGNALS
};
static guint window_item_signals[WINDOW_ITEM_NUM_SIGNALS] = {0};

struct _settings_remote_CloseReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _IconTasklistButtonPopoverPrivate {
	BudgieApplication* _app;
	BudgieWindowingWindowGroup* _group;
	gboolean _pinned;
	GtkImage* pin_icon;
	GtkStack* stack;
	GtkListBox* desktop_actions;
	GtkListBox* windows;
	GtkButton* pin_button;
	GtkButton* new_instance_button;
	GtkButton* close_all_button;
};

struct _Block1Data {
	int _ref_count_;
	IconTasklistButtonPopover* self;
	XfwWindow* window;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	WindowControls* controls_layout;
};

struct _Block3Data {
	int _ref_count_;
	IconTasklistButtonPopover* self;
	gchar* action;
};

struct _WindowControls {
	GtkBox parent_instance;
	WindowControlsPrivate * priv;
};

struct _WindowControlsClass {
	GtkBoxClass parent_class;
};

struct _WindowControlsPrivate {
	XfwWindow* _window;
	GtkButton* maximize_button;
	GtkButton* minimize_button;
	GtkButton* return_button;
};

struct _Block4Data {
	int _ref_count_;
	WindowControls* self;
	XfwWorkspace* workspace;
};

struct _WindowItem {
	GtkListBoxRow parent_instance;
	WindowItemPrivate * priv;
};

struct _WindowItemClass {
	GtkListBoxRowClass parent_class;
};

struct _WindowItemPrivate {
	XfwWindow* _window;
	GtkLabel* name_label;
	GtkButton* name_button;
	GtkButton* close_button;
	GtkButton* page_switch_button;
};

static GType settings_remote_type_id = 0;
static gint IconTasklistButtonPopover_private_offset;
static gpointer icon_tasklist_button_popover_parent_class = NULL;
static GType icon_tasklist_button_popover_type_id = 0;
static gint WindowControls_private_offset;
static gpointer window_controls_parent_class = NULL;
static GType window_controls_type_id = 0;
static gint WindowItem_private_offset;
static gpointer window_item_parent_class = NULL;
static GType window_item_type_id = 0;

static void settings_remote_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void settings_remote_proxy_Close_async (SettingsRemote* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void settings_remote_proxy_Close_finish (SettingsRemote* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static void settings_remote_proxy_settings_remote_interface_init (SettingsRemoteIface* iface);
static void _dbus_settings_remote_Close (SettingsRemote* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation);
static void _dbus_settings_remote_Close_ready (GObject * source_object,
                                        GAsyncResult * _res_,
                                        gpointer _user_data_);
static void settings_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* settings_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static gboolean settings_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _settings_remote_unregister_object (gpointer user_data);
static void icon_tasklist_button_popover_on_pin_clicked (IconTasklistButtonPopover* self);
static void icon_tasklist_button_popover_on_new_instance_clicked (IconTasklistButtonPopover* self);
static void icon_tasklist_button_popover_on_close_all_clicked (IconTasklistButtonPopover* self);
static void icon_tasklist_button_popover_real_hide (GtkWidget* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GType window_item_register_type (GTypeModule * module);
VALA_EXTERN GType window_item_get_type (void) G_GNUC_CONST ;
VALA_EXTERN WindowItem* window_item_new (XfwWindow* window);
VALA_EXTERN WindowItem* window_item_construct (GType object_type,
                                   XfwWindow* window);
static void __lambda13_ (Block1Data* _data1_);
GType window_controls_register_type (GTypeModule * module);
VALA_EXTERN GType window_controls_get_type (void) G_GNUC_CONST ;
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN WindowControls* window_controls_new (XfwWindow* window);
VALA_EXTERN WindowControls* window_controls_construct (GType object_type,
                                           XfwWindow* window);
static void __lambda19_ (Block2Data* _data2_);
static void ___lambda19__window_controls_return_clicked (WindowControls* _sender,
                                                  gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void ___lambda13__window_item_page_switch_clicked (WindowItem* _sender,
                                                   gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN XfwWindow* window_item_get_window (WindowItem* self);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static GObject * icon_tasklist_button_popover_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _icon_tasklist_button_popover______lambda20_ (Block3Data* _data3_);
static void __icon_tasklist_button_popover______lambda20__gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _icon_tasklist_button_popover_on_close_all_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void _icon_tasklist_button_popover_on_pin_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void _icon_tasklist_button_popover_on_new_instance_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                               gpointer self);
static void icon_tasklist_button_popover_finalize (GObject * obj);
static void _vala_icon_tasklist_button_popover_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_icon_tasklist_button_popover_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void window_controls_build_workspace_buttons (WindowControls* self,
                                              GtkListBox* list_box);
VALA_EXTERN XfwWindow* window_controls_get_window (WindowControls* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ____lambda14_ (Block4Data* _data4_);
static void _____lambda14__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static void window_controls_update_maximize_label (WindowControls* self);
static void window_controls_set_window (WindowControls* self,
                                 XfwWindow* value);
static GObject * window_controls_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _window_controls___lambda15_ (WindowControls* self);
static void __window_controls___lambda15__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _window_controls___lambda16_ (WindowControls* self);
static void __window_controls___lambda16__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _window_controls___lambda17_ (WindowControls* self);
static void __window_controls___lambda17__gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _window_controls___lambda18_ (WindowControls* self,
                                   XfwWindowState changed_mask,
                                   XfwWindowState new_state);
static void __window_controls___lambda18__libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                                           XfwWindowState changed_mask,
                                                                           XfwWindowState new_state,
                                                                           gpointer self);
static void window_controls_finalize (GObject * obj);
static void _vala_window_controls_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_window_controls_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void window_item_set_window (WindowItem* self,
                             XfwWindow* value);
static GObject * window_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _window_item___lambda9_ (WindowItem* self);
static void __window_item___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void _window_item___lambda10_ (WindowItem* self);
static void __window_item___lambda10__gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self);
static void _window_item___lambda11_ (WindowItem* self);
static void __window_item___lambda11__gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self);
static void _window_item___lambda12_ (WindowItem* self);
static void __window_item___lambda12__libxfce4windowing_window_name_changed (XfwWindow* _sender,
                                                                      gpointer self);
static void window_item_finalize (GObject * obj);
static void _vala_window_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_window_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo * const _settings_remote_dbus_arg_info_Close_in[] = {NULL};
static const GDBusArgInfo * const _settings_remote_dbus_arg_info_Close_out[] = {NULL};
static const GDBusMethodInfo _settings_remote_dbus_method_info_Close = {-1, "Close", (GDBusArgInfo **) (&_settings_remote_dbus_arg_info_Close_in), (GDBusArgInfo **) (&_settings_remote_dbus_arg_info_Close_out), NULL};
static const GDBusMethodInfo * const _settings_remote_dbus_method_info[] = {&_settings_remote_dbus_method_info_Close, NULL};
static const GDBusSignalInfo * const _settings_remote_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _settings_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _settings_remote_dbus_interface_info = {-1, "org.budgie_desktop.Settings", (GDBusMethodInfo **) (&_settings_remote_dbus_method_info), (GDBusSignalInfo **) (&_settings_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_settings_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _settings_remote_dbus_interface_vtable = {settings_remote_dbus_interface_method_call, settings_remote_dbus_interface_get_property, settings_remote_dbus_interface_set_property};

void
settings_remote_Close (SettingsRemote* self,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	SettingsRemoteIface* _iface_;
	_iface_ = SETTINGS_REMOTE_GET_INTERFACE (self);
	if (_iface_->Close) {
		_iface_->Close (self, _callback_, _user_data_);
	}
}

void
settings_remote_Close_finish (SettingsRemote* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	SettingsRemoteIface* _iface_;
	_iface_ = SETTINGS_REMOTE_GET_INTERFACE (self);
	if (_iface_->Close_finish) {
		_iface_->Close_finish (self, _res_, error);
	}
}

static void
settings_remote_default_init (SettingsRemoteIface * iface,
                              gpointer iface_data)
{
}

GType
settings_remote_get_type (void)
{
	return settings_remote_type_id;
}

GType
settings_remote_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	settings_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SettingsRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (settings_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (settings_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) settings_remote_proxy_get_type);
	g_type_set_qdata (settings_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Settings");
	g_type_set_qdata (settings_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_settings_remote_dbus_interface_info));
	g_type_set_qdata (settings_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) settings_remote_register_object);
	return settings_remote_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (SettingsRemoteProxy, settings_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_SETTINGS_REMOTE, settings_remote_proxy_settings_remote_interface_init) )
static void
settings_remote_proxy_class_init (SettingsRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = settings_remote_proxy_g_signal;
}

static void
settings_remote_proxy_g_signal (GDBusProxy* proxy,
                                const gchar* sender_name,
                                const gchar* signal_name,
                                GVariant* parameters)
{
}

static void
settings_remote_proxy_class_finalize (SettingsRemoteProxyClass* klass)
{
}

void
settings_remote_proxy_register_dynamic_type (GTypeModule* module)
{
	settings_remote_proxy_register_type (module);
}

static void
settings_remote_proxy_init (SettingsRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_settings_remote_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
settings_remote_proxy_Close_async (SettingsRemote* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Settings", "Close");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
settings_remote_proxy_Close_finish (SettingsRemote* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
settings_remote_proxy_settings_remote_interface_init (SettingsRemoteIface* iface)
{
	iface->Close = settings_remote_proxy_Close_async;
	iface->Close_finish = settings_remote_proxy_Close_finish;
}

static void
_dbus_settings_remote_Close (SettingsRemote* self,
                             GVariant* _parameters_,
                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	settings_remote_CloseReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (settings_remote_CloseReadyData);
	_ready_data->_invocation_ = invocation;
	settings_remote_Close (self, (GAsyncReadyCallback) _dbus_settings_remote_Close_ready, _ready_data);
}

static void
_dbus_settings_remote_Close_ready (GObject * source_object,
                                   GAsyncResult * _res_,
                                   gpointer _user_data_)
{
	settings_remote_CloseReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	settings_remote_Close_finish ((SettingsRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (settings_remote_CloseReadyData, _ready_data);
}

static void
settings_remote_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Close") == 0) {
		_dbus_settings_remote_Close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
settings_remote_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
settings_remote_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
settings_remote_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_settings_remote_dbus_interface_info), &_settings_remote_dbus_interface_vtable, data, _settings_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_settings_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
icon_tasklist_button_popover_get_instance_private (IconTasklistButtonPopover* self)
{
	return G_STRUCT_MEMBER_P (self, IconTasklistButtonPopover_private_offset);
}

IconTasklistButtonPopover*
icon_tasklist_button_popover_construct (GType object_type,
                                        IconButton* button,
                                        BudgieApplication* app,
                                        BudgieWindowingWindowGroup* group)
{
	IconTasklistButtonPopover * self = NULL;
	g_return_val_if_fail (button != NULL, NULL);
	self = (IconTasklistButtonPopover*) g_object_new (object_type, "relative-to", button, "app", app, "group", group, NULL);
	return self;
}

IconTasklistButtonPopover*
icon_tasklist_button_popover_new (IconButton* button,
                                  BudgieApplication* app,
                                  BudgieWindowingWindowGroup* group)
{
	return icon_tasklist_button_popover_construct (TYPE_ICON_TASKLIST_BUTTON_POPOVER, button, app, group);
}

static void
icon_tasklist_button_popover_on_pin_clicked (IconTasklistButtonPopover* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = icon_tasklist_button_popover_get_pinned (self);
	_tmp1_ = _tmp0_;
	icon_tasklist_button_popover_set_pinned (self, !_tmp1_);
}

static void
icon_tasklist_button_popover_on_new_instance_clicked (IconTasklistButtonPopover* self)
{
	BudgieApplication* _tmp0_;
	BudgieApplication* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_app;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_app;
	budgie_application_launch (_tmp1_);
	gtk_widget_hide ((GtkWidget*) self);
}

static void
icon_tasklist_button_popover_on_close_all_clicked (IconTasklistButtonPopover* self)
{
	GList* windows = NULL;
	BudgieWindowingWindowGroup* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_group;
	_tmp1_ = budgie_windowing_window_group_get_windows (_tmp0_);
	windows = _tmp1_;
	_tmp2_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			XfwWindow* window = NULL;
			window = (XfwWindow*) window_it->data;
			{
				{
					XfwWindow* _tmp3_;
					_tmp3_ = window;
					xfw_window_close (_tmp3_, (guint64) gtk_get_current_event_time (), &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					XfwWindow* _tmp4_;
					const gchar* _tmp5_;
					GError* _tmp6_;
					const gchar* _tmp7_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp4_ = window;
					_tmp5_ = xfw_window_get_name (_tmp4_);
					_tmp6_ = e;
					_tmp7_ = _tmp6_->message;
					g_warning ("ButtonPopover.vala:169: Unable to close window '%s': %s", _tmp5_, _tmp7_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
	gtk_widget_hide ((GtkWidget*) self);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
icon_tasklist_button_popover_real_hide (GtkWidget* base)
{
	IconTasklistButtonPopover * self;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	self = (IconTasklistButtonPopover*) base;
	GTK_WIDGET_CLASS (icon_tasklist_button_popover_parent_class)->hide ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_popover_get_type (), GtkPopover));
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "main") != 0) {
		GtkWidget* page = NULL;
		GtkStack* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		GtkStack* _tmp5_;
		GtkStack* _tmp6_;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		page = _tmp4_;
		_tmp5_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp5_, "main");
		_tmp6_ = self->priv->stack;
		_tmp7_ = page;
		gtk_container_remove ((GtkContainer*) _tmp6_, _tmp7_);
		_tmp8_ = page;
		gtk_widget_destroy (_tmp8_);
		_g_object_unref0 (page);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		IconTasklistButtonPopover* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->window);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		IconTasklistButtonPopover* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->controls_layout);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda19_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	IconTasklistButtonPopover* self;
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	WindowControls* _tmp2_;
	WindowControls* _tmp3_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "main");
	_tmp1_ = self->priv->stack;
	_tmp2_ = _data2_->controls_layout;
	gtk_container_remove ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = _data2_->controls_layout;
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
}

static void
___lambda19__window_controls_return_clicked (WindowControls* _sender,
                                             gpointer self)
{
	__lambda19_ (self);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
__lambda13_ (Block1Data* _data1_)
{
	IconTasklistButtonPopover* self;
	Block2Data* _data2_;
	WindowControls* _tmp0_;
	WindowControls* _tmp1_;
	gchar** class_ids = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint class_ids_length1;
	gint _class_ids_size_;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* id = NULL;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GtkStack* _tmp12_;
	WindowControls* _tmp13_;
	const gchar* _tmp14_;
	GtkStack* _tmp15_;
	const gchar* _tmp16_;
	self = _data1_->self;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->_data1_ = block1_data_ref (_data1_);
	_tmp0_ = window_controls_new (_data1_->window);
	g_object_ref_sink (_tmp0_);
	_data2_->controls_layout = _tmp0_;
	_tmp1_ = _data2_->controls_layout;
	g_signal_connect_data (_tmp1_, "return-clicked", (GCallback) ___lambda19__window_controls_return_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp3_ = _tmp2_ = xfw_window_get_class_ids (_data1_->window);
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _vala_array_length (_tmp2_)) : _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	class_ids = _tmp4_;
	class_ids_length1 = _tmp4__length1;
	_class_ids_size_ = class_ids_length1;
	_tmp6_ = class_ids;
	_tmp6__length1 = class_ids_length1;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = class_ids;
		_tmp7__length1 = class_ids_length1;
		_tmp5_ = _tmp7__length1 == 0;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		_tmp8_ = xfw_window_get_name (_data1_->window);
		g_warning ("ButtonPopover.vala:201: Window '%s' has no class IDs", _tmp8_);
		class_ids = (_vala_array_free (class_ids, class_ids_length1, (GDestroyNotify) g_free), NULL);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp9_ = class_ids;
	_tmp9__length1 = class_ids_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = g_strdup (_tmp10_);
	id = _tmp11_;
	_tmp12_ = self->priv->stack;
	_tmp13_ = _data2_->controls_layout;
	_tmp14_ = id;
	gtk_stack_add_named (_tmp12_, (GtkWidget*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->stack;
	_tmp16_ = id;
	gtk_stack_set_visible_child_name (_tmp15_, _tmp16_);
	_g_free0 (id);
	class_ids = (_vala_array_free (class_ids, class_ids_length1, (GDestroyNotify) g_free), NULL);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
___lambda13__window_item_page_switch_clicked (WindowItem* _sender,
                                              gpointer self)
{
	__lambda13_ (self);
}

void
icon_tasklist_button_popover_add_window (IconTasklistButtonPopover* self,
                                         XfwWindow* window)
{
	Block1Data* _data1_;
	XfwWindow* _tmp0_;
	WindowItem* window_item = NULL;
	WindowItem* _tmp1_;
	GtkListBox* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data1_->window);
	_data1_->window = _tmp0_;
	_tmp1_ = window_item_new (_data1_->window);
	g_object_ref_sink (_tmp1_);
	window_item = _tmp1_;
	g_signal_connect_data (window_item, "page-switch-clicked", (GCallback) ___lambda13__window_item_page_switch_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp2_ = self->priv->windows;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) window_item);
	_g_object_unref0 (window_item);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
icon_tasklist_button_popover_remove_window (IconTasklistButtonPopover* self,
                                            XfwWindow* window)
{
	gchar** class_ids = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint class_ids_length1;
	gint _class_ids_size_;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* window_id = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	WindowItem* window_item = NULL;
	GtkListBox* _tmp10_;
	GList* _tmp11_;
	WindowItem* _tmp28_;
	WindowItem* _tmp29_;
	gchar* id = NULL;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GtkStack* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GtkWidget* controls_layout = NULL;
	GtkStack* _tmp37_;
	const gchar* _tmp38_;
	GtkWidget* _tmp39_;
	GtkWidget* _tmp40_;
	GtkWidget* _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp1_ = _tmp0_ = xfw_window_get_class_ids (window);
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup2 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	class_ids = _tmp2_;
	class_ids_length1 = _tmp2__length1;
	_class_ids_size_ = class_ids_length1;
	_tmp4_ = class_ids;
	_tmp4__length1 = class_ids_length1;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = class_ids;
		_tmp5__length1 = class_ids_length1;
		_tmp3_ = _tmp5__length1 == 0;
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		_tmp6_ = xfw_window_get_name (window);
		g_warning ("ButtonPopover.vala:216: Window '%s' has no class IDs in remove_window", _tmp6_);
		class_ids = (_vala_array_free (class_ids, class_ids_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp7_ = class_ids;
	_tmp7__length1 = class_ids_length1;
	_tmp8_ = _tmp7_[0];
	_tmp9_ = g_strdup (_tmp8_);
	window_id = _tmp9_;
	window_item = NULL;
	_tmp10_ = self->priv->windows;
	_tmp11_ = gtk_container_get_children ((GtkContainer*) _tmp10_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp11_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				gchar** child_class_ids = NULL;
				GtkWidget* _tmp12_;
				XfwWindow* _tmp13_;
				XfwWindow* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				gint child_class_ids_length1;
				gint _child_class_ids_size_;
				gboolean _tmp18_ = FALSE;
				gchar** _tmp19_;
				gint _tmp19__length1;
				_tmp12_ = child;
				_tmp13_ = window_item_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_WINDOW_ITEM, WindowItem));
				_tmp14_ = _tmp13_;
				_tmp16_ = _tmp15_ = xfw_window_get_class_ids (_tmp14_);
				_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup3 (_tmp16_, _vala_array_length (_tmp15_)) : _tmp16_;
				_tmp17__length1 = _vala_array_length (_tmp15_);
				child_class_ids = _tmp17_;
				child_class_ids_length1 = _tmp17__length1;
				_child_class_ids_size_ = child_class_ids_length1;
				_tmp19_ = child_class_ids;
				_tmp19__length1 = child_class_ids_length1;
				if (_tmp19_ != NULL) {
					gchar** _tmp20_;
					gint _tmp20__length1;
					_tmp20_ = child_class_ids;
					_tmp20__length1 = child_class_ids_length1;
					_tmp18_ = _tmp20__length1 > 0;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					gchar* child_id = NULL;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = child_class_ids;
					_tmp21__length1 = child_class_ids_length1;
					_tmp22_ = _tmp21_[0];
					_tmp23_ = g_strdup (_tmp22_);
					child_id = _tmp23_;
					_tmp24_ = child_id;
					_tmp25_ = window_id;
					if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
						GtkWidget* _tmp26_;
						WindowItem* _tmp27_;
						_tmp26_ = child;
						_tmp27_ = _g_object_ref0 (IS_WINDOW_ITEM (_tmp26_) ? ((WindowItem*) _tmp26_) : NULL);
						_g_object_unref0 (window_item);
						window_item = _tmp27_;
						_g_free0 (child_id);
						child_class_ids = (_vala_array_free (child_class_ids, child_class_ids_length1, (GDestroyNotify) g_free), NULL);
						break;
					}
					_g_free0 (child_id);
				}
				child_class_ids = (_vala_array_free (child_class_ids, child_class_ids_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp28_ = window_item;
	if (_tmp28_ == NULL) {
		_g_object_unref0 (window_item);
		_g_free0 (window_id);
		class_ids = (_vala_array_free (class_ids, class_ids_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp29_ = window_item;
	gtk_widget_destroy ((GtkWidget*) _tmp29_);
	_tmp30_ = window_id;
	_tmp31_ = string_to_string (_tmp30_);
	_tmp32_ = g_strdup (_tmp31_);
	id = _tmp32_;
	_tmp33_ = self->priv->stack;
	_tmp34_ = gtk_stack_get_visible_child_name (_tmp33_);
	_tmp35_ = id;
	if (g_strcmp0 (_tmp34_, _tmp35_) == 0) {
		GtkStack* _tmp36_;
		_tmp36_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp36_, "main");
	}
	_tmp37_ = self->priv->stack;
	_tmp38_ = id;
	_tmp39_ = gtk_stack_get_child_by_name (_tmp37_, _tmp38_);
	_tmp40_ = _g_object_ref0 (_tmp39_);
	controls_layout = _tmp40_;
	_tmp41_ = controls_layout;
	if (_tmp41_ != NULL) {
		GtkStack* _tmp42_;
		GtkWidget* _tmp43_;
		GtkWidget* _tmp44_;
		_tmp42_ = self->priv->stack;
		_tmp43_ = controls_layout;
		gtk_container_remove ((GtkContainer*) _tmp42_, _tmp43_);
		_tmp44_ = controls_layout;
		gtk_widget_destroy (_tmp44_);
	}
	_g_object_unref0 (controls_layout);
	_g_free0 (id);
	_g_object_unref0 (window_item);
	_g_free0 (window_id);
	class_ids = (_vala_array_free (class_ids, class_ids_length1, (GDestroyNotify) g_free), NULL);
}

BudgieApplication*
icon_tasklist_button_popover_get_app (IconTasklistButtonPopover* self)
{
	BudgieApplication* result;
	BudgieApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app;
	result = _tmp0_;
	return result;
}

static void
icon_tasklist_button_popover_set_app (IconTasklistButtonPopover* self,
                                      BudgieApplication* value)
{
	BudgieApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_tasklist_button_popover_get_app (self);
	if (old_value != value) {
		BudgieApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app);
		self->priv->_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, icon_tasklist_button_popover_properties[ICON_TASKLIST_BUTTON_POPOVER_APP_PROPERTY]);
	}
}

BudgieWindowingWindowGroup*
icon_tasklist_button_popover_get_group (IconTasklistButtonPopover* self)
{
	BudgieWindowingWindowGroup* result;
	BudgieWindowingWindowGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_group;
	result = _tmp0_;
	return result;
}

void
icon_tasklist_button_popover_set_group (IconTasklistButtonPopover* self,
                                        BudgieWindowingWindowGroup* value)
{
	BudgieWindowingWindowGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_tasklist_button_popover_get_group (self);
	if (old_value != value) {
		BudgieWindowingWindowGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_group);
		self->priv->_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, icon_tasklist_button_popover_properties[ICON_TASKLIST_BUTTON_POPOVER_GROUP_PROPERTY]);
	}
}

gboolean
icon_tasklist_button_popover_get_pinned (IconTasklistButtonPopover* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pinned;
	return result;
}

void
icon_tasklist_button_popover_set_pinned (IconTasklistButtonPopover* self,
                                         gboolean value)
{
	GtkButton* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->_pinned = value;
	_tmp0_ = self->priv->pin_button;
	if (_tmp0_ == NULL) {
		return;
	}
	if (self->priv->_pinned) {
		_tmp1_ = _ ("Unfavorite");
	} else {
		_tmp1_ = _ ("Favorite");
	}
	_tmp2_ = self->priv->pin_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp1_);
	if (value) {
		GtkImage* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp3_ = self->priv->pin_icon;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "alert");
	} else {
		GtkImage* _tmp5_;
		GtkStyleContext* _tmp6_;
		_tmp5_ = self->priv->pin_icon;
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
		gtk_style_context_remove_class (_tmp6_, "alert");
	}
	g_object_notify_by_pspec ((GObject *) self, icon_tasklist_button_popover_properties[ICON_TASKLIST_BUTTON_POPOVER_PINNED_PROPERTY]);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		IconTasklistButtonPopover* self;
		self = _data3_->self;
		_g_free0 (_data3_->action);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_icon_tasklist_button_popover______lambda20_ (Block3Data* _data3_)
{
	IconTasklistButtonPopover* self;
	BudgieApplication* _tmp0_;
	const gchar* _tmp1_;
	self = _data3_->self;
	_tmp0_ = self->priv->_app;
	_tmp1_ = _data3_->action;
	budgie_application_launch_action (_tmp0_, _tmp1_);
	gtk_widget_hide ((GtkWidget*) self);
}

static void
__icon_tasklist_button_popover______lambda20__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	_icon_tasklist_button_popover______lambda20_ (self);
}

static void
_icon_tasklist_button_popover_on_close_all_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	icon_tasklist_button_popover_on_close_all_clicked ((IconTasklistButtonPopover*) self);
}

static void
_icon_tasklist_button_popover_on_pin_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	icon_tasklist_button_popover_on_pin_clicked ((IconTasklistButtonPopover*) self);
}

static void
_icon_tasklist_button_popover_on_new_instance_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self)
{
	icon_tasklist_button_popover_on_new_instance_clicked ((IconTasklistButtonPopover*) self);
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static GObject *
icon_tasklist_button_popover_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	IconTasklistButtonPopover * self;
	GtkStyleContext* _tmp0_;
	GtkListBox* _tmp1_ = NULL;
	BudgieApplication* _tmp2_;
	GtkListBox* _tmp24_ = NULL;
	BudgieWindowingWindowGroup* _tmp25_;
	GtkImage* _tmp29_;
	GtkImage* _tmp30_;
	GtkStyleContext* _tmp31_;
	gchar* _tmp32_;
	GtkButton* _tmp33_ = NULL;
	GtkButton* _tmp34_;
	GtkBox* button_box = NULL;
	GtkBox* _tmp35_;
	BudgieApplication* _tmp36_;
	GtkBox* _tmp50_;
	GtkButton* _tmp51_;
	GtkBox* main_layout = NULL;
	GtkBox* _tmp52_;
	GtkListBox* _tmp53_;
	GList* _tmp54_;
	GList* _tmp55_;
	gboolean _tmp56_;
	GtkBox* _tmp62_;
	GtkListBox* _tmp63_;
	GtkBox* _tmp64_;
	GtkBox* _tmp65_;
	GtkStack* _tmp66_ = NULL;
	GtkStack* _tmp67_;
	GtkBox* _tmp68_;
	GtkStack* _tmp69_;
	GtkStyleContext* _tmp70_;
	GtkStack* _tmp71_;
	GtkStack* _tmp72_;
	parent_class = G_OBJECT_CLASS (icon_tasklist_button_popover_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_TASKLIST_BUTTON_POPOVER, IconTasklistButtonPopover);
	g_object_set ((GtkWidget*) self, "width-request", 200, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "icon-popover");
	_tmp1_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp1_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->desktop_actions);
	self->priv->desktop_actions = _tmp1_;
	_tmp2_ = self->priv->_app;
	if (_tmp2_ != NULL) {
		GDesktopAppInfo* app_info = NULL;
		BudgieApplication* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GDesktopAppInfo* _tmp6_;
		BudgieApplication* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_ = 0;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp3_ = self->priv->_app;
		_tmp4_ = budgie_application_get_desktop_id (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_desktop_app_info_new (_tmp5_);
		app_info = _tmp6_;
		_tmp7_ = self->priv->_app;
		_tmp8_ = budgie_application_get_actions (_tmp7_, &_tmp9_);
		_tmp8__length1 = _tmp9_;
		_tmp10_ = _tmp8_;
		_tmp10__length1 = _tmp8__length1;
		{
			gchar** action_collection = NULL;
			gint action_collection_length1 = 0;
			gint _action_collection_size_ = 0;
			gint action_it = 0;
			action_collection = _tmp10_;
			action_collection_length1 = _tmp10__length1;
			for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
				gchar* _tmp11_;
				gchar* action = NULL;
				_tmp11_ = g_strdup (action_collection[action_it]);
				action = _tmp11_;
				{
					Block3Data* _data3_;
					gchar* action_label = NULL;
					GDesktopAppInfo* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					GtkButton* action_button = NULL;
					const gchar* _tmp15_;
					GtkButton* _tmp16_ = NULL;
					GtkLabel* label = NULL;
					GtkButton* _tmp17_;
					GtkWidget* _tmp18_;
					GtkLabel* _tmp19_;
					GtkLabel* _tmp20_;
					GtkButton* _tmp21_;
					GtkListBox* _tmp22_;
					GtkButton* _tmp23_;
					_data3_ = g_slice_new0 (Block3Data);
					_data3_->_ref_count_ = 1;
					_data3_->self = g_object_ref (self);
					_data3_->action = action;
					_tmp12_ = app_info;
					_tmp13_ = _data3_->action;
					_tmp14_ = g_desktop_app_info_get_action_name (_tmp12_, _tmp13_);
					action_label = _tmp14_;
					_tmp15_ = action_label;
					_tmp16_ = (GtkButton*) gtk_button_new_with_label (_tmp15_);
					gtk_button_set_relief (_tmp16_, GTK_RELIEF_NONE);
					g_object_ref_sink (_tmp16_);
					action_button = _tmp16_;
					_tmp17_ = action_button;
					_tmp18_ = gtk_bin_get_child ((GtkBin*) _tmp17_);
					_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp18_) : NULL);
					label = _tmp19_;
					_tmp20_ = label;
					gtk_label_set_xalign (_tmp20_, (gfloat) 0);
					_tmp21_ = action_button;
					g_signal_connect_data (_tmp21_, "clicked", (GCallback) __icon_tasklist_button_popover______lambda20__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_tmp22_ = self->priv->desktop_actions;
					_tmp23_ = action_button;
					gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
					_g_object_unref0 (label);
					_g_object_unref0 (action_button);
					_g_free0 (action_label);
					block3_data_unref (_data3_);
					_data3_ = NULL;
				}
			}
		}
		_g_object_unref0 (app_info);
	}
	_tmp24_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp24_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->windows);
	self->priv->windows = _tmp24_;
	_tmp25_ = self->priv->_group;
	if (_tmp25_ != NULL) {
		BudgieWindowingWindowGroup* _tmp26_;
		GList* _tmp27_;
		_tmp26_ = self->priv->_group;
		_tmp27_ = budgie_windowing_window_group_get_windows (_tmp26_);
		{
			GList* window_collection = NULL;
			GList* window_it = NULL;
			window_collection = _tmp27_;
			for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
				XfwWindow* window = NULL;
				window = (XfwWindow*) window_it->data;
				{
					XfwWindow* _tmp28_;
					_tmp28_ = window;
					icon_tasklist_button_popover_add_window (self, _tmp28_);
				}
			}
			(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
		}
	}
	_tmp29_ = (GtkImage*) gtk_image_new_from_icon_name ("budgie-emblem-favorite-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->pin_icon);
	self->priv->pin_icon = _tmp29_;
	_tmp30_ = self->priv->pin_icon;
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) _tmp30_);
	gtk_style_context_add_class (_tmp31_, "icon-popover-pin");
	_tmp32_ = g_strdup (_ ("Close all windows"));
	_tmp33_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-all-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp33_, _tmp32_);
	_g_free0 (_tmp32_);
	gtk_button_set_relief (_tmp33_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->close_all_button);
	self->priv->close_all_button = _tmp33_;
	_tmp34_ = self->priv->close_all_button;
	g_signal_connect_object (_tmp34_, "clicked", (GCallback) _icon_tasklist_button_popover_on_close_all_clicked_gtk_button_clicked, self, 0);
	_tmp35_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp35_);
	button_box = _tmp35_;
	_tmp36_ = self->priv->_app;
	if (_tmp36_ != NULL) {
		const gchar* _tmp37_ = NULL;
		GtkImage* _tmp38_;
		GtkWidget* _tmp39_;
		gchar* _tmp40_;
		GtkButton* _tmp41_ = NULL;
		GtkButton* _tmp42_;
		gchar* _tmp43_;
		GtkButton* _tmp44_ = NULL;
		GtkButton* _tmp45_;
		GtkBox* _tmp46_;
		GtkButton* _tmp47_;
		GtkBox* _tmp48_;
		GtkButton* _tmp49_;
		if (self->priv->_pinned) {
			_tmp37_ = _ ("Unfavorite");
		} else {
			_tmp37_ = _ ("Favorite");
		}
		_tmp38_ = self->priv->pin_icon;
		_tmp39_ = _g_object_ref0 ((GtkWidget*) _tmp38_);
		_tmp40_ = g_strdup (_tmp37_);
		_tmp41_ = (GtkButton*) gtk_button_new ();
		gtk_button_set_image (_tmp41_, _tmp39_);
		_g_object_unref0 (_tmp39_);
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp41_, _tmp40_);
		_g_free0 (_tmp40_);
		gtk_button_set_relief (_tmp41_, GTK_RELIEF_NONE);
		g_object_ref_sink (_tmp41_);
		_g_object_unref0 (self->priv->pin_button);
		self->priv->pin_button = _tmp41_;
		_tmp42_ = self->priv->pin_button;
		g_signal_connect_object (_tmp42_, "clicked", (GCallback) _icon_tasklist_button_popover_on_pin_clicked_gtk_button_clicked, self, 0);
		_tmp43_ = g_strdup (_ ("Launch new instance"));
		_tmp44_ = (GtkButton*) gtk_button_new_from_icon_name ("window-new-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp44_, _tmp43_);
		_g_free0 (_tmp43_);
		gtk_button_set_relief (_tmp44_, GTK_RELIEF_NONE);
		g_object_ref_sink (_tmp44_);
		_g_object_unref0 (self->priv->new_instance_button);
		self->priv->new_instance_button = _tmp44_;
		_tmp45_ = self->priv->new_instance_button;
		g_signal_connect_object (_tmp45_, "clicked", (GCallback) _icon_tasklist_button_popover_on_new_instance_clicked_gtk_button_clicked, self, 0);
		_tmp46_ = button_box;
		_tmp47_ = self->priv->pin_button;
		gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, TRUE, TRUE, (guint) 0);
		_tmp48_ = button_box;
		_tmp49_ = self->priv->new_instance_button;
		gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, TRUE, TRUE, (guint) 0);
	}
	_tmp50_ = button_box;
	_tmp51_ = self->priv->close_all_button;
	gtk_box_pack_start (_tmp50_, (GtkWidget*) _tmp51_, TRUE, TRUE, (guint) 0);
	_tmp52_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp52_);
	main_layout = _tmp52_;
	_tmp53_ = self->priv->desktop_actions;
	_tmp54_ = gtk_container_get_children ((GtkContainer*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = !vala_g_list_is_empty (_tmp55_);
	(_tmp55_ == NULL) ? NULL : (_tmp55_ = (g_list_free (_tmp55_), NULL));
	if (_tmp56_) {
		GtkSeparator* separator = NULL;
		GtkSeparator* _tmp57_;
		GtkBox* _tmp58_;
		GtkListBox* _tmp59_;
		GtkBox* _tmp60_;
		GtkSeparator* _tmp61_;
		_tmp57_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp57_);
		separator = _tmp57_;
		_tmp58_ = main_layout;
		_tmp59_ = self->priv->desktop_actions;
		gtk_box_pack_start (_tmp58_, (GtkWidget*) _tmp59_, TRUE, TRUE, (guint) 0);
		_tmp60_ = main_layout;
		_tmp61_ = separator;
		gtk_box_pack_start (_tmp60_, (GtkWidget*) _tmp61_, TRUE, TRUE, (guint) 0);
		_g_object_unref0 (separator);
	}
	_tmp62_ = main_layout;
	_tmp63_ = self->priv->windows;
	gtk_box_pack_start (_tmp62_, (GtkWidget*) _tmp63_, TRUE, TRUE, (guint) 0);
	_tmp64_ = main_layout;
	_tmp65_ = button_box;
	gtk_box_pack_start (_tmp64_, (GtkWidget*) _tmp65_, TRUE, TRUE, (guint) 0);
	_tmp66_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp66_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp66_;
	_tmp67_ = self->priv->stack;
	_tmp68_ = main_layout;
	gtk_stack_add_named (_tmp67_, (GtkWidget*) _tmp68_, "main");
	_tmp69_ = self->priv->stack;
	_tmp70_ = gtk_widget_get_style_context ((GtkWidget*) _tmp69_);
	gtk_style_context_add_class (_tmp70_, "icon-popover-stack");
	_tmp71_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp71_);
	_tmp72_ = self->priv->stack;
	gtk_widget_show_all ((GtkWidget*) _tmp72_);
	_g_object_unref0 (main_layout);
	_g_object_unref0 (button_box);
	return obj;
}

static void
icon_tasklist_button_popover_class_init (IconTasklistButtonPopoverClass * klass,
                                         gpointer klass_data)
{
	icon_tasklist_button_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &IconTasklistButtonPopover_private_offset);
	((GtkWidgetClass *) klass)->hide = (void (*) (GtkWidget*)) icon_tasklist_button_popover_real_hide;
	G_OBJECT_CLASS (klass)->get_property = _vala_icon_tasklist_button_popover_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_icon_tasklist_button_popover_set_property;
	G_OBJECT_CLASS (klass)->constructor = icon_tasklist_button_popover_constructor;
	G_OBJECT_CLASS (klass)->finalize = icon_tasklist_button_popover_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_TASKLIST_BUTTON_POPOVER_APP_PROPERTY, icon_tasklist_button_popover_properties[ICON_TASKLIST_BUTTON_POPOVER_APP_PROPERTY] = g_param_spec_object ("app", "app", "app", BUDGIE_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_TASKLIST_BUTTON_POPOVER_GROUP_PROPERTY, icon_tasklist_button_popover_properties[ICON_TASKLIST_BUTTON_POPOVER_GROUP_PROPERTY] = g_param_spec_object ("group", "group", "group", BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_TASKLIST_BUTTON_POPOVER_PINNED_PROPERTY, icon_tasklist_button_popover_properties[ICON_TASKLIST_BUTTON_POPOVER_PINNED_PROPERTY] = g_param_spec_boolean ("pinned", "pinned", "pinned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
icon_tasklist_button_popover_instance_init (IconTasklistButtonPopover * self,
                                            gpointer klass)
{
	self->priv = icon_tasklist_button_popover_get_instance_private (self);
	self->priv->_pinned = FALSE;
}

static void
icon_tasklist_button_popover_finalize (GObject * obj)
{
	IconTasklistButtonPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_TASKLIST_BUTTON_POPOVER, IconTasklistButtonPopover);
	_g_object_unref0 (self->priv->_app);
	_g_object_unref0 (self->priv->_group);
	_g_object_unref0 (self->priv->pin_icon);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->desktop_actions);
	_g_object_unref0 (self->priv->windows);
	_g_object_unref0 (self->priv->pin_button);
	_g_object_unref0 (self->priv->new_instance_button);
	_g_object_unref0 (self->priv->close_all_button);
	G_OBJECT_CLASS (icon_tasklist_button_popover_parent_class)->finalize (obj);
}

GType
icon_tasklist_button_popover_get_type (void)
{
	return icon_tasklist_button_popover_type_id;
}

GType
icon_tasklist_button_popover_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistButtonPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_button_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklistButtonPopover), 0, (GInstanceInitFunc) icon_tasklist_button_popover_instance_init, NULL };
	icon_tasklist_button_popover_type_id = g_type_module_register_type (module, gtk_popover_get_type (), "IconTasklistButtonPopover", &g_define_type_info, 0);
	IconTasklistButtonPopover_private_offset = sizeof (IconTasklistButtonPopoverPrivate);
	return icon_tasklist_button_popover_type_id;
}

static void
_vala_icon_tasklist_button_popover_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	IconTasklistButtonPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_TASKLIST_BUTTON_POPOVER, IconTasklistButtonPopover);
	switch (property_id) {
		case ICON_TASKLIST_BUTTON_POPOVER_APP_PROPERTY:
		g_value_set_object (value, icon_tasklist_button_popover_get_app (self));
		break;
		case ICON_TASKLIST_BUTTON_POPOVER_GROUP_PROPERTY:
		g_value_set_object (value, icon_tasklist_button_popover_get_group (self));
		break;
		case ICON_TASKLIST_BUTTON_POPOVER_PINNED_PROPERTY:
		g_value_set_boolean (value, icon_tasklist_button_popover_get_pinned (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_icon_tasklist_button_popover_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	IconTasklistButtonPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_TASKLIST_BUTTON_POPOVER, IconTasklistButtonPopover);
	switch (property_id) {
		case ICON_TASKLIST_BUTTON_POPOVER_APP_PROPERTY:
		icon_tasklist_button_popover_set_app (self, g_value_get_object (value));
		break;
		case ICON_TASKLIST_BUTTON_POPOVER_GROUP_PROPERTY:
		icon_tasklist_button_popover_set_group (self, g_value_get_object (value));
		break;
		case ICON_TASKLIST_BUTTON_POPOVER_PINNED_PROPERTY:
		icon_tasklist_button_popover_set_pinned (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
window_controls_get_instance_private (WindowControls* self)
{
	return G_STRUCT_MEMBER_P (self, WindowControls_private_offset);
}

WindowControls*
window_controls_construct (GType object_type,
                           XfwWindow* window)
{
	WindowControls * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (WindowControls*) g_object_new (object_type, "window", window, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	return self;
}

WindowControls*
window_controls_new (XfwWindow* window)
{
	return window_controls_construct (TYPE_WINDOW_CONTROLS, window);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		WindowControls* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->workspace);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
____lambda14_ (Block4Data* _data4_)
{
	WindowControls* self;
	XfwWorkspace* _tmp0_;
	XfwWindow* _tmp1_;
	XfwWorkspace* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->workspace;
	_tmp1_ = self->priv->_window;
	_tmp2_ = xfw_window_get_workspace (_tmp1_);
	if (_tmp0_ == _tmp2_) {
		return;
	}
	{
		XfwWindow* _tmp3_;
		XfwWorkspace* _tmp4_;
		_tmp3_ = self->priv->_window;
		_tmp4_ = _data4_->workspace;
		xfw_window_move_to_workspace (_tmp3_, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = self->priv->_window;
		_tmp6_ = xfw_window_get_name (_tmp5_);
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("ButtonPopover.vala:355: Unable to move window '%s' to new workspace: %" \
"s", _tmp6_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda14__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
	____lambda14_ (self);
}

static void
window_controls_build_workspace_buttons (WindowControls* self,
                                         GtkListBox* list_box)
{
	XfwWorkspace* current_workspace = NULL;
	XfwWindow* _tmp0_;
	XfwWorkspace* _tmp1_;
	XfwWorkspace* _tmp2_;
	XfwWorkspaceGroup* workspace_group = NULL;
	XfwWorkspace* _tmp3_;
	XfwWorkspaceGroup* _tmp4_;
	XfwWorkspaceGroup* _tmp5_;
	XfwWorkspaceGroup* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list_box != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = xfw_window_get_workspace (_tmp0_);
	current_workspace = _tmp1_;
	_tmp2_ = current_workspace;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = current_workspace;
	_tmp4_ = xfw_workspace_get_workspace_group (_tmp3_);
	workspace_group = _tmp4_;
	_tmp5_ = workspace_group;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = workspace_group;
	_tmp7_ = xfw_workspace_group_list_workspaces (_tmp6_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp7_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			XfwWorkspace* _tmp8_;
			XfwWorkspace* workspace = NULL;
			_tmp8_ = _g_object_ref0 ((XfwWorkspace*) workspace_it->data);
			workspace = _tmp8_;
			{
				Block4Data* _data4_;
				GtkButton* button = NULL;
				XfwWorkspace* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GtkButton* _tmp13_ = NULL;
				GtkButton* _tmp14_;
				GtkLabel* button_label = NULL;
				GtkButton* _tmp15_;
				GtkWidget* _tmp16_;
				GtkLabel* _tmp17_;
				GtkLabel* _tmp18_;
				GtkButton* _tmp19_;
				GtkButton* _tmp20_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->self = g_object_ref (self);
				_data4_->workspace = workspace;
				_tmp9_ = _data4_->workspace;
				_tmp10_ = xfw_workspace_get_name (_tmp9_);
				_tmp11_ = g_strdup_printf (_ ("Move to %s"), _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = (GtkButton*) gtk_button_new_with_label (_tmp12_);
				gtk_button_set_relief (_tmp13_, GTK_RELIEF_NONE);
				g_object_ref_sink (_tmp13_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				button = _tmp14_;
				_tmp15_ = button;
				_tmp16_ = gtk_bin_get_child ((GtkBin*) _tmp15_);
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp16_) : NULL);
				button_label = _tmp17_;
				_tmp18_ = button_label;
				gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
				_tmp19_ = button;
				g_signal_connect_data (_tmp19_, "clicked", (GCallback) _____lambda14__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
				_tmp20_ = button;
				gtk_container_add ((GtkContainer*) list_box, (GtkWidget*) _tmp20_);
				_g_object_unref0 (button_label);
				_g_object_unref0 (button);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
}

static void
window_controls_update_maximize_label (WindowControls* self)
{
	const gchar* _tmp0_ = NULL;
	XfwWindow* _tmp1_;
	GtkButton* _tmp2_;
	GtkLabel* maximize_button_label = NULL;
	GtkButton* _tmp3_;
	GtkWidget* _tmp4_;
	GtkLabel* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_window;
	if (xfw_window_is_maximized (_tmp1_)) {
		_tmp0_ = _ ("Unmaximize");
	} else {
		_tmp0_ = _ ("Maximize");
	}
	_tmp2_ = self->priv->maximize_button;
	gtk_button_set_label (_tmp2_, _tmp0_);
	_tmp3_ = self->priv->maximize_button;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp4_) : NULL);
	maximize_button_label = _tmp5_;
	gtk_widget_set_halign ((GtkWidget*) maximize_button_label, GTK_ALIGN_START);
	_g_object_unref0 (maximize_button_label);
}

XfwWindow*
window_controls_get_window (WindowControls* self)
{
	XfwWindow* result;
	XfwWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
window_controls_set_window (WindowControls* self,
                            XfwWindow* value)
{
	XfwWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = window_controls_get_window (self);
	if (old_value != value) {
		XfwWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, window_controls_properties[WINDOW_CONTROLS_WINDOW_PROPERTY]);
	}
}

static void
_window_controls___lambda15_ (WindowControls* self)
{
	gboolean maximized = FALSE;
	XfwWindow* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->_window;
	maximized = xfw_window_is_maximized (_tmp0_);
	{
		XfwWindow* _tmp1_;
		_tmp1_ = self->priv->_window;
		xfw_window_set_maximized (_tmp1_, !maximized, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->priv->_window;
		_tmp3_ = xfw_window_get_name (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ButtonPopover.vala:303: Unable to set maximized on window %s: %s", _tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__window_controls___lambda15__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	_window_controls___lambda15_ ((WindowControls*) self);
}

static void
_window_controls___lambda16_ (WindowControls* self)
{
	GError* _inner_error0_ = NULL;
	{
		XfwWindow* _tmp0_;
		_tmp0_ = self->priv->_window;
		xfw_window_set_minimized (_tmp0_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = self->priv->_window;
		_tmp2_ = xfw_window_get_name (_tmp1_);
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("ButtonPopover.vala:311: Unable to set minimized on window %s: %s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__window_controls___lambda16__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	_window_controls___lambda16_ ((WindowControls*) self);
}

static void
_window_controls___lambda17_ (WindowControls* self)
{
	g_signal_emit (self, window_controls_signals[WINDOW_CONTROLS_RETURN_CLICKED_SIGNAL], 0);
}

static void
__window_controls___lambda17__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	_window_controls___lambda17_ ((WindowControls*) self);
}

static void
_window_controls___lambda18_ (WindowControls* self,
                              XfwWindowState changed_mask,
                              XfwWindowState new_state)
{
	if ((changed_mask & XFW_WINDOW_STATE_MAXIMIZED) == XFW_WINDOW_STATE_MAXIMIZED) {
		window_controls_update_maximize_label (self);
	}
}

static void
__window_controls___lambda18__libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                                      XfwWindowState changed_mask,
                                                                      XfwWindowState new_state,
                                                                      gpointer self)
{
	_window_controls___lambda18_ ((WindowControls*) self, changed_mask, new_state);
}

static GObject *
window_controls_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WindowControls * self;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkLabel* minimize_button_label = NULL;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkButton* _tmp6_ = NULL;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp7_ = NULL;
	GtkListBox* _tmp8_;
	GtkButton* _tmp9_;
	GtkListBox* _tmp10_;
	GtkButton* _tmp11_;
	GtkListBox* _tmp12_;
	GtkListBox* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	XfwWindow* _tmp18_;
	parent_class = G_OBJECT_CLASS (window_controls_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WINDOW_CONTROLS, WindowControls);
	_tmp0_ = (GtkButton*) gtk_button_new_with_label ("");
	gtk_button_set_relief (_tmp0_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->maximize_button);
	self->priv->maximize_button = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("Minimize"));
	gtk_button_set_relief (_tmp1_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->minimize_button);
	self->priv->minimize_button = _tmp1_;
	_tmp2_ = self->priv->minimize_button;
	_tmp3_ = gtk_bin_get_child ((GtkBin*) _tmp2_);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp3_) : NULL);
	minimize_button_label = _tmp4_;
	_tmp5_ = minimize_button_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_button_set_relief (_tmp6_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->return_button);
	self->priv->return_button = _tmp6_;
	_tmp7_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp7_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp7_);
	list_box = _tmp7_;
	_tmp8_ = list_box;
	_tmp9_ = self->priv->maximize_button;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = list_box;
	_tmp11_ = self->priv->minimize_button;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = list_box;
	window_controls_build_workspace_buttons (self, _tmp12_);
	_tmp13_ = list_box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
	_tmp14_ = self->priv->return_button;
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = self->priv->maximize_button;
	g_signal_connect_object (_tmp15_, "clicked", (GCallback) __window_controls___lambda15__gtk_button_clicked, self, 0);
	_tmp16_ = self->priv->minimize_button;
	g_signal_connect_object (_tmp16_, "clicked", (GCallback) __window_controls___lambda16__gtk_button_clicked, self, 0);
	_tmp17_ = self->priv->return_button;
	g_signal_connect_object (_tmp17_, "clicked", (GCallback) __window_controls___lambda17__gtk_button_clicked, self, 0);
	_tmp18_ = self->priv->_window;
	g_signal_connect_object (_tmp18_, "state-changed", (GCallback) __window_controls___lambda18__libxfce4windowing_window_state_changed, self, 0);
	window_controls_update_maximize_label (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (list_box);
	_g_object_unref0 (minimize_button_label);
	return obj;
}

static void
window_controls_class_init (WindowControlsClass * klass,
                            gpointer klass_data)
{
	window_controls_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WindowControls_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_window_controls_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_window_controls_set_property;
	G_OBJECT_CLASS (klass)->constructor = window_controls_constructor;
	G_OBJECT_CLASS (klass)->finalize = window_controls_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WINDOW_CONTROLS_WINDOW_PROPERTY, window_controls_properties[WINDOW_CONTROLS_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", xfw_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	window_controls_signals[WINDOW_CONTROLS_RETURN_CLICKED_SIGNAL] = g_signal_new ("return-clicked", TYPE_WINDOW_CONTROLS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
window_controls_instance_init (WindowControls * self,
                               gpointer klass)
{
	self->priv = window_controls_get_instance_private (self);
}

static void
window_controls_finalize (GObject * obj)
{
	WindowControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WINDOW_CONTROLS, WindowControls);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->maximize_button);
	_g_object_unref0 (self->priv->minimize_button);
	_g_object_unref0 (self->priv->return_button);
	G_OBJECT_CLASS (window_controls_parent_class)->finalize (obj);
}

GType
window_controls_get_type (void)
{
	return window_controls_type_id;
}

GType
window_controls_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WindowControlsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) window_controls_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WindowControls), 0, (GInstanceInitFunc) window_controls_instance_init, NULL };
	window_controls_type_id = g_type_module_register_type (module, gtk_box_get_type (), "WindowControls", &g_define_type_info, 0);
	WindowControls_private_offset = sizeof (WindowControlsPrivate);
	return window_controls_type_id;
}

static void
_vala_window_controls_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	WindowControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WINDOW_CONTROLS, WindowControls);
	switch (property_id) {
		case WINDOW_CONTROLS_WINDOW_PROPERTY:
		g_value_set_object (value, window_controls_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_window_controls_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	WindowControls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WINDOW_CONTROLS, WindowControls);
	switch (property_id) {
		case WINDOW_CONTROLS_WINDOW_PROPERTY:
		window_controls_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
window_item_get_instance_private (WindowItem* self)
{
	return G_STRUCT_MEMBER_P (self, WindowItem_private_offset);
}

WindowItem*
window_item_construct (GType object_type,
                       XfwWindow* window)
{
	WindowItem * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (WindowItem*) g_object_new (object_type, "window", window, NULL);
	return self;
}

WindowItem*
window_item_new (XfwWindow* window)
{
	return window_item_construct (TYPE_WINDOW_ITEM, window);
}

XfwWindow*
window_item_get_window (WindowItem* self)
{
	XfwWindow* result;
	XfwWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
window_item_set_window (WindowItem* self,
                        XfwWindow* value)
{
	XfwWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = window_item_get_window (self);
	if (old_value != value) {
		XfwWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, window_item_properties[WINDOW_ITEM_WINDOW_PROPERTY]);
	}
}

static void
_window_item___lambda9_ (WindowItem* self)
{
	GError* _inner_error0_ = NULL;
	{
		XfwWindow* _tmp0_;
		_tmp0_ = self->priv->_window;
		xfw_window_activate (_tmp0_, NULL, (guint64) gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = self->priv->_window;
		_tmp2_ = xfw_window_get_name (_tmp1_);
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("ButtonPopover.vala:424: Unable to activate window %s: %s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__window_item___lambda9__gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	_window_item___lambda9_ ((WindowItem*) self);
}

static void
_window_item___lambda10_ (WindowItem* self)
{
	GError* _inner_error0_ = NULL;
	{
		XfwWindow* _tmp0_;
		_tmp0_ = self->priv->_window;
		xfw_window_close (_tmp0_, (guint64) gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		XfwWindow* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = self->priv->_window;
		_tmp2_ = xfw_window_get_name (_tmp1_);
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("ButtonPopover.vala:432: Unable to close window %s: %s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__window_item___lambda10__gtk_button_clicked (GtkButton* _sender,
                                              gpointer self)
{
	_window_item___lambda10_ ((WindowItem*) self);
}

static void
_window_item___lambda11_ (WindowItem* self)
{
	g_signal_emit (self, window_item_signals[WINDOW_ITEM_PAGE_SWITCH_CLICKED_SIGNAL], 0);
}

static void
__window_item___lambda11__gtk_button_clicked (GtkButton* _sender,
                                              gpointer self)
{
	_window_item___lambda11_ ((WindowItem*) self);
}

static void
_window_item___lambda12_ (WindowItem* self)
{
	GtkLabel* _tmp0_;
	XfwWindow* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->name_label;
	_tmp1_ = self->priv->_window;
	_tmp2_ = xfw_window_get_name (_tmp1_);
	gtk_label_set_label (_tmp0_, _tmp2_);
}

static void
__window_item___lambda12__libxfce4windowing_window_name_changed (XfwWindow* _sender,
                                                                 gpointer self)
{
	_window_item___lambda12_ ((WindowItem*) self);
}

static GObject *
window_item_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WindowItem * self;
	XfwWindow* _tmp0_;
	const gchar* _tmp1_;
	XfwWindow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkBox* button_inner = NULL;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkLabel* _tmp9_;
	GtkButton* _tmp10_;
	GtkBox* _tmp11_;
	gchar* _tmp12_;
	GtkButton* _tmp13_ = NULL;
	gchar* _tmp14_;
	GtkButton* _tmp15_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkButton* _tmp18_;
	GtkBox* _tmp19_;
	GtkButton* _tmp20_;
	GtkBox* _tmp21_;
	GtkButton* _tmp22_;
	GtkBox* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	XfwWindow* _tmp27_;
	parent_class = G_OBJECT_CLASS (window_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WINDOW_ITEM, WindowItem);
	_tmp0_ = self->priv->_window;
	_tmp1_ = xfw_window_get_name (_tmp0_);
	_tmp2_ = self->priv->_window;
	_tmp3_ = xfw_window_get_name (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp1_);
	gtk_label_set_ellipsize (_tmp5_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	gtk_label_set_justify (_tmp5_, GTK_JUSTIFY_LEFT);
	gtk_label_set_max_width_chars (_tmp5_, 20);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp5_;
	_tmp6_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_relief (_tmp6_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->name_button);
	self->priv->name_button = _tmp6_;
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp7_);
	button_inner = _tmp7_;
	_tmp8_ = button_inner;
	_tmp9_ = self->priv->name_label;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	_tmp10_ = self->priv->name_button;
	_tmp11_ = button_inner;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = g_strdup (_ ("Close window"));
	_tmp13_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp13_, _tmp12_);
	_g_free0 (_tmp12_);
	gtk_button_set_relief (_tmp13_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp13_;
	_tmp14_ = g_strdup (_ ("Show window controls"));
	_tmp15_ = (GtkButton*) gtk_button_new_from_icon_name ("go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _tmp14_);
	_g_free0 (_tmp14_);
	gtk_button_set_relief (_tmp15_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->page_switch_button);
	self->priv->page_switch_button = _tmp15_;
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp16_);
	box = _tmp16_;
	_tmp17_ = box;
	_tmp18_ = self->priv->name_button;
	gtk_box_pack_start (_tmp17_, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = box;
	_tmp20_ = self->priv->close_button;
	gtk_box_pack_end (_tmp19_, (GtkWidget*) _tmp20_, FALSE, FALSE, (guint) 0);
	_tmp21_ = box;
	_tmp22_ = self->priv->page_switch_button;
	gtk_box_pack_end (_tmp21_, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
	_tmp23_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->name_button;
	g_signal_connect_object (_tmp24_, "clicked", (GCallback) __window_item___lambda9__gtk_button_clicked, self, 0);
	_tmp25_ = self->priv->close_button;
	g_signal_connect_object (_tmp25_, "clicked", (GCallback) __window_item___lambda10__gtk_button_clicked, self, 0);
	_tmp26_ = self->priv->page_switch_button;
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) __window_item___lambda11__gtk_button_clicked, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp27_ = self->priv->_window;
	g_signal_connect_object (_tmp27_, "name-changed", (GCallback) __window_item___lambda12__libxfce4windowing_window_name_changed, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (button_inner);
	return obj;
}

static void
window_item_class_init (WindowItemClass * klass,
                        gpointer klass_data)
{
	window_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WindowItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_window_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_window_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = window_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = window_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WINDOW_ITEM_WINDOW_PROPERTY, window_item_properties[WINDOW_ITEM_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", xfw_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	window_item_signals[WINDOW_ITEM_PAGE_SWITCH_CLICKED_SIGNAL] = g_signal_new ("page-switch-clicked", TYPE_WINDOW_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
window_item_instance_init (WindowItem * self,
                           gpointer klass)
{
	self->priv = window_item_get_instance_private (self);
}

static void
window_item_finalize (GObject * obj)
{
	WindowItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WINDOW_ITEM, WindowItem);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->page_switch_button);
	G_OBJECT_CLASS (window_item_parent_class)->finalize (obj);
}

GType
window_item_get_type (void)
{
	return window_item_type_id;
}

GType
window_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WindowItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) window_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WindowItem), 0, (GInstanceInitFunc) window_item_instance_init, NULL };
	window_item_type_id = g_type_module_register_type (module, gtk_list_box_row_get_type (), "WindowItem", &g_define_type_info, 0);
	WindowItem_private_offset = sizeof (WindowItemPrivate);
	return window_item_type_id;
}

static void
_vala_window_item_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	WindowItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WINDOW_ITEM, WindowItem);
	switch (property_id) {
		case WINDOW_ITEM_WINDOW_PROPERTY:
		g_value_set_object (value, window_item_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_window_item_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	WindowItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WINDOW_ITEM, WindowItem);
	switch (property_id) {
		case WINDOW_ITEM_WINDOW_PROPERTY:
		window_item_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

