// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNetwerkDnsMetrics_h
#define mozilla_GleanNetwerkDnsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace dns {
  /**
   * generated from dns.blocklist_count
   * The number of unusable addresses reported for each record
   * This metric was generated to correspond to the Legacy Telemetry linear histogram DNS_BLACKLIST_COUNT.
   */
  constexpr impl::CustomDistributionMetric blocklist_count(4361);

  /**
   * generated from dns.by_type_cleanup_age
   * DNS Cache Entry Age for by-type queries at Removal Time (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_CLEANUP_AGE.
   */
  constexpr impl::TimingDistributionMetric by_type_cleanup_age(4362);

  /**
   * generated from dns.by_type_failed_lookup_time
   * Time for a completed by-type resolution that has a negative answer (msec).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_FAILED_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric by_type_failed_lookup_time(4363);

  /**
   * generated from dns.by_type_premature_eviction
   * DNS Cache Entry Age for by-type queries at Removal Time of non-expired entries (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_PREMATURE_EVICTION.
   */
  constexpr impl::TimingDistributionMetric by_type_premature_eviction(4364);

  /**
   * generated from dns.by_type_succeeded_lookup_time
   * Time for a completed by-type resolution that succeeded (msec).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_SUCCEEDED_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric by_type_succeeded_lookup_time(4365);

  /**
   * generated from dns.cleanup_age
   * DNS Cache Entry Age at Removal Time (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_CLEANUP_AGE.
   */
  constexpr impl::TimingDistributionMetric cleanup_age(4366);

  /**
   * generated from dns.lookup_algorithm
   */
  enum class LookupAlgorithmLabel: uint16_t {
    eNativeonly = 0,
    eTrrrace = 1,
    eTrrfirst = 2,
    eTrronly = 3,
    eTrrshadow = 4,
    e__Other__,
  };
  /**
   * DNS: lookup algorithm
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_LOOKUP_ALGORITHM.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LookupAlgorithmLabel> lookup_algorithm(4367);

  /**
   * generated from dns.lookup_disposition
   * DNS: lookup algorithm; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_LOOKUP_DISPOSITION3.
   */
  constexpr impl::DualLabeledCounterMetric lookup_disposition(4368);

  /**
   * generated from dns.lookup_method
   * DNS Lookup Type (hit, renewal, negative-hit, literal, overflow, network-first, network-shared)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DNS_LOOKUP_METHOD2.
   */
  constexpr impl::CustomDistributionMetric lookup_method(4369);

  /**
   * generated from dns.native_lookup_time
   * Time for a completed native name resolution (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_NATIVE_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric native_lookup_time(4370);

  /**
   * generated from dns.native_queuing
   * Time in resolve queue waiting to getaddrinfo (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_NATIVE_QUEUING.
   */
  constexpr impl::TimingDistributionMetric native_queuing(4371);

  /**
   * generated from dns.premature_eviction
   * DNS Cache Entry Age at Removal Time of non-expired entries (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_PREMATURE_EVICTION.
   */
  constexpr impl::TimingDistributionMetric premature_eviction(4372);

  /**
   * generated from dns.trr_attempt_count
   * Number of times we attempted TRR for a successful lookup in TRR-first mode. Keyed by provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_ATTEMPT_COUNT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_attempt_count(4373);

  /**
   * generated from dns.trr_blacklisted
   * DNS check for TRR was blocked by blacklist; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram DNS_TRR_BLACKLISTED3.
   */
  constexpr impl::DualLabeledCounterMetric trr_blacklisted(4374);

  /**
   * generated from dns.trr_disabled
   * Resolve success rate when in TRR-first and called TRR-disabled (fall-back mode); Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram DNS_TRR_DISABLED3.
   */
  constexpr impl::DualLabeledCounterMetric trr_disabled(4375);

  /**
   * generated from dns.trr_first
   * TRR-first mode distribution. 0=Worked, 1=fell back fine after TRR fail, 2=native worked, 3=both failed; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_TRR_FIRST4.
   */
  constexpr impl::DualLabeledCounterMetric trr_first(4376);

  /**
   * generated from dns.trr_http3_0rtt_state
   */
  enum class TrrHttp30rttStateLabel: uint16_t {
    eNotUsed = 0,
    eSucceeded = 1,
    eRejected = 2,
    eConnError = 3,
    eConnClosedByNecko = 4,
    e__Other__,
  };
  /**
   * Outcome of 0-RTT usage for TRR HTTP/3 connections: - "not_used": 0RTT was not used - "succeeded": 0RTT was used and succeeded - "rejected": 0RTT was used but rejected by the server - "conn_error": 0RTT was used but connection error occurred - "conn_closed_by_necko": 0RTT was used but connection was closed by necko
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TrrHttp30rttStateLabel> trr_http3_0rtt_state(4377);

  /**
   * generated from dns.trr_http3_0rtt_state_duration
   */
  enum class TrrHttp30rttStateDurationLabel: uint16_t {
    eSucceeded = 0,
    eRejected = 1,
    eConnError = 2,
    eConnClosedByNecko = 3,
    eNotUsed = 4,
    e__Other__,
  };
  /**
   * The time a TRR HTTP/3 connection was in the 0-RTT state before transitioning to a final outcome.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrHttp30rttStateDurationLabel> trr_http3_0rtt_state_duration(4378);

  /**
   * generated from dns.trr_http_version
   * HTTP version used by DoH endpoint
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_TRR_HTTP_VERSION2.
   */
  constexpr impl::DualLabeledCounterMetric trr_http_version(4379);

  /**
   * generated from dns.trr_lookup_time
   * Time for a completed TRR resolution (msec); Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_TRR_LOOKUP_TIME3.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> trr_lookup_time(4380);

  /**
   * generated from dns.trr_ns_verfified
   * TRR managed to verify NS entry; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram DNS_TRR_NS_VERFIFIED3.
   */
  constexpr impl::DualLabeledCounterMetric trr_ns_verfified(4381);

  /**
   * generated from dns.trr_processing_time
   * Time from the last received byte of the response until we have notified the consumer with a DNS record (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_TRR_PROCESSING_TIME.
   */
  constexpr impl::TimingDistributionMetric trr_processing_time(4382);

  /**
   * generated from dns.trr_relevant_skip_reason_native_failed
   * When in TRR-first mode, if TRR was skipped and native failed, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_NATIVE_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_native_failed(4383);

  /**
   * generated from dns.trr_relevant_skip_reason_native_success
   * When in TRR-first mode, if TRR was skipped and native succeeded, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_NATIVE_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_native_success(4384);

  /**
   * generated from dns.trr_relevant_skip_reason_trr_first
   * When in TRR-first mode, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_TRR_FIRST.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_trr_first(4385);

  /**
   * generated from dns.trr_relevant_skip_reason_trr_first_type_rec
   * When in TRR-first mode, it lists the reason we may have skipped TRR for HTTPS RR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_TRR_FIRST_TYPE_REC.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_trr_first_type_rec(4386);

  /**
   * generated from dns.trr_skip_reason_native_failed
   * When in TRR-first mode, if TRR was skipped and native failed, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_NATIVE_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_native_failed(4387);

  /**
   * generated from dns.trr_skip_reason_native_success
   * When in TRR-first mode, if TRR was skipped and native succeeded, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_NATIVE_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_native_success(4388);

  /**
   * generated from dns.trr_skip_reason_retry_failed
   * When in TRR-first mode, if TRR failed once and retried unsuccessfully, it lists the reason for the first failure, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_RETRY_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_retry_failed(4389);

  /**
   * generated from dns.trr_skip_reason_retry_success
   * When in TRR-first mode, if TRR failed once and was successfully retried, it lists the reason for the first failure, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_RETRY_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_retry_success(4390);

  /**
   * generated from dns.trr_skip_reason_strict_mode
   * When in TRR-first mode, it lists the reason we may have skipped TRR. The key is like `<provider>|<skip reason of first attempt>` or just `<provider>` used when there was no second attempt.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_STRICT_MODE.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_strict_mode(4391);

  /**
   * generated from dns.trr_skip_reason_trr_first
   * When in TRR-first mode, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_TRR_FIRST2.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_trr_first(4392);

  /**
   * generated from dns.trr_success
   * How often TRR (Trusted Recursive Resolver) requests are fine, time-out or error. Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_TRR_SUCCESS3.
   */
  constexpr impl::DualLabeledCounterMetric trr_success(4393);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNetwerkDnsMetrics_h
