// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNetwerkMetrics_h
#define mozilla_GleanNetwerkMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace networking {
  /**
   * generated from networking.cache_metadata_first_read_time
   * Time spent to read the first part of the metadata from the cache entry file.
   */
  constexpr impl::TimingDistributionMetric cache_metadata_first_read_time(49);

  /**
   * generated from networking.cache_metadata_second_read_time
   * Time spent to read the missing part of the metadata from the cache entry file.
   */
  constexpr impl::TimingDistributionMetric cache_metadata_second_read_time(50);

  /**
   * generated from networking.cache_metadata_size
   * Size of the metadata in bytes parsed from the disk.
   */
  constexpr impl::MemoryDistributionMetric cache_metadata_size(51);

  /**
   * generated from networking.cookie_access_fixup_diff
   * If we fix up a cookie lastAccessed timestamp that is in the future this metric records the number of seconds that timestamp was off from NOW.
   */
  constexpr impl::CustomDistributionMetric cookie_access_fixup_diff(52);

  /**
   * generated from networking.cookie_chips_partition_limit_overflow
   * The number of cookie bytes exceeding chips partition limit capacity for a single partition
   */
  constexpr impl::CustomDistributionMetric cookie_chips_partition_limit_overflow(53);

  /**
   * generated from networking.cookie_count_part_by_key
   * A distribution of the partitioned cookies in storage belonging to a particular cookie key (host + origin attributes)
   */
  constexpr impl::CustomDistributionMetric cookie_count_part_by_key(54);

  /**
   * generated from networking.cookie_count_partitioned
   * Reports the number of partitioned cookies in storage
   */
  constexpr impl::CustomDistributionMetric cookie_count_partitioned(55);

  /**
   * generated from networking.cookie_count_total
   * Reports the total number of cookies in storage
   */
  constexpr impl::CustomDistributionMetric cookie_count_total(56);

  /**
   * generated from networking.cookie_count_unpart_by_key
   * A distribution of the unpartitioned cookies in storage belonging to a particular cookie key (host + origin attributes)
   */
  constexpr impl::CustomDistributionMetric cookie_count_unpart_by_key(57);

  /**
   * generated from networking.cookie_count_unpartitioned
   * Reports the number of unpartitioned cookies in storage
   */
  constexpr impl::CustomDistributionMetric cookie_count_unpartitioned(58);

  /**
   * generated from networking.cookie_creation_fixup_diff
   * If we fix up a cookie creation timestamp that is in the future this metric records the number of seconds that timestamp was off from NOW.
   */
  constexpr impl::CustomDistributionMetric cookie_creation_fixup_diff(59);

  /**
   * generated from networking.cookie_db_validation
   */
  enum class CookieDbValidationLabel: uint16_t {
    eEok = 0,
    eErejectedemptynameandvalue = 1,
    eErejectednamevalueoversize = 2,
    eErejectedinvalidcharname = 3,
    eErejectedinvalidcharvalue = 4,
    eErejectedinvalidpath = 5,
    eErejectedinvaliddomain = 6,
    eErejectedinvalidprefix = 7,
    eErejectednonerequiressecure = 8,
    eErejectedpartitionedrequiressecure = 9,
    eErejectedhttponlybutfromscript = 10,
    eErejectedsecurebutnonhttps = 11,
    eErejectedfornonsamesiteness = 12,
    eErejectedattributepathoversize = 13,
    eErejectedattributedomainoversize = 14,
    eErejectedattributeexpiryoversize = 15,
    e__Other__,
  };
  /**
   * Counts cookies loaded from the DB grouped by validation result.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CookieDbValidationLabel> cookie_db_validation(60);

  /**
   * generated from networking.cookie_purge_entry_max
   * A distribution of the number of cookies purged for a single host + OA entry as a result of exceeding the maximum threshold for the given host + OA (single purge)
   */
  constexpr impl::CustomDistributionMetric cookie_purge_entry_max(61);

  /**
   * generated from networking.cookie_purge_max
   * A distribution of the number of cookies purged across all host + OAs as a result of exceeding the cookie maximum threshold (single purge)
   */
  constexpr impl::CustomDistributionMetric cookie_purge_max(62);

  /**
   * generated from networking.cookie_timestamp_fixed_count
   */
  enum class CookieTimestampFixedCountLabel: uint16_t {
    eCreationtime = 0,
    eLastaccessed = 1,
    e__Other__,
  };
  /**
   * Counts the number of times a cookie's invalid timestamp was fixed when reading it from the DB.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CookieTimestampFixedCountLabel> cookie_timestamp_fixed_count(63);

  /**
   * generated from networking.dns_failed_lookup_time
   * Time for an unsuccessful DNS OS resolution (msec) | Migrated from Firefox Telemetry's `DNS_FAILED_LOOKUP_TIME`.
   */
  constexpr impl::TimingDistributionMetric dns_failed_lookup_time(64);

  /**
   * generated from networking.dns_lookup_time
   * Time for a successful DNS resolution (msec) | Migrated from Firefox Telemetry's `DNS_LOOKUP_TIME`.
   */
  constexpr impl::TimingDistributionMetric dns_lookup_time(65);

  /**
   * generated from networking.dns_native_count
   */
  enum class DnsNativeCountLabel: uint16_t {
    eRegular = 0,
    ePrivate = 1,
    eHttpsRegular = 2,
    eHttpsPrivate = 3,
    e__Other__,
  };
  /**
   * The count of calls to the native DNS APIs
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DnsNativeCountLabel> dns_native_count(66);

  /**
   * generated from networking.dns_native_https_call_time
   * Time spent in the call to the native OS DNS resolution.
   */
  constexpr impl::TimingDistributionMetric dns_native_https_call_time(67);

  /**
   * generated from networking.dns_renewal_time
   * Time for a renewed DNS OS resolution (msec) | Migrated from Firefox Telemetry's `DNS_RENEWAL_TIME`.
   */
  constexpr impl::TimingDistributionMetric dns_renewal_time(68);

  /**
   * generated from networking.dns_renewal_time_for_ttl
   * Time for a DNS OS resolution (msec) used to get TTL | Migrated from Firefox Telemetry's `DNS_RENEWAL_TIME_FOR_TTL`.
   */
  constexpr impl::TimingDistributionMetric dns_renewal_time_for_ttl(69);

  /**
   * generated from networking.http3_channel_onstart_success
   * Successfully started HTTP channels when HTTP3 is used
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTTP3_CHANNEL_ONSTART_SUCCESS.
   */
  constexpr impl::DualLabeledCounterMetric http3_channel_onstart_success(70);

  /**
   * generated from networking.http_1_download_throughput
   * The download throughput for  http/1.0, http/1.1 requests larger than 10MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_download_throughput(71);

  /**
   * generated from networking.http_1_download_throughput_100
   * The download throughput for http/1.0 and http/1.1 requests size larger than 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_download_throughput_100(72);

  /**
   * generated from networking.http_1_download_throughput_10_50
   * The download throughput for http/1.0 and http/1.1 requests between 10MB and 50MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_download_throughput_10_50(73);

  /**
   * generated from networking.http_1_download_throughput_50_100
   * The download throughput for http/1.0 and http/1.1 requests between 50MB and 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_download_throughput_50_100(74);

  /**
   * generated from networking.http_1_upload_throughput
   * The upload throughput for http/1.0, http/1.1 requests larger than 10MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_upload_throughput(75);

  /**
   * generated from networking.http_1_upload_throughput_100
   * The upload throughput for http/1.0, http/1.1 request size larger than 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_upload_throughput_100(76);

  /**
   * generated from networking.http_1_upload_throughput_10_50
   * The upload throughput for http/1.0, http/1.1 request size between 10MB and 50MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_upload_throughput_10_50(77);

  /**
   * generated from networking.http_1_upload_throughput_50_100
   * The upload throughput for http/1.0, http/1.1 request size between 50MB and 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_1_upload_throughput_50_100(78);

  /**
   * generated from networking.http_2_download_throughput
   * The download throughput for http/2 requests larger than 10MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_download_throughput(79);

  /**
   * generated from networking.http_2_download_throughput_100
   * The download throughput for http/2 requests size larger than 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_download_throughput_100(80);

  /**
   * generated from networking.http_2_download_throughput_10_50
   * The download throughput for http/2 requests between 10MB and 50MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_download_throughput_10_50(81);

  /**
   * generated from networking.http_2_download_throughput_50_100
   * The download throughput for http/2 requests between 50MB and 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_download_throughput_50_100(82);

  /**
   * generated from networking.http_2_upload_throughput
   * The upload throughput for http/2 requests larger than 10MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_upload_throughput(83);

  /**
   * generated from networking.http_2_upload_throughput_100
   * The upload throughput for http/2 request size larger than 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_upload_throughput_100(84);

  /**
   * generated from networking.http_2_upload_throughput_10_50
   * The upload throughput for http/2 request size between 10MB and 50MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_upload_throughput_10_50(85);

  /**
   * generated from networking.http_2_upload_throughput_50_100
   * The upload throughput for http/2 request size between 50MB and 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_2_upload_throughput_50_100(86);

  /**
   * generated from networking.http_3_congestion_event_reason
   */
  enum class Http3CongestionEventReasonLabel: uint16_t {
    eLoss = 0,
    eEcnCe = 1,
    e__Other__,
  };
  /**
   * The type of signal that caused a congestion event in Firefox's QUIC stack.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, Http3CongestionEventReasonLabel> http_3_congestion_event_reason(87);

  /**
   * generated from networking.http_3_connection_close_reason
   */
  enum class Http3ConnectionCloseReasonLabel: uint16_t {
    eApplication = 0,
    eNoerror = 1,
    eInternalerror = 2,
    eConnectionrefused = 3,
    eFlowcontrolerror = 4,
    eStreamlimiterror = 5,
    eStreamstateerror = 6,
    eFinalsizeerror = 7,
    eFrameencodingerror = 8,
    eTransportparametererror = 9,
    eProtocolviolation = 10,
    eInvalidtoken = 11,
    eApplicationerror = 12,
    eCryptobufferexceeded = 13,
    eCryptoerror = 14,
    eQlogerror = 15,
    eCryptoalert = 16,
    eEchretry = 17,
    eAckedunsentpacket = 18,
    eConnectionidlimitexceeded = 19,
    eConnectionidsexhausted = 20,
    eConnectionstate = 21,
    eDecodingframe = 22,
    eDecrypterror = 23,
    eDisabledversion = 24,
    eIdletimeout = 25,
    eIntegeroverflow = 26,
    eInvalidinput = 27,
    eInvalidmigration = 28,
    eInvalidpacket = 29,
    eInvalidresumptiontoken = 30,
    eInvalidretry = 31,
    eInvalidstreamid = 32,
    eKeysdiscarded = 33,
    eKeysexhausted = 34,
    eKeyspending = 35,
    eKeyupdateblocked = 36,
    eNoavailablepath = 37,
    eNomoredata = 38,
    eNotavailable = 39,
    eNotconnected = 40,
    ePacketnumberoverlap = 41,
    ePeerapplicationerror = 42,
    ePeererror = 43,
    eStatelessreset = 44,
    eToomuchdata = 45,
    eUnexpectedmessage = 46,
    eUnknownconnectionid = 47,
    eUnknownframetype = 48,
    eVersionnegotiation = 49,
    eWrongrole = 50,
    e__Other__,
  };
  /**
   * Number of HTTP3 connections closed, labeled by reason.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, Http3ConnectionCloseReasonLabel> http_3_connection_close_reason(88);

  /**
   * generated from networking.http_3_download_throughput
   * The download throughput for http/3 requests larger than 10MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_download_throughput(89);

  /**
   * generated from networking.http_3_download_throughput_100
   * The download throughput for http/3 requests size larger than 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_download_throughput_100(90);

  /**
   * generated from networking.http_3_download_throughput_10_50
   * The download throughput for http/3 requests between 10MB and 50MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_download_throughput_10_50(91);

  /**
   * generated from networking.http_3_download_throughput_50_100
   * The download throughput for http/3 requests between 50MB and 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_download_throughput_50_100(92);

  /**
   * generated from networking.http_3_ecn_ce_ect0_ratio_received
   * HTTP3: ECN CE to ECT0 ratio (multiply by 10000) received.
   */
  constexpr impl::CustomDistributionMetric http_3_ecn_ce_ect0_ratio_received(93);

  /**
   * generated from networking.http_3_ecn_ce_ect0_ratio_sent
   * HTTP3: ECN CE to ECT0 ratio (multiply by 10000) sent.
   */
  constexpr impl::CustomDistributionMetric http_3_ecn_ce_ect0_ratio_sent(94);

  /**
   * generated from networking.http_3_ecn_path_capability
   */
  enum class Http3EcnPathCapabilityLabel: uint16_t {
    eCapable = 0,
    eBlackHole = 1,
    eBleaching = 2,
    eReceivedUnsentEct1 = 3,
    e__Other__,
  };
  /**
   * Number of paths known to be ECN capable or not-capable.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, Http3EcnPathCapabilityLabel> http_3_ecn_path_capability(95);

  /**
   * generated from networking.http_3_loss_ratio
   * HTTP3: packet loss ratio (multiply by 10000).
   */
  constexpr impl::CustomDistributionMetric http_3_loss_ratio(96);

  /**
   * generated from networking.http_3_quic_frame_count
   */
  enum class Http3QuicFrameCountLabel: uint16_t {
    eAckTx = 0,
    eAckRx = 1,
    eCryptoTx = 2,
    eCryptoRx = 3,
    eStreamTx = 4,
    eStreamRx = 5,
    eResetStreamTx = 6,
    eResetStreamRx = 7,
    eStopSendingTx = 8,
    eStopSendingRx = 9,
    ePingTx = 10,
    ePingRx = 11,
    ePaddingTx = 12,
    ePaddingRx = 13,
    eMaxStreamsTx = 14,
    eMaxStreamsRx = 15,
    eStreamsBlockedTx = 16,
    eStreamsBlockedRx = 17,
    eMaxDataTx = 18,
    eMaxDataRx = 19,
    eDataBlockedTx = 20,
    eDataBlockedRx = 21,
    eMaxStreamDataTx = 22,
    eMaxStreamDataRx = 23,
    eStreamDataBlockedTx = 24,
    eStreamDataBlockedRx = 25,
    eNewConnectionIdTx = 26,
    eNewConnectionIdRx = 27,
    eRetireConnectionIdTx = 28,
    eRetireConnectionIdRx = 29,
    ePathChallengeTx = 30,
    ePathChallengeRx = 31,
    ePathResponseTx = 32,
    ePathResponseRx = 33,
    eConnectionCloseTx = 34,
    eConnectionCloseRx = 35,
    eHandshakeDoneTx = 36,
    eHandshakeDoneRx = 37,
    eNewTokenTx = 38,
    eNewTokenRx = 39,
    eAckFrequencyTx = 40,
    eAckFrequencyRx = 41,
    eDatagramTx = 42,
    eDatagramRx = 43,
    e__Other__,
  };
  /**
   * Number of QUIC frames send and received by type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, Http3QuicFrameCountLabel> http_3_quic_frame_count(97);

  /**
   * generated from networking.http_3_slow_start_exited
   */
  enum class Http3SlowStartExitedLabel: uint16_t {
    eExited = 0,
    eNotExited = 1,
    e__Other__,
  };
  /**
   * Counts whether an HTTP3 connections exited slow start.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, Http3SlowStartExitedLabel> http_3_slow_start_exited(98);

  /**
   * generated from networking.http_3_spurious_congestion_event_ratio
   * HTTP3: spurious congestion event to loss induced congestion event ratio (10000 scaling factor).
   */
  constexpr impl::CustomDistributionMetric http_3_spurious_congestion_event_ratio(99);

  /**
   * generated from networking.http_3_udp_datagram_segment_size_received
   * HTTP3 UDP datagram size received.
   */
  constexpr impl::MemoryDistributionMetric http_3_udp_datagram_segment_size_received(100);

  /**
   * generated from networking.http_3_udp_datagram_segment_size_sent
   * HTTP3 UDP datagram segment size sent.
   */
  constexpr impl::MemoryDistributionMetric http_3_udp_datagram_segment_size_sent(101);

  /**
   * generated from networking.http_3_udp_datagram_segments_received
   * HTTP3 UDP number of segments per datagram received.
   */
  constexpr impl::CustomDistributionMetric http_3_udp_datagram_segments_received(102);

  /**
   * generated from networking.http_3_udp_datagram_segments_sent
   * HTTP3 UDP number of segments per datagram sent.
   */
  constexpr impl::CustomDistributionMetric http_3_udp_datagram_segments_sent(103);

  /**
   * generated from networking.http_3_udp_datagram_size_received
   * HTTP3 UDP datagram size received.
   */
  constexpr impl::MemoryDistributionMetric http_3_udp_datagram_size_received(104);

  /**
   * generated from networking.http_3_udp_datagram_size_sent
   * HTTP3 UDP datagram size sent.
   */
  constexpr impl::MemoryDistributionMetric http_3_udp_datagram_size_sent(105);

  /**
   * generated from networking.http_3_upload_throughput
   * The upload throughput for http/3 requests larger than 10MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput(106);

  /**
   * generated from networking.http_3_upload_throughput_100
   * The upload throughput for http/3 request size larger than 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput_100(107);

  /**
   * generated from networking.http_3_upload_throughput_10_50
   * The upload throughput for http/3 request size between 10MB and 50MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput_10_50(108);

  /**
   * generated from networking.http_3_upload_throughput_1_10
   * The upload throughput for http/3 request size between 1MB and 10MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput_1_10(109);

  /**
   * generated from networking.http_3_upload_throughput_50_100
   * The upload throughput for http/3 request size between 50MB and 100MB. Measured in megabits per second, Mbps.
   */
  constexpr impl::CustomDistributionMetric http_3_upload_throughput_50_100(110);

  /**
   * generated from networking.http_channel_disposition
   */
  enum class HttpChannelDispositionLabel: uint16_t {
    eHttpCancelled = 0,
    eHttpDisk = 1,
    eHttpNetOk = 2,
    eHttpNetEarlyFail = 3,
    eHttpNetLateFail = 4,
    eHttpsCancelled = 5,
    eHttpsDisk = 6,
    eHttpsNetOk = 7,
    eHttpsNetEarlyFail = 8,
    eHttpsNetLateFail = 9,
    e__Other__,
  };
  /**
   * Channel Disposition for HTTP and HTTPS: cancel, disk, net_ok, net_early_fail, and net_late_fail
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelDispositionLabel> http_channel_disposition(111);

  /**
   * generated from networking.http_channel_disposition_disabled_no_reason
   */
  enum class HttpChannelDispositionDisabledNoReasonLabel: uint16_t {
    eCancel = 0,
    eDisk = 1,
    eNetOk = 2,
    eNetEarlyFail = 3,
    eNetLateFail = 4,
    e__Other__,
  };
  /**
   * Upgrading display content Channel Disposition (key: disabled_no_reason)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelDispositionDisabledNoReasonLabel> http_channel_disposition_disabled_no_reason(112);

  /**
   * generated from networking.http_channel_disposition_disabled_upgrade
   */
  enum class HttpChannelDispositionDisabledUpgradeLabel: uint16_t {
    eCancel = 0,
    eDisk = 1,
    eNetOk = 2,
    eNetEarlyFail = 3,
    eNetLateFail = 4,
    e__Other__,
  };
  /**
   * Upgrading display content Channel Disposition (key: disable_upgrade)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelDispositionDisabledUpgradeLabel> http_channel_disposition_disabled_upgrade(113);

  /**
   * generated from networking.http_channel_disposition_disabled_wont
   */
  enum class HttpChannelDispositionDisabledWontLabel: uint16_t {
    eCancel = 0,
    eDisk = 1,
    eNetOk = 2,
    eNetEarlyFail = 3,
    eNetLateFail = 4,
    e__Other__,
  };
  /**
   * Upgrading display content Channel Disposition (key: disabled_wont)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelDispositionDisabledWontLabel> http_channel_disposition_disabled_wont(114);

  /**
   * generated from networking.http_channel_disposition_enabled_no_reason
   */
  enum class HttpChannelDispositionEnabledNoReasonLabel: uint16_t {
    eCancel = 0,
    eDisk = 1,
    eNetOk = 2,
    eNetEarlyFail = 3,
    eNetLateFail = 4,
    e__Other__,
  };
  /**
   * Upgrading display content Channel Disposition (key: enabled_no_reason)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelDispositionEnabledNoReasonLabel> http_channel_disposition_enabled_no_reason(115);

  /**
   * generated from networking.http_channel_disposition_enabled_upgrade
   */
  enum class HttpChannelDispositionEnabledUpgradeLabel: uint16_t {
    eCancel = 0,
    eDisk = 1,
    eNetOk = 2,
    eNetEarlyFail = 3,
    eNetLateFail = 4,
    e__Other__,
  };
  /**
   * Upgrading display content Channel Disposition (key: enable_upgrade)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelDispositionEnabledUpgradeLabel> http_channel_disposition_enabled_upgrade(116);

  /**
   * generated from networking.http_channel_disposition_enabled_wont
   */
  enum class HttpChannelDispositionEnabledWontLabel: uint16_t {
    eCancel = 0,
    eDisk = 1,
    eNetOk = 2,
    eNetEarlyFail = 3,
    eNetLateFail = 4,
    e__Other__,
  };
  /**
   * Upgrading display content Channel Disposition (key: enabled_wont)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelDispositionEnabledWontLabel> http_channel_disposition_enabled_wont(117);

  /**
   * generated from networking.http_channel_disposition_upgrade
   * Upgrading display content Channel Disposition
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram HTTP_CHANNEL_DISPOSITION_UPGRADE.
   */
  constexpr impl::DualLabeledCounterMetric http_channel_disposition_upgrade(118);

  /**
   * generated from networking.http_channel_onstart_status
   */
  enum class HttpChannelOnstartStatusLabel: uint16_t {
    eSuccessful = 0,
    eFail = 1,
    e__Other__,
  };
  /**
   * Whether successfully started HTTP channels
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelOnstartStatusLabel> http_channel_onstart_status(119);

  /**
   * generated from networking.http_channel_onstart_success_https_rr
   */
  enum class HttpChannelOnstartSuccessHttpsRrLabel: uint16_t {
    eSuccess = 0,
    eFailure = 1,
    eSuccessEchUsed = 2,
    eFailureEchUsed = 3,
    e__Other__,
  };
  /**
   * Successfully started HTTP channels when HTTPS RR is used
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpChannelOnstartSuccessHttpsRrLabel> http_channel_onstart_success_https_rr(120);

  /**
   * generated from networking.http_channel_page_open_to_first_sent
   * Time in milliseconds from AsyncOpen to first byte of request sent, applicable for page loads without HTTPS RR
   */
  constexpr impl::TimingDistributionMetric http_channel_page_open_to_first_sent(121);

  /**
   * generated from networking.http_channel_page_open_to_first_sent_https_rr
   * Time in milliseconds from AsyncOpen to first byte of request sent, applicable for page loads with HTTPS RR
   */
  constexpr impl::TimingDistributionMetric http_channel_page_open_to_first_sent_https_rr(122);

  /**
   * generated from networking.http_channel_sub_open_to_first_sent
   * Time in milliseconds from AsyncOpen to first byte of request sent, applicable for sub-resource loads without HTTPS RR
   */
  constexpr impl::TimingDistributionMetric http_channel_sub_open_to_first_sent(123);

  /**
   * generated from networking.http_channel_sub_open_to_first_sent_https_rr
   * Time in milliseconds from AsyncOpen to first byte of request sent, applicable for sub-resource loads with HTTPS RR
   */
  constexpr impl::TimingDistributionMetric http_channel_sub_open_to_first_sent_https_rr(124);

  /**
   * generated from networking.http_onstart_suspend_total_time
   * Time in milliseconds that http channel spent suspended between AsyncOpen and OnStartRequest.
   */
  constexpr impl::TimingDistributionMetric http_onstart_suspend_total_time(125);

  /**
   * generated from networking.http_redirect_to_scheme_subresource
   * Count of the HTTP redirection that triggered by subresource, keyed by the URL scheme redirected to
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> http_redirect_to_scheme_subresource(126);

  /**
   * generated from networking.http_redirect_to_scheme_top_level
   * Count of the HTTP redirection that triggered by top-level document, keyed by the URL scheme redirected to
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> http_redirect_to_scheme_top_level(127);

  /**
   * generated from networking.http_response_status_code
   */
  enum class HttpResponseStatusCodeLabel: uint16_t {
    e200Ok = 0,
    e301MovedPermanently = 1,
    e302Found = 2,
    e304NotModified = 3,
    e307TemporaryRedirect = 4,
    e308PermanentRedirect = 5,
    e400BadRequest = 6,
    e401Unauthorized = 7,
    e403Forbidden = 8,
    e404NotFound = 9,
    e421MisdirectedRequest = 10,
    e425TooEarly = 11,
    e429TooManyRequests = 12,
    eOther4xx = 13,
    eOther5xx = 14,
    eOther = 15,
    e__Other__,
  };
  /**
   * HTTP Response Status Code (200, 301, 302, 304, 307, 308, 400, 401, 403, 404, 421, 425, 429, other 400 and 500)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpResponseStatusCodeLabel> http_response_status_code(128);

  /**
   * generated from networking.http_response_version
   */
  enum class HttpResponseVersionLabel: uint16_t {
    eUnknown = 0,
    eHttp1 = 1,
    eHttp2 = 2,
    eHttp3 = 3,
    e__Other__,
  };
  /**
   * HTTP protocol version used on response from nsHttp.h
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpResponseVersionLabel> http_response_version(129);

  /**
   * generated from networking.http_to_https_upgrade_reason
   */
  enum class HttpToHttpsUpgradeReasonLabel: uint16_t {
    eNotInitialized = 0,
    eNotInitializedHttps = 1,
    eNoUpgrade = 2,
    eNoUpgradeHttps = 3,
    eAlreadyHttps = 4,
    eHsts = 5,
    eHttpsOnlyUpgrade = 6,
    eHttpsOnlyUpgradeDowngrade = 7,
    eHttpsFirstUpgrade = 8,
    eHttpsFirstUpgradeDowngrade = 9,
    eHttpsFirstSchemelessUpgrade = 10,
    eHttpsFirstSchemelessUpgradeDowngrade = 11,
    eCspUir = 12,
    eHttpsRr = 13,
    eWebExtensionUpgrade = 14,
    eUpgradeException = 15,
    eSkipUpgrade = 16,
    e__Other__,
  };
  /**
   * Whether a top-level HTTP request gets upgraded to HTTPS and the reason for it
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpToHttpsUpgradeReasonLabel> http_to_https_upgrade_reason(130);

  /**
   * generated from networking.https_http_or_local
   */
  enum class HttpsHttpOrLocalLabel: uint16_t {
    eLoadIsHttps = 0,
    eLoadIsHttp = 1,
    eLoadIsHttpForLocalDomain = 2,
    e__Other__,
  };
  /**
   * Whether a top-level request is HTTPS, HTTP, or HTTP for local domain
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpsHttpOrLocalLabel> https_http_or_local(131);

  /**
   * generated from networking.https_rr_presented
   */
  enum class HttpsRrPresentedLabel: uint16_t {
    ePresented = 0,
    ePresentedWithHttp3 = 1,
    eNone = 2,
    e__Other__,
  };
  /**
   * HTTPS RR is presented or not
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, HttpsRrPresentedLabel> https_rr_presented(132);

  /**
   * generated from networking.local_network_access
   */
  enum class LocalNetworkAccessLabel: uint16_t {
    ePrivateToLocalHttp = 0,
    ePrivateToLocalHttps = 1,
    ePublicToLocalHttp = 2,
    ePublicToLocalHttps = 3,
    ePublicToPrivateHttp = 4,
    ePublicToPrivateHttps = 5,
    eSuccess = 6,
    eFailure = 7,
    e__Other__,
  };
  /**
   * Whether the request is crossing to a more private addresspace
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LocalNetworkAccessLabel> local_network_access(133);

  /**
   * generated from networking.local_network_access_connection
   */
  struct LocalNetworkAccessConnectionExtra {
    mozilla::Maybe<nsCString> initiator;
    mozilla::Maybe<bool> isSecureContext;
    mozilla::Maybe<bool> loadSuccess;
    mozilla::Maybe<nsCString> promptAction;
    mozilla::Maybe<nsCString> protocol;
    mozilla::Maybe<nsCString> targetHost;
    mozilla::Maybe<nsCString> targetIp;
    mozilla::Maybe<uint32_t> targetPort;
    mozilla::Maybe<nsCString> topLevelSite;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (initiator) {
        extraKeys.AppendElement()->AssignASCII("initiator");
        extraValues.EmplaceBack(initiator.value());
      }
      if (isSecureContext) {
        extraKeys.AppendElement()->AssignASCII("is_secure_context");
        extraValues.AppendElement()->AssignASCII(isSecureContext.value() ? "true" : "false");
      }
      if (loadSuccess) {
        extraKeys.AppendElement()->AssignASCII("load_success");
        extraValues.AppendElement()->AssignASCII(loadSuccess.value() ? "true" : "false");
      }
      if (promptAction) {
        extraKeys.AppendElement()->AssignASCII("prompt_action");
        extraValues.EmplaceBack(promptAction.value());
      }
      if (protocol) {
        extraKeys.AppendElement()->AssignASCII("protocol");
        extraValues.EmplaceBack(protocol.value());
      }
      if (targetHost) {
        extraKeys.AppendElement()->AssignASCII("target_host");
        extraValues.EmplaceBack(targetHost.value());
      }
      if (targetIp) {
        extraKeys.AppendElement()->AssignASCII("target_ip");
        extraValues.EmplaceBack(targetIp.value());
      }
      if (targetPort) {
        extraKeys.AppendElement()->AssignASCII("target_port");
        extraValues.AppendElement()->AppendInt(targetPort.value());
      }
      if (topLevelSite) {
        extraKeys.AppendElement()->AssignASCII("top_level_site");
        extraValues.EmplaceBack(topLevelSite.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a site attempts to access local network resources.
   */
  constexpr impl::EventMetric<LocalNetworkAccessConnectionExtra> local_network_access_connection(134);

  /**
   * generated from networking.local_network_access_port
   * port used for local network access
   */
  constexpr impl::CustomDistributionMetric local_network_access_port(135);

  /**
   * generated from networking.local_network_access_prompts_shown
   */
  enum class LocalNetworkAccessPromptsShownLabel: uint16_t {
    eLocalhost = 0,
    eLocalNetwork = 1,
    eLocalhostCrossSite = 2,
    eLocalNetworkCrossSite = 3,
    e__Other__,
  };
  /**
   * Count of permission prompts shown to users for local network access, separated by localhost vs local network access types. Cross-site labels are used when the requesting origin differs from the top-level origin.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, LocalNetworkAccessPromptsShownLabel> local_network_access_prompts_shown(136);

  /**
   * generated from networking.local_network_blocked_tracker
   * Counts the number of times the channel was blocked because it's a LNA load triggered by a tracker
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> local_network_blocked_tracker(137);

  /**
   * generated from networking.os_socket_limit_reached
   * Counts the number of times the os socket limit was reached. i.e. CanAttachSocket() returned false.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> os_socket_limit_reached(138);

  /**
   * generated from networking.prclose_tcp_blocking_time_connectivity_change
   * Time spent blocked in PR_Close when there has been the connectivity change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_CONNECTIVITY_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prclose_tcp_blocking_time_connectivity_change(139);

  /**
   * generated from networking.prclose_tcp_blocking_time_link_change
   * Time spent blocked in PR_Close when there has been a link change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_LINK_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prclose_tcp_blocking_time_link_change(140);

  /**
   * generated from networking.prclose_tcp_blocking_time_normal
   * Time spent blocked in PR_Close when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_NORMAL.
   */
  constexpr impl::TimingDistributionMetric prclose_tcp_blocking_time_normal(141);

  /**
   * generated from networking.prclose_tcp_blocking_time_offline
   * Time spent blocked in PR_Close when the offline state has changed in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_OFFLINE.
   */
  constexpr impl::TimingDistributionMetric prclose_tcp_blocking_time_offline(142);

  /**
   * generated from networking.prclose_tcp_blocking_time_shutdown
   * Time spent blocked in PR_Close during a shutdown (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_TCP_BLOCKING_TIME_SHUTDOWN.
   */
  constexpr impl::TimingDistributionMetric prclose_tcp_blocking_time_shutdown(143);

  /**
   * generated from networking.prclose_udp_blocking_time_connectivity_change
   * Time spent blocked in PR_Close when there has been the connectivity change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_CONNECTIVITY_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prclose_udp_blocking_time_connectivity_change(144);

  /**
   * generated from networking.prclose_udp_blocking_time_link_change
   * Time spent blocked in PR_Close when there has been a link change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_LINK_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prclose_udp_blocking_time_link_change(145);

  /**
   * generated from networking.prclose_udp_blocking_time_normal
   * Time spent blocked in PR_Close when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_NORMAL.
   */
  constexpr impl::TimingDistributionMetric prclose_udp_blocking_time_normal(146);

  /**
   * generated from networking.prclose_udp_blocking_time_offline
   * Time spent blocked in PR_Close when the offline state has changed in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_OFFLINE.
   */
  constexpr impl::TimingDistributionMetric prclose_udp_blocking_time_offline(147);

  /**
   * generated from networking.prclose_udp_blocking_time_shutdown
   * Time spent blocked in PR_Close during a shutdown (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCLOSE_UDP_BLOCKING_TIME_SHUTDOWN.
   */
  constexpr impl::TimingDistributionMetric prclose_udp_blocking_time_shutdown(148);

  /**
   * generated from networking.prconnect_blocking_time_connectivity_change
   * Time spent blocked in PR_Connect when there has been the connectiviy change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_CONNECTIVITY_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prconnect_blocking_time_connectivity_change(149);

  /**
   * generated from networking.prconnect_blocking_time_link_change
   * Time spent blocked in PR_Connect when there has been a link change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_LINK_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prconnect_blocking_time_link_change(150);

  /**
   * generated from networking.prconnect_blocking_time_normal
   * Time spent blocked in PR_Connect when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_NORMAL.
   */
  constexpr impl::TimingDistributionMetric prconnect_blocking_time_normal(151);

  /**
   * generated from networking.prconnect_blocking_time_offline
   * Time spent blocked in PR_Connect when the offline state has changed in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_OFFLINE.
   */
  constexpr impl::TimingDistributionMetric prconnect_blocking_time_offline(152);

  /**
   * generated from networking.prconnect_blocking_time_shutdown
   * Time spent blocked in PR_Connect during a shutdown (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_BLOCKING_TIME_SHUTDOWN.
   */
  constexpr impl::TimingDistributionMetric prconnect_blocking_time_shutdown(153);

  /**
   * generated from networking.prconnect_fail_blocking_time_connectivity_change
   * Time spent blocked in a failed PR_Connect when there has been the connectiviy change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_CONNECTIVITY_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prconnect_fail_blocking_time_connectivity_change(154);

  /**
   * generated from networking.prconnect_fail_blocking_time_link_change
   * Time spent blocked in a failed PR_Connect when there has been a link change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_LINK_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prconnect_fail_blocking_time_link_change(155);

  /**
   * generated from networking.prconnect_fail_blocking_time_normal
   * Time spent blocked in a failed PR_Connect when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_NORMAL.
   */
  constexpr impl::TimingDistributionMetric prconnect_fail_blocking_time_normal(156);

  /**
   * generated from networking.prconnect_fail_blocking_time_offline
   * Time spent blocked in a failed PR_Connect when the offline state has changed in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_OFFLINE.
   */
  constexpr impl::TimingDistributionMetric prconnect_fail_blocking_time_offline(157);

  /**
   * generated from networking.prconnect_fail_blocking_time_shutdown
   * Time spent blocked in a failed PR_Connect during a shutdown (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECT_FAIL_BLOCKING_TIME_SHUTDOWN.
   */
  constexpr impl::TimingDistributionMetric prconnect_fail_blocking_time_shutdown(158);

  /**
   * generated from networking.prconnectcontinue_blocking_time_connectivity_change
   * Time spent blocked in PR_ConnectContinue when there has been the connectivity change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_CONNECTIVITY_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prconnectcontinue_blocking_time_connectivity_change(159);

  /**
   * generated from networking.prconnectcontinue_blocking_time_link_change
   * Time spent blocked in PR_ConnectContinue when there has been a link change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_LINK_CHANGE.
   */
  constexpr impl::TimingDistributionMetric prconnectcontinue_blocking_time_link_change(160);

  /**
   * generated from networking.prconnectcontinue_blocking_time_normal
   * Time spent blocked in PR_ConnectContinue when we are not shutting down and there has been niether a network nor an offline state change in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_NORMAL.
   */
  constexpr impl::TimingDistributionMetric prconnectcontinue_blocking_time_normal(161);

  /**
   * generated from networking.prconnectcontinue_blocking_time_offline
   * Time spent blocked in PR_ConnectContinue when the offline state has changed in the last 60s (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_OFFLINE.
   */
  constexpr impl::TimingDistributionMetric prconnectcontinue_blocking_time_offline(162);

  /**
   * generated from networking.prconnectcontinue_blocking_time_shutdown
   * Time spent blocked in PR_ConnectContinue during a shutdown (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PRCONNECTCONTINUE_BLOCKING_TIME_SHUTDOWN.
   */
  constexpr impl::TimingDistributionMetric prconnectcontinue_blocking_time_shutdown(163);

  /**
   * generated from networking.proxy_info_type
   */
  enum class ProxyInfoTypeLabel: uint16_t {
    eHttp = 0,
    eHttps = 1,
    eSocks4 = 2,
    eSocks4a = 3,
    eSocks5 = 4,
    eSocks5h = 5,
    eDirect = 6,
    eUnknown = 7,
    e__Other__,
  };
  /**
   * The proxies configurations created in the browser session (SOCKSv4, SOCKSv5, HTTP, HTTPS)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ProxyInfoTypeLabel> proxy_info_type(164);

  /**
   * generated from networking.residual_cache_folder_count
   * Counts how often we find a cache folder that wasn't purged at shutdown by a background task process.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> residual_cache_folder_count(165);

  /**
   * generated from networking.residual_cache_folder_removal
   */
  enum class ResidualCacheFolderRemovalLabel: uint16_t {
    eSuccess = 0,
    eFailure = 1,
    e__Other__,
  };
  /**
   * Counts how often succeed/fail in removing cache folder that wasn't purged at shutdown
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ResidualCacheFolderRemovalLabel> residual_cache_folder_removal(166);

  /**
   * generated from networking.sqlite_cookies_block_main_thread
   * Time spent on blocking main thread by startup cookie database read (in milliseconds), only for blocking case
   */
  constexpr impl::TimingDistributionMetric sqlite_cookies_block_main_thread(167);

  /**
   * generated from networking.sqlite_cookies_time_to_block_main_thread
   * How long (in milliseconds) after we finished reading the cookie db until the first cookie request came in (0 implies we blocked the main thread)
   */
  constexpr impl::TimingDistributionMetric sqlite_cookies_time_to_block_main_thread(168);

  /**
   * generated from networking.transaction_wait_time
   * Time from submission to dispatch of transaction without HTTPS RR (ms)
   */
  constexpr impl::TimingDistributionMetric transaction_wait_time(169);

  /**
   * generated from networking.transaction_wait_time_https_rr
   * Time from submission to dispatch of transaction when HTTPS RR is used (ms)
   */
  constexpr impl::TimingDistributionMetric transaction_wait_time_https_rr(170);

  /**
   * generated from networking.trr_complete_load
   */
  enum class TrrCompleteLoadLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, overall load time.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrCompleteLoadLabel> trr_complete_load(171);

  /**
   * generated from networking.trr_dns_end
   */
  enum class TrrDnsEndLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, time from the DNS request being issued to the response.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrDnsEndLabel> trr_dns_end(172);

  /**
   * generated from networking.trr_dns_start
   */
  enum class TrrDnsStartLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, time from connection open to the DNS request being issued.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrDnsStartLabel> trr_dns_start(173);

  /**
   * generated from networking.trr_fetch_duration
   */
  enum class TrrFetchDurationLabel: uint16_t {
    eH1 = 0,
    eH1NetworkOnly = 1,
    eH2 = 2,
    eH2NetworkOnly = 3,
    eH3 = 4,
    eH3NetworkOnly = 5,
    e__Other__,
  };
  /**
   * Time for a successful DoH request, from AsyncOpen to ReturnData
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrFetchDurationLabel> trr_fetch_duration(174);

  /**
   * generated from networking.trr_first_sent_to_last_received
   */
  enum class TrrFirstSentToLastReceivedLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, time from first byte of request sent to last byte of response received.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrFirstSentToLastReceivedLabel> trr_first_sent_to_last_received(175);

  /**
   * generated from networking.trr_open_to_first_received
   */
  enum class TrrOpenToFirstReceivedLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, time from open to first byte of reply received.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrOpenToFirstReceivedLabel> trr_open_to_first_received(176);

  /**
   * generated from networking.trr_open_to_first_sent
   */
  enum class TrrOpenToFirstSentLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, time from open to first byte of request.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrOpenToFirstSentLabel> trr_open_to_first_sent(177);

  /**
   * generated from networking.trr_request_count
   */
  enum class TrrRequestCountLabel: uint16_t {
    eRegular = 0,
    ePrivate = 1,
    e__Other__,
  };
  /**
   * The count of successful TRR requests keyed by regular/private browsing
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TrrRequestCountLabel> trr_request_count(178);

  /**
   * generated from networking.trr_request_count_per_conn
   */
  enum class TrrRequestCountPerConnLabel: uint16_t {
    eMozillaCloudflareDnsComH1 = 0,
    eFirefoxDnsNextdnsIoH1 = 1,
    ePrivateCanadianshieldCiraCaH1 = 2,
    eDohXfinityComH1 = 3,
    eDnsShawCaH1 = 4,
    eDoohCloudflareDnsComH1 = 5,
    eMozillaCloudflareDnsComH2 = 6,
    eFirefoxDnsNextdnsIoH2 = 7,
    ePrivateCanadianshieldCiraCaH2 = 8,
    eDohXfinityComH2 = 9,
    eDnsShawCaH2 = 10,
    eDoohCloudflareDnsComH2 = 11,
    eMozillaCloudflareDnsComH3 = 12,
    eFirefoxDnsNextdnsIoH3 = 13,
    ePrivateCanadianshieldCiraCaH3 = 14,
    eDohXfinityComH3 = 15,
    eDnsShawCaH3 = 16,
    eDoohCloudflareDnsComH3 = 17,
    e__Other__,
  };
  /**
   * Number of DOH requests per connection keyed by HTTP version
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TrrRequestCountPerConnLabel> trr_request_count_per_conn(179);

  /**
   * generated from networking.trr_request_size
   */
  enum class TrrRequestSizeLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, the size of the HTTP request.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, TrrRequestSizeLabel> trr_request_size(180);

  /**
   * generated from networking.trr_response_size
   */
  enum class TrrResponseSizeLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, the size of the HTTP response.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, TrrResponseSizeLabel> trr_response_size(181);

  /**
   * generated from networking.trr_tcp_connection
   */
  enum class TrrTcpConnectionLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, time from the TCP SYN packet is received to the connection is established and ready for HTTP.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrTcpConnectionLabel> trr_tcp_connection(182);

  /**
   * generated from networking.trr_tls_handshake
   */
  enum class TrrTlsHandshakeLabel: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * In TRR channel, time from after the TCP SYN packet is received to the secure connection is established and ready for HTTP.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrTlsHandshakeLabel> trr_tls_handshake(183);
}

namespace network {
  /**
   * generated from network.backgroundfilesaver_thread_count
   * Maximum number of concurrent threads reached during a given download session
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram BACKGROUNDFILESAVER_THREAD_COUNT.
   */
  constexpr impl::CustomDistributionMetric backgroundfilesaver_thread_count(4285);

  /**
   * generated from network.id
   * Network identification (0=None, 1=New Ipv4, 2=Same, 3=New IPv6, 4=New dual)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram NETWORK_ID2.
   */
  constexpr impl::CustomDistributionMetric id(4286);

  /**
   * generated from network.id_online
   */
  enum class IdOnlineLabel: uint16_t {
    eAbsent = 0,
    ePresent = 1,
    e__Other__,
  };
  /**
   * Network ID presence when the network connectivity checker reports that we have connectivity
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram NETWORK_ID_ONLINE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, IdOnlineLabel> id_online(4287);

  /**
   * generated from network.ipv4_and_ipv6_address_connectivity
   * Count the number of 0) successful connections to an ipv4 address, 1) failed connection an ipv4 address, 2) successful connection to an ipv6 address and 3) failed connections to an ipv6 address.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram IPV4_AND_IPV6_ADDRESS_CONNECTIVITY.
   */
  constexpr impl::CustomDistributionMetric ipv4_and_ipv6_address_connectivity(4288);

  /**
   * generated from network.rel_preload_miss_ratio
   */
  enum class RelPreloadMissRatioLabel: uint16_t {
    eTypeScriptUsed = 0,
    eTypeScriptUnused = 1,
    eTypeStyleUsed = 2,
    eTypeStyleUnused = 3,
    eTypeImageUsed = 4,
    eTypeImageUnused = 5,
    eTypeFontUsed = 6,
    eTypeFontUnused = 7,
    eTypeFetchUsed = 8,
    eTypeFetchUnused = 9,
    e__Other__,
  };
  /**
   * Ratio of used and unused resources preloaded with link rel=preload tag or response header, broken down by supported resource type.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram REL_PRELOAD_MISS_RATIO.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, RelPreloadMissRatioLabel> rel_preload_miss_ratio(4289);

  /**
   * generated from network.ssl_token_cache_expired
   * Counts the number of expired session resumption tokens encountered during cache lookups. High values may indicate token lifetime issues or long delays between connections to the same host.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ssl_token_cache_expired(4290);

  /**
   * generated from network.ssl_token_cache_hits
   */
  enum class SslTokenCacheHitsLabel: uint16_t {
    eHit = 0,
    eMiss = 1,
    e__Other__,
  };
  /**
   * Counts session resumption token cache hits and misses. A 'hit' means a valid cached token was found and can be used for session resumption. A 'miss' means no valid token was available.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SslTokenCacheHitsLabel> ssl_token_cache_hits(4291);

  /**
   * generated from network.urlclassifier_harmful_addon_block
   */
  struct UrlclassifierHarmfulAddonBlockExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> etld;
    mozilla::Maybe<nsCString> table;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (etld) {
        extraKeys.AppendElement()->AssignASCII("etld");
        extraValues.EmplaceBack(etld.value());
      }
      if (table) {
        extraKeys.AppendElement()->AssignASCII("table");
        extraValues.EmplaceBack(table.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A classified network request initiated by a WebExtension was blocked by the addon-protection feature.
   */
  constexpr impl::EventMetric<UrlclassifierHarmfulAddonBlockExtra> urlclassifier_harmful_addon_block(4292);
}

namespace network_cookies {
  /**
   * generated from network.cookies.sqlite_open_readahead
   * Time spent on cookie DB open with readahead (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MOZ_SQLITE_COOKIES_OPEN_READAHEAD_MS.
   */
  constexpr impl::TimingDistributionMetric sqlite_open_readahead(4394);
}

namespace network_dns {
  /**
   * generated from network.dns.trr_confirmation_context
   */
  struct TrrConfirmationContextExtra {
    mozilla::Maybe<uint32_t> attemptcount;
    mozilla::Maybe<nsCString> captiveportal;
    mozilla::Maybe<nsCString> contextreason;
    mozilla::Maybe<nsCString> failedlookups;
    mozilla::Maybe<nsCString> networkid;
    mozilla::Maybe<nsCString> results;
    mozilla::Maybe<nsCString> time;
    mozilla::Maybe<nsCString> trigger;
    mozilla::Maybe<uint32_t> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (attemptcount) {
        extraKeys.AppendElement()->AssignASCII("attemptCount");
        extraValues.AppendElement()->AppendInt(attemptcount.value());
      }
      if (captiveportal) {
        extraKeys.AppendElement()->AssignASCII("captivePortal");
        extraValues.EmplaceBack(captiveportal.value());
      }
      if (contextreason) {
        extraKeys.AppendElement()->AssignASCII("contextReason");
        extraValues.EmplaceBack(contextreason.value());
      }
      if (failedlookups) {
        extraKeys.AppendElement()->AssignASCII("failedLookups");
        extraValues.EmplaceBack(failedlookups.value());
      }
      if (networkid) {
        extraKeys.AppendElement()->AssignASCII("networkID");
        extraValues.EmplaceBack(networkid.value());
      }
      if (results) {
        extraKeys.AppendElement()->AssignASCII("results");
        extraValues.EmplaceBack(results.value());
      }
      if (time) {
        extraKeys.AppendElement()->AssignASCII("time");
        extraValues.EmplaceBack(time.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.AppendElement()->AppendInt(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This telemetry records the status of the TRR confirmation across. The value of the event is one of:   "ok"   "trying" This event was generated to correspond to the Legacy Telemetry event network.dns.trrConfirmation#context.
   */
  constexpr impl::EventMetric<TrrConfirmationContextExtra> trr_confirmation_context(4395);
}

namespace network_sso {
  /**
   * generated from network.sso.entra_success
   */
  enum class EntraSuccessLabel: uint16_t {
    eSuccess = 0,
    eDeviceHeadersMissing = 1,
    ePrtHeadersMissing = 2,
    eBothHeadersMissing = 3,
    eInvalidCookie = 4,
    eNoCredential = 5,
    eBrokerError = 6,
    eInvalidControllerSetup = 7,
    e__Other__,
  };
  /**
   * Counts how often Entra SSO succeeded/failed (macOS only). Labels are ordered in reverse chronological relation to SSO success, meaning the labels higher up are closer to the SSO success. device_headers_missing: only device_headers is missing in the SSO cookie. prt_headers_missing: only prt_headers is missing in the SSO cookie. both_headers_missing: both prt_headers and device_headers are missing in the SSO cookie. invalid_cookie: Failed to parse SSO cookie (could be a null cookie/format is incorrect). no_credential: ASAuthorizationSingleSignOnCredential is not present broker_error: An error from Microsoft's broker. invalid_controller_setup: ASAuthorizationController is setup incorrectly.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, EntraSuccessLabel> entra_success(4396);

  /**
   * generated from network.sso.total_entra_uses
   * Counts how often Entra SSO is used (macOS only).
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> total_entra_uses(4397);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNetwerkMetrics_h
