// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanWidgetMetrics_h
#define mozilla_GleanWidgetMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace gfx {
  /**
   * generated from gfx.adapters
   */

  struct AdaptersObjectItem {
    Maybe<nsCString> description;
    Maybe<nsCString> vendorID;
    Maybe<nsCString> deviceID;
    Maybe<nsCString> subsysID;
    Maybe<int64_t> RAM;
    Maybe<nsCString> driver;
    Maybe<nsCString> driverVendor;
    Maybe<nsCString> driverVersion;
    Maybe<nsCString> driverDate;
    Maybe<bool> GPUActive;
  };

  using AdaptersObject = nsTArray<AdaptersObjectItem>;
  /**
   * Information about the primary (and secondary, if available) graphics adapter.
   * * description - e.g. "Intel(R) HD Graphics 4600"
   * * vendorID - Hex vendor id
   * * deviceID - Hex device id
   * * subsysID - Hex subsys id
   * * RAM - reported RAM in megabytes.
   * * driver - Platform-specific driver information.
   * * driverVendor - Driver vendor information.
   * * driverVersion - Driver version.
   * * driverDate - Driver date.
   * * GPUActive - Whether this adapter is active.
   */
  constexpr impl::ObjectMetric<AdaptersObject, struct AdaptersObjectTag> adapters(4079);

  /**
   * generated from gfx.content_backend
   * The content backend (e.g. "Direct2D 1.1", "Skia", "Cairo").
   */
  constexpr impl::StringMetric content_backend(4080);

  /**
   * generated from gfx.dwrite_enabled
   * Whether DirectWrite is enabled. (Windows-only)
   */
  constexpr impl::BooleanMetric dwrite_enabled(4081);

  /**
   * generated from gfx.headless
   * Whether the app's running in headless mode (e.g. via `MOZ_HEADLESS`).
   */
  constexpr impl::BooleanMetric headless(4082);

  /**
   * generated from gfx.monitors
   */

  struct MonitorsObjectItem {
    Maybe<int64_t> screenWidth;
    Maybe<int64_t> screenHeight;
    Maybe<nsCString> defaultCSSScaleFactor;
    Maybe<nsCString> contentsScaleFactor;
    Maybe<int64_t> refreshRate;
    Maybe<bool> pseudoDisplay;
  };

  using MonitorsObject = nsTArray<MonitorsObjectItem>;
  /**
   * Information about connected monitors.
   * On Linux only a single monitor is returned for the primary screen.
   * * screenWidth - Screen width in pixels
   * * screenHeight - Screen height in pixels
   * * defaultCSSScaleFactor - The default number of device pixels per unscaled CSS pixel for this screen.
   * * contentsScaleFactor - The number of device pixels per desktop pixel for this screen.
   * * refreshRate - (Windows only) The target screen refresh rate, in Hz, or 0 if unknown.
   * * pseudoDislay - (Windows only) Whether the screen is a pseudo display.
   */
  constexpr impl::ObjectMetric<MonitorsObject, struct MonitorsObjectTag> monitors(4083);

  /**
   * generated from gfx.target_frame_rate
   * The frame rate in Hz, typically 60 or more.
   */
  constexpr impl::QuantityMetric target_frame_rate(4084);

  /**
   * generated from gfx.text_scale_factor
   * The text scale factor.
   */
  constexpr impl::StringMetric text_scale_factor(4085);
}

template <>
inline void impl::ObjectMetric<gfx::AdaptersObject, gfx::AdaptersObjectTag>::Set(const gfx::AdaptersObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.description.isSome()) {
          writer.StringProperty("description", *(aobjItem.description));
        }
        if (aobjItem.vendorID.isSome()) {
          writer.StringProperty("vendorID", *(aobjItem.vendorID));
        }
        if (aobjItem.deviceID.isSome()) {
          writer.StringProperty("deviceID", *(aobjItem.deviceID));
        }
        if (aobjItem.subsysID.isSome()) {
          writer.StringProperty("subsysID", *(aobjItem.subsysID));
        }
        if (aobjItem.RAM.isSome()) {
          writer.IntProperty("RAM", *(aobjItem.RAM));
        }
        if (aobjItem.driver.isSome()) {
          writer.StringProperty("driver", *(aobjItem.driver));
        }
        if (aobjItem.driverVendor.isSome()) {
          writer.StringProperty("driverVendor", *(aobjItem.driverVendor));
        }
        if (aobjItem.driverVersion.isSome()) {
          writer.StringProperty("driverVersion", *(aobjItem.driverVersion));
        }
        if (aobjItem.driverDate.isSome()) {
          writer.StringProperty("driverDate", *(aobjItem.driverDate));
        }
        if (aobjItem.GPUActive.isSome()) {
          writer.BoolProperty("GPUActive", *(aobjItem.GPUActive));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<gfx::MonitorsObject, gfx::MonitorsObjectTag>::Set(const gfx::MonitorsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.screenWidth.isSome()) {
          writer.IntProperty("screenWidth", *(aobjItem.screenWidth));
        }
        if (aobjItem.screenHeight.isSome()) {
          writer.IntProperty("screenHeight", *(aobjItem.screenHeight));
        }
        if (aobjItem.defaultCSSScaleFactor.isSome()) {
          writer.StringProperty("defaultCSSScaleFactor", *(aobjItem.defaultCSSScaleFactor));
        }
        if (aobjItem.contentsScaleFactor.isSome()) {
          writer.StringProperty("contentsScaleFactor", *(aobjItem.contentsScaleFactor));
        }
        if (aobjItem.refreshRate.isSome()) {
          writer.IntProperty("refreshRate", *(aobjItem.refreshRate));
        }
        if (aobjItem.pseudoDisplay.isSome()) {
          writer.BoolProperty("pseudoDisplay", *(aobjItem.pseudoDisplay));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

namespace widget {
  /**
   * generated from widget.dark_mode
   * Whether the OS theme is dark. This metric was generated to correspond to the Legacy Telemetry scalar widget.dark_mode.
   */
  constexpr impl::BooleanMetric dark_mode(6250);

  /**
   * generated from widget.notify_idle
   * Time spent checking for and notifying listeners that the user is idle (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IDLE_NOTIFY_IDLE_MS.
   */
  constexpr impl::TimingDistributionMetric notify_idle(6251);

  /**
   * generated from widget.pointing_devices
   */
  enum class PointingDevicesLabel: uint16_t {
    eMouse = 0,
    eTouch = 1,
    ePen = 2,
    e__Other__,
  };
  /**
   * Whether the system has any matching pointing device for each label.
   */
  constexpr impl::Labeled<impl::BooleanMetric, PointingDevicesLabel> pointing_devices(6252);
}

namespace gfx_features {
  /**
   * generated from gfx.features.compositor
   * Layers backend for compositing.
   * One of "d3d9", "d3d11", "opengl", "basic", or "none".
   * "none" indicates no compositors have been created.
   */
  constexpr impl::StringMetric compositor(6256);

  /**
   * generated from gfx.features.d3d11
   */

  struct D3d11Object {
    Maybe<nsCString> status;
    Maybe<bool> warp;
    Maybe<bool> textureSharing;
    Maybe<int64_t> version;
    Maybe<bool> blocklisted;
  };
  /**
   * (Windows-only) information about the D3D11 compositor.
   * * status - One of
   *   * "unused"      - This feature has not been requested.
   *   * "unavailable" - Safe Mode or OS restriction prevents use.
   *   * "blocked"     - An internal condition (such as safe mode) prevents use.
   *   * "blocklisted" - Blocked due to a blocklist restriction.
   *   * "denied"      - Blocked due to allowlist restrictions.
   *   * "disabled"    - User explicitly disabled this default feature.
   *   * "failed"      - Feature failed to initialize.
   *   * "available"   - User has this feature available by default.
   *             optionally including ":" followed by a reason
   *             e.g. "FEATURE_FAILURE_WEBRENDER_VIDEO_CRASH_INTEL_23.20.16.4973".
   * * warp - Software rendering (WARP) mode was chosen.
   * * textureSharing - Whether or not texture sharing works.
   * * version - The D3D11 device feature level.
   * * blocklisted - Whether D3D11 is blocklisted; use to see whether WARP
   *                 was blacklist induced or driver-failure induced.
   */
  constexpr impl::ObjectMetric<D3d11Object, struct D3d11ObjectTag> d3d11(6257);

  /**
   * generated from gfx.features.gpu_process
   */

  struct GpuProcessObject {
    Maybe<nsCString> status;
  };
  /**
   * Information about the out-of-process compositing ("GPU Process") GFX feature.
   * * status - One of
   *   * "unused"      - This feature has not been requested.
   *   * "unavailable" - Safe Mode or OS restriction prevents use.
   *   * "blocked"     - An internal condition (such as safe mode) prevents use.
   *   * "blocklisted" - Blocked due to a blocklist restriction.
   *   * "denied"      - Blocked due to allowlist restrictions.
   *   * "disabled"    - User explicitly disabled this default feature.
   *   * "failed"      - Feature failed to initialize.
   *   * "available"   - User has this feature available by default and it's in use.
   *             optionally including ":" followed by a reason
   *             e.g. "FEATURE_FAILURE_WEBRENDER_VIDEO_CRASH_INTEL_23.20.16.4973".
   */
  constexpr impl::ObjectMetric<GpuProcessObject, struct GpuProcessObjectTag> gpu_process(6258);

  /**
   * generated from gfx.features.hw_compositing
   */

  struct HwCompositingObject {
    Maybe<nsCString> status;
  };
  /**
   * Information about the hardware acceleration GFX feature.
   * (i.e. whether we try using the GPU)
   * * status - One of
   *   * "unused"      - This feature has not been requested.
   *   * "unavailable" - Safe Mode or OS restriction prevents use.
   *   * "blocked"     - An internal condition (such as safe mode) prevents use.
   *   * "blocklisted" - Blocked due to a blocklist restriction.
   *   * "denied"      - Blocked due to allowlist restrictions.
   *   * "disabled"    - User explicitly disabled this default feature.
   *   * "failed"      - Feature failed to initialize.
   *   * "available"   - User has this feature available by default.
   *             optionally including ":" followed by a reason
   *             e.g. "FEATURE_FAILURE_WEBRENDER_VIDEO_CRASH_INTEL_23.20.16.4973".
   */
  constexpr impl::ObjectMetric<HwCompositingObject, struct HwCompositingObjectTag> hw_compositing(6259);

  /**
   * generated from gfx.features.omtp
   */

  struct OmtpObject {
    Maybe<nsCString> status;
  };
  /**
   * Information about the Off Main Thread Painting GFX feature.
   * * status - One of
   *   * "unused"      - This feature has not been requested.
   *   * "unavailable" - Safe Mode or OS restriction prevents use.
   *   * "blocked"     - An internal condition (such as safe mode) prevents use.
   *   * "blocklisted" - Blocked due to a blocklist restriction.
   *   * "denied"      - Blocked due to allowlist restrictions.
   *   * "disabled"    - User explicitly disabled this default feature.
   *   * "failed"      - Feature failed to initialize.
   *   * "available"   - User has this feature available by default.
   *             optionally including ":" followed by a reason
   *             e.g. "FEATURE_FAILURE_WEBRENDER_VIDEO_CRASH_INTEL_23.20.16.4973".
   */
  constexpr impl::ObjectMetric<OmtpObject, struct OmtpObjectTag> omtp(6260);

  /**
   * generated from gfx.features.opengl_compositing
   */

  struct OpenglCompositingObject {
    Maybe<nsCString> status;
  };
  /**
   * Information about the OpenGL Compositing GFX feature.
   * * status - One of
   *   * "unused"      - This feature has not been requested.
   *   * "unavailable" - Safe Mode or OS restriction prevents use.
   *   * "blocked"     - An internal condition (such as safe mode) prevents use.
   *   * "blocklisted" - Blocked due to a blocklist restriction.
   *   * "denied"      - Blocked due to allowlist restrictions.
   *   * "disabled"    - User explicitly disabled this default feature.
   *   * "failed"      - Feature failed to initialize.
   *   * "available"   - User has this feature available by default.
   *             optionally including ":" followed by a reason
   *             e.g. "FEATURE_FAILURE_WEBRENDER_VIDEO_CRASH_INTEL_23.20.16.4973".
   */
  constexpr impl::ObjectMetric<OpenglCompositingObject, struct OpenglCompositingObjectTag> opengl_compositing(6261);

  /**
   * generated from gfx.features.webrender
   */

  struct WebrenderObject {
    Maybe<nsCString> status;
  };
  /**
   * Information about the Webrender GFX feature.
   * * status - One of
   *   * "unused"      - This feature has not been requested.
   *   * "unavailable" - Safe Mode or OS restriction prevents use.
   *   * "blocked"     - An internal condition (such as safe mode) prevents use.
   *   * "blocklisted" - Blocked due to a blocklist restriction.
   *   * "denied"      - Blocked due to allowlist restrictions.
   *   * "disabled"    - User explicitly disabled this default feature.
   *   * "failed"      - Feature failed to initialize.
   *   * "available"   - User has this feature available by default.
   *             optionally including ":" followed by a reason
   *             e.g. "FEATURE_FAILURE_WEBRENDER_VIDEO_CRASH_INTEL_23.20.16.4973".
   */
  constexpr impl::ObjectMetric<WebrenderObject, struct WebrenderObjectTag> webrender(6262);

  /**
   * generated from gfx.features.wr_compositor
   */

  struct WrCompositorObject {
    Maybe<nsCString> status;
  };
  /**
   * Information about the native OS compositor (CA, DCamp, etc.).
   * * status - One of
   *   * "unused"      - This feature has not been requested.
   *   * "unavailable" - Safe Mode or OS restriction prevents use.
   *   * "blocked"     - An internal condition (such as safe mode) prevents use.
   *   * "blocklisted" - Blocked due to a blocklist restriction.
   *   * "denied"      - Blocked due to allowlist restrictions.
   *   * "disabled"    - User explicitly disabled this default feature.
   *   * "failed"      - Feature failed to initialize.
   *   * "available"   - User has this feature available by default.
   *             optionally including ":" followed by a reason
   *             e.g. "FEATURE_FAILURE_WEBRENDER_VIDEO_CRASH_INTEL_23.20.16.4973".
   */
  constexpr impl::ObjectMetric<WrCompositorObject, struct WrCompositorObjectTag> wr_compositor(6263);
}

template <>
inline void impl::ObjectMetric<gfx_features::D3d11Object, gfx_features::D3d11ObjectTag>::Set(const gfx_features::D3d11Object& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.status.isSome()) {
      writer.StringProperty("status", *(aObj.status));
    }
    if (aObj.warp.isSome()) {
      writer.BoolProperty("warp", *(aObj.warp));
    }
    if (aObj.textureSharing.isSome()) {
      writer.BoolProperty("textureSharing", *(aObj.textureSharing));
    }
    if (aObj.version.isSome()) {
      writer.IntProperty("version", *(aObj.version));
    }
    if (aObj.blocklisted.isSome()) {
      writer.BoolProperty("blocklisted", *(aObj.blocklisted));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<gfx_features::GpuProcessObject, gfx_features::GpuProcessObjectTag>::Set(const gfx_features::GpuProcessObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.status.isSome()) {
      writer.StringProperty("status", *(aObj.status));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<gfx_features::HwCompositingObject, gfx_features::HwCompositingObjectTag>::Set(const gfx_features::HwCompositingObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.status.isSome()) {
      writer.StringProperty("status", *(aObj.status));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<gfx_features::OmtpObject, gfx_features::OmtpObjectTag>::Set(const gfx_features::OmtpObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.status.isSome()) {
      writer.StringProperty("status", *(aObj.status));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<gfx_features::OpenglCompositingObject, gfx_features::OpenglCompositingObjectTag>::Set(const gfx_features::OpenglCompositingObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.status.isSome()) {
      writer.StringProperty("status", *(aObj.status));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<gfx_features::WebrenderObject, gfx_features::WebrenderObjectTag>::Set(const gfx_features::WebrenderObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.status.isSome()) {
      writer.StringProperty("status", *(aObj.status));
    }
  }
  writer.EndObject();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<gfx_features::WrCompositorObject, gfx_features::WrCompositorObjectTag>::Set(const gfx_features::WrCompositorObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.status.isSome()) {
      writer.StringProperty("status", *(aObj.status));
    }
  }
  writer.EndObject();


  SetStr(json);
}

} // namespace mozilla::glean

#endif // mozilla_GleanWidgetMetrics_h
