/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/base/nsIBaseChannel.idl
 */

#ifndef __gen_nsIBaseChannel_h__
#define __gen_nsIBaseChannel_h__


#include "nsISupports.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
// %{C++:8-9
#include "mozilla/dom/MimeType.h"
#include "mozilla/net/ContentRange.h"
// %}

/* starting interface:    nsIBaseChannel */
#define NS_IBASECHANNEL_IID_STR "036d5cd7-9a53-40e3-9c72-c2ffaa15aa2b"

#define NS_IBASECHANNEL_IID \
  {0x036d5cd7, 0x9a53, 0x40e3, \
    { 0x9c, 0x72, 0xc2, 0xff, 0xaa, 0x15, 0xaa, 0x2b }}

class nsIBaseChannel : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IBASECHANNEL_IID)

  /* attribute ContentRangeRef contentRange; */
  NS_IMETHOD GetContentRange(RefPtr<mozilla::net::ContentRange> * aContentRange) = 0;
  NS_IMETHOD SetContentRange(RefPtr<mozilla::net::ContentRange> aContentRange) = 0;

  /* attribute MimeTypeRef fullMimeType; */
  NS_IMETHOD GetFullMimeType(RefPtr<TMimeType<char>> * aFullMimeType) = 0;
  NS_IMETHOD SetFullMimeType(RefPtr<TMimeType<char>> aFullMimeType) = 0;

// %{C++:40-60
  RefPtr<mozilla::net::ContentRange> ContentRange() {
    RefPtr<mozilla::net::ContentRange> range;
    (void)GetContentRange(&range);
    return range;
  }

  bool SetContentRangeFromHeader(const nsACString& aHeader, uint64_t aSize) {
    RefPtr<mozilla::net::ContentRange> range =
      new mozilla::net::ContentRange(aHeader, aSize);
    if (!range->IsValid()) {
      return false;
    }
    SetContentRange(range);
    return true;
  }

  RefPtr<CMimeType> FullMimeType() {
    RefPtr<CMimeType> type;
    (void)GetFullMimeType(&type);
    return type;
  }
// %}
};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBASECHANNEL \
  NS_IMETHOD GetContentRange(RefPtr<mozilla::net::ContentRange> * aContentRange) override; \
  NS_IMETHOD SetContentRange(RefPtr<mozilla::net::ContentRange> aContentRange) override; \
  NS_IMETHOD GetFullMimeType(RefPtr<TMimeType<char>> * aFullMimeType) override; \
  NS_IMETHOD SetFullMimeType(RefPtr<TMimeType<char>> aFullMimeType) override; \

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIBASECHANNEL \
  nsresult GetContentRange(RefPtr<mozilla::net::ContentRange> * aContentRange); \
  nsresult SetContentRange(RefPtr<mozilla::net::ContentRange> aContentRange); \
  nsresult GetFullMimeType(RefPtr<TMimeType<char>> * aFullMimeType); \
  nsresult SetFullMimeType(RefPtr<TMimeType<char>> aFullMimeType); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBASECHANNEL(_to) \
  NS_IMETHOD GetContentRange(RefPtr<mozilla::net::ContentRange> * aContentRange) override { return _to GetContentRange(aContentRange); } \
  NS_IMETHOD SetContentRange(RefPtr<mozilla::net::ContentRange> aContentRange) override { return _to SetContentRange(aContentRange); } \
  NS_IMETHOD GetFullMimeType(RefPtr<TMimeType<char>> * aFullMimeType) override { return _to GetFullMimeType(aFullMimeType); } \
  NS_IMETHOD SetFullMimeType(RefPtr<TMimeType<char>> aFullMimeType) override { return _to SetFullMimeType(aFullMimeType); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBASECHANNEL(_to) \
  NS_IMETHOD GetContentRange(RefPtr<mozilla::net::ContentRange> * aContentRange) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContentRange(aContentRange); } \
  NS_IMETHOD SetContentRange(RefPtr<mozilla::net::ContentRange> aContentRange) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetContentRange(aContentRange); } \
  NS_IMETHOD GetFullMimeType(RefPtr<TMimeType<char>> * aFullMimeType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFullMimeType(aFullMimeType); } \
  NS_IMETHOD SetFullMimeType(RefPtr<TMimeType<char>> aFullMimeType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFullMimeType(aFullMimeType); } \


#endif /* __gen_nsIBaseChannel_h__ */
