/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/dom/interfaces/security/nsIContentSecurityPolicy.idl
 */

#ifndef __gen_nsIContentSecurityPolicy_h__
#define __gen_nsIContentSecurityPolicy_h__


#include "nsISerializable.h"

#include "nsIContentPolicy.h"

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Assertions.h"
#include "mozilla/DebugOnly.h"

#include "js/GCAnnotations.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */

class nsIEventTarget; /* forward declaration */

class nsILoadInfo; /* forward declaration */

class nsIPrincipal; /* forward declaration */

class nsICSPEventListener; /* forward declaration */

namespace mozilla {
namespace dom {
class Element; /* webidl Element */
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
class Document; /* webidl Document */
} // namespace dom
} // namespace mozilla

// %{C++:25-28
class nsCSPPolicy;
namespace mozilla::dom {
struct CSPViolationData;
}
// %}

/* starting interface:    nsIContentSecurityPolicy */
#define NS_ICONTENTSECURITYPOLICY_IID_STR "1d632008-6c97-48ae-a51c-16e2daa0f4f6"

#define NS_ICONTENTSECURITYPOLICY_IID \
  {0x1d632008, 0x6c97, 0x48ae, \
    { 0xa5, 0x1c, 0x16, 0xe2, 0xda, 0xa0, 0xf4, 0xf6 }}

class nsIContentSecurityPolicy : public nsISerializable {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ICONTENTSECURITYPOLICY_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIContentSecurityPolicy;

  enum CSPDirective : uint8_t {
    NO_DIRECTIVE = 0,
    DEFAULT_SRC_DIRECTIVE = 1,
    SCRIPT_SRC_DIRECTIVE = 2,
    OBJECT_SRC_DIRECTIVE = 3,
    STYLE_SRC_DIRECTIVE = 4,
    IMG_SRC_DIRECTIVE = 5,
    MEDIA_SRC_DIRECTIVE = 6,
    FRAME_SRC_DIRECTIVE = 7,
    FONT_SRC_DIRECTIVE = 8,
    CONNECT_SRC_DIRECTIVE = 9,
    REPORT_URI_DIRECTIVE = 10,
    FRAME_ANCESTORS_DIRECTIVE = 11,
    REFLECTED_XSS_DIRECTIVE = 12,
    BASE_URI_DIRECTIVE = 13,
    FORM_ACTION_DIRECTIVE = 14,
    WEB_MANIFEST_SRC_DIRECTIVE = 15,
    UPGRADE_IF_INSECURE_DIRECTIVE = 16,
    CHILD_SRC_DIRECTIVE = 17,
    BLOCK_ALL_MIXED_CONTENT = 18,
    SANDBOX_DIRECTIVE = 19,
    WORKER_SRC_DIRECTIVE = 20,
    SCRIPT_SRC_ELEM_DIRECTIVE = 21,
    SCRIPT_SRC_ATTR_DIRECTIVE = 22,
    STYLE_SRC_ELEM_DIRECTIVE = 23,
    STYLE_SRC_ATTR_DIRECTIVE = 24,
    REQUIRE_TRUSTED_TYPES_FOR_DIRECTIVE = 25,
    TRUSTED_TYPES_DIRECTIVE = 26,
    REPORT_TO_DIRECTIVE = 27,
  };

  enum RequireTrustedTypesForDirectiveState : uint8_t {
    NONE = 0,
    REPORT_ONLY = 1,
    ENFORCE = 2,
  };

  /* [binaryname(GetPolicyString)] AString getPolicy (in unsigned long index); */
  NS_IMETHOD GetPolicyString(uint32_t index, nsAString& _retval) = 0;

  /* [noscript,nostdcall,notxpcom] CSPPolicyPtr GetPolicy (in unsigned long index); */
  virtual const nsCSPPolicy * GetPolicy(uint32_t index) = 0;

  /* readonly attribute unsigned long policyCount; */
  NS_IMETHOD GetPolicyCount(uint32_t *aPolicyCount) = 0;

  /* readonly attribute boolean upgradeInsecureRequests; */
  NS_IMETHOD GetUpgradeInsecureRequests(bool *aUpgradeInsecureRequests) = 0;

  /* readonly attribute boolean blockAllMixedContent; */
  NS_IMETHOD GetBlockAllMixedContent(bool *aBlockAllMixedContent) = 0;

  /* readonly attribute boolean enforcesFrameAncestors; */
  NS_IMETHOD GetEnforcesFrameAncestors(bool *aEnforcesFrameAncestors) = 0;

  /* void appendPolicy (in AString policyString, in boolean reportOnly, in boolean deliveredViaMetaTag); */
  NS_IMETHOD AppendPolicy(const nsAString& policyString, bool reportOnly, bool deliveredViaMetaTag) = 0;

  /* [infallible] readonly attribute nsIContentSecurityPolicy_RequireTrustedTypesForDirectiveState requireTrustedTypesForDirectiveState; */
  NS_IMETHOD GetRequireTrustedTypesForDirectiveState(nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState *aRequireTrustedTypesForDirectiveState) = 0;
  inline nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState  GetRequireTrustedTypesForDirectiveState()
  {
    nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState result;
    mozilla::DebugOnly<nsresult> rv = GetRequireTrustedTypesForDirectiveState(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* boolean getAllowsInline (in nsIContentSecurityPolicy_CSPDirective aDirective, in boolean aHasUnsafeHash, in AString aNonce, in boolean aParserCreated, in Element aTriggeringElement, in nsICSPEventListener aCSPEventListener, in AString aSourceText, in unsigned long aLineNumber, in unsigned long aColumnNumber); */
  NS_IMETHOD GetAllowsInline(nsIContentSecurityPolicy::CSPDirective aDirective, bool aHasUnsafeHash, const nsAString& aNonce, bool aParserCreated, mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, const nsAString& aSourceText, uint32_t aLineNumber, uint32_t aColumnNumber, bool *_retval) = 0;

  /* boolean getAllowsEval (out boolean shouldReportViolations); */
  NS_IMETHOD GetAllowsEval(bool *shouldReportViolations, bool *_retval) = 0;

  /* boolean getAllowsWasmEval (out boolean shouldReportViolations); */
  NS_IMETHOD GetAllowsWasmEval(bool *shouldReportViolations, bool *_retval) = 0;

  /* uint32_t getCSPSandboxFlags (); */
  NS_IMETHOD GetCSPSandboxFlags(uint32_t *_retval) = 0;

  /* void logViolationDetails (in unsigned short violationType, in Element triggeringElement, in nsICSPEventListener aCSPEventListener, in ACString sourceFile, in AString scriptSample, in int32_t lineNum, in int32_t columnNum, [optional] in AString nonce, [optional] in AString content); */
  NS_IMETHOD LogViolationDetails(uint16_t violationType, mozilla::dom::Element *triggeringElement, nsICSPEventListener *aCSPEventListener, const nsACString& sourceFile, const nsAString& scriptSample, int32_t lineNum, int32_t columnNum, const nsAString& nonce, const nsAString& content) = 0;

  enum {
    VIOLATION_TYPE_EVAL = 1U,
    VIOLATION_TYPE_WASM_EVAL = 2U
  };

  /* [noscript] void logTrustedTypesViolationDetailsUnchecked (in CSPViolationData aCSPViolationData, in AString aObserverSubject, in nsICSPEventListener aCSPEventListener); */
  NS_IMETHOD LogTrustedTypesViolationDetailsUnchecked(mozilla::dom::CSPViolationData&& aCSPViolationData, const nsAString& aObserverSubject, nsICSPEventListener *aCSPEventListener) = 0;

  /* [must_use] void setRequestContextWithDocument (in Document aDocument); */
  [[nodiscard]] NS_IMETHOD SetRequestContextWithDocument(mozilla::dom::Document *aDocument) = 0;

  /* [must_use] void setRequestContextWithPrincipal (in nsIPrincipal aRequestPrincipal, in nsIURI aSelfURI, in ACString aReferrer, in unsigned long long aInnerWindowId); */
  [[nodiscard]] NS_IMETHOD SetRequestContextWithPrincipal(nsIPrincipal *aRequestPrincipal, nsIURI *aSelfURI, const nsACString& aReferrer, uint64_t aInnerWindowId) = 0;

  /* [noscript,nostdcall,notxpcom] readonly attribute nsIPrincipal requestPrincipal; */
  virtual nsIPrincipal * GetRequestPrincipal() = 0;

  /* [noscript,nostdcall,notxpcom] readonly attribute nsIURI selfURI; */
  virtual nsIURI * GetSelfURI() = 0;

  /* [noscript] readonly attribute ACString referrer; */
  NS_IMETHOD GetReferrer(nsACString& aReferrer) = 0;

  /* [noscript,nostdcall,notxpcom] readonly attribute unsigned long long innerWindowID; */
  virtual uint64_t GetInnerWindowID() = 0;

  /* [noscript,nostdcall,notxpcom] attribute boolean skipAllowInlineStyleCheck; */
  virtual bool GetSkipAllowInlineStyleCheck() = 0;
  virtual void SetSkipAllowInlineStyleCheck(bool aSkipAllowInlineStyleCheck) = 0;

  /* [noscript] void ensureEventTarget (in nsIEventTarget aEventTarget); */
  NS_IMETHOD EnsureEventTarget(nsIEventTarget *aEventTarget) = 0;

  /* boolean permitsAncestry (in nsILoadInfo aLoadInfo); */
  NS_IMETHOD PermitsAncestry(nsILoadInfo *aLoadInfo, bool *_retval) = 0;

  /* boolean permits (in Element aTriggeringElement, in nsICSPEventListener aCSPEventListener, in nsIURI aURI, in nsIContentSecurityPolicy_CSPDirective aDir, in boolean aSpecific, in boolean aSendViolationReports); */
  NS_IMETHOD Permits(mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, nsIURI *aURI, nsIContentSecurityPolicy::CSPDirective aDir, bool aSpecific, bool aSendViolationReports, bool *_retval) = 0;

  /* short shouldLoad (in nsContentPolicyType aContentType, in nsICSPEventListener aCSPEventListener, in nsILoadInfo aLoadInfo, in nsIURI aContentLocation, in nsIURI aOriginalURIIfRedirect, in boolean aSendViolationReports); */
  NS_IMETHOD ShouldLoad(nsContentPolicyType aContentType, nsICSPEventListener *aCSPEventListener, nsILoadInfo *aLoadInfo, nsIURI *aContentLocation, nsIURI *aOriginalURIIfRedirect, bool aSendViolationReports, int16_t *_retval) = 0;

// %{C++:384-385
// nsIObserver topic to fire when the policy encounters a violation.
#define CSP_VIOLATION_TOPIC "csp-on-violate-policy"
// %}
  /* AString toJSON (); */
  NS_IMETHOD ToJSON(nsAString& _retval) = 0;

  /* [noscript] void EnsureIPCPoliciesRead (); */
  NS_IMETHOD EnsureIPCPoliciesRead(void) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTENTSECURITYPOLICY \
  NS_IMETHOD GetPolicyString(uint32_t index, nsAString& _retval) override; \
  virtual const nsCSPPolicy * GetPolicy(uint32_t index) override; \
  NS_IMETHOD GetPolicyCount(uint32_t *aPolicyCount) override; \
  NS_IMETHOD GetUpgradeInsecureRequests(bool *aUpgradeInsecureRequests) override; \
  NS_IMETHOD GetBlockAllMixedContent(bool *aBlockAllMixedContent) override; \
  NS_IMETHOD GetEnforcesFrameAncestors(bool *aEnforcesFrameAncestors) override; \
  NS_IMETHOD AppendPolicy(const nsAString& policyString, bool reportOnly, bool deliveredViaMetaTag) override; \
  using nsIContentSecurityPolicy::GetRequireTrustedTypesForDirectiveState; \
  NS_IMETHOD GetRequireTrustedTypesForDirectiveState(nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState *aRequireTrustedTypesForDirectiveState) override; \
  NS_IMETHOD GetAllowsInline(nsIContentSecurityPolicy::CSPDirective aDirective, bool aHasUnsafeHash, const nsAString& aNonce, bool aParserCreated, mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, const nsAString& aSourceText, uint32_t aLineNumber, uint32_t aColumnNumber, bool *_retval) override; \
  NS_IMETHOD GetAllowsEval(bool *shouldReportViolations, bool *_retval) override; \
  NS_IMETHOD GetAllowsWasmEval(bool *shouldReportViolations, bool *_retval) override; \
  NS_IMETHOD GetCSPSandboxFlags(uint32_t *_retval) override; \
  NS_IMETHOD LogViolationDetails(uint16_t violationType, mozilla::dom::Element *triggeringElement, nsICSPEventListener *aCSPEventListener, const nsACString& sourceFile, const nsAString& scriptSample, int32_t lineNum, int32_t columnNum, const nsAString& nonce, const nsAString& content) override; \
  NS_IMETHOD LogTrustedTypesViolationDetailsUnchecked(mozilla::dom::CSPViolationData&& aCSPViolationData, const nsAString& aObserverSubject, nsICSPEventListener *aCSPEventListener) override; \
  [[nodiscard]] NS_IMETHOD SetRequestContextWithDocument(mozilla::dom::Document *aDocument) override; \
  [[nodiscard]] NS_IMETHOD SetRequestContextWithPrincipal(nsIPrincipal *aRequestPrincipal, nsIURI *aSelfURI, const nsACString& aReferrer, uint64_t aInnerWindowId) override; \
  virtual nsIPrincipal * GetRequestPrincipal() override; \
  virtual nsIURI * GetSelfURI() override; \
  NS_IMETHOD GetReferrer(nsACString& aReferrer) override; \
  virtual uint64_t GetInnerWindowID() override; \
  virtual bool GetSkipAllowInlineStyleCheck() override; \
  virtual void SetSkipAllowInlineStyleCheck(bool aSkipAllowInlineStyleCheck) override; \
  NS_IMETHOD EnsureEventTarget(nsIEventTarget *aEventTarget) override; \
  NS_IMETHOD PermitsAncestry(nsILoadInfo *aLoadInfo, bool *_retval) override; \
  NS_IMETHOD Permits(mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, nsIURI *aURI, nsIContentSecurityPolicy::CSPDirective aDir, bool aSpecific, bool aSendViolationReports, bool *_retval) override; \
  NS_IMETHOD ShouldLoad(nsContentPolicyType aContentType, nsICSPEventListener *aCSPEventListener, nsILoadInfo *aLoadInfo, nsIURI *aContentLocation, nsIURI *aOriginalURIIfRedirect, bool aSendViolationReports, int16_t *_retval) override; \
  NS_IMETHOD ToJSON(nsAString& _retval) override; \
  NS_IMETHOD EnsureIPCPoliciesRead(void) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICONTENTSECURITYPOLICY \
  nsresult GetPolicyString(uint32_t index, nsAString& _retval); \
  const nsCSPPolicy * GetPolicy(uint32_t index); \
  nsresult GetPolicyCount(uint32_t *aPolicyCount); \
  nsresult GetUpgradeInsecureRequests(bool *aUpgradeInsecureRequests); \
  nsresult GetBlockAllMixedContent(bool *aBlockAllMixedContent); \
  nsresult GetEnforcesFrameAncestors(bool *aEnforcesFrameAncestors); \
  nsresult AppendPolicy(const nsAString& policyString, bool reportOnly, bool deliveredViaMetaTag); \
  using nsIContentSecurityPolicy::GetRequireTrustedTypesForDirectiveState; \
  nsresult GetRequireTrustedTypesForDirectiveState(nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState *aRequireTrustedTypesForDirectiveState); \
  nsresult GetAllowsInline(nsIContentSecurityPolicy::CSPDirective aDirective, bool aHasUnsafeHash, const nsAString& aNonce, bool aParserCreated, mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, const nsAString& aSourceText, uint32_t aLineNumber, uint32_t aColumnNumber, bool *_retval); \
  nsresult GetAllowsEval(bool *shouldReportViolations, bool *_retval); \
  nsresult GetAllowsWasmEval(bool *shouldReportViolations, bool *_retval); \
  nsresult GetCSPSandboxFlags(uint32_t *_retval); \
  nsresult LogViolationDetails(uint16_t violationType, mozilla::dom::Element *triggeringElement, nsICSPEventListener *aCSPEventListener, const nsACString& sourceFile, const nsAString& scriptSample, int32_t lineNum, int32_t columnNum, const nsAString& nonce, const nsAString& content); \
  nsresult LogTrustedTypesViolationDetailsUnchecked(mozilla::dom::CSPViolationData&& aCSPViolationData, const nsAString& aObserverSubject, nsICSPEventListener *aCSPEventListener); \
  [[nodiscard]] nsresult SetRequestContextWithDocument(mozilla::dom::Document *aDocument); \
  [[nodiscard]] nsresult SetRequestContextWithPrincipal(nsIPrincipal *aRequestPrincipal, nsIURI *aSelfURI, const nsACString& aReferrer, uint64_t aInnerWindowId); \
  nsIPrincipal * GetRequestPrincipal(); \
  nsIURI * GetSelfURI(); \
  nsresult GetReferrer(nsACString& aReferrer); \
  uint64_t GetInnerWindowID(); \
  bool GetSkipAllowInlineStyleCheck(); \
  void SetSkipAllowInlineStyleCheck(bool aSkipAllowInlineStyleCheck); \
  nsresult EnsureEventTarget(nsIEventTarget *aEventTarget); \
  nsresult PermitsAncestry(nsILoadInfo *aLoadInfo, bool *_retval); \
  nsresult Permits(mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, nsIURI *aURI, nsIContentSecurityPolicy::CSPDirective aDir, bool aSpecific, bool aSendViolationReports, bool *_retval); \
  nsresult ShouldLoad(nsContentPolicyType aContentType, nsICSPEventListener *aCSPEventListener, nsILoadInfo *aLoadInfo, nsIURI *aContentLocation, nsIURI *aOriginalURIIfRedirect, bool aSendViolationReports, int16_t *_retval); \
  nsresult ToJSON(nsAString& _retval); \
  nsresult EnsureIPCPoliciesRead(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTENTSECURITYPOLICY(_to) \
  NS_IMETHOD GetPolicyString(uint32_t index, nsAString& _retval) override { return _to GetPolicyString(index, _retval); } \
  virtual const nsCSPPolicy * GetPolicy(uint32_t index) override { return _to GetPolicy(index); } \
  NS_IMETHOD GetPolicyCount(uint32_t *aPolicyCount) override { return _to GetPolicyCount(aPolicyCount); } \
  NS_IMETHOD GetUpgradeInsecureRequests(bool *aUpgradeInsecureRequests) override { return _to GetUpgradeInsecureRequests(aUpgradeInsecureRequests); } \
  NS_IMETHOD GetBlockAllMixedContent(bool *aBlockAllMixedContent) override { return _to GetBlockAllMixedContent(aBlockAllMixedContent); } \
  NS_IMETHOD GetEnforcesFrameAncestors(bool *aEnforcesFrameAncestors) override { return _to GetEnforcesFrameAncestors(aEnforcesFrameAncestors); } \
  NS_IMETHOD AppendPolicy(const nsAString& policyString, bool reportOnly, bool deliveredViaMetaTag) override { return _to AppendPolicy(policyString, reportOnly, deliveredViaMetaTag); } \
  using nsIContentSecurityPolicy::GetRequireTrustedTypesForDirectiveState; \
  NS_IMETHOD GetRequireTrustedTypesForDirectiveState(nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState *aRequireTrustedTypesForDirectiveState) override { return _to GetRequireTrustedTypesForDirectiveState(aRequireTrustedTypesForDirectiveState); } \
  NS_IMETHOD GetAllowsInline(nsIContentSecurityPolicy::CSPDirective aDirective, bool aHasUnsafeHash, const nsAString& aNonce, bool aParserCreated, mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, const nsAString& aSourceText, uint32_t aLineNumber, uint32_t aColumnNumber, bool *_retval) override { return _to GetAllowsInline(aDirective, aHasUnsafeHash, aNonce, aParserCreated, aTriggeringElement, aCSPEventListener, aSourceText, aLineNumber, aColumnNumber, _retval); } \
  NS_IMETHOD GetAllowsEval(bool *shouldReportViolations, bool *_retval) override { return _to GetAllowsEval(shouldReportViolations, _retval); } \
  NS_IMETHOD GetAllowsWasmEval(bool *shouldReportViolations, bool *_retval) override { return _to GetAllowsWasmEval(shouldReportViolations, _retval); } \
  NS_IMETHOD GetCSPSandboxFlags(uint32_t *_retval) override { return _to GetCSPSandboxFlags(_retval); } \
  NS_IMETHOD LogViolationDetails(uint16_t violationType, mozilla::dom::Element *triggeringElement, nsICSPEventListener *aCSPEventListener, const nsACString& sourceFile, const nsAString& scriptSample, int32_t lineNum, int32_t columnNum, const nsAString& nonce, const nsAString& content) override { return _to LogViolationDetails(violationType, triggeringElement, aCSPEventListener, sourceFile, scriptSample, lineNum, columnNum, nonce, content); } \
  NS_IMETHOD LogTrustedTypesViolationDetailsUnchecked(mozilla::dom::CSPViolationData&& aCSPViolationData, const nsAString& aObserverSubject, nsICSPEventListener *aCSPEventListener) override { return _to LogTrustedTypesViolationDetailsUnchecked(aCSPViolationData, aObserverSubject, aCSPEventListener); } \
  [[nodiscard]] NS_IMETHOD SetRequestContextWithDocument(mozilla::dom::Document *aDocument) override { return _to SetRequestContextWithDocument(aDocument); } \
  [[nodiscard]] NS_IMETHOD SetRequestContextWithPrincipal(nsIPrincipal *aRequestPrincipal, nsIURI *aSelfURI, const nsACString& aReferrer, uint64_t aInnerWindowId) override { return _to SetRequestContextWithPrincipal(aRequestPrincipal, aSelfURI, aReferrer, aInnerWindowId); } \
  virtual nsIPrincipal * GetRequestPrincipal() override { return _to GetRequestPrincipal(); } \
  virtual nsIURI * GetSelfURI() override { return _to GetSelfURI(); } \
  NS_IMETHOD GetReferrer(nsACString& aReferrer) override { return _to GetReferrer(aReferrer); } \
  virtual uint64_t GetInnerWindowID() override { return _to GetInnerWindowID(); } \
  virtual bool GetSkipAllowInlineStyleCheck() override { return _to GetSkipAllowInlineStyleCheck(); } \
  virtual void SetSkipAllowInlineStyleCheck(bool aSkipAllowInlineStyleCheck) override { return _to SetSkipAllowInlineStyleCheck(aSkipAllowInlineStyleCheck); } \
  NS_IMETHOD EnsureEventTarget(nsIEventTarget *aEventTarget) override { return _to EnsureEventTarget(aEventTarget); } \
  NS_IMETHOD PermitsAncestry(nsILoadInfo *aLoadInfo, bool *_retval) override { return _to PermitsAncestry(aLoadInfo, _retval); } \
  NS_IMETHOD Permits(mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, nsIURI *aURI, nsIContentSecurityPolicy::CSPDirective aDir, bool aSpecific, bool aSendViolationReports, bool *_retval) override { return _to Permits(aTriggeringElement, aCSPEventListener, aURI, aDir, aSpecific, aSendViolationReports, _retval); } \
  NS_IMETHOD ShouldLoad(nsContentPolicyType aContentType, nsICSPEventListener *aCSPEventListener, nsILoadInfo *aLoadInfo, nsIURI *aContentLocation, nsIURI *aOriginalURIIfRedirect, bool aSendViolationReports, int16_t *_retval) override { return _to ShouldLoad(aContentType, aCSPEventListener, aLoadInfo, aContentLocation, aOriginalURIIfRedirect, aSendViolationReports, _retval); } \
  NS_IMETHOD ToJSON(nsAString& _retval) override { return _to ToJSON(_retval); } \
  NS_IMETHOD EnsureIPCPoliciesRead(void) override { return _to EnsureIPCPoliciesRead(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTENTSECURITYPOLICY(_to) \
  NS_IMETHOD GetPolicyString(uint32_t index, nsAString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPolicyString(index, _retval); } \
  virtual const nsCSPPolicy * GetPolicy(uint32_t index) override; \
  NS_IMETHOD GetPolicyCount(uint32_t *aPolicyCount) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPolicyCount(aPolicyCount); } \
  NS_IMETHOD GetUpgradeInsecureRequests(bool *aUpgradeInsecureRequests) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUpgradeInsecureRequests(aUpgradeInsecureRequests); } \
  NS_IMETHOD GetBlockAllMixedContent(bool *aBlockAllMixedContent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBlockAllMixedContent(aBlockAllMixedContent); } \
  NS_IMETHOD GetEnforcesFrameAncestors(bool *aEnforcesFrameAncestors) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEnforcesFrameAncestors(aEnforcesFrameAncestors); } \
  NS_IMETHOD AppendPolicy(const nsAString& policyString, bool reportOnly, bool deliveredViaMetaTag) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AppendPolicy(policyString, reportOnly, deliveredViaMetaTag); } \
  NS_IMETHOD GetRequireTrustedTypesForDirectiveState(nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState *aRequireTrustedTypesForDirectiveState) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequireTrustedTypesForDirectiveState(aRequireTrustedTypesForDirectiveState); } \
  NS_IMETHOD GetAllowsInline(nsIContentSecurityPolicy::CSPDirective aDirective, bool aHasUnsafeHash, const nsAString& aNonce, bool aParserCreated, mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, const nsAString& aSourceText, uint32_t aLineNumber, uint32_t aColumnNumber, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowsInline(aDirective, aHasUnsafeHash, aNonce, aParserCreated, aTriggeringElement, aCSPEventListener, aSourceText, aLineNumber, aColumnNumber, _retval); } \
  NS_IMETHOD GetAllowsEval(bool *shouldReportViolations, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowsEval(shouldReportViolations, _retval); } \
  NS_IMETHOD GetAllowsWasmEval(bool *shouldReportViolations, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowsWasmEval(shouldReportViolations, _retval); } \
  NS_IMETHOD GetCSPSandboxFlags(uint32_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCSPSandboxFlags(_retval); } \
  NS_IMETHOD LogViolationDetails(uint16_t violationType, mozilla::dom::Element *triggeringElement, nsICSPEventListener *aCSPEventListener, const nsACString& sourceFile, const nsAString& scriptSample, int32_t lineNum, int32_t columnNum, const nsAString& nonce, const nsAString& content) override { return !_to ? NS_ERROR_NULL_POINTER : _to->LogViolationDetails(violationType, triggeringElement, aCSPEventListener, sourceFile, scriptSample, lineNum, columnNum, nonce, content); } \
  NS_IMETHOD LogTrustedTypesViolationDetailsUnchecked(mozilla::dom::CSPViolationData&& aCSPViolationData, const nsAString& aObserverSubject, nsICSPEventListener *aCSPEventListener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->LogTrustedTypesViolationDetailsUnchecked(aCSPViolationData, aObserverSubject, aCSPEventListener); } \
  [[nodiscard]] NS_IMETHOD SetRequestContextWithDocument(mozilla::dom::Document *aDocument) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestContextWithDocument(aDocument); } \
  [[nodiscard]] NS_IMETHOD SetRequestContextWithPrincipal(nsIPrincipal *aRequestPrincipal, nsIURI *aSelfURI, const nsACString& aReferrer, uint64_t aInnerWindowId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestContextWithPrincipal(aRequestPrincipal, aSelfURI, aReferrer, aInnerWindowId); } \
  virtual nsIPrincipal * GetRequestPrincipal() override; \
  virtual nsIURI * GetSelfURI() override; \
  NS_IMETHOD GetReferrer(nsACString& aReferrer) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReferrer(aReferrer); } \
  virtual uint64_t GetInnerWindowID() override; \
  virtual bool GetSkipAllowInlineStyleCheck() override; \
  virtual void SetSkipAllowInlineStyleCheck(bool aSkipAllowInlineStyleCheck) override; \
  NS_IMETHOD EnsureEventTarget(nsIEventTarget *aEventTarget) override { return !_to ? NS_ERROR_NULL_POINTER : _to->EnsureEventTarget(aEventTarget); } \
  NS_IMETHOD PermitsAncestry(nsILoadInfo *aLoadInfo, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->PermitsAncestry(aLoadInfo, _retval); } \
  NS_IMETHOD Permits(mozilla::dom::Element *aTriggeringElement, nsICSPEventListener *aCSPEventListener, nsIURI *aURI, nsIContentSecurityPolicy::CSPDirective aDir, bool aSpecific, bool aSendViolationReports, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Permits(aTriggeringElement, aCSPEventListener, aURI, aDir, aSpecific, aSendViolationReports, _retval); } \
  NS_IMETHOD ShouldLoad(nsContentPolicyType aContentType, nsICSPEventListener *aCSPEventListener, nsILoadInfo *aLoadInfo, nsIURI *aContentLocation, nsIURI *aOriginalURIIfRedirect, bool aSendViolationReports, int16_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ShouldLoad(aContentType, aCSPEventListener, aLoadInfo, aContentLocation, aOriginalURIIfRedirect, aSendViolationReports, _retval); } \
  NS_IMETHOD ToJSON(nsAString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ToJSON(_retval); } \
  NS_IMETHOD EnsureIPCPoliciesRead(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->EnsureIPCPoliciesRead(); } 

typedef nsIContentSecurityPolicy::CSPDirective  CSPDirective;

typedef nsIContentSecurityPolicy::RequireTrustedTypesForDirectiveState  RequireTrustedTypesForDirectiveState;


/* starting interface:    nsICSPEventListener */
#define NS_ICSPEVENTLISTENER_IID_STR "c3163b14-3a8f-46dd-a4af-bd04680364cd"

#define NS_ICSPEVENTLISTENER_IID \
  {0xc3163b14, 0x3a8f, 0x46dd, \
    { 0xa4, 0xaf, 0xbd, 0x04, 0x68, 0x03, 0x64, 0xcd }}

class NS_NO_VTABLE nsICSPEventListener : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ICSPEVENTLISTENER_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsICSPEventListener;

  /* void onCSPViolationEvent (in AString aJSON); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnCSPViolationEvent(const nsAString& aJSON) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICSPEVENTLISTENER \
  NS_IMETHOD OnCSPViolationEvent(const nsAString& aJSON) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICSPEVENTLISTENER \
  nsresult OnCSPViolationEvent(const nsAString& aJSON); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICSPEVENTLISTENER(_to) \
  NS_IMETHOD OnCSPViolationEvent(const nsAString& aJSON) override { return _to OnCSPViolationEvent(aJSON); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICSPEVENTLISTENER(_to) \
  NS_IMETHOD OnCSPViolationEvent(const nsAString& aJSON) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnCSPViolationEvent(aJSON); } 


#endif /* __gen_nsIContentSecurityPolicy_h__ */
