/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/security/manager/ssl/nsITransportSecurityInfo.idl
 */

#ifndef __gen_nsITransportSecurityInfo_h__
#define __gen_nsITransportSecurityInfo_h__


#include "nsISupports.h"

#include "nsTArray.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIObjectOutputStream; /* forward declaration */

class nsIX509Cert; /* forward declaration */

// %{C++:13-15
namespace IPC {
class MessageWriter;
}
// %}

/* starting interface:    nsITransportSecurityInfo */
#define NS_ITRANSPORTSECURITYINFO_IID_STR "216112d3-28bc-4671-b057-f98cc09ba1ea"

#define NS_ITRANSPORTSECURITYINFO_IID \
  {0x216112d3, 0x28bc, 0x4671, \
    { 0xb0, 0x57, 0xf9, 0x8c, 0xc0, 0x9b, 0xa1, 0xea }}

class NS_NO_VTABLE nsITransportSecurityInfo : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ITRANSPORTSECURITYINFO_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsITransportSecurityInfo;

  enum OverridableErrorCategory : uint32_t {
    ERROR_UNSET = 0,
    ERROR_TRUST = 1,
    ERROR_DOMAIN = 2,
    ERROR_TIME = 3,
  };

  /* readonly attribute unsigned long securityState; */
  NS_IMETHOD GetSecurityState(uint32_t *aSecurityState) = 0;

  /* readonly attribute long errorCode; */
  NS_IMETHOD GetErrorCode(int32_t *aErrorCode) = 0;

  /* readonly attribute AString errorCodeString; */
  NS_IMETHOD GetErrorCodeString(nsAString& aErrorCodeString) = 0;

  /* readonly attribute Array<nsIX509Cert> handshakeCertificates; */
  NS_IMETHOD GetHandshakeCertificates(nsTArray<RefPtr<nsIX509Cert>>& aHandshakeCertificates) = 0;

  /* readonly attribute nsIX509Cert serverCert; */
  NS_IMETHOD GetServerCert(nsIX509Cert **aServerCert) = 0;

  /* readonly attribute Array<nsIX509Cert> succeededCertChain; */
  NS_IMETHOD GetSucceededCertChain(nsTArray<RefPtr<nsIX509Cert>>& aSucceededCertChain) = 0;

  /* [must_use] readonly attribute ACString cipherName; */
  [[nodiscard]] NS_IMETHOD GetCipherName(nsACString& aCipherName) = 0;

  /* [must_use] readonly attribute unsigned long keyLength; */
  [[nodiscard]] NS_IMETHOD GetKeyLength(uint32_t *aKeyLength) = 0;

  /* [must_use] readonly attribute unsigned long secretKeyLength; */
  [[nodiscard]] NS_IMETHOD GetSecretKeyLength(uint32_t *aSecretKeyLength) = 0;

  /* [must_use] readonly attribute ACString keaGroupName; */
  [[nodiscard]] NS_IMETHOD GetKeaGroupName(nsACString& aKeaGroupName) = 0;

  /* [must_use] readonly attribute ACString signatureSchemeName; */
  [[nodiscard]] NS_IMETHOD GetSignatureSchemeName(nsACString& aSignatureSchemeName) = 0;

  enum {
    SSL_VERSION_3 = 0,
    TLS_VERSION_1 = 1,
    TLS_VERSION_1_1 = 2,
    TLS_VERSION_1_2 = 3,
    TLS_VERSION_1_3 = 4
  };

  /* [must_use] readonly attribute unsigned short protocolVersion; */
  [[nodiscard]] NS_IMETHOD GetProtocolVersion(uint16_t *aProtocolVersion) = 0;

  enum {
    CERTIFICATE_TRANSPARENCY_NOT_APPLICABLE = 0,
    CERTIFICATE_TRANSPARENCY_POLICY_COMPLIANT = 5,
    CERTIFICATE_TRANSPARENCY_POLICY_NOT_ENOUGH_SCTS = 6,
    CERTIFICATE_TRANSPARENCY_POLICY_NOT_DIVERSE_SCTS = 7
  };

  /* [must_use] readonly attribute unsigned short certificateTransparencyStatus; */
  [[nodiscard]] NS_IMETHOD GetCertificateTransparencyStatus(uint16_t *aCertificateTransparencyStatus) = 0;

  /* [must_use] readonly attribute boolean isAcceptedEch; */
  [[nodiscard]] NS_IMETHOD GetIsAcceptedEch(bool *aIsAcceptedEch) = 0;

  /* [must_use] readonly attribute boolean isDelegatedCredential; */
  [[nodiscard]] NS_IMETHOD GetIsDelegatedCredential(bool *aIsDelegatedCredential) = 0;

  /* [must_use] readonly attribute nsITransportSecurityInfo_OverridableErrorCategory overridableErrorCategory; */
  [[nodiscard]] NS_IMETHOD GetOverridableErrorCategory(nsITransportSecurityInfo::OverridableErrorCategory *aOverridableErrorCategory) = 0;

  /* [must_use] readonly attribute boolean madeOCSPRequests; */
  [[nodiscard]] NS_IMETHOD GetMadeOCSPRequests(bool *aMadeOCSPRequests) = 0;

  /* [must_use] readonly attribute boolean usedPrivateDNS; */
  [[nodiscard]] NS_IMETHOD GetUsedPrivateDNS(bool *aUsedPrivateDNS) = 0;

  /* [must_use] readonly attribute boolean isExtendedValidation; */
  [[nodiscard]] NS_IMETHOD GetIsExtendedValidation(bool *aIsExtendedValidation) = 0;

  /* [noscript,notxpcom] void SerializeToIPC (in IpcMessageWriterPtr aWriter); */
  NS_IMETHOD_(void) SerializeToIPC(IPC::MessageWriter * aWriter) = 0;

  /* [must_use] ACString toString (); */
  [[nodiscard]] NS_IMETHOD ToString(nsACString& _retval) = 0;

  /* readonly attribute ACString negotiatedNPN; */
  NS_IMETHOD GetNegotiatedNPN(nsACString& aNegotiatedNPN) = 0;

  /* readonly attribute boolean resumed; */
  NS_IMETHOD GetResumed(bool *aResumed) = 0;

  /* readonly attribute boolean isBuiltCertChainRootBuiltInRoot; */
  NS_IMETHOD GetIsBuiltCertChainRootBuiltInRoot(bool *aIsBuiltCertChainRootBuiltInRoot) = 0;

  /* readonly attribute ACString peerId; */
  NS_IMETHOD GetPeerId(nsACString& aPeerId) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITRANSPORTSECURITYINFO \
  NS_IMETHOD GetSecurityState(uint32_t *aSecurityState) override; \
  NS_IMETHOD GetErrorCode(int32_t *aErrorCode) override; \
  NS_IMETHOD GetErrorCodeString(nsAString& aErrorCodeString) override; \
  NS_IMETHOD GetHandshakeCertificates(nsTArray<RefPtr<nsIX509Cert>>& aHandshakeCertificates) override; \
  NS_IMETHOD GetServerCert(nsIX509Cert **aServerCert) override; \
  NS_IMETHOD GetSucceededCertChain(nsTArray<RefPtr<nsIX509Cert>>& aSucceededCertChain) override; \
  [[nodiscard]] NS_IMETHOD GetCipherName(nsACString& aCipherName) override; \
  [[nodiscard]] NS_IMETHOD GetKeyLength(uint32_t *aKeyLength) override; \
  [[nodiscard]] NS_IMETHOD GetSecretKeyLength(uint32_t *aSecretKeyLength) override; \
  [[nodiscard]] NS_IMETHOD GetKeaGroupName(nsACString& aKeaGroupName) override; \
  [[nodiscard]] NS_IMETHOD GetSignatureSchemeName(nsACString& aSignatureSchemeName) override; \
  [[nodiscard]] NS_IMETHOD GetProtocolVersion(uint16_t *aProtocolVersion) override; \
  [[nodiscard]] NS_IMETHOD GetCertificateTransparencyStatus(uint16_t *aCertificateTransparencyStatus) override; \
  [[nodiscard]] NS_IMETHOD GetIsAcceptedEch(bool *aIsAcceptedEch) override; \
  [[nodiscard]] NS_IMETHOD GetIsDelegatedCredential(bool *aIsDelegatedCredential) override; \
  [[nodiscard]] NS_IMETHOD GetOverridableErrorCategory(nsITransportSecurityInfo::OverridableErrorCategory *aOverridableErrorCategory) override; \
  [[nodiscard]] NS_IMETHOD GetMadeOCSPRequests(bool *aMadeOCSPRequests) override; \
  [[nodiscard]] NS_IMETHOD GetUsedPrivateDNS(bool *aUsedPrivateDNS) override; \
  [[nodiscard]] NS_IMETHOD GetIsExtendedValidation(bool *aIsExtendedValidation) override; \
  NS_IMETHOD_(void) SerializeToIPC(IPC::MessageWriter * aWriter) override; \
  [[nodiscard]] NS_IMETHOD ToString(nsACString& _retval) override; \
  NS_IMETHOD GetNegotiatedNPN(nsACString& aNegotiatedNPN) override; \
  NS_IMETHOD GetResumed(bool *aResumed) override; \
  NS_IMETHOD GetIsBuiltCertChainRootBuiltInRoot(bool *aIsBuiltCertChainRootBuiltInRoot) override; \
  NS_IMETHOD GetPeerId(nsACString& aPeerId) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSITRANSPORTSECURITYINFO \
  nsresult GetSecurityState(uint32_t *aSecurityState); \
  nsresult GetErrorCode(int32_t *aErrorCode); \
  nsresult GetErrorCodeString(nsAString& aErrorCodeString); \
  nsresult GetHandshakeCertificates(nsTArray<RefPtr<nsIX509Cert>>& aHandshakeCertificates); \
  nsresult GetServerCert(nsIX509Cert **aServerCert); \
  nsresult GetSucceededCertChain(nsTArray<RefPtr<nsIX509Cert>>& aSucceededCertChain); \
  [[nodiscard]] nsresult GetCipherName(nsACString& aCipherName); \
  [[nodiscard]] nsresult GetKeyLength(uint32_t *aKeyLength); \
  [[nodiscard]] nsresult GetSecretKeyLength(uint32_t *aSecretKeyLength); \
  [[nodiscard]] nsresult GetKeaGroupName(nsACString& aKeaGroupName); \
  [[nodiscard]] nsresult GetSignatureSchemeName(nsACString& aSignatureSchemeName); \
  [[nodiscard]] nsresult GetProtocolVersion(uint16_t *aProtocolVersion); \
  [[nodiscard]] nsresult GetCertificateTransparencyStatus(uint16_t *aCertificateTransparencyStatus); \
  [[nodiscard]] nsresult GetIsAcceptedEch(bool *aIsAcceptedEch); \
  [[nodiscard]] nsresult GetIsDelegatedCredential(bool *aIsDelegatedCredential); \
  [[nodiscard]] nsresult GetOverridableErrorCategory(nsITransportSecurityInfo::OverridableErrorCategory *aOverridableErrorCategory); \
  [[nodiscard]] nsresult GetMadeOCSPRequests(bool *aMadeOCSPRequests); \
  [[nodiscard]] nsresult GetUsedPrivateDNS(bool *aUsedPrivateDNS); \
  [[nodiscard]] nsresult GetIsExtendedValidation(bool *aIsExtendedValidation); \
  nsresult_(void) SerializeToIPC(IPC::MessageWriter * aWriter); \
  [[nodiscard]] nsresult ToString(nsACString& _retval); \
  nsresult GetNegotiatedNPN(nsACString& aNegotiatedNPN); \
  nsresult GetResumed(bool *aResumed); \
  nsresult GetIsBuiltCertChainRootBuiltInRoot(bool *aIsBuiltCertChainRootBuiltInRoot); \
  nsresult GetPeerId(nsACString& aPeerId); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITRANSPORTSECURITYINFO(_to) \
  NS_IMETHOD GetSecurityState(uint32_t *aSecurityState) override { return _to GetSecurityState(aSecurityState); } \
  NS_IMETHOD GetErrorCode(int32_t *aErrorCode) override { return _to GetErrorCode(aErrorCode); } \
  NS_IMETHOD GetErrorCodeString(nsAString& aErrorCodeString) override { return _to GetErrorCodeString(aErrorCodeString); } \
  NS_IMETHOD GetHandshakeCertificates(nsTArray<RefPtr<nsIX509Cert>>& aHandshakeCertificates) override { return _to GetHandshakeCertificates(aHandshakeCertificates); } \
  NS_IMETHOD GetServerCert(nsIX509Cert **aServerCert) override { return _to GetServerCert(aServerCert); } \
  NS_IMETHOD GetSucceededCertChain(nsTArray<RefPtr<nsIX509Cert>>& aSucceededCertChain) override { return _to GetSucceededCertChain(aSucceededCertChain); } \
  [[nodiscard]] NS_IMETHOD GetCipherName(nsACString& aCipherName) override { return _to GetCipherName(aCipherName); } \
  [[nodiscard]] NS_IMETHOD GetKeyLength(uint32_t *aKeyLength) override { return _to GetKeyLength(aKeyLength); } \
  [[nodiscard]] NS_IMETHOD GetSecretKeyLength(uint32_t *aSecretKeyLength) override { return _to GetSecretKeyLength(aSecretKeyLength); } \
  [[nodiscard]] NS_IMETHOD GetKeaGroupName(nsACString& aKeaGroupName) override { return _to GetKeaGroupName(aKeaGroupName); } \
  [[nodiscard]] NS_IMETHOD GetSignatureSchemeName(nsACString& aSignatureSchemeName) override { return _to GetSignatureSchemeName(aSignatureSchemeName); } \
  [[nodiscard]] NS_IMETHOD GetProtocolVersion(uint16_t *aProtocolVersion) override { return _to GetProtocolVersion(aProtocolVersion); } \
  [[nodiscard]] NS_IMETHOD GetCertificateTransparencyStatus(uint16_t *aCertificateTransparencyStatus) override { return _to GetCertificateTransparencyStatus(aCertificateTransparencyStatus); } \
  [[nodiscard]] NS_IMETHOD GetIsAcceptedEch(bool *aIsAcceptedEch) override { return _to GetIsAcceptedEch(aIsAcceptedEch); } \
  [[nodiscard]] NS_IMETHOD GetIsDelegatedCredential(bool *aIsDelegatedCredential) override { return _to GetIsDelegatedCredential(aIsDelegatedCredential); } \
  [[nodiscard]] NS_IMETHOD GetOverridableErrorCategory(nsITransportSecurityInfo::OverridableErrorCategory *aOverridableErrorCategory) override { return _to GetOverridableErrorCategory(aOverridableErrorCategory); } \
  [[nodiscard]] NS_IMETHOD GetMadeOCSPRequests(bool *aMadeOCSPRequests) override { return _to GetMadeOCSPRequests(aMadeOCSPRequests); } \
  [[nodiscard]] NS_IMETHOD GetUsedPrivateDNS(bool *aUsedPrivateDNS) override { return _to GetUsedPrivateDNS(aUsedPrivateDNS); } \
  [[nodiscard]] NS_IMETHOD GetIsExtendedValidation(bool *aIsExtendedValidation) override { return _to GetIsExtendedValidation(aIsExtendedValidation); } \
  NS_IMETHOD_(void) SerializeToIPC(IPC::MessageWriter * aWriter) override { return _to SerializeToIPC(aWriter); } \
  [[nodiscard]] NS_IMETHOD ToString(nsACString& _retval) override { return _to ToString(_retval); } \
  NS_IMETHOD GetNegotiatedNPN(nsACString& aNegotiatedNPN) override { return _to GetNegotiatedNPN(aNegotiatedNPN); } \
  NS_IMETHOD GetResumed(bool *aResumed) override { return _to GetResumed(aResumed); } \
  NS_IMETHOD GetIsBuiltCertChainRootBuiltInRoot(bool *aIsBuiltCertChainRootBuiltInRoot) override { return _to GetIsBuiltCertChainRootBuiltInRoot(aIsBuiltCertChainRootBuiltInRoot); } \
  NS_IMETHOD GetPeerId(nsACString& aPeerId) override { return _to GetPeerId(aPeerId); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITRANSPORTSECURITYINFO(_to) \
  NS_IMETHOD GetSecurityState(uint32_t *aSecurityState) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSecurityState(aSecurityState); } \
  NS_IMETHOD GetErrorCode(int32_t *aErrorCode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetErrorCode(aErrorCode); } \
  NS_IMETHOD GetErrorCodeString(nsAString& aErrorCodeString) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetErrorCodeString(aErrorCodeString); } \
  NS_IMETHOD GetHandshakeCertificates(nsTArray<RefPtr<nsIX509Cert>>& aHandshakeCertificates) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHandshakeCertificates(aHandshakeCertificates); } \
  NS_IMETHOD GetServerCert(nsIX509Cert **aServerCert) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerCert(aServerCert); } \
  NS_IMETHOD GetSucceededCertChain(nsTArray<RefPtr<nsIX509Cert>>& aSucceededCertChain) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSucceededCertChain(aSucceededCertChain); } \
  [[nodiscard]] NS_IMETHOD GetCipherName(nsACString& aCipherName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCipherName(aCipherName); } \
  [[nodiscard]] NS_IMETHOD GetKeyLength(uint32_t *aKeyLength) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKeyLength(aKeyLength); } \
  [[nodiscard]] NS_IMETHOD GetSecretKeyLength(uint32_t *aSecretKeyLength) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSecretKeyLength(aSecretKeyLength); } \
  [[nodiscard]] NS_IMETHOD GetKeaGroupName(nsACString& aKeaGroupName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKeaGroupName(aKeaGroupName); } \
  [[nodiscard]] NS_IMETHOD GetSignatureSchemeName(nsACString& aSignatureSchemeName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSignatureSchemeName(aSignatureSchemeName); } \
  [[nodiscard]] NS_IMETHOD GetProtocolVersion(uint16_t *aProtocolVersion) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProtocolVersion(aProtocolVersion); } \
  [[nodiscard]] NS_IMETHOD GetCertificateTransparencyStatus(uint16_t *aCertificateTransparencyStatus) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCertificateTransparencyStatus(aCertificateTransparencyStatus); } \
  [[nodiscard]] NS_IMETHOD GetIsAcceptedEch(bool *aIsAcceptedEch) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsAcceptedEch(aIsAcceptedEch); } \
  [[nodiscard]] NS_IMETHOD GetIsDelegatedCredential(bool *aIsDelegatedCredential) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsDelegatedCredential(aIsDelegatedCredential); } \
  [[nodiscard]] NS_IMETHOD GetOverridableErrorCategory(nsITransportSecurityInfo::OverridableErrorCategory *aOverridableErrorCategory) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOverridableErrorCategory(aOverridableErrorCategory); } \
  [[nodiscard]] NS_IMETHOD GetMadeOCSPRequests(bool *aMadeOCSPRequests) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMadeOCSPRequests(aMadeOCSPRequests); } \
  [[nodiscard]] NS_IMETHOD GetUsedPrivateDNS(bool *aUsedPrivateDNS) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUsedPrivateDNS(aUsedPrivateDNS); } \
  [[nodiscard]] NS_IMETHOD GetIsExtendedValidation(bool *aIsExtendedValidation) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsExtendedValidation(aIsExtendedValidation); } \
  NS_IMETHOD_(void) SerializeToIPC(IPC::MessageWriter * aWriter) override; \
  [[nodiscard]] NS_IMETHOD ToString(nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ToString(_retval); } \
  NS_IMETHOD GetNegotiatedNPN(nsACString& aNegotiatedNPN) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNegotiatedNPN(aNegotiatedNPN); } \
  NS_IMETHOD GetResumed(bool *aResumed) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResumed(aResumed); } \
  NS_IMETHOD GetIsBuiltCertChainRootBuiltInRoot(bool *aIsBuiltCertChainRootBuiltInRoot) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsBuiltCertChainRootBuiltInRoot(aIsBuiltCertChainRootBuiltInRoot); } \
  NS_IMETHOD GetPeerId(nsACString& aPeerId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPeerId(aPeerId); } 


#endif /* __gen_nsITransportSecurityInfo_h__ */
