/* THIS FILE IS AUTOGENERATED FROM ServiceWorkerContainer.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "EventHandlerBinding.h"
#include "EventTargetBinding.h"
#include "MainThreadUtils.h"
#include "ServiceWorkerContainerBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/BasePrincipal.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/ServiceWorker.h"
#include "mozilla/dom/ServiceWorkerContainer.h"
#include "mozilla/dom/ServiceWorkerRegistration.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TrustedScriptURL.h"
#include "mozilla/dom/UnionTypes.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsJSPrincipals.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningServiceWorkerRegistrationOrUndefined& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsServiceWorkerRegistration()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsServiceWorkerRegistration(), "mServiceWorkerRegistration", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningServiceWorkerRegistrationOrUndefined& aUnion)
{
  aUnion.Uninit();
}



RegistrationOptions::RegistrationOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RegistrationOptions::InitIds(JSContext* cx, RegistrationOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->updateViaCache_id.init(cx, "updateViaCache") ||
      !atomsCache->type_id.init(cx, "type") ||
      !atomsCache->scope_id.init(cx, "scope")) {
    return false;
  }
  return true;
}

bool
RegistrationOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RegistrationOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RegistrationOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->scope_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mScope.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mScope.Value()))) {
      return false;
    }
    if (!NormalizeUSVString((mScope.Value()))) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->type_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<WorkerType>::Values,
                                                                         "WorkerType", "'type' member of RegistrationOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mType = static_cast<WorkerType>(index);
    }
  } else {
    mType = WorkerType::Classic;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->updateViaCache_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<ServiceWorkerUpdateViaCache>::Values,
                                                                         "ServiceWorkerUpdateViaCache", "'updateViaCache' member of RegistrationOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mUpdateViaCache = static_cast<ServiceWorkerUpdateViaCache>(index);
    }
  } else {
    mUpdateViaCache = ServiceWorkerUpdateViaCache::Imports;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RegistrationOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
RegistrationOptions::TraceDictionary(JSTracer* trc)
{
}

RegistrationOptions&
RegistrationOptions::operator=(const RegistrationOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mScope.Reset();
  if (aOther.mScope.WasPassed()) {
    mScope.Construct(aOther.mScope.Value());
  }
  mType = aOther.mType;
  mUpdateViaCache = aOther.mUpdateViaCache;
  return *this;
}


bool
ServiceWorkerRegistrationOrUndefined::TrySetToServiceWorkerRegistration(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::ServiceWorkerRegistration>& memberSlot = RawSetAsServiceWorkerRegistration();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::ServiceWorkerRegistration, mozilla::dom::ServiceWorkerRegistration>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyServiceWorkerRegistration();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
ServiceWorkerRegistrationOrUndefined::TrySetToServiceWorkerRegistration(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToServiceWorkerRegistration(cx, value, tryNext, passedToJSImpl);
}









bool
ServiceWorkerRegistrationOrUndefined::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  if (value.isUndefined()) {
    SetUndefined();
  } else {
    bool done = false, failed = false, tryNext;
    if (value.isObject()) {
      done = (failed = !TrySetToServiceWorkerRegistration(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    }
    if (failed) {
      return false;
    }
    if (!done) {
      cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "ServiceWorkerRegistration");
      return false;
    }
  }
  return true;
}

bool
ServiceWorkerRegistrationOrUndefined::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
ServiceWorkerRegistrationOrUndefined::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eServiceWorkerRegistration: {
      if (!GetOrCreateDOMReflector(cx, mValue.mServiceWorkerRegistration.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eUndefined: {
      rval.setUndefined();
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningServiceWorkerRegistrationOrUndefined::OwningServiceWorkerRegistrationOrUndefined(OwningServiceWorkerRegistrationOrUndefined&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eServiceWorkerRegistration: {
      mType = eServiceWorkerRegistration;
      mValue.mServiceWorkerRegistration.SetValue(std::move(aOther.mValue.mServiceWorkerRegistration.Value()));
      break;
    }
    case eUndefined: {
      MOZ_ASSERT(mType == eUninitialized);
      mType = eUndefined;
      break;
    }
  }
}



bool
OwningServiceWorkerRegistrationOrUndefined::TrySetToServiceWorkerRegistration(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::ServiceWorkerRegistration>& memberSlot = RawSetAsServiceWorkerRegistration();
    static_assert(IsRefcounted<mozilla::dom::ServiceWorkerRegistration>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::ServiceWorkerRegistration, mozilla::dom::ServiceWorkerRegistration>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyServiceWorkerRegistration();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningServiceWorkerRegistrationOrUndefined::TrySetToServiceWorkerRegistration(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToServiceWorkerRegistration(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::ServiceWorkerRegistration>&
OwningServiceWorkerRegistrationOrUndefined::RawSetAsServiceWorkerRegistration()
{
  if (mType == eServiceWorkerRegistration) {
    return mValue.mServiceWorkerRegistration.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eServiceWorkerRegistration;
  return mValue.mServiceWorkerRegistration.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::ServiceWorkerRegistration>&
OwningServiceWorkerRegistrationOrUndefined::SetAsServiceWorkerRegistration()
{
  if (mType == eServiceWorkerRegistration) {
    return mValue.mServiceWorkerRegistration.Value();
  }
  Uninit();
  mType = eServiceWorkerRegistration;
  return mValue.mServiceWorkerRegistration.SetValue();
}


void
OwningServiceWorkerRegistrationOrUndefined::DestroyServiceWorkerRegistration()
{
  MOZ_RELEASE_ASSERT(IsServiceWorkerRegistration(), "Wrong type!");
  mValue.mServiceWorkerRegistration.Destroy();
  mType = eUninitialized;
}





bool
OwningServiceWorkerRegistrationOrUndefined::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  if (value.isUndefined()) {
    SetUndefined();
  } else {
    bool done = false, failed = false, tryNext;
    if (value.isObject()) {
      done = (failed = !TrySetToServiceWorkerRegistration(cx, value, tryNext, passedToJSImpl)) || !tryNext;
    }
    if (failed) {
      return false;
    }
    if (!done) {
      cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "ServiceWorkerRegistration");
      return false;
    }
  }
  return true;
}

bool
OwningServiceWorkerRegistrationOrUndefined::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningServiceWorkerRegistrationOrUndefined::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eServiceWorkerRegistration: {
      DestroyServiceWorkerRegistration();
      break;
    }
    case eUndefined: {
      break;
    }
  }
}

bool
OwningServiceWorkerRegistrationOrUndefined::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eServiceWorkerRegistration: {
      if (!GetOrCreateDOMReflector(cx, mValue.mServiceWorkerRegistration.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eUndefined: {
      rval.setUndefined();
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningServiceWorkerRegistrationOrUndefined&
OwningServiceWorkerRegistrationOrUndefined::operator=(OwningServiceWorkerRegistrationOrUndefined&& aOther)
{
  this->~OwningServiceWorkerRegistrationOrUndefined();
  new (this) OwningServiceWorkerRegistrationOrUndefined (std::move(aOther));
  return *this;
}


OwningServiceWorkerRegistrationOrUndefined&
OwningServiceWorkerRegistrationOrUndefined::operator=(const OwningServiceWorkerRegistrationOrUndefined& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eServiceWorkerRegistration: {
      SetAsServiceWorkerRegistration() = aOther.GetAsServiceWorkerRegistration();
      break;
    }
    case eUndefined: {
      MOZ_ASSERT(mType == eUninitialized);
      mType = eUndefined;
      break;
    }
  }
  return *this;
}


namespace ServiceWorkerContainer_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<EventTarget_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_controller(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "controller", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::ServiceWorker>(MOZ_KnownLive(self)->GetController()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo controller_getterinfo = {
  { get_controller },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ready(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "ready", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetReady(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ServiceWorkerContainer.ready getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
get_ready_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  bool ok = get_ready(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo ready_getterinfo = {
  { get_ready_promiseWrapper },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
_register_(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ServiceWorkerContainer.register");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "register", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  if (!args.requireAtLeast(cx, "ServiceWorkerContainer.register", 1)) {
    return false;
  }
  TrustedScriptURLOrUSVString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  binding_detail::FastRegistrationOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  FastErrorResult rv;
  nsIPrincipal* subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);
    if (principal->IsSystemPrincipal()) {
    principal = nullptr;
  }

    subjectPrincipal = principal;
  }
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Register(Constify(arg0), Constify(arg1), MOZ_KnownLive(subjectPrincipal), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ServiceWorkerContainer.register"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
_register__promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = _register_(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo register_methodinfo = {
  { (JSJitGetterOp)_register__promiseWrapper },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getRegistration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "getRegistration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
    if (!NormalizeUSVString(arg0)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
  } else {
    arg0.AssignLiteral(u"");
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetRegistration(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ServiceWorkerContainer.getRegistration"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRegistration_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = getRegistration(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo getRegistration_methodinfo = {
  { (JSJitGetterOp)getRegistration_promiseWrapper },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getRegistrations(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "getRegistrations", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetRegistrations(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ServiceWorkerContainer.getRegistrations"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRegistrations_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = getRegistrations(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo getRegistrations_methodinfo = {
  { (JSJitGetterOp)getRegistrations_promiseWrapper },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
startMessages(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "startMessages", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StartMessages())>, "Should be returning void here");
  MOZ_KnownLive(self)->StartMessages();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo startMessages_methodinfo = {
  { (JSJitGetterOp)startMessages },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oncontrollerchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "oncontrollerchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOncontrollerchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oncontrollerchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "oncontrollerchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOncontrollerchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOncontrollerchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oncontrollerchange_getterinfo = {
  { get_oncontrollerchange },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oncontrollerchange_setterinfo = {
  { (JSJitGetterOp)set_oncontrollerchange },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "onmessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmessage());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmessage(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "onmessage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmessage(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmessage(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmessage_getterinfo = {
  { get_onmessage },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmessage_setterinfo = {
  { (JSJitGetterOp)set_onmessage },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onmessageerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "onmessageerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnmessageerror());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onmessageerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ServiceWorkerContainer", "onmessageerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ServiceWorkerContainer*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnmessageerror(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnmessageerror(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onmessageerror_getterinfo = {
  { get_onmessageerror },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onmessageerror_setterinfo = {
  { (JSJitGetterOp)set_onmessageerror },
  { prototypes::id::ServiceWorkerContainer },
  { PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::ServiceWorkerContainer* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::ServiceWorkerContainer>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::ServiceWorkerContainer>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("register", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&register_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRegistration", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&getRegistration_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRegistrations", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&getRegistrations_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("startMessages", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&startMessages_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("controller", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &controller_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("ready", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ConvertExceptionsToPromises>, &ready_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("oncontrollerchange", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &oncontrollerchange_getterinfo, GenericSetter<NormalThisPolicy>, &oncontrollerchange_setterinfo),
  JSPropertySpec::nativeAccessors("onmessage", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onmessage_getterinfo, GenericSetter<NormalThisPolicy>, &onmessage_setterinfo),
  JSPropertySpec::nativeAccessors("onmessageerror", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onmessageerror_getterinfo, GenericSetter<NormalThisPolicy>, &onmessageerror_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(5 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[9];
static PropertyInfo sNativeProperties_propertyInfos[9];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  9,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[4] }
  }
};
static_assert(9 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::ServiceWorkerContainer,
  constructors::id::ServiceWorkerContainer,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  EventTarget_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth,
  prototypes::id::ServiceWorkerContainer,
  true,
  0,
  "ServiceWorkerContainer",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "ServiceWorkerContainerPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::ServiceWorkerContainer,
  PrototypeTraits<prototypes::id::ServiceWorkerContainer>::Depth,
  &sNativePropertyHooks,
  EventTarget_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return ServiceWorkersEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "ServiceWorkerContainer",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::ServiceWorkerContainer>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::ServiceWorkerContainer, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::ServiceWorkerContainer>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::ServiceWorkerContainer>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::ServiceWorkerContainer>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::ServiceWorkerContainer>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::ServiceWorkerContainer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::ServiceWorkerContainer>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::ServiceWorkerContainer*>);
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::ServiceWorkerContainer> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::ServiceWorkerContainer);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::ServiceWorkerContainer);

  JS::Handle<JSObject*> parentProto(EventTarget_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(EventTarget_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "ServiceWorkerContainer",
                              ShouldExpose<ServiceWorkerContainer_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::ServiceWorkerContainer,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::ServiceWorkerContainer,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace ServiceWorkerContainer_Binding



} // namespace mozilla::dom
