//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/webgpu/PWebGPUChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/ByteBufUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"
#include "mozilla/webgpu/WebGPUChild.h"
#include "mozilla/webgpu/WebGPUSerialize.h"

#include "mozilla/gfx/PCanvasManagerChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace webgpu {


auto PWebGPUChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PWebGPUChild::PWebGPUChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PWebGPUChild);
}

PWebGPUChild::~PWebGPUChild()
{
    MOZ_COUNT_DTOR(PWebGPUChild);
}

auto PWebGPUChild::ActorAlloc() -> void
{
    AddRef();
}

auto PWebGPUChild::ActorDealloc() -> void
{
    Release();
}

auto PWebGPUChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebGPUChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebGPUChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebGPUChild::Manager() const -> PCanvasManagerChild*
{
    return static_cast<PCanvasManagerChild*>(IProtocol::Manager());
}

auto PWebGPUChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebGPUChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebGPUChild::SendMessages(
        const uint32_t& nrOfMessages,
        ByteBuf&& serializedMessages,
        nsTArray<ByteBuf>&& dataBuffers,
        nsTArray<MutableSharedMemoryHandle>&& shmems) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_Messages(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), nrOfMessages);
    // Sentinel = 'nrOfMessages'
    ((&(writer__)))->WriteSentinel(517473486);
    IPC::WriteParam((&(writer__)), std::move(serializedMessages));
    // Sentinel = 'serializedMessages'
    ((&(writer__)))->WriteSentinel(1184892773);
    IPC::WriteParam((&(writer__)), std::move(dataBuffers));
    // Sentinel = 'dataBuffers'
    ((&(writer__)))->WriteSentinel(434439272);
    IPC::WriteParam((&(writer__)), std::move(shmems));
    // Sentinel = 'shmems'
    ((&(writer__)))->WriteSentinel(149947022);


    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_Messages", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::SendCreateExternalTextureSource(
        const RawId& deviceId,
        const RawId& queueId,
        const RawId& externalTextureSourceId,
        const ExternalTextureSourceDescriptor& aDesc) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_CreateExternalTextureSource(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), deviceId);
    // Sentinel = 'deviceId'
    ((&(writer__)))->WriteSentinel(242025246);
    IPC::WriteParam((&(writer__)), queueId);
    // Sentinel = 'queueId'
    ((&(writer__)))->WriteSentinel(198050515);
    IPC::WriteParam((&(writer__)), externalTextureSourceId);
    // Sentinel = 'externalTextureSourceId'
    ((&(writer__)))->WriteSentinel(1938884979);
    IPC::WriteParam((&(writer__)), aDesc);
    // Sentinel = 'aDesc'
    ((&(writer__)))->WriteSentinel(91357665);


    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_CreateExternalTextureSource", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebGPUChild::OnMessageReceived(const Message& msg__) -> PWebGPUChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebGPU::Msg_ServerMessage__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_ServerMessage", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__buf = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__buf) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& buf = *maybe__buf;
            // Sentinel = 'buf'
            if ((!(((&(reader__)))->ReadSentinel(41484606)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUChild*>(this))->RecvServerMessage(std::move(buf));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_UncapturedError__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_UncapturedError", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__type = IPC::ReadParam<GPUErrorFilter>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'GPUErrorFilter'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GPUErrorFilter'");
                return MsgValueError;
            }
            auto maybe__message = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUChild*>(this))->RecvUncapturedError(std::move(aDeviceId), std::move(type), std::move(message));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_DeviceLost__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceLost", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aDeviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__aDeviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& aDeviceId = *maybe__aDeviceId;
            // Sentinel = 'aDeviceId'
            if ((!(((&(reader__)))->ReadSentinel(282526559)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__reason = IPC::ReadParam<uint8_t>((&(reader__)));
            if (!maybe__reason) {
                FatalError("Error deserializing 'uint8_t'");
                return MsgValueError;

            }
            auto& reason = *maybe__reason;
            // Sentinel = 'reason'
            if ((!(((&(reader__)))->ReadSentinel(148112009)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t'");
                return MsgValueError;
            }
            auto maybe__message = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__message) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& message = *maybe__message;
            // Sentinel = 'message'
            if ((!(((&(reader__)))->ReadSentinel(197198566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUChild*>(this))->RecvDeviceLost(std::move(aDeviceId), std::move(reason), std::move(message));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebGPUChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebGPUChild::Result
{
    return MsgNotKnown;
}



} // namespace webgpu
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::webgpu::PWebGPUChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PWebGPU'
    (aWriter)->WriteSentinel(160170587);
}

auto ParamTraits<::mozilla::webgpu::PWebGPUChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PWebGPU actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PWebGPU'
    if ((!((aReader)->ReadSentinel(160170587)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PWebGPU actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PWebGPUMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PWebGPU)");

        return {};
    }
    return static_cast<::mozilla::webgpu::PWebGPUChild*>(actor);
}

} // namespace IPC
