//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/webgpu/PWebGPUParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ipc/ByteBufUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/WebRenderMessageUtils.h"
#include "mozilla/webgpu/WebGPUParent.h"
#include "mozilla/webgpu/WebGPUSerialize.h"

#include "mozilla/gfx/PCanvasManagerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace webgpu {


MOZ_IMPLICIT PWebGPUParent::PWebGPUParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PWebGPUParent);
}

PWebGPUParent::~PWebGPUParent()
{
    MOZ_COUNT_DTOR(PWebGPUParent);
}

auto PWebGPUParent::ActorAlloc() -> void
{
    AddRef();
}

auto PWebGPUParent::ActorDealloc() -> void
{
    Release();
}

auto PWebGPUParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PWebGPUParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PWebGPUParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PWebGPUParent::Manager() const -> PCanvasManagerParent*
{
    return static_cast<PCanvasManagerParent*>(IProtocol::Manager());
}

auto PWebGPUParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PWebGPUParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PWebGPUParent::SendServerMessage(ByteBuf&& buf) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_ServerMessage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(buf));
    // Sentinel = 'buf'
    ((&(writer__)))->WriteSentinel(41484606);


    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_ServerMessage", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUParent::SendUncapturedError(
        const RawId& aDeviceId,
        const GPUErrorFilter& type,
        const nsACString& message) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_UncapturedError(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), type);
    // Sentinel = 'type'
    ((&(writer__)))->WriteSentinel(75760067);
    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);


    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_UncapturedError", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUParent::SendDeviceLost(
        const RawId& aDeviceId,
        const uint8_t& reason,
        const nsACString& message) -> bool
{
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg_DeviceLost(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aDeviceId);
    // Sentinel = 'aDeviceId'
    ((&(writer__)))->WriteSentinel(282526559);
    IPC::WriteParam((&(writer__)), reason);
    // Sentinel = 'reason'
    ((&(writer__)))->WriteSentinel(148112009);
    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);


    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg_DeviceLost", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PWebGPUParent::Send__delete__(PWebGPUParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PWebGPU::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PWebGPUParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PWebGPU::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PWebGPUParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PWebGPUParent::OnMessageReceived(const Message& msg__) -> PWebGPUParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PWebGPU::Msg_Messages__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_Messages", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__nrOfMessages = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__nrOfMessages) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& nrOfMessages = *maybe__nrOfMessages;
            // Sentinel = 'nrOfMessages'
            if ((!(((&(reader__)))->ReadSentinel(517473486)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__serializedMessages = IPC::ReadParam<ByteBuf>((&(reader__)));
            if (!maybe__serializedMessages) {
                FatalError("Error deserializing 'ByteBuf'");
                return MsgValueError;

            }
            auto& serializedMessages = *maybe__serializedMessages;
            // Sentinel = 'serializedMessages'
            if ((!(((&(reader__)))->ReadSentinel(1184892773)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf'");
                return MsgValueError;
            }
            auto maybe__dataBuffers = IPC::ReadParam<nsTArray<ByteBuf>>((&(reader__)));
            if (!maybe__dataBuffers) {
                FatalError("Error deserializing 'ByteBuf[]'");
                return MsgValueError;

            }
            auto& dataBuffers = *maybe__dataBuffers;
            // Sentinel = 'dataBuffers'
            if ((!(((&(reader__)))->ReadSentinel(434439272)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ByteBuf[]'");
                return MsgValueError;
            }
            auto maybe__shmems = IPC::ReadParam<nsTArray<MutableSharedMemoryHandle>>((&(reader__)));
            if (!maybe__shmems) {
                FatalError("Error deserializing 'MutableSharedMemoryHandle[]'");
                return MsgValueError;

            }
            auto& shmems = *maybe__shmems;
            // Sentinel = 'shmems'
            if ((!(((&(reader__)))->ReadSentinel(149947022)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MutableSharedMemoryHandle[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvMessages(std::move(nrOfMessages), std::move(serializedMessages), std::move(dataBuffers), std::move(shmems));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Msg_CreateExternalTextureSource__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PWebGPU", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PWebGPUParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PWebGPU::Msg_CreateExternalTextureSource", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__deviceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__deviceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& deviceId = *maybe__deviceId;
            // Sentinel = 'deviceId'
            if ((!(((&(reader__)))->ReadSentinel(242025246)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__queueId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__queueId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& queueId = *maybe__queueId;
            // Sentinel = 'queueId'
            if ((!(((&(reader__)))->ReadSentinel(198050515)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__externalTextureSourceId = IPC::ReadParam<RawId>((&(reader__)));
            if (!maybe__externalTextureSourceId) {
                FatalError("Error deserializing 'RawId'");
                return MsgValueError;

            }
            auto& externalTextureSourceId = *maybe__externalTextureSourceId;
            // Sentinel = 'externalTextureSourceId'
            if ((!(((&(reader__)))->ReadSentinel(1938884979)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RawId'");
                return MsgValueError;
            }
            auto maybe__aDesc = IPC::ReadParam<ExternalTextureSourceDescriptor>((&(reader__)));
            if (!maybe__aDesc) {
                FatalError("Error deserializing 'ExternalTextureSourceDescriptor'");
                return MsgValueError;

            }
            auto& aDesc = *maybe__aDesc;
            // Sentinel = 'aDesc'
            if ((!(((&(reader__)))->ReadSentinel(91357665)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ExternalTextureSourceDescriptor'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<WebGPUParent*>(this))->RecvCreateExternalTextureSource(std::move(deviceId), std::move(queueId), std::move(externalTextureSourceId), std::move(aDesc));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PWebGPU::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PWebGPUParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PWebGPUParent::Result
{
    return MsgNotKnown;
}



} // namespace webgpu
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::webgpu::PWebGPUParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PWebGPU'
    (aWriter)->WriteSentinel(160170587);
}

auto ParamTraits<::mozilla::webgpu::PWebGPUParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PWebGPU actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PWebGPU'
    if ((!((aReader)->ReadSentinel(160170587)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PWebGPU actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PWebGPUMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PWebGPU)");

        return {};
    }
    return static_cast<::mozilla::webgpu::PWebGPUParent*>(actor);
}

} // namespace IPC
