// automatically generated by the FlatBuffers compiler, do not modify

// @generated

use core::cmp::Ordering;
use core::mem;

extern crate flatbuffers;
use self::flatbuffers::{EndianScalar, Follow};

#[allow(unused_imports, dead_code)]
pub mod fb {

    use core::cmp::Ordering;
    use core::mem;

    extern crate flatbuffers;
    use self::flatbuffers::{EndianScalar, Follow};

    pub enum NetworkFilterOffset {}
    #[derive(Copy, Clone, PartialEq)]

    pub struct NetworkFilter<'a> {
        pub _tab: flatbuffers::Table<'a>,
    }

    impl<'a> flatbuffers::Follow<'a> for NetworkFilter<'a> {
        type Inner = NetworkFilter<'a>;
        #[inline]
        unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
            Self {
                _tab: unsafe { flatbuffers::Table::new(buf, loc) },
            }
        }
    }

    impl<'a> NetworkFilter<'a> {
        pub const VT_MASK: flatbuffers::VOffsetT = 4;
        pub const VT_OPT_DOMAINS: flatbuffers::VOffsetT = 6;
        pub const VT_OPT_NOT_DOMAINS: flatbuffers::VOffsetT = 8;
        pub const VT_PATTERNS: flatbuffers::VOffsetT = 10;
        pub const VT_MODIFIER_OPTION: flatbuffers::VOffsetT = 12;
        pub const VT_HOSTNAME: flatbuffers::VOffsetT = 14;
        pub const VT_TAG: flatbuffers::VOffsetT = 16;
        pub const VT_RAW_LINE: flatbuffers::VOffsetT = 18;

        #[inline]
        pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
            NetworkFilter { _tab: table }
        }
        #[allow(unused_mut)]
        pub fn create<
            'bldr: 'args,
            'args: 'mut_bldr,
            'mut_bldr,
            A: flatbuffers::Allocator + 'bldr,
        >(
            _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr, A>,
            args: &'args NetworkFilterArgs<'args>,
        ) -> flatbuffers::WIPOffset<NetworkFilter<'bldr>> {
            let mut builder = NetworkFilterBuilder::new(_fbb);
            if let Some(x) = args.raw_line {
                builder.add_raw_line(x);
            }
            if let Some(x) = args.tag {
                builder.add_tag(x);
            }
            if let Some(x) = args.hostname {
                builder.add_hostname(x);
            }
            if let Some(x) = args.modifier_option {
                builder.add_modifier_option(x);
            }
            if let Some(x) = args.patterns {
                builder.add_patterns(x);
            }
            if let Some(x) = args.opt_not_domains {
                builder.add_opt_not_domains(x);
            }
            if let Some(x) = args.opt_domains {
                builder.add_opt_domains(x);
            }
            builder.add_mask(args.mask);
            builder.finish()
        }

        pub fn unpack(&self) -> NetworkFilterT {
            let mask = self.mask();
            let opt_domains = self.opt_domains().map(|x| x.into_iter().collect());
            let opt_not_domains = self.opt_not_domains().map(|x| x.into_iter().collect());
            let patterns = self
                .patterns()
                .map(|x| x.iter().map(|s| s.to_string()).collect());
            let modifier_option = self.modifier_option().map(|x| x.to_string());
            let hostname = self.hostname().map(|x| x.to_string());
            let tag = self.tag().map(|x| x.to_string());
            let raw_line = self.raw_line().map(|x| x.to_string());
            NetworkFilterT {
                mask,
                opt_domains,
                opt_not_domains,
                patterns,
                modifier_option,
                hostname,
                tag,
                raw_line,
            }
        }

        #[inline]
        pub fn mask(&self) -> u32 {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<u32>(NetworkFilter::VT_MASK, Some(0))
                    .unwrap()
            }
        }
        /// These arrays contain sorted (ascending) indices in the |unique_domains_hashes|
        /// instead of the hashes themselves. This approach saves memory, as there
        /// typically aren’t many unique hashes
        #[inline]
        pub fn opt_domains(&self) -> Option<flatbuffers::Vector<'a, u32>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, u32>>>(
                        NetworkFilter::VT_OPT_DOMAINS,
                        None,
                    )
            }
        }
        #[inline]
        pub fn opt_not_domains(&self) -> Option<flatbuffers::Vector<'a, u32>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, u32>>>(
                        NetworkFilter::VT_OPT_NOT_DOMAINS,
                        None,
                    )
            }
        }
        #[inline]
        pub fn patterns(
            &self,
        ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab.get::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                >>(NetworkFilter::VT_PATTERNS, None)
            }
        }
        #[inline]
        pub fn modifier_option(&self) -> Option<&'a str> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab.get::<flatbuffers::ForwardsUOffset<&str>>(
                    NetworkFilter::VT_MODIFIER_OPTION,
                    None,
                )
            }
        }
        #[inline]
        pub fn hostname(&self) -> Option<&'a str> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<&str>>(NetworkFilter::VT_HOSTNAME, None)
            }
        }
        #[inline]
        pub fn tag(&self) -> Option<&'a str> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<&str>>(NetworkFilter::VT_TAG, None)
            }
        }
        #[inline]
        pub fn raw_line(&self) -> Option<&'a str> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<&str>>(NetworkFilter::VT_RAW_LINE, None)
            }
        }
    }

    impl flatbuffers::Verifiable for NetworkFilter<'_> {
        #[inline]
        fn run_verifier(
            v: &mut flatbuffers::Verifier,
            pos: usize,
        ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
            use self::flatbuffers::Verifiable;
            v.visit_table(pos)?
                .visit_field::<u32>("mask", Self::VT_MASK, false)?
                .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, u32>>>(
                    "opt_domains",
                    Self::VT_OPT_DOMAINS,
                    false,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, u32>>>(
                    "opt_not_domains",
                    Self::VT_OPT_NOT_DOMAINS,
                    false,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>("patterns", Self::VT_PATTERNS, false)?
                .visit_field::<flatbuffers::ForwardsUOffset<&str>>(
                    "modifier_option",
                    Self::VT_MODIFIER_OPTION,
                    false,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<&str>>(
                    "hostname",
                    Self::VT_HOSTNAME,
                    false,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<&str>>("tag", Self::VT_TAG, false)?
                .visit_field::<flatbuffers::ForwardsUOffset<&str>>(
                    "raw_line",
                    Self::VT_RAW_LINE,
                    false,
                )?
                .finish();
            Ok(())
        }
    }
    pub struct NetworkFilterArgs<'a> {
        pub mask: u32,
        pub opt_domains: Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, u32>>>,
        pub opt_not_domains: Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, u32>>>,
        pub patterns: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub modifier_option: Option<flatbuffers::WIPOffset<&'a str>>,
        pub hostname: Option<flatbuffers::WIPOffset<&'a str>>,
        pub tag: Option<flatbuffers::WIPOffset<&'a str>>,
        pub raw_line: Option<flatbuffers::WIPOffset<&'a str>>,
    }
    impl<'a> Default for NetworkFilterArgs<'a> {
        #[inline]
        fn default() -> Self {
            NetworkFilterArgs {
                mask: 0,
                opt_domains: None,
                opt_not_domains: None,
                patterns: None,
                modifier_option: None,
                hostname: None,
                tag: None,
                raw_line: None,
            }
        }
    }

    pub struct NetworkFilterBuilder<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> {
        fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
    }
    impl<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> NetworkFilterBuilder<'a, 'b, A> {
        #[inline]
        pub fn add_mask(&mut self, mask: u32) {
            self.fbb_.push_slot::<u32>(NetworkFilter::VT_MASK, mask, 0);
        }
        #[inline]
        pub fn add_opt_domains(
            &mut self,
            opt_domains: flatbuffers::WIPOffset<flatbuffers::Vector<'b, u32>>,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                NetworkFilter::VT_OPT_DOMAINS,
                opt_domains,
            );
        }
        #[inline]
        pub fn add_opt_not_domains(
            &mut self,
            opt_not_domains: flatbuffers::WIPOffset<flatbuffers::Vector<'b, u32>>,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                NetworkFilter::VT_OPT_NOT_DOMAINS,
                opt_not_domains,
            );
        }
        #[inline]
        pub fn add_patterns(
            &mut self,
            patterns: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                NetworkFilter::VT_PATTERNS,
                patterns,
            );
        }
        #[inline]
        pub fn add_modifier_option(&mut self, modifier_option: flatbuffers::WIPOffset<&'b str>) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                NetworkFilter::VT_MODIFIER_OPTION,
                modifier_option,
            );
        }
        #[inline]
        pub fn add_hostname(&mut self, hostname: flatbuffers::WIPOffset<&'b str>) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                NetworkFilter::VT_HOSTNAME,
                hostname,
            );
        }
        #[inline]
        pub fn add_tag(&mut self, tag: flatbuffers::WIPOffset<&'b str>) {
            self.fbb_
                .push_slot_always::<flatbuffers::WIPOffset<_>>(NetworkFilter::VT_TAG, tag);
        }
        #[inline]
        pub fn add_raw_line(&mut self, raw_line: flatbuffers::WIPOffset<&'b str>) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                NetworkFilter::VT_RAW_LINE,
                raw_line,
            );
        }
        #[inline]
        pub fn new(
            _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        ) -> NetworkFilterBuilder<'a, 'b, A> {
            let start = _fbb.start_table();
            NetworkFilterBuilder {
                fbb_: _fbb,
                start_: start,
            }
        }
        #[inline]
        pub fn finish(self) -> flatbuffers::WIPOffset<NetworkFilter<'a>> {
            let o = self.fbb_.end_table(self.start_);
            flatbuffers::WIPOffset::new(o.value())
        }
    }

    impl core::fmt::Debug for NetworkFilter<'_> {
        fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
            let mut ds = f.debug_struct("NetworkFilter");
            ds.field("mask", &self.mask());
            ds.field("opt_domains", &self.opt_domains());
            ds.field("opt_not_domains", &self.opt_not_domains());
            ds.field("patterns", &self.patterns());
            ds.field("modifier_option", &self.modifier_option());
            ds.field("hostname", &self.hostname());
            ds.field("tag", &self.tag());
            ds.field("raw_line", &self.raw_line());
            ds.finish()
        }
    }
    #[non_exhaustive]
    #[derive(Debug, Clone, PartialEq)]
    pub struct NetworkFilterT {
        pub mask: u32,
        pub opt_domains: Option<Vec<u32>>,
        pub opt_not_domains: Option<Vec<u32>>,
        pub patterns: Option<Vec<String>>,
        pub modifier_option: Option<String>,
        pub hostname: Option<String>,
        pub tag: Option<String>,
        pub raw_line: Option<String>,
    }
    impl Default for NetworkFilterT {
        fn default() -> Self {
            Self {
                mask: 0,
                opt_domains: None,
                opt_not_domains: None,
                patterns: None,
                modifier_option: None,
                hostname: None,
                tag: None,
                raw_line: None,
            }
        }
    }
    impl NetworkFilterT {
        pub fn pack<'b, A: flatbuffers::Allocator + 'b>(
            &self,
            _fbb: &mut flatbuffers::FlatBufferBuilder<'b, A>,
        ) -> flatbuffers::WIPOffset<NetworkFilter<'b>> {
            let mask = self.mask;
            let opt_domains = self.opt_domains.as_ref().map(|x| _fbb.create_vector(x));
            let opt_not_domains = self.opt_not_domains.as_ref().map(|x| _fbb.create_vector(x));
            let patterns = self.patterns.as_ref().map(|x| {
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let modifier_option = self.modifier_option.as_ref().map(|x| _fbb.create_string(x));
            let hostname = self.hostname.as_ref().map(|x| _fbb.create_string(x));
            let tag = self.tag.as_ref().map(|x| _fbb.create_string(x));
            let raw_line = self.raw_line.as_ref().map(|x| _fbb.create_string(x));
            NetworkFilter::create(
                _fbb,
                &NetworkFilterArgs {
                    mask,
                    opt_domains,
                    opt_not_domains,
                    patterns,
                    modifier_option,
                    hostname,
                    tag,
                    raw_line,
                },
            )
        }
    }
    pub enum NetworkFilterListOffset {}
    #[derive(Copy, Clone, PartialEq)]

    pub struct NetworkFilterList<'a> {
        pub _tab: flatbuffers::Table<'a>,
    }

    impl<'a> flatbuffers::Follow<'a> for NetworkFilterList<'a> {
        type Inner = NetworkFilterList<'a>;
        #[inline]
        unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
            Self {
                _tab: unsafe { flatbuffers::Table::new(buf, loc) },
            }
        }
    }

    impl<'a> NetworkFilterList<'a> {
        pub const VT_FILTER_MAP_INDEX: flatbuffers::VOffsetT = 4;
        pub const VT_FILTER_MAP_VALUES: flatbuffers::VOffsetT = 6;

        #[inline]
        pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
            NetworkFilterList { _tab: table }
        }
        #[allow(unused_mut)]
        pub fn create<
            'bldr: 'args,
            'args: 'mut_bldr,
            'mut_bldr,
            A: flatbuffers::Allocator + 'bldr,
        >(
            _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr, A>,
            args: &'args NetworkFilterListArgs<'args>,
        ) -> flatbuffers::WIPOffset<NetworkFilterList<'bldr>> {
            let mut builder = NetworkFilterListBuilder::new(_fbb);
            if let Some(x) = args.filter_map_values {
                builder.add_filter_map_values(x);
            }
            if let Some(x) = args.filter_map_index {
                builder.add_filter_map_index(x);
            }
            builder.finish()
        }

        pub fn unpack(&self) -> NetworkFilterListT {
            let filter_map_index = {
                let x = self.filter_map_index();
                x.into_iter().collect()
            };
            let filter_map_values = {
                let x = self.filter_map_values();
                x.iter().map(|t| t.unpack()).collect()
            };
            NetworkFilterListT {
                filter_map_index,
                filter_map_values,
            }
        }

        #[inline]
        pub fn filter_map_index(&self) -> flatbuffers::Vector<'a, u32> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, u32>>>(
                        NetworkFilterList::VT_FILTER_MAP_INDEX,
                        None,
                    )
                    .unwrap()
            }
        }
        #[inline]
        pub fn filter_map_values(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<NetworkFilter<'a>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<NetworkFilter>>,
                    >>(NetworkFilterList::VT_FILTER_MAP_VALUES, None)
                    .unwrap()
            }
        }
    }

    impl flatbuffers::Verifiable for NetworkFilterList<'_> {
        #[inline]
        fn run_verifier(
            v: &mut flatbuffers::Verifier,
            pos: usize,
        ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
            use self::flatbuffers::Verifiable;
            v.visit_table(pos)?
                .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, u32>>>(
                    "filter_map_index",
                    Self::VT_FILTER_MAP_INDEX,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<NetworkFilter>>,
                >>("filter_map_values", Self::VT_FILTER_MAP_VALUES, true)?
                .finish();
            Ok(())
        }
    }
    pub struct NetworkFilterListArgs<'a> {
        pub filter_map_index: Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, u32>>>,
        pub filter_map_values: Option<
            flatbuffers::WIPOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<NetworkFilter<'a>>>,
            >,
        >,
    }
    impl<'a> Default for NetworkFilterListArgs<'a> {
        #[inline]
        fn default() -> Self {
            NetworkFilterListArgs {
                filter_map_index: None,  // required field
                filter_map_values: None, // required field
            }
        }
    }

    pub struct NetworkFilterListBuilder<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> {
        fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
    }
    impl<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> NetworkFilterListBuilder<'a, 'b, A> {
        #[inline]
        pub fn add_filter_map_index(
            &mut self,
            filter_map_index: flatbuffers::WIPOffset<flatbuffers::Vector<'b, u32>>,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                NetworkFilterList::VT_FILTER_MAP_INDEX,
                filter_map_index,
            );
        }
        #[inline]
        pub fn add_filter_map_values(
            &mut self,
            filter_map_values: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<NetworkFilter<'b>>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                NetworkFilterList::VT_FILTER_MAP_VALUES,
                filter_map_values,
            );
        }
        #[inline]
        pub fn new(
            _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        ) -> NetworkFilterListBuilder<'a, 'b, A> {
            let start = _fbb.start_table();
            NetworkFilterListBuilder {
                fbb_: _fbb,
                start_: start,
            }
        }
        #[inline]
        pub fn finish(self) -> flatbuffers::WIPOffset<NetworkFilterList<'a>> {
            let o = self.fbb_.end_table(self.start_);
            self.fbb_.required(
                o,
                NetworkFilterList::VT_FILTER_MAP_INDEX,
                "filter_map_index",
            );
            self.fbb_.required(
                o,
                NetworkFilterList::VT_FILTER_MAP_VALUES,
                "filter_map_values",
            );
            flatbuffers::WIPOffset::new(o.value())
        }
    }

    impl core::fmt::Debug for NetworkFilterList<'_> {
        fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
            let mut ds = f.debug_struct("NetworkFilterList");
            ds.field("filter_map_index", &self.filter_map_index());
            ds.field("filter_map_values", &self.filter_map_values());
            ds.finish()
        }
    }
    #[non_exhaustive]
    #[derive(Debug, Clone, PartialEq)]
    pub struct NetworkFilterListT {
        pub filter_map_index: Vec<u32>,
        pub filter_map_values: Vec<NetworkFilterT>,
    }
    impl Default for NetworkFilterListT {
        fn default() -> Self {
            Self {
                filter_map_index: Default::default(),
                filter_map_values: Default::default(),
            }
        }
    }
    impl NetworkFilterListT {
        pub fn pack<'b, A: flatbuffers::Allocator + 'b>(
            &self,
            _fbb: &mut flatbuffers::FlatBufferBuilder<'b, A>,
        ) -> flatbuffers::WIPOffset<NetworkFilterList<'b>> {
            let filter_map_index = Some({
                let x = &self.filter_map_index;
                _fbb.create_vector(x)
            });
            let filter_map_values = Some({
                let x = &self.filter_map_values;
                let w: Vec<_> = x.iter().map(|t| t.pack(_fbb)).collect();
                _fbb.create_vector(&w)
            });
            NetworkFilterList::create(
                _fbb,
                &NetworkFilterListArgs {
                    filter_map_index,
                    filter_map_values,
                },
            )
        }
    }
    pub enum HostnameSpecificRulesOffset {}
    #[derive(Copy, Clone, PartialEq)]

    /// A table to store the most host-specific cosmetic rules.
    /// Although, the most common kind of rule (see hostname_inject_script_*
    /// and hostname_hide_*) are stored separately to save memory.
    pub struct HostnameSpecificRules<'a> {
        pub _tab: flatbuffers::Table<'a>,
    }

    impl<'a> flatbuffers::Follow<'a> for HostnameSpecificRules<'a> {
        type Inner = HostnameSpecificRules<'a>;
        #[inline]
        unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
            Self {
                _tab: unsafe { flatbuffers::Table::new(buf, loc) },
            }
        }
    }

    impl<'a> HostnameSpecificRules<'a> {
        pub const VT_UNHIDE: flatbuffers::VOffsetT = 4;
        pub const VT_UNINJECT_SCRIPT: flatbuffers::VOffsetT = 6;
        pub const VT_PROCEDURAL_ACTION: flatbuffers::VOffsetT = 8;
        pub const VT_PROCEDURAL_ACTION_EXCEPTION: flatbuffers::VOffsetT = 10;

        #[inline]
        pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
            HostnameSpecificRules { _tab: table }
        }
        #[allow(unused_mut)]
        pub fn create<
            'bldr: 'args,
            'args: 'mut_bldr,
            'mut_bldr,
            A: flatbuffers::Allocator + 'bldr,
        >(
            _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr, A>,
            args: &'args HostnameSpecificRulesArgs<'args>,
        ) -> flatbuffers::WIPOffset<HostnameSpecificRules<'bldr>> {
            let mut builder = HostnameSpecificRulesBuilder::new(_fbb);
            if let Some(x) = args.procedural_action_exception {
                builder.add_procedural_action_exception(x);
            }
            if let Some(x) = args.procedural_action {
                builder.add_procedural_action(x);
            }
            if let Some(x) = args.uninject_script {
                builder.add_uninject_script(x);
            }
            if let Some(x) = args.unhide {
                builder.add_unhide(x);
            }
            builder.finish()
        }

        pub fn unpack(&self) -> HostnameSpecificRulesT {
            let unhide = self
                .unhide()
                .map(|x| x.iter().map(|s| s.to_string()).collect());
            let uninject_script = self
                .uninject_script()
                .map(|x| x.iter().map(|s| s.to_string()).collect());
            let procedural_action = self
                .procedural_action()
                .map(|x| x.iter().map(|s| s.to_string()).collect());
            let procedural_action_exception = self
                .procedural_action_exception()
                .map(|x| x.iter().map(|s| s.to_string()).collect());
            HostnameSpecificRulesT {
                unhide,
                uninject_script,
                procedural_action,
                procedural_action_exception,
            }
        }

        /// Simple hide exception rules, e.g. `example.com#@#.ad`.
        /// The content is the rule's CSS selector.
        #[inline]
        pub fn unhide(
            &self,
        ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab.get::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                >>(HostnameSpecificRules::VT_UNHIDE, None)
            }
        }
        /// Rules to except a scriptlet to inject along with any arguments, e.g.
        /// `example.com#@#+js(acis, Number.isNan)`.
        /// The content is the contents of the `+js(...)` syntax construct.
        /// In practice, these rules are extremely rare in filter lists.
        #[inline]
        pub fn uninject_script(
            &self,
        ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab.get::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                >>(HostnameSpecificRules::VT_UNINJECT_SCRIPT, None)
            }
        }
        /// Procedural filters and/or filters with a [`CosmeticFilterAction`].
        /// Each is a [`ProceduralOrActionFilter`] struct serialized as JSON.
        #[inline]
        pub fn procedural_action(
            &self,
        ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab.get::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                >>(HostnameSpecificRules::VT_PROCEDURAL_ACTION, None)
            }
        }
        /// Exceptions for procedural filters and/or filters with a [`CosmeticFilterAction`].
        /// Each is a [`ProceduralOrActionFilter`] struct serialized as JSON.
        #[inline]
        pub fn procedural_action_exception(
            &self,
        ) -> Option<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab.get::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                >>(
                    HostnameSpecificRules::VT_PROCEDURAL_ACTION_EXCEPTION, None
                )
            }
        }
    }

    impl flatbuffers::Verifiable for HostnameSpecificRules<'_> {
        #[inline]
        fn run_verifier(
            v: &mut flatbuffers::Verifier,
            pos: usize,
        ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
            use self::flatbuffers::Verifiable;
            v.visit_table(pos)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>("unhide", Self::VT_UNHIDE, false)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>("uninject_script", Self::VT_UNINJECT_SCRIPT, false)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>("procedural_action", Self::VT_PROCEDURAL_ACTION, false)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>(
                    "procedural_action_exception",
                    Self::VT_PROCEDURAL_ACTION_EXCEPTION,
                    false,
                )?
                .finish();
            Ok(())
        }
    }
    pub struct HostnameSpecificRulesArgs<'a> {
        pub unhide: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub uninject_script: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub procedural_action: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub procedural_action_exception: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
    }
    impl<'a> Default for HostnameSpecificRulesArgs<'a> {
        #[inline]
        fn default() -> Self {
            HostnameSpecificRulesArgs {
                unhide: None,
                uninject_script: None,
                procedural_action: None,
                procedural_action_exception: None,
            }
        }
    }

    pub struct HostnameSpecificRulesBuilder<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> {
        fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
    }
    impl<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> HostnameSpecificRulesBuilder<'a, 'b, A> {
        #[inline]
        pub fn add_unhide(
            &mut self,
            unhide: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                HostnameSpecificRules::VT_UNHIDE,
                unhide,
            );
        }
        #[inline]
        pub fn add_uninject_script(
            &mut self,
            uninject_script: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                HostnameSpecificRules::VT_UNINJECT_SCRIPT,
                uninject_script,
            );
        }
        #[inline]
        pub fn add_procedural_action(
            &mut self,
            procedural_action: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                HostnameSpecificRules::VT_PROCEDURAL_ACTION,
                procedural_action,
            );
        }
        #[inline]
        pub fn add_procedural_action_exception(
            &mut self,
            procedural_action_exception: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                HostnameSpecificRules::VT_PROCEDURAL_ACTION_EXCEPTION,
                procedural_action_exception,
            );
        }
        #[inline]
        pub fn new(
            _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        ) -> HostnameSpecificRulesBuilder<'a, 'b, A> {
            let start = _fbb.start_table();
            HostnameSpecificRulesBuilder {
                fbb_: _fbb,
                start_: start,
            }
        }
        #[inline]
        pub fn finish(self) -> flatbuffers::WIPOffset<HostnameSpecificRules<'a>> {
            let o = self.fbb_.end_table(self.start_);
            flatbuffers::WIPOffset::new(o.value())
        }
    }

    impl core::fmt::Debug for HostnameSpecificRules<'_> {
        fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
            let mut ds = f.debug_struct("HostnameSpecificRules");
            ds.field("unhide", &self.unhide());
            ds.field("uninject_script", &self.uninject_script());
            ds.field("procedural_action", &self.procedural_action());
            ds.field(
                "procedural_action_exception",
                &self.procedural_action_exception(),
            );
            ds.finish()
        }
    }
    #[non_exhaustive]
    #[derive(Debug, Clone, PartialEq)]
    pub struct HostnameSpecificRulesT {
        pub unhide: Option<Vec<String>>,
        pub uninject_script: Option<Vec<String>>,
        pub procedural_action: Option<Vec<String>>,
        pub procedural_action_exception: Option<Vec<String>>,
    }
    impl Default for HostnameSpecificRulesT {
        fn default() -> Self {
            Self {
                unhide: None,
                uninject_script: None,
                procedural_action: None,
                procedural_action_exception: None,
            }
        }
    }
    impl HostnameSpecificRulesT {
        pub fn pack<'b, A: flatbuffers::Allocator + 'b>(
            &self,
            _fbb: &mut flatbuffers::FlatBufferBuilder<'b, A>,
        ) -> flatbuffers::WIPOffset<HostnameSpecificRules<'b>> {
            let unhide = self.unhide.as_ref().map(|x| {
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let uninject_script = self.uninject_script.as_ref().map(|x| {
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let procedural_action = self.procedural_action.as_ref().map(|x| {
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let procedural_action_exception = self.procedural_action_exception.as_ref().map(|x| {
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            HostnameSpecificRules::create(
                _fbb,
                &HostnameSpecificRulesArgs {
                    unhide,
                    uninject_script,
                    procedural_action,
                    procedural_action_exception,
                },
            )
        }
    }
    pub enum StringVectorOffset {}
    #[derive(Copy, Clone, PartialEq)]

    pub struct StringVector<'a> {
        pub _tab: flatbuffers::Table<'a>,
    }

    impl<'a> flatbuffers::Follow<'a> for StringVector<'a> {
        type Inner = StringVector<'a>;
        #[inline]
        unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
            Self {
                _tab: unsafe { flatbuffers::Table::new(buf, loc) },
            }
        }
    }

    impl<'a> StringVector<'a> {
        pub const VT_DATA: flatbuffers::VOffsetT = 4;

        #[inline]
        pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
            StringVector { _tab: table }
        }
        #[allow(unused_mut)]
        pub fn create<
            'bldr: 'args,
            'args: 'mut_bldr,
            'mut_bldr,
            A: flatbuffers::Allocator + 'bldr,
        >(
            _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr, A>,
            args: &'args StringVectorArgs<'args>,
        ) -> flatbuffers::WIPOffset<StringVector<'bldr>> {
            let mut builder = StringVectorBuilder::new(_fbb);
            if let Some(x) = args.data {
                builder.add_data(x);
            }
            builder.finish()
        }

        pub fn unpack(&self) -> StringVectorT {
            let data = {
                let x = self.data();
                x.iter().map(|s| s.to_string()).collect()
            };
            StringVectorT { data }
        }

        #[inline]
        pub fn data(&self) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                    >>(StringVector::VT_DATA, None)
                    .unwrap()
            }
        }
    }

    impl flatbuffers::Verifiable for StringVector<'_> {
        #[inline]
        fn run_verifier(
            v: &mut flatbuffers::Verifier,
            pos: usize,
        ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
            use self::flatbuffers::Verifiable;
            v.visit_table(pos)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>("data", Self::VT_DATA, true)?
                .finish();
            Ok(())
        }
    }
    pub struct StringVectorArgs<'a> {
        pub data: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
    }
    impl<'a> Default for StringVectorArgs<'a> {
        #[inline]
        fn default() -> Self {
            StringVectorArgs {
                data: None, // required field
            }
        }
    }

    pub struct StringVectorBuilder<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> {
        fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
    }
    impl<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> StringVectorBuilder<'a, 'b, A> {
        #[inline]
        pub fn add_data(
            &mut self,
            data: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_
                .push_slot_always::<flatbuffers::WIPOffset<_>>(StringVector::VT_DATA, data);
        }
        #[inline]
        pub fn new(
            _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        ) -> StringVectorBuilder<'a, 'b, A> {
            let start = _fbb.start_table();
            StringVectorBuilder {
                fbb_: _fbb,
                start_: start,
            }
        }
        #[inline]
        pub fn finish(self) -> flatbuffers::WIPOffset<StringVector<'a>> {
            let o = self.fbb_.end_table(self.start_);
            self.fbb_.required(o, StringVector::VT_DATA, "data");
            flatbuffers::WIPOffset::new(o.value())
        }
    }

    impl core::fmt::Debug for StringVector<'_> {
        fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
            let mut ds = f.debug_struct("StringVector");
            ds.field("data", &self.data());
            ds.finish()
        }
    }
    #[non_exhaustive]
    #[derive(Debug, Clone, PartialEq)]
    pub struct StringVectorT {
        pub data: Vec<String>,
    }
    impl Default for StringVectorT {
        fn default() -> Self {
            Self {
                data: Default::default(),
            }
        }
    }
    impl StringVectorT {
        pub fn pack<'b, A: flatbuffers::Allocator + 'b>(
            &self,
            _fbb: &mut flatbuffers::FlatBufferBuilder<'b, A>,
        ) -> flatbuffers::WIPOffset<StringVector<'b>> {
            let data = Some({
                let x = &self.data;
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            StringVector::create(_fbb, &StringVectorArgs { data })
        }
    }
    pub enum CosmeticFiltersOffset {}
    #[derive(Copy, Clone, PartialEq)]

    /// A table to store cosmetic filter rules (including supported structures).
    pub struct CosmeticFilters<'a> {
        pub _tab: flatbuffers::Table<'a>,
    }

    impl<'a> flatbuffers::Follow<'a> for CosmeticFilters<'a> {
        type Inner = CosmeticFilters<'a>;
        #[inline]
        unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
            Self {
                _tab: unsafe { flatbuffers::Table::new(buf, loc) },
            }
        }
    }

    impl<'a> CosmeticFilters<'a> {
        pub const VT_SIMPLE_CLASS_RULES: flatbuffers::VOffsetT = 4;
        pub const VT_SIMPLE_ID_RULES: flatbuffers::VOffsetT = 6;
        pub const VT_MISC_GENERIC_SELECTORS: flatbuffers::VOffsetT = 8;
        pub const VT_COMPLEX_CLASS_RULES_INDEX: flatbuffers::VOffsetT = 10;
        pub const VT_COMPLEX_CLASS_RULES_VALUES: flatbuffers::VOffsetT = 12;
        pub const VT_COMPLEX_ID_RULES_INDEX: flatbuffers::VOffsetT = 14;
        pub const VT_COMPLEX_ID_RULES_VALUES: flatbuffers::VOffsetT = 16;
        pub const VT_HOSTNAME_HIDE_INDEX: flatbuffers::VOffsetT = 18;
        pub const VT_HOSTNAME_HIDE_VALUES: flatbuffers::VOffsetT = 20;
        pub const VT_HOSTNAME_INJECT_SCRIPT_INDEX: flatbuffers::VOffsetT = 22;
        pub const VT_HOSTNAME_INJECT_SCRIPT_VALUES: flatbuffers::VOffsetT = 24;
        pub const VT_HOSTNAME_INDEX: flatbuffers::VOffsetT = 26;
        pub const VT_HOSTNAME_VALUES: flatbuffers::VOffsetT = 28;

        #[inline]
        pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
            CosmeticFilters { _tab: table }
        }
        #[allow(unused_mut)]
        pub fn create<
            'bldr: 'args,
            'args: 'mut_bldr,
            'mut_bldr,
            A: flatbuffers::Allocator + 'bldr,
        >(
            _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr, A>,
            args: &'args CosmeticFiltersArgs<'args>,
        ) -> flatbuffers::WIPOffset<CosmeticFilters<'bldr>> {
            let mut builder = CosmeticFiltersBuilder::new(_fbb);
            if let Some(x) = args.hostname_values {
                builder.add_hostname_values(x);
            }
            if let Some(x) = args.hostname_index {
                builder.add_hostname_index(x);
            }
            if let Some(x) = args.hostname_inject_script_values {
                builder.add_hostname_inject_script_values(x);
            }
            if let Some(x) = args.hostname_inject_script_index {
                builder.add_hostname_inject_script_index(x);
            }
            if let Some(x) = args.hostname_hide_values {
                builder.add_hostname_hide_values(x);
            }
            if let Some(x) = args.hostname_hide_index {
                builder.add_hostname_hide_index(x);
            }
            if let Some(x) = args.complex_id_rules_values {
                builder.add_complex_id_rules_values(x);
            }
            if let Some(x) = args.complex_id_rules_index {
                builder.add_complex_id_rules_index(x);
            }
            if let Some(x) = args.complex_class_rules_values {
                builder.add_complex_class_rules_values(x);
            }
            if let Some(x) = args.complex_class_rules_index {
                builder.add_complex_class_rules_index(x);
            }
            if let Some(x) = args.misc_generic_selectors {
                builder.add_misc_generic_selectors(x);
            }
            if let Some(x) = args.simple_id_rules {
                builder.add_simple_id_rules(x);
            }
            if let Some(x) = args.simple_class_rules {
                builder.add_simple_class_rules(x);
            }
            builder.finish()
        }

        pub fn unpack(&self) -> CosmeticFiltersT {
            let simple_class_rules = {
                let x = self.simple_class_rules();
                x.iter().map(|s| s.to_string()).collect()
            };
            let simple_id_rules = {
                let x = self.simple_id_rules();
                x.iter().map(|s| s.to_string()).collect()
            };
            let misc_generic_selectors = {
                let x = self.misc_generic_selectors();
                x.iter().map(|s| s.to_string()).collect()
            };
            let complex_class_rules_index = {
                let x = self.complex_class_rules_index();
                x.iter().map(|s| s.to_string()).collect()
            };
            let complex_class_rules_values = {
                let x = self.complex_class_rules_values();
                x.iter().map(|t| t.unpack()).collect()
            };
            let complex_id_rules_index = {
                let x = self.complex_id_rules_index();
                x.iter().map(|s| s.to_string()).collect()
            };
            let complex_id_rules_values = {
                let x = self.complex_id_rules_values();
                x.iter().map(|t| t.unpack()).collect()
            };
            let hostname_hide_index = {
                let x = self.hostname_hide_index();
                x.into_iter().collect()
            };
            let hostname_hide_values = {
                let x = self.hostname_hide_values();
                x.iter().map(|s| s.to_string()).collect()
            };
            let hostname_inject_script_index = {
                let x = self.hostname_inject_script_index();
                x.into_iter().collect()
            };
            let hostname_inject_script_values = {
                let x = self.hostname_inject_script_values();
                x.iter().map(|s| s.to_string()).collect()
            };
            let hostname_index = {
                let x = self.hostname_index();
                x.into_iter().collect()
            };
            let hostname_values = {
                let x = self.hostname_values();
                x.iter().map(|t| t.unpack()).collect()
            };
            CosmeticFiltersT {
                simple_class_rules,
                simple_id_rules,
                misc_generic_selectors,
                complex_class_rules_index,
                complex_class_rules_values,
                complex_id_rules_index,
                complex_id_rules_values,
                hostname_hide_index,
                hostname_hide_values,
                hostname_inject_script_index,
                hostname_inject_script_values,
                hostname_index,
                hostname_values,
            }
        }

        /// Rules that are just the CSS class of an element to be hidden on all sites, e.g. `##.ad`.
        /// Stored as a flat_set.
        #[inline]
        pub fn simple_class_rules(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                    >>(CosmeticFilters::VT_SIMPLE_CLASS_RULES, None)
                    .unwrap()
            }
        }
        /// Rules that are just the CSS id of an element to be hidden on all sites, e.g. `###banner`.
        /// Stored as a flat_set.
        #[inline]
        pub fn simple_id_rules(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                    >>(CosmeticFilters::VT_SIMPLE_ID_RULES, None)
                    .unwrap()
            }
        }
        /// Rules that are the CSS selector of an element to be hidden on all sites that do not fit
        /// into any of the class or id buckets, e.g. `##a[href="https://malware.com"]`
        /// Stored as a flat_set.
        #[inline]
        pub fn misc_generic_selectors(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                    >>(CosmeticFilters::VT_MISC_GENERIC_SELECTORS, None)
                    .unwrap()
            }
        }
        /// Rules that are the CSS selector of an element to be hidden on all sites, starting with a
        /// class, e.g. `##.ad image`.
        /// Stored as a multi-map `hostname_hash` => `selector`
        #[inline]
        pub fn complex_class_rules_index(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                    >>(CosmeticFilters::VT_COMPLEX_CLASS_RULES_INDEX, None)
                    .unwrap()
            }
        }
        #[inline]
        pub fn complex_class_rules_values(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<StringVector<'a>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<StringVector>>,
                    >>(CosmeticFilters::VT_COMPLEX_CLASS_RULES_VALUES, None)
                    .unwrap()
            }
        }
        /// Rules that are the CSS selector of an element to be hidden on all sites, starting with an
        /// id, e.g. `###banner > .text a`.
        /// Stored as a multi-map `hostname_hash` => `selector`
        #[inline]
        pub fn complex_id_rules_index(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                    >>(CosmeticFilters::VT_COMPLEX_ID_RULES_INDEX, None)
                    .unwrap()
            }
        }
        #[inline]
        pub fn complex_id_rules_values(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<StringVector<'a>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<StringVector>>,
                    >>(CosmeticFilters::VT_COMPLEX_ID_RULES_VALUES, None)
                    .unwrap()
            }
        }
        /// Simple hostname-specific hide rules, e.g. `example.com##.ad`.
        /// Stored as a multi-map `hostname_hash` => `selector`.
        /// Doesn't belong to HostnameSpecificRules for performance reasons.
        #[inline]
        pub fn hostname_hide_index(&self) -> flatbuffers::Vector<'a, u64> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, u64>>>(
                        CosmeticFilters::VT_HOSTNAME_HIDE_INDEX,
                        None,
                    )
                    .unwrap()
            }
        }
        #[inline]
        pub fn hostname_hide_values(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                    >>(CosmeticFilters::VT_HOSTNAME_HIDE_VALUES, None)
                    .unwrap()
            }
        }
        /// Rules with a scriptlet to inject along with any arguments, e.g.
        /// `example.com##+js(acis, Number.isNan)`.
        /// Stored as a multi-map `hostname_hash` => `script_plus_permission_byte`
        /// The content is the contents of the `+js(...)` syntax construct plus
        /// last byte stores permission to save memory.
        /// Doesn't belong to HostnameSpecificRules for performance reasons.
        #[inline]
        pub fn hostname_inject_script_index(&self) -> flatbuffers::Vector<'a, u64> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, u64>>>(
                        CosmeticFilters::VT_HOSTNAME_INJECT_SCRIPT_INDEX,
                        None,
                    )
                    .unwrap()
            }
        }
        #[inline]
        pub fn hostname_inject_script_values(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>,
                    >>(CosmeticFilters::VT_HOSTNAME_INJECT_SCRIPT_VALUES, None)
                    .unwrap()
            }
        }
        /// A map to store the other host-specific cosmetic rules.
        #[inline]
        pub fn hostname_index(&self) -> flatbuffers::Vector<'a, u64> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, u64>>>(
                        CosmeticFilters::VT_HOSTNAME_INDEX,
                        None,
                    )
                    .unwrap()
            }
        }
        #[inline]
        pub fn hostname_values(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<HostnameSpecificRules<'a>>>
        {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<
                            'a,
                            flatbuffers::ForwardsUOffset<HostnameSpecificRules>,
                        >,
                    >>(CosmeticFilters::VT_HOSTNAME_VALUES, None)
                    .unwrap()
            }
        }
    }

    impl flatbuffers::Verifiable for CosmeticFilters<'_> {
        #[inline]
        fn run_verifier(
            v: &mut flatbuffers::Verifier,
            pos: usize,
        ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
            use self::flatbuffers::Verifiable;
            v.visit_table(pos)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>("simple_class_rules", Self::VT_SIMPLE_CLASS_RULES, true)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>("simple_id_rules", Self::VT_SIMPLE_ID_RULES, true)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>(
                    "misc_generic_selectors",
                    Self::VT_MISC_GENERIC_SELECTORS,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>(
                    "complex_class_rules_index",
                    Self::VT_COMPLEX_CLASS_RULES_INDEX,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<StringVector>>,
                >>(
                    "complex_class_rules_values",
                    Self::VT_COMPLEX_CLASS_RULES_VALUES,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>(
                    "complex_id_rules_index",
                    Self::VT_COMPLEX_ID_RULES_INDEX,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<StringVector>>,
                >>(
                    "complex_id_rules_values",
                    Self::VT_COMPLEX_ID_RULES_VALUES,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, u64>>>(
                    "hostname_hide_index",
                    Self::VT_HOSTNAME_HIDE_INDEX,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>("hostname_hide_values", Self::VT_HOSTNAME_HIDE_VALUES, true)?
                .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, u64>>>(
                    "hostname_inject_script_index",
                    Self::VT_HOSTNAME_INJECT_SCRIPT_INDEX,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<&'_ str>>,
                >>(
                    "hostname_inject_script_values",
                    Self::VT_HOSTNAME_INJECT_SCRIPT_VALUES,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, u64>>>(
                    "hostname_index",
                    Self::VT_HOSTNAME_INDEX,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<HostnameSpecificRules>>,
                >>("hostname_values", Self::VT_HOSTNAME_VALUES, true)?
                .finish();
            Ok(())
        }
    }
    pub struct CosmeticFiltersArgs<'a> {
        pub simple_class_rules: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub simple_id_rules: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub misc_generic_selectors: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub complex_class_rules_index: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub complex_class_rules_values: Option<
            flatbuffers::WIPOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<StringVector<'a>>>,
            >,
        >,
        pub complex_id_rules_index: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub complex_id_rules_values: Option<
            flatbuffers::WIPOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<StringVector<'a>>>,
            >,
        >,
        pub hostname_hide_index: Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, u64>>>,
        pub hostname_hide_values: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub hostname_inject_script_index:
            Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, u64>>>,
        pub hostname_inject_script_values: Option<
            flatbuffers::WIPOffset<flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<&'a str>>>,
        >,
        pub hostname_index: Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, u64>>>,
        pub hostname_values: Option<
            flatbuffers::WIPOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<HostnameSpecificRules<'a>>>,
            >,
        >,
    }
    impl<'a> Default for CosmeticFiltersArgs<'a> {
        #[inline]
        fn default() -> Self {
            CosmeticFiltersArgs {
                simple_class_rules: None,            // required field
                simple_id_rules: None,               // required field
                misc_generic_selectors: None,        // required field
                complex_class_rules_index: None,     // required field
                complex_class_rules_values: None,    // required field
                complex_id_rules_index: None,        // required field
                complex_id_rules_values: None,       // required field
                hostname_hide_index: None,           // required field
                hostname_hide_values: None,          // required field
                hostname_inject_script_index: None,  // required field
                hostname_inject_script_values: None, // required field
                hostname_index: None,                // required field
                hostname_values: None,               // required field
            }
        }
    }

    pub struct CosmeticFiltersBuilder<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> {
        fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
    }
    impl<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> CosmeticFiltersBuilder<'a, 'b, A> {
        #[inline]
        pub fn add_simple_class_rules(
            &mut self,
            simple_class_rules: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_SIMPLE_CLASS_RULES,
                simple_class_rules,
            );
        }
        #[inline]
        pub fn add_simple_id_rules(
            &mut self,
            simple_id_rules: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_SIMPLE_ID_RULES,
                simple_id_rules,
            );
        }
        #[inline]
        pub fn add_misc_generic_selectors(
            &mut self,
            misc_generic_selectors: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_MISC_GENERIC_SELECTORS,
                misc_generic_selectors,
            );
        }
        #[inline]
        pub fn add_complex_class_rules_index(
            &mut self,
            complex_class_rules_index: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_COMPLEX_CLASS_RULES_INDEX,
                complex_class_rules_index,
            );
        }
        #[inline]
        pub fn add_complex_class_rules_values(
            &mut self,
            complex_class_rules_values: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<StringVector<'b>>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_COMPLEX_CLASS_RULES_VALUES,
                complex_class_rules_values,
            );
        }
        #[inline]
        pub fn add_complex_id_rules_index(
            &mut self,
            complex_id_rules_index: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_COMPLEX_ID_RULES_INDEX,
                complex_id_rules_index,
            );
        }
        #[inline]
        pub fn add_complex_id_rules_values(
            &mut self,
            complex_id_rules_values: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<StringVector<'b>>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_COMPLEX_ID_RULES_VALUES,
                complex_id_rules_values,
            );
        }
        #[inline]
        pub fn add_hostname_hide_index(
            &mut self,
            hostname_hide_index: flatbuffers::WIPOffset<flatbuffers::Vector<'b, u64>>,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_HOSTNAME_HIDE_INDEX,
                hostname_hide_index,
            );
        }
        #[inline]
        pub fn add_hostname_hide_values(
            &mut self,
            hostname_hide_values: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_HOSTNAME_HIDE_VALUES,
                hostname_hide_values,
            );
        }
        #[inline]
        pub fn add_hostname_inject_script_index(
            &mut self,
            hostname_inject_script_index: flatbuffers::WIPOffset<flatbuffers::Vector<'b, u64>>,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_HOSTNAME_INJECT_SCRIPT_INDEX,
                hostname_inject_script_index,
            );
        }
        #[inline]
        pub fn add_hostname_inject_script_values(
            &mut self,
            hostname_inject_script_values: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<&'b str>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_HOSTNAME_INJECT_SCRIPT_VALUES,
                hostname_inject_script_values,
            );
        }
        #[inline]
        pub fn add_hostname_index(
            &mut self,
            hostname_index: flatbuffers::WIPOffset<flatbuffers::Vector<'b, u64>>,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_HOSTNAME_INDEX,
                hostname_index,
            );
        }
        #[inline]
        pub fn add_hostname_values(
            &mut self,
            hostname_values: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<HostnameSpecificRules<'b>>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                CosmeticFilters::VT_HOSTNAME_VALUES,
                hostname_values,
            );
        }
        #[inline]
        pub fn new(
            _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        ) -> CosmeticFiltersBuilder<'a, 'b, A> {
            let start = _fbb.start_table();
            CosmeticFiltersBuilder {
                fbb_: _fbb,
                start_: start,
            }
        }
        #[inline]
        pub fn finish(self) -> flatbuffers::WIPOffset<CosmeticFilters<'a>> {
            let o = self.fbb_.end_table(self.start_);
            self.fbb_.required(
                o,
                CosmeticFilters::VT_SIMPLE_CLASS_RULES,
                "simple_class_rules",
            );
            self.fbb_
                .required(o, CosmeticFilters::VT_SIMPLE_ID_RULES, "simple_id_rules");
            self.fbb_.required(
                o,
                CosmeticFilters::VT_MISC_GENERIC_SELECTORS,
                "misc_generic_selectors",
            );
            self.fbb_.required(
                o,
                CosmeticFilters::VT_COMPLEX_CLASS_RULES_INDEX,
                "complex_class_rules_index",
            );
            self.fbb_.required(
                o,
                CosmeticFilters::VT_COMPLEX_CLASS_RULES_VALUES,
                "complex_class_rules_values",
            );
            self.fbb_.required(
                o,
                CosmeticFilters::VT_COMPLEX_ID_RULES_INDEX,
                "complex_id_rules_index",
            );
            self.fbb_.required(
                o,
                CosmeticFilters::VT_COMPLEX_ID_RULES_VALUES,
                "complex_id_rules_values",
            );
            self.fbb_.required(
                o,
                CosmeticFilters::VT_HOSTNAME_HIDE_INDEX,
                "hostname_hide_index",
            );
            self.fbb_.required(
                o,
                CosmeticFilters::VT_HOSTNAME_HIDE_VALUES,
                "hostname_hide_values",
            );
            self.fbb_.required(
                o,
                CosmeticFilters::VT_HOSTNAME_INJECT_SCRIPT_INDEX,
                "hostname_inject_script_index",
            );
            self.fbb_.required(
                o,
                CosmeticFilters::VT_HOSTNAME_INJECT_SCRIPT_VALUES,
                "hostname_inject_script_values",
            );
            self.fbb_
                .required(o, CosmeticFilters::VT_HOSTNAME_INDEX, "hostname_index");
            self.fbb_
                .required(o, CosmeticFilters::VT_HOSTNAME_VALUES, "hostname_values");
            flatbuffers::WIPOffset::new(o.value())
        }
    }

    impl core::fmt::Debug for CosmeticFilters<'_> {
        fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
            let mut ds = f.debug_struct("CosmeticFilters");
            ds.field("simple_class_rules", &self.simple_class_rules());
            ds.field("simple_id_rules", &self.simple_id_rules());
            ds.field("misc_generic_selectors", &self.misc_generic_selectors());
            ds.field(
                "complex_class_rules_index",
                &self.complex_class_rules_index(),
            );
            ds.field(
                "complex_class_rules_values",
                &self.complex_class_rules_values(),
            );
            ds.field("complex_id_rules_index", &self.complex_id_rules_index());
            ds.field("complex_id_rules_values", &self.complex_id_rules_values());
            ds.field("hostname_hide_index", &self.hostname_hide_index());
            ds.field("hostname_hide_values", &self.hostname_hide_values());
            ds.field(
                "hostname_inject_script_index",
                &self.hostname_inject_script_index(),
            );
            ds.field(
                "hostname_inject_script_values",
                &self.hostname_inject_script_values(),
            );
            ds.field("hostname_index", &self.hostname_index());
            ds.field("hostname_values", &self.hostname_values());
            ds.finish()
        }
    }
    #[non_exhaustive]
    #[derive(Debug, Clone, PartialEq)]
    pub struct CosmeticFiltersT {
        pub simple_class_rules: Vec<String>,
        pub simple_id_rules: Vec<String>,
        pub misc_generic_selectors: Vec<String>,
        pub complex_class_rules_index: Vec<String>,
        pub complex_class_rules_values: Vec<StringVectorT>,
        pub complex_id_rules_index: Vec<String>,
        pub complex_id_rules_values: Vec<StringVectorT>,
        pub hostname_hide_index: Vec<u64>,
        pub hostname_hide_values: Vec<String>,
        pub hostname_inject_script_index: Vec<u64>,
        pub hostname_inject_script_values: Vec<String>,
        pub hostname_index: Vec<u64>,
        pub hostname_values: Vec<HostnameSpecificRulesT>,
    }
    impl Default for CosmeticFiltersT {
        fn default() -> Self {
            Self {
                simple_class_rules: Default::default(),
                simple_id_rules: Default::default(),
                misc_generic_selectors: Default::default(),
                complex_class_rules_index: Default::default(),
                complex_class_rules_values: Default::default(),
                complex_id_rules_index: Default::default(),
                complex_id_rules_values: Default::default(),
                hostname_hide_index: Default::default(),
                hostname_hide_values: Default::default(),
                hostname_inject_script_index: Default::default(),
                hostname_inject_script_values: Default::default(),
                hostname_index: Default::default(),
                hostname_values: Default::default(),
            }
        }
    }
    impl CosmeticFiltersT {
        pub fn pack<'b, A: flatbuffers::Allocator + 'b>(
            &self,
            _fbb: &mut flatbuffers::FlatBufferBuilder<'b, A>,
        ) -> flatbuffers::WIPOffset<CosmeticFilters<'b>> {
            let simple_class_rules = Some({
                let x = &self.simple_class_rules;
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let simple_id_rules = Some({
                let x = &self.simple_id_rules;
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let misc_generic_selectors = Some({
                let x = &self.misc_generic_selectors;
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let complex_class_rules_index = Some({
                let x = &self.complex_class_rules_index;
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let complex_class_rules_values = Some({
                let x = &self.complex_class_rules_values;
                let w: Vec<_> = x.iter().map(|t| t.pack(_fbb)).collect();
                _fbb.create_vector(&w)
            });
            let complex_id_rules_index = Some({
                let x = &self.complex_id_rules_index;
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let complex_id_rules_values = Some({
                let x = &self.complex_id_rules_values;
                let w: Vec<_> = x.iter().map(|t| t.pack(_fbb)).collect();
                _fbb.create_vector(&w)
            });
            let hostname_hide_index = Some({
                let x = &self.hostname_hide_index;
                _fbb.create_vector(x)
            });
            let hostname_hide_values = Some({
                let x = &self.hostname_hide_values;
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let hostname_inject_script_index = Some({
                let x = &self.hostname_inject_script_index;
                _fbb.create_vector(x)
            });
            let hostname_inject_script_values = Some({
                let x = &self.hostname_inject_script_values;
                let w: Vec<_> = x.iter().map(|s| _fbb.create_string(s)).collect();
                _fbb.create_vector(&w)
            });
            let hostname_index = Some({
                let x = &self.hostname_index;
                _fbb.create_vector(x)
            });
            let hostname_values = Some({
                let x = &self.hostname_values;
                let w: Vec<_> = x.iter().map(|t| t.pack(_fbb)).collect();
                _fbb.create_vector(&w)
            });
            CosmeticFilters::create(
                _fbb,
                &CosmeticFiltersArgs {
                    simple_class_rules,
                    simple_id_rules,
                    misc_generic_selectors,
                    complex_class_rules_index,
                    complex_class_rules_values,
                    complex_id_rules_index,
                    complex_id_rules_values,
                    hostname_hide_index,
                    hostname_hide_values,
                    hostname_inject_script_index,
                    hostname_inject_script_values,
                    hostname_index,
                    hostname_values,
                },
            )
        }
    }
    pub enum EngineOffset {}
    #[derive(Copy, Clone, PartialEq)]

    /// A root type containing a serialized Engine.
    pub struct Engine<'a> {
        pub _tab: flatbuffers::Table<'a>,
    }

    impl<'a> flatbuffers::Follow<'a> for Engine<'a> {
        type Inner = Engine<'a>;
        #[inline]
        unsafe fn follow(buf: &'a [u8], loc: usize) -> Self::Inner {
            Self {
                _tab: unsafe { flatbuffers::Table::new(buf, loc) },
            }
        }
    }

    impl<'a> Engine<'a> {
        pub const VT_NETWORK_RULES: flatbuffers::VOffsetT = 4;
        pub const VT_UNIQUE_DOMAINS_HASHES: flatbuffers::VOffsetT = 6;
        pub const VT_COSMETIC_FILTERS: flatbuffers::VOffsetT = 8;

        #[inline]
        pub unsafe fn init_from_table(table: flatbuffers::Table<'a>) -> Self {
            Engine { _tab: table }
        }
        #[allow(unused_mut)]
        pub fn create<
            'bldr: 'args,
            'args: 'mut_bldr,
            'mut_bldr,
            A: flatbuffers::Allocator + 'bldr,
        >(
            _fbb: &'mut_bldr mut flatbuffers::FlatBufferBuilder<'bldr, A>,
            args: &'args EngineArgs<'args>,
        ) -> flatbuffers::WIPOffset<Engine<'bldr>> {
            let mut builder = EngineBuilder::new(_fbb);
            if let Some(x) = args.cosmetic_filters {
                builder.add_cosmetic_filters(x);
            }
            if let Some(x) = args.unique_domains_hashes {
                builder.add_unique_domains_hashes(x);
            }
            if let Some(x) = args.network_rules {
                builder.add_network_rules(x);
            }
            builder.finish()
        }

        pub fn unpack(&self) -> EngineT {
            let network_rules = {
                let x = self.network_rules();
                x.iter().map(|t| t.unpack()).collect()
            };
            let unique_domains_hashes = {
                let x = self.unique_domains_hashes();
                x.into_iter().collect()
            };
            let cosmetic_filters = {
                let x = self.cosmetic_filters();
                Box::new(x.unpack())
            };
            EngineT {
                network_rules,
                unique_domains_hashes,
                cosmetic_filters,
            }
        }

        /// Contains several NetworkFilterList matching to different kinds of lists.
        /// The indexes are matching NetworkFilterListId.
        /// The size must be NetworkFilterListId::Size.
        #[inline]
        pub fn network_rules(
            &self,
        ) -> flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<NetworkFilterList<'a>>> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<
                        flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<NetworkFilterList>>,
                    >>(Engine::VT_NETWORK_RULES, None)
                    .unwrap()
            }
        }
        /// Contains hashes for opt_(not)_domains. See opt_domains for details.
        #[inline]
        pub fn unique_domains_hashes(&self) -> flatbuffers::Vector<'a, u64> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'a, u64>>>(
                        Engine::VT_UNIQUE_DOMAINS_HASHES,
                        None,
                    )
                    .unwrap()
            }
        }
        #[inline]
        pub fn cosmetic_filters(&self) -> CosmeticFilters<'a> {
            // Safety:
            // Created from valid Table for this object
            // which contains a valid value in this slot
            unsafe {
                self._tab
                    .get::<flatbuffers::ForwardsUOffset<CosmeticFilters>>(
                        Engine::VT_COSMETIC_FILTERS,
                        None,
                    )
                    .unwrap()
            }
        }
    }

    impl flatbuffers::Verifiable for Engine<'_> {
        #[inline]
        fn run_verifier(
            v: &mut flatbuffers::Verifier,
            pos: usize,
        ) -> Result<(), flatbuffers::InvalidFlatbuffer> {
            use self::flatbuffers::Verifiable;
            v.visit_table(pos)?
                .visit_field::<flatbuffers::ForwardsUOffset<
                    flatbuffers::Vector<'_, flatbuffers::ForwardsUOffset<NetworkFilterList>>,
                >>("network_rules", Self::VT_NETWORK_RULES, true)?
                .visit_field::<flatbuffers::ForwardsUOffset<flatbuffers::Vector<'_, u64>>>(
                    "unique_domains_hashes",
                    Self::VT_UNIQUE_DOMAINS_HASHES,
                    true,
                )?
                .visit_field::<flatbuffers::ForwardsUOffset<CosmeticFilters>>(
                    "cosmetic_filters",
                    Self::VT_COSMETIC_FILTERS,
                    true,
                )?
                .finish();
            Ok(())
        }
    }
    pub struct EngineArgs<'a> {
        pub network_rules: Option<
            flatbuffers::WIPOffset<
                flatbuffers::Vector<'a, flatbuffers::ForwardsUOffset<NetworkFilterList<'a>>>,
            >,
        >,
        pub unique_domains_hashes: Option<flatbuffers::WIPOffset<flatbuffers::Vector<'a, u64>>>,
        pub cosmetic_filters: Option<flatbuffers::WIPOffset<CosmeticFilters<'a>>>,
    }
    impl<'a> Default for EngineArgs<'a> {
        #[inline]
        fn default() -> Self {
            EngineArgs {
                network_rules: None,         // required field
                unique_domains_hashes: None, // required field
                cosmetic_filters: None,      // required field
            }
        }
    }

    pub struct EngineBuilder<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> {
        fbb_: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        start_: flatbuffers::WIPOffset<flatbuffers::TableUnfinishedWIPOffset>,
    }
    impl<'a: 'b, 'b, A: flatbuffers::Allocator + 'a> EngineBuilder<'a, 'b, A> {
        #[inline]
        pub fn add_network_rules(
            &mut self,
            network_rules: flatbuffers::WIPOffset<
                flatbuffers::Vector<'b, flatbuffers::ForwardsUOffset<NetworkFilterList<'b>>>,
            >,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                Engine::VT_NETWORK_RULES,
                network_rules,
            );
        }
        #[inline]
        pub fn add_unique_domains_hashes(
            &mut self,
            unique_domains_hashes: flatbuffers::WIPOffset<flatbuffers::Vector<'b, u64>>,
        ) {
            self.fbb_.push_slot_always::<flatbuffers::WIPOffset<_>>(
                Engine::VT_UNIQUE_DOMAINS_HASHES,
                unique_domains_hashes,
            );
        }
        #[inline]
        pub fn add_cosmetic_filters(
            &mut self,
            cosmetic_filters: flatbuffers::WIPOffset<CosmeticFilters<'b>>,
        ) {
            self.fbb_
                .push_slot_always::<flatbuffers::WIPOffset<CosmeticFilters>>(
                    Engine::VT_COSMETIC_FILTERS,
                    cosmetic_filters,
                );
        }
        #[inline]
        pub fn new(
            _fbb: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        ) -> EngineBuilder<'a, 'b, A> {
            let start = _fbb.start_table();
            EngineBuilder {
                fbb_: _fbb,
                start_: start,
            }
        }
        #[inline]
        pub fn finish(self) -> flatbuffers::WIPOffset<Engine<'a>> {
            let o = self.fbb_.end_table(self.start_);
            self.fbb_
                .required(o, Engine::VT_NETWORK_RULES, "network_rules");
            self.fbb_
                .required(o, Engine::VT_UNIQUE_DOMAINS_HASHES, "unique_domains_hashes");
            self.fbb_
                .required(o, Engine::VT_COSMETIC_FILTERS, "cosmetic_filters");
            flatbuffers::WIPOffset::new(o.value())
        }
    }

    impl core::fmt::Debug for Engine<'_> {
        fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
            let mut ds = f.debug_struct("Engine");
            ds.field("network_rules", &self.network_rules());
            ds.field("unique_domains_hashes", &self.unique_domains_hashes());
            ds.field("cosmetic_filters", &self.cosmetic_filters());
            ds.finish()
        }
    }
    #[non_exhaustive]
    #[derive(Debug, Clone, PartialEq)]
    pub struct EngineT {
        pub network_rules: Vec<NetworkFilterListT>,
        pub unique_domains_hashes: Vec<u64>,
        pub cosmetic_filters: Box<CosmeticFiltersT>,
    }
    impl Default for EngineT {
        fn default() -> Self {
            Self {
                network_rules: Default::default(),
                unique_domains_hashes: Default::default(),
                cosmetic_filters: Default::default(),
            }
        }
    }
    impl EngineT {
        pub fn pack<'b, A: flatbuffers::Allocator + 'b>(
            &self,
            _fbb: &mut flatbuffers::FlatBufferBuilder<'b, A>,
        ) -> flatbuffers::WIPOffset<Engine<'b>> {
            let network_rules = Some({
                let x = &self.network_rules;
                let w: Vec<_> = x.iter().map(|t| t.pack(_fbb)).collect();
                _fbb.create_vector(&w)
            });
            let unique_domains_hashes = Some({
                let x = &self.unique_domains_hashes;
                _fbb.create_vector(x)
            });
            let cosmetic_filters = Some({
                let x = &self.cosmetic_filters;
                x.pack(_fbb)
            });
            Engine::create(
                _fbb,
                &EngineArgs {
                    network_rules,
                    unique_domains_hashes,
                    cosmetic_filters,
                },
            )
        }
    }
    #[inline]
    /// Verifies that a buffer of bytes contains a `Engine`
    /// and returns it.
    /// Note that verification is still experimental and may not
    /// catch every error, or be maximally performant. For the
    /// previous, unchecked, behavior use
    /// `root_as_engine_unchecked`.
    pub fn root_as_engine(buf: &[u8]) -> Result<Engine, flatbuffers::InvalidFlatbuffer> {
        flatbuffers::root::<Engine>(buf)
    }
    #[inline]
    /// Verifies that a buffer of bytes contains a size prefixed
    /// `Engine` and returns it.
    /// Note that verification is still experimental and may not
    /// catch every error, or be maximally performant. For the
    /// previous, unchecked, behavior use
    /// `size_prefixed_root_as_engine_unchecked`.
    pub fn size_prefixed_root_as_engine(
        buf: &[u8],
    ) -> Result<Engine, flatbuffers::InvalidFlatbuffer> {
        flatbuffers::size_prefixed_root::<Engine>(buf)
    }
    #[inline]
    /// Verifies, with the given options, that a buffer of bytes
    /// contains a `Engine` and returns it.
    /// Note that verification is still experimental and may not
    /// catch every error, or be maximally performant. For the
    /// previous, unchecked, behavior use
    /// `root_as_engine_unchecked`.
    pub fn root_as_engine_with_opts<'b, 'o>(
        opts: &'o flatbuffers::VerifierOptions,
        buf: &'b [u8],
    ) -> Result<Engine<'b>, flatbuffers::InvalidFlatbuffer> {
        flatbuffers::root_with_opts::<Engine<'b>>(opts, buf)
    }
    #[inline]
    /// Verifies, with the given verifier options, that a buffer of
    /// bytes contains a size prefixed `Engine` and returns
    /// it. Note that verification is still experimental and may not
    /// catch every error, or be maximally performant. For the
    /// previous, unchecked, behavior use
    /// `root_as_engine_unchecked`.
    pub fn size_prefixed_root_as_engine_with_opts<'b, 'o>(
        opts: &'o flatbuffers::VerifierOptions,
        buf: &'b [u8],
    ) -> Result<Engine<'b>, flatbuffers::InvalidFlatbuffer> {
        flatbuffers::size_prefixed_root_with_opts::<Engine<'b>>(opts, buf)
    }
    #[inline]
    /// Assumes, without verification, that a buffer of bytes contains a Engine and returns it.
    /// # Safety
    /// Callers must trust the given bytes do indeed contain a valid `Engine`.
    pub unsafe fn root_as_engine_unchecked(buf: &[u8]) -> Engine {
        unsafe { flatbuffers::root_unchecked::<Engine>(buf) }
    }
    #[inline]
    /// Assumes, without verification, that a buffer of bytes contains a size prefixed Engine and returns it.
    /// # Safety
    /// Callers must trust the given bytes do indeed contain a valid size prefixed `Engine`.
    pub unsafe fn size_prefixed_root_as_engine_unchecked(buf: &[u8]) -> Engine {
        unsafe { flatbuffers::size_prefixed_root_unchecked::<Engine>(buf) }
    }
    #[inline]
    pub fn finish_engine_buffer<'a, 'b, A: flatbuffers::Allocator + 'a>(
        fbb: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        root: flatbuffers::WIPOffset<Engine<'a>>,
    ) {
        fbb.finish(root, None);
    }

    #[inline]
    pub fn finish_size_prefixed_engine_buffer<'a, 'b, A: flatbuffers::Allocator + 'a>(
        fbb: &'b mut flatbuffers::FlatBufferBuilder<'a, A>,
        root: flatbuffers::WIPOffset<Engine<'a>>,
    ) {
        fbb.finish_size_prefixed(root, None);
    }
} // pub mod fb
