/* gitg-dash-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-dash-view.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include "libgitg-ext.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <libgit2-glib/ggit.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define GITG_DASH_VIEW_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_RECURSIVE_SCANNER (gitg_recursive_scanner_get_type ())
#define GITG_RECURSIVE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_RECURSIVE_SCANNER, GitgRecursiveScanner))
#define GITG_IS_RECURSIVE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_RECURSIVE_SCANNER))
#define GITG_RECURSIVE_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_RECURSIVE_SCANNER, GitgRecursiveScannerIface))

typedef struct _GitgRecursiveScanner GitgRecursiveScanner;
typedef struct _GitgRecursiveScannerIface GitgRecursiveScannerIface;

#define GITG_TYPE_DASH_VIEW (gitg_dash_view_get_type ())
#define GITG_DASH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DASH_VIEW, GitgDashView))
#define GITG_DASH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DASH_VIEW, GitgDashViewClass))
#define GITG_IS_DASH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DASH_VIEW))
#define GITG_IS_DASH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DASH_VIEW))
#define GITG_DASH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DASH_VIEW, GitgDashViewClass))

typedef struct _GitgDashView GitgDashView;
typedef struct _GitgDashViewClass GitgDashViewClass;
typedef struct _GitgDashViewPrivate GitgDashViewPrivate;
enum  {
	GITG_DASH_VIEW_0_PROPERTY,
	GITG_DASH_VIEW_APPLICATION_PROPERTY,
	GITG_DASH_VIEW_SELECTABLE_MODE_PROPERTY,
	GITG_DASH_VIEW_SELECTABLE_MODE_TOOLTIP_PROPERTY,
	GITG_DASH_VIEW_HAS_REPOSITORIES_PROPERTY,
	GITG_DASH_VIEW_SELECTABLE_AVAILABLE_PROPERTY,
	GITG_DASH_VIEW_SEARCH_AVAILABLE_PROPERTY,
	GITG_DASH_VIEW_DISPLAY_NAME_PROPERTY,
	GITG_DASH_VIEW_DESCRIPTION_PROPERTY,
	GITG_DASH_VIEW_ID_PROPERTY,
	GITG_DASH_VIEW_WIDGET_PROPERTY,
	GITG_DASH_VIEW_ICON_PROPERTY,
	GITG_DASH_VIEW_SEARCH_TEXT_PROPERTY,
	GITG_DASH_VIEW_SEARCH_ENTRY_PROPERTY,
	GITG_DASH_VIEW_SEARCH_VISIBLE_PROPERTY,
	GITG_DASH_VIEW_ACTION_WIDGET_PROPERTY,
	GITG_DASH_VIEW_NUM_PROPERTIES
};
static GParamSpec* gitg_dash_view_properties[GITG_DASH_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_TYPE_WINDOW (gitg_window_get_type ())
#define GITG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_WINDOW, GitgWindow))
#define GITG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_WINDOW, GitgWindowClass))
#define GITG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_WINDOW))
#define GITG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_WINDOW))
#define GITG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_WINDOW, GitgWindowClass))

typedef struct _GitgWindow GitgWindow;
typedef struct _GitgWindowClass GitgWindowClass;

#define GITG_TYPE_AUTHOR_DETAILS_DIALOG (gitg_author_details_dialog_get_type ())
#define GITG_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialog))
#define GITG_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))
#define GITG_IS_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_IS_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_AUTHOR_DETAILS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))

typedef struct _GitgAuthorDetailsDialog GitgAuthorDetailsDialog;
typedef struct _GitgAuthorDetailsDialogClass GitgAuthorDetailsDialogClass;
typedef struct _Block60Data Block60Data;
#define __vala_GgitFetchOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitFetchOptions_free (var), NULL)))

#define GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS (gitg_dash_view_clone_callbacks_get_type ())
#define GITG_DASH_VIEW_CLONE_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacks))
#define GITG_DASH_VIEW_CLONE_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacksClass))
#define GITG_DASH_VIEW_IS_CLONE_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS))
#define GITG_DASH_VIEW_IS_CLONE_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS))
#define GITG_DASH_VIEW_CLONE_CALLBACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacksClass))

typedef struct _GitgDashViewCloneCallbacks GitgDashViewCloneCallbacks;
typedef struct _GitgDashViewCloneCallbacksClass GitgDashViewCloneCallbacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgDashViewCloneData GitgDashViewCloneData;
typedef struct _Block61Data Block61Data;
typedef struct _Block62Data Block62Data;
typedef struct _GitgDashViewFileExistsAsyncData GitgDashViewFileExistsAsyncData;
typedef struct _GitgDashViewScanVisitDirectoryData GitgDashViewScanVisitDirectoryData;
typedef struct _Block63Data Block63Data;
typedef struct _GitgDashViewCloneCallbacksPrivate GitgDashViewCloneCallbacksPrivate;
enum  {
	GITG_DASH_VIEW_CLONE_CALLBACKS_0_PROPERTY,
	GITG_DASH_VIEW_CLONE_CALLBACKS_NUM_PROPERTIES
};
static GParamSpec* gitg_dash_view_clone_callbacks_properties[GITG_DASH_VIEW_CLONE_CALLBACKS_NUM_PROPERTIES];
#define _gitg_credentials_manager_unref0(var) ((var == NULL) ? NULL : (var = (gitg_credentials_manager_unref (var), NULL)))
typedef struct _Block64Data Block64Data;
typedef struct _Block65Data Block65Data;
#define _gitg_when_mapped_unref0(var) ((var == NULL) ? NULL : (var = (gitg_when_mapped_unref (var), NULL)))

struct _GitgRecursiveScannerIface {
	GTypeInterface parent_iface;
	void (*scan_visit_file) (GitgRecursiveScanner* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*scan_visit_file_finish) (GitgRecursiveScanner* self, GAsyncResult* _res_);
	void (*scan_visit_directory) (GitgRecursiveScanner* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*scan_visit_directory_finish) (GitgRecursiveScanner* self, GAsyncResult* _res_);
};

struct _GitgDashView {
	GtkGrid parent_instance;
	GitgDashViewPrivate * priv;
};

struct _GitgDashViewClass {
	GtkGridClass parent_class;
};

struct _GitgDashViewPrivate {
	GitgExtApplication* _application;
	gboolean d_setting_mode;
	GtkGrid* d_introduction;
	GtkLabel* d_label_scan;
	GtkLabel* d_label_profile;
	GtkScrolledWindow* d_scrolled_window;
	GitgRepositoryListBox* d_repository_list_box;
	gchar* d_search_text;
	gboolean _search_visible;
};

struct _Block60Data {
	int _ref_count_;
	GitgDashView* self;
	GitgRepository* repository;
	GitgRepositoryListBoxRow* row;
	gchar* url;
	GFile* location;
	gboolean is_bare;
	gpointer _async_data_;
};

struct _GitgDashViewCloneData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgDashView* self;
	GitgRepositoryListBoxRow* row;
	gchar* url;
	GFile* location;
	gboolean is_bare;
	GitgRepository* result;
	Block60Data* _data60_;
	GitgRepository* _tmp0_;
	GError* _inner_error0_;
};

struct _Block61Data {
	int _ref_count_;
	GitgDashView* self;
	GitgRepositoryListBoxRow* row;
};

struct _Block62Data {
	int _ref_count_;
	GitgDashView* self;
	GFile* location;
};

struct _GitgDashViewFileExistsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgDashView* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GError* _inner_error0_;
};

struct _GitgDashViewScanVisitDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgDashView* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gboolean _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
};

struct _Block63Data {
	int _ref_count_;
	GitgDashView* self;
	GtkMessageDialog* dlg;
	GCancellable* cancellable;
	guint timeout_id;
};

struct _GitgDashViewCloneCallbacks {
	GgitRemoteCallbacks parent_instance;
	GitgDashViewCloneCallbacksPrivate * priv;
};

struct _GitgDashViewCloneCallbacksClass {
	GgitRemoteCallbacksClass parent_class;
};

struct _GitgDashViewCloneCallbacksPrivate {
	GitgRepositoryListBoxRow* d_row;
	GitgCredentialsManager* d_credentials;
};

struct _Block64Data {
	int _ref_count_;
	GitgDashViewCloneCallbacks* self;
	guint recvobj;
	guint indxobj;
	guint totaobj;
};

struct _Block65Data {
	int _ref_count_;
	GitgDashView* self;
	GitgWhenMapped* whenMapped;
};

static gint GitgDashView_private_offset;
static gpointer gitg_dash_view_parent_class = NULL;
static gint GitgDashViewCloneCallbacks_private_offset;
static gpointer gitg_dash_view_clone_callbacks_parent_class = NULL;
static GitgExtUIElementIface * gitg_dash_view_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActivityIface * gitg_dash_view_gitg_ext_activity_parent_iface = NULL;
static GitgExtSelectableIface * gitg_dash_view_gitg_ext_selectable_parent_iface = NULL;
static GitgExtSearchableIface * gitg_dash_view_gitg_ext_searchable_parent_iface = NULL;
static GitgRecursiveScannerIface * gitg_dash_view_gitg_recursive_scanner_parent_iface = NULL;

VALA_EXTERN GType gitg_recursive_scanner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgRecursiveScanner, g_object_unref)
VALA_EXTERN GType gitg_dash_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgDashView, g_object_unref)
static void gitg_dash_view_update_search_text (GitgDashView* self);
static void gitg_dash_view_update_setup_profile_visibility (GitgDashView* self);
static gboolean gitg_dash_view_scan_home_activated (GitgDashView* self);
static void gitg_dash_view_add_repositories_scan (GitgDashView* self,
                                           GFile* location);
static gboolean _gitg_dash_view_scan_home_activated_gtk_label_activate_link (GtkLabel* _sender,
                                                                      const gchar* uri,
                                                                      gpointer self);
static gboolean gitg_dash_view_setup_profile_activated (GitgDashView* self);
VALA_EXTERN GType gitg_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgWindow, g_object_unref)
VALA_EXTERN GType gitg_author_details_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgAuthorDetailsDialog, g_object_unref)
VALA_EXTERN GitgAuthorDetailsDialog* gitg_author_details_dialog_show_global (GitgWindow* window);
static gboolean _gitg_dash_view_setup_profile_activated_gtk_label_activate_link (GtkLabel* _sender,
                                                                          const gchar* uri,
                                                                          gpointer self);
static void gitg_dash_view_update_availability (GitgDashView* self);
VALA_EXTERN GitgRepositoryListBoxRow* gitg_dash_view_add_repository (GitgDashView* self,
                                                         GitgRepository* repository);
static void gitg_dash_view_clone_data_free (gpointer _data);
static void gitg_dash_view_clone (GitgDashView* self,
                           GitgRepositoryListBoxRow* row,
                           const gchar* url,
                           GFile* location,
                           gboolean is_bare,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
static GitgRepository* gitg_dash_view_clone_finish (GitgDashView* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static gboolean gitg_dash_view_clone_co (GitgDashViewCloneData* _data_);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static void __lambda160_ (Block60Data* _data60_,
                   GError** error);
static void _vala_GgitFetchOptions_free (GgitFetchOptions* self);
static GitgDashViewCloneCallbacks* gitg_dash_view_clone_callbacks_new (GitgExtApplication* application,
                                                                GgitConfig* config,
                                                                GitgRepositoryListBoxRow* row);
static GitgDashViewCloneCallbacks* gitg_dash_view_clone_callbacks_construct (GType object_type,
                                                                      GitgExtApplication* application,
                                                                      GgitConfig* config,
                                                                      GitgRepositoryListBoxRow* row);
static GType gitg_dash_view_clone_callbacks_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgDashViewCloneCallbacks, g_object_unref)
static gint __lambda162_ (GitgDashView* self,
                   GgitSubmodule* submodule,
                   const gchar* name);
static gint ___lambda162__ggit_submodule_callback (GgitSubmodule* submodule,
                                            const gchar* name,
                                            gpointer self);
static void ___lambda160__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_dash_view_clone_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
VALA_EXTERN void gitg_dash_view_clone_repository (GitgDashView* self,
                                      const gchar* url,
                                      GFile* location,
                                      gboolean is_bare);
static Block61Data* block61_data_ref (Block61Data* _data61_);
static void block61_data_unref (void * _userdata_);
static void __lambda163_ (Block61Data* _data61_,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda163__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void gitg_dash_view_finish_add_repository (GitgDashView* self,
                                           GitgRepository* repo);
static void gitg_dash_view_do_add_repository (GitgDashView* self,
                                       GFile* location,
                                       gboolean report_errors);
static void gitg_dash_view_query_create_repository (GitgDashView* self,
                                             GFile* location);
static Block62Data* block62_data_ref (Block62Data* _data62_);
static void block62_data_unref (void * _userdata_);
static gboolean __lambda164_ (Block62Data* _data62_,
                       GitgExtUserQuery* w,
                       GtkResponseType r);
static gboolean ___lambda164__gitg_ext_user_query_response (GitgExtUserQuery* _sender,
                                                     GtkResponseType response_type,
                                                     gpointer self);
static gboolean gitg_dash_view_looks_like_git (GitgDashView* self,
                                        GFile* location);
static void gitg_dash_view_file_exists_async_data_free (gpointer _data);
static void gitg_dash_view_file_exists_async (GitgDashView* self,
                                       GFile* file,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean gitg_dash_view_file_exists_finish (GitgDashView* self,
                                            GAsyncResult* _res_);
static gboolean gitg_dash_view_file_exists_async_co (GitgDashViewFileExistsAsyncData* _data_);
static void gitg_dash_view_file_exists_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void gitg_dash_view_real_scan_visit_directory_data_free (gpointer _data);
static void gitg_dash_view_real_scan_visit_directory (GitgRecursiveScanner* base,
                                               GFile* file,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean gitg_dash_view_real_scan_visit_directory_co (GitgDashViewScanVisitDirectoryData* _data_);
static void gitg_dash_view_scan_visit_directory_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN gboolean gitg_recursive_scanner_scan_visit_directory_default (GitgRecursiveScanner* self,
                                                              GFile* file);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static void __lambda156_ (Block63Data* _data63_);
static void ___lambda156__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static gboolean __lambda157_ (Block63Data* _data63_);
static gboolean ___lambda157__gsource_func (gpointer self);
VALA_EXTERN void gitg_recursive_scanner_scan (GitgRecursiveScanner* self,
                                  GFile* location,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void gitg_recursive_scanner_scan_finish (GitgRecursiveScanner* self,
                                         GAsyncResult* _res_);
static void __lambda158_ (Block63Data* _data63_);
static void ___lambda158__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN void gitg_dash_view_add_repository_from_location (GitgDashView* self,
                                                  GFile* location,
                                                  gboolean scan_all);
VALA_EXTERN GitgDashView* gitg_dash_view_new (void);
VALA_EXTERN GitgDashView* gitg_dash_view_construct (GType object_type);
VALA_EXTERN gboolean gitg_dash_view_get_has_repositories (GitgDashView* self);
static void _gitg_dash_view_action_widget___lambda165_ (GitgDashView* self);
static void __gitg_dash_view_action_widget___lambda165__gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _gitg_dash_view_action_widget___lambda166_ (GitgDashView* self);
static void __gitg_dash_view_action_widget___lambda166__gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void gitg_dash_view_clone_callbacks_real_transfer_progress (GgitRemoteCallbacks* base,
                                                            GgitTransferProgress* stats);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
static gboolean __lambda161_ (Block64Data* _data64_);
static gboolean ___lambda161__gsource_func (gpointer self);
static GgitCred* gitg_dash_view_clone_callbacks_real_credentials (GgitRemoteCallbacks* base,
                                                           const gchar* url,
                                                           const gchar* username_from_url,
                                                           GgitCredtype allowed_types,
                                                           GError** error);
static void gitg_dash_view_clone_callbacks_finalize (GObject * obj);
static GType gitg_dash_view_clone_callbacks_get_type_once (void);
static GObject * gitg_dash_view_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static void _gitg_dash_view___lambda167_ (GitgDashView* self);
static void __gitg_dash_view___lambda167__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void _gitg_dash_view___lambda168_ (GitgDashView* self,
                                   GitgRepository* repository);
static void __gitg_dash_view___lambda168__gitg_repository_list_box_repository_activated (GitgRepositoryListBox* _sender,
                                                                                  GitgRepository* repository,
                                                                                  gpointer self);
static void _gitg_dash_view___lambda169_ (GitgDashView* self,
                                   const gchar* primary_message,
                                   const gchar* secondary_message);
static void __gitg_dash_view___lambda169__gitg_repository_list_box_show_error (GitgRepositoryListBox* _sender,
                                                                        const gchar* primary_message,
                                                                        const gchar* secondary_message,
                                                                        gpointer self);
static void _gitg_dash_view_update_availability_gtk_container_add (GtkContainer* _sender,
                                                            GtkWidget* widget,
                                                            gpointer self);
static void _gitg_dash_view_update_availability_gtk_container_remove (GtkContainer* _sender,
                                                               GtkWidget* widget,
                                                               gpointer self);
static void _gitg_dash_view___lambda170_ (Block65Data* _data65_);
VALA_EXTERN gchar* gitg_dirs_get_user_data_dir (void);
static void __gitg_dash_view___lambda170__gitg_when_mapped_on_mapped (gpointer self);
VALA_EXTERN void gitg_recursive_scanner_scan_visit_directory (GitgRecursiveScanner* self,
                                                  GFile* file,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN gboolean gitg_recursive_scanner_scan_visit_directory_finish (GitgRecursiveScanner* self,
                                                             GAsyncResult* _res_);
static void gitg_dash_view_finalize (GObject * obj);
static GType gitg_dash_view_get_type_once (void);
static void _vala_gitg_dash_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_gitg_dash_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_dash_view_get_instance_private (GitgDashView* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDashView_private_offset);
}

static void
gitg_dash_view_update_search_text (GitgDashView* self)
{
	GitgRepositoryListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_repository_list_box;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->d_search_text;
		if (g_strcmp0 (_tmp1_, "") != 0) {
			GitgRepositoryListBox* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = self->priv->d_repository_list_box;
			_tmp3_ = self->priv->d_search_text;
			gitg_repository_list_box_filter_text (_tmp2_, _tmp3_);
		} else {
			GitgRepositoryListBox* _tmp4_;
			_tmp4_ = self->priv->d_repository_list_box;
			gitg_repository_list_box_filter_text (_tmp4_, NULL);
		}
	}
}

static void
gitg_dash_view_update_setup_profile_visibility (GitgDashView* self)
{
	GtkLabel* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GgitConfig* _tmp0_ = NULL;
		GgitConfig* _tmp1_;
		GgitConfig* config = NULL;
		GgitConfig* _tmp2_;
		gchar* author_name = NULL;
		GgitConfig* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* author_email = NULL;
		GgitConfig* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp1_ = ggit_config_new_default (&_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = ggit_config_snapshot (_tmp0_, &_inner_error0_);
		config = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp3_ = config;
		_tmp4_ = ggit_config_get_string (_tmp3_, "user.name", &_inner_error0_);
		_tmp5_ = g_strdup (_tmp4_);
		author_name = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp6_ = config;
		_tmp7_ = ggit_config_get_string (_tmp6_, "user.email", &_inner_error0_);
		_tmp8_ = g_strdup (_tmp7_);
		author_email = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (author_name);
			_g_object_unref0 (config);
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp10_ = author_name;
		if (g_strcmp0 (_tmp10_, "") != 0) {
			const gchar* _tmp11_;
			_tmp11_ = author_email;
			_tmp9_ = g_strcmp0 (_tmp11_, "") != 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkLabel* _tmp12_;
			_tmp12_ = self->priv->d_label_profile;
			gtk_widget_set_visible ((GtkWidget*) _tmp12_, FALSE);
			_g_free0 (author_email);
			_g_free0 (author_name);
			_g_object_unref0 (config);
			_g_object_unref0 (_tmp0_);
			return;
		}
		_g_free0 (author_email);
		_g_free0 (author_name);
		_g_object_unref0 (config);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp13_ = self->priv->d_label_profile;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
}

static gboolean
gitg_dash_view_scan_home_activated (GitgDashView* self)
{
	gchar* homedir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	homedir = _tmp1_;
	_tmp2_ = homedir;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp3_ = homedir;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_tmp5_ = _tmp4_;
		gitg_dash_view_add_repositories_scan (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	result = TRUE;
	_g_free0 (homedir);
	return result;
}

static gboolean
_gitg_dash_view_scan_home_activated_gtk_label_activate_link (GtkLabel* _sender,
                                                             const gchar* uri,
                                                             gpointer self)
{
	gboolean result;
	result = gitg_dash_view_scan_home_activated ((GitgDashView*) self);
	return result;
}

static gboolean
gitg_dash_view_setup_profile_activated (GitgDashView* self)
{
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgWindow* _tmp2_;
	GitgWindow* _tmp3_;
	GitgAuthorDetailsDialog* _tmp4_;
	GitgAuthorDetailsDialog* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = GITG_IS_WINDOW (_tmp1_) ? ((GitgWindow*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	_tmp3_ = _tmp2_;
	_tmp4_ = gitg_author_details_dialog_show_global (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = TRUE;
	return result;
}

static gboolean
_gitg_dash_view_setup_profile_activated_gtk_label_activate_link (GtkLabel* _sender,
                                                                 const gchar* uri,
                                                                 gpointer self)
{
	gboolean result;
	result = gitg_dash_view_setup_profile_activated ((GitgDashView*) self);
	return result;
}

static void
gitg_dash_view_update_availability (GitgDashView* self)
{
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject*) self, "has-repositories");
	g_object_notify ((GObject*) self, "selectable-available");
	g_object_notify ((GObject*) self, "search-available");
}

GitgRepositoryListBoxRow*
gitg_dash_view_add_repository (GitgDashView* self,
                               GitgRepository* repository)
{
	GitgRepositoryListBox* _tmp0_;
	GitgRepositoryListBoxRow* _tmp1_;
	GitgRepositoryListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (repository != NULL, NULL);
	_tmp0_ = self->priv->d_repository_list_box;
	_tmp1_ = gitg_repository_list_box_add_repository (_tmp0_, repository, NULL);
	result = _tmp1_;
	return result;
}

static void
gitg_dash_view_clone_data_free (gpointer _data)
{
	GitgDashViewCloneData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgDashViewCloneData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_dash_view_clone (GitgDashView* self,
                      GitgRepositoryListBoxRow* row,
                      const gchar* url,
                      GFile* location,
                      gboolean is_bare,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	GitgDashViewCloneData* _data_;
	GitgDashView* _tmp0_;
	GitgRepositoryListBoxRow* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	g_return_if_fail (url != NULL);
	g_return_if_fail (location != NULL);
	_data_ = g_slice_new0 (GitgDashViewCloneData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_dash_view_clone_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (row);
	_g_object_unref0 (_data_->row);
	_data_->row = _tmp1_;
	_tmp2_ = g_strdup (url);
	_g_free0 (_data_->url);
	_data_->url = _tmp2_;
	_tmp3_ = _g_object_ref0 (location);
	_g_object_unref0 (_data_->location);
	_data_->location = _tmp3_;
	_data_->is_bare = is_bare;
	gitg_dash_view_clone_co (_data_);
}

static GitgRepository*
gitg_dash_view_clone_finish (GitgDashView* self,
                             GAsyncResult* _res_,
                             GError** error)
{
	GitgRepository* result;
	GitgDashViewCloneData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block60Data*
block60_data_ref (Block60Data* _data60_)
{
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}

static void
block60_data_unref (void * _userdata_)
{
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		GitgDashView* self;
		self = _data60_->self;
		_g_object_unref0 (_data60_->repository);
		_g_object_unref0 (_data60_->row);
		_g_free0 (_data60_->url);
		_g_object_unref0 (_data60_->location);
		_g_object_unref0 (self);
		g_slice_free (Block60Data, _data60_);
	}
}

static void
_vala_GgitFetchOptions_free (GgitFetchOptions* self)
{
	g_boxed_free (ggit_fetch_options_get_type (), self);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gint
__lambda162_ (GitgDashView* self,
              GgitSubmodule* submodule,
              const gchar* name)
{
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (submodule != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	{
		ggit_submodule_update (submodule, TRUE, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = string_to_string (name);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("ERROR: failed to update submodule ", _tmp1_, ": ", _tmp4_, "\n", NULL);
		_tmp6_ = _tmp5_;
		fprintf (_tmp0_, "%s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = 0;
	return result;
}

static gint
___lambda162__ggit_submodule_callback (GgitSubmodule* submodule,
                                       const gchar* name,
                                       gpointer self)
{
	gint result;
	result = __lambda162_ ((GitgDashView*) self, submodule, name);
	return result;
}

static void
__lambda160_ (Block60Data* _data60_,
              GError** error)
{
	GitgDashView* self;
	GgitCloneOptions* clone_options = NULL;
	GgitCloneOptions* _tmp0_;
	GgitFetchOptions* fetch_options = NULL;
	GgitFetchOptions* _tmp1_;
	GgitConfig* config = NULL;
	GitgExtApplication* _tmp5_;
	GitgExtApplication* _tmp6_;
	GitgExtApplication* _tmp7_;
	GgitConfig* _tmp8_;
	GitgDashViewCloneCallbacks* _tmp9_;
	GitgDashViewCloneCallbacks* _tmp10_;
	GgitRepository* _tmp11_ = NULL;
	GgitRepository* _tmp12_;
	GitgRepository* _tmp13_;
	GError* _inner_error0_ = NULL;
	self = _data60_->self;
	_tmp0_ = ggit_clone_options_new ();
	clone_options = _tmp0_;
	_tmp1_ = ggit_fetch_options_new ();
	fetch_options = _tmp1_;
	config = NULL;
	{
		GgitConfig* _tmp2_ = NULL;
		GgitConfig* _tmp3_;
		GgitConfig* _tmp4_;
		_tmp3_ = ggit_config_new_default (&_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (config);
		config = _tmp4_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		__vala_GgitFetchOptions_free0 (fetch_options);
		_g_object_unref0 (clone_options);
		return;
	}
	_tmp5_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = config;
	_tmp9_ = gitg_dash_view_clone_callbacks_new (_tmp7_, _tmp8_, _data60_->row);
	_tmp10_ = _tmp9_;
	ggit_fetch_options_set_remote_callbacks (fetch_options, (GgitRemoteCallbacks*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_tmp7_);
	ggit_clone_options_set_is_bare (clone_options, _data60_->is_bare);
	ggit_clone_options_set_fetch_options (clone_options, fetch_options);
	_tmp12_ = ggit_repository_clone (_data60_->url, _data60_->location, clone_options, &_inner_error0_);
	_tmp11_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		__vala_GgitFetchOptions_free0 (fetch_options);
		_g_object_unref0 (clone_options);
		return;
	}
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GITG_TYPE_REPOSITORY, GitgRepository));
	_g_object_unref0 (_data60_->repository);
	_data60_->repository = _tmp13_;
	ggit_repository_submodule_foreach ((GgitRepository*) _data60_->repository, ___lambda162__ggit_submodule_callback, self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (config);
		__vala_GgitFetchOptions_free0 (fetch_options);
		_g_object_unref0 (clone_options);
		return;
	}
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (config);
	__vala_GgitFetchOptions_free0 (fetch_options);
	_g_object_unref0 (clone_options);
}

static void
___lambda160__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	__lambda160_ (self, error);
}

static void
gitg_dash_view_clone_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	GitgDashViewCloneData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_dash_view_clone_co (_data_);
}

static gboolean
gitg_dash_view_clone_co (GitgDashViewCloneData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data60_ = g_slice_new0 (Block60Data);
	_data_->_data60_->_ref_count_ = 1;
	_data_->_data60_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data60_->row);
	_data_->_data60_->row = _data_->row;
	_g_free0 (_data_->_data60_->url);
	_data_->_data60_->url = _data_->url;
	_g_object_unref0 (_data_->_data60_->location);
	_data_->_data60_->location = _data_->location;
	_data_->_data60_->is_bare = _data_->is_bare;
	_data_->_data60_->_async_data_ = _data_;
	_data_->_data60_->repository = NULL;
	_data_->_state_ = 1;
	gitg_async_thread (___lambda160__gitg_async_thread_func, _data_->_data60_, gitg_dash_view_clone_ready, _data_);
	return FALSE;
	_state_1:
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block60_data_unref (_data_->_data60_);
		_data_->_data60_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _g_object_ref0 (_data_->_data60_->repository);
	_data_->result = _data_->_tmp0_;
	block60_data_unref (_data_->_data60_);
	_data_->_data60_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block61Data*
block61_data_ref (Block61Data* _data61_)
{
	g_atomic_int_inc (&_data61_->_ref_count_);
	return _data61_;
}

static void
block61_data_unref (void * _userdata_)
{
	Block61Data* _data61_;
	_data61_ = (Block61Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data61_->_ref_count_)) {
		GitgDashView* self;
		self = _data61_->self;
		_g_object_unref0 (_data61_->row);
		_g_object_unref0 (self);
		g_slice_free (Block61Data, _data61_);
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
__lambda163_ (Block61Data* _data61_,
              GObject* obj,
              GAsyncResult* res)
{
	GitgDashView* self;
	GitgRepository* repository = NULL;
	GitgRepositoryListBox* _tmp8_;
	GitgRepository* _tmp9_;
	GError* _inner_error0_ = NULL;
	self = _data61_->self;
	g_return_if_fail (res != NULL);
	repository = NULL;
	{
		GitgRepository* _tmp0_ = NULL;
		GitgRepository* _tmp1_;
		GitgRepository* _tmp2_;
		_tmp1_ = gitg_dash_view_clone_finish (self, res, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (repository);
		repository = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GitgExtApplication* _tmp3_;
		GitgExtApplication* _tmp4_;
		GitgExtApplication* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		gitg_ext_application_show_infobar (_tmp5_, _ ("Failed to clone repository"), _tmp7_, GTK_MESSAGE_ERROR);
		_g_object_unref0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (repository);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = self->priv->d_repository_list_box;
	_tmp9_ = repository;
	gitg_repository_list_box_end_cloning (_tmp8_, _data61_->row, _tmp9_);
	_g_object_unref0 (repository);
}

static void
___lambda163__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda163_ (self, source_object, res);
	block61_data_unref (self);
}

void
gitg_dash_view_clone_repository (GitgDashView* self,
                                 const gchar* url,
                                 GFile* location,
                                 gboolean is_bare)
{
	Block61Data* _data61_;
	gint pos = 0;
	gchar* dot_git_suffix = NULL;
	gchar* _tmp0_;
	gchar* subfolder_name = NULL;
	gchar* _tmp1_;
	gboolean has_dot_git = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GFile* subfolder = NULL;
	const gchar* _tmp14_;
	GFile* _tmp15_;
	GitgRepositoryListBox* _tmp16_;
	GitgRepositoryListBoxRow* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	g_return_if_fail (location != NULL);
	_data61_ = g_slice_new0 (Block61Data);
	_data61_->_ref_count_ = 1;
	_data61_->self = g_object_ref (self);
	pos = string_last_index_of_char (url, (gunichar) '/', 0);
	if (pos == -1) {
		pos = string_last_index_of_char (url, (gunichar) ':', 0);
	}
	_tmp0_ = g_strdup (".git");
	dot_git_suffix = _tmp0_;
	_tmp1_ = string_substring (url, (glong) (pos + 1), (glong) -1);
	subfolder_name = _tmp1_;
	_tmp2_ = subfolder_name;
	_tmp3_ = dot_git_suffix;
	has_dot_git = g_str_has_suffix (_tmp2_, _tmp3_);
	if (has_dot_git) {
		_tmp4_ = !is_bare;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = subfolder_name;
		_tmp6_ = dot_git_suffix;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_slice (_tmp5_, (glong) 0, (glong) (-_tmp8_));
		_g_free0 (subfolder_name);
		subfolder_name = _tmp9_;
	} else {
		gboolean _tmp10_ = FALSE;
		if (!has_dot_git) {
			_tmp10_ = is_bare;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = subfolder_name;
			_tmp12_ = dot_git_suffix;
			_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
			_g_free0 (subfolder_name);
			subfolder_name = _tmp13_;
		}
	}
	_tmp14_ = subfolder_name;
	_tmp15_ = g_file_resolve_relative_path (location, _tmp14_);
	subfolder = _tmp15_;
	_tmp16_ = self->priv->d_repository_list_box;
	_tmp17_ = gitg_repository_list_box_begin_cloning (_tmp16_, subfolder);
	_data61_->row = _tmp17_;
	gitg_dash_view_clone (self, _data61_->row, url, subfolder, is_bare, ___lambda163__gasync_ready_callback, block61_data_ref (_data61_));
	_g_object_unref0 (subfolder);
	_g_free0 (subfolder_name);
	_g_free0 (dot_git_suffix);
	block61_data_unref (_data61_);
	_data61_ = NULL;
}

static void
gitg_dash_view_finish_add_repository (GitgDashView* self,
                                      GitgRepository* repo)
{
	GitgRepositoryListBoxRow* row = NULL;
	GitgRepositoryListBoxRow* _tmp0_;
	GitgRepositoryListBoxRow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (repo != NULL);
	_tmp0_ = gitg_dash_view_add_repository (self, repo);
	row = _tmp0_;
	_tmp1_ = row;
	if (_tmp1_ != NULL) {
		GitgRepositoryListBoxRow* _tmp2_;
		GitgRepositoryListBox* _tmp3_;
		GitgRepositoryListBoxRow* _tmp4_;
		_tmp2_ = row;
		gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->d_repository_list_box;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
		_tmp4_ = row;
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	}
	_g_object_unref0 (row);
}

static void
gitg_dash_view_do_add_repository (GitgDashView* self,
                                  GFile* location,
                                  gboolean report_errors)
{
	GitgRepository* repo = NULL;
	GitgRepository* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	{
		GitgRepository* _tmp0_ = NULL;
		GitgRepository* _tmp1_;
		GitgRepository* _tmp2_;
		_tmp1_ = gitg_repository_new (location, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (repo);
		repo = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		if (report_errors) {
			GitgExtApplication* _tmp3_;
			GitgExtApplication* _tmp4_;
			GitgExtApplication* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
			_tmp3_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = err;
			_tmp7_ = _tmp6_->message;
			gitg_ext_application_show_infobar (_tmp5_, _ ("Failed to add repository"), _tmp7_, GTK_MESSAGE_ERROR);
			_g_object_unref0 (_tmp5_);
		}
		_g_error_free0 (err);
		_g_object_unref0 (repo);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (repo);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = repo;
	gitg_dash_view_finish_add_repository (self, _tmp8_);
	_g_object_unref0 (repo);
}

static Block62Data*
block62_data_ref (Block62Data* _data62_)
{
	g_atomic_int_inc (&_data62_->_ref_count_);
	return _data62_;
}

static void
block62_data_unref (void * _userdata_)
{
	Block62Data* _data62_;
	_data62_ = (Block62Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data62_->_ref_count_)) {
		GitgDashView* self;
		self = _data62_->self;
		_g_object_unref0 (_data62_->location);
		_g_object_unref0 (self);
		g_slice_free (Block62Data, _data62_);
	}
}

static gboolean
__lambda164_ (Block62Data* _data62_,
              GitgExtUserQuery* w,
              GtkResponseType r)
{
	GitgDashView* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data62_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	if (r == GTK_RESPONSE_OK) {
		GitgRepository* repo = NULL;
		GitgRepository* _tmp9_;
		{
			GitgRepository* _tmp0_ = NULL;
			GitgRepository* _tmp1_;
			GitgRepository* _tmp2_;
			_tmp1_ = gitg_repository_init_repository (_data62_->location, FALSE, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (repo);
			repo = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GitgExtApplication* _tmp3_;
			GitgExtApplication* _tmp4_;
			GitgExtApplication* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = err;
			_tmp7_ = _tmp6_->message;
			gitg_ext_application_show_infobar (_tmp5_, _ ("Failed to create repository"), _tmp7_, GTK_MESSAGE_ERROR);
			_g_object_unref0 (_tmp5_);
			result = TRUE;
			_g_error_free0 (err);
			_g_object_unref0 (repo);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp8_ = FALSE;
			_g_object_unref0 (repo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
		_tmp9_ = repo;
		gitg_dash_view_finish_add_repository (self, _tmp9_);
		_g_object_unref0 (repo);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda164__gitg_ext_user_query_response (GitgExtUserQuery* _sender,
                                            GtkResponseType response_type,
                                            gpointer self)
{
	gboolean result;
	result = __lambda164_ (self, _sender, response_type);
	return result;
}

static void
gitg_dash_view_query_create_repository (GitgDashView* self,
                                        GFile* location)
{
	Block62Data* _data62_;
	GFile* _tmp0_;
	GitgExtUserQuery* q = NULL;
	GitgExtUserQuery* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GitgExtUserQueryResponse* _tmp8_;
	GitgExtUserQueryResponse* _tmp9_;
	GitgExtUserQueryResponse** _tmp10_;
	GitgExtUserQueryResponse** _tmp11_;
	gint _tmp11__length1;
	GitgExtApplication* _tmp12_;
	GitgExtApplication* _tmp13_;
	GitgExtApplication* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_data62_ = g_slice_new0 (Block62Data);
	_data62_->_ref_count_ = 1;
	_data62_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (location);
	_g_object_unref0 (_data62_->location);
	_data62_->location = _tmp0_;
	_tmp1_ = gitg_ext_user_query_new ();
	q = _tmp1_;
	_tmp2_ = gitg_utils_replace_home_dir_with_tilde (_data62_->location);
	name = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) -1);
	_g_free0 (name);
	name = _tmp4_;
	gitg_ext_user_query_set_title (q, _ ("Create new repository"));
	_tmp5_ = name;
	_tmp6_ = g_strdup_printf (_ ("The location <i>%s</i> does not appear to be a valid git repository. W" \
"ould you like to initialize a new git repository at this location?"), _tmp5_);
	_tmp7_ = _tmp6_;
	gitg_ext_user_query_set_message (q, _tmp7_);
	_g_free0 (_tmp7_);
	gitg_ext_user_query_set_message_type (q, GTK_MESSAGE_QUESTION);
	gitg_ext_user_query_set_message_use_markup (q, TRUE);
	_tmp8_ = gitg_ext_user_query_response_new (_ ("_Cancel"), GTK_RESPONSE_CANCEL);
	_tmp9_ = gitg_ext_user_query_response_new (_ ("Create repository"), GTK_RESPONSE_OK);
	_tmp10_ = g_new0 (GitgExtUserQueryResponse*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	gitg_ext_user_query_set_responses (q, _tmp11_, (gint) 2);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_object_unref), NULL);
	gitg_ext_user_query_set_default_response (q, GTK_RESPONSE_OK);
	g_signal_connect_data (q, "response", (GCallback) ___lambda164__gitg_ext_user_query_response, block62_data_ref (_data62_), (GClosureNotify) block62_data_unref, 0);
	_tmp12_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	gitg_ext_application_user_query (_tmp14_, q);
	_g_object_unref0 (_tmp14_);
	_g_free0 (name);
	_g_object_unref0 (q);
	block62_data_unref (_data62_);
	_data62_ = NULL;
}

static gboolean
gitg_dash_view_looks_like_git (GitgDashView* self,
                               GFile* location)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = g_file_get_child (location, ".git");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = g_file_get_child (location, "objects");
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_query_exists (_tmp6_, NULL);
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		GFile* _tmp8_;
		GFile* _tmp9_;
		_tmp8_ = g_file_get_child (location, "HEAD");
		_tmp9_ = _tmp8_;
		_tmp4_ = g_file_query_exists (_tmp9_, NULL);
		_g_object_unref0 (_tmp9_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp10_ = g_file_get_child (location, "refs");
		_tmp11_ = _tmp10_;
		_tmp3_ = g_file_query_exists (_tmp11_, NULL);
		_g_object_unref0 (_tmp11_);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static void
gitg_dash_view_file_exists_async_data_free (gpointer _data)
{
	GitgDashViewFileExistsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgDashViewFileExistsAsyncData, _data_);
}

static void
gitg_dash_view_file_exists_async (GitgDashView* self,
                                  GFile* file,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	GitgDashViewFileExistsAsyncData* _data_;
	GitgDashView* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (GitgDashViewFileExistsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_dash_view_file_exists_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gitg_dash_view_file_exists_async_co (_data_);
}

static gboolean
gitg_dash_view_file_exists_finish (GitgDashView* self,
                                   GAsyncResult* _res_)
{
	gboolean result;
	GitgDashViewFileExistsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
gitg_dash_view_file_exists_async_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	GitgDashViewFileExistsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_dash_view_file_exists_async_co (_data_);
}

static gboolean
gitg_dash_view_file_exists_async_co (GitgDashViewFileExistsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->cancellable, gitg_dash_view_file_exists_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->result = _data_->_tmp0_ != NULL;
		_g_object_unref0 (_data_->_tmp0_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_dash_view_real_scan_visit_directory_data_free (gpointer _data)
{
	GitgDashViewScanVisitDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgDashViewScanVisitDirectoryData, _data_);
}

static void
gitg_dash_view_real_scan_visit_directory (GitgRecursiveScanner* base,
                                          GFile* file,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GitgDashView * self;
	GitgDashViewScanVisitDirectoryData* _data_;
	GitgDashView* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (file != NULL);
	self = (GitgDashView*) base;
	_data_ = g_slice_new0 (GitgDashViewScanVisitDirectoryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_dash_view_real_scan_visit_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gitg_dash_view_real_scan_visit_directory_co (_data_);
}

static gboolean
gitg_dash_view_scan_visit_directory_finish (GitgRecursiveScanner* base,
                                            GAsyncResult* _res_)
{
	gboolean result;
	GitgDashViewScanVisitDirectoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
gitg_dash_view_scan_visit_directory_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GitgDashViewScanVisitDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_dash_view_real_scan_visit_directory_co (_data_);
}

static gboolean
gitg_dash_view_real_scan_visit_directory_co (GitgDashViewScanVisitDirectoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->cancellable != NULL) {
		_data_->_tmp0_ = g_cancellable_is_cancelled (_data_->cancellable);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_file_get_child (_data_->file, ".git");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	gitg_dash_view_file_exists_async (_data_->self, _data_->_tmp2_, _data_->cancellable, gitg_dash_view_scan_visit_directory_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = gitg_dash_view_file_exists_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->_tmp2_);
	if (_data_->_tmp3_) {
		gitg_dash_view_do_add_repository (_data_->self, _data_->file, FALSE);
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = g_file_get_child (_data_->file, "objects");
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_state_ = 2;
	gitg_dash_view_file_exists_async (_data_->self, _data_->_tmp7_, _data_->cancellable, gitg_dash_view_scan_visit_directory_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp8_ = gitg_dash_view_file_exists_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->_tmp7_);
	if (_data_->_tmp8_) {
		_data_->_tmp9_ = g_file_get_child (_data_->file, "HEAD");
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_state_ = 3;
		gitg_dash_view_file_exists_async (_data_->self, _data_->_tmp10_, _data_->cancellable, gitg_dash_view_scan_visit_directory_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp5_ = gitg_dash_view_file_exists_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->_tmp10_);
	} else {
		_data_->_tmp5_ = FALSE;
	}
	if (_data_->_tmp5_) {
		_data_->_tmp11_ = g_file_get_child (_data_->file, "refs");
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_state_ = 4;
		gitg_dash_view_file_exists_async (_data_->self, _data_->_tmp12_, _data_->cancellable, gitg_dash_view_scan_visit_directory_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp4_ = gitg_dash_view_file_exists_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->_tmp12_);
	} else {
		_data_->_tmp4_ = FALSE;
	}
	if (_data_->_tmp4_) {
		gitg_dash_view_do_add_repository (_data_->self, _data_->file, FALSE);
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = gitg_recursive_scanner_scan_visit_directory_default ((GitgRecursiveScanner*) _data_->self, _data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		GitgDashView* self;
		self = _data63_->self;
		_g_object_unref0 (_data63_->cancellable);
		_g_object_unref0 (_data63_->dlg);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static void
__lambda156_ (Block63Data* _data63_)
{
	GitgDashView* self;
	self = _data63_->self;
	g_cancellable_cancel (_data63_->cancellable);
}

static void
___lambda156__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	__lambda156_ (self);
}

static gboolean
__lambda157_ (Block63Data* _data63_)
{
	GitgDashView* self;
	gboolean result;
	self = _data63_->self;
	if (_data63_->timeout_id == ((guint) 0)) {
		gtk_widget_destroy ((GtkWidget*) _data63_->dlg);
	}
	_data63_->timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
___lambda157__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda157_ (self);
	return result;
}

static void
__lambda158_ (Block63Data* _data63_)
{
	GitgDashView* self;
	self = _data63_->self;
	if (_data63_->timeout_id != ((guint) 0)) {
		_data63_->timeout_id = (guint) 0;
	} else {
		gtk_widget_destroy ((GtkWidget*) _data63_->dlg);
	}
}

static void
___lambda158__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda158_ (self);
	block63_data_unref (self);
}

static void
gitg_dash_view_add_repositories_scan (GitgDashView* self,
                                      GFile* location)
{
	Block63Data* _data63_;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkMessageDialog* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GCancellable* _tmp8_;
	GdkWindow* _tmp9_;
	GdkDisplay* _tmp10_;
	GdkCursor* _tmp11_;
	GdkCursor* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	_tmp3_ = _tmp2_;
	_tmp4_ = gitg_utils_replace_home_dir_with_tilde (location);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_CANCEL, _ ("Scanning for repositories in %s"), _tmp5_);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_data63_->dlg = _tmp7_;
	gtk_dialog_set_default_response ((GtkDialog*) _data63_->dlg, (gint) GTK_RESPONSE_CANCEL);
	_tmp8_ = g_cancellable_new ();
	_data63_->cancellable = _tmp8_;
	g_signal_connect_data ((GtkDialog*) _data63_->dlg, "response", (GCallback) ___lambda156__gtk_dialog_response, block63_data_ref (_data63_), (GClosureNotify) block63_data_unref, 0);
	_data63_->timeout_id = (guint) 0;
	_data63_->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda157__gsource_func, block63_data_ref (_data63_), block63_data_unref);
	gitg_recursive_scanner_scan ((GitgRecursiveScanner*) self, location, _data63_->cancellable, ___lambda158__gasync_ready_callback, block63_data_ref (_data63_));
	gtk_widget_show ((GtkWidget*) _data63_->dlg);
	_tmp9_ = gtk_widget_get_window ((GtkWidget*) _data63_->dlg);
	_tmp10_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp11_ = gdk_cursor_new_for_display (_tmp10_, GDK_WATCH);
	_tmp12_ = _tmp11_;
	gdk_window_set_cursor (_tmp9_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	block63_data_unref (_data63_);
	_data63_ = NULL;
}

void
gitg_dash_view_add_repository_from_location (GitgDashView* self,
                                             GFile* location,
                                             gboolean scan_all)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	if (scan_all) {
		gitg_dash_view_add_repositories_scan (self, location);
	} else {
		if (!gitg_dash_view_looks_like_git (self, location)) {
			gitg_dash_view_query_create_repository (self, location);
		} else {
			gitg_dash_view_do_add_repository (self, location, TRUE);
		}
	}
}

GitgDashView*
gitg_dash_view_construct (GType object_type)
{
	GitgDashView * self = NULL;
	self = (GitgDashView*) g_object_new (object_type, NULL);
	return self;
}

GitgDashView*
gitg_dash_view_new (void)
{
	return gitg_dash_view_construct (GITG_TYPE_DASH_VIEW);
}

static GitgExtApplication*
gitg_dash_view_real_get_application (GitgExtUIElement* base)
{
	GitgExtApplication* result;
	GitgDashView* self;
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	self = (GitgDashView*) base;
	_tmp0_ = self->priv->_application;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_dash_view_real_set_application (GitgExtUIElement* base,
                                     GitgExtApplication* value)
{
	GitgDashView* self;
	GitgExtApplication* old_value;
	self = (GitgDashView*) base;
	old_value = gitg_dash_view_real_get_application (base);
	if (old_value != value) {
		GitgExtApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_dash_view_properties[GITG_DASH_VIEW_APPLICATION_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static GitgExtSelectionMode
gitg_dash_view_real_get_selectable_mode (GitgExtSelectable* base)
{
	GitgExtSelectionMode result;
	GitgDashView* self;
	GitgRepositoryListBox* _tmp0_;
	GitgSelectionMode _tmp1_;
	GitgSelectionMode _tmp2_;
	self = (GitgDashView*) base;
	_tmp0_ = self->priv->d_repository_list_box;
	_tmp1_ = gitg_repository_list_box_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case GITG_SELECTION_MODE_NORMAL:
		{
			result = GITG_EXT_SELECTION_MODE_NORMAL;
			return result;
		}
		case GITG_SELECTION_MODE_SELECTION:
		{
			result = GITG_EXT_SELECTION_MODE_SELECTION;
			return result;
		}
		default:
		break;
	}
	result = GITG_EXT_SELECTION_MODE_NORMAL;
	return result;
}

static void
gitg_dash_view_real_set_selectable_mode (GitgExtSelectable* base,
                                         GitgExtSelectionMode value)
{
	GitgDashView* self;
	GitgExtSelectionMode _tmp0_;
	GitgExtSelectionMode _tmp1_;
	self = (GitgDashView*) base;
	_tmp0_ = gitg_ext_selectable_get_selectable_mode ((GitgExtSelectable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	self->priv->d_setting_mode = TRUE;
	switch (value) {
		case GITG_EXT_SELECTION_MODE_NORMAL:
		{
			GitgRepositoryListBox* _tmp2_;
			_tmp2_ = self->priv->d_repository_list_box;
			gitg_repository_list_box_set_mode (_tmp2_, GITG_SELECTION_MODE_NORMAL);
			break;
		}
		case GITG_EXT_SELECTION_MODE_SELECTION:
		{
			GitgRepositoryListBox* _tmp3_;
			_tmp3_ = self->priv->d_repository_list_box;
			gitg_repository_list_box_set_mode (_tmp3_, GITG_SELECTION_MODE_SELECTION);
			break;
		}
		default:
		break;
	}
	self->priv->d_setting_mode = FALSE;
	g_object_notify_by_pspec ((GObject *) self, gitg_dash_view_properties[GITG_DASH_VIEW_SELECTABLE_MODE_PROPERTY]);
}

static gchar*
gitg_dash_view_real_get_selectable_mode_tooltip (GitgExtSelectable* base)
{
	gchar* result;
	GitgDashView* self;
	gchar* _tmp0_;
	self = (GitgDashView*) base;
	_tmp0_ = g_strdup (_ ("Select and manage projects"));
	result = _tmp0_;
	return result;
}

gboolean
gitg_dash_view_get_has_repositories (GitgDashView* self)
{
	gboolean result;
	GitgRepositoryListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_repository_list_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_) != ((guint) 0);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	result = _tmp3_;
	return result;
}

static gboolean
gitg_dash_view_real_get_selectable_available (GitgExtSelectable* base)
{
	gboolean result;
	GitgDashView* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (GitgDashView*) base;
	_tmp0_ = gitg_dash_view_get_has_repositories (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

static gboolean
gitg_dash_view_real_get_search_available (GitgExtSearchable* base)
{
	gboolean result;
	GitgDashView* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (GitgDashView*) base;
	_tmp0_ = gitg_dash_view_get_has_repositories (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

static gchar*
gitg_dash_view_real_get_display_name (GitgExtUIElement* base)
{
	gchar* result;
	GitgDashView* self;
	gchar* _tmp0_;
	self = (GitgDashView*) base;
	_tmp0_ = g_strdup ("Dash");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_dash_view_real_get_description (GitgExtUIElement* base)
{
	gchar* result;
	GitgDashView* self;
	gchar* _tmp0_;
	self = (GitgDashView*) base;
	_tmp0_ = g_strdup ("Dash view");
	result = _tmp0_;
	return result;
}

static gchar*
gitg_dash_view_real_get_id (GitgExtUIElement* base)
{
	gchar* result;
	GitgDashView* self;
	gchar* _tmp0_;
	self = (GitgDashView*) base;
	_tmp0_ = g_strdup ("/org/gnome/gitg/dash");
	result = _tmp0_;
	return result;
}

static GtkWidget*
gitg_dash_view_real_get_widget (GitgExtUIElement* base)
{
	GtkWidget* result;
	GitgDashView* self;
	GtkWidget* _tmp0_;
	self = (GitgDashView*) base;
	_tmp0_ = _g_object_ref0 ((GtkWidget*) self);
	result = _tmp0_;
	return result;
}

static gchar*
gitg_dash_view_real_get_icon (GitgExtUIElement* base)
{
	gchar* result;
	GitgDashView* self;
	self = (GitgDashView*) base;
	result = NULL;
	return result;
}

static gchar*
gitg_dash_view_real_get_search_text (GitgExtSearchable* base)
{
	gchar* result;
	GitgDashView* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (GitgDashView*) base;
	_tmp0_ = self->priv->d_search_text;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_dash_view_real_set_search_text (GitgExtSearchable* base,
                                     const gchar* value)
{
	GitgDashView* self;
	const gchar* _tmp0_;
	self = (GitgDashView*) base;
	_tmp0_ = self->priv->d_search_text;
	if (g_strcmp0 (_tmp0_, value) != 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (value);
		_g_free0 (self->priv->d_search_text);
		self->priv->d_search_text = _tmp1_;
		gitg_dash_view_update_search_text (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_dash_view_properties[GITG_DASH_VIEW_SEARCH_TEXT_PROPERTY]);
}

static void
gitg_dash_view_real_set_search_entry (GitgExtSearchable* base,
                                      GtkEntry* value)
{
	GitgDashView* self;
	self = (GitgDashView*) base;
	g_object_notify_by_pspec ((GObject *) self, gitg_dash_view_properties[GITG_DASH_VIEW_SEARCH_ENTRY_PROPERTY]);
}

static gboolean
gitg_dash_view_real_get_search_visible (GitgExtSearchable* base)
{
	gboolean result;
	GitgDashView* self;
	self = (GitgDashView*) base;
	result = self->priv->_search_visible;
	return result;
}

static void
gitg_dash_view_real_set_search_visible (GitgExtSearchable* base,
                                        gboolean value)
{
	GitgDashView* self;
	gboolean old_value;
	self = (GitgDashView*) base;
	old_value = gitg_dash_view_real_get_search_visible (base);
	if (old_value != value) {
		self->priv->_search_visible = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_dash_view_properties[GITG_DASH_VIEW_SEARCH_VISIBLE_PROPERTY]);
	}
}

static void
_gitg_dash_view_action_widget___lambda165_ (GitgDashView* self)
{
	GitgRepositoryListBox* _tmp0_;
	gint _tmp1_ = 0;
	GitgRepositoryListBoxRow** _tmp2_;
	_tmp0_ = self->priv->d_repository_list_box;
	_tmp2_ = gitg_repository_list_box_get_selection (_tmp0_, &_tmp1_);
	{
		GitgRepositoryListBoxRow** sel_collection = NULL;
		gint sel_collection_length1 = 0;
		gint _sel_collection_size_ = 0;
		gint sel_it = 0;
		sel_collection = _tmp2_;
		sel_collection_length1 = _tmp1_;
		for (sel_it = 0; sel_it < sel_collection_length1; sel_it = sel_it + 1) {
			GitgRepositoryListBoxRow* _tmp3_;
			GitgRepositoryListBoxRow* sel = NULL;
			_tmp3_ = _g_object_ref0 (sel_collection[sel_it]);
			sel = _tmp3_;
			{
				GitgRepositoryListBoxRow* _tmp4_;
				_tmp4_ = sel;
				g_signal_emit_by_name (_tmp4_, "request-remove");
				_g_object_unref0 (sel);
			}
		}
		sel_collection = (_vala_array_free (sel_collection, sel_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	gitg_ext_selectable_set_selectable_mode ((GitgExtSelectable*) self, GITG_EXT_SELECTION_MODE_NORMAL);
}

static void
__gitg_dash_view_action_widget___lambda165__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	_gitg_dash_view_action_widget___lambda165_ ((GitgDashView*) self);
}

static void
_gitg_dash_view_action_widget___lambda166_ (GitgDashView* self)
{
	GitgRepositoryListBox* _tmp0_;
	gint _tmp1_ = 0;
	GitgRepositoryListBoxRow** _tmp2_;
	_tmp0_ = self->priv->d_repository_list_box;
	_tmp2_ = gitg_repository_list_box_get_selection (_tmp0_, &_tmp1_);
	{
		GitgRepositoryListBoxRow** sel_collection = NULL;
		gint sel_collection_length1 = 0;
		gint _sel_collection_size_ = 0;
		gint sel_it = 0;
		sel_collection = _tmp2_;
		sel_collection_length1 = _tmp1_;
		for (sel_it = 0; sel_it < sel_collection_length1; sel_it = sel_it + 1) {
			GitgRepositoryListBoxRow* _tmp3_;
			GitgRepositoryListBoxRow* sel = NULL;
			_tmp3_ = _g_object_ref0 (sel_collection[sel_it]);
			sel = _tmp3_;
			{
				GitgRepositoryListBoxRow* _tmp4_;
				_tmp4_ = sel;
				g_signal_emit_by_name (_tmp4_, "request-delete-source");
				_g_object_unref0 (sel);
			}
		}
		sel_collection = (_vala_array_free (sel_collection, sel_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	gitg_ext_selectable_set_selectable_mode ((GitgExtSelectable*) self, GITG_EXT_SELECTION_MODE_NORMAL);
}

static void
__gitg_dash_view_action_widget___lambda166__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	_gitg_dash_view_action_widget___lambda166_ ((GitgDashView*) self);
}

static GtkWidget*
gitg_dash_view_real_get_action_widget (GitgExtSelectable* base)
{
	GtkWidget* result;
	GitgDashView* self;
	GtkActionBar* ab = NULL;
	GtkActionBar* _tmp0_;
	GtkButton* remove_button = NULL;
	GtkButton* _tmp1_;
	GtkStyleContext* _tmp2_;
	GitgRepositoryListBox* _tmp3_;
	GtkButton* delete_source_button = NULL;
	GtkButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	GitgRepositoryListBox* _tmp6_;
	self = (GitgDashView*) base;
	_tmp0_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp0_);
	ab = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Remove"));
	g_object_ref_sink (_tmp1_);
	remove_button = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) remove_button);
	gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	gtk_widget_set_sensitive ((GtkWidget*) remove_button, FALSE);
	gtk_widget_show ((GtkWidget*) remove_button);
	g_signal_connect_object (remove_button, "clicked", (GCallback) __gitg_dash_view_action_widget___lambda165__gtk_button_clicked, self, 0);
	_tmp3_ = self->priv->d_repository_list_box;
	g_object_bind_property_with_closures ((GObject*) _tmp3_, "has-selection", (GObject*) remove_button, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Delete sources"));
	g_object_ref_sink (_tmp4_);
	delete_source_button = _tmp4_;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) delete_source_button);
	gtk_style_context_add_class (_tmp5_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	gtk_widget_set_sensitive ((GtkWidget*) delete_source_button, FALSE);
	gtk_widget_show ((GtkWidget*) delete_source_button);
	g_signal_connect_object (delete_source_button, "clicked", (GCallback) __gitg_dash_view_action_widget___lambda166__gtk_button_clicked, self, 0);
	_tmp6_ = self->priv->d_repository_list_box;
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "has-selection", (GObject*) delete_source_button, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	gtk_action_bar_pack_end (ab, (GtkWidget*) remove_button);
	gtk_action_bar_pack_start (ab, (GtkWidget*) delete_source_button);
	result = (GtkWidget*) ab;
	_g_object_unref0 (delete_source_button);
	_g_object_unref0 (remove_button);
	return result;
}

static inline gpointer
gitg_dash_view_clone_callbacks_get_instance_private (GitgDashViewCloneCallbacks* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDashViewCloneCallbacks_private_offset);
}

static GitgDashViewCloneCallbacks*
gitg_dash_view_clone_callbacks_construct (GType object_type,
                                          GitgExtApplication* application,
                                          GgitConfig* config,
                                          GitgRepositoryListBoxRow* row)
{
	GitgDashViewCloneCallbacks * self = NULL;
	GitgRepositoryListBoxRow* _tmp0_;
	GitgCredentialsManager* _tmp1_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (row != NULL, NULL);
	self = (GitgDashViewCloneCallbacks*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (row);
	_g_object_unref0 (self->priv->d_row);
	self->priv->d_row = _tmp0_;
	_tmp1_ = gitg_credentials_manager_new (config, G_TYPE_CHECK_INSTANCE_TYPE (application, gtk_window_get_type ()) ? ((GtkWindow*) application) : NULL, FALSE);
	_gitg_credentials_manager_unref0 (self->priv->d_credentials);
	self->priv->d_credentials = _tmp1_;
	return self;
}

static GitgDashViewCloneCallbacks*
gitg_dash_view_clone_callbacks_new (GitgExtApplication* application,
                                    GgitConfig* config,
                                    GitgRepositoryListBoxRow* row)
{
	return gitg_dash_view_clone_callbacks_construct (GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, application, config, row);
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		GitgDashViewCloneCallbacks* self;
		self = _data64_->self;
		_g_object_unref0 (self);
		g_slice_free (Block64Data, _data64_);
	}
}

static gboolean
__lambda161_ (Block64Data* _data64_)
{
	GitgDashViewCloneCallbacks* self;
	GitgRepositoryListBoxRow* _tmp0_;
	gboolean result;
	self = _data64_->self;
	_tmp0_ = self->priv->d_row;
	gitg_repository_list_box_row_set_fraction (_tmp0_, (_data64_->recvobj + _data64_->indxobj) / ((gdouble) (2 * _data64_->totaobj)));
	result = FALSE;
	return result;
}

static gboolean
___lambda161__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda161_ (self);
	return result;
}

static void
gitg_dash_view_clone_callbacks_real_transfer_progress (GgitRemoteCallbacks* base,
                                                       GgitTransferProgress* stats)
{
	GitgDashViewCloneCallbacks * self;
	Block64Data* _data64_;
	self = (GitgDashViewCloneCallbacks*) base;
	g_return_if_fail (stats != NULL);
	_data64_ = g_slice_new0 (Block64Data);
	_data64_->_ref_count_ = 1;
	_data64_->self = g_object_ref (self);
	_data64_->recvobj = ggit_transfer_progress_get_received_objects (stats);
	_data64_->indxobj = ggit_transfer_progress_get_indexed_objects (stats);
	_data64_->totaobj = ggit_transfer_progress_get_total_objects (stats);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda161__gsource_func, block64_data_ref (_data64_), block64_data_unref);
	block64_data_unref (_data64_);
	_data64_ = NULL;
}

static GgitCred*
gitg_dash_view_clone_callbacks_real_credentials (GgitRemoteCallbacks* base,
                                                 const gchar* url,
                                                 const gchar* username_from_url,
                                                 GgitCredtype allowed_types,
                                                 GError** error)
{
	GitgDashViewCloneCallbacks * self;
	GgitCred* _tmp0_ = NULL;
	GitgCredentialsManager* _tmp1_;
	GgitCred* _tmp2_;
	GgitCred* _tmp3_;
	GError* _inner_error0_ = NULL;
	GgitCred* result;
	self = (GitgDashViewCloneCallbacks*) base;
	g_return_val_if_fail (url != NULL, NULL);
	_tmp1_ = self->priv->d_credentials;
	_tmp2_ = gitg_credentials_manager_credentials (_tmp1_, url, username_from_url, allowed_types, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
gitg_dash_view_clone_callbacks_class_init (GitgDashViewCloneCallbacksClass * klass,
                                           gpointer klass_data)
{
	gitg_dash_view_clone_callbacks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDashViewCloneCallbacks_private_offset);
	((GgitRemoteCallbacksClass *) klass)->transfer_progress = (void (*) (GgitRemoteCallbacks*, GgitTransferProgress*)) gitg_dash_view_clone_callbacks_real_transfer_progress;
	((GgitRemoteCallbacksClass *) klass)->credentials = (GgitCred* (*) (GgitRemoteCallbacks*, const gchar*, const gchar*, GgitCredtype, GError**)) gitg_dash_view_clone_callbacks_real_credentials;
	G_OBJECT_CLASS (klass)->finalize = gitg_dash_view_clone_callbacks_finalize;
}

static void
gitg_dash_view_clone_callbacks_instance_init (GitgDashViewCloneCallbacks * self,
                                              gpointer klass)
{
	self->priv = gitg_dash_view_clone_callbacks_get_instance_private (self);
}

static void
gitg_dash_view_clone_callbacks_finalize (GObject * obj)
{
	GitgDashViewCloneCallbacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacks);
	_g_object_unref0 (self->priv->d_row);
	_gitg_credentials_manager_unref0 (self->priv->d_credentials);
	G_OBJECT_CLASS (gitg_dash_view_clone_callbacks_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_dash_view_clone_callbacks_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDashViewCloneCallbacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_dash_view_clone_callbacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDashViewCloneCallbacks), 0, (GInstanceInitFunc) gitg_dash_view_clone_callbacks_instance_init, NULL };
	GType gitg_dash_view_clone_callbacks_type_id;
	gitg_dash_view_clone_callbacks_type_id = g_type_register_static (ggit_remote_callbacks_get_type (), "GitgDashViewCloneCallbacks", &g_define_type_info, 0);
	GitgDashViewCloneCallbacks_private_offset = g_type_add_instance_private (gitg_dash_view_clone_callbacks_type_id, sizeof (GitgDashViewCloneCallbacksPrivate));
	return gitg_dash_view_clone_callbacks_type_id;
}

static GType
gitg_dash_view_clone_callbacks_get_type (void)
{
	static gsize gitg_dash_view_clone_callbacks_type_id__once = 0;
	if (g_once_init_enter (&gitg_dash_view_clone_callbacks_type_id__once)) {
		GType gitg_dash_view_clone_callbacks_type_id;
		gitg_dash_view_clone_callbacks_type_id = gitg_dash_view_clone_callbacks_get_type_once ();
		g_once_init_leave (&gitg_dash_view_clone_callbacks_type_id__once, gitg_dash_view_clone_callbacks_type_id);
	}
	return gitg_dash_view_clone_callbacks_type_id__once;
}

static Block65Data*
block65_data_ref (Block65Data* _data65_)
{
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}

static void
block65_data_unref (void * _userdata_)
{
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		GitgDashView* self;
		self = _data65_->self;
		_gitg_when_mapped_unref0 (_data65_->whenMapped);
		_g_object_unref0 (self);
		g_slice_free (Block65Data, _data65_);
	}
}

static void
_gitg_dash_view___lambda167_ (GitgDashView* self)
{
	if (!self->priv->d_setting_mode) {
		g_object_notify ((GObject*) self, "selectable-mode");
	}
}

static void
__gitg_dash_view___lambda167__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	_gitg_dash_view___lambda167_ ((GitgDashView*) self);
}

static void
_gitg_dash_view___lambda168_ (GitgDashView* self,
                              GitgRepository* repository)
{
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	g_return_if_fail (repository != NULL);
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	gitg_ext_application_set_repository (_tmp2_, repository);
	_g_object_unref0 (_tmp2_);
}

static void
__gitg_dash_view___lambda168__gitg_repository_list_box_repository_activated (GitgRepositoryListBox* _sender,
                                                                             GitgRepository* repository,
                                                                             gpointer self)
{
	_gitg_dash_view___lambda168_ ((GitgDashView*) self, repository);
}

static void
_gitg_dash_view___lambda169_ (GitgDashView* self,
                              const gchar* primary_message,
                              const gchar* secondary_message)
{
	GitgExtApplication* _tmp0_;
	GitgExtApplication* _tmp1_;
	GitgExtApplication* _tmp2_;
	g_return_if_fail (primary_message != NULL);
	g_return_if_fail (secondary_message != NULL);
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	gitg_ext_application_show_infobar (_tmp2_, primary_message, secondary_message, GTK_MESSAGE_ERROR);
	_g_object_unref0 (_tmp2_);
}

static void
__gitg_dash_view___lambda169__gitg_repository_list_box_show_error (GitgRepositoryListBox* _sender,
                                                                   const gchar* primary_message,
                                                                   const gchar* secondary_message,
                                                                   gpointer self)
{
	_gitg_dash_view___lambda169_ ((GitgDashView*) self, primary_message, secondary_message);
}

static void
_gitg_dash_view_update_availability_gtk_container_add (GtkContainer* _sender,
                                                       GtkWidget* widget,
                                                       gpointer self)
{
	gitg_dash_view_update_availability ((GitgDashView*) self);
}

static void
_gitg_dash_view_update_availability_gtk_container_remove (GtkContainer* _sender,
                                                          GtkWidget* widget,
                                                          gpointer self)
{
	gitg_dash_view_update_availability ((GitgDashView*) self);
}

static void
_gitg_dash_view___lambda170_ (Block65Data* _data65_)
{
	GitgDashView* self;
	GitgRepositoryListBox* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GitgRepositoryListBox* _tmp8_;
	self = _data65_->self;
	_tmp0_ = self->priv->d_repository_list_box;
	_tmp1_ = gitg_dirs_get_user_data_dir ();
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (_tmp3_, "repositories.gbookmarks", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_tmp7_ = _tmp6_;
	gitg_repository_list_box_set_location (_tmp0_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp8_ = self->priv->d_repository_list_box;
	gitg_repository_list_box_populate_bookmarks (_tmp8_);
	_gitg_when_mapped_unref0 (_data65_->whenMapped);
	_data65_->whenMapped = NULL;
}

static void
__gitg_dash_view___lambda170__gitg_when_mapped_on_mapped (gpointer self)
{
	_gitg_dash_view___lambda170_ (self);
}

static GObject *
gitg_dash_view_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgDashView * self;
	Block65Data* _data65_;
	GitgRepositoryListBox* _tmp0_;
	GitgRepositoryListBox* _tmp1_;
	GitgRepositoryListBox* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkGrid* _tmp4_;
	GitgRepositoryListBox* _tmp5_;
	GitgRepositoryListBox* _tmp6_;
	GtkLabel* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkLabel* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GitgWhenMapped* _tmp13_;
	GitgWhenMapped* _tmp14_;
	parent_class = G_OBJECT_CLASS (gitg_dash_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DASH_VIEW, GitgDashView);
	_data65_ = g_slice_new0 (Block65Data);
	_data65_->_ref_count_ = 1;
	_data65_->self = g_object_ref (self);
	_tmp0_ = self->priv->d_repository_list_box;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::mode", (GCallback) __gitg_dash_view___lambda167__g_object_notify, self, 0);
	_tmp1_ = self->priv->d_repository_list_box;
	g_signal_connect_object (_tmp1_, "repository-activated", (GCallback) __gitg_dash_view___lambda168__gitg_repository_list_box_repository_activated, self, 0);
	_tmp2_ = self->priv->d_repository_list_box;
	g_signal_connect_object (_tmp2_, "show-error", (GCallback) __gitg_dash_view___lambda169__gitg_repository_list_box_show_error, self, 0);
	_tmp3_ = self->priv->d_scrolled_window;
	g_object_bind_property_with_closures ((GObject*) self, "has-repositories", (GObject*) _tmp3_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = self->priv->d_introduction;
	g_object_bind_property_with_closures ((GObject*) self, "has-repositories", (GObject*) _tmp4_, "visible", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = self->priv->d_repository_list_box;
	g_signal_connect_object ((GtkContainer*) _tmp5_, "add", (GCallback) _gitg_dash_view_update_availability_gtk_container_add, self, 0);
	_tmp6_ = self->priv->d_repository_list_box;
	g_signal_connect_object ((GtkContainer*) _tmp6_, "remove", (GCallback) _gitg_dash_view_update_availability_gtk_container_remove, self, 0);
	_tmp7_ = self->priv->d_label_scan;
	_tmp8_ = g_strdup_printf (_ ("We can also %sscan your home directory%s for git repositories."), "<a href=\"scan-home\">", "</a>");
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp7_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->d_label_profile;
	_tmp11_ = g_strdup_printf (_ ("In the mean time, you may want to %sset up your git profile%s."), "<a href=\"setup-profile\">", "</a>");
	_tmp12_ = _tmp11_;
	gtk_label_set_label (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	gitg_dash_view_update_setup_profile_visibility (self);
	_tmp13_ = gitg_when_mapped_new ((GtkWidget*) self);
	_data65_->whenMapped = _tmp13_;
	_tmp14_ = _data65_->whenMapped;
	gitg_when_mapped_update (_tmp14_, __gitg_dash_view___lambda170__gitg_when_mapped_on_mapped, block65_data_ref (_data65_), block65_data_unref, NULL);
	gitg_ext_searchable_set_search_text ((GitgExtSearchable*) self, "");
	block65_data_unref (_data65_);
	_data65_ = NULL;
	return obj;
}

static void
gitg_dash_view_class_init (GitgDashViewClass * klass,
                           gpointer klass_data)
{
	gitg_dash_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDashView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_dash_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_dash_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_dash_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_dash_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_APPLICATION_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SELECTABLE_MODE_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_SELECTABLE_MODE_PROPERTY] = g_param_spec_enum ("selectable-mode", "selectable-mode", "selectable-mode", GITG_EXT_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SELECTABLE_MODE_TOOLTIP_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_SELECTABLE_MODE_TOOLTIP_PROPERTY] = g_param_spec_string ("selectable-mode-tooltip", "selectable-mode-tooltip", "selectable-mode-tooltip", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_HAS_REPOSITORIES_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_HAS_REPOSITORIES_PROPERTY] = g_param_spec_boolean ("has-repositories", "has-repositories", "has-repositories", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SELECTABLE_AVAILABLE_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_SELECTABLE_AVAILABLE_PROPERTY] = g_param_spec_boolean ("selectable-available", "selectable-available", "selectable-available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SEARCH_AVAILABLE_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_SEARCH_AVAILABLE_PROPERTY] = g_param_spec_boolean ("search-available", "search-available", "search-available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_DISPLAY_NAME_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_DESCRIPTION_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_ID_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_WIDGET_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_ICON_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SEARCH_TEXT_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_SEARCH_TEXT_PROPERTY] = g_param_spec_string ("search-text", "search-text", "search-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SEARCH_ENTRY_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_SEARCH_ENTRY_PROPERTY] = g_param_spec_object ("search-entry", "search-entry", "search-entry", gtk_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SEARCH_VISIBLE_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_SEARCH_VISIBLE_PROPERTY] = g_param_spec_boolean ("search-visible", "search-visible", "search-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_ACTION_WIDGET_PROPERTY, gitg_dash_view_properties[GITG_DASH_VIEW_ACTION_WIDGET_PROPERTY] = g_param_spec_object ("action-widget", "action-widget", "action-widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-dash-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "introduction", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_introduction));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_scan", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_label_scan));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_profile", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_label_profile));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolled_window", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_scrolled_window));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "repository_list_box", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_repository_list_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scan_home_activated", G_CALLBACK(_gitg_dash_view_scan_home_activated_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "setup_profile_activated", G_CALLBACK(_gitg_dash_view_setup_profile_activated_gtk_label_activate_link));
}

static void
gitg_dash_view_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface,
                                                   gpointer iface_data)
{
	gitg_dash_view_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_application = gitg_dash_view_real_get_application;
	iface->set_application = gitg_dash_view_real_set_application;
	iface->get_display_name = gitg_dash_view_real_get_display_name;
	iface->get_description = gitg_dash_view_real_get_description;
	iface->get_id = gitg_dash_view_real_get_id;
	iface->get_widget = gitg_dash_view_real_get_widget;
	iface->get_icon = gitg_dash_view_real_get_icon;
}

static void
gitg_dash_view_gitg_ext_activity_interface_init (GitgExtActivityIface * iface,
                                                 gpointer iface_data)
{
	gitg_dash_view_gitg_ext_activity_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gitg_dash_view_gitg_ext_selectable_interface_init (GitgExtSelectableIface * iface,
                                                   gpointer iface_data)
{
	gitg_dash_view_gitg_ext_selectable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_selectable_mode = gitg_dash_view_real_get_selectable_mode;
	iface->set_selectable_mode = gitg_dash_view_real_set_selectable_mode;
	iface->get_selectable_mode_tooltip = gitg_dash_view_real_get_selectable_mode_tooltip;
	iface->get_selectable_available = gitg_dash_view_real_get_selectable_available;
	iface->get_action_widget = gitg_dash_view_real_get_action_widget;
}

static void
gitg_dash_view_gitg_ext_searchable_interface_init (GitgExtSearchableIface * iface,
                                                   gpointer iface_data)
{
	gitg_dash_view_gitg_ext_searchable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_search_available = gitg_dash_view_real_get_search_available;
	iface->get_search_text = gitg_dash_view_real_get_search_text;
	iface->set_search_text = gitg_dash_view_real_set_search_text;
	iface->set_search_entry = gitg_dash_view_real_set_search_entry;
	iface->get_search_visible = gitg_dash_view_real_get_search_visible;
	iface->set_search_visible = gitg_dash_view_real_set_search_visible;
}

static void
gitg_dash_view_gitg_recursive_scanner_interface_init (GitgRecursiveScannerIface * iface,
                                                      gpointer iface_data)
{
	gitg_dash_view_gitg_recursive_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->scan_visit_directory = (void (*) (GitgRecursiveScanner*, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) gitg_dash_view_real_scan_visit_directory;
	iface->scan_visit_directory_finish = (gboolean (*) (GitgRecursiveScanner*, GAsyncResult*)) gitg_dash_view_scan_visit_directory_finish;
}

static void
gitg_dash_view_instance_init (GitgDashView * self,
                              gpointer klass)
{
	self->priv = gitg_dash_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_dash_view_finalize (GObject * obj)
{
	GitgDashView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DASH_VIEW, GitgDashView);
	_g_object_unref0 (self->priv->_application);
	_g_free0 (self->priv->d_search_text);
	G_OBJECT_CLASS (gitg_dash_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_dash_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDashViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_dash_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDashView), 0, (GInstanceInitFunc) gitg_dash_view_instance_init, NULL };
	static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_activity_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_ext_activity_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_selectable_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_ext_selectable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_ext_searchable_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_ext_searchable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gitg_recursive_scanner_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_recursive_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gitg_dash_view_type_id;
	gitg_dash_view_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDashView", &g_define_type_info, 0);
	g_type_add_interface_static (gitg_dash_view_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
	g_type_add_interface_static (gitg_dash_view_type_id, GITG_EXT_TYPE_ACTIVITY, &gitg_ext_activity_info);
	g_type_add_interface_static (gitg_dash_view_type_id, GITG_EXT_TYPE_SELECTABLE, &gitg_ext_selectable_info);
	g_type_add_interface_static (gitg_dash_view_type_id, GITG_EXT_TYPE_SEARCHABLE, &gitg_ext_searchable_info);
	g_type_add_interface_static (gitg_dash_view_type_id, GITG_TYPE_RECURSIVE_SCANNER, &gitg_recursive_scanner_info);
	GitgDashView_private_offset = g_type_add_instance_private (gitg_dash_view_type_id, sizeof (GitgDashViewPrivate));
	return gitg_dash_view_type_id;
}

GType
gitg_dash_view_get_type (void)
{
	static gsize gitg_dash_view_type_id__once = 0;
	if (g_once_init_enter (&gitg_dash_view_type_id__once)) {
		GType gitg_dash_view_type_id;
		gitg_dash_view_type_id = gitg_dash_view_get_type_once ();
		g_once_init_leave (&gitg_dash_view_type_id__once, gitg_dash_view_type_id);
	}
	return gitg_dash_view_type_id__once;
}

static void
_vala_gitg_dash_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	GitgDashView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DASH_VIEW, GitgDashView);
	switch (property_id) {
		case GITG_DASH_VIEW_APPLICATION_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
		break;
		case GITG_DASH_VIEW_SELECTABLE_MODE_PROPERTY:
		g_value_set_enum (value, gitg_ext_selectable_get_selectable_mode ((GitgExtSelectable*) self));
		break;
		case GITG_DASH_VIEW_SELECTABLE_MODE_TOOLTIP_PROPERTY:
		g_value_take_string (value, gitg_ext_selectable_get_selectable_mode_tooltip ((GitgExtSelectable*) self));
		break;
		case GITG_DASH_VIEW_HAS_REPOSITORIES_PROPERTY:
		g_value_set_boolean (value, gitg_dash_view_get_has_repositories (self));
		break;
		case GITG_DASH_VIEW_SELECTABLE_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, gitg_ext_selectable_get_selectable_available ((GitgExtSelectable*) self));
		break;
		case GITG_DASH_VIEW_SEARCH_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, gitg_ext_searchable_get_search_available ((GitgExtSearchable*) self));
		break;
		case GITG_DASH_VIEW_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
		break;
		case GITG_DASH_VIEW_DESCRIPTION_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
		break;
		case GITG_DASH_VIEW_ID_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
		break;
		case GITG_DASH_VIEW_WIDGET_PROPERTY:
		g_value_take_object (value, gitg_ext_ui_element_get_widget ((GitgExtUIElement*) self));
		break;
		case GITG_DASH_VIEW_ICON_PROPERTY:
		g_value_take_string (value, gitg_ext_ui_element_get_icon ((GitgExtUIElement*) self));
		break;
		case GITG_DASH_VIEW_SEARCH_TEXT_PROPERTY:
		g_value_take_string (value, gitg_ext_searchable_get_search_text ((GitgExtSearchable*) self));
		break;
		case GITG_DASH_VIEW_SEARCH_VISIBLE_PROPERTY:
		g_value_set_boolean (value, gitg_ext_searchable_get_search_visible ((GitgExtSearchable*) self));
		break;
		case GITG_DASH_VIEW_ACTION_WIDGET_PROPERTY:
		g_value_take_object (value, gitg_ext_selectable_get_action_widget ((GitgExtSelectable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_dash_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	GitgDashView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DASH_VIEW, GitgDashView);
	switch (property_id) {
		case GITG_DASH_VIEW_APPLICATION_PROPERTY:
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
		break;
		case GITG_DASH_VIEW_SELECTABLE_MODE_PROPERTY:
		gitg_ext_selectable_set_selectable_mode ((GitgExtSelectable*) self, g_value_get_enum (value));
		break;
		case GITG_DASH_VIEW_SEARCH_TEXT_PROPERTY:
		gitg_ext_searchable_set_search_text ((GitgExtSearchable*) self, g_value_get_string (value));
		break;
		case GITG_DASH_VIEW_SEARCH_ENTRY_PROPERTY:
		gitg_ext_searchable_set_search_entry ((GitgExtSearchable*) self, g_value_get_object (value));
		break;
		case GITG_DASH_VIEW_SEARCH_VISIBLE_PROPERTY:
		gitg_ext_searchable_set_search_visible ((GitgExtSearchable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

