/* gitg-utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-utils.vala, do not modify */

/*
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libgitg/gitg-platform-support.h"
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GitgParamSpecUtils GitgParamSpecUtils;

struct _GitgParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer gitg_utils_parent_class = NULL;

static void gitg_utils_finalize (GitgUtils * obj);
static GType gitg_utils_get_type_once (void);

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
gitg_utils_replace_home_dir_with_tilde (GFile* file)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gchar* homedir = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_parse_name (file);
	name = _tmp0_;
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = g_strdup (_tmp1_);
	homedir = _tmp2_;
	_tmp3_ = homedir;
	if (_tmp3_ != NULL) {
		{
			gchar* hd = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = homedir;
			_tmp5_ = g_filename_to_utf8 (_tmp4_, (gssize) -1, NULL, NULL, &_inner_error0_);
			hd = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = hd;
			_tmp7_ = name;
			if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("~/");
				_g_free0 (name);
				name = _tmp8_;
			} else {
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp13_;
				_tmp9_ = name;
				_tmp10_ = hd;
				_tmp11_ = g_strconcat (_tmp10_, "/", NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_str_has_prefix (_tmp9_, _tmp12_);
				_g_free0 (_tmp12_);
				if (_tmp13_) {
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					const gchar* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp14_ = name;
					_tmp15_ = hd;
					_tmp16_ = strlen (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = name;
					_tmp19_ = strlen (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = string_slice (_tmp14_, (glong) _tmp17_, (glong) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat ("~", _tmp22_, NULL);
					_g_free0 (name);
					name = _tmp23_;
					_g_free0 (_tmp22_);
				}
			}
			_g_free0 (hd);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (homedir);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = name;
	_g_free0 (homedir);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
gitg_utils_expand_home_dir (const gchar* path)
{
	gchar* homedir = NULL;
	gint pos = 0;
	const gchar* _tmp4_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	homedir = NULL;
	pos = -1;
	if (g_str_has_prefix (path, "~/")) {
		gchar* _tmp0_;
		_tmp0_ = gitg_platform_support_get_user_home_dir (NULL);
		_g_free0 (homedir);
		homedir = _tmp0_;
		pos = 1;
	} else {
		if (g_str_has_prefix (path, "~")) {
			gchar* user = NULL;
			gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			pos = string_index_of_char (path, (gunichar) '/', 0);
			_tmp1_ = string_slice (path, (glong) 1, (glong) pos);
			user = _tmp1_;
			_tmp2_ = user;
			_tmp3_ = gitg_platform_support_get_user_home_dir (_tmp2_);
			_g_free0 (homedir);
			homedir = _tmp3_;
			_g_free0 (user);
		}
	}
	_tmp4_ = homedir;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = homedir;
		_tmp6_ = string_substring (path, (glong) (pos + 1), (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_build_filename (_tmp5_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		_g_free0 (homedir);
		return result;
	}
	_tmp10_ = g_strdup (path);
	result = _tmp10_;
	_g_free0 (homedir);
	return result;
}

GitgUtils*
gitg_utils_construct (GType object_type)
{
	GitgUtils* self = NULL;
	self = (GitgUtils*) g_type_create_instance (object_type);
	return self;
}

GitgUtils*
gitg_utils_new (void)
{
	return gitg_utils_construct (GITG_TYPE_UTILS);
}

static void
gitg_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_utils_unref (value->data[0].v_pointer);
	}
}

static void
gitg_value_utils_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_value_utils_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_value_utils_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	GitgUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gitg_param_spec_utils (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	GitgParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gitg_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
gitg_value_set_utils (GValue* value,
                      gpointer v_object)
{
	GitgUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_utils_unref (old);
	}
}

void
gitg_value_take_utils (GValue* value,
                       gpointer v_object)
{
	GitgUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_utils_unref (old);
	}
}

static void
gitg_utils_class_init (GitgUtilsClass * klass,
                       gpointer klass_data)
{
	gitg_utils_parent_class = g_type_class_peek_parent (klass);
	((GitgUtilsClass *) klass)->finalize = gitg_utils_finalize;
}

static void
gitg_utils_instance_init (GitgUtils * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
gitg_utils_finalize (GitgUtils * obj)
{
	GitgUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_UTILS, GitgUtils);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gitg_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_value_utils_init, gitg_value_utils_free_value, gitg_value_utils_copy_value, gitg_value_utils_peek_pointer, "p", gitg_value_utils_collect_value, "p", gitg_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgUtils), 0, (GInstanceInitFunc) gitg_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_utils_type_id;
	gitg_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gitg_utils_type_id;
}

GType
gitg_utils_get_type (void)
{
	static gsize gitg_utils_type_id__once = 0;
	if (g_once_init_enter (&gitg_utils_type_id__once)) {
		GType gitg_utils_type_id;
		gitg_utils_type_id = gitg_utils_get_type_once ();
		g_once_init_leave (&gitg_utils_type_id__once, gitg_utils_type_id);
	}
	return gitg_utils_type_id__once;
}

gpointer
gitg_utils_ref (gpointer instance)
{
	GitgUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gitg_utils_unref (gpointer instance)
{
	GitgUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

