/* snapshot-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from snapshot-manager.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define GAMES_SNAPSHOT_MANAGER_MAX_AUTOSAVES 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GAMES_SNAPSHOT_MANAGER_0_PROPERTY,
	GAMES_SNAPSHOT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* games_snapshot_manager_properties[GAMES_SNAPSHOT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block16Data Block16Data;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GamesSnapshotManagerPrivate {
	GamesGame* game;
	gchar* core_id;
	GamesSnapshot** snapshots;
	gint snapshots_length1;
	gint _snapshots_size_;
};

struct _Block16Data {
	int _ref_count_;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GCompareDataFunc compare_func;
	gpointer compare_func_target;
};

static gint GamesSnapshotManager_private_offset;
static gpointer games_snapshot_manager_parent_class = NULL;

static gchar* games_snapshot_manager_get_snapshots_dir (GamesSnapshotManager* self,
                                                 GError** error);
static void _vala_array_add14 (GamesSnapshot** * array,
                        gint* length,
                        gint* size,
                        GamesSnapshot* value);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gint ___lambda3__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint _games_snapshot_compare_gcompare_data_func (gconstpointer a,
                                                 gconstpointer b,
                                                 gpointer self);
static GamesSnapshot** _vala_array_dup5 (GamesSnapshot** self,
                                  gssize length);
static void games_snapshot_manager_trim_autosaves (GamesSnapshotManager* self);
static gchar* games_snapshot_manager_create_new_snapshot_name (GamesSnapshotManager* self,
                                                        GError** error);
static gint __lambda73_ (gint a,
                  gint b);
static gint ___lambda73__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void _vala_array_add15 (GamesSnapshot** * array,
                        gint* length,
                        gint* size,
                        GamesSnapshot* value);
static void _vala_array_add16 (GamesSnapshot** * array,
                        gint* length,
                        gint* size,
                        GamesSnapshot* value);
static GamesSnapshot** _vala_array_dup6 (GamesSnapshot** self,
                                  gssize length);
static void _vala_array_add17 (GamesSnapshot** * array,
                        gint* length,
                        gint* size,
                        GamesSnapshot* value);
static GamesSnapshot** _vala_array_dup7 (GamesSnapshot** self,
                                  gssize length);
static void games_snapshot_manager_finalize (GObject * obj);
static GType games_snapshot_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_snapshot_manager_get_instance_private (GamesSnapshotManager* self)
{
	return G_STRUCT_MEMBER_P (self, GamesSnapshotManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add14 (GamesSnapshot** * array,
                   gint* length,
                   gint* size,
                   GamesSnapshot* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesSnapshot*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		GType t_type;
		GBoxedCopyFunc t_dup_func;
		GDestroyNotify t_destroy_func;
		t_type = _data16_->t_type;
		t_dup_func = _data16_->t_dup_func;
		t_destroy_func = _data16_->t_destroy_func;
		g_slice_free (Block16Data, _data16_);
	}
}

static gint
__lambda3_ (Block16Data* _data16_,
            gconstpointer* a,
            gconstpointer* b)
{
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gint result;
	t_type = _data16_->t_type;
	t_dup_func = _data16_->t_dup_func;
	t_destroy_func = _data16_->t_destroy_func;
	result = _data16_->compare_func (*a, *b, _data16_->compare_func_target);
	return result;
}

static gint
___lambda3__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda3_ (self, a, b);
	return result;
}

static void
_vala_g_qsort_with_data (GType t_type,
                         GBoxedCopyFunc t_dup_func,
                         GDestroyNotify t_destroy_func,
                         gpointer* elems,
                         gint elems_length1,
                         gsize size,
                         GCompareDataFunc compare_func,
                         gpointer compare_func_target)
{
	Block16Data* _data16_;
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->t_type = t_type;
	_data16_->t_dup_func = t_dup_func;
	_data16_->t_destroy_func = t_destroy_func;
	_data16_->compare_func = (GCompareDataFunc) compare_func;
	_data16_->compare_func_target = compare_func_target;
	g_qsort_with_data (elems, (gint) elems_length1, size, (GCompareDataFunc) ___lambda3__gcompare_data_func, _data16_);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static gint
_games_snapshot_compare_gcompare_data_func (gconstpointer a,
                                            gconstpointer b,
                                            gpointer self)
{
	gint result;
	result = games_snapshot_compare ((GamesSnapshot*) a, (GamesSnapshot*) b);
	return result;
}

GamesSnapshotManager*
games_snapshot_manager_construct (GType object_type,
                                  GamesGame* game,
                                  const gchar* core_id,
                                  GError** error)
{
	GamesSnapshotManager * self = NULL;
	GamesGame* _tmp0_;
	gchar* _tmp1_;
	gchar* dir_path = NULL;
	gchar* _tmp2_;
	GFile* dir_file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GDir* dir = NULL;
	const gchar* _tmp8_;
	GDir* _tmp9_;
	GamesSnapshot** _tmp10_;
	gchar* snapshot_name = NULL;
	GamesSnapshot** _tmp23_;
	gint _tmp23__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (core_id != NULL, NULL);
	self = (GamesSnapshotManager*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	_tmp1_ = g_strdup (core_id);
	_g_free0 (self->priv->core_id);
	self->priv->core_id = _tmp1_;
	_tmp2_ = games_snapshot_manager_get_snapshots_dir (self, &_inner_error0_);
	dir_path = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp3_ = dir_path;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	dir_file = _tmp4_;
	_tmp5_ = dir_file;
	if (!g_file_query_exists (_tmp5_, NULL)) {
		GFile* _tmp6_;
		GamesSnapshot** _tmp7_;
		_tmp6_ = dir_file;
		g_file_make_directory_with_parents (_tmp6_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (dir_file);
			_g_free0 (dir_path);
			_g_object_unref0 (self);
			return NULL;
		}
		_tmp7_ = g_new0 (GamesSnapshot*, 0 + 1);
		self->priv->snapshots = (_vala_array_free (self->priv->snapshots, self->priv->snapshots_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->snapshots = _tmp7_;
		self->priv->snapshots_length1 = 0;
		self->priv->_snapshots_size_ = self->priv->snapshots_length1;
		_g_object_unref0 (dir_file);
		_g_free0 (dir_path);
		return self;
	}
	_tmp8_ = dir_path;
	_tmp9_ = g_dir_open (_tmp8_, (guint) 0, &_inner_error0_);
	dir = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dir_file);
		_g_free0 (dir_path);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp10_ = g_new0 (GamesSnapshot*, 0 + 1);
	self->priv->snapshots = (_vala_array_free (self->priv->snapshots, self->priv->snapshots_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->snapshots = _tmp10_;
	self->priv->snapshots_length1 = 0;
	self->priv->_snapshots_size_ = self->priv->snapshots_length1;
	snapshot_name = NULL;
	while (TRUE) {
		GDir* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* snapshot_path = NULL;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		GamesPlatform* _tmp19_;
		GamesPlatform* _tmp20_;
		const gchar* _tmp21_;
		GamesSnapshot* _tmp22_;
		_tmp11_ = dir;
		_tmp12_ = g_dir_read_name (_tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (snapshot_name);
		snapshot_name = _tmp13_;
		_tmp14_ = snapshot_name;
		if (!(_tmp14_ != NULL)) {
			break;
		}
		_tmp15_ = snapshot_name;
		if (g_strcmp0 (_tmp15_, "global") == 0) {
			continue;
		}
		_tmp16_ = dir_path;
		_tmp17_ = snapshot_name;
		_tmp18_ = g_build_filename (_tmp16_, _tmp17_, NULL);
		snapshot_path = _tmp18_;
		_tmp19_ = games_game_get_platform (game);
		_tmp20_ = _tmp19_;
		_tmp21_ = snapshot_path;
		_tmp22_ = games_snapshot_load (_tmp20_, core_id, _tmp21_);
		_vala_array_add14 (&self->priv->snapshots, &self->priv->snapshots_length1, &self->priv->_snapshots_size_, _tmp22_);
		_g_free0 (snapshot_path);
	}
	_tmp23_ = self->priv->snapshots;
	_tmp23__length1 = self->priv->snapshots_length1;
	_vala_g_qsort_with_data (GAMES_TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp23_, (gint) _tmp23__length1, (gsize) sizeof (GamesSnapshot*), (GCompareDataFunc) _games_snapshot_compare_gcompare_data_func, NULL);
	_g_free0 (snapshot_name);
	_g_dir_close0 (dir);
	_g_object_unref0 (dir_file);
	_g_free0 (dir_path);
	return self;
}

GamesSnapshotManager*
games_snapshot_manager_new (GamesGame* game,
                            const gchar* core_id,
                            GError** error)
{
	return games_snapshot_manager_construct (GAMES_TYPE_SNAPSHOT_MANAGER, game, core_id, error);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_snapshot_manager_get_snapshots_dir (GamesSnapshotManager* self,
                                          GError** error)
{
	GamesUid* uid = NULL;
	GamesGame* _tmp0_;
	GamesUid* _tmp1_;
	GamesUid* _tmp2_;
	GamesUid* _tmp3_;
	gchar* core_id_prefix = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = games_game_get_uid (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	uid = _tmp3_;
	_tmp4_ = self->priv->core_id;
	_tmp5_ = string_replace (_tmp4_, ".libretro", "");
	core_id_prefix = _tmp5_;
	_tmp6_ = games_application_get_data_dir ();
	_tmp7_ = _tmp6_;
	_tmp8_ = games_uid_to_string (uid);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_to_string (core_id_prefix);
	_tmp11_ = g_strconcat (_tmp9_, "-", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_build_filename (_tmp7_, "savestates", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	result = _tmp14_;
	_g_free0 (core_id_prefix);
	_g_object_unref0 (uid);
	return result;
}

static GamesSnapshot**
_vala_array_dup5 (GamesSnapshot** self,
                  gssize length)
{
	if (length >= 0) {
		GamesSnapshot** result;
		gssize i;
		result = g_new0 (GamesSnapshot*, length + 1);
		for (i = 0; i < length; i++) {
			GamesSnapshot* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GamesSnapshot**
games_snapshot_manager_get_snapshots (GamesSnapshotManager* self,
                                      gint* result_length1)
{
	GamesSnapshot** _tmp0_;
	gint _tmp0__length1;
	GamesSnapshot** _tmp1_;
	gint _tmp1__length1;
	GamesSnapshot** _tmp2_;
	gint _tmp2__length1;
	GamesSnapshot** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->snapshots;
	_tmp0__length1 = self->priv->snapshots_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gboolean
games_snapshot_manager_has_snapshots (GamesSnapshotManager* self)
{
	GamesSnapshot** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->snapshots;
	_tmp0__length1 = self->priv->snapshots_length1;
	result = _tmp0__length1 > 0;
	return result;
}

GamesSnapshot*
games_snapshot_manager_get_latest_snapshot (GamesSnapshotManager* self)
{
	GamesSnapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (games_snapshot_manager_has_snapshots (self)) {
		GamesSnapshot** _tmp0_;
		gint _tmp0__length1;
		GamesSnapshot* _tmp1_;
		GamesSnapshot* _tmp2_;
		_tmp0_ = self->priv->snapshots;
		_tmp0__length1 = self->priv->snapshots_length1;
		_tmp1_ = _tmp0_[0];
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

static void
games_snapshot_manager_trim_autosaves (GamesSnapshotManager* self)
{
	gint n_autosaves = 0;
	GamesSnapshot** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	n_autosaves = 1;
	_tmp0_ = self->priv->snapshots;
	_tmp0__length1 = self->priv->snapshots_length1;
	{
		GamesSnapshot** snapshot_collection = NULL;
		gint snapshot_collection_length1 = 0;
		gint _snapshot_collection_size_ = 0;
		gint snapshot_it = 0;
		snapshot_collection = _tmp0_;
		snapshot_collection_length1 = _tmp0__length1;
		for (snapshot_it = 0; snapshot_it < snapshot_collection_length1; snapshot_it = snapshot_it + 1) {
			GamesSnapshot* _tmp1_;
			GamesSnapshot* snapshot = NULL;
			_tmp1_ = _g_object_ref0 (snapshot_collection[snapshot_it]);
			snapshot = _tmp1_;
			{
				GamesSnapshot* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				GamesSnapshot* _tmp6_;
				_tmp2_ = snapshot;
				_tmp3_ = games_snapshot_get_is_automatic (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					_g_object_unref0 (snapshot);
					continue;
				}
				if (n_autosaves < GAMES_SNAPSHOT_MANAGER_MAX_AUTOSAVES) {
					gint _tmp5_;
					_tmp5_ = n_autosaves;
					n_autosaves = _tmp5_ + 1;
					_g_object_unref0 (snapshot);
					continue;
				}
				_tmp6_ = snapshot;
				games_snapshot_delete_from_disk (_tmp6_);
				_g_object_unref0 (snapshot);
			}
		}
	}
}

static gint
__lambda73_ (gint a,
             gint b)
{
	gint result;
	result = a - b;
	return result;
}

static gint
___lambda73__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda73_ ((gint) ((gintptr) a), (gint) ((gintptr) b));
	return result;
}

static gchar*
games_snapshot_manager_create_new_snapshot_name (GamesSnapshotManager* self,
                                                 GError** error)
{
	GList* list = NULL;
	GRegex* regex = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GRegex* _tmp2_;
	GRegex* _tmp3_;
	GamesSnapshot** _tmp4_;
	gint _tmp4__length1;
	gint next_number = 0;
	GList* _tmp18_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	_tmp0_ = g_strdup_printf (_ ("New snapshot %s"), "([1-9]\\d*)");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		(list == NULL) ? NULL : (list = (g_list_free (list), NULL));
		return NULL;
	}
	_tmp4_ = self->priv->snapshots;
	_tmp4__length1 = self->priv->snapshots_length1;
	{
		GamesSnapshot** snapshot_collection = NULL;
		gint snapshot_collection_length1 = 0;
		gint _snapshot_collection_size_ = 0;
		gint snapshot_it = 0;
		snapshot_collection = _tmp4_;
		snapshot_collection_length1 = _tmp4__length1;
		for (snapshot_it = 0; snapshot_it < snapshot_collection_length1; snapshot_it = snapshot_it + 1) {
			GamesSnapshot* _tmp5_;
			GamesSnapshot* snapshot = NULL;
			_tmp5_ = _g_object_ref0 (snapshot_collection[snapshot_it]);
			snapshot = _tmp5_;
			{
				GamesSnapshot* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				GMatchInfo* match_info = NULL;
				GRegex* _tmp9_;
				GamesSnapshot* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				GMatchInfo* _tmp13_ = NULL;
				gboolean _tmp14_;
				_tmp6_ = snapshot;
				_tmp7_ = games_snapshot_get_is_automatic (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					_g_object_unref0 (snapshot);
					continue;
				}
				match_info = NULL;
				_tmp9_ = regex;
				_tmp10_ = snapshot;
				_tmp11_ = games_snapshot_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp14_ = g_regex_match (_tmp9_, _tmp12_, 0, &_tmp13_);
				_g_match_info_unref0 (match_info);
				match_info = _tmp13_;
				if (_tmp14_) {
					gchar* number = NULL;
					GMatchInfo* _tmp15_;
					gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = match_info;
					_tmp16_ = g_match_info_fetch (_tmp15_, 1);
					number = _tmp16_;
					_tmp17_ = number;
					list = g_list_prepend (list, (gpointer) ((gintptr) atoi (_tmp17_)));
					_g_free0 (number);
				}
				_g_match_info_unref0 (match_info);
				_g_object_unref0 (snapshot);
			}
		}
	}
	list = g_list_sort (list, ___lambda73__gcompare_func);
	next_number = 1;
	_tmp18_ = list;
	{
		GList* number_collection = NULL;
		GList* number_it = NULL;
		number_collection = _tmp18_;
		for (number_it = number_collection; number_it != NULL; number_it = number_it->next) {
			gint number = 0;
			number = (gint) ((gintptr) number_it->data);
			{
				gint _tmp19_;
				if (number != next_number) {
					break;
				}
				_tmp19_ = next_number;
				next_number = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = g_strdup_printf ("%i", next_number);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf (_ ("New snapshot %s"), _tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	result = _tmp23_;
	_g_regex_unref0 (regex);
	(list == NULL) ? NULL : (list = (g_list_free (list), NULL));
	return result;
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
_vala_array_add15 (GamesSnapshot** * array,
                   gint* length,
                   gint* size,
                   GamesSnapshot* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesSnapshot*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add16 (GamesSnapshot** * array,
                   gint* length,
                   gint* size,
                   GamesSnapshot* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesSnapshot*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GamesSnapshot**
_vala_array_dup6 (GamesSnapshot** self,
                  gssize length)
{
	if (length >= 0) {
		GamesSnapshot** result;
		gssize i;
		result = g_new0 (GamesSnapshot*, length + 1);
		for (i = 0; i < length; i++) {
			GamesSnapshot* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GamesSnapshot*
games_snapshot_manager_create_snapshot (GamesSnapshotManager* self,
                                        gboolean is_automatic,
                                        GamesSnapshotManagerSnapshotFunc save_callback,
                                        gpointer save_callback_target,
                                        GError** error)
{
	GDateTime* creation_date = NULL;
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* path = NULL;
	GDateTime* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GamesSnapshot* snapshot = NULL;
	GamesGame* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GamesSnapshot* _tmp14_;
	GamesSnapshot* _tmp15_;
	gchar* _tmp16_ = NULL;
	GamesSnapshot* _tmp18_;
	GamesSnapshot* _tmp19_;
	GDateTime* _tmp20_;
	GamesSnapshot* _tmp21_;
	GamesSnapshot* _tmp22_;
	GamesSnapshot* _tmp23_ = NULL;
	GamesSnapshot* _tmp24_;
	const gchar* _tmp25_;
	GamesSnapshot* _tmp26_;
	GamesSnapshot* _tmp27_;
	GamesSnapshot** new_snapshots = NULL;
	GamesSnapshot** _tmp28_;
	gint new_snapshots_length1;
	gint _new_snapshots_size_;
	GamesSnapshot* _tmp29_;
	GamesSnapshot* _tmp30_;
	GamesSnapshot** _tmp31_;
	gint _tmp31__length1;
	GamesSnapshot** _tmp35_;
	gint _tmp35__length1;
	GamesSnapshot** _tmp36_;
	gint _tmp36__length1;
	GError* _inner_error0_ = NULL;
	GamesSnapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (is_automatic) {
		games_snapshot_manager_trim_autosaves (self);
	}
	_tmp0_ = g_time_zone_new_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_time_zone_unref0 (_tmp1_);
	creation_date = _tmp3_;
	_tmp5_ = games_snapshot_manager_get_snapshots_dir (self, &_inner_error0_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_date_time_unref0 (creation_date);
		return NULL;
	}
	_tmp6_ = creation_date;
	_tmp7_ = g_date_time_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_filename (_tmp4_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	path = _tmp10_;
	_tmp11_ = self->priv->game;
	_tmp12_ = self->priv->core_id;
	_tmp13_ = path;
	_tmp14_ = games_snapshot_create_empty (_tmp11_, _tmp12_, _tmp13_, &_inner_error0_);
	snapshot = _tmp14_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (path);
		_g_free0 (_tmp4_);
		_g_date_time_unref0 (creation_date);
		return NULL;
	}
	_tmp15_ = snapshot;
	games_snapshot_set_is_automatic (_tmp15_, is_automatic);
	if (is_automatic) {
		_g_free0 (_tmp16_);
		_tmp16_ = NULL;
	} else {
		gchar* _tmp17_;
		_tmp17_ = games_snapshot_manager_create_new_snapshot_name (self, &_inner_error0_);
		_g_free0 (_tmp16_);
		_tmp16_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp16_);
			_g_object_unref0 (snapshot);
			_g_free0 (path);
			_g_free0 (_tmp4_);
			_g_date_time_unref0 (creation_date);
			return NULL;
		}
	}
	_tmp18_ = snapshot;
	games_snapshot_set_name (_tmp18_, _tmp16_);
	_tmp19_ = snapshot;
	_tmp20_ = creation_date;
	games_snapshot_set_creation_date (_tmp19_, _tmp20_);
	_tmp21_ = snapshot;
	save_callback (_tmp21_, save_callback_target, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp16_);
		_g_object_unref0 (snapshot);
		_g_free0 (path);
		_g_free0 (_tmp4_);
		_g_date_time_unref0 (creation_date);
		return NULL;
	}
	_tmp22_ = snapshot;
	games_snapshot_write_metadata (_tmp22_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp16_);
		_g_object_unref0 (snapshot);
		_g_free0 (path);
		_g_free0 (_tmp4_);
		_g_date_time_unref0 (creation_date);
		return NULL;
	}
	_tmp24_ = snapshot;
	_tmp25_ = path;
	_tmp26_ = games_snapshot_move_to (_tmp24_, _tmp25_, &_inner_error0_);
	_tmp23_ = _tmp26_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp16_);
		_g_object_unref0 (snapshot);
		_g_free0 (path);
		_g_free0 (_tmp4_);
		_g_date_time_unref0 (creation_date);
		return NULL;
	}
	_tmp27_ = _tmp23_;
	_tmp23_ = NULL;
	_g_object_unref0 (snapshot);
	snapshot = _tmp27_;
	_tmp28_ = g_new0 (GamesSnapshot*, 0 + 1);
	new_snapshots = _tmp28_;
	new_snapshots_length1 = 0;
	_new_snapshots_size_ = new_snapshots_length1;
	_tmp29_ = snapshot;
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_vala_array_add15 (&new_snapshots, &new_snapshots_length1, &_new_snapshots_size_, _tmp30_);
	_tmp31_ = self->priv->snapshots;
	_tmp31__length1 = self->priv->snapshots_length1;
	{
		GamesSnapshot** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp31_;
		s_collection_length1 = _tmp31__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			GamesSnapshot* _tmp32_;
			GamesSnapshot* s = NULL;
			_tmp32_ = _g_object_ref0 (s_collection[s_it]);
			s = _tmp32_;
			{
				GamesSnapshot* _tmp33_;
				GamesSnapshot* _tmp34_;
				_tmp33_ = s;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				_vala_array_add16 (&new_snapshots, &new_snapshots_length1, &_new_snapshots_size_, _tmp34_);
				_g_object_unref0 (s);
			}
		}
	}
	_tmp35_ = new_snapshots;
	_tmp35__length1 = new_snapshots_length1;
	_tmp36_ = (_tmp35_ != NULL) ? _vala_array_dup6 (_tmp35_, _tmp35__length1) : _tmp35_;
	_tmp36__length1 = _tmp35__length1;
	self->priv->snapshots = (_vala_array_free (self->priv->snapshots, self->priv->snapshots_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->snapshots = _tmp36_;
	self->priv->snapshots_length1 = _tmp36__length1;
	self->priv->_snapshots_size_ = self->priv->snapshots_length1;
	result = snapshot;
	new_snapshots = (_vala_array_free (new_snapshots, new_snapshots_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp23_);
	_g_free0 (_tmp16_);
	_g_free0 (path);
	_g_free0 (_tmp4_);
	_g_date_time_unref0 (creation_date);
	return result;
}

static void
_vala_array_add17 (GamesSnapshot** * array,
                   gint* length,
                   gint* size,
                   GamesSnapshot* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesSnapshot*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GamesSnapshot**
_vala_array_dup7 (GamesSnapshot** self,
                  gssize length)
{
	if (length >= 0) {
		GamesSnapshot** result;
		gssize i;
		result = g_new0 (GamesSnapshot*, length + 1);
		for (i = 0; i < length; i++) {
			GamesSnapshot* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
games_snapshot_manager_delete_snapshot (GamesSnapshotManager* self,
                                        GamesSnapshot* snapshot)
{
	GamesSnapshot** new_snapshots = NULL;
	GamesSnapshot** _tmp0_;
	gint new_snapshots_length1;
	gint _new_snapshots_size_;
	GamesSnapshot** _tmp1_;
	gint _tmp1__length1;
	GamesSnapshot** _tmp6_;
	gint _tmp6__length1;
	GamesSnapshot** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = g_new0 (GamesSnapshot*, 0 + 1);
	new_snapshots = _tmp0_;
	new_snapshots_length1 = 0;
	_new_snapshots_size_ = new_snapshots_length1;
	_tmp1_ = self->priv->snapshots;
	_tmp1__length1 = self->priv->snapshots_length1;
	{
		GamesSnapshot** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _tmp1__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			GamesSnapshot* _tmp2_;
			GamesSnapshot* s = NULL;
			_tmp2_ = _g_object_ref0 (s_collection[s_it]);
			s = _tmp2_;
			{
				GamesSnapshot* _tmp3_;
				_tmp3_ = s;
				if (snapshot != _tmp3_) {
					GamesSnapshot* _tmp4_;
					GamesSnapshot* _tmp5_;
					_tmp4_ = s;
					_tmp5_ = _g_object_ref0 (_tmp4_);
					_vala_array_add17 (&new_snapshots, &new_snapshots_length1, &_new_snapshots_size_, _tmp5_);
				}
				_g_object_unref0 (s);
			}
		}
	}
	_tmp6_ = new_snapshots;
	_tmp6__length1 = new_snapshots_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup7 (_tmp6_, _tmp6__length1) : _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	self->priv->snapshots = (_vala_array_free (self->priv->snapshots, self->priv->snapshots_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->snapshots = _tmp7_;
	self->priv->snapshots_length1 = _tmp7__length1;
	self->priv->_snapshots_size_ = self->priv->snapshots_length1;
	games_snapshot_delete_from_disk (snapshot);
	new_snapshots = (_vala_array_free (new_snapshots, new_snapshots_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
games_snapshot_manager_class_init (GamesSnapshotManagerClass * klass,
                                   gpointer klass_data)
{
	games_snapshot_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesSnapshotManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_snapshot_manager_finalize;
}

static void
games_snapshot_manager_instance_init (GamesSnapshotManager * self,
                                      gpointer klass)
{
	self->priv = games_snapshot_manager_get_instance_private (self);
}

static void
games_snapshot_manager_finalize (GObject * obj)
{
	GamesSnapshotManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SNAPSHOT_MANAGER, GamesSnapshotManager);
	_g_object_unref0 (self->priv->game);
	_g_free0 (self->priv->core_id);
	self->priv->snapshots = (_vala_array_free (self->priv->snapshots, self->priv->snapshots_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (games_snapshot_manager_parent_class)->finalize (obj);
}

static GType
games_snapshot_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSnapshotManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_snapshot_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSnapshotManager), 0, (GInstanceInitFunc) games_snapshot_manager_instance_init, NULL };
	GType games_snapshot_manager_type_id;
	games_snapshot_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesSnapshotManager", &g_define_type_info, 0);
	GamesSnapshotManager_private_offset = g_type_add_instance_private (games_snapshot_manager_type_id, sizeof (GamesSnapshotManagerPrivate));
	return games_snapshot_manager_type_id;
}

GType
games_snapshot_manager_get_type (void)
{
	static volatile gsize games_snapshot_manager_type_id__once = 0;
	if (g_once_init_enter (&games_snapshot_manager_type_id__once)) {
		GType games_snapshot_manager_type_id;
		games_snapshot_manager_type_id = games_snapshot_manager_get_type_once ();
		g_once_init_leave (&games_snapshot_manager_type_id__once, games_snapshot_manager_type_id);
	}
	return games_snapshot_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

