/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fft, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fft_window = R"doc()doc";


static const char* __doc_gr_fft_window_window_0 = R"doc()doc";


static const char* __doc_gr_fft_window_window_1 = R"doc()doc";


static const char* __doc_gr_fft_window_max_attenuation = R"doc(Given a window::win_type, this tells you the maximum attenuation (really the maximum approximation error) you can expect.

For most windows, this is a set value. For the Kaiser, Exponential, Gaussian, and Tukey windows, the attenuation is based on the value of a provided parameter.


For the Kaiser window the actual relationship is a piece-wise exponential relationship to calculate beta from the desired attenuation and can be found on page 542 of Oppenheim and Schafer (Discrete-Time Signal Processing, 3rd edition). To simplify this function to solve for A given beta, we use a linear form that is exact for attenuation >= 50 dB. For an attenuation of 50 dB, beta = 4.55; for an attenuation of 70 dB, beta = 6.76.


Exponential attenuation is complicated to measure due to the irregular error ripple structure, but it ranges between 23 and 26 dB depending on the decay factor; 26 dB is a good bound.


The Gaussian window should not be used for window based filter construction; instead there is a dedicated gaussian filter construction function. There is no meaningful way to measure approximation error 'delta' as shown in Fig 7.23 of Oppenheim and Schafer (Discrete-Time Signal Processing, 3rd edition).


Tukey windows provide attenuation that varies non-linearily between Rectangular (21 dB) and Hann (44 dB) windows.)doc";


static const char* __doc_gr_fft_window_coswindow_0 = R"doc()doc";


static const char* __doc_gr_fft_window_coswindow_1 = R"doc()doc";


static const char* __doc_gr_fft_window_coswindow_2 = R"doc()doc";


static const char* __doc_gr_fft_window_rectangular = R"doc(Build a rectangular window.

Taps are flat across the window.)doc";


static const char* __doc_gr_fft_window_hamming = R"doc(Build a Hamming window.

See:)doc";


static const char* __doc_gr_fft_window_hann = R"doc(Build a Hann window (sometimes known as Hanning).

See:)doc";


static const char* __doc_gr_fft_window_hanning = R"doc(Alias to build a Hann window.)doc";


static const char* __doc_gr_fft_window_blackman = R"doc(Build an exact Blackman window.

See:)doc";


static const char* __doc_gr_fft_window_blackman2 = R"doc(Build Blackman window, variation 1.)doc";


static const char* __doc_gr_fft_window_blackman3 = R"doc(Build Blackman window, variation 2.)doc";


static const char* __doc_gr_fft_window_blackman4 = R"doc(Build Blackman window, variation 3.)doc";


static const char* __doc_gr_fft_window_blackman_harris = R"doc(Build a Blackman-harris window with a given attenuation.)doc";


static const char* __doc_gr_fft_window_blackmanharris = R"doc(Alias to gr::fft::window::blackman_harris.)doc";


static const char* __doc_gr_fft_window_nuttall = R"doc(Build a minimum 4-term Nuttall (or Blackman-Nuttall) window, referred to by Heinzel G. et al. as a Nuttall4c window.

See: A.H. Nuttall: 'Some windows with very good sidelobe behaviour', IEEE Trans. on Acoustics, Speech and Signal Processing, Vol ASSP-29, figure 15


See: 'Spectrum and spectral density estimation by the Discrete Fourier transform (DFT), including a comprehensive list of window functions and some new flat-top windows', February 15, 2002 


Also:)doc";


static const char* __doc_gr_fft_window_blackman_nuttall = R"doc(Alias to the Nuttall window.)doc";


static const char* __doc_gr_fft_window_nuttall_cfd = R"doc(Build a Nuttall 4-term continuous first derivative window, referred to by Heinzel G. et al. as a Nuttall4b window.

See: A.H. Nuttall: 'Some windows with very good sidelobe behaviour', IEEE Trans. on Acoustics, Speech and Signal Processing, Vol ASSP-29, figure 12


See: 'Spectrum and spectral density estimation by the Discrete Fourier transform (DFT), including a comprehensive list of window functions and some new flat-top windows', February 15, 2002 


Also:)doc";


static const char* __doc_gr_fft_window_flattop = R"doc(Build a flat top window per the SRS specification.

See: 


Note: there are many flat top windows, and this implementation is different from SciPY and Matlab which use the coefficients from D?Antona et al. \"Digital Signal
Processing for Measurement Systems\" with the following cosine coefficients:)doc";


static const char* __doc_gr_fft_window_kaiser = R"doc(Build a Kaiser window with a given beta.

See:)doc";


static const char* __doc_gr_fft_window_bartlett = R"doc(Build a Barlett (triangular) window.

See:)doc";


static const char* __doc_gr_fft_window_welch = R"doc()doc";


static const char* __doc_gr_fft_window_parzen = R"doc(Build a Parzen (or de la Valle-Poussin) window.

See:)doc";


static const char* __doc_gr_fft_window_exponential = R"doc(Build an exponential window with a given decay.

See:)doc";


static const char* __doc_gr_fft_window_riemann = R"doc(Build a Riemann window.

See:)doc";


static const char* __doc_gr_fft_window_tukey = R"doc(Build a Tukey window.)doc";


static const char* __doc_gr_fft_window_gaussian = R"doc(Build a Gaussian window using the equation.)doc";


static const char* __doc_gr_fft_window_build = R"doc(Build a window using gr::fft::win_type to index the type of window desired.)doc";
