{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An event caused by a pointing device moving between surfaces.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.CrossingEvent
    ( 

-- * Exported types
    CrossingEvent(..)                       ,
    IsCrossingEvent                         ,
    toCrossingEvent                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gdk.Objects.Event#g:method:ref"), [triggersContextMenu]("GI.Gdk.Objects.Event#g:method:triggersContextMenu"), [unref]("GI.Gdk.Objects.Event#g:method:unref").
-- 
-- ==== Getters
-- [getAxes]("GI.Gdk.Objects.Event#g:method:getAxes"), [getAxis]("GI.Gdk.Objects.Event#g:method:getAxis"), [getDetail]("GI.Gdk.Objects.CrossingEvent#g:method:getDetail"), [getDevice]("GI.Gdk.Objects.Event#g:method:getDevice"), [getDeviceTool]("GI.Gdk.Objects.Event#g:method:getDeviceTool"), [getDisplay]("GI.Gdk.Objects.Event#g:method:getDisplay"), [getEventSequence]("GI.Gdk.Objects.Event#g:method:getEventSequence"), [getEventType]("GI.Gdk.Objects.Event#g:method:getEventType"), [getFocus]("GI.Gdk.Objects.CrossingEvent#g:method:getFocus"), [getHistory]("GI.Gdk.Objects.Event#g:method:getHistory"), [getMode]("GI.Gdk.Objects.CrossingEvent#g:method:getMode"), [getModifierState]("GI.Gdk.Objects.Event#g:method:getModifierState"), [getPointerEmulated]("GI.Gdk.Objects.Event#g:method:getPointerEmulated"), [getPosition]("GI.Gdk.Objects.Event#g:method:getPosition"), [getSeat]("GI.Gdk.Objects.Event#g:method:getSeat"), [getSurface]("GI.Gdk.Objects.Event#g:method:getSurface"), [getTime]("GI.Gdk.Objects.Event#g:method:getTime").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveCrossingEventMethod              ,
#endif

-- ** getDetail #method:getDetail#

#if defined(ENABLE_OVERLOADING)
    CrossingEventGetDetailMethodInfo        ,
#endif
    crossingEventGetDetail                  ,


-- ** getFocus #method:getFocus#

#if defined(ENABLE_OVERLOADING)
    CrossingEventGetFocusMethodInfo         ,
#endif
    crossingEventGetFocus                   ,


-- ** getMode #method:getMode#

#if defined(ENABLE_OVERLOADING)
    CrossingEventGetModeMethodInfo          ,
#endif
    crossingEventGetMode                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event

#endif

-- | Memory-managed wrapper type.
newtype CrossingEvent = CrossingEvent (SP.ManagedPtr CrossingEvent)
    deriving (Eq)

instance SP.ManagedPtrNewtype CrossingEvent where
    toManagedPtr (CrossingEvent p) = p

foreign import ccall "gdk_crossing_event_get_type"
    c_gdk_crossing_event_get_type :: IO B.Types.GType

instance B.Types.TypedObject CrossingEvent where
    glibType = c_gdk_crossing_event_get_type

-- | Type class for types which can be safely cast to t'CrossingEvent', for instance with `toCrossingEvent`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf CrossingEvent o) => IsCrossingEvent o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf CrossingEvent o) => IsCrossingEvent o

instance O.HasParentTypes CrossingEvent
type instance O.ParentTypes CrossingEvent = '[Gdk.Event.Event]

-- | Cast to t'CrossingEvent', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCrossingEvent :: (MIO.MonadIO m, IsCrossingEvent o) => o -> m CrossingEvent
toCrossingEvent = MIO.liftIO . B.ManagedPtr.unsafeCastTo CrossingEvent

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveCrossingEventMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCrossingEventMethod "ref" o = Gdk.Event.EventRefMethodInfo
    ResolveCrossingEventMethod "triggersContextMenu" o = Gdk.Event.EventTriggersContextMenuMethodInfo
    ResolveCrossingEventMethod "unref" o = Gdk.Event.EventUnrefMethodInfo
    ResolveCrossingEventMethod "getAxes" o = Gdk.Event.EventGetAxesMethodInfo
    ResolveCrossingEventMethod "getAxis" o = Gdk.Event.EventGetAxisMethodInfo
    ResolveCrossingEventMethod "getDetail" o = CrossingEventGetDetailMethodInfo
    ResolveCrossingEventMethod "getDevice" o = Gdk.Event.EventGetDeviceMethodInfo
    ResolveCrossingEventMethod "getDeviceTool" o = Gdk.Event.EventGetDeviceToolMethodInfo
    ResolveCrossingEventMethod "getDisplay" o = Gdk.Event.EventGetDisplayMethodInfo
    ResolveCrossingEventMethod "getEventSequence" o = Gdk.Event.EventGetEventSequenceMethodInfo
    ResolveCrossingEventMethod "getEventType" o = Gdk.Event.EventGetEventTypeMethodInfo
    ResolveCrossingEventMethod "getFocus" o = CrossingEventGetFocusMethodInfo
    ResolveCrossingEventMethod "getHistory" o = Gdk.Event.EventGetHistoryMethodInfo
    ResolveCrossingEventMethod "getMode" o = CrossingEventGetModeMethodInfo
    ResolveCrossingEventMethod "getModifierState" o = Gdk.Event.EventGetModifierStateMethodInfo
    ResolveCrossingEventMethod "getPointerEmulated" o = Gdk.Event.EventGetPointerEmulatedMethodInfo
    ResolveCrossingEventMethod "getPosition" o = Gdk.Event.EventGetPositionMethodInfo
    ResolveCrossingEventMethod "getSeat" o = Gdk.Event.EventGetSeatMethodInfo
    ResolveCrossingEventMethod "getSurface" o = Gdk.Event.EventGetSurfaceMethodInfo
    ResolveCrossingEventMethod "getTime" o = Gdk.Event.EventGetTimeMethodInfo
    ResolveCrossingEventMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCrossingEventMethod t CrossingEvent, O.OverloadedMethod info CrossingEvent p) => OL.IsLabel t (CrossingEvent -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCrossingEventMethod t CrossingEvent, O.OverloadedMethod info CrossingEvent p, R.HasField t CrossingEvent p) => R.HasField t CrossingEvent p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCrossingEventMethod t CrossingEvent, O.OverloadedMethodInfo info CrossingEvent) => OL.IsLabel t (O.MethodProxy info CrossingEvent) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr CrossingEvent where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method CrossingEvent::get_detail
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "CrossingEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a crossing event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "NotifyType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_crossing_event_get_detail" gdk_crossing_event_get_detail :: 
    Ptr CrossingEvent ->                    -- event : TInterface (Name {namespace = "Gdk", name = "CrossingEvent"})
    IO CUInt

-- | Extracts the notify detail from a crossing event.
crossingEventGetDetail ::
    (B.CallStack.HasCallStack, MonadIO m, IsCrossingEvent a) =>
    a
    -- ^ /@event@/: a crossing event
    -> m Gdk.Enums.NotifyType
    -- ^ __Returns:__ the notify detail of /@event@/
crossingEventGetDetail event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_crossing_event_get_detail event'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data CrossingEventGetDetailMethodInfo
instance (signature ~ (m Gdk.Enums.NotifyType), MonadIO m, IsCrossingEvent a) => O.OverloadedMethod CrossingEventGetDetailMethodInfo a signature where
    overloadedMethod = crossingEventGetDetail

instance O.OverloadedMethodInfo CrossingEventGetDetailMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.CrossingEvent.crossingEventGetDetail",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-CrossingEvent.html#v:crossingEventGetDetail"
        })


#endif

-- method CrossingEvent::get_focus
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "CrossingEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a crossing event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_crossing_event_get_focus" gdk_crossing_event_get_focus :: 
    Ptr CrossingEvent ->                    -- event : TInterface (Name {namespace = "Gdk", name = "CrossingEvent"})
    IO CInt

-- | Checks if the /@event@/ surface is the focus surface.
crossingEventGetFocus ::
    (B.CallStack.HasCallStack, MonadIO m, IsCrossingEvent a) =>
    a
    -- ^ /@event@/: a crossing event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the surface is the focus surface
crossingEventGetFocus event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_crossing_event_get_focus event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data CrossingEventGetFocusMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCrossingEvent a) => O.OverloadedMethod CrossingEventGetFocusMethodInfo a signature where
    overloadedMethod = crossingEventGetFocus

instance O.OverloadedMethodInfo CrossingEventGetFocusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.CrossingEvent.crossingEventGetFocus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-CrossingEvent.html#v:crossingEventGetFocus"
        })


#endif

-- method CrossingEvent::get_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "CrossingEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a crossing event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "CrossingMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_crossing_event_get_mode" gdk_crossing_event_get_mode :: 
    Ptr CrossingEvent ->                    -- event : TInterface (Name {namespace = "Gdk", name = "CrossingEvent"})
    IO CUInt

-- | Extracts the crossing mode from a crossing event.
crossingEventGetMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsCrossingEvent a) =>
    a
    -- ^ /@event@/: a crossing event
    -> m Gdk.Enums.CrossingMode
    -- ^ __Returns:__ the mode of /@event@/
crossingEventGetMode event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_crossing_event_get_mode event'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data CrossingEventGetModeMethodInfo
instance (signature ~ (m Gdk.Enums.CrossingMode), MonadIO m, IsCrossingEvent a) => O.OverloadedMethod CrossingEventGetModeMethodInfo a signature where
    overloadedMethod = crossingEventGetMode

instance O.OverloadedMethodInfo CrossingEventGetModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.CrossingEvent.crossingEventGetMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-CrossingEvent.html#v:crossingEventGetMode"
        })


#endif


