{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Stores a single event in a motion history.
-- 
-- To check whether an axis is present, check whether the corresponding
-- flag from the [flags/@gdk@/.AxisFlags] enumeration is set in the /@flags@/
-- To access individual axis values, use the values of the values of
-- the t'GI.Gdk.Enums.AxisUse' enumerations as indices.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.TimeCoord
    ( 

-- * Exported types
    TimeCoord(..)                           ,
    newZeroTimeCoord                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTimeCoordMethod                  ,
#endif



 -- * Properties


-- ** flags #attr:flags#
-- | Flags indicating what axes are present, see [flags/@gdk@/.AxisFlags]

    getTimeCoordFlags                       ,
    setTimeCoordFlags                       ,
#if defined(ENABLE_OVERLOADING)
    timeCoord_flags                         ,
#endif


-- ** time #attr:time#
-- | The timestamp for this event

    getTimeCoordTime                        ,
    setTimeCoordTime                        ,
#if defined(ENABLE_OVERLOADING)
    timeCoord_time                          ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags

#else
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags

#endif

-- | Memory-managed wrapper type.
newtype TimeCoord = TimeCoord (SP.ManagedPtr TimeCoord)
    deriving (Eq)

instance SP.ManagedPtrNewtype TimeCoord where
    toManagedPtr (TimeCoord p) = p

instance BoxedPtr TimeCoord where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 104 >=> B.ManagedPtr.wrapPtr TimeCoord)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TimeCoord where
    boxedPtrCalloc = callocBytes 104


-- | Construct a t'TimeCoord' struct initialized to zero.
newZeroTimeCoord :: MonadIO m => m TimeCoord
newZeroTimeCoord = liftIO $ boxedPtrCalloc >>= wrapPtr TimeCoord

instance tag ~ 'AttrSet => Constructible TimeCoord tag where
    new _ attrs = do
        o <- newZeroTimeCoord
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' timeCoord #time
-- @
getTimeCoordTime :: MonadIO m => TimeCoord -> m Word32
getTimeCoordTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' timeCoord [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setTimeCoordTime :: MonadIO m => TimeCoord -> Word32 -> m ()
setTimeCoordTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data TimeCoordTimeFieldInfo
instance AttrInfo TimeCoordTimeFieldInfo where
    type AttrBaseTypeConstraint TimeCoordTimeFieldInfo = (~) TimeCoord
    type AttrAllowedOps TimeCoordTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TimeCoordTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint TimeCoordTimeFieldInfo = (~)Word32
    type AttrTransferType TimeCoordTimeFieldInfo = Word32
    type AttrGetType TimeCoordTimeFieldInfo = Word32
    type AttrLabel TimeCoordTimeFieldInfo = "time"
    type AttrOrigin TimeCoordTimeFieldInfo = TimeCoord
    attrGet = getTimeCoordTime
    attrSet = setTimeCoordTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.TimeCoord.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-TimeCoord.html#g:attr:time"
        })

timeCoord_time :: AttrLabelProxy "time"
timeCoord_time = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' timeCoord #flags
-- @
getTimeCoordFlags :: MonadIO m => TimeCoord -> m [Gdk.Flags.AxisFlags]
getTimeCoordFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' timeCoord [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setTimeCoordFlags :: MonadIO m => TimeCoord -> [Gdk.Flags.AxisFlags] -> m ()
setTimeCoordFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 4) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data TimeCoordFlagsFieldInfo
instance AttrInfo TimeCoordFlagsFieldInfo where
    type AttrBaseTypeConstraint TimeCoordFlagsFieldInfo = (~) TimeCoord
    type AttrAllowedOps TimeCoordFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TimeCoordFlagsFieldInfo = (~) [Gdk.Flags.AxisFlags]
    type AttrTransferTypeConstraint TimeCoordFlagsFieldInfo = (~)[Gdk.Flags.AxisFlags]
    type AttrTransferType TimeCoordFlagsFieldInfo = [Gdk.Flags.AxisFlags]
    type AttrGetType TimeCoordFlagsFieldInfo = [Gdk.Flags.AxisFlags]
    type AttrLabel TimeCoordFlagsFieldInfo = "flags"
    type AttrOrigin TimeCoordFlagsFieldInfo = TimeCoord
    attrGet = getTimeCoordFlags
    attrSet = setTimeCoordFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.TimeCoord.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-TimeCoord.html#g:attr:flags"
        })

timeCoord_flags :: AttrLabelProxy "flags"
timeCoord_flags = AttrLabelProxy

#endif


-- XXX Skipped attribute for "TimeCoord:axes"
-- Not implemented: Don't know how to unpack C array of type TCArray False 12 (-1) (TBasicType TDouble)

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TimeCoord
type instance O.AttributeList TimeCoord = TimeCoordAttributeList
type TimeCoordAttributeList = ('[ '("time", TimeCoordTimeFieldInfo), '("flags", TimeCoordFlagsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTimeCoordMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTimeCoordMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTimeCoordMethod t TimeCoord, O.OverloadedMethod info TimeCoord p) => OL.IsLabel t (TimeCoord -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTimeCoordMethod t TimeCoord, O.OverloadedMethod info TimeCoord p, R.HasField t TimeCoord p) => R.HasField t TimeCoord p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTimeCoordMethod t TimeCoord, O.OverloadedMethodInfo info TimeCoord) => OL.IsLabel t (O.MethodProxy info TimeCoord) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


