{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Shows a vertical list.
-- 
-- \<picture>
--   \<source srcset=\"list-box-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkListBox\" src=\"list-box.png\">
-- \<\/picture>
-- 
-- A @GtkListBox@ only contains @GtkListBoxRow@ children. These rows can
-- by dynamically sorted and filtered, and headers can be added dynamically
-- depending on the row content. It also allows keyboard and mouse navigation
-- and selection like a typical list.
-- 
-- Using @GtkListBox@ is often an alternative to @GtkTreeView@, especially
-- when the list contents has a more complicated layout than what is allowed
-- by a @GtkCellRenderer@, or when the contents is interactive (i.e. has a
-- button in it).
-- 
-- Although a @GtkListBox@ must have only @GtkListBoxRow@ children, you can
-- add any kind of widget to it via 'GI.Gtk.Objects.ListBox.listBoxPrepend',
-- 'GI.Gtk.Objects.ListBox.listBoxAppend' and 'GI.Gtk.Objects.ListBox.listBoxInsert' and a
-- @GtkListBoxRow@ widget will automatically be inserted between the list
-- and the widget.
-- 
-- @GtkListBoxRows@ can be marked as activatable or selectable. If a row is
-- activatable, [ListBox::rowActivated]("GI.Gtk.Objects.ListBox#g:signal:rowActivated") will be emitted for it when
-- the user tries to activate it. If it is selectable, the row will be marked
-- as selected when the user tries to select it.
-- 
-- = GtkListBox as GtkBuildable
-- 
-- The @GtkListBox@ implementation of the @GtkBuildable@ interface supports
-- setting a child as the placeholder by specifying “placeholder” as the “type”
-- attribute of a @\<child>@ element. See 'GI.Gtk.Objects.ListBox.listBoxSetPlaceholder'
-- for info.
-- 
-- = Shortcuts and Gestures
-- 
-- The following signals have default keybindings:
-- 
-- * [ListBox::moveCursor]("GI.Gtk.Objects.ListBox#g:signal:moveCursor")
-- * [ListBox::selectAll]("GI.Gtk.Objects.ListBox#g:signal:selectAll")
-- * [ListBox::toggleCursorRow]("GI.Gtk.Objects.ListBox#g:signal:toggleCursorRow")
-- * [ListBox::unselectAll]("GI.Gtk.Objects.ListBox#g:signal:unselectAll")
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >list[.separators][.rich-list][.navigation-sidebar][.boxed-list]
-- >╰── row[.activatable]
-- 
-- 
-- @GtkListBox@ uses a single CSS node named list. It may carry the .separators
-- style class, when the [ListBox:showSeparators]("GI.Gtk.Objects.ListBox#g:attr:showSeparators") property is set.
-- Each @GtkListBoxRow@ uses a single CSS node named row. The row nodes get the
-- .activatable style class added when appropriate.
-- 
-- It may also carry the .boxed-list style class. In this case, the list will be
-- automatically surrounded by a frame and have separators.
-- 
-- The main list node may also carry style classes to select
-- the style of <https://docs.gtk.org/gtk4/section-list-widget.html#list-styles list presentation>:
-- .rich-list, .navigation-sidebar or .data-table.
-- 
-- = Accessibility
-- 
-- @GtkListBox@ uses the 'GI.Gtk.Enums.AccessibleRoleList' role and @GtkListBoxRow@ uses
-- the 'GI.Gtk.Enums.AccessibleRoleListItem' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ListBox
    ( 

-- * Exported types
    ListBox(..)                             ,
    IsListBox                               ,
    toListBox                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [append]("GI.Gtk.Objects.ListBox#g:method:append"), [bindModel]("GI.Gtk.Objects.ListBox#g:method:bindModel"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [dragHighlightRow]("GI.Gtk.Objects.ListBox#g:method:dragHighlightRow"), [dragUnhighlightRow]("GI.Gtk.Objects.ListBox#g:method:dragUnhighlightRow"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insert]("GI.Gtk.Objects.ListBox#g:method:insert"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [invalidateFilter]("GI.Gtk.Objects.ListBox#g:method:invalidateFilter"), [invalidateHeaders]("GI.Gtk.Objects.ListBox#g:method:invalidateHeaders"), [invalidateSort]("GI.Gtk.Objects.ListBox#g:method:invalidateSort"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [prepend]("GI.Gtk.Objects.ListBox#g:method:prepend"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.ListBox#g:method:remove"), [removeAll]("GI.Gtk.Objects.ListBox#g:method:removeAll"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [selectAll]("GI.Gtk.Objects.ListBox#g:method:selectAll"), [selectRow]("GI.Gtk.Objects.ListBox#g:method:selectRow"), [selectedForeach]("GI.Gtk.Objects.ListBox#g:method:selectedForeach"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unselectAll]("GI.Gtk.Objects.ListBox#g:method:unselectAll"), [unselectRow]("GI.Gtk.Objects.ListBox#g:method:unselectRow"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActivateOnSingleClick]("GI.Gtk.Objects.ListBox#g:method:getActivateOnSingleClick"), [getAdjustment]("GI.Gtk.Objects.ListBox#g:method:getAdjustment"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getRowAtIndex]("GI.Gtk.Objects.ListBox#g:method:getRowAtIndex"), [getRowAtY]("GI.Gtk.Objects.ListBox#g:method:getRowAtY"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSelectedRow]("GI.Gtk.Objects.ListBox#g:method:getSelectedRow"), [getSelectedRows]("GI.Gtk.Objects.ListBox#g:method:getSelectedRows"), [getSelectionMode]("GI.Gtk.Objects.ListBox#g:method:getSelectionMode"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowSeparators]("GI.Gtk.Objects.ListBox#g:method:getShowSeparators"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTabBehavior]("GI.Gtk.Objects.ListBox#g:method:getTabBehavior"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActivateOnSingleClick]("GI.Gtk.Objects.ListBox#g:method:setActivateOnSingleClick"), [setAdjustment]("GI.Gtk.Objects.ListBox#g:method:setAdjustment"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFilterFunc]("GI.Gtk.Objects.ListBox#g:method:setFilterFunc"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHeaderFunc]("GI.Gtk.Objects.ListBox#g:method:setHeaderFunc"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPlaceholder]("GI.Gtk.Objects.ListBox#g:method:setPlaceholder"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSelectionMode]("GI.Gtk.Objects.ListBox#g:method:setSelectionMode"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowSeparators]("GI.Gtk.Objects.ListBox#g:method:setShowSeparators"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setSortFunc]("GI.Gtk.Objects.ListBox#g:method:setSortFunc"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTabBehavior]("GI.Gtk.Objects.ListBox#g:method:setTabBehavior"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveListBoxMethod                    ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    ListBoxAppendMethodInfo                 ,
#endif
    listBoxAppend                           ,


-- ** bindModel #method:bindModel#

#if defined(ENABLE_OVERLOADING)
    ListBoxBindModelMethodInfo              ,
#endif
    listBoxBindModel                        ,


-- ** dragHighlightRow #method:dragHighlightRow#

#if defined(ENABLE_OVERLOADING)
    ListBoxDragHighlightRowMethodInfo       ,
#endif
    listBoxDragHighlightRow                 ,


-- ** dragUnhighlightRow #method:dragUnhighlightRow#

#if defined(ENABLE_OVERLOADING)
    ListBoxDragUnhighlightRowMethodInfo     ,
#endif
    listBoxDragUnhighlightRow               ,


-- ** getActivateOnSingleClick #method:getActivateOnSingleClick#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetActivateOnSingleClickMethodInfo,
#endif
    listBoxGetActivateOnSingleClick         ,


-- ** getAdjustment #method:getAdjustment#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetAdjustmentMethodInfo          ,
#endif
    listBoxGetAdjustment                    ,


-- ** getRowAtIndex #method:getRowAtIndex#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetRowAtIndexMethodInfo          ,
#endif
    listBoxGetRowAtIndex                    ,


-- ** getRowAtY #method:getRowAtY#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetRowAtYMethodInfo              ,
#endif
    listBoxGetRowAtY                        ,


-- ** getSelectedRow #method:getSelectedRow#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetSelectedRowMethodInfo         ,
#endif
    listBoxGetSelectedRow                   ,


-- ** getSelectedRows #method:getSelectedRows#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetSelectedRowsMethodInfo        ,
#endif
    listBoxGetSelectedRows                  ,


-- ** getSelectionMode #method:getSelectionMode#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetSelectionModeMethodInfo       ,
#endif
    listBoxGetSelectionMode                 ,


-- ** getShowSeparators #method:getShowSeparators#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetShowSeparatorsMethodInfo      ,
#endif
    listBoxGetShowSeparators                ,


-- ** getTabBehavior #method:getTabBehavior#

#if defined(ENABLE_OVERLOADING)
    ListBoxGetTabBehaviorMethodInfo         ,
#endif
    listBoxGetTabBehavior                   ,


-- ** insert #method:insert#

#if defined(ENABLE_OVERLOADING)
    ListBoxInsertMethodInfo                 ,
#endif
    listBoxInsert                           ,


-- ** invalidateFilter #method:invalidateFilter#

#if defined(ENABLE_OVERLOADING)
    ListBoxInvalidateFilterMethodInfo       ,
#endif
    listBoxInvalidateFilter                 ,


-- ** invalidateHeaders #method:invalidateHeaders#

#if defined(ENABLE_OVERLOADING)
    ListBoxInvalidateHeadersMethodInfo      ,
#endif
    listBoxInvalidateHeaders                ,


-- ** invalidateSort #method:invalidateSort#

#if defined(ENABLE_OVERLOADING)
    ListBoxInvalidateSortMethodInfo         ,
#endif
    listBoxInvalidateSort                   ,


-- ** new #method:new#

    listBoxNew                              ,


-- ** prepend #method:prepend#

#if defined(ENABLE_OVERLOADING)
    ListBoxPrependMethodInfo                ,
#endif
    listBoxPrepend                          ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    ListBoxRemoveMethodInfo                 ,
#endif
    listBoxRemove                           ,


-- ** removeAll #method:removeAll#

#if defined(ENABLE_OVERLOADING)
    ListBoxRemoveAllMethodInfo              ,
#endif
    listBoxRemoveAll                        ,


-- ** selectAll #method:selectAll#

#if defined(ENABLE_OVERLOADING)
    ListBoxSelectAllMethodInfo              ,
#endif
    listBoxSelectAll                        ,


-- ** selectRow #method:selectRow#

#if defined(ENABLE_OVERLOADING)
    ListBoxSelectRowMethodInfo              ,
#endif
    listBoxSelectRow                        ,


-- ** selectedForeach #method:selectedForeach#

#if defined(ENABLE_OVERLOADING)
    ListBoxSelectedForeachMethodInfo        ,
#endif
    listBoxSelectedForeach                  ,


-- ** setActivateOnSingleClick #method:setActivateOnSingleClick#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetActivateOnSingleClickMethodInfo,
#endif
    listBoxSetActivateOnSingleClick         ,


-- ** setAdjustment #method:setAdjustment#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetAdjustmentMethodInfo          ,
#endif
    listBoxSetAdjustment                    ,


-- ** setFilterFunc #method:setFilterFunc#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetFilterFuncMethodInfo          ,
#endif
    listBoxSetFilterFunc                    ,


-- ** setHeaderFunc #method:setHeaderFunc#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetHeaderFuncMethodInfo          ,
#endif
    listBoxSetHeaderFunc                    ,


-- ** setPlaceholder #method:setPlaceholder#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetPlaceholderMethodInfo         ,
#endif
    listBoxSetPlaceholder                   ,


-- ** setSelectionMode #method:setSelectionMode#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetSelectionModeMethodInfo       ,
#endif
    listBoxSetSelectionMode                 ,


-- ** setShowSeparators #method:setShowSeparators#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetShowSeparatorsMethodInfo      ,
#endif
    listBoxSetShowSeparators                ,


-- ** setSortFunc #method:setSortFunc#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetSortFuncMethodInfo            ,
#endif
    listBoxSetSortFunc                      ,


-- ** setTabBehavior #method:setTabBehavior#

#if defined(ENABLE_OVERLOADING)
    ListBoxSetTabBehaviorMethodInfo         ,
#endif
    listBoxSetTabBehavior                   ,


-- ** unselectAll #method:unselectAll#

#if defined(ENABLE_OVERLOADING)
    ListBoxUnselectAllMethodInfo            ,
#endif
    listBoxUnselectAll                      ,


-- ** unselectRow #method:unselectRow#

#if defined(ENABLE_OVERLOADING)
    ListBoxUnselectRowMethodInfo            ,
#endif
    listBoxUnselectRow                      ,




 -- * Properties


-- ** acceptUnpairedRelease #attr:acceptUnpairedRelease#
-- | Whether to accept unpaired release events.

#if defined(ENABLE_OVERLOADING)
    ListBoxAcceptUnpairedReleasePropertyInfo,
#endif
    constructListBoxAcceptUnpairedRelease   ,
    getListBoxAcceptUnpairedRelease         ,
#if defined(ENABLE_OVERLOADING)
    listBoxAcceptUnpairedRelease            ,
#endif
    setListBoxAcceptUnpairedRelease         ,


-- ** activateOnSingleClick #attr:activateOnSingleClick#
-- | Determines whether children can be activated with a single
-- click, or require a double-click.

#if defined(ENABLE_OVERLOADING)
    ListBoxActivateOnSingleClickPropertyInfo,
#endif
    constructListBoxActivateOnSingleClick   ,
    getListBoxActivateOnSingleClick         ,
#if defined(ENABLE_OVERLOADING)
    listBoxActivateOnSingleClick            ,
#endif
    setListBoxActivateOnSingleClick         ,


-- ** selectionMode #attr:selectionMode#
-- | The selection mode used by the list box.

#if defined(ENABLE_OVERLOADING)
    ListBoxSelectionModePropertyInfo        ,
#endif
    constructListBoxSelectionMode           ,
    getListBoxSelectionMode                 ,
#if defined(ENABLE_OVERLOADING)
    listBoxSelectionMode                    ,
#endif
    setListBoxSelectionMode                 ,


-- ** showSeparators #attr:showSeparators#
-- | Whether to show separators between rows.

#if defined(ENABLE_OVERLOADING)
    ListBoxShowSeparatorsPropertyInfo       ,
#endif
    constructListBoxShowSeparators          ,
    getListBoxShowSeparators                ,
#if defined(ENABLE_OVERLOADING)
    listBoxShowSeparators                   ,
#endif
    setListBoxShowSeparators                ,


-- ** tabBehavior #attr:tabBehavior#
-- | Behavior of the \<kbd>Tab\<\/kbd> key
-- 
-- /Since: 4.18/

#if defined(ENABLE_OVERLOADING)
    ListBoxTabBehaviorPropertyInfo          ,
#endif
    constructListBoxTabBehavior             ,
    getListBoxTabBehavior                   ,
#if defined(ENABLE_OVERLOADING)
    listBoxTabBehavior                      ,
#endif
    setListBoxTabBehavior                   ,




 -- * Signals


-- ** activateCursorRow #signal:activateCursorRow#

    ListBoxActivateCursorRowCallback        ,
#if defined(ENABLE_OVERLOADING)
    ListBoxActivateCursorRowSignalInfo      ,
#endif
    afterListBoxActivateCursorRow           ,
    onListBoxActivateCursorRow              ,


-- ** moveCursor #signal:moveCursor#

    ListBoxMoveCursorCallback               ,
#if defined(ENABLE_OVERLOADING)
    ListBoxMoveCursorSignalInfo             ,
#endif
    afterListBoxMoveCursor                  ,
    onListBoxMoveCursor                     ,


-- ** rowActivated #signal:rowActivated#

    ListBoxRowActivatedCallback             ,
#if defined(ENABLE_OVERLOADING)
    ListBoxRowActivatedSignalInfo           ,
#endif
    afterListBoxRowActivated                ,
    onListBoxRowActivated                   ,


-- ** rowSelected #signal:rowSelected#

    ListBoxRowSelectedCallback              ,
#if defined(ENABLE_OVERLOADING)
    ListBoxRowSelectedSignalInfo            ,
#endif
    afterListBoxRowSelected                 ,
    onListBoxRowSelected                    ,


-- ** selectAll #signal:selectAll#

    ListBoxSelectAllCallback                ,
#if defined(ENABLE_OVERLOADING)
    ListBoxSelectAllSignalInfo              ,
#endif
    afterListBoxSelectAll                   ,
    onListBoxSelectAll                      ,


-- ** selectedRowsChanged #signal:selectedRowsChanged#

    ListBoxSelectedRowsChangedCallback      ,
#if defined(ENABLE_OVERLOADING)
    ListBoxSelectedRowsChangedSignalInfo    ,
#endif
    afterListBoxSelectedRowsChanged         ,
    onListBoxSelectedRowsChanged            ,


-- ** toggleCursorRow #signal:toggleCursorRow#

    ListBoxToggleCursorRowCallback          ,
#if defined(ENABLE_OVERLOADING)
    ListBoxToggleCursorRowSignalInfo        ,
#endif
    afterListBoxToggleCursorRow             ,
    onListBoxToggleCursorRow                ,


-- ** unselectAll #signal:unselectAll#

    ListBoxUnselectAllCallback              ,
#if defined(ENABLE_OVERLOADING)
    ListBoxUnselectAllSignalInfo            ,
#endif
    afterListBoxUnselectAll                 ,
    onListBoxUnselectAll                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBoxRow as Gtk.ListBoxRow
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListBoxRow as Gtk.ListBoxRow
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ListBox = ListBox (SP.ManagedPtr ListBox)
    deriving (Eq)

instance SP.ManagedPtrNewtype ListBox where
    toManagedPtr (ListBox p) = p

foreign import ccall "gtk_list_box_get_type"
    c_gtk_list_box_get_type :: IO B.Types.GType

instance B.Types.TypedObject ListBox where
    glibType = c_gtk_list_box_get_type

instance B.Types.GObject ListBox

-- | Type class for types which can be safely cast to t'ListBox', for instance with `toListBox`.
class (SP.GObject o, O.IsDescendantOf ListBox o) => IsListBox o
instance (SP.GObject o, O.IsDescendantOf ListBox o) => IsListBox o

instance O.HasParentTypes ListBox
type instance O.ParentTypes ListBox = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'ListBox', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toListBox :: (MIO.MonadIO m, IsListBox o) => o -> m ListBox
toListBox = MIO.liftIO . B.ManagedPtr.unsafeCastTo ListBox

-- | Convert t'ListBox' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ListBox) where
    gvalueGType_ = c_gtk_list_box_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ListBox)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ListBox)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ListBox ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveListBoxMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveListBoxMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveListBoxMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveListBoxMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveListBoxMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveListBoxMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveListBoxMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveListBoxMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveListBoxMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveListBoxMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveListBoxMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveListBoxMethod "append" o = ListBoxAppendMethodInfo
    ResolveListBoxMethod "bindModel" o = ListBoxBindModelMethodInfo
    ResolveListBoxMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveListBoxMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveListBoxMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveListBoxMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveListBoxMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveListBoxMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveListBoxMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveListBoxMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveListBoxMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveListBoxMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveListBoxMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveListBoxMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveListBoxMethod "dragHighlightRow" o = ListBoxDragHighlightRowMethodInfo
    ResolveListBoxMethod "dragUnhighlightRow" o = ListBoxDragUnhighlightRowMethodInfo
    ResolveListBoxMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveListBoxMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveListBoxMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveListBoxMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveListBoxMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveListBoxMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveListBoxMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveListBoxMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveListBoxMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveListBoxMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveListBoxMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveListBoxMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveListBoxMethod "insert" o = ListBoxInsertMethodInfo
    ResolveListBoxMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveListBoxMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveListBoxMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveListBoxMethod "invalidateFilter" o = ListBoxInvalidateFilterMethodInfo
    ResolveListBoxMethod "invalidateHeaders" o = ListBoxInvalidateHeadersMethodInfo
    ResolveListBoxMethod "invalidateSort" o = ListBoxInvalidateSortMethodInfo
    ResolveListBoxMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveListBoxMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveListBoxMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveListBoxMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveListBoxMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveListBoxMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveListBoxMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveListBoxMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveListBoxMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveListBoxMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveListBoxMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveListBoxMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveListBoxMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveListBoxMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveListBoxMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveListBoxMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveListBoxMethod "prepend" o = ListBoxPrependMethodInfo
    ResolveListBoxMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveListBoxMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveListBoxMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveListBoxMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveListBoxMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveListBoxMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveListBoxMethod "remove" o = ListBoxRemoveMethodInfo
    ResolveListBoxMethod "removeAll" o = ListBoxRemoveAllMethodInfo
    ResolveListBoxMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveListBoxMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveListBoxMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveListBoxMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveListBoxMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveListBoxMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveListBoxMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveListBoxMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveListBoxMethod "selectAll" o = ListBoxSelectAllMethodInfo
    ResolveListBoxMethod "selectRow" o = ListBoxSelectRowMethodInfo
    ResolveListBoxMethod "selectedForeach" o = ListBoxSelectedForeachMethodInfo
    ResolveListBoxMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveListBoxMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveListBoxMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveListBoxMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveListBoxMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveListBoxMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveListBoxMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveListBoxMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveListBoxMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveListBoxMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveListBoxMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveListBoxMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveListBoxMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveListBoxMethod "unselectAll" o = ListBoxUnselectAllMethodInfo
    ResolveListBoxMethod "unselectRow" o = ListBoxUnselectRowMethodInfo
    ResolveListBoxMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveListBoxMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveListBoxMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveListBoxMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveListBoxMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveListBoxMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveListBoxMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveListBoxMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveListBoxMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveListBoxMethod "getActivateOnSingleClick" o = ListBoxGetActivateOnSingleClickMethodInfo
    ResolveListBoxMethod "getAdjustment" o = ListBoxGetAdjustmentMethodInfo
    ResolveListBoxMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveListBoxMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveListBoxMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveListBoxMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveListBoxMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveListBoxMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveListBoxMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveListBoxMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveListBoxMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveListBoxMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveListBoxMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveListBoxMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveListBoxMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveListBoxMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveListBoxMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveListBoxMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveListBoxMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveListBoxMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveListBoxMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveListBoxMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveListBoxMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveListBoxMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveListBoxMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveListBoxMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveListBoxMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveListBoxMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveListBoxMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveListBoxMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveListBoxMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveListBoxMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveListBoxMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveListBoxMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveListBoxMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveListBoxMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveListBoxMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveListBoxMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveListBoxMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveListBoxMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveListBoxMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveListBoxMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveListBoxMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveListBoxMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveListBoxMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveListBoxMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveListBoxMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveListBoxMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveListBoxMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveListBoxMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveListBoxMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveListBoxMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveListBoxMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveListBoxMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveListBoxMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveListBoxMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveListBoxMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveListBoxMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveListBoxMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveListBoxMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveListBoxMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveListBoxMethod "getRowAtIndex" o = ListBoxGetRowAtIndexMethodInfo
    ResolveListBoxMethod "getRowAtY" o = ListBoxGetRowAtYMethodInfo
    ResolveListBoxMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveListBoxMethod "getSelectedRow" o = ListBoxGetSelectedRowMethodInfo
    ResolveListBoxMethod "getSelectedRows" o = ListBoxGetSelectedRowsMethodInfo
    ResolveListBoxMethod "getSelectionMode" o = ListBoxGetSelectionModeMethodInfo
    ResolveListBoxMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveListBoxMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveListBoxMethod "getShowSeparators" o = ListBoxGetShowSeparatorsMethodInfo
    ResolveListBoxMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveListBoxMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveListBoxMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveListBoxMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveListBoxMethod "getTabBehavior" o = ListBoxGetTabBehaviorMethodInfo
    ResolveListBoxMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveListBoxMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveListBoxMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveListBoxMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveListBoxMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveListBoxMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveListBoxMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveListBoxMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveListBoxMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveListBoxMethod "setActivateOnSingleClick" o = ListBoxSetActivateOnSingleClickMethodInfo
    ResolveListBoxMethod "setAdjustment" o = ListBoxSetAdjustmentMethodInfo
    ResolveListBoxMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveListBoxMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveListBoxMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveListBoxMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveListBoxMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveListBoxMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveListBoxMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveListBoxMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveListBoxMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveListBoxMethod "setFilterFunc" o = ListBoxSetFilterFuncMethodInfo
    ResolveListBoxMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveListBoxMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveListBoxMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveListBoxMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveListBoxMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveListBoxMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveListBoxMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveListBoxMethod "setHeaderFunc" o = ListBoxSetHeaderFuncMethodInfo
    ResolveListBoxMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveListBoxMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveListBoxMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveListBoxMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveListBoxMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveListBoxMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveListBoxMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveListBoxMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveListBoxMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveListBoxMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveListBoxMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveListBoxMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveListBoxMethod "setPlaceholder" o = ListBoxSetPlaceholderMethodInfo
    ResolveListBoxMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveListBoxMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveListBoxMethod "setSelectionMode" o = ListBoxSetSelectionModeMethodInfo
    ResolveListBoxMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveListBoxMethod "setShowSeparators" o = ListBoxSetShowSeparatorsMethodInfo
    ResolveListBoxMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveListBoxMethod "setSortFunc" o = ListBoxSetSortFuncMethodInfo
    ResolveListBoxMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveListBoxMethod "setTabBehavior" o = ListBoxSetTabBehaviorMethodInfo
    ResolveListBoxMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveListBoxMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveListBoxMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveListBoxMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveListBoxMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveListBoxMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveListBoxMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveListBoxMethod t ListBox, O.OverloadedMethod info ListBox p) => OL.IsLabel t (ListBox -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveListBoxMethod t ListBox, O.OverloadedMethod info ListBox p, R.HasField t ListBox p) => R.HasField t ListBox p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveListBoxMethod t ListBox, O.OverloadedMethodInfo info ListBox) => OL.IsLabel t (O.MethodProxy info ListBox) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ListBox::activate-cursor-row
-- | Emitted when the cursor row is activated.
type ListBoxActivateCursorRowCallback =
    IO ()

type C_ListBoxActivateCursorRowCallback =
    Ptr ListBox ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxActivateCursorRowCallback`.
foreign import ccall "wrapper"
    mk_ListBoxActivateCursorRowCallback :: C_ListBoxActivateCursorRowCallback -> IO (FunPtr C_ListBoxActivateCursorRowCallback)

wrap_ListBoxActivateCursorRowCallback :: 
    GObject a => (a -> ListBoxActivateCursorRowCallback) ->
    C_ListBoxActivateCursorRowCallback
wrap_ListBoxActivateCursorRowCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activateCursorRow](#signal:activateCursorRow) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBox #activateCursorRow callback
-- @
-- 
-- 
onListBoxActivateCursorRow :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxActivateCursorRowCallback) -> m SignalHandlerId
onListBoxActivateCursorRow obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxActivateCursorRowCallback wrapped
    wrapped'' <- mk_ListBoxActivateCursorRowCallback wrapped'
    connectSignalFunPtr obj "activate-cursor-row" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activateCursorRow](#signal:activateCursorRow) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBox #activateCursorRow callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxActivateCursorRow :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxActivateCursorRowCallback) -> m SignalHandlerId
afterListBoxActivateCursorRow obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxActivateCursorRowCallback wrapped
    wrapped'' <- mk_ListBoxActivateCursorRowCallback wrapped'
    connectSignalFunPtr obj "activate-cursor-row" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxActivateCursorRowSignalInfo
instance SignalInfo ListBoxActivateCursorRowSignalInfo where
    type HaskellCallbackType ListBoxActivateCursorRowSignalInfo = ListBoxActivateCursorRowCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxActivateCursorRowCallback cb
        cb'' <- mk_ListBoxActivateCursorRowCallback cb'
        connectSignalFunPtr obj "activate-cursor-row" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox::activate-cursor-row"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:signal:activateCursorRow"})

#endif

-- signal ListBox::move-cursor
-- | Emitted when the user initiates a cursor movement.
-- 
-- The default bindings for this signal come in two variants, the variant with
-- the Shift modifier extends the selection, the variant without the Shift
-- modifier does not. There are too many key combinations to list them all
-- here.
-- 
-- * \<kbd>←\<\/kbd>, \<kbd>→\<\/kbd>, \<kbd>↑\<\/kbd>, \<kbd>↓\<\/kbd>
--   move by individual children
-- * \<kbd>Home\<\/kbd>, \<kbd>End\<\/kbd> move to the ends of the box
-- * \<kbd>PgUp\<\/kbd>, \<kbd>PgDn\<\/kbd> move vertically by pages
type ListBoxMoveCursorCallback =
    Gtk.Enums.MovementStep
    -- ^ /@step@/: the granularity of the move, as a @GtkMovementStep@
    -> Int32
    -- ^ /@count@/: the number of /@step@/ units to move
    -> Bool
    -- ^ /@extend@/: whether to extend the selection
    -> Bool
    -- ^ /@modify@/: whether to modify the selection
    -> IO ()

type C_ListBoxMoveCursorCallback =
    Ptr ListBox ->                          -- object
    CUInt ->
    Int32 ->
    CInt ->
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxMoveCursorCallback`.
foreign import ccall "wrapper"
    mk_ListBoxMoveCursorCallback :: C_ListBoxMoveCursorCallback -> IO (FunPtr C_ListBoxMoveCursorCallback)

wrap_ListBoxMoveCursorCallback :: 
    GObject a => (a -> ListBoxMoveCursorCallback) ->
    C_ListBoxMoveCursorCallback
wrap_ListBoxMoveCursorCallback gi'cb gi'selfPtr step count extend modify _ = do
    let step' = (toEnum . fromIntegral) step
    let extend' = (/= 0) extend
    let modify' = (/= 0) modify
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  step' count extend' modify'


-- | Connect a signal handler for the [moveCursor](#signal:moveCursor) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBox #moveCursor callback
-- @
-- 
-- 
onListBoxMoveCursor :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxMoveCursorCallback) -> m SignalHandlerId
onListBoxMoveCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxMoveCursorCallback wrapped
    wrapped'' <- mk_ListBoxMoveCursorCallback wrapped'
    connectSignalFunPtr obj "move-cursor" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveCursor](#signal:moveCursor) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBox #moveCursor callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxMoveCursor :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxMoveCursorCallback) -> m SignalHandlerId
afterListBoxMoveCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxMoveCursorCallback wrapped
    wrapped'' <- mk_ListBoxMoveCursorCallback wrapped'
    connectSignalFunPtr obj "move-cursor" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxMoveCursorSignalInfo
instance SignalInfo ListBoxMoveCursorSignalInfo where
    type HaskellCallbackType ListBoxMoveCursorSignalInfo = ListBoxMoveCursorCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxMoveCursorCallback cb
        cb'' <- mk_ListBoxMoveCursorCallback cb'
        connectSignalFunPtr obj "move-cursor" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox::move-cursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:signal:moveCursor"})

#endif

-- signal ListBox::row-activated
-- | Emitted when a row has been activated by the user.
type ListBoxRowActivatedCallback =
    Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row@/: the activated row
    -> IO ()

type C_ListBoxRowActivatedCallback =
    Ptr ListBox ->                          -- object
    Ptr Gtk.ListBoxRow.ListBoxRow ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxRowActivatedCallback`.
foreign import ccall "wrapper"
    mk_ListBoxRowActivatedCallback :: C_ListBoxRowActivatedCallback -> IO (FunPtr C_ListBoxRowActivatedCallback)

wrap_ListBoxRowActivatedCallback :: 
    GObject a => (a -> ListBoxRowActivatedCallback) ->
    C_ListBoxRowActivatedCallback
wrap_ListBoxRowActivatedCallback gi'cb gi'selfPtr row _ = do
    row' <- (newObject Gtk.ListBoxRow.ListBoxRow) row
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  row'


-- | Connect a signal handler for the [rowActivated](#signal:rowActivated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBox #rowActivated callback
-- @
-- 
-- 
onListBoxRowActivated :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxRowActivatedCallback) -> m SignalHandlerId
onListBoxRowActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxRowActivatedCallback wrapped
    wrapped'' <- mk_ListBoxRowActivatedCallback wrapped'
    connectSignalFunPtr obj "row-activated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [rowActivated](#signal:rowActivated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBox #rowActivated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxRowActivated :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxRowActivatedCallback) -> m SignalHandlerId
afterListBoxRowActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxRowActivatedCallback wrapped
    wrapped'' <- mk_ListBoxRowActivatedCallback wrapped'
    connectSignalFunPtr obj "row-activated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxRowActivatedSignalInfo
instance SignalInfo ListBoxRowActivatedSignalInfo where
    type HaskellCallbackType ListBoxRowActivatedSignalInfo = ListBoxRowActivatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxRowActivatedCallback cb
        cb'' <- mk_ListBoxRowActivatedCallback cb'
        connectSignalFunPtr obj "row-activated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox::row-activated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:signal:rowActivated"})

#endif

-- signal ListBox::row-selected
-- | Emitted when a new row is selected, or (with a 'P.Nothing' /@row@/)
-- when the selection is cleared.
-- 
-- When the /@box@/ is using 'GI.Gtk.Enums.SelectionModeMultiple', this signal will not
-- give you the full picture of selection changes, and you should use
-- the [ListBox::selectedRowsChanged]("GI.Gtk.Objects.ListBox#g:signal:selectedRowsChanged") signal instead.
type ListBoxRowSelectedCallback =
    Maybe Gtk.ListBoxRow.ListBoxRow
    -- ^ /@row@/: the selected row
    -> IO ()

type C_ListBoxRowSelectedCallback =
    Ptr ListBox ->                          -- object
    Ptr Gtk.ListBoxRow.ListBoxRow ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxRowSelectedCallback`.
foreign import ccall "wrapper"
    mk_ListBoxRowSelectedCallback :: C_ListBoxRowSelectedCallback -> IO (FunPtr C_ListBoxRowSelectedCallback)

wrap_ListBoxRowSelectedCallback :: 
    GObject a => (a -> ListBoxRowSelectedCallback) ->
    C_ListBoxRowSelectedCallback
wrap_ListBoxRowSelectedCallback gi'cb gi'selfPtr row _ = do
    maybeRow <-
        if row == FP.nullPtr
        then return Nothing
        else do
            row' <- (newObject Gtk.ListBoxRow.ListBoxRow) row
            return $ Just row'
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  maybeRow


-- | Connect a signal handler for the [rowSelected](#signal:rowSelected) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBox #rowSelected callback
-- @
-- 
-- 
onListBoxRowSelected :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxRowSelectedCallback) -> m SignalHandlerId
onListBoxRowSelected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxRowSelectedCallback wrapped
    wrapped'' <- mk_ListBoxRowSelectedCallback wrapped'
    connectSignalFunPtr obj "row-selected" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [rowSelected](#signal:rowSelected) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBox #rowSelected callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxRowSelected :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxRowSelectedCallback) -> m SignalHandlerId
afterListBoxRowSelected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxRowSelectedCallback wrapped
    wrapped'' <- mk_ListBoxRowSelectedCallback wrapped'
    connectSignalFunPtr obj "row-selected" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxRowSelectedSignalInfo
instance SignalInfo ListBoxRowSelectedSignalInfo where
    type HaskellCallbackType ListBoxRowSelectedSignalInfo = ListBoxRowSelectedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxRowSelectedCallback cb
        cb'' <- mk_ListBoxRowSelectedCallback cb'
        connectSignalFunPtr obj "row-selected" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox::row-selected"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:signal:rowSelected"})

#endif

-- signal ListBox::select-all
-- | Emitted to select all children of the box, if the selection
-- mode permits it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>Ctrl\<\/kbd>-\<kbd>a\<\/kbd>.
type ListBoxSelectAllCallback =
    IO ()

type C_ListBoxSelectAllCallback =
    Ptr ListBox ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxSelectAllCallback`.
foreign import ccall "wrapper"
    mk_ListBoxSelectAllCallback :: C_ListBoxSelectAllCallback -> IO (FunPtr C_ListBoxSelectAllCallback)

wrap_ListBoxSelectAllCallback :: 
    GObject a => (a -> ListBoxSelectAllCallback) ->
    C_ListBoxSelectAllCallback
wrap_ListBoxSelectAllCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [selectAll](#signal:selectAll) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBox #selectAll callback
-- @
-- 
-- 
onListBoxSelectAll :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxSelectAllCallback) -> m SignalHandlerId
onListBoxSelectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxSelectAllCallback wrapped
    wrapped'' <- mk_ListBoxSelectAllCallback wrapped'
    connectSignalFunPtr obj "select-all" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [selectAll](#signal:selectAll) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBox #selectAll callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxSelectAll :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxSelectAllCallback) -> m SignalHandlerId
afterListBoxSelectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxSelectAllCallback wrapped
    wrapped'' <- mk_ListBoxSelectAllCallback wrapped'
    connectSignalFunPtr obj "select-all" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxSelectAllSignalInfo
instance SignalInfo ListBoxSelectAllSignalInfo where
    type HaskellCallbackType ListBoxSelectAllSignalInfo = ListBoxSelectAllCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxSelectAllCallback cb
        cb'' <- mk_ListBoxSelectAllCallback cb'
        connectSignalFunPtr obj "select-all" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox::select-all"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:signal:selectAll"})

#endif

-- signal ListBox::selected-rows-changed
-- | Emitted when the set of selected rows changes.
type ListBoxSelectedRowsChangedCallback =
    IO ()

type C_ListBoxSelectedRowsChangedCallback =
    Ptr ListBox ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxSelectedRowsChangedCallback`.
foreign import ccall "wrapper"
    mk_ListBoxSelectedRowsChangedCallback :: C_ListBoxSelectedRowsChangedCallback -> IO (FunPtr C_ListBoxSelectedRowsChangedCallback)

wrap_ListBoxSelectedRowsChangedCallback :: 
    GObject a => (a -> ListBoxSelectedRowsChangedCallback) ->
    C_ListBoxSelectedRowsChangedCallback
wrap_ListBoxSelectedRowsChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [selectedRowsChanged](#signal:selectedRowsChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBox #selectedRowsChanged callback
-- @
-- 
-- 
onListBoxSelectedRowsChanged :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxSelectedRowsChangedCallback) -> m SignalHandlerId
onListBoxSelectedRowsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxSelectedRowsChangedCallback wrapped
    wrapped'' <- mk_ListBoxSelectedRowsChangedCallback wrapped'
    connectSignalFunPtr obj "selected-rows-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [selectedRowsChanged](#signal:selectedRowsChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBox #selectedRowsChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxSelectedRowsChanged :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxSelectedRowsChangedCallback) -> m SignalHandlerId
afterListBoxSelectedRowsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxSelectedRowsChangedCallback wrapped
    wrapped'' <- mk_ListBoxSelectedRowsChangedCallback wrapped'
    connectSignalFunPtr obj "selected-rows-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxSelectedRowsChangedSignalInfo
instance SignalInfo ListBoxSelectedRowsChangedSignalInfo where
    type HaskellCallbackType ListBoxSelectedRowsChangedSignalInfo = ListBoxSelectedRowsChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxSelectedRowsChangedCallback cb
        cb'' <- mk_ListBoxSelectedRowsChangedCallback cb'
        connectSignalFunPtr obj "selected-rows-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox::selected-rows-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:signal:selectedRowsChanged"})

#endif

-- signal ListBox::toggle-cursor-row
-- | Emitted when the cursor row is toggled.
-- 
-- The default bindings for this signal is \<kbd>Ctrl\<\/kbd>+\<kbd>␣\<\/kbd>.
type ListBoxToggleCursorRowCallback =
    IO ()

type C_ListBoxToggleCursorRowCallback =
    Ptr ListBox ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxToggleCursorRowCallback`.
foreign import ccall "wrapper"
    mk_ListBoxToggleCursorRowCallback :: C_ListBoxToggleCursorRowCallback -> IO (FunPtr C_ListBoxToggleCursorRowCallback)

wrap_ListBoxToggleCursorRowCallback :: 
    GObject a => (a -> ListBoxToggleCursorRowCallback) ->
    C_ListBoxToggleCursorRowCallback
wrap_ListBoxToggleCursorRowCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [toggleCursorRow](#signal:toggleCursorRow) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBox #toggleCursorRow callback
-- @
-- 
-- 
onListBoxToggleCursorRow :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxToggleCursorRowCallback) -> m SignalHandlerId
onListBoxToggleCursorRow obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxToggleCursorRowCallback wrapped
    wrapped'' <- mk_ListBoxToggleCursorRowCallback wrapped'
    connectSignalFunPtr obj "toggle-cursor-row" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toggleCursorRow](#signal:toggleCursorRow) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBox #toggleCursorRow callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxToggleCursorRow :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxToggleCursorRowCallback) -> m SignalHandlerId
afterListBoxToggleCursorRow obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxToggleCursorRowCallback wrapped
    wrapped'' <- mk_ListBoxToggleCursorRowCallback wrapped'
    connectSignalFunPtr obj "toggle-cursor-row" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxToggleCursorRowSignalInfo
instance SignalInfo ListBoxToggleCursorRowSignalInfo where
    type HaskellCallbackType ListBoxToggleCursorRowSignalInfo = ListBoxToggleCursorRowCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxToggleCursorRowCallback cb
        cb'' <- mk_ListBoxToggleCursorRowCallback cb'
        connectSignalFunPtr obj "toggle-cursor-row" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox::toggle-cursor-row"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:signal:toggleCursorRow"})

#endif

-- signal ListBox::unselect-all
-- | Emitted to unselect all children of the box, if the selection
-- mode permits it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is
-- \<kbd>Ctrl\<\/kbd>-\<kbd>Shift\<\/kbd>-\<kbd>a\<\/kbd>.
type ListBoxUnselectAllCallback =
    IO ()

type C_ListBoxUnselectAllCallback =
    Ptr ListBox ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ListBoxUnselectAllCallback`.
foreign import ccall "wrapper"
    mk_ListBoxUnselectAllCallback :: C_ListBoxUnselectAllCallback -> IO (FunPtr C_ListBoxUnselectAllCallback)

wrap_ListBoxUnselectAllCallback :: 
    GObject a => (a -> ListBoxUnselectAllCallback) ->
    C_ListBoxUnselectAllCallback
wrap_ListBoxUnselectAllCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [unselectAll](#signal:unselectAll) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' listBox #unselectAll callback
-- @
-- 
-- 
onListBoxUnselectAll :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxUnselectAllCallback) -> m SignalHandlerId
onListBoxUnselectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxUnselectAllCallback wrapped
    wrapped'' <- mk_ListBoxUnselectAllCallback wrapped'
    connectSignalFunPtr obj "unselect-all" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [unselectAll](#signal:unselectAll) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' listBox #unselectAll callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterListBoxUnselectAll :: (IsListBox a, MonadIO m) => a -> ((?self :: a) => ListBoxUnselectAllCallback) -> m SignalHandlerId
afterListBoxUnselectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ListBoxUnselectAllCallback wrapped
    wrapped'' <- mk_ListBoxUnselectAllCallback wrapped'
    connectSignalFunPtr obj "unselect-all" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ListBoxUnselectAllSignalInfo
instance SignalInfo ListBoxUnselectAllSignalInfo where
    type HaskellCallbackType ListBoxUnselectAllSignalInfo = ListBoxUnselectAllCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ListBoxUnselectAllCallback cb
        cb'' <- mk_ListBoxUnselectAllCallback cb'
        connectSignalFunPtr obj "unselect-all" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox::unselect-all"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:signal:unselectAll"})

#endif

-- VVV Prop "accept-unpaired-release"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accept-unpaired-release@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listBox #acceptUnpairedRelease
-- @
getListBoxAcceptUnpairedRelease :: (MonadIO m, IsListBox o) => o -> m Bool
getListBoxAcceptUnpairedRelease obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "accept-unpaired-release"

-- | Set the value of the “@accept-unpaired-release@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listBox [ #acceptUnpairedRelease 'Data.GI.Base.Attributes.:=' value ]
-- @
setListBoxAcceptUnpairedRelease :: (MonadIO m, IsListBox o) => o -> Bool -> m ()
setListBoxAcceptUnpairedRelease obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "accept-unpaired-release" val

-- | Construct a t'GValueConstruct' with valid value for the “@accept-unpaired-release@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListBoxAcceptUnpairedRelease :: (IsListBox o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructListBoxAcceptUnpairedRelease val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "accept-unpaired-release" val

#if defined(ENABLE_OVERLOADING)
data ListBoxAcceptUnpairedReleasePropertyInfo
instance AttrInfo ListBoxAcceptUnpairedReleasePropertyInfo where
    type AttrAllowedOps ListBoxAcceptUnpairedReleasePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ListBoxAcceptUnpairedReleasePropertyInfo = IsListBox
    type AttrSetTypeConstraint ListBoxAcceptUnpairedReleasePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ListBoxAcceptUnpairedReleasePropertyInfo = (~) Bool
    type AttrTransferType ListBoxAcceptUnpairedReleasePropertyInfo = Bool
    type AttrGetType ListBoxAcceptUnpairedReleasePropertyInfo = Bool
    type AttrLabel ListBoxAcceptUnpairedReleasePropertyInfo = "accept-unpaired-release"
    type AttrOrigin ListBoxAcceptUnpairedReleasePropertyInfo = ListBox
    attrGet = getListBoxAcceptUnpairedRelease
    attrSet = setListBoxAcceptUnpairedRelease
    attrPut = setListBoxAcceptUnpairedRelease
    attrTransfer _ v = do
        return v
    attrConstruct = constructListBoxAcceptUnpairedRelease
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.acceptUnpairedRelease"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:attr:acceptUnpairedRelease"
        })
#endif

-- VVV Prop "activate-on-single-click"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@activate-on-single-click@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listBox #activateOnSingleClick
-- @
getListBoxActivateOnSingleClick :: (MonadIO m, IsListBox o) => o -> m Bool
getListBoxActivateOnSingleClick obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "activate-on-single-click"

-- | Set the value of the “@activate-on-single-click@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listBox [ #activateOnSingleClick 'Data.GI.Base.Attributes.:=' value ]
-- @
setListBoxActivateOnSingleClick :: (MonadIO m, IsListBox o) => o -> Bool -> m ()
setListBoxActivateOnSingleClick obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "activate-on-single-click" val

-- | Construct a t'GValueConstruct' with valid value for the “@activate-on-single-click@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListBoxActivateOnSingleClick :: (IsListBox o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructListBoxActivateOnSingleClick val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "activate-on-single-click" val

#if defined(ENABLE_OVERLOADING)
data ListBoxActivateOnSingleClickPropertyInfo
instance AttrInfo ListBoxActivateOnSingleClickPropertyInfo where
    type AttrAllowedOps ListBoxActivateOnSingleClickPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ListBoxActivateOnSingleClickPropertyInfo = IsListBox
    type AttrSetTypeConstraint ListBoxActivateOnSingleClickPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ListBoxActivateOnSingleClickPropertyInfo = (~) Bool
    type AttrTransferType ListBoxActivateOnSingleClickPropertyInfo = Bool
    type AttrGetType ListBoxActivateOnSingleClickPropertyInfo = Bool
    type AttrLabel ListBoxActivateOnSingleClickPropertyInfo = "activate-on-single-click"
    type AttrOrigin ListBoxActivateOnSingleClickPropertyInfo = ListBox
    attrGet = getListBoxActivateOnSingleClick
    attrSet = setListBoxActivateOnSingleClick
    attrPut = setListBoxActivateOnSingleClick
    attrTransfer _ v = do
        return v
    attrConstruct = constructListBoxActivateOnSingleClick
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.activateOnSingleClick"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:attr:activateOnSingleClick"
        })
#endif

-- VVV Prop "selection-mode"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SelectionMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@selection-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listBox #selectionMode
-- @
getListBoxSelectionMode :: (MonadIO m, IsListBox o) => o -> m Gtk.Enums.SelectionMode
getListBoxSelectionMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "selection-mode"

-- | Set the value of the “@selection-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listBox [ #selectionMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setListBoxSelectionMode :: (MonadIO m, IsListBox o) => o -> Gtk.Enums.SelectionMode -> m ()
setListBoxSelectionMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "selection-mode" val

-- | Construct a t'GValueConstruct' with valid value for the “@selection-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListBoxSelectionMode :: (IsListBox o, MIO.MonadIO m) => Gtk.Enums.SelectionMode -> m (GValueConstruct o)
constructListBoxSelectionMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "selection-mode" val

#if defined(ENABLE_OVERLOADING)
data ListBoxSelectionModePropertyInfo
instance AttrInfo ListBoxSelectionModePropertyInfo where
    type AttrAllowedOps ListBoxSelectionModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ListBoxSelectionModePropertyInfo = IsListBox
    type AttrSetTypeConstraint ListBoxSelectionModePropertyInfo = (~) Gtk.Enums.SelectionMode
    type AttrTransferTypeConstraint ListBoxSelectionModePropertyInfo = (~) Gtk.Enums.SelectionMode
    type AttrTransferType ListBoxSelectionModePropertyInfo = Gtk.Enums.SelectionMode
    type AttrGetType ListBoxSelectionModePropertyInfo = Gtk.Enums.SelectionMode
    type AttrLabel ListBoxSelectionModePropertyInfo = "selection-mode"
    type AttrOrigin ListBoxSelectionModePropertyInfo = ListBox
    attrGet = getListBoxSelectionMode
    attrSet = setListBoxSelectionMode
    attrPut = setListBoxSelectionMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructListBoxSelectionMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.selectionMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:attr:selectionMode"
        })
#endif

-- VVV Prop "show-separators"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-separators@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listBox #showSeparators
-- @
getListBoxShowSeparators :: (MonadIO m, IsListBox o) => o -> m Bool
getListBoxShowSeparators obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-separators"

-- | Set the value of the “@show-separators@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listBox [ #showSeparators 'Data.GI.Base.Attributes.:=' value ]
-- @
setListBoxShowSeparators :: (MonadIO m, IsListBox o) => o -> Bool -> m ()
setListBoxShowSeparators obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-separators" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-separators@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListBoxShowSeparators :: (IsListBox o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructListBoxShowSeparators val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-separators" val

#if defined(ENABLE_OVERLOADING)
data ListBoxShowSeparatorsPropertyInfo
instance AttrInfo ListBoxShowSeparatorsPropertyInfo where
    type AttrAllowedOps ListBoxShowSeparatorsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ListBoxShowSeparatorsPropertyInfo = IsListBox
    type AttrSetTypeConstraint ListBoxShowSeparatorsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ListBoxShowSeparatorsPropertyInfo = (~) Bool
    type AttrTransferType ListBoxShowSeparatorsPropertyInfo = Bool
    type AttrGetType ListBoxShowSeparatorsPropertyInfo = Bool
    type AttrLabel ListBoxShowSeparatorsPropertyInfo = "show-separators"
    type AttrOrigin ListBoxShowSeparatorsPropertyInfo = ListBox
    attrGet = getListBoxShowSeparators
    attrSet = setListBoxShowSeparators
    attrPut = setListBoxShowSeparators
    attrTransfer _ v = do
        return v
    attrConstruct = constructListBoxShowSeparators
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.showSeparators"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:attr:showSeparators"
        })
#endif

-- VVV Prop "tab-behavior"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListTabBehavior"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@tab-behavior@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' listBox #tabBehavior
-- @
getListBoxTabBehavior :: (MonadIO m, IsListBox o) => o -> m Gtk.Enums.ListTabBehavior
getListBoxTabBehavior obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "tab-behavior"

-- | Set the value of the “@tab-behavior@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' listBox [ #tabBehavior 'Data.GI.Base.Attributes.:=' value ]
-- @
setListBoxTabBehavior :: (MonadIO m, IsListBox o) => o -> Gtk.Enums.ListTabBehavior -> m ()
setListBoxTabBehavior obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "tab-behavior" val

-- | Construct a t'GValueConstruct' with valid value for the “@tab-behavior@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructListBoxTabBehavior :: (IsListBox o, MIO.MonadIO m) => Gtk.Enums.ListTabBehavior -> m (GValueConstruct o)
constructListBoxTabBehavior val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "tab-behavior" val

#if defined(ENABLE_OVERLOADING)
data ListBoxTabBehaviorPropertyInfo
instance AttrInfo ListBoxTabBehaviorPropertyInfo where
    type AttrAllowedOps ListBoxTabBehaviorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ListBoxTabBehaviorPropertyInfo = IsListBox
    type AttrSetTypeConstraint ListBoxTabBehaviorPropertyInfo = (~) Gtk.Enums.ListTabBehavior
    type AttrTransferTypeConstraint ListBoxTabBehaviorPropertyInfo = (~) Gtk.Enums.ListTabBehavior
    type AttrTransferType ListBoxTabBehaviorPropertyInfo = Gtk.Enums.ListTabBehavior
    type AttrGetType ListBoxTabBehaviorPropertyInfo = Gtk.Enums.ListTabBehavior
    type AttrLabel ListBoxTabBehaviorPropertyInfo = "tab-behavior"
    type AttrOrigin ListBoxTabBehaviorPropertyInfo = ListBox
    attrGet = getListBoxTabBehavior
    attrSet = setListBoxTabBehavior
    attrPut = setListBoxTabBehavior
    attrTransfer _ v = do
        return v
    attrConstruct = constructListBoxTabBehavior
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.tabBehavior"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#g:attr:tabBehavior"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ListBox
type instance O.AttributeList ListBox = ListBoxAttributeList
type ListBoxAttributeList = ('[ '("acceptUnpairedRelease", ListBoxAcceptUnpairedReleasePropertyInfo), '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("activateOnSingleClick", ListBoxActivateOnSingleClickPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("selectionMode", ListBoxSelectionModePropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showSeparators", ListBoxShowSeparatorsPropertyInfo), '("tabBehavior", ListBoxTabBehaviorPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
listBoxAcceptUnpairedRelease :: AttrLabelProxy "acceptUnpairedRelease"
listBoxAcceptUnpairedRelease = AttrLabelProxy

listBoxActivateOnSingleClick :: AttrLabelProxy "activateOnSingleClick"
listBoxActivateOnSingleClick = AttrLabelProxy

listBoxSelectionMode :: AttrLabelProxy "selectionMode"
listBoxSelectionMode = AttrLabelProxy

listBoxShowSeparators :: AttrLabelProxy "showSeparators"
listBoxShowSeparators = AttrLabelProxy

listBoxTabBehavior :: AttrLabelProxy "tabBehavior"
listBoxTabBehavior = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ListBox = ListBoxSignalList
type ListBoxSignalList = ('[ '("activateCursorRow", ListBoxActivateCursorRowSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveCursor", ListBoxMoveCursorSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("rowActivated", ListBoxRowActivatedSignalInfo), '("rowSelected", ListBoxRowSelectedSignalInfo), '("selectAll", ListBoxSelectAllSignalInfo), '("selectedRowsChanged", ListBoxSelectedRowsChangedSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("toggleCursorRow", ListBoxToggleCursorRowSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo), '("unselectAll", ListBoxUnselectAllSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ListBox::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ListBox" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_new" gtk_list_box_new :: 
    IO (Ptr ListBox)

-- | Creates a new @GtkListBox@ container.
listBoxNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ListBox
    -- ^ __Returns:__ a new @GtkListBox@
listBoxNew  = liftIO $ do
    result <- gtk_list_box_new
    checkUnexpectedReturnNULL "listBoxNew" result
    result' <- (newObject ListBox) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ListBox::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkWidget` to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_append" gtk_list_box_append :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Append a widget to the list.
-- 
-- If a sort function is set, the widget will
-- actually be inserted at the calculated position.
listBoxAppend ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to add
    -> m ()
listBoxAppend box child = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    child' <- unsafeManagedPtrCastPtr child
    gtk_list_box_append box' child'
    touchManagedPtr box
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxAppendMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ListBoxAppendMethodInfo a signature where
    overloadedMethod = listBoxAppend

instance O.OverloadedMethodInfo ListBoxAppendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxAppend"
        })


#endif

-- method ListBox::bind_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GListModel` to be bound to @box"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "create_widget_func"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "ListBoxCreateWidgetFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a function\n  that creates widgets for items or %NULL in case you also passed %NULL as @model"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @create_widget_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data_free_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function for freeing @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_bind_model" gtk_list_box_bind_model :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    FunPtr Gtk.Callbacks.C_ListBoxCreateWidgetFunc -> -- create_widget_func : TInterface (Name {namespace = "Gtk", name = "ListBoxCreateWidgetFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_data_free_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Binds /@model@/ to /@box@/.
-- 
-- If /@box@/ was already bound to a model, that previous binding is
-- destroyed.
-- 
-- The contents of /@box@/ are cleared and then filled with widgets that
-- represent items from /@model@/. /@box@/ is updated whenever /@model@/ changes.
-- If /@model@/ is 'P.Nothing', /@box@/ is left empty.
-- 
-- It is undefined to add or remove widgets directly (for example, with
-- 'GI.Gtk.Objects.ListBox.listBoxInsert') while /@box@/ is bound to a model.
-- 
-- Note that using a model is incompatible with the filtering and sorting
-- functionality in @GtkListBox@. When using a model, filtering and sorting
-- should be implemented by the model.
listBoxBindModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gio.ListModel.IsListModel b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Maybe (b)
    -- ^ /@model@/: the @GListModel@ to be bound to /@box@/
    -> Maybe (Gtk.Callbacks.ListBoxCreateWidgetFunc)
    -- ^ /@createWidgetFunc@/: a function
    --   that creates widgets for items or 'P.Nothing' in case you also passed 'P.Nothing' as /@model@/
    -> m ()
listBoxBindModel box model createWidgetFunc = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    maybeCreateWidgetFunc <- case createWidgetFunc of
        Nothing -> return FP.nullFunPtr
        Just jCreateWidgetFunc -> do
            jCreateWidgetFunc' <- Gtk.Callbacks.mk_ListBoxCreateWidgetFunc (Gtk.Callbacks.wrap_ListBoxCreateWidgetFunc Nothing (Gtk.Callbacks.drop_closures_ListBoxCreateWidgetFunc jCreateWidgetFunc))
            return jCreateWidgetFunc'
    let userData = castFunPtrToPtr maybeCreateWidgetFunc
    let userDataFreeFunc = SP.safeFreeFunPtrPtr
    gtk_list_box_bind_model box' maybeModel maybeCreateWidgetFunc userData userDataFreeFunc
    touchManagedPtr box
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxBindModelMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gtk.Callbacks.ListBoxCreateWidgetFunc) -> m ()), MonadIO m, IsListBox a, Gio.ListModel.IsListModel b) => O.OverloadedMethod ListBoxBindModelMethodInfo a signature where
    overloadedMethod = listBoxBindModel

instance O.OverloadedMethodInfo ListBoxBindModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxBindModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxBindModel"
        })


#endif

-- method ListBox::drag_highlight_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBoxRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_drag_highlight_row" gtk_list_box_drag_highlight_row :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.ListBoxRow.ListBoxRow ->        -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO ()

-- | Add a drag highlight to a row.
-- 
-- This is a helper function for implementing DnD onto a @GtkListBox@.
-- The passed in /@row@/ will be highlighted by setting the
-- 'GI.Gtk.Flags.StateFlagsDropActive' state and any previously highlighted
-- row will be unhighlighted.
-- 
-- The row will also be unhighlighted when the widget gets
-- a drag leave event.
listBoxDragHighlightRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.ListBoxRow.IsListBoxRow b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> b
    -- ^ /@row@/: a @GtkListBoxRow@
    -> m ()
listBoxDragHighlightRow box row = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    row' <- unsafeManagedPtrCastPtr row
    gtk_list_box_drag_highlight_row box' row'
    touchManagedPtr box
    touchManagedPtr row
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxDragHighlightRowMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsListBox a, Gtk.ListBoxRow.IsListBoxRow b) => O.OverloadedMethod ListBoxDragHighlightRowMethodInfo a signature where
    overloadedMethod = listBoxDragHighlightRow

instance O.OverloadedMethodInfo ListBoxDragHighlightRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxDragHighlightRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxDragHighlightRow"
        })


#endif

-- method ListBox::drag_unhighlight_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_drag_unhighlight_row" gtk_list_box_drag_unhighlight_row :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO ()

-- | If a row has previously been highlighted via 'GI.Gtk.Objects.ListBox.listBoxDragHighlightRow',
-- it will have the highlight removed.
listBoxDragUnhighlightRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m ()
listBoxDragUnhighlightRow box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    gtk_list_box_drag_unhighlight_row box'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxDragUnhighlightRowMethodInfo
instance (signature ~ (m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxDragUnhighlightRowMethodInfo a signature where
    overloadedMethod = listBoxDragUnhighlightRow

instance O.OverloadedMethodInfo ListBoxDragUnhighlightRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxDragUnhighlightRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxDragUnhighlightRow"
        })


#endif

-- method ListBox::get_activate_on_single_click
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_activate_on_single_click" gtk_list_box_get_activate_on_single_click :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO CInt

-- | Returns whether rows activate on single clicks.
listBoxGetActivateOnSingleClick ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if rows are activated on single click, 'P.False' otherwise
listBoxGetActivateOnSingleClick box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_activate_on_single_click box'
    let result' = (/= 0) result
    touchManagedPtr box
    return result'

#if defined(ENABLE_OVERLOADING)
data ListBoxGetActivateOnSingleClickMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetActivateOnSingleClickMethodInfo a signature where
    overloadedMethod = listBoxGetActivateOnSingleClick

instance O.OverloadedMethodInfo ListBoxGetActivateOnSingleClickMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetActivateOnSingleClick",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetActivateOnSingleClick"
        })


#endif

-- method ListBox::get_adjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Adjustment" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_adjustment" gtk_list_box_get_adjustment :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO (Ptr Gtk.Adjustment.Adjustment)

-- | Gets the adjustment (if any) that the widget uses to
-- for vertical scrolling.
listBoxGetAdjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m (Maybe Gtk.Adjustment.Adjustment)
    -- ^ __Returns:__ the adjustment
listBoxGetAdjustment box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_adjustment box'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Adjustment.Adjustment) result'
        return result''
    touchManagedPtr box
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListBoxGetAdjustmentMethodInfo
instance (signature ~ (m (Maybe Gtk.Adjustment.Adjustment)), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetAdjustmentMethodInfo a signature where
    overloadedMethod = listBoxGetAdjustment

instance O.OverloadedMethodInfo ListBoxGetAdjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetAdjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetAdjustment"
        })


#endif

-- method ListBox::get_row_at_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of the row"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ListBoxRow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_row_at_index" gtk_list_box_get_row_at_index :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Int32 ->                                -- index_ : TBasicType TInt
    IO (Ptr Gtk.ListBoxRow.ListBoxRow)

-- | Gets the n-th child in the list (not counting headers).
-- 
-- If /@index_@/ is negative or larger than the number of items in the
-- list, 'P.Nothing' is returned.
listBoxGetRowAtIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Int32
    -- ^ /@index_@/: the index of the row
    -> m (Maybe Gtk.ListBoxRow.ListBoxRow)
    -- ^ __Returns:__ the child @GtkWidget@
listBoxGetRowAtIndex box index_ = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_row_at_index box' index_
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListBoxRow.ListBoxRow) result'
        return result''
    touchManagedPtr box
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListBoxGetRowAtIndexMethodInfo
instance (signature ~ (Int32 -> m (Maybe Gtk.ListBoxRow.ListBoxRow)), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetRowAtIndexMethodInfo a signature where
    overloadedMethod = listBoxGetRowAtIndex

instance O.OverloadedMethodInfo ListBoxGetRowAtIndexMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetRowAtIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetRowAtIndex"
        })


#endif

-- method ListBox::get_row_at_y
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "position" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ListBoxRow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_row_at_y" gtk_list_box_get_row_at_y :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Int32 ->                                -- y : TBasicType TInt
    IO (Ptr Gtk.ListBoxRow.ListBoxRow)

-- | Gets the row at the /@y@/ position.
listBoxGetRowAtY ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Int32
    -- ^ /@y@/: position
    -> m (Maybe Gtk.ListBoxRow.ListBoxRow)
    -- ^ __Returns:__ the row
listBoxGetRowAtY box y = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_row_at_y box' y
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListBoxRow.ListBoxRow) result'
        return result''
    touchManagedPtr box
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListBoxGetRowAtYMethodInfo
instance (signature ~ (Int32 -> m (Maybe Gtk.ListBoxRow.ListBoxRow)), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetRowAtYMethodInfo a signature where
    overloadedMethod = listBoxGetRowAtY

instance O.OverloadedMethodInfo ListBoxGetRowAtYMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetRowAtY",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetRowAtY"
        })


#endif

-- method ListBox::get_selected_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ListBoxRow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_selected_row" gtk_list_box_get_selected_row :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO (Ptr Gtk.ListBoxRow.ListBoxRow)

-- | Gets the selected row, or 'P.Nothing' if no rows are selected.
-- 
-- Note that the box may allow multiple selection, in which
-- case you should use 'GI.Gtk.Objects.ListBox.listBoxSelectedForeach' to
-- find all selected rows.
listBoxGetSelectedRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m (Maybe Gtk.ListBoxRow.ListBoxRow)
    -- ^ __Returns:__ the selected row
listBoxGetSelectedRow box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_selected_row box'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListBoxRow.ListBoxRow) result'
        return result''
    touchManagedPtr box
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ListBoxGetSelectedRowMethodInfo
instance (signature ~ (m (Maybe Gtk.ListBoxRow.ListBoxRow)), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetSelectedRowMethodInfo a signature where
    overloadedMethod = listBoxGetSelectedRow

instance O.OverloadedMethodInfo ListBoxGetSelectedRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetSelectedRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetSelectedRow"
        })


#endif

-- method ListBox::get_selected_rows
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_selected_rows" gtk_list_box_get_selected_rows :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO (Ptr (GList (Ptr Gtk.ListBoxRow.ListBoxRow)))

-- | Creates a list of all selected children.
listBoxGetSelectedRows ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m [Gtk.ListBoxRow.ListBoxRow]
    -- ^ __Returns:__ 
    --   A @GList@ containing the @GtkWidget@ for each selected child.
    --   Free with @/g_list_free()/@ when done.
listBoxGetSelectedRows box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_selected_rows box'
    result' <- unpackGList result
    result'' <- mapM (newObject Gtk.ListBoxRow.ListBoxRow) result'
    g_list_free result
    touchManagedPtr box
    return result''

#if defined(ENABLE_OVERLOADING)
data ListBoxGetSelectedRowsMethodInfo
instance (signature ~ (m [Gtk.ListBoxRow.ListBoxRow]), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetSelectedRowsMethodInfo a signature where
    overloadedMethod = listBoxGetSelectedRows

instance O.OverloadedMethodInfo ListBoxGetSelectedRowsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetSelectedRows",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetSelectedRows"
        })


#endif

-- method ListBox::get_selection_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SelectionMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_selection_mode" gtk_list_box_get_selection_mode :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO CUInt

-- | Gets the selection mode of the listbox.
listBoxGetSelectionMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m Gtk.Enums.SelectionMode
    -- ^ __Returns:__ a @GtkSelectionMode@
listBoxGetSelectionMode box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_selection_mode box'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr box
    return result'

#if defined(ENABLE_OVERLOADING)
data ListBoxGetSelectionModeMethodInfo
instance (signature ~ (m Gtk.Enums.SelectionMode), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetSelectionModeMethodInfo a signature where
    overloadedMethod = listBoxGetSelectionMode

instance O.OverloadedMethodInfo ListBoxGetSelectionModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetSelectionMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetSelectionMode"
        })


#endif

-- method ListBox::get_show_separators
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_show_separators" gtk_list_box_get_show_separators :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO CInt

-- | Returns whether the list box should show separators
-- between rows.
listBoxGetShowSeparators ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the list box shows separators
listBoxGetShowSeparators box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_show_separators box'
    let result' = (/= 0) result
    touchManagedPtr box
    return result'

#if defined(ENABLE_OVERLOADING)
data ListBoxGetShowSeparatorsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetShowSeparatorsMethodInfo a signature where
    overloadedMethod = listBoxGetShowSeparators

instance O.OverloadedMethodInfo ListBoxGetShowSeparatorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetShowSeparators",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetShowSeparators"
        })


#endif

-- method ListBox::get_tab_behavior
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListTabBehavior" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_get_tab_behavior" gtk_list_box_get_tab_behavior :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO CUInt

-- | Returns the behavior of the \<kbd>Tab\<\/kbd> and \<kbd>Shift\<\/kbd>+\<kbd>Tab\<\/kbd> keys.
-- 
-- /Since: 4.18/
listBoxGetTabBehavior ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m Gtk.Enums.ListTabBehavior
    -- ^ __Returns:__ the tab behavior
listBoxGetTabBehavior box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    result <- gtk_list_box_get_tab_behavior box'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr box
    return result'

#if defined(ENABLE_OVERLOADING)
data ListBoxGetTabBehaviorMethodInfo
instance (signature ~ (m Gtk.Enums.ListTabBehavior), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxGetTabBehaviorMethodInfo a signature where
    overloadedMethod = listBoxGetTabBehavior

instance O.OverloadedMethodInfo ListBoxGetTabBehaviorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxGetTabBehavior",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxGetTabBehavior"
        })


#endif

-- method ListBox::insert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkWidget` to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position to insert @child in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_insert" gtk_list_box_insert :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- position : TBasicType TInt
    IO ()

-- | Insert the /@child@/ into the /@box@/ at /@position@/.
-- 
-- If a sort function is
-- set, the widget will actually be inserted at the calculated position.
-- 
-- If /@position@/ is -1, or larger than the total number of items in the
-- /@box@/, then the /@child@/ will be appended to the end.
listBoxInsert ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to add
    -> Int32
    -- ^ /@position@/: the position to insert /@child@/ in
    -> m ()
listBoxInsert box child position = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    child' <- unsafeManagedPtrCastPtr child
    gtk_list_box_insert box' child' position
    touchManagedPtr box
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxInsertMethodInfo
instance (signature ~ (b -> Int32 -> m ()), MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ListBoxInsertMethodInfo a signature where
    overloadedMethod = listBoxInsert

instance O.OverloadedMethodInfo ListBoxInsertMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxInsert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxInsert"
        })


#endif

-- method ListBox::invalidate_filter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_invalidate_filter" gtk_list_box_invalidate_filter :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO ()

-- | Update the filtering for all rows.
-- 
-- Call this when result
-- of the filter function on the /@box@/ is changed due
-- to an external factor. For instance, this would be used
-- if the filter function just looked for a specific search
-- string and the entry with the search string has changed.
listBoxInvalidateFilter ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m ()
listBoxInvalidateFilter box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    gtk_list_box_invalidate_filter box'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxInvalidateFilterMethodInfo
instance (signature ~ (m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxInvalidateFilterMethodInfo a signature where
    overloadedMethod = listBoxInvalidateFilter

instance O.OverloadedMethodInfo ListBoxInvalidateFilterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxInvalidateFilter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxInvalidateFilter"
        })


#endif

-- method ListBox::invalidate_headers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_invalidate_headers" gtk_list_box_invalidate_headers :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO ()

-- | Update the separators for all rows.
-- 
-- Call this when result
-- of the header function on the /@box@/ is changed due
-- to an external factor.
listBoxInvalidateHeaders ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m ()
listBoxInvalidateHeaders box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    gtk_list_box_invalidate_headers box'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxInvalidateHeadersMethodInfo
instance (signature ~ (m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxInvalidateHeadersMethodInfo a signature where
    overloadedMethod = listBoxInvalidateHeaders

instance O.OverloadedMethodInfo ListBoxInvalidateHeadersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxInvalidateHeaders",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxInvalidateHeaders"
        })


#endif

-- method ListBox::invalidate_sort
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_invalidate_sort" gtk_list_box_invalidate_sort :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO ()

-- | Update the sorting for all rows.
-- 
-- Call this when result
-- of the sort function on the /@box@/ is changed due
-- to an external factor.
listBoxInvalidateSort ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m ()
listBoxInvalidateSort box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    gtk_list_box_invalidate_sort box'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxInvalidateSortMethodInfo
instance (signature ~ (m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxInvalidateSortMethodInfo a signature where
    overloadedMethod = listBoxInvalidateSort

instance O.OverloadedMethodInfo ListBoxInvalidateSortMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxInvalidateSort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxInvalidateSort"
        })


#endif

-- method ListBox::prepend
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkWidget` to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_prepend" gtk_list_box_prepend :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Prepend a widget to the list.
-- 
-- If a sort function is set, the widget will
-- actually be inserted at the calculated position.
listBoxPrepend ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to add
    -> m ()
listBoxPrepend box child = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    child' <- unsafeManagedPtrCastPtr child
    gtk_list_box_prepend box' child'
    touchManagedPtr box
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxPrependMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ListBoxPrependMethodInfo a signature where
    overloadedMethod = listBoxPrepend

instance O.OverloadedMethodInfo ListBoxPrependMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxPrepend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxPrepend"
        })


#endif

-- method ListBox::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_remove" gtk_list_box_remove :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Removes a child from /@box@/.
listBoxRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> b
    -- ^ /@child@/: the child to remove
    -> m ()
listBoxRemove box child = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    child' <- unsafeManagedPtrCastPtr child
    gtk_list_box_remove box' child'
    touchManagedPtr box
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxRemoveMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ListBoxRemoveMethodInfo a signature where
    overloadedMethod = listBoxRemove

instance O.OverloadedMethodInfo ListBoxRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxRemove"
        })


#endif

-- method ListBox::remove_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_remove_all" gtk_list_box_remove_all :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO ()

-- | Removes all rows from /@box@/.
-- 
-- This function does nothing if /@box@/ is backed by a model.
-- 
-- /Since: 4.12/
listBoxRemoveAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m ()
listBoxRemoveAll box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    gtk_list_box_remove_all box'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxRemoveAllMethodInfo
instance (signature ~ (m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxRemoveAllMethodInfo a signature where
    overloadedMethod = listBoxRemoveAll

instance O.OverloadedMethodInfo ListBoxRemoveAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxRemoveAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxRemoveAll"
        })


#endif

-- method ListBox::select_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_select_all" gtk_list_box_select_all :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO ()

-- | Select all children of /@box@/, if the selection mode allows it.
listBoxSelectAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m ()
listBoxSelectAll box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    gtk_list_box_select_all box'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSelectAllMethodInfo
instance (signature ~ (m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSelectAllMethodInfo a signature where
    overloadedMethod = listBoxSelectAll

instance O.OverloadedMethodInfo ListBoxSelectAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSelectAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSelectAll"
        })


#endif

-- method ListBox::select_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The row to select" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_select_row" gtk_list_box_select_row :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.ListBoxRow.ListBoxRow ->        -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO ()

-- | Make /@row@/ the currently selected row.
listBoxSelectRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.ListBoxRow.IsListBoxRow b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Maybe (b)
    -- ^ /@row@/: The row to select
    -> m ()
listBoxSelectRow box row = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    maybeRow <- case row of
        Nothing -> return FP.nullPtr
        Just jRow -> do
            jRow' <- unsafeManagedPtrCastPtr jRow
            return jRow'
    gtk_list_box_select_row box' maybeRow
    touchManagedPtr box
    whenJust row touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSelectRowMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListBox a, Gtk.ListBoxRow.IsListBoxRow b) => O.OverloadedMethod ListBoxSelectRowMethodInfo a signature where
    overloadedMethod = listBoxSelectRow

instance O.OverloadedMethodInfo ListBoxSelectRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSelectRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSelectRow"
        })


#endif

-- method ListBox::selected_foreach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxForeachFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the function to call for each selected child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_selected_foreach" gtk_list_box_selected_foreach :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    FunPtr Gtk.Callbacks.C_ListBoxForeachFunc -> -- func : TInterface (Name {namespace = "Gtk", name = "ListBoxForeachFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Calls a function for each selected child.
-- 
-- Note that the selection cannot be modified from within this function.
listBoxSelectedForeach ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Gtk.Callbacks.ListBoxForeachFunc
    -- ^ /@func@/: the function to call for each selected child
    -> m ()
listBoxSelectedForeach box func = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    func' <- Gtk.Callbacks.mk_ListBoxForeachFunc (Gtk.Callbacks.wrap_ListBoxForeachFunc Nothing (Gtk.Callbacks.drop_closures_ListBoxForeachFunc func))
    let data_ = nullPtr
    gtk_list_box_selected_foreach box' func' data_
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSelectedForeachMethodInfo
instance (signature ~ (Gtk.Callbacks.ListBoxForeachFunc -> m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSelectedForeachMethodInfo a signature where
    overloadedMethod = listBoxSelectedForeach

instance O.OverloadedMethodInfo ListBoxSelectedForeachMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSelectedForeach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSelectedForeach"
        })


#endif

-- method ListBox::set_activate_on_single_click
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "single"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a boolean" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_activate_on_single_click" gtk_list_box_set_activate_on_single_click :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    CInt ->                                 -- single : TBasicType TBoolean
    IO ()

-- | If /@single@/ is 'P.True', rows will be activated when you click on them,
-- otherwise you need to double-click.
listBoxSetActivateOnSingleClick ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Bool
    -- ^ /@single@/: a boolean
    -> m ()
listBoxSetActivateOnSingleClick box single = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    let single' = (P.fromIntegral . P.fromEnum) single
    gtk_list_box_set_activate_on_single_click box' single'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetActivateOnSingleClickMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSetActivateOnSingleClickMethodInfo a signature where
    overloadedMethod = listBoxSetActivateOnSingleClick

instance O.OverloadedMethodInfo ListBoxSetActivateOnSingleClickMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetActivateOnSingleClick",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetActivateOnSingleClick"
        })


#endif

-- method ListBox::set_adjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "adjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the adjustment" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_adjustment" gtk_list_box_set_adjustment :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.Adjustment.Adjustment ->        -- adjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    IO ()

-- | Sets the adjustment (if any) that the widget uses to
-- for vertical scrolling.
-- 
-- For instance, this is used to get the page size for
-- PageUp\/Down key handling.
-- 
-- In the normal case when the /@box@/ is packed inside
-- a @GtkScrolledWindow@ the adjustment from that will
-- be picked up automatically, so there is no need
-- to manually do that.
listBoxSetAdjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.Adjustment.IsAdjustment b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Maybe (b)
    -- ^ /@adjustment@/: the adjustment
    -> m ()
listBoxSetAdjustment box adjustment = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    maybeAdjustment <- case adjustment of
        Nothing -> return FP.nullPtr
        Just jAdjustment -> do
            jAdjustment' <- unsafeManagedPtrCastPtr jAdjustment
            return jAdjustment'
    gtk_list_box_set_adjustment box' maybeAdjustment
    touchManagedPtr box
    whenJust adjustment touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetAdjustmentMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListBox a, Gtk.Adjustment.IsAdjustment b) => O.OverloadedMethod ListBoxSetAdjustmentMethodInfo a signature where
    overloadedMethod = listBoxSetAdjustment

instance O.OverloadedMethodInfo ListBoxSetAdjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetAdjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetAdjustment"
        })


#endif

-- method ListBox::set_filter_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filter_func"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxFilterFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "callback\n  that lets you filter which rows to show"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @filter_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notifier for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_filter_func" gtk_list_box_set_filter_func :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    FunPtr Gtk.Callbacks.C_ListBoxFilterFunc -> -- filter_func : TInterface (Name {namespace = "Gtk", name = "ListBoxFilterFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | By setting a filter function on the /@box@/ one can decide dynamically which
-- of the rows to show.
-- 
-- For instance, to implement a search function on a list that
-- filters the original list to only show the matching rows.
-- 
-- The /@filterFunc@/ will be called for each row after the call, and
-- it will continue to be called each time a row changes (via
-- 'GI.Gtk.Objects.ListBoxRow.listBoxRowChanged') or when 'GI.Gtk.Objects.ListBox.listBoxInvalidateFilter'
-- is called.
-- 
-- Note that using a filter function is incompatible with using a model
-- (see 'GI.Gtk.Objects.ListBox.listBoxBindModel').
listBoxSetFilterFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Maybe (Gtk.Callbacks.ListBoxFilterFunc)
    -- ^ /@filterFunc@/: callback
    --   that lets you filter which rows to show
    -> m ()
listBoxSetFilterFunc box filterFunc = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    maybeFilterFunc <- case filterFunc of
        Nothing -> return FP.nullFunPtr
        Just jFilterFunc -> do
            jFilterFunc' <- Gtk.Callbacks.mk_ListBoxFilterFunc (Gtk.Callbacks.wrap_ListBoxFilterFunc Nothing (Gtk.Callbacks.drop_closures_ListBoxFilterFunc jFilterFunc))
            return jFilterFunc'
    let userData = castFunPtrToPtr maybeFilterFunc
    let destroy = SP.safeFreeFunPtrPtr
    gtk_list_box_set_filter_func box' maybeFilterFunc userData destroy
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetFilterFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.ListBoxFilterFunc) -> m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSetFilterFuncMethodInfo a signature where
    overloadedMethod = listBoxSetFilterFunc

instance O.OverloadedMethodInfo ListBoxSetFilterFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetFilterFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetFilterFunc"
        })


#endif

-- method ListBox::set_header_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "update_header"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "ListBoxUpdateHeaderFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "callback\n  that lets you add row headers"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @update_header"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notifier for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_header_func" gtk_list_box_set_header_func :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    FunPtr Gtk.Callbacks.C_ListBoxUpdateHeaderFunc -> -- update_header : TInterface (Name {namespace = "Gtk", name = "ListBoxUpdateHeaderFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets a header function.
-- 
-- By setting a header function on the /@box@/ one can dynamically add headers
-- in front of rows, depending on the contents of the row and its position
-- in the list.
-- 
-- For instance, one could use it to add headers in front of the first item
-- of a new kind, in a list sorted by the kind.
-- 
-- The /@updateHeader@/ can look at the current header widget using
-- 'GI.Gtk.Objects.ListBoxRow.listBoxRowGetHeader' and either update the state of the widget
-- as needed, or set a new one using 'GI.Gtk.Objects.ListBoxRow.listBoxRowSetHeader'. If no
-- header is needed, set the header to 'P.Nothing'.
-- 
-- Note that you may get many calls /@updateHeader@/ to this for a particular
-- row when e.g. changing things that don’t affect the header. In this case
-- it is important for performance to not blindly replace an existing header
-- with an identical one.
-- 
-- The /@updateHeader@/ function will be called for each row after the call,
-- and it will continue to be called each time a row changes (via
-- 'GI.Gtk.Objects.ListBoxRow.listBoxRowChanged') and when the row before changes (either
-- by 'GI.Gtk.Objects.ListBoxRow.listBoxRowChanged' on the previous row, or when the previous
-- row becomes a different row). It is also called for all rows when
-- 'GI.Gtk.Objects.ListBox.listBoxInvalidateHeaders' is called.
listBoxSetHeaderFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Maybe (Gtk.Callbacks.ListBoxUpdateHeaderFunc)
    -- ^ /@updateHeader@/: callback
    --   that lets you add row headers
    -> m ()
listBoxSetHeaderFunc box updateHeader = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    maybeUpdateHeader <- case updateHeader of
        Nothing -> return FP.nullFunPtr
        Just jUpdateHeader -> do
            jUpdateHeader' <- Gtk.Callbacks.mk_ListBoxUpdateHeaderFunc (Gtk.Callbacks.wrap_ListBoxUpdateHeaderFunc Nothing (Gtk.Callbacks.drop_closures_ListBoxUpdateHeaderFunc jUpdateHeader))
            return jUpdateHeader'
    let userData = castFunPtrToPtr maybeUpdateHeader
    let destroy = SP.safeFreeFunPtrPtr
    gtk_list_box_set_header_func box' maybeUpdateHeader userData destroy
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetHeaderFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.ListBoxUpdateHeaderFunc) -> m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSetHeaderFuncMethodInfo a signature where
    overloadedMethod = listBoxSetHeaderFunc

instance O.OverloadedMethodInfo ListBoxSetHeaderFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetHeaderFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetHeaderFunc"
        })


#endif

-- method ListBox::set_placeholder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "placeholder"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_placeholder" gtk_list_box_set_placeholder :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.Widget.Widget ->                -- placeholder : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the placeholder widget that is shown in the list when
-- it doesn\'t display any visible children.
listBoxSetPlaceholder ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Maybe (b)
    -- ^ /@placeholder@/: a @GtkWidget@
    -> m ()
listBoxSetPlaceholder box placeholder = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    maybePlaceholder <- case placeholder of
        Nothing -> return FP.nullPtr
        Just jPlaceholder -> do
            jPlaceholder' <- unsafeManagedPtrCastPtr jPlaceholder
            return jPlaceholder'
    gtk_list_box_set_placeholder box' maybePlaceholder
    touchManagedPtr box
    whenJust placeholder touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetPlaceholderMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsListBox a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ListBoxSetPlaceholderMethodInfo a signature where
    overloadedMethod = listBoxSetPlaceholder

instance O.OverloadedMethodInfo ListBoxSetPlaceholderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetPlaceholder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetPlaceholder"
        })


#endif

-- method ListBox::set_selection_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The `GtkSelectionMode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_selection_mode" gtk_list_box_set_selection_mode :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    CUInt ->                                -- mode : TInterface (Name {namespace = "Gtk", name = "SelectionMode"})
    IO ()

-- | Sets how selection works in the listbox.
listBoxSetSelectionMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Gtk.Enums.SelectionMode
    -- ^ /@mode@/: The @GtkSelectionMode@
    -> m ()
listBoxSetSelectionMode box mode = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    let mode' = (fromIntegral . fromEnum) mode
    gtk_list_box_set_selection_mode box' mode'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetSelectionModeMethodInfo
instance (signature ~ (Gtk.Enums.SelectionMode -> m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSetSelectionModeMethodInfo a signature where
    overloadedMethod = listBoxSetSelectionMode

instance O.OverloadedMethodInfo ListBoxSetSelectionModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetSelectionMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetSelectionMode"
        })


#endif

-- method ListBox::set_show_separators
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_separators"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to show separators"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_show_separators" gtk_list_box_set_show_separators :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    CInt ->                                 -- show_separators : TBasicType TBoolean
    IO ()

-- | Sets whether the list box should show separators
-- between rows.
listBoxSetShowSeparators ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Bool
    -- ^ /@showSeparators@/: 'P.True' to show separators
    -> m ()
listBoxSetShowSeparators box showSeparators = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    let showSeparators' = (P.fromIntegral . P.fromEnum) showSeparators
    gtk_list_box_set_show_separators box' showSeparators'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetShowSeparatorsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSetShowSeparatorsMethodInfo a signature where
    overloadedMethod = listBoxSetShowSeparators

instance O.OverloadedMethodInfo ListBoxSetShowSeparatorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetShowSeparators",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetShowSeparators"
        })


#endif

-- method ListBox::set_sort_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sort_func"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxSortFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the sort function" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @sort_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notifier for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_sort_func" gtk_list_box_set_sort_func :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    FunPtr Gtk.Callbacks.C_ListBoxSortFunc -> -- sort_func : TInterface (Name {namespace = "Gtk", name = "ListBoxSortFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets a sort function.
-- 
-- By setting a sort function on the /@box@/ one can dynamically reorder
-- the rows of the list, based on the contents of the rows.
-- 
-- The /@sortFunc@/ will be called for each row after the call, and will
-- continue to be called each time a row changes (via
-- 'GI.Gtk.Objects.ListBoxRow.listBoxRowChanged') and when 'GI.Gtk.Objects.ListBox.listBoxInvalidateSort'
-- is called.
-- 
-- Note that using a sort function is incompatible with using a model
-- (see 'GI.Gtk.Objects.ListBox.listBoxBindModel').
listBoxSetSortFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Maybe (Gtk.Callbacks.ListBoxSortFunc)
    -- ^ /@sortFunc@/: the sort function
    -> m ()
listBoxSetSortFunc box sortFunc = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    maybeSortFunc <- case sortFunc of
        Nothing -> return FP.nullFunPtr
        Just jSortFunc -> do
            jSortFunc' <- Gtk.Callbacks.mk_ListBoxSortFunc (Gtk.Callbacks.wrap_ListBoxSortFunc Nothing (Gtk.Callbacks.drop_closures_ListBoxSortFunc jSortFunc))
            return jSortFunc'
    let userData = castFunPtrToPtr maybeSortFunc
    let destroy = SP.safeFreeFunPtrPtr
    gtk_list_box_set_sort_func box' maybeSortFunc userData destroy
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetSortFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.ListBoxSortFunc) -> m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSetSortFuncMethodInfo a signature where
    overloadedMethod = listBoxSetSortFunc

instance O.OverloadedMethodInfo ListBoxSetSortFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetSortFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetSortFunc"
        })


#endif

-- method ListBox::set_tab_behavior
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "behavior"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListTabBehavior" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the tab behavior" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_set_tab_behavior" gtk_list_box_set_tab_behavior :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    CUInt ->                                -- behavior : TInterface (Name {namespace = "Gtk", name = "ListTabBehavior"})
    IO ()

-- | Sets the behavior of the \<kbd>Tab\<\/kbd> and \<kbd>Shift\<\/kbd>+\<kbd>Tab\<\/kbd> keys.
-- 
-- /Since: 4.18/
listBoxSetTabBehavior ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> Gtk.Enums.ListTabBehavior
    -- ^ /@behavior@/: the tab behavior
    -> m ()
listBoxSetTabBehavior box behavior = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    let behavior' = (fromIntegral . fromEnum) behavior
    gtk_list_box_set_tab_behavior box' behavior'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxSetTabBehaviorMethodInfo
instance (signature ~ (Gtk.Enums.ListTabBehavior -> m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxSetTabBehaviorMethodInfo a signature where
    overloadedMethod = listBoxSetTabBehavior

instance O.OverloadedMethodInfo ListBoxSetTabBehaviorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxSetTabBehavior",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxSetTabBehavior"
        })


#endif

-- method ListBox::unselect_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_unselect_all" gtk_list_box_unselect_all :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    IO ()

-- | Unselect all children of /@box@/, if the selection mode allows it.
listBoxUnselectAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> m ()
listBoxUnselectAll box = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    gtk_list_box_unselect_all box'
    touchManagedPtr box
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxUnselectAllMethodInfo
instance (signature ~ (m ()), MonadIO m, IsListBox a) => O.OverloadedMethod ListBoxUnselectAllMethodInfo a signature where
    overloadedMethod = listBoxUnselectAll

instance O.OverloadedMethodInfo ListBoxUnselectAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxUnselectAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxUnselectAll"
        })


#endif

-- method ListBox::unselect_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "box"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBox" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkListBox`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListBoxRow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row to unselect"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_list_box_unselect_row" gtk_list_box_unselect_row :: 
    Ptr ListBox ->                          -- box : TInterface (Name {namespace = "Gtk", name = "ListBox"})
    Ptr Gtk.ListBoxRow.ListBoxRow ->        -- row : TInterface (Name {namespace = "Gtk", name = "ListBoxRow"})
    IO ()

-- | Unselects a single row of /@box@/, if the selection mode allows it.
listBoxUnselectRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsListBox a, Gtk.ListBoxRow.IsListBoxRow b) =>
    a
    -- ^ /@box@/: a @GtkListBox@
    -> b
    -- ^ /@row@/: the row to unselect
    -> m ()
listBoxUnselectRow box row = liftIO $ do
    box' <- unsafeManagedPtrCastPtr box
    row' <- unsafeManagedPtrCastPtr row
    gtk_list_box_unselect_row box' row'
    touchManagedPtr box
    touchManagedPtr row
    return ()

#if defined(ENABLE_OVERLOADING)
data ListBoxUnselectRowMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsListBox a, Gtk.ListBoxRow.IsListBoxRow b) => O.OverloadedMethod ListBoxUnselectRowMethodInfo a signature where
    overloadedMethod = listBoxUnselectRow

instance O.OverloadedMethodInfo ListBoxUnselectRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ListBox.listBoxUnselectRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ListBox.html#v:listBoxUnselectRow"
        })


#endif


