//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/admission_control/v3/admission_control.proto

package admission_controlv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on AdmissionControl with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *AdmissionControl) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AdmissionControl with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AdmissionControlMultiError, or nil if none found.
func (m *AdmissionControl) ValidateAll() error {
	return m.validate(true)
}

func (m *AdmissionControl) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "Enabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "Enabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdmissionControlValidationError{
				field:  "Enabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetSamplingWindow()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "SamplingWindow",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "SamplingWindow",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSamplingWindow()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdmissionControlValidationError{
				field:  "SamplingWindow",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAggression()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "Aggression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "Aggression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAggression()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdmissionControlValidationError{
				field:  "Aggression",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetSrThreshold()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "SrThreshold",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "SrThreshold",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSrThreshold()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdmissionControlValidationError{
				field:  "SrThreshold",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRpsThreshold()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "RpsThreshold",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "RpsThreshold",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRpsThreshold()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdmissionControlValidationError{
				field:  "RpsThreshold",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxRejectionProbability()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "MaxRejectionProbability",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdmissionControlValidationError{
					field:  "MaxRejectionProbability",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxRejectionProbability()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdmissionControlValidationError{
				field:  "MaxRejectionProbability",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofEvaluationCriteriaPresent := false
	switch v := m.EvaluationCriteria.(type) {
	case *AdmissionControl_SuccessCriteria_:
		if v == nil {
			err := AdmissionControlValidationError{
				field:  "EvaluationCriteria",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofEvaluationCriteriaPresent = true

		if all {
			switch v := interface{}(m.GetSuccessCriteria()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AdmissionControlValidationError{
						field:  "SuccessCriteria",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AdmissionControlValidationError{
						field:  "SuccessCriteria",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSuccessCriteria()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AdmissionControlValidationError{
					field:  "SuccessCriteria",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofEvaluationCriteriaPresent {
		err := AdmissionControlValidationError{
			field:  "EvaluationCriteria",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AdmissionControlMultiError(errors)
	}

	return nil
}

// AdmissionControlMultiError is an error wrapping multiple validation errors
// returned by AdmissionControl.ValidateAll() if the designated constraints
// aren't met.
type AdmissionControlMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AdmissionControlMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AdmissionControlMultiError) AllErrors() []error { return m }

// AdmissionControlValidationError is the validation error returned by
// AdmissionControl.Validate if the designated constraints aren't met.
type AdmissionControlValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AdmissionControlValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AdmissionControlValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AdmissionControlValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AdmissionControlValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AdmissionControlValidationError) ErrorName() string { return "AdmissionControlValidationError" }

// Error satisfies the builtin error interface
func (e AdmissionControlValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAdmissionControl.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AdmissionControlValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AdmissionControlValidationError{}

// Validate checks the field values on AdmissionControl_SuccessCriteria with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *AdmissionControl_SuccessCriteria) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AdmissionControl_SuccessCriteria with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// AdmissionControl_SuccessCriteriaMultiError, or nil if none found.
func (m *AdmissionControl_SuccessCriteria) ValidateAll() error {
	return m.validate(true)
}

func (m *AdmissionControl_SuccessCriteria) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetHttpCriteria()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdmissionControl_SuccessCriteriaValidationError{
					field:  "HttpCriteria",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdmissionControl_SuccessCriteriaValidationError{
					field:  "HttpCriteria",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttpCriteria()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdmissionControl_SuccessCriteriaValidationError{
				field:  "HttpCriteria",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGrpcCriteria()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdmissionControl_SuccessCriteriaValidationError{
					field:  "GrpcCriteria",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdmissionControl_SuccessCriteriaValidationError{
					field:  "GrpcCriteria",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcCriteria()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdmissionControl_SuccessCriteriaValidationError{
				field:  "GrpcCriteria",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AdmissionControl_SuccessCriteriaMultiError(errors)
	}

	return nil
}

// AdmissionControl_SuccessCriteriaMultiError is an error wrapping multiple
// validation errors returned by
// AdmissionControl_SuccessCriteria.ValidateAll() if the designated
// constraints aren't met.
type AdmissionControl_SuccessCriteriaMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AdmissionControl_SuccessCriteriaMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AdmissionControl_SuccessCriteriaMultiError) AllErrors() []error { return m }

// AdmissionControl_SuccessCriteriaValidationError is the validation error
// returned by AdmissionControl_SuccessCriteria.Validate if the designated
// constraints aren't met.
type AdmissionControl_SuccessCriteriaValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AdmissionControl_SuccessCriteriaValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AdmissionControl_SuccessCriteriaValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AdmissionControl_SuccessCriteriaValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AdmissionControl_SuccessCriteriaValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AdmissionControl_SuccessCriteriaValidationError) ErrorName() string {
	return "AdmissionControl_SuccessCriteriaValidationError"
}

// Error satisfies the builtin error interface
func (e AdmissionControl_SuccessCriteriaValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAdmissionControl_SuccessCriteria.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AdmissionControl_SuccessCriteriaValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AdmissionControl_SuccessCriteriaValidationError{}

// Validate checks the field values on
// AdmissionControl_SuccessCriteria_HttpCriteria with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AdmissionControl_SuccessCriteria_HttpCriteria) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// AdmissionControl_SuccessCriteria_HttpCriteria with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// AdmissionControl_SuccessCriteria_HttpCriteriaMultiError, or nil if none found.
func (m *AdmissionControl_SuccessCriteria_HttpCriteria) ValidateAll() error {
	return m.validate(true)
}

func (m *AdmissionControl_SuccessCriteria_HttpCriteria) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetHttpSuccessStatus()) < 1 {
		err := AdmissionControl_SuccessCriteria_HttpCriteriaValidationError{
			field:  "HttpSuccessStatus",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetHttpSuccessStatus() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AdmissionControl_SuccessCriteria_HttpCriteriaValidationError{
						field:  fmt.Sprintf("HttpSuccessStatus[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AdmissionControl_SuccessCriteria_HttpCriteriaValidationError{
						field:  fmt.Sprintf("HttpSuccessStatus[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AdmissionControl_SuccessCriteria_HttpCriteriaValidationError{
					field:  fmt.Sprintf("HttpSuccessStatus[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return AdmissionControl_SuccessCriteria_HttpCriteriaMultiError(errors)
	}

	return nil
}

// AdmissionControl_SuccessCriteria_HttpCriteriaMultiError is an error wrapping
// multiple validation errors returned by
// AdmissionControl_SuccessCriteria_HttpCriteria.ValidateAll() if the
// designated constraints aren't met.
type AdmissionControl_SuccessCriteria_HttpCriteriaMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AdmissionControl_SuccessCriteria_HttpCriteriaMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AdmissionControl_SuccessCriteria_HttpCriteriaMultiError) AllErrors() []error { return m }

// AdmissionControl_SuccessCriteria_HttpCriteriaValidationError is the
// validation error returned by
// AdmissionControl_SuccessCriteria_HttpCriteria.Validate if the designated
// constraints aren't met.
type AdmissionControl_SuccessCriteria_HttpCriteriaValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AdmissionControl_SuccessCriteria_HttpCriteriaValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AdmissionControl_SuccessCriteria_HttpCriteriaValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e AdmissionControl_SuccessCriteria_HttpCriteriaValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AdmissionControl_SuccessCriteria_HttpCriteriaValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AdmissionControl_SuccessCriteria_HttpCriteriaValidationError) ErrorName() string {
	return "AdmissionControl_SuccessCriteria_HttpCriteriaValidationError"
}

// Error satisfies the builtin error interface
func (e AdmissionControl_SuccessCriteria_HttpCriteriaValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAdmissionControl_SuccessCriteria_HttpCriteria.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AdmissionControl_SuccessCriteria_HttpCriteriaValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AdmissionControl_SuccessCriteria_HttpCriteriaValidationError{}

// Validate checks the field values on
// AdmissionControl_SuccessCriteria_GrpcCriteria with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AdmissionControl_SuccessCriteria_GrpcCriteria) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// AdmissionControl_SuccessCriteria_GrpcCriteria with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// AdmissionControl_SuccessCriteria_GrpcCriteriaMultiError, or nil if none found.
func (m *AdmissionControl_SuccessCriteria_GrpcCriteria) ValidateAll() error {
	return m.validate(true)
}

func (m *AdmissionControl_SuccessCriteria_GrpcCriteria) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetGrpcSuccessStatus()) < 1 {
		err := AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError{
			field:  "GrpcSuccessStatus",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AdmissionControl_SuccessCriteria_GrpcCriteriaMultiError(errors)
	}

	return nil
}

// AdmissionControl_SuccessCriteria_GrpcCriteriaMultiError is an error wrapping
// multiple validation errors returned by
// AdmissionControl_SuccessCriteria_GrpcCriteria.ValidateAll() if the
// designated constraints aren't met.
type AdmissionControl_SuccessCriteria_GrpcCriteriaMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AdmissionControl_SuccessCriteria_GrpcCriteriaMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AdmissionControl_SuccessCriteria_GrpcCriteriaMultiError) AllErrors() []error { return m }

// AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError is the
// validation error returned by
// AdmissionControl_SuccessCriteria_GrpcCriteria.Validate if the designated
// constraints aren't met.
type AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError) ErrorName() string {
	return "AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError"
}

// Error satisfies the builtin error interface
func (e AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAdmissionControl_SuccessCriteria_GrpcCriteria.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AdmissionControl_SuccessCriteria_GrpcCriteriaValidationError{}
