// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: envoy/extensions/filters/http/credential_injector/v3/credential_injector.proto

package credential_injectorv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Credential Injector injects credentials into outgoing HTTP requests. The filter configuration is used to retrieve the credentials, or
// they can be requested through the OAuth2 client credential grant. The credentials obtained are then injected into the Authorization header
// of the proxied HTTP requests, utilizing either the Basic or Bearer scheme.
//
// If the credential is not present or there was a failure injecting the credential, the request will fail with “401 Unauthorized“ unless
// “allow_request_without_credential“ is set to “true“.
//
// Notice: This filter is intended to be used for workload authentication, which means that the identity associated with the inserted credential
// is considered as the identity of the workload behind the envoy proxy(in this case, envoy is typically deployed as a sidecar alongside that
// workload). Please note that this filter does not handle end user authentication. Its purpose is solely to authenticate the workload itself.
//
// Here is an example of CredentialInjector configuration with Generic credential, which injects an HTTP Basic Auth credential into the proxied requests.
//
// .. code-block:: yaml
//
//	overwrite: true
//	credential:
//	  name: generic_credential
//	  typed_config:
//	    "@type": type.googleapis.com/envoy.extensions.http.injected_credentials.generic.v3.Generic
//	    credential:
//	      name: credential
//	      sds_config:
//	        path_config_source:
//	          path: credential.yaml
//	    header: Authorization
//
// credential.yaml for Basic Auth:
//
// .. code-block:: yaml
//
//	resources:
//	- "@type": "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.Secret"
//	  name: credential
//	  generic_secret:
//	    secret:
//	      inline_string: "Basic base64EncodedUsernamePassword"
//
// It can also be configured to inject a Bearer token into the proxied requests.
//
// credential.yaml for Bearer Token:
//
// .. code-block:: yaml
//
//	resources:
//	- "@type": "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.Secret"
//	  name: credential
//	  generic_secret:
//	    secret:
//	      inline_string: "Bearer myToken"
type CredentialInjector struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Whether to overwrite the value or not if the injected headers already exist.
	// Value defaults to false.
	Overwrite bool `protobuf:"varint,1,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
	// Whether to send the request to upstream if the credential is not present or if the credential injection
	// to the request fails.
	//
	// By default, a request will fail with “401 Unauthorized“ if the
	// credential is not present or the injection of the credential to the request fails.
	// If set to true, the request will be sent to upstream without the credential.
	AllowRequestWithoutCredential bool `protobuf:"varint,2,opt,name=allow_request_without_credential,json=allowRequestWithoutCredential,proto3" json:"allow_request_without_credential,omitempty"`
	// The credential to inject into the proxied requests
	// [#extension-category: envoy.http.injected_credentials]
	Credential    *v3.TypedExtensionConfig `protobuf:"bytes,3,opt,name=credential,proto3" json:"credential,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CredentialInjector) Reset() {
	*x = CredentialInjector{}
	mi := &file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CredentialInjector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CredentialInjector) ProtoMessage() {}

func (x *CredentialInjector) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CredentialInjector.ProtoReflect.Descriptor instead.
func (*CredentialInjector) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDescGZIP(), []int{0}
}

func (x *CredentialInjector) GetOverwrite() bool {
	if x != nil {
		return x.Overwrite
	}
	return false
}

func (x *CredentialInjector) GetAllowRequestWithoutCredential() bool {
	if x != nil {
		return x.AllowRequestWithoutCredential
	}
	return false
}

func (x *CredentialInjector) GetCredential() *v3.TypedExtensionConfig {
	if x != nil {
		return x.Credential
	}
	return nil
}

var File_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto protoreflect.FileDescriptor

const file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDesc = "" +
	"\n" +
	"Nenvoy/extensions/filters/http/credential_injector/v3/credential_injector.proto\x124envoy.extensions.filters.http.credential_injector.v3\x1a$envoy/config/core/v3/extension.proto\x1a\x1dudpa/annotations/status.proto\x1a\x17validate/validate.proto\"\xd1\x01\n" +
	"\x12CredentialInjector\x12\x1c\n" +
	"\toverwrite\x18\x01 \x01(\bR\toverwrite\x12G\n" +
	" allow_request_without_credential\x18\x02 \x01(\bR\x1dallowRequestWithoutCredential\x12T\n" +
	"\n" +
	"credential\x18\x03 \x01(\v2*.envoy.config.core.v3.TypedExtensionConfigB\b\xfaB\x05\x8a\x01\x02\x10\x01R\n" +
	"credentialB\xda\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\n" +
	"Bio.envoyproxy.envoy.extensions.filters.http.credential_injector.v3B\x17CredentialInjectorProtoP\x01Zqgithub.com/envoyproxy/go-control-plane/envoy/extensions/filters/http/credential_injector/v3;credential_injectorv3b\x06proto3"

var (
	file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDescData []byte
)

func file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDesc), len(file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDesc)))
	})
	return file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDescData
}

var file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_goTypes = []any{
	(*CredentialInjector)(nil),      // 0: envoy.extensions.filters.http.credential_injector.v3.CredentialInjector
	(*v3.TypedExtensionConfig)(nil), // 1: envoy.config.core.v3.TypedExtensionConfig
}
var file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_depIdxs = []int32{
	1, // 0: envoy.extensions.filters.http.credential_injector.v3.CredentialInjector.credential:type_name -> envoy.config.core.v3.TypedExtensionConfig
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() {
	file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_init()
}
func file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_init() {
	if File_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDesc), len(file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_depIdxs,
		MessageInfos:      file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto = out.File
	file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_goTypes = nil
	file_envoy_extensions_filters_http_credential_injector_v3_credential_injector_proto_depIdxs = nil
}
