#ifndef SBK_KSTATUSNOTIFIERITEMWRAPPER_H
#define SBK_KSTATUSNOTIFIERITEMWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kstatusnotifieritem.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KStatusNotifierItemWrapper : public KStatusNotifierItem
{
public:
    KStatusNotifierItemWrapper(::QObject * parent = nullptr);
    KStatusNotifierItemWrapper(const ::QString & id, ::QObject * parent = nullptr);
    KStatusNotifierItemWrapper(const KStatusNotifierItemWrapper &) = delete;
    KStatusNotifierItemWrapper& operator=(const KStatusNotifierItemWrapper &) = delete;
    KStatusNotifierItemWrapper(KStatusNotifierItemWrapper &&) = delete;
    KStatusNotifierItemWrapper& operator=(KStatusNotifierItemWrapper &&) = delete;
    ~KStatusNotifierItemWrapper() override;

    void activate(const ::QPoint & pos = QPoint()) override;
    static void sbk_o_activate(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QPoint & pos = QPoint());
    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void connectNotify(const ::QMetaMethod & signal) override;
    static void sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal);
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 8> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KSTATUSNOTIFIERITEMWRAPPER_H
