#include "nv_push_cla297.h"

#include <stdio.h>

const char*
P_PARSE_NVA297_MTHD(uint16_t idx)
{
    switch (idx) {
    case NVA297_SET_OBJECT:
        return "NVA297_SET_OBJECT";
    case NVA297_NO_OPERATION:
        return "NVA297_NO_OPERATION";
    case NVA297_SET_NOTIFY_A:
        return "NVA297_SET_NOTIFY_A";
    case NVA297_SET_NOTIFY_B:
        return "NVA297_SET_NOTIFY_B";
    case NVA297_NOTIFY:
        return "NVA297_NOTIFY";
    case NVA297_WAIT_FOR_IDLE:
        return "NVA297_WAIT_FOR_IDLE";
    case NVA297_LOAD_MME_INSTRUCTION_RAM_POINTER:
        return "NVA297_LOAD_MME_INSTRUCTION_RAM_POINTER";
    case NVA297_LOAD_MME_INSTRUCTION_RAM:
        return "NVA297_LOAD_MME_INSTRUCTION_RAM";
    case NVA297_LOAD_MME_START_ADDRESS_RAM_POINTER:
        return "NVA297_LOAD_MME_START_ADDRESS_RAM_POINTER";
    case NVA297_LOAD_MME_START_ADDRESS_RAM:
        return "NVA297_LOAD_MME_START_ADDRESS_RAM";
    case NVA297_SET_MME_SHADOW_RAM_CONTROL:
        return "NVA297_SET_MME_SHADOW_RAM_CONTROL";
    case NVA297_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER:
        return "NVA297_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER";
    case NVA297_PEER_SEMAPHORE_RELEASE_OFFSET:
        return "NVA297_PEER_SEMAPHORE_RELEASE_OFFSET";
    case NVA297_SET_GLOBAL_RENDER_ENABLE_A:
        return "NVA297_SET_GLOBAL_RENDER_ENABLE_A";
    case NVA297_SET_GLOBAL_RENDER_ENABLE_B:
        return "NVA297_SET_GLOBAL_RENDER_ENABLE_B";
    case NVA297_SET_GLOBAL_RENDER_ENABLE_C:
        return "NVA297_SET_GLOBAL_RENDER_ENABLE_C";
    case NVA297_SEND_GO_IDLE:
        return "NVA297_SEND_GO_IDLE";
    case NVA297_PM_TRIGGER:
        return "NVA297_PM_TRIGGER";
    case NVA297_PM_TRIGGER_WFI:
        return "NVA297_PM_TRIGGER_WFI";
    case NVA297_SET_INSTRUMENTATION_METHOD_HEADER:
        return "NVA297_SET_INSTRUMENTATION_METHOD_HEADER";
    case NVA297_SET_INSTRUMENTATION_METHOD_DATA:
        return "NVA297_SET_INSTRUMENTATION_METHOD_DATA";
    case NVA297_LINE_LENGTH_IN:
        return "NVA297_LINE_LENGTH_IN";
    case NVA297_LINE_COUNT:
        return "NVA297_LINE_COUNT";
    case NVA297_OFFSET_OUT_UPPER:
        return "NVA297_OFFSET_OUT_UPPER";
    case NVA297_OFFSET_OUT:
        return "NVA297_OFFSET_OUT";
    case NVA297_PITCH_OUT:
        return "NVA297_PITCH_OUT";
    case NVA297_SET_DST_BLOCK_SIZE:
        return "NVA297_SET_DST_BLOCK_SIZE";
    case NVA297_SET_DST_WIDTH:
        return "NVA297_SET_DST_WIDTH";
    case NVA297_SET_DST_HEIGHT:
        return "NVA297_SET_DST_HEIGHT";
    case NVA297_SET_DST_DEPTH:
        return "NVA297_SET_DST_DEPTH";
    case NVA297_SET_DST_LAYER:
        return "NVA297_SET_DST_LAYER";
    case NVA297_SET_DST_ORIGIN_BYTES_X:
        return "NVA297_SET_DST_ORIGIN_BYTES_X";
    case NVA297_SET_DST_ORIGIN_SAMPLES_Y:
        return "NVA297_SET_DST_ORIGIN_SAMPLES_Y";
    case NVA297_LAUNCH_DMA:
        return "NVA297_LAUNCH_DMA";
    case NVA297_LOAD_INLINE_DATA:
        return "NVA297_LOAD_INLINE_DATA";
    case NVA297_SET_I2M_SEMAPHORE_A:
        return "NVA297_SET_I2M_SEMAPHORE_A";
    case NVA297_SET_I2M_SEMAPHORE_B:
        return "NVA297_SET_I2M_SEMAPHORE_B";
    case NVA297_SET_I2M_SEMAPHORE_C:
        return "NVA297_SET_I2M_SEMAPHORE_C";
    case NVA297_SET_I2M_SPARE_NOOP00:
        return "NVA297_SET_I2M_SPARE_NOOP00";
    case NVA297_SET_I2M_SPARE_NOOP01:
        return "NVA297_SET_I2M_SPARE_NOOP01";
    case NVA297_SET_I2M_SPARE_NOOP02:
        return "NVA297_SET_I2M_SPARE_NOOP02";
    case NVA297_SET_I2M_SPARE_NOOP03:
        return "NVA297_SET_I2M_SPARE_NOOP03";
    case NVA297_RUN_DS_NOW:
        return "NVA297_RUN_DS_NOW";
    case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS:
        return "NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS";
    case NVA297_SET_RASTER_PIPE_SYNC_CONTROL:
        return "NVA297_SET_RASTER_PIPE_SYNC_CONTROL";
    case NVA297_SET_ALIASED_LINE_WIDTH_ENABLE:
        return "NVA297_SET_ALIASED_LINE_WIDTH_ENABLE";
    case NVA297_SET_API_MANDATED_EARLY_Z:
        return "NVA297_SET_API_MANDATED_EARLY_Z";
    case NVA297_SET_GS_DM_FIFO:
        return "NVA297_SET_GS_DM_FIFO";
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS:
        return "NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS";
    case NVA297_INVALIDATE_SHADER_CACHES:
        return "NVA297_INVALIDATE_SHADER_CACHES";
                                            case NVA297_SET_GLOBAL_LOAD_VIA_TEXTURE:
        return "NVA297_SET_GLOBAL_LOAD_VIA_TEXTURE";
    case NVA297_INCREMENT_SYNC_POINT:
        return "NVA297_INCREMENT_SYNC_POINT";
    case NVA297_SET_TASK_CIRCULAR_BUFFER_THROTTLE:
        return "NVA297_SET_TASK_CIRCULAR_BUFFER_THROTTLE";
    case NVA297_SET_PRIM_CIRCULAR_BUFFER_THROTTLE:
        return "NVA297_SET_PRIM_CIRCULAR_BUFFER_THROTTLE";
    case NVA297_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE:
        return "NVA297_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE";
    case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE:
        return "NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE";
    case NVA297_SET_ALPHA_CIRCULAR_BUFFER_SIZE:
        return "NVA297_SET_ALPHA_CIRCULAR_BUFFER_SIZE";
    case NVA297_DECOMPRESS_SURFACE:
        return "NVA297_DECOMPRESS_SURFACE";
    case NVA297_SET_ZCULL_ROP_BYPASS:
        return "NVA297_SET_ZCULL_ROP_BYPASS";
    case NVA297_SET_ZCULL_SUBREGION:
        return "NVA297_SET_ZCULL_SUBREGION";
    case NVA297_SET_RASTER_BOUNDING_BOX:
        return "NVA297_SET_RASTER_BOUNDING_BOX";
    case NVA297_PEER_SEMAPHORE_RELEASE:
        return "NVA297_PEER_SEMAPHORE_RELEASE";
    case NVA297_SET_ITERATED_BLEND_OPTIMIZATION:
        return "NVA297_SET_ITERATED_BLEND_OPTIMIZATION";
    case NVA297_SET_ZCULL_SUBREGION_ALLOCATION:
        return "NVA297_SET_ZCULL_SUBREGION_ALLOCATION";
    case NVA297_ASSIGN_ZCULL_SUBREGIONS:
        return "NVA297_ASSIGN_ZCULL_SUBREGIONS";
    case NVA297_SET_PS_OUTPUT_SAMPLE_MASK_USAGE:
        return "NVA297_SET_PS_OUTPUT_SAMPLE_MASK_USAGE";
    case NVA297_DRAW_ZERO_INDEX:
        return "NVA297_DRAW_ZERO_INDEX";
    case NVA297_SET_L1_CONFIGURATION:
        return "NVA297_SET_L1_CONFIGURATION";
    case NVA297_SET_RENDER_ENABLE_CONTROL:
        return "NVA297_SET_RENDER_ENABLE_CONTROL";
    case NVA297_SET_SPA_VERSION:
        return "NVA297_SET_SPA_VERSION";
    case NVA297_SET_IEEE_CLEAN_UPDATE:
        return "NVA297_SET_IEEE_CLEAN_UPDATE";
    case NVA297_SET_SNAP_GRID_LINE:
        return "NVA297_SET_SNAP_GRID_LINE";
    case NVA297_SET_SNAP_GRID_NON_LINE:
        return "NVA297_SET_SNAP_GRID_NON_LINE";
    case NVA297_SET_TESSELLATION_PARAMETERS:
        return "NVA297_SET_TESSELLATION_PARAMETERS";
    case NVA297_SET_TESSELLATION_LOD_U0_OR_DENSITY:
        return "NVA297_SET_TESSELLATION_LOD_U0_OR_DENSITY";
    case NVA297_SET_TESSELLATION_LOD_V0_OR_DETAIL:
        return "NVA297_SET_TESSELLATION_LOD_V0_OR_DETAIL";
    case NVA297_SET_TESSELLATION_LOD_U1_OR_W0:
        return "NVA297_SET_TESSELLATION_LOD_U1_OR_W0";
    case NVA297_SET_TESSELLATION_LOD_V1:
        return "NVA297_SET_TESSELLATION_LOD_V1";
    case NVA297_SET_TG_LOD_INTERIOR_U:
        return "NVA297_SET_TG_LOD_INTERIOR_U";
    case NVA297_SET_TG_LOD_INTERIOR_V:
        return "NVA297_SET_TG_LOD_INTERIOR_V";
    case NVA297_RESERVED_TG07:
        return "NVA297_RESERVED_TG07";
    case NVA297_RESERVED_TG08:
        return "NVA297_RESERVED_TG08";
    case NVA297_RESERVED_TG09:
        return "NVA297_RESERVED_TG09";
    case NVA297_RESERVED_TG10:
        return "NVA297_RESERVED_TG10";
    case NVA297_RESERVED_TG11:
        return "NVA297_RESERVED_TG11";
    case NVA297_RESERVED_TG12:
        return "NVA297_RESERVED_TG12";
    case NVA297_RESERVED_TG13:
        return "NVA297_RESERVED_TG13";
    case NVA297_RESERVED_TG14:
        return "NVA297_RESERVED_TG14";
    case NVA297_RESERVED_TG15:
        return "NVA297_RESERVED_TG15";
    case NVA297_SET_SUBTILING_PERF_KNOB_A:
        return "NVA297_SET_SUBTILING_PERF_KNOB_A";
    case NVA297_SET_SUBTILING_PERF_KNOB_B:
        return "NVA297_SET_SUBTILING_PERF_KNOB_B";
    case NVA297_SET_SUBTILING_PERF_KNOB_C:
        return "NVA297_SET_SUBTILING_PERF_KNOB_C";
    case NVA297_SET_ZCULL_SUBREGION_TO_REPORT:
        return "NVA297_SET_ZCULL_SUBREGION_TO_REPORT";
    case NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE:
        return "NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE";
    case NVA297_SET_BALANCED_PRIMITIVE_WORKLOAD:
        return "NVA297_SET_BALANCED_PRIMITIVE_WORKLOAD";
    case NVA297_SET_MAX_PATCHES_PER_BATCH:
        return "NVA297_SET_MAX_PATCHES_PER_BATCH";
    case NVA297_SET_RASTER_ENABLE:
        return "NVA297_SET_RASTER_ENABLE";
    case NVA297_SET_STREAM_OUT_BUFFER_ENABLE(0):
        return "NVA297_SET_STREAM_OUT_BUFFER_ENABLE(0)";
    case NVA297_SET_STREAM_OUT_BUFFER_ENABLE(1):
        return "NVA297_SET_STREAM_OUT_BUFFER_ENABLE(1)";
    case NVA297_SET_STREAM_OUT_BUFFER_ENABLE(2):
        return "NVA297_SET_STREAM_OUT_BUFFER_ENABLE(2)";
    case NVA297_SET_STREAM_OUT_BUFFER_ENABLE(3):
        return "NVA297_SET_STREAM_OUT_BUFFER_ENABLE(3)";
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(0):
        return "NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(0)";
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(1):
        return "NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(1)";
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(2):
        return "NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(2)";
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(3):
        return "NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(3)";
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(0):
        return "NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(0)";
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(1):
        return "NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(1)";
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(2):
        return "NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(2)";
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(3):
        return "NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(3)";
    case NVA297_SET_STREAM_OUT_BUFFER_SIZE(0):
        return "NVA297_SET_STREAM_OUT_BUFFER_SIZE(0)";
    case NVA297_SET_STREAM_OUT_BUFFER_SIZE(1):
        return "NVA297_SET_STREAM_OUT_BUFFER_SIZE(1)";
    case NVA297_SET_STREAM_OUT_BUFFER_SIZE(2):
        return "NVA297_SET_STREAM_OUT_BUFFER_SIZE(2)";
    case NVA297_SET_STREAM_OUT_BUFFER_SIZE(3):
        return "NVA297_SET_STREAM_OUT_BUFFER_SIZE(3)";
    case NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(0):
        return "NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(0)";
    case NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(1):
        return "NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(1)";
    case NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(2):
        return "NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(2)";
    case NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(3):
        return "NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(3)";
        case NVA297_SET_STREAM_OUT_CONTROL_STREAM(0):
        return "NVA297_SET_STREAM_OUT_CONTROL_STREAM(0)";
    case NVA297_SET_STREAM_OUT_CONTROL_STREAM(1):
        return "NVA297_SET_STREAM_OUT_CONTROL_STREAM(1)";
    case NVA297_SET_STREAM_OUT_CONTROL_STREAM(2):
        return "NVA297_SET_STREAM_OUT_CONTROL_STREAM(2)";
    case NVA297_SET_STREAM_OUT_CONTROL_STREAM(3):
        return "NVA297_SET_STREAM_OUT_CONTROL_STREAM(3)";
    case NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(0):
        return "NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(0)";
    case NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(1):
        return "NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(1)";
    case NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(2):
        return "NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(2)";
    case NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(3):
        return "NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(3)";
    case NVA297_SET_STREAM_OUT_CONTROL_STRIDE(0):
        return "NVA297_SET_STREAM_OUT_CONTROL_STRIDE(0)";
    case NVA297_SET_STREAM_OUT_CONTROL_STRIDE(1):
        return "NVA297_SET_STREAM_OUT_CONTROL_STRIDE(1)";
    case NVA297_SET_STREAM_OUT_CONTROL_STRIDE(2):
        return "NVA297_SET_STREAM_OUT_CONTROL_STRIDE(2)";
    case NVA297_SET_STREAM_OUT_CONTROL_STRIDE(3):
        return "NVA297_SET_STREAM_OUT_CONTROL_STRIDE(3)";
    case NVA297_SET_RASTER_INPUT:
        return "NVA297_SET_RASTER_INPUT";
    case NVA297_SET_STREAM_OUTPUT:
        return "NVA297_SET_STREAM_OUTPUT";
    case NVA297_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE:
        return "NVA297_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE";
    case NVA297_SET_ALPHA_FRACTION:
        return "NVA297_SET_ALPHA_FRACTION";
    case NVA297_SET_HYBRID_ANTI_ALIAS_CONTROL:
        return "NVA297_SET_HYBRID_ANTI_ALIAS_CONTROL";
    case NVA297_SET_MAX_TI_WARPS_PER_BATCH:
        return "NVA297_SET_MAX_TI_WARPS_PER_BATCH";
    case NVA297_SET_SHADER_LOCAL_MEMORY_WINDOW:
        return "NVA297_SET_SHADER_LOCAL_MEMORY_WINDOW";
    case NVA297_SET_SHADER_LOCAL_MEMORY_A:
        return "NVA297_SET_SHADER_LOCAL_MEMORY_A";
    case NVA297_SET_SHADER_LOCAL_MEMORY_B:
        return "NVA297_SET_SHADER_LOCAL_MEMORY_B";
    case NVA297_SET_SHADER_LOCAL_MEMORY_C:
        return "NVA297_SET_SHADER_LOCAL_MEMORY_C";
    case NVA297_SET_SHADER_LOCAL_MEMORY_D:
        return "NVA297_SET_SHADER_LOCAL_MEMORY_D";
    case NVA297_SET_SHADER_LOCAL_MEMORY_E:
        return "NVA297_SET_SHADER_LOCAL_MEMORY_E";
    case NVA297_SET_COLOR_ZERO_BANDWIDTH_CLEAR:
        return "NVA297_SET_COLOR_ZERO_BANDWIDTH_CLEAR";
    case NVA297_SET_Z_ZERO_BANDWIDTH_CLEAR:
        return "NVA297_SET_Z_ZERO_BANDWIDTH_CLEAR";
    case NVA297_SET_ISBE_SAVE_RESTORE_PROGRAM:
        return "NVA297_SET_ISBE_SAVE_RESTORE_PROGRAM";
        case NVA297_SET_ZCULL_REGION_SIZE_A:
        return "NVA297_SET_ZCULL_REGION_SIZE_A";
    case NVA297_SET_ZCULL_REGION_SIZE_B:
        return "NVA297_SET_ZCULL_REGION_SIZE_B";
    case NVA297_SET_ZCULL_REGION_SIZE_C:
        return "NVA297_SET_ZCULL_REGION_SIZE_C";
    case NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_C:
        return "NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_C";
    case NVA297_SET_CULL_BEFORE_FETCH:
        return "NVA297_SET_CULL_BEFORE_FETCH";
    case NVA297_SET_ZCULL_REGION_LOCATION:
        return "NVA297_SET_ZCULL_REGION_LOCATION";
    case NVA297_SET_ZCULL_REGION_ALIQUOTS:
        return "NVA297_SET_ZCULL_REGION_ALIQUOTS";
    case NVA297_SET_ZCULL_STORAGE_A:
        return "NVA297_SET_ZCULL_STORAGE_A";
    case NVA297_SET_ZCULL_STORAGE_B:
        return "NVA297_SET_ZCULL_STORAGE_B";
    case NVA297_SET_ZCULL_STORAGE_C:
        return "NVA297_SET_ZCULL_STORAGE_C";
    case NVA297_SET_ZCULL_STORAGE_D:
        return "NVA297_SET_ZCULL_STORAGE_D";
    case NVA297_SET_ZT_READ_ONLY:
        return "NVA297_SET_ZT_READ_ONLY";
    case NVA297_SET_TEXTURE_INSTRUCTION_OPERAND:
        return "NVA297_SET_TEXTURE_INSTRUCTION_OPERAND";
    case NVA297_SET_COLOR_TARGET_A(0):
        return "NVA297_SET_COLOR_TARGET_A(0)";
    case NVA297_SET_COLOR_TARGET_A(1):
        return "NVA297_SET_COLOR_TARGET_A(1)";
    case NVA297_SET_COLOR_TARGET_A(2):
        return "NVA297_SET_COLOR_TARGET_A(2)";
    case NVA297_SET_COLOR_TARGET_A(3):
        return "NVA297_SET_COLOR_TARGET_A(3)";
    case NVA297_SET_COLOR_TARGET_A(4):
        return "NVA297_SET_COLOR_TARGET_A(4)";
    case NVA297_SET_COLOR_TARGET_A(5):
        return "NVA297_SET_COLOR_TARGET_A(5)";
    case NVA297_SET_COLOR_TARGET_A(6):
        return "NVA297_SET_COLOR_TARGET_A(6)";
    case NVA297_SET_COLOR_TARGET_A(7):
        return "NVA297_SET_COLOR_TARGET_A(7)";
    case NVA297_SET_COLOR_TARGET_B(0):
        return "NVA297_SET_COLOR_TARGET_B(0)";
    case NVA297_SET_COLOR_TARGET_B(1):
        return "NVA297_SET_COLOR_TARGET_B(1)";
    case NVA297_SET_COLOR_TARGET_B(2):
        return "NVA297_SET_COLOR_TARGET_B(2)";
    case NVA297_SET_COLOR_TARGET_B(3):
        return "NVA297_SET_COLOR_TARGET_B(3)";
    case NVA297_SET_COLOR_TARGET_B(4):
        return "NVA297_SET_COLOR_TARGET_B(4)";
    case NVA297_SET_COLOR_TARGET_B(5):
        return "NVA297_SET_COLOR_TARGET_B(5)";
    case NVA297_SET_COLOR_TARGET_B(6):
        return "NVA297_SET_COLOR_TARGET_B(6)";
    case NVA297_SET_COLOR_TARGET_B(7):
        return "NVA297_SET_COLOR_TARGET_B(7)";
    case NVA297_SET_COLOR_TARGET_WIDTH(0):
        return "NVA297_SET_COLOR_TARGET_WIDTH(0)";
    case NVA297_SET_COLOR_TARGET_WIDTH(1):
        return "NVA297_SET_COLOR_TARGET_WIDTH(1)";
    case NVA297_SET_COLOR_TARGET_WIDTH(2):
        return "NVA297_SET_COLOR_TARGET_WIDTH(2)";
    case NVA297_SET_COLOR_TARGET_WIDTH(3):
        return "NVA297_SET_COLOR_TARGET_WIDTH(3)";
    case NVA297_SET_COLOR_TARGET_WIDTH(4):
        return "NVA297_SET_COLOR_TARGET_WIDTH(4)";
    case NVA297_SET_COLOR_TARGET_WIDTH(5):
        return "NVA297_SET_COLOR_TARGET_WIDTH(5)";
    case NVA297_SET_COLOR_TARGET_WIDTH(6):
        return "NVA297_SET_COLOR_TARGET_WIDTH(6)";
    case NVA297_SET_COLOR_TARGET_WIDTH(7):
        return "NVA297_SET_COLOR_TARGET_WIDTH(7)";
    case NVA297_SET_COLOR_TARGET_HEIGHT(0):
        return "NVA297_SET_COLOR_TARGET_HEIGHT(0)";
    case NVA297_SET_COLOR_TARGET_HEIGHT(1):
        return "NVA297_SET_COLOR_TARGET_HEIGHT(1)";
    case NVA297_SET_COLOR_TARGET_HEIGHT(2):
        return "NVA297_SET_COLOR_TARGET_HEIGHT(2)";
    case NVA297_SET_COLOR_TARGET_HEIGHT(3):
        return "NVA297_SET_COLOR_TARGET_HEIGHT(3)";
    case NVA297_SET_COLOR_TARGET_HEIGHT(4):
        return "NVA297_SET_COLOR_TARGET_HEIGHT(4)";
    case NVA297_SET_COLOR_TARGET_HEIGHT(5):
        return "NVA297_SET_COLOR_TARGET_HEIGHT(5)";
    case NVA297_SET_COLOR_TARGET_HEIGHT(6):
        return "NVA297_SET_COLOR_TARGET_HEIGHT(6)";
    case NVA297_SET_COLOR_TARGET_HEIGHT(7):
        return "NVA297_SET_COLOR_TARGET_HEIGHT(7)";
    case NVA297_SET_COLOR_TARGET_FORMAT(0):
        return "NVA297_SET_COLOR_TARGET_FORMAT(0)";
    case NVA297_SET_COLOR_TARGET_FORMAT(1):
        return "NVA297_SET_COLOR_TARGET_FORMAT(1)";
    case NVA297_SET_COLOR_TARGET_FORMAT(2):
        return "NVA297_SET_COLOR_TARGET_FORMAT(2)";
    case NVA297_SET_COLOR_TARGET_FORMAT(3):
        return "NVA297_SET_COLOR_TARGET_FORMAT(3)";
    case NVA297_SET_COLOR_TARGET_FORMAT(4):
        return "NVA297_SET_COLOR_TARGET_FORMAT(4)";
    case NVA297_SET_COLOR_TARGET_FORMAT(5):
        return "NVA297_SET_COLOR_TARGET_FORMAT(5)";
    case NVA297_SET_COLOR_TARGET_FORMAT(6):
        return "NVA297_SET_COLOR_TARGET_FORMAT(6)";
    case NVA297_SET_COLOR_TARGET_FORMAT(7):
        return "NVA297_SET_COLOR_TARGET_FORMAT(7)";
    case NVA297_SET_COLOR_TARGET_MEMORY(0):
        return "NVA297_SET_COLOR_TARGET_MEMORY(0)";
    case NVA297_SET_COLOR_TARGET_MEMORY(1):
        return "NVA297_SET_COLOR_TARGET_MEMORY(1)";
    case NVA297_SET_COLOR_TARGET_MEMORY(2):
        return "NVA297_SET_COLOR_TARGET_MEMORY(2)";
    case NVA297_SET_COLOR_TARGET_MEMORY(3):
        return "NVA297_SET_COLOR_TARGET_MEMORY(3)";
    case NVA297_SET_COLOR_TARGET_MEMORY(4):
        return "NVA297_SET_COLOR_TARGET_MEMORY(4)";
    case NVA297_SET_COLOR_TARGET_MEMORY(5):
        return "NVA297_SET_COLOR_TARGET_MEMORY(5)";
    case NVA297_SET_COLOR_TARGET_MEMORY(6):
        return "NVA297_SET_COLOR_TARGET_MEMORY(6)";
    case NVA297_SET_COLOR_TARGET_MEMORY(7):
        return "NVA297_SET_COLOR_TARGET_MEMORY(7)";
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(0):
        return "NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(0)";
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(1):
        return "NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(1)";
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(2):
        return "NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(2)";
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(3):
        return "NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(3)";
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(4):
        return "NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(4)";
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(5):
        return "NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(5)";
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(6):
        return "NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(6)";
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(7):
        return "NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(7)";
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(0):
        return "NVA297_SET_COLOR_TARGET_ARRAY_PITCH(0)";
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(1):
        return "NVA297_SET_COLOR_TARGET_ARRAY_PITCH(1)";
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(2):
        return "NVA297_SET_COLOR_TARGET_ARRAY_PITCH(2)";
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(3):
        return "NVA297_SET_COLOR_TARGET_ARRAY_PITCH(3)";
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(4):
        return "NVA297_SET_COLOR_TARGET_ARRAY_PITCH(4)";
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(5):
        return "NVA297_SET_COLOR_TARGET_ARRAY_PITCH(5)";
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(6):
        return "NVA297_SET_COLOR_TARGET_ARRAY_PITCH(6)";
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(7):
        return "NVA297_SET_COLOR_TARGET_ARRAY_PITCH(7)";
    case NVA297_SET_COLOR_TARGET_LAYER(0):
        return "NVA297_SET_COLOR_TARGET_LAYER(0)";
    case NVA297_SET_COLOR_TARGET_LAYER(1):
        return "NVA297_SET_COLOR_TARGET_LAYER(1)";
    case NVA297_SET_COLOR_TARGET_LAYER(2):
        return "NVA297_SET_COLOR_TARGET_LAYER(2)";
    case NVA297_SET_COLOR_TARGET_LAYER(3):
        return "NVA297_SET_COLOR_TARGET_LAYER(3)";
    case NVA297_SET_COLOR_TARGET_LAYER(4):
        return "NVA297_SET_COLOR_TARGET_LAYER(4)";
    case NVA297_SET_COLOR_TARGET_LAYER(5):
        return "NVA297_SET_COLOR_TARGET_LAYER(5)";
    case NVA297_SET_COLOR_TARGET_LAYER(6):
        return "NVA297_SET_COLOR_TARGET_LAYER(6)";
    case NVA297_SET_COLOR_TARGET_LAYER(7):
        return "NVA297_SET_COLOR_TARGET_LAYER(7)";
    case NVA297_SET_COLOR_TARGET_MARK(0):
        return "NVA297_SET_COLOR_TARGET_MARK(0)";
    case NVA297_SET_COLOR_TARGET_MARK(1):
        return "NVA297_SET_COLOR_TARGET_MARK(1)";
    case NVA297_SET_COLOR_TARGET_MARK(2):
        return "NVA297_SET_COLOR_TARGET_MARK(2)";
    case NVA297_SET_COLOR_TARGET_MARK(3):
        return "NVA297_SET_COLOR_TARGET_MARK(3)";
    case NVA297_SET_COLOR_TARGET_MARK(4):
        return "NVA297_SET_COLOR_TARGET_MARK(4)";
    case NVA297_SET_COLOR_TARGET_MARK(5):
        return "NVA297_SET_COLOR_TARGET_MARK(5)";
    case NVA297_SET_COLOR_TARGET_MARK(6):
        return "NVA297_SET_COLOR_TARGET_MARK(6)";
    case NVA297_SET_COLOR_TARGET_MARK(7):
        return "NVA297_SET_COLOR_TARGET_MARK(7)";
    case NVA297_SET_VIEWPORT_SCALE_X(0):
        return "NVA297_SET_VIEWPORT_SCALE_X(0)";
    case NVA297_SET_VIEWPORT_SCALE_X(1):
        return "NVA297_SET_VIEWPORT_SCALE_X(1)";
    case NVA297_SET_VIEWPORT_SCALE_X(2):
        return "NVA297_SET_VIEWPORT_SCALE_X(2)";
    case NVA297_SET_VIEWPORT_SCALE_X(3):
        return "NVA297_SET_VIEWPORT_SCALE_X(3)";
    case NVA297_SET_VIEWPORT_SCALE_X(4):
        return "NVA297_SET_VIEWPORT_SCALE_X(4)";
    case NVA297_SET_VIEWPORT_SCALE_X(5):
        return "NVA297_SET_VIEWPORT_SCALE_X(5)";
    case NVA297_SET_VIEWPORT_SCALE_X(6):
        return "NVA297_SET_VIEWPORT_SCALE_X(6)";
    case NVA297_SET_VIEWPORT_SCALE_X(7):
        return "NVA297_SET_VIEWPORT_SCALE_X(7)";
    case NVA297_SET_VIEWPORT_SCALE_X(8):
        return "NVA297_SET_VIEWPORT_SCALE_X(8)";
    case NVA297_SET_VIEWPORT_SCALE_X(9):
        return "NVA297_SET_VIEWPORT_SCALE_X(9)";
    case NVA297_SET_VIEWPORT_SCALE_X(10):
        return "NVA297_SET_VIEWPORT_SCALE_X(10)";
    case NVA297_SET_VIEWPORT_SCALE_X(11):
        return "NVA297_SET_VIEWPORT_SCALE_X(11)";
    case NVA297_SET_VIEWPORT_SCALE_X(12):
        return "NVA297_SET_VIEWPORT_SCALE_X(12)";
    case NVA297_SET_VIEWPORT_SCALE_X(13):
        return "NVA297_SET_VIEWPORT_SCALE_X(13)";
    case NVA297_SET_VIEWPORT_SCALE_X(14):
        return "NVA297_SET_VIEWPORT_SCALE_X(14)";
    case NVA297_SET_VIEWPORT_SCALE_X(15):
        return "NVA297_SET_VIEWPORT_SCALE_X(15)";
    case NVA297_SET_VIEWPORT_SCALE_Y(0):
        return "NVA297_SET_VIEWPORT_SCALE_Y(0)";
    case NVA297_SET_VIEWPORT_SCALE_Y(1):
        return "NVA297_SET_VIEWPORT_SCALE_Y(1)";
    case NVA297_SET_VIEWPORT_SCALE_Y(2):
        return "NVA297_SET_VIEWPORT_SCALE_Y(2)";
    case NVA297_SET_VIEWPORT_SCALE_Y(3):
        return "NVA297_SET_VIEWPORT_SCALE_Y(3)";
    case NVA297_SET_VIEWPORT_SCALE_Y(4):
        return "NVA297_SET_VIEWPORT_SCALE_Y(4)";
    case NVA297_SET_VIEWPORT_SCALE_Y(5):
        return "NVA297_SET_VIEWPORT_SCALE_Y(5)";
    case NVA297_SET_VIEWPORT_SCALE_Y(6):
        return "NVA297_SET_VIEWPORT_SCALE_Y(6)";
    case NVA297_SET_VIEWPORT_SCALE_Y(7):
        return "NVA297_SET_VIEWPORT_SCALE_Y(7)";
    case NVA297_SET_VIEWPORT_SCALE_Y(8):
        return "NVA297_SET_VIEWPORT_SCALE_Y(8)";
    case NVA297_SET_VIEWPORT_SCALE_Y(9):
        return "NVA297_SET_VIEWPORT_SCALE_Y(9)";
    case NVA297_SET_VIEWPORT_SCALE_Y(10):
        return "NVA297_SET_VIEWPORT_SCALE_Y(10)";
    case NVA297_SET_VIEWPORT_SCALE_Y(11):
        return "NVA297_SET_VIEWPORT_SCALE_Y(11)";
    case NVA297_SET_VIEWPORT_SCALE_Y(12):
        return "NVA297_SET_VIEWPORT_SCALE_Y(12)";
    case NVA297_SET_VIEWPORT_SCALE_Y(13):
        return "NVA297_SET_VIEWPORT_SCALE_Y(13)";
    case NVA297_SET_VIEWPORT_SCALE_Y(14):
        return "NVA297_SET_VIEWPORT_SCALE_Y(14)";
    case NVA297_SET_VIEWPORT_SCALE_Y(15):
        return "NVA297_SET_VIEWPORT_SCALE_Y(15)";
    case NVA297_SET_VIEWPORT_SCALE_Z(0):
        return "NVA297_SET_VIEWPORT_SCALE_Z(0)";
    case NVA297_SET_VIEWPORT_SCALE_Z(1):
        return "NVA297_SET_VIEWPORT_SCALE_Z(1)";
    case NVA297_SET_VIEWPORT_SCALE_Z(2):
        return "NVA297_SET_VIEWPORT_SCALE_Z(2)";
    case NVA297_SET_VIEWPORT_SCALE_Z(3):
        return "NVA297_SET_VIEWPORT_SCALE_Z(3)";
    case NVA297_SET_VIEWPORT_SCALE_Z(4):
        return "NVA297_SET_VIEWPORT_SCALE_Z(4)";
    case NVA297_SET_VIEWPORT_SCALE_Z(5):
        return "NVA297_SET_VIEWPORT_SCALE_Z(5)";
    case NVA297_SET_VIEWPORT_SCALE_Z(6):
        return "NVA297_SET_VIEWPORT_SCALE_Z(6)";
    case NVA297_SET_VIEWPORT_SCALE_Z(7):
        return "NVA297_SET_VIEWPORT_SCALE_Z(7)";
    case NVA297_SET_VIEWPORT_SCALE_Z(8):
        return "NVA297_SET_VIEWPORT_SCALE_Z(8)";
    case NVA297_SET_VIEWPORT_SCALE_Z(9):
        return "NVA297_SET_VIEWPORT_SCALE_Z(9)";
    case NVA297_SET_VIEWPORT_SCALE_Z(10):
        return "NVA297_SET_VIEWPORT_SCALE_Z(10)";
    case NVA297_SET_VIEWPORT_SCALE_Z(11):
        return "NVA297_SET_VIEWPORT_SCALE_Z(11)";
    case NVA297_SET_VIEWPORT_SCALE_Z(12):
        return "NVA297_SET_VIEWPORT_SCALE_Z(12)";
    case NVA297_SET_VIEWPORT_SCALE_Z(13):
        return "NVA297_SET_VIEWPORT_SCALE_Z(13)";
    case NVA297_SET_VIEWPORT_SCALE_Z(14):
        return "NVA297_SET_VIEWPORT_SCALE_Z(14)";
    case NVA297_SET_VIEWPORT_SCALE_Z(15):
        return "NVA297_SET_VIEWPORT_SCALE_Z(15)";
    case NVA297_SET_VIEWPORT_OFFSET_X(0):
        return "NVA297_SET_VIEWPORT_OFFSET_X(0)";
    case NVA297_SET_VIEWPORT_OFFSET_X(1):
        return "NVA297_SET_VIEWPORT_OFFSET_X(1)";
    case NVA297_SET_VIEWPORT_OFFSET_X(2):
        return "NVA297_SET_VIEWPORT_OFFSET_X(2)";
    case NVA297_SET_VIEWPORT_OFFSET_X(3):
        return "NVA297_SET_VIEWPORT_OFFSET_X(3)";
    case NVA297_SET_VIEWPORT_OFFSET_X(4):
        return "NVA297_SET_VIEWPORT_OFFSET_X(4)";
    case NVA297_SET_VIEWPORT_OFFSET_X(5):
        return "NVA297_SET_VIEWPORT_OFFSET_X(5)";
    case NVA297_SET_VIEWPORT_OFFSET_X(6):
        return "NVA297_SET_VIEWPORT_OFFSET_X(6)";
    case NVA297_SET_VIEWPORT_OFFSET_X(7):
        return "NVA297_SET_VIEWPORT_OFFSET_X(7)";
    case NVA297_SET_VIEWPORT_OFFSET_X(8):
        return "NVA297_SET_VIEWPORT_OFFSET_X(8)";
    case NVA297_SET_VIEWPORT_OFFSET_X(9):
        return "NVA297_SET_VIEWPORT_OFFSET_X(9)";
    case NVA297_SET_VIEWPORT_OFFSET_X(10):
        return "NVA297_SET_VIEWPORT_OFFSET_X(10)";
    case NVA297_SET_VIEWPORT_OFFSET_X(11):
        return "NVA297_SET_VIEWPORT_OFFSET_X(11)";
    case NVA297_SET_VIEWPORT_OFFSET_X(12):
        return "NVA297_SET_VIEWPORT_OFFSET_X(12)";
    case NVA297_SET_VIEWPORT_OFFSET_X(13):
        return "NVA297_SET_VIEWPORT_OFFSET_X(13)";
    case NVA297_SET_VIEWPORT_OFFSET_X(14):
        return "NVA297_SET_VIEWPORT_OFFSET_X(14)";
    case NVA297_SET_VIEWPORT_OFFSET_X(15):
        return "NVA297_SET_VIEWPORT_OFFSET_X(15)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(0):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(0)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(1):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(1)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(2):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(2)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(3):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(3)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(4):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(4)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(5):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(5)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(6):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(6)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(7):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(7)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(8):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(8)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(9):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(9)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(10):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(10)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(11):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(11)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(12):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(12)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(13):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(13)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(14):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(14)";
    case NVA297_SET_VIEWPORT_OFFSET_Y(15):
        return "NVA297_SET_VIEWPORT_OFFSET_Y(15)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(0):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(0)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(1):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(1)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(2):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(2)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(3):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(3)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(4):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(4)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(5):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(5)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(6):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(6)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(7):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(7)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(8):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(8)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(9):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(9)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(10):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(10)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(11):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(11)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(12):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(12)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(13):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(13)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(14):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(14)";
    case NVA297_SET_VIEWPORT_OFFSET_Z(15):
        return "NVA297_SET_VIEWPORT_OFFSET_Z(15)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(0):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(0)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(1):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(1)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(2):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(2)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(3):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(3)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(4):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(4)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(5):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(5)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(6):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(6)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(7):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(7)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(8):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(8)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(9):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(9)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(10):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(10)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(11):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(11)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(12):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(12)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(13):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(13)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(14):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(14)";
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(15):
        return "NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(15)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(0):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(0)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(1):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(1)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(2):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(2)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(3):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(3)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(4):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(4)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(5):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(5)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(6):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(6)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(7):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(7)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(8):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(8)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(9):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(9)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(10):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(10)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(11):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(11)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(12):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(12)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(13):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(13)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(14):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(14)";
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(15):
        return "NVA297_SET_VIEWPORT_CLIP_VERTICAL(15)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(0):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(0)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(1):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(1)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(2):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(2)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(3):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(3)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(4):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(4)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(5):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(5)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(6):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(6)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(7):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(7)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(8):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(8)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(9):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(9)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(10):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(10)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(11):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(11)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(12):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(12)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(13):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(13)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(14):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(14)";
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(15):
        return "NVA297_SET_VIEWPORT_CLIP_MIN_Z(15)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(0):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(0)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(1):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(1)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(2):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(2)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(3):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(3)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(4):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(4)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(5):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(5)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(6):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(6)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(7):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(7)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(8):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(8)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(9):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(9)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(10):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(10)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(11):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(11)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(12):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(12)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(13):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(13)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(14):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(14)";
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(15):
        return "NVA297_SET_VIEWPORT_CLIP_MAX_Z(15)";
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(0):
        return "NVA297_SET_WINDOW_CLIP_HORIZONTAL(0)";
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(1):
        return "NVA297_SET_WINDOW_CLIP_HORIZONTAL(1)";
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(2):
        return "NVA297_SET_WINDOW_CLIP_HORIZONTAL(2)";
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(3):
        return "NVA297_SET_WINDOW_CLIP_HORIZONTAL(3)";
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(4):
        return "NVA297_SET_WINDOW_CLIP_HORIZONTAL(4)";
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(5):
        return "NVA297_SET_WINDOW_CLIP_HORIZONTAL(5)";
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(6):
        return "NVA297_SET_WINDOW_CLIP_HORIZONTAL(6)";
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(7):
        return "NVA297_SET_WINDOW_CLIP_HORIZONTAL(7)";
    case NVA297_SET_WINDOW_CLIP_VERTICAL(0):
        return "NVA297_SET_WINDOW_CLIP_VERTICAL(0)";
    case NVA297_SET_WINDOW_CLIP_VERTICAL(1):
        return "NVA297_SET_WINDOW_CLIP_VERTICAL(1)";
    case NVA297_SET_WINDOW_CLIP_VERTICAL(2):
        return "NVA297_SET_WINDOW_CLIP_VERTICAL(2)";
    case NVA297_SET_WINDOW_CLIP_VERTICAL(3):
        return "NVA297_SET_WINDOW_CLIP_VERTICAL(3)";
    case NVA297_SET_WINDOW_CLIP_VERTICAL(4):
        return "NVA297_SET_WINDOW_CLIP_VERTICAL(4)";
    case NVA297_SET_WINDOW_CLIP_VERTICAL(5):
        return "NVA297_SET_WINDOW_CLIP_VERTICAL(5)";
    case NVA297_SET_WINDOW_CLIP_VERTICAL(6):
        return "NVA297_SET_WINDOW_CLIP_VERTICAL(6)";
    case NVA297_SET_WINDOW_CLIP_VERTICAL(7):
        return "NVA297_SET_WINDOW_CLIP_VERTICAL(7)";
    case NVA297_SET_CLIP_ID_EXTENT_X(0):
        return "NVA297_SET_CLIP_ID_EXTENT_X(0)";
    case NVA297_SET_CLIP_ID_EXTENT_X(1):
        return "NVA297_SET_CLIP_ID_EXTENT_X(1)";
    case NVA297_SET_CLIP_ID_EXTENT_X(2):
        return "NVA297_SET_CLIP_ID_EXTENT_X(2)";
    case NVA297_SET_CLIP_ID_EXTENT_X(3):
        return "NVA297_SET_CLIP_ID_EXTENT_X(3)";
    case NVA297_SET_CLIP_ID_EXTENT_Y(0):
        return "NVA297_SET_CLIP_ID_EXTENT_Y(0)";
    case NVA297_SET_CLIP_ID_EXTENT_Y(1):
        return "NVA297_SET_CLIP_ID_EXTENT_Y(1)";
    case NVA297_SET_CLIP_ID_EXTENT_Y(2):
        return "NVA297_SET_CLIP_ID_EXTENT_Y(2)";
    case NVA297_SET_CLIP_ID_EXTENT_Y(3):
        return "NVA297_SET_CLIP_ID_EXTENT_Y(3)";
    case NVA297_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK:
        return "NVA297_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK";
    case NVA297_SET_API_VISIBLE_CALL_LIMIT:
        return "NVA297_SET_API_VISIBLE_CALL_LIMIT";
    case NVA297_SET_STATISTICS_COUNTER:
        return "NVA297_SET_STATISTICS_COUNTER";
    case NVA297_SET_CLEAR_RECT_HORIZONTAL:
        return "NVA297_SET_CLEAR_RECT_HORIZONTAL";
    case NVA297_SET_CLEAR_RECT_VERTICAL:
        return "NVA297_SET_CLEAR_RECT_VERTICAL";
    case NVA297_SET_VERTEX_ARRAY_START:
        return "NVA297_SET_VERTEX_ARRAY_START";
    case NVA297_DRAW_VERTEX_ARRAY:
        return "NVA297_DRAW_VERTEX_ARRAY";
    case NVA297_SET_VIEWPORT_Z_CLIP:
        return "NVA297_SET_VIEWPORT_Z_CLIP";
    case NVA297_SET_COLOR_CLEAR_VALUE(0):
        return "NVA297_SET_COLOR_CLEAR_VALUE(0)";
    case NVA297_SET_COLOR_CLEAR_VALUE(1):
        return "NVA297_SET_COLOR_CLEAR_VALUE(1)";
    case NVA297_SET_COLOR_CLEAR_VALUE(2):
        return "NVA297_SET_COLOR_CLEAR_VALUE(2)";
    case NVA297_SET_COLOR_CLEAR_VALUE(3):
        return "NVA297_SET_COLOR_CLEAR_VALUE(3)";
    case NVA297_SET_Z_CLEAR_VALUE:
        return "NVA297_SET_Z_CLEAR_VALUE";
    case NVA297_SET_SHADER_CACHE_CONTROL:
        return "NVA297_SET_SHADER_CACHE_CONTROL";
    case NVA297_FORCE_TRANSITION_TO_BETA:
        return "NVA297_FORCE_TRANSITION_TO_BETA";
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_ENABLE:
        return "NVA297_SET_REDUCE_COLOR_THRESHOLDS_ENABLE";
    case NVA297_SET_STENCIL_CLEAR_VALUE:
        return "NVA297_SET_STENCIL_CLEAR_VALUE";
    case NVA297_INVALIDATE_SHADER_CACHES_NO_WFI:
        return "NVA297_INVALIDATE_SHADER_CACHES_NO_WFI";
    case NVA297_SET_ZCULL_SERIALIZATION:
        return "NVA297_SET_ZCULL_SERIALIZATION";
    case NVA297_SET_FRONT_POLYGON_MODE:
        return "NVA297_SET_FRONT_POLYGON_MODE";
    case NVA297_SET_BACK_POLYGON_MODE:
        return "NVA297_SET_BACK_POLYGON_MODE";
    case NVA297_SET_POLY_SMOOTH:
        return "NVA297_SET_POLY_SMOOTH";
    case NVA297_SET_ZT_MARK:
        return "NVA297_SET_ZT_MARK";
    case NVA297_SET_ZCULL_DIR_FORMAT:
        return "NVA297_SET_ZCULL_DIR_FORMAT";
    case NVA297_SET_POLY_OFFSET_POINT:
        return "NVA297_SET_POLY_OFFSET_POINT";
    case NVA297_SET_POLY_OFFSET_LINE:
        return "NVA297_SET_POLY_OFFSET_LINE";
    case NVA297_SET_POLY_OFFSET_FILL:
        return "NVA297_SET_POLY_OFFSET_FILL";
    case NVA297_SET_PATCH:
        return "NVA297_SET_PATCH";
    case NVA297_SET_ITERATED_BLEND:
        return "NVA297_SET_ITERATED_BLEND";
    case NVA297_SET_ITERATED_BLEND_PASS:
        return "NVA297_SET_ITERATED_BLEND_PASS";
    case NVA297_SET_ZCULL_CRITERION:
        return "NVA297_SET_ZCULL_CRITERION";
    case NVA297_SET_SM_QUADRANT_SELECTION_CONTROL:
        return "NVA297_SET_SM_QUADRANT_SELECTION_CONTROL";
    case NVA297_SET_SM_TIMEOUT_INTERVAL:
        return "NVA297_SET_SM_TIMEOUT_INTERVAL";
    case NVA297_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY:
        return "NVA297_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY";
    case NVA297_SET_DRAW_INLINE_VERTEX_VAB_UPDATE:
        return "NVA297_SET_DRAW_INLINE_VERTEX_VAB_UPDATE";
    case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_POINTER:
        return "NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_POINTER";
    case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION:
        return "NVA297_LOAD_ITERATED_BLEND_INSTRUCTION";
    case NVA297_SET_WINDOW_OFFSET_X:
        return "NVA297_SET_WINDOW_OFFSET_X";
    case NVA297_SET_WINDOW_OFFSET_Y:
        return "NVA297_SET_WINDOW_OFFSET_Y";
    case NVA297_SET_SCISSOR_ENABLE(0):
        return "NVA297_SET_SCISSOR_ENABLE(0)";
    case NVA297_SET_SCISSOR_ENABLE(1):
        return "NVA297_SET_SCISSOR_ENABLE(1)";
    case NVA297_SET_SCISSOR_ENABLE(2):
        return "NVA297_SET_SCISSOR_ENABLE(2)";
    case NVA297_SET_SCISSOR_ENABLE(3):
        return "NVA297_SET_SCISSOR_ENABLE(3)";
    case NVA297_SET_SCISSOR_ENABLE(4):
        return "NVA297_SET_SCISSOR_ENABLE(4)";
    case NVA297_SET_SCISSOR_ENABLE(5):
        return "NVA297_SET_SCISSOR_ENABLE(5)";
    case NVA297_SET_SCISSOR_ENABLE(6):
        return "NVA297_SET_SCISSOR_ENABLE(6)";
    case NVA297_SET_SCISSOR_ENABLE(7):
        return "NVA297_SET_SCISSOR_ENABLE(7)";
    case NVA297_SET_SCISSOR_ENABLE(8):
        return "NVA297_SET_SCISSOR_ENABLE(8)";
    case NVA297_SET_SCISSOR_ENABLE(9):
        return "NVA297_SET_SCISSOR_ENABLE(9)";
    case NVA297_SET_SCISSOR_ENABLE(10):
        return "NVA297_SET_SCISSOR_ENABLE(10)";
    case NVA297_SET_SCISSOR_ENABLE(11):
        return "NVA297_SET_SCISSOR_ENABLE(11)";
    case NVA297_SET_SCISSOR_ENABLE(12):
        return "NVA297_SET_SCISSOR_ENABLE(12)";
    case NVA297_SET_SCISSOR_ENABLE(13):
        return "NVA297_SET_SCISSOR_ENABLE(13)";
    case NVA297_SET_SCISSOR_ENABLE(14):
        return "NVA297_SET_SCISSOR_ENABLE(14)";
    case NVA297_SET_SCISSOR_ENABLE(15):
        return "NVA297_SET_SCISSOR_ENABLE(15)";
    case NVA297_SET_SCISSOR_HORIZONTAL(0):
        return "NVA297_SET_SCISSOR_HORIZONTAL(0)";
    case NVA297_SET_SCISSOR_HORIZONTAL(1):
        return "NVA297_SET_SCISSOR_HORIZONTAL(1)";
    case NVA297_SET_SCISSOR_HORIZONTAL(2):
        return "NVA297_SET_SCISSOR_HORIZONTAL(2)";
    case NVA297_SET_SCISSOR_HORIZONTAL(3):
        return "NVA297_SET_SCISSOR_HORIZONTAL(3)";
    case NVA297_SET_SCISSOR_HORIZONTAL(4):
        return "NVA297_SET_SCISSOR_HORIZONTAL(4)";
    case NVA297_SET_SCISSOR_HORIZONTAL(5):
        return "NVA297_SET_SCISSOR_HORIZONTAL(5)";
    case NVA297_SET_SCISSOR_HORIZONTAL(6):
        return "NVA297_SET_SCISSOR_HORIZONTAL(6)";
    case NVA297_SET_SCISSOR_HORIZONTAL(7):
        return "NVA297_SET_SCISSOR_HORIZONTAL(7)";
    case NVA297_SET_SCISSOR_HORIZONTAL(8):
        return "NVA297_SET_SCISSOR_HORIZONTAL(8)";
    case NVA297_SET_SCISSOR_HORIZONTAL(9):
        return "NVA297_SET_SCISSOR_HORIZONTAL(9)";
    case NVA297_SET_SCISSOR_HORIZONTAL(10):
        return "NVA297_SET_SCISSOR_HORIZONTAL(10)";
    case NVA297_SET_SCISSOR_HORIZONTAL(11):
        return "NVA297_SET_SCISSOR_HORIZONTAL(11)";
    case NVA297_SET_SCISSOR_HORIZONTAL(12):
        return "NVA297_SET_SCISSOR_HORIZONTAL(12)";
    case NVA297_SET_SCISSOR_HORIZONTAL(13):
        return "NVA297_SET_SCISSOR_HORIZONTAL(13)";
    case NVA297_SET_SCISSOR_HORIZONTAL(14):
        return "NVA297_SET_SCISSOR_HORIZONTAL(14)";
    case NVA297_SET_SCISSOR_HORIZONTAL(15):
        return "NVA297_SET_SCISSOR_HORIZONTAL(15)";
    case NVA297_SET_SCISSOR_VERTICAL(0):
        return "NVA297_SET_SCISSOR_VERTICAL(0)";
    case NVA297_SET_SCISSOR_VERTICAL(1):
        return "NVA297_SET_SCISSOR_VERTICAL(1)";
    case NVA297_SET_SCISSOR_VERTICAL(2):
        return "NVA297_SET_SCISSOR_VERTICAL(2)";
    case NVA297_SET_SCISSOR_VERTICAL(3):
        return "NVA297_SET_SCISSOR_VERTICAL(3)";
    case NVA297_SET_SCISSOR_VERTICAL(4):
        return "NVA297_SET_SCISSOR_VERTICAL(4)";
    case NVA297_SET_SCISSOR_VERTICAL(5):
        return "NVA297_SET_SCISSOR_VERTICAL(5)";
    case NVA297_SET_SCISSOR_VERTICAL(6):
        return "NVA297_SET_SCISSOR_VERTICAL(6)";
    case NVA297_SET_SCISSOR_VERTICAL(7):
        return "NVA297_SET_SCISSOR_VERTICAL(7)";
    case NVA297_SET_SCISSOR_VERTICAL(8):
        return "NVA297_SET_SCISSOR_VERTICAL(8)";
    case NVA297_SET_SCISSOR_VERTICAL(9):
        return "NVA297_SET_SCISSOR_VERTICAL(9)";
    case NVA297_SET_SCISSOR_VERTICAL(10):
        return "NVA297_SET_SCISSOR_VERTICAL(10)";
    case NVA297_SET_SCISSOR_VERTICAL(11):
        return "NVA297_SET_SCISSOR_VERTICAL(11)";
    case NVA297_SET_SCISSOR_VERTICAL(12):
        return "NVA297_SET_SCISSOR_VERTICAL(12)";
    case NVA297_SET_SCISSOR_VERTICAL(13):
        return "NVA297_SET_SCISSOR_VERTICAL(13)";
    case NVA297_SET_SCISSOR_VERTICAL(14):
        return "NVA297_SET_SCISSOR_VERTICAL(14)";
    case NVA297_SET_SCISSOR_VERTICAL(15):
        return "NVA297_SET_SCISSOR_VERTICAL(15)";
        case NVA297_SET_CONSTANT_COLOR_RENDERING:
        return "NVA297_SET_CONSTANT_COLOR_RENDERING";
    case NVA297_SET_CONSTANT_COLOR_RENDERING_RED:
        return "NVA297_SET_CONSTANT_COLOR_RENDERING_RED";
    case NVA297_SET_CONSTANT_COLOR_RENDERING_GREEN:
        return "NVA297_SET_CONSTANT_COLOR_RENDERING_GREEN";
    case NVA297_SET_CONSTANT_COLOR_RENDERING_BLUE:
        return "NVA297_SET_CONSTANT_COLOR_RENDERING_BLUE";
    case NVA297_SET_CONSTANT_COLOR_RENDERING_ALPHA:
        return "NVA297_SET_CONSTANT_COLOR_RENDERING_ALPHA";
    case NVA297_SET_BACK_STENCIL_FUNC_REF:
        return "NVA297_SET_BACK_STENCIL_FUNC_REF";
    case NVA297_SET_BACK_STENCIL_MASK:
        return "NVA297_SET_BACK_STENCIL_MASK";
    case NVA297_SET_BACK_STENCIL_FUNC_MASK:
        return "NVA297_SET_BACK_STENCIL_FUNC_MASK";
    case NVA297_SET_VERTEX_STREAM_SUBSTITUTE_A:
        return "NVA297_SET_VERTEX_STREAM_SUBSTITUTE_A";
    case NVA297_SET_VERTEX_STREAM_SUBSTITUTE_B:
        return "NVA297_SET_VERTEX_STREAM_SUBSTITUTE_B";
    case NVA297_SET_LINE_MODE_POLYGON_CLIP:
        return "NVA297_SET_LINE_MODE_POLYGON_CLIP";
    case NVA297_SET_SINGLE_CT_WRITE_CONTROL:
        return "NVA297_SET_SINGLE_CT_WRITE_CONTROL";
    case NVA297_SET_VTG_WARP_WATERMARKS:
        return "NVA297_SET_VTG_WARP_WATERMARKS";
    case NVA297_SET_DEPTH_BOUNDS_MIN:
        return "NVA297_SET_DEPTH_BOUNDS_MIN";
    case NVA297_SET_DEPTH_BOUNDS_MAX:
        return "NVA297_SET_DEPTH_BOUNDS_MAX";
    case NVA297_SET_CT_MRT_ENABLE:
        return "NVA297_SET_CT_MRT_ENABLE";
    case NVA297_SET_NONMULTISAMPLED_Z:
        return "NVA297_SET_NONMULTISAMPLED_Z";
    case NVA297_SET_SAMPLE_MASK_X0_Y0:
        return "NVA297_SET_SAMPLE_MASK_X0_Y0";
    case NVA297_SET_SAMPLE_MASK_X1_Y0:
        return "NVA297_SET_SAMPLE_MASK_X1_Y0";
    case NVA297_SET_SAMPLE_MASK_X0_Y1:
        return "NVA297_SET_SAMPLE_MASK_X0_Y1";
    case NVA297_SET_SAMPLE_MASK_X1_Y1:
        return "NVA297_SET_SAMPLE_MASK_X1_Y1";
    case NVA297_SET_SURFACE_CLIP_ID_MEMORY_A:
        return "NVA297_SET_SURFACE_CLIP_ID_MEMORY_A";
    case NVA297_SET_SURFACE_CLIP_ID_MEMORY_B:
        return "NVA297_SET_SURFACE_CLIP_ID_MEMORY_B";
    case NVA297_SET_BLEND_OPT_CONTROL:
        return "NVA297_SET_BLEND_OPT_CONTROL";
    case NVA297_SET_ZT_A:
        return "NVA297_SET_ZT_A";
    case NVA297_SET_ZT_B:
        return "NVA297_SET_ZT_B";
    case NVA297_SET_ZT_FORMAT:
        return "NVA297_SET_ZT_FORMAT";
    case NVA297_SET_ZT_BLOCK_SIZE:
        return "NVA297_SET_ZT_BLOCK_SIZE";
    case NVA297_SET_ZT_ARRAY_PITCH:
        return "NVA297_SET_ZT_ARRAY_PITCH";
    case NVA297_SET_SURFACE_CLIP_HORIZONTAL:
        return "NVA297_SET_SURFACE_CLIP_HORIZONTAL";
    case NVA297_SET_SURFACE_CLIP_VERTICAL:
        return "NVA297_SET_SURFACE_CLIP_VERTICAL";
    case NVA297_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS:
        return "NVA297_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS";
    case NVA297_SET_TESSELLATION_CUT_HEIGHT:
        return "NVA297_SET_TESSELLATION_CUT_HEIGHT";
    case NVA297_SET_MAX_GS_INSTANCES_PER_TASK:
        return "NVA297_SET_MAX_GS_INSTANCES_PER_TASK";
    case NVA297_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK:
        return "NVA297_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK";
    case NVA297_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER:
        return "NVA297_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER";
    case NVA297_SET_BETA_CB_STORAGE_CONSTRAINT:
        return "NVA297_SET_BETA_CB_STORAGE_CONSTRAINT";
    case NVA297_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER:
        return "NVA297_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER";
    case NVA297_SET_ALPHA_CB_STORAGE_CONSTRAINT:
        return "NVA297_SET_ALPHA_CB_STORAGE_CONSTRAINT";
    case NVA297_SET_SPARE_NOOP01:
        return "NVA297_SET_SPARE_NOOP01";
    case NVA297_SET_SPARE_NOOP02:
        return "NVA297_SET_SPARE_NOOP02";
    case NVA297_SET_SPARE_NOOP03:
        return "NVA297_SET_SPARE_NOOP03";
    case NVA297_SET_SPARE_NOOP04:
        return "NVA297_SET_SPARE_NOOP04";
    case NVA297_SET_SPARE_NOOP05:
        return "NVA297_SET_SPARE_NOOP05";
    case NVA297_SET_SPARE_NOOP06:
        return "NVA297_SET_SPARE_NOOP06";
    case NVA297_SET_SPARE_NOOP07:
        return "NVA297_SET_SPARE_NOOP07";
    case NVA297_SET_SPARE_NOOP08:
        return "NVA297_SET_SPARE_NOOP08";
    case NVA297_SET_SPARE_NOOP09:
        return "NVA297_SET_SPARE_NOOP09";
    case NVA297_SET_SPARE_NOOP10:
        return "NVA297_SET_SPARE_NOOP10";
    case NVA297_SET_SPARE_NOOP11:
        return "NVA297_SET_SPARE_NOOP11";
    case NVA297_SET_SPARE_NOOP12:
        return "NVA297_SET_SPARE_NOOP12";
    case NVA297_SET_SPARE_NOOP13:
        return "NVA297_SET_SPARE_NOOP13";
    case NVA297_SET_SPARE_NOOP14:
        return "NVA297_SET_SPARE_NOOP14";
    case NVA297_SET_SPARE_NOOP15:
        return "NVA297_SET_SPARE_NOOP15";
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM8:
        return "NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM8";
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM10:
        return "NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM10";
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM16:
        return "NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM16";
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_FP11:
        return "NVA297_SET_REDUCE_COLOR_THRESHOLDS_FP11";
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_FP16:
        return "NVA297_SET_REDUCE_COLOR_THRESHOLDS_FP16";
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_SRGB8:
        return "NVA297_SET_REDUCE_COLOR_THRESHOLDS_SRGB8";
    case NVA297_UNBIND_ALL:
        return "NVA297_UNBIND_ALL";
    case NVA297_SET_CLEAR_SURFACE_CONTROL:
        return "NVA297_SET_CLEAR_SURFACE_CONTROL";
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS:
        return "NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS";
    case NVA297_NO_OPERATION_DATA_HI:
        return "NVA297_NO_OPERATION_DATA_HI";
    case NVA297_SET_DEPTH_BIAS_CONTROL:
        return "NVA297_SET_DEPTH_BIAS_CONTROL";
    case NVA297_PM_TRIGGER_END:
        return "NVA297_PM_TRIGGER_END";
    case NVA297_SET_VERTEX_ID_BASE:
        return "NVA297_SET_VERTEX_ID_BASE";
            case NVA297_SET_BLEND_PER_FORMAT_ENABLE:
        return "NVA297_SET_BLEND_PER_FORMAT_ENABLE";
    case NVA297_FLUSH_PENDING_WRITES:
        return "NVA297_FLUSH_PENDING_WRITES";
    case NVA297_SET_VAB_DATA_CONTROL:
        return "NVA297_SET_VAB_DATA_CONTROL";
        case NVA297_SET_VERTEX_ATTRIBUTE_A(0):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(0)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(1):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(1)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(2):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(2)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(3):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(3)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(4):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(4)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(5):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(5)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(6):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(6)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(7):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(7)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(8):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(8)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(9):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(9)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(10):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(10)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(11):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(11)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(12):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(12)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(13):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(13)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(14):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(14)";
    case NVA297_SET_VERTEX_ATTRIBUTE_A(15):
        return "NVA297_SET_VERTEX_ATTRIBUTE_A(15)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(0):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(0)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(1):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(1)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(2):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(2)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(3):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(3)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(4):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(4)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(5):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(5)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(6):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(6)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(7):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(7)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(8):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(8)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(9):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(9)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(10):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(10)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(11):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(11)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(12):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(12)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(13):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(13)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(14):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(14)";
    case NVA297_SET_VERTEX_ATTRIBUTE_B(15):
        return "NVA297_SET_VERTEX_ATTRIBUTE_B(15)";
    case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST:
        return "NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST";
    case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT:
        return "NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT";
    case NVA297_SET_CT_SELECT:
        return "NVA297_SET_CT_SELECT";
    case NVA297_SET_COMPRESSION_THRESHOLD:
        return "NVA297_SET_COMPRESSION_THRESHOLD";
    case NVA297_SET_ZT_SIZE_A:
        return "NVA297_SET_ZT_SIZE_A";
    case NVA297_SET_ZT_SIZE_B:
        return "NVA297_SET_ZT_SIZE_B";
    case NVA297_SET_ZT_SIZE_C:
        return "NVA297_SET_ZT_SIZE_C";
    case NVA297_SET_SAMPLER_BINDING:
        return "NVA297_SET_SAMPLER_BINDING";
    case NVA297_DRAW_AUTO:
        return "NVA297_DRAW_AUTO";
    case NVA297_SET_CIRCULAR_BUFFER_SIZE:
        return "NVA297_SET_CIRCULAR_BUFFER_SIZE";
    case NVA297_SET_VTG_REGISTER_WATERMARKS:
        return "NVA297_SET_VTG_REGISTER_WATERMARKS";
    case NVA297_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
        return "NVA297_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI";
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS:
        return "NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS";
    case NVA297_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE:
        return "NVA297_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE";
    case NVA297_SET_SHADER_SCHEDULING:
        return "NVA297_SET_SHADER_SCHEDULING";
    case NVA297_CLEAR_ZCULL_REGION:
        return "NVA297_CLEAR_ZCULL_REGION";
    case NVA297_SET_DEPTH_TEST:
        return "NVA297_SET_DEPTH_TEST";
    case NVA297_SET_FILL_MODE:
        return "NVA297_SET_FILL_MODE";
    case NVA297_SET_SHADE_MODE:
        return "NVA297_SET_SHADE_MODE";
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS:
        return "NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS";
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS:
        return "NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS";
    case NVA297_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL:
        return "NVA297_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL";
    case NVA297_SET_BLEND_STATE_PER_TARGET:
        return "NVA297_SET_BLEND_STATE_PER_TARGET";
    case NVA297_SET_DEPTH_WRITE:
        return "NVA297_SET_DEPTH_WRITE";
    case NVA297_SET_ALPHA_TEST:
        return "NVA297_SET_ALPHA_TEST";
    case NVA297_SET_INLINE_INDEX4X8_ALIGN:
        return "NVA297_SET_INLINE_INDEX4X8_ALIGN";
    case NVA297_DRAW_INLINE_INDEX4X8:
        return "NVA297_DRAW_INLINE_INDEX4X8";
    case NVA297_D3D_SET_CULL_MODE:
        return "NVA297_D3D_SET_CULL_MODE";
    case NVA297_SET_DEPTH_FUNC:
        return "NVA297_SET_DEPTH_FUNC";
    case NVA297_SET_ALPHA_REF:
        return "NVA297_SET_ALPHA_REF";
    case NVA297_SET_ALPHA_FUNC:
        return "NVA297_SET_ALPHA_FUNC";
    case NVA297_SET_DRAW_AUTO_STRIDE:
        return "NVA297_SET_DRAW_AUTO_STRIDE";
    case NVA297_SET_BLEND_CONST_RED:
        return "NVA297_SET_BLEND_CONST_RED";
    case NVA297_SET_BLEND_CONST_GREEN:
        return "NVA297_SET_BLEND_CONST_GREEN";
    case NVA297_SET_BLEND_CONST_BLUE:
        return "NVA297_SET_BLEND_CONST_BLUE";
    case NVA297_SET_BLEND_CONST_ALPHA:
        return "NVA297_SET_BLEND_CONST_ALPHA";
    case NVA297_INVALIDATE_SAMPLER_CACHE:
        return "NVA297_INVALIDATE_SAMPLER_CACHE";
    case NVA297_INVALIDATE_TEXTURE_HEADER_CACHE:
        return "NVA297_INVALIDATE_TEXTURE_HEADER_CACHE";
    case NVA297_INVALIDATE_TEXTURE_DATA_CACHE:
        return "NVA297_INVALIDATE_TEXTURE_DATA_CACHE";
    case NVA297_SET_BLEND_SEPARATE_FOR_ALPHA:
        return "NVA297_SET_BLEND_SEPARATE_FOR_ALPHA";
    case NVA297_SET_BLEND_COLOR_OP:
        return "NVA297_SET_BLEND_COLOR_OP";
    case NVA297_SET_BLEND_COLOR_SOURCE_COEFF:
        return "NVA297_SET_BLEND_COLOR_SOURCE_COEFF";
    case NVA297_SET_BLEND_COLOR_DEST_COEFF:
        return "NVA297_SET_BLEND_COLOR_DEST_COEFF";
    case NVA297_SET_BLEND_ALPHA_OP:
        return "NVA297_SET_BLEND_ALPHA_OP";
    case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF:
        return "NVA297_SET_BLEND_ALPHA_SOURCE_COEFF";
    case NVA297_SET_GLOBAL_COLOR_KEY:
        return "NVA297_SET_GLOBAL_COLOR_KEY";
    case NVA297_SET_BLEND_ALPHA_DEST_COEFF:
        return "NVA297_SET_BLEND_ALPHA_DEST_COEFF";
    case NVA297_SET_SINGLE_ROP_CONTROL:
        return "NVA297_SET_SINGLE_ROP_CONTROL";
    case NVA297_SET_BLEND(0):
        return "NVA297_SET_BLEND(0)";
    case NVA297_SET_BLEND(1):
        return "NVA297_SET_BLEND(1)";
    case NVA297_SET_BLEND(2):
        return "NVA297_SET_BLEND(2)";
    case NVA297_SET_BLEND(3):
        return "NVA297_SET_BLEND(3)";
    case NVA297_SET_BLEND(4):
        return "NVA297_SET_BLEND(4)";
    case NVA297_SET_BLEND(5):
        return "NVA297_SET_BLEND(5)";
    case NVA297_SET_BLEND(6):
        return "NVA297_SET_BLEND(6)";
    case NVA297_SET_BLEND(7):
        return "NVA297_SET_BLEND(7)";
    case NVA297_SET_STENCIL_TEST:
        return "NVA297_SET_STENCIL_TEST";
    case NVA297_SET_STENCIL_OP_FAIL:
        return "NVA297_SET_STENCIL_OP_FAIL";
    case NVA297_SET_STENCIL_OP_ZFAIL:
        return "NVA297_SET_STENCIL_OP_ZFAIL";
    case NVA297_SET_STENCIL_OP_ZPASS:
        return "NVA297_SET_STENCIL_OP_ZPASS";
    case NVA297_SET_STENCIL_FUNC:
        return "NVA297_SET_STENCIL_FUNC";
    case NVA297_SET_STENCIL_FUNC_REF:
        return "NVA297_SET_STENCIL_FUNC_REF";
    case NVA297_SET_STENCIL_FUNC_MASK:
        return "NVA297_SET_STENCIL_FUNC_MASK";
    case NVA297_SET_STENCIL_MASK:
        return "NVA297_SET_STENCIL_MASK";
    case NVA297_SET_DRAW_AUTO_START:
        return "NVA297_SET_DRAW_AUTO_START";
    case NVA297_SET_PS_SATURATE:
        return "NVA297_SET_PS_SATURATE";
    case NVA297_SET_WINDOW_ORIGIN:
        return "NVA297_SET_WINDOW_ORIGIN";
    case NVA297_SET_LINE_WIDTH_FLOAT:
        return "NVA297_SET_LINE_WIDTH_FLOAT";
    case NVA297_SET_ALIASED_LINE_WIDTH_FLOAT:
        return "NVA297_SET_ALIASED_LINE_WIDTH_FLOAT";
    case NVA297_SET_LINE_MULTISAMPLE_OVERRIDE:
        return "NVA297_SET_LINE_MULTISAMPLE_OVERRIDE";
    case NVA297_SET_ALPHA_HYSTERESIS:
        return "NVA297_SET_ALPHA_HYSTERESIS";
    case NVA297_INVALIDATE_SAMPLER_CACHE_NO_WFI:
        return "NVA297_INVALIDATE_SAMPLER_CACHE_NO_WFI";
    case NVA297_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
        return "NVA297_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI";
    case NVA297_INVALIDATE_DA_DMA_CACHE:
        return "NVA297_INVALIDATE_DA_DMA_CACHE";
    case NVA297_SET_GLOBAL_BASE_VERTEX_INDEX:
        return "NVA297_SET_GLOBAL_BASE_VERTEX_INDEX";
    case NVA297_SET_GLOBAL_BASE_INSTANCE_INDEX:
        return "NVA297_SET_GLOBAL_BASE_INSTANCE_INDEX";
    case NVA297_SET_PS_WARP_WATERMARKS:
        return "NVA297_SET_PS_WARP_WATERMARKS";
    case NVA297_SET_PS_REGISTER_WATERMARKS:
        return "NVA297_SET_PS_REGISTER_WATERMARKS";
    case NVA297_STORE_ZCULL:
        return "NVA297_STORE_ZCULL";
                case NVA297_LOAD_ZCULL:
        return "NVA297_LOAD_ZCULL";
    case NVA297_SET_SURFACE_CLIP_ID_HEIGHT:
        return "NVA297_SET_SURFACE_CLIP_ID_HEIGHT";
    case NVA297_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL:
        return "NVA297_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL";
    case NVA297_SET_CLIP_ID_CLEAR_RECT_VERTICAL:
        return "NVA297_SET_CLIP_ID_CLEAR_RECT_VERTICAL";
    case NVA297_SET_USER_CLIP_ENABLE:
        return "NVA297_SET_USER_CLIP_ENABLE";
    case NVA297_SET_ZPASS_PIXEL_COUNT:
        return "NVA297_SET_ZPASS_PIXEL_COUNT";
    case NVA297_SET_POINT_SIZE:
        return "NVA297_SET_POINT_SIZE";
    case NVA297_SET_ZCULL_STATS:
        return "NVA297_SET_ZCULL_STATS";
    case NVA297_SET_POINT_SPRITE:
        return "NVA297_SET_POINT_SPRITE";
    case NVA297_SET_SHADER_EXCEPTIONS:
        return "NVA297_SET_SHADER_EXCEPTIONS";
    case NVA297_CLEAR_REPORT_VALUE:
        return "NVA297_CLEAR_REPORT_VALUE";
    case NVA297_SET_ANTI_ALIAS_ENABLE:
        return "NVA297_SET_ANTI_ALIAS_ENABLE";
    case NVA297_SET_ZT_SELECT:
        return "NVA297_SET_ZT_SELECT";
    case NVA297_SET_ANTI_ALIAS_ALPHA_CONTROL:
        return "NVA297_SET_ANTI_ALIAS_ALPHA_CONTROL";
    case NVA297_SET_RENDER_ENABLE_A:
        return "NVA297_SET_RENDER_ENABLE_A";
    case NVA297_SET_RENDER_ENABLE_B:
        return "NVA297_SET_RENDER_ENABLE_B";
    case NVA297_SET_RENDER_ENABLE_C:
        return "NVA297_SET_RENDER_ENABLE_C";
    case NVA297_SET_TEX_SAMPLER_POOL_A:
        return "NVA297_SET_TEX_SAMPLER_POOL_A";
    case NVA297_SET_TEX_SAMPLER_POOL_B:
        return "NVA297_SET_TEX_SAMPLER_POOL_B";
    case NVA297_SET_TEX_SAMPLER_POOL_C:
        return "NVA297_SET_TEX_SAMPLER_POOL_C";
    case NVA297_SET_SLOPE_SCALE_DEPTH_BIAS:
        return "NVA297_SET_SLOPE_SCALE_DEPTH_BIAS";
    case NVA297_SET_ANTI_ALIASED_LINE:
        return "NVA297_SET_ANTI_ALIASED_LINE";
    case NVA297_SET_TEX_HEADER_POOL_A:
        return "NVA297_SET_TEX_HEADER_POOL_A";
    case NVA297_SET_TEX_HEADER_POOL_B:
        return "NVA297_SET_TEX_HEADER_POOL_B";
    case NVA297_SET_TEX_HEADER_POOL_C:
        return "NVA297_SET_TEX_HEADER_POOL_C";
    case NVA297_SET_ACTIVE_ZCULL_REGION:
        return "NVA297_SET_ACTIVE_ZCULL_REGION";
    case NVA297_SET_TWO_SIDED_STENCIL_TEST:
        return "NVA297_SET_TWO_SIDED_STENCIL_TEST";
    case NVA297_SET_BACK_STENCIL_OP_FAIL:
        return "NVA297_SET_BACK_STENCIL_OP_FAIL";
    case NVA297_SET_BACK_STENCIL_OP_ZFAIL:
        return "NVA297_SET_BACK_STENCIL_OP_ZFAIL";
    case NVA297_SET_BACK_STENCIL_OP_ZPASS:
        return "NVA297_SET_BACK_STENCIL_OP_ZPASS";
    case NVA297_SET_BACK_STENCIL_FUNC:
        return "NVA297_SET_BACK_STENCIL_FUNC";
    case NVA297_SET_SRGB_WRITE:
        return "NVA297_SET_SRGB_WRITE";
    case NVA297_SET_DEPTH_BIAS:
        return "NVA297_SET_DEPTH_BIAS";
    case NVA297_SET_ZCULL_REGION_FORMAT:
        return "NVA297_SET_ZCULL_REGION_FORMAT";
    case NVA297_SET_RT_LAYER:
        return "NVA297_SET_RT_LAYER";
    case NVA297_SET_ANTI_ALIAS:
        return "NVA297_SET_ANTI_ALIAS";
    case NVA297_SET_EDGE_FLAG:
        return "NVA297_SET_EDGE_FLAG";
    case NVA297_DRAW_INLINE_INDEX:
        return "NVA297_DRAW_INLINE_INDEX";
    case NVA297_SET_INLINE_INDEX2X16_ALIGN:
        return "NVA297_SET_INLINE_INDEX2X16_ALIGN";
    case NVA297_DRAW_INLINE_INDEX2X16:
        return "NVA297_DRAW_INLINE_INDEX2X16";
    case NVA297_SET_VERTEX_GLOBAL_BASE_OFFSET_A:
        return "NVA297_SET_VERTEX_GLOBAL_BASE_OFFSET_A";
    case NVA297_SET_VERTEX_GLOBAL_BASE_OFFSET_B:
        return "NVA297_SET_VERTEX_GLOBAL_BASE_OFFSET_B";
    case NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_A:
        return "NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_A";
    case NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_B:
        return "NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_B";
    case NVA297_SET_POINT_SPRITE_SELECT:
        return "NVA297_SET_POINT_SPRITE_SELECT";
    case NVA297_SET_PROGRAM_REGION_A:
        return "NVA297_SET_PROGRAM_REGION_A";
    case NVA297_SET_PROGRAM_REGION_B:
        return "NVA297_SET_PROGRAM_REGION_B";
    case NVA297_SET_ATTRIBUTE_DEFAULT:
        return "NVA297_SET_ATTRIBUTE_DEFAULT";
    case NVA297_END:
        return "NVA297_END";
    case NVA297_BEGIN:
        return "NVA297_BEGIN";
    case NVA297_SET_VERTEX_ID_COPY:
        return "NVA297_SET_VERTEX_ID_COPY";
    case NVA297_ADD_TO_PRIMITIVE_ID:
        return "NVA297_ADD_TO_PRIMITIVE_ID";
    case NVA297_LOAD_PRIMITIVE_ID:
        return "NVA297_LOAD_PRIMITIVE_ID";
    case NVA297_SET_SHADER_BASED_CULL:
        return "NVA297_SET_SHADER_BASED_CULL";
    case NVA297_SET_CLASS_VERSION:
        return "NVA297_SET_CLASS_VERSION";
    case NVA297_SET_VAB_PAGE:
        return "NVA297_SET_VAB_PAGE";
    case NVA297_DRAW_INLINE_VERTEX:
        return "NVA297_DRAW_INLINE_VERTEX";
    case NVA297_SET_DA_PRIMITIVE_RESTART:
        return "NVA297_SET_DA_PRIMITIVE_RESTART";
    case NVA297_SET_DA_PRIMITIVE_RESTART_INDEX:
        return "NVA297_SET_DA_PRIMITIVE_RESTART_INDEX";
    case NVA297_SET_DA_OUTPUT:
        return "NVA297_SET_DA_OUTPUT";
    case NVA297_SET_ANTI_ALIASED_POINT:
        return "NVA297_SET_ANTI_ALIASED_POINT";
    case NVA297_SET_POINT_CENTER_MODE:
        return "NVA297_SET_POINT_CENTER_MODE";
    case NVA297_SET_LINE_SMOOTH_PARAMETERS:
        return "NVA297_SET_LINE_SMOOTH_PARAMETERS";
    case NVA297_SET_LINE_STIPPLE:
        return "NVA297_SET_LINE_STIPPLE";
        case NVA297_SET_LINE_STIPPLE_PARAMETERS:
        return "NVA297_SET_LINE_STIPPLE_PARAMETERS";
    case NVA297_SET_PROVOKING_VERTEX:
        return "NVA297_SET_PROVOKING_VERTEX";
    case NVA297_SET_TWO_SIDED_LIGHT:
        return "NVA297_SET_TWO_SIDED_LIGHT";
    case NVA297_SET_POLYGON_STIPPLE:
        return "NVA297_SET_POLYGON_STIPPLE";
    case NVA297_SET_SHADER_CONTROL:
        return "NVA297_SET_SHADER_CONTROL";
    case NVA297_LAUNCH_VERTEX:
        return "NVA297_LAUNCH_VERTEX";
    case NVA297_CHECK_CLASS_VERSION:
        return "NVA297_CHECK_CLASS_VERSION";
    case NVA297_SET_SPH_VERSION:
        return "NVA297_SET_SPH_VERSION";
    case NVA297_CHECK_SPH_VERSION:
        return "NVA297_CHECK_SPH_VERSION";
    case NVA297_SET_ALPHA_TO_COVERAGE_OVERRIDE:
        return "NVA297_SET_ALPHA_TO_COVERAGE_OVERRIDE";
        case NVA297_SET_AAM_VERSION:
        return "NVA297_SET_AAM_VERSION";
    case NVA297_CHECK_AAM_VERSION:
        return "NVA297_CHECK_AAM_VERSION";
    case NVA297_SET_ZT_LAYER:
        return "NVA297_SET_ZT_LAYER";
    case NVA297_SET_VAB_MEMORY_AREA_A:
        return "NVA297_SET_VAB_MEMORY_AREA_A";
    case NVA297_SET_VAB_MEMORY_AREA_B:
        return "NVA297_SET_VAB_MEMORY_AREA_B";
    case NVA297_SET_VAB_MEMORY_AREA_C:
        return "NVA297_SET_VAB_MEMORY_AREA_C";
    case NVA297_SET_INDEX_BUFFER_A:
        return "NVA297_SET_INDEX_BUFFER_A";
    case NVA297_SET_INDEX_BUFFER_B:
        return "NVA297_SET_INDEX_BUFFER_B";
    case NVA297_SET_INDEX_BUFFER_C:
        return "NVA297_SET_INDEX_BUFFER_C";
    case NVA297_SET_INDEX_BUFFER_D:
        return "NVA297_SET_INDEX_BUFFER_D";
    case NVA297_SET_INDEX_BUFFER_E:
        return "NVA297_SET_INDEX_BUFFER_E";
    case NVA297_SET_INDEX_BUFFER_F:
        return "NVA297_SET_INDEX_BUFFER_F";
    case NVA297_DRAW_INDEX_BUFFER:
        return "NVA297_DRAW_INDEX_BUFFER";
    case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST:
        return "NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST";
    case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST:
        return "NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST";
    case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST:
        return "NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST";
    case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT:
        return "NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT";
    case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT:
        return "NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT";
    case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT:
        return "NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT";
    case NVA297_SET_DEPTH_BIAS_CLAMP:
        return "NVA297_SET_DEPTH_BIAS_CLAMP";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(0):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(0)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(1):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(1)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(2):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(2)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(3):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(3)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(4):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(4)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(5):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(5)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(6):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(6)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(7):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(7)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(8):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(8)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(9):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(9)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(10):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(10)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(11):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(11)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(12):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(12)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(13):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(13)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(14):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(14)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(15):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_A(15)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(0):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(0)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(1):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(1)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(2):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(2)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(3):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(3)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(4):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(4)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(5):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(5)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(6):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(6)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(7):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(7)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(8):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(8)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(9):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(9)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(10):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(10)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(11):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(11)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(12):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(12)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(13):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(13)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(14):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(14)";
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(15):
        return "NVA297_SET_VERTEX_STREAM_INSTANCE_B(15)";
    case NVA297_SET_ATTRIBUTE_POINT_SIZE:
        return "NVA297_SET_ATTRIBUTE_POINT_SIZE";
    case NVA297_OGL_SET_CULL:
        return "NVA297_OGL_SET_CULL";
    case NVA297_OGL_SET_FRONT_FACE:
        return "NVA297_OGL_SET_FRONT_FACE";
    case NVA297_OGL_SET_CULL_FACE:
        return "NVA297_OGL_SET_CULL_FACE";
    case NVA297_SET_VIEWPORT_PIXEL:
        return "NVA297_SET_VIEWPORT_PIXEL";
    case NVA297_SET_VIEWPORT_SCALE_OFFSET:
        return "NVA297_SET_VIEWPORT_SCALE_OFFSET";
    case NVA297_INVALIDATE_CONSTANT_BUFFER_CACHE:
        return "NVA297_INVALIDATE_CONSTANT_BUFFER_CACHE";
    case NVA297_SET_VIEWPORT_CLIP_CONTROL:
        return "NVA297_SET_VIEWPORT_CLIP_CONTROL";
    case NVA297_SET_USER_CLIP_OP:
        return "NVA297_SET_USER_CLIP_OP";
    case NVA297_SET_RENDER_ENABLE_OVERRIDE:
        return "NVA297_SET_RENDER_ENABLE_OVERRIDE";
    case NVA297_SET_PRIMITIVE_TOPOLOGY_CONTROL:
        return "NVA297_SET_PRIMITIVE_TOPOLOGY_CONTROL";
    case NVA297_SET_WINDOW_CLIP_ENABLE:
        return "NVA297_SET_WINDOW_CLIP_ENABLE";
    case NVA297_SET_WINDOW_CLIP_TYPE:
        return "NVA297_SET_WINDOW_CLIP_TYPE";
    case NVA297_INVALIDATE_ZCULL:
        return "NVA297_INVALIDATE_ZCULL";
    case NVA297_SET_ZCULL:
        return "NVA297_SET_ZCULL";
    case NVA297_SET_ZCULL_BOUNDS:
        return "NVA297_SET_ZCULL_BOUNDS";
    case NVA297_SET_PRIMITIVE_TOPOLOGY:
        return "NVA297_SET_PRIMITIVE_TOPOLOGY";
    case NVA297_ZCULL_SYNC:
        return "NVA297_ZCULL_SYNC";
    case NVA297_SET_CLIP_ID_TEST:
        return "NVA297_SET_CLIP_ID_TEST";
    case NVA297_SET_SURFACE_CLIP_ID_WIDTH:
        return "NVA297_SET_SURFACE_CLIP_ID_WIDTH";
    case NVA297_SET_CLIP_ID:
        return "NVA297_SET_CLIP_ID";
    case NVA297_SET_DEPTH_BOUNDS_TEST:
        return "NVA297_SET_DEPTH_BOUNDS_TEST";
    case NVA297_SET_BLEND_FLOAT_OPTION:
        return "NVA297_SET_BLEND_FLOAT_OPTION";
    case NVA297_SET_LOGIC_OP:
        return "NVA297_SET_LOGIC_OP";
    case NVA297_SET_LOGIC_OP_FUNC:
        return "NVA297_SET_LOGIC_OP_FUNC";
    case NVA297_SET_Z_COMPRESSION:
        return "NVA297_SET_Z_COMPRESSION";
    case NVA297_CLEAR_SURFACE:
        return "NVA297_CLEAR_SURFACE";
    case NVA297_CLEAR_CLIP_ID_SURFACE:
        return "NVA297_CLEAR_CLIP_ID_SURFACE";
    case NVA297_SET_COLOR_COMPRESSION(0):
        return "NVA297_SET_COLOR_COMPRESSION(0)";
    case NVA297_SET_COLOR_COMPRESSION(1):
        return "NVA297_SET_COLOR_COMPRESSION(1)";
    case NVA297_SET_COLOR_COMPRESSION(2):
        return "NVA297_SET_COLOR_COMPRESSION(2)";
    case NVA297_SET_COLOR_COMPRESSION(3):
        return "NVA297_SET_COLOR_COMPRESSION(3)";
    case NVA297_SET_COLOR_COMPRESSION(4):
        return "NVA297_SET_COLOR_COMPRESSION(4)";
    case NVA297_SET_COLOR_COMPRESSION(5):
        return "NVA297_SET_COLOR_COMPRESSION(5)";
    case NVA297_SET_COLOR_COMPRESSION(6):
        return "NVA297_SET_COLOR_COMPRESSION(6)";
    case NVA297_SET_COLOR_COMPRESSION(7):
        return "NVA297_SET_COLOR_COMPRESSION(7)";
    case NVA297_SET_CT_WRITE(0):
        return "NVA297_SET_CT_WRITE(0)";
    case NVA297_SET_CT_WRITE(1):
        return "NVA297_SET_CT_WRITE(1)";
    case NVA297_SET_CT_WRITE(2):
        return "NVA297_SET_CT_WRITE(2)";
    case NVA297_SET_CT_WRITE(3):
        return "NVA297_SET_CT_WRITE(3)";
    case NVA297_SET_CT_WRITE(4):
        return "NVA297_SET_CT_WRITE(4)";
    case NVA297_SET_CT_WRITE(5):
        return "NVA297_SET_CT_WRITE(5)";
    case NVA297_SET_CT_WRITE(6):
        return "NVA297_SET_CT_WRITE(6)";
    case NVA297_SET_CT_WRITE(7):
        return "NVA297_SET_CT_WRITE(7)";
    case NVA297_PIPE_NOP:
        return "NVA297_PIPE_NOP";
    case NVA297_SET_SPARE00:
        return "NVA297_SET_SPARE00";
    case NVA297_SET_SPARE01:
        return "NVA297_SET_SPARE01";
    case NVA297_SET_SPARE02:
        return "NVA297_SET_SPARE02";
    case NVA297_SET_SPARE03:
        return "NVA297_SET_SPARE03";
    case NVA297_SET_REPORT_SEMAPHORE_A:
        return "NVA297_SET_REPORT_SEMAPHORE_A";
    case NVA297_SET_REPORT_SEMAPHORE_B:
        return "NVA297_SET_REPORT_SEMAPHORE_B";
    case NVA297_SET_REPORT_SEMAPHORE_C:
        return "NVA297_SET_REPORT_SEMAPHORE_C";
    case NVA297_SET_REPORT_SEMAPHORE_D:
        return "NVA297_SET_REPORT_SEMAPHORE_D";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(0):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(0)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(1):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(1)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(2):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(2)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(3):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(3)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(4):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(4)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(5):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(5)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(6):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(6)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(7):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(7)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(8):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(8)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(9):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(9)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(10):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(10)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(11):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(11)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(12):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(12)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(13):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(13)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(14):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(14)";
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(15):
        return "NVA297_SET_VERTEX_STREAM_A_FORMAT(15)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(0):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(0)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(1):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(1)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(2):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(2)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(3):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(3)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(4):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(4)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(5):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(5)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(6):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(6)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(7):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(7)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(8):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(8)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(9):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(9)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(10):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(10)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(11):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(11)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(12):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(12)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(13):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(13)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(14):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(14)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(15):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_A(15)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(0):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(0)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(1):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(1)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(2):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(2)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(3):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(3)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(4):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(4)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(5):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(5)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(6):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(6)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(7):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(7)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(8):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(8)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(9):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(9)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(10):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(10)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(11):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(11)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(12):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(12)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(13):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(13)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(14):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(14)";
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(15):
        return "NVA297_SET_VERTEX_STREAM_A_LOCATION_B(15)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(0):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(0)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(1):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(1)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(2):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(2)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(3):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(3)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(4):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(4)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(5):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(5)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(6):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(6)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(7):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(7)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(8):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(8)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(9):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(9)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(10):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(10)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(11):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(11)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(12):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(12)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(13):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(13)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(14):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(14)";
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(15):
        return "NVA297_SET_VERTEX_STREAM_A_FREQUENCY(15)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(0):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(0)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(1):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(1)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(2):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(2)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(3):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(3)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(4):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(4)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(5):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(5)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(6):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(6)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(7):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(7)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(8):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(8)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(9):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(9)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(10):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(10)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(11):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(11)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(12):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(12)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(13):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(13)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(14):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(14)";
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(15):
        return "NVA297_SET_VERTEX_STREAM_B_FORMAT(15)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(0):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(0)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(1):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(1)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(2):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(2)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(3):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(3)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(4):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(4)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(5):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(5)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(6):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(6)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(7):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(7)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(8):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(8)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(9):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(9)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(10):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(10)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(11):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(11)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(12):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(12)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(13):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(13)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(14):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(14)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(15):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_A(15)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(0):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(0)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(1):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(1)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(2):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(2)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(3):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(3)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(4):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(4)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(5):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(5)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(6):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(6)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(7):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(7)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(8):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(8)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(9):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(9)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(10):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(10)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(11):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(11)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(12):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(12)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(13):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(13)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(14):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(14)";
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(15):
        return "NVA297_SET_VERTEX_STREAM_B_LOCATION_B(15)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(0):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(0)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(1):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(1)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(2):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(2)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(3):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(3)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(4):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(4)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(5):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(5)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(6):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(6)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(7):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(7)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(8):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(8)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(9):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(9)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(10):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(10)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(11):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(11)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(12):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(12)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(13):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(13)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(14):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(14)";
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(15):
        return "NVA297_SET_VERTEX_STREAM_B_FREQUENCY(15)";
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(0):
        return "NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(0)";
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(1):
        return "NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(1)";
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(2):
        return "NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(2)";
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(3):
        return "NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(3)";
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(4):
        return "NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(4)";
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(5):
        return "NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(5)";
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(6):
        return "NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(6)";
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(7):
        return "NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(7)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(0):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_OP(0)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(1):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_OP(1)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(2):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_OP(2)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(3):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_OP(3)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(4):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_OP(4)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(5):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_OP(5)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(6):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_OP(6)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(7):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_OP(7)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(0):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(0)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(1):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(1)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(2):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(2)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(3):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(3)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(4):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(4)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(5):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(5)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(6):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(6)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(7):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(7)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(0):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(0)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(1):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(1)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(2):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(2)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(3):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(3)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(4):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(4)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(5):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(5)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(6):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(6)";
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(7):
        return "NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(7)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(0):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(0)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(1):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(1)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(2):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(2)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(3):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(3)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(4):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(4)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(5):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(5)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(6):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(6)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(7):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(7)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(0):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(0)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(1):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(1)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(2):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(2)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(3):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(3)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(4):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(4)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(5):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(5)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(6):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(6)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(7):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(7)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(0):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(0)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(1):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(1)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(2):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(2)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(3):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(3)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(4):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(4)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(5):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(5)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(6):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(6)";
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(7):
        return "NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(7)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(0):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(0)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(1):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(1)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(2):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(2)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(3):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(3)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(4):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(4)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(5):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(5)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(6):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(6)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(7):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(7)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(8):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(8)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(9):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(9)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(10):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(10)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(11):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(11)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(12):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(12)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(13):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(13)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(14):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(14)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(15):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_A(15)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(0):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(0)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(1):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(1)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(2):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(2)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(3):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(3)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(4):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(4)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(5):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(5)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(6):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(6)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(7):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(7)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(8):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(8)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(9):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(9)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(10):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(10)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(11):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(11)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(12):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(12)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(13):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(13)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(14):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(14)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(15):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_A_B(15)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(0):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(0)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(1):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(1)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(2):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(2)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(3):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(3)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(4):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(4)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(5):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(5)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(6):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(6)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(7):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(7)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(8):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(8)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(9):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(9)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(10):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(10)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(11):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(11)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(12):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(12)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(13):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(13)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(14):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(14)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(15):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_A(15)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(0):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(0)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(1):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(1)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(2):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(2)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(3):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(3)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(4):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(4)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(5):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(5)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(6):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(6)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(7):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(7)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(8):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(8)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(9):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(9)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(10):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(10)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(11):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(11)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(12):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(12)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(13):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(13)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(14):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(14)";
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(15):
        return "NVA297_SET_VERTEX_STREAM_LIMIT_B_B(15)";
    case NVA297_SET_PIPELINE_SHADER(0):
        return "NVA297_SET_PIPELINE_SHADER(0)";
    case NVA297_SET_PIPELINE_SHADER(1):
        return "NVA297_SET_PIPELINE_SHADER(1)";
    case NVA297_SET_PIPELINE_SHADER(2):
        return "NVA297_SET_PIPELINE_SHADER(2)";
    case NVA297_SET_PIPELINE_SHADER(3):
        return "NVA297_SET_PIPELINE_SHADER(3)";
    case NVA297_SET_PIPELINE_SHADER(4):
        return "NVA297_SET_PIPELINE_SHADER(4)";
    case NVA297_SET_PIPELINE_SHADER(5):
        return "NVA297_SET_PIPELINE_SHADER(5)";
    case NVA297_SET_PIPELINE_PROGRAM(0):
        return "NVA297_SET_PIPELINE_PROGRAM(0)";
    case NVA297_SET_PIPELINE_PROGRAM(1):
        return "NVA297_SET_PIPELINE_PROGRAM(1)";
    case NVA297_SET_PIPELINE_PROGRAM(2):
        return "NVA297_SET_PIPELINE_PROGRAM(2)";
    case NVA297_SET_PIPELINE_PROGRAM(3):
        return "NVA297_SET_PIPELINE_PROGRAM(3)";
    case NVA297_SET_PIPELINE_PROGRAM(4):
        return "NVA297_SET_PIPELINE_PROGRAM(4)";
    case NVA297_SET_PIPELINE_PROGRAM(5):
        return "NVA297_SET_PIPELINE_PROGRAM(5)";
    case NVA297_SET_PIPELINE_RESERVED_A(0):
        return "NVA297_SET_PIPELINE_RESERVED_A(0)";
    case NVA297_SET_PIPELINE_RESERVED_A(1):
        return "NVA297_SET_PIPELINE_RESERVED_A(1)";
    case NVA297_SET_PIPELINE_RESERVED_A(2):
        return "NVA297_SET_PIPELINE_RESERVED_A(2)";
    case NVA297_SET_PIPELINE_RESERVED_A(3):
        return "NVA297_SET_PIPELINE_RESERVED_A(3)";
    case NVA297_SET_PIPELINE_RESERVED_A(4):
        return "NVA297_SET_PIPELINE_RESERVED_A(4)";
    case NVA297_SET_PIPELINE_RESERVED_A(5):
        return "NVA297_SET_PIPELINE_RESERVED_A(5)";
    case NVA297_SET_PIPELINE_REGISTER_COUNT(0):
        return "NVA297_SET_PIPELINE_REGISTER_COUNT(0)";
    case NVA297_SET_PIPELINE_REGISTER_COUNT(1):
        return "NVA297_SET_PIPELINE_REGISTER_COUNT(1)";
    case NVA297_SET_PIPELINE_REGISTER_COUNT(2):
        return "NVA297_SET_PIPELINE_REGISTER_COUNT(2)";
    case NVA297_SET_PIPELINE_REGISTER_COUNT(3):
        return "NVA297_SET_PIPELINE_REGISTER_COUNT(3)";
    case NVA297_SET_PIPELINE_REGISTER_COUNT(4):
        return "NVA297_SET_PIPELINE_REGISTER_COUNT(4)";
    case NVA297_SET_PIPELINE_REGISTER_COUNT(5):
        return "NVA297_SET_PIPELINE_REGISTER_COUNT(5)";
    case NVA297_SET_PIPELINE_BINDING(0):
        return "NVA297_SET_PIPELINE_BINDING(0)";
    case NVA297_SET_PIPELINE_BINDING(1):
        return "NVA297_SET_PIPELINE_BINDING(1)";
    case NVA297_SET_PIPELINE_BINDING(2):
        return "NVA297_SET_PIPELINE_BINDING(2)";
    case NVA297_SET_PIPELINE_BINDING(3):
        return "NVA297_SET_PIPELINE_BINDING(3)";
    case NVA297_SET_PIPELINE_BINDING(4):
        return "NVA297_SET_PIPELINE_BINDING(4)";
    case NVA297_SET_PIPELINE_BINDING(5):
        return "NVA297_SET_PIPELINE_BINDING(5)";
    case NVA297_SET_PIPELINE_RESERVED_B(0):
        return "NVA297_SET_PIPELINE_RESERVED_B(0)";
    case NVA297_SET_PIPELINE_RESERVED_B(1):
        return "NVA297_SET_PIPELINE_RESERVED_B(1)";
    case NVA297_SET_PIPELINE_RESERVED_B(2):
        return "NVA297_SET_PIPELINE_RESERVED_B(2)";
    case NVA297_SET_PIPELINE_RESERVED_B(3):
        return "NVA297_SET_PIPELINE_RESERVED_B(3)";
    case NVA297_SET_PIPELINE_RESERVED_B(4):
        return "NVA297_SET_PIPELINE_RESERVED_B(4)";
    case NVA297_SET_PIPELINE_RESERVED_B(5):
        return "NVA297_SET_PIPELINE_RESERVED_B(5)";
    case NVA297_SET_PIPELINE_RESERVED_C(0):
        return "NVA297_SET_PIPELINE_RESERVED_C(0)";
    case NVA297_SET_PIPELINE_RESERVED_C(1):
        return "NVA297_SET_PIPELINE_RESERVED_C(1)";
    case NVA297_SET_PIPELINE_RESERVED_C(2):
        return "NVA297_SET_PIPELINE_RESERVED_C(2)";
    case NVA297_SET_PIPELINE_RESERVED_C(3):
        return "NVA297_SET_PIPELINE_RESERVED_C(3)";
    case NVA297_SET_PIPELINE_RESERVED_C(4):
        return "NVA297_SET_PIPELINE_RESERVED_C(4)";
    case NVA297_SET_PIPELINE_RESERVED_C(5):
        return "NVA297_SET_PIPELINE_RESERVED_C(5)";
    case NVA297_SET_PIPELINE_RESERVED_D(0):
        return "NVA297_SET_PIPELINE_RESERVED_D(0)";
    case NVA297_SET_PIPELINE_RESERVED_D(1):
        return "NVA297_SET_PIPELINE_RESERVED_D(1)";
    case NVA297_SET_PIPELINE_RESERVED_D(2):
        return "NVA297_SET_PIPELINE_RESERVED_D(2)";
    case NVA297_SET_PIPELINE_RESERVED_D(3):
        return "NVA297_SET_PIPELINE_RESERVED_D(3)";
    case NVA297_SET_PIPELINE_RESERVED_D(4):
        return "NVA297_SET_PIPELINE_RESERVED_D(4)";
    case NVA297_SET_PIPELINE_RESERVED_D(5):
        return "NVA297_SET_PIPELINE_RESERVED_D(5)";
    case NVA297_SET_PIPELINE_RESERVED_E(0):
        return "NVA297_SET_PIPELINE_RESERVED_E(0)";
    case NVA297_SET_PIPELINE_RESERVED_E(1):
        return "NVA297_SET_PIPELINE_RESERVED_E(1)";
    case NVA297_SET_PIPELINE_RESERVED_E(2):
        return "NVA297_SET_PIPELINE_RESERVED_E(2)";
    case NVA297_SET_PIPELINE_RESERVED_E(3):
        return "NVA297_SET_PIPELINE_RESERVED_E(3)";
    case NVA297_SET_PIPELINE_RESERVED_E(4):
        return "NVA297_SET_PIPELINE_RESERVED_E(4)";
    case NVA297_SET_PIPELINE_RESERVED_E(5):
        return "NVA297_SET_PIPELINE_RESERVED_E(5)";
    case NVA297_SET_FALCON00:
        return "NVA297_SET_FALCON00";
    case NVA297_SET_FALCON01:
        return "NVA297_SET_FALCON01";
    case NVA297_SET_FALCON02:
        return "NVA297_SET_FALCON02";
    case NVA297_SET_FALCON03:
        return "NVA297_SET_FALCON03";
    case NVA297_SET_FALCON04:
        return "NVA297_SET_FALCON04";
    case NVA297_SET_FALCON05:
        return "NVA297_SET_FALCON05";
    case NVA297_SET_FALCON06:
        return "NVA297_SET_FALCON06";
    case NVA297_SET_FALCON07:
        return "NVA297_SET_FALCON07";
    case NVA297_SET_FALCON08:
        return "NVA297_SET_FALCON08";
    case NVA297_SET_FALCON09:
        return "NVA297_SET_FALCON09";
    case NVA297_SET_FALCON10:
        return "NVA297_SET_FALCON10";
    case NVA297_SET_FALCON11:
        return "NVA297_SET_FALCON11";
    case NVA297_SET_FALCON12:
        return "NVA297_SET_FALCON12";
    case NVA297_SET_FALCON13:
        return "NVA297_SET_FALCON13";
    case NVA297_SET_FALCON14:
        return "NVA297_SET_FALCON14";
    case NVA297_SET_FALCON15:
        return "NVA297_SET_FALCON15";
    case NVA297_SET_FALCON16:
        return "NVA297_SET_FALCON16";
    case NVA297_SET_FALCON17:
        return "NVA297_SET_FALCON17";
    case NVA297_SET_FALCON18:
        return "NVA297_SET_FALCON18";
    case NVA297_SET_FALCON19:
        return "NVA297_SET_FALCON19";
    case NVA297_SET_FALCON20:
        return "NVA297_SET_FALCON20";
    case NVA297_SET_FALCON21:
        return "NVA297_SET_FALCON21";
    case NVA297_SET_FALCON22:
        return "NVA297_SET_FALCON22";
    case NVA297_SET_FALCON23:
        return "NVA297_SET_FALCON23";
    case NVA297_SET_FALCON24:
        return "NVA297_SET_FALCON24";
    case NVA297_SET_FALCON25:
        return "NVA297_SET_FALCON25";
    case NVA297_SET_FALCON26:
        return "NVA297_SET_FALCON26";
    case NVA297_SET_FALCON27:
        return "NVA297_SET_FALCON27";
    case NVA297_SET_FALCON28:
        return "NVA297_SET_FALCON28";
    case NVA297_SET_FALCON29:
        return "NVA297_SET_FALCON29";
    case NVA297_SET_FALCON30:
        return "NVA297_SET_FALCON30";
    case NVA297_SET_FALCON31:
        return "NVA297_SET_FALCON31";
    case NVA297_SET_CONSTANT_BUFFER_SELECTOR_A:
        return "NVA297_SET_CONSTANT_BUFFER_SELECTOR_A";
    case NVA297_SET_CONSTANT_BUFFER_SELECTOR_B:
        return "NVA297_SET_CONSTANT_BUFFER_SELECTOR_B";
    case NVA297_SET_CONSTANT_BUFFER_SELECTOR_C:
        return "NVA297_SET_CONSTANT_BUFFER_SELECTOR_C";
    case NVA297_LOAD_CONSTANT_BUFFER_OFFSET:
        return "NVA297_LOAD_CONSTANT_BUFFER_OFFSET";
    case NVA297_LOAD_CONSTANT_BUFFER(0):
        return "NVA297_LOAD_CONSTANT_BUFFER(0)";
    case NVA297_LOAD_CONSTANT_BUFFER(1):
        return "NVA297_LOAD_CONSTANT_BUFFER(1)";
    case NVA297_LOAD_CONSTANT_BUFFER(2):
        return "NVA297_LOAD_CONSTANT_BUFFER(2)";
    case NVA297_LOAD_CONSTANT_BUFFER(3):
        return "NVA297_LOAD_CONSTANT_BUFFER(3)";
    case NVA297_LOAD_CONSTANT_BUFFER(4):
        return "NVA297_LOAD_CONSTANT_BUFFER(4)";
    case NVA297_LOAD_CONSTANT_BUFFER(5):
        return "NVA297_LOAD_CONSTANT_BUFFER(5)";
    case NVA297_LOAD_CONSTANT_BUFFER(6):
        return "NVA297_LOAD_CONSTANT_BUFFER(6)";
    case NVA297_LOAD_CONSTANT_BUFFER(7):
        return "NVA297_LOAD_CONSTANT_BUFFER(7)";
    case NVA297_LOAD_CONSTANT_BUFFER(8):
        return "NVA297_LOAD_CONSTANT_BUFFER(8)";
    case NVA297_LOAD_CONSTANT_BUFFER(9):
        return "NVA297_LOAD_CONSTANT_BUFFER(9)";
    case NVA297_LOAD_CONSTANT_BUFFER(10):
        return "NVA297_LOAD_CONSTANT_BUFFER(10)";
    case NVA297_LOAD_CONSTANT_BUFFER(11):
        return "NVA297_LOAD_CONSTANT_BUFFER(11)";
    case NVA297_LOAD_CONSTANT_BUFFER(12):
        return "NVA297_LOAD_CONSTANT_BUFFER(12)";
    case NVA297_LOAD_CONSTANT_BUFFER(13):
        return "NVA297_LOAD_CONSTANT_BUFFER(13)";
    case NVA297_LOAD_CONSTANT_BUFFER(14):
        return "NVA297_LOAD_CONSTANT_BUFFER(14)";
    case NVA297_LOAD_CONSTANT_BUFFER(15):
        return "NVA297_LOAD_CONSTANT_BUFFER(15)";
                    case NVA297_BIND_GROUP_CONSTANT_BUFFER(0):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(0)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(1):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(1)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(2):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(2)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(3):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(3)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(4):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(4)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(5):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(5)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(6):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(6)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(7):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(7)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(8):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(8)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(9):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(9)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(10):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(10)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(11):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(11)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(12):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(12)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(13):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(13)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(14):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(14)";
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(15):
        return "NVA297_BIND_GROUP_CONSTANT_BUFFER(15)";
    case NVA297_SET_COLOR_CLAMP:
        return "NVA297_SET_COLOR_CLAMP";
    case NVA297_NOOP_X_X_X_SET_VALVE:
        return "NVA297_NOOP_X_X_X_SET_VALVE";
    case NVA297_SET_BINDLESS_TEXTURE:
        return "NVA297_SET_BINDLESS_TEXTURE";
    case NVA297_SET_TRAP_HANDLER:
        return "NVA297_SET_TRAP_HANDLER";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7)";
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
        return "NVA297_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL";
    case NVA297_SET_MME_SHADOW_SCRATCH(0):
        return "NVA297_SET_MME_SHADOW_SCRATCH(0)";
    case NVA297_SET_MME_SHADOW_SCRATCH(1):
        return "NVA297_SET_MME_SHADOW_SCRATCH(1)";
    case NVA297_SET_MME_SHADOW_SCRATCH(2):
        return "NVA297_SET_MME_SHADOW_SCRATCH(2)";
    case NVA297_SET_MME_SHADOW_SCRATCH(3):
        return "NVA297_SET_MME_SHADOW_SCRATCH(3)";
    case NVA297_SET_MME_SHADOW_SCRATCH(4):
        return "NVA297_SET_MME_SHADOW_SCRATCH(4)";
    case NVA297_SET_MME_SHADOW_SCRATCH(5):
        return "NVA297_SET_MME_SHADOW_SCRATCH(5)";
    case NVA297_SET_MME_SHADOW_SCRATCH(6):
        return "NVA297_SET_MME_SHADOW_SCRATCH(6)";
    case NVA297_SET_MME_SHADOW_SCRATCH(7):
        return "NVA297_SET_MME_SHADOW_SCRATCH(7)";
    case NVA297_SET_MME_SHADOW_SCRATCH(8):
        return "NVA297_SET_MME_SHADOW_SCRATCH(8)";
    case NVA297_SET_MME_SHADOW_SCRATCH(9):
        return "NVA297_SET_MME_SHADOW_SCRATCH(9)";
    case NVA297_SET_MME_SHADOW_SCRATCH(10):
        return "NVA297_SET_MME_SHADOW_SCRATCH(10)";
    case NVA297_SET_MME_SHADOW_SCRATCH(11):
        return "NVA297_SET_MME_SHADOW_SCRATCH(11)";
    case NVA297_SET_MME_SHADOW_SCRATCH(12):
        return "NVA297_SET_MME_SHADOW_SCRATCH(12)";
    case NVA297_SET_MME_SHADOW_SCRATCH(13):
        return "NVA297_SET_MME_SHADOW_SCRATCH(13)";
    case NVA297_SET_MME_SHADOW_SCRATCH(14):
        return "NVA297_SET_MME_SHADOW_SCRATCH(14)";
    case NVA297_SET_MME_SHADOW_SCRATCH(15):
        return "NVA297_SET_MME_SHADOW_SCRATCH(15)";
    case NVA297_SET_MME_SHADOW_SCRATCH(16):
        return "NVA297_SET_MME_SHADOW_SCRATCH(16)";
    case NVA297_SET_MME_SHADOW_SCRATCH(17):
        return "NVA297_SET_MME_SHADOW_SCRATCH(17)";
    case NVA297_SET_MME_SHADOW_SCRATCH(18):
        return "NVA297_SET_MME_SHADOW_SCRATCH(18)";
    case NVA297_SET_MME_SHADOW_SCRATCH(19):
        return "NVA297_SET_MME_SHADOW_SCRATCH(19)";
    case NVA297_SET_MME_SHADOW_SCRATCH(20):
        return "NVA297_SET_MME_SHADOW_SCRATCH(20)";
    case NVA297_SET_MME_SHADOW_SCRATCH(21):
        return "NVA297_SET_MME_SHADOW_SCRATCH(21)";
    case NVA297_SET_MME_SHADOW_SCRATCH(22):
        return "NVA297_SET_MME_SHADOW_SCRATCH(22)";
    case NVA297_SET_MME_SHADOW_SCRATCH(23):
        return "NVA297_SET_MME_SHADOW_SCRATCH(23)";
    case NVA297_SET_MME_SHADOW_SCRATCH(24):
        return "NVA297_SET_MME_SHADOW_SCRATCH(24)";
    case NVA297_SET_MME_SHADOW_SCRATCH(25):
        return "NVA297_SET_MME_SHADOW_SCRATCH(25)";
    case NVA297_SET_MME_SHADOW_SCRATCH(26):
        return "NVA297_SET_MME_SHADOW_SCRATCH(26)";
    case NVA297_SET_MME_SHADOW_SCRATCH(27):
        return "NVA297_SET_MME_SHADOW_SCRATCH(27)";
    case NVA297_SET_MME_SHADOW_SCRATCH(28):
        return "NVA297_SET_MME_SHADOW_SCRATCH(28)";
    case NVA297_SET_MME_SHADOW_SCRATCH(29):
        return "NVA297_SET_MME_SHADOW_SCRATCH(29)";
    case NVA297_SET_MME_SHADOW_SCRATCH(30):
        return "NVA297_SET_MME_SHADOW_SCRATCH(30)";
    case NVA297_SET_MME_SHADOW_SCRATCH(31):
        return "NVA297_SET_MME_SHADOW_SCRATCH(31)";
    case NVA297_SET_MME_SHADOW_SCRATCH(32):
        return "NVA297_SET_MME_SHADOW_SCRATCH(32)";
    case NVA297_SET_MME_SHADOW_SCRATCH(33):
        return "NVA297_SET_MME_SHADOW_SCRATCH(33)";
    case NVA297_SET_MME_SHADOW_SCRATCH(34):
        return "NVA297_SET_MME_SHADOW_SCRATCH(34)";
    case NVA297_SET_MME_SHADOW_SCRATCH(35):
        return "NVA297_SET_MME_SHADOW_SCRATCH(35)";
    case NVA297_SET_MME_SHADOW_SCRATCH(36):
        return "NVA297_SET_MME_SHADOW_SCRATCH(36)";
    case NVA297_SET_MME_SHADOW_SCRATCH(37):
        return "NVA297_SET_MME_SHADOW_SCRATCH(37)";
    case NVA297_SET_MME_SHADOW_SCRATCH(38):
        return "NVA297_SET_MME_SHADOW_SCRATCH(38)";
    case NVA297_SET_MME_SHADOW_SCRATCH(39):
        return "NVA297_SET_MME_SHADOW_SCRATCH(39)";
    case NVA297_SET_MME_SHADOW_SCRATCH(40):
        return "NVA297_SET_MME_SHADOW_SCRATCH(40)";
    case NVA297_SET_MME_SHADOW_SCRATCH(41):
        return "NVA297_SET_MME_SHADOW_SCRATCH(41)";
    case NVA297_SET_MME_SHADOW_SCRATCH(42):
        return "NVA297_SET_MME_SHADOW_SCRATCH(42)";
    case NVA297_SET_MME_SHADOW_SCRATCH(43):
        return "NVA297_SET_MME_SHADOW_SCRATCH(43)";
    case NVA297_SET_MME_SHADOW_SCRATCH(44):
        return "NVA297_SET_MME_SHADOW_SCRATCH(44)";
    case NVA297_SET_MME_SHADOW_SCRATCH(45):
        return "NVA297_SET_MME_SHADOW_SCRATCH(45)";
    case NVA297_SET_MME_SHADOW_SCRATCH(46):
        return "NVA297_SET_MME_SHADOW_SCRATCH(46)";
    case NVA297_SET_MME_SHADOW_SCRATCH(47):
        return "NVA297_SET_MME_SHADOW_SCRATCH(47)";
    case NVA297_SET_MME_SHADOW_SCRATCH(48):
        return "NVA297_SET_MME_SHADOW_SCRATCH(48)";
    case NVA297_SET_MME_SHADOW_SCRATCH(49):
        return "NVA297_SET_MME_SHADOW_SCRATCH(49)";
    case NVA297_SET_MME_SHADOW_SCRATCH(50):
        return "NVA297_SET_MME_SHADOW_SCRATCH(50)";
    case NVA297_SET_MME_SHADOW_SCRATCH(51):
        return "NVA297_SET_MME_SHADOW_SCRATCH(51)";
    case NVA297_SET_MME_SHADOW_SCRATCH(52):
        return "NVA297_SET_MME_SHADOW_SCRATCH(52)";
    case NVA297_SET_MME_SHADOW_SCRATCH(53):
        return "NVA297_SET_MME_SHADOW_SCRATCH(53)";
    case NVA297_SET_MME_SHADOW_SCRATCH(54):
        return "NVA297_SET_MME_SHADOW_SCRATCH(54)";
    case NVA297_SET_MME_SHADOW_SCRATCH(55):
        return "NVA297_SET_MME_SHADOW_SCRATCH(55)";
    case NVA297_SET_MME_SHADOW_SCRATCH(56):
        return "NVA297_SET_MME_SHADOW_SCRATCH(56)";
    case NVA297_SET_MME_SHADOW_SCRATCH(57):
        return "NVA297_SET_MME_SHADOW_SCRATCH(57)";
    case NVA297_SET_MME_SHADOW_SCRATCH(58):
        return "NVA297_SET_MME_SHADOW_SCRATCH(58)";
    case NVA297_SET_MME_SHADOW_SCRATCH(59):
        return "NVA297_SET_MME_SHADOW_SCRATCH(59)";
    case NVA297_SET_MME_SHADOW_SCRATCH(60):
        return "NVA297_SET_MME_SHADOW_SCRATCH(60)";
    case NVA297_SET_MME_SHADOW_SCRATCH(61):
        return "NVA297_SET_MME_SHADOW_SCRATCH(61)";
    case NVA297_SET_MME_SHADOW_SCRATCH(62):
        return "NVA297_SET_MME_SHADOW_SCRATCH(62)";
    case NVA297_SET_MME_SHADOW_SCRATCH(63):
        return "NVA297_SET_MME_SHADOW_SCRATCH(63)";
    case NVA297_SET_MME_SHADOW_SCRATCH(64):
        return "NVA297_SET_MME_SHADOW_SCRATCH(64)";
    case NVA297_SET_MME_SHADOW_SCRATCH(65):
        return "NVA297_SET_MME_SHADOW_SCRATCH(65)";
    case NVA297_SET_MME_SHADOW_SCRATCH(66):
        return "NVA297_SET_MME_SHADOW_SCRATCH(66)";
    case NVA297_SET_MME_SHADOW_SCRATCH(67):
        return "NVA297_SET_MME_SHADOW_SCRATCH(67)";
    case NVA297_SET_MME_SHADOW_SCRATCH(68):
        return "NVA297_SET_MME_SHADOW_SCRATCH(68)";
    case NVA297_SET_MME_SHADOW_SCRATCH(69):
        return "NVA297_SET_MME_SHADOW_SCRATCH(69)";
    case NVA297_SET_MME_SHADOW_SCRATCH(70):
        return "NVA297_SET_MME_SHADOW_SCRATCH(70)";
    case NVA297_SET_MME_SHADOW_SCRATCH(71):
        return "NVA297_SET_MME_SHADOW_SCRATCH(71)";
    case NVA297_SET_MME_SHADOW_SCRATCH(72):
        return "NVA297_SET_MME_SHADOW_SCRATCH(72)";
    case NVA297_SET_MME_SHADOW_SCRATCH(73):
        return "NVA297_SET_MME_SHADOW_SCRATCH(73)";
    case NVA297_SET_MME_SHADOW_SCRATCH(74):
        return "NVA297_SET_MME_SHADOW_SCRATCH(74)";
    case NVA297_SET_MME_SHADOW_SCRATCH(75):
        return "NVA297_SET_MME_SHADOW_SCRATCH(75)";
    case NVA297_SET_MME_SHADOW_SCRATCH(76):
        return "NVA297_SET_MME_SHADOW_SCRATCH(76)";
    case NVA297_SET_MME_SHADOW_SCRATCH(77):
        return "NVA297_SET_MME_SHADOW_SCRATCH(77)";
    case NVA297_SET_MME_SHADOW_SCRATCH(78):
        return "NVA297_SET_MME_SHADOW_SCRATCH(78)";
    case NVA297_SET_MME_SHADOW_SCRATCH(79):
        return "NVA297_SET_MME_SHADOW_SCRATCH(79)";
    case NVA297_SET_MME_SHADOW_SCRATCH(80):
        return "NVA297_SET_MME_SHADOW_SCRATCH(80)";
    case NVA297_SET_MME_SHADOW_SCRATCH(81):
        return "NVA297_SET_MME_SHADOW_SCRATCH(81)";
    case NVA297_SET_MME_SHADOW_SCRATCH(82):
        return "NVA297_SET_MME_SHADOW_SCRATCH(82)";
    case NVA297_SET_MME_SHADOW_SCRATCH(83):
        return "NVA297_SET_MME_SHADOW_SCRATCH(83)";
    case NVA297_SET_MME_SHADOW_SCRATCH(84):
        return "NVA297_SET_MME_SHADOW_SCRATCH(84)";
    case NVA297_SET_MME_SHADOW_SCRATCH(85):
        return "NVA297_SET_MME_SHADOW_SCRATCH(85)";
    case NVA297_SET_MME_SHADOW_SCRATCH(86):
        return "NVA297_SET_MME_SHADOW_SCRATCH(86)";
    case NVA297_SET_MME_SHADOW_SCRATCH(87):
        return "NVA297_SET_MME_SHADOW_SCRATCH(87)";
    case NVA297_SET_MME_SHADOW_SCRATCH(88):
        return "NVA297_SET_MME_SHADOW_SCRATCH(88)";
    case NVA297_SET_MME_SHADOW_SCRATCH(89):
        return "NVA297_SET_MME_SHADOW_SCRATCH(89)";
    case NVA297_SET_MME_SHADOW_SCRATCH(90):
        return "NVA297_SET_MME_SHADOW_SCRATCH(90)";
    case NVA297_SET_MME_SHADOW_SCRATCH(91):
        return "NVA297_SET_MME_SHADOW_SCRATCH(91)";
    case NVA297_SET_MME_SHADOW_SCRATCH(92):
        return "NVA297_SET_MME_SHADOW_SCRATCH(92)";
    case NVA297_SET_MME_SHADOW_SCRATCH(93):
        return "NVA297_SET_MME_SHADOW_SCRATCH(93)";
    case NVA297_SET_MME_SHADOW_SCRATCH(94):
        return "NVA297_SET_MME_SHADOW_SCRATCH(94)";
    case NVA297_SET_MME_SHADOW_SCRATCH(95):
        return "NVA297_SET_MME_SHADOW_SCRATCH(95)";
    case NVA297_SET_MME_SHADOW_SCRATCH(96):
        return "NVA297_SET_MME_SHADOW_SCRATCH(96)";
    case NVA297_SET_MME_SHADOW_SCRATCH(97):
        return "NVA297_SET_MME_SHADOW_SCRATCH(97)";
    case NVA297_SET_MME_SHADOW_SCRATCH(98):
        return "NVA297_SET_MME_SHADOW_SCRATCH(98)";
    case NVA297_SET_MME_SHADOW_SCRATCH(99):
        return "NVA297_SET_MME_SHADOW_SCRATCH(99)";
    case NVA297_SET_MME_SHADOW_SCRATCH(100):
        return "NVA297_SET_MME_SHADOW_SCRATCH(100)";
    case NVA297_SET_MME_SHADOW_SCRATCH(101):
        return "NVA297_SET_MME_SHADOW_SCRATCH(101)";
    case NVA297_SET_MME_SHADOW_SCRATCH(102):
        return "NVA297_SET_MME_SHADOW_SCRATCH(102)";
    case NVA297_SET_MME_SHADOW_SCRATCH(103):
        return "NVA297_SET_MME_SHADOW_SCRATCH(103)";
    case NVA297_SET_MME_SHADOW_SCRATCH(104):
        return "NVA297_SET_MME_SHADOW_SCRATCH(104)";
    case NVA297_SET_MME_SHADOW_SCRATCH(105):
        return "NVA297_SET_MME_SHADOW_SCRATCH(105)";
    case NVA297_SET_MME_SHADOW_SCRATCH(106):
        return "NVA297_SET_MME_SHADOW_SCRATCH(106)";
    case NVA297_SET_MME_SHADOW_SCRATCH(107):
        return "NVA297_SET_MME_SHADOW_SCRATCH(107)";
    case NVA297_SET_MME_SHADOW_SCRATCH(108):
        return "NVA297_SET_MME_SHADOW_SCRATCH(108)";
    case NVA297_SET_MME_SHADOW_SCRATCH(109):
        return "NVA297_SET_MME_SHADOW_SCRATCH(109)";
    case NVA297_SET_MME_SHADOW_SCRATCH(110):
        return "NVA297_SET_MME_SHADOW_SCRATCH(110)";
    case NVA297_SET_MME_SHADOW_SCRATCH(111):
        return "NVA297_SET_MME_SHADOW_SCRATCH(111)";
    case NVA297_SET_MME_SHADOW_SCRATCH(112):
        return "NVA297_SET_MME_SHADOW_SCRATCH(112)";
    case NVA297_SET_MME_SHADOW_SCRATCH(113):
        return "NVA297_SET_MME_SHADOW_SCRATCH(113)";
    case NVA297_SET_MME_SHADOW_SCRATCH(114):
        return "NVA297_SET_MME_SHADOW_SCRATCH(114)";
    case NVA297_SET_MME_SHADOW_SCRATCH(115):
        return "NVA297_SET_MME_SHADOW_SCRATCH(115)";
    case NVA297_SET_MME_SHADOW_SCRATCH(116):
        return "NVA297_SET_MME_SHADOW_SCRATCH(116)";
    case NVA297_SET_MME_SHADOW_SCRATCH(117):
        return "NVA297_SET_MME_SHADOW_SCRATCH(117)";
    case NVA297_SET_MME_SHADOW_SCRATCH(118):
        return "NVA297_SET_MME_SHADOW_SCRATCH(118)";
    case NVA297_SET_MME_SHADOW_SCRATCH(119):
        return "NVA297_SET_MME_SHADOW_SCRATCH(119)";
    case NVA297_SET_MME_SHADOW_SCRATCH(120):
        return "NVA297_SET_MME_SHADOW_SCRATCH(120)";
    case NVA297_SET_MME_SHADOW_SCRATCH(121):
        return "NVA297_SET_MME_SHADOW_SCRATCH(121)";
    case NVA297_SET_MME_SHADOW_SCRATCH(122):
        return "NVA297_SET_MME_SHADOW_SCRATCH(122)";
    case NVA297_SET_MME_SHADOW_SCRATCH(123):
        return "NVA297_SET_MME_SHADOW_SCRATCH(123)";
    case NVA297_SET_MME_SHADOW_SCRATCH(124):
        return "NVA297_SET_MME_SHADOW_SCRATCH(124)";
    case NVA297_SET_MME_SHADOW_SCRATCH(125):
        return "NVA297_SET_MME_SHADOW_SCRATCH(125)";
    case NVA297_SET_MME_SHADOW_SCRATCH(126):
        return "NVA297_SET_MME_SHADOW_SCRATCH(126)";
    case NVA297_SET_MME_SHADOW_SCRATCH(127):
        return "NVA297_SET_MME_SHADOW_SCRATCH(127)";
    case NVA297_SET_MME_SHADOW_SCRATCH(128):
        return "NVA297_SET_MME_SHADOW_SCRATCH(128)";
    case NVA297_SET_MME_SHADOW_SCRATCH(129):
        return "NVA297_SET_MME_SHADOW_SCRATCH(129)";
    case NVA297_SET_MME_SHADOW_SCRATCH(130):
        return "NVA297_SET_MME_SHADOW_SCRATCH(130)";
    case NVA297_SET_MME_SHADOW_SCRATCH(131):
        return "NVA297_SET_MME_SHADOW_SCRATCH(131)";
    case NVA297_SET_MME_SHADOW_SCRATCH(132):
        return "NVA297_SET_MME_SHADOW_SCRATCH(132)";
    case NVA297_SET_MME_SHADOW_SCRATCH(133):
        return "NVA297_SET_MME_SHADOW_SCRATCH(133)";
    case NVA297_SET_MME_SHADOW_SCRATCH(134):
        return "NVA297_SET_MME_SHADOW_SCRATCH(134)";
    case NVA297_SET_MME_SHADOW_SCRATCH(135):
        return "NVA297_SET_MME_SHADOW_SCRATCH(135)";
    case NVA297_SET_MME_SHADOW_SCRATCH(136):
        return "NVA297_SET_MME_SHADOW_SCRATCH(136)";
    case NVA297_SET_MME_SHADOW_SCRATCH(137):
        return "NVA297_SET_MME_SHADOW_SCRATCH(137)";
    case NVA297_SET_MME_SHADOW_SCRATCH(138):
        return "NVA297_SET_MME_SHADOW_SCRATCH(138)";
    case NVA297_SET_MME_SHADOW_SCRATCH(139):
        return "NVA297_SET_MME_SHADOW_SCRATCH(139)";
    case NVA297_SET_MME_SHADOW_SCRATCH(140):
        return "NVA297_SET_MME_SHADOW_SCRATCH(140)";
    case NVA297_SET_MME_SHADOW_SCRATCH(141):
        return "NVA297_SET_MME_SHADOW_SCRATCH(141)";
    case NVA297_SET_MME_SHADOW_SCRATCH(142):
        return "NVA297_SET_MME_SHADOW_SCRATCH(142)";
    case NVA297_SET_MME_SHADOW_SCRATCH(143):
        return "NVA297_SET_MME_SHADOW_SCRATCH(143)";
    case NVA297_SET_MME_SHADOW_SCRATCH(144):
        return "NVA297_SET_MME_SHADOW_SCRATCH(144)";
    case NVA297_SET_MME_SHADOW_SCRATCH(145):
        return "NVA297_SET_MME_SHADOW_SCRATCH(145)";
    case NVA297_SET_MME_SHADOW_SCRATCH(146):
        return "NVA297_SET_MME_SHADOW_SCRATCH(146)";
    case NVA297_SET_MME_SHADOW_SCRATCH(147):
        return "NVA297_SET_MME_SHADOW_SCRATCH(147)";
    case NVA297_SET_MME_SHADOW_SCRATCH(148):
        return "NVA297_SET_MME_SHADOW_SCRATCH(148)";
    case NVA297_SET_MME_SHADOW_SCRATCH(149):
        return "NVA297_SET_MME_SHADOW_SCRATCH(149)";
    case NVA297_SET_MME_SHADOW_SCRATCH(150):
        return "NVA297_SET_MME_SHADOW_SCRATCH(150)";
    case NVA297_SET_MME_SHADOW_SCRATCH(151):
        return "NVA297_SET_MME_SHADOW_SCRATCH(151)";
    case NVA297_SET_MME_SHADOW_SCRATCH(152):
        return "NVA297_SET_MME_SHADOW_SCRATCH(152)";
    case NVA297_SET_MME_SHADOW_SCRATCH(153):
        return "NVA297_SET_MME_SHADOW_SCRATCH(153)";
    case NVA297_SET_MME_SHADOW_SCRATCH(154):
        return "NVA297_SET_MME_SHADOW_SCRATCH(154)";
    case NVA297_SET_MME_SHADOW_SCRATCH(155):
        return "NVA297_SET_MME_SHADOW_SCRATCH(155)";
    case NVA297_SET_MME_SHADOW_SCRATCH(156):
        return "NVA297_SET_MME_SHADOW_SCRATCH(156)";
    case NVA297_SET_MME_SHADOW_SCRATCH(157):
        return "NVA297_SET_MME_SHADOW_SCRATCH(157)";
    case NVA297_SET_MME_SHADOW_SCRATCH(158):
        return "NVA297_SET_MME_SHADOW_SCRATCH(158)";
    case NVA297_SET_MME_SHADOW_SCRATCH(159):
        return "NVA297_SET_MME_SHADOW_SCRATCH(159)";
    case NVA297_SET_MME_SHADOW_SCRATCH(160):
        return "NVA297_SET_MME_SHADOW_SCRATCH(160)";
    case NVA297_SET_MME_SHADOW_SCRATCH(161):
        return "NVA297_SET_MME_SHADOW_SCRATCH(161)";
    case NVA297_SET_MME_SHADOW_SCRATCH(162):
        return "NVA297_SET_MME_SHADOW_SCRATCH(162)";
    case NVA297_SET_MME_SHADOW_SCRATCH(163):
        return "NVA297_SET_MME_SHADOW_SCRATCH(163)";
    case NVA297_SET_MME_SHADOW_SCRATCH(164):
        return "NVA297_SET_MME_SHADOW_SCRATCH(164)";
    case NVA297_SET_MME_SHADOW_SCRATCH(165):
        return "NVA297_SET_MME_SHADOW_SCRATCH(165)";
    case NVA297_SET_MME_SHADOW_SCRATCH(166):
        return "NVA297_SET_MME_SHADOW_SCRATCH(166)";
    case NVA297_SET_MME_SHADOW_SCRATCH(167):
        return "NVA297_SET_MME_SHADOW_SCRATCH(167)";
    case NVA297_SET_MME_SHADOW_SCRATCH(168):
        return "NVA297_SET_MME_SHADOW_SCRATCH(168)";
    case NVA297_SET_MME_SHADOW_SCRATCH(169):
        return "NVA297_SET_MME_SHADOW_SCRATCH(169)";
    case NVA297_SET_MME_SHADOW_SCRATCH(170):
        return "NVA297_SET_MME_SHADOW_SCRATCH(170)";
    case NVA297_SET_MME_SHADOW_SCRATCH(171):
        return "NVA297_SET_MME_SHADOW_SCRATCH(171)";
    case NVA297_SET_MME_SHADOW_SCRATCH(172):
        return "NVA297_SET_MME_SHADOW_SCRATCH(172)";
    case NVA297_SET_MME_SHADOW_SCRATCH(173):
        return "NVA297_SET_MME_SHADOW_SCRATCH(173)";
    case NVA297_SET_MME_SHADOW_SCRATCH(174):
        return "NVA297_SET_MME_SHADOW_SCRATCH(174)";
    case NVA297_SET_MME_SHADOW_SCRATCH(175):
        return "NVA297_SET_MME_SHADOW_SCRATCH(175)";
    case NVA297_SET_MME_SHADOW_SCRATCH(176):
        return "NVA297_SET_MME_SHADOW_SCRATCH(176)";
    case NVA297_SET_MME_SHADOW_SCRATCH(177):
        return "NVA297_SET_MME_SHADOW_SCRATCH(177)";
    case NVA297_SET_MME_SHADOW_SCRATCH(178):
        return "NVA297_SET_MME_SHADOW_SCRATCH(178)";
    case NVA297_SET_MME_SHADOW_SCRATCH(179):
        return "NVA297_SET_MME_SHADOW_SCRATCH(179)";
    case NVA297_SET_MME_SHADOW_SCRATCH(180):
        return "NVA297_SET_MME_SHADOW_SCRATCH(180)";
    case NVA297_SET_MME_SHADOW_SCRATCH(181):
        return "NVA297_SET_MME_SHADOW_SCRATCH(181)";
    case NVA297_SET_MME_SHADOW_SCRATCH(182):
        return "NVA297_SET_MME_SHADOW_SCRATCH(182)";
    case NVA297_SET_MME_SHADOW_SCRATCH(183):
        return "NVA297_SET_MME_SHADOW_SCRATCH(183)";
    case NVA297_SET_MME_SHADOW_SCRATCH(184):
        return "NVA297_SET_MME_SHADOW_SCRATCH(184)";
    case NVA297_SET_MME_SHADOW_SCRATCH(185):
        return "NVA297_SET_MME_SHADOW_SCRATCH(185)";
    case NVA297_SET_MME_SHADOW_SCRATCH(186):
        return "NVA297_SET_MME_SHADOW_SCRATCH(186)";
    case NVA297_SET_MME_SHADOW_SCRATCH(187):
        return "NVA297_SET_MME_SHADOW_SCRATCH(187)";
    case NVA297_SET_MME_SHADOW_SCRATCH(188):
        return "NVA297_SET_MME_SHADOW_SCRATCH(188)";
    case NVA297_SET_MME_SHADOW_SCRATCH(189):
        return "NVA297_SET_MME_SHADOW_SCRATCH(189)";
    case NVA297_SET_MME_SHADOW_SCRATCH(190):
        return "NVA297_SET_MME_SHADOW_SCRATCH(190)";
    case NVA297_SET_MME_SHADOW_SCRATCH(191):
        return "NVA297_SET_MME_SHADOW_SCRATCH(191)";
    case NVA297_SET_MME_SHADOW_SCRATCH(192):
        return "NVA297_SET_MME_SHADOW_SCRATCH(192)";
    case NVA297_SET_MME_SHADOW_SCRATCH(193):
        return "NVA297_SET_MME_SHADOW_SCRATCH(193)";
    case NVA297_SET_MME_SHADOW_SCRATCH(194):
        return "NVA297_SET_MME_SHADOW_SCRATCH(194)";
    case NVA297_SET_MME_SHADOW_SCRATCH(195):
        return "NVA297_SET_MME_SHADOW_SCRATCH(195)";
    case NVA297_SET_MME_SHADOW_SCRATCH(196):
        return "NVA297_SET_MME_SHADOW_SCRATCH(196)";
    case NVA297_SET_MME_SHADOW_SCRATCH(197):
        return "NVA297_SET_MME_SHADOW_SCRATCH(197)";
    case NVA297_SET_MME_SHADOW_SCRATCH(198):
        return "NVA297_SET_MME_SHADOW_SCRATCH(198)";
    case NVA297_SET_MME_SHADOW_SCRATCH(199):
        return "NVA297_SET_MME_SHADOW_SCRATCH(199)";
    case NVA297_SET_MME_SHADOW_SCRATCH(200):
        return "NVA297_SET_MME_SHADOW_SCRATCH(200)";
    case NVA297_SET_MME_SHADOW_SCRATCH(201):
        return "NVA297_SET_MME_SHADOW_SCRATCH(201)";
    case NVA297_SET_MME_SHADOW_SCRATCH(202):
        return "NVA297_SET_MME_SHADOW_SCRATCH(202)";
    case NVA297_SET_MME_SHADOW_SCRATCH(203):
        return "NVA297_SET_MME_SHADOW_SCRATCH(203)";
    case NVA297_SET_MME_SHADOW_SCRATCH(204):
        return "NVA297_SET_MME_SHADOW_SCRATCH(204)";
    case NVA297_SET_MME_SHADOW_SCRATCH(205):
        return "NVA297_SET_MME_SHADOW_SCRATCH(205)";
    case NVA297_SET_MME_SHADOW_SCRATCH(206):
        return "NVA297_SET_MME_SHADOW_SCRATCH(206)";
    case NVA297_SET_MME_SHADOW_SCRATCH(207):
        return "NVA297_SET_MME_SHADOW_SCRATCH(207)";
    case NVA297_SET_MME_SHADOW_SCRATCH(208):
        return "NVA297_SET_MME_SHADOW_SCRATCH(208)";
    case NVA297_SET_MME_SHADOW_SCRATCH(209):
        return "NVA297_SET_MME_SHADOW_SCRATCH(209)";
    case NVA297_SET_MME_SHADOW_SCRATCH(210):
        return "NVA297_SET_MME_SHADOW_SCRATCH(210)";
    case NVA297_SET_MME_SHADOW_SCRATCH(211):
        return "NVA297_SET_MME_SHADOW_SCRATCH(211)";
    case NVA297_SET_MME_SHADOW_SCRATCH(212):
        return "NVA297_SET_MME_SHADOW_SCRATCH(212)";
    case NVA297_SET_MME_SHADOW_SCRATCH(213):
        return "NVA297_SET_MME_SHADOW_SCRATCH(213)";
    case NVA297_SET_MME_SHADOW_SCRATCH(214):
        return "NVA297_SET_MME_SHADOW_SCRATCH(214)";
    case NVA297_SET_MME_SHADOW_SCRATCH(215):
        return "NVA297_SET_MME_SHADOW_SCRATCH(215)";
    case NVA297_SET_MME_SHADOW_SCRATCH(216):
        return "NVA297_SET_MME_SHADOW_SCRATCH(216)";
    case NVA297_SET_MME_SHADOW_SCRATCH(217):
        return "NVA297_SET_MME_SHADOW_SCRATCH(217)";
    case NVA297_SET_MME_SHADOW_SCRATCH(218):
        return "NVA297_SET_MME_SHADOW_SCRATCH(218)";
    case NVA297_SET_MME_SHADOW_SCRATCH(219):
        return "NVA297_SET_MME_SHADOW_SCRATCH(219)";
    case NVA297_SET_MME_SHADOW_SCRATCH(220):
        return "NVA297_SET_MME_SHADOW_SCRATCH(220)";
    case NVA297_SET_MME_SHADOW_SCRATCH(221):
        return "NVA297_SET_MME_SHADOW_SCRATCH(221)";
    case NVA297_SET_MME_SHADOW_SCRATCH(222):
        return "NVA297_SET_MME_SHADOW_SCRATCH(222)";
    case NVA297_SET_MME_SHADOW_SCRATCH(223):
        return "NVA297_SET_MME_SHADOW_SCRATCH(223)";
    case NVA297_SET_MME_SHADOW_SCRATCH(224):
        return "NVA297_SET_MME_SHADOW_SCRATCH(224)";
    case NVA297_SET_MME_SHADOW_SCRATCH(225):
        return "NVA297_SET_MME_SHADOW_SCRATCH(225)";
    case NVA297_SET_MME_SHADOW_SCRATCH(226):
        return "NVA297_SET_MME_SHADOW_SCRATCH(226)";
    case NVA297_SET_MME_SHADOW_SCRATCH(227):
        return "NVA297_SET_MME_SHADOW_SCRATCH(227)";
    case NVA297_SET_MME_SHADOW_SCRATCH(228):
        return "NVA297_SET_MME_SHADOW_SCRATCH(228)";
    case NVA297_SET_MME_SHADOW_SCRATCH(229):
        return "NVA297_SET_MME_SHADOW_SCRATCH(229)";
    case NVA297_SET_MME_SHADOW_SCRATCH(230):
        return "NVA297_SET_MME_SHADOW_SCRATCH(230)";
    case NVA297_SET_MME_SHADOW_SCRATCH(231):
        return "NVA297_SET_MME_SHADOW_SCRATCH(231)";
    case NVA297_SET_MME_SHADOW_SCRATCH(232):
        return "NVA297_SET_MME_SHADOW_SCRATCH(232)";
    case NVA297_SET_MME_SHADOW_SCRATCH(233):
        return "NVA297_SET_MME_SHADOW_SCRATCH(233)";
    case NVA297_SET_MME_SHADOW_SCRATCH(234):
        return "NVA297_SET_MME_SHADOW_SCRATCH(234)";
    case NVA297_SET_MME_SHADOW_SCRATCH(235):
        return "NVA297_SET_MME_SHADOW_SCRATCH(235)";
    case NVA297_SET_MME_SHADOW_SCRATCH(236):
        return "NVA297_SET_MME_SHADOW_SCRATCH(236)";
    case NVA297_SET_MME_SHADOW_SCRATCH(237):
        return "NVA297_SET_MME_SHADOW_SCRATCH(237)";
    case NVA297_SET_MME_SHADOW_SCRATCH(238):
        return "NVA297_SET_MME_SHADOW_SCRATCH(238)";
    case NVA297_SET_MME_SHADOW_SCRATCH(239):
        return "NVA297_SET_MME_SHADOW_SCRATCH(239)";
    case NVA297_SET_MME_SHADOW_SCRATCH(240):
        return "NVA297_SET_MME_SHADOW_SCRATCH(240)";
    case NVA297_SET_MME_SHADOW_SCRATCH(241):
        return "NVA297_SET_MME_SHADOW_SCRATCH(241)";
    case NVA297_SET_MME_SHADOW_SCRATCH(242):
        return "NVA297_SET_MME_SHADOW_SCRATCH(242)";
    case NVA297_SET_MME_SHADOW_SCRATCH(243):
        return "NVA297_SET_MME_SHADOW_SCRATCH(243)";
    case NVA297_SET_MME_SHADOW_SCRATCH(244):
        return "NVA297_SET_MME_SHADOW_SCRATCH(244)";
    case NVA297_SET_MME_SHADOW_SCRATCH(245):
        return "NVA297_SET_MME_SHADOW_SCRATCH(245)";
    case NVA297_SET_MME_SHADOW_SCRATCH(246):
        return "NVA297_SET_MME_SHADOW_SCRATCH(246)";
    case NVA297_SET_MME_SHADOW_SCRATCH(247):
        return "NVA297_SET_MME_SHADOW_SCRATCH(247)";
    case NVA297_SET_MME_SHADOW_SCRATCH(248):
        return "NVA297_SET_MME_SHADOW_SCRATCH(248)";
    case NVA297_SET_MME_SHADOW_SCRATCH(249):
        return "NVA297_SET_MME_SHADOW_SCRATCH(249)";
    case NVA297_SET_MME_SHADOW_SCRATCH(250):
        return "NVA297_SET_MME_SHADOW_SCRATCH(250)";
    case NVA297_SET_MME_SHADOW_SCRATCH(251):
        return "NVA297_SET_MME_SHADOW_SCRATCH(251)";
    case NVA297_SET_MME_SHADOW_SCRATCH(252):
        return "NVA297_SET_MME_SHADOW_SCRATCH(252)";
    case NVA297_SET_MME_SHADOW_SCRATCH(253):
        return "NVA297_SET_MME_SHADOW_SCRATCH(253)";
    case NVA297_SET_MME_SHADOW_SCRATCH(254):
        return "NVA297_SET_MME_SHADOW_SCRATCH(254)";
    case NVA297_SET_MME_SHADOW_SCRATCH(255):
        return "NVA297_SET_MME_SHADOW_SCRATCH(255)";
    case NVA297_CALL_MME_MACRO(0):
        return "NVA297_CALL_MME_MACRO(0)";
    case NVA297_CALL_MME_MACRO(1):
        return "NVA297_CALL_MME_MACRO(1)";
    case NVA297_CALL_MME_MACRO(2):
        return "NVA297_CALL_MME_MACRO(2)";
    case NVA297_CALL_MME_MACRO(3):
        return "NVA297_CALL_MME_MACRO(3)";
    case NVA297_CALL_MME_MACRO(4):
        return "NVA297_CALL_MME_MACRO(4)";
    case NVA297_CALL_MME_MACRO(5):
        return "NVA297_CALL_MME_MACRO(5)";
    case NVA297_CALL_MME_MACRO(6):
        return "NVA297_CALL_MME_MACRO(6)";
    case NVA297_CALL_MME_MACRO(7):
        return "NVA297_CALL_MME_MACRO(7)";
    case NVA297_CALL_MME_MACRO(8):
        return "NVA297_CALL_MME_MACRO(8)";
    case NVA297_CALL_MME_MACRO(9):
        return "NVA297_CALL_MME_MACRO(9)";
    case NVA297_CALL_MME_MACRO(10):
        return "NVA297_CALL_MME_MACRO(10)";
    case NVA297_CALL_MME_MACRO(11):
        return "NVA297_CALL_MME_MACRO(11)";
    case NVA297_CALL_MME_MACRO(12):
        return "NVA297_CALL_MME_MACRO(12)";
    case NVA297_CALL_MME_MACRO(13):
        return "NVA297_CALL_MME_MACRO(13)";
    case NVA297_CALL_MME_MACRO(14):
        return "NVA297_CALL_MME_MACRO(14)";
    case NVA297_CALL_MME_MACRO(15):
        return "NVA297_CALL_MME_MACRO(15)";
    case NVA297_CALL_MME_MACRO(16):
        return "NVA297_CALL_MME_MACRO(16)";
    case NVA297_CALL_MME_MACRO(17):
        return "NVA297_CALL_MME_MACRO(17)";
    case NVA297_CALL_MME_MACRO(18):
        return "NVA297_CALL_MME_MACRO(18)";
    case NVA297_CALL_MME_MACRO(19):
        return "NVA297_CALL_MME_MACRO(19)";
    case NVA297_CALL_MME_MACRO(20):
        return "NVA297_CALL_MME_MACRO(20)";
    case NVA297_CALL_MME_MACRO(21):
        return "NVA297_CALL_MME_MACRO(21)";
    case NVA297_CALL_MME_MACRO(22):
        return "NVA297_CALL_MME_MACRO(22)";
    case NVA297_CALL_MME_MACRO(23):
        return "NVA297_CALL_MME_MACRO(23)";
    case NVA297_CALL_MME_MACRO(24):
        return "NVA297_CALL_MME_MACRO(24)";
    case NVA297_CALL_MME_MACRO(25):
        return "NVA297_CALL_MME_MACRO(25)";
    case NVA297_CALL_MME_MACRO(26):
        return "NVA297_CALL_MME_MACRO(26)";
    case NVA297_CALL_MME_MACRO(27):
        return "NVA297_CALL_MME_MACRO(27)";
    case NVA297_CALL_MME_MACRO(28):
        return "NVA297_CALL_MME_MACRO(28)";
    case NVA297_CALL_MME_MACRO(29):
        return "NVA297_CALL_MME_MACRO(29)";
    case NVA297_CALL_MME_MACRO(30):
        return "NVA297_CALL_MME_MACRO(30)";
    case NVA297_CALL_MME_MACRO(31):
        return "NVA297_CALL_MME_MACRO(31)";
    case NVA297_CALL_MME_MACRO(32):
        return "NVA297_CALL_MME_MACRO(32)";
    case NVA297_CALL_MME_MACRO(33):
        return "NVA297_CALL_MME_MACRO(33)";
    case NVA297_CALL_MME_MACRO(34):
        return "NVA297_CALL_MME_MACRO(34)";
    case NVA297_CALL_MME_MACRO(35):
        return "NVA297_CALL_MME_MACRO(35)";
    case NVA297_CALL_MME_MACRO(36):
        return "NVA297_CALL_MME_MACRO(36)";
    case NVA297_CALL_MME_MACRO(37):
        return "NVA297_CALL_MME_MACRO(37)";
    case NVA297_CALL_MME_MACRO(38):
        return "NVA297_CALL_MME_MACRO(38)";
    case NVA297_CALL_MME_MACRO(39):
        return "NVA297_CALL_MME_MACRO(39)";
    case NVA297_CALL_MME_MACRO(40):
        return "NVA297_CALL_MME_MACRO(40)";
    case NVA297_CALL_MME_MACRO(41):
        return "NVA297_CALL_MME_MACRO(41)";
    case NVA297_CALL_MME_MACRO(42):
        return "NVA297_CALL_MME_MACRO(42)";
    case NVA297_CALL_MME_MACRO(43):
        return "NVA297_CALL_MME_MACRO(43)";
    case NVA297_CALL_MME_MACRO(44):
        return "NVA297_CALL_MME_MACRO(44)";
    case NVA297_CALL_MME_MACRO(45):
        return "NVA297_CALL_MME_MACRO(45)";
    case NVA297_CALL_MME_MACRO(46):
        return "NVA297_CALL_MME_MACRO(46)";
    case NVA297_CALL_MME_MACRO(47):
        return "NVA297_CALL_MME_MACRO(47)";
    case NVA297_CALL_MME_MACRO(48):
        return "NVA297_CALL_MME_MACRO(48)";
    case NVA297_CALL_MME_MACRO(49):
        return "NVA297_CALL_MME_MACRO(49)";
    case NVA297_CALL_MME_MACRO(50):
        return "NVA297_CALL_MME_MACRO(50)";
    case NVA297_CALL_MME_MACRO(51):
        return "NVA297_CALL_MME_MACRO(51)";
    case NVA297_CALL_MME_MACRO(52):
        return "NVA297_CALL_MME_MACRO(52)";
    case NVA297_CALL_MME_MACRO(53):
        return "NVA297_CALL_MME_MACRO(53)";
    case NVA297_CALL_MME_MACRO(54):
        return "NVA297_CALL_MME_MACRO(54)";
    case NVA297_CALL_MME_MACRO(55):
        return "NVA297_CALL_MME_MACRO(55)";
    case NVA297_CALL_MME_MACRO(56):
        return "NVA297_CALL_MME_MACRO(56)";
    case NVA297_CALL_MME_MACRO(57):
        return "NVA297_CALL_MME_MACRO(57)";
    case NVA297_CALL_MME_MACRO(58):
        return "NVA297_CALL_MME_MACRO(58)";
    case NVA297_CALL_MME_MACRO(59):
        return "NVA297_CALL_MME_MACRO(59)";
    case NVA297_CALL_MME_MACRO(60):
        return "NVA297_CALL_MME_MACRO(60)";
    case NVA297_CALL_MME_MACRO(61):
        return "NVA297_CALL_MME_MACRO(61)";
    case NVA297_CALL_MME_MACRO(62):
        return "NVA297_CALL_MME_MACRO(62)";
    case NVA297_CALL_MME_MACRO(63):
        return "NVA297_CALL_MME_MACRO(63)";
    case NVA297_CALL_MME_MACRO(64):
        return "NVA297_CALL_MME_MACRO(64)";
    case NVA297_CALL_MME_MACRO(65):
        return "NVA297_CALL_MME_MACRO(65)";
    case NVA297_CALL_MME_MACRO(66):
        return "NVA297_CALL_MME_MACRO(66)";
    case NVA297_CALL_MME_MACRO(67):
        return "NVA297_CALL_MME_MACRO(67)";
    case NVA297_CALL_MME_MACRO(68):
        return "NVA297_CALL_MME_MACRO(68)";
    case NVA297_CALL_MME_MACRO(69):
        return "NVA297_CALL_MME_MACRO(69)";
    case NVA297_CALL_MME_MACRO(70):
        return "NVA297_CALL_MME_MACRO(70)";
    case NVA297_CALL_MME_MACRO(71):
        return "NVA297_CALL_MME_MACRO(71)";
    case NVA297_CALL_MME_MACRO(72):
        return "NVA297_CALL_MME_MACRO(72)";
    case NVA297_CALL_MME_MACRO(73):
        return "NVA297_CALL_MME_MACRO(73)";
    case NVA297_CALL_MME_MACRO(74):
        return "NVA297_CALL_MME_MACRO(74)";
    case NVA297_CALL_MME_MACRO(75):
        return "NVA297_CALL_MME_MACRO(75)";
    case NVA297_CALL_MME_MACRO(76):
        return "NVA297_CALL_MME_MACRO(76)";
    case NVA297_CALL_MME_MACRO(77):
        return "NVA297_CALL_MME_MACRO(77)";
    case NVA297_CALL_MME_MACRO(78):
        return "NVA297_CALL_MME_MACRO(78)";
    case NVA297_CALL_MME_MACRO(79):
        return "NVA297_CALL_MME_MACRO(79)";
    case NVA297_CALL_MME_MACRO(80):
        return "NVA297_CALL_MME_MACRO(80)";
    case NVA297_CALL_MME_MACRO(81):
        return "NVA297_CALL_MME_MACRO(81)";
    case NVA297_CALL_MME_MACRO(82):
        return "NVA297_CALL_MME_MACRO(82)";
    case NVA297_CALL_MME_MACRO(83):
        return "NVA297_CALL_MME_MACRO(83)";
    case NVA297_CALL_MME_MACRO(84):
        return "NVA297_CALL_MME_MACRO(84)";
    case NVA297_CALL_MME_MACRO(85):
        return "NVA297_CALL_MME_MACRO(85)";
    case NVA297_CALL_MME_MACRO(86):
        return "NVA297_CALL_MME_MACRO(86)";
    case NVA297_CALL_MME_MACRO(87):
        return "NVA297_CALL_MME_MACRO(87)";
    case NVA297_CALL_MME_MACRO(88):
        return "NVA297_CALL_MME_MACRO(88)";
    case NVA297_CALL_MME_MACRO(89):
        return "NVA297_CALL_MME_MACRO(89)";
    case NVA297_CALL_MME_MACRO(90):
        return "NVA297_CALL_MME_MACRO(90)";
    case NVA297_CALL_MME_MACRO(91):
        return "NVA297_CALL_MME_MACRO(91)";
    case NVA297_CALL_MME_MACRO(92):
        return "NVA297_CALL_MME_MACRO(92)";
    case NVA297_CALL_MME_MACRO(93):
        return "NVA297_CALL_MME_MACRO(93)";
    case NVA297_CALL_MME_MACRO(94):
        return "NVA297_CALL_MME_MACRO(94)";
    case NVA297_CALL_MME_MACRO(95):
        return "NVA297_CALL_MME_MACRO(95)";
    case NVA297_CALL_MME_MACRO(96):
        return "NVA297_CALL_MME_MACRO(96)";
    case NVA297_CALL_MME_MACRO(97):
        return "NVA297_CALL_MME_MACRO(97)";
    case NVA297_CALL_MME_MACRO(98):
        return "NVA297_CALL_MME_MACRO(98)";
    case NVA297_CALL_MME_MACRO(99):
        return "NVA297_CALL_MME_MACRO(99)";
    case NVA297_CALL_MME_MACRO(100):
        return "NVA297_CALL_MME_MACRO(100)";
    case NVA297_CALL_MME_MACRO(101):
        return "NVA297_CALL_MME_MACRO(101)";
    case NVA297_CALL_MME_MACRO(102):
        return "NVA297_CALL_MME_MACRO(102)";
    case NVA297_CALL_MME_MACRO(103):
        return "NVA297_CALL_MME_MACRO(103)";
    case NVA297_CALL_MME_MACRO(104):
        return "NVA297_CALL_MME_MACRO(104)";
    case NVA297_CALL_MME_MACRO(105):
        return "NVA297_CALL_MME_MACRO(105)";
    case NVA297_CALL_MME_MACRO(106):
        return "NVA297_CALL_MME_MACRO(106)";
    case NVA297_CALL_MME_MACRO(107):
        return "NVA297_CALL_MME_MACRO(107)";
    case NVA297_CALL_MME_MACRO(108):
        return "NVA297_CALL_MME_MACRO(108)";
    case NVA297_CALL_MME_MACRO(109):
        return "NVA297_CALL_MME_MACRO(109)";
    case NVA297_CALL_MME_MACRO(110):
        return "NVA297_CALL_MME_MACRO(110)";
    case NVA297_CALL_MME_MACRO(111):
        return "NVA297_CALL_MME_MACRO(111)";
    case NVA297_CALL_MME_MACRO(112):
        return "NVA297_CALL_MME_MACRO(112)";
    case NVA297_CALL_MME_MACRO(113):
        return "NVA297_CALL_MME_MACRO(113)";
    case NVA297_CALL_MME_MACRO(114):
        return "NVA297_CALL_MME_MACRO(114)";
    case NVA297_CALL_MME_MACRO(115):
        return "NVA297_CALL_MME_MACRO(115)";
    case NVA297_CALL_MME_MACRO(116):
        return "NVA297_CALL_MME_MACRO(116)";
    case NVA297_CALL_MME_MACRO(117):
        return "NVA297_CALL_MME_MACRO(117)";
    case NVA297_CALL_MME_MACRO(118):
        return "NVA297_CALL_MME_MACRO(118)";
    case NVA297_CALL_MME_MACRO(119):
        return "NVA297_CALL_MME_MACRO(119)";
    case NVA297_CALL_MME_MACRO(120):
        return "NVA297_CALL_MME_MACRO(120)";
    case NVA297_CALL_MME_MACRO(121):
        return "NVA297_CALL_MME_MACRO(121)";
    case NVA297_CALL_MME_MACRO(122):
        return "NVA297_CALL_MME_MACRO(122)";
    case NVA297_CALL_MME_MACRO(123):
        return "NVA297_CALL_MME_MACRO(123)";
    case NVA297_CALL_MME_MACRO(124):
        return "NVA297_CALL_MME_MACRO(124)";
    case NVA297_CALL_MME_MACRO(125):
        return "NVA297_CALL_MME_MACRO(125)";
    case NVA297_CALL_MME_MACRO(126):
        return "NVA297_CALL_MME_MACRO(126)";
    case NVA297_CALL_MME_MACRO(127):
        return "NVA297_CALL_MME_MACRO(127)";
    case NVA297_CALL_MME_MACRO(128):
        return "NVA297_CALL_MME_MACRO(128)";
    case NVA297_CALL_MME_MACRO(129):
        return "NVA297_CALL_MME_MACRO(129)";
    case NVA297_CALL_MME_MACRO(130):
        return "NVA297_CALL_MME_MACRO(130)";
    case NVA297_CALL_MME_MACRO(131):
        return "NVA297_CALL_MME_MACRO(131)";
    case NVA297_CALL_MME_MACRO(132):
        return "NVA297_CALL_MME_MACRO(132)";
    case NVA297_CALL_MME_MACRO(133):
        return "NVA297_CALL_MME_MACRO(133)";
    case NVA297_CALL_MME_MACRO(134):
        return "NVA297_CALL_MME_MACRO(134)";
    case NVA297_CALL_MME_MACRO(135):
        return "NVA297_CALL_MME_MACRO(135)";
    case NVA297_CALL_MME_MACRO(136):
        return "NVA297_CALL_MME_MACRO(136)";
    case NVA297_CALL_MME_MACRO(137):
        return "NVA297_CALL_MME_MACRO(137)";
    case NVA297_CALL_MME_MACRO(138):
        return "NVA297_CALL_MME_MACRO(138)";
    case NVA297_CALL_MME_MACRO(139):
        return "NVA297_CALL_MME_MACRO(139)";
    case NVA297_CALL_MME_MACRO(140):
        return "NVA297_CALL_MME_MACRO(140)";
    case NVA297_CALL_MME_MACRO(141):
        return "NVA297_CALL_MME_MACRO(141)";
    case NVA297_CALL_MME_MACRO(142):
        return "NVA297_CALL_MME_MACRO(142)";
    case NVA297_CALL_MME_MACRO(143):
        return "NVA297_CALL_MME_MACRO(143)";
    case NVA297_CALL_MME_MACRO(144):
        return "NVA297_CALL_MME_MACRO(144)";
    case NVA297_CALL_MME_MACRO(145):
        return "NVA297_CALL_MME_MACRO(145)";
    case NVA297_CALL_MME_MACRO(146):
        return "NVA297_CALL_MME_MACRO(146)";
    case NVA297_CALL_MME_MACRO(147):
        return "NVA297_CALL_MME_MACRO(147)";
    case NVA297_CALL_MME_MACRO(148):
        return "NVA297_CALL_MME_MACRO(148)";
    case NVA297_CALL_MME_MACRO(149):
        return "NVA297_CALL_MME_MACRO(149)";
    case NVA297_CALL_MME_MACRO(150):
        return "NVA297_CALL_MME_MACRO(150)";
    case NVA297_CALL_MME_MACRO(151):
        return "NVA297_CALL_MME_MACRO(151)";
    case NVA297_CALL_MME_MACRO(152):
        return "NVA297_CALL_MME_MACRO(152)";
    case NVA297_CALL_MME_MACRO(153):
        return "NVA297_CALL_MME_MACRO(153)";
    case NVA297_CALL_MME_MACRO(154):
        return "NVA297_CALL_MME_MACRO(154)";
    case NVA297_CALL_MME_MACRO(155):
        return "NVA297_CALL_MME_MACRO(155)";
    case NVA297_CALL_MME_MACRO(156):
        return "NVA297_CALL_MME_MACRO(156)";
    case NVA297_CALL_MME_MACRO(157):
        return "NVA297_CALL_MME_MACRO(157)";
    case NVA297_CALL_MME_MACRO(158):
        return "NVA297_CALL_MME_MACRO(158)";
    case NVA297_CALL_MME_MACRO(159):
        return "NVA297_CALL_MME_MACRO(159)";
    case NVA297_CALL_MME_MACRO(160):
        return "NVA297_CALL_MME_MACRO(160)";
    case NVA297_CALL_MME_MACRO(161):
        return "NVA297_CALL_MME_MACRO(161)";
    case NVA297_CALL_MME_MACRO(162):
        return "NVA297_CALL_MME_MACRO(162)";
    case NVA297_CALL_MME_MACRO(163):
        return "NVA297_CALL_MME_MACRO(163)";
    case NVA297_CALL_MME_MACRO(164):
        return "NVA297_CALL_MME_MACRO(164)";
    case NVA297_CALL_MME_MACRO(165):
        return "NVA297_CALL_MME_MACRO(165)";
    case NVA297_CALL_MME_MACRO(166):
        return "NVA297_CALL_MME_MACRO(166)";
    case NVA297_CALL_MME_MACRO(167):
        return "NVA297_CALL_MME_MACRO(167)";
    case NVA297_CALL_MME_MACRO(168):
        return "NVA297_CALL_MME_MACRO(168)";
    case NVA297_CALL_MME_MACRO(169):
        return "NVA297_CALL_MME_MACRO(169)";
    case NVA297_CALL_MME_MACRO(170):
        return "NVA297_CALL_MME_MACRO(170)";
    case NVA297_CALL_MME_MACRO(171):
        return "NVA297_CALL_MME_MACRO(171)";
    case NVA297_CALL_MME_MACRO(172):
        return "NVA297_CALL_MME_MACRO(172)";
    case NVA297_CALL_MME_MACRO(173):
        return "NVA297_CALL_MME_MACRO(173)";
    case NVA297_CALL_MME_MACRO(174):
        return "NVA297_CALL_MME_MACRO(174)";
    case NVA297_CALL_MME_MACRO(175):
        return "NVA297_CALL_MME_MACRO(175)";
    case NVA297_CALL_MME_MACRO(176):
        return "NVA297_CALL_MME_MACRO(176)";
    case NVA297_CALL_MME_MACRO(177):
        return "NVA297_CALL_MME_MACRO(177)";
    case NVA297_CALL_MME_MACRO(178):
        return "NVA297_CALL_MME_MACRO(178)";
    case NVA297_CALL_MME_MACRO(179):
        return "NVA297_CALL_MME_MACRO(179)";
    case NVA297_CALL_MME_MACRO(180):
        return "NVA297_CALL_MME_MACRO(180)";
    case NVA297_CALL_MME_MACRO(181):
        return "NVA297_CALL_MME_MACRO(181)";
    case NVA297_CALL_MME_MACRO(182):
        return "NVA297_CALL_MME_MACRO(182)";
    case NVA297_CALL_MME_MACRO(183):
        return "NVA297_CALL_MME_MACRO(183)";
    case NVA297_CALL_MME_MACRO(184):
        return "NVA297_CALL_MME_MACRO(184)";
    case NVA297_CALL_MME_MACRO(185):
        return "NVA297_CALL_MME_MACRO(185)";
    case NVA297_CALL_MME_MACRO(186):
        return "NVA297_CALL_MME_MACRO(186)";
    case NVA297_CALL_MME_MACRO(187):
        return "NVA297_CALL_MME_MACRO(187)";
    case NVA297_CALL_MME_MACRO(188):
        return "NVA297_CALL_MME_MACRO(188)";
    case NVA297_CALL_MME_MACRO(189):
        return "NVA297_CALL_MME_MACRO(189)";
    case NVA297_CALL_MME_MACRO(190):
        return "NVA297_CALL_MME_MACRO(190)";
    case NVA297_CALL_MME_MACRO(191):
        return "NVA297_CALL_MME_MACRO(191)";
    case NVA297_CALL_MME_MACRO(192):
        return "NVA297_CALL_MME_MACRO(192)";
    case NVA297_CALL_MME_MACRO(193):
        return "NVA297_CALL_MME_MACRO(193)";
    case NVA297_CALL_MME_MACRO(194):
        return "NVA297_CALL_MME_MACRO(194)";
    case NVA297_CALL_MME_MACRO(195):
        return "NVA297_CALL_MME_MACRO(195)";
    case NVA297_CALL_MME_MACRO(196):
        return "NVA297_CALL_MME_MACRO(196)";
    case NVA297_CALL_MME_MACRO(197):
        return "NVA297_CALL_MME_MACRO(197)";
    case NVA297_CALL_MME_MACRO(198):
        return "NVA297_CALL_MME_MACRO(198)";
    case NVA297_CALL_MME_MACRO(199):
        return "NVA297_CALL_MME_MACRO(199)";
    case NVA297_CALL_MME_MACRO(200):
        return "NVA297_CALL_MME_MACRO(200)";
    case NVA297_CALL_MME_MACRO(201):
        return "NVA297_CALL_MME_MACRO(201)";
    case NVA297_CALL_MME_MACRO(202):
        return "NVA297_CALL_MME_MACRO(202)";
    case NVA297_CALL_MME_MACRO(203):
        return "NVA297_CALL_MME_MACRO(203)";
    case NVA297_CALL_MME_MACRO(204):
        return "NVA297_CALL_MME_MACRO(204)";
    case NVA297_CALL_MME_MACRO(205):
        return "NVA297_CALL_MME_MACRO(205)";
    case NVA297_CALL_MME_MACRO(206):
        return "NVA297_CALL_MME_MACRO(206)";
    case NVA297_CALL_MME_MACRO(207):
        return "NVA297_CALL_MME_MACRO(207)";
    case NVA297_CALL_MME_MACRO(208):
        return "NVA297_CALL_MME_MACRO(208)";
    case NVA297_CALL_MME_MACRO(209):
        return "NVA297_CALL_MME_MACRO(209)";
    case NVA297_CALL_MME_MACRO(210):
        return "NVA297_CALL_MME_MACRO(210)";
    case NVA297_CALL_MME_MACRO(211):
        return "NVA297_CALL_MME_MACRO(211)";
    case NVA297_CALL_MME_MACRO(212):
        return "NVA297_CALL_MME_MACRO(212)";
    case NVA297_CALL_MME_MACRO(213):
        return "NVA297_CALL_MME_MACRO(213)";
    case NVA297_CALL_MME_MACRO(214):
        return "NVA297_CALL_MME_MACRO(214)";
    case NVA297_CALL_MME_MACRO(215):
        return "NVA297_CALL_MME_MACRO(215)";
    case NVA297_CALL_MME_MACRO(216):
        return "NVA297_CALL_MME_MACRO(216)";
    case NVA297_CALL_MME_MACRO(217):
        return "NVA297_CALL_MME_MACRO(217)";
    case NVA297_CALL_MME_MACRO(218):
        return "NVA297_CALL_MME_MACRO(218)";
    case NVA297_CALL_MME_MACRO(219):
        return "NVA297_CALL_MME_MACRO(219)";
    case NVA297_CALL_MME_MACRO(220):
        return "NVA297_CALL_MME_MACRO(220)";
    case NVA297_CALL_MME_MACRO(221):
        return "NVA297_CALL_MME_MACRO(221)";
    case NVA297_CALL_MME_MACRO(222):
        return "NVA297_CALL_MME_MACRO(222)";
    case NVA297_CALL_MME_MACRO(223):
        return "NVA297_CALL_MME_MACRO(223)";
    case NVA297_CALL_MME_MACRO(224):
        return "NVA297_CALL_MME_MACRO(224)";
    case NVA297_CALL_MME_MACRO(225):
        return "NVA297_CALL_MME_MACRO(225)";
    case NVA297_CALL_MME_MACRO(226):
        return "NVA297_CALL_MME_MACRO(226)";
    case NVA297_CALL_MME_MACRO(227):
        return "NVA297_CALL_MME_MACRO(227)";
    case NVA297_CALL_MME_MACRO(228):
        return "NVA297_CALL_MME_MACRO(228)";
    case NVA297_CALL_MME_MACRO(229):
        return "NVA297_CALL_MME_MACRO(229)";
    case NVA297_CALL_MME_MACRO(230):
        return "NVA297_CALL_MME_MACRO(230)";
    case NVA297_CALL_MME_MACRO(231):
        return "NVA297_CALL_MME_MACRO(231)";
    case NVA297_CALL_MME_MACRO(232):
        return "NVA297_CALL_MME_MACRO(232)";
    case NVA297_CALL_MME_MACRO(233):
        return "NVA297_CALL_MME_MACRO(233)";
    case NVA297_CALL_MME_MACRO(234):
        return "NVA297_CALL_MME_MACRO(234)";
    case NVA297_CALL_MME_MACRO(235):
        return "NVA297_CALL_MME_MACRO(235)";
    case NVA297_CALL_MME_MACRO(236):
        return "NVA297_CALL_MME_MACRO(236)";
    case NVA297_CALL_MME_MACRO(237):
        return "NVA297_CALL_MME_MACRO(237)";
    case NVA297_CALL_MME_MACRO(238):
        return "NVA297_CALL_MME_MACRO(238)";
    case NVA297_CALL_MME_MACRO(239):
        return "NVA297_CALL_MME_MACRO(239)";
    case NVA297_CALL_MME_MACRO(240):
        return "NVA297_CALL_MME_MACRO(240)";
    case NVA297_CALL_MME_MACRO(241):
        return "NVA297_CALL_MME_MACRO(241)";
    case NVA297_CALL_MME_MACRO(242):
        return "NVA297_CALL_MME_MACRO(242)";
    case NVA297_CALL_MME_MACRO(243):
        return "NVA297_CALL_MME_MACRO(243)";
    case NVA297_CALL_MME_MACRO(244):
        return "NVA297_CALL_MME_MACRO(244)";
    case NVA297_CALL_MME_MACRO(245):
        return "NVA297_CALL_MME_MACRO(245)";
    case NVA297_CALL_MME_MACRO(246):
        return "NVA297_CALL_MME_MACRO(246)";
    case NVA297_CALL_MME_MACRO(247):
        return "NVA297_CALL_MME_MACRO(247)";
    case NVA297_CALL_MME_MACRO(248):
        return "NVA297_CALL_MME_MACRO(248)";
    case NVA297_CALL_MME_MACRO(249):
        return "NVA297_CALL_MME_MACRO(249)";
    case NVA297_CALL_MME_MACRO(250):
        return "NVA297_CALL_MME_MACRO(250)";
    case NVA297_CALL_MME_MACRO(251):
        return "NVA297_CALL_MME_MACRO(251)";
    case NVA297_CALL_MME_MACRO(252):
        return "NVA297_CALL_MME_MACRO(252)";
    case NVA297_CALL_MME_MACRO(253):
        return "NVA297_CALL_MME_MACRO(253)";
    case NVA297_CALL_MME_MACRO(254):
        return "NVA297_CALL_MME_MACRO(254)";
    case NVA297_CALL_MME_MACRO(255):
        return "NVA297_CALL_MME_MACRO(255)";
    case NVA297_CALL_MME_DATA(0):
        return "NVA297_CALL_MME_DATA(0)";
    case NVA297_CALL_MME_DATA(1):
        return "NVA297_CALL_MME_DATA(1)";
    case NVA297_CALL_MME_DATA(2):
        return "NVA297_CALL_MME_DATA(2)";
    case NVA297_CALL_MME_DATA(3):
        return "NVA297_CALL_MME_DATA(3)";
    case NVA297_CALL_MME_DATA(4):
        return "NVA297_CALL_MME_DATA(4)";
    case NVA297_CALL_MME_DATA(5):
        return "NVA297_CALL_MME_DATA(5)";
    case NVA297_CALL_MME_DATA(6):
        return "NVA297_CALL_MME_DATA(6)";
    case NVA297_CALL_MME_DATA(7):
        return "NVA297_CALL_MME_DATA(7)";
    case NVA297_CALL_MME_DATA(8):
        return "NVA297_CALL_MME_DATA(8)";
    case NVA297_CALL_MME_DATA(9):
        return "NVA297_CALL_MME_DATA(9)";
    case NVA297_CALL_MME_DATA(10):
        return "NVA297_CALL_MME_DATA(10)";
    case NVA297_CALL_MME_DATA(11):
        return "NVA297_CALL_MME_DATA(11)";
    case NVA297_CALL_MME_DATA(12):
        return "NVA297_CALL_MME_DATA(12)";
    case NVA297_CALL_MME_DATA(13):
        return "NVA297_CALL_MME_DATA(13)";
    case NVA297_CALL_MME_DATA(14):
        return "NVA297_CALL_MME_DATA(14)";
    case NVA297_CALL_MME_DATA(15):
        return "NVA297_CALL_MME_DATA(15)";
    case NVA297_CALL_MME_DATA(16):
        return "NVA297_CALL_MME_DATA(16)";
    case NVA297_CALL_MME_DATA(17):
        return "NVA297_CALL_MME_DATA(17)";
    case NVA297_CALL_MME_DATA(18):
        return "NVA297_CALL_MME_DATA(18)";
    case NVA297_CALL_MME_DATA(19):
        return "NVA297_CALL_MME_DATA(19)";
    case NVA297_CALL_MME_DATA(20):
        return "NVA297_CALL_MME_DATA(20)";
    case NVA297_CALL_MME_DATA(21):
        return "NVA297_CALL_MME_DATA(21)";
    case NVA297_CALL_MME_DATA(22):
        return "NVA297_CALL_MME_DATA(22)";
    case NVA297_CALL_MME_DATA(23):
        return "NVA297_CALL_MME_DATA(23)";
    case NVA297_CALL_MME_DATA(24):
        return "NVA297_CALL_MME_DATA(24)";
    case NVA297_CALL_MME_DATA(25):
        return "NVA297_CALL_MME_DATA(25)";
    case NVA297_CALL_MME_DATA(26):
        return "NVA297_CALL_MME_DATA(26)";
    case NVA297_CALL_MME_DATA(27):
        return "NVA297_CALL_MME_DATA(27)";
    case NVA297_CALL_MME_DATA(28):
        return "NVA297_CALL_MME_DATA(28)";
    case NVA297_CALL_MME_DATA(29):
        return "NVA297_CALL_MME_DATA(29)";
    case NVA297_CALL_MME_DATA(30):
        return "NVA297_CALL_MME_DATA(30)";
    case NVA297_CALL_MME_DATA(31):
        return "NVA297_CALL_MME_DATA(31)";
    case NVA297_CALL_MME_DATA(32):
        return "NVA297_CALL_MME_DATA(32)";
    case NVA297_CALL_MME_DATA(33):
        return "NVA297_CALL_MME_DATA(33)";
    case NVA297_CALL_MME_DATA(34):
        return "NVA297_CALL_MME_DATA(34)";
    case NVA297_CALL_MME_DATA(35):
        return "NVA297_CALL_MME_DATA(35)";
    case NVA297_CALL_MME_DATA(36):
        return "NVA297_CALL_MME_DATA(36)";
    case NVA297_CALL_MME_DATA(37):
        return "NVA297_CALL_MME_DATA(37)";
    case NVA297_CALL_MME_DATA(38):
        return "NVA297_CALL_MME_DATA(38)";
    case NVA297_CALL_MME_DATA(39):
        return "NVA297_CALL_MME_DATA(39)";
    case NVA297_CALL_MME_DATA(40):
        return "NVA297_CALL_MME_DATA(40)";
    case NVA297_CALL_MME_DATA(41):
        return "NVA297_CALL_MME_DATA(41)";
    case NVA297_CALL_MME_DATA(42):
        return "NVA297_CALL_MME_DATA(42)";
    case NVA297_CALL_MME_DATA(43):
        return "NVA297_CALL_MME_DATA(43)";
    case NVA297_CALL_MME_DATA(44):
        return "NVA297_CALL_MME_DATA(44)";
    case NVA297_CALL_MME_DATA(45):
        return "NVA297_CALL_MME_DATA(45)";
    case NVA297_CALL_MME_DATA(46):
        return "NVA297_CALL_MME_DATA(46)";
    case NVA297_CALL_MME_DATA(47):
        return "NVA297_CALL_MME_DATA(47)";
    case NVA297_CALL_MME_DATA(48):
        return "NVA297_CALL_MME_DATA(48)";
    case NVA297_CALL_MME_DATA(49):
        return "NVA297_CALL_MME_DATA(49)";
    case NVA297_CALL_MME_DATA(50):
        return "NVA297_CALL_MME_DATA(50)";
    case NVA297_CALL_MME_DATA(51):
        return "NVA297_CALL_MME_DATA(51)";
    case NVA297_CALL_MME_DATA(52):
        return "NVA297_CALL_MME_DATA(52)";
    case NVA297_CALL_MME_DATA(53):
        return "NVA297_CALL_MME_DATA(53)";
    case NVA297_CALL_MME_DATA(54):
        return "NVA297_CALL_MME_DATA(54)";
    case NVA297_CALL_MME_DATA(55):
        return "NVA297_CALL_MME_DATA(55)";
    case NVA297_CALL_MME_DATA(56):
        return "NVA297_CALL_MME_DATA(56)";
    case NVA297_CALL_MME_DATA(57):
        return "NVA297_CALL_MME_DATA(57)";
    case NVA297_CALL_MME_DATA(58):
        return "NVA297_CALL_MME_DATA(58)";
    case NVA297_CALL_MME_DATA(59):
        return "NVA297_CALL_MME_DATA(59)";
    case NVA297_CALL_MME_DATA(60):
        return "NVA297_CALL_MME_DATA(60)";
    case NVA297_CALL_MME_DATA(61):
        return "NVA297_CALL_MME_DATA(61)";
    case NVA297_CALL_MME_DATA(62):
        return "NVA297_CALL_MME_DATA(62)";
    case NVA297_CALL_MME_DATA(63):
        return "NVA297_CALL_MME_DATA(63)";
    case NVA297_CALL_MME_DATA(64):
        return "NVA297_CALL_MME_DATA(64)";
    case NVA297_CALL_MME_DATA(65):
        return "NVA297_CALL_MME_DATA(65)";
    case NVA297_CALL_MME_DATA(66):
        return "NVA297_CALL_MME_DATA(66)";
    case NVA297_CALL_MME_DATA(67):
        return "NVA297_CALL_MME_DATA(67)";
    case NVA297_CALL_MME_DATA(68):
        return "NVA297_CALL_MME_DATA(68)";
    case NVA297_CALL_MME_DATA(69):
        return "NVA297_CALL_MME_DATA(69)";
    case NVA297_CALL_MME_DATA(70):
        return "NVA297_CALL_MME_DATA(70)";
    case NVA297_CALL_MME_DATA(71):
        return "NVA297_CALL_MME_DATA(71)";
    case NVA297_CALL_MME_DATA(72):
        return "NVA297_CALL_MME_DATA(72)";
    case NVA297_CALL_MME_DATA(73):
        return "NVA297_CALL_MME_DATA(73)";
    case NVA297_CALL_MME_DATA(74):
        return "NVA297_CALL_MME_DATA(74)";
    case NVA297_CALL_MME_DATA(75):
        return "NVA297_CALL_MME_DATA(75)";
    case NVA297_CALL_MME_DATA(76):
        return "NVA297_CALL_MME_DATA(76)";
    case NVA297_CALL_MME_DATA(77):
        return "NVA297_CALL_MME_DATA(77)";
    case NVA297_CALL_MME_DATA(78):
        return "NVA297_CALL_MME_DATA(78)";
    case NVA297_CALL_MME_DATA(79):
        return "NVA297_CALL_MME_DATA(79)";
    case NVA297_CALL_MME_DATA(80):
        return "NVA297_CALL_MME_DATA(80)";
    case NVA297_CALL_MME_DATA(81):
        return "NVA297_CALL_MME_DATA(81)";
    case NVA297_CALL_MME_DATA(82):
        return "NVA297_CALL_MME_DATA(82)";
    case NVA297_CALL_MME_DATA(83):
        return "NVA297_CALL_MME_DATA(83)";
    case NVA297_CALL_MME_DATA(84):
        return "NVA297_CALL_MME_DATA(84)";
    case NVA297_CALL_MME_DATA(85):
        return "NVA297_CALL_MME_DATA(85)";
    case NVA297_CALL_MME_DATA(86):
        return "NVA297_CALL_MME_DATA(86)";
    case NVA297_CALL_MME_DATA(87):
        return "NVA297_CALL_MME_DATA(87)";
    case NVA297_CALL_MME_DATA(88):
        return "NVA297_CALL_MME_DATA(88)";
    case NVA297_CALL_MME_DATA(89):
        return "NVA297_CALL_MME_DATA(89)";
    case NVA297_CALL_MME_DATA(90):
        return "NVA297_CALL_MME_DATA(90)";
    case NVA297_CALL_MME_DATA(91):
        return "NVA297_CALL_MME_DATA(91)";
    case NVA297_CALL_MME_DATA(92):
        return "NVA297_CALL_MME_DATA(92)";
    case NVA297_CALL_MME_DATA(93):
        return "NVA297_CALL_MME_DATA(93)";
    case NVA297_CALL_MME_DATA(94):
        return "NVA297_CALL_MME_DATA(94)";
    case NVA297_CALL_MME_DATA(95):
        return "NVA297_CALL_MME_DATA(95)";
    case NVA297_CALL_MME_DATA(96):
        return "NVA297_CALL_MME_DATA(96)";
    case NVA297_CALL_MME_DATA(97):
        return "NVA297_CALL_MME_DATA(97)";
    case NVA297_CALL_MME_DATA(98):
        return "NVA297_CALL_MME_DATA(98)";
    case NVA297_CALL_MME_DATA(99):
        return "NVA297_CALL_MME_DATA(99)";
    case NVA297_CALL_MME_DATA(100):
        return "NVA297_CALL_MME_DATA(100)";
    case NVA297_CALL_MME_DATA(101):
        return "NVA297_CALL_MME_DATA(101)";
    case NVA297_CALL_MME_DATA(102):
        return "NVA297_CALL_MME_DATA(102)";
    case NVA297_CALL_MME_DATA(103):
        return "NVA297_CALL_MME_DATA(103)";
    case NVA297_CALL_MME_DATA(104):
        return "NVA297_CALL_MME_DATA(104)";
    case NVA297_CALL_MME_DATA(105):
        return "NVA297_CALL_MME_DATA(105)";
    case NVA297_CALL_MME_DATA(106):
        return "NVA297_CALL_MME_DATA(106)";
    case NVA297_CALL_MME_DATA(107):
        return "NVA297_CALL_MME_DATA(107)";
    case NVA297_CALL_MME_DATA(108):
        return "NVA297_CALL_MME_DATA(108)";
    case NVA297_CALL_MME_DATA(109):
        return "NVA297_CALL_MME_DATA(109)";
    case NVA297_CALL_MME_DATA(110):
        return "NVA297_CALL_MME_DATA(110)";
    case NVA297_CALL_MME_DATA(111):
        return "NVA297_CALL_MME_DATA(111)";
    case NVA297_CALL_MME_DATA(112):
        return "NVA297_CALL_MME_DATA(112)";
    case NVA297_CALL_MME_DATA(113):
        return "NVA297_CALL_MME_DATA(113)";
    case NVA297_CALL_MME_DATA(114):
        return "NVA297_CALL_MME_DATA(114)";
    case NVA297_CALL_MME_DATA(115):
        return "NVA297_CALL_MME_DATA(115)";
    case NVA297_CALL_MME_DATA(116):
        return "NVA297_CALL_MME_DATA(116)";
    case NVA297_CALL_MME_DATA(117):
        return "NVA297_CALL_MME_DATA(117)";
    case NVA297_CALL_MME_DATA(118):
        return "NVA297_CALL_MME_DATA(118)";
    case NVA297_CALL_MME_DATA(119):
        return "NVA297_CALL_MME_DATA(119)";
    case NVA297_CALL_MME_DATA(120):
        return "NVA297_CALL_MME_DATA(120)";
    case NVA297_CALL_MME_DATA(121):
        return "NVA297_CALL_MME_DATA(121)";
    case NVA297_CALL_MME_DATA(122):
        return "NVA297_CALL_MME_DATA(122)";
    case NVA297_CALL_MME_DATA(123):
        return "NVA297_CALL_MME_DATA(123)";
    case NVA297_CALL_MME_DATA(124):
        return "NVA297_CALL_MME_DATA(124)";
    case NVA297_CALL_MME_DATA(125):
        return "NVA297_CALL_MME_DATA(125)";
    case NVA297_CALL_MME_DATA(126):
        return "NVA297_CALL_MME_DATA(126)";
    case NVA297_CALL_MME_DATA(127):
        return "NVA297_CALL_MME_DATA(127)";
    case NVA297_CALL_MME_DATA(128):
        return "NVA297_CALL_MME_DATA(128)";
    case NVA297_CALL_MME_DATA(129):
        return "NVA297_CALL_MME_DATA(129)";
    case NVA297_CALL_MME_DATA(130):
        return "NVA297_CALL_MME_DATA(130)";
    case NVA297_CALL_MME_DATA(131):
        return "NVA297_CALL_MME_DATA(131)";
    case NVA297_CALL_MME_DATA(132):
        return "NVA297_CALL_MME_DATA(132)";
    case NVA297_CALL_MME_DATA(133):
        return "NVA297_CALL_MME_DATA(133)";
    case NVA297_CALL_MME_DATA(134):
        return "NVA297_CALL_MME_DATA(134)";
    case NVA297_CALL_MME_DATA(135):
        return "NVA297_CALL_MME_DATA(135)";
    case NVA297_CALL_MME_DATA(136):
        return "NVA297_CALL_MME_DATA(136)";
    case NVA297_CALL_MME_DATA(137):
        return "NVA297_CALL_MME_DATA(137)";
    case NVA297_CALL_MME_DATA(138):
        return "NVA297_CALL_MME_DATA(138)";
    case NVA297_CALL_MME_DATA(139):
        return "NVA297_CALL_MME_DATA(139)";
    case NVA297_CALL_MME_DATA(140):
        return "NVA297_CALL_MME_DATA(140)";
    case NVA297_CALL_MME_DATA(141):
        return "NVA297_CALL_MME_DATA(141)";
    case NVA297_CALL_MME_DATA(142):
        return "NVA297_CALL_MME_DATA(142)";
    case NVA297_CALL_MME_DATA(143):
        return "NVA297_CALL_MME_DATA(143)";
    case NVA297_CALL_MME_DATA(144):
        return "NVA297_CALL_MME_DATA(144)";
    case NVA297_CALL_MME_DATA(145):
        return "NVA297_CALL_MME_DATA(145)";
    case NVA297_CALL_MME_DATA(146):
        return "NVA297_CALL_MME_DATA(146)";
    case NVA297_CALL_MME_DATA(147):
        return "NVA297_CALL_MME_DATA(147)";
    case NVA297_CALL_MME_DATA(148):
        return "NVA297_CALL_MME_DATA(148)";
    case NVA297_CALL_MME_DATA(149):
        return "NVA297_CALL_MME_DATA(149)";
    case NVA297_CALL_MME_DATA(150):
        return "NVA297_CALL_MME_DATA(150)";
    case NVA297_CALL_MME_DATA(151):
        return "NVA297_CALL_MME_DATA(151)";
    case NVA297_CALL_MME_DATA(152):
        return "NVA297_CALL_MME_DATA(152)";
    case NVA297_CALL_MME_DATA(153):
        return "NVA297_CALL_MME_DATA(153)";
    case NVA297_CALL_MME_DATA(154):
        return "NVA297_CALL_MME_DATA(154)";
    case NVA297_CALL_MME_DATA(155):
        return "NVA297_CALL_MME_DATA(155)";
    case NVA297_CALL_MME_DATA(156):
        return "NVA297_CALL_MME_DATA(156)";
    case NVA297_CALL_MME_DATA(157):
        return "NVA297_CALL_MME_DATA(157)";
    case NVA297_CALL_MME_DATA(158):
        return "NVA297_CALL_MME_DATA(158)";
    case NVA297_CALL_MME_DATA(159):
        return "NVA297_CALL_MME_DATA(159)";
    case NVA297_CALL_MME_DATA(160):
        return "NVA297_CALL_MME_DATA(160)";
    case NVA297_CALL_MME_DATA(161):
        return "NVA297_CALL_MME_DATA(161)";
    case NVA297_CALL_MME_DATA(162):
        return "NVA297_CALL_MME_DATA(162)";
    case NVA297_CALL_MME_DATA(163):
        return "NVA297_CALL_MME_DATA(163)";
    case NVA297_CALL_MME_DATA(164):
        return "NVA297_CALL_MME_DATA(164)";
    case NVA297_CALL_MME_DATA(165):
        return "NVA297_CALL_MME_DATA(165)";
    case NVA297_CALL_MME_DATA(166):
        return "NVA297_CALL_MME_DATA(166)";
    case NVA297_CALL_MME_DATA(167):
        return "NVA297_CALL_MME_DATA(167)";
    case NVA297_CALL_MME_DATA(168):
        return "NVA297_CALL_MME_DATA(168)";
    case NVA297_CALL_MME_DATA(169):
        return "NVA297_CALL_MME_DATA(169)";
    case NVA297_CALL_MME_DATA(170):
        return "NVA297_CALL_MME_DATA(170)";
    case NVA297_CALL_MME_DATA(171):
        return "NVA297_CALL_MME_DATA(171)";
    case NVA297_CALL_MME_DATA(172):
        return "NVA297_CALL_MME_DATA(172)";
    case NVA297_CALL_MME_DATA(173):
        return "NVA297_CALL_MME_DATA(173)";
    case NVA297_CALL_MME_DATA(174):
        return "NVA297_CALL_MME_DATA(174)";
    case NVA297_CALL_MME_DATA(175):
        return "NVA297_CALL_MME_DATA(175)";
    case NVA297_CALL_MME_DATA(176):
        return "NVA297_CALL_MME_DATA(176)";
    case NVA297_CALL_MME_DATA(177):
        return "NVA297_CALL_MME_DATA(177)";
    case NVA297_CALL_MME_DATA(178):
        return "NVA297_CALL_MME_DATA(178)";
    case NVA297_CALL_MME_DATA(179):
        return "NVA297_CALL_MME_DATA(179)";
    case NVA297_CALL_MME_DATA(180):
        return "NVA297_CALL_MME_DATA(180)";
    case NVA297_CALL_MME_DATA(181):
        return "NVA297_CALL_MME_DATA(181)";
    case NVA297_CALL_MME_DATA(182):
        return "NVA297_CALL_MME_DATA(182)";
    case NVA297_CALL_MME_DATA(183):
        return "NVA297_CALL_MME_DATA(183)";
    case NVA297_CALL_MME_DATA(184):
        return "NVA297_CALL_MME_DATA(184)";
    case NVA297_CALL_MME_DATA(185):
        return "NVA297_CALL_MME_DATA(185)";
    case NVA297_CALL_MME_DATA(186):
        return "NVA297_CALL_MME_DATA(186)";
    case NVA297_CALL_MME_DATA(187):
        return "NVA297_CALL_MME_DATA(187)";
    case NVA297_CALL_MME_DATA(188):
        return "NVA297_CALL_MME_DATA(188)";
    case NVA297_CALL_MME_DATA(189):
        return "NVA297_CALL_MME_DATA(189)";
    case NVA297_CALL_MME_DATA(190):
        return "NVA297_CALL_MME_DATA(190)";
    case NVA297_CALL_MME_DATA(191):
        return "NVA297_CALL_MME_DATA(191)";
    case NVA297_CALL_MME_DATA(192):
        return "NVA297_CALL_MME_DATA(192)";
    case NVA297_CALL_MME_DATA(193):
        return "NVA297_CALL_MME_DATA(193)";
    case NVA297_CALL_MME_DATA(194):
        return "NVA297_CALL_MME_DATA(194)";
    case NVA297_CALL_MME_DATA(195):
        return "NVA297_CALL_MME_DATA(195)";
    case NVA297_CALL_MME_DATA(196):
        return "NVA297_CALL_MME_DATA(196)";
    case NVA297_CALL_MME_DATA(197):
        return "NVA297_CALL_MME_DATA(197)";
    case NVA297_CALL_MME_DATA(198):
        return "NVA297_CALL_MME_DATA(198)";
    case NVA297_CALL_MME_DATA(199):
        return "NVA297_CALL_MME_DATA(199)";
    case NVA297_CALL_MME_DATA(200):
        return "NVA297_CALL_MME_DATA(200)";
    case NVA297_CALL_MME_DATA(201):
        return "NVA297_CALL_MME_DATA(201)";
    case NVA297_CALL_MME_DATA(202):
        return "NVA297_CALL_MME_DATA(202)";
    case NVA297_CALL_MME_DATA(203):
        return "NVA297_CALL_MME_DATA(203)";
    case NVA297_CALL_MME_DATA(204):
        return "NVA297_CALL_MME_DATA(204)";
    case NVA297_CALL_MME_DATA(205):
        return "NVA297_CALL_MME_DATA(205)";
    case NVA297_CALL_MME_DATA(206):
        return "NVA297_CALL_MME_DATA(206)";
    case NVA297_CALL_MME_DATA(207):
        return "NVA297_CALL_MME_DATA(207)";
    case NVA297_CALL_MME_DATA(208):
        return "NVA297_CALL_MME_DATA(208)";
    case NVA297_CALL_MME_DATA(209):
        return "NVA297_CALL_MME_DATA(209)";
    case NVA297_CALL_MME_DATA(210):
        return "NVA297_CALL_MME_DATA(210)";
    case NVA297_CALL_MME_DATA(211):
        return "NVA297_CALL_MME_DATA(211)";
    case NVA297_CALL_MME_DATA(212):
        return "NVA297_CALL_MME_DATA(212)";
    case NVA297_CALL_MME_DATA(213):
        return "NVA297_CALL_MME_DATA(213)";
    case NVA297_CALL_MME_DATA(214):
        return "NVA297_CALL_MME_DATA(214)";
    case NVA297_CALL_MME_DATA(215):
        return "NVA297_CALL_MME_DATA(215)";
    case NVA297_CALL_MME_DATA(216):
        return "NVA297_CALL_MME_DATA(216)";
    case NVA297_CALL_MME_DATA(217):
        return "NVA297_CALL_MME_DATA(217)";
    case NVA297_CALL_MME_DATA(218):
        return "NVA297_CALL_MME_DATA(218)";
    case NVA297_CALL_MME_DATA(219):
        return "NVA297_CALL_MME_DATA(219)";
    case NVA297_CALL_MME_DATA(220):
        return "NVA297_CALL_MME_DATA(220)";
    case NVA297_CALL_MME_DATA(221):
        return "NVA297_CALL_MME_DATA(221)";
    case NVA297_CALL_MME_DATA(222):
        return "NVA297_CALL_MME_DATA(222)";
    case NVA297_CALL_MME_DATA(223):
        return "NVA297_CALL_MME_DATA(223)";
    case NVA297_CALL_MME_DATA(224):
        return "NVA297_CALL_MME_DATA(224)";
    case NVA297_CALL_MME_DATA(225):
        return "NVA297_CALL_MME_DATA(225)";
    case NVA297_CALL_MME_DATA(226):
        return "NVA297_CALL_MME_DATA(226)";
    case NVA297_CALL_MME_DATA(227):
        return "NVA297_CALL_MME_DATA(227)";
    case NVA297_CALL_MME_DATA(228):
        return "NVA297_CALL_MME_DATA(228)";
    case NVA297_CALL_MME_DATA(229):
        return "NVA297_CALL_MME_DATA(229)";
    case NVA297_CALL_MME_DATA(230):
        return "NVA297_CALL_MME_DATA(230)";
    case NVA297_CALL_MME_DATA(231):
        return "NVA297_CALL_MME_DATA(231)";
    case NVA297_CALL_MME_DATA(232):
        return "NVA297_CALL_MME_DATA(232)";
    case NVA297_CALL_MME_DATA(233):
        return "NVA297_CALL_MME_DATA(233)";
    case NVA297_CALL_MME_DATA(234):
        return "NVA297_CALL_MME_DATA(234)";
    case NVA297_CALL_MME_DATA(235):
        return "NVA297_CALL_MME_DATA(235)";
    case NVA297_CALL_MME_DATA(236):
        return "NVA297_CALL_MME_DATA(236)";
    case NVA297_CALL_MME_DATA(237):
        return "NVA297_CALL_MME_DATA(237)";
    case NVA297_CALL_MME_DATA(238):
        return "NVA297_CALL_MME_DATA(238)";
    case NVA297_CALL_MME_DATA(239):
        return "NVA297_CALL_MME_DATA(239)";
    case NVA297_CALL_MME_DATA(240):
        return "NVA297_CALL_MME_DATA(240)";
    case NVA297_CALL_MME_DATA(241):
        return "NVA297_CALL_MME_DATA(241)";
    case NVA297_CALL_MME_DATA(242):
        return "NVA297_CALL_MME_DATA(242)";
    case NVA297_CALL_MME_DATA(243):
        return "NVA297_CALL_MME_DATA(243)";
    case NVA297_CALL_MME_DATA(244):
        return "NVA297_CALL_MME_DATA(244)";
    case NVA297_CALL_MME_DATA(245):
        return "NVA297_CALL_MME_DATA(245)";
    case NVA297_CALL_MME_DATA(246):
        return "NVA297_CALL_MME_DATA(246)";
    case NVA297_CALL_MME_DATA(247):
        return "NVA297_CALL_MME_DATA(247)";
    case NVA297_CALL_MME_DATA(248):
        return "NVA297_CALL_MME_DATA(248)";
    case NVA297_CALL_MME_DATA(249):
        return "NVA297_CALL_MME_DATA(249)";
    case NVA297_CALL_MME_DATA(250):
        return "NVA297_CALL_MME_DATA(250)";
    case NVA297_CALL_MME_DATA(251):
        return "NVA297_CALL_MME_DATA(251)";
    case NVA297_CALL_MME_DATA(252):
        return "NVA297_CALL_MME_DATA(252)";
    case NVA297_CALL_MME_DATA(253):
        return "NVA297_CALL_MME_DATA(253)";
    case NVA297_CALL_MME_DATA(254):
        return "NVA297_CALL_MME_DATA(254)";
    case NVA297_CALL_MME_DATA(255):
        return "NVA297_CALL_MME_DATA(255)";
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVA297_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {
    case NVA297_SET_OBJECT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CLASS_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 5) - 1);
        fprintf(fp, "%s.ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_NO_OPERATION:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_NOTIFY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_NOTIFY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_NOTIFY:
    
        parsed = data;
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVA297_NOTIFY_TYPE_WRITE_ONLY:
            fprintf(fp, "WRITE_ONLY\n");
            break;
        case NVA297_NOTIFY_TYPE_WRITE_THEN_AWAKEN:
            fprintf(fp, "WRITE_THEN_AWAKEN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_WAIT_FOR_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LOAD_MME_INSTRUCTION_RAM_POINTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LOAD_MME_INSTRUCTION_RAM:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LOAD_MME_START_ADDRESS_RAM_POINTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LOAD_MME_START_ADDRESS_RAM:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_MME_SHADOW_RAM_CONTROL:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK:
            fprintf(fp, "METHOD_TRACK\n");
            break;
        case NVA297_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER:
            fprintf(fp, "METHOD_TRACK_WITH_FILTER\n");
            break;
        case NVA297_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH:
            fprintf(fp, "METHOD_PASSTHROUGH\n");
            break;
        case NVA297_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY:
            fprintf(fp, "METHOD_REPLAY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_PEER_SEMAPHORE_RELEASE_OFFSET:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_GLOBAL_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_GLOBAL_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_GLOBAL_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVA297_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVA297_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVA297_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SEND_GO_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_PM_TRIGGER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_PM_TRIGGER_WFI:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_INSTRUMENTATION_METHOD_HEADER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_INSTRUMENTATION_METHOD_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LINE_LENGTH_IN:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LINE_COUNT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_OFFSET_OUT_UPPER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_OFFSET_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_PITCH_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DST_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVA297_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVA297_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVA297_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVA297_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DST_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DST_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DST_DEPTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DST_LAYER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DST_ORIGIN_BYTES_X:
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DST_ORIGIN_SAMPLES_Y:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LAUNCH_DMA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVA297_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVA297_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPLETION_TYPE = ", prefix);
        switch (parsed) {
        case NVA297_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE:
            fprintf(fp, "FLUSH_DISABLE\n");
            break;
        case NVA297_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY:
            fprintf(fp, "FLUSH_ONLY\n");
            break;
        case NVA297_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE:
            fprintf(fp, "RELEASE_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVA297_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVA297_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT:
            fprintf(fp, "INTERRUPT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_STRUCT_SIZE = ", prefix);
        switch (parsed) {
        case NVA297_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVA297_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_LAUNCH_DMA_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVA297_LAUNCH_DMA_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVA297_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVA297_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSMEMBAR_DISABLE = ", prefix);
        switch (parsed) {
        case NVA297_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_LOAD_INLINE_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_I2M_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_I2M_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_I2M_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_I2M_SPARE_NOOP00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_I2M_SPARE_NOOP01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_I2M_SPARE_NOOP02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_I2M_SPARE_NOOP03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RUN_DS_NOW:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.ACCUMULATED_PRIM_AREA_THRESHOLD = ", prefix);
        switch (parsed) {
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_INSTANTANEOUS:
            fprintf(fp, "INSTANTANEOUS\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16:
            fprintf(fp, "_16\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32:
            fprintf(fp, "_32\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__64:
            fprintf(fp, "_64\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__128:
            fprintf(fp, "_128\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__256:
            fprintf(fp, "_256\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__512:
            fprintf(fp, "_512\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1024:
            fprintf(fp, "_1024\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2048:
            fprintf(fp, "_2048\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4096:
            fprintf(fp, "_4096\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__8192:
            fprintf(fp, "_8192\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16384:
            fprintf(fp, "_16384\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32768:
            fprintf(fp, "_32768\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__65536:
            fprintf(fp, "_65536\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__131072:
            fprintf(fp, "_131072\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__262144:
            fprintf(fp, "_262144\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__524288:
            fprintf(fp, "_524288\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1048576:
            fprintf(fp, "_1048576\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2097152:
            fprintf(fp, "_2097152\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4194304:
            fprintf(fp, "_4194304\n");
            break;
        case NVA297_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_LATEZ_ALWAYS:
            fprintf(fp, "LATEZ_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_RASTER_PIPE_SYNC_CONTROL:
    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.PRIM_AREA_THRESHOLD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_RASTER_PIPE_SYNC_CONTROL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_RASTER_PIPE_SYNC_CONTROL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ALIASED_LINE_WIDTH_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_ALIASED_LINE_WIDTH_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ALIASED_LINE_WIDTH_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_API_MANDATED_EARLY_Z:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_API_MANDATED_EARLY_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_API_MANDATED_EARLY_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_GS_DM_FIFO:
    
        parsed = (data >> 0) & ((1u << 13) - 1);
        fprintf(fp, "%s.SIZE_RASTER_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 13) - 1);
        fprintf(fp, "%s.SIZE_RASTER_OFF = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.SPILL_ENABLED = ", prefix);
        switch (parsed) {
        case NVA297_SET_GS_DM_FIFO_SPILL_ENABLED_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_GS_DM_FIFO_SPILL_ENABLED_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_INVALIDATE_SHADER_CACHES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.DATA = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SHADER_CACHES_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_SHADER_CACHES_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.LOCKS = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SHADER_CACHES_LOCKS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_SHADER_CACHES_LOCKS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DATA = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                            case NVA297_SET_GLOBAL_LOAD_VIA_TEXTURE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_GLOBAL_LOAD_VIA_TEXTURE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_GLOBAL_LOAD_VIA_TEXTURE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 20) - 1);
        fprintf(fp, "%s.HEADER_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_INCREMENT_SYNC_POINT:
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLEAN_L2 = ", prefix);
        switch (parsed) {
        case NVA297_INCREMENT_SYNC_POINT_CLEAN_L2_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INCREMENT_SYNC_POINT_CLEAN_L2_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONDITION = ", prefix);
        switch (parsed) {
        case NVA297_INCREMENT_SYNC_POINT_CONDITION_STREAM_OUT_WRITES_DONE:
            fprintf(fp, "STREAM_OUT_WRITES_DONE\n");
            break;
        case NVA297_INCREMENT_SYNC_POINT_CONDITION_ROP_WRITES_DONE:
            fprintf(fp, "ROP_WRITES_DONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TASK_CIRCULAR_BUFFER_THROTTLE:
    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.TASK_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PRIM_CIRCULAR_BUFFER_THROTTLE:
    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.PRIM_AREA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVA297_SET_SURFACE_CLIP_ID_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ALPHA_CIRCULAR_BUFFER_SIZE:
    
        parsed = (data >> 0) & ((1u << 10) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_DECOMPRESS_SURFACE:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MRT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 16) - 1);
        fprintf(fp, "%s.RT_ARRAY_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_ROP_BYPASS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_ROP_BYPASS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_ROP_BYPASS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_STALL = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_ROP_BYPASS_NO_STALL_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_ROP_BYPASS_NO_STALL_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.CULL_EVERYTHING = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.THRESHOLD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_SUBREGION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_SUBREGION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 24) - 1);
        fprintf(fp, "%s.NORMALIZED_ALIQUOTS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_RASTER_BOUNDING_BOX:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_RASTER_BOUNDING_BOX_MODE_BOUNDING_BOX:
            fprintf(fp, "BOUNDING_BOX\n");
            break;
        case NVA297_SET_RASTER_BOUNDING_BOX_MODE_FULL_VIEWPORT:
            fprintf(fp, "FULL_VIEWPORT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.PAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_PEER_SEMAPHORE_RELEASE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ITERATED_BLEND_OPTIMIZATION:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.NOOP = ", prefix);
        switch (parsed) {
        case NVA297_SET_ITERATED_BLEND_OPTIMIZATION_NOOP_NEVER:
            fprintf(fp, "NEVER\n");
            break;
        case NVA297_SET_ITERATED_BLEND_OPTIMIZATION_NOOP_SOURCE_RGBA_0000:
            fprintf(fp, "SOURCE_RGBA_0000\n");
            break;
        case NVA297_SET_ITERATED_BLEND_OPTIMIZATION_NOOP_SOURCE_ALPHA_0:
            fprintf(fp, "SOURCE_ALPHA_0\n");
            break;
        case NVA297_SET_ITERATED_BLEND_OPTIMIZATION_NOOP_SOURCE_RGBA_0001:
            fprintf(fp, "SOURCE_RGBA_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZCULL_SUBREGION_ALLOCATION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SUBREGION_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.ALIQUOTS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 4) - 1);
        fprintf(fp, "%s.FORMAT = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16X2_4X4:
            fprintf(fp, "Z_16X16X2_4X4\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X16_4X4:
            fprintf(fp, "ZS_16X16_4X4\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X2:
            fprintf(fp, "Z_16X16_4X2\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_2X4:
            fprintf(fp, "Z_16X16_2X4\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X8_4X4:
            fprintf(fp, "Z_16X8_4X4\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_4X2:
            fprintf(fp, "Z_8X8_4X2\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_2X4:
            fprintf(fp, "Z_8X8_2X4\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X8:
            fprintf(fp, "Z_16X16_4X8\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_2X2:
            fprintf(fp, "Z_4X8_2X2\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_4X2:
            fprintf(fp, "ZS_16X8_4X2\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_2X4:
            fprintf(fp, "ZS_16X8_2X4\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_8X8_2X2:
            fprintf(fp, "ZS_8X8_2X2\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_1X1:
            fprintf(fp, "Z_4X8_1X1\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_NONE:
            fprintf(fp, "NONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_ASSIGN_ZCULL_SUBREGIONS:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.ALGORITHM = ", prefix);
        switch (parsed) {
        case NVA297_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Static:
            fprintf(fp, "Static\n");
            break;
        case NVA297_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Adaptive:
            fprintf(fp, "Adaptive\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_PS_OUTPUT_SAMPLE_MASK_USAGE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.QUALIFY_BY_ANTI_ALIAS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVA297_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_ZERO_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_L1_CONFIGURATION:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.DIRECTLY_ADDRESSABLE_MEMORY = ", prefix);
        switch (parsed) {
        case NVA297_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB:
            fprintf(fp, "SIZE_16KB\n");
            break;
        case NVA297_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB:
            fprintf(fp, "SIZE_48KB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_RENDER_ENABLE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONDITIONAL_LOAD_CONSTANT_BUFFER = ", prefix);
        switch (parsed) {
        case NVA297_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SPA_VERSION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MINOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAJOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_IEEE_CLEAN_UPDATE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_IEEE_CLEAN_UPDATE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_IEEE_CLEAN_UPDATE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SNAP_GRID_LINE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.LOCATIONS_PER_PIXEL = ", prefix);
        switch (parsed) {
        case NVA297_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__2X2:
            fprintf(fp, "_2X2\n");
            break;
        case NVA297_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__4X4:
            fprintf(fp, "_4X4\n");
            break;
        case NVA297_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__8X8:
            fprintf(fp, "_8X8\n");
            break;
        case NVA297_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__16X16:
            fprintf(fp, "_16X16\n");
            break;
        case NVA297_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__32X32:
            fprintf(fp, "_32X32\n");
            break;
        case NVA297_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__64X64:
            fprintf(fp, "_64X64\n");
            break;
        case NVA297_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__128X128:
            fprintf(fp, "_128X128\n");
            break;
        case NVA297_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__256X256:
            fprintf(fp, "_256X256\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.ROUNDING_MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SNAP_GRID_LINE_ROUNDING_MODE_RTNE:
            fprintf(fp, "RTNE\n");
            break;
        case NVA297_SET_SNAP_GRID_LINE_ROUNDING_MODE_TESLA:
            fprintf(fp, "TESLA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SNAP_GRID_NON_LINE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.LOCATIONS_PER_PIXEL = ", prefix);
        switch (parsed) {
        case NVA297_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__2X2:
            fprintf(fp, "_2X2\n");
            break;
        case NVA297_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__4X4:
            fprintf(fp, "_4X4\n");
            break;
        case NVA297_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__8X8:
            fprintf(fp, "_8X8\n");
            break;
        case NVA297_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__16X16:
            fprintf(fp, "_16X16\n");
            break;
        case NVA297_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__32X32:
            fprintf(fp, "_32X32\n");
            break;
        case NVA297_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__64X64:
            fprintf(fp, "_64X64\n");
            break;
        case NVA297_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__128X128:
            fprintf(fp, "_128X128\n");
            break;
        case NVA297_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__256X256:
            fprintf(fp, "_256X256\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.ROUNDING_MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_RTNE:
            fprintf(fp, "RTNE\n");
            break;
        case NVA297_SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_TESLA:
            fprintf(fp, "TESLA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TESSELLATION_PARAMETERS:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.DOMAIN_TYPE = ", prefix);
        switch (parsed) {
        case NVA297_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_ISOLINE:
            fprintf(fp, "ISOLINE\n");
            break;
        case NVA297_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_TRIANGLE:
            fprintf(fp, "TRIANGLE\n");
            break;
        case NVA297_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_QUAD:
            fprintf(fp, "QUAD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPACING = ", prefix);
        switch (parsed) {
        case NVA297_SET_TESSELLATION_PARAMETERS_SPACING_INTEGER:
            fprintf(fp, "INTEGER\n");
            break;
        case NVA297_SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_ODD:
            fprintf(fp, "FRACTIONAL_ODD\n");
            break;
        case NVA297_SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_EVEN:
            fprintf(fp, "FRACTIONAL_EVEN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.OUTPUT_PRIMITIVES = ", prefix);
        switch (parsed) {
        case NVA297_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CW:
            fprintf(fp, "TRIANGLES_CW\n");
            break;
        case NVA297_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CCW:
            fprintf(fp, "TRIANGLES_CCW\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TESSELLATION_LOD_U0_OR_DENSITY:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TESSELLATION_LOD_V0_OR_DETAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TESSELLATION_LOD_U1_OR_W0:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TESSELLATION_LOD_V1:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TG_LOD_INTERIOR_U:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TG_LOD_INTERIOR_V:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG07:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG08:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG09:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG10:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG11:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG12:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG13:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG14:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_RESERVED_TG15:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SUBTILING_PERF_KNOB_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_SPM_REGISTER_FILE_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_SPM_PIXEL_OUTPUT_BUFFER_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_SPM_TRIANGLE_RAM_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_MAX_QUADS_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SUBTILING_PERF_KNOB_B:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_MAX_PRIMITIVES_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SUBTILING_PERF_KNOB_C:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.RESERVED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_SUBREGION_TO_REPORT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.SUBREGION_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST:
            fprintf(fp, "DEPTH_TEST\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_NO_ACCEPT:
            fprintf(fp, "DEPTH_TEST_NO_ACCEPT\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_LATE_Z:
            fprintf(fp, "DEPTH_TEST_LATE_Z\n");
            break;
        case NVA297_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_STENCIL_TEST:
            fprintf(fp, "STENCIL_TEST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BALANCED_PRIMITIVE_WORKLOAD:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IN_UNPARTITIONED_MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.IN_TIMESLICED_MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_MAX_PATCHES_PER_BATCH:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_RASTER_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_RASTER_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_RASTER_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STREAM_OUT_BUFFER_ENABLE(0):
    case NVA297_SET_STREAM_OUT_BUFFER_ENABLE(1):
    case NVA297_SET_STREAM_OUT_BUFFER_ENABLE(2):
    case NVA297_SET_STREAM_OUT_BUFFER_ENABLE(3):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_STREAM_OUT_BUFFER_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STREAM_OUT_BUFFER_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(0):
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(1):
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(2):
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_A(3):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(0):
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(1):
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(2):
    case NVA297_SET_STREAM_OUT_BUFFER_ADDRESS_B(3):
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_STREAM_OUT_BUFFER_SIZE(0):
    case NVA297_SET_STREAM_OUT_BUFFER_SIZE(1):
    case NVA297_SET_STREAM_OUT_BUFFER_SIZE(2):
    case NVA297_SET_STREAM_OUT_BUFFER_SIZE(3):
    
        parsed = data;
        fprintf(fp, "%s.BYTES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(0):
    case NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(1):
    case NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(2):
    case NVA297_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(3):
    
        parsed = data;
        fprintf(fp, "%s.START_OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
        case NVA297_SET_STREAM_OUT_CONTROL_STREAM(0):
    case NVA297_SET_STREAM_OUT_CONTROL_STREAM(1):
    case NVA297_SET_STREAM_OUT_CONTROL_STREAM(2):
    case NVA297_SET_STREAM_OUT_CONTROL_STREAM(3):
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(0):
    case NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(1):
    case NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(2):
    case NVA297_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(3):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_STREAM_OUT_CONTROL_STRIDE(0):
    case NVA297_SET_STREAM_OUT_CONTROL_STRIDE(1):
    case NVA297_SET_STREAM_OUT_CONTROL_STRIDE(2):
    case NVA297_SET_STREAM_OUT_CONTROL_STRIDE(3):
    
        parsed = data;
        fprintf(fp, "%s.BYTES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_RASTER_INPUT:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.STREAM_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_STREAM_OUTPUT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STREAM_OUTPUT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STREAM_OUTPUT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ALPHA_FRACTION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_HYBRID_ANTI_ALIAS_CONTROL:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.PASSES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.CENTROID = ", prefix);
        switch (parsed) {
        case NVA297_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_FRAGMENT:
            fprintf(fp, "PER_FRAGMENT\n");
            break;
        case NVA297_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_PASS:
            fprintf(fp, "PER_PASS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_MAX_TI_WARPS_PER_BATCH:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_LOCAL_MEMORY_WINDOW:
    
        parsed = data;
        fprintf(fp, "%s.BASE_ADDRESS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_LOCAL_MEMORY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_LOCAL_MEMORY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_LOCAL_MEMORY_C:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.SIZE_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_LOCAL_MEMORY_D:
    
        parsed = data;
        fprintf(fp, "%s.SIZE_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_LOCAL_MEMORY_E:
    
        parsed = (data >> 0) & ((1u << 26) - 1);
        fprintf(fp, "%s.DEFAULT_SIZE_PER_WARP = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_ZERO_BANDWIDTH_CLEAR:
    
        parsed = (data >> 0) & ((1u << 15) - 1);
        fprintf(fp, "%s.SLOT_DISABLE_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_Z_ZERO_BANDWIDTH_CLEAR:
    
        parsed = (data >> 0) & ((1u << 15) - 1);
        fprintf(fp, "%s.SLOT_DISABLE_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ISBE_SAVE_RESTORE_PROGRAM:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
        case NVA297_SET_ZCULL_REGION_SIZE_A:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_REGION_SIZE_B:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_REGION_SIZE_C:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_C:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CULL_BEFORE_FETCH:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.FETCH_STREAMS_ONCE = ", prefix);
        switch (parsed) {
        case NVA297_SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZCULL_REGION_LOCATION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.START_ALIQUOT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.ALIQUOT_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_REGION_ALIQUOTS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.PER_LAYER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_STORAGE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_STORAGE_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_STORAGE_C:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.LIMIT_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_STORAGE_D:
    
        parsed = data;
        fprintf(fp, "%s.LIMIT_ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZT_READ_ONLY:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE_Z = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZT_READ_ONLY_ENABLE_Z_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZT_READ_ONLY_ENABLE_Z_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE_STENCIL = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZT_READ_ONLY_ENABLE_STENCIL_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZT_READ_ONLY_ENABLE_STENCIL_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TEXTURE_INSTRUCTION_OPERAND:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ORDERING = ", prefix);
        switch (parsed) {
        case NVA297_SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING_FERMI_ORDER:
            fprintf(fp, "FERMI_ORDER\n");
            break;
        case NVA297_SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING_KEPLER_ORDER:
            fprintf(fp, "KEPLER_ORDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_COLOR_TARGET_A(0):
    case NVA297_SET_COLOR_TARGET_A(1):
    case NVA297_SET_COLOR_TARGET_A(2):
    case NVA297_SET_COLOR_TARGET_A(3):
    case NVA297_SET_COLOR_TARGET_A(4):
    case NVA297_SET_COLOR_TARGET_A(5):
    case NVA297_SET_COLOR_TARGET_A(6):
    case NVA297_SET_COLOR_TARGET_A(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_TARGET_B(0):
    case NVA297_SET_COLOR_TARGET_B(1):
    case NVA297_SET_COLOR_TARGET_B(2):
    case NVA297_SET_COLOR_TARGET_B(3):
    case NVA297_SET_COLOR_TARGET_B(4):
    case NVA297_SET_COLOR_TARGET_B(5):
    case NVA297_SET_COLOR_TARGET_B(6):
    case NVA297_SET_COLOR_TARGET_B(7):
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_TARGET_WIDTH(0):
    case NVA297_SET_COLOR_TARGET_WIDTH(1):
    case NVA297_SET_COLOR_TARGET_WIDTH(2):
    case NVA297_SET_COLOR_TARGET_WIDTH(3):
    case NVA297_SET_COLOR_TARGET_WIDTH(4):
    case NVA297_SET_COLOR_TARGET_WIDTH(5):
    case NVA297_SET_COLOR_TARGET_WIDTH(6):
    case NVA297_SET_COLOR_TARGET_WIDTH(7):
    
        parsed = (data >> 0) & ((1u << 28) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_TARGET_HEIGHT(0):
    case NVA297_SET_COLOR_TARGET_HEIGHT(1):
    case NVA297_SET_COLOR_TARGET_HEIGHT(2):
    case NVA297_SET_COLOR_TARGET_HEIGHT(3):
    case NVA297_SET_COLOR_TARGET_HEIGHT(4):
    case NVA297_SET_COLOR_TARGET_HEIGHT(5):
    case NVA297_SET_COLOR_TARGET_HEIGHT(6):
    case NVA297_SET_COLOR_TARGET_HEIGHT(7):
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_TARGET_FORMAT(0):
    case NVA297_SET_COLOR_TARGET_FORMAT(1):
    case NVA297_SET_COLOR_TARGET_FORMAT(2):
    case NVA297_SET_COLOR_TARGET_FORMAT(3):
    case NVA297_SET_COLOR_TARGET_FORMAT(4):
    case NVA297_SET_COLOR_TARGET_FORMAT(5):
    case NVA297_SET_COLOR_TARGET_FORMAT(6):
    case NVA297_SET_COLOR_TARGET_FORMAT(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_TARGET_FORMAT_V_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_AF32:
            fprintf(fp, "RF32_GF32_BF32_AF32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_AS32:
            fprintf(fp, "RS32_GS32_BS32_AS32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_AU32:
            fprintf(fp, "RU32_GU32_BU32_AU32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_X32:
            fprintf(fp, "RF32_GF32_BF32_X32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_X32:
            fprintf(fp, "RS32_GS32_BS32_X32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_X32:
            fprintf(fp, "RU32_GU32_BU32_X32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_R16_G16_B16_A16:
            fprintf(fp, "R16_G16_B16_A16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RN16_GN16_BN16_AN16:
            fprintf(fp, "RN16_GN16_BN16_AN16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RS16_GS16_BS16_AS16:
            fprintf(fp, "RS16_GS16_BS16_AS16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RU16_GU16_BU16_AU16:
            fprintf(fp, "RU16_GU16_BU16_AU16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_AF16:
            fprintf(fp, "RF16_GF16_BF16_AF16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF32_GF32:
            fprintf(fp, "RF32_GF32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RS32_GS32:
            fprintf(fp, "RS32_GS32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RU32_GU32:
            fprintf(fp, "RU32_GU32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_X16:
            fprintf(fp, "RF16_GF16_BF16_X16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A8R8G8B8:
            fprintf(fp, "A8R8G8B8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A8RL8GL8BL8:
            fprintf(fp, "A8RL8GL8BL8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A2B10G10R10:
            fprintf(fp, "A2B10G10R10\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_AU2BU10GU10RU10:
            fprintf(fp, "AU2BU10GU10RU10\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A8B8G8R8:
            fprintf(fp, "A8B8G8R8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A8BL8GL8RL8:
            fprintf(fp, "A8BL8GL8RL8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_AN8BN8GN8RN8:
            fprintf(fp, "AN8BN8GN8RN8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_AS8BS8GS8RS8:
            fprintf(fp, "AS8BS8GS8RS8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_AU8BU8GU8RU8:
            fprintf(fp, "AU8BU8GU8RU8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_R16_G16:
            fprintf(fp, "R16_G16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RN16_GN16:
            fprintf(fp, "RN16_GN16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RS16_GS16:
            fprintf(fp, "RS16_GS16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RU16_GU16:
            fprintf(fp, "RU16_GU16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF16_GF16:
            fprintf(fp, "RF16_GF16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A2R10G10B10:
            fprintf(fp, "A2R10G10B10\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_BF10GF11RF11:
            fprintf(fp, "BF10GF11RF11\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RS32:
            fprintf(fp, "RS32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RU32:
            fprintf(fp, "RU32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF32:
            fprintf(fp, "RF32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_X8R8G8B8:
            fprintf(fp, "X8R8G8B8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_X8RL8GL8BL8:
            fprintf(fp, "X8RL8GL8BL8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_R5G6B5:
            fprintf(fp, "R5G6B5\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A1R5G5B5:
            fprintf(fp, "A1R5G5B5\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_G8R8:
            fprintf(fp, "G8R8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_GN8RN8:
            fprintf(fp, "GN8RN8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_GS8RS8:
            fprintf(fp, "GS8RS8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_GU8RU8:
            fprintf(fp, "GU8RU8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_R16:
            fprintf(fp, "R16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RN16:
            fprintf(fp, "RN16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RS16:
            fprintf(fp, "RS16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RU16:
            fprintf(fp, "RU16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF16:
            fprintf(fp, "RF16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_R8:
            fprintf(fp, "R8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RN8:
            fprintf(fp, "RN8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RS8:
            fprintf(fp, "RS8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RU8:
            fprintf(fp, "RU8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A8:
            fprintf(fp, "A8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_X1R5G5B5:
            fprintf(fp, "X1R5G5B5\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_X8B8G8R8:
            fprintf(fp, "X8B8G8R8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_X8BL8GL8RL8:
            fprintf(fp, "X8BL8GL8RL8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_Z1R5G5B5:
            fprintf(fp, "Z1R5G5B5\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_O1R5G5B5:
            fprintf(fp, "O1R5G5B5\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_Z8R8G8B8:
            fprintf(fp, "Z8R8G8B8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_O8R8G8B8:
            fprintf(fp, "O8R8G8B8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_R32:
            fprintf(fp, "R32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A16:
            fprintf(fp, "A16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_AF16:
            fprintf(fp, "AF16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_AF32:
            fprintf(fp, "AF32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_A8R8:
            fprintf(fp, "A8R8\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_R16_A16:
            fprintf(fp, "R16_A16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF16_AF16:
            fprintf(fp, "RF16_AF16\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_RF32_AF32:
            fprintf(fp, "RF32_AF32\n");
            break;
        case NVA297_SET_COLOR_TARGET_FORMAT_V_B8G8R8A8:
            fprintf(fp, "B8G8R8A8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_COLOR_TARGET_MEMORY(0):
    case NVA297_SET_COLOR_TARGET_MEMORY(1):
    case NVA297_SET_COLOR_TARGET_MEMORY(2):
    case NVA297_SET_COLOR_TARGET_MEMORY(3):
    case NVA297_SET_COLOR_TARGET_MEMORY(4):
    case NVA297_SET_COLOR_TARGET_MEMORY(5):
    case NVA297_SET_COLOR_TARGET_MEMORY(6):
    case NVA297_SET_COLOR_TARGET_MEMORY(7):
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.BLOCK_WIDTH = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.BLOCK_HEIGHT = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.BLOCK_DEPTH = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.LAYOUT = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_TARGET_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.THIRD_DIMENSION_CONTROL = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE:
            fprintf(fp, "THIRD_DIMENSION_DEFINES_ARRAY_SIZE\n");
            break;
        case NVA297_SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_DEPTH_SIZE:
            fprintf(fp, "THIRD_DIMENSION_DEFINES_DEPTH_SIZE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(0):
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(1):
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(2):
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(3):
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(4):
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(5):
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(6):
    case NVA297_SET_COLOR_TARGET_THIRD_DIMENSION(7):
    
        parsed = (data >> 0) & ((1u << 28) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(0):
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(1):
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(2):
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(3):
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(4):
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(5):
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(6):
    case NVA297_SET_COLOR_TARGET_ARRAY_PITCH(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_TARGET_LAYER(0):
    case NVA297_SET_COLOR_TARGET_LAYER(1):
    case NVA297_SET_COLOR_TARGET_LAYER(2):
    case NVA297_SET_COLOR_TARGET_LAYER(3):
    case NVA297_SET_COLOR_TARGET_LAYER(4):
    case NVA297_SET_COLOR_TARGET_LAYER(5):
    case NVA297_SET_COLOR_TARGET_LAYER(6):
    case NVA297_SET_COLOR_TARGET_LAYER(7):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_TARGET_MARK(0):
    case NVA297_SET_COLOR_TARGET_MARK(1):
    case NVA297_SET_COLOR_TARGET_MARK(2):
    case NVA297_SET_COLOR_TARGET_MARK(3):
    case NVA297_SET_COLOR_TARGET_MARK(4):
    case NVA297_SET_COLOR_TARGET_MARK(5):
    case NVA297_SET_COLOR_TARGET_MARK(6):
    case NVA297_SET_COLOR_TARGET_MARK(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IEEE_CLEAN = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_TARGET_MARK_IEEE_CLEAN_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_COLOR_TARGET_MARK_IEEE_CLEAN_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VIEWPORT_SCALE_X(0):
    case NVA297_SET_VIEWPORT_SCALE_X(1):
    case NVA297_SET_VIEWPORT_SCALE_X(2):
    case NVA297_SET_VIEWPORT_SCALE_X(3):
    case NVA297_SET_VIEWPORT_SCALE_X(4):
    case NVA297_SET_VIEWPORT_SCALE_X(5):
    case NVA297_SET_VIEWPORT_SCALE_X(6):
    case NVA297_SET_VIEWPORT_SCALE_X(7):
    case NVA297_SET_VIEWPORT_SCALE_X(8):
    case NVA297_SET_VIEWPORT_SCALE_X(9):
    case NVA297_SET_VIEWPORT_SCALE_X(10):
    case NVA297_SET_VIEWPORT_SCALE_X(11):
    case NVA297_SET_VIEWPORT_SCALE_X(12):
    case NVA297_SET_VIEWPORT_SCALE_X(13):
    case NVA297_SET_VIEWPORT_SCALE_X(14):
    case NVA297_SET_VIEWPORT_SCALE_X(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_VIEWPORT_SCALE_Y(0):
    case NVA297_SET_VIEWPORT_SCALE_Y(1):
    case NVA297_SET_VIEWPORT_SCALE_Y(2):
    case NVA297_SET_VIEWPORT_SCALE_Y(3):
    case NVA297_SET_VIEWPORT_SCALE_Y(4):
    case NVA297_SET_VIEWPORT_SCALE_Y(5):
    case NVA297_SET_VIEWPORT_SCALE_Y(6):
    case NVA297_SET_VIEWPORT_SCALE_Y(7):
    case NVA297_SET_VIEWPORT_SCALE_Y(8):
    case NVA297_SET_VIEWPORT_SCALE_Y(9):
    case NVA297_SET_VIEWPORT_SCALE_Y(10):
    case NVA297_SET_VIEWPORT_SCALE_Y(11):
    case NVA297_SET_VIEWPORT_SCALE_Y(12):
    case NVA297_SET_VIEWPORT_SCALE_Y(13):
    case NVA297_SET_VIEWPORT_SCALE_Y(14):
    case NVA297_SET_VIEWPORT_SCALE_Y(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_VIEWPORT_SCALE_Z(0):
    case NVA297_SET_VIEWPORT_SCALE_Z(1):
    case NVA297_SET_VIEWPORT_SCALE_Z(2):
    case NVA297_SET_VIEWPORT_SCALE_Z(3):
    case NVA297_SET_VIEWPORT_SCALE_Z(4):
    case NVA297_SET_VIEWPORT_SCALE_Z(5):
    case NVA297_SET_VIEWPORT_SCALE_Z(6):
    case NVA297_SET_VIEWPORT_SCALE_Z(7):
    case NVA297_SET_VIEWPORT_SCALE_Z(8):
    case NVA297_SET_VIEWPORT_SCALE_Z(9):
    case NVA297_SET_VIEWPORT_SCALE_Z(10):
    case NVA297_SET_VIEWPORT_SCALE_Z(11):
    case NVA297_SET_VIEWPORT_SCALE_Z(12):
    case NVA297_SET_VIEWPORT_SCALE_Z(13):
    case NVA297_SET_VIEWPORT_SCALE_Z(14):
    case NVA297_SET_VIEWPORT_SCALE_Z(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_VIEWPORT_OFFSET_X(0):
    case NVA297_SET_VIEWPORT_OFFSET_X(1):
    case NVA297_SET_VIEWPORT_OFFSET_X(2):
    case NVA297_SET_VIEWPORT_OFFSET_X(3):
    case NVA297_SET_VIEWPORT_OFFSET_X(4):
    case NVA297_SET_VIEWPORT_OFFSET_X(5):
    case NVA297_SET_VIEWPORT_OFFSET_X(6):
    case NVA297_SET_VIEWPORT_OFFSET_X(7):
    case NVA297_SET_VIEWPORT_OFFSET_X(8):
    case NVA297_SET_VIEWPORT_OFFSET_X(9):
    case NVA297_SET_VIEWPORT_OFFSET_X(10):
    case NVA297_SET_VIEWPORT_OFFSET_X(11):
    case NVA297_SET_VIEWPORT_OFFSET_X(12):
    case NVA297_SET_VIEWPORT_OFFSET_X(13):
    case NVA297_SET_VIEWPORT_OFFSET_X(14):
    case NVA297_SET_VIEWPORT_OFFSET_X(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_VIEWPORT_OFFSET_Y(0):
    case NVA297_SET_VIEWPORT_OFFSET_Y(1):
    case NVA297_SET_VIEWPORT_OFFSET_Y(2):
    case NVA297_SET_VIEWPORT_OFFSET_Y(3):
    case NVA297_SET_VIEWPORT_OFFSET_Y(4):
    case NVA297_SET_VIEWPORT_OFFSET_Y(5):
    case NVA297_SET_VIEWPORT_OFFSET_Y(6):
    case NVA297_SET_VIEWPORT_OFFSET_Y(7):
    case NVA297_SET_VIEWPORT_OFFSET_Y(8):
    case NVA297_SET_VIEWPORT_OFFSET_Y(9):
    case NVA297_SET_VIEWPORT_OFFSET_Y(10):
    case NVA297_SET_VIEWPORT_OFFSET_Y(11):
    case NVA297_SET_VIEWPORT_OFFSET_Y(12):
    case NVA297_SET_VIEWPORT_OFFSET_Y(13):
    case NVA297_SET_VIEWPORT_OFFSET_Y(14):
    case NVA297_SET_VIEWPORT_OFFSET_Y(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_VIEWPORT_OFFSET_Z(0):
    case NVA297_SET_VIEWPORT_OFFSET_Z(1):
    case NVA297_SET_VIEWPORT_OFFSET_Z(2):
    case NVA297_SET_VIEWPORT_OFFSET_Z(3):
    case NVA297_SET_VIEWPORT_OFFSET_Z(4):
    case NVA297_SET_VIEWPORT_OFFSET_Z(5):
    case NVA297_SET_VIEWPORT_OFFSET_Z(6):
    case NVA297_SET_VIEWPORT_OFFSET_Z(7):
    case NVA297_SET_VIEWPORT_OFFSET_Z(8):
    case NVA297_SET_VIEWPORT_OFFSET_Z(9):
    case NVA297_SET_VIEWPORT_OFFSET_Z(10):
    case NVA297_SET_VIEWPORT_OFFSET_Z(11):
    case NVA297_SET_VIEWPORT_OFFSET_Z(12):
    case NVA297_SET_VIEWPORT_OFFSET_Z(13):
    case NVA297_SET_VIEWPORT_OFFSET_Z(14):
    case NVA297_SET_VIEWPORT_OFFSET_Z(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(0):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(1):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(2):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(3):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(4):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(5):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(6):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(7):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(8):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(9):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(10):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(11):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(12):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(13):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(14):
    case NVA297_SET_VIEWPORT_CLIP_HORIZONTAL(15):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.X0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(0):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(1):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(2):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(3):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(4):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(5):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(6):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(7):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(8):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(9):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(10):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(11):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(12):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(13):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(14):
    case NVA297_SET_VIEWPORT_CLIP_VERTICAL(15):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.Y0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(0):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(1):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(2):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(3):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(4):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(5):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(6):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(7):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(8):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(9):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(10):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(11):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(12):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(13):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(14):
    case NVA297_SET_VIEWPORT_CLIP_MIN_Z(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(0):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(1):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(2):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(3):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(4):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(5):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(6):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(7):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(8):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(9):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(10):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(11):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(12):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(13):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(14):
    case NVA297_SET_VIEWPORT_CLIP_MAX_Z(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(0):
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(1):
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(2):
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(3):
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(4):
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(5):
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(6):
    case NVA297_SET_WINDOW_CLIP_HORIZONTAL(7):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_WINDOW_CLIP_VERTICAL(0):
    case NVA297_SET_WINDOW_CLIP_VERTICAL(1):
    case NVA297_SET_WINDOW_CLIP_VERTICAL(2):
    case NVA297_SET_WINDOW_CLIP_VERTICAL(3):
    case NVA297_SET_WINDOW_CLIP_VERTICAL(4):
    case NVA297_SET_WINDOW_CLIP_VERTICAL(5):
    case NVA297_SET_WINDOW_CLIP_VERTICAL(6):
    case NVA297_SET_WINDOW_CLIP_VERTICAL(7):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CLIP_ID_EXTENT_X(0):
    case NVA297_SET_CLIP_ID_EXTENT_X(1):
    case NVA297_SET_CLIP_ID_EXTENT_X(2):
    case NVA297_SET_CLIP_ID_EXTENT_X(3):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.MINX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CLIP_ID_EXTENT_Y(0):
    case NVA297_SET_CLIP_ID_EXTENT_Y(1):
    case NVA297_SET_CLIP_ID_EXTENT_Y(2):
    case NVA297_SET_CLIP_ID_EXTENT_Y(3):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.MINY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK:
    
        parsed = (data >> 0) & ((1u << 11) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_API_VISIBLE_CALL_LIMIT:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__0:
            fprintf(fp, "_0\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__1:
            fprintf(fp, "_1\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__2:
            fprintf(fp, "_2\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__4:
            fprintf(fp, "_4\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__8:
            fprintf(fp, "_8\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__16:
            fprintf(fp, "_16\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__32:
            fprintf(fp, "_32\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__64:
            fprintf(fp, "_64\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V__128:
            fprintf(fp, "_128\n");
            break;
        case NVA297_SET_API_VISIBLE_CALL_LIMIT_V_NO_CHECK:
            fprintf(fp, "NO_CHECK\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STATISTICS_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DA_VERTICES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.DA_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.VS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.GS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GS_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.STREAMING_PRIMITIVES_SUCCEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.STREAMING_PRIMITIVES_NEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLIPPER_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLIPPER_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.PS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TI_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.TS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.TS_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 14) & ((1u << 1) - 1);
        fprintf(fp, "%s.TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.VTG_PRIMITIVES_OUT_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 15) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_BETA_CLOCKS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_CLEAR_RECT_HORIZONTAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CLEAR_RECT_VERTICAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_ARRAY_START:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_DRAW_VERTEX_ARRAY:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VIEWPORT_Z_CLIP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.RANGE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_Z_CLIP_RANGE_NEGATIVE_W_TO_POSITIVE_W:
            fprintf(fp, "NEGATIVE_W_TO_POSITIVE_W\n");
            break;
        case NVA297_SET_VIEWPORT_Z_CLIP_RANGE_ZERO_TO_POSITIVE_W:
            fprintf(fp, "ZERO_TO_POSITIVE_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_COLOR_CLEAR_VALUE(0):
    case NVA297_SET_COLOR_CLEAR_VALUE(1):
    case NVA297_SET_COLOR_CLEAR_VALUE(2):
    case NVA297_SET_COLOR_CLEAR_VALUE(3):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_Z_CLEAR_VALUE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_SHADER_CACHE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ICACHE_PREFETCH_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_FORCE_TRANSITION_TO_BETA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STENCIL_CLEAR_VALUE:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_INVALIDATE_SHADER_CACHES_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GLOBAL_DATA = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZCULL_SERIALIZATION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_SERIALIZATION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_SERIALIZATION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.APPLIED = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_SERIALIZATION_APPLIED_ALWAYS:
            fprintf(fp, "ALWAYS\n");
            break;
        case NVA297_SET_ZCULL_SERIALIZATION_APPLIED_LATE_Z:
            fprintf(fp, "LATE_Z\n");
            break;
        case NVA297_SET_ZCULL_SERIALIZATION_APPLIED_OUT_OF_GAMUT_Z:
            fprintf(fp, "OUT_OF_GAMUT_Z\n");
            break;
        case NVA297_SET_ZCULL_SERIALIZATION_APPLIED_LATE_Z_OR_OUT_OF_GAMUT_Z:
            fprintf(fp, "LATE_Z_OR_OUT_OF_GAMUT_Z\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_FRONT_POLYGON_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_FRONT_POLYGON_MODE_V_POINT:
            fprintf(fp, "POINT\n");
            break;
        case NVA297_SET_FRONT_POLYGON_MODE_V_LINE:
            fprintf(fp, "LINE\n");
            break;
        case NVA297_SET_FRONT_POLYGON_MODE_V_FILL:
            fprintf(fp, "FILL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BACK_POLYGON_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BACK_POLYGON_MODE_V_POINT:
            fprintf(fp, "POINT\n");
            break;
        case NVA297_SET_BACK_POLYGON_MODE_V_LINE:
            fprintf(fp, "LINE\n");
            break;
        case NVA297_SET_BACK_POLYGON_MODE_V_FILL:
            fprintf(fp, "FILL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_POLY_SMOOTH:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_POLY_SMOOTH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_POLY_SMOOTH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZT_MARK:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IEEE_CLEAN = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZT_MARK_IEEE_CLEAN_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZT_MARK_IEEE_CLEAN_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZCULL_DIR_FORMAT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.ZDIR = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_DIR_FORMAT_ZDIR_LESS:
            fprintf(fp, "LESS\n");
            break;
        case NVA297_SET_ZCULL_DIR_FORMAT_ZDIR_GREATER:
            fprintf(fp, "GREATER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.ZFORMAT = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_DIR_FORMAT_ZFORMAT_MSB:
            fprintf(fp, "MSB\n");
            break;
        case NVA297_SET_ZCULL_DIR_FORMAT_ZFORMAT_FP:
            fprintf(fp, "FP\n");
            break;
        case NVA297_SET_ZCULL_DIR_FORMAT_ZFORMAT_ZTRICK:
            fprintf(fp, "ZTRICK\n");
            break;
        case NVA297_SET_ZCULL_DIR_FORMAT_ZFORMAT_ZF32_1:
            fprintf(fp, "ZF32_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_POLY_OFFSET_POINT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_POLY_OFFSET_POINT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_POLY_OFFSET_POINT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_POLY_OFFSET_LINE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_POLY_OFFSET_LINE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_POLY_OFFSET_LINE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_POLY_OFFSET_FILL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_POLY_OFFSET_FILL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_POLY_OFFSET_FILL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_PATCH:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ITERATED_BLEND:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ITERATED_BLEND_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ITERATED_BLEND_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ITERATED_BLEND_ALPHA_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ITERATED_BLEND_ALPHA_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ITERATED_BLEND_PASS:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_CRITERION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SFUNC = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_CRITERION_SFUNC_NEVER:
            fprintf(fp, "NEVER\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_SFUNC_LESS:
            fprintf(fp, "LESS\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_SFUNC_EQUAL:
            fprintf(fp, "EQUAL\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_SFUNC_LEQUAL:
            fprintf(fp, "LEQUAL\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_SFUNC_GREATER:
            fprintf(fp, "GREATER\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_SFUNC_NOTEQUAL:
            fprintf(fp, "NOTEQUAL\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_SFUNC_GEQUAL:
            fprintf(fp, "GEQUAL\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_SFUNC_ALWAYS:
            fprintf(fp, "ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_INVALIDATE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_CRITERION_NO_INVALIDATE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_NO_INVALIDATE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.FORCE_MATCH = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_CRITERION_FORCE_MATCH_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_CRITERION_FORCE_MATCH_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.SREF = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.SMASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SM_QUADRANT_SELECTION_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAX_PIXEL_WARPS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SM_TIMEOUT_INTERVAL:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.COUNTER_BIT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DRAW_INLINE_VERTEX_VAB_UPDATE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_POINTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.TEST_CC = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_EQ:
            fprintf(fp, "EQ\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_NE:
            fprintf(fp, "NE\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_LT:
            fprintf(fp, "LT\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_LE:
            fprintf(fp, "LE\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_GT:
            fprintf(fp, "GT\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_GE:
            fprintf(fp, "GE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_ADD_PRODUCTS:
            fprintf(fp, "ADD_PRODUCTS\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_SUB_PRODUCTS:
            fprintf(fp, "SUB_PRODUCTS\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_MIN:
            fprintf(fp, "MIN\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_MAX:
            fprintf(fp, "MAX\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_RCP:
            fprintf(fp, "RCP\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_ADD:
            fprintf(fp, "ADD\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_SUBTRACT:
            fprintf(fp, "SUBTRACT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 3) - 1);
        fprintf(fp, "%s.CONSTANT_INPUT_SELECT = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT0:
            fprintf(fp, "CONSTANT0\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT1:
            fprintf(fp, "CONSTANT1\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT2:
            fprintf(fp, "CONSTANT2\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT3:
            fprintf(fp, "CONSTANT3\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT4:
            fprintf(fp, "CONSTANT4\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT5:
            fprintf(fp, "CONSTANT5\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT6:
            fprintf(fp, "CONSTANT6\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT7:
            fprintf(fp, "CONSTANT7\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERAND_A_SELECT = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_SRC_RGB:
            fprintf(fp, "SRC_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_DEST_RGB:
            fprintf(fp, "DEST_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_SRC_AAA:
            fprintf(fp, "SRC_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_DEST_AAA:
            fprintf(fp, "DEST_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_TEMP0_RGB:
            fprintf(fp, "TEMP0_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_TEMP1_RGB:
            fprintf(fp, "TEMP1_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_TEMP2_RGB:
            fprintf(fp, "TEMP2_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_PBR_RGB:
            fprintf(fp, "PBR_RGB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.OPERAND_B_SELECT = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_SRC_RGB:
            fprintf(fp, "SRC_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_SRC_AAA:
            fprintf(fp, "SRC_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ONE_MINUS_SRC_AAA:
            fprintf(fp, "ONE_MINUS_SRC_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_DEST_RGB:
            fprintf(fp, "DEST_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_DEST_AAA:
            fprintf(fp, "DEST_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ONE_MINUS_DEST_AAA:
            fprintf(fp, "ONE_MINUS_DEST_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_TEMP0_RGB:
            fprintf(fp, "TEMP0_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_TEMP1_RGB:
            fprintf(fp, "TEMP1_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_TEMP2_RGB:
            fprintf(fp, "TEMP2_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_PBR_RGB:
            fprintf(fp, "PBR_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_CONSTANT_RGB:
            fprintf(fp, "CONSTANT_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ZERO_A_TIMES_B:
            fprintf(fp, "ZERO_A_TIMES_B\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERAND_C_SELECT = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_SRC_RGB:
            fprintf(fp, "SRC_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_DEST_RGB:
            fprintf(fp, "DEST_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_SRC_AAA:
            fprintf(fp, "SRC_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_DEST_AAA:
            fprintf(fp, "DEST_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_TEMP0_RGB:
            fprintf(fp, "TEMP0_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_TEMP1_RGB:
            fprintf(fp, "TEMP1_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_TEMP2_RGB:
            fprintf(fp, "TEMP2_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_PBR_RGB:
            fprintf(fp, "PBR_RGB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 19) & ((1u << 4) - 1);
        fprintf(fp, "%s.OPERAND_D_SELECT = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_SRC_RGB:
            fprintf(fp, "SRC_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_SRC_AAA:
            fprintf(fp, "SRC_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ONE_MINUS_SRC_AAA:
            fprintf(fp, "ONE_MINUS_SRC_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_DEST_RGB:
            fprintf(fp, "DEST_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_DEST_AAA:
            fprintf(fp, "DEST_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ONE_MINUS_DEST_AAA:
            fprintf(fp, "ONE_MINUS_DEST_AAA\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_TEMP0_RGB:
            fprintf(fp, "TEMP0_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_TEMP1_RGB:
            fprintf(fp, "TEMP1_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_TEMP2_RGB:
            fprintf(fp, "TEMP2_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_PBR_RGB:
            fprintf(fp, "PBR_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_CONSTANT_RGB:
            fprintf(fp, "CONSTANT_RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ZERO_C_TIMES_D:
            fprintf(fp, "ZERO_C_TIMES_D\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 23) & ((1u << 3) - 1);
        fprintf(fp, "%s.OUTPUT_SWIZZLE = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_RGB:
            fprintf(fp, "RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_GBR:
            fprintf(fp, "GBR\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_RRR:
            fprintf(fp, "RRR\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_GGG:
            fprintf(fp, "GGG\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_BBB:
            fprintf(fp, "BBB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_R_TO_A:
            fprintf(fp, "R_TO_A\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 26) & ((1u << 2) - 1);
        fprintf(fp, "%s.OUTPUT_WRITE_MASK = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_WRITE_MASK_RGB:
            fprintf(fp, "RGB\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_WRITE_MASK_R_ONLY:
            fprintf(fp, "R_ONLY\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_WRITE_MASK_G_ONLY:
            fprintf(fp, "G_ONLY\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_WRITE_MASK_B_ONLY:
            fprintf(fp, "B_ONLY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 2) - 1);
        fprintf(fp, "%s.PASS_OUTPUT = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_PASS_OUTPUT_TEMP0:
            fprintf(fp, "TEMP0\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_PASS_OUTPUT_TEMP1:
            fprintf(fp, "TEMP1\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_PASS_OUTPUT_TEMP2:
            fprintf(fp, "TEMP2\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_PASS_OUTPUT_NONE:
            fprintf(fp, "NONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.SET_CC = ", prefix);
        switch (parsed) {
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_SET_CC_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_LOAD_ITERATED_BLEND_INSTRUCTION_SET_CC_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_WINDOW_OFFSET_X:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_WINDOW_OFFSET_Y:
    
        parsed = (data >> 0) & ((1u << 18) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SCISSOR_ENABLE(0):
    case NVA297_SET_SCISSOR_ENABLE(1):
    case NVA297_SET_SCISSOR_ENABLE(2):
    case NVA297_SET_SCISSOR_ENABLE(3):
    case NVA297_SET_SCISSOR_ENABLE(4):
    case NVA297_SET_SCISSOR_ENABLE(5):
    case NVA297_SET_SCISSOR_ENABLE(6):
    case NVA297_SET_SCISSOR_ENABLE(7):
    case NVA297_SET_SCISSOR_ENABLE(8):
    case NVA297_SET_SCISSOR_ENABLE(9):
    case NVA297_SET_SCISSOR_ENABLE(10):
    case NVA297_SET_SCISSOR_ENABLE(11):
    case NVA297_SET_SCISSOR_ENABLE(12):
    case NVA297_SET_SCISSOR_ENABLE(13):
    case NVA297_SET_SCISSOR_ENABLE(14):
    case NVA297_SET_SCISSOR_ENABLE(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_SCISSOR_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_SCISSOR_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SCISSOR_HORIZONTAL(0):
    case NVA297_SET_SCISSOR_HORIZONTAL(1):
    case NVA297_SET_SCISSOR_HORIZONTAL(2):
    case NVA297_SET_SCISSOR_HORIZONTAL(3):
    case NVA297_SET_SCISSOR_HORIZONTAL(4):
    case NVA297_SET_SCISSOR_HORIZONTAL(5):
    case NVA297_SET_SCISSOR_HORIZONTAL(6):
    case NVA297_SET_SCISSOR_HORIZONTAL(7):
    case NVA297_SET_SCISSOR_HORIZONTAL(8):
    case NVA297_SET_SCISSOR_HORIZONTAL(9):
    case NVA297_SET_SCISSOR_HORIZONTAL(10):
    case NVA297_SET_SCISSOR_HORIZONTAL(11):
    case NVA297_SET_SCISSOR_HORIZONTAL(12):
    case NVA297_SET_SCISSOR_HORIZONTAL(13):
    case NVA297_SET_SCISSOR_HORIZONTAL(14):
    case NVA297_SET_SCISSOR_HORIZONTAL(15):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SCISSOR_VERTICAL(0):
    case NVA297_SET_SCISSOR_VERTICAL(1):
    case NVA297_SET_SCISSOR_VERTICAL(2):
    case NVA297_SET_SCISSOR_VERTICAL(3):
    case NVA297_SET_SCISSOR_VERTICAL(4):
    case NVA297_SET_SCISSOR_VERTICAL(5):
    case NVA297_SET_SCISSOR_VERTICAL(6):
    case NVA297_SET_SCISSOR_VERTICAL(7):
    case NVA297_SET_SCISSOR_VERTICAL(8):
    case NVA297_SET_SCISSOR_VERTICAL(9):
    case NVA297_SET_SCISSOR_VERTICAL(10):
    case NVA297_SET_SCISSOR_VERTICAL(11):
    case NVA297_SET_SCISSOR_VERTICAL(12):
    case NVA297_SET_SCISSOR_VERTICAL(13):
    case NVA297_SET_SCISSOR_VERTICAL(14):
    case NVA297_SET_SCISSOR_VERTICAL(15):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
        case NVA297_SET_CONSTANT_COLOR_RENDERING:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_CONSTANT_COLOR_RENDERING_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CONSTANT_COLOR_RENDERING_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_CONSTANT_COLOR_RENDERING_RED:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CONSTANT_COLOR_RENDERING_GREEN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CONSTANT_COLOR_RENDERING_BLUE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CONSTANT_COLOR_RENDERING_ALPHA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_BACK_STENCIL_FUNC_REF:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_BACK_STENCIL_MASK:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_BACK_STENCIL_FUNC_MASK:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_SUBSTITUTE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_SUBSTITUTE_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_LINE_MODE_POLYGON_CLIP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.GENERATED_EDGE = ", prefix);
        switch (parsed) {
        case NVA297_SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DRAW_LINE:
            fprintf(fp, "DRAW_LINE\n");
            break;
        case NVA297_SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DO_NOT_DRAW_LINE:
            fprintf(fp, "DO_NOT_DRAW_LINE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SINGLE_CT_WRITE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SINGLE_CT_WRITE_CONTROL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_SINGLE_CT_WRITE_CONTROL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VTG_WARP_WATERMARKS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DEPTH_BOUNDS_MIN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_DEPTH_BOUNDS_MAX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_CT_MRT_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_CT_MRT_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CT_MRT_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_NONMULTISAMPLED_Z:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_NONMULTISAMPLED_Z_V_PER_SAMPLE:
            fprintf(fp, "PER_SAMPLE\n");
            break;
        case NVA297_SET_NONMULTISAMPLED_Z_V_AT_PIXEL_CENTER:
            fprintf(fp, "AT_PIXEL_CENTER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SAMPLE_MASK_X0_Y0:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SAMPLE_MASK_X1_Y0:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SAMPLE_MASK_X0_Y1:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SAMPLE_MASK_X1_Y1:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SURFACE_CLIP_ID_MEMORY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SURFACE_CLIP_ID_MEMORY_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_BLEND_OPT_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALLOW_FLOAT_PIXEL_KILLS = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZT_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZT_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZT_FORMAT:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZT_FORMAT_V_Z16:
            fprintf(fp, "Z16\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_Z24S8:
            fprintf(fp, "Z24S8\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_X8Z24:
            fprintf(fp, "X8Z24\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_S8Z24:
            fprintf(fp, "S8Z24\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_V8Z24:
            fprintf(fp, "V8Z24\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_ZF32:
            fprintf(fp, "ZF32\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_ZF32_X24S8:
            fprintf(fp, "ZF32_X24S8\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_X8Z24_X16V8S8:
            fprintf(fp, "X8Z24_X16V8S8\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_ZF32_X16V8X8:
            fprintf(fp, "ZF32_X16V8X8\n");
            break;
        case NVA297_SET_ZT_FORMAT_V_ZF32_X16V8S8:
            fprintf(fp, "ZF32_X16V8S8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZT_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZT_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZT_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVA297_SET_ZT_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVA297_SET_ZT_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVA297_SET_ZT_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVA297_SET_ZT_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVA297_SET_ZT_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZT_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZT_ARRAY_PITCH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SURFACE_CLIP_HORIZONTAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.X = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SURFACE_CLIP_VERTICAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.Y = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSTEM_MEMORY_VOLATILE = ", prefix);
        switch (parsed) {
        case NVA297_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVA297_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TESSELLATION_CUT_HEIGHT:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_MAX_GS_INSTANCES_PER_TASK:
    
        parsed = (data >> 0) & ((1u << 11) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER:
    
        parsed = (data >> 0) & ((1u << 10) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_BETA_CB_STORAGE_CONSTRAINT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER:
    
        parsed = (data >> 0) & ((1u << 10) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ALPHA_CB_STORAGE_CONSTRAINT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SPARE_NOOP01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE_NOOP15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM8:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM10:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_UNORM16:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_FP11:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 6) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_FP16:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REDUCE_COLOR_THRESHOLDS_SRGB8:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_UNBIND_ALL:
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT_BUFFERS = ", prefix);
        switch (parsed) {
        case NVA297_UNBIND_ALL_CONSTANT_BUFFERS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_UNBIND_ALL_CONSTANT_BUFFERS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_CLEAR_SURFACE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.RESPECT_STENCIL_MASK = ", prefix);
        switch (parsed) {
        case NVA297_SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_CLEAR_RECT = ", prefix);
        switch (parsed) {
        case NVA297_SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_SCISSOR0 = ", prefix);
        switch (parsed) {
        case NVA297_SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_VIEWPORT_CLIP0 = ", prefix);
        switch (parsed) {
        case NVA297_SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_NO_OPERATION_DATA_HI:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DEPTH_BIAS_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DEPTH_FORMAT_DEPENDENT = ", prefix);
        switch (parsed) {
        case NVA297_SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_PM_TRIGGER_END:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_ID_BASE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
            case NVA297_SET_BLEND_PER_FORMAT_ENABLE:
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.SNORM8_UNORM16_SNORM16 = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_FLUSH_PENDING_WRITES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SM_DOES_GLOBAL_STORE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VAB_DATA_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.VAB_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 3) - 1);
        fprintf(fp, "%s.COMPONENT_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.COMPONENT_BYTE_WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 3) - 1);
        fprintf(fp, "%s.FORMAT = ", prefix);
        switch (parsed) {
        case NVA297_SET_VAB_DATA_CONTROL_FORMAT_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY:
            fprintf(fp, "UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY\n");
            break;
        case NVA297_SET_VAB_DATA_CONTROL_FORMAT_NUM_SNORM:
            fprintf(fp, "NUM_SNORM\n");
            break;
        case NVA297_SET_VAB_DATA_CONTROL_FORMAT_NUM_UNORM:
            fprintf(fp, "NUM_UNORM\n");
            break;
        case NVA297_SET_VAB_DATA_CONTROL_FORMAT_NUM_SINT:
            fprintf(fp, "NUM_SINT\n");
            break;
        case NVA297_SET_VAB_DATA_CONTROL_FORMAT_NUM_UINT:
            fprintf(fp, "NUM_UINT\n");
            break;
        case NVA297_SET_VAB_DATA_CONTROL_FORMAT_NUM_USCALED:
            fprintf(fp, "NUM_USCALED\n");
            break;
        case NVA297_SET_VAB_DATA_CONTROL_FORMAT_NUM_SSCALED:
            fprintf(fp, "NUM_SSCALED\n");
            break;
        case NVA297_SET_VAB_DATA_CONTROL_FORMAT_NUM_FLOAT:
            fprintf(fp, "NUM_FLOAT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A(0):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(1):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(2):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(3):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(4):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(5):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(6):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(7):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(8):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(9):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(10):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(11):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(12):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(13):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(14):
    case NVA297_SET_VERTEX_ATTRIBUTE_A(15):
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.STREAM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SOURCE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ATTRIBUTE_A_SOURCE_ACTIVE:
            fprintf(fp, "ACTIVE\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_SOURCE_INACTIVE:
            fprintf(fp, "INACTIVE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 14) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 6) - 1);
        fprintf(fp, "%s.COMPONENT_BIT_WIDTHS = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32:
            fprintf(fp, "R32_G32_B32_A32\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32:
            fprintf(fp, "R32_G32_B32\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16:
            fprintf(fp, "R16_G16_B16_A16\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32:
            fprintf(fp, "R32_G32\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16:
            fprintf(fp, "R16_G16_B16\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8B8G8R8:
            fprintf(fp, "A8B8G8R8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8:
            fprintf(fp, "R8_G8_B8_A8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_X8B8G8R8:
            fprintf(fp, "X8B8G8R8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A2B10G10R10:
            fprintf(fp, "A2B10G10R10\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_B10G11R11:
            fprintf(fp, "B10G11R11\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16:
            fprintf(fp, "R16_G16\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32:
            fprintf(fp, "R32\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8:
            fprintf(fp, "R8_G8_B8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_G8R8:
            fprintf(fp, "G8R8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8:
            fprintf(fp, "R8_G8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16:
            fprintf(fp, "R16\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8:
            fprintf(fp, "R8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8:
            fprintf(fp, "A8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.NUMERICAL_TYPE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY:
            fprintf(fp, "UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SNORM:
            fprintf(fp, "NUM_SNORM\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UNORM:
            fprintf(fp, "NUM_UNORM\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SINT:
            fprintf(fp, "NUM_SINT\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UINT:
            fprintf(fp, "NUM_UINT\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_USCALED:
            fprintf(fp, "NUM_USCALED\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SSCALED:
            fprintf(fp, "NUM_SSCALED\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_FLOAT:
            fprintf(fp, "NUM_FLOAT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.SWAP_R_AND_B = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VERTEX_ATTRIBUTE_B(0):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(1):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(2):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(3):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(4):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(5):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(6):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(7):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(8):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(9):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(10):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(11):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(12):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(13):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(14):
    case NVA297_SET_VERTEX_ATTRIBUTE_B(15):
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.STREAM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SOURCE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ATTRIBUTE_B_SOURCE_ACTIVE:
            fprintf(fp, "ACTIVE\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_SOURCE_INACTIVE:
            fprintf(fp, "INACTIVE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 14) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 6) - 1);
        fprintf(fp, "%s.COMPONENT_BIT_WIDTHS = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32:
            fprintf(fp, "R32_G32_B32_A32\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32:
            fprintf(fp, "R32_G32_B32\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16:
            fprintf(fp, "R16_G16_B16_A16\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32:
            fprintf(fp, "R32_G32\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16:
            fprintf(fp, "R16_G16_B16\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8B8G8R8:
            fprintf(fp, "A8B8G8R8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8:
            fprintf(fp, "R8_G8_B8_A8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_X8B8G8R8:
            fprintf(fp, "X8B8G8R8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A2B10G10R10:
            fprintf(fp, "A2B10G10R10\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_B10G11R11:
            fprintf(fp, "B10G11R11\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16:
            fprintf(fp, "R16_G16\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32:
            fprintf(fp, "R32\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8:
            fprintf(fp, "R8_G8_B8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_G8R8:
            fprintf(fp, "G8R8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8:
            fprintf(fp, "R8_G8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16:
            fprintf(fp, "R16\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8:
            fprintf(fp, "R8\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8:
            fprintf(fp, "A8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.NUMERICAL_TYPE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY:
            fprintf(fp, "UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SNORM:
            fprintf(fp, "NUM_SNORM\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UNORM:
            fprintf(fp, "NUM_UNORM\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SINT:
            fprintf(fp, "NUM_SINT\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UINT:
            fprintf(fp, "NUM_UINT\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_USCALED:
            fprintf(fp, "NUM_USCALED\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SSCALED:
            fprintf(fp, "NUM_SSCALED\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_FLOAT:
            fprintf(fp, "NUM_FLOAT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.SWAP_R_AND_B = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.START_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.START_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_CT_SELECT:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.TARGET_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 13) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 19) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 22) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET6 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 25) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET7 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COMPRESSION_THRESHOLD:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.SAMPLES = ", prefix);
        switch (parsed) {
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__0:
            fprintf(fp, "_0\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__1:
            fprintf(fp, "_1\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__2:
            fprintf(fp, "_2\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__4:
            fprintf(fp, "_4\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__8:
            fprintf(fp, "_8\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__16:
            fprintf(fp, "_16\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__32:
            fprintf(fp, "_32\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__64:
            fprintf(fp, "_64\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__128:
            fprintf(fp, "_128\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__256:
            fprintf(fp, "_256\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__512:
            fprintf(fp, "_512\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__1024:
            fprintf(fp, "_1024\n");
            break;
        case NVA297_SET_COMPRESSION_THRESHOLD_SAMPLES__2048:
            fprintf(fp, "_2048\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZT_SIZE_A:
    
        parsed = (data >> 0) & ((1u << 28) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZT_SIZE_B:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZT_SIZE_C:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.THIRD_DIMENSION = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONTROL = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZT_SIZE_C_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE:
            fprintf(fp, "THIRD_DIMENSION_DEFINES_ARRAY_SIZE\n");
            break;
        case NVA297_SET_ZT_SIZE_C_CONTROL_ARRAY_SIZE_IS_ONE:
            fprintf(fp, "ARRAY_SIZE_IS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SAMPLER_BINDING:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_SAMPLER_BINDING_V_INDEPENDENTLY:
            fprintf(fp, "INDEPENDENTLY\n");
            break;
        case NVA297_SET_SAMPLER_BINDING_V_VIA_HEADER_BINDING:
            fprintf(fp, "VIA_HEADER_BINDING\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_AUTO:
    
        parsed = data;
        fprintf(fp, "%s.BYTE_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CIRCULAR_BUFFER_SIZE:
    
        parsed = (data >> 0) & ((1u << 10) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VTG_REGISTER_WATERMARKS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVA297_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_SCHEDULING:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADER_SCHEDULING_MODE_OLDEST_THREAD_FIRST:
            fprintf(fp, "OLDEST_THREAD_FIRST\n");
            break;
        case NVA297_SET_SHADER_SCHEDULING_MODE_ROUND_ROBIN:
            fprintf(fp, "ROUND_ROBIN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_CLEAR_ZCULL_REGION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_ZCULL_REGION_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_ZCULL_REGION_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.STENCIL_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_ZCULL_REGION_STENCIL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_ZCULL_REGION_STENCIL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_CLEAR_RECT = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_ZCULL_REGION_USE_CLEAR_RECT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_ZCULL_REGION_USE_CLEAR_RECT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_RT_ARRAY_INDEX = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 16) - 1);
        fprintf(fp, "%s.RT_ARRAY_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.MAKE_CONSERVATIVE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DEPTH_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_DEPTH_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DEPTH_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_FILL_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_FILL_MODE_V_POINT:
            fprintf(fp, "POINT\n");
            break;
        case NVA297_SET_FILL_MODE_V_WIREFRAME:
            fprintf(fp, "WIREFRAME\n");
            break;
        case NVA297_SET_FILL_MODE_V_SOLID:
            fprintf(fp, "SOLID\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SHADE_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADE_MODE_V_FLAT:
            fprintf(fp, "FLAT\n");
            break;
        case NVA297_SET_SHADE_MODE_V_GOURAUD:
            fprintf(fp, "GOURAUD\n");
            break;
        case NVA297_SET_SHADE_MODE_V_OGL_FLAT:
            fprintf(fp, "OGL_FLAT\n");
            break;
        case NVA297_SET_SHADE_MODE_V_OGL_SMOOTH:
            fprintf(fp, "OGL_SMOOTH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVA297_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.DITHER_FOOTPRINT = ", prefix);
        switch (parsed) {
        case NVA297_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1:
            fprintf(fp, "PIXELS_1X1\n");
            break;
        case NVA297_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_2X2:
            fprintf(fp, "PIXELS_2X2\n");
            break;
        case NVA297_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1_VIRTUAL_SAMPLES:
            fprintf(fp, "PIXELS_1X1_VIRTUAL_SAMPLES\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_STATE_PER_TARGET:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_STATE_PER_TARGET_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BLEND_STATE_PER_TARGET_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DEPTH_WRITE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_DEPTH_WRITE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DEPTH_WRITE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ALPHA_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ALPHA_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ALPHA_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_INLINE_INDEX4X8_ALIGN:
    
        parsed = (data >> 0) & ((1u << 30) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 2) - 1);
        fprintf(fp, "%s.START = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_DRAW_INLINE_INDEX4X8:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.INDEX0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.INDEX1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.INDEX2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.INDEX3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_D3D_SET_CULL_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_D3D_SET_CULL_MODE_V_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVA297_D3D_SET_CULL_MODE_V_CW:
            fprintf(fp, "CW\n");
            break;
        case NVA297_D3D_SET_CULL_MODE_V_CCW:
            fprintf(fp, "CCW\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DEPTH_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_DEPTH_FUNC_V_OGL_NEVER:
            fprintf(fp, "OGL_NEVER\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_OGL_LESS:
            fprintf(fp, "OGL_LESS\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_OGL_EQUAL:
            fprintf(fp, "OGL_EQUAL\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_OGL_LEQUAL:
            fprintf(fp, "OGL_LEQUAL\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_OGL_GREATER:
            fprintf(fp, "OGL_GREATER\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_OGL_NOTEQUAL:
            fprintf(fp, "OGL_NOTEQUAL\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_OGL_GEQUAL:
            fprintf(fp, "OGL_GEQUAL\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_OGL_ALWAYS:
            fprintf(fp, "OGL_ALWAYS\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_D3D_NEVER:
            fprintf(fp, "D3D_NEVER\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_D3D_LESS:
            fprintf(fp, "D3D_LESS\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_D3D_EQUAL:
            fprintf(fp, "D3D_EQUAL\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_D3D_LESSEQUAL:
            fprintf(fp, "D3D_LESSEQUAL\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_D3D_GREATER:
            fprintf(fp, "D3D_GREATER\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_D3D_NOTEQUAL:
            fprintf(fp, "D3D_NOTEQUAL\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_D3D_GREATEREQUAL:
            fprintf(fp, "D3D_GREATEREQUAL\n");
            break;
        case NVA297_SET_DEPTH_FUNC_V_D3D_ALWAYS:
            fprintf(fp, "D3D_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ALPHA_REF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ALPHA_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_ALPHA_FUNC_V_OGL_NEVER:
            fprintf(fp, "OGL_NEVER\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_OGL_LESS:
            fprintf(fp, "OGL_LESS\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_OGL_EQUAL:
            fprintf(fp, "OGL_EQUAL\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_OGL_LEQUAL:
            fprintf(fp, "OGL_LEQUAL\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_OGL_GREATER:
            fprintf(fp, "OGL_GREATER\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_OGL_NOTEQUAL:
            fprintf(fp, "OGL_NOTEQUAL\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_OGL_GEQUAL:
            fprintf(fp, "OGL_GEQUAL\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_OGL_ALWAYS:
            fprintf(fp, "OGL_ALWAYS\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_D3D_NEVER:
            fprintf(fp, "D3D_NEVER\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_D3D_LESS:
            fprintf(fp, "D3D_LESS\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_D3D_EQUAL:
            fprintf(fp, "D3D_EQUAL\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_D3D_LESSEQUAL:
            fprintf(fp, "D3D_LESSEQUAL\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_D3D_GREATER:
            fprintf(fp, "D3D_GREATER\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_D3D_NOTEQUAL:
            fprintf(fp, "D3D_NOTEQUAL\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_D3D_GREATEREQUAL:
            fprintf(fp, "D3D_GREATEREQUAL\n");
            break;
        case NVA297_SET_ALPHA_FUNC_V_D3D_ALWAYS:
            fprintf(fp, "D3D_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DRAW_AUTO_STRIDE:
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_BLEND_CONST_RED:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_BLEND_CONST_GREEN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_BLEND_CONST_BLUE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_BLEND_CONST_ALPHA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_INVALIDATE_SAMPLER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SAMPLER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVA297_INVALIDATE_SAMPLER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_INVALIDATE_TEXTURE_HEADER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVA297_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_INVALIDATE_TEXTURE_DATA_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVA297_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_BLEND_SEPARATE_FOR_ALPHA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_COLOR_OP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_COLOR_OP_V_OGL_FUNC_SUBTRACT:
            fprintf(fp, "OGL_FUNC_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT:
            fprintf(fp, "OGL_FUNC_REVERSE_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_OGL_FUNC_ADD:
            fprintf(fp, "OGL_FUNC_ADD\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_OGL_MIN:
            fprintf(fp, "OGL_MIN\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_OGL_MAX:
            fprintf(fp, "OGL_MAX\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_D3D_ADD:
            fprintf(fp, "D3D_ADD\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_D3D_SUBTRACT:
            fprintf(fp, "D3D_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_D3D_REVSUBTRACT:
            fprintf(fp, "D3D_REVSUBTRACT\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_D3D_MIN:
            fprintf(fp, "D3D_MIN\n");
            break;
        case NVA297_SET_BLEND_COLOR_OP_V_D3D_MAX:
            fprintf(fp, "D3D_MAX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_COLOR_SOURCE_COEFF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA:
            fprintf(fp, "D3D_BOTHSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA:
            fprintf(fp, "D3D_BOTHINVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_COLOR_DEST_COEFF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_ALPHA_OP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_ALPHA_OP_V_OGL_FUNC_SUBTRACT:
            fprintf(fp, "OGL_FUNC_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT:
            fprintf(fp, "OGL_FUNC_REVERSE_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_OGL_FUNC_ADD:
            fprintf(fp, "OGL_FUNC_ADD\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_OGL_MIN:
            fprintf(fp, "OGL_MIN\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_OGL_MAX:
            fprintf(fp, "OGL_MAX\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_D3D_ADD:
            fprintf(fp, "D3D_ADD\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_D3D_SUBTRACT:
            fprintf(fp, "D3D_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_D3D_REVSUBTRACT:
            fprintf(fp, "D3D_REVSUBTRACT\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_D3D_MIN:
            fprintf(fp, "D3D_MIN\n");
            break;
        case NVA297_SET_BLEND_ALPHA_OP_V_D3D_MAX:
            fprintf(fp, "D3D_MAX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA:
            fprintf(fp, "D3D_BOTHSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA:
            fprintf(fp, "D3D_BOTHINVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_GLOBAL_COLOR_KEY:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_GLOBAL_COLOR_KEY_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_GLOBAL_COLOR_KEY_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_ALPHA_DEST_COEFF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SINGLE_ROP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SINGLE_ROP_CONTROL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_SINGLE_ROP_CONTROL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND(0):
    case NVA297_SET_BLEND(1):
    case NVA297_SET_BLEND(2):
    case NVA297_SET_BLEND(3):
    case NVA297_SET_BLEND(4):
    case NVA297_SET_BLEND(5):
    case NVA297_SET_BLEND(6):
    case NVA297_SET_BLEND(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BLEND_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STENCIL_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_STENCIL_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_STENCIL_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STENCIL_OP_FAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_STENCIL_OP_FAIL_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVA297_SET_STENCIL_OP_FAIL_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STENCIL_OP_ZFAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_STENCIL_OP_ZFAIL_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVA297_SET_STENCIL_OP_ZFAIL_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STENCIL_OP_ZPASS:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_STENCIL_OP_ZPASS_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVA297_SET_STENCIL_OP_ZPASS_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STENCIL_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_STENCIL_FUNC_V_OGL_NEVER:
            fprintf(fp, "OGL_NEVER\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_OGL_LESS:
            fprintf(fp, "OGL_LESS\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_OGL_EQUAL:
            fprintf(fp, "OGL_EQUAL\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_OGL_LEQUAL:
            fprintf(fp, "OGL_LEQUAL\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_OGL_GREATER:
            fprintf(fp, "OGL_GREATER\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_OGL_NOTEQUAL:
            fprintf(fp, "OGL_NOTEQUAL\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_OGL_GEQUAL:
            fprintf(fp, "OGL_GEQUAL\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_OGL_ALWAYS:
            fprintf(fp, "OGL_ALWAYS\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_D3D_NEVER:
            fprintf(fp, "D3D_NEVER\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_D3D_LESS:
            fprintf(fp, "D3D_LESS\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_D3D_EQUAL:
            fprintf(fp, "D3D_EQUAL\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_D3D_LESSEQUAL:
            fprintf(fp, "D3D_LESSEQUAL\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_D3D_GREATER:
            fprintf(fp, "D3D_GREATER\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_D3D_NOTEQUAL:
            fprintf(fp, "D3D_NOTEQUAL\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_D3D_GREATEREQUAL:
            fprintf(fp, "D3D_GREATEREQUAL\n");
            break;
        case NVA297_SET_STENCIL_FUNC_V_D3D_ALWAYS:
            fprintf(fp, "D3D_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_STENCIL_FUNC_REF:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_STENCIL_FUNC_MASK:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_STENCIL_MASK:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DRAW_AUTO_START:
    
        parsed = data;
        fprintf(fp, "%s.BYTE_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PS_SATURATE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT0 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_OUTPUT0_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_SATURATE_OUTPUT0_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE0 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE0_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE0_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT1 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_OUTPUT1_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_SATURATE_OUTPUT1_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE1 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE1_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE1_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT2 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_OUTPUT2_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_SATURATE_OUTPUT2_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE2 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE2_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE2_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT3 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_OUTPUT3_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_SATURATE_OUTPUT3_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE3 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE3_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE3_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT4 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_OUTPUT4_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_SATURATE_OUTPUT4_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE4 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE4_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE4_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT5 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_OUTPUT5_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_SATURATE_OUTPUT5_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE5 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE5_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE5_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT6 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_OUTPUT6_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_SATURATE_OUTPUT6_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 25) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE6 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE6_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE6_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT7 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_OUTPUT7_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PS_SATURATE_OUTPUT7_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 29) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE7 = ", prefix);
        switch (parsed) {
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE7_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVA297_SET_PS_SATURATE_CLAMP_RANGE7_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_WINDOW_ORIGIN:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_WINDOW_ORIGIN_MODE_UPPER_LEFT:
            fprintf(fp, "UPPER_LEFT\n");
            break;
        case NVA297_SET_WINDOW_ORIGIN_MODE_LOWER_LEFT:
            fprintf(fp, "LOWER_LEFT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLIP_Y = ", prefix);
        switch (parsed) {
        case NVA297_SET_WINDOW_ORIGIN_FLIP_Y_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_WINDOW_ORIGIN_FLIP_Y_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_LINE_WIDTH_FLOAT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_ALIASED_LINE_WIDTH_FLOAT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_LINE_MULTISAMPLE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ALPHA_HYSTERESIS:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ROUNDS_OF_ALPHA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_INVALIDATE_SAMPLER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVA297_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVA297_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_INVALIDATE_DA_DMA_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_GLOBAL_BASE_VERTEX_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_GLOBAL_BASE_INSTANCE_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PS_WARP_WATERMARKS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PS_REGISTER_WATERMARKS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_STORE_ZCULL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                case NVA297_LOAD_ZCULL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SURFACE_CLIP_ID_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CLIP_ID_CLEAR_RECT_VERTICAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_USER_CLIP_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE0 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_ENABLE_PLANE0_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_USER_CLIP_ENABLE_PLANE0_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE1 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_ENABLE_PLANE1_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_USER_CLIP_ENABLE_PLANE1_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE2 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_ENABLE_PLANE2_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_USER_CLIP_ENABLE_PLANE2_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE3 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_ENABLE_PLANE3_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_USER_CLIP_ENABLE_PLANE3_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE4 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_ENABLE_PLANE4_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_USER_CLIP_ENABLE_PLANE4_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE5 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_ENABLE_PLANE5_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_USER_CLIP_ENABLE_PLANE5_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE6 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_ENABLE_PLANE6_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_USER_CLIP_ENABLE_PLANE6_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE7 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_ENABLE_PLANE7_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_USER_CLIP_ENABLE_PLANE7_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZPASS_PIXEL_COUNT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZPASS_PIXEL_COUNT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZPASS_PIXEL_COUNT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_POINT_SIZE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_STATS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_STATS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_STATS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_POINT_SPRITE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_POINT_SPRITE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SHADER_EXCEPTIONS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADER_EXCEPTIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_SHADER_EXCEPTIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_CLEAR_REPORT_VALUE:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_REPORT_VALUE_TYPE_DA_VERTICES_GENERATED:
            fprintf(fp, "DA_VERTICES_GENERATED\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_DA_PRIMITIVES_GENERATED:
            fprintf(fp, "DA_PRIMITIVES_GENERATED\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_VS_INVOCATIONS:
            fprintf(fp, "VS_INVOCATIONS\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_TI_INVOCATIONS:
            fprintf(fp, "TI_INVOCATIONS\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_TS_INVOCATIONS:
            fprintf(fp, "TS_INVOCATIONS\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_TS_PRIMITIVES_GENERATED:
            fprintf(fp, "TS_PRIMITIVES_GENERATED\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_GS_INVOCATIONS:
            fprintf(fp, "GS_INVOCATIONS\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_GS_PRIMITIVES_GENERATED:
            fprintf(fp, "GS_PRIMITIVES_GENERATED\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_VTG_PRIMITIVES_OUT:
            fprintf(fp, "VTG_PRIMITIVES_OUT\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_SUCCEEDED\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_NEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_CLIPPER_INVOCATIONS:
            fprintf(fp, "CLIPPER_INVOCATIONS\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_CLIPPER_PRIMITIVES_GENERATED:
            fprintf(fp, "CLIPPER_PRIMITIVES_GENERATED\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_ZCULL_STATS:
            fprintf(fp, "ZCULL_STATS\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_PS_INVOCATIONS:
            fprintf(fp, "PS_INVOCATIONS\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_ZPASS_PIXEL_CNT:
            fprintf(fp, "ZPASS_PIXEL_CNT\n");
            break;
        case NVA297_CLEAR_REPORT_VALUE_TYPE_ALPHA_BETA_CLOCKS:
            fprintf(fp, "ALPHA_BETA_CLOCKS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ANTI_ALIAS_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_ANTI_ALIAS_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ANTI_ALIAS_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZT_SELECT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TARGET_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ANTI_ALIAS_ALPHA_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_TO_COVERAGE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVA297_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_TO_ONE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVA297_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVA297_SET_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVA297_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVA297_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TEX_SAMPLER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TEX_SAMPLER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TEX_SAMPLER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SLOPE_SCALE_DEPTH_BIAS:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_ANTI_ALIASED_LINE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ANTI_ALIASED_LINE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ANTI_ALIASED_LINE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TEX_HEADER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TEX_HEADER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TEX_HEADER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ACTIVE_ZCULL_REGION:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TWO_SIDED_STENCIL_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_TWO_SIDED_STENCIL_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_TWO_SIDED_STENCIL_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BACK_STENCIL_OP_FAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_FAIL_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BACK_STENCIL_OP_ZFAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BACK_STENCIL_OP_ZPASS:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVA297_SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BACK_STENCIL_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BACK_STENCIL_FUNC_V_OGL_NEVER:
            fprintf(fp, "OGL_NEVER\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_OGL_LESS:
            fprintf(fp, "OGL_LESS\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_OGL_EQUAL:
            fprintf(fp, "OGL_EQUAL\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_OGL_LEQUAL:
            fprintf(fp, "OGL_LEQUAL\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_OGL_GREATER:
            fprintf(fp, "OGL_GREATER\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_OGL_NOTEQUAL:
            fprintf(fp, "OGL_NOTEQUAL\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_OGL_GEQUAL:
            fprintf(fp, "OGL_GEQUAL\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_OGL_ALWAYS:
            fprintf(fp, "OGL_ALWAYS\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_D3D_NEVER:
            fprintf(fp, "D3D_NEVER\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_D3D_LESS:
            fprintf(fp, "D3D_LESS\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_D3D_EQUAL:
            fprintf(fp, "D3D_EQUAL\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_D3D_LESSEQUAL:
            fprintf(fp, "D3D_LESSEQUAL\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_D3D_GREATER:
            fprintf(fp, "D3D_GREATER\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_D3D_NOTEQUAL:
            fprintf(fp, "D3D_NOTEQUAL\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_D3D_GREATEREQUAL:
            fprintf(fp, "D3D_GREATEREQUAL\n");
            break;
        case NVA297_SET_BACK_STENCIL_FUNC_V_D3D_ALWAYS:
            fprintf(fp, "D3D_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SRGB_WRITE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SRGB_WRITE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_SRGB_WRITE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DEPTH_BIAS:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_ZCULL_REGION_FORMAT:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X4:
            fprintf(fp, "Z_4X4\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_ZS_4X4:
            fprintf(fp, "ZS_4X4\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X2:
            fprintf(fp, "Z_4X2\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_2X4:
            fprintf(fp, "Z_2X4\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X8_4X4:
            fprintf(fp, "Z_16X8_4X4\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_4X2:
            fprintf(fp, "Z_8X8_4X2\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_2X4:
            fprintf(fp, "Z_8X8_2X4\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X16_4X8:
            fprintf(fp, "Z_16X16_4X8\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_2X2:
            fprintf(fp, "Z_4X8_2X2\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_4X2:
            fprintf(fp, "ZS_16X8_4X2\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_2X4:
            fprintf(fp, "ZS_16X8_2X4\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_ZS_8X8_2X2:
            fprintf(fp, "ZS_8X8_2X2\n");
            break;
        case NVA297_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_1X1:
            fprintf(fp, "Z_4X8_1X1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_RT_LAYER:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONTROL = ", prefix);
        switch (parsed) {
        case NVA297_SET_RT_LAYER_CONTROL_V_SELECTS_LAYER:
            fprintf(fp, "V_SELECTS_LAYER\n");
            break;
        case NVA297_SET_RT_LAYER_CONTROL_GEOMETRY_SHADER_SELECTS_LAYER:
            fprintf(fp, "GEOMETRY_SHADER_SELECTS_LAYER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ANTI_ALIAS:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.SAMPLES = ", prefix);
        switch (parsed) {
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_1X1:
            fprintf(fp, "MODE_1X1\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_2X1:
            fprintf(fp, "MODE_2X1\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_2X2:
            fprintf(fp, "MODE_2X2\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_4X2:
            fprintf(fp, "MODE_4X2\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_D3D:
            fprintf(fp, "MODE_4X2_D3D\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_2X1_D3D:
            fprintf(fp, "MODE_2X1_D3D\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_4X4:
            fprintf(fp, "MODE_4X4\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_4:
            fprintf(fp, "MODE_2X2_VC_4\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_12:
            fprintf(fp, "MODE_2X2_VC_12\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_8:
            fprintf(fp, "MODE_4X2_VC_8\n");
            break;
        case NVA297_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_24:
            fprintf(fp, "MODE_4X2_VC_24\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_EDGE_FLAG:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_EDGE_FLAG_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_EDGE_FLAG_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_INLINE_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_INLINE_INDEX2X16_ALIGN:
    
        parsed = (data >> 0) & ((1u << 31) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.START_ODD = ", prefix);
        switch (parsed) {
        case NVA297_SET_INLINE_INDEX2X16_ALIGN_START_ODD_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_INLINE_INDEX2X16_ALIGN_START_ODD_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_INLINE_INDEX2X16:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.EVEN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.ODD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_GLOBAL_BASE_OFFSET_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_GLOBAL_BASE_OFFSET_B:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_A:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZCULL_REGION_PIXEL_OFFSET_B:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_POINT_SPRITE_SELECT:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.RMODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_RMODE_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_RMODE_FROM_R:
            fprintf(fp, "FROM_R\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_RMODE_FROM_S:
            fprintf(fp, "FROM_S\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.ORIGIN = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_ORIGIN_BOTTOM:
            fprintf(fp, "BOTTOM\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_ORIGIN_TOP:
            fprintf(fp, "TOP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE0 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE0_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE0_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE1 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE1_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE1_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE2 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE2_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE2_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE3 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE3_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE3_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE4 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE4_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE4_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE5 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE5_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE5_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE6 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE6_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE6_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE7 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE7_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE7_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE8 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE8_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE8_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE9 = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE9_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVA297_SET_POINT_SPRITE_SELECT_TEXTURE9_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_PROGRAM_REGION_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PROGRAM_REGION_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ATTRIBUTE_DEFAULT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.COLOR_FRONT_DIFFUSE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        case NVA297_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_1111:
            fprintf(fp, "VECTOR_1111\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.COLOR_FRONT_SPECULAR = ", prefix);
        switch (parsed) {
        case NVA297_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0000:
            fprintf(fp, "VECTOR_0000\n");
            break;
        case NVA297_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.GENERIC_VECTOR = ", prefix);
        switch (parsed) {
        case NVA297_SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0000:
            fprintf(fp, "VECTOR_0000\n");
            break;
        case NVA297_SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.FIXED_FNC_TEXTURE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0000:
            fprintf(fp, "VECTOR_0000\n");
            break;
        case NVA297_SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.DX9_COLOR0 = ", prefix);
        switch (parsed) {
        case NVA297_SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        case NVA297_SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_1111:
            fprintf(fp, "VECTOR_1111\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.DX9_COLOR1_TO_COLOR15 = ", prefix);
        switch (parsed) {
        case NVA297_SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0000:
            fprintf(fp, "VECTOR_0000\n");
            break;
        case NVA297_SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_END:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_BEGIN:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NVA297_BEGIN_OP_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_BEGIN_OP_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_BEGIN_OP_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_BEGIN_OP_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_BEGIN_OP_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_BEGIN_OP_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_BEGIN_OP_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_BEGIN_OP_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_BEGIN_OP_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_BEGIN_OP_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_BEGIN_OP_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_BEGIN_OP_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_BEGIN_OP_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_BEGIN_OP_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_BEGIN_OP_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PRIMITIVE_ID = ", prefix);
        switch (parsed) {
        case NVA297_BEGIN_PRIMITIVE_ID_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVA297_BEGIN_PRIMITIVE_ID_UNCHANGED:
            fprintf(fp, "UNCHANGED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 26) & ((1u << 2) - 1);
        fprintf(fp, "%s.INSTANCE_ID = ", prefix);
        switch (parsed) {
        case NVA297_BEGIN_INSTANCE_ID_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVA297_BEGIN_INSTANCE_ID_SUBSEQUENT:
            fprintf(fp, "SUBSEQUENT\n");
            break;
        case NVA297_BEGIN_INSTANCE_ID_UNCHANGED:
            fprintf(fp, "UNCHANGED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 29) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPLIT_MODE = ", prefix);
        switch (parsed) {
        case NVA297_BEGIN_SPLIT_MODE_NORMAL_BEGIN_NORMAL_END:
            fprintf(fp, "NORMAL_BEGIN_NORMAL_END\n");
            break;
        case NVA297_BEGIN_SPLIT_MODE_NORMAL_BEGIN_OPEN_END:
            fprintf(fp, "NORMAL_BEGIN_OPEN_END\n");
            break;
        case NVA297_BEGIN_SPLIT_MODE_OPEN_BEGIN_OPEN_END:
            fprintf(fp, "OPEN_BEGIN_OPEN_END\n");
            break;
        case NVA297_BEGIN_SPLIT_MODE_OPEN_BEGIN_NORMAL_END:
            fprintf(fp, "OPEN_BEGIN_NORMAL_END\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VERTEX_ID_COPY:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_ID_COPY_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VERTEX_ID_COPY_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.ATTRIBUTE_SLOT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_ADD_TO_PRIMITIVE_ID:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LOAD_PRIMITIVE_ID:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_BASED_CULL:
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.BATCH_CULL_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.BEFORE_FETCH_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VAB_PAGE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.READ_SELECT = ", prefix);
        switch (parsed) {
        case NVA297_SET_VAB_PAGE_READ_SELECT_PAGES_0_AND_1:
            fprintf(fp, "PAGES_0_AND_1\n");
            break;
        case NVA297_SET_VAB_PAGE_READ_SELECT_PAGES_0_AND_2:
            fprintf(fp, "PAGES_0_AND_2\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_INLINE_VERTEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DA_PRIMITIVE_RESTART:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_DA_PRIMITIVE_RESTART_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DA_PRIMITIVE_RESTART_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DA_PRIMITIVE_RESTART_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DA_OUTPUT:
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.VERTEX_ID_USES_ARRAY_START = ", prefix);
        switch (parsed) {
        case NVA297_SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ANTI_ALIASED_POINT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ANTI_ALIASED_POINT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ANTI_ALIASED_POINT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_POINT_CENTER_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_POINT_CENTER_MODE_V_OGL:
            fprintf(fp, "OGL\n");
            break;
        case NVA297_SET_POINT_CENTER_MODE_V_D3D:
            fprintf(fp, "D3D\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_LINE_SMOOTH_PARAMETERS:
    
        parsed = data;
        fprintf(fp, "%s.FALLOFF = ", prefix);
        switch (parsed) {
        case NVA297_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_00:
            fprintf(fp, "_1_00\n");
            break;
        case NVA297_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_33:
            fprintf(fp, "_1_33\n");
            break;
        case NVA297_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_60:
            fprintf(fp, "_1_60\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_LINE_STIPPLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_LINE_STIPPLE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_LINE_STIPPLE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
        case NVA297_SET_LINE_STIPPLE_PARAMETERS:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.FACTOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.PATTERN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PROVOKING_VERTEX:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_PROVOKING_VERTEX_V_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVA297_SET_PROVOKING_VERTEX_V_LAST:
            fprintf(fp, "LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_TWO_SIDED_LIGHT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_TWO_SIDED_LIGHT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_TWO_SIDED_LIGHT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_POLYGON_STIPPLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_POLYGON_STIPPLE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_POLYGON_STIPPLE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SHADER_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DEFAULT_PARTIAL = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NVA297_SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY:
            fprintf(fp, "INFINITY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.FP32_NAN_BEHAVIOR = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY:
            fprintf(fp, "LEGACY\n");
            break;
        case NVA297_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE:
            fprintf(fp, "FP64_COMPATIBLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FP32_F2I_NAN_BEHAVIOR = ", prefix);
        switch (parsed) {
        case NVA297_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO:
            fprintf(fp, "PASS_ZERO\n");
            break;
        case NVA297_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE:
            fprintf(fp, "PASS_INDEFINITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_LAUNCH_VERTEX:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_CHECK_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPH_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_CHECK_SPH_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ALPHA_TO_COVERAGE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.QUALIFY_BY_ANTI_ALIAS_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVA297_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT = ", prefix);
        switch (parsed) {
        case NVA297_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVA297_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
        case NVA297_SET_AAM_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_CHECK_AAM_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_ZT_LAYER:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VAB_MEMORY_AREA_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VAB_MEMORY_AREA_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VAB_MEMORY_AREA_C:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.SIZE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_64K:
            fprintf(fp, "BYTES_64K\n");
            break;
        case NVA297_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_128K:
            fprintf(fp, "BYTES_128K\n");
            break;
        case NVA297_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_256K:
            fprintf(fp, "BYTES_256K\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_INDEX_BUFFER_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_INDEX_BUFFER_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_INDEX_BUFFER_C:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.LIMIT_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_INDEX_BUFFER_D:
    
        parsed = data;
        fprintf(fp, "%s.LIMIT_ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_INDEX_BUFFER_E:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.INDEX_SIZE = ", prefix);
        switch (parsed) {
        case NVA297_SET_INDEX_BUFFER_E_INDEX_SIZE_ONE_BYTE:
            fprintf(fp, "ONE_BYTE\n");
            break;
        case NVA297_SET_INDEX_BUFFER_E_INDEX_SIZE_TWO_BYTES:
            fprintf(fp, "TWO_BYTES\n");
            break;
        case NVA297_SET_INDEX_BUFFER_E_INDEX_SIZE_FOUR_BYTES:
            fprintf(fp, "FOUR_BYTES\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_INDEX_BUFFER_F:
    
        parsed = data;
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_DRAW_INDEX_BUFFER:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_DEPTH_BIAS_CLAMP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(0):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(1):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(2):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(3):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(4):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(5):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(6):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(7):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(8):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(9):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(10):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(11):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(12):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(13):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(14):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_A(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IS_INSTANCED = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(0):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(1):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(2):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(3):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(4):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(5):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(6):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(7):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(8):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(9):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(10):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(11):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(12):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(13):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(14):
    case NVA297_SET_VERTEX_STREAM_INSTANCE_B(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IS_INSTANCED = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ATTRIBUTE_POINT_SIZE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ATTRIBUTE_POINT_SIZE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ATTRIBUTE_POINT_SIZE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.SLOT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_OGL_SET_CULL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_OGL_SET_CULL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_OGL_SET_CULL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_OGL_SET_FRONT_FACE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_OGL_SET_FRONT_FACE_V_CW:
            fprintf(fp, "CW\n");
            break;
        case NVA297_OGL_SET_FRONT_FACE_V_CCW:
            fprintf(fp, "CCW\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_OGL_SET_CULL_FACE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_OGL_SET_CULL_FACE_V_FRONT:
            fprintf(fp, "FRONT\n");
            break;
        case NVA297_OGL_SET_CULL_FACE_V_BACK:
            fprintf(fp, "BACK\n");
            break;
        case NVA297_OGL_SET_CULL_FACE_V_FRONT_AND_BACK:
            fprintf(fp, "FRONT_AND_BACK\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VIEWPORT_PIXEL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.CENTER = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_PIXEL_CENTER_AT_HALF_INTEGERS:
            fprintf(fp, "AT_HALF_INTEGERS\n");
            break;
        case NVA297_SET_VIEWPORT_PIXEL_CENTER_AT_INTEGERS:
            fprintf(fp, "AT_INTEGERS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VIEWPORT_SCALE_OFFSET:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_SCALE_OFFSET_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VIEWPORT_SCALE_OFFSET_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_INVALIDATE_CONSTANT_BUFFER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.THRU_L2 = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VIEWPORT_CLIP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MIN_Z_ZERO_MAX_Z_ONE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.PIXEL_MIN_Z = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLAMP:
            fprintf(fp, "CLAMP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.PIXEL_MAX_Z = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLAMP:
            fprintf(fp, "CLAMP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.GEOMETRY_GUARDBAND = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINE_POINT_CULL_GUARDBAND = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 3) - 1);
        fprintf(fp, "%s.GEOMETRY_CLIP = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP:
            fprintf(fp, "WZERO_CLIP\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_PASSTHRU:
            fprintf(fp, "PASSTHRU\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XY_CLIP:
            fprintf(fp, "FRUSTUM_XY_CLIP\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XYZ_CLIP:
            fprintf(fp, "FRUSTUM_XYZ_CLIP\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP_NO_Z_CULL:
            fprintf(fp, "WZERO_CLIP_NO_Z_CULL\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_Z_CLIP:
            fprintf(fp, "FRUSTUM_Z_CLIP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 2) - 1);
        fprintf(fp, "%s.GEOMETRY_GUARDBAND_Z = ", prefix);
        switch (parsed) {
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SAME_AS_XY_GUARDBAND:
            fprintf(fp, "SAME_AS_XY_GUARDBAND\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVA297_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_USER_CLIP_OP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE0 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_OP_PLANE0_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_USER_CLIP_OP_PLANE0_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE1 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_OP_PLANE1_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_USER_CLIP_OP_PLANE1_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE2 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_OP_PLANE2_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_USER_CLIP_OP_PLANE2_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE3 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_OP_PLANE3_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_USER_CLIP_OP_PLANE3_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE4 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_OP_PLANE4_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_USER_CLIP_OP_PLANE4_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE5 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_OP_PLANE5_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_USER_CLIP_OP_PLANE5_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE6 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_OP_PLANE6_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_USER_CLIP_OP_PLANE6_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE7 = ", prefix);
        switch (parsed) {
        case NVA297_SET_USER_CLIP_OP_PLANE7_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVA297_SET_USER_CLIP_OP_PLANE7_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_RENDER_ENABLE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVA297_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE:
            fprintf(fp, "USE_RENDER_ENABLE\n");
            break;
        case NVA297_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER:
            fprintf(fp, "ALWAYS_RENDER\n");
            break;
        case NVA297_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER:
            fprintf(fp, "NEVER_RENDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_PRIMITIVE_TOPOLOGY_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.OVERRIDE = ", prefix);
        switch (parsed) {
        case NVA297_SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_TOPOLOGY_IN_BEGIN_METHODS:
            fprintf(fp, "USE_TOPOLOGY_IN_BEGIN_METHODS\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_SEPARATE_TOPOLOGY_STATE:
            fprintf(fp, "USE_SEPARATE_TOPOLOGY_STATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_WINDOW_CLIP_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_WINDOW_CLIP_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_WINDOW_CLIP_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_WINDOW_CLIP_TYPE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_WINDOW_CLIP_TYPE_V_INCLUSIVE:
            fprintf(fp, "INCLUSIVE\n");
            break;
        case NVA297_SET_WINDOW_CLIP_TYPE_V_EXCLUSIVE:
            fprintf(fp, "EXCLUSIVE\n");
            break;
        case NVA297_SET_WINDOW_CLIP_TYPE_V_CLIPALL:
            fprintf(fp, "CLIPALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_INVALIDATE_ZCULL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_INVALIDATE_ZCULL_V_INVALIDATE:
            fprintf(fp, "INVALIDATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZCULL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.STENCIL_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_STENCIL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_STENCIL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_ZCULL_BOUNDS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_MIN_UNBOUNDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_MAX_UNBOUNDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_PRIMITIVE_TOPOLOGY:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_POINTLIST:
            fprintf(fp, "POINTLIST\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LINELIST:
            fprintf(fp, "LINELIST\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP:
            fprintf(fp, "LINESTRIP\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST:
            fprintf(fp, "TRIANGLELIST\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP:
            fprintf(fp, "TRIANGLESTRIP\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_PATCHLIST:
            fprintf(fp, "PATCHLIST\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_POINTS:
            fprintf(fp, "LEGACY_POINTS\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST:
            fprintf(fp, "LEGACY_INDEXEDLINELIST\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST:
            fprintf(fp, "LEGACY_INDEXEDTRIANGLELIST\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST:
            fprintf(fp, "LEGACY_LINELIST\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINESTRIP:
            fprintf(fp, "LEGACY_LINESTRIP\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINESTRIP:
            fprintf(fp, "LEGACY_INDEXEDLINESTRIP\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLELIST:
            fprintf(fp, "LEGACY_TRIANGLELIST\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLESTRIP:
            fprintf(fp, "LEGACY_TRIANGLESTRIP\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLESTRIP:
            fprintf(fp, "LEGACY_INDEXEDTRIANGLESTRIP\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN:
            fprintf(fp, "LEGACY_TRIANGLEFAN\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLEFAN:
            fprintf(fp, "LEGACY_INDEXEDTRIANGLEFAN\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN_IMM:
            fprintf(fp, "LEGACY_TRIANGLEFAN_IMM\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST_IMM:
            fprintf(fp, "LEGACY_LINELIST_IMM\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST2:
            fprintf(fp, "LEGACY_INDEXEDTRIANGLELIST2\n");
            break;
        case NVA297_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST2:
            fprintf(fp, "LEGACY_INDEXEDLINELIST2\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_ZCULL_SYNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CLIP_ID_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_CLIP_ID_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CLIP_ID_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_SURFACE_CLIP_ID_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CLIP_ID:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_DEPTH_BOUNDS_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_DEPTH_BOUNDS_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_DEPTH_BOUNDS_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_FLOAT_OPTION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ZERO_TIMES_ANYTHING_IS_ZERO = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_LOGIC_OP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_LOGIC_OP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_LOGIC_OP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_LOGIC_OP_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_LOGIC_OP_FUNC_V_CLEAR:
            fprintf(fp, "CLEAR\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_AND:
            fprintf(fp, "AND\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_AND_REVERSE:
            fprintf(fp, "AND_REVERSE\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_COPY:
            fprintf(fp, "COPY\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_AND_INVERTED:
            fprintf(fp, "AND_INVERTED\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_NOOP:
            fprintf(fp, "NOOP\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_XOR:
            fprintf(fp, "XOR\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_OR:
            fprintf(fp, "OR\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_NOR:
            fprintf(fp, "NOR\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_EQUIV:
            fprintf(fp, "EQUIV\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_INVERT:
            fprintf(fp, "INVERT\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_OR_REVERSE:
            fprintf(fp, "OR_REVERSE\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_COPY_INVERTED:
            fprintf(fp, "COPY_INVERTED\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_OR_INVERTED:
            fprintf(fp, "OR_INVERTED\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_NAND:
            fprintf(fp, "NAND\n");
            break;
        case NVA297_SET_LOGIC_OP_FUNC_V_SET:
            fprintf(fp, "SET\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_Z_COMPRESSION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_Z_COMPRESSION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_Z_COMPRESSION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_CLEAR_SURFACE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_SURFACE_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_SURFACE_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.STENCIL_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_SURFACE_STENCIL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_SURFACE_STENCIL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.R_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_SURFACE_R_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_SURFACE_R_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.G_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_SURFACE_G_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_SURFACE_G_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.B_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_SURFACE_B_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_SURFACE_B_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.A_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_CLEAR_SURFACE_A_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_CLEAR_SURFACE_A_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 4) - 1);
        fprintf(fp, "%s.MRT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 16) - 1);
        fprintf(fp, "%s.RT_ARRAY_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_CLEAR_CLIP_ID_SURFACE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_COMPRESSION(0):
    case NVA297_SET_COLOR_COMPRESSION(1):
    case NVA297_SET_COLOR_COMPRESSION(2):
    case NVA297_SET_COLOR_COMPRESSION(3):
    case NVA297_SET_COLOR_COMPRESSION(4):
    case NVA297_SET_COLOR_COMPRESSION(5):
    case NVA297_SET_COLOR_COMPRESSION(6):
    case NVA297_SET_COLOR_COMPRESSION(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_COMPRESSION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_COLOR_COMPRESSION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_CT_WRITE(0):
    case NVA297_SET_CT_WRITE(1):
    case NVA297_SET_CT_WRITE(2):
    case NVA297_SET_CT_WRITE(3):
    case NVA297_SET_CT_WRITE(4):
    case NVA297_SET_CT_WRITE(5):
    case NVA297_SET_CT_WRITE(6):
    case NVA297_SET_CT_WRITE(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.R_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_CT_WRITE_R_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CT_WRITE_R_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.G_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_CT_WRITE_G_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CT_WRITE_G_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.B_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_CT_WRITE_B_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CT_WRITE_B_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.A_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_CT_WRITE_A_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_CT_WRITE_A_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_PIPE_NOP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SPARE03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REPORT_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REPORT_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REPORT_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_REPORT_SEMAPHORE_D:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_OPERATION_REPORT_ONLY:
            fprintf(fp, "REPORT_ONLY\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE:
            fprintf(fp, "AFTER_ALL_PRECEEDING_READS_COMPLETE\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE:
            fprintf(fp, "AFTER_ALL_PRECEEDING_WRITES_COMPLETE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START:
            fprintf(fp, "BEFORE_ANY_FOLLOWING_WRITES_START\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START:
            fprintf(fp, "BEFORE_ANY_FOLLOWING_READS_START\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.PIPELINE_LOCATION = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DATA_ASSEMBLER:
            fprintf(fp, "DATA_ASSEMBLER\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VERTEX_SHADER:
            fprintf(fp, "VERTEX_SHADER\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_INIT_SHADER:
            fprintf(fp, "TESSELATION_INIT_SHADER\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_SHADER:
            fprintf(fp, "TESSELATION_SHADER\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_GEOMETRY_SHADER:
            fprintf(fp, "GEOMETRY_SHADER\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_STREAMING_OUTPUT:
            fprintf(fp, "STREAMING_OUTPUT\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VPC:
            fprintf(fp, "VPC\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ZCULL:
            fprintf(fp, "ZCULL\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_PIXEL_SHADER:
            fprintf(fp, "PIXEL_SHADER\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DEPTH_TEST:
            fprintf(fp, "DEPTH_TEST\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.COMPARISON = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_COMPARISON_EQ:
            fprintf(fp, "EQ\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_COMPARISON_GE:
            fprintf(fp, "GE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 23) & ((1u << 5) - 1);
        fprintf(fp, "%s.REPORT = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_DA_VERTICES_GENERATED:
            fprintf(fp, "DA_VERTICES_GENERATED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_DA_PRIMITIVES_GENERATED:
            fprintf(fp, "DA_PRIMITIVES_GENERATED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_VS_INVOCATIONS:
            fprintf(fp, "VS_INVOCATIONS\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_TI_INVOCATIONS:
            fprintf(fp, "TI_INVOCATIONS\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_TS_INVOCATIONS:
            fprintf(fp, "TS_INVOCATIONS\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_TS_PRIMITIVES_GENERATED:
            fprintf(fp, "TS_PRIMITIVES_GENERATED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_GS_INVOCATIONS:
            fprintf(fp, "GS_INVOCATIONS\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_GS_PRIMITIVES_GENERATED:
            fprintf(fp, "GS_PRIMITIVES_GENERATED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_ALPHA_BETA_CLOCKS:
            fprintf(fp, "ALPHA_BETA_CLOCKS\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_VTG_PRIMITIVES_OUT:
            fprintf(fp, "VTG_PRIMITIVES_OUT\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_SUCCEEDED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_BYTE_COUNT:
            fprintf(fp, "STREAMING_BYTE_COUNT\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_INVOCATIONS:
            fprintf(fp, "CLIPPER_INVOCATIONS\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_PRIMITIVES_GENERATED:
            fprintf(fp, "CLIPPER_PRIMITIVES_GENERATED\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS0:
            fprintf(fp, "ZCULL_STATS0\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS1:
            fprintf(fp, "ZCULL_STATS1\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS2:
            fprintf(fp, "ZCULL_STATS2\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS3:
            fprintf(fp, "ZCULL_STATS3\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_PS_INVOCATIONS:
            fprintf(fp, "PS_INVOCATIONS\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT:
            fprintf(fp, "ZPASS_PIXEL_CNT\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT64:
            fprintf(fp, "ZPASS_PIXEL_CNT64\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_COLOR_TARGET:
            fprintf(fp, "IEEE_CLEAN_COLOR_TARGET\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_ZETA_TARGET:
            fprintf(fp, "IEEE_CLEAN_ZETA_TARGET\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REPORT_BOUNDING_RECTANGLE:
            fprintf(fp, "BOUNDING_RECTANGLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 3) - 1);
        fprintf(fp, "%s.SUB_REPORT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.REPORT_DWORD_NUMBER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVA297_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(0):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(1):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(2):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(3):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(4):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(5):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(6):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(7):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(8):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(9):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(10):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(11):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(12):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(13):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(14):
    case NVA297_SET_VERTEX_STREAM_A_FORMAT(15):
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.STRIDE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_STREAM_A_FORMAT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VERTEX_STREAM_A_FORMAT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(0):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(1):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(2):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(3):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(4):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(5):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(6):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(7):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(8):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(9):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(10):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(11):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(12):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(13):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(14):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_A(15):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(0):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(1):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(2):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(3):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(4):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(5):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(6):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(7):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(8):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(9):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(10):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(11):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(12):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(13):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(14):
    case NVA297_SET_VERTEX_STREAM_A_LOCATION_B(15):
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(0):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(1):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(2):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(3):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(4):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(5):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(6):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(7):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(8):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(9):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(10):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(11):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(12):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(13):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(14):
    case NVA297_SET_VERTEX_STREAM_A_FREQUENCY(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(0):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(1):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(2):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(3):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(4):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(5):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(6):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(7):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(8):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(9):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(10):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(11):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(12):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(13):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(14):
    case NVA297_SET_VERTEX_STREAM_B_FORMAT(15):
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.STRIDE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_VERTEX_STREAM_B_FORMAT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_VERTEX_STREAM_B_FORMAT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(0):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(1):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(2):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(3):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(4):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(5):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(6):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(7):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(8):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(9):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(10):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(11):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(12):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(13):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(14):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_A(15):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(0):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(1):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(2):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(3):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(4):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(5):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(6):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(7):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(8):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(9):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(10):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(11):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(12):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(13):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(14):
    case NVA297_SET_VERTEX_STREAM_B_LOCATION_B(15):
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(0):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(1):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(2):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(3):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(4):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(5):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(6):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(7):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(8):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(9):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(10):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(11):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(12):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(13):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(14):
    case NVA297_SET_VERTEX_STREAM_B_FREQUENCY(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(0):
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(1):
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(2):
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(3):
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(4):
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(5):
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(6):
    case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(0):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(1):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(2):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(3):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(4):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(5):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(6):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_OP(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_SUBTRACT:
            fprintf(fp, "OGL_FUNC_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT:
            fprintf(fp, "OGL_FUNC_REVERSE_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_ADD:
            fprintf(fp, "OGL_FUNC_ADD\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MIN:
            fprintf(fp, "OGL_MIN\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MAX:
            fprintf(fp, "OGL_MAX\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_ADD:
            fprintf(fp, "D3D_ADD\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_SUBTRACT:
            fprintf(fp, "D3D_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_REVSUBTRACT:
            fprintf(fp, "D3D_REVSUBTRACT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MIN:
            fprintf(fp, "D3D_MIN\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MAX:
            fprintf(fp, "D3D_MAX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(0):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(1):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(2):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(3):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(4):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(5):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(6):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA:
            fprintf(fp, "D3D_BOTHSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA:
            fprintf(fp, "D3D_BOTHINVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(0):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(1):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(2):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(3):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(4):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(5):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(6):
    case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(0):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(1):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(2):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(3):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(4):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(5):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(6):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_SUBTRACT:
            fprintf(fp, "OGL_FUNC_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT:
            fprintf(fp, "OGL_FUNC_REVERSE_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_ADD:
            fprintf(fp, "OGL_FUNC_ADD\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MIN:
            fprintf(fp, "OGL_MIN\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MAX:
            fprintf(fp, "OGL_MAX\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_ADD:
            fprintf(fp, "D3D_ADD\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_SUBTRACT:
            fprintf(fp, "D3D_SUBTRACT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_REVSUBTRACT:
            fprintf(fp, "D3D_REVSUBTRACT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MIN:
            fprintf(fp, "D3D_MIN\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MAX:
            fprintf(fp, "D3D_MAX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(0):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(1):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(2):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(3):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(4):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(5):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(6):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA:
            fprintf(fp, "D3D_BOTHSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA:
            fprintf(fp, "D3D_BOTHINVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(0):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(1):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(2):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(3):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(4):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(5):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(6):
    case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVA297_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(0):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(1):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(2):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(3):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(4):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(5):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(6):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(7):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(8):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(9):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(10):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(11):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(12):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(13):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(14):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_A(15):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(0):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(1):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(2):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(3):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(4):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(5):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(6):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(7):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(8):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(9):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(10):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(11):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(12):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(13):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(14):
    case NVA297_SET_VERTEX_STREAM_LIMIT_A_B(15):
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(0):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(1):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(2):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(3):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(4):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(5):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(6):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(7):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(8):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(9):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(10):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(11):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(12):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(13):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(14):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_A(15):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(0):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(1):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(2):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(3):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(4):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(5):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(6):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(7):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(8):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(9):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(10):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(11):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(12):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(13):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(14):
    case NVA297_SET_VERTEX_STREAM_LIMIT_B_B(15):
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PIPELINE_SHADER(0):
    case NVA297_SET_PIPELINE_SHADER(1):
    case NVA297_SET_PIPELINE_SHADER(2):
    case NVA297_SET_PIPELINE_SHADER(3):
    case NVA297_SET_PIPELINE_SHADER(4):
    case NVA297_SET_PIPELINE_SHADER(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_PIPELINE_SHADER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_PIPELINE_SHADER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVA297_SET_PIPELINE_SHADER_TYPE_VERTEX_CULL_BEFORE_FETCH:
            fprintf(fp, "VERTEX_CULL_BEFORE_FETCH\n");
            break;
        case NVA297_SET_PIPELINE_SHADER_TYPE_VERTEX:
            fprintf(fp, "VERTEX\n");
            break;
        case NVA297_SET_PIPELINE_SHADER_TYPE_TESSELLATION_INIT:
            fprintf(fp, "TESSELLATION_INIT\n");
            break;
        case NVA297_SET_PIPELINE_SHADER_TYPE_TESSELLATION:
            fprintf(fp, "TESSELLATION\n");
            break;
        case NVA297_SET_PIPELINE_SHADER_TYPE_GEOMETRY:
            fprintf(fp, "GEOMETRY\n");
            break;
        case NVA297_SET_PIPELINE_SHADER_TYPE_PIXEL:
            fprintf(fp, "PIXEL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_PIPELINE_PROGRAM(0):
    case NVA297_SET_PIPELINE_PROGRAM(1):
    case NVA297_SET_PIPELINE_PROGRAM(2):
    case NVA297_SET_PIPELINE_PROGRAM(3):
    case NVA297_SET_PIPELINE_PROGRAM(4):
    case NVA297_SET_PIPELINE_PROGRAM(5):
    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PIPELINE_RESERVED_A(0):
    case NVA297_SET_PIPELINE_RESERVED_A(1):
    case NVA297_SET_PIPELINE_RESERVED_A(2):
    case NVA297_SET_PIPELINE_RESERVED_A(3):
    case NVA297_SET_PIPELINE_RESERVED_A(4):
    case NVA297_SET_PIPELINE_RESERVED_A(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PIPELINE_REGISTER_COUNT(0):
    case NVA297_SET_PIPELINE_REGISTER_COUNT(1):
    case NVA297_SET_PIPELINE_REGISTER_COUNT(2):
    case NVA297_SET_PIPELINE_REGISTER_COUNT(3):
    case NVA297_SET_PIPELINE_REGISTER_COUNT(4):
    case NVA297_SET_PIPELINE_REGISTER_COUNT(5):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PIPELINE_BINDING(0):
    case NVA297_SET_PIPELINE_BINDING(1):
    case NVA297_SET_PIPELINE_BINDING(2):
    case NVA297_SET_PIPELINE_BINDING(3):
    case NVA297_SET_PIPELINE_BINDING(4):
    case NVA297_SET_PIPELINE_BINDING(5):
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.GROUP = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PIPELINE_RESERVED_B(0):
    case NVA297_SET_PIPELINE_RESERVED_B(1):
    case NVA297_SET_PIPELINE_RESERVED_B(2):
    case NVA297_SET_PIPELINE_RESERVED_B(3):
    case NVA297_SET_PIPELINE_RESERVED_B(4):
    case NVA297_SET_PIPELINE_RESERVED_B(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PIPELINE_RESERVED_C(0):
    case NVA297_SET_PIPELINE_RESERVED_C(1):
    case NVA297_SET_PIPELINE_RESERVED_C(2):
    case NVA297_SET_PIPELINE_RESERVED_C(3):
    case NVA297_SET_PIPELINE_RESERVED_C(4):
    case NVA297_SET_PIPELINE_RESERVED_C(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PIPELINE_RESERVED_D(0):
    case NVA297_SET_PIPELINE_RESERVED_D(1):
    case NVA297_SET_PIPELINE_RESERVED_D(2):
    case NVA297_SET_PIPELINE_RESERVED_D(3):
    case NVA297_SET_PIPELINE_RESERVED_D(4):
    case NVA297_SET_PIPELINE_RESERVED_D(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_PIPELINE_RESERVED_E(0):
    case NVA297_SET_PIPELINE_RESERVED_E(1):
    case NVA297_SET_PIPELINE_RESERVED_E(2):
    case NVA297_SET_PIPELINE_RESERVED_E(3):
    case NVA297_SET_PIPELINE_RESERVED_E(4):
    case NVA297_SET_PIPELINE_RESERVED_E(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON16:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON17:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON18:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON19:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON20:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON21:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON22:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON23:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON24:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON25:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON26:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON27:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON28:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON29:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON30:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_FALCON31:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CONSTANT_BUFFER_SELECTOR_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CONSTANT_BUFFER_SELECTOR_B:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_CONSTANT_BUFFER_SELECTOR_C:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LOAD_CONSTANT_BUFFER_OFFSET:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_LOAD_CONSTANT_BUFFER(0):
    case NVA297_LOAD_CONSTANT_BUFFER(1):
    case NVA297_LOAD_CONSTANT_BUFFER(2):
    case NVA297_LOAD_CONSTANT_BUFFER(3):
    case NVA297_LOAD_CONSTANT_BUFFER(4):
    case NVA297_LOAD_CONSTANT_BUFFER(5):
    case NVA297_LOAD_CONSTANT_BUFFER(6):
    case NVA297_LOAD_CONSTANT_BUFFER(7):
    case NVA297_LOAD_CONSTANT_BUFFER(8):
    case NVA297_LOAD_CONSTANT_BUFFER(9):
    case NVA297_LOAD_CONSTANT_BUFFER(10):
    case NVA297_LOAD_CONSTANT_BUFFER(11):
    case NVA297_LOAD_CONSTANT_BUFFER(12):
    case NVA297_LOAD_CONSTANT_BUFFER(13):
    case NVA297_LOAD_CONSTANT_BUFFER(14):
    case NVA297_LOAD_CONSTANT_BUFFER(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                    case NVA297_BIND_GROUP_CONSTANT_BUFFER(0):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(1):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(2):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(3):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(4):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(5):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(6):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(7):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(8):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(9):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(10):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(11):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(12):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(13):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(14):
    case NVA297_BIND_GROUP_CONSTANT_BUFFER(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.VALID = ", prefix);
        switch (parsed) {
        case NVA297_BIND_GROUP_CONSTANT_BUFFER_VALID_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_BIND_GROUP_CONSTANT_BUFFER_VALID_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 5) - 1);
        fprintf(fp, "%s.SHADER_SLOT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_COLOR_CLAMP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVA297_SET_COLOR_CLAMP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVA297_SET_COLOR_CLAMP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_NOOP_X_X_X_SET_VALVE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.HIGHER_PRIORITY = ", prefix);
        switch (parsed) {
        case NVA297_NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY_COMPUTE:
            fprintf(fp, "COMPUTE\n");
            break;
        case NVA297_NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY_GRAPHICS:
            fprintf(fp, "GRAPHICS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVA297_SET_BINDLESS_TEXTURE:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.CONSTANT_BUFFER_SLOT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_TRAP_HANDLER:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.EVENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 15) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 22) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 25) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPARE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.EDGE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 1) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.WINDOWED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 16) - 1);
        fprintf(fp, "%s.FUNC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_SET_MME_SHADOW_SCRATCH(0):
    case NVA297_SET_MME_SHADOW_SCRATCH(1):
    case NVA297_SET_MME_SHADOW_SCRATCH(2):
    case NVA297_SET_MME_SHADOW_SCRATCH(3):
    case NVA297_SET_MME_SHADOW_SCRATCH(4):
    case NVA297_SET_MME_SHADOW_SCRATCH(5):
    case NVA297_SET_MME_SHADOW_SCRATCH(6):
    case NVA297_SET_MME_SHADOW_SCRATCH(7):
    case NVA297_SET_MME_SHADOW_SCRATCH(8):
    case NVA297_SET_MME_SHADOW_SCRATCH(9):
    case NVA297_SET_MME_SHADOW_SCRATCH(10):
    case NVA297_SET_MME_SHADOW_SCRATCH(11):
    case NVA297_SET_MME_SHADOW_SCRATCH(12):
    case NVA297_SET_MME_SHADOW_SCRATCH(13):
    case NVA297_SET_MME_SHADOW_SCRATCH(14):
    case NVA297_SET_MME_SHADOW_SCRATCH(15):
    case NVA297_SET_MME_SHADOW_SCRATCH(16):
    case NVA297_SET_MME_SHADOW_SCRATCH(17):
    case NVA297_SET_MME_SHADOW_SCRATCH(18):
    case NVA297_SET_MME_SHADOW_SCRATCH(19):
    case NVA297_SET_MME_SHADOW_SCRATCH(20):
    case NVA297_SET_MME_SHADOW_SCRATCH(21):
    case NVA297_SET_MME_SHADOW_SCRATCH(22):
    case NVA297_SET_MME_SHADOW_SCRATCH(23):
    case NVA297_SET_MME_SHADOW_SCRATCH(24):
    case NVA297_SET_MME_SHADOW_SCRATCH(25):
    case NVA297_SET_MME_SHADOW_SCRATCH(26):
    case NVA297_SET_MME_SHADOW_SCRATCH(27):
    case NVA297_SET_MME_SHADOW_SCRATCH(28):
    case NVA297_SET_MME_SHADOW_SCRATCH(29):
    case NVA297_SET_MME_SHADOW_SCRATCH(30):
    case NVA297_SET_MME_SHADOW_SCRATCH(31):
    case NVA297_SET_MME_SHADOW_SCRATCH(32):
    case NVA297_SET_MME_SHADOW_SCRATCH(33):
    case NVA297_SET_MME_SHADOW_SCRATCH(34):
    case NVA297_SET_MME_SHADOW_SCRATCH(35):
    case NVA297_SET_MME_SHADOW_SCRATCH(36):
    case NVA297_SET_MME_SHADOW_SCRATCH(37):
    case NVA297_SET_MME_SHADOW_SCRATCH(38):
    case NVA297_SET_MME_SHADOW_SCRATCH(39):
    case NVA297_SET_MME_SHADOW_SCRATCH(40):
    case NVA297_SET_MME_SHADOW_SCRATCH(41):
    case NVA297_SET_MME_SHADOW_SCRATCH(42):
    case NVA297_SET_MME_SHADOW_SCRATCH(43):
    case NVA297_SET_MME_SHADOW_SCRATCH(44):
    case NVA297_SET_MME_SHADOW_SCRATCH(45):
    case NVA297_SET_MME_SHADOW_SCRATCH(46):
    case NVA297_SET_MME_SHADOW_SCRATCH(47):
    case NVA297_SET_MME_SHADOW_SCRATCH(48):
    case NVA297_SET_MME_SHADOW_SCRATCH(49):
    case NVA297_SET_MME_SHADOW_SCRATCH(50):
    case NVA297_SET_MME_SHADOW_SCRATCH(51):
    case NVA297_SET_MME_SHADOW_SCRATCH(52):
    case NVA297_SET_MME_SHADOW_SCRATCH(53):
    case NVA297_SET_MME_SHADOW_SCRATCH(54):
    case NVA297_SET_MME_SHADOW_SCRATCH(55):
    case NVA297_SET_MME_SHADOW_SCRATCH(56):
    case NVA297_SET_MME_SHADOW_SCRATCH(57):
    case NVA297_SET_MME_SHADOW_SCRATCH(58):
    case NVA297_SET_MME_SHADOW_SCRATCH(59):
    case NVA297_SET_MME_SHADOW_SCRATCH(60):
    case NVA297_SET_MME_SHADOW_SCRATCH(61):
    case NVA297_SET_MME_SHADOW_SCRATCH(62):
    case NVA297_SET_MME_SHADOW_SCRATCH(63):
    case NVA297_SET_MME_SHADOW_SCRATCH(64):
    case NVA297_SET_MME_SHADOW_SCRATCH(65):
    case NVA297_SET_MME_SHADOW_SCRATCH(66):
    case NVA297_SET_MME_SHADOW_SCRATCH(67):
    case NVA297_SET_MME_SHADOW_SCRATCH(68):
    case NVA297_SET_MME_SHADOW_SCRATCH(69):
    case NVA297_SET_MME_SHADOW_SCRATCH(70):
    case NVA297_SET_MME_SHADOW_SCRATCH(71):
    case NVA297_SET_MME_SHADOW_SCRATCH(72):
    case NVA297_SET_MME_SHADOW_SCRATCH(73):
    case NVA297_SET_MME_SHADOW_SCRATCH(74):
    case NVA297_SET_MME_SHADOW_SCRATCH(75):
    case NVA297_SET_MME_SHADOW_SCRATCH(76):
    case NVA297_SET_MME_SHADOW_SCRATCH(77):
    case NVA297_SET_MME_SHADOW_SCRATCH(78):
    case NVA297_SET_MME_SHADOW_SCRATCH(79):
    case NVA297_SET_MME_SHADOW_SCRATCH(80):
    case NVA297_SET_MME_SHADOW_SCRATCH(81):
    case NVA297_SET_MME_SHADOW_SCRATCH(82):
    case NVA297_SET_MME_SHADOW_SCRATCH(83):
    case NVA297_SET_MME_SHADOW_SCRATCH(84):
    case NVA297_SET_MME_SHADOW_SCRATCH(85):
    case NVA297_SET_MME_SHADOW_SCRATCH(86):
    case NVA297_SET_MME_SHADOW_SCRATCH(87):
    case NVA297_SET_MME_SHADOW_SCRATCH(88):
    case NVA297_SET_MME_SHADOW_SCRATCH(89):
    case NVA297_SET_MME_SHADOW_SCRATCH(90):
    case NVA297_SET_MME_SHADOW_SCRATCH(91):
    case NVA297_SET_MME_SHADOW_SCRATCH(92):
    case NVA297_SET_MME_SHADOW_SCRATCH(93):
    case NVA297_SET_MME_SHADOW_SCRATCH(94):
    case NVA297_SET_MME_SHADOW_SCRATCH(95):
    case NVA297_SET_MME_SHADOW_SCRATCH(96):
    case NVA297_SET_MME_SHADOW_SCRATCH(97):
    case NVA297_SET_MME_SHADOW_SCRATCH(98):
    case NVA297_SET_MME_SHADOW_SCRATCH(99):
    case NVA297_SET_MME_SHADOW_SCRATCH(100):
    case NVA297_SET_MME_SHADOW_SCRATCH(101):
    case NVA297_SET_MME_SHADOW_SCRATCH(102):
    case NVA297_SET_MME_SHADOW_SCRATCH(103):
    case NVA297_SET_MME_SHADOW_SCRATCH(104):
    case NVA297_SET_MME_SHADOW_SCRATCH(105):
    case NVA297_SET_MME_SHADOW_SCRATCH(106):
    case NVA297_SET_MME_SHADOW_SCRATCH(107):
    case NVA297_SET_MME_SHADOW_SCRATCH(108):
    case NVA297_SET_MME_SHADOW_SCRATCH(109):
    case NVA297_SET_MME_SHADOW_SCRATCH(110):
    case NVA297_SET_MME_SHADOW_SCRATCH(111):
    case NVA297_SET_MME_SHADOW_SCRATCH(112):
    case NVA297_SET_MME_SHADOW_SCRATCH(113):
    case NVA297_SET_MME_SHADOW_SCRATCH(114):
    case NVA297_SET_MME_SHADOW_SCRATCH(115):
    case NVA297_SET_MME_SHADOW_SCRATCH(116):
    case NVA297_SET_MME_SHADOW_SCRATCH(117):
    case NVA297_SET_MME_SHADOW_SCRATCH(118):
    case NVA297_SET_MME_SHADOW_SCRATCH(119):
    case NVA297_SET_MME_SHADOW_SCRATCH(120):
    case NVA297_SET_MME_SHADOW_SCRATCH(121):
    case NVA297_SET_MME_SHADOW_SCRATCH(122):
    case NVA297_SET_MME_SHADOW_SCRATCH(123):
    case NVA297_SET_MME_SHADOW_SCRATCH(124):
    case NVA297_SET_MME_SHADOW_SCRATCH(125):
    case NVA297_SET_MME_SHADOW_SCRATCH(126):
    case NVA297_SET_MME_SHADOW_SCRATCH(127):
    case NVA297_SET_MME_SHADOW_SCRATCH(128):
    case NVA297_SET_MME_SHADOW_SCRATCH(129):
    case NVA297_SET_MME_SHADOW_SCRATCH(130):
    case NVA297_SET_MME_SHADOW_SCRATCH(131):
    case NVA297_SET_MME_SHADOW_SCRATCH(132):
    case NVA297_SET_MME_SHADOW_SCRATCH(133):
    case NVA297_SET_MME_SHADOW_SCRATCH(134):
    case NVA297_SET_MME_SHADOW_SCRATCH(135):
    case NVA297_SET_MME_SHADOW_SCRATCH(136):
    case NVA297_SET_MME_SHADOW_SCRATCH(137):
    case NVA297_SET_MME_SHADOW_SCRATCH(138):
    case NVA297_SET_MME_SHADOW_SCRATCH(139):
    case NVA297_SET_MME_SHADOW_SCRATCH(140):
    case NVA297_SET_MME_SHADOW_SCRATCH(141):
    case NVA297_SET_MME_SHADOW_SCRATCH(142):
    case NVA297_SET_MME_SHADOW_SCRATCH(143):
    case NVA297_SET_MME_SHADOW_SCRATCH(144):
    case NVA297_SET_MME_SHADOW_SCRATCH(145):
    case NVA297_SET_MME_SHADOW_SCRATCH(146):
    case NVA297_SET_MME_SHADOW_SCRATCH(147):
    case NVA297_SET_MME_SHADOW_SCRATCH(148):
    case NVA297_SET_MME_SHADOW_SCRATCH(149):
    case NVA297_SET_MME_SHADOW_SCRATCH(150):
    case NVA297_SET_MME_SHADOW_SCRATCH(151):
    case NVA297_SET_MME_SHADOW_SCRATCH(152):
    case NVA297_SET_MME_SHADOW_SCRATCH(153):
    case NVA297_SET_MME_SHADOW_SCRATCH(154):
    case NVA297_SET_MME_SHADOW_SCRATCH(155):
    case NVA297_SET_MME_SHADOW_SCRATCH(156):
    case NVA297_SET_MME_SHADOW_SCRATCH(157):
    case NVA297_SET_MME_SHADOW_SCRATCH(158):
    case NVA297_SET_MME_SHADOW_SCRATCH(159):
    case NVA297_SET_MME_SHADOW_SCRATCH(160):
    case NVA297_SET_MME_SHADOW_SCRATCH(161):
    case NVA297_SET_MME_SHADOW_SCRATCH(162):
    case NVA297_SET_MME_SHADOW_SCRATCH(163):
    case NVA297_SET_MME_SHADOW_SCRATCH(164):
    case NVA297_SET_MME_SHADOW_SCRATCH(165):
    case NVA297_SET_MME_SHADOW_SCRATCH(166):
    case NVA297_SET_MME_SHADOW_SCRATCH(167):
    case NVA297_SET_MME_SHADOW_SCRATCH(168):
    case NVA297_SET_MME_SHADOW_SCRATCH(169):
    case NVA297_SET_MME_SHADOW_SCRATCH(170):
    case NVA297_SET_MME_SHADOW_SCRATCH(171):
    case NVA297_SET_MME_SHADOW_SCRATCH(172):
    case NVA297_SET_MME_SHADOW_SCRATCH(173):
    case NVA297_SET_MME_SHADOW_SCRATCH(174):
    case NVA297_SET_MME_SHADOW_SCRATCH(175):
    case NVA297_SET_MME_SHADOW_SCRATCH(176):
    case NVA297_SET_MME_SHADOW_SCRATCH(177):
    case NVA297_SET_MME_SHADOW_SCRATCH(178):
    case NVA297_SET_MME_SHADOW_SCRATCH(179):
    case NVA297_SET_MME_SHADOW_SCRATCH(180):
    case NVA297_SET_MME_SHADOW_SCRATCH(181):
    case NVA297_SET_MME_SHADOW_SCRATCH(182):
    case NVA297_SET_MME_SHADOW_SCRATCH(183):
    case NVA297_SET_MME_SHADOW_SCRATCH(184):
    case NVA297_SET_MME_SHADOW_SCRATCH(185):
    case NVA297_SET_MME_SHADOW_SCRATCH(186):
    case NVA297_SET_MME_SHADOW_SCRATCH(187):
    case NVA297_SET_MME_SHADOW_SCRATCH(188):
    case NVA297_SET_MME_SHADOW_SCRATCH(189):
    case NVA297_SET_MME_SHADOW_SCRATCH(190):
    case NVA297_SET_MME_SHADOW_SCRATCH(191):
    case NVA297_SET_MME_SHADOW_SCRATCH(192):
    case NVA297_SET_MME_SHADOW_SCRATCH(193):
    case NVA297_SET_MME_SHADOW_SCRATCH(194):
    case NVA297_SET_MME_SHADOW_SCRATCH(195):
    case NVA297_SET_MME_SHADOW_SCRATCH(196):
    case NVA297_SET_MME_SHADOW_SCRATCH(197):
    case NVA297_SET_MME_SHADOW_SCRATCH(198):
    case NVA297_SET_MME_SHADOW_SCRATCH(199):
    case NVA297_SET_MME_SHADOW_SCRATCH(200):
    case NVA297_SET_MME_SHADOW_SCRATCH(201):
    case NVA297_SET_MME_SHADOW_SCRATCH(202):
    case NVA297_SET_MME_SHADOW_SCRATCH(203):
    case NVA297_SET_MME_SHADOW_SCRATCH(204):
    case NVA297_SET_MME_SHADOW_SCRATCH(205):
    case NVA297_SET_MME_SHADOW_SCRATCH(206):
    case NVA297_SET_MME_SHADOW_SCRATCH(207):
    case NVA297_SET_MME_SHADOW_SCRATCH(208):
    case NVA297_SET_MME_SHADOW_SCRATCH(209):
    case NVA297_SET_MME_SHADOW_SCRATCH(210):
    case NVA297_SET_MME_SHADOW_SCRATCH(211):
    case NVA297_SET_MME_SHADOW_SCRATCH(212):
    case NVA297_SET_MME_SHADOW_SCRATCH(213):
    case NVA297_SET_MME_SHADOW_SCRATCH(214):
    case NVA297_SET_MME_SHADOW_SCRATCH(215):
    case NVA297_SET_MME_SHADOW_SCRATCH(216):
    case NVA297_SET_MME_SHADOW_SCRATCH(217):
    case NVA297_SET_MME_SHADOW_SCRATCH(218):
    case NVA297_SET_MME_SHADOW_SCRATCH(219):
    case NVA297_SET_MME_SHADOW_SCRATCH(220):
    case NVA297_SET_MME_SHADOW_SCRATCH(221):
    case NVA297_SET_MME_SHADOW_SCRATCH(222):
    case NVA297_SET_MME_SHADOW_SCRATCH(223):
    case NVA297_SET_MME_SHADOW_SCRATCH(224):
    case NVA297_SET_MME_SHADOW_SCRATCH(225):
    case NVA297_SET_MME_SHADOW_SCRATCH(226):
    case NVA297_SET_MME_SHADOW_SCRATCH(227):
    case NVA297_SET_MME_SHADOW_SCRATCH(228):
    case NVA297_SET_MME_SHADOW_SCRATCH(229):
    case NVA297_SET_MME_SHADOW_SCRATCH(230):
    case NVA297_SET_MME_SHADOW_SCRATCH(231):
    case NVA297_SET_MME_SHADOW_SCRATCH(232):
    case NVA297_SET_MME_SHADOW_SCRATCH(233):
    case NVA297_SET_MME_SHADOW_SCRATCH(234):
    case NVA297_SET_MME_SHADOW_SCRATCH(235):
    case NVA297_SET_MME_SHADOW_SCRATCH(236):
    case NVA297_SET_MME_SHADOW_SCRATCH(237):
    case NVA297_SET_MME_SHADOW_SCRATCH(238):
    case NVA297_SET_MME_SHADOW_SCRATCH(239):
    case NVA297_SET_MME_SHADOW_SCRATCH(240):
    case NVA297_SET_MME_SHADOW_SCRATCH(241):
    case NVA297_SET_MME_SHADOW_SCRATCH(242):
    case NVA297_SET_MME_SHADOW_SCRATCH(243):
    case NVA297_SET_MME_SHADOW_SCRATCH(244):
    case NVA297_SET_MME_SHADOW_SCRATCH(245):
    case NVA297_SET_MME_SHADOW_SCRATCH(246):
    case NVA297_SET_MME_SHADOW_SCRATCH(247):
    case NVA297_SET_MME_SHADOW_SCRATCH(248):
    case NVA297_SET_MME_SHADOW_SCRATCH(249):
    case NVA297_SET_MME_SHADOW_SCRATCH(250):
    case NVA297_SET_MME_SHADOW_SCRATCH(251):
    case NVA297_SET_MME_SHADOW_SCRATCH(252):
    case NVA297_SET_MME_SHADOW_SCRATCH(253):
    case NVA297_SET_MME_SHADOW_SCRATCH(254):
    case NVA297_SET_MME_SHADOW_SCRATCH(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_CALL_MME_MACRO(0):
    case NVA297_CALL_MME_MACRO(1):
    case NVA297_CALL_MME_MACRO(2):
    case NVA297_CALL_MME_MACRO(3):
    case NVA297_CALL_MME_MACRO(4):
    case NVA297_CALL_MME_MACRO(5):
    case NVA297_CALL_MME_MACRO(6):
    case NVA297_CALL_MME_MACRO(7):
    case NVA297_CALL_MME_MACRO(8):
    case NVA297_CALL_MME_MACRO(9):
    case NVA297_CALL_MME_MACRO(10):
    case NVA297_CALL_MME_MACRO(11):
    case NVA297_CALL_MME_MACRO(12):
    case NVA297_CALL_MME_MACRO(13):
    case NVA297_CALL_MME_MACRO(14):
    case NVA297_CALL_MME_MACRO(15):
    case NVA297_CALL_MME_MACRO(16):
    case NVA297_CALL_MME_MACRO(17):
    case NVA297_CALL_MME_MACRO(18):
    case NVA297_CALL_MME_MACRO(19):
    case NVA297_CALL_MME_MACRO(20):
    case NVA297_CALL_MME_MACRO(21):
    case NVA297_CALL_MME_MACRO(22):
    case NVA297_CALL_MME_MACRO(23):
    case NVA297_CALL_MME_MACRO(24):
    case NVA297_CALL_MME_MACRO(25):
    case NVA297_CALL_MME_MACRO(26):
    case NVA297_CALL_MME_MACRO(27):
    case NVA297_CALL_MME_MACRO(28):
    case NVA297_CALL_MME_MACRO(29):
    case NVA297_CALL_MME_MACRO(30):
    case NVA297_CALL_MME_MACRO(31):
    case NVA297_CALL_MME_MACRO(32):
    case NVA297_CALL_MME_MACRO(33):
    case NVA297_CALL_MME_MACRO(34):
    case NVA297_CALL_MME_MACRO(35):
    case NVA297_CALL_MME_MACRO(36):
    case NVA297_CALL_MME_MACRO(37):
    case NVA297_CALL_MME_MACRO(38):
    case NVA297_CALL_MME_MACRO(39):
    case NVA297_CALL_MME_MACRO(40):
    case NVA297_CALL_MME_MACRO(41):
    case NVA297_CALL_MME_MACRO(42):
    case NVA297_CALL_MME_MACRO(43):
    case NVA297_CALL_MME_MACRO(44):
    case NVA297_CALL_MME_MACRO(45):
    case NVA297_CALL_MME_MACRO(46):
    case NVA297_CALL_MME_MACRO(47):
    case NVA297_CALL_MME_MACRO(48):
    case NVA297_CALL_MME_MACRO(49):
    case NVA297_CALL_MME_MACRO(50):
    case NVA297_CALL_MME_MACRO(51):
    case NVA297_CALL_MME_MACRO(52):
    case NVA297_CALL_MME_MACRO(53):
    case NVA297_CALL_MME_MACRO(54):
    case NVA297_CALL_MME_MACRO(55):
    case NVA297_CALL_MME_MACRO(56):
    case NVA297_CALL_MME_MACRO(57):
    case NVA297_CALL_MME_MACRO(58):
    case NVA297_CALL_MME_MACRO(59):
    case NVA297_CALL_MME_MACRO(60):
    case NVA297_CALL_MME_MACRO(61):
    case NVA297_CALL_MME_MACRO(62):
    case NVA297_CALL_MME_MACRO(63):
    case NVA297_CALL_MME_MACRO(64):
    case NVA297_CALL_MME_MACRO(65):
    case NVA297_CALL_MME_MACRO(66):
    case NVA297_CALL_MME_MACRO(67):
    case NVA297_CALL_MME_MACRO(68):
    case NVA297_CALL_MME_MACRO(69):
    case NVA297_CALL_MME_MACRO(70):
    case NVA297_CALL_MME_MACRO(71):
    case NVA297_CALL_MME_MACRO(72):
    case NVA297_CALL_MME_MACRO(73):
    case NVA297_CALL_MME_MACRO(74):
    case NVA297_CALL_MME_MACRO(75):
    case NVA297_CALL_MME_MACRO(76):
    case NVA297_CALL_MME_MACRO(77):
    case NVA297_CALL_MME_MACRO(78):
    case NVA297_CALL_MME_MACRO(79):
    case NVA297_CALL_MME_MACRO(80):
    case NVA297_CALL_MME_MACRO(81):
    case NVA297_CALL_MME_MACRO(82):
    case NVA297_CALL_MME_MACRO(83):
    case NVA297_CALL_MME_MACRO(84):
    case NVA297_CALL_MME_MACRO(85):
    case NVA297_CALL_MME_MACRO(86):
    case NVA297_CALL_MME_MACRO(87):
    case NVA297_CALL_MME_MACRO(88):
    case NVA297_CALL_MME_MACRO(89):
    case NVA297_CALL_MME_MACRO(90):
    case NVA297_CALL_MME_MACRO(91):
    case NVA297_CALL_MME_MACRO(92):
    case NVA297_CALL_MME_MACRO(93):
    case NVA297_CALL_MME_MACRO(94):
    case NVA297_CALL_MME_MACRO(95):
    case NVA297_CALL_MME_MACRO(96):
    case NVA297_CALL_MME_MACRO(97):
    case NVA297_CALL_MME_MACRO(98):
    case NVA297_CALL_MME_MACRO(99):
    case NVA297_CALL_MME_MACRO(100):
    case NVA297_CALL_MME_MACRO(101):
    case NVA297_CALL_MME_MACRO(102):
    case NVA297_CALL_MME_MACRO(103):
    case NVA297_CALL_MME_MACRO(104):
    case NVA297_CALL_MME_MACRO(105):
    case NVA297_CALL_MME_MACRO(106):
    case NVA297_CALL_MME_MACRO(107):
    case NVA297_CALL_MME_MACRO(108):
    case NVA297_CALL_MME_MACRO(109):
    case NVA297_CALL_MME_MACRO(110):
    case NVA297_CALL_MME_MACRO(111):
    case NVA297_CALL_MME_MACRO(112):
    case NVA297_CALL_MME_MACRO(113):
    case NVA297_CALL_MME_MACRO(114):
    case NVA297_CALL_MME_MACRO(115):
    case NVA297_CALL_MME_MACRO(116):
    case NVA297_CALL_MME_MACRO(117):
    case NVA297_CALL_MME_MACRO(118):
    case NVA297_CALL_MME_MACRO(119):
    case NVA297_CALL_MME_MACRO(120):
    case NVA297_CALL_MME_MACRO(121):
    case NVA297_CALL_MME_MACRO(122):
    case NVA297_CALL_MME_MACRO(123):
    case NVA297_CALL_MME_MACRO(124):
    case NVA297_CALL_MME_MACRO(125):
    case NVA297_CALL_MME_MACRO(126):
    case NVA297_CALL_MME_MACRO(127):
    case NVA297_CALL_MME_MACRO(128):
    case NVA297_CALL_MME_MACRO(129):
    case NVA297_CALL_MME_MACRO(130):
    case NVA297_CALL_MME_MACRO(131):
    case NVA297_CALL_MME_MACRO(132):
    case NVA297_CALL_MME_MACRO(133):
    case NVA297_CALL_MME_MACRO(134):
    case NVA297_CALL_MME_MACRO(135):
    case NVA297_CALL_MME_MACRO(136):
    case NVA297_CALL_MME_MACRO(137):
    case NVA297_CALL_MME_MACRO(138):
    case NVA297_CALL_MME_MACRO(139):
    case NVA297_CALL_MME_MACRO(140):
    case NVA297_CALL_MME_MACRO(141):
    case NVA297_CALL_MME_MACRO(142):
    case NVA297_CALL_MME_MACRO(143):
    case NVA297_CALL_MME_MACRO(144):
    case NVA297_CALL_MME_MACRO(145):
    case NVA297_CALL_MME_MACRO(146):
    case NVA297_CALL_MME_MACRO(147):
    case NVA297_CALL_MME_MACRO(148):
    case NVA297_CALL_MME_MACRO(149):
    case NVA297_CALL_MME_MACRO(150):
    case NVA297_CALL_MME_MACRO(151):
    case NVA297_CALL_MME_MACRO(152):
    case NVA297_CALL_MME_MACRO(153):
    case NVA297_CALL_MME_MACRO(154):
    case NVA297_CALL_MME_MACRO(155):
    case NVA297_CALL_MME_MACRO(156):
    case NVA297_CALL_MME_MACRO(157):
    case NVA297_CALL_MME_MACRO(158):
    case NVA297_CALL_MME_MACRO(159):
    case NVA297_CALL_MME_MACRO(160):
    case NVA297_CALL_MME_MACRO(161):
    case NVA297_CALL_MME_MACRO(162):
    case NVA297_CALL_MME_MACRO(163):
    case NVA297_CALL_MME_MACRO(164):
    case NVA297_CALL_MME_MACRO(165):
    case NVA297_CALL_MME_MACRO(166):
    case NVA297_CALL_MME_MACRO(167):
    case NVA297_CALL_MME_MACRO(168):
    case NVA297_CALL_MME_MACRO(169):
    case NVA297_CALL_MME_MACRO(170):
    case NVA297_CALL_MME_MACRO(171):
    case NVA297_CALL_MME_MACRO(172):
    case NVA297_CALL_MME_MACRO(173):
    case NVA297_CALL_MME_MACRO(174):
    case NVA297_CALL_MME_MACRO(175):
    case NVA297_CALL_MME_MACRO(176):
    case NVA297_CALL_MME_MACRO(177):
    case NVA297_CALL_MME_MACRO(178):
    case NVA297_CALL_MME_MACRO(179):
    case NVA297_CALL_MME_MACRO(180):
    case NVA297_CALL_MME_MACRO(181):
    case NVA297_CALL_MME_MACRO(182):
    case NVA297_CALL_MME_MACRO(183):
    case NVA297_CALL_MME_MACRO(184):
    case NVA297_CALL_MME_MACRO(185):
    case NVA297_CALL_MME_MACRO(186):
    case NVA297_CALL_MME_MACRO(187):
    case NVA297_CALL_MME_MACRO(188):
    case NVA297_CALL_MME_MACRO(189):
    case NVA297_CALL_MME_MACRO(190):
    case NVA297_CALL_MME_MACRO(191):
    case NVA297_CALL_MME_MACRO(192):
    case NVA297_CALL_MME_MACRO(193):
    case NVA297_CALL_MME_MACRO(194):
    case NVA297_CALL_MME_MACRO(195):
    case NVA297_CALL_MME_MACRO(196):
    case NVA297_CALL_MME_MACRO(197):
    case NVA297_CALL_MME_MACRO(198):
    case NVA297_CALL_MME_MACRO(199):
    case NVA297_CALL_MME_MACRO(200):
    case NVA297_CALL_MME_MACRO(201):
    case NVA297_CALL_MME_MACRO(202):
    case NVA297_CALL_MME_MACRO(203):
    case NVA297_CALL_MME_MACRO(204):
    case NVA297_CALL_MME_MACRO(205):
    case NVA297_CALL_MME_MACRO(206):
    case NVA297_CALL_MME_MACRO(207):
    case NVA297_CALL_MME_MACRO(208):
    case NVA297_CALL_MME_MACRO(209):
    case NVA297_CALL_MME_MACRO(210):
    case NVA297_CALL_MME_MACRO(211):
    case NVA297_CALL_MME_MACRO(212):
    case NVA297_CALL_MME_MACRO(213):
    case NVA297_CALL_MME_MACRO(214):
    case NVA297_CALL_MME_MACRO(215):
    case NVA297_CALL_MME_MACRO(216):
    case NVA297_CALL_MME_MACRO(217):
    case NVA297_CALL_MME_MACRO(218):
    case NVA297_CALL_MME_MACRO(219):
    case NVA297_CALL_MME_MACRO(220):
    case NVA297_CALL_MME_MACRO(221):
    case NVA297_CALL_MME_MACRO(222):
    case NVA297_CALL_MME_MACRO(223):
    case NVA297_CALL_MME_MACRO(224):
    case NVA297_CALL_MME_MACRO(225):
    case NVA297_CALL_MME_MACRO(226):
    case NVA297_CALL_MME_MACRO(227):
    case NVA297_CALL_MME_MACRO(228):
    case NVA297_CALL_MME_MACRO(229):
    case NVA297_CALL_MME_MACRO(230):
    case NVA297_CALL_MME_MACRO(231):
    case NVA297_CALL_MME_MACRO(232):
    case NVA297_CALL_MME_MACRO(233):
    case NVA297_CALL_MME_MACRO(234):
    case NVA297_CALL_MME_MACRO(235):
    case NVA297_CALL_MME_MACRO(236):
    case NVA297_CALL_MME_MACRO(237):
    case NVA297_CALL_MME_MACRO(238):
    case NVA297_CALL_MME_MACRO(239):
    case NVA297_CALL_MME_MACRO(240):
    case NVA297_CALL_MME_MACRO(241):
    case NVA297_CALL_MME_MACRO(242):
    case NVA297_CALL_MME_MACRO(243):
    case NVA297_CALL_MME_MACRO(244):
    case NVA297_CALL_MME_MACRO(245):
    case NVA297_CALL_MME_MACRO(246):
    case NVA297_CALL_MME_MACRO(247):
    case NVA297_CALL_MME_MACRO(248):
    case NVA297_CALL_MME_MACRO(249):
    case NVA297_CALL_MME_MACRO(250):
    case NVA297_CALL_MME_MACRO(251):
    case NVA297_CALL_MME_MACRO(252):
    case NVA297_CALL_MME_MACRO(253):
    case NVA297_CALL_MME_MACRO(254):
    case NVA297_CALL_MME_MACRO(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVA297_CALL_MME_DATA(0):
    case NVA297_CALL_MME_DATA(1):
    case NVA297_CALL_MME_DATA(2):
    case NVA297_CALL_MME_DATA(3):
    case NVA297_CALL_MME_DATA(4):
    case NVA297_CALL_MME_DATA(5):
    case NVA297_CALL_MME_DATA(6):
    case NVA297_CALL_MME_DATA(7):
    case NVA297_CALL_MME_DATA(8):
    case NVA297_CALL_MME_DATA(9):
    case NVA297_CALL_MME_DATA(10):
    case NVA297_CALL_MME_DATA(11):
    case NVA297_CALL_MME_DATA(12):
    case NVA297_CALL_MME_DATA(13):
    case NVA297_CALL_MME_DATA(14):
    case NVA297_CALL_MME_DATA(15):
    case NVA297_CALL_MME_DATA(16):
    case NVA297_CALL_MME_DATA(17):
    case NVA297_CALL_MME_DATA(18):
    case NVA297_CALL_MME_DATA(19):
    case NVA297_CALL_MME_DATA(20):
    case NVA297_CALL_MME_DATA(21):
    case NVA297_CALL_MME_DATA(22):
    case NVA297_CALL_MME_DATA(23):
    case NVA297_CALL_MME_DATA(24):
    case NVA297_CALL_MME_DATA(25):
    case NVA297_CALL_MME_DATA(26):
    case NVA297_CALL_MME_DATA(27):
    case NVA297_CALL_MME_DATA(28):
    case NVA297_CALL_MME_DATA(29):
    case NVA297_CALL_MME_DATA(30):
    case NVA297_CALL_MME_DATA(31):
    case NVA297_CALL_MME_DATA(32):
    case NVA297_CALL_MME_DATA(33):
    case NVA297_CALL_MME_DATA(34):
    case NVA297_CALL_MME_DATA(35):
    case NVA297_CALL_MME_DATA(36):
    case NVA297_CALL_MME_DATA(37):
    case NVA297_CALL_MME_DATA(38):
    case NVA297_CALL_MME_DATA(39):
    case NVA297_CALL_MME_DATA(40):
    case NVA297_CALL_MME_DATA(41):
    case NVA297_CALL_MME_DATA(42):
    case NVA297_CALL_MME_DATA(43):
    case NVA297_CALL_MME_DATA(44):
    case NVA297_CALL_MME_DATA(45):
    case NVA297_CALL_MME_DATA(46):
    case NVA297_CALL_MME_DATA(47):
    case NVA297_CALL_MME_DATA(48):
    case NVA297_CALL_MME_DATA(49):
    case NVA297_CALL_MME_DATA(50):
    case NVA297_CALL_MME_DATA(51):
    case NVA297_CALL_MME_DATA(52):
    case NVA297_CALL_MME_DATA(53):
    case NVA297_CALL_MME_DATA(54):
    case NVA297_CALL_MME_DATA(55):
    case NVA297_CALL_MME_DATA(56):
    case NVA297_CALL_MME_DATA(57):
    case NVA297_CALL_MME_DATA(58):
    case NVA297_CALL_MME_DATA(59):
    case NVA297_CALL_MME_DATA(60):
    case NVA297_CALL_MME_DATA(61):
    case NVA297_CALL_MME_DATA(62):
    case NVA297_CALL_MME_DATA(63):
    case NVA297_CALL_MME_DATA(64):
    case NVA297_CALL_MME_DATA(65):
    case NVA297_CALL_MME_DATA(66):
    case NVA297_CALL_MME_DATA(67):
    case NVA297_CALL_MME_DATA(68):
    case NVA297_CALL_MME_DATA(69):
    case NVA297_CALL_MME_DATA(70):
    case NVA297_CALL_MME_DATA(71):
    case NVA297_CALL_MME_DATA(72):
    case NVA297_CALL_MME_DATA(73):
    case NVA297_CALL_MME_DATA(74):
    case NVA297_CALL_MME_DATA(75):
    case NVA297_CALL_MME_DATA(76):
    case NVA297_CALL_MME_DATA(77):
    case NVA297_CALL_MME_DATA(78):
    case NVA297_CALL_MME_DATA(79):
    case NVA297_CALL_MME_DATA(80):
    case NVA297_CALL_MME_DATA(81):
    case NVA297_CALL_MME_DATA(82):
    case NVA297_CALL_MME_DATA(83):
    case NVA297_CALL_MME_DATA(84):
    case NVA297_CALL_MME_DATA(85):
    case NVA297_CALL_MME_DATA(86):
    case NVA297_CALL_MME_DATA(87):
    case NVA297_CALL_MME_DATA(88):
    case NVA297_CALL_MME_DATA(89):
    case NVA297_CALL_MME_DATA(90):
    case NVA297_CALL_MME_DATA(91):
    case NVA297_CALL_MME_DATA(92):
    case NVA297_CALL_MME_DATA(93):
    case NVA297_CALL_MME_DATA(94):
    case NVA297_CALL_MME_DATA(95):
    case NVA297_CALL_MME_DATA(96):
    case NVA297_CALL_MME_DATA(97):
    case NVA297_CALL_MME_DATA(98):
    case NVA297_CALL_MME_DATA(99):
    case NVA297_CALL_MME_DATA(100):
    case NVA297_CALL_MME_DATA(101):
    case NVA297_CALL_MME_DATA(102):
    case NVA297_CALL_MME_DATA(103):
    case NVA297_CALL_MME_DATA(104):
    case NVA297_CALL_MME_DATA(105):
    case NVA297_CALL_MME_DATA(106):
    case NVA297_CALL_MME_DATA(107):
    case NVA297_CALL_MME_DATA(108):
    case NVA297_CALL_MME_DATA(109):
    case NVA297_CALL_MME_DATA(110):
    case NVA297_CALL_MME_DATA(111):
    case NVA297_CALL_MME_DATA(112):
    case NVA297_CALL_MME_DATA(113):
    case NVA297_CALL_MME_DATA(114):
    case NVA297_CALL_MME_DATA(115):
    case NVA297_CALL_MME_DATA(116):
    case NVA297_CALL_MME_DATA(117):
    case NVA297_CALL_MME_DATA(118):
    case NVA297_CALL_MME_DATA(119):
    case NVA297_CALL_MME_DATA(120):
    case NVA297_CALL_MME_DATA(121):
    case NVA297_CALL_MME_DATA(122):
    case NVA297_CALL_MME_DATA(123):
    case NVA297_CALL_MME_DATA(124):
    case NVA297_CALL_MME_DATA(125):
    case NVA297_CALL_MME_DATA(126):
    case NVA297_CALL_MME_DATA(127):
    case NVA297_CALL_MME_DATA(128):
    case NVA297_CALL_MME_DATA(129):
    case NVA297_CALL_MME_DATA(130):
    case NVA297_CALL_MME_DATA(131):
    case NVA297_CALL_MME_DATA(132):
    case NVA297_CALL_MME_DATA(133):
    case NVA297_CALL_MME_DATA(134):
    case NVA297_CALL_MME_DATA(135):
    case NVA297_CALL_MME_DATA(136):
    case NVA297_CALL_MME_DATA(137):
    case NVA297_CALL_MME_DATA(138):
    case NVA297_CALL_MME_DATA(139):
    case NVA297_CALL_MME_DATA(140):
    case NVA297_CALL_MME_DATA(141):
    case NVA297_CALL_MME_DATA(142):
    case NVA297_CALL_MME_DATA(143):
    case NVA297_CALL_MME_DATA(144):
    case NVA297_CALL_MME_DATA(145):
    case NVA297_CALL_MME_DATA(146):
    case NVA297_CALL_MME_DATA(147):
    case NVA297_CALL_MME_DATA(148):
    case NVA297_CALL_MME_DATA(149):
    case NVA297_CALL_MME_DATA(150):
    case NVA297_CALL_MME_DATA(151):
    case NVA297_CALL_MME_DATA(152):
    case NVA297_CALL_MME_DATA(153):
    case NVA297_CALL_MME_DATA(154):
    case NVA297_CALL_MME_DATA(155):
    case NVA297_CALL_MME_DATA(156):
    case NVA297_CALL_MME_DATA(157):
    case NVA297_CALL_MME_DATA(158):
    case NVA297_CALL_MME_DATA(159):
    case NVA297_CALL_MME_DATA(160):
    case NVA297_CALL_MME_DATA(161):
    case NVA297_CALL_MME_DATA(162):
    case NVA297_CALL_MME_DATA(163):
    case NVA297_CALL_MME_DATA(164):
    case NVA297_CALL_MME_DATA(165):
    case NVA297_CALL_MME_DATA(166):
    case NVA297_CALL_MME_DATA(167):
    case NVA297_CALL_MME_DATA(168):
    case NVA297_CALL_MME_DATA(169):
    case NVA297_CALL_MME_DATA(170):
    case NVA297_CALL_MME_DATA(171):
    case NVA297_CALL_MME_DATA(172):
    case NVA297_CALL_MME_DATA(173):
    case NVA297_CALL_MME_DATA(174):
    case NVA297_CALL_MME_DATA(175):
    case NVA297_CALL_MME_DATA(176):
    case NVA297_CALL_MME_DATA(177):
    case NVA297_CALL_MME_DATA(178):
    case NVA297_CALL_MME_DATA(179):
    case NVA297_CALL_MME_DATA(180):
    case NVA297_CALL_MME_DATA(181):
    case NVA297_CALL_MME_DATA(182):
    case NVA297_CALL_MME_DATA(183):
    case NVA297_CALL_MME_DATA(184):
    case NVA297_CALL_MME_DATA(185):
    case NVA297_CALL_MME_DATA(186):
    case NVA297_CALL_MME_DATA(187):
    case NVA297_CALL_MME_DATA(188):
    case NVA297_CALL_MME_DATA(189):
    case NVA297_CALL_MME_DATA(190):
    case NVA297_CALL_MME_DATA(191):
    case NVA297_CALL_MME_DATA(192):
    case NVA297_CALL_MME_DATA(193):
    case NVA297_CALL_MME_DATA(194):
    case NVA297_CALL_MME_DATA(195):
    case NVA297_CALL_MME_DATA(196):
    case NVA297_CALL_MME_DATA(197):
    case NVA297_CALL_MME_DATA(198):
    case NVA297_CALL_MME_DATA(199):
    case NVA297_CALL_MME_DATA(200):
    case NVA297_CALL_MME_DATA(201):
    case NVA297_CALL_MME_DATA(202):
    case NVA297_CALL_MME_DATA(203):
    case NVA297_CALL_MME_DATA(204):
    case NVA297_CALL_MME_DATA(205):
    case NVA297_CALL_MME_DATA(206):
    case NVA297_CALL_MME_DATA(207):
    case NVA297_CALL_MME_DATA(208):
    case NVA297_CALL_MME_DATA(209):
    case NVA297_CALL_MME_DATA(210):
    case NVA297_CALL_MME_DATA(211):
    case NVA297_CALL_MME_DATA(212):
    case NVA297_CALL_MME_DATA(213):
    case NVA297_CALL_MME_DATA(214):
    case NVA297_CALL_MME_DATA(215):
    case NVA297_CALL_MME_DATA(216):
    case NVA297_CALL_MME_DATA(217):
    case NVA297_CALL_MME_DATA(218):
    case NVA297_CALL_MME_DATA(219):
    case NVA297_CALL_MME_DATA(220):
    case NVA297_CALL_MME_DATA(221):
    case NVA297_CALL_MME_DATA(222):
    case NVA297_CALL_MME_DATA(223):
    case NVA297_CALL_MME_DATA(224):
    case NVA297_CALL_MME_DATA(225):
    case NVA297_CALL_MME_DATA(226):
    case NVA297_CALL_MME_DATA(227):
    case NVA297_CALL_MME_DATA(228):
    case NVA297_CALL_MME_DATA(229):
    case NVA297_CALL_MME_DATA(230):
    case NVA297_CALL_MME_DATA(231):
    case NVA297_CALL_MME_DATA(232):
    case NVA297_CALL_MME_DATA(233):
    case NVA297_CALL_MME_DATA(234):
    case NVA297_CALL_MME_DATA(235):
    case NVA297_CALL_MME_DATA(236):
    case NVA297_CALL_MME_DATA(237):
    case NVA297_CALL_MME_DATA(238):
    case NVA297_CALL_MME_DATA(239):
    case NVA297_CALL_MME_DATA(240):
    case NVA297_CALL_MME_DATA(241):
    case NVA297_CALL_MME_DATA(242):
    case NVA297_CALL_MME_DATA(243):
    case NVA297_CALL_MME_DATA(244):
    case NVA297_CALL_MME_DATA(245):
    case NVA297_CALL_MME_DATA(246):
    case NVA297_CALL_MME_DATA(247):
    case NVA297_CALL_MME_DATA(248):
    case NVA297_CALL_MME_DATA(249):
    case NVA297_CALL_MME_DATA(250):
    case NVA297_CALL_MME_DATA(251):
    case NVA297_CALL_MME_DATA(252):
    case NVA297_CALL_MME_DATA(253):
    case NVA297_CALL_MME_DATA(254):
    case NVA297_CALL_MME_DATA(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
