// Copyright Contributors to the Open Shading Language project.
// SPDX-License-Identifier: BSD-3-Clause
// https://github.com/AcademySoftwareFoundation/OpenShadingLanguage

#pragma once
#include <BSDL/spectrum_decl.h>

BSDL_ENTER_NAMESPACE

BSDL_INLINE_METHOD constexpr Spectrum::Data
Spectrum::get_luts_ctxr()
{
    return {
        // XYZ response
        { { 0.001368f, 0.000039f, 0.006450f },
          { 0.002236f, 0.000064f, 0.010550f },
          { 0.004243f, 0.000120f, 0.020050f },
          { 0.007650f, 0.000217f, 0.036210f },
          { 0.014310f, 0.000396f, 0.067850f },
          { 0.023190f, 0.000640f, 0.110200f },
          { 0.043510f, 0.001210f, 0.207400f },
          { 0.077630f, 0.002180f, 0.371300f },
          { 0.134380f, 0.004000f, 0.645600f },
          { 0.214770f, 0.007300f, 1.039050f },
          { 0.283900f, 0.011600f, 1.385600f },
          { 0.328500f, 0.016840f, 1.622960f },
          { 0.348280f, 0.023000f, 1.747060f },
          { 0.348060f, 0.029800f, 1.782600f },
          { 0.336200f, 0.038000f, 1.772110f },
          { 0.318700f, 0.048000f, 1.744100f },
          { 0.290800f, 0.060000f, 1.669200f },
          { 0.251100f, 0.073900f, 1.528100f },
          { 0.195360f, 0.090980f, 1.287640f },
          { 0.142100f, 0.112600f, 1.041900f },
          { 0.095640f, 0.139020f, 0.812950f },
          { 0.057950f, 0.169300f, 0.616200f },
          { 0.032010f, 0.208020f, 0.465180f },
          { 0.014700f, 0.258600f, 0.353300f },
          { 0.004900f, 0.323000f, 0.272000f },
          { 0.002400f, 0.407300f, 0.212300f },
          { 0.009300f, 0.503000f, 0.158200f },
          { 0.029100f, 0.608200f, 0.111700f },
          { 0.063270f, 0.710000f, 0.078250f },
          { 0.109600f, 0.793200f, 0.057250f },
          { 0.165500f, 0.862000f, 0.042160f },
          { 0.225750f, 0.914850f, 0.029840f },
          { 0.290400f, 0.954000f, 0.020300f },
          { 0.359700f, 0.980300f, 0.013400f },
          { 0.433450f, 0.994950f, 0.008750f },
          { 0.512050f, 1.000000f, 0.005750f },
          { 0.594500f, 0.995000f, 0.003900f },
          { 0.678400f, 0.978600f, 0.002750f },
          { 0.762100f, 0.952000f, 0.002100f },
          { 0.842500f, 0.915400f, 0.001800f },
          { 0.916300f, 0.870000f, 0.001650f },
          { 0.978600f, 0.816300f, 0.001400f },
          { 1.026300f, 0.757000f, 0.001100f },
          { 1.056700f, 0.694900f, 0.001000f },
          { 1.062200f, 0.631000f, 0.000800f },
          { 1.045600f, 0.566800f, 0.000600f },
          { 1.002600f, 0.503000f, 0.000340f },
          { 0.938400f, 0.441200f, 0.000240f },
          { 0.854450f, 0.381000f, 0.000190f },
          { 0.751400f, 0.321000f, 0.000100f },
          { 0.642400f, 0.265000f, 0.000050f },
          { 0.541900f, 0.217000f, 0.000030f },
          { 0.447900f, 0.175000f, 0.000020f },
          { 0.360800f, 0.138200f, 0.000010f },
          { 0.283500f, 0.107000f, 0.000000f },
          { 0.218700f, 0.081600f, 0.000000f },
          { 0.164900f, 0.061000f, 0.000000f },
          { 0.121200f, 0.044580f, 0.000000f },
          { 0.087400f, 0.032000f, 0.000000f },
          { 0.063600f, 0.023200f, 0.000000f },
          { 0.046770f, 0.017000f, 0.000000f },
          { 0.032900f, 0.011920f, 0.000000f },
          { 0.022700f, 0.008210f, 0.000000f },
          { 0.015840f, 0.005723f, 0.000000f },
          { 0.011359f, 0.004102f, 0.000000f },
          { 0.008111f, 0.002929f, 0.000000f },
          { 0.005790f, 0.002091f, 0.000000f },
          { 0.004109f, 0.001484f, 0.000000f },
          { 0.002899f, 0.001047f, 0.000000f },
          { 0.002049f, 0.000740f, 0.000000f },
          { 0.001440f, 0.000520f, 0.000000f },
          { 0.001000f, 0.000361f, 0.000000f },
          { 0.000690f, 0.000249f, 0.000000f },
          { 0.000476f, 0.000172f, 0.000000f },
          { 0.000332f, 0.000120f, 0.000000f },
          { 0.000235f, 0.000085f, 0.000000f },
          { 0.000166f, 0.000060f, 0.000000f },
          { 0.000117f, 0.000042f, 0.000000f },
          { 0.000083f, 0.000030f, 0.000000f },
          { 0.000059f, 0.000021f, 0.000000f },
          { 0.000042f, 0.000015f, 0.000000f } },
        // D65 illuminant
        { 49.9755f, 52.3118f, 54.6482f, 68.7015f, 82.7549f, 87.1204f, 91.486f,
          92.4589f, 93.4318f, 90.057f,  86.6823f, 95.7736f, 104.865f, 110.936f,
          117.008f, 117.41f,  117.812f, 116.336f, 114.861f, 115.392f, 115.923f,
          112.367f, 108.811f, 109.082f, 109.354f, 108.578f, 107.802f, 106.296f,
          104.79f,  106.239f, 107.689f, 106.047f, 104.405f, 104.225f, 104.046f,
          102.023f, 100.0f,   98.1671f, 96.3342f, 96.0611f, 95.788f,  92.2368f,
          88.6856f, 89.3459f, 90.0062f, 89.8026f, 89.5991f, 88.6489f, 87.6987f,
          85.4936f, 83.2886f, 83.4939f, 83.6992f, 81.863f,  80.0268f, 80.1207f,
          80.2146f, 81.2462f, 82.2778f, 80.281f,  78.2842f, 74.0027f, 69.7213f,
          70.6652f, 71.6091f, 72.979f,  74.349f,  67.9765f, 61.604f,  65.7448f,
          69.8856f, 72.4863f, 75.087f,  69.3398f, 63.5927f, 55.0054f, 46.4182f,
          56.6118f, 66.8054f, 65.0941f, 63.3828f },
        // D60 illuminant
        { 41.471500f,  44.046250f,  46.621000f,  59.460050f,  72.299100f,
          76.380650f,  80.462200f,  81.698900f,  82.935600f,  80.314750f,
          77.693900f,  86.696600f,  95.699300f,  101.835950f, 107.972600f,
          108.774000f, 109.575400f, 108.673750f, 107.772100f, 108.727900f,
          109.683700f, 106.700800f, 103.717900f, 104.479100f, 105.240300f,
          104.837300f, 104.434300f, 103.480850f, 102.527400f, 104.291650f,
          106.055900f, 104.686600f, 103.317300f, 103.428450f, 103.539600f,
          101.769800f, 100.000000f, 98.375300f,  96.750600f,  96.730800f,
          96.711000f,  93.315000f,  89.919000f,  90.957400f,  91.995800f,
          92.044750f,  92.093700f,  91.366900f,  90.640100f,  88.580050f,
          86.520000f,  87.045700f,  87.571400f,  85.769800f,  83.968200f,
          84.341600f,  84.715000f,  86.099000f,  87.483000f,  85.477800f,
          83.472600f,  78.818050f,  74.163500f,  75.386900f,  76.610300f,
          77.826350f,  79.042400f,  72.253000f,  65.463600f,  69.780600f,
          74.097600f,  76.807900f,  79.518200f,  73.408950f,  67.299700f,
          58.283750f,  49.267800f,  60.076000f,  70.884200f,  69.020300f,
          67.156400f }
    };
}

BSDL_INLINE_METHOD const sRGBColorSpace::Data&
sRGBColorSpace::get_luts()
{
    static const Data data = {
        // sRGB basis
        { { 0.327457413827055f, 0.331861713085874f, 0.340680791548052f },
          { 0.323750578270541f, 0.329688187759399f, 0.346561186624852f },
          { 0.313439461251577f, 0.327860021624697f, 0.358700493140351f },
          { 0.288879382755265f, 0.319173580231756f, 0.391947026588195f },
          { 0.239205681158886f, 0.294322583694842f, 0.466471730587333f },
          { 0.189702036890535f, 0.258697064768736f, 0.551600895598602f },
          { 0.121746067959218f, 0.188894319254765f, 0.689359610948928f },
          { 0.074578270669466f, 0.125388381991689f, 0.800033346878607f },
          { 0.0444331586340337f, 0.0786870603106217f, 0.876879780935314f },
          { 0.0289286321285029f, 0.0531432708659453f, 0.917928097443955f },
          { 0.0223166534847512f, 0.0422881460313421f, 0.935395200669632f },
          { 0.0169113072926318f, 0.0333183455029171f, 0.949770347115183f },
          { 0.0141811071179667f, 0.0297559481859724f, 0.95606294480524f },
          { 0.0130531426774873f, 0.0303312505369047f, 0.956615606890316f },
          { 0.011986163627845f, 0.0309885718973007f, 0.957025264931328f },
          { 0.0112887147124048f, 0.0316863551888381f, 0.957024930534713f },
          { 0.0109060664656517f, 0.0346699615029974f, 0.954423972737066f },
          { 0.0104007134810042f, 0.034551957443675f, 0.955047329020204f },
          { 0.0106373602541465f, 0.0406848061948297f, 0.948677833093334f },
          { 0.0109076625337741f, 0.0544600373694056f, 0.934632299842328f },
          { 0.0110327124480988f, 0.0809052874204737f, 0.908061999852269f },
          { 0.0113106565912268f, 0.146348302857044f, 0.842341039463727f },
          { 0.0111546420569403f, 0.379679643296617f, 0.609165715365647f },
          { 0.0101487704062122f, 0.766744268654033f, 0.223106960959533f },
          { 0.00891858211883843f, 0.87621474761337f, 0.114866670291336f },
          { 0.00768557633847106f, 0.918491655613843f, 0.0738227678957437f },
          { 0.00670570828469526f, 0.940655562534437f, 0.0526387287910555f },
          { 0.00599580598764424f, 0.95373188453302f, 0.0402723090168887f },
          { 0.00553725664234189f, 0.961643279840238f, 0.0328194626509591f },
          { 0.00519378424120663f, 0.967200019685078f, 0.0276061959270456f },
          { 0.00502536226522334f, 0.970989746390046f, 0.0239848911270394f },
          { 0.00513636276967508f, 0.972852303563554f, 0.0220113333527922f },
          { 0.00543320026053983f, 0.973116594076444f, 0.0214502052559966f },
          { 0.00581998590243535f, 0.973351069154143f, 0.0208289445095685f },
          { 0.00640057277462412f, 0.973351115544369f, 0.0202483113888087f },
          { 0.00744952868340878f, 0.972261079731725f, 0.0202893914512066f },
          { 0.00858363581937657f, 0.973351021746917f, 0.018065342335913f },
          { 0.0103957624651674f, 0.973148495185693f, 0.0164557422344685f },
          { 0.0135654335386492f, 0.971061306300914f, 0.0153732601340955f },
          { 0.0193845158399742f, 0.966371305955183f, 0.0142441784845517f },
          { 0.0320840712020024f, 0.954941967502548f, 0.0129739615543347f },
          { 0.0743560378459411f, 0.913578989551261f, 0.0120649741345218f },
          { 0.624393724178075f, 0.364348803907687f, 0.0112574781603901f },
          { 0.91831003276872f, 0.0715072425408851f, 0.0101827246716942f },
          { 0.949253030175051f, 0.0412304344713751f, 0.00951653538723741f },
          { 0.958187833329246f, 0.0324238741836685f, 0.00938829272866817f },
          { 0.958187751332698f, 0.0319246297982003f, 0.00988761909067028f },
          { 0.958187625087782f, 0.0312760331730969f, 0.0105363420064589f },
          { 0.955679060771746f, 0.0326303704290574f, 0.0116905688374448f },
          { 0.958006154893429f, 0.0295308721490739f, 0.0124629728871037f },
          { 0.954101573456564f, 0.0315617611702464f, 0.0143366651774203f },
          { 0.947607606237237f, 0.0356742182708204f, 0.0167181753275443f },
          { 0.938681328447549f, 0.0414030053955673f, 0.0199156660750025f },
          { 0.924466682751434f, 0.0506042604489561f, 0.024929056163281f },
          { 0.904606025333056f, 0.0634343003817003f, 0.0319596735860402f },
          { 0.880412198927933f, 0.0789182452939229f, 0.0406695540952484f },
          { 0.8477878731517f, 0.0995427426653747f, 0.0526693824219396f },
          { 0.805779126623019f, 0.125595760093287f, 0.0686251105141947f },
          { 0.752531853871421f, 0.15759091044168f, 0.0898772323000136f },
          { 0.686439396844578f, 0.19539823904421f, 0.118162358926434f },
          { 0.61869457086061f, 0.231474474772178f, 0.149830947442133f },
          { 0.540264443959111f, 0.268852136095262f, 0.190883409341834f },
          { 0.472964416293838f, 0.296029164217928f, 0.231006403025217f },
          { 0.432701596704049f, 0.309754994441945f, 0.257543385422202f },
          { 0.405358045528392f, 0.317815883383822f, 0.276826038721536f },
          { 0.385491834974902f, 0.322990347389898f, 0.291517772810795f },
          { 0.370983584551061f, 0.326353847938009f, 0.302662506083233f },
          { 0.357608701523081f, 0.32914390227898f, 0.313247301302886f },
          { 0.348712800108393f, 0.330808726803682f, 0.320478325124633f },
          { 0.344880119344691f, 0.331482689922243f, 0.323636994707961f },
          { 0.341917877323291f, 0.331984550352389f, 0.3260973088469f },
          { 0.339531092987129f, 0.332341172522545f, 0.328127369340184f },
          { 0.337169503774367f, 0.332912009415539f, 0.329917975958888f },
          { 0.336172018527717f, 0.332919279695214f, 0.330907901216649f },
          { 0.335167443433363f, 0.333027672578856f, 0.331803633095995f },
          { 0.334421625306463f, 0.33317970467326f, 0.332396627255361f },
          { 0.334008760376402f, 0.333247030974549f, 0.332740780726824f },
          { 0.333915792790082f, 0.333259349210601f, 0.332820857081489f },
          { 0.333818454946367f, 0.333275050279383f, 0.332901731283444f },
          { 0.333672774928456f, 0.333294328448732f, 0.333025967488632f },
          { 0.333569513405591f, 0.333309424957775f, 0.333111083081497f } }
    };
    return data;
}

BSDL_INLINE_METHOD const Spectrum::Data&
Spectrum::get_luts()
{
    static Data data = get_luts_ctxr();
    return data;
}

BSDL_LEAVE_NAMESPACE
