/* Branch.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Branch.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#define LIBRARY_BRANCH_POSITION_DATA "x-photos-entry-position"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	LIBRARY_BRANCH_0_PROPERTY,
	LIBRARY_BRANCH_PHOTOS_ENTRY_PROPERTY,
	LIBRARY_BRANCH_VIDEOS_ENTRY_PROPERTY,
	LIBRARY_BRANCH_RAWS_ENTRY_PROPERTY,
	LIBRARY_BRANCH_FLAGGED_ENTRY_PROPERTY,
	LIBRARY_BRANCH_LAST_IMPORTED_ENTRY_PROPERTY,
	LIBRARY_BRANCH_IMPORT_QUEUE_ENTRY_PROPERTY,
	LIBRARY_BRANCH_OFFLINE_ENTRY_PROPERTY,
	LIBRARY_BRANCH_TRASH_ENTRY_PROPERTY,
	LIBRARY_BRANCH_NUM_PROPERTIES
};
static GParamSpec* library_branch_properties[LIBRARY_BRANCH_NUM_PROPERTIES];
typedef enum  {
	LIBRARY_BRANCH_ENTRY_POSITION_PHOTOS,
	LIBRARY_BRANCH_ENTRY_POSITION_RAWS,
	LIBRARY_BRANCH_ENTRY_POSITION_VIDEOS,
	LIBRARY_BRANCH_ENTRY_POSITION_FLAGGED,
	LIBRARY_BRANCH_ENTRY_POSITION_LAST_IMPORTED,
	LIBRARY_BRANCH_ENTRY_POSITION_IMPORT_QUEUE,
	LIBRARY_BRANCH_ENTRY_POSITION_OFFLINE,
	LIBRARY_BRANCH_ENTRY_POSITION_TRASH
} LibraryBranchEntryPosition;

#define LIBRARY_BRANCH_TYPE_ENTRY_POSITION (library_branch_entry_position_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	LIBRARY_HIDEABLE_PAGE_ENTRY_0_PROPERTY,
	LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBLE_PROPERTY,
	LIBRARY_HIDEABLE_PAGE_ENTRY_NUM_PROPERTIES
};
static GParamSpec* library_hideable_page_entry_properties[LIBRARY_HIDEABLE_PAGE_ENTRY_NUM_PROPERTIES];
enum  {
	LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBILITY_CHANGED_SIGNAL,
	LIBRARY_HIDEABLE_PAGE_ENTRY_NUM_SIGNALS
};
static guint library_hideable_page_entry_signals[LIBRARY_HIDEABLE_PAGE_ENTRY_NUM_SIGNALS] = {0};
enum  {
	LIBRARY_MAIN_PAGE_0_PROPERTY,
	LIBRARY_MAIN_PAGE_NUM_PROPERTIES
};
static GParamSpec* library_main_page_properties[LIBRARY_MAIN_PAGE_NUM_PROPERTIES];
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))
#define _view_collection_monitor_unref0(var) ((var == NULL) ? NULL : (var = (view_collection_monitor_unref (var), NULL)))
#define _view_manager_unref0(var) ((var == NULL) ? NULL : (var = (view_manager_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

struct _LibraryBranchPrivate {
	LibraryPhotosEntry* _photos_entry;
	LibraryVideosEntry* _videos_entry;
	LibraryRawsEntry* _raws_entry;
	LibraryFlaggedSidebarEntry* _flagged_entry;
	LibraryLastImportSidebarEntry* _last_imported_entry;
	LibraryImportQueueSidebarEntry* _import_queue_entry;
	LibraryOfflineSidebarEntry* _offline_entry;
	LibraryTrashSidebarEntry* _trash_entry;
};

struct _LibraryHideablePageEntryPrivate {
	gboolean show_entry;
};

static gint LibraryBranch_private_offset;
static gpointer library_branch_parent_class = NULL;
static gint LibraryHideablePageEntry_private_offset;
static gpointer library_hideable_page_entry_parent_class = NULL;
static gpointer library_main_page_parent_class = NULL;

static GType library_branch_entry_position_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint library_branch_comparator (SidebarEntry* a,
                                SidebarEntry* b);
static gint _library_branch_comparator_gcompare_func (gconstpointer a,
                                               gconstpointer b);
static void library_branch_set_photos_entry (LibraryBranch* self,
                                      LibraryPhotosEntry* value);
static void library_branch_set_videos_entry (LibraryBranch* self,
                                      LibraryVideosEntry* value);
static void library_branch_set_raws_entry (LibraryBranch* self,
                                    LibraryRawsEntry* value);
static void library_branch_set_trash_entry (LibraryBranch* self,
                                     LibraryTrashSidebarEntry* value);
static void library_branch_set_last_imported_entry (LibraryBranch* self,
                                             LibraryLastImportSidebarEntry* value);
static void library_branch_set_flagged_entry (LibraryBranch* self,
                                       LibraryFlaggedSidebarEntry* value);
static void library_branch_set_offline_entry (LibraryBranch* self,
                                       LibraryOfflineSidebarEntry* value);
static void library_branch_set_import_queue_entry (LibraryBranch* self,
                                            LibraryImportQueueSidebarEntry* value);
static void library_branch_insert (LibraryBranch* self,
                            SidebarEntry* entry,
                            gint position);
static void library_branch_on_videos_visibility_changed (LibraryBranch* self);
static void _library_branch_on_videos_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                                  gboolean visible,
                                                                                                  gpointer self);
static void library_branch_on_flagged_visibility_changed (LibraryBranch* self);
static void _library_branch_on_flagged_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                                   gboolean visible,
                                                                                                   gpointer self);
static void library_branch_on_last_imported_visibility_changed (LibraryBranch* self);
static void _library_branch_on_last_imported_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                                         gboolean visible,
                                                                                                         gpointer self);
static void library_branch_on_import_queue_visibility_changed (LibraryBranch* self);
static void _library_branch_on_import_queue_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                                        gboolean visible,
                                                                                                        gpointer self);
static void library_branch_on_offline_visibility_changed (LibraryBranch* self);
static void _library_branch_on_offline_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                                   gboolean visible,
                                                                                                   gpointer self);
static void library_branch_update_entry_visibility (LibraryBranch* self,
                                             LibraryHideablePageEntry* entry,
                                             gint position);
static void library_branch_finalize (GObject * obj);
static GType library_branch_get_type_once (void);
static void _vala_library_branch_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_library_branch_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void library_hideable_page_entry_finalize (GObject * obj);
static GType library_hideable_page_entry_get_type_once (void);
static void _vala_library_hideable_page_entry_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_library_hideable_page_entry_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static gchar* library_main_page_real_get_back_name (CheckerboardPage* base);
static GType library_main_page_get_type_once (void);

static inline gpointer
library_branch_get_instance_private (LibraryBranch* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryBranch_private_offset);
}

static GType
library_branch_entry_position_get_type_once (void)
{
	static const GEnumValue values[] = {{LIBRARY_BRANCH_ENTRY_POSITION_PHOTOS, "LIBRARY_BRANCH_ENTRY_POSITION_PHOTOS", "photos"}, {LIBRARY_BRANCH_ENTRY_POSITION_RAWS, "LIBRARY_BRANCH_ENTRY_POSITION_RAWS", "raws"}, {LIBRARY_BRANCH_ENTRY_POSITION_VIDEOS, "LIBRARY_BRANCH_ENTRY_POSITION_VIDEOS", "videos"}, {LIBRARY_BRANCH_ENTRY_POSITION_FLAGGED, "LIBRARY_BRANCH_ENTRY_POSITION_FLAGGED", "flagged"}, {LIBRARY_BRANCH_ENTRY_POSITION_LAST_IMPORTED, "LIBRARY_BRANCH_ENTRY_POSITION_LAST_IMPORTED", "last-imported"}, {LIBRARY_BRANCH_ENTRY_POSITION_IMPORT_QUEUE, "LIBRARY_BRANCH_ENTRY_POSITION_IMPORT_QUEUE", "import-queue"}, {LIBRARY_BRANCH_ENTRY_POSITION_OFFLINE, "LIBRARY_BRANCH_ENTRY_POSITION_OFFLINE", "offline"}, {LIBRARY_BRANCH_ENTRY_POSITION_TRASH, "LIBRARY_BRANCH_ENTRY_POSITION_TRASH", "trash"}, {0, NULL, NULL}};
	GType library_branch_entry_position_type_id;
	library_branch_entry_position_type_id = g_enum_register_static ("LibraryBranchEntryPosition", values);
	return library_branch_entry_position_type_id;
}

static GType
library_branch_entry_position_get_type (void)
{
	static volatile gsize library_branch_entry_position_type_id__once = 0;
	if (g_once_init_enter (&library_branch_entry_position_type_id__once)) {
		GType library_branch_entry_position_type_id;
		library_branch_entry_position_type_id = library_branch_entry_position_get_type_once ();
		g_once_init_leave (&library_branch_entry_position_type_id__once, library_branch_entry_position_type_id);
	}
	return library_branch_entry_position_type_id__once;
}

static gint
_library_branch_comparator_gcompare_func (gconstpointer a,
                                          gconstpointer b)
{
	gint result;
	result = library_branch_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

static void
_library_branch_on_videos_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                             gboolean visible,
                                                                                             gpointer self)
{
	library_branch_on_videos_visibility_changed ((LibraryBranch*) self);
}

static void
_library_branch_on_flagged_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                              gboolean visible,
                                                                                              gpointer self)
{
	library_branch_on_flagged_visibility_changed ((LibraryBranch*) self);
}

static void
_library_branch_on_last_imported_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                                    gboolean visible,
                                                                                                    gpointer self)
{
	library_branch_on_last_imported_visibility_changed ((LibraryBranch*) self);
}

static void
_library_branch_on_import_queue_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                                   gboolean visible,
                                                                                                   gpointer self)
{
	library_branch_on_import_queue_visibility_changed ((LibraryBranch*) self);
}

static void
_library_branch_on_offline_visibility_changed_library_hideable_page_entry_visibility_changed (LibraryHideablePageEntry* _sender,
                                                                                              gboolean visible,
                                                                                              gpointer self)
{
	library_branch_on_offline_visibility_changed ((LibraryBranch*) self);
}

LibraryBranch*
library_branch_construct (GType object_type)
{
	LibraryBranch * self = NULL;
	SidebarGrouping* _tmp0_;
	SidebarGrouping* _tmp1_;
	LibraryPhotosEntry* _tmp2_;
	LibraryPhotosEntry* _tmp3_;
	LibraryVideosEntry* _tmp4_;
	LibraryVideosEntry* _tmp5_;
	LibraryRawsEntry* _tmp6_;
	LibraryRawsEntry* _tmp7_;
	LibraryTrashSidebarEntry* _tmp8_;
	LibraryTrashSidebarEntry* _tmp9_;
	LibraryLastImportSidebarEntry* _tmp10_;
	LibraryLastImportSidebarEntry* _tmp11_;
	LibraryFlaggedSidebarEntry* _tmp12_;
	LibraryFlaggedSidebarEntry* _tmp13_;
	LibraryOfflineSidebarEntry* _tmp14_;
	LibraryOfflineSidebarEntry* _tmp15_;
	LibraryImportQueueSidebarEntry* _tmp16_;
	LibraryImportQueueSidebarEntry* _tmp17_;
	LibraryPhotosEntry* _tmp18_;
	LibraryRawsEntry* _tmp19_;
	LibraryTrashSidebarEntry* _tmp20_;
	LibraryVideosEntry* _tmp21_;
	LibraryFlaggedSidebarEntry* _tmp22_;
	LibraryLastImportSidebarEntry* _tmp23_;
	LibraryImportQueueSidebarEntry* _tmp24_;
	LibraryOfflineSidebarEntry* _tmp25_;
	_tmp0_ = sidebar_grouping_new (_ ("Library"), NULL, NULL);
	_tmp1_ = _tmp0_;
	self = (LibraryBranch*) sidebar_branch_construct (object_type, (SidebarEntry*) _tmp1_, SIDEBAR_BRANCH_OPTIONS_STARTUP_OPEN_GROUPING, _library_branch_comparator_gcompare_func, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = library_photos_entry_new ();
	_tmp3_ = _tmp2_;
	library_branch_set_photos_entry (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = library_videos_entry_new ();
	_tmp5_ = _tmp4_;
	library_branch_set_videos_entry (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = library_raws_entry_new ();
	_tmp7_ = _tmp6_;
	library_branch_set_raws_entry (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = library_trash_sidebar_entry_new ();
	_tmp9_ = _tmp8_;
	library_branch_set_trash_entry (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = library_last_import_sidebar_entry_new ();
	_tmp11_ = _tmp10_;
	library_branch_set_last_imported_entry (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = library_flagged_sidebar_entry_new ();
	_tmp13_ = _tmp12_;
	library_branch_set_flagged_entry (self, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = library_offline_sidebar_entry_new ();
	_tmp15_ = _tmp14_;
	library_branch_set_offline_entry (self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = library_import_queue_sidebar_entry_new ();
	_tmp17_ = _tmp16_;
	library_branch_set_import_queue_entry (self, _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = self->priv->_photos_entry;
	library_branch_insert (self, (SidebarEntry*) _tmp18_, (gint) LIBRARY_BRANCH_ENTRY_POSITION_PHOTOS);
	_tmp19_ = self->priv->_raws_entry;
	library_branch_insert (self, (SidebarEntry*) _tmp19_, (gint) LIBRARY_BRANCH_ENTRY_POSITION_RAWS);
	_tmp20_ = self->priv->_trash_entry;
	library_branch_insert (self, (SidebarEntry*) _tmp20_, (gint) LIBRARY_BRANCH_ENTRY_POSITION_TRASH);
	_tmp21_ = self->priv->_videos_entry;
	g_signal_connect_object ((LibraryHideablePageEntry*) _tmp21_, "visibility-changed", (GCallback) _library_branch_on_videos_visibility_changed_library_hideable_page_entry_visibility_changed, self, 0);
	library_branch_on_videos_visibility_changed (self);
	_tmp22_ = self->priv->_flagged_entry;
	g_signal_connect_object ((LibraryHideablePageEntry*) _tmp22_, "visibility-changed", (GCallback) _library_branch_on_flagged_visibility_changed_library_hideable_page_entry_visibility_changed, self, 0);
	library_branch_on_flagged_visibility_changed (self);
	_tmp23_ = self->priv->_last_imported_entry;
	g_signal_connect_object ((LibraryHideablePageEntry*) _tmp23_, "visibility-changed", (GCallback) _library_branch_on_last_imported_visibility_changed_library_hideable_page_entry_visibility_changed, self, 0);
	library_branch_on_last_imported_visibility_changed (self);
	_tmp24_ = self->priv->_import_queue_entry;
	g_signal_connect_object ((LibraryHideablePageEntry*) _tmp24_, "visibility-changed", (GCallback) _library_branch_on_import_queue_visibility_changed_library_hideable_page_entry_visibility_changed, self, 0);
	library_branch_on_import_queue_visibility_changed (self);
	_tmp25_ = self->priv->_offline_entry;
	g_signal_connect_object ((LibraryHideablePageEntry*) _tmp25_, "visibility-changed", (GCallback) _library_branch_on_offline_visibility_changed_library_hideable_page_entry_visibility_changed, self, 0);
	library_branch_on_offline_visibility_changed (self);
	return self;
}

LibraryBranch*
library_branch_new (void)
{
	return library_branch_construct (LIBRARY_TYPE_BRANCH);
}

static void
library_branch_insert (LibraryBranch* self,
                       SidebarEntry* entry,
                       gint position)
{
	SidebarEntry* _tmp0_;
	SidebarEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	g_object_set_data_full ((GObject*) entry, LIBRARY_BRANCH_POSITION_DATA, (gpointer) ((gintptr) position), NULL);
	_tmp0_ = sidebar_branch_get_root ((SidebarBranch*) self);
	_tmp1_ = _tmp0_;
	sidebar_branch_graft ((SidebarBranch*) self, _tmp1_, entry, NULL);
	_g_object_unref0 (_tmp1_);
}

static void
library_branch_on_videos_visibility_changed (LibraryBranch* self)
{
	LibraryVideosEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_videos_entry;
	library_branch_update_entry_visibility (self, (LibraryHideablePageEntry*) _tmp0_, (gint) LIBRARY_BRANCH_ENTRY_POSITION_VIDEOS);
}

static void
library_branch_on_flagged_visibility_changed (LibraryBranch* self)
{
	LibraryFlaggedSidebarEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_flagged_entry;
	library_branch_update_entry_visibility (self, (LibraryHideablePageEntry*) _tmp0_, (gint) LIBRARY_BRANCH_ENTRY_POSITION_FLAGGED);
}

static void
library_branch_on_last_imported_visibility_changed (LibraryBranch* self)
{
	LibraryLastImportSidebarEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_last_imported_entry;
	library_branch_update_entry_visibility (self, (LibraryHideablePageEntry*) _tmp0_, (gint) LIBRARY_BRANCH_ENTRY_POSITION_LAST_IMPORTED);
}

static void
library_branch_on_import_queue_visibility_changed (LibraryBranch* self)
{
	LibraryImportQueueSidebarEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_import_queue_entry;
	library_branch_update_entry_visibility (self, (LibraryHideablePageEntry*) _tmp0_, (gint) LIBRARY_BRANCH_ENTRY_POSITION_IMPORT_QUEUE);
}

static void
library_branch_on_offline_visibility_changed (LibraryBranch* self)
{
	LibraryOfflineSidebarEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_offline_entry;
	library_branch_update_entry_visibility (self, (LibraryHideablePageEntry*) _tmp0_, (gint) LIBRARY_BRANCH_ENTRY_POSITION_OFFLINE);
}

static void
library_branch_update_entry_visibility (LibraryBranch* self,
                                        LibraryHideablePageEntry* entry,
                                        gint position)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = library_hideable_page_entry_get_visible (entry);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		if (!sidebar_branch_has_entry ((SidebarBranch*) self, (SidebarEntry*) entry)) {
			library_branch_insert (self, (SidebarEntry*) entry, position);
		}
	} else {
		if (sidebar_branch_has_entry ((SidebarBranch*) self, (SidebarEntry*) entry)) {
			sidebar_branch_prune ((SidebarBranch*) self, (SidebarEntry*) entry);
		}
	}
}

static gint
library_branch_comparator (SidebarEntry* a,
                           SidebarEntry* b)
{
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_object_get_data ((GObject*) a, LIBRARY_BRANCH_POSITION_DATA);
	_tmp1_ = g_object_get_data ((GObject*) b, LIBRARY_BRANCH_POSITION_DATA);
	result = ((gint) ((gintptr) _tmp0_)) - ((gint) ((gintptr) _tmp1_));
	return result;
}

LibraryPhotosEntry*
library_branch_get_photos_entry (LibraryBranch* self)
{
	LibraryPhotosEntry* result;
	LibraryPhotosEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_photos_entry;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
library_branch_set_photos_entry (LibraryBranch* self,
                                 LibraryPhotosEntry* value)
{
	LibraryPhotosEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = library_branch_get_photos_entry (self);
	if (old_value != value) {
		LibraryPhotosEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_photos_entry);
		self->priv->_photos_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, library_branch_properties[LIBRARY_BRANCH_PHOTOS_ENTRY_PROPERTY]);
	}
}

LibraryVideosEntry*
library_branch_get_videos_entry (LibraryBranch* self)
{
	LibraryVideosEntry* result;
	LibraryVideosEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_videos_entry;
	result = _tmp0_;
	return result;
}

static void
library_branch_set_videos_entry (LibraryBranch* self,
                                 LibraryVideosEntry* value)
{
	LibraryVideosEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = library_branch_get_videos_entry (self);
	if (old_value != value) {
		LibraryVideosEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_videos_entry);
		self->priv->_videos_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, library_branch_properties[LIBRARY_BRANCH_VIDEOS_ENTRY_PROPERTY]);
	}
}

LibraryRawsEntry*
library_branch_get_raws_entry (LibraryBranch* self)
{
	LibraryRawsEntry* result;
	LibraryRawsEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_raws_entry;
	result = _tmp0_;
	return result;
}

static void
library_branch_set_raws_entry (LibraryBranch* self,
                               LibraryRawsEntry* value)
{
	LibraryRawsEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = library_branch_get_raws_entry (self);
	if (old_value != value) {
		LibraryRawsEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_raws_entry);
		self->priv->_raws_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, library_branch_properties[LIBRARY_BRANCH_RAWS_ENTRY_PROPERTY]);
	}
}

LibraryFlaggedSidebarEntry*
library_branch_get_flagged_entry (LibraryBranch* self)
{
	LibraryFlaggedSidebarEntry* result;
	LibraryFlaggedSidebarEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_flagged_entry;
	result = _tmp0_;
	return result;
}

static void
library_branch_set_flagged_entry (LibraryBranch* self,
                                  LibraryFlaggedSidebarEntry* value)
{
	LibraryFlaggedSidebarEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = library_branch_get_flagged_entry (self);
	if (old_value != value) {
		LibraryFlaggedSidebarEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_flagged_entry);
		self->priv->_flagged_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, library_branch_properties[LIBRARY_BRANCH_FLAGGED_ENTRY_PROPERTY]);
	}
}

LibraryLastImportSidebarEntry*
library_branch_get_last_imported_entry (LibraryBranch* self)
{
	LibraryLastImportSidebarEntry* result;
	LibraryLastImportSidebarEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_imported_entry;
	result = _tmp0_;
	return result;
}

static void
library_branch_set_last_imported_entry (LibraryBranch* self,
                                        LibraryLastImportSidebarEntry* value)
{
	LibraryLastImportSidebarEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = library_branch_get_last_imported_entry (self);
	if (old_value != value) {
		LibraryLastImportSidebarEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_last_imported_entry);
		self->priv->_last_imported_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, library_branch_properties[LIBRARY_BRANCH_LAST_IMPORTED_ENTRY_PROPERTY]);
	}
}

LibraryImportQueueSidebarEntry*
library_branch_get_import_queue_entry (LibraryBranch* self)
{
	LibraryImportQueueSidebarEntry* result;
	LibraryImportQueueSidebarEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_import_queue_entry;
	result = _tmp0_;
	return result;
}

static void
library_branch_set_import_queue_entry (LibraryBranch* self,
                                       LibraryImportQueueSidebarEntry* value)
{
	LibraryImportQueueSidebarEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = library_branch_get_import_queue_entry (self);
	if (old_value != value) {
		LibraryImportQueueSidebarEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_import_queue_entry);
		self->priv->_import_queue_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, library_branch_properties[LIBRARY_BRANCH_IMPORT_QUEUE_ENTRY_PROPERTY]);
	}
}

LibraryOfflineSidebarEntry*
library_branch_get_offline_entry (LibraryBranch* self)
{
	LibraryOfflineSidebarEntry* result;
	LibraryOfflineSidebarEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_offline_entry;
	result = _tmp0_;
	return result;
}

static void
library_branch_set_offline_entry (LibraryBranch* self,
                                  LibraryOfflineSidebarEntry* value)
{
	LibraryOfflineSidebarEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = library_branch_get_offline_entry (self);
	if (old_value != value) {
		LibraryOfflineSidebarEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_offline_entry);
		self->priv->_offline_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, library_branch_properties[LIBRARY_BRANCH_OFFLINE_ENTRY_PROPERTY]);
	}
}

LibraryTrashSidebarEntry*
library_branch_get_trash_entry (LibraryBranch* self)
{
	LibraryTrashSidebarEntry* result;
	LibraryTrashSidebarEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_trash_entry;
	result = _tmp0_;
	return result;
}

static void
library_branch_set_trash_entry (LibraryBranch* self,
                                LibraryTrashSidebarEntry* value)
{
	LibraryTrashSidebarEntry* old_value;
	g_return_if_fail (self != NULL);
	old_value = library_branch_get_trash_entry (self);
	if (old_value != value) {
		LibraryTrashSidebarEntry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_trash_entry);
		self->priv->_trash_entry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, library_branch_properties[LIBRARY_BRANCH_TRASH_ENTRY_PROPERTY]);
	}
}

static void
library_branch_class_init (LibraryBranchClass * klass,
                           gpointer klass_data)
{
	library_branch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LibraryBranch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_library_branch_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_library_branch_set_property;
	G_OBJECT_CLASS (klass)->finalize = library_branch_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_BRANCH_PHOTOS_ENTRY_PROPERTY, library_branch_properties[LIBRARY_BRANCH_PHOTOS_ENTRY_PROPERTY] = g_param_spec_object ("photos-entry", "photos-entry", "photos-entry", LIBRARY_TYPE_PHOTOS_ENTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_BRANCH_VIDEOS_ENTRY_PROPERTY, library_branch_properties[LIBRARY_BRANCH_VIDEOS_ENTRY_PROPERTY] = g_param_spec_object ("videos-entry", "videos-entry", "videos-entry", LIBRARY_TYPE_VIDEOS_ENTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_BRANCH_RAWS_ENTRY_PROPERTY, library_branch_properties[LIBRARY_BRANCH_RAWS_ENTRY_PROPERTY] = g_param_spec_object ("raws-entry", "raws-entry", "raws-entry", LIBRARY_TYPE_RAWS_ENTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_BRANCH_FLAGGED_ENTRY_PROPERTY, library_branch_properties[LIBRARY_BRANCH_FLAGGED_ENTRY_PROPERTY] = g_param_spec_object ("flagged-entry", "flagged-entry", "flagged-entry", LIBRARY_TYPE_FLAGGED_SIDEBAR_ENTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_BRANCH_LAST_IMPORTED_ENTRY_PROPERTY, library_branch_properties[LIBRARY_BRANCH_LAST_IMPORTED_ENTRY_PROPERTY] = g_param_spec_object ("last-imported-entry", "last-imported-entry", "last-imported-entry", LIBRARY_TYPE_LAST_IMPORT_SIDEBAR_ENTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_BRANCH_IMPORT_QUEUE_ENTRY_PROPERTY, library_branch_properties[LIBRARY_BRANCH_IMPORT_QUEUE_ENTRY_PROPERTY] = g_param_spec_object ("import-queue-entry", "import-queue-entry", "import-queue-entry", LIBRARY_TYPE_IMPORT_QUEUE_SIDEBAR_ENTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_BRANCH_OFFLINE_ENTRY_PROPERTY, library_branch_properties[LIBRARY_BRANCH_OFFLINE_ENTRY_PROPERTY] = g_param_spec_object ("offline-entry", "offline-entry", "offline-entry", LIBRARY_TYPE_OFFLINE_SIDEBAR_ENTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_BRANCH_TRASH_ENTRY_PROPERTY, library_branch_properties[LIBRARY_BRANCH_TRASH_ENTRY_PROPERTY] = g_param_spec_object ("trash-entry", "trash-entry", "trash-entry", LIBRARY_TYPE_TRASH_SIDEBAR_ENTRY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
library_branch_instance_init (LibraryBranch * self,
                              gpointer klass)
{
	self->priv = library_branch_get_instance_private (self);
}

static void
library_branch_finalize (GObject * obj)
{
	LibraryBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_TYPE_BRANCH, LibraryBranch);
	_g_object_unref0 (self->priv->_photos_entry);
	_g_object_unref0 (self->priv->_videos_entry);
	_g_object_unref0 (self->priv->_raws_entry);
	_g_object_unref0 (self->priv->_flagged_entry);
	_g_object_unref0 (self->priv->_last_imported_entry);
	_g_object_unref0 (self->priv->_import_queue_entry);
	_g_object_unref0 (self->priv->_offline_entry);
	_g_object_unref0 (self->priv->_trash_entry);
	G_OBJECT_CLASS (library_branch_parent_class)->finalize (obj);
}

static GType
library_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryBranchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryBranch), 0, (GInstanceInitFunc) library_branch_instance_init, NULL };
	GType library_branch_type_id;
	library_branch_type_id = g_type_register_static (SIDEBAR_TYPE_BRANCH, "LibraryBranch", &g_define_type_info, 0);
	LibraryBranch_private_offset = g_type_add_instance_private (library_branch_type_id, sizeof (LibraryBranchPrivate));
	return library_branch_type_id;
}

GType
library_branch_get_type (void)
{
	static volatile gsize library_branch_type_id__once = 0;
	if (g_once_init_enter (&library_branch_type_id__once)) {
		GType library_branch_type_id;
		library_branch_type_id = library_branch_get_type_once ();
		g_once_init_leave (&library_branch_type_id__once, library_branch_type_id);
	}
	return library_branch_type_id__once;
}

static void
_vala_library_branch_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	LibraryBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIBRARY_TYPE_BRANCH, LibraryBranch);
	switch (property_id) {
		case LIBRARY_BRANCH_PHOTOS_ENTRY_PROPERTY:
		g_value_set_object (value, library_branch_get_photos_entry (self));
		break;
		case LIBRARY_BRANCH_VIDEOS_ENTRY_PROPERTY:
		g_value_set_object (value, library_branch_get_videos_entry (self));
		break;
		case LIBRARY_BRANCH_RAWS_ENTRY_PROPERTY:
		g_value_set_object (value, library_branch_get_raws_entry (self));
		break;
		case LIBRARY_BRANCH_FLAGGED_ENTRY_PROPERTY:
		g_value_set_object (value, library_branch_get_flagged_entry (self));
		break;
		case LIBRARY_BRANCH_LAST_IMPORTED_ENTRY_PROPERTY:
		g_value_set_object (value, library_branch_get_last_imported_entry (self));
		break;
		case LIBRARY_BRANCH_IMPORT_QUEUE_ENTRY_PROPERTY:
		g_value_set_object (value, library_branch_get_import_queue_entry (self));
		break;
		case LIBRARY_BRANCH_OFFLINE_ENTRY_PROPERTY:
		g_value_set_object (value, library_branch_get_offline_entry (self));
		break;
		case LIBRARY_BRANCH_TRASH_ENTRY_PROPERTY:
		g_value_set_object (value, library_branch_get_trash_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_library_branch_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	LibraryBranch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIBRARY_TYPE_BRANCH, LibraryBranch);
	switch (property_id) {
		case LIBRARY_BRANCH_PHOTOS_ENTRY_PROPERTY:
		library_branch_set_photos_entry (self, g_value_get_object (value));
		break;
		case LIBRARY_BRANCH_VIDEOS_ENTRY_PROPERTY:
		library_branch_set_videos_entry (self, g_value_get_object (value));
		break;
		case LIBRARY_BRANCH_RAWS_ENTRY_PROPERTY:
		library_branch_set_raws_entry (self, g_value_get_object (value));
		break;
		case LIBRARY_BRANCH_FLAGGED_ENTRY_PROPERTY:
		library_branch_set_flagged_entry (self, g_value_get_object (value));
		break;
		case LIBRARY_BRANCH_LAST_IMPORTED_ENTRY_PROPERTY:
		library_branch_set_last_imported_entry (self, g_value_get_object (value));
		break;
		case LIBRARY_BRANCH_IMPORT_QUEUE_ENTRY_PROPERTY:
		library_branch_set_import_queue_entry (self, g_value_get_object (value));
		break;
		case LIBRARY_BRANCH_OFFLINE_ENTRY_PROPERTY:
		library_branch_set_offline_entry (self, g_value_get_object (value));
		break;
		case LIBRARY_BRANCH_TRASH_ENTRY_PROPERTY:
		library_branch_set_trash_entry (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
library_hideable_page_entry_get_instance_private (LibraryHideablePageEntry* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryHideablePageEntry_private_offset);
}

LibraryHideablePageEntry*
library_hideable_page_entry_construct (GType object_type)
{
	LibraryHideablePageEntry * self = NULL;
	self = (LibraryHideablePageEntry*) sidebar_simple_page_entry_construct (object_type);
	return self;
}

gboolean
library_hideable_page_entry_get_visible (LibraryHideablePageEntry* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->show_entry;
	return result;
}

void
library_hideable_page_entry_set_visible (LibraryHideablePageEntry* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value == self->priv->show_entry) {
		return;
	}
	self->priv->show_entry = value;
	g_signal_emit (self, library_hideable_page_entry_signals[LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBILITY_CHANGED_SIGNAL], 0, value);
	g_object_notify_by_pspec ((GObject *) self, library_hideable_page_entry_properties[LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBLE_PROPERTY]);
}

static void
library_hideable_page_entry_class_init (LibraryHideablePageEntryClass * klass,
                                        gpointer klass_data)
{
	library_hideable_page_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LibraryHideablePageEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_library_hideable_page_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_library_hideable_page_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = library_hideable_page_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBLE_PROPERTY, library_hideable_page_entry_properties[LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBLE_PROPERTY] = g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	library_hideable_page_entry_signals[LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBILITY_CHANGED_SIGNAL] = g_signal_new ("visibility-changed", LIBRARY_TYPE_HIDEABLE_PAGE_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
library_hideable_page_entry_instance_init (LibraryHideablePageEntry * self,
                                           gpointer klass)
{
	self->priv = library_hideable_page_entry_get_instance_private (self);
	self->priv->show_entry = FALSE;
}

static void
library_hideable_page_entry_finalize (GObject * obj)
{
	LibraryHideablePageEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_TYPE_HIDEABLE_PAGE_ENTRY, LibraryHideablePageEntry);
	G_OBJECT_CLASS (library_hideable_page_entry_parent_class)->finalize (obj);
}

static GType
library_hideable_page_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryHideablePageEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_hideable_page_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryHideablePageEntry), 0, (GInstanceInitFunc) library_hideable_page_entry_instance_init, NULL };
	GType library_hideable_page_entry_type_id;
	library_hideable_page_entry_type_id = g_type_register_static (SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, "LibraryHideablePageEntry", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	LibraryHideablePageEntry_private_offset = g_type_add_instance_private (library_hideable_page_entry_type_id, sizeof (LibraryHideablePageEntryPrivate));
	return library_hideable_page_entry_type_id;
}

GType
library_hideable_page_entry_get_type (void)
{
	static volatile gsize library_hideable_page_entry_type_id__once = 0;
	if (g_once_init_enter (&library_hideable_page_entry_type_id__once)) {
		GType library_hideable_page_entry_type_id;
		library_hideable_page_entry_type_id = library_hideable_page_entry_get_type_once ();
		g_once_init_leave (&library_hideable_page_entry_type_id__once, library_hideable_page_entry_type_id);
	}
	return library_hideable_page_entry_type_id__once;
}

static void
_vala_library_hideable_page_entry_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	LibraryHideablePageEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIBRARY_TYPE_HIDEABLE_PAGE_ENTRY, LibraryHideablePageEntry);
	switch (property_id) {
		case LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBLE_PROPERTY:
		g_value_set_boolean (value, library_hideable_page_entry_get_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_library_hideable_page_entry_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	LibraryHideablePageEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIBRARY_TYPE_HIDEABLE_PAGE_ENTRY, LibraryHideablePageEntry);
	switch (property_id) {
		case LIBRARY_HIDEABLE_PAGE_ENTRY_VISIBLE_PROPERTY:
		library_hideable_page_entry_set_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

LibraryMainPage*
library_main_page_construct (GType object_type,
                             ProgressMonitor monitor,
                             gpointer monitor_target)
{
	LibraryMainPage * self = NULL;
	self = (LibraryMainPage*) collection_page_construct (object_type, LIBRARY_MAIN_PAGE_NAME);
	{
		GeeIterator* _sources_it = NULL;
		MediaCollectionRegistry* _tmp0_;
		MediaCollectionRegistry* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = media_collection_registry_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = media_collection_registry_get_all (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_media_collection_registry_unref0 (_tmp1_);
		_sources_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			MediaSourceCollection* sources = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			ViewCollection* _tmp9_;
			ViewCollection* _tmp10_;
			MediaSourceCollection* _tmp11_;
			CollectionViewManager* _tmp12_;
			CollectionViewManager* _tmp13_;
			ViewCollectionMonitor* _tmp14_;
			ViewCollectionMonitor* _tmp15_;
			_tmp6_ = _sources_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _sources_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			sources = (MediaSourceCollection*) _tmp8_;
			_tmp9_ = page_get_view ((Page*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = sources;
			_tmp12_ = collection_view_manager_new ((CollectionPage*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = view_collection_monitor_source_collection (_tmp10_, (SourceCollection*) _tmp11_, (ViewManager*) _tmp13_, NULL, NULL, monitor, monitor_target);
			_tmp15_ = _tmp14_;
			_view_collection_monitor_unref0 (_tmp15_);
			_view_manager_unref0 (_tmp13_);
			_data_collection_unref0 (_tmp10_);
			_data_collection_unref0 (sources);
		}
		_g_object_unref0 (_sources_it);
	}
	return self;
}

LibraryMainPage*
library_main_page_new (ProgressMonitor monitor,
                       gpointer monitor_target)
{
	return library_main_page_construct (LIBRARY_TYPE_MAIN_PAGE, monitor, monitor_target);
}

static gchar*
library_main_page_real_get_back_name (CheckerboardPage* base)
{
	LibraryMainPage * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LibraryMainPage*) base;
	_tmp0_ = g_strdup (_ ("All Photos"));
	result = _tmp0_;
	return result;
}

static void
library_main_page_class_init (LibraryMainPageClass * klass,
                              gpointer klass_data)
{
	library_main_page_parent_class = g_type_class_peek_parent (klass);
	((CheckerboardPageClass *) klass)->get_back_name = (gchar* (*) (CheckerboardPage*)) library_main_page_real_get_back_name;
}

static void
library_main_page_instance_init (LibraryMainPage * self,
                                 gpointer klass)
{
}

static GType
library_main_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryMainPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_main_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMainPage), 0, (GInstanceInitFunc) library_main_page_instance_init, NULL };
	GType library_main_page_type_id;
	library_main_page_type_id = g_type_register_static (TYPE_COLLECTION_PAGE, "LibraryMainPage", &g_define_type_info, 0);
	return library_main_page_type_id;
}

GType
library_main_page_get_type (void)
{
	static volatile gsize library_main_page_type_id__once = 0;
	if (g_once_init_enter (&library_main_page_type_id__once)) {
		GType library_main_page_type_id;
		library_main_page_type_id = library_main_page_get_type_once ();
		g_once_init_leave (&library_main_page_type_id__once, library_main_page_type_id);
	}
	return library_main_page_type_id__once;
}

