// python wrapper for vtkPVDataRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVDataRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVDataRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVDataRepresentation_ClassNew(); }


static PyObject *
PyvtkPVDataRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVDataRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVDataRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVDataRepresentation *tempr = vtkPVDataRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVDataRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVDataRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVDataRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkPVDataRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_MarkModified(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MarkModified");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MarkModified();
    }
    else
    {
      op->vtkPVDataRepresentation::MarkModified();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  unsigned int temp0;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->Initialize(temp0, temp1) :
      op->vtkPVDataRepresentation::Initialize(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetUniqueIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUniqueIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetUniqueIdentifier() :
      op->vtkPVDataRepresentation::GetUniqueIdentifier());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkPVDataRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVisibility() :
      op->vtkPVDataRepresentation::GetVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetRenderedDataObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderedDataObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetRenderedDataObject(temp0) :
      op->vtkPVDataRepresentation::GetRenderedDataObject(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_SetUpdateTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUpdateTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUpdateTime(temp0);
    }
    else
    {
      op->vtkPVDataRepresentation::SetUpdateTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetUpdateTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUpdateTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetUpdateTime() :
      op->vtkPVDataRepresentation::GetUpdateTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetUpdateTimeValid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUpdateTimeValid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUpdateTimeValid() :
      op->vtkPVDataRepresentation::GetUpdateTimeValid());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_ResetUpdateTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetUpdateTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetUpdateTime();
    }
    else
    {
      op->vtkPVDataRepresentation::ResetUpdateTime();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_SetForcedCacheKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForcedCacheKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForcedCacheKey(temp0);
    }
    else
    {
      op->vtkPVDataRepresentation::SetForcedCacheKey(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_SetForceUseCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceUseCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceUseCache(temp0);
    }
    else
    {
      op->vtkPVDataRepresentation::SetForceUseCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetForcedCacheKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForcedCacheKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetForcedCacheKey() :
      op->vtkPVDataRepresentation::GetForcedCacheKey());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetForceUseCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceUseCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceUseCache() :
      op->vtkPVDataRepresentation::GetForceUseCache());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetCacheKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCacheKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetCacheKey() :
      op->vtkPVDataRepresentation::GetCacheKey());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_AddToView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddToView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  vtkView *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkView"))
  {
    bool tempr = (ap.IsBound() ?
      op->AddToView(temp0) :
      op->vtkPVDataRepresentation::AddToView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_RemoveFromView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveFromView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  vtkView *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkView"))
  {
    bool tempr = (ap.IsBound() ?
      op->RemoveFromView(temp0) :
      op->vtkPVDataRepresentation::RemoveFromView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetInternalOutputPort_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInternalOutputPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithmOutput *tempr = (ap.IsBound() ?
      op->GetInternalOutputPort() :
      op->vtkPVDataRepresentation::GetInternalOutputPort());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataRepresentation_GetInternalOutputPort_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInternalOutputPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkAlgorithmOutput *tempr = (ap.IsBound() ?
      op->GetInternalOutputPort(temp0) :
      op->vtkPVDataRepresentation::GetInternalOutputPort(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataRepresentation_GetInternalOutputPort_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInternalOutputPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkAlgorithmOutput *tempr = (ap.IsBound() ?
      op->GetInternalOutputPort(temp0, temp1) :
      op->vtkPVDataRepresentation::GetInternalOutputPort(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataRepresentation_GetInternalOutputPort(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVDataRepresentation_GetInternalOutputPort_s1(self, args);
    case 1:
      return PyvtkPVDataRepresentation_GetInternalOutputPort_s2(self, args);
    case 2:
      return PyvtkPVDataRepresentation_GetInternalOutputPort_s3(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetInternalOutputPort");
  return nullptr;
}


static PyObject *
PyvtkPVDataRepresentation_GetView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkView *tempr = (ap.IsBound() ?
      op->GetView() :
      op->vtkPVDataRepresentation::GetView());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetPipelineDataTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPipelineDataTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetPipelineDataTime() :
      op->vtkPVDataRepresentation::GetPipelineDataTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_SetLogName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLogName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLogName(temp0);
    }
    else
    {
      op->vtkPVDataRepresentation::SetLogName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetLogName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLogName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetLogName() :
      &op->vtkPVDataRepresentation::GetLogName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetHasTemporalPipeline(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHasTemporalPipeline");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHasTemporalPipeline() :
      op->vtkPVDataRepresentation::GetHasTemporalPipeline());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_SetHasTemporalPipeline(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHasTemporalPipeline");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHasTemporalPipeline(temp0);
    }
    else
    {
      op->vtkPVDataRepresentation::SetHasTemporalPipeline(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_GetNeedsUpdate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNeedsUpdate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNeedsUpdate() :
      op->vtkPVDataRepresentation::GetNeedsUpdate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVDataRepresentation_SetInputConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  int temp0;
  vtkAlgorithmOutput *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetInputConnection(temp0, temp1);
    }
    else
    {
      op->vtkPVDataRepresentation::SetInputConnection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataRepresentation_SetInputConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->SetInputConnection(temp0);
    }
    else
    {
      op->vtkPVDataRepresentation::SetInputConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataRepresentation_SetInputConnection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVDataRepresentation_SetInputConnection_s1(self, args);
    case 1:
      return PyvtkPVDataRepresentation_SetInputConnection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetInputConnection");
  return nullptr;
}


static PyObject *
PyvtkPVDataRepresentation_AddInputConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  int temp0;
  vtkAlgorithmOutput *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->AddInputConnection(temp0, temp1);
    }
    else
    {
      op->vtkPVDataRepresentation::AddInputConnection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataRepresentation_AddInputConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInputConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  vtkAlgorithmOutput *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithmOutput"))
  {
    if (ap.IsBound())
    {
      op->AddInputConnection(temp0);
    }
    else
    {
      op->vtkPVDataRepresentation::AddInputConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVDataRepresentation_AddInputConnection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPVDataRepresentation_AddInputConnection_s1(self, args);
    case 1:
      return PyvtkPVDataRepresentation_AddInputConnection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AddInputConnection");
  return nullptr;
}


static PyObject *
PyvtkPVDataRepresentation_SetArrayIdNames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayIdNames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVDataRepresentation *op = static_cast<vtkPVDataRepresentation *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetArrayIdNames(temp0, temp1);
    }
    else
    {
      op->vtkPVDataRepresentation::SetArrayIdNames(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVDataRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkPVDataRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVDataRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVDataRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVDataRepresentation\nC++: static vtkPVDataRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVDataRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVDataRepresentation\nC++: vtkPVDataRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVDataRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVDataRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ProcessViewRequest", PyvtkPVDataRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: virtual int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo)\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n\note Starting with ParaView 5.8, this method is no longer called\nfor hidden representation i.e. representations for which\n`vtkDataRepresentation::GetVisibility()` returns false.\n"},
  {"MarkModified", PyvtkPVDataRepresentation_MarkModified, METH_VARARGS,
   "MarkModified(self) -> None\nC++: virtual void MarkModified()\n\nThis is one of the most important functions. In VTK pipelines,\nit's very easy for the pipeline to decide when it needs to\nre-execute. vtkAlgorithm::Update() can go up the entire pipeline\nto see if any filters MTime changed (among other things) and if\nso, it can re-execute the pipeline. However in case of\nrepresentations, the real input connection may only be present on\nthe data-server nodes. In that case the\nvtkPVDataRepresentation::RequestData() will only get called on\nthe data-server nodes. That means that representations won't be\nable to any data-delivery in RequestData(). We'd need some other\nmechanisms to synchronize data-delivery among processes. To avoid\nthat conundrum, the vtkSMRepresentationProxy calls MarkModified()\non all processes whenever any filter in the pipeline is modified.\nIn this method, the vtkPVDataRepresentation subclasses should\nensure that they mark all delivery related filters dirty in their\nRequestData to ensure they execute then next time they are\nupdated. The vtkPVDataRepresentation also uses a special\nexecutive which avoids updating the representation unless\nMarkModified() was called since the last Update(), thus acting as\na update-suppressor.\n"},
  {"Initialize", PyvtkPVDataRepresentation_Initialize, METH_VARARGS,
   "Initialize(self, minIdAvailable:int, maxIdAvailable:int) -> int\nC++: virtual unsigned int Initialize(unsigned int minIdAvailable,\n    unsigned int maxIdAvailable)\n\nInitialize the representation with an identifier range so each\ninternal representation can own a unique ID. If a representation\nrequires more IDs than the set of ids provided, the\nrepresentation MUST complains by an error or abort explaining how\nmany ids where expected so the number of reserved ids could be\neasily adjust. Unless noted otherwise, this method must be called\nbefore calling any other methods on this class.\n\note CallOnAllProcesses Internally you can pick an id that follow\nthat condition minIdAvailable <= id <= maxIdAvailable Return the\nminIdAvailable after initialization so that new range could be\nused\n"},
  {"GetUniqueIdentifier", PyvtkPVDataRepresentation_GetUniqueIdentifier, METH_VARARGS,
   "GetUniqueIdentifier(self) -> int\nC++: unsigned int GetUniqueIdentifier()\n\nReturn 0 if the Initialize() method was not called otherwise a\nunique ID that will be shared across the processes for that same\nobject.\n"},
  {"SetVisibility", PyvtkPVDataRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, val:bool) -> None\nC++: virtual void SetVisibility(bool val)\n\nGet/Set the visibility for this representation. When the\nvisibility of representation of false, all view passes are\nignored.\n"},
  {"GetVisibility", PyvtkPVDataRepresentation_GetVisibility, METH_VARARGS,
   "GetVisibility(self) -> bool\nC++: virtual bool GetVisibility()\n\n"},
  {"GetRenderedDataObject", PyvtkPVDataRepresentation_GetRenderedDataObject, METH_VARARGS,
   "GetRenderedDataObject(self, port:int) -> vtkDataObject\nC++: virtual vtkDataObject *GetRenderedDataObject(int port)\n\nReturns the data object that is rendered from the given input\nport.\n"},
  {"SetUpdateTime", PyvtkPVDataRepresentation_SetUpdateTime, METH_VARARGS,
   "SetUpdateTime(self, time:float) -> None\nC++: virtual void SetUpdateTime(double time)\n\nSet the update time.\n"},
  {"GetUpdateTime", PyvtkPVDataRepresentation_GetUpdateTime, METH_VARARGS,
   "GetUpdateTime(self) -> float\nC++: virtual double GetUpdateTime()\n\n"},
  {"GetUpdateTimeValid", PyvtkPVDataRepresentation_GetUpdateTimeValid, METH_VARARGS,
   "GetUpdateTimeValid(self) -> bool\nC++: virtual bool GetUpdateTimeValid()\n\nGet whether the UpdateTime is valid. `ResetUpdateTime` can be\nused to clear the UpdateTimeValid flag.\n"},
  {"ResetUpdateTime", PyvtkPVDataRepresentation_ResetUpdateTime, METH_VARARGS,
   "ResetUpdateTime(self) -> None\nC++: void ResetUpdateTime()\n\n"},
  {"SetForcedCacheKey", PyvtkPVDataRepresentation_SetForcedCacheKey, METH_VARARGS,
   "SetForcedCacheKey(self, val:float) -> None\nC++: virtual void SetForcedCacheKey(double val)\n\nGenerally, caching is within the purview of the vtkPVView (and\nsubclasses). However, a representation may choose to override\nthat caching by forcing specific caching parameters. This is\nprimarily intended for views like comparative view that rely on\ncaching to show multiple frames from the same pipeline at a time.\n"},
  {"SetForceUseCache", PyvtkPVDataRepresentation_SetForceUseCache, METH_VARARGS,
   "SetForceUseCache(self, val:bool) -> None\nC++: virtual void SetForceUseCache(bool val)\n\n"},
  {"GetForcedCacheKey", PyvtkPVDataRepresentation_GetForcedCacheKey, METH_VARARGS,
   "GetForcedCacheKey(self) -> float\nC++: virtual double GetForcedCacheKey()\n\n"},
  {"GetForceUseCache", PyvtkPVDataRepresentation_GetForceUseCache, METH_VARARGS,
   "GetForceUseCache(self) -> bool\nC++: virtual bool GetForceUseCache()\n\n"},
  {"GetCacheKey", PyvtkPVDataRepresentation_GetCacheKey, METH_VARARGS,
   "GetCacheKey(self) -> float\nC++: double GetCacheKey()\n\nReturns the cache-key the representation is currently using. This\ntakes into consideration whether ForcedCacheKey is to be used.\n"},
  {"AddToView", PyvtkPVDataRepresentation_AddToView, METH_VARARGS,
   "AddToView(self, view:vtkView) -> bool\nC++: bool AddToView(vtkView *view) override;\n\nMaking these methods public. When constructing composite\nrepresentations, we need to call these methods directly on\ninternal representations.\n"},
  {"RemoveFromView", PyvtkPVDataRepresentation_RemoveFromView, METH_VARARGS,
   "RemoveFromView(self, view:vtkView) -> bool\nC++: bool RemoveFromView(vtkView *view) override;\n\nRemoves the representation to the view.  This is called from\nvtkView::RemoveRepresentation().  Subclasses should override this\nmethod. Returns true if the removal succeeds.\n"},
  {"GetInternalOutputPort", PyvtkPVDataRepresentation_GetInternalOutputPort, METH_VARARGS,
   "GetInternalOutputPort(self) -> vtkAlgorithmOutput\nC++: vtkAlgorithmOutput *GetInternalOutputPort() override;\nGetInternalOutputPort(self, port:int) -> vtkAlgorithmOutput\nC++: vtkAlgorithmOutput *GetInternalOutputPort(int port) override;\nGetInternalOutputPort(self, port:int, conn:int)\n    -> vtkAlgorithmOutput\nC++: vtkAlgorithmOutput *GetInternalOutputPort(int port, int conn)\n     override;\n\nRetrieves an output port for the input data object at the\nspecified port and connection index. This may be connected to the\nrepresentation's internal pipeline. Overridden to use\nvtkPVTrivialProducer instead of vtkTrivialProducer\n"},
  {"GetView", PyvtkPVDataRepresentation_GetView, METH_VARARGS,
   "GetView(self) -> vtkView\nC++: vtkView *GetView()\n\nProvides access to the view.\n"},
  {"GetPipelineDataTime", PyvtkPVDataRepresentation_GetPipelineDataTime, METH_VARARGS,
   "GetPipelineDataTime(self) -> int\nC++: vtkMTimeType GetPipelineDataTime()\n\nReturns the timestamp when `RequestData` was executed on the\nrepresentation.\n"},
  {"SetLogName", PyvtkPVDataRepresentation_SetLogName, METH_VARARGS,
   "SetLogName(self, name:str) -> None\nC++: virtual void SetLogName(const std::string &name)\n\nThis is solely intended to simplify debugging and use for any\nother purpose is vehemently discouraged.\n"},
  {"GetLogName", PyvtkPVDataRepresentation_GetLogName, METH_VARARGS,
   "GetLogName(self) -> str\nC++: const std::string &GetLogName()\n\n"},
  {"GetHasTemporalPipeline", PyvtkPVDataRepresentation_GetHasTemporalPipeline, METH_VARARGS,
   "GetHasTemporalPipeline(self) -> bool\nC++: virtual bool GetHasTemporalPipeline()\n\nThis flag indicates if the representation is for a temporal\npipeline. If true, then calling `SetUpdateTime` will result in\ncalling `this->MarkModified()` i.e. will cause the representation\nto update on subsequent update request. Otherwise, the subsequent\nupdate request will be a no-op (unless the representation ended\nup calling MarkModified due to other changes i.e. change in input\npipeline). `HasTemporalPipeline` gets set in the first update on\nthe representation, however, only on the data-server side.\nvtkPVView ensures that the flag is synced up among all ranks at\nthe end of each `vtkPVView::Update` call.\n"},
  {"SetHasTemporalPipeline", PyvtkPVDataRepresentation_SetHasTemporalPipeline, METH_VARARGS,
   "SetHasTemporalPipeline(self, _arg:bool) -> None\nC++: virtual void SetHasTemporalPipeline(bool _arg)\n\n"},
  {"GetNeedsUpdate", PyvtkPVDataRepresentation_GetNeedsUpdate, METH_VARARGS,
   "GetNeedsUpdate(self) -> bool\nC++: bool GetNeedsUpdate()\n\nReturns true if the representation needs an update.\n"},
  {"SetInputConnection", PyvtkPVDataRepresentation_SetInputConnection, METH_VARARGS,
   "SetInputConnection(self, port:int, input:vtkAlgorithmOutput)\n    -> None\nC++: void SetInputConnection(int port, vtkAlgorithmOutput *input)\n    override;\nSetInputConnection(self, input:vtkAlgorithmOutput) -> None\nC++: virtual void SetInputConnection(vtkAlgorithmOutput *input)\n\nOverridden to ensure that `MarkModified` is called.\n"},
  {"AddInputConnection", PyvtkPVDataRepresentation_AddInputConnection, METH_VARARGS,
   "AddInputConnection(self, port:int, input:vtkAlgorithmOutput)\n    -> None\nC++: void AddInputConnection(int port, vtkAlgorithmOutput *input)\n    override;\nAddInputConnection(self, input:vtkAlgorithmOutput) -> None\nC++: virtual void AddInputConnection(vtkAlgorithmOutput *input)\n\nAdd a connection to the given input port index.  See\nSetInputConnection() for details on input connections.  This\nmethod is the complement to RemoveInputConnection() in that it\nadds only the connection specified without affecting other\nconnections.  Typical usage is\n\n* filter2->AddInputConnection(0, filter1->GetOutputPort(0)).\n"},
  {"SetArrayIdNames", PyvtkPVDataRepresentation_SetArrayIdNames, METH_VARARGS,
   "SetArrayIdNames(self, pointArray:str, cellArray:str) -> None\nC++: virtual void SetArrayIdNames(const char *pointArray,\n    const char *cellArray)\n\nSpecify the array names used for the selection. Empty method to\nbe implemented by inheriting classes\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVDataRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetVisibility/SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("update_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetUpdateTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataRepresentation_SetUpdateTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataRepresentation_SetUpdateTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUpdateTime/SetUpdateTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("forced_cache_key"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetForcedCacheKey(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataRepresentation_SetForcedCacheKey(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataRepresentation_SetForcedCacheKey(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForcedCacheKey/SetForcedCacheKey\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_use_cache"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetForceUseCache(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataRepresentation_SetForceUseCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataRepresentation_SetForceUseCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceUseCache/SetForceUseCache\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("log_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetLogName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataRepresentation_SetLogName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataRepresentation_SetLogName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLogName/SetLogName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("has_temporal_pipeline"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetHasTemporalPipeline(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataRepresentation_SetHasTemporalPipeline(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataRepresentation_SetHasTemporalPipeline(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHasTemporalPipeline/SetHasTemporalPipeline\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_connection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVDataRepresentation_SetInputConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVDataRepresentation_SetInputConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("unique_identifier"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetUniqueIdentifier(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUniqueIdentifier\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("update_time_valid"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetUpdateTimeValid(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUpdateTimeValid\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cache_key"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetCacheKey(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCacheKey\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("internal_output_port"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetInternalOutputPort(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInternalOutputPort\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("view"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetView(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetView\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pipeline_data_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetPipelineDataTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPipelineDataTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("needs_update"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVDataRepresentation_GetNeedsUpdate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNeedsUpdate\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVDataRepresentation_Doc =
  "vtkPVDataRepresentation - vtkPVDataRepresentation adds some ParaView\nspecific API to data representations.\n\n"
  "Superclass: vtkDataRepresentation\n\n"
  "@sa\n"
  "vtkPVDataRepresentationPipeline\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVDataRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVDataRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVDataRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkPVDataRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVDataRepresentation_Type, PyvtkPVDataRepresentation_Methods,
    "vtkPVDataRepresentation",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataRepresentation");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; int value; }
      constants[2] = {
        { "SkippedUpdateDataEvent", vtkPVDataRepresentation::SkippedUpdateDataEvent },
        { "UpdateTimeChangedEvent", vtkPVDataRepresentation::UpdateTimeChangedEvent },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVDataRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVDataRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVDataRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVDataRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

