/* Generated by re2c 4.4 */
#line 1 "../src/parse/conf_lexer.re"
#include <stdint.h>
#include <string>
#include <vector>

#include "src/encoding/enc.h"
#include "src/msg/msg.h"
#include "src/options/opt.h"
#include "src/parse/ast.h"
#include "src/parse/conf_parser.h"
#include "src/parse/input.h"
#include "src/util/file_utils.h"
#include "src/util/string_utils.h"

namespace re2c {

#line 19 "src/parse/conf_lexer.cc"
size_t LexerState::maxfill_conf() { return 32; }
#line 16 "../src/parse/conf_lexer.re"


#define YYFILL(n) do { \
    if (!fill(n)) { \
        RET_FAIL(error_at_cur("unexpected end of input in configuration")); \
    } \
} while(0)

// Immutable options are only allowed in syntax files.
#define SETCONOPT(opt, val) do { \
    if (!in_syntax_file) { \
        RET_FAIL(error_at_cur("this configuration is only allowed in syntax files")); \
    } \
    const_cast<conopt_t&>(opts.glob).init_##opt(val); \
} while (0)

// In syntax file mode do not overwrite user-defined options.
#define SETOPT(opt, val) do { \
    if (in_syntax_file) { \
        opts.init_##opt(val); \
    } else { \
        opts.set_##opt(val); \
    } \
} while (0)

#define RET_CONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    SETOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_STXCONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    SETCONOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_CONF_FEAT(conf, name) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    if (tmp_bool && !opts.glob.supported_features_contains(name)) { \
        RET_FAIL(error_at_cur("`%s` feature is not supported for this backend", name)); \
    } \
    SETOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_CONF_STR(conf) do { \
    CHECK_RET(lex_conf_string(opts)); \
    SETOPT(conf, tmp_str); \
    return Ret::OK; \
} while(0)

#define RET_CONF_CODE(conf) do { \
    CHECK_RET(lex_conf_code(opts)); \
    SETOPT(conf, tmp_code); \
    return Ret::OK; \
} while(0)

#define RET_CONF_ENC(enc) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    if (in_syntax_file) { \
        opts.init_encoding(enc, tmp_bool); \
    } else { \
        opts.set_encoding(enc, tmp_bool); \
    } \
    return Ret::OK; \
} while(0)

#define RET_CONF_NUM_NONNEG(conf) do { \
    CHECK_RET(lex_conf_number(opts)); \
    if (tmp_num < 0) RET_FAIL(error_at_cur("expected nonnegative value in configuration")); \
    SETOPT(conf, static_cast<uint32_t>(tmp_num)); \
    return Ret::OK; \
} while(0)

#define RET_CONF_EOF(conf) do { \
    CHECK_RET(lex_conf_number(opts)); \
    SETOPT(conf, tmp_num < 0 ? NOEOF : static_cast<uint32_t>(tmp_num)); \
    return Ret::OK; \
} while(0)

#line 113 "../src/parse/conf_lexer.re"


Ret Input::lex_conf(Opt& opts) {

#line 108 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[256] = {
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,  64,   0,   0,   0,  64,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		 64,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,  32,   0,   0,
		160, 160, 160, 160, 160, 160, 160, 160,
		160, 160,  32,   0,   0,   0,   0,   0,
		  0,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,   0,   0,   0,   0,  32,
		  0,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0
	};
	if ((lim - cur) < 28) YYFILL(28);
	yych = *cur;
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case ':':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'g':
		case 'j':
		case 'k':
		case 'o':
		case 'q':
		case 'r':
		case 'w':
		case 'x':
		case 'z': goto yy2;
		case 'Y': goto yy4;
		case 'a': goto yy5;
		case 'b': goto yy6;
		case 'c': goto yy7;
		case 'd': goto yy8;
		case 'e': goto yy9;
		case 'f': goto yy10;
		case 'h': goto yy11;
		case 'i': goto yy12;
		case 'l': goto yy13;
		case 'm': goto yy14;
		case 'n': goto yy15;
		case 'p': goto yy16;
		case 's': goto yy17;
		case 't': goto yy18;
		case 'u': goto yy19;
		case 'v': goto yy20;
		case 'y': goto yy21;
		default: goto yy1;
	}
yy1:
#line 303 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok(
                "unrecognized configuration '%.*s'", static_cast<int>(cur - tok), tok));
    }
#line 222 "src/parse/conf_lexer.cc"
yy2:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy3:
	if (yybm[0+yych] & 32) goto yy2;
	goto yy1;
yy4:
	yych = *++cur;
	if (yych == 'Y') goto yy22;
	goto yy3;
yy5:
	yych = *++cur;
	if (yych == 'p') goto yy23;
	goto yy3;
yy6:
	yych = *++cur;
	if (yych == 'i') goto yy24;
	goto yy3;
yy7:
	yych = *++cur;
	if (yych <= 'f') {
		if (yych == 'a') goto yy25;
		goto yy3;
	} else {
		if (yych <= 'g') goto yy26;
		if (yych == 'o') goto yy27;
		goto yy3;
	}
yy8:
	yych = *++cur;
	if (yych == 'a') goto yy28;
	if (yych == 'e') goto yy29;
	goto yy3;
yy9:
	yych = *++cur;
	if (yych <= 'l') goto yy3;
	if (yych <= 'm') goto yy30;
	if (yych <= 'n') goto yy31;
	if (yych <= 'o') goto yy32;
	goto yy3;
yy10:
	yych = *++cur;
	if (yych == 'l') goto yy33;
	goto yy3;
yy11:
	yych = *++cur;
	if (yych == 'e') goto yy34;
	goto yy3;
yy12:
	yych = *++cur;
	if (yych == 'n') goto yy35;
	goto yy3;
yy13:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'a') goto yy36;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy37;
		if (yych == 'i') goto yy38;
		goto yy3;
	}
yy14:
	yych = *++cur;
	if (yych == 'o') goto yy39;
	goto yy3;
yy15:
	yych = *++cur;
	if (yych == 'e') goto yy40;
	goto yy3;
yy16:
	yych = *++cur;
	if (yych == 'o') goto yy41;
	goto yy3;
yy17:
	yych = *++cur;
	if (yych == 'e') goto yy42;
	if (yych == 't') goto yy43;
	goto yy3;
yy18:
	yych = *++cur;
	if (yych == 'a') goto yy44;
	goto yy3;
yy19:
	yych = *++cur;
	if (yych == 'n') goto yy45;
	goto yy3;
yy20:
	yych = *++cur;
	if (yych == 'a') goto yy46;
	if (yych == 'e') goto yy47;
	goto yy3;
yy21:
	yych = *++cur;
	if (yych == 'y') goto yy48;
	goto yy3;
yy22:
	yych = *++cur;
	switch (yych) {
		case 'B': goto yy49;
		case 'C': goto yy50;
		case 'D': goto yy51;
		case 'E': goto yy52;
		case 'F': goto yy53;
		case 'G': goto yy54;
		case 'I': goto yy55;
		case 'L': goto yy56;
		case 'M': goto yy57;
		case 'P': goto yy58;
		case 'R': goto yy59;
		case 'S': goto yy60;
		default: goto yy3;
	}
yy23:
	yych = *++cur;
	if (yych == 'i') goto yy61;
	goto yy3;
yy24:
	yych = *++cur;
	if (yych == 't') goto yy63;
	goto yy3;
yy25:
	yych = *++cur;
	if (yych == 'p') goto yy64;
	if (yych == 's') goto yy65;
	goto yy3;
yy26:
	yych = *++cur;
	if (yych == 'o') goto yy66;
	goto yy3;
yy27:
	yych = *++cur;
	if (yych <= 'l') {
		if (yych == 'd') goto yy67;
		goto yy3;
	} else {
		if (yych <= 'm') goto yy68;
		if (yych <= 'n') goto yy69;
		goto yy3;
	}
yy28:
	yych = *++cur;
	if (yych == 't') goto yy70;
	goto yy3;
yy29:
	yych = *++cur;
	if (yych == 'b') goto yy71;
	if (yych == 'f') goto yy72;
	goto yy3;
yy30:
	yych = *++cur;
	if (yych == 'p') goto yy73;
	goto yy3;
yy31:
	yych = *++cur;
	if (yych == 'c') goto yy74;
	goto yy3;
yy32:
	yych = *++cur;
	if (yych == 'f') goto yy75;
	goto yy3;
yy33:
	yych = *++cur;
	if (yych == 'a') goto yy76;
	if (yych == 'e') goto yy77;
	goto yy3;
yy34:
	yych = *++cur;
	if (yych == 'a') goto yy78;
	goto yy3;
yy35:
	yych = *++cur;
	if (yych <= 'o') {
		if (yych == 'd') goto yy79;
		goto yy3;
	} else {
		if (yych <= 'p') goto yy80;
		if (yych == 'v') goto yy81;
		goto yy3;
	}
yy36:
	yych = *++cur;
	if (yych == 'b') goto yy82;
	goto yy3;
yy37:
	yych = *++cur;
	if (yych == 'f') goto yy83;
	goto yy3;
yy38:
	yych = *++cur;
	if (yych == 'n') goto yy84;
	goto yy3;
yy39:
	yych = *++cur;
	if (yych == 'n') goto yy85;
	goto yy3;
yy40:
	yych = *++cur;
	if (yych == 's') goto yy86;
	goto yy3;
yy41:
	yych = *++cur;
	if (yych == 's') goto yy87;
	goto yy3;
yy42:
	yych = *++cur;
	if (yych == 'n') goto yy88;
	goto yy3;
yy43:
	yych = *++cur;
	if (yych == 'a') goto yy89;
	if (yych == 'o') goto yy90;
	goto yy3;
yy44:
	yych = *++cur;
	if (yych == 'g') goto yy91;
	if (yych == 'r') goto yy92;
	goto yy3;
yy45:
	yych = *++cur;
	if (yych == 's') goto yy93;
	goto yy3;
yy46:
	yych = *++cur;
	if (yych == 'r') goto yy94;
	goto yy3;
yy47:
	yych = *++cur;
	if (yych == 'r') goto yy95;
	goto yy3;
yy48:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy96;
		case 'b': goto yy97;
		case 'c': goto yy98;
		case 'f': goto yy99;
		case 'n': goto yy100;
		case 'p': goto yy101;
		case 'r': goto yy102;
		case 's': goto yy103;
		case 't': goto yy104;
		default: goto yy3;
	}
yy49:
	yych = *++cur;
	if (yych == 'A') goto yy105;
	goto yy3;
yy50:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'O') goto yy106;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy107;
		if (yych <= 'U') goto yy108;
		goto yy3;
	}
yy51:
	yych = *++cur;
	if (yych == 'E') goto yy109;
	goto yy3;
yy52:
	yych = *++cur;
	if (yych == 'N') goto yy110;
	goto yy3;
yy53:
	yych = *++cur;
	if (yych == 'I') goto yy111;
	if (yych == 'N') goto yy112;
	goto yy3;
yy54:
	yych = *++cur;
	if (yych == 'E') goto yy113;
	goto yy3;
yy55:
	yych = *++cur;
	if (yych == 'N') goto yy114;
	goto yy3;
yy56:
	yych = *++cur;
	if (yych == 'E') goto yy115;
	if (yych == 'I') goto yy116;
	goto yy3;
yy57:
	yych = *++cur;
	if (yych == 'A') goto yy117;
	if (yych == 'T') goto yy118;
	goto yy3;
yy58:
	yych = *++cur;
	if (yych == 'E') goto yy119;
	goto yy3;
yy59:
	yych = *++cur;
	if (yych == 'E') goto yy120;
	goto yy3;
yy60:
	yych = *++cur;
	switch (yych) {
		case 'E': goto yy121;
		case 'H': goto yy122;
		case 'K': goto yy123;
		case 'T': goto yy124;
		default: goto yy3;
	}
yy61:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy125;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy62;
			if (yych <= 'z') goto yy2;
		}
	}
yy62:
#line 132 "../src/parse/conf_lexer.re"
	{ goto input; }
#line 551 "src/parse/conf_lexer.cc"
yy63:
	yych = *++cur;
	if (yych == '-') goto yy126;
	goto yy3;
yy64:
	yych = *++cur;
	if (yych == 't') goto yy127;
	goto yy3;
yy65:
	yych = *++cur;
	if (yych == 'e') goto yy128;
	goto yy3;
yy66:
	yych = *++cur;
	if (yych == 't') goto yy129;
	goto yy3;
yy67:
	yych = *++cur;
	if (yych == 'e') goto yy130;
	goto yy3;
yy68:
	yych = *++cur;
	if (yych == 'p') goto yy131;
	goto yy3;
yy69:
	yych = *++cur;
	if (yych == 'd') goto yy132;
	goto yy3;
yy70:
	yych = *++cur;
	if (yych == 'e') goto yy133;
	goto yy3;
yy71:
	yych = *++cur;
	if (yych == 'u') goto yy134;
	goto yy3;
yy72:
	yych = *++cur;
	if (yych == 'i') goto yy135;
	goto yy3;
yy73:
	yych = *++cur;
	if (yych == 't') goto yy136;
	goto yy3;
yy74:
	yych = *++cur;
	if (yych == 'o') goto yy137;
	goto yy3;
yy75:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 147 "../src/parse/conf_lexer.re"
	{ RET_CONF_EOF(fill_eof); }
#line 605 "src/parse/conf_lexer.cc"
yy76:
	yych = *++cur;
	if (yych == 'g') goto yy138;
	goto yy3;
yy77:
	yych = *++cur;
	if (yych == 'x') goto yy139;
	goto yy3;
yy78:
	yych = *++cur;
	if (yych == 'd') goto yy140;
	goto yy3;
yy79:
	yych = *++cur;
	if (yych == 'e') goto yy141;
	goto yy3;
yy80:
	yych = *++cur;
	if (yych == 'u') goto yy142;
	goto yy3;
yy81:
	yych = *++cur;
	if (yych == 'e') goto yy143;
	goto yy3;
yy82:
	yych = *++cur;
	if (yych == 'e') goto yy144;
	goto yy3;
yy83:
	yych = *++cur;
	if (yych == 't') goto yy145;
	goto yy3;
yy84:
	yych = *++cur;
	if (yych == 'e') goto yy146;
	goto yy3;
yy85:
	yych = *++cur;
	if (yych == 'a') goto yy147;
	goto yy3;
yy86:
	yych = *++cur;
	if (yych == 't') goto yy148;
	goto yy3;
yy87:
	yych = *++cur;
	if (yych == 'i') goto yy149;
	goto yy3;
yy88:
	yych = *++cur;
	if (yych == 't') goto yy150;
	goto yy3;
yy89:
	yych = *++cur;
	if (yych == 'r') goto yy151;
	if (yych == 't') goto yy152;
	goto yy3;
yy90:
	yych = *++cur;
	if (yych == 'r') goto yy153;
	goto yy3;
yy91:
	yych = *++cur;
	if (yych == 's') goto yy154;
	goto yy3;
yy92:
	yych = *++cur;
	if (yych == 'g') goto yy156;
	goto yy3;
yy93:
	yych = *++cur;
	if (yych == 'a') goto yy157;
	goto yy3;
yy94:
	yych = *++cur;
	if (yych == 'i') goto yy158;
	goto yy3;
yy95:
	yych = *++cur;
	if (yych == 'b') goto yy159;
	if (yych == 's') goto yy160;
	goto yy3;
yy96:
	yych = *++cur;
	if (yych == 'c') goto yy161;
	goto yy3;
yy97:
	yych = *++cur;
	if (yych == 'm') goto yy162;
	goto yy3;
yy98:
	yych = *++cur;
	if (yych <= 'n') {
		if (yych == 'h') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'o') goto yy166;
		if (yych == 't') goto yy167;
		goto yy3;
	}
yy99:
	yych = *++cur;
	if (yych == 'i') goto yy168;
	if (yych == 'n') goto yy169;
	goto yy3;
yy100:
	yych = *++cur;
	if (yych == 'm') goto yy170;
	goto yy3;
yy101:
	yych = *++cur;
	if (yych == 'm') goto yy171;
	goto yy3;
yy102:
	yych = *++cur;
	if (yych == 'e') goto yy172;
	goto yy3;
yy103:
	yych = *++cur;
	if (yych == 't') goto yy173;
	goto yy3;
yy104:
	yych = *++cur;
	if (yych == 'a') goto yy174;
	goto yy3;
yy105:
	yych = *++cur;
	if (yych == 'C') goto yy175;
	goto yy3;
yy106:
	yych = *++cur;
	if (yych == 'N') goto yy176;
	if (yych == 'P') goto yy177;
	goto yy3;
yy107:
	yych = *++cur;
	if (yych <= 'W') goto yy3;
	if (yych <= 'X') goto yy178;
	if (yych <= 'Y') goto yy179;
	goto yy3;
yy108:
	yych = *++cur;
	if (yych == 'R') goto yy180;
	goto yy3;
yy109:
	yych = *++cur;
	if (yych == 'B') goto yy181;
	goto yy3;
yy110:
	yych = *++cur;
	if (yych == 'D') goto yy182;
	goto yy3;
yy111:
	yych = *++cur;
	if (yych == 'L') goto yy183;
	goto yy3;
yy112:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 234 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_list(opts));
        if (tmp_list.size() < 1) {
            RET_FAIL(error_at_tok(
                "`re2c:YYFN` configuration value should be a nonempty list of strings"));
        }
        SETOPT(api_fn, tmp_list);
        return Ret::OK;
    }
#line 775 "src/parse/conf_lexer.cc"
yy113:
	yych = *++cur;
	if (yych == 'T') goto yy184;
	goto yy3;
yy114:
	yych = *++cur;
	if (yych == 'P') goto yy185;
	goto yy3;
yy115:
	yych = *++cur;
	if (yych == 'S') goto yy186;
	goto yy3;
yy116:
	yych = *++cur;
	if (yych == 'M') goto yy187;
	goto yy3;
yy117:
	yych = *++cur;
	if (yych == 'R') goto yy188;
	if (yych == 'X') goto yy189;
	goto yy3;
yy118:
	yych = *++cur;
	if (yych == 'A') goto yy190;
	goto yy3;
yy119:
	yych = *++cur;
	if (yych == 'E') goto yy191;
	goto yy3;
yy120:
	yych = *++cur;
	if (yych == 'S') goto yy192;
	goto yy3;
yy121:
	yych = *++cur;
	if (yych == 'T') goto yy193;
	goto yy3;
yy122:
	yych = *++cur;
	if (yych == 'I') goto yy194;
	goto yy3;
yy123:
	yych = *++cur;
	if (yych == 'I') goto yy195;
	goto yy3;
yy124:
	yych = *++cur;
	if (yych == 'A') goto yy196;
	goto yy3;
yy125:
	yych = *++cur;
	if (yych == 's') goto yy197;
	goto yy3;
yy126:
	yych = *++cur;
	if (yych == 'v') goto yy198;
	goto yy3;
yy127:
	yych = *++cur;
	if (yych <= 't') goto yy3;
	if (yych <= 'u') goto yy199;
	if (yych <= 'v') goto yy200;
	goto yy3;
yy128:
	yych = *++cur;
	if (yych == '-') goto yy201;
	goto yy3;
yy129:
	yych = *++cur;
	if (yych == 'o') goto yy202;
	goto yy3;
yy130:
	yych = *++cur;
	if (yych == '-') goto yy203;
	goto yy3;
yy131:
	yych = *++cur;
	if (yych == 'u') goto yy204;
	goto yy3;
yy132:
	yych = *++cur;
	if (yych <= 'e') {
		if (yych == ':') goto yy205;
		if (yych <= 'd') goto yy3;
		goto yy206;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy3;
			goto yy207;
		} else {
			if (yych == 'p') goto yy208;
			goto yy3;
		}
	}
yy133:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 122 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(date); }
#line 875 "src/parse/conf_lexer.cc"
yy134:
	yych = *++cur;
	if (yych == 'g') goto yy209;
	goto yy3;
yy135:
	yych = *++cur;
	if (yych == 'n') goto yy210;
	goto yy3;
yy136:
	yych = *++cur;
	if (yych == 'y') goto yy211;
	goto yy3;
yy137:
	yych = *++cur;
	if (yych == 'd') goto yy212;
	goto yy3;
yy138:
	yych = *++cur;
	if (yych == 's') goto yy213;
	goto yy3;
yy139:
	yych = *++cur;
	if (yych == '-') goto yy214;
	goto yy3;
yy140:
	yych = *++cur;
	if (yych == 'e') goto yy215;
	goto yy3;
yy141:
	yych = *++cur;
	if (yych == 'n') goto yy216;
	goto yy3;
yy142:
	yych = *++cur;
	if (yych == 't') goto yy217;
	goto yy3;
yy143:
	yych = *++cur;
	if (yych == 'r') goto yy218;
	goto yy3;
yy144:
	yych = *++cur;
	if (yych == 'l') goto yy219;
	goto yy3;
yy145:
	yych = *++cur;
	if (yych == 'm') goto yy220;
	goto yy3;
yy146:
	yych = *++cur;
	if (yych == '-') goto yy221;
	goto yy3;
yy147:
	yych = *++cur;
	if (yych == 'd') goto yy222;
	goto yy3;
yy148:
	yych = *++cur;
	if (yych == 'e') goto yy223;
	goto yy3;
yy149:
	yych = *++cur;
	if (yych == 'x') goto yy224;
	goto yy3;
yy150:
	yych = *++cur;
	if (yych == 'i') goto yy225;
	goto yy3;
yy151:
	yych = *++cur;
	if (yych == 't') goto yy226;
	goto yy3;
yy152:
	yych = *++cur;
	if (yych == 'e') goto yy227;
	goto yy3;
yy153:
	yych = *++cur;
	if (yych == 'a') goto yy228;
	goto yy3;
yy154:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy229;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy155;
			if (yych <= 'z') goto yy2;
		}
	}
yy155:
#line 157 "../src/parse/conf_lexer.re"
	{
        RET_CONF_BOOL(tags);
    }
#line 979 "src/parse/conf_lexer.cc"
yy156:
	yych = *++cur;
	if (yych == 'e') goto yy230;
	goto yy3;
yy157:
	yych = *++cur;
	if (yych == 'f') goto yy231;
	goto yy3;
yy158:
	yych = *++cur;
	if (yych == 'a') goto yy232;
	goto yy3;
yy159:
	yych = *++cur;
	if (yych == 'o') goto yy233;
	goto yy3;
yy160:
	yych = *++cur;
	if (yych == 'i') goto yy234;
	goto yy3;
yy161:
	yych = *++cur;
	if (yych == 'c') goto yy235;
	goto yy3;
yy162:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy236;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy163;
			if (yych <= 'z') goto yy2;
		}
	}
yy163:
#line 256 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_bitmaps); }
#line 1025 "src/parse/conf_lexer.cc"
yy164:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy237;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy165;
			if (yych <= 'z') goto yy2;
		}
	}
yy165:
#line 252 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_char); }
#line 1047 "src/parse/conf_lexer.cc"
yy166:
	yych = *++cur;
	if (yych == 'n') goto yy238;
	goto yy3;
yy167:
	yych = *++cur;
	if (yych == 'a') goto yy239;
	goto yy3;
yy168:
	yych = *++cur;
	if (yych == 'l') goto yy240;
	goto yy3;
yy169:
	yych = *++cur;
	if (yych == ':') goto yy241;
	goto yy3;
yy170:
	yych = *++cur;
	if (yych == 'a') goto yy242;
	goto yy3;
yy171:
	yych = *++cur;
	if (yych == 'a') goto yy243;
	goto yy3;
yy172:
	yych = *++cur;
	if (yych == 'c') goto yy244;
	goto yy3;
yy173:
	yych = *++cur;
	if (yych == 'a') goto yy245;
	goto yy3;
yy174:
	yych = *++cur;
	if (yych == 'r') goto yy246;
	goto yy3;
yy175:
	yych = *++cur;
	if (yych == 'K') goto yy247;
	goto yy3;
yy176:
	yych = *++cur;
	if (yych == 'D') goto yy248;
	goto yy3;
yy177:
	yych = *++cur;
	if (yych == 'Y') goto yy249;
	goto yy3;
yy178:
	yych = *++cur;
	if (yych == 'M') goto yy250;
	goto yy3;
yy179:
	yych = *++cur;
	if (yych == 'P') goto yy251;
	goto yy3;
yy180:
	yych = *++cur;
	if (yych == 'S') goto yy252;
	goto yy3;
yy181:
	yych = *++cur;
	if (yych == 'U') goto yy253;
	goto yy3;
yy182:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 201 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_end); }
#line 1117 "src/parse/conf_lexer.cc"
yy183:
	yych = *++cur;
	if (yych == 'L') goto yy254;
	goto yy3;
yy184:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy256;
		goto yy3;
	} else {
		if (yych <= 'C') goto yy257;
		if (yych == 'S') goto yy258;
		goto yy3;
	}
yy185:
	yych = *++cur;
	if (yych == 'U') goto yy259;
	goto yy3;
yy186:
	yych = *++cur;
	if (yych == 'S') goto yy260;
	goto yy3;
yy187:
	yych = *++cur;
	if (yych == 'I') goto yy261;
	goto yy3;
yy188:
	yych = *++cur;
	if (yych == 'K') goto yy262;
	goto yy3;
yy189:
	yych = *++cur;
	if (yych == 'F') goto yy263;
	if (yych == 'N') goto yy264;
	goto yy3;
yy190:
	yych = *++cur;
	if (yych == 'G') goto yy265;
	goto yy3;
yy191:
	yych = *++cur;
	if (yych == 'K') goto yy266;
	goto yy3;
yy192:
	yych = *++cur;
	if (yych == 'T') goto yy267;
	goto yy3;
yy193:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy268;
		goto yy3;
	} else {
		if (yych <= 'C') goto yy269;
		if (yych == 'S') goto yy270;
		goto yy3;
	}
yy194:
	yych = *++cur;
	if (yych == 'F') goto yy271;
	goto yy3;
yy195:
	yych = *++cur;
	if (yych == 'P') goto yy272;
	goto yy3;
yy196:
	yych = *++cur;
	if (yych == 'G') goto yy273;
	goto yy3;
yy197:
	yych = *++cur;
	if (yych == 'i') goto yy274;
	if (yych == 't') goto yy275;
	goto yy3;
yy198:
	yych = *++cur;
	if (yych == 'e') goto yy276;
	goto yy3;
yy199:
	yych = *++cur;
	if (yych == 'r') goto yy277;
	goto yy3;
yy200:
	yych = *++cur;
	if (yych == 'a') goto yy278;
	goto yy3;
yy201:
	yych = *++cur;
	if (yych == 'i') goto yy279;
	if (yych == 'r') goto yy280;
	goto yy3;
yy202:
	yych = *++cur;
	if (yych == ':') goto yy281;
	goto yy3;
yy203:
	yych = *++cur;
	if (yych == 'm') goto yy282;
	goto yy3;
yy204:
	yych = *++cur;
	if (yych == 't') goto yy283;
	goto yy3;
yy205:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy284;
		case 'd': goto yy285;
		case 'e': goto yy206;
		case 'g': goto yy286;
		case 'p': goto yy208;
		default: goto yy3;
	}
yy206:
	yych = *++cur;
	if (yych == 'n') goto yy287;
	goto yy3;
yy207:
	yych = *++cur;
	if (yych == 't') goto yy288;
	goto yy3;
yy208:
	yych = *++cur;
	if (yych == 'r') goto yy289;
	goto yy3;
yy209:
	yych = *++cur;
	if (yych == '-') goto yy290;
	goto yy3;
yy210:
	yych = *++cur;
	if (yych == 'e') goto yy291;
	goto yy3;
yy211:
	yych = *++cur;
	if (yych == '-') goto yy292;
	goto yy3;
yy212:
	yych = *++cur;
	if (yych == 'i') goto yy293;
	goto yy3;
yy213:
	yych = *++cur;
	if (yych == ':') goto yy294;
	goto yy3;
yy214:
	yych = *++cur;
	if (yych == 's') goto yy295;
	goto yy3;
yy215:
	yych = *++cur;
	if (yych == 'r') goto yy296;
	goto yy3;
yy216:
	yych = *++cur;
	if (yych == 't') goto yy298;
	goto yy3;
yy217:
	yych = *++cur;
	if (yych == '-') goto yy299;
	goto yy3;
yy218:
	yych = *++cur;
	if (yych == 't') goto yy300;
	goto yy3;
yy219:
	yych = *++cur;
	if (yych == ':') goto yy301;
	if (yych == 'p') goto yy302;
	goto yy3;
yy220:
	yych = *++cur;
	if (yych == 'o') goto yy303;
	goto yy3;
yy221:
	yych = *++cur;
	if (yych == 'd') goto yy304;
	goto yy3;
yy222:
	yych = *++cur;
	if (yych == 'i') goto yy305;
	goto yy3;
yy223:
	yych = *++cur;
	if (yych == 'd') goto yy306;
	goto yy3;
yy224:
	yych = *++cur;
	if (yych == '-') goto yy307;
	goto yy3;
yy225:
	yych = *++cur;
	if (yych == 'n') goto yy308;
	goto yy3;
yy226:
	yych = *++cur;
	if (yych == 'l') goto yy309;
	goto yy3;
yy227:
	yych = *++cur;
	if (yych == ':') goto yy310;
	goto yy3;
yy228:
	yych = *++cur;
	if (yych == 'b') goto yy311;
	goto yy3;
yy229:
	yych = *++cur;
	if (yych <= 'm') {
		if (yych == 'e') goto yy312;
		goto yy3;
	} else {
		if (yych <= 'n') goto yy313;
		if (yych == 'p') goto yy314;
		goto yy3;
	}
yy230:
	yych = *++cur;
	if (yych == 't') goto yy315;
	goto yy3;
yy231:
	yych = *++cur;
	if (yych == 'e') goto yy316;
	goto yy3;
yy232:
	yych = *++cur;
	if (yych == 'b') goto yy317;
	goto yy3;
yy233:
	yych = *++cur;
	if (yych == 's') goto yy318;
	goto yy3;
yy234:
	yych = *++cur;
	if (yych == 'o') goto yy319;
	goto yy3;
yy235:
	yych = *++cur;
	if (yych == 'e') goto yy320;
	goto yy3;
yy236:
	yych = *++cur;
	if (yych == 'h') goto yy321;
	goto yy3;
yy237:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'c') goto yy322;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy323;
		if (yych == 'l') goto yy324;
		goto yy3;
	}
yy238:
	yych = *++cur;
	if (yych == 'd') goto yy325;
	goto yy3;
yy239:
	yych = *++cur;
	if (yych == 'b') goto yy326;
	goto yy3;
yy240:
	yych = *++cur;
	if (yych == 'l') goto yy327;
	goto yy3;
yy241:
	yych = *++cur;
	if (yych <= 'r') goto yy3;
	if (yych <= 's') goto yy329;
	if (yych <= 't') goto yy330;
	goto yy3;
yy242:
	yych = *++cur;
	if (yych == 't') goto yy331;
	goto yy3;
yy243:
	yych = *++cur;
	if (yych == 't') goto yy332;
	goto yy3;
yy244:
	yych = *++cur;
	if (yych == 'o') goto yy333;
	goto yy3;
yy245:
	yych = *++cur;
	if (yych == 'b') goto yy334;
	if (yych == 't') goto yy335;
	goto yy3;
yy246:
	yych = *++cur;
	if (yych == 'g') goto yy336;
	goto yy3;
yy247:
	yych = *++cur;
	if (yych == 'U') goto yy337;
	goto yy3;
yy248:
	yych = *++cur;
	if (yych == 'T') goto yy338;
	goto yy3;
yy249:
	yych = *++cur;
	if (yych == 'M') goto yy339;
	if (yych == 'S') goto yy340;
	goto yy3;
yy250:
	yych = *++cur;
	if (yych == 'A') goto yy341;
	goto yy3;
yy251:
	yych = *++cur;
	if (yych == 'E') goto yy342;
	goto yy3;
yy252:
	yych = *++cur;
	if (yych == 'O') goto yy343;
	goto yy3;
yy253:
	yych = *++cur;
	if (yych == 'G') goto yy344;
	goto yy3;
yy254:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy345;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy346;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy255;
			if (yych <= 'z') goto yy2;
		}
	}
yy255:
#line 202 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_fill); }
#line 1462 "src/parse/conf_lexer.cc"
yy256:
	yych = *++cur;
	if (yych == 'C') goto yy348;
	goto yy3;
yy257:
	yych = *++cur;
	if (yych == 'O') goto yy349;
	goto yy3;
yy258:
	yych = *++cur;
	if (yych == 'T') goto yy350;
	goto yy3;
yy259:
	yych = *++cur;
	if (yych == 'T') goto yy351;
	goto yy3;
yy260:
	yych = *++cur;
	if (yych == 'T') goto yy352;
	goto yy3;
yy261:
	yych = *++cur;
	if (yych == 'T') goto yy353;
	goto yy3;
yy262:
	yych = *++cur;
	if (yych == 'E') goto yy354;
	goto yy3;
yy263:
	yych = *++cur;
	if (yych == 'I') goto yy355;
	goto yy3;
yy264:
	yych = *++cur;
	if (yych == 'M') goto yy356;
	goto yy3;
yy265:
	yych = *++cur;
	if (yych == 'N') goto yy357;
	if (yych == 'P') goto yy358;
	goto yy3;
yy266:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 217 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_peek); }
#line 1509 "src/parse/conf_lexer.cc"
yy267:
	yych = *++cur;
	if (yych == 'O') goto yy359;
	goto yy3;
yy268:
	yych = *++cur;
	if (yych == 'C') goto yy360;
	goto yy3;
yy269:
	yych = *++cur;
	if (yych == 'O') goto yy361;
	goto yy3;
yy270:
	yych = *++cur;
	if (yych == 'T') goto yy362;
	goto yy3;
yy271:
	yych = *++cur;
	if (yych == 'T') goto yy363;
	goto yy3;
yy272:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 231 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_skip); }
#line 1535 "src/parse/conf_lexer.cc"
yy273:
	yych = *++cur;
	if (yych == 'N') goto yy365;
	if (yych == 'P') goto yy366;
	goto yy3;
yy274:
	yych = *++cur;
	if (yych == 'g') goto yy367;
	goto yy3;
yy275:
	yych = *++cur;
	if (yych == 'y') goto yy368;
	goto yy3;
yy276:
	yych = *++cur;
	if (yych == 'c') goto yy369;
	goto yy3;
yy277:
	yych = *++cur;
	if (yych == 'e') goto yy370;
	goto yy3;
yy278:
	yych = *++cur;
	if (yych == 'r') goto yy371;
	goto yy3;
yy279:
	yych = *++cur;
	if (yych == 'n') goto yy372;
	goto yy3;
yy280:
	yych = *++cur;
	if (yych == 'a') goto yy373;
	goto yy3;
yy281:
	yych = *++cur;
	if (yych == 'r') goto yy374;
	if (yych == 't') goto yy375;
	goto yy3;
yy282:
	yych = *++cur;
	if (yych == 'o') goto yy376;
	goto yy3;
yy283:
	yych = *++cur;
	if (yych == 'e') goto yy377;
	goto yy3;
yy284:
	yych = *++cur;
	if (yych == 'b') goto yy378;
	goto yy3;
yy285:
	yych = *++cur;
	if (yych == 'i') goto yy379;
	goto yy3;
yy286:
	yych = *++cur;
	if (yych == 'o') goto yy380;
	goto yy3;
yy287:
	yych = *++cur;
	if (yych == 'u') goto yy381;
	goto yy3;
yy288:
	yych = *++cur;
	if (yych == 'i') goto yy382;
	goto yy3;
yy289:
	yych = *++cur;
	if (yych == 'e') goto yy383;
	goto yy3;
yy290:
	yych = *++cur;
	if (yych == 'o') goto yy384;
	goto yy3;
yy291:
	yych = *++cur;
	if (yych == ':') goto yy385;
	goto yy3;
yy292:
	yych = *++cur;
	if (yych == 'c') goto yy386;
	goto yy3;
yy293:
	yych = *++cur;
	if (yych == 'n') goto yy387;
	goto yy3;
yy294:
	yych = *++cur;
	switch (yych) {
		case '8': goto yy388;
		case 'P': goto yy389;
		case 'T': goto yy390;
		case 'b': goto yy391;
		case 'c': goto yy393;
		case 'd': goto yy394;
		case 'e': goto yy396;
		case 'g': goto yy398;
		case 'i': goto yy400;
		case 'l': goto yy401;
		case 'm': goto yy14;
		case 'n': goto yy15;
		case 'p': goto yy402;
		case 's': goto yy403;
		case 't': goto yy404;
		case 'u': goto yy405;
		case 'w': goto yy407;
		case 'x': goto yy409;
		default: goto yy3;
	}
yy295:
	yych = *++cur;
	if (yych == 'y') goto yy410;
	goto yy3;
yy296:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
yy297:
#line 137 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_string(opts));
        if (!tmp_str.empty()) {
            std::string path(opts.glob.output_file);
            get_dir(path);
            SETOPT(header_file, path + tmp_str);
        }
        return Ret::OK;
    }
#line 1663 "src/parse/conf_lexer.cc"
yy298:
	yych = *++cur;
	if (yych == ':') goto yy411;
	goto yy3;
yy299:
	yych = *++cur;
	if (yych == 'e') goto yy412;
	goto yy3;
yy300:
	yych = *++cur;
	if (yych == '-') goto yy413;
	goto yy3;
yy301:
	yych = *++cur;
	if (yych <= 'r') {
		if (yych != 'p') goto yy3;
	} else {
		if (yych <= 's') goto yy414;
		if (yych == 'y') goto yy415;
		goto yy3;
	}
yy302:
	yych = *++cur;
	if (yych == 'r') goto yy416;
	goto yy3;
yy303:
	yych = *++cur;
	if (yych == 's') goto yy417;
	goto yy3;
yy304:
	yych = *++cur;
	if (yych == 'i') goto yy418;
	goto yy3;
yy305:
	yych = *++cur;
	if (yych == 'c') goto yy419;
	goto yy3;
yy306:
	yych = *++cur;
	if (yych == '-') goto yy420;
	goto yy3;
yy307:
	yych = *++cur;
	if (yych == 'c') goto yy421;
	goto yy3;
yy308:
	yych = *++cur;
	if (yych == 'e') goto yy422;
	goto yy3;
yy309:
	yych = *++cur;
	if (yych == 'a') goto yy423;
	goto yy3;
yy310:
	yych = *++cur;
	if (yych == 'a') goto yy424;
	if (yych == 'n') goto yy425;
	goto yy3;
yy311:
	yych = *++cur;
	if (yych == 'l') goto yy426;
	goto yy3;
yy312:
	yych = *++cur;
	if (yych == 'x') goto yy427;
	goto yy3;
yy313:
	yych = *++cur;
	if (yych == 'e') goto yy428;
	goto yy3;
yy314:
	yych = *++cur;
	if (yych == 'r') goto yy429;
	goto yy3;
yy315:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 119 "../src/parse/conf_lexer.re"
	{ goto target; }
#line 1743 "src/parse/conf_lexer.cc"
yy316:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 281 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(unsafe); }
#line 1749 "src/parse/conf_lexer.cc"
yy317:
	yych = *++cur;
	if (yych == 'l') goto yy430;
	goto yy3;
yy318:
	yych = *++cur;
	if (yych == 'e') goto yy431;
	goto yy3;
yy319:
	yych = *++cur;
	if (yych == 'n') goto yy432;
	goto yy3;
yy320:
	yych = *++cur;
	if (yych == 'p') goto yy433;
	goto yy3;
yy321:
	yych = *++cur;
	if (yych == 'e') goto yy434;
	goto yy3;
yy322:
	yych = *++cur;
	if (yych == 'o') goto yy435;
	goto yy3;
yy323:
	yych = *++cur;
	if (yych == 'm') goto yy436;
	goto yy3;
yy324:
	yych = *++cur;
	if (yych == 'i') goto yy437;
	goto yy3;
yy325:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 244 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_cond); }
#line 1787 "src/parse/conf_lexer.cc"
yy326:
	yych = *++cur;
	if (yych == 'l') goto yy438;
	goto yy3;
yy327:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy439;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy328;
			if (yych <= 'z') goto yy2;
		}
	}
yy328:
#line 258 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_fill); }
#line 1813 "src/parse/conf_lexer.cc"
yy329:
	yych = *++cur;
	if (yych == 'e') goto yy440;
	goto yy3;
yy330:
	yych = *++cur;
	if (yych == 'h') goto yy441;
	goto yy3;
yy331:
	yych = *++cur;
	if (yych == 'c') goto yy442;
	goto yy3;
yy332:
	yych = *++cur;
	if (yych == 'c') goto yy443;
	goto yy3;
yy333:
	yych = *++cur;
	if (yych == 'r') goto yy444;
	goto yy3;
yy334:
	yych = *++cur;
	if (yych == 'l') goto yy445;
	goto yy3;
yy335:
	yych = *++cur;
	if (yych == 'e') goto yy446;
	goto yy3;
yy336:
	yych = *++cur;
	if (yych == 'e') goto yy447;
	goto yy3;
yy337:
	yych = *++cur;
	if (yych == 'P') goto yy448;
	goto yy3;
yy338:
	yych = *++cur;
	if (yych == 'Y') goto yy450;
	goto yy3;
yy339:
	yych = *++cur;
	if (yych == 'T') goto yy451;
	goto yy3;
yy340:
	yych = *++cur;
	if (yych == 'T') goto yy452;
	goto yy3;
yy341:
	yych = *++cur;
	if (yych == 'R') goto yy453;
	goto yy3;
yy342:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 196 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_char_type); }
#line 1871 "src/parse/conf_lexer.cc"
yy343:
	yych = *++cur;
	if (yych == 'R') goto yy454;
	goto yy3;
yy344:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 200 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_debug); }
#line 1881 "src/parse/conf_lexer.cc"
yy345:
	yych = *++cur;
	if (yych == 'n') goto yy455;
	goto yy3;
yy346:
	yych = *++cur;
	if (yych == 'l') goto yy456;
yy347:
	cur = mar;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) goto yy255;
			else goto yy559;
		} else {
			goto yy576;
		}
	} else {
		if (yyaccept <= 4) {
			if (yyaccept == 3) goto yy647;
			else goto yy693;
		} else {
			goto yy793;
		}
	}
yy348:
	yych = *++cur;
	if (yych == 'C') goto yy457;
	goto yy3;
yy349:
	yych = *++cur;
	if (yych == 'N') goto yy458;
	goto yy3;
yy350:
	yych = *++cur;
	if (yych == 'A') goto yy459;
	goto yy3;
yy351:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 198 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_input); }
#line 1923 "src/parse/conf_lexer.cc"
yy352:
	yych = *++cur;
	if (yych == 'H') goto yy460;
	goto yy3;
yy353:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 211 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_limit); }
#line 1933 "src/parse/conf_lexer.cc"
yy354:
	yych = *++cur;
	if (yych == 'R') goto yy461;
	goto yy3;
yy355:
	yych = *++cur;
	if (yych == 'L') goto yy462;
	goto yy3;
yy356:
	yych = *++cur;
	if (yych == 'A') goto yy463;
	goto yy3;
yy357:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 215 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_neg); }
#line 1951 "src/parse/conf_lexer.cc"
yy358:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 216 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_pos); }
#line 1957 "src/parse/conf_lexer.cc"
yy359:
	yych = *++cur;
	if (yych == 'R') goto yy464;
	goto yy3;
yy360:
	yych = *++cur;
	if (yych == 'C') goto yy465;
	goto yy3;
yy361:
	yych = *++cur;
	if (yych == 'N') goto yy466;
	goto yy3;
yy362:
	yych = *++cur;
	if (yych == 'A') goto yy467;
	goto yy3;
yy363:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy364;
			if (yych <= 'L') goto yy2;
			goto yy468;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'S') goto yy469;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy364;
			if (yych <= 'z') goto yy2;
		}
	}
yy364:
#line 228 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_shift); }
#line 1997 "src/parse/conf_lexer.cc"
yy365:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 232 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_neg); }
#line 2003 "src/parse/conf_lexer.cc"
yy366:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 233 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_pos); }
#line 2009 "src/parse/conf_lexer.cc"
yy367:
	yych = *++cur;
	if (yych == 'i') goto yy470;
	goto yy3;
yy368:
	yych = *++cur;
	if (yych == 'l') goto yy471;
	goto yy3;
yy369:
	yych = *++cur;
	if (yych == 't') goto yy472;
	goto yy3;
yy370:
	yych = *++cur;
	if (yych == 's') goto yy473;
	goto yy3;
yy371:
	yych = *++cur;
	if (yych == 's') goto yy474;
	goto yy3;
yy372:
	yych = *++cur;
	if (yych == 's') goto yy475;
	if (yych == 'v') goto yy476;
	goto yy3;
yy373:
	yych = *++cur;
	if (yych == 'n') goto yy477;
	goto yy3;
yy374:
	yych = *++cur;
	if (yych == 'e') goto yy478;
	goto yy3;
yy375:
	yych = *++cur;
	if (yych == 'h') goto yy479;
	goto yy3;
yy376:
	yych = *++cur;
	if (yych == 'd') goto yy480;
	goto yy3;
yy377:
	yych = *++cur;
	if (yych == 'd') goto yy481;
	goto yy3;
yy378:
	yych = *++cur;
	if (yych == 'o') goto yy482;
	goto yy3;
yy379:
	yych = *++cur;
	if (yych == 'v') goto yy483;
	goto yy3;
yy380:
	yych = *++cur;
	if (yych == 't') goto yy484;
	goto yy3;
yy381:
	yych = *++cur;
	if (yych == 'm') goto yy485;
	goto yy3;
yy382:
	yych = *++cur;
	if (yych == 'o') goto yy486;
	goto yy3;
yy383:
	yych = *++cur;
	if (yych == 'f') goto yy487;
	goto yy3;
yy384:
	yych = *++cur;
	if (yych == 'u') goto yy488;
	goto yy3;
yy385:
	yych = *++cur;
	if (yych == 'Y') goto yy4;
	goto yy3;
yy386:
	yych = *++cur;
	if (yych == 'l') goto yy489;
	goto yy3;
yy387:
	yych = *++cur;
	if (yych == 'g') goto yy490;
	goto yy3;
yy388:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 288 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF8); }
#line 2100 "src/parse/conf_lexer.cc"
yy389:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 166 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_posix, tmp_bool);
        SETOPT(captures_array, true);
        return Ret::OK;
    }
#line 2112 "src/parse/conf_lexer.cc"
yy390:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy155;
yy391:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'i') goto yy24;
			if (yych <= 'z') goto yy2;
		}
	}
yy392:
#line 272 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(bitmaps, "bitmaps"); }
#line 2137 "src/parse/conf_lexer.cc"
yy393:
	yych = *++cur;
	if (yych == 'a') goto yy491;
	if (yych == 'o') goto yy492;
	goto yy3;
yy394:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'e') goto yy493;
			if (yych <= 'z') goto yy2;
		}
	}
yy395:
#line 273 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(debug); }
#line 2163 "src/parse/conf_lexer.cc"
yy396:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= ':') {
			if (yych == '-') goto yy2;
			if (yych >= '0') goto yy2;
		} else {
			if (yych <= '@') goto yy397;
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= '`') goto yy397;
			if (yych == 'c') goto yy494;
			goto yy2;
		} else {
			if (yych <= 'm') goto yy30;
			if (yych <= 'n') goto yy495;
			if (yych <= 'z') goto yy2;
		}
	}
yy397:
#line 284 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::EBCDIC); }
#line 2189 "src/parse/conf_lexer.cc"
yy398:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
yy399:
#line 274 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(computed_gotos, "computed-gotos"); }
#line 2196 "src/parse/conf_lexer.cc"
yy400:
	yych = *++cur;
	if (yych == 'n') goto yy496;
	goto yy3;
yy401:
	yych = *++cur;
	if (yych == 'e') goto yy497;
	goto yy3;
yy402:
	yych = *++cur;
	if (yych == 'o') goto yy498;
	goto yy3;
yy403:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 277 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(nested_ifs, "nested-ifs"); }
#line 2214 "src/parse/conf_lexer.cc"
yy404:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy297;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy297;
			if (yych <= 'Z') goto yy2;
			goto yy297;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= '_') goto yy2;
			if (yych <= '`') goto yy297;
			goto yy499;
		} else {
			if (yych == 'y') goto yy500;
			if (yych <= 'z') goto yy2;
			goto yy297;
		}
	}
yy405:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy406;
			if (yych <= 'Z') goto yy2;
		}
	} else {
		if (yych <= 'n') {
			if (yych == '`') goto yy406;
			if (yych <= 'm') goto yy2;
			goto yy501;
		} else {
			if (yych == 't') goto yy502;
			if (yych <= 'z') goto yy2;
		}
	}
yy406:
#line 285 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF32); }
#line 2261 "src/parse/conf_lexer.cc"
yy407:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'i') goto yy503;
			if (yych <= 'z') goto yy2;
		}
	}
yy408:
#line 286 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UCS2); }
#line 2282 "src/parse/conf_lexer.cc"
yy409:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 287 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF16); }
#line 2288 "src/parse/conf_lexer.cc"
yy410:
	yych = *++cur;
	if (yych == 'n') goto yy504;
	goto yy3;
yy411:
	yych = *++cur;
	if (yych <= 'r') goto yy3;
	if (yych <= 's') goto yy505;
	if (yych <= 't') goto yy506;
	goto yy3;
yy412:
	yych = *++cur;
	if (yych == 'n') goto yy507;
	goto yy3;
yy413:
	yych = *++cur;
	if (yych == 'c') goto yy508;
	goto yy3;
yy414:
	yych = *++cur;
	if (yych == 't') goto yy509;
	goto yy3;
yy415:
	yych = *++cur;
	if (yych == 'y') goto yy510;
	goto yy3;
yy416:
	yych = *++cur;
	if (yych == 'e') goto yy511;
	goto yy3;
yy417:
	yych = *++cur;
	if (yych == 't') goto yy512;
	goto yy3;
yy418:
	yych = *++cur;
	if (yych == 'r') goto yy513;
	goto yy3;
yy419:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 282 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(monadic); }
#line 2332 "src/parse/conf_lexer.cc"
yy420:
	yych = *++cur;
	if (yych == 'i') goto yy514;
	goto yy3;
yy421:
	yych = *++cur;
	if (yych == 'a') goto yy515;
	goto yy3;
yy422:
	yych = *++cur;
	if (yych == 'l') goto yy516;
	goto yy3;
yy423:
	yych = *++cur;
	if (yych == 'b') goto yy517;
	goto yy3;
yy424:
	yych = *++cur;
	if (yych == 'b') goto yy518;
	goto yy3;
yy425:
	yych = *++cur;
	if (yych == 'e') goto yy519;
	goto yy3;
yy426:
	yych = *++cur;
	if (yych == 'e') goto yy520;
	goto yy3;
yy427:
	yych = *++cur;
	if (yych == 'p') goto yy521;
	goto yy3;
yy428:
	yych = *++cur;
	if (yych == 'g') goto yy522;
	goto yy3;
yy429:
	yych = *++cur;
	if (yych == 'e') goto yy523;
	goto yy3;
yy430:
	yych = *++cur;
	if (yych == 'e') goto yy524;
	goto yy3;
yy431:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 127 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(verbose); }
#line 2382 "src/parse/conf_lexer.cc"
yy432:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 123 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(version); }
#line 2388 "src/parse/conf_lexer.cc"
yy433:
	yych = *++cur;
	if (yych == 't') goto yy525;
	goto yy3;
yy434:
	yych = *++cur;
	if (yych == 'x') goto yy526;
	goto yy3;
yy435:
	yych = *++cur;
	if (yych == 'n') goto yy527;
	goto yy3;
yy436:
	yych = *++cur;
	if (yych == 'i') goto yy528;
	goto yy3;
yy437:
	yych = *++cur;
	if (yych == 't') goto yy529;
	goto yy3;
yy438:
	yych = *++cur;
	if (yych == 'e') goto yy530;
	goto yy3;
yy439:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'c') goto yy531;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy532;
		if (yych == 'p') goto yy533;
		goto yy3;
	}
yy440:
	yych = *++cur;
	if (yych == 'p') goto yy534;
	goto yy3;
yy441:
	yych = *++cur;
	if (yych == 'r') goto yy535;
	goto yy3;
yy442:
	yych = *++cur;
	if (yych == 'h') goto yy536;
	goto yy3;
yy443:
	yych = *++cur;
	if (yych == 'h') goto yy537;
	goto yy3;
yy444:
	yych = *++cur;
	if (yych == 'd') goto yy538;
	goto yy3;
yy445:
	yych = *++cur;
	if (yych == 'e') goto yy539;
	goto yy3;
yy446:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 248 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_state); }
#line 2452 "src/parse/conf_lexer.cc"
yy447:
	yych = *++cur;
	if (yych == 't') goto yy540;
	goto yy3;
yy448:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'C') goto yy541;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy449;
			if (yych <= 'z') goto yy2;
		}
	}
yy449:
#line 191 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_backup); }
#line 2478 "src/parse/conf_lexer.cc"
yy450:
	yych = *++cur;
	if (yych == 'P') goto yy542;
	goto yy3;
yy451:
	yych = *++cur;
	if (yych == 'A') goto yy543;
	goto yy3;
yy452:
	yych = *++cur;
	if (yych == 'A') goto yy544;
	goto yy3;
yy453:
	yych = *++cur;
	if (yych == 'K') goto yy545;
	goto yy3;
yy454:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 199 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cursor); }
#line 2500 "src/parse/conf_lexer.cc"
yy455:
	yych = *++cur;
	if (yych == 'a') goto yy546;
	goto yy3;
yy456:
	yych = *++cur;
	if (yych == 'e') goto yy547;
	goto yy347;
yy457:
	yych = *++cur;
	if (yych == 'E') goto yy548;
	goto yy3;
yy458:
	yych = *++cur;
	if (yych == 'D') goto yy549;
	goto yy3;
yy459:
	yych = *++cur;
	if (yych == 'T') goto yy551;
	goto yy3;
yy460:
	yych = *++cur;
	if (yych == 'A') goto yy552;
	goto yy3;
yy461:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 212 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_marker); }
#line 2530 "src/parse/conf_lexer.cc"
yy462:
	yych = *++cur;
	if (yych == 'L') goto yy553;
	goto yy3;
yy463:
	yych = *++cur;
	if (yych == 'T') goto yy554;
	goto yy3;
yy464:
	yych = *++cur;
	if (yych == 'E') goto yy555;
	goto yy3;
yy465:
	yych = *++cur;
	if (yych == 'E') goto yy557;
	goto yy3;
yy466:
	yych = *++cur;
	if (yych == 'D') goto yy558;
	goto yy3;
yy467:
	yych = *++cur;
	if (yych == 'T') goto yy560;
	goto yy3;
yy468:
	yych = *++cur;
	if (yych == 'T') goto yy561;
	goto yy3;
yy469:
	yych = *++cur;
	if (yych == 'T') goto yy562;
	goto yy3;
yy470:
	yych = *++cur;
	if (yych == 'l') goto yy563;
	goto yy3;
yy471:
	yych = *++cur;
	if (yych == 'e') goto yy564;
	goto yy3;
yy472:
	yych = *++cur;
	if (yych == 'o') goto yy565;
	goto yy3;
yy473:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 160 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_array, true);
        return Ret::OK;
    }
#line 2585 "src/parse/conf_lexer.cc"
yy474:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 173 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_array, false);
        return Ret::OK;
    }
#line 2596 "src/parse/conf_lexer.cc"
yy475:
	yych = *++cur;
	if (yych == 'e') goto yy566;
	goto yy3;
yy476:
	yych = *++cur;
	if (yych == 'e') goto yy567;
	goto yy3;
yy477:
	yych = *++cur;
	if (yych == 'g') goto yy568;
	goto yy3;
yy478:
	yych = *++cur;
	if (yych == 'l') goto yy569;
	goto yy3;
yy479:
	yych = *++cur;
	if (yych == 'r') goto yy570;
	goto yy3;
yy480:
	yych = *++cur;
	if (yych == 'e') goto yy571;
	goto yy3;
yy481:
	yych = *++cur;
	if (yych == '-') goto yy572;
	goto yy3;
yy482:
	yych = *++cur;
	if (yych == 'r') goto yy573;
	goto yy3;
yy483:
	yych = *++cur;
	if (yych == 'i') goto yy574;
	goto yy3;
yy484:
	yych = *++cur;
	if (yych == 'o') goto yy575;
	goto yy3;
yy485:
	yych = *++cur;
	if (yych == 'p') goto yy577;
	goto yy3;
yy486:
	yych = *++cur;
	if (yych == 'n') goto yy578;
	goto yy3;
yy487:
	yych = *++cur;
	if (yych == 'i') goto yy579;
	goto yy3;
yy488:
	yych = *++cur;
	if (yych == 't') goto yy580;
	goto yy3;
yy489:
	yych = *++cur;
	if (yych == 'a') goto yy581;
	goto yy3;
yy490:
	yych = *++cur;
	if (yych == '-') goto yy582;
	if (yych == ':') goto yy583;
	goto yy3;
yy491:
	yych = *++cur;
	if (yych == 'p') goto yy584;
	if (yych == 's') goto yy65;
	goto yy3;
yy492:
	yych = *++cur;
	if (yych == 'm') goto yy585;
	goto yy3;
yy493:
	yych = *++cur;
	if (yych == 'b') goto yy71;
	goto yy3;
yy494:
	yych = *++cur;
	if (yych == 'b') goto yy586;
	goto yy3;
yy495:
	yych = *++cur;
	if (yych == 'c') goto yy587;
	goto yy3;
yy496:
	yych = *++cur;
	if (yych == 'p') goto yy588;
	goto yy3;
yy497:
	yych = *++cur;
	if (yych == 'f') goto yy589;
	goto yy3;
yy498:
	yych = *++cur;
	if (yych == 's') goto yy590;
	goto yy3;
yy499:
	yych = *++cur;
	if (yych == 'g') goto yy591;
	goto yy3;
yy500:
	yych = *++cur;
	if (yych == 'p') goto yy592;
	goto yy3;
yy501:
	yych = *++cur;
	if (yych == 'i') goto yy593;
	if (yych == 's') goto yy93;
	goto yy3;
yy502:
	yych = *++cur;
	if (yych == 'f') goto yy594;
	goto yy3;
yy503:
	yych = *++cur;
	if (yych == 'd') goto yy595;
	goto yy3;
yy504:
	yych = *++cur;
	if (yych == 't') goto yy596;
	goto yy3;
yy505:
	yych = *++cur;
	if (yych == 't') goto yy597;
	goto yy3;
yy506:
	yych = *++cur;
	if (yych == 'o') goto yy598;
	goto yy3;
yy507:
	yych = *++cur;
	if (yych == 'c') goto yy599;
	goto yy3;
yy508:
	yych = *++cur;
	if (yych == 'a') goto yy600;
	goto yy3;
yy509:
	yych = *++cur;
	if (yych == 'a') goto yy601;
	goto yy3;
yy510:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy602;
		if (yych <= 'M') goto yy3;
		goto yy603;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy3;
			goto yy604;
		} else {
			if (yych == 'l') goto yy605;
			goto yy3;
		}
	}
yy511:
	yych = *++cur;
	if (yych == 'f') goto yy606;
	goto yy3;
yy512:
	yych = *++cur;
	if (yych == '-') goto yy607;
	goto yy3;
yy513:
	yych = *++cur;
	if (yych == 's') goto yy608;
	goto yy3;
yy514:
	yych = *++cur;
	if (yych == 'f') goto yy609;
	goto yy3;
yy515:
	yych = *++cur;
	if (yych == 'p') goto yy610;
	goto yy3;
yy516:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 148 "../src/parse/conf_lexer.re"
	{ RET_CONF_EOF(fill_sentinel); }
#line 2780 "src/parse/conf_lexer.cc"
yy517:
	yych = *++cur;
	if (yych == 'e') goto yy611;
	goto yy3;
yy518:
	yych = *++cur;
	if (yych == 'o') goto yy612;
	goto yy3;
yy519:
	yych = *++cur;
	if (yych == 'x') goto yy613;
	goto yy3;
yy520:
	yych = *++cur;
	if (yych == '-') goto yy614;
	goto yy3;
yy521:
	yych = *++cur;
	if (yych == 'r') goto yy615;
	goto yy3;
yy522:
	yych = *++cur;
	if (yych == 'a') goto yy616;
	goto yy3;
yy523:
	yych = *++cur;
	if (yych == 'f') goto yy617;
	goto yy3;
yy524:
	yych = *++cur;
	if (yych == ':') goto yy618;
	goto yy3;
yy525:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 246 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_accept); }
#line 2818 "src/parse/conf_lexer.cc"
yy526:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 257 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(bitmaps_hex); }
#line 2824 "src/parse/conf_lexer.cc"
yy527:
	yych = *++cur;
	if (yych == 'v') goto yy619;
	goto yy3;
yy528:
	yych = *++cur;
	if (yych == 't') goto yy620;
	goto yy3;
yy529:
	yych = *++cur;
	if (yych == 'e') goto yy621;
	goto yy3;
yy530:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 245 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_cond_table); }
#line 2842 "src/parse/conf_lexer.cc"
yy531:
	yych = *++cur;
	if (yych == 'h') goto yy622;
	goto yy3;
yy532:
	yych = *++cur;
	if (yych == 'n') goto yy623;
	goto yy3;
yy533:
	yych = *++cur;
	if (yych == 'a') goto yy624;
	goto yy3;
yy534:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 154 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(fn_sep); }
#line 2860 "src/parse/conf_lexer.cc"
yy535:
	yych = *++cur;
	if (yych == 'o') goto yy625;
	goto yy3;
yy536:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 249 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_nmatch); }
#line 2870 "src/parse/conf_lexer.cc"
yy537:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 250 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_pmatch); }
#line 2876 "src/parse/conf_lexer.cc"
yy538:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 251 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_record); }
#line 2882 "src/parse/conf_lexer.cc"
yy539:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 259 "../src/parse/conf_lexer.re"
	{ return lex_conf_string(opts); }
#line 2888 "src/parse/conf_lexer.cc"
yy540:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 247 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_cgoto_table); }
#line 2894 "src/parse/conf_lexer.cc"
yy541:
	yych = *++cur;
	if (yych == 'T') goto yy626;
	goto yy3;
yy542:
	yych = *++cur;
	if (yych == 'E') goto yy627;
	goto yy3;
yy543:
	yych = *++cur;
	if (yych == 'G') goto yy628;
	goto yy3;
yy544:
	yych = *++cur;
	if (yych == 'G') goto yy629;
	goto yy3;
yy545:
	yych = *++cur;
	if (yych == 'E') goto yy630;
	goto yy3;
yy546:
	yych = *++cur;
	if (yych == 'k') goto yy631;
	goto yy3;
yy547:
	yych = *++cur;
	if (yych == 'n') goto yy632;
	goto yy347;
yy548:
	yych = *++cur;
	if (yych == 'P') goto yy633;
	goto yy3;
yy549:
	yych = *++cur;
	if (yych <= 'H') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy634;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'I') goto yy635;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy550;
			if (yych <= 'z') goto yy2;
		}
	}
yy550:
#line 206 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_get); }
#line 2949 "src/parse/conf_lexer.cc"
yy551:
	yych = *++cur;
	if (yych == 'E') goto yy636;
	goto yy3;
yy552:
	yych = *++cur;
	if (yych == 'N') goto yy638;
	goto yy3;
yy553:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 213 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_maxfill); }
#line 2963 "src/parse/conf_lexer.cc"
yy554:
	yych = *++cur;
	if (yych == 'C') goto yy639;
	goto yy3;
yy555:
	yych = *++cur;
	if (yych <= 'C') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy556;
			if (yych <= 'B') goto yy2;
			goto yy640;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'T') goto yy641;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy556;
			if (yych <= 'z') goto yy2;
		}
	}
yy556:
#line 218 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore); }
#line 2991 "src/parse/conf_lexer.cc"
yy557:
	yych = *++cur;
	if (yych == 'P') goto yy642;
	goto yy3;
yy558:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy643;
			if (yych >= '@') goto yy644;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'I') goto yy645;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy559;
			if (yych <= 'z') goto yy2;
		}
	}
yy559:
#line 222 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_set); }
#line 3019 "src/parse/conf_lexer.cc"
yy560:
	yych = *++cur;
	if (yych == 'E') goto yy646;
	goto yy3;
yy561:
	yych = *++cur;
	if (yych == 'A') goto yy648;
	goto yy3;
yy562:
	yych = *++cur;
	if (yych == 'A') goto yy649;
	goto yy3;
yy563:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 134 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(api_sigil); }
#line 3037 "src/parse/conf_lexer.cc"
yy564:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 133 "../src/parse/conf_lexer.re"
	{ goto api_style; }
#line 3043 "src/parse/conf_lexer.cc"
yy565:
	yych = *++cur;
	if (yych == 'r') goto yy650;
	goto yy3;
yy566:
	yych = *++cur;
	if (yych == 'n') goto yy651;
	goto yy3;
yy567:
	yych = *++cur;
	if (yych == 'r') goto yy652;
	goto yy3;
yy568:
	yych = *++cur;
	if (yych == 'e') goto yy653;
	goto yy3;
yy569:
	yych = *++cur;
	if (yych == 'a') goto yy654;
	goto yy3;
yy570:
	yych = *++cur;
	if (yych == 'e') goto yy655;
	goto yy3;
yy571:
	yych = *++cur;
	if (yych == 'l') goto yy656;
	goto yy3;
yy572:
	yych = *++cur;
	if (yych == 'g') goto yy657;
	goto yy3;
yy573:
	yych = *++cur;
	if (yych == 't') goto yy658;
	goto yy3;
yy574:
	yych = *++cur;
	if (yych == 'd') goto yy659;
	goto yy3;
yy575:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych == '@') goto yy660;
yy576:
#line 266 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(cond_goto); }
#line 3092 "src/parse/conf_lexer.cc"
yy577:
	yych = *++cur;
	if (yych == 'r') goto yy661;
	goto yy3;
yy578:
	yych = *++cur;
	if (yych == 's') goto yy662;
	goto yy3;
yy579:
	yych = *++cur;
	if (yych == 'x') goto yy663;
	goto yy3;
yy580:
	yych = *++cur;
	if (yych == 'p') goto yy664;
	goto yy3;
yy581:
	yych = *++cur;
	if (yych == 's') goto yy665;
	goto yy3;
yy582:
	yych = *++cur;
	if (yych == 'p') goto yy666;
	goto yy3;
yy583:
	yych = *++cur;
	if (yych == 'e') goto yy667;
	if (yych == 'u') goto yy668;
	goto yy3;
yy584:
	yych = *++cur;
	if (yych == 't') goto yy669;
	goto yy3;
yy585:
	yych = *++cur;
	if (yych == 'p') goto yy670;
	goto yy3;
yy586:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy397;
yy587:
	yych = *++cur;
	if (yych == 'o') goto yy671;
	goto yy3;
yy588:
	yych = *++cur;
	if (yych == 'u') goto yy672;
	goto yy3;
yy589:
	yych = *++cur;
	if (yych == 't') goto yy673;
	goto yy3;
yy590:
	yych = *++cur;
	if (yych == 'i') goto yy674;
	goto yy3;
yy591:
	yych = *++cur;
	if (yych == 's') goto yy390;
	goto yy3;
yy592:
	yych = *++cur;
	if (yych == 'e') goto yy675;
	goto yy3;
yy593:
	yych = *++cur;
	if (yych == 'c') goto yy676;
	goto yy3;
yy594:
	yych = *++cur;
	if (yych == '-') goto yy677;
	goto yy3;
yy595:
	yych = *++cur;
	if (yych == 'e') goto yy678;
	goto yy3;
yy596:
	yych = *++cur;
	if (yych == 'a') goto yy679;
	goto yy3;
yy597:
	yych = *++cur;
	if (yych == 'r') goto yy680;
	goto yy3;
yy598:
	yych = *++cur;
	if (yych == 'p') goto yy681;
	goto yy3;
yy599:
	yych = *++cur;
	if (yych == 'o') goto yy682;
	goto yy3;
yy600:
	yych = *++cur;
	if (yych == 'p') goto yy683;
	goto yy3;
yy601:
	yych = *++cur;
	if (yych == 'r') goto yy684;
	goto yy3;
yy602:
	yych = *++cur;
	if (yych == 'i') goto yy685;
	goto yy3;
yy603:
	yych = *++cur;
	if (yych == 'e') goto yy686;
	goto yy3;
yy604:
	yych = *++cur;
	if (yych == 'i') goto yy687;
	goto yy3;
yy605:
	yych = *++cur;
	if (yych == 'o') goto yy688;
	goto yy3;
yy606:
	yych = *++cur;
	if (yych == 'i') goto yy689;
	goto yy3;
yy607:
	yych = *++cur;
	if (yych == 'c') goto yy690;
	goto yy3;
yy608:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 128 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(line_dirs); }
#line 3223 "src/parse/conf_lexer.cc"
yy609:
	yych = *++cur;
	if (yych == 's') goto yy403;
	goto yy3;
yy610:
	yych = *++cur;
	if (yych == 't') goto yy691;
	goto yy3;
yy611:
	yych = *++cur;
	if (yych == 'l') goto yy692;
	goto yy3;
yy612:
	yych = *++cur;
	if (yych == 'r') goto yy694;
	goto yy3;
yy613:
	yych = *++cur;
	if (yych == 't') goto yy695;
	goto yy3;
yy614:
	yych = *++cur;
	if (yych == 's') goto yy696;
	goto yy3;
yy615:
	yych = *++cur;
	if (yych == 'e') goto yy697;
	goto yy3;
yy616:
	yych = *++cur;
	if (yych == 't') goto yy698;
	goto yy3;
yy617:
	yych = *++cur;
	if (yych == 'i') goto yy699;
	goto yy3;
yy618:
	yych = *++cur;
	if (yych == 'y') goto yy700;
	goto yy3;
yy619:
	yych = *++cur;
	if (yych == 'e') goto yy701;
	goto yy3;
yy620:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 255 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(char_emit); }
#line 3273 "src/parse/conf_lexer.cc"
yy621:
	yych = *++cur;
	if (yych == 'r') goto yy702;
	goto yy3;
yy622:
	yych = *++cur;
	if (yych == 'e') goto yy703;
	goto yy3;
yy623:
	yych = *++cur;
	if (yych == 'a') goto yy704;
	goto yy3;
yy624:
	yych = *++cur;
	if (yych == 'r') goto yy705;
	goto yy3;
yy625:
	yych = *++cur;
	if (yych == 'w') goto yy706;
	goto yy3;
yy626:
	yych = *++cur;
	if (yych == 'X') goto yy707;
	goto yy3;
yy627:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 193 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_type); }
#line 3303 "src/parse/conf_lexer.cc"
yy628:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 194 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_copy); }
#line 3309 "src/parse/conf_lexer.cc"
yy629:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 195 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_copy); }
#line 3315 "src/parse/conf_lexer.cc"
yy630:
	yych = *++cur;
	if (yych == 'R') goto yy708;
	goto yy3;
yy631:
	yych = *++cur;
	if (yych == 'e') goto yy709;
	goto yy3;
yy632:
	++cur;
#line 203 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(fill_param); }
#line 3328 "src/parse/conf_lexer.cc"
yy633:
	yych = *++cur;
	if (yych == 'T') goto yy710;
	goto yy3;
yy634:
	yych = *++cur;
	if (yych == 'n') goto yy711;
	goto yy3;
yy635:
	yych = *++cur;
	if (yych == 'T') goto yy712;
	goto yy3;
yy636:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy713;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy637;
			if (yych <= 'z') goto yy2;
		}
	}
yy637:
#line 208 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_state_get); }
#line 3362 "src/parse/conf_lexer.cc"
yy638:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 210 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_less_than); }
#line 3368 "src/parse/conf_lexer.cc"
yy639:
	yych = *++cur;
	if (yych == 'H') goto yy714;
	goto yy3;
yy640:
	yych = *++cur;
	if (yych == 'T') goto yy715;
	goto yy3;
yy641:
	yych = *++cur;
	if (yych == 'A') goto yy716;
	goto yy3;
yy642:
	yych = *++cur;
	if (yych == 'T') goto yy717;
	goto yy3;
yy643:
	yych = *++cur;
	if (yych == 'n') goto yy718;
	goto yy3;
yy644:
	yych = *++cur;
	if (yych == 'c') goto yy719;
	goto yy347;
yy645:
	yych = *++cur;
	if (yych == 'T') goto yy720;
	goto yy3;
yy646:
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy721;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy722;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy647;
			if (yych <= 'z') goto yy2;
		}
	}
yy647:
#line 225 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_state_set); }
#line 3419 "src/parse/conf_lexer.cc"
yy648:
	yych = *++cur;
	if (yych == 'G') goto yy723;
	goto yy3;
yy649:
	yych = *++cur;
	if (yych == 'G') goto yy724;
	goto yy3;
yy650:
	yych = *++cur;
	if (yych == 's') goto yy725;
	goto yy3;
yy651:
	yych = *++cur;
	if (yych == 's') goto yy726;
	goto yy3;
yy652:
	yych = *++cur;
	if (yych == 't') goto yy727;
	goto yy3;
yy653:
	yych = *++cur;
	if (yych == 's') goto yy728;
	goto yy3;
yy654:
	yych = *++cur;
	if (yych == 't') goto yy729;
	goto yy3;
yy655:
	yych = *++cur;
	if (yych == 's') goto yy730;
	goto yy3;
yy656:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 120 "../src/parse/conf_lexer.re"
	{ goto code_model; }
#line 3457 "src/parse/conf_lexer.cc"
yy657:
	yych = *++cur;
	if (yych == 'o') goto yy731;
	goto yy3;
yy658:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 261 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_abort); }
#line 3467 "src/parse/conf_lexer.cc"
yy659:
	yych = *++cur;
	if (yych == 'e') goto yy732;
	goto yy3;
yy660:
	yych = *++cur;
	if (yych == 'c') goto yy733;
	goto yy347;
yy661:
	yych = *++cur;
	if (yych == 'e') goto yy734;
	goto yy3;
yy662:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 124 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(start_conditions); }
#line 3485 "src/parse/conf_lexer.cc"
yy663:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 262 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_label_prefix); }
#line 3491 "src/parse/conf_lexer.cc"
yy664:
	yych = *++cur;
	if (yych == 'u') goto yy735;
	goto yy3;
yy665:
	yych = *++cur;
	if (yych == 's') goto yy736;
	goto yy3;
yy666:
	yych = *++cur;
	if (yych == 'o') goto yy737;
	goto yy3;
yy667:
	yych = *++cur;
	if (yych == 'b') goto yy738;
	goto yy3;
yy668:
	yych = *++cur;
	if (yych == 'c') goto yy739;
	if (yych == 't') goto yy740;
	goto yy3;
yy669:
	yych = *++cur;
	if (yych == 'u') goto yy199;
	goto yy3;
yy670:
	yych = *++cur;
	if (yych == 'u') goto yy741;
	goto yy3;
yy671:
	yych = *++cur;
	if (yych == 'd') goto yy742;
	goto yy3;
yy672:
	yych = *++cur;
	if (yych == 't') goto yy743;
	goto yy3;
yy673:
	yych = *++cur;
	if (yych == 'm') goto yy744;
	goto yy3;
yy674:
	yych = *++cur;
	if (yych == 'x') goto yy745;
	goto yy3;
yy675:
	yych = *++cur;
	if (yych == '-') goto yy746;
	goto yy3;
yy676:
	yych = *++cur;
	if (yych == 'o') goto yy747;
	goto yy3;
yy677:
	yych = *++cur;
	if (yych == '1') goto yy748;
	if (yych == '8') goto yy388;
	goto yy3;
yy678:
	yych = *++cur;
	if (yych == '-') goto yy749;
	goto yy3;
yy679:
	yych = *++cur;
	if (yych == 'x') goto yy750;
	goto yy3;
yy680:
	yych = *++cur;
	if (yych == 'i') goto yy751;
	goto yy3;
yy681:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 294 "../src/parse/conf_lexer.re"
	{ RET_CONF_NUM_NONNEG(indent_top); }
#line 3567 "src/parse/conf_lexer.cc"
yy682:
	yych = *++cur;
	if (yych == 'd') goto yy752;
	goto yy3;
yy683:
	yych = *++cur;
	if (yych == 't') goto yy753;
	goto yy3;
yy684:
	yych = *++cur;
	if (yych == 't') goto yy692;
	goto yy3;
yy685:
	yych = *++cur;
	if (yych == 'l') goto yy754;
	goto yy3;
yy686:
	yych = *++cur;
	if (yych == 'x') goto yy755;
	goto yy3;
yy687:
	yych = *++cur;
	if (yych == 'l') goto yy756;
	goto yy3;
yy688:
	yych = *++cur;
	if (yych == 'o') goto yy757;
	goto yy3;
yy689:
	yych = *++cur;
	if (yych == 'x') goto yy758;
	goto yy3;
yy690:
	yych = *++cur;
	if (yych == 'a') goto yy759;
	goto yy3;
yy691:
	yych = *++cur;
	if (yych <= 't') goto yy3;
	if (yych <= 'u') goto yy760;
	if (yych <= 'v') goto yy761;
	goto yy3;
yy692:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych <= '\r') {
		if (yych == '\t') {
			ctx = cur;
			goto yy762;
		}
		if (yych >= '\r') {
			ctx = cur;
			goto yy762;
		}
	} else {
		if (yych <= ' ') {
			if (yych >= ' ') {
				ctx = cur;
				goto yy762;
			}
		} else {
			if (yych == '=') {
				ctx = cur;
				goto yy763;
			}
		}
	}
yy693:
#line 301 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_start); }
#line 3639 "src/parse/conf_lexer.cc"
yy694:
	yych = *++cur;
	if (yych == 't') goto yy764;
	goto yy3;
yy695:
	yych = *++cur;
	if (yych == 'l') goto yy765;
	goto yy3;
yy696:
	yych = *++cur;
	if (yych == 't') goto yy766;
	goto yy3;
yy697:
	yych = *++cur;
	if (yych == 's') goto yy767;
	goto yy3;
yy698:
	yych = *++cur;
	if (yych == 'i') goto yy768;
	goto yy3;
yy699:
	yych = *++cur;
	if (yych == 'x') goto yy769;
	goto yy3;
yy700:
	yych = *++cur;
	if (yych == 'y') goto yy770;
	goto yy3;
yy701:
	yych = *++cur;
	if (yych == 'r') goto yy771;
	goto yy3;
yy702:
	yych = *++cur;
	if (yych == 'a') goto yy772;
	goto yy3;
yy703:
	yych = *++cur;
	if (yych == 'c') goto yy773;
	goto yy3;
yy704:
	yych = *++cur;
	if (yych == 'b') goto yy774;
	goto yy3;
yy705:
	yych = *++cur;
	if (yych == 'a') goto yy775;
	goto yy3;
yy706:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 155 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(fn_throw); }
#line 3693 "src/parse/conf_lexer.cc"
yy707:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 192 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_backup_ctx); }
#line 3699 "src/parse/conf_lexer.cc"
yy708:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 197 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_ctxmarker); }
#line 3705 "src/parse/conf_lexer.cc"
yy709:
	yych = *++cur;
	if (yych == 'd') goto yy776;
	goto yy3;
yy710:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 205 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_accept_get); }
#line 3715 "src/parse/conf_lexer.cc"
yy711:
	yych = *++cur;
	if (yych == 'a') goto yy777;
	goto yy3;
yy712:
	yych = *++cur;
	if (yych == 'I') goto yy778;
	goto yy3;
yy713:
	yych = *++cur;
	if (yych == 'n') goto yy779;
	goto yy3;
yy714:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 214 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_maxnmatch); }
#line 3733 "src/parse/conf_lexer.cc"
yy715:
	yych = *++cur;
	if (yych == 'X') goto yy780;
	goto yy3;
yy716:
	yych = *++cur;
	if (yych == 'G') goto yy781;
	goto yy3;
yy717:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 221 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_accept_set); }
#line 3747 "src/parse/conf_lexer.cc"
yy718:
	yych = *++cur;
	if (yych == 'a') goto yy782;
	goto yy3;
yy719:
	yych = *++cur;
	if (yych == 'o') goto yy783;
	goto yy347;
yy720:
	yych = *++cur;
	if (yych == 'I') goto yy784;
	goto yy3;
yy721:
	yych = *++cur;
	if (yych == 'n') goto yy785;
	goto yy3;
yy722:
	yych = *++cur;
	if (yych == 's') goto yy786;
	goto yy347;
yy723:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 230 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_shift); }
#line 3773 "src/parse/conf_lexer.cc"
yy724:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 229 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_shift); }
#line 3779 "src/parse/conf_lexer.cc"
yy725:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy392;
yy726:
	yych = *++cur;
	if (yych == 'i') goto yy787;
	goto yy3;
yy727:
	yych = *++cur;
	if (yych == 'e') goto yy788;
	goto yy3;
yy728:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 280 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(case_ranges, "case-ranges"); }
#line 3797 "src/parse/conf_lexer.cc"
yy729:
	yych = *++cur;
	if (yych == 'i') goto yy789;
	goto yy3;
yy730:
	yych = *++cur;
	if (yych == 'h') goto yy790;
	goto yy3;
yy731:
	yych = *++cur;
	if (yych == 't') goto yy791;
	goto yy3;
yy732:
	yych = *++cur;
	if (yych == 'r') goto yy792;
	goto yy3;
yy733:
	yych = *++cur;
	if (yych == 'o') goto yy794;
	goto yy347;
yy734:
	yych = *++cur;
	if (yych == 'f') goto yy795;
	goto yy3;
yy735:
	yych = *++cur;
	if (yych == 't') goto yy796;
	goto yy3;
yy736:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 291 "../src/parse/conf_lexer.re"
	{ goto empty_class; }
#line 3831 "src/parse/conf_lexer.cc"
yy737:
	yych = *++cur;
	if (yych == 'l') goto yy797;
	goto yy3;
yy738:
	yych = *++cur;
	if (yych == 'c') goto yy798;
	goto yy3;
yy739:
	yych = *++cur;
	if (yych == 's') goto yy799;
	goto yy3;
yy740:
	yych = *++cur;
	if (yych == 'f') goto yy800;
	goto yy3;
yy741:
	yych = *++cur;
	if (yych == 't') goto yy801;
	goto yy3;
yy742:
	yych = *++cur;
	if (yych == 'i') goto yy802;
	goto yy3;
yy743:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy62;
yy744:
	yych = *++cur;
	if (yych == 'o') goto yy803;
	goto yy3;
yy745:
	yych = *++cur;
	if (yych == '-') goto yy804;
	goto yy3;
yy746:
	yych = *++cur;
	if (yych == 'h') goto yy11;
	goto yy3;
yy747:
	yych = *++cur;
	if (yych == 'd') goto yy805;
	goto yy3;
yy748:
	yych = *++cur;
	if (yych == '6') goto yy409;
	goto yy3;
yy749:
	yych = *++cur;
	if (yych == 'c') goto yy806;
	goto yy3;
yy750:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 126 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(flex_syntax); }
#line 3889 "src/parse/conf_lexer.cc"
yy751:
	yych = *++cur;
	if (yych == 'n') goto yy807;
	goto yy3;
yy752:
	yych = *++cur;
	if (yych == 'i') goto yy808;
	goto yy3;
yy753:
	yych = *++cur;
	if (yych == 'u') goto yy809;
	goto yy3;
yy754:
	yych = *++cur;
	if (yych == 'l') goto yy810;
	goto yy3;
yy755:
	yych = *++cur;
	if (yych == 't') goto yy811;
	goto yy3;
yy756:
	yych = *++cur;
	if (yych == 'l') goto yy812;
	goto yy3;
yy757:
	yych = *++cur;
	if (yych == 'p') goto yy813;
	goto yy3;
yy758:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 296 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_prefix); }
#line 3923 "src/parse/conf_lexer.cc"
yy759:
	yych = *++cur;
	if (yych == 'p') goto yy64;
	goto yy3;
yy760:
	yych = *++cur;
	if (yych == 'r') goto yy814;
	goto yy3;
yy761:
	yych = *++cur;
	if (yych == 'a') goto yy815;
	goto yy3;
yy762:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy762;
	if (yych != '=') goto yy347;
yy763:
	++cur;
	if ((lim - cur) < 2) YYFILL(2);
	yych = *cur;
	if (yych <= ' ') {
		if (yych <= '\f') {
			if (yych == '\t') goto yy763;
			goto yy347;
		} else {
			if (yych <= '\r') goto yy763;
			if (yych <= 0x1F) goto yy347;
			goto yy763;
		}
	} else {
		if (yych <= '/') {
			if (yych == '-') goto yy816;
			goto yy347;
		} else {
			if (yych <= '0') goto yy817;
			if (yych <= '9') goto yy819;
			goto yy347;
		}
	}
yy764:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 269 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_abort); }
#line 3970 "src/parse/conf_lexer.cc"
yy765:
	yych = *++cur;
	if (yych == 'a') goto yy820;
	goto yy3;
yy766:
	yych = *++cur;
	if (yych == 'a') goto yy821;
	goto yy3;
yy767:
	yych = *++cur;
	if (yych == 's') goto yy822;
	goto yy3;
yy768:
	yych = *++cur;
	if (yych == 'v') goto yy823;
	goto yy3;
yy769:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 186 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(tags_prefix); }
#line 3992 "src/parse/conf_lexer.cc"
yy770:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy96;
		case 'b': goto yy97;
		case 'c': goto yy98;
		case 'f': goto yy824;
		case 'n': goto yy100;
		case 'p': goto yy101;
		case 'r': goto yy102;
		case 's': goto yy103;
		case 't': goto yy104;
		default: goto yy3;
	}
yy771:
	yych = *++cur;
	if (yych == 's') goto yy825;
	goto yy3;
yy772:
	yych = *++cur;
	if (yych == 'l') goto yy826;
	goto yy3;
yy773:
	yych = *++cur;
	if (yych == 'k') goto yy827;
	goto yy3;
yy774:
	yych = *++cur;
	if (yych == 'l') goto yy828;
	goto yy3;
yy775:
	yych = *++cur;
	if (yych == 'm') goto yy829;
	goto yy3;
yy776:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 204 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_naked); }
#line 4032 "src/parse/conf_lexer.cc"
yy777:
	yych = *++cur;
	if (yych == 'k') goto yy830;
	goto yy3;
yy778:
	yych = *++cur;
	if (yych == 'O') goto yy831;
	goto yy3;
yy779:
	yych = *++cur;
	if (yych == 'a') goto yy832;
	goto yy3;
yy780:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 219 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore_ctx); }
#line 4050 "src/parse/conf_lexer.cc"
yy781:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 220 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore_tag); }
#line 4056 "src/parse/conf_lexer.cc"
yy782:
	yych = *++cur;
	if (yych == 'k') goto yy833;
	goto yy3;
yy783:
	yych = *++cur;
	if (yych == 'n') goto yy834;
	goto yy347;
yy784:
	yych = *++cur;
	if (yych == 'O') goto yy835;
	goto yy3;
yy785:
	yych = *++cur;
	if (yych == 'a') goto yy836;
	goto yy3;
yy786:
	yych = *++cur;
	if (yych == 't') goto yy837;
	goto yy347;
yy787:
	yych = *++cur;
	if (yych == 't') goto yy838;
	goto yy3;
yy788:
	yych = *++cur;
	if (yych == 'd') goto yy839;
	goto yy3;
yy789:
	yych = *++cur;
	if (yych == 'v') goto yy840;
	goto yy3;
yy790:
	yych = *++cur;
	if (yych == 'o') goto yy841;
	goto yy3;
yy791:
	yych = *++cur;
	if (yych == 'o') goto yy842;
	goto yy3;
yy792:
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych == '@') goto yy843;
yy793:
#line 264 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(cond_div); }
#line 4105 "src/parse/conf_lexer.cc"
yy794:
	yych = *++cur;
	if (yych == 'n') goto yy844;
	goto yy347;
yy795:
	yych = *++cur;
	if (yych == 'i') goto yy845;
	goto yy3;
yy796:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy395;
yy797:
	yych = *++cur;
	if (yych == 'i') goto yy846;
	goto yy3;
yy798:
	yych = *++cur;
	if (yych == 'd') goto yy847;
	goto yy3;
yy799:
	yych = *++cur;
	if (yych == '2') goto yy848;
	goto yy3;
yy800:
	yych = *++cur;
	if (yych <= '2') {
		if (yych == '1') goto yy748;
		goto yy3;
	} else {
		if (yych <= '3') goto yy849;
		if (yych == '8') goto yy388;
		goto yy3;
	}
yy801:
	yych = *++cur;
	if (yych == 'e') goto yy850;
	goto yy3;
yy802:
	yych = *++cur;
	if (yych == 'n') goto yy851;
	goto yy3;
yy803:
	yych = *++cur;
	if (yych == 's') goto yy852;
	goto yy3;
yy804:
	yych = *++cur;
	if (yych == 'c') goto yy853;
	goto yy3;
yy805:
	yych = *++cur;
	if (yych == 'e') goto yy854;
	goto yy3;
yy806:
	yych = *++cur;
	if (yych == 'h') goto yy855;
	goto yy3;
yy807:
	yych = *++cur;
	if (yych == 'g') goto yy856;
	goto yy3;
yy808:
	yych = *++cur;
	if (yych == 'n') goto yy857;
	goto yy3;
yy809:
	yych = *++cur;
	if (yych == 'r') goto yy858;
	goto yy3;
yy810:
	yych = *++cur;
	if (yych == 'L') goto yy859;
	goto yy3;
yy811:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 299 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_next); }
#line 4185 "src/parse/conf_lexer.cc"
yy812:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 297 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_fill); }
#line 4191 "src/parse/conf_lexer.cc"
yy813:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 298 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_loop); }
#line 4197 "src/parse/conf_lexer.cc"
yy814:
	yych = *++cur;
	if (yych == 'e') goto yy860;
	goto yy3;
yy815:
	yych = *++cur;
	if (yych == 'r') goto yy861;
	goto yy3;
yy816:
	yych = *++cur;
	if (yych <= '0') goto yy347;
	if (yych <= '9') goto yy819;
	goto yy347;
yy817:
	++cur;
yy818:
	cur = ctx;
#line 300 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(label_start_force); }
#line 4217 "src/parse/conf_lexer.cc"
yy819:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy819;
	goto yy818;
yy820:
	yych = *++cur;
	if (yych == 'b') goto yy862;
	goto yy3;
yy821:
	yych = *++cur;
	if (yych == 't') goto yy863;
	goto yy3;
yy822:
	yych = *++cur;
	if (yych == 'i') goto yy864;
	goto yy3;
yy823:
	yych = *++cur;
	if (yych == 'e') goto yy865;
	goto yy3;
yy824:
	yych = *++cur;
	if (yych == 'i') goto yy866;
	goto yy3;
yy825:
	yych = *++cur;
	if (yych == 'i') goto yy867;
	goto yy3;
yy826:
	yych = *++cur;
	if (yych == 's') goto yy868;
	goto yy3;
yy827:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 152 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_check); }
#line 4257 "src/parse/conf_lexer.cc"
yy828:
	yych = *++cur;
	if (yych == 'e') goto yy869;
	goto yy3;
yy829:
	yych = *++cur;
	if (yych == 'e') goto yy870;
	goto yy3;
yy830:
	yych = *++cur;
	if (yych == 'e') goto yy871;
	goto yy3;
yy831:
	yych = *++cur;
	if (yych == 'N') goto yy872;
	goto yy3;
yy832:
	yych = *++cur;
	if (yych == 'k') goto yy873;
	goto yy3;
yy833:
	yych = *++cur;
	if (yych == 'e') goto yy874;
	goto yy3;
yy834:
	yych = *++cur;
	if (yych == 'd') goto yy875;
	goto yy347;
yy835:
	yych = *++cur;
	if (yych == 'N') goto yy876;
	goto yy3;
yy836:
	yych = *++cur;
	if (yych == 'k') goto yy877;
	goto yy3;
yy837:
	yych = *++cur;
	if (yych == 'a') goto yy878;
	goto yy347;
yy838:
	yych = *++cur;
	if (yych == 'i') goto yy879;
	goto yy3;
yy839:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 279 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(case_inverted); }
#line 4307 "src/parse/conf_lexer.cc"
yy840:
	yych = *++cur;
	if (yych == 'e') goto yy880;
	goto yy3;
yy841:
	yych = *++cur;
	if (yych == 'l') goto yy881;
	goto yy3;
yy842:
	yych = *++cur;
	if (yych == 's') goto yy882;
	goto yy3;
yy843:
	yych = *++cur;
	if (yych == 'c') goto yy883;
	goto yy347;
yy844:
	yych = *++cur;
	if (yych == 'd') goto yy884;
	goto yy347;
yy845:
	yych = *++cur;
	if (yych == 'x') goto yy885;
	goto yy3;
yy846:
	yych = *++cur;
	if (yych == 'c') goto yy886;
	goto yy3;
yy847:
	yych = *++cur;
	if (yych == 'i') goto yy887;
	goto yy3;
yy848:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy408;
yy849:
	yych = *++cur;
	if (yych == '2') goto yy854;
	goto yy3;
yy850:
	yych = *++cur;
	if (yych == 'd') goto yy888;
	goto yy3;
yy851:
	yych = *++cur;
	if (yych == 'g') goto yy889;
	goto yy3;
yy852:
	yych = *++cur;
	if (yych == 't') goto yy890;
	goto yy3;
yy853:
	yych = *++cur;
	if (yych == 'a') goto yy891;
	goto yy3;
yy854:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy406;
yy855:
	yych = *++cur;
	if (yych == 'a') goto yy892;
	goto yy3;
yy856:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 293 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(indent_str); }
#line 4377 "src/parse/conf_lexer.cc"
yy857:
	yych = *++cur;
	if (yych == 'g') goto yy893;
	goto yy3;
yy858:
	yych = *++cur;
	if (yych == 'e') goto yy894;
	goto yy3;
yy859:
	yych = *++cur;
	if (yych == 'a') goto yy895;
	goto yy3;
yy860:
	yych = *++cur;
	if (yych == 's') goto yy389;
	goto yy3;
yy861:
	yych = *++cur;
	if (yych == 's') goto yy896;
	goto yy3;
yy862:
	yych = *++cur;
	if (yych == 'e') goto yy897;
	goto yy3;
yy863:
	yych = *++cur;
	if (yych == 'e') goto yy898;
	goto yy3;
yy864:
	yych = *++cur;
	if (yych == 'o') goto yy899;
	goto yy3;
yy865:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 188 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(tags_negative); }
#line 4415 "src/parse/conf_lexer.cc"
yy866:
	yych = *++cur;
	if (yych == 'l') goto yy900;
	goto yy3;
yy867:
	yych = *++cur;
	if (yych == 'o') goto yy901;
	goto yy3;
yy868:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 254 "../src/parse/conf_lexer.re"
	{ goto char_lit; }
#line 4429 "src/parse/conf_lexer.cc"
yy869:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 150 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_enable); }
#line 4435 "src/parse/conf_lexer.cc"
yy870:
	yych = *++cur;
	if (yych == 't') goto yy902;
	goto yy3;
yy871:
	yych = *++cur;
	if (yych == 'd') goto yy903;
	goto yy3;
yy872:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy550;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy634;
			goto yy550;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych <= '^') goto yy550;
			goto yy2;
		} else {
			if (yych <= '`') goto yy550;
			if (yych <= 'z') goto yy2;
			goto yy550;
		}
	}
yy873:
	yych = *++cur;
	if (yych == 'e') goto yy904;
	goto yy3;
yy874:
	yych = *++cur;
	if (yych == 'd') goto yy905;
	goto yy3;
yy875:
	++cur;
#line 223 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_set_param); }
#line 4478 "src/parse/conf_lexer.cc"
yy876:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy559;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy643;
			goto yy559;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy644;
			if (yych <= 'Z') goto yy2;
			goto yy559;
		} else {
			if (yych == '`') goto yy559;
			if (yych <= 'z') goto yy2;
			goto yy559;
		}
	}
yy877:
	yych = *++cur;
	if (yych == 'e') goto yy906;
	goto yy3;
yy878:
	yych = *++cur;
	if (yych == 't') goto yy907;
	goto yy347;
yy879:
	yych = *++cur;
	if (yych == 'v') goto yy908;
	goto yy3;
yy880:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 276 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(computed_gotos_relative); }
#line 4519 "src/parse/conf_lexer.cc"
yy881:
	yych = *++cur;
	if (yych == 'd') goto yy909;
	goto yy3;
yy882:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy399;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy281;
			goto yy399;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych <= '^') goto yy399;
			goto yy2;
		} else {
			if (yych <= '`') goto yy399;
			if (yych <= 'z') goto yy2;
			goto yy399;
		}
	}
yy883:
	yych = *++cur;
	if (yych == 'o') goto yy910;
	goto yy347;
yy884:
	++cur;
#line 267 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_goto_param); }
#line 4554 "src/parse/conf_lexer.cc"
yy885:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 263 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_enum_prefix); }
#line 4560 "src/parse/conf_lexer.cc"
yy886:
	yych = *++cur;
	if (yych == 'y') goto yy911;
	goto yy3;
yy887:
	yych = *++cur;
	if (yych == 'c') goto yy586;
	goto yy3;
yy888:
	yych = *++cur;
	if (yych == '-') goto yy912;
	goto yy3;
yy889:
	yych = *++cur;
	if (yych == '-') goto yy582;
	goto yy3;
yy890:
	yych = *++cur;
	if (yych == '-') goto yy913;
	goto yy3;
yy891:
	yych = *++cur;
	if (yych == 'p') goto yy914;
	goto yy3;
yy892:
	yych = *++cur;
	if (yych == 'r') goto yy915;
	goto yy3;
yy893:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 121 "../src/parse/conf_lexer.re"
	{ goto input_enc; }
#line 4594 "src/parse/conf_lexer.cc"
yy894:
	yych = *++cur;
	if (yych == 's') goto yy916;
	goto yy3;
yy895:
	yych = *++cur;
	if (yych == 'b') goto yy917;
	goto yy3;
yy896:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 179 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_posix, tmp_bool);
        SETOPT(captures_array, false);
        return Ret::OK;
    }
#line 4614 "src/parse/conf_lexer.cc"
yy897:
	yych = *++cur;
	if (yych == 'l') goto yy918;
	goto yy3;
yy898:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 125 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(storable_state); }
#line 4624 "src/parse/conf_lexer.cc"
yy899:
	yych = *++cur;
	if (yych == 'n') goto yy919;
	goto yy3;
yy900:
	yych = *++cur;
	if (yych == 'l') goto yy920;
	goto yy3;
yy901:
	yych = *++cur;
	if (yych == 'n') goto yy921;
	goto yy3;
yy902:
	yych = *++cur;
	if (yych == 'e') goto yy922;
	goto yy3;
yy903:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 207 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_get_naked); }
#line 4646 "src/parse/conf_lexer.cc"
yy904:
	yych = *++cur;
	if (yych == 'd') goto yy923;
	goto yy3;
yy905:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 224 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_set_naked); }
#line 4656 "src/parse/conf_lexer.cc"
yy906:
	yych = *++cur;
	if (yych == 'd') goto yy924;
	goto yy3;
yy907:
	yych = *++cur;
	if (yych == 'e') goto yy925;
	goto yy347;
yy908:
	yych = *++cur;
	if (yych == 'e') goto yy926;
	goto yy3;
yy909:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 275 "../src/parse/conf_lexer.re"
	{ RET_CONF_NUM_NONNEG(computed_gotos_threshold); }
#line 4674 "src/parse/conf_lexer.cc"
yy910:
	yych = *++cur;
	if (yych == 'n') goto yy927;
	goto yy347;
yy911:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 290 "../src/parse/conf_lexer.re"
	{ goto encoding_policy; }
#line 4684 "src/parse/conf_lexer.cc"
yy912:
	yych = *++cur;
	if (yych == 'g') goto yy928;
	goto yy3;
yy913:
	yych = *++cur;
	if (yych == 'c') goto yy929;
	goto yy3;
yy914:
	yych = *++cur;
	if (yych == 't') goto yy930;
	goto yy3;
yy915:
	yych = *++cur;
	if (yych == 's') goto yy848;
	goto yy3;
yy916:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 189 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(captures_invert); }
#line 4706 "src/parse/conf_lexer.cc"
yy917:
	yych = *++cur;
	if (yych == 'e') goto yy756;
	goto yy3;
yy918:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 270 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_next); }
#line 4716 "src/parse/conf_lexer.cc"
yy919:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 187 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(tags_expression); }
#line 4722 "src/parse/conf_lexer.cc"
yy920:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy328;
yy921:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 253 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(char_conv); }
#line 4732 "src/parse/conf_lexer.cc"
yy922:
	yych = *++cur;
	if (yych == 'r') goto yy931;
	goto yy3;
yy923:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 209 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_get_naked); }
#line 4742 "src/parse/conf_lexer.cc"
yy924:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 226 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_set_naked); }
#line 4748 "src/parse/conf_lexer.cc"
yy925:
	++cur;
#line 227 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(state_set_param); }
#line 4753 "src/parse/conf_lexer.cc"
yy926:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 278 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(case_insensitive); }
#line 4759 "src/parse/conf_lexer.cc"
yy927:
	yych = *++cur;
	if (yych == 'd') goto yy932;
	goto yy347;
yy928:
	yych = *++cur;
	if (yych == 'o') goto yy933;
	goto yy3;
yy929:
	yych = *++cur;
	if (yych == 'a') goto yy934;
	goto yy3;
yy930:
	yych = *++cur;
	if (yych == 'u') goto yy760;
	goto yy3;
yy931:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 151 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_param_enable); }
#line 4781 "src/parse/conf_lexer.cc"
yy932:
	++cur;
#line 265 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_div_param); }
#line 4786 "src/parse/conf_lexer.cc"
yy933:
	yych = *++cur;
	if (yych == 't') goto yy935;
	goto yy3;
yy934:
	yych = *++cur;
	if (yych == 'p') goto yy584;
	goto yy3;
yy935:
	yych = *++cur;
	if (yych != 'o') goto yy3;
	yych = *++cur;
	if (yych == 's') goto yy398;
	goto yy3;
}
#line 307 "../src/parse/conf_lexer.re"


target:
    CHECK_RET(lex_conf_assign());

#line 4808 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 8) YYFILL(8);
	yych = *cur;
	if (yych <= 'd') {
		if (yych <= 'b') goto yy937;
		if (yych <= 'c') goto yy939;
		goto yy940;
	} else {
		if (yych == 's') goto yy941;
	}
yy937:
	++cur;
yy938:
#line 312 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'code', 'skeleton', 'dot')"));
    }
#line 4827 "src/parse/conf_lexer.cc"
yy939:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy942;
	goto yy938;
yy940:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy944;
	goto yy938;
yy941:
	yych = *(mar = ++cur);
	if (yych == 'k') goto yy945;
	goto yy938;
yy942:
	yych = *++cur;
	if (yych == 'd') goto yy946;
yy943:
	cur = mar;
	goto yy938;
yy944:
	yych = *++cur;
	if (yych == 't') goto yy947;
	goto yy943;
yy945:
	yych = *++cur;
	if (yych == 'e') goto yy948;
	goto yy943;
yy946:
	yych = *++cur;
	if (yych == 'e') goto yy949;
	goto yy943;
yy947:
	++cur;
#line 317 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::DOT);      goto end; }
#line 4862 "src/parse/conf_lexer.cc"
yy948:
	yych = *++cur;
	if (yych == 'l') goto yy950;
	goto yy943;
yy949:
	++cur;
#line 315 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::CODE);     goto end; }
#line 4871 "src/parse/conf_lexer.cc"
yy950:
	yych = *++cur;
	if (yych != 'e') goto yy943;
	yych = *++cur;
	if (yych != 't') goto yy943;
	yych = *++cur;
	if (yych != 'o') goto yy943;
	yych = *++cur;
	if (yych != 'n') goto yy943;
	++cur;
#line 316 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::SKELETON); goto end; }
#line 4884 "src/parse/conf_lexer.cc"
}
#line 318 "../src/parse/conf_lexer.re"


code_model:
    CHECK_RET(lex_conf_assign());

#line 4892 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 19) YYFILL(19);
	yych = *cur;
	if (yych <= 'k') {
		if (yych == 'g') goto yy953;
	} else {
		if (yych <= 'l') goto yy954;
		if (yych == 'r') goto yy955;
	}
	++cur;
yy952:
#line 323 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value"
            " (expected: 'goto-label', 'loop-switch', 'recursive-functions')"));
    }
#line 4910 "src/parse/conf_lexer.cc"
yy953:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy956;
	goto yy952;
yy954:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy958;
	goto yy952;
yy955:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy959;
	goto yy952;
yy956:
	yych = *++cur;
	if (yych == 't') goto yy960;
yy957:
	cur = mar;
	goto yy952;
yy958:
	yych = *++cur;
	if (yych == 'o') goto yy961;
	goto yy957;
yy959:
	yych = *++cur;
	if (yych == 'c') goto yy962;
	goto yy957;
yy960:
	yych = *++cur;
	if (yych == 'o') goto yy963;
	goto yy957;
yy961:
	yych = *++cur;
	if (yych == 'p') goto yy964;
	goto yy957;
yy962:
	yych = *++cur;
	if (yych == 'u') goto yy965;
	goto yy957;
yy963:
	yych = *++cur;
	if (yych == '-') goto yy966;
	goto yy957;
yy964:
	yych = *++cur;
	if (yych == '-') goto yy967;
	goto yy957;
yy965:
	yych = *++cur;
	if (yych == 'r') goto yy968;
	goto yy957;
yy966:
	yych = *++cur;
	if (yych == 'l') goto yy969;
	goto yy957;
yy967:
	yych = *++cur;
	if (yych == 's') goto yy970;
	goto yy957;
yy968:
	yych = *++cur;
	if (yych == 's') goto yy971;
	goto yy957;
yy969:
	yych = *++cur;
	if (yych == 'a') goto yy972;
	goto yy957;
yy970:
	yych = *++cur;
	if (yych == 'w') goto yy973;
	goto yy957;
yy971:
	yych = *++cur;
	if (yych == 'i') goto yy974;
	goto yy957;
yy972:
	yych = *++cur;
	if (yych == 'b') goto yy975;
	goto yy957;
yy973:
	yych = *++cur;
	if (yych == 'i') goto yy976;
	goto yy957;
yy974:
	yych = *++cur;
	if (yych == 'v') goto yy977;
	goto yy957;
yy975:
	yych = *++cur;
	if (yych == 'e') goto yy978;
	goto yy957;
yy976:
	yych = *++cur;
	if (yych == 't') goto yy979;
	goto yy957;
yy977:
	yych = *++cur;
	if (yych == 'e') goto yy980;
	goto yy957;
yy978:
	yych = *++cur;
	if (yych == 'l') goto yy981;
	goto yy957;
yy979:
	yych = *++cur;
	if (yych == 'c') goto yy982;
	goto yy957;
yy980:
	yych = *++cur;
	if (yych == '-') goto yy983;
	goto yy957;
yy981:
	++cur;
#line 327 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::GOTO_LABEL);  goto end; }
#line 5025 "src/parse/conf_lexer.cc"
yy982:
	yych = *++cur;
	if (yych == 'h') goto yy984;
	goto yy957;
yy983:
	yych = *++cur;
	if (yych == 'f') goto yy985;
	goto yy957;
yy984:
	++cur;
#line 328 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::LOOP_SWITCH); goto end; }
#line 5038 "src/parse/conf_lexer.cc"
yy985:
	yych = *++cur;
	if (yych != 'u') goto yy957;
	yych = *++cur;
	if (yych != 'n') goto yy957;
	yych = *++cur;
	if (yych != 'c') goto yy957;
	yych = *++cur;
	if (yych != 't') goto yy957;
	yych = *++cur;
	if (yych != 'i') goto yy957;
	yych = *++cur;
	if (yych != 'o') goto yy957;
	yych = *++cur;
	if (yych != 'n') goto yy957;
	yych = *++cur;
	if (yych != 's') goto yy957;
	++cur;
#line 329 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::REC_FUNC);    goto end; }
#line 5059 "src/parse/conf_lexer.cc"
}
#line 330 "../src/parse/conf_lexer.re"


input_enc:
    CHECK_RET(lex_conf_assign());

#line 5067 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 5) YYFILL(5);
	yych = *cur;
	if (yych == 'a') goto yy988;
	if (yych == 'u') goto yy989;
	++cur;
yy987:
#line 335 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'ascii', 'utf8')"));
    }
#line 5080 "src/parse/conf_lexer.cc"
yy988:
	yych = *(mar = ++cur);
	if (yych == 's') goto yy990;
	goto yy987;
yy989:
	yych = *(mar = ++cur);
	if (yych == 't') goto yy992;
	goto yy987;
yy990:
	yych = *++cur;
	if (yych == 'c') goto yy993;
yy991:
	cur = mar;
	goto yy987;
yy992:
	yych = *++cur;
	if (yych == 'f') goto yy994;
	goto yy991;
yy993:
	yych = *++cur;
	if (yych == 'i') goto yy995;
	goto yy991;
yy994:
	yych = *++cur;
	if (yych == '8') goto yy996;
	goto yy991;
yy995:
	yych = *++cur;
	if (yych == 'i') goto yy997;
	goto yy991;
yy996:
	++cur;
#line 339 "../src/parse/conf_lexer.re"
	{ SETCONOPT(input_encoding, Enc::Type::UTF8);  goto end; }
#line 5115 "src/parse/conf_lexer.cc"
yy997:
	++cur;
#line 338 "../src/parse/conf_lexer.re"
	{ SETCONOPT(input_encoding, Enc::Type::ASCII); goto end; }
#line 5120 "src/parse/conf_lexer.cc"
}
#line 340 "../src/parse/conf_lexer.re"


input:
    CHECK_RET(lex_conf_assign());

#line 5128 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 7) YYFILL(7);
	yych = *cur;
	switch (yych) {
		case 'c': goto yy1001;
		case 'd': goto yy1002;
		case 'g': goto yy1003;
		case 'r': goto yy1004;
		case 's': goto yy1005;
		default: goto yy999;
	}
yy999:
	++cur;
yy1000:
#line 345 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'simple', 'generic', 'record')"));
    }
#line 5148 "src/parse/conf_lexer.cc"
yy1001:
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy1006;
	goto yy1000;
yy1002:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1008;
	goto yy1000;
yy1003:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1009;
	goto yy1000;
yy1004:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1010;
	goto yy1000;
yy1005:
	yych = *(mar = ++cur);
	if (yych == 'i') goto yy1011;
	goto yy1000;
yy1006:
	yych = *++cur;
	if (yych == 's') goto yy1012;
yy1007:
	cur = mar;
	goto yy1000;
yy1008:
	yych = *++cur;
	if (yych == 'f') goto yy1013;
	goto yy1007;
yy1009:
	yych = *++cur;
	if (yych == 'n') goto yy1014;
	goto yy1007;
yy1010:
	yych = *++cur;
	if (yych == 'c') goto yy1015;
	goto yy1007;
yy1011:
	yych = *++cur;
	if (yych == 'm') goto yy1016;
	goto yy1007;
yy1012:
	yych = *++cur;
	if (yych == 't') goto yy1017;
	goto yy1007;
yy1013:
	yych = *++cur;
	if (yych == 'a') goto yy1018;
	goto yy1007;
yy1014:
	yych = *++cur;
	if (yych == 'e') goto yy1019;
	goto yy1007;
yy1015:
	yych = *++cur;
	if (yych == 'o') goto yy1020;
	goto yy1007;
yy1016:
	yych = *++cur;
	if (yych == 'p') goto yy1021;
	goto yy1007;
yy1017:
	yych = *++cur;
	if (yych == 'o') goto yy1022;
	goto yy1007;
yy1018:
	yych = *++cur;
	if (yych == 'u') goto yy1023;
	goto yy1007;
yy1019:
	yych = *++cur;
	if (yych == 'r') goto yy1024;
	goto yy1007;
yy1020:
	yych = *++cur;
	if (yych == 'r') goto yy1025;
	goto yy1007;
yy1021:
	yych = *++cur;
	if (yych == 'l') goto yy1026;
	goto yy1007;
yy1022:
	yych = *++cur;
	if (yych == 'm') goto yy1027;
	goto yy1007;
yy1023:
	yych = *++cur;
	if (yych == 'l') goto yy1028;
	goto yy1007;
yy1024:
	yych = *++cur;
	if (yych == 'i') goto yy1029;
	goto yy1007;
yy1025:
	yych = *++cur;
	if (yych == 'd') goto yy1030;
	goto yy1007;
yy1026:
	yych = *++cur;
	if (yych == 'e') goto yy1031;
	goto yy1007;
yy1027:
	++cur;
#line 349 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::GENERIC); goto end; }
#line 5255 "src/parse/conf_lexer.cc"
yy1028:
	yych = *++cur;
	if (yych == 't') goto yy1031;
	goto yy1007;
yy1029:
	yych = *++cur;
	if (yych == 'c') goto yy1027;
	goto yy1007;
yy1030:
	++cur;
#line 350 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::RECORD);  goto end; }
#line 5268 "src/parse/conf_lexer.cc"
yy1031:
	++cur;
#line 348 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::SIMPLE);  goto end; }
#line 5273 "src/parse/conf_lexer.cc"
}
#line 351 "../src/parse/conf_lexer.re"


api_style:
    CHECK_RET(lex_conf_assign());

#line 5281 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 9) YYFILL(9);
	yych = *cur;
	if (yych == 'f') goto yy1034;
	++cur;
yy1033:
#line 356 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'functions', 'free-form')"));
    }
#line 5293 "src/parse/conf_lexer.cc"
yy1034:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy1035;
	if (yych == 'u') goto yy1037;
	goto yy1033;
yy1035:
	yych = *++cur;
	if (yych == 'e') goto yy1038;
yy1036:
	cur = mar;
	goto yy1033;
yy1037:
	yych = *++cur;
	if (yych == 'n') goto yy1039;
	goto yy1036;
yy1038:
	yych = *++cur;
	if (yych == 'e') goto yy1040;
	goto yy1036;
yy1039:
	yych = *++cur;
	if (yych == 'c') goto yy1041;
	goto yy1036;
yy1040:
	yych = *++cur;
	if (yych == '-') goto yy1042;
	goto yy1036;
yy1041:
	yych = *++cur;
	if (yych == 't') goto yy1043;
	goto yy1036;
yy1042:
	yych = *++cur;
	if (yych == 'f') goto yy1044;
	goto yy1036;
yy1043:
	yych = *++cur;
	if (yych == 'i') goto yy1045;
	goto yy1036;
yy1044:
	yych = *++cur;
	if (yych == 'o') goto yy1046;
	goto yy1036;
yy1045:
	yych = *++cur;
	if (yych == 'o') goto yy1047;
	goto yy1036;
yy1046:
	yych = *++cur;
	if (yych == 'r') goto yy1048;
	goto yy1036;
yy1047:
	yych = *++cur;
	if (yych == 'n') goto yy1049;
	goto yy1036;
yy1048:
	yych = *++cur;
	if (yych == 'm') goto yy1050;
	goto yy1036;
yy1049:
	yych = *++cur;
	if (yych == 's') goto yy1051;
	goto yy1036;
yy1050:
	++cur;
#line 360 "../src/parse/conf_lexer.re"
	{ SETOPT(api_style, ApiStyle::FREEFORM);  goto end; }
#line 5361 "src/parse/conf_lexer.cc"
yy1051:
	++cur;
#line 359 "../src/parse/conf_lexer.re"
	{ SETOPT(api_style, ApiStyle::FUNCTIONS); goto end; }
#line 5366 "src/parse/conf_lexer.cc"
}
#line 361 "../src/parse/conf_lexer.re"


encoding_policy:
    CHECK_RET(lex_conf_assign());

#line 5374 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 10) YYFILL(10);
	yych = *cur;
	if (yych <= 'h') {
		if (yych == 'f') goto yy1054;
	} else {
		if (yych <= 'i') goto yy1055;
		if (yych == 's') goto yy1056;
	}
	++cur;
yy1053:
#line 366 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur(
                "bad configuration value (expected: 'ignore', 'substitute', 'fail')"));
    }
#line 5392 "src/parse/conf_lexer.cc"
yy1054:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy1057;
	goto yy1053;
yy1055:
	yych = *(mar = ++cur);
	if (yych == 'g') goto yy1059;
	goto yy1053;
yy1056:
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy1060;
	goto yy1053;
yy1057:
	yych = *++cur;
	if (yych == 'i') goto yy1061;
yy1058:
	cur = mar;
	goto yy1053;
yy1059:
	yych = *++cur;
	if (yych == 'n') goto yy1062;
	goto yy1058;
yy1060:
	yych = *++cur;
	if (yych == 'b') goto yy1063;
	goto yy1058;
yy1061:
	yych = *++cur;
	if (yych == 'l') goto yy1064;
	goto yy1058;
yy1062:
	yych = *++cur;
	if (yych == 'o') goto yy1065;
	goto yy1058;
yy1063:
	yych = *++cur;
	if (yych == 's') goto yy1066;
	goto yy1058;
yy1064:
	++cur;
#line 372 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::FAIL);       goto end; }
#line 5435 "src/parse/conf_lexer.cc"
yy1065:
	yych = *++cur;
	if (yych == 'r') goto yy1067;
	goto yy1058;
yy1066:
	yych = *++cur;
	if (yych == 't') goto yy1068;
	goto yy1058;
yy1067:
	yych = *++cur;
	if (yych == 'e') goto yy1069;
	goto yy1058;
yy1068:
	yych = *++cur;
	if (yych == 'i') goto yy1070;
	goto yy1058;
yy1069:
	++cur;
#line 370 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::IGNORE);     goto end; }
#line 5456 "src/parse/conf_lexer.cc"
yy1070:
	yych = *++cur;
	if (yych != 't') goto yy1058;
	yych = *++cur;
	if (yych != 'u') goto yy1058;
	yych = *++cur;
	if (yych != 't') goto yy1058;
	yych = *++cur;
	if (yych != 'e') goto yy1058;
	++cur;
#line 371 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::SUBSTITUTE); goto end; }
#line 5469 "src/parse/conf_lexer.cc"
}
#line 373 "../src/parse/conf_lexer.re"


empty_class:
    CHECK_RET(lex_conf_assign());

#line 5477 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 11) YYFILL(11);
	yych = *cur;
	if (yych == 'e') goto yy1073;
	if (yych == 'm') goto yy1074;
	++cur;
yy1072:
#line 378 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur(
                "bad configuration value (expected: 'match-empty', 'match-none', 'error')"));
    }
#line 5491 "src/parse/conf_lexer.cc"
yy1073:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy1075;
	goto yy1072;
yy1074:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy1077;
	goto yy1072;
yy1075:
	yych = *++cur;
	if (yych == 'r') goto yy1078;
yy1076:
	cur = mar;
	goto yy1072;
yy1077:
	yych = *++cur;
	if (yych == 't') goto yy1079;
	goto yy1076;
yy1078:
	yych = *++cur;
	if (yych == 'o') goto yy1080;
	goto yy1076;
yy1079:
	yych = *++cur;
	if (yych == 'c') goto yy1081;
	goto yy1076;
yy1080:
	yych = *++cur;
	if (yych == 'r') goto yy1082;
	goto yy1076;
yy1081:
	yych = *++cur;
	if (yych == 'h') goto yy1083;
	goto yy1076;
yy1082:
	++cur;
#line 384 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::ERROR);       goto end; }
#line 5530 "src/parse/conf_lexer.cc"
yy1083:
	yych = *++cur;
	if (yych != '-') goto yy1076;
	yych = *++cur;
	if (yych == 'e') goto yy1084;
	if (yych == 'n') goto yy1085;
	goto yy1076;
yy1084:
	yych = *++cur;
	if (yych == 'm') goto yy1086;
	goto yy1076;
yy1085:
	yych = *++cur;
	if (yych == 'o') goto yy1087;
	goto yy1076;
yy1086:
	yych = *++cur;
	if (yych == 'p') goto yy1088;
	goto yy1076;
yy1087:
	yych = *++cur;
	if (yych == 'n') goto yy1089;
	goto yy1076;
yy1088:
	yych = *++cur;
	if (yych == 't') goto yy1090;
	goto yy1076;
yy1089:
	yych = *++cur;
	if (yych == 'e') goto yy1091;
	goto yy1076;
yy1090:
	yych = *++cur;
	if (yych == 'y') goto yy1092;
	goto yy1076;
yy1091:
	++cur;
#line 383 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::MATCH_NONE);  goto end; }
#line 5570 "src/parse/conf_lexer.cc"
yy1092:
	++cur;
#line 382 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::MATCH_EMPTY); goto end; }
#line 5575 "src/parse/conf_lexer.cc"
}
#line 385 "../src/parse/conf_lexer.re"


char_lit:
    CHECK_RET(lex_conf_assign());

#line 5583 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	if ((lim - cur) < 11) YYFILL(11);
	yych = *cur;
	if (yych == 'c') goto yy1095;
	if (yych == 'h') goto yy1096;
	++cur;
yy1094:
#line 390 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'char', 'hex', 'char-or-hex')"));
    }
#line 5597 "src/parse/conf_lexer.cc"
yy1095:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'h') goto yy1097;
	goto yy1094;
yy1096:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1099;
	goto yy1094;
yy1097:
	yych = *++cur;
	if (yych == 'a') goto yy1100;
yy1098:
	cur = mar;
	if (yyaccept == 0) goto yy1094;
	else goto yy1103;
yy1099:
	yych = *++cur;
	if (yych == 'x') goto yy1101;
	goto yy1098;
yy1100:
	yych = *++cur;
	if (yych == 'r') goto yy1102;
	goto yy1098;
yy1101:
	++cur;
#line 394 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::HEX);         goto end; }
#line 5627 "src/parse/conf_lexer.cc"
yy1102:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '-') goto yy1104;
yy1103:
#line 393 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::CHAR);        goto end; }
#line 5635 "src/parse/conf_lexer.cc"
yy1104:
	yych = *++cur;
	if (yych != 'o') goto yy1098;
	yych = *++cur;
	if (yych != 'r') goto yy1098;
	yych = *++cur;
	if (yych != '-') goto yy1098;
	yych = *++cur;
	if (yych != 'h') goto yy1098;
	yych = *++cur;
	if (yych != 'e') goto yy1098;
	yych = *++cur;
	if (yych != 'x') goto yy1098;
	++cur;
#line 395 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::CHAR_OR_HEX); goto end; }
#line 5652 "src/parse/conf_lexer.cc"
}
#line 396 "../src/parse/conf_lexer.re"


end:
    return lex_conf_semicolon();
}

#undef SETOPT
#undef RET_CONF_BOOL
#undef RET_CONF_FEAT
#undef RET_CONF_STR
#undef RET_CONF_ENC
#undef RET_CONF_NUM_NONNEG
#undef RET_CONF_EOF

Ret Input::lex_spaces() {
loop: 
#line 5671 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1106;
		if (yych <= '\t') goto yy1107;
		if (yych <= '\n') goto yy1108;
	} else {
		if (yych <= '\r') goto yy1107;
		if (yych == ' ') goto yy1107;
	}
yy1106:
#line 414 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 5687 "src/parse/conf_lexer.cc"
yy1107:
	++cur;
#line 413 "../src/parse/conf_lexer.re"
	{ goto loop; }
#line 5692 "src/parse/conf_lexer.cc"
yy1108:
	++cur;
#line 412 "../src/parse/conf_lexer.re"
	{ next_line(); goto loop; }
#line 5697 "src/parse/conf_lexer.cc"
}
#line 415 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_assign() {
    CHECK_RET(lex_spaces());

#line 5706 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych == '=') goto yy1110;
	++cur;
#line 422 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("missing '=' in configuration")); }
#line 5715 "src/parse/conf_lexer.cc"
yy1110:
	++cur;
#line 421 "../src/parse/conf_lexer.re"
	{ return lex_spaces(); }
#line 5720 "src/parse/conf_lexer.cc"
}
#line 423 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_semicolon() {
    CHECK_RET(lex_spaces());

#line 5729 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych == ';') goto yy1112;
	++cur;
#line 430 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("missing ending ';' in configuration")); }
#line 5738 "src/parse/conf_lexer.cc"
yy1112:
	++cur;
#line 429 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 5743 "src/parse/conf_lexer.cc"
}
#line 431 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_number(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::NUM) {
        RET_FAIL(error_at_tok("configuration value should be a number"));
    }
    return Ret::OK;
}

inline Ret Input::lex_conf_bool(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::NUM) {
        RET_FAIL(error_at_tok("configuration value should be a boolean value 0 or 1"));
    }
    return Ret::OK;
}

// Historically re2c allowed raw (unquoted) strings containing special symbols as configuration
// values in source files. In syntax files this is not allowed, as it would conflict with other
// parts of grammar (e.g. parentheses and question mark are used for conditionals). Therefore we
// have a legacy method for string configurations in source files.
Ret Input::lex_conf_string_legacy() {
    CHECK_RET(lex_conf_assign());
    tok = cur;

#line 5773 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128,   0,   0, 128, 128,   0, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128,   0, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy1114;
			if (yych <= 0x08) goto yy1115;
		} else {
			if (yych == '\r') goto yy1114;
			if (yych <= 0x1F) goto yy1115;
		}
	} else {
		if (yych <= '&') {
			if (yych == '"') goto yy1116;
			goto yy1115;
		} else {
			if (yych <= '\'') goto yy1116;
			if (yych != ';') goto yy1115;
		}
	}
yy1114:
#line 460 "../src/parse/conf_lexer.re"
	{ tmp_str.clear(); goto end; }
#line 5832 "src/parse/conf_lexer.cc"
yy1115:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy1115;
#line 458 "../src/parse/conf_lexer.re"
	{ tmp_str.assign(tok, cur); goto end; }
#line 5840 "src/parse/conf_lexer.cc"
yy1116:
	++cur;
	cur -= 1;
#line 459 "../src/parse/conf_lexer.re"
	{ tmp_str.clear(); goto loop; }
#line 5846 "src/parse/conf_lexer.cc"
}
#line 461 "../src/parse/conf_lexer.re"

loop: // lex one or more double-quoted strings separated with spaces or newlines
    tok = cur;

#line 5853 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x08) goto yy1118;
			if (yych <= '\t') goto yy1119;
			goto yy1120;
		} else {
			if (yych == '\r') goto yy1119;
		}
	} else {
		if (yych <= '"') {
			if (yych <= ' ') goto yy1119;
			if (yych >= '"') goto yy1121;
		} else {
			if (yych == '\'') goto yy1121;
		}
	}
yy1118:
#line 468 "../src/parse/conf_lexer.re"
	{ goto end; }
#line 5877 "src/parse/conf_lexer.cc"
yy1119:
	++cur;
#line 467 "../src/parse/conf_lexer.re"
	{ goto loop; }
#line 5882 "src/parse/conf_lexer.cc"
yy1120:
	++cur;
#line 466 "../src/parse/conf_lexer.re"
	{ next_line(); goto loop; }
#line 5887 "src/parse/conf_lexer.cc"
yy1121:
	++cur;
#line 465 "../src/parse/conf_lexer.re"
	{ CHECK_RET(lex_conf_string_quoted(tok[0])); goto loop; }
#line 5892 "src/parse/conf_lexer.cc"
}
#line 469 "../src/parse/conf_lexer.re"

end:
    return lex_conf_semicolon();
}

Ret Input::lex_conf_string(Opt& opts) {
    if (!in_syntax_file) {
        return lex_conf_string_legacy();
    }

    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::STR) {
        RET_FAIL(error_at_tok("configuration value should be a string"));
    }
    return Ret::OK;
}

Ret Input::lex_conf_list(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::LIST) {
        RET_FAIL(error_at_tok("configuration value should be a list"));
    }
    return Ret::OK;
}

Ret Input::lex_conf_string_quoted(uint8_t quote) {
    AstChar c;
    bool stop;
    for (;;) {
        CHECK_RET(lex_str_chr(quote, c, stop));
        if (stop) return Ret::OK;
        if (c.chr > 0xFF) {
            RET_FAIL(error_at(c.loc, "multibyte character in configuration string: 0x%X", c.chr));
        } else if (c.chr == '\n' && in_syntax_file && !allow_raw_nl) {
            RET_FAIL(error_at(c.loc, "newline in a string literal (use `nl` variable instead)"));
        }
        tmp_str += static_cast<char>(c.chr);
    }
}

Ret Input::lex_conf_code(Opt& opts) {
    if (in_syntax_file) {
        conf_kind = ConfKind::CODE;
        allow_raw_nl = false;
        CHECK_RET(parse_conf(opts));
        allow_raw_nl = true;
    } else {
        CHECK_RET(lex_conf_string(opts));
        tmp_code = opts.make_api(tmp_str);
    }
    return Ret::OK;
}

#define RET_TOK(t) do { \
    token = t; \
    return Ret::OK; \
} while(0)

#define RET_COND(c) do { \
    token = CONF_COND; \
    yylval->cond = (c); \
    return Ret::OK; \
} while(0)

#define RET_GOPT(opt) do { \
    token = CONF_GOPT; \
    yylval->gopt = opt; \
    return Ret::OK; \
} while(0)

#define RET_LOPT(opt) do { \
    token = CONF_LOPT; \
    yylval->lopt = opt; \
    return Ret::OK; \
} while(0)

#define RET_VAR(v) do { \
    token = CONF_VAR; \
    yylval->var = v; \
    return Ret::OK; \
} while(0)

#define RET_CODE(conf) do { \
    token = CONF_CODE; \
    yylval->codeptr = const_cast<const StxCodes**>(&opts.glob.conf); \
    return Ret::OK; \
} while(0)

Ret Input::lex_conf_token(CONF_STYPE* yylval, int& token, Opt& opts) {
    if (conf_kind == ConfKind::CODE) { // one of pre-lexed `conf:` configuratins
        conf_kind = ConfKind::NONE;
        yylval->codeptr = &tmp_code;
        RET_TOK(CONF_CODE);
    }
start:
    tok = cur;

#line 5992 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 136,   0, 128, 128, 136, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		136, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 192, 128,
		240, 240, 240, 240, 240, 240, 240, 240,
		240, 240, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 224,
		128, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if ((lim - cur) < 32) YYFILL(32);
	yych = *cur;
	if (yybm[0+yych] & 8) goto yy1126;
	switch (yych) {
		case 0x00: goto yy1123;
		case '\t':
		case '\n': goto yy1127;
		case ' ':
		case '!':
		case '&':
		case '(':
		case ')':
		case ',':
		case ':':
		case '=':
		case '?':
		case '[':
		case ']':
		case '{':
		case '|':
		case '}': goto yy1128;
		case '"':
		case '\'': goto yy1129;
		case '-': goto yy1130;
		case '.': goto yy1131;
		case '/': goto yy1132;
		case '0': goto yy1133;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1135;
		case ';': goto yy1136;
		case '<': goto yy1137;
		case 'Y': goto yy1138;
		case '_':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'p':
		case 'q':
		case 'u':
		case 'w':
		case 'x':
		case 'z': goto yy1139;
		case 'a': goto yy1142;
		case 'b': goto yy1143;
		case 'c': goto yy1144;
		case 'd': goto yy1145;
		case 'e': goto yy1146;
		case 'f': goto yy1147;
		case 'i': goto yy1148;
		case 'l': goto yy1149;
		case 'm': goto yy1150;
		case 'n': goto yy1151;
		case 'o': goto yy1152;
		case 'r': goto yy1153;
		case 's': goto yy1154;
		case 't': goto yy1155;
		case 'v': goto yy1156;
		case 'y': goto yy1157;
		default: goto yy1124;
	}
yy1123:
	++cur;
#line 568 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("unexpected end of input in configuration")); }
#line 6102 "src/parse/conf_lexer.cc"
yy1124:
	++cur;
yy1125:
#line 815 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_tok("unexpected character: '%c'", cur[-1])); }
#line 6108 "src/parse/conf_lexer.cc"
yy1126:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 8) goto yy1126;
#line 572 "../src/parse/conf_lexer.re"
	{ goto start; }
#line 6116 "src/parse/conf_lexer.cc"
yy1127:
	++cur;
#line 570 "../src/parse/conf_lexer.re"
	{ next_line(); goto start; }
#line 6121 "src/parse/conf_lexer.cc"
yy1128:
	++cur;
#line 588 "../src/parse/conf_lexer.re"
	{ RET_TOK(cur[-1]); }
#line 6126 "src/parse/conf_lexer.cc"
yy1129:
	++cur;
#line 581 "../src/parse/conf_lexer.re"
	{
        tmp_str.clear();
        CHECK_RET(lex_conf_string_quoted(cur[-1]));
        yylval->str = copystr(tmp_str, alc);
        RET_TOK(CONF_STRING);
    }
#line 6136 "src/parse/conf_lexer.cc"
yy1130:
	yych = *++cur;
	if (yych <= '0') goto yy1125;
	if (yych <= '9') goto yy1158;
	goto yy1125;
yy1131:
	yych = *++cur;
	if (yych <= 'i') {
		if (yych <= '_') {
			if (yych <= '/') {
				if (yych == '.') goto yy1159;
				goto yy1125;
			} else {
				if (yych <= '9') goto yy1159;
				if (yych <= '^') goto yy1125;
				goto yy1159;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy1125;
				if (yych <= 'a') goto yy1161;
				goto yy1159;
			} else {
				if (yych <= 'c') goto yy1162;
				if (yych <= 'd') goto yy1163;
				if (yych <= 'h') goto yy1159;
				goto yy1164;
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'm') {
				if (yych <= 'k') goto yy1159;
				if (yych <= 'l') goto yy1165;
				goto yy1166;
			} else {
				if (yych <= 'n') goto yy1167;
				if (yych <= 'q') goto yy1159;
				if (yych <= 'r') goto yy1168;
				goto yy1169;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 't') goto yy1170;
				if (yych <= 'u') goto yy1171;
				goto yy1172;
			} else {
				if (yych == 'y') goto yy1173;
				if (yych <= 'z') goto yy1159;
				goto yy1125;
			}
		}
	}
yy1132:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == '/') goto yy1174;
	goto yy1125;
yy1133:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
yy1134:
#line 574 "../src/parse/conf_lexer.re"
	{
        if (!s_to_i32_unsafe(tok, cur, yylval->num)) {
            RET_FAIL(error_at_cur("configuration value overflow"));
        }
        RET_TOK(CONF_NUMBER);
    }
#line 6206 "src/parse/conf_lexer.cc"
yy1135:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 16) goto yy1135;
	if (yych == '_') goto yy1139;
	if (yych <= '`') goto yy1134;
	if (yych <= 'z') goto yy1139;
	goto yy1134;
yy1136:
	++cur;
#line 566 "../src/parse/conf_lexer.re"
	{ RET_TOK(CONF_EOF); }
#line 6220 "src/parse/conf_lexer.cc"
yy1137:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy1176;
	goto yy1125;
yy1138:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'Y') goto yy1177;
	goto yy1125;
yy1139:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1140:
	if (yybm[0+yych] & 32) goto yy1139;
yy1141:
#line 811 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown variable: '%.*s'", int(cur - tok), tok));
    }
#line 6242 "src/parse/conf_lexer.cc"
yy1142:
	yych = *++cur;
	if (yych == 'r') goto yy1178;
	goto yy1140;
yy1143:
	yych = *++cur;
	if (yych == 'a') goto yy1179;
	if (yych == 'r') goto yy1180;
	goto yy1140;
yy1144:
	yych = *++cur;
	if (yych == 'a') goto yy1181;
	if (yych == 'o') goto yy1182;
	goto yy1140;
yy1145:
	yych = *++cur;
	if (yych == 'a') goto yy1183;
	if (yych == 'e') goto yy1184;
	goto yy1140;
yy1146:
	yych = *++cur;
	if (yych == 'l') goto yy1185;
	if (yych == 'x') goto yy1186;
	goto yy1140;
yy1147:
	yych = *++cur;
	if (yych == 'i') goto yy1187;
	if (yych == 'n') goto yy1188;
	goto yy1140;
yy1148:
	yych = *++cur;
	if (yych == 'n') goto yy1190;
	goto yy1140;
yy1149:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'a') goto yy1191;
		goto yy1140;
	} else {
		if (yych <= 'h') goto yy1192;
		if (yych <= 'i') goto yy1193;
		goto yy1140;
	}
yy1150:
	yych = *++cur;
	if (yych == 'a') goto yy1194;
	goto yy1140;
yy1151:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'a') goto yy1195;
		goto yy1140;
	} else {
		if (yych <= 'e') goto yy1196;
		if (yych == 'l') goto yy1197;
		goto yy1140;
	}
yy1152:
	yych = *++cur;
	if (yych == 'f') goto yy1198;
	goto yy1140;
yy1153:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'e') goto yy1199;
		goto yy1140;
	} else {
		if (yych <= 'h') goto yy1200;
		if (yych == 'o') goto yy1201;
		goto yy1140;
	}
yy1154:
	yych = *++cur;
	if (yych == 'i') goto yy1202;
	if (yych == 't') goto yy1203;
	goto yy1140;
yy1155:
	yych = *++cur;
	if (yych <= 'h') {
		if (yych == 'a') goto yy1204;
		if (yych <= 'g') goto yy1140;
		goto yy1205;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1140;
			goto yy1206;
		} else {
			if (yych == 'y') goto yy1207;
			goto yy1140;
		}
	}
yy1156:
	yych = *++cur;
	if (yych == 'a') goto yy1208;
	if (yych == 'e') goto yy1209;
	goto yy1140;
yy1157:
	yych = *++cur;
	if (yych == 'y') goto yy1210;
	goto yy1140;
yy1158:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= '/') goto yy1134;
	if (yych <= '9') goto yy1158;
	goto yy1134;
yy1159:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1160:
	if (yybm[0+yych] & 64) goto yy1159;
#line 807 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown conditional: '%.*s'", int(cur - tok), tok));
    }
#line 6360 "src/parse/conf_lexer.cc"
yy1161:
	yych = *++cur;
	if (yych == 'p') goto yy1211;
	if (yych == 'r') goto yy1212;
	goto yy1160;
yy1162:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'a') goto yy1213;
		if (yych <= 'f') goto yy1160;
		goto yy1214;
	} else {
		if (yych <= 'h') goto yy1215;
		if (yych == 'o') goto yy1216;
		goto yy1160;
	}
yy1163:
	yych = *++cur;
	if (yych == 'a') goto yy1217;
	goto yy1160;
yy1164:
	yych = *++cur;
	if (yych == 'n') goto yy1218;
	goto yy1160;
yy1165:
	yych = *++cur;
	if (yych == 'o') goto yy1219;
	goto yy1160;
yy1166:
	yych = *++cur;
	if (yych == 'a') goto yy1220;
	if (yych == 'o') goto yy1221;
	goto yy1160;
yy1167:
	yych = *++cur;
	if (yych == 'e') goto yy1222;
	goto yy1160;
yy1168:
	yych = *++cur;
	if (yych == 'e') goto yy1223;
	goto yy1160;
yy1169:
	yych = *++cur;
	if (yych == 't') goto yy1224;
	goto yy1160;
yy1170:
	yych = *++cur;
	if (yych == 'y') goto yy1225;
	goto yy1160;
yy1171:
	yych = *++cur;
	if (yych == 'n') goto yy1226;
	goto yy1160;
yy1172:
	yych = *++cur;
	if (yych == 'e') goto yy1227;
	goto yy1160;
yy1173:
	yych = *++cur;
	if (yych == 'y') goto yy1228;
	goto yy1160;
yy1174:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy1174;
	if (yych >= 0x01) goto yy1127;
yy1175:
	cur = mar;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) goto yy1125;
			else goto yy1141;
		} else {
			goto yy1525;
		}
	} else {
		if (yyaccept == 3) goto yy1569;
		else goto yy1640;
	}
yy1176:
	yych = *++cur;
	if (yych == 'n') goto yy1229;
	goto yy1175;
yy1177:
	yych = *++cur;
	switch (yych) {
		case 'B': goto yy1230;
		case 'C': goto yy1231;
		case 'D': goto yy1232;
		case 'E': goto yy1233;
		case 'G': goto yy1234;
		case 'I': goto yy1235;
		case 'L': goto yy1236;
		case 'M': goto yy1237;
		case 'P': goto yy1238;
		case 'R': goto yy1239;
		case 'S': goto yy1240;
		default: goto yy1175;
	}
yy1178:
	yych = *++cur;
	if (yych == 'g') goto yy1241;
	if (yych == 'r') goto yy1242;
	goto yy1140;
yy1179:
	yych = *++cur;
	if (yych == 's') goto yy1243;
	goto yy1140;
yy1180:
	yych = *++cur;
	if (yych == 'a') goto yy1244;
	goto yy1140;
yy1181:
	yych = *++cur;
	if (yych == 's') goto yy1245;
	goto yy1140;
yy1182:
	yych = *++cur;
	if (yych == 'd') goto yy1246;
	if (yych == 'n') goto yy1247;
	goto yy1140;
yy1183:
	yych = *++cur;
	if (yych == 't') goto yy1248;
	goto yy1140;
yy1184:
	yych = *++cur;
	if (yych == 'd') goto yy1249;
	goto yy1140;
yy1185:
	yych = *++cur;
	if (yych == 'e') goto yy1250;
	goto yy1140;
yy1186:
	yych = *++cur;
	if (yych == 'p') goto yy1251;
	goto yy1140;
yy1187:
	yych = *++cur;
	if (yych == 'l') goto yy1252;
	goto yy1140;
yy1188:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= '/') goto yy1189;
		if (yych <= '9') goto yy1139;
		if (yych >= '_') goto yy1139;
	} else {
		if (yych <= 'c') {
			if (yych >= 'a') goto yy1139;
		} else {
			if (yych <= 'd') goto yy1253;
			if (yych <= 'z') goto yy1139;
		}
	}
yy1189:
#line 683 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FN); }
#line 6520 "src/parse/conf_lexer.cc"
yy1190:
	yych = *++cur;
	if (yych == 'd') goto yy1254;
	if (yych == 'i') goto yy1255;
	goto yy1140;
yy1191:
	yych = *++cur;
	if (yych == 'b') goto yy1256;
	goto yy1140;
yy1192:
	yych = *++cur;
	if (yych == 's') goto yy1257;
	goto yy1140;
yy1193:
	yych = *++cur;
	if (yych == 'n') goto yy1258;
	goto yy1140;
yy1194:
	yych = *++cur;
	if (yych == 's') goto yy1259;
	goto yy1140;
yy1195:
	yych = *++cur;
	if (yych == 'm') goto yy1260;
	goto yy1140;
yy1196:
	yych = *++cur;
	if (yych == 'e') goto yy1261;
	if (yych == 'g') goto yy1262;
	goto yy1140;
yy1197:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 747 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEWLINE); }
#line 6556 "src/parse/conf_lexer.cc"
yy1198:
	yych = *++cur;
	if (yych == 'f') goto yy1263;
	goto yy1140;
yy1199:
	yych = *++cur;
	if (yych == 't') goto yy1264;
	goto yy1140;
yy1200:
	yych = *++cur;
	if (yych == 's') goto yy1265;
	goto yy1140;
yy1201:
	yych = *++cur;
	if (yych == 'w') goto yy1266;
	goto yy1140;
yy1202:
	yych = *++cur;
	if (yych == 'g') goto yy1267;
	if (yych == 'z') goto yy1268;
	goto yy1140;
yy1203:
	yych = *++cur;
	if (yych == 'a') goto yy1269;
	if (yych == 'm') goto yy1270;
	goto yy1140;
yy1204:
	yych = *++cur;
	if (yych == 'g') goto yy1271;
	goto yy1140;
yy1205:
	yych = *++cur;
	if (yych == 'r') goto yy1272;
	goto yy1140;
yy1206:
	yych = *++cur;
	if (yych == 'p') goto yy1273;
	goto yy1140;
yy1207:
	yych = *++cur;
	if (yych == 'p') goto yy1274;
	goto yy1140;
yy1208:
	yych = *++cur;
	if (yych == 'l') goto yy1275;
	if (yych == 'r') goto yy1276;
	goto yy1140;
yy1209:
	yych = *++cur;
	if (yych == 'r') goto yy1277;
	goto yy1140;
yy1210:
	yych = *++cur;
	if (yych <= 'c') {
		if (yych <= 'a') goto yy1140;
		if (yych <= 'b') goto yy1278;
		goto yy1279;
	} else {
		if (yych == 'r') goto yy1280;
		goto yy1140;
	}
yy1211:
	yych = *++cur;
	if (yych == 'i') goto yy1281;
	goto yy1160;
yy1212:
	yych = *++cur;
	if (yych == 'g') goto yy1282;
	goto yy1160;
yy1213:
	yych = *++cur;
	if (yych == 's') goto yy1283;
	goto yy1160;
yy1214:
	yych = *++cur;
	if (yych == 'o') goto yy1284;
	goto yy1160;
yy1215:
	yych = *++cur;
	if (yych == 'a') goto yy1285;
	goto yy1160;
yy1216:
	yych = *++cur;
	if (yych == 'd') goto yy1286;
	if (yych == 'n') goto yy1287;
	goto yy1160;
yy1217:
	yych = *++cur;
	if (yych == 't') goto yy1288;
	goto yy1160;
yy1218:
	yych = *++cur;
	if (yych == 'i') goto yy1289;
	goto yy1160;
yy1219:
	yych = *++cur;
	if (yych == 'o') goto yy1290;
	goto yy1160;
yy1220:
	yych = *++cur;
	if (yych == 'n') goto yy1291;
	goto yy1160;
yy1221:
	yych = *++cur;
	if (yych == 'n') goto yy1292;
	goto yy1160;
yy1222:
	yych = *++cur;
	if (yych == 's') goto yy1293;
	goto yy1160;
yy1223:
	yych = *++cur;
	if (yych == 't') goto yy1294;
	goto yy1160;
yy1224:
	yych = *++cur;
	if (yych == 'a') goto yy1295;
	if (yych == 'o') goto yy1296;
	goto yy1160;
yy1225:
	yych = *++cur;
	if (yych == 'p') goto yy1297;
	goto yy1160;
yy1226:
	yych = *++cur;
	if (yych == 's') goto yy1298;
	goto yy1160;
yy1227:
	yych = *++cur;
	if (yych == 'r') goto yy1299;
	goto yy1160;
yy1228:
	yych = *++cur;
	if (yych == 'f') goto yy1300;
	goto yy1160;
yy1229:
	yych = *++cur;
	if (yych == 'd') goto yy1301;
	goto yy1175;
yy1230:
	yych = *++cur;
	if (yych == 'A') goto yy1302;
	goto yy1175;
yy1231:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'O') goto yy1303;
		goto yy1175;
	} else {
		if (yych <= 'T') goto yy1304;
		if (yych <= 'U') goto yy1305;
		goto yy1175;
	}
yy1232:
	yych = *++cur;
	if (yych == 'E') goto yy1306;
	goto yy1175;
yy1233:
	yych = *++cur;
	if (yych == 'N') goto yy1307;
	goto yy1175;
yy1234:
	yych = *++cur;
	if (yych == 'E') goto yy1308;
	goto yy1175;
yy1235:
	yych = *++cur;
	if (yych == 'N') goto yy1309;
	goto yy1175;
yy1236:
	yych = *++cur;
	if (yych == 'E') goto yy1310;
	if (yych == 'I') goto yy1311;
	goto yy1175;
yy1237:
	yych = *++cur;
	if (yych == 'A') goto yy1312;
	if (yych == 'T') goto yy1313;
	goto yy1175;
yy1238:
	yych = *++cur;
	if (yych == 'E') goto yy1314;
	goto yy1175;
yy1239:
	yych = *++cur;
	if (yych == 'E') goto yy1315;
	goto yy1175;
yy1240:
	yych = *++cur;
	switch (yych) {
		case 'E': goto yy1316;
		case 'H': goto yy1317;
		case 'K': goto yy1318;
		case 'T': goto yy1319;
		default: goto yy1175;
	}
yy1241:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1139;
		} else {
			if (yych == '_') goto yy1139;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'n') goto yy1320;
			goto yy1139;
		} else {
			if (yych <= 't') goto yy1321;
			if (yych <= 'z') goto yy1139;
		}
	}
#line 672 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARG); }
#line 6772 "src/parse/conf_lexer.cc"
yy1242:
	yych = *++cur;
	if (yych == 'a') goto yy1322;
	goto yy1140;
yy1243:
	yych = *++cur;
	if (yych == 'e') goto yy1323;
	goto yy1140;
yy1244:
	yych = *++cur;
	if (yych == 'n') goto yy1324;
	goto yy1140;
yy1245:
	yych = *++cur;
	if (yych == 'e') goto yy1325;
	goto yy1140;
yy1246:
	yych = *++cur;
	if (yych == 'e') goto yy1326;
	goto yy1140;
yy1247:
	yych = *++cur;
	if (yych == 'd') goto yy1327;
	goto yy1140;
yy1248:
	yych = *++cur;
	if (yych == 'e') goto yy1328;
	goto yy1140;
yy1249:
	yych = *++cur;
	if (yych == 'e') goto yy1329;
	goto yy1140;
yy1250:
	yych = *++cur;
	if (yych == 'm') goto yy1330;
	goto yy1140;
yy1251:
	yych = *++cur;
	if (yych == 'r') goto yy1331;
	goto yy1140;
yy1252:
	yych = *++cur;
	if (yych == 'e') goto yy1332;
	goto yy1140;
yy1253:
	yych = *++cur;
	if (yych == 'e') goto yy1333;
	goto yy1140;
yy1254:
	yych = *++cur;
	if (yych == 'e') goto yy1334;
	goto yy1140;
yy1255:
	yych = *++cur;
	if (yych == 't') goto yy1335;
	goto yy1140;
yy1256:
	yych = *++cur;
	if (yych == 'e') goto yy1336;
	goto yy1140;
yy1257:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 690 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LHS); }
#line 6838 "src/parse/conf_lexer.cc"
yy1258:
	yych = *++cur;
	if (yych == 'e') goto yy1337;
	goto yy1140;
yy1259:
	yych = *++cur;
	if (yych == 'k') goto yy1338;
	goto yy1140;
yy1260:
	yych = *++cur;
	if (yych == 'e') goto yy1339;
	goto yy1140;
yy1261:
	yych = *++cur;
	if (yych == 'd') goto yy1340;
	goto yy1140;
yy1262:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 694 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEG); }
#line 6860 "src/parse/conf_lexer.cc"
yy1263:
	yych = *++cur;
	if (yych == 's') goto yy1341;
	goto yy1140;
yy1264:
	yych = *++cur;
	if (yych == 'v') goto yy1342;
	goto yy1140;
yy1265:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 698 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RHS); }
#line 6874 "src/parse/conf_lexer.cc"
yy1266:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 699 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ROW); }
#line 6880 "src/parse/conf_lexer.cc"
yy1267:
	yych = *++cur;
	if (yych == 'i') goto yy1343;
	goto yy1140;
yy1268:
	yych = *++cur;
	if (yych == 'e') goto yy1344;
	goto yy1140;
yy1269:
	yych = *++cur;
	if (yych == 't') goto yy1345;
	goto yy1140;
yy1270:
	yych = *++cur;
	if (yych == 't') goto yy1346;
	goto yy1140;
yy1271:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 704 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TAG); }
#line 6902 "src/parse/conf_lexer.cc"
yy1272:
	yych = *++cur;
	if (yych == 'o') goto yy1347;
	goto yy1140;
yy1273:
	yych = *++cur;
	if (yych == 'i') goto yy1348;
	goto yy1140;
yy1274:
	yych = *++cur;
	if (yych == 'e') goto yy1349;
	goto yy1140;
yy1275:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 707 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VAL); }
#line 6920 "src/parse/conf_lexer.cc"
yy1276:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 708 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VAR); }
#line 6926 "src/parse/conf_lexer.cc"
yy1277:
	yych = *++cur;
	if (yych == 's') goto yy1350;
	goto yy1140;
yy1278:
	yych = *++cur;
	if (yych == 'm') goto yy1351;
	goto yy1140;
yy1279:
	yych = *++cur;
	if (yych == 'h') goto yy1352;
	goto yy1140;
yy1280:
	yych = *++cur;
	if (yych == 'e') goto yy1353;
	goto yy1140;
yy1281:
	yych = *++cur;
	if (yych == '.') goto yy1354;
	if (yych == '_') goto yy1355;
	goto yy1160;
yy1282:
	yych = *++cur;
	if (yych == 's') goto yy1356;
	goto yy1160;
yy1283:
	yych = *++cur;
	if (yych == 'e') goto yy1357;
	if (yych == 't') goto yy1358;
	goto yy1160;
yy1284:
	yych = *++cur;
	if (yych == 't') goto yy1359;
	goto yy1160;
yy1285:
	yych = *++cur;
	if (yych == 'r') goto yy1360;
	goto yy1160;
yy1286:
	yych = *++cur;
	if (yych == 'e') goto yy1361;
	goto yy1160;
yy1287:
	yych = *++cur;
	if (yych == 'd') goto yy1362;
	if (yych == 's') goto yy1363;
	goto yy1160;
yy1288:
	yych = *++cur;
	if (yych == 'e') goto yy1364;
	goto yy1160;
yy1289:
	yych = *++cur;
	if (yych == 't') goto yy1365;
	goto yy1160;
yy1290:
	yych = *++cur;
	if (yych == 'p') goto yy1366;
	goto yy1160;
yy1291:
	yych = *++cur;
	if (yych == 'y') goto yy1367;
	goto yy1160;
yy1292:
	yych = *++cur;
	if (yych == 'a') goto yy1368;
	goto yy1160;
yy1293:
	yych = *++cur;
	if (yych == 't') goto yy1369;
	goto yy1160;
yy1294:
	yych = *++cur;
	if (yych == 'v') goto yy1370;
	goto yy1160;
yy1295:
	yych = *++cur;
	if (yych == 'r') goto yy1371;
	goto yy1160;
yy1296:
	yych = *++cur;
	if (yych == 'r') goto yy1372;
	goto yy1160;
yy1297:
	yych = *++cur;
	if (yych == 'e') goto yy1373;
	goto yy1160;
yy1298:
	yych = *++cur;
	if (yych == 'a') goto yy1374;
	goto yy1160;
yy1299:
	yych = *++cur;
	if (yych == 's') goto yy1375;
	goto yy1160;
yy1300:
	yych = *++cur;
	if (yych == 'i') goto yy1376;
	if (yych == 'n') goto yy1377;
	goto yy1160;
yy1301:
	yych = *++cur;
	if (yych == 'e') goto yy1378;
	goto yy1175;
yy1302:
	yych = *++cur;
	if (yych == 'C') goto yy1379;
	goto yy1175;
yy1303:
	yych = *++cur;
	if (yych == 'P') goto yy1380;
	goto yy1175;
yy1304:
	yych = *++cur;
	if (yych <= 'W') goto yy1175;
	if (yych <= 'X') goto yy1381;
	if (yych <= 'Y') goto yy1382;
	goto yy1175;
yy1305:
	yych = *++cur;
	if (yych == 'R') goto yy1383;
	goto yy1175;
yy1306:
	yych = *++cur;
	if (yych == 'B') goto yy1384;
	goto yy1175;
yy1307:
	yych = *++cur;
	if (yych == 'D') goto yy1385;
	goto yy1175;
yy1308:
	yych = *++cur;
	if (yych == 'T') goto yy1386;
	goto yy1175;
yy1309:
	yych = *++cur;
	if (yych == 'P') goto yy1387;
	goto yy1175;
yy1310:
	yych = *++cur;
	if (yych == 'S') goto yy1388;
	goto yy1175;
yy1311:
	yych = *++cur;
	if (yych == 'M') goto yy1389;
	goto yy1175;
yy1312:
	yych = *++cur;
	if (yych == 'R') goto yy1390;
	goto yy1175;
yy1313:
	yych = *++cur;
	if (yych == 'A') goto yy1391;
	goto yy1175;
yy1314:
	yych = *++cur;
	if (yych == 'E') goto yy1392;
	goto yy1175;
yy1315:
	yych = *++cur;
	if (yych == 'S') goto yy1393;
	goto yy1175;
yy1316:
	yych = *++cur;
	if (yych == 'T') goto yy1394;
	goto yy1175;
yy1317:
	yych = *++cur;
	if (yych == 'I') goto yy1395;
	goto yy1175;
yy1318:
	yych = *++cur;
	if (yych == 'I') goto yy1396;
	goto yy1175;
yy1319:
	yych = *++cur;
	if (yych == 'A') goto yy1397;
	goto yy1175;
yy1320:
	yych = *++cur;
	if (yych == 'a') goto yy1398;
	goto yy1140;
yy1321:
	yych = *++cur;
	if (yych == 'y') goto yy1399;
	goto yy1140;
yy1322:
	yych = *++cur;
	if (yych == 'y') goto yy1400;
	goto yy1140;
yy1323:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 677 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BASE); }
#line 7122 "src/parse/conf_lexer.cc"
yy1324:
	yych = *++cur;
	if (yych == 'c') goto yy1401;
	goto yy1140;
yy1325:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 678 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CASE); }
#line 7132 "src/parse/conf_lexer.cc"
yy1326:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == ':') goto yy1402;
	goto yy1140;
yy1327:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 679 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COND); }
#line 7143 "src/parse/conf_lexer.cc"
yy1328:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 680 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DATE); }
#line 7149 "src/parse/conf_lexer.cc"
yy1329:
	yych = *++cur;
	if (yych == 'n') goto yy1403;
	goto yy1140;
yy1330:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 681 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ELEM); }
#line 7159 "src/parse/conf_lexer.cc"
yy1331:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 682 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::EXPR); }
#line 7165 "src/parse/conf_lexer.cc"
yy1332:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 684 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FILE); }
#line 7171 "src/parse/conf_lexer.cc"
yy1333:
	yych = *++cur;
	if (yych == 'c') goto yy1404;
	if (yych == 'f') goto yy1405;
	goto yy1140;
yy1334:
	yych = *++cur;
	if (yych == 'n') goto yy1406;
	if (yych == 'x') goto yy1407;
	goto yy1140;
yy1335:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 688 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INIT); }
#line 7187 "src/parse/conf_lexer.cc"
yy1336:
	yych = *++cur;
	if (yych == 'l') goto yy1408;
	goto yy1140;
yy1337:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 691 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LINE); }
#line 7197 "src/parse/conf_lexer.cc"
yy1338:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 692 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MASK); }
#line 7203 "src/parse/conf_lexer.cc"
yy1339:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 693 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NAME); }
#line 7209 "src/parse/conf_lexer.cc"
yy1340:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 695 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEED); }
#line 7215 "src/parse/conf_lexer.cc"
yy1341:
	yych = *++cur;
	if (yych == 'e') goto yy1409;
	goto yy1140;
yy1342:
	yych = *++cur;
	if (yych == 'a') goto yy1410;
	goto yy1140;
yy1343:
	yych = *++cur;
	if (yych == 'l') goto yy1411;
	goto yy1140;
yy1344:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 701 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SIZE); }
#line 7233 "src/parse/conf_lexer.cc"
yy1345:
	yych = *++cur;
	if (yych == 'e') goto yy1412;
	goto yy1140;
yy1346:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 703 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STMT); }
#line 7243 "src/parse/conf_lexer.cc"
yy1347:
	yych = *++cur;
	if (yych == 'w') goto yy1413;
	goto yy1140;
yy1348:
	yych = *++cur;
	if (yych == 'n') goto yy1414;
	goto yy1140;
yy1349:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 706 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TYPE); }
#line 7257 "src/parse/conf_lexer.cc"
yy1350:
	yych = *++cur;
	if (yych == 'i') goto yy1415;
	goto yy1140;
yy1351:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 713 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BITMAP); }
#line 7267 "src/parse/conf_lexer.cc"
yy1352:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 714 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CHAR); }
#line 7273 "src/parse/conf_lexer.cc"
yy1353:
	yych = *++cur;
	if (yych == 'c') goto yy1416;
	goto yy1140;
yy1354:
	yych = *++cur;
	if (yych <= 'q') {
		if (yych == 'g') goto yy1417;
		goto yy1160;
	} else {
		if (yych <= 'r') goto yy1418;
		if (yych <= 's') goto yy1419;
		goto yy1160;
	}
yy1355:
	yych = *++cur;
	if (yych == 's') goto yy1420;
	goto yy1160;
yy1356:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 799 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::ARGS); }
#line 7297 "src/parse/conf_lexer.cc"
yy1357:
	yych = *++cur;
	if (yych == '_') goto yy1421;
	goto yy1160;
yy1358:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 796 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::CAST); }
#line 7307 "src/parse/conf_lexer.cc"
yy1359:
	yych = *++cur;
	if (yych == 'o') goto yy1422;
	goto yy1160;
yy1360:
	yych = *++cur;
	if (yych == '_') goto yy1423;
	goto yy1160;
yy1361:
	yych = *++cur;
	if (yych == '_') goto yy1424;
	goto yy1160;
yy1362:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 800 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::COND); }
#line 7325 "src/parse/conf_lexer.cc"
yy1363:
	yych = *++cur;
	if (yych == 't') goto yy1425;
	goto yy1160;
yy1364:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 782 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::DATE); }
#line 7335 "src/parse/conf_lexer.cc"
yy1365:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 801 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::INIT); }
#line 7341 "src/parse/conf_lexer.cc"
yy1366:
	yych = *++cur;
	if (yych == '_') goto yy1426;
	goto yy1160;
yy1367:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 804 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::MANY); }
#line 7351 "src/parse/conf_lexer.cc"
yy1368:
	yych = *++cur;
	if (yych == 'd') goto yy1427;
	goto yy1160;
yy1369:
	yych = *++cur;
	if (yych == 'e') goto yy1428;
	goto yy1160;
yy1370:
	yych = *++cur;
	if (yych == 'a') goto yy1429;
	goto yy1160;
yy1371:
	yych = *++cur;
	if (yych == 't') goto yy1430;
	goto yy1160;
yy1372:
	yych = *++cur;
	if (yych == 'a') goto yy1431;
	goto yy1160;
yy1373:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 803 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::TYPE); }
#line 7377 "src/parse/conf_lexer.cc"
yy1374:
	yych = *++cur;
	if (yych == 'f') goto yy1432;
	goto yy1160;
yy1375:
	yych = *++cur;
	if (yych == 'i') goto yy1433;
	goto yy1160;
yy1376:
	yych = *++cur;
	if (yych == 'l') goto yy1434;
	goto yy1160;
yy1377:
	yych = *++cur;
	if (yych == '.') goto yy1435;
	goto yy1160;
yy1378:
	yych = *++cur;
	if (yych == 'f') goto yy1436;
	goto yy1175;
yy1379:
	yych = *++cur;
	if (yych == 'K') goto yy1437;
	goto yy1175;
yy1380:
	yych = *++cur;
	if (yych == 'Y') goto yy1438;
	goto yy1175;
yy1381:
	yych = *++cur;
	if (yych == 'M') goto yy1439;
	goto yy1175;
yy1382:
	yych = *++cur;
	if (yych == 'P') goto yy1440;
	goto yy1175;
yy1383:
	yych = *++cur;
	if (yych == 'S') goto yy1441;
	goto yy1175;
yy1384:
	yych = *++cur;
	if (yych == 'U') goto yy1442;
	goto yy1175;
yy1385:
	++cur;
#line 721 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::END); }
#line 7426 "src/parse/conf_lexer.cc"
yy1386:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy1443;
		goto yy1175;
	} else {
		if (yych <= 'C') goto yy1444;
		if (yych == 'S') goto yy1445;
		goto yy1175;
	}
yy1387:
	yych = *++cur;
	if (yych == 'U') goto yy1446;
	goto yy1175;
yy1388:
	yych = *++cur;
	if (yych == 'S') goto yy1447;
	goto yy1175;
yy1389:
	yych = *++cur;
	if (yych == 'I') goto yy1448;
	goto yy1175;
yy1390:
	yych = *++cur;
	if (yych == 'K') goto yy1449;
	goto yy1175;
yy1391:
	yych = *++cur;
	if (yych == 'G') goto yy1450;
	goto yy1175;
yy1392:
	yych = *++cur;
	if (yych == 'K') goto yy1451;
	goto yy1175;
yy1393:
	yych = *++cur;
	if (yych == 'T') goto yy1452;
	goto yy1175;
yy1394:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy1453;
		goto yy1175;
	} else {
		if (yych <= 'C') goto yy1454;
		if (yych == 'S') goto yy1455;
		goto yy1175;
	}
yy1395:
	yych = *++cur;
	if (yych == 'F') goto yy1456;
	goto yy1175;
yy1396:
	yych = *++cur;
	if (yych == 'P') goto yy1457;
	goto yy1175;
yy1397:
	yych = *++cur;
	if (yych == 'G') goto yy1458;
	goto yy1175;
yy1398:
	yych = *++cur;
	if (yych == 'm') goto yy1459;
	goto yy1140;
yy1399:
	yych = *++cur;
	if (yych == 'p') goto yy1460;
	goto yy1140;
yy1400:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 675 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARRAY); }
#line 7500 "src/parse/conf_lexer.cc"
yy1401:
	yych = *++cur;
	if (yych == 'h') goto yy1461;
	goto yy1140;
yy1402:
	yych = *++cur;
	if (yych <= 'h') {
		if (yych <= 'a') {
			if (yych <= '^') {
				if (yych <= '/') goto yy1175;
				if (yych <= '9') goto yy1462;
				goto yy1175;
			} else {
				if (yych <= '_') goto yy1462;
				if (yych <= '`') goto yy1175;
				goto yy1465;
			}
		} else {
			if (yych <= 'd') {
				if (yych == 'c') goto yy1466;
				goto yy1462;
			} else {
				if (yych <= 'e') goto yy1467;
				if (yych <= 'f') goto yy1468;
				if (yych <= 'g') goto yy1469;
				goto yy1462;
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'l') {
				if (yych <= 'i') goto yy1470;
				if (yych <= 'k') goto yy1462;
				goto yy1471;
			} else {
				if (yych <= 'q') goto yy1462;
				if (yych <= 'r') goto yy1472;
				goto yy1473;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 't') goto yy1474;
				if (yych <= 'u') goto yy1462;
				goto yy1475;
			} else {
				if (yych == 'y') goto yy1476;
				if (yych <= 'z') goto yy1462;
				goto yy1175;
			}
		}
	}
yy1403:
	yych = *++cur;
	if (yych == 't') goto yy1477;
	goto yy1140;
yy1404:
	yych = *++cur;
	if (yych == 'l') goto yy1478;
	goto yy1140;
yy1405:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 686 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FNDEF); }
#line 7565 "src/parse/conf_lexer.cc"
yy1406:
	yych = *++cur;
	if (yych == 't') goto yy1479;
	goto yy1140;
yy1407:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 687 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INDEX); }
#line 7575 "src/parse/conf_lexer.cc"
yy1408:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 689 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LABEL); }
#line 7581 "src/parse/conf_lexer.cc"
yy1409:
	yych = *++cur;
	if (yych == 't') goto yy1480;
	goto yy1140;
yy1410:
	yych = *++cur;
	if (yych == 'l') goto yy1481;
	goto yy1140;
yy1411:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 700 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SIGIL); }
#line 7595 "src/parse/conf_lexer.cc"
yy1412:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 702 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STATE); }
#line 7601 "src/parse/conf_lexer.cc"
yy1413:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 705 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::THROW); }
#line 7607 "src/parse/conf_lexer.cc"
yy1414:
	yych = *++cur;
	if (yych == 'd') goto yy1482;
	goto yy1140;
yy1415:
	yych = *++cur;
	if (yych == 'o') goto yy1483;
	goto yy1140;
yy1416:
	yych = *++cur;
	if (yych == 'o') goto yy1484;
	goto yy1140;
yy1417:
	yych = *++cur;
	if (yych == 'e') goto yy1485;
	goto yy1160;
yy1418:
	yych = *++cur;
	if (yych == 'e') goto yy1486;
	goto yy1160;
yy1419:
	yych = *++cur;
	if (yych == 'i') goto yy1487;
	goto yy1160;
yy1420:
	yych = *++cur;
	if (yych == 't') goto yy1488;
	goto yy1160;
yy1421:
	yych = *++cur;
	if (yych == 'r') goto yy1489;
	goto yy1160;
yy1422:
	yych = *++cur;
	if (yych == '.') goto yy1490;
	goto yy1160;
yy1423:
	yych = *++cur;
	if (yych == 'l') goto yy1491;
	goto yy1160;
yy1424:
	yych = *++cur;
	if (yych == 'm') goto yy1492;
	goto yy1160;
yy1425:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 798 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::CONST); }
#line 7657 "src/parse/conf_lexer.cc"
yy1426:
	yych = *++cur;
	if (yych == 'l') goto yy1493;
	goto yy1160;
yy1427:
	yych = *++cur;
	if (yych == 'i') goto yy1494;
	goto yy1160;
yy1428:
	yych = *++cur;
	if (yych == 'd') goto yy1495;
	goto yy1160;
yy1429:
	yych = *++cur;
	if (yych == 'l') goto yy1496;
	goto yy1160;
yy1430:
	yych = *++cur;
	if (yych == '_') goto yy1497;
	goto yy1160;
yy1431:
	yych = *++cur;
	if (yych == 'b') goto yy1498;
	goto yy1160;
yy1432:
	yych = *++cur;
	if (yych == 'e') goto yy1499;
	goto yy1160;
yy1433:
	yych = *++cur;
	if (yych == 'o') goto yy1500;
	goto yy1160;
yy1434:
	yych = *++cur;
	if (yych == 'l') goto yy1501;
	goto yy1160;
yy1435:
	yych = *++cur;
	if (yych == 't') goto yy1502;
	goto yy1160;
yy1436:
	yych = *++cur;
	if (yych == 'i') goto yy1503;
	goto yy1175;
yy1437:
	yych = *++cur;
	if (yych == 'U') goto yy1504;
	goto yy1175;
yy1438:
	yych = *++cur;
	if (yych == 'M') goto yy1505;
	if (yych == 'S') goto yy1506;
	goto yy1175;
yy1439:
	yych = *++cur;
	if (yych == 'A') goto yy1507;
	goto yy1175;
yy1440:
	yych = *++cur;
	if (yych == 'E') goto yy1508;
	goto yy1175;
yy1441:
	yych = *++cur;
	if (yych == 'O') goto yy1509;
	goto yy1175;
yy1442:
	yych = *++cur;
	if (yych == 'G') goto yy1510;
	goto yy1175;
yy1443:
	yych = *++cur;
	if (yych == 'C') goto yy1511;
	goto yy1175;
yy1444:
	yych = *++cur;
	if (yych == 'O') goto yy1512;
	goto yy1175;
yy1445:
	yych = *++cur;
	if (yych == 'T') goto yy1513;
	goto yy1175;
yy1446:
	yych = *++cur;
	if (yych == 'T') goto yy1514;
	goto yy1175;
yy1447:
	yych = *++cur;
	if (yych == 'T') goto yy1515;
	goto yy1175;
yy1448:
	yych = *++cur;
	if (yych == 'T') goto yy1516;
	goto yy1175;
yy1449:
	yych = *++cur;
	if (yych == 'E') goto yy1517;
	goto yy1175;
yy1450:
	yych = *++cur;
	if (yych == 'N') goto yy1518;
	if (yych == 'P') goto yy1519;
	goto yy1175;
yy1451:
	++cur;
#line 731 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::PEEK); }
#line 7764 "src/parse/conf_lexer.cc"
yy1452:
	yych = *++cur;
	if (yych == 'O') goto yy1520;
	goto yy1175;
yy1453:
	yych = *++cur;
	if (yych == 'C') goto yy1521;
	goto yy1175;
yy1454:
	yych = *++cur;
	if (yych == 'O') goto yy1522;
	goto yy1175;
yy1455:
	yych = *++cur;
	if (yych == 'T') goto yy1523;
	goto yy1175;
yy1456:
	yych = *++cur;
	if (yych == 'T') goto yy1524;
	goto yy1175;
yy1457:
	++cur;
#line 742 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SKIP); }
#line 7789 "src/parse/conf_lexer.cc"
yy1458:
	yych = *++cur;
	if (yych == 'N') goto yy1526;
	if (yych == 'P') goto yy1527;
	goto yy1175;
yy1459:
	yych = *++cur;
	if (yych == 'e') goto yy1528;
	goto yy1140;
yy1460:
	yych = *++cur;
	if (yych == 'e') goto yy1529;
	goto yy1140;
yy1461:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 676 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BRANCH); }
#line 7808 "src/parse/conf_lexer.cc"
yy1462:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1463:
	if (yych <= '^') {
		if (yych <= '/') goto yy1464;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1464;
		if (yych <= 'z') goto yy1462;
	}
yy1464:
#line 667 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown code template: '%.*s'", int(cur - tok), tok));
    }
#line 7826 "src/parse/conf_lexer.cc"
yy1465:
	yych = *++cur;
	if (yych <= 'q') {
		if (yych == 'b') goto yy1530;
		goto yy1463;
	} else {
		if (yych <= 'r') goto yy1531;
		if (yych <= 's') goto yy1532;
		goto yy1463;
	}
yy1466:
	yych = *++cur;
	if (yych <= 'l') {
		if (yych == 'g') goto yy1533;
		goto yy1463;
	} else {
		if (yych <= 'm') goto yy1534;
		if (yych == 'o') goto yy1535;
		goto yy1463;
	}
yy1467:
	yych = *++cur;
	if (yych == 'n') goto yy1536;
	goto yy1463;
yy1468:
	yych = *++cur;
	if (yych == 'i') goto yy1537;
	if (yych == 'n') goto yy1538;
	goto yy1463;
yy1469:
	yych = *++cur;
	if (yych == 'o') goto yy1539;
	goto yy1463;
yy1470:
	yych = *++cur;
	if (yych == 'f') goto yy1540;
	goto yy1463;
yy1471:
	yych = *++cur;
	if (yych == 'i') goto yy1541;
	if (yych == 'o') goto yy1542;
	goto yy1463;
yy1472:
	yych = *++cur;
	if (yych == 'e') goto yy1543;
	goto yy1463;
yy1473:
	yych = *++cur;
	if (yych == 'w') goto yy1544;
	goto yy1463;
yy1474:
	yych = *++cur;
	if (yych == 'a') goto yy1545;
	if (yych == 'y') goto yy1546;
	goto yy1463;
yy1475:
	yych = *++cur;
	if (yych == 'a') goto yy1547;
	goto yy1463;
yy1476:
	yych = *++cur;
	if (yych == 'y') goto yy1548;
	goto yy1463;
yy1477:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 749 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DEDENT); }
#line 7895 "src/parse/conf_lexer.cc"
yy1478:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 685 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FNDECL); }
#line 7901 "src/parse/conf_lexer.cc"
yy1479:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 748 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INDENT); }
#line 7907 "src/parse/conf_lexer.cc"
yy1480:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 696 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::OFFSET); }
#line 7913 "src/parse/conf_lexer.cc"
yy1481:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 697 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RETVAL); }
#line 7919 "src/parse/conf_lexer.cc"
yy1482:
	yych = *++cur;
	if (yych == 'e') goto yy1549;
	goto yy1140;
yy1483:
	yych = *++cur;
	if (yych == 'n') goto yy1550;
	goto yy1140;
yy1484:
	yych = *++cur;
	if (yych == 'r') goto yy1551;
	goto yy1140;
yy1485:
	yych = *++cur;
	if (yych == 'n') goto yy1552;
	goto yy1160;
yy1486:
	yych = *++cur;
	if (yych == 'c') goto yy1553;
	goto yy1160;
yy1487:
	yych = *++cur;
	if (yych == 'm') goto yy1554;
	goto yy1160;
yy1488:
	yych = *++cur;
	if (yych == 'y') goto yy1555;
	goto yy1160;
yy1489:
	yych = *++cur;
	if (yych == 'a') goto yy1556;
	goto yy1160;
yy1490:
	yych = *++cur;
	if (yych == 'r') goto yy1557;
	goto yy1160;
yy1491:
	yych = *++cur;
	if (yych == 'i') goto yy1558;
	goto yy1160;
yy1492:
	yych = *++cur;
	if (yych == 'o') goto yy1559;
	goto yy1160;
yy1493:
	yych = *++cur;
	if (yych == 'a') goto yy1560;
	goto yy1160;
yy1494:
	yych = *++cur;
	if (yych == 'c') goto yy1561;
	goto yy1160;
yy1495:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 805 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::NESTED); }
#line 7977 "src/parse/conf_lexer.cc"
yy1496:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 802 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::RETVAL); }
#line 7983 "src/parse/conf_lexer.cc"
yy1497:
	yych = *++cur;
	if (yych == 'c') goto yy1562;
	goto yy1160;
yy1498:
	yych = *++cur;
	if (yych == 'l') goto yy1563;
	goto yy1160;
yy1499:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 785 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::UNSAFE); }
#line 7997 "src/parse/conf_lexer.cc"
yy1500:
	yych = *++cur;
	if (yych == 'n') goto yy1564;
	goto yy1160;
yy1501:
	yych = *++cur;
	if (yych == '.') goto yy1565;
	goto yy1160;
yy1502:
	yych = *++cur;
	if (yych == 'h') goto yy1566;
	goto yy1160;
yy1503:
	yych = *++cur;
	if (yych == 'n') goto yy1567;
	goto yy1175;
yy1504:
	yych = *++cur;
	if (yych == 'P') goto yy1568;
	goto yy1175;
yy1505:
	yych = *++cur;
	if (yych == 'T') goto yy1570;
	goto yy1175;
yy1506:
	yych = *++cur;
	if (yych == 'T') goto yy1571;
	goto yy1175;
yy1507:
	yych = *++cur;
	if (yych == 'R') goto yy1572;
	goto yy1175;
yy1508:
	++cur;
#line 717 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CTYPE); }
#line 8034 "src/parse/conf_lexer.cc"
yy1509:
	yych = *++cur;
	if (yych == 'R') goto yy1573;
	goto yy1175;
yy1510:
	++cur;
#line 720 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DEBUG); }
#line 8043 "src/parse/conf_lexer.cc"
yy1511:
	yych = *++cur;
	if (yych == 'C') goto yy1574;
	goto yy1175;
yy1512:
	yych = *++cur;
	if (yych == 'N') goto yy1575;
	goto yy1175;
yy1513:
	yych = *++cur;
	if (yych == 'A') goto yy1576;
	goto yy1175;
yy1514:
	++cur;
#line 725 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INPUT); }
#line 8060 "src/parse/conf_lexer.cc"
yy1515:
	yych = *++cur;
	if (yych == 'H') goto yy1577;
	goto yy1175;
yy1516:
	++cur;
#line 727 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LIMIT); }
#line 8069 "src/parse/conf_lexer.cc"
yy1517:
	yych = *++cur;
	if (yych == 'R') goto yy1578;
	goto yy1175;
yy1518:
	++cur;
#line 729 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MTAGN); }
#line 8078 "src/parse/conf_lexer.cc"
yy1519:
	++cur;
#line 730 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MTAGP); }
#line 8083 "src/parse/conf_lexer.cc"
yy1520:
	yych = *++cur;
	if (yych == 'R') goto yy1579;
	goto yy1175;
yy1521:
	yych = *++cur;
	if (yych == 'C') goto yy1580;
	goto yy1175;
yy1522:
	yych = *++cur;
	if (yych == 'N') goto yy1581;
	goto yy1175;
yy1523:
	yych = *++cur;
	if (yych == 'A') goto yy1582;
	goto yy1175;
yy1524:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == 'M') goto yy1583;
	if (yych == 'S') goto yy1584;
yy1525:
#line 739 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFT); }
#line 8108 "src/parse/conf_lexer.cc"
yy1526:
	++cur;
#line 743 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STAGN); }
#line 8113 "src/parse/conf_lexer.cc"
yy1527:
	++cur;
#line 744 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STAGP); }
#line 8118 "src/parse/conf_lexer.cc"
yy1528:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 673 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARGNAME); }
#line 8124 "src/parse/conf_lexer.cc"
yy1529:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 674 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARGTYPE); }
#line 8130 "src/parse/conf_lexer.cc"
yy1530:
	yych = *++cur;
	if (yych == 'o') goto yy1585;
	goto yy1463;
yy1531:
	yych = *++cur;
	if (yych == 'r') goto yy1586;
	goto yy1463;
yy1532:
	yych = *++cur;
	if (yych == 's') goto yy1587;
	goto yy1463;
yy1533:
	yych = *++cur;
	if (yych == 'o') goto yy1588;
	goto yy1463;
yy1534:
	yych = *++cur;
	if (yych == 'p') goto yy1589;
	goto yy1463;
yy1535:
	yych = *++cur;
	if (yych == 'n') goto yy1590;
	goto yy1463;
yy1536:
	yych = *++cur;
	if (yych == 'u') goto yy1591;
	goto yy1463;
yy1537:
	yych = *++cur;
	if (yych == 'n') goto yy1592;
	goto yy1463;
yy1538:
	yych = *++cur;
	if (yych <= 'b') goto yy1463;
	if (yych <= 'c') goto yy1593;
	if (yych <= 'd') goto yy1594;
	goto yy1463;
yy1539:
	yych = *++cur;
	if (yych == 't') goto yy1595;
	goto yy1463;
yy1540:
	yych = *++cur;
	if (yych == '_') goto yy1596;
	goto yy1463;
yy1541:
	yych = *++cur;
	if (yych == 'n') goto yy1597;
	goto yy1463;
yy1542:
	yych = *++cur;
	if (yych == 'o') goto yy1598;
	goto yy1463;
yy1543:
	yych = *++cur;
	if (yych == 'c') goto yy1599;
	goto yy1463;
yy1544:
	yych = *++cur;
	if (yych == 'i') goto yy1600;
	goto yy1463;
yy1545:
	yych = *++cur;
	if (yych == 'i') goto yy1601;
	goto yy1463;
yy1546:
	yych = *++cur;
	if (yych == 'p') goto yy1602;
	goto yy1463;
yy1547:
	yych = *++cur;
	if (yych == 'r') goto yy1603;
	goto yy1463;
yy1548:
	yych = *++cur;
	switch (yych) {
		case 'b': goto yy1604;
		case 'c': goto yy1605;
		case 'd': goto yy1606;
		case 'e': goto yy1607;
		case 'g': goto yy1608;
		case 'l': goto yy1609;
		case 'm': goto yy1610;
		case 'p': goto yy1611;
		case 'r': goto yy1612;
		case 's': goto yy1613;
		case 't': goto yy1614;
		default: goto yy1463;
	}
yy1549:
	yych = *++cur;
	if (yych == 'n') goto yy1615;
	goto yy1140;
yy1550:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 709 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VER); }
#line 8230 "src/parse/conf_lexer.cc"
yy1551:
	yych = *++cur;
	if (yych == 'd') goto yy1616;
	goto yy1140;
yy1552:
	yych = *++cur;
	if (yych == 'e') goto yy1617;
	goto yy1160;
yy1553:
	yych = *++cur;
	if (yych == 'o') goto yy1618;
	goto yy1160;
yy1554:
	yych = *++cur;
	if (yych == 'p') goto yy1619;
	goto yy1160;
yy1555:
	yych = *++cur;
	if (yych == 'l') goto yy1620;
	goto yy1160;
yy1556:
	yych = *++cur;
	if (yych == 'n') goto yy1621;
	goto yy1160;
yy1557:
	yych = *++cur;
	if (yych == 'e') goto yy1622;
	goto yy1160;
yy1558:
	yych = *++cur;
	if (yych == 't') goto yy1623;
	goto yy1160;
yy1559:
	yych = *++cur;
	if (yych == 'd') goto yy1624;
	goto yy1160;
yy1560:
	yych = *++cur;
	if (yych == 'b') goto yy1625;
	goto yy1160;
yy1561:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 786 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::MONADIC); }
#line 8276 "src/parse/conf_lexer.cc"
yy1562:
	yych = *++cur;
	if (yych == 'o') goto yy1626;
	goto yy1160;
yy1563:
	yych = *++cur;
	if (yych == 'e') goto yy1627;
	goto yy1160;
yy1564:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 783 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::VER); }
#line 8290 "src/parse/conf_lexer.cc"
yy1565:
	yych = *++cur;
	if (yych == 'e') goto yy1628;
	goto yy1160;
yy1566:
	yych = *++cur;
	if (yych == 'r') goto yy1629;
	goto yy1160;
yy1567:
	yych = *++cur;
	if (yych == 'e') goto yy1630;
	goto yy1175;
yy1568:
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == 'C') goto yy1631;
yy1569:
#line 711 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BACKUP); }
#line 8310 "src/parse/conf_lexer.cc"
yy1570:
	yych = *++cur;
	if (yych == 'A') goto yy1632;
	goto yy1175;
yy1571:
	yych = *++cur;
	if (yych == 'A') goto yy1633;
	goto yy1175;
yy1572:
	yych = *++cur;
	if (yych == 'K') goto yy1634;
	goto yy1175;
yy1573:
	++cur;
#line 719 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CURSOR); }
#line 8327 "src/parse/conf_lexer.cc"
yy1574:
	yych = *++cur;
	if (yych == 'E') goto yy1635;
	goto yy1175;
yy1575:
	yych = *++cur;
	if (yych == 'D') goto yy1636;
	goto yy1175;
yy1576:
	yych = *++cur;
	if (yych == 'T') goto yy1637;
	goto yy1175;
yy1577:
	yych = *++cur;
	if (yych == 'A') goto yy1638;
	goto yy1175;
yy1578:
	++cur;
#line 728 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MARKER); }
#line 8348 "src/parse/conf_lexer.cc"
yy1579:
	yych = *++cur;
	if (yych == 'E') goto yy1639;
	goto yy1175;
yy1580:
	yych = *++cur;
	if (yych == 'E') goto yy1641;
	goto yy1175;
yy1581:
	yych = *++cur;
	if (yych == 'D') goto yy1642;
	goto yy1175;
yy1582:
	yych = *++cur;
	if (yych == 'T') goto yy1643;
	goto yy1175;
yy1583:
	yych = *++cur;
	if (yych == 'T') goto yy1644;
	goto yy1175;
yy1584:
	yych = *++cur;
	if (yych == 'T') goto yy1645;
	goto yy1175;
yy1585:
	yych = *++cur;
	if (yych == 'r') goto yy1646;
	goto yy1463;
yy1586:
	yych = *++cur;
	if (yych == 'a') goto yy1647;
	goto yy1463;
yy1587:
	yych = *++cur;
	if (yych == 'i') goto yy1648;
	goto yy1463;
yy1588:
	yych = *++cur;
	if (yych == 't') goto yy1649;
	goto yy1463;
yy1589:
	yych = *++cur;
	if (yych == '_') goto yy1650;
	goto yy1463;
yy1590:
	yych = *++cur;
	if (yych <= 'r') goto yy1463;
	if (yych <= 's') goto yy1651;
	if (yych <= 't') goto yy1652;
	goto yy1463;
yy1591:
	yych = *++cur;
	if (yych == 'm') goto yy1653;
	goto yy1463;
yy1592:
	yych = *++cur;
	if (yych == 'g') goto yy1655;
	goto yy1463;
yy1593:
	yych = *++cur;
	if (yych == 'a') goto yy1656;
	goto yy1463;
yy1594:
	yych = *++cur;
	if (yych == 'e') goto yy1657;
	goto yy1463;
yy1595:
	yych = *++cur;
	if (yych == 'o') goto yy1658;
	goto yy1463;
yy1596:
	yych = *++cur;
	if (yych == 't') goto yy1660;
	goto yy1463;
yy1597:
	yych = *++cur;
	if (yych == 'e') goto yy1661;
	goto yy1463;
yy1598:
	yych = *++cur;
	if (yych == 'p') goto yy1662;
	goto yy1463;
yy1599:
	yych = *++cur;
	if (yych == 'u') goto yy1664;
	goto yy1463;
yy1600:
	yych = *++cur;
	if (yych == 't') goto yy1665;
	goto yy1463;
yy1601:
	yych = *++cur;
	if (yych == 'l') goto yy1666;
	goto yy1463;
yy1602:
	yych = *++cur;
	if (yych == 'e') goto yy1667;
	goto yy1463;
yy1603:
	yych = *++cur;
	if (yych == '_') goto yy1668;
	goto yy1463;
yy1604:
	yych = *++cur;
	if (yych == 'a') goto yy1669;
	if (yych == 'm') goto yy1670;
	goto yy1463;
yy1605:
	yych = *++cur;
	if (yych == 'o') goto yy1671;
	goto yy1463;
yy1606:
	yych = *++cur;
	if (yych == 'e') goto yy1672;
	goto yy1463;
yy1607:
	yych = *++cur;
	if (yych == 'n') goto yy1673;
	goto yy1463;
yy1608:
	yych = *++cur;
	if (yych == 'e') goto yy1674;
	goto yy1463;
yy1609:
	yych = *++cur;
	if (yych == 'e') goto yy1675;
	goto yy1463;
yy1610:
	yych = *++cur;
	if (yych == 't') goto yy1676;
	goto yy1463;
yy1611:
	yych = *++cur;
	if (yych == 'e') goto yy1677;
	goto yy1463;
yy1612:
	yych = *++cur;
	if (yych == 'e') goto yy1678;
	goto yy1463;
yy1613:
	yych = *++cur;
	switch (yych) {
		case 'e': goto yy1679;
		case 'h': goto yy1680;
		case 'k': goto yy1681;
		case 't': goto yy1682;
		default: goto yy1463;
	}
yy1614:
	yych = *++cur;
	if (yych == 'a') goto yy1683;
	goto yy1463;
yy1615:
	yych = *++cur;
	if (yych == 't') goto yy1684;
	goto yy1140;
yy1616:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 732 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RECORD); }
#line 8510 "src/parse/conf_lexer.cc"
yy1617:
	yych = *++cur;
	if (yych == 'r') goto yy1685;
	goto yy1160;
yy1618:
	yych = *++cur;
	if (yych == 'r') goto yy1686;
	goto yy1160;
yy1619:
	yych = *++cur;
	if (yych == 'l') goto yy1687;
	goto yy1160;
yy1620:
	yych = *++cur;
	if (yych == 'e') goto yy1688;
	goto yy1160;
yy1621:
	yych = *++cur;
	if (yych == 'g') goto yy1689;
	goto yy1160;
yy1622:
	yych = *++cur;
	if (yych == 'l') goto yy1690;
	goto yy1160;
yy1623:
	yych = *++cur;
	if (yych == 'e') goto yy1691;
	goto yy1160;
yy1624:
	yych = *++cur;
	if (yych == 'e') goto yy1692;
	goto yy1160;
yy1625:
	yych = *++cur;
	if (yych == 'e') goto yy1693;
	goto yy1160;
yy1626:
	yych = *++cur;
	if (yych == 'n') goto yy1694;
	goto yy1160;
yy1627:
	yych = *++cur;
	if (yych == '_') goto yy1695;
	goto yy1160;
yy1628:
	yych = *++cur;
	if (yych == 'n') goto yy1696;
	goto yy1160;
yy1629:
	yych = *++cur;
	if (yych == 'o') goto yy1697;
	goto yy1160;
yy1630:
	yych = *++cur;
	if (yych == 'd') goto yy1698;
	goto yy1175;
yy1631:
	yych = *++cur;
	if (yych == 'T') goto yy1699;
	goto yy1175;
yy1632:
	yych = *++cur;
	if (yych == 'G') goto yy1700;
	goto yy1175;
yy1633:
	yych = *++cur;
	if (yych == 'G') goto yy1701;
	goto yy1175;
yy1634:
	yych = *++cur;
	if (yych == 'E') goto yy1702;
	goto yy1175;
yy1635:
	yych = *++cur;
	if (yych == 'P') goto yy1703;
	goto yy1175;
yy1636:
	++cur;
#line 723 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETCOND); }
#line 8591 "src/parse/conf_lexer.cc"
yy1637:
	yych = *++cur;
	if (yych == 'E') goto yy1704;
	goto yy1175;
yy1638:
	yych = *++cur;
	if (yych == 'N') goto yy1705;
	goto yy1175;
yy1639:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yych == 'C') goto yy1706;
	if (yych == 'T') goto yy1707;
yy1640:
#line 733 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORE); }
#line 8608 "src/parse/conf_lexer.cc"
yy1641:
	yych = *++cur;
	if (yych == 'P') goto yy1708;
	goto yy1175;
yy1642:
	++cur;
#line 737 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETCOND); }
#line 8617 "src/parse/conf_lexer.cc"
yy1643:
	yych = *++cur;
	if (yych == 'E') goto yy1709;
	goto yy1175;
yy1644:
	yych = *++cur;
	if (yych == 'A') goto yy1710;
	goto yy1175;
yy1645:
	yych = *++cur;
	if (yych == 'A') goto yy1711;
	goto yy1175;
yy1646:
	yych = *++cur;
	if (yych == 't') goto yy1712;
	goto yy1463;
yy1647:
	yych = *++cur;
	if (yych == 'y') goto yy1714;
	goto yy1463;
yy1648:
	yych = *++cur;
	if (yych == 'g') goto yy1715;
	goto yy1463;
yy1649:
	yych = *++cur;
	if (yych == 'o') goto yy1716;
	goto yy1463;
yy1650:
	yych = *++cur;
	switch (yych) {
		case 'e': goto yy1718;
		case 'g': goto yy1719;
		case 'l': goto yy1720;
		case 'n': goto yy1721;
		default: goto yy1463;
	}
yy1651:
	yych = *++cur;
	if (yych == 't') goto yy1722;
	goto yy1463;
yy1652:
	yych = *++cur;
	if (yych == 'i') goto yy1723;
	goto yy1463;
yy1653:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1654;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy1724;
		if (yych <= '`') goto yy1654;
		if (yych <= 'z') goto yy1462;
	}
yy1654:
#line 621 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_enum); }
#line 8676 "src/parse/conf_lexer.cc"
yy1655:
	yych = *++cur;
	if (yych == 'e') goto yy1725;
	goto yy1463;
yy1656:
	yych = *++cur;
	if (yych == 'l') goto yy1726;
	goto yy1463;
yy1657:
	yych = *++cur;
	if (yych == 'c') goto yy1727;
	if (yych == 'f') goto yy1728;
	goto yy1463;
yy1658:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1659;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1659;
		if (yych <= 'z') goto yy1462;
	}
yy1659:
#line 618 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_goto); }
#line 8702 "src/parse/conf_lexer.cc"
yy1660:
	yych = *++cur;
	if (yych == 'h') goto yy1730;
	goto yy1463;
yy1661:
	yych = *++cur;
	if (yych == '_') goto yy1731;
	goto yy1463;
yy1662:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1663;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1663;
		if (yych <= 'z') goto yy1462;
	}
yy1663:
#line 616 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_loop); }
#line 8723 "src/parse/conf_lexer.cc"
yy1664:
	yych = *++cur;
	if (yych == 'r') goto yy1732;
	goto yy1463;
yy1665:
	yych = *++cur;
	if (yych == 'c') goto yy1733;
	goto yy1463;
yy1666:
	yych = *++cur;
	if (yych == 'c') goto yy1734;
	goto yy1463;
yy1667:
	yych = *++cur;
	if (yych == '_') goto yy1735;
	goto yy1463;
yy1668:
	yych = *++cur;
	if (yych == 'g') goto yy1736;
	if (yych == 'l') goto yy1737;
	goto yy1463;
yy1669:
	yych = *++cur;
	if (yych == 'c') goto yy1738;
	goto yy1463;
yy1670:
	yych = *++cur;
	if (yych == '_') goto yy1739;
	goto yy1463;
yy1671:
	yych = *++cur;
	if (yych == 'p') goto yy1740;
	goto yy1463;
yy1672:
	yych = *++cur;
	if (yych == 'b') goto yy1741;
	goto yy1463;
yy1673:
	yych = *++cur;
	if (yych == 'd') goto yy1742;
	goto yy1463;
yy1674:
	yych = *++cur;
	if (yych == 't') goto yy1744;
	goto yy1463;
yy1675:
	yych = *++cur;
	if (yych == 's') goto yy1745;
	goto yy1463;
yy1676:
	yych = *++cur;
	if (yych == 'a') goto yy1746;
	goto yy1463;
yy1677:
	yych = *++cur;
	if (yych == 'e') goto yy1747;
	goto yy1463;
yy1678:
	yych = *++cur;
	if (yych == 's') goto yy1748;
	goto yy1463;
yy1679:
	yych = *++cur;
	if (yych == 't') goto yy1749;
	goto yy1463;
yy1680:
	yych = *++cur;
	if (yych == 'i') goto yy1750;
	goto yy1463;
yy1681:
	yych = *++cur;
	if (yych == 'i') goto yy1751;
	goto yy1463;
yy1682:
	yych = *++cur;
	if (yych == 'a') goto yy1752;
	goto yy1463;
yy1683:
	yych = *++cur;
	if (yych == 'r') goto yy1753;
	goto yy1463;
yy1684:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1139;
#line 750 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TOPINDENT); }
#line 8810 "src/parse/conf_lexer.cc"
yy1685:
	yych = *++cur;
	if (yych == 'i') goto yy1754;
	goto yy1160;
yy1686:
	yych = *++cur;
	if (yych == 'd') goto yy1755;
	goto yy1160;
yy1687:
	yych = *++cur;
	if (yych == 'e') goto yy1756;
	goto yy1160;
yy1688:
	yych = *++cur;
	if (yych == '.') goto yy1757;
	goto yy1160;
yy1689:
	yych = *++cur;
	if (yych == 'e') goto yy1758;
	goto yy1160;
yy1690:
	yych = *++cur;
	if (yych == 'a') goto yy1759;
	goto yy1160;
yy1691:
	yych = *++cur;
	if (yych == 'r') goto yy1760;
	goto yy1160;
yy1692:
	yych = *++cur;
	if (yych == 'l') goto yy1761;
	goto yy1160;
yy1693:
	yych = *++cur;
	if (yych == 'l') goto yy1762;
	goto yy1160;
yy1694:
	yych = *++cur;
	if (yych == 'd') goto yy1763;
	goto yy1160;
yy1695:
	yych = *++cur;
	if (yych == 's') goto yy1764;
	goto yy1160;
yy1696:
	yych = *++cur;
	if (yych == 'a') goto yy1765;
	goto yy1160;
yy1697:
	yych = *++cur;
	if (yych == 'w') goto yy1766;
	goto yy1160;
yy1698:
	yych = *++cur;
	if (yych == '>') goto yy1767;
	goto yy1175;
yy1699:
	yych = *++cur;
	if (yych == 'X') goto yy1768;
	goto yy1175;
yy1700:
	++cur;
#line 715 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COPYMTAG); }
#line 8875 "src/parse/conf_lexer.cc"
yy1701:
	++cur;
#line 716 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COPYSTAG); }
#line 8880 "src/parse/conf_lexer.cc"
yy1702:
	yych = *++cur;
	if (yych == 'R') goto yy1769;
	goto yy1175;
yy1703:
	yych = *++cur;
	if (yych == 'T') goto yy1770;
	goto yy1175;
yy1704:
	++cur;
#line 724 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETSTATE); }
#line 8893 "src/parse/conf_lexer.cc"
yy1705:
	++cur;
#line 726 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LESSTHAN); }
#line 8898 "src/parse/conf_lexer.cc"
yy1706:
	yych = *++cur;
	if (yych == 'T') goto yy1771;
	goto yy1175;
yy1707:
	yych = *++cur;
	if (yych == 'A') goto yy1772;
	goto yy1175;
yy1708:
	yych = *++cur;
	if (yych == 'T') goto yy1773;
	goto yy1175;
yy1709:
	++cur;
#line 738 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETSTATE); }
#line 8915 "src/parse/conf_lexer.cc"
yy1710:
	yych = *++cur;
	if (yych == 'G') goto yy1774;
	goto yy1175;
yy1711:
	yych = *++cur;
	if (yych == 'G') goto yy1775;
	goto yy1175;
yy1712:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1713;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1713;
		if (yych <= 'z') goto yy1462;
	}
yy1713:
#line 630 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_abort); }
#line 8936 "src/parse/conf_lexer.cc"
yy1714:
	yych = *++cur;
	if (yych == '_') goto yy1776;
	goto yy1463;
yy1715:
	yych = *++cur;
	if (yych == 'n') goto yy1777;
	goto yy1463;
yy1716:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1717;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy1779;
		if (yych <= '`') goto yy1717;
		if (yych <= 'z') goto yy1462;
	}
yy1717:
#line 619 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cgoto); }
#line 8958 "src/parse/conf_lexer.cc"
yy1718:
	yych = *++cur;
	if (yych == 'q') goto yy1780;
	goto yy1463;
yy1719:
	yych = *++cur;
	if (yych == 'e') goto yy1782;
	if (yych == 't') goto yy1784;
	goto yy1463;
yy1720:
	yych = *++cur;
	if (yych == 'e') goto yy1786;
	if (yych == 't') goto yy1788;
	goto yy1463;
yy1721:
	yych = *++cur;
	if (yych == 'e') goto yy1790;
	goto yy1463;
yy1722:
	yych = *++cur;
	if (yych == '_') goto yy1792;
	goto yy1463;
yy1723:
	yych = *++cur;
	if (yych == 'n') goto yy1793;
	goto yy1463;
yy1724:
	yych = *++cur;
	if (yych == 'e') goto yy1794;
	goto yy1463;
yy1725:
	yych = *++cur;
	if (yych == 'r') goto yy1795;
	goto yy1463;
yy1726:
	yych = *++cur;
	if (yych == 'l') goto yy1796;
	goto yy1463;
yy1727:
	yych = *++cur;
	if (yych == 'l') goto yy1798;
	goto yy1463;
yy1728:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1729;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1729;
		if (yych <= 'z') goto yy1462;
	}
yy1729:
#line 624 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fndef); }
#line 9013 "src/parse/conf_lexer.cc"
yy1730:
	yych = *++cur;
	if (yych == 'e') goto yy1800;
	goto yy1463;
yy1731:
	yych = *++cur;
	if (yych == 'i') goto yy1801;
	goto yy1463;
yy1732:
	yych = *++cur;
	if (yych == 's') goto yy1802;
	goto yy1463;
yy1733:
	yych = *++cur;
	if (yych == 'h') goto yy1803;
	goto yy1463;
yy1734:
	yych = *++cur;
	if (yych == 'a') goto yy1805;
	goto yy1463;
yy1735:
	yych = *++cur;
	if (yych <= 't') {
		if (yych == 'i') goto yy1806;
		goto yy1463;
	} else {
		if (yych <= 'u') goto yy1807;
		if (yych == 'y') goto yy1808;
		goto yy1463;
	}
yy1736:
	yych = *++cur;
	if (yych == 'l') goto yy1809;
	goto yy1463;
yy1737:
	yych = *++cur;
	if (yych == 'o') goto yy1810;
	goto yy1463;
yy1738:
	yych = *++cur;
	if (yych == 'k') goto yy1811;
	goto yy1463;
yy1739:
	yych = *++cur;
	if (yych == 'f') goto yy1812;
	if (yych == 'm') goto yy1813;
	goto yy1463;
yy1740:
	yych = *++cur;
	if (yych == 'y') goto yy1814;
	goto yy1463;
yy1741:
	yych = *++cur;
	if (yych == 'u') goto yy1815;
	goto yy1463;
yy1742:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1743;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1743;
		if (yych <= 'z') goto yy1462;
	}
yy1743:
#line 662 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyend); }
#line 9081 "src/parse/conf_lexer.cc"
yy1744:
	yych = *++cur;
	if (yych <= 'b') {
		if (yych == 'a') goto yy1816;
		goto yy1463;
	} else {
		if (yych <= 'c') goto yy1817;
		if (yych == 's') goto yy1818;
		goto yy1463;
	}
yy1745:
	yych = *++cur;
	if (yych == 's') goto yy1819;
	goto yy1463;
yy1746:
	yych = *++cur;
	if (yych == 'g') goto yy1820;
	goto yy1463;
yy1747:
	yych = *++cur;
	if (yych == 'k') goto yy1821;
	goto yy1463;
yy1748:
	yych = *++cur;
	if (yych == 't') goto yy1823;
	goto yy1463;
yy1749:
	yych = *++cur;
	if (yych <= 'b') {
		if (yych == 'a') goto yy1824;
		goto yy1463;
	} else {
		if (yych <= 'c') goto yy1825;
		if (yych == 's') goto yy1826;
		goto yy1463;
	}
yy1750:
	yych = *++cur;
	if (yych == 'f') goto yy1827;
	goto yy1463;
yy1751:
	yych = *++cur;
	if (yych == 'p') goto yy1828;
	goto yy1463;
yy1752:
	yych = *++cur;
	if (yych == 'g') goto yy1830;
	goto yy1463;
yy1753:
	yych = *++cur;
	if (yych == 'g') goto yy1831;
	goto yy1463;
yy1754:
	yych = *++cur;
	if (yych == 'c') goto yy1832;
	goto yy1160;
yy1755:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 777 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_RECORD); }
#line 9143 "src/parse/conf_lexer.cc"
yy1756:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 775 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_SIMPLE); }
#line 9149 "src/parse/conf_lexer.cc"
yy1757:
	yych = *++cur;
	if (yych == 'f') goto yy1833;
	goto yy1160;
yy1758:
	yych = *++cur;
	if (yych == 's') goto yy1834;
	goto yy1160;
yy1759:
	yych = *++cur;
	if (yych == 't') goto yy1835;
	goto yy1160;
yy1760:
	yych = *++cur;
	if (yych == 'a') goto yy1836;
	goto yy1160;
yy1761:
	yych = *++cur;
	if (yych == '.') goto yy1837;
	goto yy1160;
yy1762:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 787 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::LOOP_LABEL); }
#line 9175 "src/parse/conf_lexer.cc"
yy1763:
	yych = *++cur;
	if (yych == 'i') goto yy1838;
	goto yy1160;
yy1764:
	yych = *++cur;
	if (yych == 't') goto yy1839;
	goto yy1160;
yy1765:
	yych = *++cur;
	if (yych == 'b') goto yy1840;
	goto yy1160;
yy1766:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 790 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::FN_THROW); }
#line 9193 "src/parse/conf_lexer.cc"
yy1767:
	++cur;
#line 753 "../src/parse/conf_lexer.re"
	{ RET_TOK(CONF_UD); }
#line 9198 "src/parse/conf_lexer.cc"
yy1768:
	++cur;
#line 712 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BACKUPCTX); }
#line 9203 "src/parse/conf_lexer.cc"
yy1769:
	++cur;
#line 718 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CTXMARKER); }
#line 9208 "src/parse/conf_lexer.cc"
yy1770:
	++cur;
#line 722 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETACCEPT); }
#line 9213 "src/parse/conf_lexer.cc"
yy1771:
	yych = *++cur;
	if (yych == 'X') goto yy1841;
	goto yy1175;
yy1772:
	yych = *++cur;
	if (yych == 'G') goto yy1842;
	goto yy1175;
yy1773:
	++cur;
#line 736 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETACCEPT); }
#line 9226 "src/parse/conf_lexer.cc"
yy1774:
	++cur;
#line 740 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFTMTAG); }
#line 9231 "src/parse/conf_lexer.cc"
yy1775:
	++cur;
#line 741 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFTSTAG); }
#line 9236 "src/parse/conf_lexer.cc"
yy1776:
	yych = *++cur;
	if (yych <= 'f') {
		if (yych == 'e') goto yy1843;
		goto yy1463;
	} else {
		if (yych <= 'g') goto yy1844;
		if (yych == 'l') goto yy1845;
		goto yy1463;
	}
yy1777:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1778;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1778;
		if (yych <= 'z') goto yy1462;
	}
yy1778:
#line 602 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_assign); }
#line 9259 "src/parse/conf_lexer.cc"
yy1779:
	yych = *++cur;
	if (yych == 'd') goto yy1846;
	goto yy1463;
yy1780:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1781;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1781;
		if (yych <= 'z') goto yy1462;
	}
yy1781:
#line 603 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_eq); }
#line 9276 "src/parse/conf_lexer.cc"
yy1782:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1783;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1783;
		if (yych <= 'z') goto yy1462;
	}
yy1783:
#line 608 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_ge); }
#line 9289 "src/parse/conf_lexer.cc"
yy1784:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1785;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1785;
		if (yych <= 'z') goto yy1462;
	}
yy1785:
#line 606 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_gt); }
#line 9302 "src/parse/conf_lexer.cc"
yy1786:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1787;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1787;
		if (yych <= 'z') goto yy1462;
	}
yy1787:
#line 607 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_le); }
#line 9315 "src/parse/conf_lexer.cc"
yy1788:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1789;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1789;
		if (yych <= 'z') goto yy1462;
	}
yy1789:
#line 605 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_lt); }
#line 9328 "src/parse/conf_lexer.cc"
yy1790:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1791;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1791;
		if (yych <= 'z') goto yy1462;
	}
yy1791:
#line 604 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_ne); }
#line 9341 "src/parse/conf_lexer.cc"
yy1792:
	yych = *++cur;
	if (yych == 'g') goto yy1847;
	if (yych == 'l') goto yy1848;
	goto yy1463;
yy1793:
	yych = *++cur;
	if (yych == 'u') goto yy1849;
	goto yy1463;
yy1794:
	yych = *++cur;
	if (yych == 'l') goto yy1850;
	goto yy1463;
yy1795:
	yych = *++cur;
	if (yych == 'p') goto yy1851;
	goto yy1463;
yy1796:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1797;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1797;
		if (yych <= 'z') goto yy1462;
	}
yy1797:
#line 625 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fncall); }
#line 9371 "src/parse/conf_lexer.cc"
yy1798:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1799;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1799;
		if (yych <= 'z') goto yy1462;
	}
yy1799:
#line 623 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fndecl); }
#line 9384 "src/parse/conf_lexer.cc"
yy1800:
	yych = *++cur;
	if (yych == 'n') goto yy1852;
	goto yy1463;
yy1801:
	yych = *++cur;
	if (yych == 'n') goto yy1853;
	goto yy1463;
yy1802:
	yych = *++cur;
	if (yych == 'i') goto yy1854;
	goto yy1463;
yy1803:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1804;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy1855;
		if (yych <= '`') goto yy1804;
		if (yych <= 'z') goto yy1462;
	}
yy1804:
#line 611 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch); }
#line 9410 "src/parse/conf_lexer.cc"
yy1805:
	yych = *++cur;
	if (yych == 'l') goto yy1856;
	goto yy1463;
yy1806:
	yych = *++cur;
	if (yych == 'n') goto yy1857;
	goto yy1463;
yy1807:
	yych = *++cur;
	if (yych == 'i') goto yy1858;
	goto yy1463;
yy1808:
	yych = *++cur;
	if (yych == 'y') goto yy1859;
	goto yy1463;
yy1809:
	yych = *++cur;
	if (yych == 'o') goto yy1860;
	goto yy1463;
yy1810:
	yych = *++cur;
	if (yych == 'c') goto yy1861;
	goto yy1463;
yy1811:
	yych = *++cur;
	if (yych == 'u') goto yy1862;
	goto yy1463;
yy1812:
	yych = *++cur;
	if (yych == 'i') goto yy1863;
	goto yy1463;
yy1813:
	yych = *++cur;
	if (yych == 'a') goto yy1864;
	goto yy1463;
yy1814:
	yych = *++cur;
	if (yych == 'm') goto yy1865;
	if (yych == 's') goto yy1866;
	goto yy1463;
yy1815:
	yych = *++cur;
	if (yych == 'g') goto yy1867;
	goto yy1463;
yy1816:
	yych = *++cur;
	if (yych == 'c') goto yy1869;
	goto yy1463;
yy1817:
	yych = *++cur;
	if (yych == 'o') goto yy1870;
	goto yy1463;
yy1818:
	yych = *++cur;
	if (yych == 't') goto yy1871;
	goto yy1463;
yy1819:
	yych = *++cur;
	if (yych == 't') goto yy1872;
	goto yy1463;
yy1820:
	yych = *++cur;
	if (yych == 'n') goto yy1873;
	if (yych == 'p') goto yy1875;
	goto yy1463;
yy1821:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1822;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy1877;
		if (yych <= '`') goto yy1822;
		if (yych <= 'z') goto yy1462;
	}
yy1822:
#line 632 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yypeek); }
#line 9490 "src/parse/conf_lexer.cc"
yy1823:
	yych = *++cur;
	if (yych == 'o') goto yy1878;
	goto yy1463;
yy1824:
	yych = *++cur;
	if (yych == 'c') goto yy1879;
	goto yy1463;
yy1825:
	yych = *++cur;
	if (yych == 'o') goto yy1880;
	goto yy1463;
yy1826:
	yych = *++cur;
	if (yych == 't') goto yy1881;
	goto yy1463;
yy1827:
	yych = *++cur;
	if (yych == 't') goto yy1882;
	goto yy1463;
yy1828:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1829;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy1883;
		if (yych <= '`') goto yy1829;
		if (yych <= 'z') goto yy1462;
	}
yy1829:
#line 633 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip); }
#line 9524 "src/parse/conf_lexer.cc"
yy1830:
	yych = *++cur;
	if (yych == 'n') goto yy1884;
	if (yych == 'p') goto yy1886;
	goto yy1463;
yy1831:
	yych = *++cur;
	if (yych == 'e') goto yy1888;
	goto yy1463;
yy1832:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 776 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_GENERIC); }
#line 9539 "src/parse/conf_lexer.cc"
yy1833:
	yych = *++cur;
	if (yych == 'r') goto yy1889;
	if (yych == 'u') goto yy1890;
	goto yy1160;
yy1834:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 784 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::CASE_RANGES); }
#line 9550 "src/parse/conf_lexer.cc"
yy1835:
	yych = *++cur;
	if (yych == 'i') goto yy1891;
	goto yy1160;
yy1836:
	yych = *++cur;
	if (yych == 'l') goto yy1892;
	goto yy1160;
yy1837:
	yych = *++cur;
	if (yych <= 'k') {
		if (yych == 'g') goto yy1893;
		goto yy1160;
	} else {
		if (yych <= 'l') goto yy1894;
		if (yych == 'r') goto yy1895;
		goto yy1160;
	}
yy1838:
	yych = *++cur;
	if (yych == 't') goto yy1896;
	goto yy1160;
yy1839:
	yych = *++cur;
	if (yych == 'a') goto yy1897;
	goto yy1160;
yy1840:
	yych = *++cur;
	if (yych == 'l') goto yy1898;
	goto yy1160;
yy1841:
	++cur;
#line 734 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORECTX); }
#line 9585 "src/parse/conf_lexer.cc"
yy1842:
	++cur;
#line 735 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORETAG); }
#line 9590 "src/parse/conf_lexer.cc"
yy1843:
	yych = *++cur;
	if (yych == 'l') goto yy1899;
	goto yy1463;
yy1844:
	yych = *++cur;
	if (yych == 'l') goto yy1900;
	goto yy1463;
yy1845:
	yych = *++cur;
	if (yych == 'o') goto yy1901;
	goto yy1463;
yy1846:
	yych = *++cur;
	if (yych == 'a') goto yy1902;
	goto yy1463;
yy1847:
	yych = *++cur;
	if (yych == 'l') goto yy1903;
	goto yy1463;
yy1848:
	yych = *++cur;
	if (yych == 'o') goto yy1904;
	goto yy1463;
yy1849:
	yych = *++cur;
	if (yych == 'e') goto yy1905;
	goto yy1463;
yy1850:
	yych = *++cur;
	if (yych == 'e') goto yy1907;
	goto yy1463;
yy1851:
	yych = *++cur;
	if (yych == 'r') goto yy1908;
	goto yy1463;
yy1852:
	yych = *++cur;
	if (yych == '_') goto yy1909;
	goto yy1463;
yy1853:
	yych = *++cur;
	if (yych == 'f') goto yy1910;
	goto yy1463;
yy1854:
	yych = *++cur;
	if (yych == 'v') goto yy1911;
	goto yy1463;
yy1855:
	yych = *++cur;
	if (yych == 'c') goto yy1912;
	goto yy1463;
yy1856:
	yych = *++cur;
	if (yych == 'l') goto yy1913;
	goto yy1463;
yy1857:
	yych = *++cur;
	if (yych == 't') goto yy1915;
	goto yy1463;
yy1858:
	yych = *++cur;
	if (yych == 'n') goto yy1917;
	goto yy1463;
yy1859:
	yych = *++cur;
	if (yych <= 'c') {
		if (yych <= 'a') goto yy1463;
		if (yych <= 'b') goto yy1918;
		goto yy1919;
	} else {
		if (yych == 't') goto yy1920;
		goto yy1463;
	}
yy1860:
	yych = *++cur;
	if (yych == 'b') goto yy1921;
	goto yy1463;
yy1861:
	yych = *++cur;
	if (yych == 'a') goto yy1922;
	goto yy1463;
yy1862:
	yych = *++cur;
	if (yych == 'p') goto yy1923;
	goto yy1463;
yy1863:
	yych = *++cur;
	if (yych == 'l') goto yy1925;
	goto yy1463;
yy1864:
	yych = *++cur;
	if (yych == 't') goto yy1926;
	goto yy1463;
yy1865:
	yych = *++cur;
	if (yych == 't') goto yy1927;
	goto yy1463;
yy1866:
	yych = *++cur;
	if (yych == 't') goto yy1928;
	goto yy1463;
yy1867:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1868;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1868;
		if (yych <= 'z') goto yy1462;
	}
yy1868:
#line 631 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yydebug); }
#line 9705 "src/parse/conf_lexer.cc"
yy1869:
	yych = *++cur;
	if (yych == 'c') goto yy1929;
	goto yy1463;
yy1870:
	yych = *++cur;
	if (yych == 'n') goto yy1930;
	goto yy1463;
yy1871:
	yych = *++cur;
	if (yych == 'a') goto yy1931;
	goto yy1463;
yy1872:
	yych = *++cur;
	if (yych == 'h') goto yy1932;
	goto yy1463;
yy1873:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1874;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1874;
		if (yych <= 'z') goto yy1462;
	}
yy1874:
#line 643 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yymtagn); }
#line 9734 "src/parse/conf_lexer.cc"
yy1875:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1876;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1876;
		if (yych <= 'z') goto yy1462;
	}
yy1876:
#line 645 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yymtagp); }
#line 9747 "src/parse/conf_lexer.cc"
yy1877:
	yych = *++cur;
	if (yych == 'y') goto yy1933;
	goto yy1463;
yy1878:
	yych = *++cur;
	if (yych == 'r') goto yy1934;
	goto yy1463;
yy1879:
	yych = *++cur;
	if (yych == 'c') goto yy1935;
	goto yy1463;
yy1880:
	yych = *++cur;
	if (yych == 'n') goto yy1936;
	goto yy1463;
yy1881:
	yych = *++cur;
	if (yych == 'a') goto yy1937;
	goto yy1463;
yy1882:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1462;
		} else {
			if (yych == '_') goto yy1462;
		}
	} else {
		if (yych <= 'r') {
			if (yych == 'm') goto yy1938;
			goto yy1462;
		} else {
			if (yych <= 's') goto yy1939;
			if (yych <= 'z') goto yy1462;
		}
	}
#line 639 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshift); }
#line 9787 "src/parse/conf_lexer.cc"
yy1883:
	yych = *++cur;
	if (yych == 'y') goto yy1940;
	goto yy1463;
yy1884:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1885;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1885;
		if (yych <= 'z') goto yy1462;
	}
yy1885:
#line 642 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yystagn); }
#line 9804 "src/parse/conf_lexer.cc"
yy1886:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1887;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1887;
		if (yych <= 'z') goto yy1462;
	}
yy1887:
#line 644 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yystagp); }
#line 9817 "src/parse/conf_lexer.cc"
yy1888:
	yych = *++cur;
	if (yych == 't') goto yy1941;
	goto yy1463;
yy1889:
	yych = *++cur;
	if (yych == 'e') goto yy1942;
	goto yy1160;
yy1890:
	yych = *++cur;
	if (yych == 'n') goto yy1943;
	goto yy1160;
yy1891:
	yych = *++cur;
	if (yych == 'v') goto yy1944;
	goto yy1160;
yy1892:
	yych = *++cur;
	if (yych == 's') goto yy1945;
	goto yy1160;
yy1893:
	yych = *++cur;
	if (yych == 'o') goto yy1946;
	goto yy1160;
yy1894:
	yych = *++cur;
	if (yych == 'o') goto yy1947;
	goto yy1160;
yy1895:
	yych = *++cur;
	if (yych == 'e') goto yy1948;
	goto yy1160;
yy1896:
	yych = *++cur;
	if (yych == 'i') goto yy1949;
	goto yy1160;
yy1897:
	yych = *++cur;
	if (yych == 't') goto yy1950;
	goto yy1160;
yy1898:
	yych = *++cur;
	if (yych == 'e') goto yy1951;
	goto yy1160;
yy1899:
	yych = *++cur;
	if (yych == 'e') goto yy1952;
	goto yy1463;
yy1900:
	yych = *++cur;
	if (yych == 'o') goto yy1953;
	goto yy1463;
yy1901:
	yych = *++cur;
	if (yych == 'c') goto yy1954;
	goto yy1463;
yy1902:
	yych = *++cur;
	if (yych == 't') goto yy1955;
	goto yy1463;
yy1903:
	yych = *++cur;
	if (yych == 'o') goto yy1956;
	goto yy1463;
yy1904:
	yych = *++cur;
	if (yych == 'c') goto yy1957;
	goto yy1463;
yy1905:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1906;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1906;
		if (yych <= 'z') goto yy1462;
	}
yy1906:
#line 617 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_continue); }
#line 9898 "src/parse/conf_lexer.cc"
yy1907:
	yych = *++cur;
	if (yych == 'm') goto yy1958;
	goto yy1463;
yy1908:
	yych = *++cur;
	if (yych == 'i') goto yy1960;
	goto yy1463;
yy1909:
	yych = *++cur;
	if (yych == 'e') goto yy1961;
	goto yy1463;
yy1910:
	yych = *++cur;
	if (yych == 'o') goto yy1962;
	goto yy1463;
yy1911:
	yych = *++cur;
	if (yych == 'e') goto yy1964;
	goto yy1463;
yy1912:
	yych = *++cur;
	if (yych == 'a') goto yy1965;
	goto yy1463;
yy1913:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1914;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1914;
		if (yych <= 'z') goto yy1462;
	}
yy1914:
#line 626 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_tailcall); }
#line 9935 "src/parse/conf_lexer.cc"
yy1915:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1916;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1916;
		if (yych <= 'z') goto yy1462;
	}
yy1916:
#line 597 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_int); }
#line 9948 "src/parse/conf_lexer.cc"
yy1917:
	yych = *++cur;
	if (yych == 't') goto yy1966;
	goto yy1463;
yy1918:
	yych = *++cur;
	if (yych == 'm') goto yy1968;
	goto yy1463;
yy1919:
	yych = *++cur;
	if (yych == 't') goto yy1970;
	goto yy1463;
yy1920:
	yych = *++cur;
	if (yych == 'a') goto yy1971;
	goto yy1463;
yy1921:
	yych = *++cur;
	if (yych == 'a') goto yy1972;
	goto yy1463;
yy1922:
	yych = *++cur;
	if (yych == 'l') goto yy1973;
	goto yy1463;
yy1923:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= '/') goto yy1924;
		if (yych <= '9') goto yy1462;
		if (yych >= '_') goto yy1975;
	} else {
		if (yych <= 'b') {
			if (yych >= 'a') goto yy1462;
		} else {
			if (yych <= 'c') goto yy1976;
			if (yych <= 'z') goto yy1462;
		}
	}
yy1924:
#line 634 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup); }
#line 9990 "src/parse/conf_lexer.cc"
yy1925:
	yych = *++cur;
	if (yych == 't') goto yy1977;
	goto yy1463;
yy1926:
	yych = *++cur;
	if (yych == 'c') goto yy1978;
	goto yy1463;
yy1927:
	yych = *++cur;
	if (yych == 'a') goto yy1979;
	goto yy1463;
yy1928:
	yych = *++cur;
	if (yych == 'a') goto yy1980;
	goto yy1463;
yy1929:
	yych = *++cur;
	if (yych == 'e') goto yy1981;
	goto yy1463;
yy1930:
	yych = *++cur;
	if (yych == 'd') goto yy1982;
	goto yy1463;
yy1931:
	yych = *++cur;
	if (yych == 't') goto yy1984;
	goto yy1463;
yy1932:
	yych = *++cur;
	if (yych == 'a') goto yy1985;
	goto yy1463;
yy1933:
	yych = *++cur;
	if (yych == 'y') goto yy1986;
	goto yy1463;
yy1934:
	yych = *++cur;
	if (yych == 'e') goto yy1987;
	goto yy1463;
yy1935:
	yych = *++cur;
	if (yych == 'e') goto yy1988;
	goto yy1463;
yy1936:
	yych = *++cur;
	if (yych == 'd') goto yy1989;
	goto yy1463;
yy1937:
	yych = *++cur;
	if (yych == 't') goto yy1991;
	goto yy1463;
yy1938:
	yych = *++cur;
	if (yych == 't') goto yy1992;
	goto yy1463;
yy1939:
	yych = *++cur;
	if (yych == 't') goto yy1993;
	goto yy1463;
yy1940:
	yych = *++cur;
	if (yych == 'y') goto yy1994;
	goto yy1463;
yy1941:
	yych = *++cur;
	if (yych == '_') goto yy1995;
	goto yy1463;
yy1942:
	yych = *++cur;
	if (yych == 'e') goto yy1996;
	goto yy1160;
yy1943:
	yych = *++cur;
	if (yych == 'c') goto yy1997;
	goto yy1160;
yy1944:
	yych = *++cur;
	if (yych == 'e') goto yy1998;
	goto yy1160;
yy1945:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 797 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::CHAR_LITERALS); }
#line 10076 "src/parse/conf_lexer.cc"
yy1946:
	yych = *++cur;
	if (yych == 't') goto yy1999;
	goto yy1160;
yy1947:
	yych = *++cur;
	if (yych == 'o') goto yy2000;
	goto yy1160;
yy1948:
	yych = *++cur;
	if (yych == 'c') goto yy2001;
	goto yy1160;
yy1949:
	yych = *++cur;
	if (yych == 'o') goto yy2002;
	goto yy1160;
yy1950:
	yych = *++cur;
	if (yych == 'e') goto yy2003;
	goto yy1160;
yy1951:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 789 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::FILL_ENABLE); }
#line 10102 "src/parse/conf_lexer.cc"
yy1952:
	yych = *++cur;
	if (yych == 'm') goto yy2004;
	goto yy1463;
yy1953:
	yych = *++cur;
	if (yych == 'b') goto yy2006;
	goto yy1463;
yy1954:
	yych = *++cur;
	if (yych == 'a') goto yy2007;
	goto yy1463;
yy1955:
	yych = *++cur;
	if (yych == 'a') goto yy2008;
	goto yy1463;
yy1956:
	yych = *++cur;
	if (yych == 'b') goto yy2010;
	goto yy1463;
yy1957:
	yych = *++cur;
	if (yych == 'a') goto yy2011;
	goto yy1463;
yy1958:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1959;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1959;
		if (yych <= 'z') goto yy1462;
	}
yy1959:
#line 622 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_enum_elem); }
#line 10139 "src/parse/conf_lexer.cc"
yy1960:
	yych = *++cur;
	if (yych == 'n') goto yy2012;
	goto yy1463;
yy1961:
	yych = *++cur;
	if (yych == 'l') goto yy2013;
	goto yy1463;
yy1962:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1963;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1963;
		if (yych <= 'z') goto yy1462;
	}
yy1963:
#line 629 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_line_info); }
#line 10160 "src/parse/conf_lexer.cc"
yy1964:
	yych = *++cur;
	if (yych == '_') goto yy2014;
	goto yy1463;
yy1965:
	yych = *++cur;
	if (yych == 's') goto yy2015;
	goto yy1463;
yy1966:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1967;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1967;
		if (yych <= 'z') goto yy1462;
	}
yy1967:
#line 598 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_uint); }
#line 10181 "src/parse/conf_lexer.cc"
yy1968:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1969;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1969;
		if (yych <= 'z') goto yy1462;
	}
yy1969:
#line 599 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_yybm); }
#line 10194 "src/parse/conf_lexer.cc"
yy1970:
	yych = *++cur;
	if (yych == 'a') goto yy2016;
	goto yy1463;
yy1971:
	yych = *++cur;
	if (yych == 'r') goto yy2017;
	goto yy1463;
yy1972:
	yych = *++cur;
	if (yych == 'l') goto yy2018;
	goto yy1463;
yy1973:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1974;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1974;
		if (yych <= 'z') goto yy1462;
	}
yy1974:
#line 590 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_var_local); }
#line 10219 "src/parse/conf_lexer.cc"
yy1975:
	yych = *++cur;
	if (yych == 'y') goto yy2020;
	goto yy1463;
yy1976:
	yych = *++cur;
	if (yych == 't') goto yy2021;
	goto yy1463;
yy1977:
	yych = *++cur;
	if (yych == 'e') goto yy2022;
	goto yy1463;
yy1978:
	yych = *++cur;
	if (yych == 'h') goto yy2023;
	goto yy1463;
yy1979:
	yych = *++cur;
	if (yych == 'g') goto yy2025;
	goto yy1463;
yy1980:
	yych = *++cur;
	if (yych == 'g') goto yy2027;
	goto yy1463;
yy1981:
	yych = *++cur;
	if (yych == 'p') goto yy2029;
	goto yy1463;
yy1982:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1983;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1983;
		if (yych <= 'z') goto yy1462;
	}
yy1983:
#line 657 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetcond); }
#line 10260 "src/parse/conf_lexer.cc"
yy1984:
	yych = *++cur;
	if (yych == 'e') goto yy2030;
	goto yy1463;
yy1985:
	yych = *++cur;
	if (yych == 'n') goto yy2032;
	goto yy1463;
yy1986:
	yych = *++cur;
	if (yych == 's') goto yy2034;
	goto yy1463;
yy1987:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1462;
		} else {
			if (yych == '_') goto yy1462;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'c') goto yy2035;
			goto yy1462;
		} else {
			if (yych <= 't') goto yy2036;
			if (yych <= 'z') goto yy1462;
		}
	}
#line 636 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestore); }
#line 10292 "src/parse/conf_lexer.cc"
yy1988:
	yych = *++cur;
	if (yych == 'p') goto yy2037;
	goto yy1463;
yy1989:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1990;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy1990;
		if (yych <= 'z') goto yy1462;
	}
yy1990:
#line 658 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetcond); }
#line 10309 "src/parse/conf_lexer.cc"
yy1991:
	yych = *++cur;
	if (yych == 'e') goto yy2038;
	goto yy1463;
yy1992:
	yych = *++cur;
	if (yych == 'a') goto yy2040;
	goto yy1463;
yy1993:
	yych = *++cur;
	if (yych == 'a') goto yy2041;
	goto yy1463;
yy1994:
	yych = *++cur;
	if (yych == 'b') goto yy2042;
	if (yych == 'p') goto yy2043;
	goto yy1463;
yy1995:
	yych = *++cur;
	if (yych == 'f') goto yy2044;
	goto yy1463;
yy1996:
	yych = *++cur;
	if (yych == 'f') goto yy2045;
	goto yy1160;
yy1997:
	yych = *++cur;
	if (yych == 't') goto yy2046;
	goto yy1160;
yy1998:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 788 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::CGOTO_RELATIVE); }
#line 10344 "src/parse/conf_lexer.cc"
yy1999:
	yych = *++cur;
	if (yych == 'o') goto yy2047;
	goto yy1160;
yy2000:
	yych = *++cur;
	if (yych == 'p') goto yy2048;
	goto yy1160;
yy2001:
	yych = *++cur;
	if (yych == 'u') goto yy2049;
	goto yy1160;
yy2002:
	yych = *++cur;
	if (yych == 'n') goto yy2050;
	goto yy1160;
yy2003:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 781 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::STORABLE_STATE); }
#line 10366 "src/parse/conf_lexer.cc"
yy2004:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2005;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2005;
		if (yych <= 'z') goto yy1462;
	}
yy2005:
#line 596 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_elem); }
#line 10379 "src/parse/conf_lexer.cc"
yy2006:
	yych = *++cur;
	if (yych == 'a') goto yy2051;
	goto yy1463;
yy2007:
	yych = *++cur;
	if (yych == 'l') goto yy2052;
	goto yy1463;
yy2008:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2009;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2009;
		if (yych <= 'z') goto yy1462;
	}
yy2009:
#line 620 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cgoto_data); }
#line 10400 "src/parse/conf_lexer.cc"
yy2010:
	yych = *++cur;
	if (yych == 'a') goto yy2054;
	goto yy1463;
yy2011:
	yych = *++cur;
	if (yych == 'l') goto yy2055;
	goto yy1463;
yy2012:
	yych = *++cur;
	if (yych == 't') goto yy2057;
	goto yy1463;
yy2013:
	yych = *++cur;
	if (yych == 's') goto yy2059;
	goto yy1463;
yy2014:
	yych = *++cur;
	if (yych == 'f') goto yy2060;
	goto yy1463;
yy2015:
	yych = *++cur;
	if (yych == 'e') goto yy2061;
	goto yy1463;
yy2016:
	yych = *++cur;
	if (yych == 'b') goto yy2062;
	goto yy1463;
yy2017:
	yych = *++cur;
	if (yych == 'g') goto yy2063;
	goto yy1463;
yy2018:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2019;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2019;
		if (yych <= 'z') goto yy1462;
	}
yy2019:
#line 591 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_var_global); }
#line 10445 "src/parse/conf_lexer.cc"
yy2020:
	yych = *++cur;
	if (yych == 'y') goto yy2064;
	goto yy1463;
yy2021:
	yych = *++cur;
	if (yych == 'x') goto yy2065;
	goto yy1463;
yy2022:
	yych = *++cur;
	if (yych == 'r') goto yy2067;
	goto yy1463;
yy2023:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2024;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2024;
		if (yych <= 'z') goto yy1462;
	}
yy2024:
#line 664 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybm_match); }
#line 10470 "src/parse/conf_lexer.cc"
yy2025:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2026;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2026;
		if (yych <= 'z') goto yy1462;
	}
yy2026:
#line 646 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yycopymtag); }
#line 10483 "src/parse/conf_lexer.cc"
yy2027:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2028;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2028;
		if (yych <= 'z') goto yy1462;
	}
yy2028:
#line 647 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yycopystag); }
#line 10496 "src/parse/conf_lexer.cc"
yy2029:
	yych = *++cur;
	if (yych == 't') goto yy2069;
	goto yy1463;
yy2030:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2031;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2031;
		if (yych <= 'z') goto yy1462;
	}
yy2031:
#line 659 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetstate); }
#line 10513 "src/parse/conf_lexer.cc"
yy2032:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2033;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2033;
		if (yych <= 'z') goto yy1462;
	}
yy2033:
#line 661 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yylessthan); }
#line 10526 "src/parse/conf_lexer.cc"
yy2034:
	yych = *++cur;
	if (yych == 'k') goto yy2071;
	goto yy1463;
yy2035:
	yych = *++cur;
	if (yych == 't') goto yy2072;
	goto yy1463;
yy2036:
	yych = *++cur;
	if (yych == 'a') goto yy2073;
	goto yy1463;
yy2037:
	yych = *++cur;
	if (yych == 't') goto yy2074;
	goto yy1463;
yy2038:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2039;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2039;
		if (yych <= 'z') goto yy1462;
	}
yy2039:
#line 660 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetstate); }
#line 10555 "src/parse/conf_lexer.cc"
yy2040:
	yych = *++cur;
	if (yych == 'g') goto yy2076;
	goto yy1463;
yy2041:
	yych = *++cur;
	if (yych == 'g') goto yy2078;
	goto yy1463;
yy2042:
	yych = *++cur;
	if (yych == 'a') goto yy2080;
	goto yy1463;
yy2043:
	yych = *++cur;
	if (yych == 'e') goto yy2081;
	goto yy1463;
yy2044:
	yych = *++cur;
	if (yych == 'i') goto yy2082;
	goto yy1463;
yy2045:
	yych = *++cur;
	if (yych == 'o') goto yy2083;
	goto yy1160;
yy2046:
	yych = *++cur;
	if (yych == 'i') goto yy2084;
	goto yy1160;
yy2047:
	yych = *++cur;
	if (yych == '_') goto yy2085;
	goto yy1160;
yy2048:
	yych = *++cur;
	if (yych == '_') goto yy2086;
	goto yy1160;
yy2049:
	yych = *++cur;
	if (yych == 'r') goto yy2087;
	goto yy1160;
yy2050:
	yych = *++cur;
	if (yych == 's') goto yy2088;
	goto yy1160;
yy2051:
	yych = *++cur;
	if (yych == 'l') goto yy2089;
	goto yy1463;
yy2052:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2053;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2053;
		if (yych <= 'z') goto yy1462;
	}
yy2053:
#line 594 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_local); }
#line 10616 "src/parse/conf_lexer.cc"
yy2054:
	yych = *++cur;
	if (yych == 'l') goto yy2091;
	goto yy1463;
yy2055:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2056;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2056;
		if (yych <= 'z') goto yy1462;
	}
yy2056:
#line 592 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_const_local); }
#line 10633 "src/parse/conf_lexer.cc"
yy2057:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2058;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2058;
		if (yych <= 'z') goto yy1462;
	}
yy2058:
#line 628 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fingerprint); }
#line 10646 "src/parse/conf_lexer.cc"
yy2059:
	yych = *++cur;
	if (yych == 'e') goto yy2093;
	goto yy1463;
yy2060:
	yych = *++cur;
	if (yych == 'u') goto yy2095;
	goto yy1463;
yy2061:
	yych = *++cur;
	if (yych == '_') goto yy2096;
	if (yych == 's') goto yy2097;
	goto yy1463;
yy2062:
	yych = *++cur;
	if (yych == 'l') goto yy2099;
	goto yy1463;
yy2063:
	yych = *++cur;
	if (yych == 'e') goto yy2100;
	goto yy1463;
yy2064:
	yych = *++cur;
	if (yych == 'p') goto yy2101;
	if (yych == 's') goto yy2102;
	goto yy1463;
yy2065:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2066;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2066;
		if (yych <= 'z') goto yy1462;
	}
yy2066:
#line 635 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackupctx); }
#line 10685 "src/parse/conf_lexer.cc"
yy2067:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2068;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2068;
		if (yych <= 'z') goto yy1462;
	}
yy2068:
#line 663 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybm_filter); }
#line 10698 "src/parse/conf_lexer.cc"
yy2069:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2070;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2070;
		if (yych <= 'z') goto yy1462;
	}
yy2070:
#line 655 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetaccept); }
#line 10711 "src/parse/conf_lexer.cc"
yy2071:
	yych = *++cur;
	if (yych == 'i') goto yy2103;
	goto yy1463;
yy2072:
	yych = *++cur;
	if (yych == 'x') goto yy2104;
	goto yy1463;
yy2073:
	yych = *++cur;
	if (yych == 'g') goto yy2106;
	goto yy1463;
yy2074:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2075;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2075;
		if (yych <= 'z') goto yy1462;
	}
yy2075:
#line 656 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetaccept); }
#line 10736 "src/parse/conf_lexer.cc"
yy2076:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2077;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2077;
		if (yych <= 'z') goto yy1462;
	}
yy2077:
#line 640 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshiftmtag); }
#line 10749 "src/parse/conf_lexer.cc"
yy2078:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2079;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2079;
		if (yych <= 'z') goto yy1462;
	}
yy2079:
#line 641 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshiftstag); }
#line 10762 "src/parse/conf_lexer.cc"
yy2080:
	yych = *++cur;
	if (yych == 'c') goto yy2108;
	goto yy1463;
yy2081:
	yych = *++cur;
	if (yych == 'e') goto yy2109;
	goto yy1463;
yy2082:
	yych = *++cur;
	if (yych == 'l') goto yy2110;
	goto yy1463;
yy2083:
	yych = *++cur;
	if (yych == 'r') goto yy2111;
	goto yy1160;
yy2084:
	yych = *++cur;
	if (yych == 'o') goto yy2112;
	goto yy1160;
yy2085:
	yych = *++cur;
	if (yych == 'l') goto yy2113;
	goto yy1160;
yy2086:
	yych = *++cur;
	if (yych == 's') goto yy2114;
	goto yy1160;
yy2087:
	yych = *++cur;
	if (yych == 's') goto yy2115;
	goto yy1160;
yy2088:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 780 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::START_CONDITIONS); }
#line 10800 "src/parse/conf_lexer.cc"
yy2089:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2090;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2090;
		if (yych <= 'z') goto yy1462;
	}
yy2090:
#line 595 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_global); }
#line 10813 "src/parse/conf_lexer.cc"
yy2091:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2092;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2092;
		if (yych <= 'z') goto yy1462;
	}
yy2092:
#line 593 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_const_global); }
#line 10826 "src/parse/conf_lexer.cc"
yy2093:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2094;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy2116;
		if (yych <= '`') goto yy2094;
		if (yych <= 'z') goto yy1462;
	}
yy2094:
#line 609 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_if_then_else); }
#line 10840 "src/parse/conf_lexer.cc"
yy2095:
	yych = *++cur;
	if (yych == 'n') goto yy2117;
	goto yy1463;
yy2096:
	yych = *++cur;
	if (yych == 'd') goto yy2118;
	if (yych == 'r') goto yy2119;
	goto yy1463;
yy2097:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2098;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy2120;
		if (yych <= '`') goto yy2098;
		if (yych <= 'z') goto yy1462;
	}
yy2098:
#line 612 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_cases); }
#line 10863 "src/parse/conf_lexer.cc"
yy2099:
	yych = *++cur;
	if (yych == 'e') goto yy2121;
	goto yy1463;
yy2100:
	yych = *++cur;
	if (yych == 't') goto yy2123;
	goto yy1463;
yy2101:
	yych = *++cur;
	if (yych == 'e') goto yy2125;
	goto yy1463;
yy2102:
	yych = *++cur;
	if (yych == 'k') goto yy2126;
	goto yy1463;
yy2103:
	yych = *++cur;
	if (yych == 'p') goto yy2127;
	goto yy1463;
yy2104:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2105;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2105;
		if (yych <= 'z') goto yy1462;
	}
yy2105:
#line 637 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestorectx); }
#line 10896 "src/parse/conf_lexer.cc"
yy2106:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2107;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2107;
		if (yych <= 'z') goto yy1462;
	}
yy2107:
#line 638 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestoretag); }
#line 10909 "src/parse/conf_lexer.cc"
yy2108:
	yych = *++cur;
	if (yych == 'k') goto yy2129;
	goto yy1463;
yy2109:
	yych = *++cur;
	if (yych == 'k') goto yy2130;
	goto yy1463;
yy2110:
	yych = *++cur;
	if (yych == 't') goto yy2132;
	goto yy1463;
yy2111:
	yych = *++cur;
	if (yych == 'm') goto yy2133;
	goto yy1160;
yy2112:
	yych = *++cur;
	if (yych == 'n') goto yy2134;
	goto yy1160;
yy2113:
	yych = *++cur;
	if (yych == 'a') goto yy2135;
	goto yy1160;
yy2114:
	yych = *++cur;
	if (yych == 'w') goto yy2136;
	goto yy1160;
yy2115:
	yych = *++cur;
	if (yych == 'i') goto yy2137;
	goto yy1160;
yy2116:
	yych = *++cur;
	if (yych == 'o') goto yy2138;
	goto yy1463;
yy2117:
	yych = *++cur;
	if (yych == 'c') goto yy2139;
	goto yy1463;
yy2118:
	yych = *++cur;
	if (yych == 'e') goto yy2140;
	goto yy1463;
yy2119:
	yych = *++cur;
	if (yych == 'a') goto yy2141;
	goto yy1463;
yy2120:
	yych = *++cur;
	if (yych == 'o') goto yy2142;
	goto yy1463;
yy2121:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2122;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2122;
		if (yych <= 'z') goto yy1462;
	}
yy2122:
#line 601 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_yyctable); }
#line 10974 "src/parse/conf_lexer.cc"
yy2123:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2124;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2124;
		if (yych <= 'z') goto yy1462;
	}
yy2124:
#line 600 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_yytarget); }
#line 10987 "src/parse/conf_lexer.cc"
yy2125:
	yych = *++cur;
	if (yych == 'e') goto yy2143;
	goto yy1463;
yy2126:
	yych = *++cur;
	if (yych == 'i') goto yy2144;
	goto yy1463;
yy2127:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2128;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2128;
		if (yych <= 'z') goto yy1462;
	}
yy2128:
#line 649 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yypeek_yyskip); }
#line 11008 "src/parse/conf_lexer.cc"
yy2129:
	yych = *++cur;
	if (yych == 'u') goto yy2145;
	goto yy1463;
yy2130:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2131;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2131;
		if (yych <= 'z') goto yy1462;
	}
yy2131:
#line 648 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yypeek); }
#line 11025 "src/parse/conf_lexer.cc"
yy2132:
	yych = *++cur;
	if (yych == 'e') goto yy2146;
	goto yy1463;
yy2133:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 779 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_STYLE_FREEFORM); }
#line 11035 "src/parse/conf_lexer.cc"
yy2134:
	yych = *++cur;
	if (yych == 's') goto yy2147;
	goto yy1160;
yy2135:
	yych = *++cur;
	if (yych == 'b') goto yy2148;
	goto yy1160;
yy2136:
	yych = *++cur;
	if (yych == 'i') goto yy2149;
	goto yy1160;
yy2137:
	yych = *++cur;
	if (yych == 'v') goto yy2150;
	goto yy1160;
yy2138:
	yych = *++cur;
	if (yych == 'n') goto yy2151;
	goto yy1463;
yy2139:
	yych = *++cur;
	if (yych == 't') goto yy2152;
	goto yy1463;
yy2140:
	yych = *++cur;
	if (yych == 'f') goto yy2153;
	goto yy1463;
yy2141:
	yych = *++cur;
	if (yych == 'n') goto yy2154;
	goto yy1463;
yy2142:
	yych = *++cur;
	if (yych == 'n') goto yy2155;
	goto yy1463;
yy2143:
	yych = *++cur;
	if (yych == 'k') goto yy2156;
	goto yy1463;
yy2144:
	yych = *++cur;
	if (yych == 'p') goto yy2158;
	goto yy1463;
yy2145:
	yych = *++cur;
	if (yych == 'p') goto yy2160;
	goto yy1463;
yy2146:
	yych = *++cur;
	if (yych == 'r') goto yy2162;
	goto yy1463;
yy2147:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 778 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_STYLE_FUNCTIONS); }
#line 11093 "src/parse/conf_lexer.cc"
yy2148:
	yych = *++cur;
	if (yych == 'e') goto yy2164;
	goto yy1160;
yy2149:
	yych = *++cur;
	if (yych == 't') goto yy2165;
	goto yy1160;
yy2150:
	yych = *++cur;
	if (yych == 'e') goto yy2166;
	goto yy1160;
yy2151:
	yych = *++cur;
	if (yych == 'e') goto yy2167;
	goto yy1463;
yy2152:
	yych = *++cur;
	if (yych == 'i') goto yy2168;
	goto yy1463;
yy2153:
	yych = *++cur;
	if (yych == 'a') goto yy2169;
	goto yy1463;
yy2154:
	yych = *++cur;
	if (yych == 'g') goto yy2170;
	goto yy1463;
yy2155:
	yych = *++cur;
	if (yych == 'e') goto yy2171;
	goto yy1463;
yy2156:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2157;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy2172;
		if (yych <= '`') goto yy2157;
		if (yych <= 'z') goto yy1462;
	}
yy2157:
#line 652 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yypeek); }
#line 11139 "src/parse/conf_lexer.cc"
yy2158:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2159;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2159;
		if (yych <= 'z') goto yy1462;
	}
yy2159:
#line 651 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yyskip); }
#line 11152 "src/parse/conf_lexer.cc"
yy2160:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2161;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych <= '_') goto yy2173;
		if (yych <= '`') goto yy2161;
		if (yych <= 'z') goto yy1462;
	}
yy2161:
#line 650 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yybackup); }
#line 11166 "src/parse/conf_lexer.cc"
yy2162:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2163;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2163;
		if (yych <= 'z') goto yy1462;
	}
yy2163:
#line 665 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yytarget_filter); }
#line 11179 "src/parse/conf_lexer.cc"
yy2164:
	yych = *++cur;
	if (yych == 'l') goto yy2174;
	goto yy1160;
yy2165:
	yych = *++cur;
	if (yych == 'c') goto yy2175;
	goto yy1160;
yy2166:
	yych = *++cur;
	if (yych == '_') goto yy2176;
	goto yy1160;
yy2167:
	yych = *++cur;
	if (yych == 'l') goto yy2177;
	goto yy1463;
yy2168:
	yych = *++cur;
	if (yych == 'o') goto yy2178;
	goto yy1463;
yy2169:
	yych = *++cur;
	if (yych == 'u') goto yy2179;
	goto yy1463;
yy2170:
	yych = *++cur;
	if (yych == 'e') goto yy2180;
	goto yy1463;
yy2171:
	yych = *++cur;
	if (yych == 'l') goto yy2182;
	goto yy1463;
yy2172:
	yych = *++cur;
	if (yych == 'y') goto yy2183;
	goto yy1463;
yy2173:
	yych = *++cur;
	if (yych == 'y') goto yy2184;
	goto yy1463;
yy2174:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 763 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::GOTO_LABEL); }
#line 11225 "src/parse/conf_lexer.cc"
yy2175:
	yych = *++cur;
	if (yych == 'h') goto yy2185;
	goto yy1160;
yy2176:
	yych = *++cur;
	if (yych == 'f') goto yy2186;
	goto yy1160;
yy2177:
	yych = *++cur;
	if (yych == 'i') goto yy2187;
	goto yy1463;
yy2178:
	yych = *++cur;
	if (yych == 'n') goto yy2188;
	goto yy1463;
yy2179:
	yych = *++cur;
	if (yych == 'l') goto yy2189;
	goto yy1463;
yy2180:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2181;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2181;
		if (yych <= 'z') goto yy1462;
	}
yy2181:
#line 614 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_case_range); }
#line 11258 "src/parse/conf_lexer.cc"
yy2182:
	yych = *++cur;
	if (yych == 'i') goto yy2190;
	goto yy1463;
yy2183:
	yych = *++cur;
	if (yych == 'y') goto yy2191;
	goto yy1463;
yy2184:
	yych = *++cur;
	if (yych == 'y') goto yy2192;
	goto yy1463;
yy2185:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 764 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::LOOP_SWITCH); }
#line 11276 "src/parse/conf_lexer.cc"
yy2186:
	yych = *++cur;
	if (yych == 'u') goto yy2193;
	goto yy1160;
yy2187:
	yych = *++cur;
	if (yych == 'n') goto yy2194;
	goto yy1463;
yy2188:
	yych = *++cur;
	if (yych == 's') goto yy2195;
	goto yy1463;
yy2189:
	yych = *++cur;
	if (yych == 't') goto yy2197;
	goto yy1463;
yy2190:
	yych = *++cur;
	if (yych == 'n') goto yy2199;
	goto yy1463;
yy2191:
	yych = *++cur;
	if (yych == 's') goto yy2200;
	goto yy1463;
yy2192:
	yych = *++cur;
	if (yych == 'p') goto yy2201;
	goto yy1463;
yy2193:
	yych = *++cur;
	if (yych == 'n') goto yy2202;
	goto yy1160;
yy2194:
	yych = *++cur;
	if (yych == 'e') goto yy2203;
	goto yy1463;
yy2195:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2196;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2196;
		if (yych <= 'z') goto yy1462;
	}
yy2196:
#line 627 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_recursive_functions); }
#line 11325 "src/parse/conf_lexer.cc"
yy2197:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2198;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2198;
		if (yych <= 'z') goto yy1462;
	}
yy2198:
#line 615 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_case_default); }
#line 11338 "src/parse/conf_lexer.cc"
yy2199:
	yych = *++cur;
	if (yych == 'e') goto yy2205;
	goto yy1463;
yy2200:
	yych = *++cur;
	if (yych == 'k') goto yy2207;
	goto yy1463;
yy2201:
	yych = *++cur;
	if (yych == 'e') goto yy2208;
	goto yy1463;
yy2202:
	yych = *++cur;
	if (yych == 'c') goto yy2209;
	goto yy1160;
yy2203:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2204;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2204;
		if (yych <= 'z') goto yy1462;
	}
yy2204:
#line 610 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_if_then_else_oneline); }
#line 11367 "src/parse/conf_lexer.cc"
yy2205:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2206;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2206;
		if (yych <= 'z') goto yy1462;
	}
yy2206:
#line 613 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_cases_oneline); }
#line 11380 "src/parse/conf_lexer.cc"
yy2207:
	yych = *++cur;
	if (yych == 'i') goto yy2210;
	goto yy1463;
yy2208:
	yych = *++cur;
	if (yych == 'e') goto yy2211;
	goto yy1463;
yy2209:
	yych = *++cur;
	if (yych == 't') goto yy2212;
	goto yy1160;
yy2210:
	yych = *++cur;
	if (yych == 'p') goto yy2213;
	goto yy1463;
yy2211:
	yych = *++cur;
	if (yych == 'k') goto yy2215;
	goto yy1463;
yy2212:
	yych = *++cur;
	if (yych == 'i') goto yy2217;
	goto yy1160;
yy2213:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2214;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2214;
		if (yych <= 'z') goto yy1462;
	}
yy2214:
#line 654 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yypeek_yyskip); }
#line 11417 "src/parse/conf_lexer.cc"
yy2215:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2216;
		if (yych <= '9') goto yy1462;
	} else {
		if (yych == '`') goto yy2216;
		if (yych <= 'z') goto yy1462;
	}
yy2216:
#line 653 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yybackup_yypeek); }
#line 11430 "src/parse/conf_lexer.cc"
yy2217:
	yych = *++cur;
	if (yych != 'o') goto yy1160;
	yych = *++cur;
	if (yych != 'n') goto yy1160;
	yych = *++cur;
	if (yych != 's') goto yy1160;
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1159;
#line 765 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::REC_FUNC); }
#line 11442 "src/parse/conf_lexer.cc"
}
#line 816 "../src/parse/conf_lexer.re"


    UNREACHABLE();
    return Ret::FAIL; // unreachable
}

#undef RET_TOK
#undef RET_OPT
#undef RET_GOPT
#undef RET_LOPT
#undef RET_VAR
#undef RET_CODE

#define SAVE_CONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    opts.set_##conf(tmp_bool); \
    goto start; \
} while(0)

#define SAVE_CONF_STR(conf) do { \
    CHECK_RET(lex_conf_string(opts)); \
    opts.set_##conf(tmp_str); \
    goto start; \
} while(0)

#define SAVE_CONF_LIST(conf) do { \
    CHECK_RET(lex_conf_list(opts)); \
    opts.set_##conf(tmp_list); \
    CHECK_RET(opts.check_##conf()); \
    tmp_list.clear(); \
    goto start; \
} while(0)

Ret Input::lex_syntax_file(Opt& opts) {
start:
    tok = cur;
    location = cur_loc();

#line 11483 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 192,   0, 128, 128, 192, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		192, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if ((lim - cur) < 23) YYFILL(23);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy2222;
	if (yych <= 'c') {
		if (yych <= '.') {
			if (yych <= 0x00) goto yy2219;
			if (yych <= 0x08) goto yy2220;
			if (yych <= '\n') goto yy2223;
			goto yy2220;
		} else {
			if (yych <= '/') goto yy2224;
			if (yych <= 'a') goto yy2220;
			if (yych <= 'b') goto yy2225;
			goto yy2226;
		}
	} else {
		if (yych <= 'r') {
			if (yych == 'i') goto yy2227;
			if (yych <= 'q') goto yy2220;
			goto yy2228;
		} else {
			if (yych <= 's') goto yy2229;
			if (yych == 'w') goto yy2230;
			goto yy2220;
		}
	}
yy2219:
	++cur;
#line 854 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 11550 "src/parse/conf_lexer.cc"
yy2220:
	++cur;
yy2221:
#line 882 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_tok("unexpected character: '%c'", cur[-1])); }
#line 11556 "src/parse/conf_lexer.cc"
yy2222:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy2222;
#line 858 "../src/parse/conf_lexer.re"
	{ goto start; }
#line 11564 "src/parse/conf_lexer.cc"
yy2223:
	++cur;
#line 856 "../src/parse/conf_lexer.re"
	{ next_line(); goto start; }
#line 11569 "src/parse/conf_lexer.cc"
yy2224:
	yych = *(mar = ++cur);
	if (yych == '/') goto yy2231;
	goto yy2221;
yy2225:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy2233;
	goto yy2221;
yy2226:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy2234;
	goto yy2221;
yy2227:
	yych = *(mar = ++cur);
	if (yych == 'n') goto yy2235;
	goto yy2221;
yy2228:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy2236;
	goto yy2221;
yy2229:
	yych = *(mar = ++cur);
	switch (yych) {
		case 'e': goto yy2237;
		case 'i': goto yy2238;
		case 'p': goto yy2239;
		case 'u': goto yy2240;
		default: goto yy2221;
	}
yy2230:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy2241;
	goto yy2221;
yy2231:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy2231;
	if (yych >= 0x01) goto yy2223;
yy2232:
	cur = mar;
	goto yy2221;
yy2233:
	yych = *++cur;
	if (yych == 'c') goto yy2242;
	goto yy2232;
yy2234:
	yych = *++cur;
	if (yych == 'd') goto yy2243;
	goto yy2232;
yy2235:
	yych = *++cur;
	if (yych == 'd') goto yy2244;
	goto yy2232;
yy2236:
	yych = *++cur;
	if (yych == '2') goto yy2245;
	goto yy2232;
yy2237:
	yych = *++cur;
	if (yych == 'm') goto yy2246;
	goto yy2232;
yy2238:
	yych = *++cur;
	if (yych == 'n') goto yy2247;
	goto yy2232;
yy2239:
	yych = *++cur;
	if (yych == 'e') goto yy2248;
	goto yy2232;
yy2240:
	yych = *++cur;
	if (yych == 'p') goto yy2249;
	goto yy2232;
yy2241:
	yych = *++cur;
	if (yych == 'a') goto yy2250;
	goto yy2232;
yy2242:
	yych = *++cur;
	if (yych == 'k') goto yy2251;
	goto yy2232;
yy2243:
	yych = *++cur;
	if (yych == 'e') goto yy2252;
	goto yy2232;
yy2244:
	yych = *++cur;
	if (yych == 'e') goto yy2253;
	goto yy2232;
yy2245:
	yych = *++cur;
	if (yych == 'c') goto yy2254;
	goto yy2232;
yy2246:
	yych = *++cur;
	if (yych == 'i') goto yy2255;
	goto yy2232;
yy2247:
	yych = *++cur;
	if (yych == 'g') goto yy2256;
	goto yy2232;
yy2248:
	yych = *++cur;
	if (yych == 'c') goto yy2257;
	goto yy2232;
yy2249:
	yych = *++cur;
	if (yych == 'p') goto yy2258;
	goto yy2232;
yy2250:
	yych = *++cur;
	if (yych == 'p') goto yy2259;
	goto yy2232;
yy2251:
	yych = *++cur;
	if (yych == 't') goto yy2260;
	goto yy2232;
yy2252:
	yych = *++cur;
	if (yych == ':') goto yy2261;
	goto yy2232;
yy2253:
	yych = *++cur;
	if (yych == 'n') goto yy2262;
	goto yy2232;
yy2254:
	yych = *++cur;
	if (yych == ':') goto yy2263;
	goto yy2232;
yy2255:
	yych = *++cur;
	if (yych == 'c') goto yy2264;
	goto yy2232;
yy2256:
	yych = *++cur;
	if (yych == 'l') goto yy2265;
	goto yy2232;
yy2257:
	yych = *++cur;
	if (yych == 'i') goto yy2266;
	goto yy2232;
yy2258:
	yych = *++cur;
	if (yych == 'o') goto yy2267;
	goto yy2232;
yy2259:
	yych = *++cur;
	if (yych == '_') goto yy2268;
	goto yy2232;
yy2260:
	yych = *++cur;
	if (yych == 'i') goto yy2269;
	goto yy2232;
yy2261:
	++cur;
	cur -= 5;
#line 862 "../src/parse/conf_lexer.re"
	{
        allow_raw_nl = false;
        if (conf_parse(*this, opts) != 0) return Ret::FAIL;
        allow_raw_nl = true;
        goto start;
    }
#line 11734 "src/parse/conf_lexer.cc"
yy2262:
	yych = *++cur;
	if (yych == 't') goto yy2270;
	goto yy2232;
yy2263:
	++cur;
#line 860 "../src/parse/conf_lexer.re"
	{ CHECK_RET(lex_conf(opts)); goto start; }
#line 11743 "src/parse/conf_lexer.cc"
yy2264:
	yych = *++cur;
	if (yych == 'o') goto yy2271;
	goto yy2232;
yy2265:
	yych = *++cur;
	if (yych == 'e') goto yy2272;
	goto yy2232;
yy2266:
	yych = *++cur;
	if (yych == 'a') goto yy2273;
	goto yy2232;
yy2267:
	yych = *++cur;
	if (yych == 'r') goto yy2274;
	goto yy2232;
yy2268:
	yych = *++cur;
	if (yych == 'b') goto yy2275;
	goto yy2232;
yy2269:
	yych = *++cur;
	if (yych == 'c') goto yy2276;
	goto yy2232;
yy2270:
	yych = *++cur;
	if (yych == 'a') goto yy2277;
	goto yy2232;
yy2271:
	yych = *++cur;
	if (yych == 'l') goto yy2278;
	goto yy2232;
yy2272:
	yych = *++cur;
	if (yych == '_') goto yy2279;
	goto yy2232;
yy2273:
	yych = *++cur;
	if (yych == 'l') goto yy2280;
	goto yy2232;
yy2274:
	yych = *++cur;
	if (yych == 't') goto yy2281;
	goto yy2232;
yy2275:
	yych = *++cur;
	if (yych == 'l') goto yy2282;
	goto yy2232;
yy2276:
	yych = *++cur;
	if (yych == 'k') goto yy2283;
	goto yy2232;
yy2277:
	yych = *++cur;
	if (yych == 't') goto yy2284;
	goto yy2232;
yy2278:
	yych = *++cur;
	if (yych == 'o') goto yy2285;
	goto yy2232;
yy2279:
	yych = *++cur;
	if (yych == 'q') goto yy2286;
	goto yy2232;
yy2280:
	yych = *++cur;
	if (yych == '_') goto yy2287;
	goto yy2232;
yy2281:
	yych = *++cur;
	if (yych == 'e') goto yy2288;
	goto yy2232;
yy2282:
	yych = *++cur;
	if (yych == 'o') goto yy2289;
	goto yy2232;
yy2283:
	yych = *++cur;
	if (yych == '_') goto yy2290;
	goto yy2232;
yy2284:
	yych = *++cur;
	if (yych == 'i') goto yy2291;
	goto yy2232;
yy2285:
	yych = *++cur;
	if (yych == 'n') goto yy2292;
	goto yy2232;
yy2286:
	yych = *++cur;
	if (yych == 'u') goto yy2293;
	goto yy2232;
yy2287:
	yych = *++cur;
	if (yych == 'e') goto yy2294;
	goto yy2232;
yy2288:
	yych = *++cur;
	if (yych == 'd') goto yy2295;
	goto yy2232;
yy2289:
	yych = *++cur;
	if (yych == 'c') goto yy2296;
	goto yy2232;
yy2290:
	yych = *++cur;
	if (yych == 'q') goto yy2297;
	goto yy2232;
yy2291:
	yych = *++cur;
	if (yych == 'o') goto yy2298;
	goto yy2232;
yy2292:
	yych = *++cur;
	if (yych == 's') goto yy2299;
	goto yy2232;
yy2293:
	yych = *++cur;
	if (yych == 'o') goto yy2300;
	goto yy2232;
yy2294:
	yych = *++cur;
	if (yych == 's') goto yy2301;
	goto yy2232;
yy2295:
	yych = *++cur;
	if (yych == '_') goto yy2302;
	goto yy2232;
yy2296:
	yych = *++cur;
	if (yych == 'k') goto yy2303;
	goto yy2232;
yy2297:
	yych = *++cur;
	if (yych == 'u') goto yy2304;
	goto yy2232;
yy2298:
	yych = *++cur;
	if (yych == 'n') goto yy2305;
	goto yy2232;
yy2299:
	++cur;
#line 875 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(semicolons); }
#line 11888 "src/parse/conf_lexer.cc"
yy2300:
	yych = *++cur;
	if (yych == 't') goto yy2306;
	goto yy2232;
yy2301:
	yych = *++cur;
	if (yych == 'c') goto yy2307;
	goto yy2232;
yy2302:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy2308;
		case 'c': goto yy2309;
		case 'f': goto yy2310;
		case 't': goto yy2311;
		default: goto yy2232;
	}
yy2303:
	yych = *++cur;
	if (yych == 's') goto yy2312;
	goto yy2232;
yy2304:
	yych = *++cur;
	if (yych == 'o') goto yy2313;
	goto yy2232;
yy2305:
	yych = *++cur;
	if (yych == '_') goto yy2314;
	goto yy2232;
yy2306:
	yych = *++cur;
	if (yych == 'e') goto yy2315;
	goto yy2232;
yy2307:
	yych = *++cur;
	if (yych == 'a') goto yy2316;
	goto yy2232;
yy2308:
	yych = *++cur;
	if (yych == 'p') goto yy2317;
	goto yy2232;
yy2309:
	yych = *++cur;
	if (yych == 'o') goto yy2318;
	goto yy2232;
yy2310:
	yych = *++cur;
	if (yych == 'e') goto yy2319;
	goto yy2232;
yy2311:
	yych = *++cur;
	if (yych == 'a') goto yy2320;
	goto yy2232;
yy2312:
	yych = *++cur;
	if (yych == '_') goto yy2321;
	goto yy2232;
yy2313:
	yych = *++cur;
	if (yych == 't') goto yy2322;
	goto yy2232;
yy2314:
	yych = *++cur;
	if (yych == 's') goto yy2323;
	goto yy2232;
yy2315:
	yych = *++cur;
	if (yych == 'd') goto yy2324;
	goto yy2232;
yy2316:
	yych = *++cur;
	if (yych == 'p') goto yy2325;
	goto yy2232;
yy2317:
	yych = *++cur;
	if (yych == 'i') goto yy2326;
	goto yy2232;
yy2318:
	yych = *++cur;
	if (yych == 'd') goto yy2327;
	goto yy2232;
yy2319:
	yych = *++cur;
	if (yych == 'a') goto yy2328;
	goto yy2232;
yy2320:
	yych = *++cur;
	if (yych == 'r') goto yy2329;
	goto yy2232;
yy2321:
	yych = *++cur;
	if (yych == 'i') goto yy2330;
	goto yy2232;
yy2322:
	yych = *++cur;
	if (yych == 'e') goto yy2331;
	goto yy2232;
yy2323:
	yych = *++cur;
	if (yych == 'e') goto yy2332;
	goto yy2232;
yy2324:
	yych = *++cur;
	if (yych == '_') goto yy2333;
	goto yy2232;
yy2325:
	yych = *++cur;
	if (yych == 'e') goto yy2334;
	goto yy2232;
yy2326:
	yych = *++cur;
	if (yych == '_') goto yy2335;
	if (yych == 's') goto yy2336;
	goto yy2232;
yy2327:
	yych = *++cur;
	if (yych == 'e') goto yy2337;
	goto yy2232;
yy2328:
	yych = *++cur;
	if (yych == 't') goto yy2338;
	goto yy2232;
yy2329:
	yych = *++cur;
	if (yych == 'g') goto yy2339;
	goto yy2232;
yy2330:
	yych = *++cur;
	if (yych == 'n') goto yy2340;
	goto yy2232;
yy2331:
	yych = *++cur;
	if (yych == 'd') goto yy2341;
	goto yy2232;
yy2332:
	yych = *++cur;
	if (yych == 'n') goto yy2342;
	goto yy2232;
yy2333:
	yych = *++cur;
	if (yych == 's') goto yy2343;
	goto yy2232;
yy2334:
	yych = *++cur;
	if (yych == 's') goto yy2344;
	goto yy2232;
yy2335:
	yych = *++cur;
	if (yych == 's') goto yy2345;
	goto yy2232;
yy2336:
	++cur;
#line 869 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_apis); }
#line 12043 "src/parse/conf_lexer.cc"
yy2337:
	yych = *++cur;
	if (yych == '_') goto yy2346;
	goto yy2232;
yy2338:
	yych = *++cur;
	if (yych == 'u') goto yy2347;
	goto yy2232;
yy2339:
	yych = *++cur;
	if (yych == 'e') goto yy2348;
	goto yy2232;
yy2340:
	yych = *++cur;
	if (yych == '_') goto yy2349;
	goto yy2232;
yy2341:
	yych = *++cur;
	if (yych == '_') goto yy2350;
	goto yy2232;
yy2342:
	yych = *++cur;
	if (yych == 's') goto yy2351;
	goto yy2232;
yy2343:
	yych = *++cur;
	if (yych == 't') goto yy2352;
	goto yy2232;
yy2344:
	++cur;
#line 880 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_STR(special_escapes); }
#line 12076 "src/parse/conf_lexer.cc"
yy2345:
	yych = *++cur;
	if (yych == 't') goto yy2353;
	goto yy2232;
yy2346:
	yych = *++cur;
	if (yych == 'm') goto yy2354;
	goto yy2232;
yy2347:
	yych = *++cur;
	if (yych == 'r') goto yy2355;
	goto yy2232;
yy2348:
	yych = *++cur;
	if (yych == 't') goto yy2356;
	goto yy2232;
yy2349:
	yych = *++cur;
	if (yych == 'b') goto yy2357;
	goto yy2232;
yy2350:
	yych = *++cur;
	if (yych == 's') goto yy2358;
	goto yy2232;
yy2351:
	yych = *++cur;
	if (yych == 'i') goto yy2359;
	goto yy2232;
yy2352:
	yych = *++cur;
	if (yych == 'r') goto yy2360;
	goto yy2232;
yy2353:
	yych = *++cur;
	if (yych == 'y') goto yy2361;
	goto yy2232;
yy2354:
	yych = *++cur;
	if (yych == 'o') goto yy2362;
	goto yy2232;
yy2355:
	yych = *++cur;
	if (yych == 'e') goto yy2363;
	goto yy2232;
yy2356:
	yych = *++cur;
	if (yych == 's') goto yy2364;
	goto yy2232;
yy2357:
	yych = *++cur;
	if (yych == 'r') goto yy2365;
	goto yy2232;
yy2358:
	yych = *++cur;
	if (yych == 't') goto yy2366;
	goto yy2232;
yy2359:
	yych = *++cur;
	if (yych == 't') goto yy2367;
	goto yy2232;
yy2360:
	yych = *++cur;
	if (yych == 'i') goto yy2368;
	goto yy2232;
yy2361:
	yych = *++cur;
	if (yych == 'l') goto yy2369;
	goto yy2232;
yy2362:
	yych = *++cur;
	if (yych == 'd') goto yy2370;
	goto yy2232;
yy2363:
	yych = *++cur;
	if (yych == 's') goto yy2371;
	goto yy2232;
yy2364:
	++cur;
#line 872 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_targets); }
#line 12157 "src/parse/conf_lexer.cc"
yy2365:
	yych = *++cur;
	if (yych == 'a') goto yy2372;
	goto yy2232;
yy2366:
	yych = *++cur;
	if (yych == 'r') goto yy2373;
	goto yy2232;
yy2367:
	yych = *++cur;
	if (yych == 'i') goto yy2374;
	goto yy2232;
yy2368:
	yych = *++cur;
	if (yych == 'n') goto yy2375;
	goto yy2232;
yy2369:
	yych = *++cur;
	if (yych == 'e') goto yy2376;
	goto yy2232;
yy2370:
	yych = *++cur;
	if (yych == 'e') goto yy2377;
	goto yy2232;
yy2371:
	++cur;
#line 873 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_features); }
#line 12186 "src/parse/conf_lexer.cc"
yy2372:
	yych = *++cur;
	if (yych == 'c') goto yy2378;
	goto yy2232;
yy2373:
	yych = *++cur;
	if (yych == 'i') goto yy2379;
	goto yy2232;
yy2374:
	yych = *++cur;
	if (yych == 'v') goto yy2380;
	goto yy2232;
yy2375:
	yych = *++cur;
	if (yych == 'g') goto yy2381;
	goto yy2232;
yy2376:
	yych = *++cur;
	if (yych == 's') goto yy2382;
	goto yy2232;
yy2377:
	yych = *++cur;
	if (yych == 'l') goto yy2383;
	goto yy2232;
yy2378:
	yych = *++cur;
	if (yych == 'e') goto yy2384;
	goto yy2232;
yy2379:
	yych = *++cur;
	if (yych == 'n') goto yy2385;
	goto yy2232;
yy2380:
	yych = *++cur;
	if (yych == 'e') goto yy2386;
	goto yy2232;
yy2381:
	yych = *++cur;
	if (yych == 's') goto yy2387;
	goto yy2232;
yy2382:
	++cur;
#line 870 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_api_styles); }
#line 12231 "src/parse/conf_lexer.cc"
yy2383:
	yych = *++cur;
	if (yych == 's') goto yy2388;
	goto yy2232;
yy2384:
	yych = *++cur;
	if (yych == 's') goto yy2389;
	goto yy2232;
yy2385:
	yych = *++cur;
	if (yych == 'g') goto yy2390;
	goto yy2232;
yy2386:
	++cur;
#line 878 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(indentation_sensitive); }
#line 12248 "src/parse/conf_lexer.cc"
yy2387:
	++cur;
#line 877 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(single_quoted_strings); }
#line 12253 "src/parse/conf_lexer.cc"
yy2388:
	++cur;
#line 871 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_code_models); }
#line 12258 "src/parse/conf_lexer.cc"
yy2389:
	++cur;
#line 879 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(wrap_blocks_in_braces); }
#line 12263 "src/parse/conf_lexer.cc"
yy2390:
	yych = *++cur;
	if (yych != 's') goto yy2232;
	++cur;
#line 876 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(backtick_quoted_strings); }
#line 12270 "src/parse/conf_lexer.cc"
}
#line 883 "../src/parse/conf_lexer.re"


    UNREACHABLE();
    return Ret::FAIL;
}

#undef SAVE_CONF_BOOL
#undef SAVE_CONF_STR
#undef SAVE_CONF_LIST

#undef YYFILL

} // namespace re2c
