const char metrics_tarantool_cpu_lua[] =
"local ffi = require('ffi')\n"
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"if not pcall(ffi.typeof, \"struct timeval\") then\n"
"    if ffi.os == 'OSX' then\n"
"        ffi.cdef[[\n"
"            typedef int32_t suseconds_t;\n"
"            struct timeval {\n"
"                long        tv_sec;     /* seconds */\n"
"                suseconds_t tv_usec;    /* microseconds */\n"
"            };\n"
"        ]]\n"
"    else\n"
"        ffi.cdef[[\n"
"            struct timeval {\n"
"                long tv_sec;     /* seconds */\n"
"                long tv_usec;    /* microseconds */\n"
"            };\n"
"        ]]\n"
"    end\n"
"end\n"
"\n"
"if not pcall(ffi.typeof, \"struct rusage\") then\n"
"    ffi.cdef[[\n"
"        struct rusage {\n"
"            struct timeval ru_utime; /* user CPU time used */\n"
"            struct timeval ru_stime; /* system CPU time used */\n"
"            long   ru_maxrss;        /* maximum resident set size */\n"
"            long   ru_ixrss;         /* integral shared memory size */\n"
"            long   ru_idrss;         /* integral unshared data size */\n"
"            long   ru_isrss;         /* integral unshared stack size */\n"
"            long   ru_minflt;        /* page reclaims (soft page faults) */\n"
"            long   ru_majflt;        /* page faults (hard page faults) */\n"
"            long   ru_nswap;         /* swaps */\n"
"            long   ru_inblock;       /* block input operations */\n"
"            long   ru_oublock;       /* block output operations */\n"
"            long   ru_msgsnd;        /* IPC messages sent */\n"
"            long   ru_msgrcv;        /* IPC messages received */\n"
"            long   ru_nsignals;      /* signals received */\n"
"            long   ru_nvcsw;         /* voluntary context switches */\n"
"            long   ru_nivcsw;        /* involuntary context switches */\n"
"        };\n"
"        int getrusage(int who, struct rusage *usage);\n"
"        int gettimeofday(struct timeval *tv, struct timezone *tz);\n"
"    ]]\n"
"end\n"
"\n"
"local RUSAGE_SELF = 0\n"
"\n"
"local shared_rusage = ffi.new(\"struct rusage[1]\")\n"
"\n"
"local function ss_get_rusage()\n"
"    if ffi.C.getrusage(RUSAGE_SELF, shared_rusage) < 0 then\n"
"        return nil\n"
"    end\n"
"\n"
"    local ru_utime = tonumber(shared_rusage[0].ru_utime.tv_sec) +\n"
"                     (tonumber(shared_rusage[0].ru_utime.tv_usec) / 1000000)\n"
"    local ru_stime = tonumber(shared_rusage[0].ru_stime.tv_sec) +\n"
"                     (tonumber(shared_rusage[0].ru_stime.tv_usec) / 1000000)\n"
"\n"
"    return {\n"
"      ru_utime = ru_utime,\n"
"      ru_stime = ru_stime,\n"
"    }\n"
"end\n"
"\n"
"local function update_info_metrics()\n"
"    local cpu_time = ss_get_rusage()\n"
"    if cpu_time then\n"
"        collectors_list.cpu_user_time = utils.set_gauge('cpu_user_time', 'CPU user time usage',\n"
"            cpu_time.ru_utime, nil, nil, {default = true})\n"
"        collectors_list.cpu_system_time = utils.set_gauge('cpu_system_time', 'CPU system time usage',\n"
"            cpu_time.ru_stime, nil, nil, {default = true})\n"
"    end\n"
"end\n"
"\n"
"return {\n"
"    update = update_info_metrics,\n"
"    list = collectors_list,\n"
"}\n"
""
;
