/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// ForwardAuthApplyConfiguration represents a declarative configuration of the ForwardAuth type for use
// with apply.
type ForwardAuthApplyConfiguration struct {
	Address                  *string                                    `json:"address,omitempty"`
	TrustForwardHeader       *bool                                      `json:"trustForwardHeader,omitempty"`
	AuthResponseHeaders      []string                                   `json:"authResponseHeaders,omitempty"`
	AuthResponseHeadersRegex *string                                    `json:"authResponseHeadersRegex,omitempty"`
	AuthRequestHeaders       []string                                   `json:"authRequestHeaders,omitempty"`
	TLS                      *ClientTLSWithCAOptionalApplyConfiguration `json:"tls,omitempty"`
	AddAuthCookiesToResponse []string                                   `json:"addAuthCookiesToResponse,omitempty"`
	HeaderField              *string                                    `json:"headerField,omitempty"`
	ForwardBody              *bool                                      `json:"forwardBody,omitempty"`
	MaxBodySize              *int64                                     `json:"maxBodySize,omitempty"`
	PreserveLocationHeader   *bool                                      `json:"preserveLocationHeader,omitempty"`
	PreserveRequestMethod    *bool                                      `json:"preserveRequestMethod,omitempty"`
}

// ForwardAuthApplyConfiguration constructs a declarative configuration of the ForwardAuth type for use with
// apply.
func ForwardAuth() *ForwardAuthApplyConfiguration {
	return &ForwardAuthApplyConfiguration{}
}

// WithAddress sets the Address field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Address field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithAddress(value string) *ForwardAuthApplyConfiguration {
	b.Address = &value
	return b
}

// WithTrustForwardHeader sets the TrustForwardHeader field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TrustForwardHeader field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithTrustForwardHeader(value bool) *ForwardAuthApplyConfiguration {
	b.TrustForwardHeader = &value
	return b
}

// WithAuthResponseHeaders adds the given value to the AuthResponseHeaders field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AuthResponseHeaders field.
func (b *ForwardAuthApplyConfiguration) WithAuthResponseHeaders(values ...string) *ForwardAuthApplyConfiguration {
	for i := range values {
		b.AuthResponseHeaders = append(b.AuthResponseHeaders, values[i])
	}
	return b
}

// WithAuthResponseHeadersRegex sets the AuthResponseHeadersRegex field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AuthResponseHeadersRegex field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithAuthResponseHeadersRegex(value string) *ForwardAuthApplyConfiguration {
	b.AuthResponseHeadersRegex = &value
	return b
}

// WithAuthRequestHeaders adds the given value to the AuthRequestHeaders field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AuthRequestHeaders field.
func (b *ForwardAuthApplyConfiguration) WithAuthRequestHeaders(values ...string) *ForwardAuthApplyConfiguration {
	for i := range values {
		b.AuthRequestHeaders = append(b.AuthRequestHeaders, values[i])
	}
	return b
}

// WithTLS sets the TLS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLS field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithTLS(value *ClientTLSWithCAOptionalApplyConfiguration) *ForwardAuthApplyConfiguration {
	b.TLS = value
	return b
}

// WithAddAuthCookiesToResponse adds the given value to the AddAuthCookiesToResponse field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AddAuthCookiesToResponse field.
func (b *ForwardAuthApplyConfiguration) WithAddAuthCookiesToResponse(values ...string) *ForwardAuthApplyConfiguration {
	for i := range values {
		b.AddAuthCookiesToResponse = append(b.AddAuthCookiesToResponse, values[i])
	}
	return b
}

// WithHeaderField sets the HeaderField field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HeaderField field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithHeaderField(value string) *ForwardAuthApplyConfiguration {
	b.HeaderField = &value
	return b
}

// WithForwardBody sets the ForwardBody field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ForwardBody field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithForwardBody(value bool) *ForwardAuthApplyConfiguration {
	b.ForwardBody = &value
	return b
}

// WithMaxBodySize sets the MaxBodySize field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxBodySize field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithMaxBodySize(value int64) *ForwardAuthApplyConfiguration {
	b.MaxBodySize = &value
	return b
}

// WithPreserveLocationHeader sets the PreserveLocationHeader field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PreserveLocationHeader field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithPreserveLocationHeader(value bool) *ForwardAuthApplyConfiguration {
	b.PreserveLocationHeader = &value
	return b
}

// WithPreserveRequestMethod sets the PreserveRequestMethod field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PreserveRequestMethod field is set to the value of the last call.
func (b *ForwardAuthApplyConfiguration) WithPreserveRequestMethod(value bool) *ForwardAuthApplyConfiguration {
	b.PreserveRequestMethod = &value
	return b
}
