// python wrapper for vtkXdmf3SILBuilder
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkXdmf3SILBuilder.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkXdmf3SILBuilder(PyObject *dict); }

static PyObject *
PyvtkXdmf3SILBuilder_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3SILBuilder *op = static_cast<vtkXdmf3SILBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Initialize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3SILBuilder_AddVertex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddVertex");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3SILBuilder *op = static_cast<vtkXdmf3SILBuilder *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = op->AddVertex(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3SILBuilder_AddChildEdge(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddChildEdge");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3SILBuilder *op = static_cast<vtkXdmf3SILBuilder *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    long long tempr = op->AddChildEdge(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3SILBuilder_AddCrossEdge(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddCrossEdge");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3SILBuilder *op = static_cast<vtkXdmf3SILBuilder *>(vp);

  long long temp0;
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    long long tempr = op->AddCrossEdge(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3SILBuilder_GetRootVertex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRootVertex");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3SILBuilder *op = static_cast<vtkXdmf3SILBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = op->GetRootVertex();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3SILBuilder_GetBlocksRoot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlocksRoot");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3SILBuilder *op = static_cast<vtkXdmf3SILBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = op->GetBlocksRoot();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3SILBuilder_GetHierarchyRoot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHierarchyRoot");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3SILBuilder *op = static_cast<vtkXdmf3SILBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = op->GetHierarchyRoot();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkXdmf3SILBuilder_IsMaxedOut(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsMaxedOut");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkXdmf3SILBuilder *op = static_cast<vtkXdmf3SILBuilder *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->IsMaxedOut();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkXdmf3SILBuilder_Methods[] = {
  {"Initialize", PyvtkXdmf3SILBuilder_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize()\n\nInitializes the data-structures.\n"},
  {"AddVertex", PyvtkXdmf3SILBuilder_AddVertex, METH_VARARGS,
   "AddVertex(self, name:str) -> int\nC++: vtkIdType AddVertex(const char *name)\n\nAdd vertex, child-edge or cross-edge to the graph.\n"},
  {"AddChildEdge", PyvtkXdmf3SILBuilder_AddChildEdge, METH_VARARGS,
   "AddChildEdge(self, parent:int, child:int) -> int\nC++: vtkIdType AddChildEdge(vtkIdType parent, vtkIdType child)\n\n"},
  {"AddCrossEdge", PyvtkXdmf3SILBuilder_AddCrossEdge, METH_VARARGS,
   "AddCrossEdge(self, src:int, dst:int) -> int\nC++: vtkIdType AddCrossEdge(vtkIdType src, vtkIdType dst)\n\n"},
  {"GetRootVertex", PyvtkXdmf3SILBuilder_GetRootVertex, METH_VARARGS,
   "GetRootVertex(self) -> int\nC++: vtkIdType GetRootVertex()\n\nReturns the vertex id for the root vertex.\n"},
  {"GetBlocksRoot", PyvtkXdmf3SILBuilder_GetBlocksRoot, METH_VARARGS,
   "GetBlocksRoot(self) -> int\nC++: vtkIdType GetBlocksRoot()\n\n"},
  {"GetHierarchyRoot", PyvtkXdmf3SILBuilder_GetHierarchyRoot, METH_VARARGS,
   "GetHierarchyRoot(self) -> int\nC++: vtkIdType GetHierarchyRoot()\n\n"},
  {"IsMaxedOut", PyvtkXdmf3SILBuilder_IsMaxedOut, METH_VARARGS,
   "IsMaxedOut(self) -> bool\nC++: bool IsMaxedOut()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkXdmf3SILBuilder_GetSets[] = {
  {
    /*name=*/pystr("root_vertex"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3SILBuilder_GetRootVertex(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRootVertex\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("blocks_root"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3SILBuilder_GetBlocksRoot(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBlocksRoot\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hierarchy_root"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkXdmf3SILBuilder_GetHierarchyRoot(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetHierarchyRoot\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkXdmf3SILBuilder_vtkXdmf3SILBuilder(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkXdmf3SILBuilder");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkXdmf3SILBuilder *op = new vtkXdmf3SILBuilder();

    result = PyVTKSpecialObject_New("vtkXdmf3SILBuilder", op);
  }

  return result;
}

static PyMethodDef PyvtkXdmf3SILBuilder_vtkXdmf3SILBuilder_Methods[] = {
  {nullptr, nullptr, 0, nullptr}
};


static const char *PyvtkXdmf3SILBuilder_Doc =

  "vtkXdmf3SILBuilder() -> vtkXdmf3SILBuilder\nC++: vtkXdmf3SILBuilder()\n""\n"
  "vtkXdmf3SILBuilder - helper to allow block selection\n\n"
  "vtkXdmf3Reader uses this to build up a datastructure that represents\n"
  "block trees that correspond to the file. ParaView builds a GUI from\n"
  "that to let the user select from the various block and types of\n"
  "blocks that should or should not be loaded.\n\n"
  "This file is a helper for the vtkXdmf3Reader and vtkXdmf3Writer and\n"
  "not intended to be part of VTK public API\n\n";

static PyObject *
PyvtkXdmf3SILBuilder_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkXdmf3SILBuilder_vtkXdmf3SILBuilder(nullptr, args);
}

static void PyvtkXdmf3SILBuilder_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkXdmf3SILBuilder *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkXdmf3SILBuilder_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkXdmf3SILBuilder_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOXdmf3.vtkXdmf3SILBuilder", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkXdmf3SILBuilder_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkXdmf3SILBuilder_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkXdmf3SILBuilder_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkXdmf3SILBuilder_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

#ifndef DECLARED_PyvtkXdmf3SILBuilder_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkXdmf3SILBuilder_TypeNew(); }
#define DECLARED_PyvtkXdmf3SILBuilder_TypeNew
#endif

PyObject *PyvtkXdmf3SILBuilder_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkXdmf3SILBuilder_Type,
    PyvtkXdmf3SILBuilder_Methods,
    PyvtkXdmf3SILBuilder_GetSets,
    PyvtkXdmf3SILBuilder_vtkXdmf3SILBuilder_Methods,
    nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkXdmf3SILBuilder(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkXdmf3SILBuilder_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkXdmf3SILBuilder", o) != 0)
  {
    Py_DECREF(o);
  }

}

