// java wrapper for vtkParametricSpline object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkParametricSpline.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkParametricFunction_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkParametricSpline_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkParametricSpline",dType)) { return me; }
  if ((res= vtkParametricFunction_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParametricSpline_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParametricSpline_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetDimension_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_Evaluate_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[9];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 9, &temp2[0]);

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->Evaluate(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 9, &temp2[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkParametricSpline_EvaluateScalar_16(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[9];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 9, &temp2[0]);

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateScalar(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 9, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetXSpline_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSpline * temp0;
  temp0 = static_cast<vtkSpline*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXSpline(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetYSpline_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSpline * temp0;
  temp0 = static_cast<vtkSpline*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYSpline(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetZSpline_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkSpline * temp0;
  temp0 = static_cast<vtkSpline*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZSpline(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParametricSpline_GetXSpline_110(JNIEnv* env, jobject obj)
{
  vtkSpline * temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXSpline();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParametricSpline_GetYSpline_111(JNIEnv* env, jobject obj)
{
  vtkSpline * temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYSpline();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParametricSpline_GetZSpline_112(JNIEnv* env, jobject obj)
{
  vtkSpline * temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZSpline();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetPoints_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoints(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkParametricSpline_GetPoints_114(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetNumberOfPoints_115(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetPoint_116(JNIEnv* env, jobject obj,jlong id0,jdouble id1,jdouble id2,jdouble id3)
{
  long long   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetClosed_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClosed(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetClosed_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClosed();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_ClosedOn_119(JNIEnv* env, jobject obj)
{

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClosedOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_ClosedOff_120(JNIEnv* env, jobject obj)
{

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClosedOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetParameterizeByLength_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParameterizeByLength(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetParameterizeByLength_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParameterizeByLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_ParameterizeByLengthOn_123(JNIEnv* env, jobject obj)
{

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->ParameterizeByLengthOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_ParameterizeByLengthOff_124(JNIEnv* env, jobject obj)
{

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->ParameterizeByLengthOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetLeftConstraint_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeftConstraint(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetLeftConstraintMinValue_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftConstraintMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetLeftConstraintMaxValue_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftConstraintMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetLeftConstraint_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftConstraint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetRightConstraint_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRightConstraint(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetRightConstraintMinValue_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightConstraintMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetRightConstraintMaxValue_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightConstraintMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkParametricSpline_GetRightConstraint_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightConstraint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetLeftValue_133(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeftValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkParametricSpline_GetLeftValue_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkParametricSpline_SetRightValue_135(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRightValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkParametricSpline_GetRightValue_136(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkParametricSpline* op = static_cast<vtkParametricSpline*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightValue();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkParametricSpline_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkParametricSpline::New());
}
