// java wrapper for vtkLongArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLongArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLongArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLongArray",dType)) { return me; }
  if ((res= vtkDataArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}

// Array conversion routines
extern "C" JNIEXPORT jlongArray JNICALL Java_vtk_vtkLongArray_GetJavaArray_10(JNIEnv* env, jobject obj)
{
  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  long* buffer = op->GetPointer(0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<jlong*>(buffer), op->GetSize());
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLongArray_SetJavaArray_10(JNIEnv* env, jobject obj, jlongArray id0, jint len0)
{
  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(len0 / op->GetNumberOfComponents());
  long* buffer = op->GetPointer(0);
  env->GetLongArrayRegion(id0, 0, len0, reinterpret_cast<jlong*>(buffer));
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLongArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLongArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLongArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLongArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLongArray_ExtendedNew_14(JNIEnv* env, jobject obj)
{
  vtkLongArray * temp20;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLongArray_GetDataType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLongArray_GetValue_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long   temp20;
  temp0 = id0;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkLongArray_GetValueRange_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long * temp20;
  temp0 = id0;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange(temp0);
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<jlong*>(temp20), 2);

}

extern "C" JNIEXPORT jlongArray  JNICALL Java_vtk_vtkLongArray_GetValueRange_18(JNIEnv* env, jobject obj)
{
  long * temp20;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange();
  return vtkJavaMakeJArrayOfLong(env, reinterpret_cast<jlong*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLongArray_SetValue_19(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkLongArray_SetNumberOfValues_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLongArray_InsertValue_111(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertValue(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLongArray_InsertNextValue_112(JNIEnv* env, jobject obj,jlong id0)
{
  long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLongArray_FastDownCast_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkLongArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLongArray_GetDataTypeValueMin_114(JNIEnv* env, jobject obj)
{
  long   temp20;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMin();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLongArray_GetDataTypeValueMax_115(JNIEnv* env, jobject obj)
{
  long   temp20;

  vtkLongArray* op = static_cast<vtkLongArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMax();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLongArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLongArray::New());
}
