// java wrapper for vtkCursor3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCursor3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCursor3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCursor3D",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCursor3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCursor3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetModelBounds_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetModelBounds_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCursor3D_GetModelBounds_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetFocalPoint_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetFocalPoint_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCursor3D_GetFocalPoint_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetOutline_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutline(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_GetOutline_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutline();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_OutlineOn_112(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_OutlineOff_113(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetAxes_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_GetAxes_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_AxesOn_116(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_AxesOff_117(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetXShadows_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXShadows(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_GetXShadows_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXShadows();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_XShadowsOn_120(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->XShadowsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_XShadowsOff_121(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->XShadowsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetYShadows_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYShadows(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_GetYShadows_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYShadows();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_YShadowsOn_124(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->YShadowsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_YShadowsOff_125(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->YShadowsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetZShadows_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZShadows(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_GetZShadows_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZShadows();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_ZShadowsOn_128(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZShadowsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_ZShadowsOff_129(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZShadowsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetTranslationMode_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslationMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_GetTranslationMode_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_TranslationModeOn_132(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TranslationModeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_TranslationModeOff_133(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TranslationModeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_SetWrap_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWrap(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor3D_GetWrap_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_WrapOn_136(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->WrapOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_WrapOff_137(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->WrapOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCursor3D_GetFocus_138(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocus();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_AllOn_139(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor3D_AllOff_140(JNIEnv* env, jobject obj)
{

  vtkCursor3D* op = static_cast<vtkCursor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCursor3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCursor3D::New());
}
