// java wrapper for vtkPNGReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPNGReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageReader2_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPNGReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPNGReader",dType)) { return me; }
  if ((res= vtkImageReader2_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPNGReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPNGReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPNGReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPNGReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPNGReader_CanReadFile_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPNGReader_GetFileExtensions_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPNGReader_GetDescriptiveName_16(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPNGReader_GetTextChunks_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jintArray id1)
{
  char * temp0;
  int temp1[2];
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTextChunks(temp0,temp1);
  delete[] temp0;
  env->SetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPNGReader_GetTextKey_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextKey(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPNGReader_GetTextKeys_19(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextKeys();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPNGReader_GetTextValue_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextValue(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPNGReader_GetTextValues_111(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextValues();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPNGReader_SetReadSpacingFromFile_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadSpacingFromFile(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPNGReader_GetReadSpacingFromFile_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadSpacingFromFile();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPNGReader_ReadSpacingFromFileOn_114(JNIEnv* env, jobject obj)
{

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadSpacingFromFileOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPNGReader_ReadSpacingFromFileOff_115(JNIEnv* env, jobject obj)
{

  vtkPNGReader* op = static_cast<vtkPNGReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadSpacingFromFileOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPNGReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPNGReader::New());
}
