// java wrapper for vtkLSDynaReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLSDynaReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMultiBlockDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLSDynaReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLSDynaReader",dType)) { return me; }
  if ((res= vtkMultiBlockDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_DebugDump_14(JNIEnv* env, jobject obj)
{

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DebugDump();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_CanReadFile_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetDatabaseDirectory_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDatabaseDirectory(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetDatabaseDirectory_17(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDatabaseDirectory();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_IsDatabaseValid_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsDatabaseValid();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetFileName_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetFileName_110(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetTitle_111(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetDimensionality_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionality();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfNodes_113(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodes();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfCells_114(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfContinuumCells_115(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfContinuumCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfSolidCells_116(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSolidCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfThickShellCells_117(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThickShellCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfShellCells_118(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfShellCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfRigidBodyCells_119(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRigidBodyCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfRoadSurfaceCells_120(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRoadSurfaceCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfBeamCells_121(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfBeamCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfParticleCells_122(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfParticleCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfTimeSteps_123(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTimeSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetTimeStep_124(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStep(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLSDynaReader_GetTimeStep_125(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStep();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLSDynaReader_GetTimeValue_126(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkLSDynaReader_GetTimeStepRange_127(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetTimeStepRange_128(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetTimeStepRange_129(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepRange(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfPointArrays_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetPointArrayName_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetPointArrayStatus_132(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetPointArrayStatus_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetPointArrayStatus_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetPointArrayStatus_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInPointArray_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInPointArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInPointArray_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInPointArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfCellArrays_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetCellArrayName_139(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  const char * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetCellArrayStatus_140(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetCellArrayStatus_141(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jint id2)
{
  int   temp0;
  char * temp1;
  int   temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetCellArrayStatus_142(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetCellArrayStatus_143(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInCellArray_144(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInCellArray(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInCellArray_145(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInCellArray(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfSolidArrays_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSolidArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetSolidArrayName_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSolidArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetSolidArrayStatus_148(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSolidArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetSolidArrayStatus_149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSolidArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetSolidArrayStatus_150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSolidArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetSolidArrayStatus_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSolidArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInSolidArray_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInSolidArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInSolidArray_153(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInSolidArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfThickShellArrays_154(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThickShellArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetThickShellArrayName_155(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetThickShellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetThickShellArrayStatus_156(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetThickShellArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetThickShellArrayStatus_157(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetThickShellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetThickShellArrayStatus_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetThickShellArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetThickShellArrayStatus_159(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetThickShellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInThickShellArray_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInThickShellArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInThickShellArray_161(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInThickShellArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfShellArrays_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfShellArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetShellArrayName_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetShellArrayStatus_164(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShellArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetShellArrayStatus_165(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetShellArrayStatus_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShellArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetShellArrayStatus_167(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInShellArray_168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInShellArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInShellArray_169(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInShellArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfRigidBodyArrays_170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRigidBodyArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetRigidBodyArrayName_171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRigidBodyArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetRigidBodyArrayStatus_172(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRigidBodyArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetRigidBodyArrayStatus_173(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRigidBodyArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetRigidBodyArrayStatus_174(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRigidBodyArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetRigidBodyArrayStatus_175(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRigidBodyArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInRigidBodyArray_176(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInRigidBodyArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInRigidBodyArray_177(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInRigidBodyArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfRoadSurfaceArrays_178(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRoadSurfaceArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetRoadSurfaceArrayName_179(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoadSurfaceArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetRoadSurfaceArrayStatus_180(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRoadSurfaceArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetRoadSurfaceArrayStatus_181(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRoadSurfaceArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetRoadSurfaceArrayStatus_182(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoadSurfaceArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetRoadSurfaceArrayStatus_183(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoadSurfaceArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInRoadSurfaceArray_184(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInRoadSurfaceArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInRoadSurfaceArray_185(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInRoadSurfaceArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfBeamArrays_186(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfBeamArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetBeamArrayName_187(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBeamArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetBeamArrayStatus_188(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBeamArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetBeamArrayStatus_189(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBeamArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetBeamArrayStatus_190(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBeamArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetBeamArrayStatus_191(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBeamArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInBeamArray_192(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInBeamArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInBeamArray_193(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInBeamArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfParticleArrays_194(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfParticleArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetParticleArrayName_195(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParticleArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetParticleArrayStatus_196(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParticleArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetParticleArrayStatus_197(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParticleArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetParticleArrayStatus_198(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParticleArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetParticleArrayStatus_199(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParticleArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInParticleArray_1100(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInParticleArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfComponentsInParticleArray_1101(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponentsInParticleArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetDeformedMesh_1102(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeformedMesh(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetDeformedMesh_1103(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeformedMesh();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_DeformedMeshOn_1104(JNIEnv* env, jobject obj)
{

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeformedMeshOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_DeformedMeshOff_1105(JNIEnv* env, jobject obj)
{

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeformedMeshOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetRemoveDeletedCells_1106(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRemoveDeletedCells(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetRemoveDeletedCells_1107(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRemoveDeletedCells();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_RemoveDeletedCellsOn_1108(JNIEnv* env, jobject obj)
{

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDeletedCellsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_RemoveDeletedCellsOff_1109(JNIEnv* env, jobject obj)
{

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDeletedCellsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetDeletedCellsAsGhostArray_1110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeletedCellsAsGhostArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetDeletedCellsAsGhostArray_1111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeletedCellsAsGhostArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_DeletedCellsAsGhostArrayOn_1112(JNIEnv* env, jobject obj)
{

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeletedCellsAsGhostArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_DeletedCellsAsGhostArrayOff_1113(JNIEnv* env, jobject obj)
{

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeletedCellsAsGhostArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetInputDeck_1114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputDeck(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetInputDeck_1115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputDeck();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetNumberOfPartArrays_1116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPartArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkLSDynaReader_GetPartArrayName_1117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetPartArrayStatus_1118(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPartArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLSDynaReader_SetPartArrayStatus_1119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPartArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetPartArrayStatus_1120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLSDynaReader_GetPartArrayStatus_1121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLSDynaReader* op = static_cast<vtkLSDynaReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLSDynaReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLSDynaReader::New());
}
