// java wrapper for vtkImageStack object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageStack.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageSlice_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageStack_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageStack",dType)) { return me; }
  if ((res= vtkImageSlice_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_AddImage_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageSlice * temp0;
  temp0 = static_cast<vtkImageSlice*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddImage(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_RemoveImage_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageSlice * temp0;
  temp0 = static_cast<vtkImageSlice*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveImage(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_HasImage_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageSlice * temp0;
  int   temp20;
  temp0 = static_cast<vtkImageSlice*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasImage(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetImages_17(JNIEnv* env, jobject obj)
{
  vtkImageSliceCollection * temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImages();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_SetActiveLayer_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActiveLayer(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_GetActiveLayer_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveLayer();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetActiveImage_110(JNIEnv* env, jobject obj)
{
  vtkImageSlice * temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveImage();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetMapper_111(JNIEnv* env, jobject obj)
{
  vtkImageMapper3D * temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapper();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetProperty_112(JNIEnv* env, jobject obj)
{
  vtkImageProperty * temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_GetBounds_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetMTime_114(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetRedrawMTime_115(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRedrawMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_ShallowCopy_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_GetImages_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetImages(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_RenderOverlay_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_RenderOpaqueGeometry_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_RenderTranslucentPolygonalGeometry_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_HasTranslucentPolygonalGeometry_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_ReleaseGraphicsResources_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_InitPathTraversal_123(JNIEnv* env, jobject obj)
{

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitPathTraversal();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageStack_GetNextPath_124(JNIEnv* env, jobject obj)
{
  vtkAssemblyPath * temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNextPath();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageStack_GetNumberOfPaths_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPaths();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageStack_BuildPaths_126(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkAssemblyPaths * temp0;
  vtkAssemblyPath * temp1;
  temp0 = static_cast<vtkAssemblyPaths*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkAssemblyPath*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageStack* op = static_cast<vtkImageStack*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildPaths(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageStack_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageStack::New());
}
