/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUTextureSampleType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUTextureSampleType enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 5> values {
        MAKE_STATIC_STRING_IMPL("float"),
        MAKE_STATIC_STRING_IMPL("unfilterable-float"),
        MAKE_STATIC_STRING_IMPL("depth"),
        MAKE_STATIC_STRING_IMPL("sint"),
        MAKE_STATIC_STRING_IMPL("uint"),
    };
    static_assert(static_cast<size_t>(GPUTextureSampleType::Float) == 0, "GPUTextureSampleType::Float is not 0 as expected");
    static_assert(static_cast<size_t>(GPUTextureSampleType::UnfilterableFloat) == 1, "GPUTextureSampleType::UnfilterableFloat is not 1 as expected");
    static_assert(static_cast<size_t>(GPUTextureSampleType::Depth) == 2, "GPUTextureSampleType::Depth is not 2 as expected");
    static_assert(static_cast<size_t>(GPUTextureSampleType::Sint) == 3, "GPUTextureSampleType::Sint is not 3 as expected");
    static_assert(static_cast<size_t>(GPUTextureSampleType::Uint) == 4, "GPUTextureSampleType::Uint is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUTextureSampleType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUTextureSampleType> parseEnumerationFromString<GPUTextureSampleType>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPUTextureSampleType>, 5> mappings {
        std::pair<ComparableASCIILiteral, GPUTextureSampleType> { "depth"_s, GPUTextureSampleType::Depth },
        std::pair<ComparableASCIILiteral, GPUTextureSampleType> { "float"_s, GPUTextureSampleType::Float },
        std::pair<ComparableASCIILiteral, GPUTextureSampleType> { "sint"_s, GPUTextureSampleType::Sint },
        std::pair<ComparableASCIILiteral, GPUTextureSampleType> { "uint"_s, GPUTextureSampleType::Uint },
        std::pair<ComparableASCIILiteral, GPUTextureSampleType> { "unfilterable-float"_s, GPUTextureSampleType::UnfilterableFloat },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUTextureSampleType> parseEnumeration<GPUTextureSampleType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUTextureSampleType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUTextureSampleType>()
{
    return "\"float\", \"unfilterable-float\", \"depth\", \"sint\", \"uint\""_s;
}

} // namespace WebCore

