/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTrustedTypePolicyOptions.h"

#include "JSCreateHTMLCallback.h"
#include "JSCreateScriptCallback.h"
#include "JSCreateScriptURLCallback.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<TrustedTypePolicyOptions>> convertDictionary<TrustedTypePolicyOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    TrustedTypePolicyOptions result;
    JSValue createHTMLValue;
    if (isNullOrUndefined)
        createHTMLValue = jsUndefined();
    else {
        createHTMLValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "createHTML"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!createHTMLValue.isUndefined()) {
        auto createHTMLConversionResult = convert<IDLCallbackFunction<JSCreateHTMLCallback>>(lexicalGlobalObject, createHTMLValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        if (createHTMLConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.createHTML = createHTMLConversionResult.releaseReturnValue();
    }
    JSValue createScriptValue;
    if (isNullOrUndefined)
        createScriptValue = jsUndefined();
    else {
        createScriptValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "createScript"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!createScriptValue.isUndefined()) {
        auto createScriptConversionResult = convert<IDLCallbackFunction<JSCreateScriptCallback>>(lexicalGlobalObject, createScriptValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        if (createScriptConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.createScript = createScriptConversionResult.releaseReturnValue();
    }
    JSValue createScriptURLValue;
    if (isNullOrUndefined)
        createScriptURLValue = jsUndefined();
    else {
        createScriptURLValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "createScriptURL"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!createScriptURLValue.isUndefined()) {
        auto createScriptURLConversionResult = convert<IDLCallbackFunction<JSCreateScriptURLCallback>>(lexicalGlobalObject, createScriptURLValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        if (createScriptURLConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.createScriptURL = createScriptURLConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

