// Package openapi Code generated by swaggo/swag. DO NOT EDIT
package openapi

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {
            "name": "Woodpecker CI",
            "url": "https://woodpecker-ci.org/"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/agents": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "List agents",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Agent"
                            }
                        }
                    }
                }
            },
            "post": {
                "description": "Creates a new agent with a random token",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Create a new agent",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "the agent's data (only 'name' and 'no_schedule' are read)",
                        "name": "agent",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                }
            }
        },
        "/agents/{agent_id}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get an agent",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the agent's id",
                        "name": "agent_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Delete an agent",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the agent's id",
                        "name": "agent_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Update an agent",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the agent's id",
                        "name": "agent_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the agent's data",
                        "name": "agentData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                }
            }
        },
        "/agents/{agent_id}/tasks": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "List agent tasks",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the agent's id",
                        "name": "agent_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Task"
                            }
                        }
                    }
                }
            }
        },
        "/badges/{repo_id}/cc.xml": {
            "get": {
                "description": "CCMenu displays the pipeline status of projects on a CI server as an item in the Mac's menu bar.\nMore details on how to install, you can find at http://ccmenu.org/\nThe response format adheres to CCTray v1 Specification, https://cctray.org/v1/",
                "produces": [
                    "text/xml"
                ],
                "tags": [
                    "Badges"
                ],
                "summary": "Provide pipeline status information to the CCMenu tool",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/badges/{repo_id}/status.svg": {
            "get": {
                "produces": [
                    "image/svg+xml"
                ],
                "tags": [
                    "Badges"
                ],
                "summary": "Get status of pipeline as SVG badge",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug",
                "produces": [
                    "text/html"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "List available pprof profiles (HTML)",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof/block": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get pprof stack traces that led to blocking on synchronization primitives",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof/cmdline": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get the command line invocation of the current program",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof/goroutine": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get pprof stack traces of all current goroutines",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "Use debug=2 as a query parameter to export in the same format as an un-recovered panic",
                        "name": "debug",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof/heap": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get pprof heap dump, a sampling of memory allocations of live objects",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "default": "",
                        "description": "You can specify gc=heap to run GC before taking the heap sample",
                        "name": "gc",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof/profile": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug\nAfter you get the profile file, use the go tool pprof command to investigate the profile.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get pprof CPU profile",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "You can specify the duration in the seconds GET parameter.",
                        "name": "seconds",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof/symbol": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug\nLooks up the program counters listed in the request,\nresponding with a table mapping program counters to function names.\nThe requested program counters can be provided via GET + query parameters,\nor POST + body parameters. Program counters shall be space delimited.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get pprof program counters mapping to function names",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            },
            "post": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug\nLooks up the program counters listed in the request,\nresponding with a table mapping program counters to function names.\nThe requested program counters can be provided via GET + query parameters,\nor POST + body parameters. Program counters shall be space delimited.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get pprof program counters mapping to function names",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof/threadcreate": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get pprof stack traces that led to the creation of new OS threads",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/pprof/trace": {
            "get": {
                "description": "Only available, when server was started with WOODPECKER_LOG_LEVEL=debug\nAfter you get the profile file, use the go tool pprof command to investigate the profile.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Process profiling and debugging"
                ],
                "summary": "Get a trace of execution of the current program",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "You can specify the duration in the seconds GET parameter.",
                        "name": "seconds",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/forges": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Forges"
                ],
                "summary": "List forges",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Forge"
                            }
                        }
                    }
                }
            },
            "post": {
                "description": "Creates a new forge with a random token",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Forges"
                ],
                "summary": "Create a new forge",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "the forge's data (only 'name' and 'no_schedule' are read)",
                        "name": "forge",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/ForgeWithOAuthClientSecret"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Forge"
                        }
                    }
                }
            }
        },
        "/forges/{forgeId}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Forges"
                ],
                "summary": "Get a forge",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header"
                    },
                    {
                        "type": "integer",
                        "description": "the forge's id",
                        "name": "forgeId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Forge"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Forges"
                ],
                "summary": "Delete a forge",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the forge's id",
                        "name": "forgeId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Forges"
                ],
                "summary": "Update a forge",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the forge's id",
                        "name": "forgeId",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the forge's data",
                        "name": "forgeData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/ForgeWithOAuthClientSecret"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Forge"
                        }
                    }
                }
            }
        },
        "/healthz": {
            "get": {
                "description": "If everything is fine, just a 204 will be returned, a 500 signals server state is unhealthy.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "System"
                ],
                "summary": "Health information",
                "responses": {
                    "204": {
                        "description": "No Content"
                    },
                    "500": {
                        "description": "Internal Server Error"
                    }
                }
            }
        },
        "/hook": {
            "post": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "System"
                ],
                "summary": "Incoming webhook from forge",
                "parameters": [
                    {
                        "description": "the webhook payload; forge is automatically detected",
                        "name": "hook",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "object"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/log-level": {
            "get": {
                "description": "Endpoint returns the current logging level. Requires admin rights.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "System"
                ],
                "summary": "Current log level",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "object",
                            "properties": {
                                "log-level": {
                                    "type": "string"
                                }
                            }
                        }
                    }
                }
            },
            "post": {
                "description": "Endpoint sets the current logging level. Requires admin rights.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "System"
                ],
                "summary": "Set log level",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "the new log level, one of \u003cdebug,trace,info,warn,error,fatal,panic,disabled\u003e",
                        "name": "log-level",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "object",
                            "properties": {
                                "log-level": {
                                    "type": "string"
                                }
                            }
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "object",
                            "properties": {
                                "log-level": {
                                    "type": "string"
                                }
                            }
                        }
                    }
                }
            }
        },
        "/orgs": {
            "get": {
                "description": "Returns all registered orgs in the system. Requires admin rights.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Orgs"
                ],
                "summary": "List organizations",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Org"
                            }
                        }
                    }
                }
            }
        },
        "/orgs/lookup/{org_full_name}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Orgs"
                ],
                "summary": "Lookup an organization by full name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the organizations full name / slug",
                        "name": "org_full_name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Org"
                        }
                    }
                }
            }
        },
        "/orgs/{id}": {
            "delete": {
                "description": "Deletes the given org. Requires admin rights.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Orgs"
                ],
                "summary": "Delete an organization",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/orgs/{org_id}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization"
                ],
                "summary": "Get an organization",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the organization's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Org"
                            }
                        }
                    }
                }
            }
        },
        "/orgs/{org_id}/agents": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "List agents for an organization",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the organization's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Agent"
                            }
                        }
                    }
                }
            },
            "post": {
                "description": "Creates a new agent with a random token, scoped to the specified organization",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Create a new organization-scoped agent",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the organization's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the agent's data (only 'name' and 'no_schedule' are read)",
                        "name": "agent",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                }
            }
        },
        "/orgs/{org_id}/agents/{agent_id}": {
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Delete an organization-scoped agent",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the organization's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the agent's id",
                        "name": "agent_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Update an organization-scoped agent",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the organization's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the agent's id",
                        "name": "agent_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the agent's updated data",
                        "name": "agent",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Agent"
                        }
                    }
                }
            }
        },
        "/orgs/{org_id}/permissions": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization permissions"
                ],
                "summary": "Get the permissions of the currently authenticated user for the given organization",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the organization's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/OrgPerm"
                            }
                        }
                    }
                }
            }
        },
        "/orgs/{org_id}/registries": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization registries"
                ],
                "summary": "List organization registries",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Registry"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization registries"
                ],
                "summary": "Create an organization registry",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the new registry",
                        "name": "registryData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            }
        },
        "/orgs/{org_id}/registries/{registry}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization registries"
                ],
                "summary": "Get a organization registry by address",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry's address",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Organization registries"
                ],
                "summary": "Delete an organization registry by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry's name",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization registries"
                ],
                "summary": "Update an organization registry by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry's name",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the update registry data",
                        "name": "registryData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            }
        },
        "/orgs/{org_id}/secrets": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization secrets"
                ],
                "summary": "List organization secrets",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Secret"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization secrets"
                ],
                "summary": "Create an organization secret",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the new secret",
                        "name": "secretData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            }
        },
        "/orgs/{org_id}/secrets/{secret}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization secrets"
                ],
                "summary": "Get a organization secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret's name",
                        "name": "secret",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Organization secrets"
                ],
                "summary": "Delete an organization secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret's name",
                        "name": "secret",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organization secrets"
                ],
                "summary": "Update an organization secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the org's id",
                        "name": "org_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret's name",
                        "name": "secret",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the update secret data",
                        "name": "secretData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/SecretPatch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            }
        },
        "/pipelines": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipeline queues"
                ],
                "summary": "List pipelines in queue",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Feed"
                            }
                        }
                    }
                }
            }
        },
        "/queue/info": {
            "get": {
                "description": "Returns pipeline queue information with agent details",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipeline queues"
                ],
                "summary": "Get pipeline queue information",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/QueueInfo"
                        }
                    }
                }
            }
        },
        "/queue/norunningpipelines": {
            "get": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Pipeline queues"
                ],
                "summary": "Block til pipeline queue has a running item",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/queue/pause": {
            "post": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Pipeline queues"
                ],
                "summary": "Pause the pipeline queue",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/queue/resume": {
            "post": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Pipeline queues"
                ],
                "summary": "Resume the pipeline queue",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/registries": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Registries"
                ],
                "summary": "List global registries",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Registry"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Registries"
                ],
                "summary": "Create a global registry",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "the registry object data",
                        "name": "registry",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            }
        },
        "/registries/{registry}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Registries"
                ],
                "summary": "Get a global registry by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry's name",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Registries"
                ],
                "summary": "Delete a global registry by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry's name",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Registries"
                ],
                "summary": "Update a global registry by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry's name",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the registry's data",
                        "name": "registryData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            }
        },
        "/repos": {
            "get": {
                "description": "Returns a list of all repositories. Requires admin rights.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "List all repositories on the server",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "only list active repos",
                        "name": "active",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Repo"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Activate a repository",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the id of a repository at the forge",
                        "name": "forge_remote_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Repo"
                        }
                    }
                }
            }
        },
        "/repos/lookup/{repo_full_name}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Lookup a repository by full name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the repository full name / slug",
                        "name": "repo_full_name",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Repo"
                        }
                    }
                }
            }
        },
        "/repos/repair": {
            "post": {
                "description": "Executes a repair process on all repositories. Requires admin rights.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Repair all repositories on the server",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/repos/{repo_id}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Get a repository",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Repo"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Delete a repository",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Repo"
                        }
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Update a repository",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the repository's information",
                        "name": "repo",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/RepoPatch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Repo"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/branches": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Get branches of a repository",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/chown": {
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Change a repository's owner to the currently authenticated user",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Repo"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/cron": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository cron jobs"
                ],
                "summary": "List cron jobs",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Cron"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository cron jobs"
                ],
                "summary": "Create a cron job",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the new cron job",
                        "name": "cronJob",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Cron"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Cron"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/cron/{cron}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository cron jobs"
                ],
                "summary": "Get a cron job",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the cron job id",
                        "name": "cron",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Cron"
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository cron jobs"
                ],
                "summary": "Start a cron job now",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the cron job id",
                        "name": "cron",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Pipeline"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Repository cron jobs"
                ],
                "summary": "Delete a cron job",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the cron job id",
                        "name": "cron",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository cron jobs"
                ],
                "summary": "Update a cron job",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the cron job id",
                        "name": "cron",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the cron job data",
                        "name": "cronJob",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/CronPatch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Cron"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/logs/{number}": {
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Pipeline logs"
                ],
                "summary": "Deletes all logs of a pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/repos/{repo_id}/logs/{number}/{stepID}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipeline logs"
                ],
                "summary": "Get logs for a pipeline step",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the step id",
                        "name": "stepID",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/LogEntry"
                            }
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/logs/{number}/{stepId}": {
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Pipeline logs"
                ],
                "summary": "Delete step logs of a pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the step id",
                        "name": "stepId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/repos/{repo_id}/move": {
            "post": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Move a repository to a new owner",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the username to move the repository to",
                        "name": "to",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/repos/{repo_id}/permissions": {
            "get": {
                "description": "The repository permission, according to the used access token.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Check current authenticated users access to the repository",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Perm"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/pipelines": {
            "get": {
                "description": "Get a list of pipelines for a repository.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "List repository pipelines",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "only return pipelines before this RFC3339 date",
                        "name": "before",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "only return pipelines after this RFC3339 date",
                        "name": "after",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter pipelines by branch",
                        "name": "branch",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter pipelines by webhook events (comma separated)",
                        "name": "event",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter pipelines by strings contained in ref",
                        "name": "ref",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter pipelines by status",
                        "name": "status",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Pipeline"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Trigger a manual pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the options for the pipeline to run",
                        "name": "options",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/PipelineOptions"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Pipeline"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/pipelines/{number}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Get a repositories pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline, OR 'latest'",
                        "name": "number",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Pipeline"
                        }
                    }
                }
            },
            "post": {
                "description": "Restarts a pipeline optional with altered event, deploy or environment",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Restart a pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "override the event type",
                        "name": "event",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "override the target deploy value",
                        "name": "deploy_to",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Pipeline"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Delete a pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/repos/{repo_id}/pipelines/{number}/approve": {
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Approve and start a pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Pipeline"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/pipelines/{number}/cancel": {
            "post": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Cancel a pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/repos/{repo_id}/pipelines/{number}/config": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Get configuration files for a pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Config"
                            }
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/pipelines/{number}/decline": {
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Decline a pipeline",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Pipeline"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/pipelines/{number}/metadata": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Pipelines"
                ],
                "summary": "Get metadata for a pipeline or a specific workflow, including previous pipeline info",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "number",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/metadata.Metadata"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/pull_requests": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "List active pull requests of a repository",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/PullRequest"
                            }
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/registries": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository registries"
                ],
                "summary": "List registries",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Registry"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository registries"
                ],
                "summary": "Create a registry",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the new registry data",
                        "name": "registry",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/registries/{registry}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository registries"
                ],
                "summary": "Get a registry by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry name",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Repository registries"
                ],
                "summary": "Delete a registry by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry name",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository registries"
                ],
                "summary": "Update a registry by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the registry name",
                        "name": "registry",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the attributes for the registry",
                        "name": "registryData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Registry"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/repair": {
            "post": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Repositories"
                ],
                "summary": "Repair a repository",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/repos/{repo_id}/secrets": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository secrets"
                ],
                "summary": "List repository secrets",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Secret"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository secrets"
                ],
                "summary": "Create a repository secret",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the new secret",
                        "name": "secret",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            }
        },
        "/repos/{repo_id}/secrets/{secretName}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository secrets"
                ],
                "summary": "Get a repository secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret name",
                        "name": "secretName",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Repository secrets"
                ],
                "summary": "Delete a repository secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret name",
                        "name": "secretName",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Repository secrets"
                ],
                "summary": "Update a repository secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret name",
                        "name": "secretName",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the secret itself",
                        "name": "secret",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/SecretPatch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            }
        },
        "/secrets": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Secrets"
                ],
                "summary": "List global secrets",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Secret"
                            }
                        }
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Secrets"
                ],
                "summary": "Create a global secret",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "the secret object data",
                        "name": "secret",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            }
        },
        "/secrets/{secret}": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Secrets"
                ],
                "summary": "Get a global secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret's name",
                        "name": "secret",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            },
            "delete": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Secrets"
                ],
                "summary": "Delete a global secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret's name",
                        "name": "secret",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Secrets"
                ],
                "summary": "Update a global secret by name",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the secret's name",
                        "name": "secret",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the secret's data",
                        "name": "secretData",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/SecretPatch"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/Secret"
                        }
                    }
                }
            }
        },
        "/signature/public-key": {
            "get": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "System"
                ],
                "summary": "Get server's signature public key",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/stream/events": {
            "get": {
                "description": "With quic and http2 support",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Events"
                ],
                "summary": "Stream events like pipeline updates",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/stream/logs/{repo_id}/{pipeline}/{stepID}": {
            "get": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Pipeline logs"
                ],
                "summary": "Stream logs of a pipeline step",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "the repository id",
                        "name": "repo_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the number of the pipeline",
                        "name": "pipeline",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "the step id",
                        "name": "stepID",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/user": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get the currently authenticated user",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/User"
                        }
                    }
                }
            }
        },
        "/user/feed": {
            "get": {
                "description": "The feed lists the most recent pipeline for the currently authenticated user.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get the currently authenticated users pipeline feed",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/Feed"
                            }
                        }
                    }
                }
            }
        },
        "/user/repos": {
            "get": {
                "description": "Retrieve the currently authenticated User's Repository list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Get user's repositories",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "query all repos, including inactive ones",
                        "name": "all",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "filter repos by name",
                        "name": "name",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/RepoLastPipeline"
                            }
                        }
                    }
                }
            }
        },
        "/user/token": {
            "post": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Return the token of the current user as string",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            },
            "delete": {
                "description": "Reset's the current personal access token of the user and returns a new one.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "User"
                ],
                "summary": "Reset a token",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/users": {
            "get": {
                "description": "Returns all registered, active users in the system. Requires admin rights.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "List users",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "default": 1,
                        "description": "for response pagination, page offset number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "default": 50,
                        "description": "for response pagination, max items per page",
                        "name": "perPage",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/User"
                            }
                        }
                    }
                }
            },
            "post": {
                "description": "Creates a new user account with the specified external login. Requires admin rights.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Create a user",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "the user's data",
                        "name": "user",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/User"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/User"
                        }
                    }
                }
            }
        },
        "/users/{login}": {
            "get": {
                "description": "Returns a user with the specified login name. Requires admin rights.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get a user",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the user's login name",
                        "name": "login",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "specify forge (else default will be used)",
                        "name": "forge_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "specify user id at forge (else fallback to login)",
                        "name": "forge_remote_id",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/User"
                        }
                    }
                }
            },
            "delete": {
                "description": "Deletes the given user. Requires admin rights.",
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Delete a user",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the user's login name",
                        "name": "login",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "specify forge (else default will be used)",
                        "name": "forge_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "specify user id at forge (else fallback to login)",
                        "name": "forge_remote_id",
                        "in": "query"
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "description": "Changes the data of an existing user. Requires admin rights.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Update a user",
                "parameters": [
                    {
                        "type": "string",
                        "default": "Bearer \u003cpersonal access token\u003e",
                        "description": "Insert your personal access token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "the user's login name",
                        "name": "login",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "the user's data",
                        "name": "user",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/User"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/User"
                        }
                    }
                }
            }
        },
        "/version": {
            "get": {
                "description": "Endpoint returns the server version and build information.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "System"
                ],
                "summary": "Get version",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "object",
                            "properties": {
                                "source": {
                                    "type": "string"
                                },
                                "version": {
                                    "type": "string"
                                }
                            }
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "Agent": {
            "type": "object",
            "properties": {
                "backend": {
                    "type": "string"
                },
                "capacity": {
                    "type": "integer"
                },
                "created": {
                    "type": "integer"
                },
                "custom_labels": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "id": {
                    "type": "integer"
                },
                "last_contact": {
                    "type": "integer"
                },
                "last_work": {
                    "description": "last time the agent did something, this value is used to determine if the agent is still doing work used by the autoscaler",
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "no_schedule": {
                    "type": "boolean"
                },
                "org_id": {
                    "description": "OrgID is counted as unset if set to -1, this is done to ensure a new(Agent) still enforce the OrgID check by default",
                    "type": "integer"
                },
                "owner_id": {
                    "type": "integer"
                },
                "platform": {
                    "type": "string"
                },
                "token": {
                    "type": "string"
                },
                "updated": {
                    "type": "integer"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "Config": {
            "type": "object",
            "properties": {
                "data": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "hash": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "Cron": {
            "type": "object",
            "properties": {
                "branch": {
                    "type": "string"
                },
                "created": {
                    "type": "integer"
                },
                "creator_id": {
                    "description": "TODO: drop with next major version",
                    "type": "integer"
                },
                "enabled": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "next_exec": {
                    "type": "integer"
                },
                "repo_id": {
                    "type": "integer"
                },
                "schedule": {
                    "description": "@weekly,\t3min, ...",
                    "type": "string"
                },
                "variables": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                }
            }
        },
        "CronPatch": {
            "type": "object",
            "properties": {
                "branch": {
                    "type": "string"
                },
                "enabled": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "schedule": {
                    "type": "string"
                },
                "variables": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                }
            }
        },
        "Feed": {
            "type": "object",
            "properties": {
                "author": {
                    "type": "string"
                },
                "author_avatar": {
                    "type": "string"
                },
                "author_email": {
                    "type": "string"
                },
                "branch": {
                    "type": "string"
                },
                "commit": {
                    "type": "string"
                },
                "created": {
                    "type": "integer"
                },
                "event": {
                    "type": "string"
                },
                "finished": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "message": {
                    "type": "string"
                },
                "number": {
                    "type": "integer"
                },
                "ref": {
                    "type": "string"
                },
                "refspec": {
                    "type": "string"
                },
                "repo_id": {
                    "type": "integer"
                },
                "started": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                }
            }
        },
        "Forge": {
            "type": "object",
            "properties": {
                "additional_options": {
                    "type": "object",
                    "additionalProperties": {}
                },
                "client": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "oauth_host": {
                    "description": "public url for oauth if different from url",
                    "type": "string"
                },
                "skip_verify": {
                    "type": "boolean"
                },
                "type": {
                    "$ref": "#/definitions/model.ForgeType"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "ForgeWithOAuthClientSecret": {
            "type": "object",
            "properties": {
                "additional_options": {
                    "type": "object",
                    "additionalProperties": {}
                },
                "client": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "oauth_client_secret": {
                    "type": "string"
                },
                "oauth_host": {
                    "description": "public url for oauth if different from url",
                    "type": "string"
                },
                "skip_verify": {
                    "type": "boolean"
                },
                "type": {
                    "$ref": "#/definitions/model.ForgeType"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "LogEntry": {
            "type": "object",
            "properties": {
                "data": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "id": {
                    "type": "integer"
                },
                "line": {
                    "type": "integer"
                },
                "step_id": {
                    "type": "integer"
                },
                "time": {
                    "type": "integer"
                },
                "type": {
                    "$ref": "#/definitions/LogEntryType"
                }
            }
        },
        "LogEntryType": {
            "type": "integer",
            "enum": [
                0,
                1,
                2,
                3,
                4
            ],
            "x-enum-varnames": [
                "LogEntryStdout",
                "LogEntryStderr",
                "LogEntryExitCode",
                "LogEntryMetadata",
                "LogEntryProgress"
            ]
        },
        "Org": {
            "type": "object",
            "properties": {
                "forge_id": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "is_user": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "OrgPerm": {
            "type": "object",
            "properties": {
                "admin": {
                    "type": "boolean"
                },
                "member": {
                    "type": "boolean"
                }
            }
        },
        "Perm": {
            "type": "object",
            "properties": {
                "admin": {
                    "type": "boolean"
                },
                "created": {
                    "type": "integer"
                },
                "pull": {
                    "type": "boolean"
                },
                "push": {
                    "type": "boolean"
                },
                "synced": {
                    "type": "integer"
                },
                "updated": {
                    "type": "integer"
                }
            }
        },
        "Pipeline": {
            "type": "object",
            "properties": {
                "author": {
                    "type": "string"
                },
                "author_avatar": {
                    "type": "string"
                },
                "author_email": {
                    "type": "string"
                },
                "branch": {
                    "type": "string"
                },
                "changed_files": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "commit": {
                    "type": "string"
                },
                "created": {
                    "type": "integer"
                },
                "deploy_task": {
                    "type": "string"
                },
                "deploy_to": {
                    "type": "string"
                },
                "errors": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.PipelineError"
                    }
                },
                "event": {
                    "$ref": "#/definitions/WebhookEvent"
                },
                "event_reason": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "finished": {
                    "type": "integer"
                },
                "forge_url": {
                    "type": "string"
                },
                "from_fork": {
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                },
                "is_prerelease": {
                    "type": "boolean"
                },
                "message": {
                    "type": "string"
                },
                "number": {
                    "type": "integer"
                },
                "parent": {
                    "type": "integer"
                },
                "pr_labels": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "pr_milestone": {
                    "type": "string"
                },
                "ref": {
                    "type": "string"
                },
                "refspec": {
                    "type": "string"
                },
                "reviewed": {
                    "type": "integer"
                },
                "reviewed_by": {
                    "type": "string"
                },
                "sender": {
                    "description": "uses reported user for webhooks and name of cron for cron pipelines",
                    "type": "string"
                },
                "started": {
                    "type": "integer"
                },
                "status": {
                    "$ref": "#/definitions/StatusValue"
                },
                "timestamp": {
                    "type": "integer"
                },
                "title": {
                    "type": "string"
                },
                "updated": {
                    "type": "integer"
                },
                "variables": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "workflows": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.Workflow"
                    }
                }
            }
        },
        "PipelineOptions": {
            "type": "object",
            "properties": {
                "branch": {
                    "type": "string"
                },
                "variables": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                }
            }
        },
        "PullRequest": {
            "type": "object",
            "properties": {
                "index": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                }
            }
        },
        "QueueInfo": {
            "type": "object",
            "properties": {
                "paused": {
                    "type": "boolean"
                },
                "pending": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.QueueTask"
                    }
                },
                "running": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.QueueTask"
                    }
                },
                "stats": {
                    "type": "object",
                    "properties": {
                        "pending_count": {
                            "type": "integer"
                        },
                        "running_count": {
                            "type": "integer"
                        },
                        "waiting_on_deps_count": {
                            "type": "integer"
                        },
                        "worker_count": {
                            "type": "integer"
                        }
                    }
                },
                "waiting_on_deps": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.QueueTask"
                    }
                }
            }
        },
        "Registry": {
            "type": "object",
            "properties": {
                "address": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "org_id": {
                    "type": "integer"
                },
                "password": {
                    "type": "string"
                },
                "readonly": {
                    "type": "boolean"
                },
                "repo_id": {
                    "type": "integer"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "Repo": {
            "type": "object",
            "properties": {
                "active": {
                    "type": "boolean"
                },
                "allow_deploy": {
                    "type": "boolean"
                },
                "allow_pr": {
                    "type": "boolean"
                },
                "approval_allowed_users": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "avatar_url": {
                    "type": "string"
                },
                "cancel_previous_pipeline_events": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/WebhookEvent"
                    }
                },
                "clone_url": {
                    "type": "string"
                },
                "clone_url_ssh": {
                    "type": "string"
                },
                "config_extension_endpoint": {
                    "type": "string"
                },
                "config_file": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "forge_id": {
                    "type": "integer"
                },
                "forge_remote_id": {
                    "description": "ForgeRemoteID is the unique identifier for the repository on the forge.",
                    "type": "string"
                },
                "forge_url": {
                    "type": "string"
                },
                "full_name": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "netrc_trusted": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "org_id": {
                    "type": "integer"
                },
                "owner": {
                    "type": "string"
                },
                "pr_enabled": {
                    "type": "boolean"
                },
                "private": {
                    "type": "boolean"
                },
                "require_approval": {
                    "$ref": "#/definitions/model.ApprovalMode"
                },
                "timeout": {
                    "type": "integer"
                },
                "trusted": {
                    "$ref": "#/definitions/model.TrustedConfiguration"
                },
                "visibility": {
                    "$ref": "#/definitions/RepoVisibility"
                }
            }
        },
        "RepoLastPipeline": {
            "type": "object",
            "properties": {
                "active": {
                    "type": "boolean"
                },
                "allow_deploy": {
                    "type": "boolean"
                },
                "allow_pr": {
                    "type": "boolean"
                },
                "approval_allowed_users": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "avatar_url": {
                    "type": "string"
                },
                "cancel_previous_pipeline_events": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/WebhookEvent"
                    }
                },
                "clone_url": {
                    "type": "string"
                },
                "clone_url_ssh": {
                    "type": "string"
                },
                "config_extension_endpoint": {
                    "type": "string"
                },
                "config_file": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "forge_id": {
                    "type": "integer"
                },
                "forge_remote_id": {
                    "description": "ForgeRemoteID is the unique identifier for the repository on the forge.",
                    "type": "string"
                },
                "forge_url": {
                    "type": "string"
                },
                "full_name": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "last_pipeline": {
                    "$ref": "#/definitions/Pipeline"
                },
                "name": {
                    "type": "string"
                },
                "netrc_trusted": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "org_id": {
                    "type": "integer"
                },
                "owner": {
                    "type": "string"
                },
                "pr_enabled": {
                    "type": "boolean"
                },
                "private": {
                    "type": "boolean"
                },
                "require_approval": {
                    "$ref": "#/definitions/model.ApprovalMode"
                },
                "timeout": {
                    "type": "integer"
                },
                "trusted": {
                    "$ref": "#/definitions/model.TrustedConfiguration"
                },
                "visibility": {
                    "$ref": "#/definitions/RepoVisibility"
                }
            }
        },
        "RepoPatch": {
            "type": "object",
            "properties": {
                "allow_deploy": {
                    "type": "boolean"
                },
                "allow_pr": {
                    "type": "boolean"
                },
                "approval_allowed_users": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "cancel_previous_pipeline_events": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/WebhookEvent"
                    }
                },
                "config_extension_endpoint": {
                    "type": "string"
                },
                "config_file": {
                    "type": "string"
                },
                "netrc_trusted": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "require_approval": {
                    "type": "string"
                },
                "timeout": {
                    "type": "integer"
                },
                "trusted": {
                    "$ref": "#/definitions/model.TrustedConfigurationPatch"
                },
                "visibility": {
                    "type": "string"
                }
            }
        },
        "RepoVisibility": {
            "type": "string",
            "enum": [
                "public",
                "private",
                "internal"
            ],
            "x-enum-varnames": [
                "VisibilityPublic",
                "VisibilityPrivate",
                "VisibilityInternal"
            ]
        },
        "Secret": {
            "type": "object",
            "properties": {
                "events": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/WebhookEvent"
                    }
                },
                "id": {
                    "type": "integer"
                },
                "images": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "note": {
                    "type": "string"
                },
                "org_id": {
                    "type": "integer"
                },
                "repo_id": {
                    "type": "integer"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "SecretPatch": {
            "type": "object",
            "properties": {
                "events": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/WebhookEvent"
                    }
                },
                "images": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "note": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "StatusValue": {
            "type": "string",
            "enum": [
                "skipped",
                "pending",
                "running",
                "success",
                "failure",
                "killed",
                "error",
                "blocked",
                "declined",
                "created"
            ],
            "x-enum-comments": {
                "StatusBlocked": "waiting for approval",
                "StatusCreated": "created / internal use only",
                "StatusDeclined": "blocked and declined",
                "StatusError": "error with the config / while parsing / some other system problem",
                "StatusFailure": "failed to finish (exit code != 0)",
                "StatusKilled": "killed by user",
                "StatusPending": "pending to be executed",
                "StatusRunning": "currently running",
                "StatusSkipped": "skipped as another step failed",
                "StatusSuccess": "successfully finished"
            },
            "x-enum-descriptions": [
                "skipped as another step failed",
                "pending to be executed",
                "currently running",
                "successfully finished",
                "failed to finish (exit code != 0)",
                "killed by user",
                "error with the config / while parsing / some other system problem",
                "waiting for approval",
                "blocked and declined",
                "created / internal use only"
            ],
            "x-enum-varnames": [
                "StatusSkipped",
                "StatusPending",
                "StatusRunning",
                "StatusSuccess",
                "StatusFailure",
                "StatusKilled",
                "StatusError",
                "StatusBlocked",
                "StatusDeclined",
                "StatusCreated"
            ]
        },
        "Step": {
            "type": "object",
            "properties": {
                "error": {
                    "type": "string"
                },
                "exit_code": {
                    "type": "integer"
                },
                "finished": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "pid": {
                    "type": "integer"
                },
                "pipeline_id": {
                    "type": "integer"
                },
                "ppid": {
                    "type": "integer"
                },
                "started": {
                    "type": "integer"
                },
                "state": {
                    "$ref": "#/definitions/StatusValue"
                },
                "type": {
                    "$ref": "#/definitions/StepType"
                },
                "uuid": {
                    "type": "string"
                }
            }
        },
        "StepType": {
            "type": "string",
            "enum": [
                "clone",
                "service",
                "plugin",
                "commands",
                "cache"
            ],
            "x-enum-varnames": [
                "StepTypeClone",
                "StepTypeService",
                "StepTypePlugin",
                "StepTypeCommands",
                "StepTypeCache"
            ]
        },
        "Task": {
            "type": "object",
            "properties": {
                "agent_id": {
                    "type": "integer"
                },
                "dep_status": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/StatusValue"
                    }
                },
                "dependencies": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "id": {
                    "type": "string"
                },
                "labels": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "pid": {
                    "type": "integer"
                },
                "pipeline_id": {
                    "type": "integer"
                },
                "repo_id": {
                    "type": "integer"
                },
                "run_on": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "User": {
            "type": "object",
            "properties": {
                "admin": {
                    "description": "Admin indicates the user is a system administrator.\n\nNOTE: If the username is part of the WOODPECKER_ADMIN\nenvironment variable, this value will be set to true on login.",
                    "type": "boolean"
                },
                "avatar_url": {
                    "description": "the avatar url for this user.",
                    "type": "string"
                },
                "email": {
                    "description": "Email is the email address for this user.\n\nrequired: true",
                    "type": "string"
                },
                "forge_id": {
                    "type": "integer"
                },
                "forge_remote_id": {
                    "type": "string"
                },
                "id": {
                    "description": "the id for this user.\n\nrequired: true",
                    "type": "integer"
                },
                "login": {
                    "description": "Login is the username for this user.\n\nrequired: true",
                    "type": "string"
                },
                "org_id": {
                    "description": "OrgID is the of the user as model.Org.",
                    "type": "integer"
                }
            }
        },
        "WebhookEvent": {
            "type": "string",
            "enum": [
                "push",
                "pull_request",
                "pull_request_closed",
                "pull_request_metadata",
                "tag",
                "release",
                "deployment",
                "cron",
                "manual"
            ],
            "x-enum-varnames": [
                "EventPush",
                "EventPull",
                "EventPullClosed",
                "EventPullMetadata",
                "EventTag",
                "EventRelease",
                "EventDeploy",
                "EventCron",
                "EventManual"
            ]
        },
        "metadata.Author": {
            "type": "object",
            "properties": {
                "avatar": {
                    "type": "string"
                },
                "email": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "metadata.Commit": {
            "type": "object",
            "properties": {
                "author": {
                    "$ref": "#/definitions/metadata.Author"
                },
                "branch": {
                    "type": "string"
                },
                "changed_files": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "is_prerelease": {
                    "type": "boolean"
                },
                "labels": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "message": {
                    "type": "string"
                },
                "milestone": {
                    "type": "string"
                },
                "ref": {
                    "type": "string"
                },
                "refspec": {
                    "type": "string"
                },
                "sha": {
                    "type": "string"
                }
            }
        },
        "metadata.Forge": {
            "type": "object",
            "properties": {
                "type": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "metadata.Metadata": {
            "type": "object",
            "properties": {
                "curr": {
                    "$ref": "#/definitions/metadata.Pipeline"
                },
                "forge": {
                    "$ref": "#/definitions/metadata.Forge"
                },
                "id": {
                    "type": "string"
                },
                "prev": {
                    "$ref": "#/definitions/metadata.Pipeline"
                },
                "repo": {
                    "$ref": "#/definitions/metadata.Repo"
                },
                "step": {
                    "$ref": "#/definitions/metadata.Step"
                },
                "sys": {
                    "$ref": "#/definitions/metadata.System"
                },
                "workflow": {
                    "$ref": "#/definitions/metadata.Workflow"
                }
            }
        },
        "metadata.Pipeline": {
            "type": "object",
            "properties": {
                "author": {
                    "type": "string"
                },
                "avatar": {
                    "type": "string"
                },
                "commit": {
                    "$ref": "#/definitions/metadata.Commit"
                },
                "created": {
                    "type": "integer"
                },
                "cron": {
                    "type": "string"
                },
                "event": {
                    "type": "string"
                },
                "event_reason": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "finished": {
                    "type": "integer"
                },
                "forge_url": {
                    "type": "string"
                },
                "number": {
                    "type": "integer"
                },
                "parent": {
                    "type": "integer"
                },
                "started": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "target": {
                    "type": "string"
                },
                "task": {
                    "type": "string"
                }
            }
        },
        "metadata.Repo": {
            "type": "object",
            "properties": {
                "clone_url": {
                    "type": "string"
                },
                "clone_url_ssh": {
                    "type": "string"
                },
                "default_branch": {
                    "type": "string"
                },
                "forge_url": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "owner": {
                    "type": "string"
                },
                "private": {
                    "type": "boolean"
                },
                "remote_id": {
                    "type": "string"
                },
                "trusted": {
                    "$ref": "#/definitions/metadata.TrustedConfiguration"
                }
            }
        },
        "metadata.Step": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "number": {
                    "type": "integer"
                }
            }
        },
        "metadata.System": {
            "type": "object",
            "properties": {
                "arch": {
                    "type": "string"
                },
                "host": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "metadata.TrustedConfiguration": {
            "type": "object",
            "properties": {
                "network": {
                    "type": "boolean"
                },
                "security": {
                    "type": "boolean"
                },
                "volumes": {
                    "type": "boolean"
                }
            }
        },
        "metadata.Workflow": {
            "type": "object",
            "properties": {
                "matrix": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "number": {
                    "type": "integer"
                }
            }
        },
        "model.ApprovalMode": {
            "type": "string",
            "enum": [
                "none",
                "forks",
                "pull_requests",
                "all_events"
            ],
            "x-enum-comments": {
                "RequireApprovalAllEvents": "require approval for all external events",
                "RequireApprovalForks": "require approval for PRs from forks (default)",
                "RequireApprovalNone": "require approval for no events",
                "RequireApprovalPullRequests": "require approval for all PRs"
            },
            "x-enum-descriptions": [
                "require approval for no events",
                "require approval for PRs from forks (default)",
                "require approval for all PRs",
                "require approval for all external events"
            ],
            "x-enum-varnames": [
                "RequireApprovalNone",
                "RequireApprovalForks",
                "RequireApprovalPullRequests",
                "RequireApprovalAllEvents"
            ]
        },
        "model.ForgeType": {
            "type": "string",
            "enum": [
                "github",
                "gitlab",
                "gitea",
                "forgejo",
                "bitbucket",
                "bitbucket-dc",
                "addon"
            ],
            "x-enum-varnames": [
                "ForgeTypeGithub",
                "ForgeTypeGitlab",
                "ForgeTypeGitea",
                "ForgeTypeForgejo",
                "ForgeTypeBitbucket",
                "ForgeTypeBitbucketDatacenter",
                "ForgeTypeAddon"
            ]
        },
        "model.QueueTask": {
            "type": "object",
            "properties": {
                "agent_id": {
                    "type": "integer"
                },
                "agent_name": {
                    "type": "string"
                },
                "dep_status": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/StatusValue"
                    }
                },
                "dependencies": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "id": {
                    "type": "string"
                },
                "labels": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "pid": {
                    "type": "integer"
                },
                "pipeline_id": {
                    "type": "integer"
                },
                "pipeline_number": {
                    "type": "integer"
                },
                "repo_id": {
                    "type": "integer"
                },
                "run_on": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "model.TrustedConfiguration": {
            "type": "object",
            "properties": {
                "network": {
                    "type": "boolean"
                },
                "security": {
                    "type": "boolean"
                },
                "volumes": {
                    "type": "boolean"
                }
            }
        },
        "model.TrustedConfigurationPatch": {
            "type": "object",
            "properties": {
                "network": {
                    "type": "boolean"
                },
                "security": {
                    "type": "boolean"
                },
                "volumes": {
                    "type": "boolean"
                }
            }
        },
        "model.Workflow": {
            "type": "object",
            "properties": {
                "agent_id": {
                    "type": "integer"
                },
                "children": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/Step"
                    }
                },
                "environ": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "error": {
                    "type": "string"
                },
                "finished": {
                    "type": "integer"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                },
                "pid": {
                    "type": "integer"
                },
                "pipeline_id": {
                    "type": "integer"
                },
                "platform": {
                    "type": "string"
                },
                "started": {
                    "type": "integer"
                },
                "state": {
                    "$ref": "#/definitions/StatusValue"
                }
            }
        },
        "types.PipelineError": {
            "type": "object",
            "properties": {
                "data": {},
                "is_warning": {
                    "type": "boolean"
                },
                "message": {
                    "type": "string"
                },
                "type": {
                    "$ref": "#/definitions/types.PipelineErrorType"
                }
            }
        },
        "types.PipelineErrorType": {
            "type": "string",
            "enum": [
                "linter",
                "deprecation",
                "compiler",
                "generic",
                "bad_habit"
            ],
            "x-enum-comments": {
                "PipelineErrorTypeBadHabit": "some bad-habit error",
                "PipelineErrorTypeCompiler": "some error with the config semantics",
                "PipelineErrorTypeDeprecation": "using some deprecated feature",
                "PipelineErrorTypeGeneric": "some generic error",
                "PipelineErrorTypeLinter": "some error with the config syntax"
            },
            "x-enum-descriptions": [
                "some error with the config syntax",
                "using some deprecated feature",
                "some error with the config semantics",
                "some generic error",
                "some bad-habit error"
            ],
            "x-enum-varnames": [
                "PipelineErrorTypeLinter",
                "PipelineErrorTypeDeprecation",
                "PipelineErrorTypeCompiler",
                "PipelineErrorTypeGeneric",
                "PipelineErrorTypeBadHabit"
            ]
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "",
	Host:             "",
	BasePath:         "/api",
	Schemes:          []string{},
	Title:            "Woodpecker CI API",
	Description:      "Woodpecker is a simple, yet powerful CI/CD engine with great extensibility.\nTo get a personal access token (PAT) for authentication, please log in your Woodpecker server,\nand go to you personal profile page, by clicking the user icon at the top right.",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
	LeftDelim:        "{{",
	RightDelim:       "}}",
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
