/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.MirrorCheckpointConfig;
import org.apache.kafka.connect.mirror.MirrorCheckpointMetrics;

public class MirrorCheckpointTaskConfig
extends MirrorCheckpointConfig {
    private static final String TASK_CONSUMER_GROUPS_DOC = "Consumer groups assigned to this task to replicate.";
    protected static final ConfigDef TASK_CONFIG_DEF = new ConfigDef(CONNECTOR_CONFIG_DEF).define("task.assigned.groups", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.ValidList.anyNonDuplicateValues((boolean)false, (boolean)false), ConfigDef.Importance.LOW, "Consumer groups assigned to this task to replicate.").define("task.index", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The index of the task");

    public MirrorCheckpointTaskConfig(Map<String, String> props) {
        super(TASK_CONFIG_DEF, props);
    }

    Set<String> taskConsumerGroups() {
        return new HashSet<String>(this.getList("task.assigned.groups"));
    }

    MirrorCheckpointMetrics metrics() {
        MirrorCheckpointMetrics metrics = new MirrorCheckpointMetrics(this);
        this.metricsReporters().forEach(metrics::addReporter);
        return metrics;
    }

    @Override
    String entityLabel() {
        return super.entityLabel() + "-" + String.valueOf(this.getInt("task.index") == null ? "?" : this.getInt("task.index"));
    }
}

