/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.ClientQuotaEntity;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClientSensors;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.quota.QuotaUtils;
import org.apache.kafka.server.quota.SensorAccess;
import org.apache.kafka.server.quota.ThrottleCallback;
import org.apache.kafka.server.quota.ThrottledChannel;
import org.apache.kafka.server.util.ShutdownableThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientQuotaManager {
    public static final int NO_QUOTAS = 0;
    public static final int CLIENT_ID_QUOTA_ENABLED = 1;
    public static final int USER_QUOTA_ENABLED = 2;
    public static final int USER_CLIENT_ID_QUOTA_ENABLED = 4;
    public static final int CUSTOM_QUOTAS = 8;
    private static final Logger LOG = LoggerFactory.getLogger(ClientQuotaManager.class);
    private final ConcurrentHashMap<Integer, Integer> activeQuotaEntities = new ConcurrentHashMap();
    private static final int INACTIVE_SENSOR_EXPIRATION_TIME_SECONDS = 3600;
    private static final String DEFAULT_NAME = "<default>";
    public static final ClientQuotaEntity.ConfigEntity DEFAULT_USER_ENTITY = new ClientQuotaEntity.ConfigEntity(){

        public ClientQuotaEntity.ConfigEntityType entityType() {
            return ClientQuotaEntity.ConfigEntityType.DEFAULT_USER;
        }

        public String name() {
            return ClientQuotaManager.DEFAULT_NAME;
        }

        public String toString() {
            return "default user";
        }
    };
    public static final ClientQuotaEntity.ConfigEntity DEFAULT_USER_CLIENT_ID = new ClientQuotaEntity.ConfigEntity(){

        public ClientQuotaEntity.ConfigEntityType entityType() {
            return ClientQuotaEntity.ConfigEntityType.DEFAULT_CLIENT_ID;
        }

        public String name() {
            return ClientQuotaManager.DEFAULT_NAME;
        }

        public String toString() {
            return "default client-id";
        }
    };
    private static final KafkaQuotaEntity DEFAULT_CLIENT_ID_QUOTA_ENTITY = new KafkaQuotaEntity(null, DEFAULT_USER_CLIENT_ID);
    private static final KafkaQuotaEntity DEFAULT_USER_QUOTA_ENTITY = new KafkaQuotaEntity(DEFAULT_USER_ENTITY, null);
    private static final KafkaQuotaEntity DEFAULT_USER_CLIENT_ID_QUOTA_ENTITY = new KafkaQuotaEntity(DEFAULT_USER_ENTITY, DEFAULT_USER_CLIENT_ID);
    public static final String USER_TAG = "user";
    public static final String CLIENT_ID_TAG = "client-id";
    private final ClientQuotaManagerConfig config;
    protected final Metrics metrics;
    private final QuotaType quotaType;
    protected final Time time;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final SensorAccess sensorAccessor;
    private final ClientQuotaCallback quotaCallback;
    private final ClientQuotaType clientQuotaType;
    private volatile int quotaTypesEnabled;
    private final Sensor delayQueueSensor;
    private final DelayQueue<ThrottledChannel> delayQueue = new DelayQueue();
    private final ThrottledChannelReaper throttledChannelReaper;

    public int quotaTypesEnabled() {
        return this.quotaTypesEnabled;
    }

    public void processThrottledChannelReaperDoWork() {
        this.throttledChannelReaper.doWork();
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time, String threadNamePrefix, Optional<Plugin<ClientQuotaCallback>> clientQuotaCallbackPlugin) {
        this.config = config;
        this.metrics = metrics;
        this.quotaType = quotaType;
        this.time = time;
        this.sensorAccessor = new SensorAccess((ReadWriteLock)this.lock, metrics);
        this.clientQuotaType = QuotaType.toClientQuotaType((QuotaType)quotaType);
        this.quotaTypesEnabled = clientQuotaCallbackPlugin.isPresent() ? 8 : 0;
        this.delayQueueSensor = metrics.sensor(String.valueOf(quotaType) + "-delayQueue");
        this.delayQueueSensor.add(metrics.metricName("queue-size", quotaType.toString(), "Tracks the size of the delay queue"), (MeasurableStat)new CumulativeSum());
        this.throttledChannelReaper = new ThrottledChannelReaper(this.delayQueue, threadNamePrefix);
        this.quotaCallback = clientQuotaCallbackPlugin.map(Plugin::get).orElse(new DefaultQuotaCallback());
        this.start();
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time, String threadNamePrefix) {
        this(config, metrics, quotaType, time, threadNamePrefix, Optional.empty());
    }

    protected Metrics metrics() {
        return this.metrics;
    }

    protected Time time() {
        return this.time;
    }

    private void start() {
        this.throttledChannelReaper.start();
    }

    public boolean quotasEnabled() {
        return this.quotaTypesEnabled != 0;
    }

    public int maybeRecordAndGetThrottleTimeMs(Session session, String clientId, double value, long timeMs) {
        if (this.quotasEnabled()) {
            return this.recordAndGetThrottleTimeMs(session, clientId, value, timeMs);
        }
        return 0;
    }

    public int recordAndGetThrottleTimeMs(Session session, String clientId, double value, long timeMs) {
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
        try {
            clientSensors.quotaSensor().record(value, timeMs, true);
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)this.throttleTime(e, timeMs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Quota violated for sensor ({}). Delay time: ({})", (Object)clientSensors.quotaSensor().name(), (Object)throttleTimeMs);
            }
            return throttleTimeMs;
        }
    }

    public void recordNoThrottle(Session session, String clientId, double value) {
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
        clientSensors.quotaSensor().record(value, this.time.milliseconds(), false);
    }

    public void unrecordQuotaSensor(Session session, String clientId, double value, long timeMs) {
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
        clientSensors.quotaSensor().record(value * -1.0, timeMs, false);
    }

    public double maxValueInQuotaWindow(Session session, String clientId) {
        if (!this.quotasEnabled()) {
            return Double.MAX_VALUE;
        }
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
        Double limit = this.quotaCallback.quotaLimit(this.clientQuotaType, clientSensors.metricTags());
        if (limit != null) {
            return limit * (double)(this.config.numQuotaSamples() - 1) * (double)this.config.quotaWindowSizeSeconds();
        }
        return Double.MAX_VALUE;
    }

    public void throttle(String clientId, Session session, ThrottleCallback throttleCallback, int throttleTimeMs) {
        if (throttleTimeMs > 0) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            clientSensors.throttleTimeSensor().record((double)throttleTimeMs);
            ThrottledChannel throttledChannel = new ThrottledChannel(this.time, throttleTimeMs, throttleCallback);
            this.delayQueue.add(throttledChannel);
            this.delayQueueSensor.record();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel throttled for sensor ({}). Delay time: ({})", (Object)clientSensors.quotaSensor().name(), (Object)throttleTimeMs);
            }
        }
    }

    public Quota quota(String user, String clientId) {
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", user);
        return this.quota(userPrincipal, clientId);
    }

    public Quota quota(KafkaPrincipal userPrincipal, String clientId) {
        Map metricTags = this.quotaCallback.quotaMetricTags(this.clientQuotaType, userPrincipal, clientId);
        return Quota.upperBound((double)this.quotaLimit(metricTags));
    }

    private double quotaLimit(Map<String, String> metricTags) {
        Double limit = this.quotaCallback.quotaLimit(this.clientQuotaType, metricTags);
        return limit != null ? limit : 9.223372036854776E18;
    }

    protected long throttleTime(QuotaViolationException e, long timeMs) {
        return QuotaUtils.throttleTime((QuotaViolationException)e, (long)timeMs);
    }

    public ClientSensors getOrCreateQuotaSensors(Session session, String clientId) {
        Map map;
        ClientQuotaCallback clientQuotaCallback = this.quotaCallback;
        if (clientQuotaCallback instanceof DefaultQuotaCallback) {
            DefaultQuotaCallback defaultCallback = (DefaultQuotaCallback)clientQuotaCallback;
            map = defaultCallback.quotaMetricTags(session.sanitizedUser, clientId);
        } else {
            map = this.quotaCallback.quotaMetricTags(this.clientQuotaType, session.principal, clientId);
        }
        Map metricTags = map;
        ClientSensors sensors = new ClientSensors(metricTags, this.sensorAccessor.getOrCreate(this.getQuotaSensorName(metricTags), 3600L, sensor -> this.registerQuotaMetrics(metricTags, (Sensor)sensor)), this.sensorAccessor.getOrCreate(this.getThrottleTimeSensorName(metricTags), 3600L, sensor -> sensor.add(this.throttleMetricName(metricTags), (MeasurableStat)new Avg())));
        if (this.quotaCallback.quotaResetRequired(this.clientQuotaType)) {
            this.updateQuotaMetricConfigs();
        }
        return sensors;
    }

    protected void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        sensor.add(this.clientQuotaMetricName(metricTags), (MeasurableStat)new Rate(), this.getQuotaMetricConfig(metricTags));
    }

    private String metricTagsToSensorSuffix(Map<String, String> metricTags) {
        return String.join((CharSequence)":", metricTags.values());
    }

    private String getThrottleTimeSensorName(Map<String, String> metricTags) {
        return this.quotaType.toString() + "ThrottleTime-" + this.metricTagsToSensorSuffix(metricTags);
    }

    private String getQuotaSensorName(Map<String, String> metricTags) {
        return this.quotaType.toString() + "-" + this.metricTagsToSensorSuffix(metricTags);
    }

    protected MetricConfig getQuotaMetricConfig(Map<String, String> metricTags) {
        return this.getQuotaMetricConfig(this.quotaLimit(metricTags));
    }

    private MetricConfig getQuotaMetricConfig(double quotaLimit) {
        return new MetricConfig().timeWindow((long)this.config.quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config.numQuotaSamples()).quota(new Quota(quotaLimit, true));
    }

    protected Sensor getOrCreateSensor(String sensorName, long expirationTimeSeconds, Consumer<Sensor> registerMetrics) {
        return this.sensorAccessor.getOrCreate(sensorName, expirationTimeSeconds, registerMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQuota(Optional<ClientQuotaEntity.ConfigEntity> userEntity, Optional<ClientQuotaEntity.ConfigEntity> clientEntity, Optional<Quota> quota) {
        this.lock.writeLock().lock();
        try {
            KafkaQuotaEntity quotaEntity = new KafkaQuotaEntity(userEntity.orElse(null), clientEntity.orElse(null));
            if (quota.isPresent()) {
                this.updateQuotaTypes(quotaEntity, true);
                this.quotaCallback.updateQuota(this.clientQuotaType, (ClientQuotaEntity)quotaEntity, quota.get().bound());
            } else {
                this.updateQuotaTypes(quotaEntity, false);
                this.quotaCallback.removeQuota(this.clientQuotaType, (ClientQuotaEntity)quotaEntity);
            }
            Optional<KafkaQuotaEntity> updatedEntity = userEntity.filter(entity -> entity == DEFAULT_USER_ENTITY).isPresent() || clientEntity.filter(entity -> entity == DEFAULT_USER_CLIENT_ID).isPresent() ? Optional.empty() : Optional.of(quotaEntity);
            this.updateQuotaMetricConfigs(updatedEntity);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void updateQuotaTypes(KafkaQuotaEntity quotaEntity, boolean shouldAdd) {
        DefaultQuotaCallback defaultCallback;
        boolean isActive;
        if (this.quotaTypesEnabled == 8) {
            return;
        }
        ClientQuotaCallback clientQuotaCallback = this.quotaCallback;
        boolean bl = isActive = !(clientQuotaCallback instanceof DefaultQuotaCallback) || (defaultCallback = (DefaultQuotaCallback)clientQuotaCallback).getActiveQuotasEntities().contains(quotaEntity);
        int activeQuotaType = quotaEntity.userEntity() != null && quotaEntity.clientIdEntity() != null ? 4 : (quotaEntity.userEntity() != null ? 2 : (quotaEntity.clientIdEntity() != null ? 1 : 0));
        if (shouldAdd && !isActive) {
            this.activeQuotaEntities.compute(activeQuotaType, (key, currentValue) -> currentValue == null || currentValue == 0 ? 1 : currentValue + 1);
            this.quotaTypesEnabled |= activeQuotaType;
        } else if (!shouldAdd && isActive) {
            this.activeQuotaEntities.compute(activeQuotaType, (key, currentValue) -> currentValue == null || currentValue <= 1 ? 0 : currentValue - 1);
            if (this.activeQuotaEntities.getOrDefault(activeQuotaType, 0) == 0) {
                this.quotaTypesEnabled &= ~activeQuotaType;
            }
        }
        Map<Integer, String> quotaTypeNames = Map.of(4, "UserClientIdQuota", 1, "ClientIdQuota", 2, "UserQuota");
        String activeEntities = quotaTypeNames.entrySet().stream().filter(entry -> this.activeQuotaEntities.getOrDefault(entry.getKey(), 0) > 0).map(Map.Entry::getValue).collect(Collectors.joining(", "));
        LOG.info("Quota types enabled has been changed to {} with active quota entities: [{}]", (Object)this.quotaTypesEnabled, (Object)activeEntities);
    }

    public void updateQuotaMetricConfigs() {
        this.updateQuotaMetricConfigs(Optional.empty());
    }

    public void updateQuotaMetricConfigs(Optional<KafkaQuotaEntity> updatedQuotaEntity) {
        boolean singleUpdate;
        Map allMetrics = this.metrics.metrics();
        switch (this.quotaTypesEnabled) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                boolean bl = updatedQuotaEntity.isPresent();
                break;
            }
            default: {
                boolean bl = singleUpdate = false;
            }
        }
        if (singleUpdate) {
            String clientId;
            KafkaQuotaEntity quotaEntity = updatedQuotaEntity.orElseThrow(() -> new IllegalStateException("Quota entity not specified"));
            String user = quotaEntity.sanitizedUser();
            Map<String, String> metricTags = Map.of(USER_TAG, user, CLIENT_ID_TAG, clientId = quotaEntity.clientId());
            MetricName quotaMetricName = this.clientQuotaMetricName(metricTags);
            KafkaMetric metric2 = (KafkaMetric)allMetrics.get(quotaMetricName);
            if (metric2 != null) {
                double newQuota = this.quotaLimit(metricTags);
                LOG.info("Sensor for {} already exists. Changing quota to {} in MetricConfig", (Object)quotaEntity, (Object)newQuota);
                metric2.config(this.getQuotaMetricConfig(newQuota));
            }
        } else {
            MetricName quotaMetricName = this.clientQuotaMetricName(Map.of());
            allMetrics.forEach((metricName, metric) -> {
                Map metricTags;
                double newQuota;
                if (metricName.name().equals(quotaMetricName.name()) && metricName.group().equals(quotaMetricName.group()) && Double.compare(newQuota = this.quotaLimit(metricTags = metricName.tags()), metric.config().quota().bound()) != 0) {
                    LOG.info("Sensor for quota-id {} already exists. Setting quota to {} in MetricConfig", (Object)metricTags, (Object)newQuota);
                    metric.config(this.getQuotaMetricConfig(newQuota));
                }
            });
        }
    }

    protected MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics.metricName("byte-rate", this.quotaType.toString(), "Tracking byte-rate per user/client-id", quotaMetricTags);
    }

    private MetricName throttleMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics.metricName("throttle-time", this.quotaType.toString(), "Tracking average throttle-time per user/client-id", quotaMetricTags);
    }

    public void initiateShutdown() {
        this.throttledChannelReaper.initiateShutdown();
        this.delayQueue.add(new ThrottledChannel(this.time, 0, new ThrottleCallback(){

            @Override
            public void startThrottling() {
            }

            @Override
            public void endThrottling() {
            }
        }));
    }

    public void shutdown() {
        this.initiateShutdown();
        try {
            this.throttledChannelReaper.awaitShutdown();
        }
        catch (InterruptedException e) {
            LOG.warn("Shutdown was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public class ThrottledChannelReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledChannel> delayQueue;

        public ThrottledChannelReaper(DelayQueue<ThrottledChannel> delayQueue, String prefix) {
            super(prefix + "ThrottledChannelReaper-" + String.valueOf(ClientQuotaManager.this.quotaType), false);
            this.delayQueue = delayQueue;
        }

        public void doWork() {
            try {
                ThrottledChannel throttledChannel = (ThrottledChannel)this.delayQueue.poll(1L, TimeUnit.SECONDS);
                if (throttledChannel != null) {
                    ClientQuotaManager.this.delayQueueSensor.record(-1.0);
                    throttledChannel.notifyThrottlingDone();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class DefaultQuotaCallback
    implements ClientQuotaCallback {
        private final ConcurrentHashMap<ClientQuotaEntity, Quota> overriddenQuotas = new ConcurrentHashMap();

        private DefaultQuotaCallback() {
        }

        public void configure(Map<String, ?> configs) {
        }

        public Map<String, String> quotaMetricTags(ClientQuotaType quotaType, KafkaPrincipal principal, String clientId) {
            return this.quotaMetricTags(Sanitizer.sanitize((String)principal.getName()), clientId);
        }

        public Double quotaLimit(ClientQuotaType quotaType, Map<String, String> metricTags) {
            String sanitizedUser = metricTags.get(ClientQuotaManager.USER_TAG);
            String clientId = metricTags.get(ClientQuotaManager.CLIENT_ID_TAG);
            if (sanitizedUser == null || clientId == null) {
                return null;
            }
            UserEntity userEntity = new UserEntity(sanitizedUser);
            ClientIdEntity clientIdEntity = new ClientIdEntity(clientId);
            Quota quota = this.findQuota(sanitizedUser, clientId, userEntity, clientIdEntity);
            return quota != null ? Double.valueOf(quota.bound()) : null;
        }

        private Quota findQuota(String sanitizedUser, String clientId, UserEntity userEntity, ClientIdEntity clientIdEntity) {
            if (!sanitizedUser.isEmpty() && !clientId.isEmpty()) {
                return this.findUserClientQuota(userEntity, clientIdEntity);
            }
            if (!sanitizedUser.isEmpty()) {
                return this.findUserQuota(userEntity);
            }
            if (!clientId.isEmpty()) {
                return this.findClientQuota(clientIdEntity);
            }
            return null;
        }

        private Quota findUserClientQuota(UserEntity userEntity, ClientIdEntity clientIdEntity) {
            Quota quota = this.overriddenQuotas.get(new KafkaQuotaEntity(userEntity, clientIdEntity));
            if (quota != null) {
                return quota;
            }
            quota = this.overriddenQuotas.get(new KafkaQuotaEntity(userEntity, DEFAULT_USER_CLIENT_ID));
            if (quota != null) {
                return quota;
            }
            quota = this.overriddenQuotas.get(new KafkaQuotaEntity(DEFAULT_USER_ENTITY, clientIdEntity));
            if (quota != null) {
                return quota;
            }
            return this.overriddenQuotas.get(DEFAULT_USER_CLIENT_ID_QUOTA_ENTITY);
        }

        private Quota findUserQuota(UserEntity userEntity) {
            Quota quota = this.overriddenQuotas.get(new KafkaQuotaEntity(userEntity, null));
            if (quota != null) {
                return quota;
            }
            return this.overriddenQuotas.get(DEFAULT_USER_QUOTA_ENTITY);
        }

        private Quota findClientQuota(ClientIdEntity clientIdEntity) {
            Quota quota = this.overriddenQuotas.get(new KafkaQuotaEntity(null, clientIdEntity));
            if (quota != null) {
                return quota;
            }
            return this.overriddenQuotas.get(DEFAULT_CLIENT_ID_QUOTA_ENTITY);
        }

        public boolean updateClusterMetadata(Cluster cluster) {
            return false;
        }

        public void updateQuota(ClientQuotaType quotaType, ClientQuotaEntity entity, double newValue) {
            KafkaQuotaEntity quotaEntity = (KafkaQuotaEntity)entity;
            LOG.info("Changing {} quota for {} to {}", new Object[]{quotaType, quotaEntity, newValue});
            this.overriddenQuotas.put(quotaEntity, new Quota(newValue, true));
        }

        public void removeQuota(ClientQuotaType quotaType, ClientQuotaEntity entity) {
            KafkaQuotaEntity quotaEntity = (KafkaQuotaEntity)entity;
            LOG.info("Removing {} quota for {}", (Object)quotaType, (Object)quotaEntity);
            this.overriddenQuotas.remove(quotaEntity);
        }

        public boolean quotaResetRequired(ClientQuotaType quotaType) {
            return false;
        }

        public Set<ClientQuotaEntity> getActiveQuotasEntities() {
            return this.overriddenQuotas.keySet();
        }

        public Map<String, String> quotaMetricTags(String sanitizedUser, String clientId) {
            String clientIdTag;
            String userTag;
            switch (ClientQuotaManager.this.quotaTypesEnabled) {
                case 0: 
                case 1: {
                    userTag = "";
                    clientIdTag = clientId;
                    break;
                }
                case 2: {
                    userTag = sanitizedUser;
                    clientIdTag = "";
                    break;
                }
                case 4: {
                    userTag = sanitizedUser;
                    clientIdTag = clientId;
                    break;
                }
                default: {
                    UserEntity userEntity = new UserEntity(sanitizedUser);
                    ClientIdEntity clientIdEntity = new ClientIdEntity(clientId);
                    userTag = sanitizedUser;
                    clientIdTag = clientId;
                    if (this.overriddenQuotas.containsKey(new KafkaQuotaEntity(userEntity, clientIdEntity))) break;
                    userTag = sanitizedUser;
                    clientIdTag = clientId;
                    if (this.overriddenQuotas.containsKey(new KafkaQuotaEntity(userEntity, DEFAULT_USER_CLIENT_ID))) break;
                    userTag = sanitizedUser;
                    clientIdTag = "";
                    if (this.overriddenQuotas.containsKey(new KafkaQuotaEntity(userEntity, null))) break;
                    userTag = sanitizedUser;
                    clientIdTag = clientId;
                    if (this.overriddenQuotas.containsKey(new KafkaQuotaEntity(DEFAULT_USER_ENTITY, clientIdEntity))) break;
                    userTag = sanitizedUser;
                    clientIdTag = clientId;
                    if (this.overriddenQuotas.containsKey(DEFAULT_USER_CLIENT_ID_QUOTA_ENTITY)) break;
                    userTag = sanitizedUser;
                    clientIdTag = "";
                    if (this.overriddenQuotas.containsKey(DEFAULT_USER_QUOTA_ENTITY)) break;
                    userTag = "";
                    clientIdTag = clientId;
                }
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            result.put(ClientQuotaManager.USER_TAG, userTag);
            result.put(ClientQuotaManager.CLIENT_ID_TAG, clientIdTag);
            return result;
        }

        public void close() {
        }
    }

    public record KafkaQuotaEntity(ClientQuotaEntity.ConfigEntity userEntity, ClientQuotaEntity.ConfigEntity clientIdEntity) implements ClientQuotaEntity
    {
        public List<ClientQuotaEntity.ConfigEntity> configEntities() {
            ArrayList<ClientQuotaEntity.ConfigEntity> entities = new ArrayList<ClientQuotaEntity.ConfigEntity>();
            if (this.userEntity != null) {
                entities.add(this.userEntity);
            }
            if (this.clientIdEntity != null) {
                entities.add(this.clientIdEntity);
            }
            return entities;
        }

        public String sanitizedUser() {
            ClientQuotaEntity.ConfigEntity configEntity = this.userEntity;
            if (configEntity instanceof UserEntity) {
                UserEntity userRecord = (UserEntity)configEntity;
                return userRecord.sanitizedUser();
            }
            if (this.userEntity == DEFAULT_USER_ENTITY) {
                return ClientQuotaManager.DEFAULT_NAME;
            }
            return "";
        }

        public String clientId() {
            return this.clientIdEntity != null ? this.clientIdEntity.name() : "";
        }

        @Override
        public String toString() {
            String user = this.userEntity != null ? this.userEntity.toString() : "";
            String clientId = this.clientIdEntity != null ? this.clientIdEntity.toString() : "";
            return (user + " " + clientId).trim();
        }
    }

    public record ClientIdEntity(String clientId) implements ClientQuotaEntity.ConfigEntity
    {
        public ClientQuotaEntity.ConfigEntityType entityType() {
            return ClientQuotaEntity.ConfigEntityType.CLIENT_ID;
        }

        public String name() {
            return this.clientId;
        }

        @Override
        public String toString() {
            return "client-id " + this.clientId;
        }
    }

    public record UserEntity(String sanitizedUser) implements ClientQuotaEntity.ConfigEntity
    {
        public ClientQuotaEntity.ConfigEntityType entityType() {
            return ClientQuotaEntity.ConfigEntityType.USER;
        }

        public String name() {
            return Sanitizer.desanitize((String)this.sanitizedUser);
        }

        @Override
        public String toString() {
            return "user " + this.sanitizedUser;
        }
    }
}

