/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.telnet;

import java.net.BindException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.equinox.console.telnet.TelnetServer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class TelnetCommand {
    private String defaultHost;
    private int defaultPort;
    private final List<CommandProcessor> processors;
    private final BundleContext context;
    private String host;
    private int port;
    private TelnetServer telnetServer;
    private ServiceRegistration<?> configuratorRegistration;
    private boolean isEnabled;
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String USE_CONFIG_ADMIN_PROP = "osgi.console.useConfigAdmin";
    private static final String TELNET_PID = "osgi.console.telnet";
    private static final String CONSOLE_PROP = "osgi.console";
    private static final String ENABLED = "enabled";
    private final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TelnetCommand(CommandProcessor processor, BundleContext context) {
        block6: {
            this.defaultHost = null;
            this.processors = new ArrayList<CommandProcessor>();
            this.host = null;
            this.telnetServer = null;
            this.isEnabled = false;
            this.lock = new Object();
            this.processors.add(processor);
            this.context = context;
            if ("true".equals(context.getProperty(USE_CONFIG_ADMIN_PROP))) {
                Hashtable<String, String> telnetProperties = new Hashtable<String, String>();
                ((Dictionary)telnetProperties).put("service.pid", TELNET_PID);
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.configuratorRegistration = context.registerService(ManagedService.class.getName(), (Object)new TelnetConfigurator(), telnetProperties);
                        break block6;
                    }
                }
                catch (NoClassDefFoundError e) {
                    System.out.println("Configuration Admin not available!");
                    return;
                }
            }
            this.parseHostAndPort();
        }
    }

    private void parseHostAndPort() {
        String telnetPort = null;
        String consolePropValue = this.context.getProperty(CONSOLE_PROP);
        if (consolePropValue != null) {
            int index = consolePropValue.lastIndexOf(58);
            if (index > -1) {
                this.defaultHost = consolePropValue.substring(0, index);
            }
            telnetPort = consolePropValue.substring(index + 1);
            this.isEnabled = true;
        }
        if (telnetPort != null && !"".equals(telnetPort)) {
            try {
                this.defaultPort = Integer.parseInt(telnetPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public synchronized void startService() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.command.scope", "equinox");
        ((Dictionary)properties).put("osgi.command.function", new String[]{"telnet"});
        if ((this.port > 0 || this.defaultPort > 0) && this.isEnabled) {
            try {
                this.telnet(new String[]{"start"});
            }
            catch (Exception e) {
                System.out.println("Cannot start telnet. Reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.context.registerService(TelnetCommand.class.getName(), (Object)this, properties);
    }

    @Descriptor(value="start/stop a telnet server")
    public synchronized void telnet(String[] arguments) throws Exception {
        String command = null;
        int newPort = 0;
        String newHost = null;
        int i = 0;
        while (i < arguments.length) {
            if ("-?".equals(arguments[i]) || "-help".equals(arguments[i])) {
                this.printHelp();
                return;
            }
            if ("start".equals(arguments[i])) {
                command = "start";
            } else if ("stop".equals(arguments[i])) {
                command = "stop";
            } else if ("-port".equals(arguments[i]) && arguments.length > i + 1) {
                newPort = Integer.parseInt(arguments[++i]);
            } else if ("-host".equals(arguments[i]) && arguments.length > i + 1) {
                newHost = arguments[++i];
            } else {
                throw new Exception("Unrecognized telnet command/option " + arguments[i]);
            }
            ++i;
        }
        if (command == null) {
            throw new Exception("No telnet command specified");
        }
        if (newPort != 0) {
            this.port = newPort;
        } else if (this.port == 0) {
            this.port = this.defaultPort;
        }
        if (this.port == 0) {
            throw new Exception("No telnet port specified");
        }
        this.host = newHost != null ? newHost : this.defaultHost;
        if ("start".equals(command)) {
            if (this.telnetServer != null) {
                throw new IllegalStateException("telnet is already running on port " + this.port);
            }
            try {
                this.telnetServer = new TelnetServer(this.context, this.processors, this.host, this.port);
            }
            catch (BindException e) {
                throw new Exception("Port " + this.port + " already in use");
            }
            this.telnetServer.setName("equinox telnet");
            this.telnetServer.start();
        } else if ("stop".equals(command)) {
            if (this.telnetServer == null) {
                System.out.println("telnet is not running.");
                return;
            }
            this.telnetServer.stopTelnetServer();
            this.telnetServer = null;
        }
    }

    public synchronized void addCommandProcessor(CommandProcessor processor) {
        this.processors.add(processor);
        if (this.telnetServer != null) {
            this.telnetServer.addCommandProcessor(processor);
        }
    }

    public synchronized void removeCommandProcessor(CommandProcessor processor) {
        this.processors.remove(processor);
        if (this.telnetServer != null) {
            this.telnetServer.removeCommandProcessor(processor);
        }
    }

    private void printHelp() {
        StringBuilder help = new StringBuilder();
        help.append("telnet - start simple telnet server");
        help.append("\n");
        help.append("Usage: telnet start | stop [-port port] [-host host]");
        help.append("\n");
        help.append("\t");
        help.append("-port");
        help.append("\t");
        help.append("listen port (default=");
        help.append(this.defaultPort);
        help.append(")");
        help.append("\n");
        help.append("\t");
        help.append("-host");
        help.append("\t");
        help.append("local host address to listen on (default is none - listen on all network interfaces)");
        help.append("\n");
        help.append("\t");
        help.append("-?, -help");
        help.append("\t");
        help.append("show help");
        System.out.println(help.toString());
    }

    class TelnetConfigurator
    implements ManagedService {
        private Dictionary<String, Object> properties;

        TelnetConfigurator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void updated(Dictionary<String, ?> props) throws ConfigurationException {
            if (props == null) {
                return;
            }
            Object unchecked = props;
            this.properties = unchecked;
            this.properties.put("service.pid", TelnetCommand.TELNET_PID);
            TelnetCommand.this.defaultPort = Integer.parseInt((String)this.properties.get(TelnetCommand.PORT));
            TelnetCommand.this.defaultHost = (String)this.properties.get(TelnetCommand.HOST);
            if (this.properties.get(TelnetCommand.ENABLED) == null) {
                TelnetCommand.this.isEnabled = false;
            } else {
                TelnetCommand.this.isEnabled = Boolean.parseBoolean((String)this.properties.get(TelnetCommand.ENABLED));
            }
            unchecked = TelnetCommand.this.lock;
            synchronized (unchecked) {
                TelnetCommand.this.configuratorRegistration.setProperties(this.properties);
            }
            if (TelnetCommand.this.telnetServer == null && TelnetCommand.this.isEnabled) {
                try {
                    TelnetCommand.this.telnet(new String[]{"start"});
                }
                catch (Exception e) {
                    System.out.println("Cannot start telnet: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

