/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.googleai.GeminiThinkingConfig;
import dev.langchain4j.model.googleai.GoogleAiGeminiChatModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.util.Map;
import org.freeplane.plugin.ai.chat.AIModelSelection;
import org.freeplane.plugin.ai.chat.AIProviderConfiguration;

public class AIChatModelFactory {
    public static final String PROVIDER_NAME_OPENROUTER = "openrouter";
    public static final String PROVIDER_NAME_GEMINI = "gemini";
    public static final String PROVIDER_NAME_OLLAMA = "ollama";
    public static final String DEFAULT_OPENROUTER_SERVICE_ADDRESS = "https://openrouter.ai/api/v1";
    static final int CHAT_MODEL_MAX_RETRIES = 2;

    private AIChatModelFactory() {
    }

    public static ChatModel createChatLanguageModel(AIProviderConfiguration configuration) {
        AIModelSelection selection = AIModelSelection.fromSelectionValue(configuration.getSelectedModelValue());
        if (selection == null) {
            throw new IllegalArgumentException("Missing model selection");
        }
        String providerName = selection.getProviderName();
        String modelName = selection.getModelName();
        if (PROVIDER_NAME_OPENROUTER.equalsIgnoreCase(providerName)) {
            return OpenAiChatModel.builder().baseUrl(AIChatModelFactory.getOpenrouterServiceAddress(configuration)).apiKey(configuration.getOpenRouterKey()).modelName(modelName).maxRetries(Integer.valueOf(2)).build();
        }
        if (PROVIDER_NAME_GEMINI.equalsIgnoreCase(providerName)) {
            GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder builder = ((GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder)((GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder)GoogleAiGeminiChatModel.builder().apiKey(configuration.getGeminiKey())).modelName(modelName)).maxRetries(Integer.valueOf(2));
            String serviceAddress = configuration.getGeminiServiceAddress();
            if (serviceAddress != null && !serviceAddress.isEmpty()) {
                builder.baseUrl(serviceAddress);
            }
            if (modelName != null && modelName.startsWith("gemini-3-")) {
                GeminiThinkingConfig thinkingConfig = GeminiThinkingConfig.builder().includeThoughts(Boolean.valueOf(true)).build();
                ((GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder)((GoogleAiGeminiChatModel.GoogleAiGeminiChatModelBuilder)builder.thinkingConfig(thinkingConfig)).returnThinking(Boolean.valueOf(true))).sendThinking(Boolean.valueOf(true));
            }
            return builder.build();
        }
        if (PROVIDER_NAME_OLLAMA.equalsIgnoreCase(providerName)) {
            OllamaChatModel.OllamaChatModelBuilder builder = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AIChatModelFactory.getOllamaServiceAddress(configuration))).modelName(modelName)).maxRetries(Integer.valueOf(2));
            Map<String, String> requestHeaders = configuration.getOllamaRequestHeaders();
            if (!requestHeaders.isEmpty()) {
                builder.customHeaders(requestHeaders);
            }
            return builder.build();
        }
        throw new IllegalArgumentException("Unknown provider name: " + providerName);
    }

    private static String getOpenrouterServiceAddress(AIProviderConfiguration configuration) {
        String serviceAddress = configuration.getOpenrouterServiceAddress();
        if (serviceAddress == null || serviceAddress.isEmpty()) {
            return DEFAULT_OPENROUTER_SERVICE_ADDRESS;
        }
        return serviceAddress;
    }

    private static String getOllamaServiceAddress(AIProviderConfiguration configuration) {
        return configuration.getOllamaServiceAddress();
    }
}

