/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.util.Map;

public class RedBlackEntry<K, V>
implements Map.Entry<K, V> {
    final K key;
    V value;
    NodeColor color;
    RedBlackEntry<K, V> parent;
    RedBlackEntry<K, V> left;
    RedBlackEntry<K, V> right;

    RedBlackEntry(K key, V value, RedBlackEntry<K, V> parent) {
        this.key = key;
        this.value = value;
        this.parent = parent;
        this.color = NodeColor.BLACK;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V oldValue = value;
        this.value = value;
        return oldValue;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public RedBlackEntry<K, V> getSuccessor() {
        if (this.right != null) {
            RedBlackEntry<K, V> node = this.right;
            while (node.left != null) {
                node = node.left;
            }
            return node;
        }
        RedBlackEntry<K, V> node = this;
        while (node.parent != null) {
            if (node.isLeftChild()) {
                return node.parent;
            }
            node = node.parent;
        }
        return null;
    }

    public RedBlackEntry<K, V> getPredecessor() {
        if (this.left != null) {
            RedBlackEntry<K, V> node = this.left;
            while (node.right != null) {
                node = node.right;
            }
            return node;
        }
        RedBlackEntry<K, V> node = this;
        while (node.parent != null) {
            if (!node.isLeftChild()) {
                return node.parent;
            }
            node = node.parent;
        }
        return null;
    }

    boolean isLeftChild() {
        return this.parent.left == this;
    }

    boolean isRightChild() {
        return this.parent.right == this;
    }

    public boolean isDisposed() {
        return this.color == null;
    }

    static enum NodeColor {
        RED,
        BLACK;

    }
}

