/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.cmd.equate.ClearEquateCmd;
import ghidra.app.cmd.equate.SetEquateCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramSelection;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Optional;

public class ConvertCommand
extends BackgroundCommand<Program> {
    private Program program;
    private AbstractConvertAction action;
    private ListingActionContext context;
    private String msg;

    public ConvertCommand(AbstractConvertAction action, ListingActionContext context) {
        this.action = action;
        this.context = context;
        this.program = context.getProgram();
    }

    public String getName() {
        return "Convert Command";
    }

    public boolean applyTo(Program program, TaskMonitor monitor) {
        try {
            CodeUnit cu = this.action.plugin.getCodeUnit(this.context);
            if (cu instanceof Data) {
                return this.applyDataSettings((Data)cu);
            }
            if (this.context.hasSelection()) {
                this.msg = this.applyEquateOverRange(this.context.getSelection());
                return this.msg == null;
            }
            Instruction instruction = (Instruction)this.context.getCodeUnit();
            int opIndex = this.action.plugin.getOperandIndex(this.context);
            int subOpIndex = this.action.plugin.getSubOperandIndex(this.context);
            this.msg = this.applyEquate(instruction, opIndex, subOpIndex);
        }
        catch (Exception e) {
            this.msg = "Exception applying the Convert: " + e.getMessage();
        }
        return this.msg == null;
    }

    private boolean applyDataSettings(Data data) throws CodeUnitInsertionException {
        DataType dt = data.getBaseDataType();
        Data settings = data;
        Settings defaultSettings = dt.getDefaultSettings();
        if (!Scalar.class.equals((Object)data.getValueClass()) || !(dt instanceof AbstractIntegerDataType)) {
            this.msg = "Unsupported data type for convert: " + data.getDataType().getDisplayName();
            return false;
        }
        int formatChoice = this.action.getFormatChoice();
        if (formatChoice == 1) {
            AbstractIntegerDataType numDt = (AbstractIntegerDataType)dt;
            if (this.action.isSignedChoice()) {
                if (!numDt.isSigned()) {
                    AbstractIntegerDataType signedDataType = numDt.getOppositeSignednessDataType();
                    this.createData(data, (DataType)signedDataType);
                }
            } else if (numDt.isSigned()) {
                AbstractIntegerDataType unsignedDataType = numDt.getOppositeSignednessDataType();
                this.createData(data, (DataType)unsignedDataType);
            }
        }
        if (FormatSettingsDefinition.DEF.getChoice(defaultSettings) == formatChoice) {
            FormatSettingsDefinition.DEF.clear((Settings)settings);
        } else {
            FormatSettingsDefinition.DEF.setChoice((Settings)settings, formatChoice);
        }
        return true;
    }

    private void createData(Data data, DataType unsignedDataType) throws CodeUnitInsertionException {
        Listing listing = data.getProgram().getListing();
        Address addr = data.getAddress();
        listing.clearCodeUnits(addr, data.getMaxAddress(), false);
        listing.createData(addr, unsignedDataType);
    }

    private String applyEquateOverRange(ProgramSelection selection) {
        InstructionIterator it = this.program.getListing().getInstructions((AddressSetView)this.context.getSelection(), true);
        String errorMessage = null;
        for (Instruction instruction : it) {
            for (int i = 0; i < instruction.getNumOperands(); ++i) {
                String m = this.applyEquate(instruction, i, 0);
                if (errorMessage != null || m == null) continue;
                errorMessage = m;
            }
        }
        return errorMessage;
    }

    private String applyEquate(Instruction instruction, int opIndex, int subOpIndex) {
        if (instruction == null || opIndex == -1) {
            return null;
        }
        Scalar scalar = this.grabMatchingScalar(instruction, opIndex, subOpIndex);
        if (scalar == null) {
            return null;
        }
        String equateName = this.action.convertToString(this.program, scalar, false);
        if (equateName.isEmpty()) {
            return null;
        }
        EquateTable equateTable = this.program.getEquateTable();
        Equate eqt = equateTable.getEquate(equateName);
        if (eqt != null && this.valuesAreDifferent(eqt, scalar)) {
            return "Couldn't convert to " + equateName + ". Equate named " + equateName + " already exists with value of " + eqt.getValue() + ".";
        }
        Address address = instruction.getAddress();
        List equates = equateTable.getEquates(address, opIndex);
        for (Equate equate : equates) {
            if (this.valuesAreDifferent(equate, scalar)) continue;
            ClearEquateCmd cmd = new ClearEquateCmd(equate.getName(), address, opIndex);
            cmd.applyTo(this.program);
        }
        if (this.action.getFormatChoice() == 0 && (scalar.getSignedValue() >= 0L || this.action.isSignedChoice() == scalar.isSigned())) {
            return null;
        }
        SetEquateCmd cmd = new SetEquateCmd(equateName, address, opIndex, scalar.getValue());
        if (!cmd.applyTo(this.program)) {
            return "Couldn't convert to " + equateName + ". " + cmd.getStatusMsg();
        }
        return null;
    }

    private Scalar grabMatchingScalar(Instruction instruction, int opIndex, int subOpIndex) {
        Scalar scalar;
        Scalar scalarAtCursor = this.action.plugin.getScalar(this.context);
        if (scalarAtCursor.equals((Object)(scalar = this.action.plugin.getScalar((CodeUnit)instruction, opIndex, subOpIndex)))) {
            return scalar;
        }
        if (scalar == null) {
            List opObjects = instruction.getDefaultOperandRepresentationList(opIndex);
            Optional<Scalar> match = opObjects.stream().filter(Scalar.class::isInstance).map(Scalar.class::cast).filter(s -> s.equals((Object)scalarAtCursor)).findAny();
            if (match.isPresent()) {
                return match.get();
            }
        }
        return null;
    }

    public String getStatusMsg() {
        return this.msg;
    }

    private boolean valuesAreDifferent(Equate equate, Scalar scalar) {
        long value = equate.getValue();
        return value != scalar.getSignedValue() && value != scalar.getUnsignedValue();
    }
}

