/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.sourcefilestable;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.sourcefilestable.SourceMapEntryRowObject;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourceFileManager;
import ghidra.program.model.sourcemap.SourceMapEntry;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.Counter;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.List;

public class SourceMapEntryTableModel
extends GhidraProgramTableModel<SourceMapEntryRowObject> {
    private SourceFile sourceFile;
    private static final int END_ADDRESS_INDEX = 2;
    private SourceFileManager sourceManager;

    protected SourceMapEntryTableModel(ServiceProvider serviceProvider, Program program, TaskMonitor monitor, SourceFile sourceFile) {
        super("SourceMapEntryTableModel", serviceProvider, program, monitor);
        this.sourceFile = sourceFile;
        this.sourceManager = program.getSourceFileManager();
    }

    @Override
    public ProgramLocation getProgramLocation(int modelRow, int modelColumn) {
        SourceMapEntryRowObject rowObject = (SourceMapEntryRowObject)this.getRowObject(modelRow);
        if (modelColumn == 2) {
            return new ProgramLocation(this.program, this.getEndAddress(rowObject));
        }
        return new ProgramLocation(this.program, rowObject.getBaseAddress());
    }

    @Override
    public ProgramSelection getProgramSelection(int[] modelRows) {
        AddressSet selection = new AddressSet();
        for (SourceMapEntryRowObject rowObject : this.getRowObjects(modelRows)) {
            selection.addRange(rowObject.getBaseAddress(), this.getEndAddress(rowObject));
        }
        return new ProgramSelection((AddressSetView)selection);
    }

    public void refresh() {
        this.reload();
        super.refresh();
    }

    protected void doLoad(Accumulator<SourceMapEntryRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        List mapEntries = this.sourceManager.getSourceMapEntries(this.sourceFile);
        HashMap<Integer, Counter> lineCount = new HashMap<Integer, Counter>();
        for (SourceMapEntry entry : mapEntries) {
            Integer lineNumber = entry.getLineNumber();
            Counter count = lineCount.getOrDefault(lineNumber, new Counter());
            count.increment();
            lineCount.put(lineNumber, count);
        }
        for (SourceMapEntry entry : mapEntries) {
            int lineNumber = entry.getLineNumber();
            SourceMapEntryRowObject rowObject = new SourceMapEntryRowObject(entry.getBaseAddress(), lineNumber, entry.getLength(), ((Counter)lineCount.get(lineNumber)).intValue());
            accumulator.add((Object)rowObject);
        }
    }

    @Override
    protected TableColumnDescriptor<SourceMapEntryRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new BaseAddressTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new EndAddressTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new LineNumberTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new LengthTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new CountTableColumn(this));
        return descriptor;
    }

    private Address getEndAddress(SourceMapEntryRowObject rowObject) {
        long length = rowObject.getLength();
        Address baseAddress = rowObject.getBaseAddress();
        if (length == 0L) {
            return rowObject.getBaseAddress();
        }
        return baseAddress.add(length - 1L);
    }

    private class BaseAddressTableColumn
    extends AbstractDynamicTableColumn<SourceMapEntryRowObject, Address, Object> {
        private BaseAddressTableColumn(SourceMapEntryTableModel sourceMapEntryTableModel) {
        }

        public String getColumnName() {
            return "Base Address";
        }

        public Address getValue(SourceMapEntryRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getBaseAddress();
        }
    }

    private class EndAddressTableColumn
    extends AbstractDynamicTableColumn<SourceMapEntryRowObject, Address, Object> {
        private EndAddressTableColumn() {
        }

        public String getColumnName() {
            return "End Address";
        }

        public Address getValue(SourceMapEntryRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return SourceMapEntryTableModel.this.getEndAddress(rowObject);
        }
    }

    private class LineNumberTableColumn
    extends AbstractDynamicTableColumn<SourceMapEntryRowObject, Integer, Object> {
        private LineNumberTableColumn(SourceMapEntryTableModel sourceMapEntryTableModel) {
        }

        public String getColumnName() {
            return "Line Number";
        }

        public Integer getValue(SourceMapEntryRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getLineNumber();
        }
    }

    private class LengthTableColumn
    extends AbstractDynamicTableColumn<SourceMapEntryRowObject, Long, Object> {
        private LengthTableColumn(SourceMapEntryTableModel sourceMapEntryTableModel) {
        }

        public String getColumnName() {
            return "Length";
        }

        public Long getValue(SourceMapEntryRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getLength();
        }
    }

    private class CountTableColumn
    extends AbstractDynamicTableColumn<SourceMapEntryRowObject, Integer, Object> {
        private CountTableColumn(SourceMapEntryTableModel sourceMapEntryTableModel) {
        }

        public String getColumnName() {
            return "Count";
        }

        public Integer getValue(SourceMapEntryRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getCount();
        }
    }
}

