/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomAuxId
implements StructConverter {
    public static final int SIZE = 8;
    private boolean mandatory;
    private boolean copy;
    private boolean append;
    private boolean ignore;
    private int reserved;
    private int type;
    private long length;

    public SomAuxId(BinaryReader reader) throws IOException {
        int bitfield = reader.readNextInt();
        this.type = bitfield & 0xFFFF;
        this.reserved = bitfield >> 16 & 0xFFF;
        this.ignore = (bitfield >> 28 & 1) != 0;
        this.append = (bitfield >> 29 & 1) != 0;
        this.copy = (bitfield >> 30 & 1) != 0;
        this.mandatory = (bitfield >> 31 & 1) != 0;
        this.length = reader.readNextUnsignedInt();
    }

    public boolean getMandatory() {
        return this.mandatory;
    }

    public boolean getCopy() {
        return this.copy;
    }

    public boolean getAppend() {
        return this.append;
    }

    public boolean getIgnore() {
        return this.ignore;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getType() {
        return this.type;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("aux_id", 8);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(DWORD, 1, "mandatory", null);
            struct.addBitField(DWORD, 1, "copy", null);
            struct.addBitField(DWORD, 1, "append", null);
            struct.addBitField(DWORD, 1, "ignore", null);
            struct.addBitField(DWORD, 12, "reserved", null);
            struct.addBitField(DWORD, 16, "type", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(DWORD, "length", null);
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

