/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.tracermi;

import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.tracermi.RemoteAsyncResult;
import ghidra.debug.api.tracermi.RemoteParameter;
import ghidra.debug.api.tracermi.TraceRmiError;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;

public interface RemoteMethod {
    public String name();

    public ActionName action();

    public String display();

    public Icon icon();

    public String okText();

    public String description();

    public Map<String, RemoteParameter> parameters();

    public TraceObjectSchema.SchemaName retType();

    public static void checkType(String paramName, TraceObjectSchema.SchemaName schName, TraceObjectSchema sch, Object arg) {
        TraceObject obj;
        if (sch != null && (sch.getType() != TraceObject.class ? sch.getType().isInstance(arg) : arg instanceof TraceObject && sch.isAssignableFrom((obj = (TraceObject)arg).getSchema()))) {
            return;
        }
        throw new IllegalArgumentException("For parameter %s: argument %s is not a %s".formatted(paramName, arg, schName));
    }

    default public Trace validate(Map<String, Object> arguments) {
        Trace trace = null;
        SchemaContext ctx = PrimitiveTraceObjectSchema.MinimalSchemaContext.INSTANCE;
        for (Map.Entry<String, RemoteParameter> entry : this.parameters().entrySet()) {
            if (!arguments.containsKey(entry.getKey())) {
                if (!entry.getValue().required()) continue;
                throw new IllegalArgumentException("Missing required parameter '" + entry.getKey() + "'");
            }
            Object arg = arguments.get(entry.getKey());
            if (arg instanceof TraceObject) {
                TraceObject obj = (TraceObject)arg;
                if (trace == null) {
                    trace = obj.getTrace();
                    ctx = trace.getObjectManager().getRootSchema().getContext();
                } else if (trace != obj.getTrace()) {
                    throw new IllegalArgumentException("All TraceObject parameters must come from the same trace");
                }
            }
            TraceObjectSchema.SchemaName schName = entry.getValue().type();
            TraceObjectSchema sch = ctx.getSchemaOrNull(schName);
            RemoteMethod.checkType(entry.getKey(), schName, sch, arg);
        }
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            if (this.parameters().containsKey(entry.getKey())) continue;
            throw new IllegalArgumentException("Extra argument '" + entry.getKey() + "'");
        }
        return trace;
    }

    public RemoteAsyncResult invokeAsync(Map<String, Object> var1);

    default public Object invoke(Map<String, Object> arguments) {
        try {
            return this.invokeAsync(arguments).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new TraceRmiError(e);
        }
    }
}

