/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import java.awt.Toolkit;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class BoundedRangeInputVerifier
extends InputVerifier {
    private final JFormattedTextField otherField;
    private final boolean isOtherFieldUpperRange;
    private final Number upperRangeValue;
    private final Number lowerRangeValue;

    public BoundedRangeInputVerifier(JFormattedTextField otherField, boolean isOtherFieldUpperRange, Number upperRangeValue, Number lowerRangeValue) {
        this.otherField = otherField;
        this.isOtherFieldUpperRange = isOtherFieldUpperRange;
        this.upperRangeValue = upperRangeValue;
        this.lowerRangeValue = lowerRangeValue;
    }

    @Override
    public boolean verify(JComponent input) {
        if (!(input instanceof JFormattedTextField)) {
            return true;
        }
        JFormattedTextField ftf = (JFormattedTextField)input;
        JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
        if (formatter == null) {
            return true;
        }
        String text = ftf.getText();
        try {
            Number number = (Number)formatter.stringToValue(text);
            if (this.compareNumbers(number, this.upperRangeValue) > 0 || this.compareNumbers(number, this.lowerRangeValue) < 0) {
                return false;
            }
            boolean result = false;
            Number otherNumber = (Number)this.otherField.getValue();
            result = this.isOtherFieldUpperRange ? this.compareNumbers(number, otherNumber) <= 0 : this.compareNumbers(number, otherNumber) >= 0;
            return result;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private int compareNumbers(Number number, Number otherNumber) {
        if (number instanceof Double) {
            Double double1 = (Double)number;
            Double double2 = (Double)otherNumber;
            return double1.compareTo(double2);
        }
        if (number instanceof Long) {
            Long long1 = (Long)number;
            Long long2 = (Long)otherNumber;
            return long1.compareTo(long2);
        }
        if (number instanceof Integer) {
            Long long1 = number.longValue();
            Long long2 = otherNumber.longValue();
            return long1.compareTo(long2);
        }
        return 0;
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        boolean shouldYieldFocus = super.shouldYieldFocus(input);
        if (!shouldYieldFocus) {
            this.warn();
        }
        return shouldYieldFocus;
    }

    private void warn() {
        Toolkit.getDefaultToolkit().beep();
    }
}

